<?php
if (session_id() == "") session_start(); // Init session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg14.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql14.php") ?>
<?php include_once "phpfn14.php" ?>
<?php include_once "kontrakinfo.php" ?>
<?php include_once "employeesinfo.php" ?>
<?php include_once "userfn14.php" ?>
<?php

//
// Page class
//

$kontrak_delete = NULL; // Initialize page object first

class ckontrak_delete extends ckontrak {

	// Page ID
	var $PageID = 'delete';

	// Project ID
	var $ProjectID = '{CC60B42B-604B-412A-B014-2315920AF6AA}';

	// Table name
	var $TableName = 'kontrak';

	// Page object name
	var $PageObjName = 'kontrak_delete';

	// Page headings
	var $Heading = '';
	var $Subheading = '';

	// Page heading
	function PageHeading() {
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->TableCaption();
		return "";
	}

	// Page subheading
	function PageSubheading() {
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->Phrase($this->PageID);
		return "";
	}

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (kontrak)
		if (!isset($GLOBALS["kontrak"]) || get_class($GLOBALS["kontrak"]) == "ckontrak") {
			$GLOBALS["kontrak"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["kontrak"];
		}

		// Table object (employees)
		if (!isset($GLOBALS['employees'])) $GLOBALS['employees'] = new cemployees();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'delete', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'kontrak', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"]))
			$GLOBALS["gTimer"] = new cTimer();

		// Debug message
		ew_LoadDebugMsg();

		// Open connection
		if (!isset($conn))
			$conn = ew_Connect($this->DBID);

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new cemployees();
			$UserTableConn = Conn($UserTable->DBID);
		}
	}

	//
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// User profile
		$UserProfile = new cUserProfile();

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanDelete()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			if ($Security->CanList())
				$this->Page_Terminate(ew_GetUrl("kontraklist.php"));
			else
				$this->Page_Terminate(ew_GetUrl("login.php"));
		}

		// NOTE: Security object may be needed in other part of the script, skip set to Nothing
		// 
		// Security = null;
		// 

		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action
		$this->k_id_kontrak->SetVisibility();
		$this->k_luas_lahan->SetVisibility();
		$this->pet_id->SetVisibility();
		$this->koord_id->SetVisibility();
		$this->kk_id->SetVisibility();
		$this->prov_id->SetVisibility();
		$this->kab_id->SetVisibility();
		$this->kec_id->SetVisibility();
		$this->desa_id->SetVisibility();
		$this->blok_id->SetVisibility();
		$this->sos_id->SetVisibility();
		$this->var_id->SetVisibility();
		$this->co_id->SetVisibility();
		$this->k_jumlah_bibit->SetVisibility();
		$this->k_asal_bibit->SetVisibility();
		$this->k_tgl_tanam->SetVisibility();
		$this->k_es_tgl_panen->SetVisibility();
		$this->k_ak_tgl_datang->SetVisibility();
		$this->k_es_qty->SetVisibility();
		$this->k_ak_qty->SetVisibility();
		$this->k_es_perhektar->SetVisibility();
		$this->k_ak_perhektar->SetVisibility();
		$this->k_skor->SetVisibility();
		$this->k_ket->SetVisibility();
		$this->k_cat->SetVisibility();
		$this->k_titik_koordinat->SetVisibility();
		$this->k_foto_lahan->SetVisibility();
		$this->k_dok->SetVisibility();
		$this->k_harga_bibit->SetVisibility();
		$this->k_bayar_bibit->SetVisibility();
		$this->k_pinjaman->SetVisibility();
		$this->k_bayar_pinjaman->SetVisibility();
		$this->k_sisa_hutang->SetVisibility();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Create Token
		$this->CreateToken();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $kontrak;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($kontrak);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		// Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			ew_SaveDebugMsg();
			header("Location: " . $url);
		}
		exit();
	}
	var $DbMasterFilter = "";
	var $DbDetailFilter = "";
	var $StartRec;
	var $TotalRecs = 0;
	var $RecCnt;
	var $RecKeys = array();
	var $Recordset;
	var $StartRowCnt = 1;
	var $RowCnt = 0;

	//
	// Page main
	//
	function Page_Main() {
		global $Language;

		// Set up Breadcrumb
		$this->SetupBreadcrumb();

		// Load key parameters
		$this->RecKeys = $this->GetRecordKeys(); // Load record keys
		$sFilter = $this->GetKeyFilter();
		if ($sFilter == "")
			$this->Page_Terminate("kontraklist.php"); // Prevent SQL injection, return to list

		// Set up filter (SQL WHHERE clause) and get return SQL
		// SQL constructor in kontrak class, kontrakinfo.php

		$this->CurrentFilter = $sFilter;

		// Get action
		if (@$_POST["a_delete"] <> "") {
			$this->CurrentAction = $_POST["a_delete"];
		} elseif (@$_GET["a_delete"] == "1") {
			$this->CurrentAction = "D"; // Delete record directly
		} else {
			$this->CurrentAction = "I"; // Display record
		}
		if ($this->CurrentAction == "D") {
			$this->SendEmail = TRUE; // Send email on delete success
			if ($this->DeleteRows()) { // Delete rows
				if ($this->getSuccessMessage() == "")
					$this->setSuccessMessage($Language->Phrase("DeleteSuccess")); // Set up success message
				$this->Page_Terminate($this->getReturnUrl()); // Return to caller
			} else { // Delete failed
				$this->CurrentAction = "I"; // Display record
			}
		}
		if ($this->CurrentAction == "I") { // Load records for display
			if ($this->Recordset = $this->LoadRecordset())
				$this->TotalRecs = $this->Recordset->RecordCount(); // Get record count
			if ($this->TotalRecs <= 0) { // No record found, exit
				if ($this->Recordset)
					$this->Recordset->Close();
				$this->Page_Terminate("kontraklist.php"); // Return to list
			}
		}
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {

		// Load List page SQL
		$sSql = $this->ListSQL();
		$conn = &$this->Connection();

		// Load recordset
		$dbtype = ew_GetConnectionType($this->DBID);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset, array("_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderByList())));
			} else {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = ew_LoadRecordset($sSql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues($rs = NULL) {
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->NewRow(); 

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->k_id->setDbValue($row['k_id']);
		$this->k_id_kontrak->setDbValue($row['k_id_kontrak']);
		$this->k_id_lama->setDbValue($row['k_id_lama']);
		$this->k_no_kontrak->setDbValue($row['k_no_kontrak']);
		$this->k_luas_lahan->setDbValue($row['k_luas_lahan']);
		$this->pet_id->setDbValue($row['pet_id']);
		if (array_key_exists('EV__pet_id', $rs->fields)) {
			$this->pet_id->VirtualValue = $rs->fields('EV__pet_id'); // Set up virtual field value
		} else {
			$this->pet_id->VirtualValue = ""; // Clear value
		}
		$this->koord_id->setDbValue($row['koord_id']);
		if (array_key_exists('EV__koord_id', $rs->fields)) {
			$this->koord_id->VirtualValue = $rs->fields('EV__koord_id'); // Set up virtual field value
		} else {
			$this->koord_id->VirtualValue = ""; // Clear value
		}
		$this->kk_id->setDbValue($row['kk_id']);
		$this->prov_id->setDbValue($row['prov_id']);
		if (array_key_exists('EV__prov_id', $rs->fields)) {
			$this->prov_id->VirtualValue = $rs->fields('EV__prov_id'); // Set up virtual field value
		} else {
			$this->prov_id->VirtualValue = ""; // Clear value
		}
		$this->kab_id->setDbValue($row['kab_id']);
		if (array_key_exists('EV__kab_id', $rs->fields)) {
			$this->kab_id->VirtualValue = $rs->fields('EV__kab_id'); // Set up virtual field value
		} else {
			$this->kab_id->VirtualValue = ""; // Clear value
		}
		$this->kec_id->setDbValue($row['kec_id']);
		if (array_key_exists('EV__kec_id', $rs->fields)) {
			$this->kec_id->VirtualValue = $rs->fields('EV__kec_id'); // Set up virtual field value
		} else {
			$this->kec_id->VirtualValue = ""; // Clear value
		}
		$this->desa_id->setDbValue($row['desa_id']);
		if (array_key_exists('EV__desa_id', $rs->fields)) {
			$this->desa_id->VirtualValue = $rs->fields('EV__desa_id'); // Set up virtual field value
		} else {
			$this->desa_id->VirtualValue = ""; // Clear value
		}
		$this->blok_id->setDbValue($row['blok_id']);
		if (array_key_exists('EV__blok_id', $rs->fields)) {
			$this->blok_id->VirtualValue = $rs->fields('EV__blok_id'); // Set up virtual field value
		} else {
			$this->blok_id->VirtualValue = ""; // Clear value
		}
		$this->sos_id->setDbValue($row['sos_id']);
		if (array_key_exists('EV__sos_id', $rs->fields)) {
			$this->sos_id->VirtualValue = $rs->fields('EV__sos_id'); // Set up virtual field value
		} else {
			$this->sos_id->VirtualValue = ""; // Clear value
		}
		$this->var_id->setDbValue($row['var_id']);
		$this->co_id->setDbValue($row['co_id']);
		$this->k_jumlah_bibit->setDbValue($row['k_jumlah_bibit']);
		$this->k_asal_bibit->setDbValue($row['k_asal_bibit']);
		$this->k_tgl_tanam->setDbValue($row['k_tgl_tanam']);
		$this->k_es_tgl_panen->setDbValue($row['k_es_tgl_panen']);
		$this->k_ak_tgl_datang->setDbValue($row['k_ak_tgl_datang']);
		$this->k_es_qty->setDbValue($row['k_es_qty']);
		$this->k_ak_qty->setDbValue($row['k_ak_qty']);
		$this->k_es_perhektar->setDbValue($row['k_es_perhektar']);
		$this->k_ak_perhektar->setDbValue($row['k_ak_perhektar']);
		$this->k_skor->setDbValue($row['k_skor']);
		$this->k_ket->setDbValue($row['k_ket']);
		$this->k_cat->setDbValue($row['k_cat']);
		$this->k_titik_koordinat->setDbValue($row['k_titik_koordinat']);
		$this->k_foto_lahan->Upload->DbValue = $row['k_foto_lahan'];
		$this->k_foto_lahan->setDbValue($this->k_foto_lahan->Upload->DbValue);
		$this->k_dok->Upload->DbValue = $row['k_dok'];
		$this->k_dok->setDbValue($this->k_dok->Upload->DbValue);
		$this->k_harga_bibit->setDbValue($row['k_harga_bibit']);
		$this->k_bayar_bibit->setDbValue($row['k_bayar_bibit']);
		$this->k_pinjaman->setDbValue($row['k_pinjaman']);
		$this->k_bayar_pinjaman->setDbValue($row['k_bayar_pinjaman']);
		$this->k_sisa_hutang->setDbValue($row['k_sisa_hutang']);
	}

	// Return a row with default values
	function NewRow() {
		$row = array();
		$row['k_id'] = NULL;
		$row['k_id_kontrak'] = NULL;
		$row['k_id_lama'] = NULL;
		$row['k_no_kontrak'] = NULL;
		$row['k_luas_lahan'] = NULL;
		$row['pet_id'] = NULL;
		$row['koord_id'] = NULL;
		$row['kk_id'] = NULL;
		$row['prov_id'] = NULL;
		$row['kab_id'] = NULL;
		$row['kec_id'] = NULL;
		$row['desa_id'] = NULL;
		$row['blok_id'] = NULL;
		$row['sos_id'] = NULL;
		$row['var_id'] = NULL;
		$row['co_id'] = NULL;
		$row['k_jumlah_bibit'] = NULL;
		$row['k_asal_bibit'] = NULL;
		$row['k_tgl_tanam'] = NULL;
		$row['k_es_tgl_panen'] = NULL;
		$row['k_ak_tgl_datang'] = NULL;
		$row['k_es_qty'] = NULL;
		$row['k_ak_qty'] = NULL;
		$row['k_es_perhektar'] = NULL;
		$row['k_ak_perhektar'] = NULL;
		$row['k_skor'] = NULL;
		$row['k_ket'] = NULL;
		$row['k_cat'] = NULL;
		$row['k_titik_koordinat'] = NULL;
		$row['k_foto_lahan'] = NULL;
		$row['k_dok'] = NULL;
		$row['k_harga_bibit'] = NULL;
		$row['k_bayar_bibit'] = NULL;
		$row['k_pinjaman'] = NULL;
		$row['k_bayar_pinjaman'] = NULL;
		$row['k_sisa_hutang'] = NULL;
		return $row;
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->k_id->DbValue = $row['k_id'];
		$this->k_id_kontrak->DbValue = $row['k_id_kontrak'];
		$this->k_id_lama->DbValue = $row['k_id_lama'];
		$this->k_no_kontrak->DbValue = $row['k_no_kontrak'];
		$this->k_luas_lahan->DbValue = $row['k_luas_lahan'];
		$this->pet_id->DbValue = $row['pet_id'];
		$this->koord_id->DbValue = $row['koord_id'];
		$this->kk_id->DbValue = $row['kk_id'];
		$this->prov_id->DbValue = $row['prov_id'];
		$this->kab_id->DbValue = $row['kab_id'];
		$this->kec_id->DbValue = $row['kec_id'];
		$this->desa_id->DbValue = $row['desa_id'];
		$this->blok_id->DbValue = $row['blok_id'];
		$this->sos_id->DbValue = $row['sos_id'];
		$this->var_id->DbValue = $row['var_id'];
		$this->co_id->DbValue = $row['co_id'];
		$this->k_jumlah_bibit->DbValue = $row['k_jumlah_bibit'];
		$this->k_asal_bibit->DbValue = $row['k_asal_bibit'];
		$this->k_tgl_tanam->DbValue = $row['k_tgl_tanam'];
		$this->k_es_tgl_panen->DbValue = $row['k_es_tgl_panen'];
		$this->k_ak_tgl_datang->DbValue = $row['k_ak_tgl_datang'];
		$this->k_es_qty->DbValue = $row['k_es_qty'];
		$this->k_ak_qty->DbValue = $row['k_ak_qty'];
		$this->k_es_perhektar->DbValue = $row['k_es_perhektar'];
		$this->k_ak_perhektar->DbValue = $row['k_ak_perhektar'];
		$this->k_skor->DbValue = $row['k_skor'];
		$this->k_ket->DbValue = $row['k_ket'];
		$this->k_cat->DbValue = $row['k_cat'];
		$this->k_titik_koordinat->DbValue = $row['k_titik_koordinat'];
		$this->k_foto_lahan->Upload->DbValue = $row['k_foto_lahan'];
		$this->k_dok->Upload->DbValue = $row['k_dok'];
		$this->k_harga_bibit->DbValue = $row['k_harga_bibit'];
		$this->k_bayar_bibit->DbValue = $row['k_bayar_bibit'];
		$this->k_pinjaman->DbValue = $row['k_pinjaman'];
		$this->k_bayar_pinjaman->DbValue = $row['k_bayar_pinjaman'];
		$this->k_sisa_hutang->DbValue = $row['k_sisa_hutang'];
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->k_ak_perhektar->FormValue == $this->k_ak_perhektar->CurrentValue && is_numeric(ew_StrToFloat($this->k_ak_perhektar->CurrentValue)))
			$this->k_ak_perhektar->CurrentValue = ew_StrToFloat($this->k_ak_perhektar->CurrentValue);

		// Convert decimal values if posted back
		if ($this->k_skor->FormValue == $this->k_skor->CurrentValue && is_numeric(ew_StrToFloat($this->k_skor->CurrentValue)))
			$this->k_skor->CurrentValue = ew_StrToFloat($this->k_skor->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// k_id

		$this->k_id->CellCssStyle = "white-space: nowrap;";

		// k_id_kontrak
		// k_id_lama

		$this->k_id_lama->CellCssStyle = "white-space: nowrap;";

		// k_no_kontrak
		$this->k_no_kontrak->CellCssStyle = "white-space: nowrap;";

		// k_luas_lahan
		// pet_id
		// koord_id
		// kk_id
		// prov_id
		// kab_id
		// kec_id
		// desa_id
		// blok_id
		// sos_id
		// var_id
		// co_id
		// k_jumlah_bibit
		// k_asal_bibit
		// k_tgl_tanam
		// k_es_tgl_panen
		// k_ak_tgl_datang
		// k_es_qty
		// k_ak_qty
		// k_es_perhektar
		// k_ak_perhektar
		// k_skor
		// k_ket
		// k_cat
		// k_titik_koordinat
		// k_foto_lahan
		// k_dok
		// k_harga_bibit
		// k_bayar_bibit
		// k_pinjaman
		// k_bayar_pinjaman
		// k_sisa_hutang

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// k_id
		$this->k_id->ViewValue = $this->k_id->CurrentValue;
		$this->k_id->ViewCustomAttributes = "";

		// k_id_kontrak
		$this->k_id_kontrak->ViewValue = $this->k_id_kontrak->CurrentValue;
		$this->k_id_kontrak->ViewCustomAttributes = "";

		// k_luas_lahan
		$this->k_luas_lahan->ViewValue = $this->k_luas_lahan->CurrentValue;
		$this->k_luas_lahan->ViewCustomAttributes = "";

		// pet_id
		if ($this->pet_id->VirtualValue <> "") {
			$this->pet_id->ViewValue = $this->pet_id->VirtualValue;
		} else {
			$this->pet_id->ViewValue = $this->pet_id->CurrentValue;
		if (strval($this->pet_id->CurrentValue) <> "") {
			$sFilterWrk = "`pet_id`" . ew_SearchString("=", $this->pet_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `pet_id`, `pet_nama` AS `DispFld`, `pet_alamat` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `petani`";
		$sWhereWrk = "";
		$this->pet_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->pet_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `pet_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = $rswrk->fields('Disp2Fld');
				$this->pet_id->ViewValue = $this->pet_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->pet_id->ViewValue = $this->pet_id->CurrentValue;
			}
		} else {
			$this->pet_id->ViewValue = NULL;
		}
		}
		$this->pet_id->ViewCustomAttributes = "";

		// koord_id
		if ($this->koord_id->VirtualValue <> "") {
			$this->koord_id->ViewValue = $this->koord_id->VirtualValue;
		} else {
			$this->koord_id->ViewValue = $this->koord_id->CurrentValue;
		if (strval($this->koord_id->CurrentValue) <> "") {
			$sFilterWrk = "`koord_id`" . ew_SearchString("=", $this->koord_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `koord_id`, `koord_nama` AS `DispFld`, `koord_alamat` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `koord`";
		$sWhereWrk = "";
		$this->koord_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->koord_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `koord_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = $rswrk->fields('Disp2Fld');
				$this->koord_id->ViewValue = $this->koord_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->koord_id->ViewValue = $this->koord_id->CurrentValue;
			}
		} else {
			$this->koord_id->ViewValue = NULL;
		}
		}
		$this->koord_id->ViewCustomAttributes = "";

		// kk_id
		if (strval($this->kk_id->CurrentValue) <> "") {
			$sFilterWrk = "`kk_id`" . ew_SearchString("=", $this->kk_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `kk_id`, `kk_periode` AS `DispFld`, `kk_tgl_mulai` AS `Disp2Fld`, `kk_tgl_akhir` AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kontrak_koord`";
		$sWhereWrk = "";
		$this->kk_id->LookupFilters = array("df2" => "5", "df3" => "5");
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->kk_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = ew_FormatDateTime($rswrk->fields('Disp2Fld'), 5);
				$arwrk[3] = ew_FormatDateTime($rswrk->fields('Disp3Fld'), 5);
				$this->kk_id->ViewValue = $this->kk_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->kk_id->ViewValue = $this->kk_id->CurrentValue;
			}
		} else {
			$this->kk_id->ViewValue = NULL;
		}
		$this->kk_id->ViewCustomAttributes = "";

		// prov_id
		if ($this->prov_id->VirtualValue <> "") {
			$this->prov_id->ViewValue = $this->prov_id->VirtualValue;
		} else {
		if (strval($this->prov_id->CurrentValue) <> "") {
			$sFilterWrk = "`prov_id`" . ew_SearchString("=", $this->prov_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `prov_id`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `prov`";
		$sWhereWrk = "";
		$this->prov_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->prov_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `prov_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->prov_id->ViewValue = $this->prov_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->prov_id->ViewValue = $this->prov_id->CurrentValue;
			}
		} else {
			$this->prov_id->ViewValue = NULL;
		}
		}
		$this->prov_id->ViewCustomAttributes = "";

		// kab_id
		if ($this->kab_id->VirtualValue <> "") {
			$this->kab_id->ViewValue = $this->kab_id->VirtualValue;
		} else {
		if (strval($this->kab_id->CurrentValue) <> "") {
			$sFilterWrk = "`kab_id`" . ew_SearchString("=", $this->kab_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `kab_id`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kab`";
		$sWhereWrk = "";
		$this->kab_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->kab_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `kab_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->kab_id->ViewValue = $this->kab_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->kab_id->ViewValue = $this->kab_id->CurrentValue;
			}
		} else {
			$this->kab_id->ViewValue = NULL;
		}
		}
		$this->kab_id->ViewCustomAttributes = "";

		// kec_id
		if ($this->kec_id->VirtualValue <> "") {
			$this->kec_id->ViewValue = $this->kec_id->VirtualValue;
		} else {
		if (strval($this->kec_id->CurrentValue) <> "") {
			$sFilterWrk = "`kec_id`" . ew_SearchString("=", $this->kec_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `kec_id`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kec`";
		$sWhereWrk = "";
		$this->kec_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->kec_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `kec_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->kec_id->ViewValue = $this->kec_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->kec_id->ViewValue = $this->kec_id->CurrentValue;
			}
		} else {
			$this->kec_id->ViewValue = NULL;
		}
		}
		$this->kec_id->ViewCustomAttributes = "";

		// desa_id
		if ($this->desa_id->VirtualValue <> "") {
			$this->desa_id->ViewValue = $this->desa_id->VirtualValue;
		} else {
		if (strval($this->desa_id->CurrentValue) <> "") {
			$sFilterWrk = "`desa_id`" . ew_SearchString("=", $this->desa_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `desa_id`, `desa_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `desa`";
		$sWhereWrk = "";
		$this->desa_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->desa_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `desa_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->desa_id->ViewValue = $this->desa_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->desa_id->ViewValue = $this->desa_id->CurrentValue;
			}
		} else {
			$this->desa_id->ViewValue = NULL;
		}
		}
		$this->desa_id->ViewCustomAttributes = "";

		// blok_id
		if ($this->blok_id->VirtualValue <> "") {
			$this->blok_id->ViewValue = $this->blok_id->VirtualValue;
		} else {
			$this->blok_id->ViewValue = $this->blok_id->CurrentValue;
		if (strval($this->blok_id->CurrentValue) <> "") {
			$sFilterWrk = "`blok_id`" . ew_SearchString("=", $this->blok_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `blok_id`, `blok_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `blok`";
		$sWhereWrk = "";
		$this->blok_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->blok_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `blok_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->blok_id->ViewValue = $this->blok_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->blok_id->ViewValue = $this->blok_id->CurrentValue;
			}
		} else {
			$this->blok_id->ViewValue = NULL;
		}
		}
		$this->blok_id->ViewCustomAttributes = "";

		// sos_id
		if ($this->sos_id->VirtualValue <> "") {
			$this->sos_id->ViewValue = $this->sos_id->VirtualValue;
		} else {
		if (strval($this->sos_id->CurrentValue) <> "") {
			$sFilterWrk = "`sos_id`" . ew_SearchString("=", $this->sos_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `sos_id`, `sos_id` AS `DispFld`, `sos_tgl` AS `Disp2Fld`, `sos_alamat` AS `Disp3Fld`, '' AS `Disp4Fld` FROM `sosialisasi`";
		$sWhereWrk = "";
		$this->sos_id->LookupFilters = array("df2" => "0");
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->sos_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `sos_tgl` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = ew_FormatDateTime($rswrk->fields('Disp2Fld'), 0);
				$arwrk[3] = $rswrk->fields('Disp3Fld');
				$this->sos_id->ViewValue = $this->sos_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->sos_id->ViewValue = $this->sos_id->CurrentValue;
			}
		} else {
			$this->sos_id->ViewValue = NULL;
		}
		}
		$this->sos_id->ViewCustomAttributes = "";

		// var_id
		if (strval($this->var_id->CurrentValue) <> "") {
			$sFilterWrk = "`var_id`" . ew_SearchString("=", $this->var_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `var_id`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `varietas`";
		$sWhereWrk = "";
		$this->var_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->var_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `var_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->var_id->ViewValue = $this->var_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->var_id->ViewValue = $this->var_id->CurrentValue;
			}
		} else {
			$this->var_id->ViewValue = NULL;
		}
		$this->var_id->ViewCustomAttributes = "";

		// co_id
		if (strval($this->co_id->CurrentValue) <> "") {
			$sFilterWrk = "`co_id`" . ew_SearchString("=", $this->co_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `co_id`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `co`";
		$sWhereWrk = "";
		$this->co_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->co_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `co_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->co_id->ViewValue = $this->co_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->co_id->ViewValue = $this->co_id->CurrentValue;
			}
		} else {
			$this->co_id->ViewValue = NULL;
		}
		$this->co_id->ViewCustomAttributes = "";

		// k_jumlah_bibit
		$this->k_jumlah_bibit->ViewValue = $this->k_jumlah_bibit->CurrentValue;
		$this->k_jumlah_bibit->ViewCustomAttributes = "";

		// k_asal_bibit
		$this->k_asal_bibit->ViewValue = $this->k_asal_bibit->CurrentValue;
		$this->k_asal_bibit->ViewCustomAttributes = "";

		// k_tgl_tanam
		$this->k_tgl_tanam->ViewValue = $this->k_tgl_tanam->CurrentValue;
		$this->k_tgl_tanam->ViewValue = ew_FormatDateTime($this->k_tgl_tanam->ViewValue, 5);
		$this->k_tgl_tanam->ViewCustomAttributes = "";

		// k_es_tgl_panen
		$this->k_es_tgl_panen->ViewValue = $this->k_es_tgl_panen->CurrentValue;
		$this->k_es_tgl_panen->ViewValue = ew_FormatDateTime($this->k_es_tgl_panen->ViewValue, 5);
		$this->k_es_tgl_panen->ViewCustomAttributes = "";

		// k_ak_tgl_datang
		$this->k_ak_tgl_datang->ViewValue = $this->k_ak_tgl_datang->CurrentValue;
		$this->k_ak_tgl_datang->ViewValue = ew_FormatDateTime($this->k_ak_tgl_datang->ViewValue, 5);
		$this->k_ak_tgl_datang->ViewCustomAttributes = "";

		// k_es_qty
		$this->k_es_qty->ViewValue = $this->k_es_qty->CurrentValue;
		$this->k_es_qty->ViewCustomAttributes = "";

		// k_ak_qty
		$this->k_ak_qty->ViewValue = $this->k_ak_qty->CurrentValue;
		$this->k_ak_qty->ViewCustomAttributes = "";

		// k_es_perhektar
		$this->k_es_perhektar->ViewValue = $this->k_es_perhektar->CurrentValue;
		$this->k_es_perhektar->ViewCustomAttributes = "";

		// k_ak_perhektar
		$this->k_ak_perhektar->ViewValue = $this->k_ak_perhektar->CurrentValue;
		$this->k_ak_perhektar->ViewCustomAttributes = "";

		// k_skor
		$this->k_skor->ViewValue = $this->k_skor->CurrentValue;
		$this->k_skor->ViewCustomAttributes = "";

		// k_ket
		$this->k_ket->ViewValue = $this->k_ket->CurrentValue;
		$this->k_ket->ViewCustomAttributes = "";

		// k_cat
		$this->k_cat->ViewValue = $this->k_cat->CurrentValue;
		$this->k_cat->ViewCustomAttributes = "";

		// k_titik_koordinat
		$this->k_titik_koordinat->ViewValue = $this->k_titik_koordinat->CurrentValue;
		$this->k_titik_koordinat->CellCssStyle .= "text-align: left;";
		$this->k_titik_koordinat->ViewCustomAttributes = "";

		// k_foto_lahan
		$this->k_foto_lahan->UploadPath = "foto_lahan";
		if (!ew_Empty($this->k_foto_lahan->Upload->DbValue)) {
			$this->k_foto_lahan->ImageWidth = 40;
			$this->k_foto_lahan->ImageHeight = 30;
			$this->k_foto_lahan->ImageAlt = $this->k_foto_lahan->FldAlt();
			$this->k_foto_lahan->ViewValue = $this->k_foto_lahan->Upload->DbValue;
		} else {
			$this->k_foto_lahan->ViewValue = "";
		}
		$this->k_foto_lahan->CellCssStyle .= "text-align: left;";
		$this->k_foto_lahan->ViewCustomAttributes = "";

		// k_dok
		$this->k_dok->UploadPath = "dokumen_kontrak_lahan";
		if (!ew_Empty($this->k_dok->Upload->DbValue)) {
			$this->k_dok->ImageWidth = 42;
			$this->k_dok->ImageHeight = 70;
			$this->k_dok->ImageAlt = $this->k_dok->FldAlt();
			$this->k_dok->ViewValue = $this->k_dok->Upload->DbValue;
		} else {
			$this->k_dok->ViewValue = "";
		}
		$this->k_dok->ViewCustomAttributes = "";

		// k_harga_bibit
		$this->k_harga_bibit->ViewValue = $this->k_harga_bibit->CurrentValue;
		$this->k_harga_bibit->ViewCustomAttributes = "";

		// k_bayar_bibit
		$this->k_bayar_bibit->ViewValue = $this->k_bayar_bibit->CurrentValue;
		$this->k_bayar_bibit->ViewCustomAttributes = "";

		// k_pinjaman
		$this->k_pinjaman->ViewValue = $this->k_pinjaman->CurrentValue;
		$this->k_pinjaman->ViewCustomAttributes = "";

		// k_bayar_pinjaman
		$this->k_bayar_pinjaman->ViewValue = $this->k_bayar_pinjaman->CurrentValue;
		$this->k_bayar_pinjaman->ViewCustomAttributes = "";

		// k_sisa_hutang
		$this->k_sisa_hutang->ViewValue = $this->k_sisa_hutang->CurrentValue;
		$this->k_sisa_hutang->ViewCustomAttributes = "";

			// k_id_kontrak
			$this->k_id_kontrak->LinkCustomAttributes = "";
			$this->k_id_kontrak->HrefValue = "";
			$this->k_id_kontrak->TooltipValue = "";

			// k_luas_lahan
			$this->k_luas_lahan->LinkCustomAttributes = "";
			$this->k_luas_lahan->HrefValue = "";
			$this->k_luas_lahan->TooltipValue = "";

			// pet_id
			$this->pet_id->LinkCustomAttributes = "";
			if (!ew_Empty($this->pet_id->CurrentValue)) {
				$this->pet_id->HrefValue = "petaniview.php?showdetail=&pet_id=" . $this->pet_id->CurrentValue; // Add prefix/suffix
				$this->pet_id->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->pet_id->HrefValue = ew_FullUrl($this->pet_id->HrefValue, "href");
			} else {
				$this->pet_id->HrefValue = "";
			}
			$this->pet_id->TooltipValue = "";

			// koord_id
			$this->koord_id->LinkCustomAttributes = "";
			if (!ew_Empty($this->koord_id->CurrentValue)) {
				$this->koord_id->HrefValue = "koordview.php?showdetail=&koord_id=" . $this->koord_id->CurrentValue; // Add prefix/suffix
				$this->koord_id->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->koord_id->HrefValue = ew_FullUrl($this->koord_id->HrefValue, "href");
			} else {
				$this->koord_id->HrefValue = "";
			}
			$this->koord_id->TooltipValue = "";

			// kk_id
			$this->kk_id->LinkCustomAttributes = "";
			if (!ew_Empty($this->kk_id->CurrentValue)) {
				$this->kk_id->HrefValue = "kontrak_koordview.php?showdetail=&kk_id=" . $this->kk_id->CurrentValue; // Add prefix/suffix
				$this->kk_id->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->kk_id->HrefValue = ew_FullUrl($this->kk_id->HrefValue, "href");
			} else {
				$this->kk_id->HrefValue = "";
			}
			$this->kk_id->TooltipValue = "";

			// prov_id
			$this->prov_id->LinkCustomAttributes = "";
			$this->prov_id->HrefValue = "";
			$this->prov_id->TooltipValue = "";

			// kab_id
			$this->kab_id->LinkCustomAttributes = "";
			$this->kab_id->HrefValue = "";
			$this->kab_id->TooltipValue = "";

			// kec_id
			$this->kec_id->LinkCustomAttributes = "";
			$this->kec_id->HrefValue = "";
			$this->kec_id->TooltipValue = "";

			// desa_id
			$this->desa_id->LinkCustomAttributes = "";
			$this->desa_id->HrefValue = "";
			$this->desa_id->TooltipValue = "";

			// blok_id
			$this->blok_id->LinkCustomAttributes = "";
			$this->blok_id->HrefValue = "";
			$this->blok_id->TooltipValue = "";

			// sos_id
			$this->sos_id->LinkCustomAttributes = "";
			$this->sos_id->HrefValue = "";
			$this->sos_id->TooltipValue = "";

			// var_id
			$this->var_id->LinkCustomAttributes = "";
			if (!ew_Empty($this->var_id->CurrentValue)) {
				$this->var_id->HrefValue = "varietasview.php?showdetail=&var_id=" . $this->var_id->CurrentValue; // Add prefix/suffix
				$this->var_id->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->var_id->HrefValue = ew_FullUrl($this->var_id->HrefValue, "href");
			} else {
				$this->var_id->HrefValue = "";
			}
			$this->var_id->TooltipValue = "";

			// co_id
			$this->co_id->LinkCustomAttributes = "";
			if (!ew_Empty($this->co_id->CurrentValue)) {
				$this->co_id->HrefValue = "coview.php?showdetail=&co_id=" . $this->co_id->CurrentValue; // Add prefix/suffix
				$this->co_id->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->co_id->HrefValue = ew_FullUrl($this->co_id->HrefValue, "href");
			} else {
				$this->co_id->HrefValue = "";
			}
			$this->co_id->TooltipValue = "";

			// k_jumlah_bibit
			$this->k_jumlah_bibit->LinkCustomAttributes = "";
			$this->k_jumlah_bibit->HrefValue = "";
			$this->k_jumlah_bibit->TooltipValue = "";

			// k_asal_bibit
			$this->k_asal_bibit->LinkCustomAttributes = "";
			$this->k_asal_bibit->HrefValue = "";
			$this->k_asal_bibit->TooltipValue = "";

			// k_tgl_tanam
			$this->k_tgl_tanam->LinkCustomAttributes = "";
			$this->k_tgl_tanam->HrefValue = "";
			$this->k_tgl_tanam->TooltipValue = "";

			// k_es_tgl_panen
			$this->k_es_tgl_panen->LinkCustomAttributes = "";
			$this->k_es_tgl_panen->HrefValue = "";
			$this->k_es_tgl_panen->TooltipValue = "";

			// k_ak_tgl_datang
			$this->k_ak_tgl_datang->LinkCustomAttributes = "";
			$this->k_ak_tgl_datang->HrefValue = "";
			$this->k_ak_tgl_datang->TooltipValue = "";

			// k_es_qty
			$this->k_es_qty->LinkCustomAttributes = "";
			$this->k_es_qty->HrefValue = "";
			$this->k_es_qty->TooltipValue = "";

			// k_ak_qty
			$this->k_ak_qty->LinkCustomAttributes = "";
			$this->k_ak_qty->HrefValue = "";
			$this->k_ak_qty->TooltipValue = "";

			// k_es_perhektar
			$this->k_es_perhektar->LinkCustomAttributes = "";
			$this->k_es_perhektar->HrefValue = "";
			$this->k_es_perhektar->TooltipValue = "";

			// k_ak_perhektar
			$this->k_ak_perhektar->LinkCustomAttributes = "";
			$this->k_ak_perhektar->HrefValue = "";
			$this->k_ak_perhektar->TooltipValue = "";

			// k_skor
			$this->k_skor->LinkCustomAttributes = "";
			$this->k_skor->HrefValue = "";
			$this->k_skor->TooltipValue = "";

			// k_ket
			$this->k_ket->LinkCustomAttributes = "";
			$this->k_ket->HrefValue = "";
			$this->k_ket->TooltipValue = "";

			// k_cat
			$this->k_cat->LinkCustomAttributes = "";
			$this->k_cat->HrefValue = "";
			$this->k_cat->TooltipValue = "";

			// k_titik_koordinat
			$this->k_titik_koordinat->LinkCustomAttributes = "";
			if (!ew_Empty($this->k_titik_koordinat->CurrentValue)) {
				$this->k_titik_koordinat->HrefValue = ((!empty($this->k_titik_koordinat->ViewValue) && !is_array($this->k_titik_koordinat->ViewValue)) ? ew_RemoveHtml($this->k_titik_koordinat->ViewValue) : $this->k_titik_koordinat->CurrentValue); // Add prefix/suffix
				$this->k_titik_koordinat->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->k_titik_koordinat->HrefValue = ew_FullUrl($this->k_titik_koordinat->HrefValue, "href");
			} else {
				$this->k_titik_koordinat->HrefValue = "";
			}
			$this->k_titik_koordinat->TooltipValue = "";

			// k_foto_lahan
			$this->k_foto_lahan->LinkCustomAttributes = "";
			$this->k_foto_lahan->UploadPath = "foto_lahan";
			if (!ew_Empty($this->k_foto_lahan->Upload->DbValue)) {
				$this->k_foto_lahan->HrefValue = "%u"; // Add prefix/suffix
				$this->k_foto_lahan->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->k_foto_lahan->HrefValue = ew_FullUrl($this->k_foto_lahan->HrefValue, "href");
			} else {
				$this->k_foto_lahan->HrefValue = "";
			}
			$this->k_foto_lahan->HrefValue2 = $this->k_foto_lahan->UploadPath . $this->k_foto_lahan->Upload->DbValue;
			$this->k_foto_lahan->TooltipValue = "";
			if ($this->k_foto_lahan->UseColorbox) {
				if (ew_Empty($this->k_foto_lahan->TooltipValue))
					$this->k_foto_lahan->LinkAttrs["title"] = $Language->Phrase("ViewImageGallery");
				$this->k_foto_lahan->LinkAttrs["data-rel"] = "kontrak_x_k_foto_lahan";
				ew_AppendClass($this->k_foto_lahan->LinkAttrs["class"], "ewLightbox");
			}

			// k_dok
			$this->k_dok->LinkCustomAttributes = "";
			$this->k_dok->UploadPath = "dokumen_kontrak_lahan";
			if (!ew_Empty($this->k_dok->Upload->DbValue)) {
				$this->k_dok->HrefValue = "%u"; // Add prefix/suffix
				$this->k_dok->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->k_dok->HrefValue = ew_FullUrl($this->k_dok->HrefValue, "href");
			} else {
				$this->k_dok->HrefValue = "";
			}
			$this->k_dok->HrefValue2 = $this->k_dok->UploadPath . $this->k_dok->Upload->DbValue;
			$this->k_dok->TooltipValue = "";
			if ($this->k_dok->UseColorbox) {
				if (ew_Empty($this->k_dok->TooltipValue))
					$this->k_dok->LinkAttrs["title"] = $Language->Phrase("ViewImageGallery");
				$this->k_dok->LinkAttrs["data-rel"] = "kontrak_x_k_dok";
				ew_AppendClass($this->k_dok->LinkAttrs["class"], "ewLightbox");
			}

			// k_harga_bibit
			$this->k_harga_bibit->LinkCustomAttributes = "";
			$this->k_harga_bibit->HrefValue = "";
			$this->k_harga_bibit->TooltipValue = "";

			// k_bayar_bibit
			$this->k_bayar_bibit->LinkCustomAttributes = "";
			$this->k_bayar_bibit->HrefValue = "";
			$this->k_bayar_bibit->TooltipValue = "";

			// k_pinjaman
			$this->k_pinjaman->LinkCustomAttributes = "";
			$this->k_pinjaman->HrefValue = "";
			$this->k_pinjaman->TooltipValue = "";

			// k_bayar_pinjaman
			$this->k_bayar_pinjaman->LinkCustomAttributes = "";
			$this->k_bayar_pinjaman->HrefValue = "";
			$this->k_bayar_pinjaman->TooltipValue = "";

			// k_sisa_hutang
			$this->k_sisa_hutang->LinkCustomAttributes = "";
			$this->k_sisa_hutang->HrefValue = "";
			$this->k_sisa_hutang->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	//
	// Delete records based on current filter
	//
	function DeleteRows() {
		global $Language, $Security;
		if (!$Security->CanDelete()) {
			$this->setFailureMessage($Language->Phrase("NoDeletePermission")); // No delete permission
			return FALSE;
		}
		$DeleteRows = TRUE;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
		$rs = $conn->Execute($sSql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE) {
			return FALSE;
		} elseif ($rs->EOF) {
			$this->setFailureMessage($Language->Phrase("NoRecord")); // No record found
			$rs->Close();
			return FALSE;
		}
		$rows = ($rs) ? $rs->GetRows() : array();
		$conn->BeginTrans();

		// Clone old rows
		$rsold = $rows;
		if ($rs)
			$rs->Close();

		// Call row deleting event
		if ($DeleteRows) {
			foreach ($rsold as $row) {
				$DeleteRows = $this->Row_Deleting($row);
				if (!$DeleteRows) break;
			}
		}
		if ($DeleteRows) {
			$sKey = "";
			foreach ($rsold as $row) {
				$sThisKey = "";
				if ($sThisKey <> "") $sThisKey .= $GLOBALS["EW_COMPOSITE_KEY_SEPARATOR"];
				$sThisKey .= $row['k_id'];

				// Delete old files
				$this->LoadDbValues($row);
				$this->k_foto_lahan->OldUploadPath = "foto_lahan";
				$OldFiles = ew_Empty($row['k_foto_lahan']) ? array() : explode(EW_MULTIPLE_UPLOAD_SEPARATOR, $row['k_foto_lahan']);
				$OldFileCount = count($OldFiles);
				for ($i = 0; $i < $OldFileCount; $i++) {
					if (file_exists($this->k_foto_lahan->OldPhysicalUploadPath() . $OldFiles[$i]))
						@unlink($this->k_foto_lahan->OldPhysicalUploadPath() . $OldFiles[$i]);
				}
				$this->k_dok->OldUploadPath = "dokumen_kontrak_lahan";
				$OldFiles = ew_Empty($row['k_dok']) ? array() : explode(EW_MULTIPLE_UPLOAD_SEPARATOR, $row['k_dok']);
				$OldFileCount = count($OldFiles);
				for ($i = 0; $i < $OldFileCount; $i++) {
					if (file_exists($this->k_dok->OldPhysicalUploadPath() . $OldFiles[$i]))
						@unlink($this->k_dok->OldPhysicalUploadPath() . $OldFiles[$i]);
				}
				$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
				$DeleteRows = $this->Delete($row); // Delete
				$conn->raiseErrorFn = '';
				if ($DeleteRows === FALSE)
					break;
				if ($sKey <> "") $sKey .= ", ";
				$sKey .= $sThisKey;
			}
		}
		if (!$DeleteRows) {

			// Set up error message
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->Phrase("DeleteCancelled"));
			}
		}
		if ($DeleteRows) {
			$conn->CommitTrans(); // Commit the changes
		} else {
			$conn->RollbackTrans(); // Rollback changes
		}

		// Call Row Deleted event
		if ($DeleteRows) {
			foreach ($rsold as $row) {
				$this->Row_Deleted($row);
			}
		}
		return $DeleteRows;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$Breadcrumb->Add("list", $this->TableVar, $this->AddMasterUrl("kontraklist.php"), "", $this->TableVar, TRUE);
		$PageId = "delete";
		$Breadcrumb->Add("delete", $PageId, $url);
	}

	// Setup lookup filters of a field
	function SetupLookupFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		}
	}

	// Setup AutoSuggest filters of a field
	function SetupAutoSuggestFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($kontrak_delete)) $kontrak_delete = new ckontrak_delete();

// Page init
$kontrak_delete->Page_Init();

// Page main
$kontrak_delete->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$kontrak_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "delete";
var CurrentForm = fkontrakdelete = new ew_Form("fkontrakdelete", "delete");

// Form_CustomValidate event
fkontrakdelete.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fkontrakdelete.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fkontrakdelete.Lists["x_pet_id"] = {"LinkField":"x_pet_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_pet_nama","x_pet_alamat","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"petani"};
fkontrakdelete.Lists["x_pet_id"].Data = "<?php echo $kontrak_delete->pet_id->LookupFilterQuery(FALSE, "delete") ?>";
fkontrakdelete.AutoSuggests["x_pet_id"] = <?php echo json_encode(array("data" => "ajax=autosuggest&" . $kontrak_delete->pet_id->LookupFilterQuery(TRUE, "delete"))) ?>;
fkontrakdelete.Lists["x_koord_id"] = {"LinkField":"x_koord_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_koord_nama","x_koord_alamat","",""],"ParentFields":[],"ChildFields":["x_kk_id"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"koord"};
fkontrakdelete.Lists["x_koord_id"].Data = "<?php echo $kontrak_delete->koord_id->LookupFilterQuery(FALSE, "delete") ?>";
fkontrakdelete.AutoSuggests["x_koord_id"] = <?php echo json_encode(array("data" => "ajax=autosuggest&" . $kontrak_delete->koord_id->LookupFilterQuery(TRUE, "delete"))) ?>;
fkontrakdelete.Lists["x_kk_id"] = {"LinkField":"x_kk_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kk_periode","x_kk_tgl_mulai","x_kk_tgl_akhir",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kontrak_koord"};
fkontrakdelete.Lists["x_kk_id"].Data = "<?php echo $kontrak_delete->kk_id->LookupFilterQuery(FALSE, "delete") ?>";
fkontrakdelete.Lists["x_prov_id"] = {"LinkField":"x_prov_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_prov_nama","","",""],"ParentFields":[],"ChildFields":["x_kab_id","x_kec_id","x_desa_id"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"prov"};
fkontrakdelete.Lists["x_prov_id"].Data = "<?php echo $kontrak_delete->prov_id->LookupFilterQuery(FALSE, "delete") ?>";
fkontrakdelete.Lists["x_kab_id"] = {"LinkField":"x_kab_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kab_nama","","",""],"ParentFields":[],"ChildFields":["x_kec_id","x_desa_id"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kab"};
fkontrakdelete.Lists["x_kab_id"].Data = "<?php echo $kontrak_delete->kab_id->LookupFilterQuery(FALSE, "delete") ?>";
fkontrakdelete.Lists["x_kec_id"] = {"LinkField":"x_kec_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kec_nama","","",""],"ParentFields":[],"ChildFields":["x_desa_id"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kec"};
fkontrakdelete.Lists["x_kec_id"].Data = "<?php echo $kontrak_delete->kec_id->LookupFilterQuery(FALSE, "delete") ?>";
fkontrakdelete.Lists["x_desa_id"] = {"LinkField":"x_desa_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_desa_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"desa"};
fkontrakdelete.Lists["x_desa_id"].Data = "<?php echo $kontrak_delete->desa_id->LookupFilterQuery(FALSE, "delete") ?>";
fkontrakdelete.Lists["x_blok_id"] = {"LinkField":"x_blok_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_blok_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"blok"};
fkontrakdelete.Lists["x_blok_id"].Data = "<?php echo $kontrak_delete->blok_id->LookupFilterQuery(FALSE, "delete") ?>";
fkontrakdelete.AutoSuggests["x_blok_id"] = <?php echo json_encode(array("data" => "ajax=autosuggest&" . $kontrak_delete->blok_id->LookupFilterQuery(TRUE, "delete"))) ?>;
fkontrakdelete.Lists["x_sos_id"] = {"LinkField":"x_sos_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_sos_id","x_sos_tgl","x_sos_alamat",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"sosialisasi"};
fkontrakdelete.Lists["x_sos_id"].Data = "<?php echo $kontrak_delete->sos_id->LookupFilterQuery(FALSE, "delete") ?>";
fkontrakdelete.Lists["x_var_id"] = {"LinkField":"x_var_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_var_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"varietas"};
fkontrakdelete.Lists["x_var_id"].Data = "<?php echo $kontrak_delete->var_id->LookupFilterQuery(FALSE, "delete") ?>";
fkontrakdelete.Lists["x_co_id"] = {"LinkField":"x_co_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_co_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"co"};
fkontrakdelete.Lists["x_co_id"].Data = "<?php echo $kontrak_delete->co_id->LookupFilterQuery(FALSE, "delete") ?>";

// Form object for search
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php $kontrak_delete->ShowPageHeader(); ?>
<?php
$kontrak_delete->ShowMessage();
?>
<form name="fkontrakdelete" id="fkontrakdelete" class="form-inline ewForm ewDeleteForm" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($kontrak_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $kontrak_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="kontrak">
<input type="hidden" name="a_delete" id="a_delete" value="D">
<?php foreach ($kontrak_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($EW_COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo ew_HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="box ewBox ewGrid">
<div class="<?php if (ew_IsResponsiveLayout()) { ?>table-responsive <?php } ?>ewGridMiddlePanel">
<table class="table ewTable">
	<thead>
	<tr class="ewTableHeader">
<?php if ($kontrak->k_id_kontrak->Visible) { // k_id_kontrak ?>
		<th class="<?php echo $kontrak->k_id_kontrak->HeaderCellClass() ?>"><span id="elh_kontrak_k_id_kontrak" class="kontrak_k_id_kontrak"><?php echo $kontrak->k_id_kontrak->FldCaption() ?></span></th>
<?php } ?>
<?php if ($kontrak->k_luas_lahan->Visible) { // k_luas_lahan ?>
		<th class="<?php echo $kontrak->k_luas_lahan->HeaderCellClass() ?>"><span id="elh_kontrak_k_luas_lahan" class="kontrak_k_luas_lahan"><?php echo $kontrak->k_luas_lahan->FldCaption() ?></span></th>
<?php } ?>
<?php if ($kontrak->pet_id->Visible) { // pet_id ?>
		<th class="<?php echo $kontrak->pet_id->HeaderCellClass() ?>"><span id="elh_kontrak_pet_id" class="kontrak_pet_id"><?php echo $kontrak->pet_id->FldCaption() ?></span></th>
<?php } ?>
<?php if ($kontrak->koord_id->Visible) { // koord_id ?>
		<th class="<?php echo $kontrak->koord_id->HeaderCellClass() ?>"><span id="elh_kontrak_koord_id" class="kontrak_koord_id"><?php echo $kontrak->koord_id->FldCaption() ?></span></th>
<?php } ?>
<?php if ($kontrak->kk_id->Visible) { // kk_id ?>
		<th class="<?php echo $kontrak->kk_id->HeaderCellClass() ?>"><span id="elh_kontrak_kk_id" class="kontrak_kk_id"><?php echo $kontrak->kk_id->FldCaption() ?></span></th>
<?php } ?>
<?php if ($kontrak->prov_id->Visible) { // prov_id ?>
		<th class="<?php echo $kontrak->prov_id->HeaderCellClass() ?>"><span id="elh_kontrak_prov_id" class="kontrak_prov_id"><?php echo $kontrak->prov_id->FldCaption() ?></span></th>
<?php } ?>
<?php if ($kontrak->kab_id->Visible) { // kab_id ?>
		<th class="<?php echo $kontrak->kab_id->HeaderCellClass() ?>"><span id="elh_kontrak_kab_id" class="kontrak_kab_id"><?php echo $kontrak->kab_id->FldCaption() ?></span></th>
<?php } ?>
<?php if ($kontrak->kec_id->Visible) { // kec_id ?>
		<th class="<?php echo $kontrak->kec_id->HeaderCellClass() ?>"><span id="elh_kontrak_kec_id" class="kontrak_kec_id"><?php echo $kontrak->kec_id->FldCaption() ?></span></th>
<?php } ?>
<?php if ($kontrak->desa_id->Visible) { // desa_id ?>
		<th class="<?php echo $kontrak->desa_id->HeaderCellClass() ?>"><span id="elh_kontrak_desa_id" class="kontrak_desa_id"><?php echo $kontrak->desa_id->FldCaption() ?></span></th>
<?php } ?>
<?php if ($kontrak->blok_id->Visible) { // blok_id ?>
		<th class="<?php echo $kontrak->blok_id->HeaderCellClass() ?>"><span id="elh_kontrak_blok_id" class="kontrak_blok_id"><?php echo $kontrak->blok_id->FldCaption() ?></span></th>
<?php } ?>
<?php if ($kontrak->sos_id->Visible) { // sos_id ?>
		<th class="<?php echo $kontrak->sos_id->HeaderCellClass() ?>"><span id="elh_kontrak_sos_id" class="kontrak_sos_id"><?php echo $kontrak->sos_id->FldCaption() ?></span></th>
<?php } ?>
<?php if ($kontrak->var_id->Visible) { // var_id ?>
		<th class="<?php echo $kontrak->var_id->HeaderCellClass() ?>"><span id="elh_kontrak_var_id" class="kontrak_var_id"><?php echo $kontrak->var_id->FldCaption() ?></span></th>
<?php } ?>
<?php if ($kontrak->co_id->Visible) { // co_id ?>
		<th class="<?php echo $kontrak->co_id->HeaderCellClass() ?>"><span id="elh_kontrak_co_id" class="kontrak_co_id"><?php echo $kontrak->co_id->FldCaption() ?></span></th>
<?php } ?>
<?php if ($kontrak->k_jumlah_bibit->Visible) { // k_jumlah_bibit ?>
		<th class="<?php echo $kontrak->k_jumlah_bibit->HeaderCellClass() ?>"><span id="elh_kontrak_k_jumlah_bibit" class="kontrak_k_jumlah_bibit"><?php echo $kontrak->k_jumlah_bibit->FldCaption() ?></span></th>
<?php } ?>
<?php if ($kontrak->k_asal_bibit->Visible) { // k_asal_bibit ?>
		<th class="<?php echo $kontrak->k_asal_bibit->HeaderCellClass() ?>"><span id="elh_kontrak_k_asal_bibit" class="kontrak_k_asal_bibit"><?php echo $kontrak->k_asal_bibit->FldCaption() ?></span></th>
<?php } ?>
<?php if ($kontrak->k_tgl_tanam->Visible) { // k_tgl_tanam ?>
		<th class="<?php echo $kontrak->k_tgl_tanam->HeaderCellClass() ?>"><span id="elh_kontrak_k_tgl_tanam" class="kontrak_k_tgl_tanam"><?php echo $kontrak->k_tgl_tanam->FldCaption() ?></span></th>
<?php } ?>
<?php if ($kontrak->k_es_tgl_panen->Visible) { // k_es_tgl_panen ?>
		<th class="<?php echo $kontrak->k_es_tgl_panen->HeaderCellClass() ?>"><span id="elh_kontrak_k_es_tgl_panen" class="kontrak_k_es_tgl_panen"><?php echo $kontrak->k_es_tgl_panen->FldCaption() ?></span></th>
<?php } ?>
<?php if ($kontrak->k_ak_tgl_datang->Visible) { // k_ak_tgl_datang ?>
		<th class="<?php echo $kontrak->k_ak_tgl_datang->HeaderCellClass() ?>"><span id="elh_kontrak_k_ak_tgl_datang" class="kontrak_k_ak_tgl_datang"><?php echo $kontrak->k_ak_tgl_datang->FldCaption() ?></span></th>
<?php } ?>
<?php if ($kontrak->k_es_qty->Visible) { // k_es_qty ?>
		<th class="<?php echo $kontrak->k_es_qty->HeaderCellClass() ?>"><span id="elh_kontrak_k_es_qty" class="kontrak_k_es_qty"><?php echo $kontrak->k_es_qty->FldCaption() ?></span></th>
<?php } ?>
<?php if ($kontrak->k_ak_qty->Visible) { // k_ak_qty ?>
		<th class="<?php echo $kontrak->k_ak_qty->HeaderCellClass() ?>"><span id="elh_kontrak_k_ak_qty" class="kontrak_k_ak_qty"><?php echo $kontrak->k_ak_qty->FldCaption() ?></span></th>
<?php } ?>
<?php if ($kontrak->k_es_perhektar->Visible) { // k_es_perhektar ?>
		<th class="<?php echo $kontrak->k_es_perhektar->HeaderCellClass() ?>"><span id="elh_kontrak_k_es_perhektar" class="kontrak_k_es_perhektar"><?php echo $kontrak->k_es_perhektar->FldCaption() ?></span></th>
<?php } ?>
<?php if ($kontrak->k_ak_perhektar->Visible) { // k_ak_perhektar ?>
		<th class="<?php echo $kontrak->k_ak_perhektar->HeaderCellClass() ?>"><span id="elh_kontrak_k_ak_perhektar" class="kontrak_k_ak_perhektar"><?php echo $kontrak->k_ak_perhektar->FldCaption() ?></span></th>
<?php } ?>
<?php if ($kontrak->k_skor->Visible) { // k_skor ?>
		<th class="<?php echo $kontrak->k_skor->HeaderCellClass() ?>"><span id="elh_kontrak_k_skor" class="kontrak_k_skor"><?php echo $kontrak->k_skor->FldCaption() ?></span></th>
<?php } ?>
<?php if ($kontrak->k_ket->Visible) { // k_ket ?>
		<th class="<?php echo $kontrak->k_ket->HeaderCellClass() ?>"><span id="elh_kontrak_k_ket" class="kontrak_k_ket"><?php echo $kontrak->k_ket->FldCaption() ?></span></th>
<?php } ?>
<?php if ($kontrak->k_cat->Visible) { // k_cat ?>
		<th class="<?php echo $kontrak->k_cat->HeaderCellClass() ?>"><span id="elh_kontrak_k_cat" class="kontrak_k_cat"><?php echo $kontrak->k_cat->FldCaption() ?></span></th>
<?php } ?>
<?php if ($kontrak->k_titik_koordinat->Visible) { // k_titik_koordinat ?>
		<th class="<?php echo $kontrak->k_titik_koordinat->HeaderCellClass() ?>"><span id="elh_kontrak_k_titik_koordinat" class="kontrak_k_titik_koordinat"><?php echo $kontrak->k_titik_koordinat->FldCaption() ?></span></th>
<?php } ?>
<?php if ($kontrak->k_foto_lahan->Visible) { // k_foto_lahan ?>
		<th class="<?php echo $kontrak->k_foto_lahan->HeaderCellClass() ?>"><span id="elh_kontrak_k_foto_lahan" class="kontrak_k_foto_lahan"><?php echo $kontrak->k_foto_lahan->FldCaption() ?></span></th>
<?php } ?>
<?php if ($kontrak->k_dok->Visible) { // k_dok ?>
		<th class="<?php echo $kontrak->k_dok->HeaderCellClass() ?>"><span id="elh_kontrak_k_dok" class="kontrak_k_dok"><?php echo $kontrak->k_dok->FldCaption() ?></span></th>
<?php } ?>
<?php if ($kontrak->k_harga_bibit->Visible) { // k_harga_bibit ?>
		<th class="<?php echo $kontrak->k_harga_bibit->HeaderCellClass() ?>"><span id="elh_kontrak_k_harga_bibit" class="kontrak_k_harga_bibit"><?php echo $kontrak->k_harga_bibit->FldCaption() ?></span></th>
<?php } ?>
<?php if ($kontrak->k_bayar_bibit->Visible) { // k_bayar_bibit ?>
		<th class="<?php echo $kontrak->k_bayar_bibit->HeaderCellClass() ?>"><span id="elh_kontrak_k_bayar_bibit" class="kontrak_k_bayar_bibit"><?php echo $kontrak->k_bayar_bibit->FldCaption() ?></span></th>
<?php } ?>
<?php if ($kontrak->k_pinjaman->Visible) { // k_pinjaman ?>
		<th class="<?php echo $kontrak->k_pinjaman->HeaderCellClass() ?>"><span id="elh_kontrak_k_pinjaman" class="kontrak_k_pinjaman"><?php echo $kontrak->k_pinjaman->FldCaption() ?></span></th>
<?php } ?>
<?php if ($kontrak->k_bayar_pinjaman->Visible) { // k_bayar_pinjaman ?>
		<th class="<?php echo $kontrak->k_bayar_pinjaman->HeaderCellClass() ?>"><span id="elh_kontrak_k_bayar_pinjaman" class="kontrak_k_bayar_pinjaman"><?php echo $kontrak->k_bayar_pinjaman->FldCaption() ?></span></th>
<?php } ?>
<?php if ($kontrak->k_sisa_hutang->Visible) { // k_sisa_hutang ?>
		<th class="<?php echo $kontrak->k_sisa_hutang->HeaderCellClass() ?>"><span id="elh_kontrak_k_sisa_hutang" class="kontrak_k_sisa_hutang"><?php echo $kontrak->k_sisa_hutang->FldCaption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$kontrak_delete->RecCnt = 0;
$i = 0;
while (!$kontrak_delete->Recordset->EOF) {
	$kontrak_delete->RecCnt++;
	$kontrak_delete->RowCnt++;

	// Set row properties
	$kontrak->ResetAttrs();
	$kontrak->RowType = EW_ROWTYPE_VIEW; // View

	// Get the field contents
	$kontrak_delete->LoadRowValues($kontrak_delete->Recordset);

	// Render row
	$kontrak_delete->RenderRow();
?>
	<tr<?php echo $kontrak->RowAttributes() ?>>
<?php if ($kontrak->k_id_kontrak->Visible) { // k_id_kontrak ?>
		<td<?php echo $kontrak->k_id_kontrak->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_k_id_kontrak" class="kontrak_k_id_kontrak">
<span<?php echo $kontrak->k_id_kontrak->ViewAttributes() ?>>
<?php echo $kontrak->k_id_kontrak->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($kontrak->k_luas_lahan->Visible) { // k_luas_lahan ?>
		<td<?php echo $kontrak->k_luas_lahan->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_k_luas_lahan" class="kontrak_k_luas_lahan">
<span<?php echo $kontrak->k_luas_lahan->ViewAttributes() ?>>
<?php echo $kontrak->k_luas_lahan->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($kontrak->pet_id->Visible) { // pet_id ?>
		<td<?php echo $kontrak->pet_id->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_pet_id" class="kontrak_pet_id">
<span<?php echo $kontrak->pet_id->ViewAttributes() ?>>
<?php if ((!ew_EmptyStr($kontrak->pet_id->ListViewValue())) && $kontrak->pet_id->LinkAttributes() <> "") { ?>
<a<?php echo $kontrak->pet_id->LinkAttributes() ?>><?php echo $kontrak->pet_id->ListViewValue() ?></a>
<?php } else { ?>
<?php echo $kontrak->pet_id->ListViewValue() ?>
<?php } ?>
</span>
</span>
</td>
<?php } ?>
<?php if ($kontrak->koord_id->Visible) { // koord_id ?>
		<td<?php echo $kontrak->koord_id->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_koord_id" class="kontrak_koord_id">
<span<?php echo $kontrak->koord_id->ViewAttributes() ?>>
<?php if ((!ew_EmptyStr($kontrak->koord_id->ListViewValue())) && $kontrak->koord_id->LinkAttributes() <> "") { ?>
<a<?php echo $kontrak->koord_id->LinkAttributes() ?>><?php echo $kontrak->koord_id->ListViewValue() ?></a>
<?php } else { ?>
<?php echo $kontrak->koord_id->ListViewValue() ?>
<?php } ?>
</span>
</span>
</td>
<?php } ?>
<?php if ($kontrak->kk_id->Visible) { // kk_id ?>
		<td<?php echo $kontrak->kk_id->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_kk_id" class="kontrak_kk_id">
<span<?php echo $kontrak->kk_id->ViewAttributes() ?>>
<?php if ((!ew_EmptyStr($kontrak->kk_id->ListViewValue())) && $kontrak->kk_id->LinkAttributes() <> "") { ?>
<a<?php echo $kontrak->kk_id->LinkAttributes() ?>><?php echo $kontrak->kk_id->ListViewValue() ?></a>
<?php } else { ?>
<?php echo $kontrak->kk_id->ListViewValue() ?>
<?php } ?>
</span>
</span>
</td>
<?php } ?>
<?php if ($kontrak->prov_id->Visible) { // prov_id ?>
		<td<?php echo $kontrak->prov_id->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_prov_id" class="kontrak_prov_id">
<span<?php echo $kontrak->prov_id->ViewAttributes() ?>>
<?php echo $kontrak->prov_id->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($kontrak->kab_id->Visible) { // kab_id ?>
		<td<?php echo $kontrak->kab_id->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_kab_id" class="kontrak_kab_id">
<span<?php echo $kontrak->kab_id->ViewAttributes() ?>>
<?php echo $kontrak->kab_id->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($kontrak->kec_id->Visible) { // kec_id ?>
		<td<?php echo $kontrak->kec_id->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_kec_id" class="kontrak_kec_id">
<span<?php echo $kontrak->kec_id->ViewAttributes() ?>>
<?php echo $kontrak->kec_id->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($kontrak->desa_id->Visible) { // desa_id ?>
		<td<?php echo $kontrak->desa_id->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_desa_id" class="kontrak_desa_id">
<span<?php echo $kontrak->desa_id->ViewAttributes() ?>>
<?php echo $kontrak->desa_id->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($kontrak->blok_id->Visible) { // blok_id ?>
		<td<?php echo $kontrak->blok_id->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_blok_id" class="kontrak_blok_id">
<span<?php echo $kontrak->blok_id->ViewAttributes() ?>>
<?php echo $kontrak->blok_id->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($kontrak->sos_id->Visible) { // sos_id ?>
		<td<?php echo $kontrak->sos_id->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_sos_id" class="kontrak_sos_id">
<span<?php echo $kontrak->sos_id->ViewAttributes() ?>>
<?php echo $kontrak->sos_id->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($kontrak->var_id->Visible) { // var_id ?>
		<td<?php echo $kontrak->var_id->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_var_id" class="kontrak_var_id">
<span<?php echo $kontrak->var_id->ViewAttributes() ?>>
<?php if ((!ew_EmptyStr($kontrak->var_id->ListViewValue())) && $kontrak->var_id->LinkAttributes() <> "") { ?>
<a<?php echo $kontrak->var_id->LinkAttributes() ?>><?php echo $kontrak->var_id->ListViewValue() ?></a>
<?php } else { ?>
<?php echo $kontrak->var_id->ListViewValue() ?>
<?php } ?>
</span>
</span>
</td>
<?php } ?>
<?php if ($kontrak->co_id->Visible) { // co_id ?>
		<td<?php echo $kontrak->co_id->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_co_id" class="kontrak_co_id">
<span<?php echo $kontrak->co_id->ViewAttributes() ?>>
<?php if ((!ew_EmptyStr($kontrak->co_id->ListViewValue())) && $kontrak->co_id->LinkAttributes() <> "") { ?>
<a<?php echo $kontrak->co_id->LinkAttributes() ?>><?php echo $kontrak->co_id->ListViewValue() ?></a>
<?php } else { ?>
<?php echo $kontrak->co_id->ListViewValue() ?>
<?php } ?>
</span>
</span>
</td>
<?php } ?>
<?php if ($kontrak->k_jumlah_bibit->Visible) { // k_jumlah_bibit ?>
		<td<?php echo $kontrak->k_jumlah_bibit->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_k_jumlah_bibit" class="kontrak_k_jumlah_bibit">
<span<?php echo $kontrak->k_jumlah_bibit->ViewAttributes() ?>>
<?php echo $kontrak->k_jumlah_bibit->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($kontrak->k_asal_bibit->Visible) { // k_asal_bibit ?>
		<td<?php echo $kontrak->k_asal_bibit->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_k_asal_bibit" class="kontrak_k_asal_bibit">
<span<?php echo $kontrak->k_asal_bibit->ViewAttributes() ?>>
<?php echo $kontrak->k_asal_bibit->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($kontrak->k_tgl_tanam->Visible) { // k_tgl_tanam ?>
		<td<?php echo $kontrak->k_tgl_tanam->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_k_tgl_tanam" class="kontrak_k_tgl_tanam">
<span<?php echo $kontrak->k_tgl_tanam->ViewAttributes() ?>>
<?php echo $kontrak->k_tgl_tanam->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($kontrak->k_es_tgl_panen->Visible) { // k_es_tgl_panen ?>
		<td<?php echo $kontrak->k_es_tgl_panen->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_k_es_tgl_panen" class="kontrak_k_es_tgl_panen">
<span<?php echo $kontrak->k_es_tgl_panen->ViewAttributes() ?>>
<?php echo $kontrak->k_es_tgl_panen->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($kontrak->k_ak_tgl_datang->Visible) { // k_ak_tgl_datang ?>
		<td<?php echo $kontrak->k_ak_tgl_datang->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_k_ak_tgl_datang" class="kontrak_k_ak_tgl_datang">
<span<?php echo $kontrak->k_ak_tgl_datang->ViewAttributes() ?>>
<?php echo $kontrak->k_ak_tgl_datang->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($kontrak->k_es_qty->Visible) { // k_es_qty ?>
		<td<?php echo $kontrak->k_es_qty->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_k_es_qty" class="kontrak_k_es_qty">
<span<?php echo $kontrak->k_es_qty->ViewAttributes() ?>>
<?php echo $kontrak->k_es_qty->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($kontrak->k_ak_qty->Visible) { // k_ak_qty ?>
		<td<?php echo $kontrak->k_ak_qty->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_k_ak_qty" class="kontrak_k_ak_qty">
<span<?php echo $kontrak->k_ak_qty->ViewAttributes() ?>>
<?php echo $kontrak->k_ak_qty->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($kontrak->k_es_perhektar->Visible) { // k_es_perhektar ?>
		<td<?php echo $kontrak->k_es_perhektar->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_k_es_perhektar" class="kontrak_k_es_perhektar">
<span<?php echo $kontrak->k_es_perhektar->ViewAttributes() ?>>
<?php echo $kontrak->k_es_perhektar->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($kontrak->k_ak_perhektar->Visible) { // k_ak_perhektar ?>
		<td<?php echo $kontrak->k_ak_perhektar->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_k_ak_perhektar" class="kontrak_k_ak_perhektar">
<span<?php echo $kontrak->k_ak_perhektar->ViewAttributes() ?>>
<?php echo $kontrak->k_ak_perhektar->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($kontrak->k_skor->Visible) { // k_skor ?>
		<td<?php echo $kontrak->k_skor->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_k_skor" class="kontrak_k_skor">
<span<?php echo $kontrak->k_skor->ViewAttributes() ?>>
<?php echo $kontrak->k_skor->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($kontrak->k_ket->Visible) { // k_ket ?>
		<td<?php echo $kontrak->k_ket->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_k_ket" class="kontrak_k_ket">
<span<?php echo $kontrak->k_ket->ViewAttributes() ?>>
<?php echo $kontrak->k_ket->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($kontrak->k_cat->Visible) { // k_cat ?>
		<td<?php echo $kontrak->k_cat->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_k_cat" class="kontrak_k_cat">
<span<?php echo $kontrak->k_cat->ViewAttributes() ?>>
<?php echo $kontrak->k_cat->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($kontrak->k_titik_koordinat->Visible) { // k_titik_koordinat ?>
		<td<?php echo $kontrak->k_titik_koordinat->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_k_titik_koordinat" class="kontrak_k_titik_koordinat">
<span<?php echo $kontrak->k_titik_koordinat->ViewAttributes() ?>>
<?php if ((!ew_EmptyStr($kontrak->k_titik_koordinat->ListViewValue())) && $kontrak->k_titik_koordinat->LinkAttributes() <> "") { ?>
<a<?php echo $kontrak->k_titik_koordinat->LinkAttributes() ?>><?php echo $kontrak->k_titik_koordinat->ListViewValue() ?></a>
<?php } else { ?>
<?php echo $kontrak->k_titik_koordinat->ListViewValue() ?>
<?php } ?>
</span>
</span>
</td>
<?php } ?>
<?php if ($kontrak->k_foto_lahan->Visible) { // k_foto_lahan ?>
		<td<?php echo $kontrak->k_foto_lahan->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_k_foto_lahan" class="kontrak_k_foto_lahan">
<span>
<?php echo ew_GetFileViewTag($kontrak->k_foto_lahan, $kontrak->k_foto_lahan->ListViewValue()) ?>
</span>
</span>
</td>
<?php } ?>
<?php if ($kontrak->k_dok->Visible) { // k_dok ?>
		<td<?php echo $kontrak->k_dok->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_k_dok" class="kontrak_k_dok">
<span>
<?php echo ew_GetFileViewTag($kontrak->k_dok, $kontrak->k_dok->ListViewValue()) ?>
</span>
</span>
</td>
<?php } ?>
<?php if ($kontrak->k_harga_bibit->Visible) { // k_harga_bibit ?>
		<td<?php echo $kontrak->k_harga_bibit->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_k_harga_bibit" class="kontrak_k_harga_bibit">
<span<?php echo $kontrak->k_harga_bibit->ViewAttributes() ?>>
<?php echo $kontrak->k_harga_bibit->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($kontrak->k_bayar_bibit->Visible) { // k_bayar_bibit ?>
		<td<?php echo $kontrak->k_bayar_bibit->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_k_bayar_bibit" class="kontrak_k_bayar_bibit">
<span<?php echo $kontrak->k_bayar_bibit->ViewAttributes() ?>>
<?php echo $kontrak->k_bayar_bibit->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($kontrak->k_pinjaman->Visible) { // k_pinjaman ?>
		<td<?php echo $kontrak->k_pinjaman->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_k_pinjaman" class="kontrak_k_pinjaman">
<span<?php echo $kontrak->k_pinjaman->ViewAttributes() ?>>
<?php echo $kontrak->k_pinjaman->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($kontrak->k_bayar_pinjaman->Visible) { // k_bayar_pinjaman ?>
		<td<?php echo $kontrak->k_bayar_pinjaman->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_k_bayar_pinjaman" class="kontrak_k_bayar_pinjaman">
<span<?php echo $kontrak->k_bayar_pinjaman->ViewAttributes() ?>>
<?php echo $kontrak->k_bayar_pinjaman->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($kontrak->k_sisa_hutang->Visible) { // k_sisa_hutang ?>
		<td<?php echo $kontrak->k_sisa_hutang->CellAttributes() ?>>
<span id="el<?php echo $kontrak_delete->RowCnt ?>_kontrak_k_sisa_hutang" class="kontrak_k_sisa_hutang">
<span<?php echo $kontrak->k_sisa_hutang->ViewAttributes() ?>>
<?php echo $kontrak->k_sisa_hutang->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$kontrak_delete->Recordset->MoveNext();
}
$kontrak_delete->Recordset->Close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ewButton" name="btnAction" id="btnAction" type="submit"><?php echo $Language->Phrase("DeleteBtn") ?></button>
<button class="btn btn-default ewButton" name="btnCancel" id="btnCancel" type="button" data-href="<?php echo $kontrak_delete->getReturnUrl() ?>"><?php echo $Language->Phrase("CancelBtn") ?></button>
</div>
</form>
<script type="text/javascript">
fkontrakdelete.Init();
</script>
<?php
$kontrak_delete->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$kontrak_delete->Page_Terminate();
?>
