<?php

// Global variable for table object
$kedatangan = NULL;

//
// Table class for kedatangan
//
class ckedatangan extends cTable {
	var $datang_id;
	var $datang_tgl;
	var $datang_sumber;
	var $k_id;
	var $sup_id;
	var $po_id;
	var $var_id;
	var $datang_jumlah;
	var $datang_terpakai;

	//
	// Table class constructor
	//
	function __construct() {
		global $Language;

		// Language object
		if (!isset($Language)) $Language = new cLanguage();
		$this->TableVar = 'kedatangan';
		$this->TableName = 'kedatangan';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`kedatangan`";
		$this->DBID = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = ""; // Page orientation (PHPExcel only)
		$this->ExportExcelPageSize = ""; // Page size (PHPExcel only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new cBasicSearch($this->TableVar);

		// datang_id
		$this->datang_id = new cField('kedatangan', 'kedatangan', 'x_datang_id', 'datang_id', '`datang_id`', '`datang_id`', 3, -1, FALSE, '`datang_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datang_id->Sortable = TRUE; // Allow sort
		$this->datang_id->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['datang_id'] = &$this->datang_id;

		// datang_tgl
		$this->datang_tgl = new cField('kedatangan', 'kedatangan', 'x_datang_tgl', 'datang_tgl', '`datang_tgl`', ew_CastDateFieldForLike('`datang_tgl`', 0, "DB"), 135, 0, FALSE, '`datang_tgl`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datang_tgl->Sortable = TRUE; // Allow sort
		$this->datang_tgl->FldDefaultErrMsg = str_replace("%s", $GLOBALS["EW_DATE_FORMAT"], $Language->Phrase("IncorrectDate"));
		$this->fields['datang_tgl'] = &$this->datang_tgl;

		// datang_sumber
		$this->datang_sumber = new cField('kedatangan', 'kedatangan', 'x_datang_sumber', 'datang_sumber', '`datang_sumber`', '`datang_sumber`', 3, -1, FALSE, '`datang_sumber`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'RADIO');
		$this->datang_sumber->Sortable = TRUE; // Allow sort
		$this->datang_sumber->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['datang_sumber'] = &$this->datang_sumber;

		// k_id
		$this->k_id = new cField('kedatangan', 'kedatangan', 'x_k_id', 'k_id', '`k_id`', '`k_id`', 3, -1, FALSE, '`EV__k_id`', TRUE, FALSE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->k_id->Sortable = TRUE; // Allow sort
		$this->k_id->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['k_id'] = &$this->k_id;

		// sup_id
		$this->sup_id = new cField('kedatangan', 'kedatangan', 'x_sup_id', 'sup_id', '`sup_id`', '`sup_id`', 3, -1, FALSE, '`sup_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sup_id->Sortable = TRUE; // Allow sort
		$this->sup_id->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['sup_id'] = &$this->sup_id;

		// po_id
		$this->po_id = new cField('kedatangan', 'kedatangan', 'x_po_id', 'po_id', '`po_id`', '`po_id`', 3, -1, FALSE, '`EV__po_id`', TRUE, FALSE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->po_id->Sortable = TRUE; // Allow sort
		$this->po_id->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['po_id'] = &$this->po_id;

		// var_id
		$this->var_id = new cField('kedatangan', 'kedatangan', 'x_var_id', 'var_id', '`var_id`', '`var_id`', 3, -1, FALSE, '`var_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->var_id->Sortable = TRUE; // Allow sort
		$this->var_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->var_id->PleaseSelectText = $Language->Phrase("PleaseSelect"); // PleaseSelect text
		$this->var_id->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['var_id'] = &$this->var_id;

		// datang_jumlah
		$this->datang_jumlah = new cField('kedatangan', 'kedatangan', 'x_datang_jumlah', 'datang_jumlah', '`datang_jumlah`', '`datang_jumlah`', 3, -1, FALSE, '`datang_jumlah`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datang_jumlah->Sortable = TRUE; // Allow sort
		$this->datang_jumlah->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['datang_jumlah'] = &$this->datang_jumlah;

		// datang_terpakai
		$this->datang_terpakai = new cField('kedatangan', 'kedatangan', 'x_datang_terpakai', 'datang_terpakai', '`datang_terpakai`', '`datang_terpakai`', 3, -1, FALSE, '`datang_terpakai`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datang_terpakai->Sortable = TRUE; // Allow sort
		$this->datang_terpakai->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['datang_terpakai'] = &$this->datang_terpakai;
	}

	// Field Visibility
	function GetFieldVisibility($fldparm) {
		global $Security;
		return $this->$fldparm->Visible; // Returns original value
	}

	// Column CSS classes
	var $LeftColumnClass = "col-sm-2 control-label ewLabel";
	var $RightColumnClass = "col-sm-10";
	var $OffsetColumnClass = "col-sm-10 col-sm-offset-2";

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function SetLeftColumnClass($class) {
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " control-label ewLabel";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - intval($match[2]));
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace($match[1], $match[1] + "-offset", $class);
		}
	}

	// Single column sort
	function UpdateSort(&$ofld) {
		if ($this->CurrentOrder == $ofld->FldName) {
			$sSortField = $ofld->FldExpression;
			$sLastSort = $ofld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$sThisSort = $this->CurrentOrderType;
			} else {
				$sThisSort = ($sLastSort == "ASC") ? "DESC" : "ASC";
			}
			$ofld->setSort($sThisSort);
			$this->setSessionOrderBy($sSortField . " " . $sThisSort); // Save to Session
			$sSortFieldList = ($ofld->FldVirtualExpression <> "") ? $ofld->FldVirtualExpression : $sSortField;
			$this->setSessionOrderByList($sSortFieldList . " " . $sThisSort); // Save to Session
		} else {
			$ofld->setSort("");
		}
	}

	// Session ORDER BY for List page
	function getSessionOrderByList() {
		return @$_SESSION[EW_PROJECT_NAME . "_" . $this->TableVar . "_" . EW_TABLE_ORDER_BY_LIST];
	}

	function setSessionOrderByList($v) {
		$_SESSION[EW_PROJECT_NAME . "_" . $this->TableVar . "_" . EW_TABLE_ORDER_BY_LIST] = $v;
	}

	// Table level SQL
	var $_SqlFrom = "";

	function getSqlFrom() { // From
		return ($this->_SqlFrom <> "") ? $this->_SqlFrom : "`kedatangan`";
	}

	function SqlFrom() { // For backward compatibility
		return $this->getSqlFrom();
	}

	function setSqlFrom($v) {
		$this->_SqlFrom = $v;
	}
	var $_SqlSelect = "";

	function getSqlSelect() { // Select
		return ($this->_SqlSelect <> "") ? $this->_SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}

	function SqlSelect() { // For backward compatibility
		return $this->getSqlSelect();
	}

	function setSqlSelect($v) {
		$this->_SqlSelect = $v;
	}
	var $_SqlSelectList = "";

	function getSqlSelectList() { // Select for List page
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT CONCAT(COALESCE(`k_id_kontrak`, ''),'" . ew_ValueSeparator(1, $this->k_id) . "',COALESCE(`k_tgl_tanam`,'')) FROM `kontrak` `EW_TMP_LOOKUPTABLE` WHERE `EW_TMP_LOOKUPTABLE`.`k_id` = `kedatangan`.`k_id` LIMIT 1) AS `EV__k_id`, (SELECT CONCAT(COALESCE(`po_id`, ''),'" . ew_ValueSeparator(1, $this->po_id) . "',COALESCE(`po_tanggal`,'')) FROM `po` `EW_TMP_LOOKUPTABLE` WHERE `EW_TMP_LOOKUPTABLE`.`po_id` = `kedatangan`.`po_id` LIMIT 1) AS `EV__po_id` FROM `kedatangan`" .
			") `EW_TMP_TABLE`";
		return ($this->_SqlSelectList <> "") ? $this->_SqlSelectList : $select;
	}

	function SqlSelectList() { // For backward compatibility
		return $this->getSqlSelectList();
	}

	function setSqlSelectList($v) {
		$this->_SqlSelectList = $v;
	}
	var $_SqlWhere = "";

	function getSqlWhere() { // Where
		$sWhere = ($this->_SqlWhere <> "") ? $this->_SqlWhere : "";
		$this->TableFilter = "";
		ew_AddFilter($sWhere, $this->TableFilter);
		return $sWhere;
	}

	function SqlWhere() { // For backward compatibility
		return $this->getSqlWhere();
	}

	function setSqlWhere($v) {
		$this->_SqlWhere = $v;
	}
	var $_SqlGroupBy = "";

	function getSqlGroupBy() { // Group By
		return ($this->_SqlGroupBy <> "") ? $this->_SqlGroupBy : "";
	}

	function SqlGroupBy() { // For backward compatibility
		return $this->getSqlGroupBy();
	}

	function setSqlGroupBy($v) {
		$this->_SqlGroupBy = $v;
	}
	var $_SqlHaving = "";

	function getSqlHaving() { // Having
		return ($this->_SqlHaving <> "") ? $this->_SqlHaving : "";
	}

	function SqlHaving() { // For backward compatibility
		return $this->getSqlHaving();
	}

	function setSqlHaving($v) {
		$this->_SqlHaving = $v;
	}
	var $_SqlOrderBy = "";

	function getSqlOrderBy() { // Order By
		return ($this->_SqlOrderBy <> "") ? $this->_SqlOrderBy : "";
	}

	function SqlOrderBy() { // For backward compatibility
		return $this->getSqlOrderBy();
	}

	function setSqlOrderBy($v) {
		$this->_SqlOrderBy = $v;
	}

	// Apply User ID filters
	function ApplyUserIDFilters($sFilter) {
		return $sFilter;
	}

	// Check if User ID security allows view all
	function UserIDAllow($id = "") {
		$allow = EW_USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	function GetSQL($where, $orderby) {
		return ew_BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderby);
	}

	// Table SQL
	function SQL() {
		$filter = $this->CurrentFilter;
		$filter = $this->ApplyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->GetSQL($filter, $sort);
	}

	// Table SQL with List page filter
	var $UseSessionForListSQL = TRUE;

	function ListSQL() {
		$sFilter = $this->UseSessionForListSQL ? $this->getSessionWhere() : "";
		ew_AddFilter($sFilter, $this->CurrentFilter);
		$sFilter = $this->ApplyUserIDFilters($sFilter);
		$this->Recordset_Selecting($sFilter);
		if ($this->UseVirtualFields()) {
			$sSelect = $this->getSqlSelectList();
			$sSort = $this->UseSessionForListSQL ? $this->getSessionOrderByList() : "";
		} else {
			$sSelect = $this->getSqlSelect();
			$sSort = $this->UseSessionForListSQL ? $this->getSessionOrderBy() : "";
		}
		return ew_BuildSelectSql($sSelect, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $sFilter, $sSort);
	}

	// Get ORDER BY clause
	function GetOrderBy() {
		$sSort = ($this->UseVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return ew_BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sSort);
	}

	// Check if virtual fields is used in SQL
	function UseVirtualFields() {
		$sWhere = $this->UseSessionForListSQL ? $this->getSessionWhere() : $this->CurrentFilter;
		$sOrderBy = $this->UseSessionForListSQL ? $this->getSessionOrderByList() : "";
		if ($sWhere <> "")
			$sWhere = " " . str_replace(array("(",")"), array("",""), $sWhere) . " ";
		if ($sOrderBy <> "")
			$sOrderBy = " " . str_replace(array("(",")"), array("",""), $sOrderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if ($this->k_id->AdvancedSearch->SearchValue <> "" ||
			$this->k_id->AdvancedSearch->SearchValue2 <> "" ||
			strpos($sWhere, " " . $this->k_id->FldVirtualExpression . " ") !== FALSE)
			return TRUE;
		if (strpos($sOrderBy, " " . $this->k_id->FldVirtualExpression . " ") !== FALSE)
			return TRUE;
		if ($this->po_id->AdvancedSearch->SearchValue <> "" ||
			$this->po_id->AdvancedSearch->SearchValue2 <> "" ||
			strpos($sWhere, " " . $this->po_id->FldVirtualExpression . " ") !== FALSE)
			return TRUE;
		if (strpos($sOrderBy, " " . $this->po_id->FldVirtualExpression . " ") !== FALSE)
			return TRUE;
		return FALSE;
	}

	// Try to get record count
	function TryGetRecordCount($sql) {
		$cnt = -1;
		$pattern = "/^SELECT \* FROM/i";
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') && preg_match($pattern, $sql)) {
			$sql = "SELECT COUNT(*) FROM" . preg_replace($pattern, "", $sql);
		} else {
			$sql = "SELECT COUNT(*) FROM (" . $sql . ") EW_COUNT_TABLE";
		}
		$conn = &$this->Connection();
		if ($rs = $conn->Execute($sql)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->Close();
			}
		}
		return intval($cnt);
	}

	// Get record count based on filter (for detail record count in master table pages)
	function LoadRecordCount($filter) {
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = ew_BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->TryGetRecordCount($sql);
		if ($cnt == -1) {
			if ($rs = $this->LoadRs($this->CurrentFilter)) {
				$cnt = $rs->RecordCount();
				$rs->Close();
			}
		}
		$this->CurrentFilter = $origFilter;
		return intval($cnt);
	}

	// Get record count (for current List page)
	function ListRecordCount() {
		$filter = $this->getSessionWhere();
		ew_AddFilter($filter, $this->CurrentFilter);
		$filter = $this->ApplyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->UseVirtualFields())
			$sql = ew_BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = ew_BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->TryGetRecordCount($sql);
		if ($cnt == -1) {
			$conn = &$this->Connection();
			if ($rs = $conn->Execute($sql)) {
				$cnt = $rs->RecordCount();
				$rs->Close();
			}
		}
		return intval($cnt);
	}

	// INSERT statement
	function InsertSQL(&$rs) {
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->FldIsCustom)
				continue;
			$names .= $this->fields[$name]->FldExpression . ",";
			$values .= ew_QuotedValue($value, $this->fields[$name]->FldDataType, $this->DBID) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	function Insert(&$rs) {
		$conn = &$this->Connection();
		$bInsert = $conn->Execute($this->InsertSQL($rs));
		if ($bInsert) {
		}
		return $bInsert;
	}

	// UPDATE statement
	function UpdateSQL(&$rs, $where = "", $curfilter = TRUE) {
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->FldIsCustom)
				continue;
			$sql .= $this->fields[$name]->FldExpression . "=";
			$sql .= ew_QuotedValue($value, $this->fields[$name]->FldDataType, $this->DBID) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->ArrayToFilter($where);
		ew_AddFilter($filter, $where);
		if ($filter <> "")	$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	function Update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE) {
		$conn = &$this->Connection();
		$bUpdate = $conn->Execute($this->UpdateSQL($rs, $where, $curfilter));
		return $bUpdate;
	}

	// DELETE statement
	function DeleteSQL(&$rs, $where = "", $curfilter = TRUE) {
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->ArrayToFilter($where);
		if ($rs) {
			if (array_key_exists('datang_id', $rs))
				ew_AddFilter($where, ew_QuotedName('datang_id', $this->DBID) . '=' . ew_QuotedValue($rs['datang_id'], $this->datang_id->FldDataType, $this->DBID));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		ew_AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	function Delete(&$rs, $where = "", $curfilter = TRUE) {
		$bDelete = TRUE;
		$conn = &$this->Connection();
		if ($bDelete)
			$bDelete = $conn->Execute($this->DeleteSQL($rs, $where, $curfilter));
		return $bDelete;
	}

	// Key filter WHERE clause
	function SqlKeyFilter() {
		return "`datang_id` = @datang_id@";
	}

	// Key filter
	function KeyFilter() {
		$sKeyFilter = $this->SqlKeyFilter();
		if (!is_numeric($this->datang_id->CurrentValue))
			return "0=1"; // Invalid key
		if (is_null($this->datang_id->CurrentValue))
			return "0=1"; // Invalid key
		else
			$sKeyFilter = str_replace("@datang_id@", ew_AdjustSql($this->datang_id->CurrentValue, $this->DBID), $sKeyFilter); // Replace key value
		return $sKeyFilter;
	}

	// Return page URL
	function getReturnUrl() {
		$name = EW_PROJECT_NAME . "_" . $this->TableVar . "_" . EW_TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ew_ServerVar("HTTP_REFERER") <> "" && ew_ReferPage() <> ew_CurrentPage() && ew_ReferPage() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ew_ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "kedatanganlist.php";
		}
	}

	function setReturnUrl($v) {
		$_SESSION[EW_PROJECT_NAME . "_" . $this->TableVar . "_" . EW_TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	function GetModalCaption($pageName) {
		global $Language;
		if ($pageName == "kedatanganview.php")
			return $Language->Phrase("View");
		elseif ($pageName == "kedatanganedit.php")
			return $Language->Phrase("Edit");
		elseif ($pageName == "kedatanganadd.php")
			return $Language->Phrase("Add");
		else
			return "";
	}

	// List URL
	function GetListUrl() {
		return "kedatanganlist.php";
	}

	// View URL
	function GetViewUrl($parm = "") {
		if ($parm <> "")
			$url = $this->KeyUrl("kedatanganview.php", $this->UrlParm($parm));
		else
			$url = $this->KeyUrl("kedatanganview.php", $this->UrlParm(EW_TABLE_SHOW_DETAIL . "="));
		return $this->AddMasterUrl($url);
	}

	// Add URL
	function GetAddUrl($parm = "") {
		if ($parm <> "")
			$url = "kedatanganadd.php?" . $this->UrlParm($parm);
		else
			$url = "kedatanganadd.php";
		return $this->AddMasterUrl($url);
	}

	// Edit URL
	function GetEditUrl($parm = "") {
		$url = $this->KeyUrl("kedatanganedit.php", $this->UrlParm($parm));
		return $this->AddMasterUrl($url);
	}

	// Inline edit URL
	function GetInlineEditUrl() {
		$url = $this->KeyUrl(ew_CurrentPage(), $this->UrlParm("a=edit"));
		return $this->AddMasterUrl($url);
	}

	// Copy URL
	function GetCopyUrl($parm = "") {
		$url = $this->KeyUrl("kedatanganadd.php", $this->UrlParm($parm));
		return $this->AddMasterUrl($url);
	}

	// Inline copy URL
	function GetInlineCopyUrl() {
		$url = $this->KeyUrl(ew_CurrentPage(), $this->UrlParm("a=copy"));
		return $this->AddMasterUrl($url);
	}

	// Delete URL
	function GetDeleteUrl() {
		return $this->KeyUrl("kedatangandelete.php", $this->UrlParm());
	}

	// Add master url
	function AddMasterUrl($url) {
		return $url;
	}

	function KeyToJson() {
		$json = "";
		$json .= "datang_id:" . ew_VarToJson($this->datang_id->CurrentValue, "number", "'");
		return "{" . $json . "}";
	}

	// Add key value to URL
	function KeyUrl($url, $parm = "") {
		$sUrl = $url . "?";
		if ($parm <> "") $sUrl .= $parm . "&";
		if (!is_null($this->datang_id->CurrentValue)) {
			$sUrl .= "datang_id=" . urlencode($this->datang_id->CurrentValue);
		} else {
			return "javascript:ew_Alert(ewLanguage.Phrase('InvalidRecord'));";
		}
		return $sUrl;
	}

	// Sort URL
	function SortUrl(&$fld) {
		if ($this->CurrentAction <> "" || $this->Export <> "" ||
			in_array($fld->FldType, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$sUrlParm = $this->UrlParm("order=" . urlencode($fld->FldName) . "&amp;ordertype=" . $fld->ReverseSort());
			return $this->AddMasterUrl(ew_CurrentPage() . "?" . $sUrlParm);
		} else {
			return "";
		}
	}

	// Get record keys from $_POST/$_GET/$_SESSION
	function GetRecordKeys() {
		global $EW_COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (isset($_POST["key_m"])) {
			$arKeys = $_POST["key_m"];
			$cnt = count($arKeys);
		} elseif (isset($_GET["key_m"])) {
			$arKeys = $_GET["key_m"];
			$cnt = count($arKeys);
		} elseif (!empty($_GET) || !empty($_POST)) {
			$isPost = ew_IsPost();
			if ($isPost && isset($_POST["datang_id"]))
				$arKeys[] = $_POST["datang_id"];
			elseif (isset($_GET["datang_id"]))
				$arKeys[] = $_GET["datang_id"];
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get key filter
	function GetKeyFilter() {
		$arKeys = $this->GetRecordKeys();
		$sKeyFilter = "";
		foreach ($arKeys as $key) {
			if ($sKeyFilter <> "") $sKeyFilter .= " OR ";
			$this->datang_id->CurrentValue = $key;
			$sKeyFilter .= "(" . $this->KeyFilter() . ")";
		}
		return $sKeyFilter;
	}

	// Load rows based on filter
	function &LoadRs($filter) {

		// Set up filter (SQL WHERE clause) and get return SQL
		//$this->CurrentFilter = $filter;
		//$sql = $this->SQL();

		$sql = $this->GetSQL($filter, "");
		$conn = &$this->Connection();
		$rs = $conn->Execute($sql);
		return $rs;
	}

	// Load row values from recordset
	function LoadListRowValues(&$rs) {
		$this->datang_id->setDbValue($rs->fields('datang_id'));
		$this->datang_tgl->setDbValue($rs->fields('datang_tgl'));
		$this->datang_sumber->setDbValue($rs->fields('datang_sumber'));
		$this->k_id->setDbValue($rs->fields('k_id'));
		$this->sup_id->setDbValue($rs->fields('sup_id'));
		$this->po_id->setDbValue($rs->fields('po_id'));
		$this->var_id->setDbValue($rs->fields('var_id'));
		$this->datang_jumlah->setDbValue($rs->fields('datang_jumlah'));
		$this->datang_terpakai->setDbValue($rs->fields('datang_terpakai'));
	}

	// Render list row values
	function RenderListRow() {
		global $Security, $gsLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

	// Common render codes
		// datang_id
		// datang_tgl
		// datang_sumber
		// k_id
		// sup_id
		// po_id
		// var_id
		// datang_jumlah
		// datang_terpakai
		// datang_id

		$this->datang_id->ViewValue = $this->datang_id->CurrentValue;
		$this->datang_id->ViewCustomAttributes = "";

		// datang_tgl
		$this->datang_tgl->ViewValue = $this->datang_tgl->CurrentValue;
		$this->datang_tgl->ViewValue = ew_FormatDateTime($this->datang_tgl->ViewValue, 0);
		$this->datang_tgl->ViewCustomAttributes = "";

		// datang_sumber
		if (strval($this->datang_sumber->CurrentValue) <> "") {
			$sFilterWrk = "`ds_id`" . ew_SearchString("=", $this->datang_sumber->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `ds_id`, `ds_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `datang_sumber`";
		$sWhereWrk = "";
		$this->datang_sumber->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->datang_sumber, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `ds_id` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->datang_sumber->ViewValue = $this->datang_sumber->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->datang_sumber->ViewValue = $this->datang_sumber->CurrentValue;
			}
		} else {
			$this->datang_sumber->ViewValue = NULL;
		}
		$this->datang_sumber->ViewCustomAttributes = "";

		// k_id
		if ($this->k_id->VirtualValue <> "") {
			$this->k_id->ViewValue = $this->k_id->VirtualValue;
		} else {
			$this->k_id->ViewValue = $this->k_id->CurrentValue;
		if (strval($this->k_id->CurrentValue) <> "") {
			$sFilterWrk = "`k_id`" . ew_SearchString("=", $this->k_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `k_id`, `k_id_kontrak` AS `DispFld`, `k_tgl_tanam` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kontrak`";
		$sWhereWrk = "";
		$this->k_id->LookupFilters = array("df2" => "5");
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->k_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `k_id` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = ew_FormatDateTime($rswrk->fields('Disp2Fld'), 5);
				$this->k_id->ViewValue = $this->k_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->k_id->ViewValue = $this->k_id->CurrentValue;
			}
		} else {
			$this->k_id->ViewValue = NULL;
		}
		}
		$this->k_id->ViewCustomAttributes = "";

		// sup_id
		$this->sup_id->ViewValue = $this->sup_id->CurrentValue;
		if (strval($this->sup_id->CurrentValue) <> "") {
			$sFilterWrk = "`sup_id`" . ew_SearchString("=", $this->sup_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `sup_id`, `sup_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `suplaiyer_ubi`";
		$sWhereWrk = "";
		$this->sup_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->sup_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `sup_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->sup_id->ViewValue = $this->sup_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->sup_id->ViewValue = $this->sup_id->CurrentValue;
			}
		} else {
			$this->sup_id->ViewValue = NULL;
		}
		$this->sup_id->ViewCustomAttributes = "";

		// po_id
		if ($this->po_id->VirtualValue <> "") {
			$this->po_id->ViewValue = $this->po_id->VirtualValue;
		} else {
			$this->po_id->ViewValue = $this->po_id->CurrentValue;
		if (strval($this->po_id->CurrentValue) <> "") {
			$sFilterWrk = "`po_id`" . ew_SearchString("=", $this->po_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `po_id`, `po_id` AS `DispFld`, `po_tanggal` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `po`";
		$sWhereWrk = "";
		$this->po_id->LookupFilters = array("df2" => "2");
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->po_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `po_id` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = ew_FormatDateTime($rswrk->fields('Disp2Fld'), 2);
				$this->po_id->ViewValue = $this->po_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->po_id->ViewValue = $this->po_id->CurrentValue;
			}
		} else {
			$this->po_id->ViewValue = NULL;
		}
		}
		$this->po_id->ViewCustomAttributes = "";

		// var_id
		if (strval($this->var_id->CurrentValue) <> "") {
			$sFilterWrk = "`var_id`" . ew_SearchString("=", $this->var_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `var_id`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `varietas`";
		$sWhereWrk = "";
		$this->var_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->var_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `var_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->var_id->ViewValue = $this->var_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->var_id->ViewValue = $this->var_id->CurrentValue;
			}
		} else {
			$this->var_id->ViewValue = NULL;
		}
		$this->var_id->ViewCustomAttributes = "";

		// datang_jumlah
		$this->datang_jumlah->ViewValue = $this->datang_jumlah->CurrentValue;
		$this->datang_jumlah->ViewCustomAttributes = "";

		// datang_terpakai
		$this->datang_terpakai->ViewValue = $this->datang_terpakai->CurrentValue;
		$this->datang_terpakai->ViewCustomAttributes = "";

		// datang_id
		$this->datang_id->LinkCustomAttributes = "";
		$this->datang_id->HrefValue = "";
		$this->datang_id->TooltipValue = "";

		// datang_tgl
		$this->datang_tgl->LinkCustomAttributes = "";
		$this->datang_tgl->HrefValue = "";
		$this->datang_tgl->TooltipValue = "";

		// datang_sumber
		$this->datang_sumber->LinkCustomAttributes = "";
		$this->datang_sumber->HrefValue = "";
		$this->datang_sumber->TooltipValue = "";

		// k_id
		$this->k_id->LinkCustomAttributes = "";
		$this->k_id->HrefValue = "";
		$this->k_id->TooltipValue = "";

		// sup_id
		$this->sup_id->LinkCustomAttributes = "";
		$this->sup_id->HrefValue = "";
		$this->sup_id->TooltipValue = "";

		// po_id
		$this->po_id->LinkCustomAttributes = "";
		$this->po_id->HrefValue = "";
		$this->po_id->TooltipValue = "";

		// var_id
		$this->var_id->LinkCustomAttributes = "";
		$this->var_id->HrefValue = "";
		$this->var_id->TooltipValue = "";

		// datang_jumlah
		$this->datang_jumlah->LinkCustomAttributes = "";
		$this->datang_jumlah->HrefValue = "";
		$this->datang_jumlah->TooltipValue = "";

		// datang_terpakai
		$this->datang_terpakai->LinkCustomAttributes = "";
		$this->datang_terpakai->HrefValue = "";
		$this->datang_terpakai->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->CustomTemplateFieldValues();
	}

	// Render edit row values
	function RenderEditRow() {
		global $Security, $gsLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// datang_id
		$this->datang_id->EditAttrs["class"] = "form-control";
		$this->datang_id->EditCustomAttributes = "";
		$this->datang_id->EditValue = $this->datang_id->CurrentValue;
		$this->datang_id->ViewCustomAttributes = "";

		// datang_tgl
		$this->datang_tgl->EditAttrs["class"] = "form-control";
		$this->datang_tgl->EditCustomAttributes = "";
		$this->datang_tgl->EditValue = ew_FormatDateTime($this->datang_tgl->CurrentValue, 8);
		$this->datang_tgl->PlaceHolder = ew_RemoveHtml($this->datang_tgl->FldCaption());

		// datang_sumber
		$this->datang_sumber->EditCustomAttributes = "";

		// k_id
		$this->k_id->EditAttrs["class"] = "form-control";
		$this->k_id->EditCustomAttributes = "";
		$this->k_id->EditValue = $this->k_id->CurrentValue;
		$this->k_id->PlaceHolder = ew_RemoveHtml($this->k_id->FldCaption());

		// sup_id
		$this->sup_id->EditAttrs["class"] = "form-control";
		$this->sup_id->EditCustomAttributes = "";
		$this->sup_id->EditValue = $this->sup_id->CurrentValue;
		$this->sup_id->PlaceHolder = ew_RemoveHtml($this->sup_id->FldCaption());

		// po_id
		$this->po_id->EditAttrs["class"] = "form-control";
		$this->po_id->EditCustomAttributes = "";
		$this->po_id->EditValue = $this->po_id->CurrentValue;
		$this->po_id->PlaceHolder = ew_RemoveHtml($this->po_id->FldCaption());

		// var_id
		$this->var_id->EditAttrs["class"] = "form-control";
		$this->var_id->EditCustomAttributes = "";

		// datang_jumlah
		$this->datang_jumlah->EditAttrs["class"] = "form-control";
		$this->datang_jumlah->EditCustomAttributes = "";
		$this->datang_jumlah->EditValue = $this->datang_jumlah->CurrentValue;
		$this->datang_jumlah->PlaceHolder = ew_RemoveHtml($this->datang_jumlah->FldCaption());

		// datang_terpakai
		$this->datang_terpakai->EditAttrs["class"] = "form-control";
		$this->datang_terpakai->EditCustomAttributes = "";
		$this->datang_terpakai->EditValue = $this->datang_terpakai->CurrentValue;
		$this->datang_terpakai->PlaceHolder = ew_RemoveHtml($this->datang_terpakai->FldCaption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	function AggregateListRowValues() {
	}

	// Aggregate list row (for rendering)
	function AggregateListRow() {

		// Call Row Rendered event
		$this->Row_Rendered();
	}
	var $ExportDoc;

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	function ExportDocument(&$Doc, &$Recordset, $StartRec, $StopRec, $ExportPageType = "") {
		if (!$Recordset || !$Doc)
			return;
		if (!$Doc->ExportCustom) {

			// Write header
			$Doc->ExportTableHeader();
			if ($Doc->Horizontal) { // Horizontal format, write header
				$Doc->BeginExportRow();
				if ($ExportPageType == "view") {
					if ($this->datang_id->Exportable) $Doc->ExportCaption($this->datang_id);
					if ($this->datang_tgl->Exportable) $Doc->ExportCaption($this->datang_tgl);
					if ($this->datang_sumber->Exportable) $Doc->ExportCaption($this->datang_sumber);
					if ($this->k_id->Exportable) $Doc->ExportCaption($this->k_id);
					if ($this->sup_id->Exportable) $Doc->ExportCaption($this->sup_id);
					if ($this->po_id->Exportable) $Doc->ExportCaption($this->po_id);
					if ($this->var_id->Exportable) $Doc->ExportCaption($this->var_id);
					if ($this->datang_jumlah->Exportable) $Doc->ExportCaption($this->datang_jumlah);
					if ($this->datang_terpakai->Exportable) $Doc->ExportCaption($this->datang_terpakai);
				} else {
					if ($this->datang_id->Exportable) $Doc->ExportCaption($this->datang_id);
					if ($this->datang_tgl->Exportable) $Doc->ExportCaption($this->datang_tgl);
					if ($this->datang_sumber->Exportable) $Doc->ExportCaption($this->datang_sumber);
					if ($this->k_id->Exportable) $Doc->ExportCaption($this->k_id);
					if ($this->sup_id->Exportable) $Doc->ExportCaption($this->sup_id);
					if ($this->po_id->Exportable) $Doc->ExportCaption($this->po_id);
					if ($this->var_id->Exportable) $Doc->ExportCaption($this->var_id);
					if ($this->datang_jumlah->Exportable) $Doc->ExportCaption($this->datang_jumlah);
					if ($this->datang_terpakai->Exportable) $Doc->ExportCaption($this->datang_terpakai);
				}
				$Doc->EndExportRow();
			}
		}

		// Move to first record
		$RecCnt = $StartRec - 1;
		if (!$Recordset->EOF) {
			$Recordset->MoveFirst();
			if ($StartRec > 1)
				$Recordset->Move($StartRec - 1);
		}
		while (!$Recordset->EOF && $RecCnt < $StopRec) {
			$RecCnt++;
			if (intval($RecCnt) >= intval($StartRec)) {
				$RowCnt = intval($RecCnt) - intval($StartRec) + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($RowCnt > 1 && ($RowCnt - 1) % $this->ExportPageBreakCount == 0)
						$Doc->ExportPageBreak();
				}
				$this->LoadListRowValues($Recordset);

				// Render row
				$this->RowType = EW_ROWTYPE_VIEW; // Render view
				$this->ResetAttrs();
				$this->RenderListRow();
				if (!$Doc->ExportCustom) {
					$Doc->BeginExportRow($RowCnt); // Allow CSS styles if enabled
					if ($ExportPageType == "view") {
						if ($this->datang_id->Exportable) $Doc->ExportField($this->datang_id);
						if ($this->datang_tgl->Exportable) $Doc->ExportField($this->datang_tgl);
						if ($this->datang_sumber->Exportable) $Doc->ExportField($this->datang_sumber);
						if ($this->k_id->Exportable) $Doc->ExportField($this->k_id);
						if ($this->sup_id->Exportable) $Doc->ExportField($this->sup_id);
						if ($this->po_id->Exportable) $Doc->ExportField($this->po_id);
						if ($this->var_id->Exportable) $Doc->ExportField($this->var_id);
						if ($this->datang_jumlah->Exportable) $Doc->ExportField($this->datang_jumlah);
						if ($this->datang_terpakai->Exportable) $Doc->ExportField($this->datang_terpakai);
					} else {
						if ($this->datang_id->Exportable) $Doc->ExportField($this->datang_id);
						if ($this->datang_tgl->Exportable) $Doc->ExportField($this->datang_tgl);
						if ($this->datang_sumber->Exportable) $Doc->ExportField($this->datang_sumber);
						if ($this->k_id->Exportable) $Doc->ExportField($this->k_id);
						if ($this->sup_id->Exportable) $Doc->ExportField($this->sup_id);
						if ($this->po_id->Exportable) $Doc->ExportField($this->po_id);
						if ($this->var_id->Exportable) $Doc->ExportField($this->var_id);
						if ($this->datang_jumlah->Exportable) $Doc->ExportField($this->datang_jumlah);
						if ($this->datang_terpakai->Exportable) $Doc->ExportField($this->datang_terpakai);
					}
					$Doc->EndExportRow($RowCnt);
				}
			}

			// Call Row Export server event
			if ($Doc->ExportCustom)
				$this->Row_Export($Recordset->fields);
			$Recordset->MoveNext();
		}
		if (!$Doc->ExportCustom) {
			$Doc->ExportTableFooter();
		}
	}

	// Get auto fill value
	function GetAutoFill($id, $val) {
		$rsarr = array();
		$rowcnt = 0;

		// Output
		if (is_array($rsarr) && $rowcnt > 0) {
			$fldcnt = count($rsarr[0]);
			for ($i = 0; $i < $rowcnt; $i++) {
				for ($j = 0; $j < $fldcnt; $j++) {
					$str = strval($rsarr[$i][$j]);
					$str = ew_ConvertToUtf8($str);
					if (isset($post["keepCRLF"])) {
						$str = str_replace(array("\r", "\n"), array("\\r", "\\n"), $str);
					} else {
						$str = str_replace(array("\r", "\n"), array(" ", " "), $str);
					}
					$rsarr[$i][$j] = $str;
				}
			}
			return ew_ArrayToJson($rsarr);
		} else {
			return FALSE;
		}
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending(&$Email, &$Args) {

		//var_dump($Email); var_dump($Args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->FldName, $fld->LookupFilters, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>
