<?php
if (session_id() == "") session_start(); // Init session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg14.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql14.php") ?>
<?php include_once "phpfn14.php" ?>
<?php include_once "kedatanganinfo.php" ?>
<?php include_once "employeesinfo.php" ?>
<?php include_once "userfn14.php" ?>
<?php

//
// Page class
//

$kedatangan_add = NULL; // Initialize page object first

class ckedatangan_add extends ckedatangan {

	// Page ID
	var $PageID = 'add';

	// Project ID
	var $ProjectID = '{CC60B42B-604B-412A-B014-2315920AF6AA}';

	// Table name
	var $TableName = 'kedatangan';

	// Page object name
	var $PageObjName = 'kedatangan_add';

	// Page headings
	var $Heading = '';
	var $Subheading = '';

	// Page heading
	function PageHeading() {
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->TableCaption();
		return "";
	}

	// Page subheading
	function PageSubheading() {
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->Phrase($this->PageID);
		return "";
	}

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (kedatangan)
		if (!isset($GLOBALS["kedatangan"]) || get_class($GLOBALS["kedatangan"]) == "ckedatangan") {
			$GLOBALS["kedatangan"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["kedatangan"];
		}

		// Table object (employees)
		if (!isset($GLOBALS['employees'])) $GLOBALS['employees'] = new cemployees();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'add', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'kedatangan', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"]))
			$GLOBALS["gTimer"] = new cTimer();

		// Debug message
		ew_LoadDebugMsg();

		// Open connection
		if (!isset($conn))
			$conn = ew_Connect($this->DBID);

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new cemployees();
			$UserTableConn = Conn($UserTable->DBID);
		}
	}

	//
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Is modal
		$this->IsModal = (@$_GET["modal"] == "1" || @$_POST["modal"] == "1");

		// User profile
		$UserProfile = new cUserProfile();

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanAdd()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			if ($Security->CanList())
				$this->Page_Terminate(ew_GetUrl("kedatanganlist.php"));
			else
				$this->Page_Terminate(ew_GetUrl("login.php"));
		}

		// NOTE: Security object may be needed in other part of the script, skip set to Nothing
		// 
		// Security = null;
		// 
		// Create form object

		$objForm = new cFormObj();
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action
		$this->datang_id->SetVisibility();
		$this->datang_tgl->SetVisibility();
		$this->datang_sumber->SetVisibility();
		$this->k_id->SetVisibility();
		$this->sup_id->SetVisibility();
		$this->po_id->SetVisibility();
		$this->var_id->SetVisibility();
		$this->datang_jumlah->SetVisibility();
		$this->datang_terpakai->SetVisibility();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $kedatangan;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($kedatangan);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		// Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = ew_GetPageName($url);
				if ($pageName != $this->GetListUrl()) { // Not List page
					$row["caption"] = $this->GetModalCaption($pageName);
					if ($pageName == "kedatanganview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				header("Content-Type: application/json; charset=utf-8");
				echo ew_ConvertToUtf8(ew_ArrayToJson(array($row)));
			} else {
				ew_SaveDebugMsg();
				header("Location: " . $url);
			}
		}
		exit();
	}
	var $FormClassName = "form-horizontal ewForm ewAddForm";
	var $IsModal = FALSE;
	var $IsMobileOrModal = FALSE;
	var $DbMasterFilter = "";
	var $DbDetailFilter = "";
	var $StartRec;
	var $Priv = 0;
	var $OldRecordset;
	var $CopyRecord;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError;
		global $gbSkipHeaderFooter;

		// Check modal
		if ($this->IsModal)
			$gbSkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = ew_IsMobile() || $this->IsModal;
		$this->FormClassName = "ewForm ewAddForm form-horizontal";

		// Set up current action
		if (@$_POST["a_add"] <> "") {
			$this->CurrentAction = $_POST["a_add"]; // Get form action
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (@$_GET["datang_id"] != "") {
				$this->datang_id->setQueryStringValue($_GET["datang_id"]);
				$this->setKey("datang_id", $this->datang_id->CurrentValue); // Set up key
			} else {
				$this->setKey("datang_id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "C"; // Copy record
			} else {
				$this->CurrentAction = "I"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->LoadOldRecord();

		// Load form values
		if (@$_POST["a_add"] <> "") {
			$this->LoadFormValues(); // Load form values
		}

		// Validate form if post back
		if (@$_POST["a_add"] <> "") {
			if (!$this->ValidateForm()) {
				$this->CurrentAction = "I"; // Form error, reset action
				$this->EventCancelled = TRUE; // Event cancelled
				$this->RestoreFormValues(); // Restore form values
				$this->setFailureMessage($gsFormError);
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "I": // Blank record
				break;
			case "C": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "") $this->setFailureMessage($Language->Phrase("NoRecord")); // No record found
					$this->Page_Terminate("kedatanganlist.php"); // No matching record, return to list
				}
				break;
			case "A": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->AddRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->Phrase("AddSuccess")); // Set up success message
					$sReturnUrl = $this->getReturnUrl();
					if (ew_GetPageName($sReturnUrl) == "kedatanganlist.php")
						$sReturnUrl = $this->AddMasterUrl($sReturnUrl); // List page, return to List page with correct master key if necessary
					elseif (ew_GetPageName($sReturnUrl) == "kedatanganview.php")
						$sReturnUrl = $this->GetViewUrl(); // View page, return to View page with keyurl directly
					$this->Page_Terminate($sReturnUrl); // Clean up and return
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->RestoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->SetupBreadcrumb();

		// Render row based on row type
		$this->RowType = EW_ROWTYPE_ADD; // Render add type

		// Render row
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Get upload files
	function GetUploadFiles() {
		global $objForm, $Language;

		// Get upload data
	}

	// Load default values
	function LoadDefaultValues() {
		$this->datang_id->CurrentValue = NULL;
		$this->datang_id->OldValue = $this->datang_id->CurrentValue;
		$this->datang_tgl->CurrentValue = NULL;
		$this->datang_tgl->OldValue = $this->datang_tgl->CurrentValue;
		$this->datang_sumber->CurrentValue = NULL;
		$this->datang_sumber->OldValue = $this->datang_sumber->CurrentValue;
		$this->k_id->CurrentValue = NULL;
		$this->k_id->OldValue = $this->k_id->CurrentValue;
		$this->sup_id->CurrentValue = NULL;
		$this->sup_id->OldValue = $this->sup_id->CurrentValue;
		$this->po_id->CurrentValue = NULL;
		$this->po_id->OldValue = $this->po_id->CurrentValue;
		$this->var_id->CurrentValue = NULL;
		$this->var_id->OldValue = $this->var_id->CurrentValue;
		$this->datang_jumlah->CurrentValue = NULL;
		$this->datang_jumlah->OldValue = $this->datang_jumlah->CurrentValue;
		$this->datang_terpakai->CurrentValue = NULL;
		$this->datang_terpakai->OldValue = $this->datang_terpakai->CurrentValue;
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm;
		if (!$this->datang_id->FldIsDetailKey) {
			$this->datang_id->setFormValue($objForm->GetValue("x_datang_id"));
		}
		if (!$this->datang_tgl->FldIsDetailKey) {
			$this->datang_tgl->setFormValue($objForm->GetValue("x_datang_tgl"));
			$this->datang_tgl->CurrentValue = ew_UnFormatDateTime($this->datang_tgl->CurrentValue, 0);
		}
		if (!$this->datang_sumber->FldIsDetailKey) {
			$this->datang_sumber->setFormValue($objForm->GetValue("x_datang_sumber"));
		}
		if (!$this->k_id->FldIsDetailKey) {
			$this->k_id->setFormValue($objForm->GetValue("x_k_id"));
		}
		if (!$this->sup_id->FldIsDetailKey) {
			$this->sup_id->setFormValue($objForm->GetValue("x_sup_id"));
		}
		if (!$this->po_id->FldIsDetailKey) {
			$this->po_id->setFormValue($objForm->GetValue("x_po_id"));
		}
		if (!$this->var_id->FldIsDetailKey) {
			$this->var_id->setFormValue($objForm->GetValue("x_var_id"));
		}
		if (!$this->datang_jumlah->FldIsDetailKey) {
			$this->datang_jumlah->setFormValue($objForm->GetValue("x_datang_jumlah"));
		}
		if (!$this->datang_terpakai->FldIsDetailKey) {
			$this->datang_terpakai->setFormValue($objForm->GetValue("x_datang_terpakai"));
		}
	}

	// Restore form values
	function RestoreFormValues() {
		global $objForm;
		$this->datang_id->CurrentValue = $this->datang_id->FormValue;
		$this->datang_tgl->CurrentValue = $this->datang_tgl->FormValue;
		$this->datang_tgl->CurrentValue = ew_UnFormatDateTime($this->datang_tgl->CurrentValue, 0);
		$this->datang_sumber->CurrentValue = $this->datang_sumber->FormValue;
		$this->k_id->CurrentValue = $this->k_id->FormValue;
		$this->sup_id->CurrentValue = $this->sup_id->FormValue;
		$this->po_id->CurrentValue = $this->po_id->FormValue;
		$this->var_id->CurrentValue = $this->var_id->FormValue;
		$this->datang_jumlah->CurrentValue = $this->datang_jumlah->FormValue;
		$this->datang_terpakai->CurrentValue = $this->datang_terpakai->FormValue;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues($rs = NULL) {
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->NewRow(); 

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->datang_id->setDbValue($row['datang_id']);
		$this->datang_tgl->setDbValue($row['datang_tgl']);
		$this->datang_sumber->setDbValue($row['datang_sumber']);
		$this->k_id->setDbValue($row['k_id']);
		if (array_key_exists('EV__k_id', $rs->fields)) {
			$this->k_id->VirtualValue = $rs->fields('EV__k_id'); // Set up virtual field value
		} else {
			$this->k_id->VirtualValue = ""; // Clear value
		}
		$this->sup_id->setDbValue($row['sup_id']);
		$this->po_id->setDbValue($row['po_id']);
		if (array_key_exists('EV__po_id', $rs->fields)) {
			$this->po_id->VirtualValue = $rs->fields('EV__po_id'); // Set up virtual field value
		} else {
			$this->po_id->VirtualValue = ""; // Clear value
		}
		$this->var_id->setDbValue($row['var_id']);
		$this->datang_jumlah->setDbValue($row['datang_jumlah']);
		$this->datang_terpakai->setDbValue($row['datang_terpakai']);
	}

	// Return a row with default values
	function NewRow() {
		$this->LoadDefaultValues();
		$row = array();
		$row['datang_id'] = $this->datang_id->CurrentValue;
		$row['datang_tgl'] = $this->datang_tgl->CurrentValue;
		$row['datang_sumber'] = $this->datang_sumber->CurrentValue;
		$row['k_id'] = $this->k_id->CurrentValue;
		$row['sup_id'] = $this->sup_id->CurrentValue;
		$row['po_id'] = $this->po_id->CurrentValue;
		$row['var_id'] = $this->var_id->CurrentValue;
		$row['datang_jumlah'] = $this->datang_jumlah->CurrentValue;
		$row['datang_terpakai'] = $this->datang_terpakai->CurrentValue;
		return $row;
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->datang_id->DbValue = $row['datang_id'];
		$this->datang_tgl->DbValue = $row['datang_tgl'];
		$this->datang_sumber->DbValue = $row['datang_sumber'];
		$this->k_id->DbValue = $row['k_id'];
		$this->sup_id->DbValue = $row['sup_id'];
		$this->po_id->DbValue = $row['po_id'];
		$this->var_id->DbValue = $row['var_id'];
		$this->datang_jumlah->DbValue = $row['datang_jumlah'];
		$this->datang_terpakai->DbValue = $row['datang_terpakai'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("datang_id")) <> "")
			$this->datang_id->CurrentValue = $this->getKey("datang_id"); // datang_id
		else
			$bValidKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
		}
		$this->LoadRowValues($this->OldRecordset); // Load row values
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// datang_id
		// datang_tgl
		// datang_sumber
		// k_id
		// sup_id
		// po_id
		// var_id
		// datang_jumlah
		// datang_terpakai

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// datang_id
		$this->datang_id->ViewValue = $this->datang_id->CurrentValue;
		$this->datang_id->ViewCustomAttributes = "";

		// datang_tgl
		$this->datang_tgl->ViewValue = $this->datang_tgl->CurrentValue;
		$this->datang_tgl->ViewValue = ew_FormatDateTime($this->datang_tgl->ViewValue, 0);
		$this->datang_tgl->ViewCustomAttributes = "";

		// datang_sumber
		if (strval($this->datang_sumber->CurrentValue) <> "") {
			$sFilterWrk = "`ds_id`" . ew_SearchString("=", $this->datang_sumber->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `ds_id`, `ds_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `datang_sumber`";
		$sWhereWrk = "";
		$this->datang_sumber->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->datang_sumber, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `ds_id` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->datang_sumber->ViewValue = $this->datang_sumber->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->datang_sumber->ViewValue = $this->datang_sumber->CurrentValue;
			}
		} else {
			$this->datang_sumber->ViewValue = NULL;
		}
		$this->datang_sumber->ViewCustomAttributes = "";

		// k_id
		if ($this->k_id->VirtualValue <> "") {
			$this->k_id->ViewValue = $this->k_id->VirtualValue;
		} else {
			$this->k_id->ViewValue = $this->k_id->CurrentValue;
		if (strval($this->k_id->CurrentValue) <> "") {
			$sFilterWrk = "`k_id`" . ew_SearchString("=", $this->k_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `k_id`, `k_id_kontrak` AS `DispFld`, `k_tgl_tanam` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kontrak`";
		$sWhereWrk = "";
		$this->k_id->LookupFilters = array("df2" => "5");
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->k_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `k_id` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = ew_FormatDateTime($rswrk->fields('Disp2Fld'), 5);
				$this->k_id->ViewValue = $this->k_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->k_id->ViewValue = $this->k_id->CurrentValue;
			}
		} else {
			$this->k_id->ViewValue = NULL;
		}
		}
		$this->k_id->ViewCustomAttributes = "";

		// sup_id
		$this->sup_id->ViewValue = $this->sup_id->CurrentValue;
		if (strval($this->sup_id->CurrentValue) <> "") {
			$sFilterWrk = "`sup_id`" . ew_SearchString("=", $this->sup_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `sup_id`, `sup_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `suplaiyer_ubi`";
		$sWhereWrk = "";
		$this->sup_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->sup_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `sup_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->sup_id->ViewValue = $this->sup_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->sup_id->ViewValue = $this->sup_id->CurrentValue;
			}
		} else {
			$this->sup_id->ViewValue = NULL;
		}
		$this->sup_id->ViewCustomAttributes = "";

		// po_id
		if ($this->po_id->VirtualValue <> "") {
			$this->po_id->ViewValue = $this->po_id->VirtualValue;
		} else {
			$this->po_id->ViewValue = $this->po_id->CurrentValue;
		if (strval($this->po_id->CurrentValue) <> "") {
			$sFilterWrk = "`po_id`" . ew_SearchString("=", $this->po_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `po_id`, `po_id` AS `DispFld`, `po_tanggal` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `po`";
		$sWhereWrk = "";
		$this->po_id->LookupFilters = array("df2" => "2");
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->po_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `po_id` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = ew_FormatDateTime($rswrk->fields('Disp2Fld'), 2);
				$this->po_id->ViewValue = $this->po_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->po_id->ViewValue = $this->po_id->CurrentValue;
			}
		} else {
			$this->po_id->ViewValue = NULL;
		}
		}
		$this->po_id->ViewCustomAttributes = "";

		// var_id
		if (strval($this->var_id->CurrentValue) <> "") {
			$sFilterWrk = "`var_id`" . ew_SearchString("=", $this->var_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `var_id`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `varietas`";
		$sWhereWrk = "";
		$this->var_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->var_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `var_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->var_id->ViewValue = $this->var_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->var_id->ViewValue = $this->var_id->CurrentValue;
			}
		} else {
			$this->var_id->ViewValue = NULL;
		}
		$this->var_id->ViewCustomAttributes = "";

		// datang_jumlah
		$this->datang_jumlah->ViewValue = $this->datang_jumlah->CurrentValue;
		$this->datang_jumlah->ViewCustomAttributes = "";

		// datang_terpakai
		$this->datang_terpakai->ViewValue = $this->datang_terpakai->CurrentValue;
		$this->datang_terpakai->ViewCustomAttributes = "";

			// datang_id
			$this->datang_id->LinkCustomAttributes = "";
			$this->datang_id->HrefValue = "";
			$this->datang_id->TooltipValue = "";

			// datang_tgl
			$this->datang_tgl->LinkCustomAttributes = "";
			$this->datang_tgl->HrefValue = "";
			$this->datang_tgl->TooltipValue = "";

			// datang_sumber
			$this->datang_sumber->LinkCustomAttributes = "";
			$this->datang_sumber->HrefValue = "";
			$this->datang_sumber->TooltipValue = "";

			// k_id
			$this->k_id->LinkCustomAttributes = "";
			$this->k_id->HrefValue = "";
			$this->k_id->TooltipValue = "";

			// sup_id
			$this->sup_id->LinkCustomAttributes = "";
			$this->sup_id->HrefValue = "";
			$this->sup_id->TooltipValue = "";

			// po_id
			$this->po_id->LinkCustomAttributes = "";
			$this->po_id->HrefValue = "";
			$this->po_id->TooltipValue = "";

			// var_id
			$this->var_id->LinkCustomAttributes = "";
			$this->var_id->HrefValue = "";
			$this->var_id->TooltipValue = "";

			// datang_jumlah
			$this->datang_jumlah->LinkCustomAttributes = "";
			$this->datang_jumlah->HrefValue = "";
			$this->datang_jumlah->TooltipValue = "";

			// datang_terpakai
			$this->datang_terpakai->LinkCustomAttributes = "";
			$this->datang_terpakai->HrefValue = "";
			$this->datang_terpakai->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_ADD) { // Add row

			// datang_id
			$this->datang_id->EditAttrs["class"] = "form-control";
			$this->datang_id->EditCustomAttributes = "";
			$this->datang_id->EditValue = ew_HtmlEncode($this->datang_id->CurrentValue);
			$this->datang_id->PlaceHolder = ew_RemoveHtml($this->datang_id->FldCaption());

			// datang_tgl
			$this->datang_tgl->EditAttrs["class"] = "form-control";
			$this->datang_tgl->EditCustomAttributes = "";
			$this->datang_tgl->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->datang_tgl->CurrentValue, 8));
			$this->datang_tgl->PlaceHolder = ew_RemoveHtml($this->datang_tgl->FldCaption());

			// datang_sumber
			$this->datang_sumber->EditCustomAttributes = "";
			if (trim(strval($this->datang_sumber->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`ds_id`" . ew_SearchString("=", $this->datang_sumber->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `ds_id`, `ds_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `datang_sumber`";
			$sWhereWrk = "";
			$this->datang_sumber->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->datang_sumber, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `ds_id` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->datang_sumber->EditValue = $arwrk;

			// k_id
			$this->k_id->EditAttrs["class"] = "form-control";
			$this->k_id->EditCustomAttributes = "";
			$this->k_id->EditValue = ew_HtmlEncode($this->k_id->CurrentValue);
			$this->k_id->PlaceHolder = ew_RemoveHtml($this->k_id->FldCaption());

			// sup_id
			$this->sup_id->EditAttrs["class"] = "form-control";
			$this->sup_id->EditCustomAttributes = "";
			$this->sup_id->EditValue = ew_HtmlEncode($this->sup_id->CurrentValue);
			if (strval($this->sup_id->CurrentValue) <> "") {
				$sFilterWrk = "`sup_id`" . ew_SearchString("=", $this->sup_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			$sSqlWrk = "SELECT `sup_id`, `sup_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `suplaiyer_ubi`";
			$sWhereWrk = "";
			$this->sup_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->sup_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `sup_nama` ASC";
				$rswrk = Conn()->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = ew_HtmlEncode($rswrk->fields('DispFld'));
					$this->sup_id->EditValue = $this->sup_id->DisplayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->sup_id->EditValue = ew_HtmlEncode($this->sup_id->CurrentValue);
				}
			} else {
				$this->sup_id->EditValue = NULL;
			}
			$this->sup_id->PlaceHolder = ew_RemoveHtml($this->sup_id->FldCaption());

			// po_id
			$this->po_id->EditAttrs["class"] = "form-control";
			$this->po_id->EditCustomAttributes = "";
			$this->po_id->EditValue = ew_HtmlEncode($this->po_id->CurrentValue);
			$this->po_id->PlaceHolder = ew_RemoveHtml($this->po_id->FldCaption());

			// var_id
			$this->var_id->EditAttrs["class"] = "form-control";
			$this->var_id->EditCustomAttributes = "";
			if (trim(strval($this->var_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`var_id`" . ew_SearchString("=", $this->var_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `var_id`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `varietas`";
			$sWhereWrk = "";
			$this->var_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->var_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `var_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->var_id->EditValue = $arwrk;

			// datang_jumlah
			$this->datang_jumlah->EditAttrs["class"] = "form-control";
			$this->datang_jumlah->EditCustomAttributes = "";
			$this->datang_jumlah->EditValue = ew_HtmlEncode($this->datang_jumlah->CurrentValue);
			$this->datang_jumlah->PlaceHolder = ew_RemoveHtml($this->datang_jumlah->FldCaption());

			// datang_terpakai
			$this->datang_terpakai->EditAttrs["class"] = "form-control";
			$this->datang_terpakai->EditCustomAttributes = "";
			$this->datang_terpakai->EditValue = ew_HtmlEncode($this->datang_terpakai->CurrentValue);
			$this->datang_terpakai->PlaceHolder = ew_RemoveHtml($this->datang_terpakai->FldCaption());

			// Add refer script
			// datang_id

			$this->datang_id->LinkCustomAttributes = "";
			$this->datang_id->HrefValue = "";

			// datang_tgl
			$this->datang_tgl->LinkCustomAttributes = "";
			$this->datang_tgl->HrefValue = "";

			// datang_sumber
			$this->datang_sumber->LinkCustomAttributes = "";
			$this->datang_sumber->HrefValue = "";

			// k_id
			$this->k_id->LinkCustomAttributes = "";
			$this->k_id->HrefValue = "";

			// sup_id
			$this->sup_id->LinkCustomAttributes = "";
			$this->sup_id->HrefValue = "";

			// po_id
			$this->po_id->LinkCustomAttributes = "";
			$this->po_id->HrefValue = "";

			// var_id
			$this->var_id->LinkCustomAttributes = "";
			$this->var_id->HrefValue = "";

			// datang_jumlah
			$this->datang_jumlah->LinkCustomAttributes = "";
			$this->datang_jumlah->HrefValue = "";

			// datang_terpakai
			$this->datang_terpakai->LinkCustomAttributes = "";
			$this->datang_terpakai->HrefValue = "";
		}
		if ($this->RowType == EW_ROWTYPE_ADD || $this->RowType == EW_ROWTYPE_EDIT || $this->RowType == EW_ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->SetupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $Language, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return ($gsFormError == "");
		if (!$this->datang_id->FldIsDetailKey && !is_null($this->datang_id->FormValue) && $this->datang_id->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->datang_id->FldCaption(), $this->datang_id->ReqErrMsg));
		}
		if (!ew_CheckInteger($this->datang_id->FormValue)) {
			ew_AddMessage($gsFormError, $this->datang_id->FldErrMsg());
		}
		if (!$this->datang_tgl->FldIsDetailKey && !is_null($this->datang_tgl->FormValue) && $this->datang_tgl->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->datang_tgl->FldCaption(), $this->datang_tgl->ReqErrMsg));
		}
		if (!ew_CheckDateDef($this->datang_tgl->FormValue)) {
			ew_AddMessage($gsFormError, $this->datang_tgl->FldErrMsg());
		}
		if ($this->datang_sumber->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->datang_sumber->FldCaption(), $this->datang_sumber->ReqErrMsg));
		}
		if (!ew_CheckInteger($this->sup_id->FormValue)) {
			ew_AddMessage($gsFormError, $this->sup_id->FldErrMsg());
		}
		if (!$this->var_id->FldIsDetailKey && !is_null($this->var_id->FormValue) && $this->var_id->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->var_id->FldCaption(), $this->var_id->ReqErrMsg));
		}
		if (!$this->datang_jumlah->FldIsDetailKey && !is_null($this->datang_jumlah->FormValue) && $this->datang_jumlah->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->datang_jumlah->FldCaption(), $this->datang_jumlah->ReqErrMsg));
		}
		if (!ew_CheckInteger($this->datang_jumlah->FormValue)) {
			ew_AddMessage($gsFormError, $this->datang_jumlah->FldErrMsg());
		}
		if (!ew_CheckInteger($this->datang_terpakai->FormValue)) {
			ew_AddMessage($gsFormError, $this->datang_terpakai->FldErrMsg());
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsFormError, $sFormCustomError);
		}
		return $ValidateForm;
	}

	// Add record
	function AddRow($rsold = NULL) {
		global $Language, $Security;
		if ($this->datang_id->CurrentValue <> "") { // Check field with unique index
			$sFilter = "(datang_id = " . ew_AdjustSql($this->datang_id->CurrentValue, $this->DBID) . ")";
			$rsChk = $this->LoadRs($sFilter);
			if ($rsChk && !$rsChk->EOF) {
				$sIdxErrMsg = str_replace("%f", $this->datang_id->FldCaption(), $Language->Phrase("DupIndex"));
				$sIdxErrMsg = str_replace("%v", $this->datang_id->CurrentValue, $sIdxErrMsg);
				$this->setFailureMessage($sIdxErrMsg);
				$rsChk->Close();
				return FALSE;
			}
		}
		$conn = &$this->Connection();

		// Load db values from rsold
		$this->LoadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = array();

		// datang_id
		$this->datang_id->SetDbValueDef($rsnew, $this->datang_id->CurrentValue, 0, FALSE);

		// datang_tgl
		$this->datang_tgl->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->datang_tgl->CurrentValue, 0), NULL, FALSE);

		// datang_sumber
		$this->datang_sumber->SetDbValueDef($rsnew, $this->datang_sumber->CurrentValue, NULL, FALSE);

		// k_id
		$this->k_id->SetDbValueDef($rsnew, $this->k_id->CurrentValue, NULL, FALSE);

		// sup_id
		$this->sup_id->SetDbValueDef($rsnew, $this->sup_id->CurrentValue, NULL, FALSE);

		// po_id
		$this->po_id->SetDbValueDef($rsnew, $this->po_id->CurrentValue, NULL, FALSE);

		// var_id
		$this->var_id->SetDbValueDef($rsnew, $this->var_id->CurrentValue, NULL, FALSE);

		// datang_jumlah
		$this->datang_jumlah->SetDbValueDef($rsnew, $this->datang_jumlah->CurrentValue, NULL, FALSE);

		// datang_terpakai
		$this->datang_terpakai->SetDbValueDef($rsnew, $this->datang_terpakai->CurrentValue, NULL, FALSE);

		// Call Row Inserting event
		$rs = ($rsold == NULL) ? NULL : $rsold->fields;
		$bInsertRow = $this->Row_Inserting($rs, $rsnew);

		// Check if key value entered
		if ($bInsertRow && $this->ValidateKey && strval($rsnew['datang_id']) == "") {
			$this->setFailureMessage($Language->Phrase("InvalidKeyValue"));
			$bInsertRow = FALSE;
		}

		// Check for duplicate key
		if ($bInsertRow && $this->ValidateKey) {
			$sFilter = $this->KeyFilter();
			$rsChk = $this->LoadRs($sFilter);
			if ($rsChk && !$rsChk->EOF) {
				$sKeyErrMsg = str_replace("%f", $sFilter, $Language->Phrase("DupKey"));
				$this->setFailureMessage($sKeyErrMsg);
				$rsChk->Close();
				$bInsertRow = FALSE;
			}
		}
		if ($bInsertRow) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			$AddRow = $this->Insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($AddRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->Phrase("InsertCancelled"));
			}
			$AddRow = FALSE;
		}
		if ($AddRow) {

			// Call Row Inserted event
			$rs = ($rsold == NULL) ? NULL : $rsold->fields;
			$this->Row_Inserted($rs, $rsnew);
		}
		return $AddRow;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$Breadcrumb->Add("list", $this->TableVar, $this->AddMasterUrl("kedatanganlist.php"), "", $this->TableVar, TRUE);
		$PageId = ($this->CurrentAction == "C") ? "Copy" : "Add";
		$Breadcrumb->Add("add", $PageId, $url);
	}

	// Setup lookup filters of a field
	function SetupLookupFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		case "x_datang_sumber":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `ds_id` AS `LinkFld`, `ds_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `datang_sumber`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`ds_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->datang_sumber, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `ds_id` DESC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_k_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `k_id` AS `LinkFld`, `k_id_kontrak` AS `DispFld`, `k_tgl_tanam` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kontrak`";
			$sWhereWrk = "{filter}";
			$fld->LookupFilters = array("df2" => "5");
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`k_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->k_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `k_id` DESC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_sup_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `sup_id` AS `LinkFld`, `sup_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `suplaiyer_ubi`";
			$sWhereWrk = "{filter}";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`sup_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->sup_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `sup_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_po_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `po_id` AS `LinkFld`, `po_id` AS `DispFld`, `po_tanggal` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `po`";
			$sWhereWrk = "{filter}";
			$fld->LookupFilters = array("df2" => "2");
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`po_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->po_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `po_id` DESC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_var_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `var_id` AS `LinkFld`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `varietas`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`var_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->var_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `var_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		}
	}

	// Setup AutoSuggest filters of a field
	function SetupAutoSuggestFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		case "x_k_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `k_id`, `k_id_kontrak` AS `DispFld`, `k_tgl_tanam` AS `Disp2Fld` FROM `kontrak`";
			$sWhereWrk = "`k_id_kontrak` LIKE '{query_value}%' OR CONCAT(COALESCE(`k_id_kontrak`, ''),'" . ew_ValueSeparator(1, $this->k_id) . "',COALESCE(" . ew_CastDateFieldForLike('`k_tgl_tanam`', 5, "DB") . ",'')) LIKE '{query_value}%'";
			$fld->LookupFilters = array("df2" => "5");
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->k_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `k_id` DESC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_sup_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `sup_id`, `sup_nama` AS `DispFld` FROM `suplaiyer_ubi`";
			$sWhereWrk = "`sup_nama` LIKE '{query_value}%'";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->sup_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `sup_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_po_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `po_id`, `po_id` AS `DispFld`, `po_tanggal` AS `Disp2Fld` FROM `po`";
			$sWhereWrk = "`po_id` LIKE '{query_value}%' OR CONCAT(COALESCE(`po_id`, ''),'" . ew_ValueSeparator(1, $this->po_id) . "',COALESCE(" . ew_CastDateFieldForLike('`po_tanggal`', 2, "DB") . ",'')) LIKE '{query_value}%'";
			$fld->LookupFilters = array("df2" => "2");
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->po_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `po_id` DESC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($kedatangan_add)) $kedatangan_add = new ckedatangan_add();

// Page init
$kedatangan_add->Page_Init();

// Page main
$kedatangan_add->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$kedatangan_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "add";
var CurrentForm = fkedatanganadd = new ew_Form("fkedatanganadd", "add");

// Validate form
fkedatanganadd.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);
	if ($fobj.find("#a_confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.FormKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = $fobj.find("#a_list").val() == "gridinsert";
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
			elm = this.GetElements("x" + infix + "_datang_id");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $kedatangan->datang_id->FldCaption(), $kedatangan->datang_id->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_datang_id");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($kedatangan->datang_id->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_datang_tgl");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $kedatangan->datang_tgl->FldCaption(), $kedatangan->datang_tgl->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_datang_tgl");
			if (elm && !ew_CheckDateDef(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($kedatangan->datang_tgl->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_datang_sumber");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $kedatangan->datang_sumber->FldCaption(), $kedatangan->datang_sumber->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_sup_id");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($kedatangan->sup_id->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_var_id");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $kedatangan->var_id->FldCaption(), $kedatangan->var_id->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_datang_jumlah");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $kedatangan->datang_jumlah->FldCaption(), $kedatangan->datang_jumlah->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_datang_jumlah");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($kedatangan->datang_jumlah->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_datang_terpakai");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($kedatangan->datang_terpakai->FldErrMsg()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ewForms[val])
			if (!ewForms[val].Validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fkedatanganadd.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fkedatanganadd.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fkedatanganadd.Lists["x_datang_sumber"] = {"LinkField":"x_ds_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_ds_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"datang_sumber"};
fkedatanganadd.Lists["x_datang_sumber"].Data = "<?php echo $kedatangan_add->datang_sumber->LookupFilterQuery(FALSE, "add") ?>";
fkedatanganadd.Lists["x_k_id"] = {"LinkField":"x_k_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_k_id_kontrak","x_k_tgl_tanam","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kontrak"};
fkedatanganadd.Lists["x_k_id"].Data = "<?php echo $kedatangan_add->k_id->LookupFilterQuery(FALSE, "add") ?>";
fkedatanganadd.AutoSuggests["x_k_id"] = <?php echo json_encode(array("data" => "ajax=autosuggest&" . $kedatangan_add->k_id->LookupFilterQuery(TRUE, "add"))) ?>;
fkedatanganadd.Lists["x_sup_id"] = {"LinkField":"x_sup_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_sup_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"suplaiyer_ubi"};
fkedatanganadd.Lists["x_sup_id"].Data = "<?php echo $kedatangan_add->sup_id->LookupFilterQuery(FALSE, "add") ?>";
fkedatanganadd.AutoSuggests["x_sup_id"] = <?php echo json_encode(array("data" => "ajax=autosuggest&" . $kedatangan_add->sup_id->LookupFilterQuery(TRUE, "add"))) ?>;
fkedatanganadd.Lists["x_po_id"] = {"LinkField":"x_po_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_po_id","x_po_tanggal","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"po"};
fkedatanganadd.Lists["x_po_id"].Data = "<?php echo $kedatangan_add->po_id->LookupFilterQuery(FALSE, "add") ?>";
fkedatanganadd.AutoSuggests["x_po_id"] = <?php echo json_encode(array("data" => "ajax=autosuggest&" . $kedatangan_add->po_id->LookupFilterQuery(TRUE, "add"))) ?>;
fkedatanganadd.Lists["x_var_id"] = {"LinkField":"x_var_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_var_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"varietas"};
fkedatanganadd.Lists["x_var_id"].Data = "<?php echo $kedatangan_add->var_id->LookupFilterQuery(FALSE, "add") ?>";

// Form object for search
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php $kedatangan_add->ShowPageHeader(); ?>
<?php
$kedatangan_add->ShowMessage();
?>
<form name="fkedatanganadd" id="fkedatanganadd" class="<?php echo $kedatangan_add->FormClassName ?>" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($kedatangan_add->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $kedatangan_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="kedatangan">
<input type="hidden" name="a_add" id="a_add" value="A">
<input type="hidden" name="modal" value="<?php echo intval($kedatangan_add->IsModal) ?>">
<div class="ewAddDiv"><!-- page* -->
<?php if ($kedatangan->datang_id->Visible) { // datang_id ?>
	<div id="r_datang_id" class="form-group">
		<label id="elh_kedatangan_datang_id" for="x_datang_id" class="<?php echo $kedatangan_add->LeftColumnClass ?>"><?php echo $kedatangan->datang_id->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $kedatangan_add->RightColumnClass ?>"><div<?php echo $kedatangan->datang_id->CellAttributes() ?>>
<span id="el_kedatangan_datang_id">
<input type="text" data-table="kedatangan" data-field="x_datang_id" name="x_datang_id" id="x_datang_id" placeholder="<?php echo ew_HtmlEncode($kedatangan->datang_id->getPlaceHolder()) ?>" value="<?php echo $kedatangan->datang_id->EditValue ?>"<?php echo $kedatangan->datang_id->EditAttributes() ?>>
</span>
<?php echo $kedatangan->datang_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kedatangan->datang_tgl->Visible) { // datang_tgl ?>
	<div id="r_datang_tgl" class="form-group">
		<label id="elh_kedatangan_datang_tgl" for="x_datang_tgl" class="<?php echo $kedatangan_add->LeftColumnClass ?>"><?php echo $kedatangan->datang_tgl->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $kedatangan_add->RightColumnClass ?>"><div<?php echo $kedatangan->datang_tgl->CellAttributes() ?>>
<span id="el_kedatangan_datang_tgl">
<input type="text" data-table="kedatangan" data-field="x_datang_tgl" name="x_datang_tgl" id="x_datang_tgl" placeholder="<?php echo ew_HtmlEncode($kedatangan->datang_tgl->getPlaceHolder()) ?>" value="<?php echo $kedatangan->datang_tgl->EditValue ?>"<?php echo $kedatangan->datang_tgl->EditAttributes() ?>>
<?php if (!$kedatangan->datang_tgl->ReadOnly && !$kedatangan->datang_tgl->Disabled && !isset($kedatangan->datang_tgl->EditAttrs["readonly"]) && !isset($kedatangan->datang_tgl->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("fkedatanganadd", "x_datang_tgl", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $kedatangan->datang_tgl->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kedatangan->datang_sumber->Visible) { // datang_sumber ?>
	<div id="r_datang_sumber" class="form-group">
		<label id="elh_kedatangan_datang_sumber" class="<?php echo $kedatangan_add->LeftColumnClass ?>"><?php echo $kedatangan->datang_sumber->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $kedatangan_add->RightColumnClass ?>"><div<?php echo $kedatangan->datang_sumber->CellAttributes() ?>>
<span id="el_kedatangan_datang_sumber">
<div id="tp_x_datang_sumber" class="ewTemplate"><input type="radio" data-table="kedatangan" data-field="x_datang_sumber" data-value-separator="<?php echo $kedatangan->datang_sumber->DisplayValueSeparatorAttribute() ?>" name="x_datang_sumber" id="x_datang_sumber" value="{value}"<?php echo $kedatangan->datang_sumber->EditAttributes() ?>></div>
<div id="dsl_x_datang_sumber" data-repeatcolumn="5" class="ewItemList" style="display: none;"><div>
<?php echo $kedatangan->datang_sumber->RadioButtonListHtml(FALSE, "x_datang_sumber") ?>
</div></div>
</span>
<?php echo $kedatangan->datang_sumber->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kedatangan->k_id->Visible) { // k_id ?>
	<div id="r_k_id" class="form-group">
		<label id="elh_kedatangan_k_id" class="<?php echo $kedatangan_add->LeftColumnClass ?>"><?php echo $kedatangan->k_id->FldCaption() ?></label>
		<div class="<?php echo $kedatangan_add->RightColumnClass ?>"><div<?php echo $kedatangan->k_id->CellAttributes() ?>>
<span id="el_kedatangan_k_id">
<?php
$wrkonchange = trim(" " . @$kedatangan->k_id->EditAttrs["onchange"]);
if ($wrkonchange <> "") $wrkonchange = " onchange=\"" . ew_JsEncode2($wrkonchange) . "\"";
$kedatangan->k_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_k_id" style="white-space: nowrap; z-index: 8960">
	<input type="text" name="sv_x_k_id" id="sv_x_k_id" value="<?php echo $kedatangan->k_id->EditValue ?>" size="30" placeholder="<?php echo ew_HtmlEncode($kedatangan->k_id->getPlaceHolder()) ?>" data-placeholder="<?php echo ew_HtmlEncode($kedatangan->k_id->getPlaceHolder()) ?>"<?php echo $kedatangan->k_id->EditAttributes() ?>>
</span>
<input type="hidden" data-table="kedatangan" data-field="x_k_id" data-value-separator="<?php echo $kedatangan->k_id->DisplayValueSeparatorAttribute() ?>" name="x_k_id" id="x_k_id" value="<?php echo ew_HtmlEncode($kedatangan->k_id->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script type="text/javascript">
fkedatanganadd.CreateAutoSuggest({"id":"x_k_id","forceSelect":false});
</script>
</span>
<?php echo $kedatangan->k_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kedatangan->sup_id->Visible) { // sup_id ?>
	<div id="r_sup_id" class="form-group">
		<label id="elh_kedatangan_sup_id" class="<?php echo $kedatangan_add->LeftColumnClass ?>"><?php echo $kedatangan->sup_id->FldCaption() ?></label>
		<div class="<?php echo $kedatangan_add->RightColumnClass ?>"><div<?php echo $kedatangan->sup_id->CellAttributes() ?>>
<span id="el_kedatangan_sup_id">
<?php
$wrkonchange = trim(" " . @$kedatangan->sup_id->EditAttrs["onchange"]);
if ($wrkonchange <> "") $wrkonchange = " onchange=\"" . ew_JsEncode2($wrkonchange) . "\"";
$kedatangan->sup_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_sup_id" style="white-space: nowrap; z-index: 8950">
	<input type="text" name="sv_x_sup_id" id="sv_x_sup_id" value="<?php echo $kedatangan->sup_id->EditValue ?>" size="30" placeholder="<?php echo ew_HtmlEncode($kedatangan->sup_id->getPlaceHolder()) ?>" data-placeholder="<?php echo ew_HtmlEncode($kedatangan->sup_id->getPlaceHolder()) ?>"<?php echo $kedatangan->sup_id->EditAttributes() ?>>
</span>
<input type="hidden" data-table="kedatangan" data-field="x_sup_id" data-value-separator="<?php echo $kedatangan->sup_id->DisplayValueSeparatorAttribute() ?>" name="x_sup_id" id="x_sup_id" value="<?php echo ew_HtmlEncode($kedatangan->sup_id->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script type="text/javascript">
fkedatanganadd.CreateAutoSuggest({"id":"x_sup_id","forceSelect":false});
</script>
</span>
<?php echo $kedatangan->sup_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kedatangan->po_id->Visible) { // po_id ?>
	<div id="r_po_id" class="form-group">
		<label id="elh_kedatangan_po_id" class="<?php echo $kedatangan_add->LeftColumnClass ?>"><?php echo $kedatangan->po_id->FldCaption() ?></label>
		<div class="<?php echo $kedatangan_add->RightColumnClass ?>"><div<?php echo $kedatangan->po_id->CellAttributes() ?>>
<span id="el_kedatangan_po_id">
<?php
$wrkonchange = trim(" " . @$kedatangan->po_id->EditAttrs["onchange"]);
if ($wrkonchange <> "") $wrkonchange = " onchange=\"" . ew_JsEncode2($wrkonchange) . "\"";
$kedatangan->po_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_po_id" style="white-space: nowrap; z-index: 8940">
	<input type="text" name="sv_x_po_id" id="sv_x_po_id" value="<?php echo $kedatangan->po_id->EditValue ?>" size="30" placeholder="<?php echo ew_HtmlEncode($kedatangan->po_id->getPlaceHolder()) ?>" data-placeholder="<?php echo ew_HtmlEncode($kedatangan->po_id->getPlaceHolder()) ?>"<?php echo $kedatangan->po_id->EditAttributes() ?>>
</span>
<input type="hidden" data-table="kedatangan" data-field="x_po_id" data-value-separator="<?php echo $kedatangan->po_id->DisplayValueSeparatorAttribute() ?>" name="x_po_id" id="x_po_id" value="<?php echo ew_HtmlEncode($kedatangan->po_id->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script type="text/javascript">
fkedatanganadd.CreateAutoSuggest({"id":"x_po_id","forceSelect":false});
</script>
<?php if (AllowAdd(CurrentProjectID() . "po") && !$kedatangan->po_id->ReadOnly) { ?>
<button type="button" title="<?php echo ew_HtmlTitle($Language->Phrase("AddLink")) . "&nbsp;" . $kedatangan->po_id->FldCaption() ?>" onclick="ew_AddOptDialogShow({lnk:this,el:'x_po_id',url:'poaddopt.php'});" class="ewAddOptBtn btn btn-default btn-sm" id="aol_x_po_id"><span class="glyphicon glyphicon-plus ewIcon"></span><span class="hide"><?php echo $Language->Phrase("AddLink") ?>&nbsp;<?php echo $kedatangan->po_id->FldCaption() ?></span></button>
<?php } ?>
</span>
<?php echo $kedatangan->po_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kedatangan->var_id->Visible) { // var_id ?>
	<div id="r_var_id" class="form-group">
		<label id="elh_kedatangan_var_id" for="x_var_id" class="<?php echo $kedatangan_add->LeftColumnClass ?>"><?php echo $kedatangan->var_id->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $kedatangan_add->RightColumnClass ?>"><div<?php echo $kedatangan->var_id->CellAttributes() ?>>
<span id="el_kedatangan_var_id">
<select data-table="kedatangan" data-field="x_var_id" data-value-separator="<?php echo $kedatangan->var_id->DisplayValueSeparatorAttribute() ?>" id="x_var_id" name="x_var_id"<?php echo $kedatangan->var_id->EditAttributes() ?>>
<?php echo $kedatangan->var_id->SelectOptionListHtml("x_var_id") ?>
</select>
</span>
<?php echo $kedatangan->var_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kedatangan->datang_jumlah->Visible) { // datang_jumlah ?>
	<div id="r_datang_jumlah" class="form-group">
		<label id="elh_kedatangan_datang_jumlah" for="x_datang_jumlah" class="<?php echo $kedatangan_add->LeftColumnClass ?>"><?php echo $kedatangan->datang_jumlah->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $kedatangan_add->RightColumnClass ?>"><div<?php echo $kedatangan->datang_jumlah->CellAttributes() ?>>
<span id="el_kedatangan_datang_jumlah">
<input type="text" data-table="kedatangan" data-field="x_datang_jumlah" name="x_datang_jumlah" id="x_datang_jumlah" size="30" placeholder="<?php echo ew_HtmlEncode($kedatangan->datang_jumlah->getPlaceHolder()) ?>" value="<?php echo $kedatangan->datang_jumlah->EditValue ?>"<?php echo $kedatangan->datang_jumlah->EditAttributes() ?>>
</span>
<?php echo $kedatangan->datang_jumlah->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kedatangan->datang_terpakai->Visible) { // datang_terpakai ?>
	<div id="r_datang_terpakai" class="form-group">
		<label id="elh_kedatangan_datang_terpakai" for="x_datang_terpakai" class="<?php echo $kedatangan_add->LeftColumnClass ?>"><?php echo $kedatangan->datang_terpakai->FldCaption() ?></label>
		<div class="<?php echo $kedatangan_add->RightColumnClass ?>"><div<?php echo $kedatangan->datang_terpakai->CellAttributes() ?>>
<span id="el_kedatangan_datang_terpakai">
<input type="text" data-table="kedatangan" data-field="x_datang_terpakai" name="x_datang_terpakai" id="x_datang_terpakai" size="30" placeholder="<?php echo ew_HtmlEncode($kedatangan->datang_terpakai->getPlaceHolder()) ?>" value="<?php echo $kedatangan->datang_terpakai->EditValue ?>"<?php echo $kedatangan->datang_terpakai->EditAttributes() ?>>
</span>
<?php echo $kedatangan->datang_terpakai->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$kedatangan_add->IsModal) { ?>
<div class="form-group"><!-- buttons .form-group -->
	<div class="<?php echo $kedatangan_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ewButton" name="btnAction" id="btnAction" type="submit"><?php echo $Language->Phrase("AddBtn") ?></button>
<button class="btn btn-default ewButton" name="btnCancel" id="btnCancel" type="button" data-href="<?php echo $kedatangan_add->getReturnUrl() ?>"><?php echo $Language->Phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<script type="text/javascript">
fkedatanganadd.Init();
</script>
<?php
$kedatangan_add->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$kedatangan_add->Page_Terminate();
?>
