<?php
if (session_id() == "") session_start(); // Init session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg14.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql14.php") ?>
<?php include_once "phpfn14.php" ?>
<?php include_once "bibitinfo.php" ?>
<?php include_once "employeesinfo.php" ?>
<?php include_once "userfn14.php" ?>
<?php

//
// Page class
//

$bibit_list = NULL; // Initialize page object first

class cbibit_list extends cbibit {

	// Page ID
	var $PageID = 'list';

	// Project ID
	var $ProjectID = '{CC60B42B-604B-412A-B014-2315920AF6AA}';

	// Table name
	var $TableName = 'bibit';

	// Page object name
	var $PageObjName = 'bibit_list';

	// Grid form hidden field names
	var $FormName = 'fbibitlist';
	var $FormActionName = 'k_action';
	var $FormKeyName = 'k_key';
	var $FormOldKeyName = 'k_oldkey';
	var $FormBlankRowName = 'k_blankrow';
	var $FormKeyCountName = 'key_count';

	// Page headings
	var $Heading = '';
	var $Subheading = '';

	// Page heading
	function PageHeading() {
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->TableCaption();
		return "";
	}

	// Page subheading
	function PageSubheading() {
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->Phrase($this->PageID);
		return "";
	}

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;
	var $ExportPdfUrl;

	// Custom export
	var $ExportExcelCustom = FALSE;
	var $ExportWordCustom = FALSE;
	var $ExportPdfCustom = FALSE;
	var $ExportEmailCustom = FALSE;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (bibit)
		if (!isset($GLOBALS["bibit"]) || get_class($GLOBALS["bibit"]) == "cbibit") {
			$GLOBALS["bibit"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["bibit"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->PageUrl() . "export=print";
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel";
		$this->ExportWordUrl = $this->PageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->PageUrl() . "export=html";
		$this->ExportXmlUrl = $this->PageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->PageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf";
		$this->AddUrl = "bibitadd.php";
		$this->InlineAddUrl = $this->PageUrl() . "a=add";
		$this->GridAddUrl = $this->PageUrl() . "a=gridadd";
		$this->GridEditUrl = $this->PageUrl() . "a=gridedit";
		$this->MultiDeleteUrl = "bibitdelete.php";
		$this->MultiUpdateUrl = "bibitupdate.php";

		// Table object (employees)
		if (!isset($GLOBALS['employees'])) $GLOBALS['employees'] = new cemployees();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'list', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'bibit', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"]))
			$GLOBALS["gTimer"] = new cTimer();

		// Debug message
		ew_LoadDebugMsg();

		// Open connection
		if (!isset($conn))
			$conn = ew_Connect($this->DBID);

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new cemployees();
			$UserTableConn = Conn($UserTable->DBID);
		}

		// List options
		$this->ListOptions = new cListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new cListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Other options
		$this->OtherOptions['addedit'] = new cListOptions();
		$this->OtherOptions['addedit']->Tag = "div";
		$this->OtherOptions['addedit']->TagClassName = "ewAddEditOption";
		$this->OtherOptions['detail'] = new cListOptions();
		$this->OtherOptions['detail']->Tag = "div";
		$this->OtherOptions['detail']->TagClassName = "ewDetailOption";
		$this->OtherOptions['action'] = new cListOptions();
		$this->OtherOptions['action']->Tag = "div";
		$this->OtherOptions['action']->TagClassName = "ewActionOption";

		// Filter options
		$this->FilterOptions = new cListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ewFilterOption fbibitlistsrch";

		// List actions
		$this->ListActions = new cListActions();
	}

	//
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// User profile
		$UserProfile = new cUserProfile();

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanList()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			$this->Page_Terminate(ew_GetUrl("index.php"));
		}

		// NOTE: Security object may be needed in other part of the script, skip set to Nothing
		// 
		// Security = null;
		// 
		// Get export parameters

		$custom = "";
		if (@$_GET["export"] <> "") {
			$this->Export = $_GET["export"];
			$custom = @$_GET["custom"];
		} elseif (@$_POST["export"] <> "") {
			$this->Export = $_POST["export"];
			$custom = @$_POST["custom"];
		} elseif (ew_IsPost()) {
			if (@$_POST["exporttype"] <> "")
				$this->Export = $_POST["exporttype"];
			$custom = @$_POST["custom"];
		} elseif (@$_GET["cmd"] == "json") {
			$this->Export = $_GET["cmd"];
		} else {
			$this->setExportReturnUrl(ew_CurrentUrl());
		}
		$gsExportFile = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->Export <> "" && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$gsCustomExport = $this->CustomExport;
		$gsExport = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined("EW_USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined("EW_USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action

		// Get grid add count
		$gridaddcnt = @$_GET[EW_TABLE_GRID_ADD_ROW_COUNT];
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->SetupListOptions();

		// Setup export options
		$this->SetupExportOptions();
		$this->id->SetVisibility();
		if ($this->IsAdd() || $this->IsCopy() || $this->IsGridAdd())
			$this->id->Visible = FALSE;
		$this->tgl_tanam->SetVisibility();
		$this->jumlah_tanam->SetVisibility();
		$this->jumlah_panen_stek->SetVisibility();
		$this->ket->SetVisibility();
		$this->var_nama->SetVisibility();
		$this->id_gen->SetVisibility();
		$this->k_id_kontrak->SetVisibility();
		$this->co_nama->SetVisibility();
		$this->koord_nama->SetVisibility();
		$this->pet_nama->SetVisibility();
		$this->prov_nama->SetVisibility();
		$this->kab_nama->SetVisibility();
		$this->kec_nama->SetVisibility();
		$this->desa_nama->SetVisibility();
		$this->id_asal_bibit->SetVisibility();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();

		// Setup other options
		$this->SetupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->Add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == EW_ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $bibit;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($bibit);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		// Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			ew_SaveDebugMsg();
			header("Location: " . $url);
		}
		exit();
	}

	// Class variables
	var $ListOptions; // List options
	var $ExportOptions; // Export options
	var $SearchOptions; // Search options
	var $OtherOptions = array(); // Other options
	var $FilterOptions; // Filter options
	var $ListActions; // List actions
	var $SelectedCount = 0;
	var $SelectedIndex = 0;
	var $DisplayRecs = 100;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $Pager;
	var $AutoHidePager = EW_AUTO_HIDE_PAGER;
	var $AutoHidePageSizeSelector = EW_AUTO_HIDE_PAGE_SIZE_SELECTOR;
	var $DefaultSearchWhere = ""; // Default search WHERE clause
	var $SearchWhere = ""; // Search WHERE clause
	var $RecCnt = 0; // Record count
	var $EditRowCnt;
	var $StartRowCnt = 1;
	var $RowCnt = 0;
	var $Attrs = array(); // Row attributes and cell attributes
	var $RowIndex = 0; // Row index
	var $KeyCount = 0; // Key count
	var $RowAction = ""; // Row action
	var $RowOldKey = ""; // Row old key (for copy)
	var $RecPerRow = 0;
	var $MultiColumnClass;
	var $MultiColumnEditClass = "col-sm-12";
	var $MultiColumnCnt = 12;
	var $MultiColumnEditCnt = 12;
	var $GridCnt = 0;
	var $ColCnt = 0;
	var $DbMasterFilter = ""; // Master filter
	var $DbDetailFilter = ""; // Detail filter
	var $MasterRecordExists;
	var $MultiSelectKey;
	var $Command;
	var $RestoreSearch = FALSE;
	var $DetailPages;
	var $Recordset;
	var $OldRecordset;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError, $gsSearchError, $Security, $EW_EXPORT;

		// Search filters
		$sSrchAdvanced = ""; // Advanced search filter
		$sSrchBasic = ""; // Basic search filter
		$sFilter = "";

		// Get command
		$this->Command = strtolower(@$_GET["cmd"]);
		if ($this->IsPageRequest()) { // Validate request

			// Process list action first
			if ($this->ProcessListAction()) // Ajax request
				$this->Page_Terminate();

			// Handle reset command
			$this->ResetCmd();

			// Set up Breadcrumb
			if ($this->Export == "")
				$this->SetupBreadcrumb();

			// Hide list options
			if ($this->Export <> "") {
				$this->ListOptions->HideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->CurrentAction == "gridadd" || $this->CurrentAction == "gridedit") {
				$this->ListOptions->HideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->Export <> "" || $this->CurrentAction <> "") {
				$this->ExportOptions->HideAllOptions();
				$this->FilterOptions->HideAllOptions();
			}

			// Hide other options
			if ($this->Export <> "") {
				foreach ($this->OtherOptions as &$option)
					$option->HideAllOptions();
			}

			// Get default search criteria
			ew_AddFilter($this->DefaultSearchWhere, $this->BasicSearchWhere(TRUE));
			ew_AddFilter($this->DefaultSearchWhere, $this->AdvancedSearchWhere(TRUE));

			// Get basic search values
			$this->LoadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->LoadSearchValues(); // Get search values

			// Process filter list
			$this->ProcessFilterList();
			if (!$this->ValidateSearch())
				$this->setFailureMessage($gsSearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->Export <> "" || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->CheckSearchParms())
				$this->RestoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->SetupSortOrder();

			// Get basic search criteria
			if ($gsSearchError == "")
				$sSrchBasic = $this->BasicSearchWhere();

			// Get search criteria for advanced search
			if ($gsSearchError == "")
				$sSrchAdvanced = $this->AdvancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 100; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->LoadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->CheckSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->LoadDefault();
			if ($this->BasicSearch->Keyword != "")
				$sSrchBasic = $this->BasicSearchWhere();

			// Load advanced search from default
			if ($this->LoadAdvancedSearchDefault()) {
				$sSrchAdvanced = $this->AdvancedSearchWhere();
			}
		}

		// Build search criteria
		ew_AddFilter($this->SearchWhere, $sSrchAdvanced);
		ew_AddFilter($this->SearchWhere, $sSrchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$sFilter = "";
		if (!$Security->CanList())
			$sFilter = "(0=1)"; // Filter all records
		ew_AddFilter($sFilter, $this->DbDetailFilter);
		ew_AddFilter($sFilter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSQL = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $sFilter;
		} else {
			$this->setSessionWhere($sFilter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if ($this->CustomExport == "" && in_array($this->Export, array_keys($EW_EXPORT))) {
			$this->ExportData();
			$this->Page_Terminate(); // Terminate response
			exit();
		}

		// Load record count first
		if (!$this->IsAddOrEdit()) {
			$bSelectLimit = $this->UseSelectLimit;
			if ($bSelectLimit) {
				$this->TotalRecs = $this->ListRecordCount();
			} else {
				if ($this->Recordset = $this->LoadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
		}

		// Search options
		$this->SetupSearchOptions();
	}

	// Build filter for all keys
	function BuildKeyFilter() {
		global $objForm;
		$sWrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$objForm->Index = $rowindex;
		$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		while ($sThisKey <> "") {
			if ($this->SetupKeyValues($sThisKey)) {
				$sFilter = $this->KeyFilter();
				if ($sWrkFilter <> "") $sWrkFilter .= " OR ";
				$sWrkFilter .= $sFilter;
			} else {
				$sWrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$objForm->Index = $rowindex;
			$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		}
		return $sWrkFilter;
	}

	// Set up key values
	function SetupKeyValues($key) {
		$arrKeyFlds = explode($GLOBALS["EW_COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arrKeyFlds) >= 1) {
			$this->id->setFormValue($arrKeyFlds[0]);
			if (!is_numeric($this->id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	function GetFilterList() {
		global $UserProfile;

		// Initialize
		$sFilterList = "";
		$sSavedFilterList = "";
		$sFilterList = ew_Concat($sFilterList, $this->id->AdvancedSearch->ToJson(), ","); // Field id
		$sFilterList = ew_Concat($sFilterList, $this->tgl_tanam->AdvancedSearch->ToJson(), ","); // Field tgl_tanam
		$sFilterList = ew_Concat($sFilterList, $this->jumlah_tanam->AdvancedSearch->ToJson(), ","); // Field jumlah_tanam
		$sFilterList = ew_Concat($sFilterList, $this->jumlah_panen_stek->AdvancedSearch->ToJson(), ","); // Field jumlah_panen_stek
		$sFilterList = ew_Concat($sFilterList, $this->ket->AdvancedSearch->ToJson(), ","); // Field ket
		$sFilterList = ew_Concat($sFilterList, $this->var_nama->AdvancedSearch->ToJson(), ","); // Field var_nama
		$sFilterList = ew_Concat($sFilterList, $this->id_gen->AdvancedSearch->ToJson(), ","); // Field id_gen
		$sFilterList = ew_Concat($sFilterList, $this->k_id_kontrak->AdvancedSearch->ToJson(), ","); // Field k_id_kontrak
		$sFilterList = ew_Concat($sFilterList, $this->co_nama->AdvancedSearch->ToJson(), ","); // Field co_nama
		$sFilterList = ew_Concat($sFilterList, $this->koord_nama->AdvancedSearch->ToJson(), ","); // Field koord_nama
		$sFilterList = ew_Concat($sFilterList, $this->pet_nama->AdvancedSearch->ToJson(), ","); // Field pet_nama
		$sFilterList = ew_Concat($sFilterList, $this->prov_nama->AdvancedSearch->ToJson(), ","); // Field prov_nama
		$sFilterList = ew_Concat($sFilterList, $this->kab_nama->AdvancedSearch->ToJson(), ","); // Field kab_nama
		$sFilterList = ew_Concat($sFilterList, $this->kec_nama->AdvancedSearch->ToJson(), ","); // Field kec_nama
		$sFilterList = ew_Concat($sFilterList, $this->desa_nama->AdvancedSearch->ToJson(), ","); // Field desa_nama
		$sFilterList = ew_Concat($sFilterList, $this->id_asal_bibit->AdvancedSearch->ToJson(), ","); // Field id_asal_bibit
		if ($this->BasicSearch->Keyword <> "") {
			$sWrk = "\"" . EW_TABLE_BASIC_SEARCH . "\":\"" . ew_JsEncode2($this->BasicSearch->Keyword) . "\",\"" . EW_TABLE_BASIC_SEARCH_TYPE . "\":\"" . ew_JsEncode2($this->BasicSearch->Type) . "\"";
			$sFilterList = ew_Concat($sFilterList, $sWrk, ",");
		}
		$sFilterList = preg_replace('/,$/', "", $sFilterList);

		// Return filter list in json
		if ($sFilterList <> "")
			$sFilterList = "\"data\":{" . $sFilterList . "}";
		if ($sSavedFilterList <> "") {
			if ($sFilterList <> "")
				$sFilterList .= ",";
			$sFilterList .= "\"filters\":" . $sSavedFilterList;
		}
		return ($sFilterList <> "") ? "{" . $sFilterList . "}" : "null";
	}

	// Process filter list
	function ProcessFilterList() {
		global $UserProfile;
		if (@$_POST["ajax"] == "savefilters") { // Save filter request (Ajax)
			$filters = @$_POST["filters"];
			$UserProfile->SetSearchFilters(CurrentUserName(), "fbibitlistsrch", $filters);

			// Clean output buffer
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			echo ew_ArrayToJson(array(array("success" => TRUE))); // Success
			$this->Page_Terminate();
			exit();
		} elseif (@$_POST["cmd"] == "resetfilter") {
			$this->RestoreFilterList();
		}
	}

	// Restore list of filters
	function RestoreFilterList() {

		// Return if not reset filter
		if (@$_POST["cmd"] <> "resetfilter")
			return FALSE;
		$filter = json_decode(@$_POST["filter"], TRUE);
		$this->Command = "search";

		// Field id
		$this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
		$this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
		$this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
		$this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
		$this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
		$this->id->AdvancedSearch->Save();

		// Field tgl_tanam
		$this->tgl_tanam->AdvancedSearch->SearchValue = @$filter["x_tgl_tanam"];
		$this->tgl_tanam->AdvancedSearch->SearchOperator = @$filter["z_tgl_tanam"];
		$this->tgl_tanam->AdvancedSearch->SearchCondition = @$filter["v_tgl_tanam"];
		$this->tgl_tanam->AdvancedSearch->SearchValue2 = @$filter["y_tgl_tanam"];
		$this->tgl_tanam->AdvancedSearch->SearchOperator2 = @$filter["w_tgl_tanam"];
		$this->tgl_tanam->AdvancedSearch->Save();

		// Field jumlah_tanam
		$this->jumlah_tanam->AdvancedSearch->SearchValue = @$filter["x_jumlah_tanam"];
		$this->jumlah_tanam->AdvancedSearch->SearchOperator = @$filter["z_jumlah_tanam"];
		$this->jumlah_tanam->AdvancedSearch->SearchCondition = @$filter["v_jumlah_tanam"];
		$this->jumlah_tanam->AdvancedSearch->SearchValue2 = @$filter["y_jumlah_tanam"];
		$this->jumlah_tanam->AdvancedSearch->SearchOperator2 = @$filter["w_jumlah_tanam"];
		$this->jumlah_tanam->AdvancedSearch->Save();

		// Field jumlah_panen_stek
		$this->jumlah_panen_stek->AdvancedSearch->SearchValue = @$filter["x_jumlah_panen_stek"];
		$this->jumlah_panen_stek->AdvancedSearch->SearchOperator = @$filter["z_jumlah_panen_stek"];
		$this->jumlah_panen_stek->AdvancedSearch->SearchCondition = @$filter["v_jumlah_panen_stek"];
		$this->jumlah_panen_stek->AdvancedSearch->SearchValue2 = @$filter["y_jumlah_panen_stek"];
		$this->jumlah_panen_stek->AdvancedSearch->SearchOperator2 = @$filter["w_jumlah_panen_stek"];
		$this->jumlah_panen_stek->AdvancedSearch->Save();

		// Field ket
		$this->ket->AdvancedSearch->SearchValue = @$filter["x_ket"];
		$this->ket->AdvancedSearch->SearchOperator = @$filter["z_ket"];
		$this->ket->AdvancedSearch->SearchCondition = @$filter["v_ket"];
		$this->ket->AdvancedSearch->SearchValue2 = @$filter["y_ket"];
		$this->ket->AdvancedSearch->SearchOperator2 = @$filter["w_ket"];
		$this->ket->AdvancedSearch->Save();

		// Field var_nama
		$this->var_nama->AdvancedSearch->SearchValue = @$filter["x_var_nama"];
		$this->var_nama->AdvancedSearch->SearchOperator = @$filter["z_var_nama"];
		$this->var_nama->AdvancedSearch->SearchCondition = @$filter["v_var_nama"];
		$this->var_nama->AdvancedSearch->SearchValue2 = @$filter["y_var_nama"];
		$this->var_nama->AdvancedSearch->SearchOperator2 = @$filter["w_var_nama"];
		$this->var_nama->AdvancedSearch->Save();

		// Field id_gen
		$this->id_gen->AdvancedSearch->SearchValue = @$filter["x_id_gen"];
		$this->id_gen->AdvancedSearch->SearchOperator = @$filter["z_id_gen"];
		$this->id_gen->AdvancedSearch->SearchCondition = @$filter["v_id_gen"];
		$this->id_gen->AdvancedSearch->SearchValue2 = @$filter["y_id_gen"];
		$this->id_gen->AdvancedSearch->SearchOperator2 = @$filter["w_id_gen"];
		$this->id_gen->AdvancedSearch->Save();

		// Field k_id_kontrak
		$this->k_id_kontrak->AdvancedSearch->SearchValue = @$filter["x_k_id_kontrak"];
		$this->k_id_kontrak->AdvancedSearch->SearchOperator = @$filter["z_k_id_kontrak"];
		$this->k_id_kontrak->AdvancedSearch->SearchCondition = @$filter["v_k_id_kontrak"];
		$this->k_id_kontrak->AdvancedSearch->SearchValue2 = @$filter["y_k_id_kontrak"];
		$this->k_id_kontrak->AdvancedSearch->SearchOperator2 = @$filter["w_k_id_kontrak"];
		$this->k_id_kontrak->AdvancedSearch->Save();

		// Field co_nama
		$this->co_nama->AdvancedSearch->SearchValue = @$filter["x_co_nama"];
		$this->co_nama->AdvancedSearch->SearchOperator = @$filter["z_co_nama"];
		$this->co_nama->AdvancedSearch->SearchCondition = @$filter["v_co_nama"];
		$this->co_nama->AdvancedSearch->SearchValue2 = @$filter["y_co_nama"];
		$this->co_nama->AdvancedSearch->SearchOperator2 = @$filter["w_co_nama"];
		$this->co_nama->AdvancedSearch->Save();

		// Field koord_nama
		$this->koord_nama->AdvancedSearch->SearchValue = @$filter["x_koord_nama"];
		$this->koord_nama->AdvancedSearch->SearchOperator = @$filter["z_koord_nama"];
		$this->koord_nama->AdvancedSearch->SearchCondition = @$filter["v_koord_nama"];
		$this->koord_nama->AdvancedSearch->SearchValue2 = @$filter["y_koord_nama"];
		$this->koord_nama->AdvancedSearch->SearchOperator2 = @$filter["w_koord_nama"];
		$this->koord_nama->AdvancedSearch->Save();

		// Field pet_nama
		$this->pet_nama->AdvancedSearch->SearchValue = @$filter["x_pet_nama"];
		$this->pet_nama->AdvancedSearch->SearchOperator = @$filter["z_pet_nama"];
		$this->pet_nama->AdvancedSearch->SearchCondition = @$filter["v_pet_nama"];
		$this->pet_nama->AdvancedSearch->SearchValue2 = @$filter["y_pet_nama"];
		$this->pet_nama->AdvancedSearch->SearchOperator2 = @$filter["w_pet_nama"];
		$this->pet_nama->AdvancedSearch->Save();

		// Field prov_nama
		$this->prov_nama->AdvancedSearch->SearchValue = @$filter["x_prov_nama"];
		$this->prov_nama->AdvancedSearch->SearchOperator = @$filter["z_prov_nama"];
		$this->prov_nama->AdvancedSearch->SearchCondition = @$filter["v_prov_nama"];
		$this->prov_nama->AdvancedSearch->SearchValue2 = @$filter["y_prov_nama"];
		$this->prov_nama->AdvancedSearch->SearchOperator2 = @$filter["w_prov_nama"];
		$this->prov_nama->AdvancedSearch->Save();

		// Field kab_nama
		$this->kab_nama->AdvancedSearch->SearchValue = @$filter["x_kab_nama"];
		$this->kab_nama->AdvancedSearch->SearchOperator = @$filter["z_kab_nama"];
		$this->kab_nama->AdvancedSearch->SearchCondition = @$filter["v_kab_nama"];
		$this->kab_nama->AdvancedSearch->SearchValue2 = @$filter["y_kab_nama"];
		$this->kab_nama->AdvancedSearch->SearchOperator2 = @$filter["w_kab_nama"];
		$this->kab_nama->AdvancedSearch->Save();

		// Field kec_nama
		$this->kec_nama->AdvancedSearch->SearchValue = @$filter["x_kec_nama"];
		$this->kec_nama->AdvancedSearch->SearchOperator = @$filter["z_kec_nama"];
		$this->kec_nama->AdvancedSearch->SearchCondition = @$filter["v_kec_nama"];
		$this->kec_nama->AdvancedSearch->SearchValue2 = @$filter["y_kec_nama"];
		$this->kec_nama->AdvancedSearch->SearchOperator2 = @$filter["w_kec_nama"];
		$this->kec_nama->AdvancedSearch->Save();

		// Field desa_nama
		$this->desa_nama->AdvancedSearch->SearchValue = @$filter["x_desa_nama"];
		$this->desa_nama->AdvancedSearch->SearchOperator = @$filter["z_desa_nama"];
		$this->desa_nama->AdvancedSearch->SearchCondition = @$filter["v_desa_nama"];
		$this->desa_nama->AdvancedSearch->SearchValue2 = @$filter["y_desa_nama"];
		$this->desa_nama->AdvancedSearch->SearchOperator2 = @$filter["w_desa_nama"];
		$this->desa_nama->AdvancedSearch->Save();

		// Field id_asal_bibit
		$this->id_asal_bibit->AdvancedSearch->SearchValue = @$filter["x_id_asal_bibit"];
		$this->id_asal_bibit->AdvancedSearch->SearchOperator = @$filter["z_id_asal_bibit"];
		$this->id_asal_bibit->AdvancedSearch->SearchCondition = @$filter["v_id_asal_bibit"];
		$this->id_asal_bibit->AdvancedSearch->SearchValue2 = @$filter["y_id_asal_bibit"];
		$this->id_asal_bibit->AdvancedSearch->SearchOperator2 = @$filter["w_id_asal_bibit"];
		$this->id_asal_bibit->AdvancedSearch->Save();
		$this->BasicSearch->setKeyword(@$filter[EW_TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[EW_TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	function AdvancedSearchWhere($Default = FALSE) {
		global $Security;
		$sWhere = "";
		if (!$Security->CanSearch()) return "";
		$this->BuildSearchSql($sWhere, $this->id, $Default, FALSE); // id
		$this->BuildSearchSql($sWhere, $this->tgl_tanam, $Default, FALSE); // tgl_tanam
		$this->BuildSearchSql($sWhere, $this->jumlah_tanam, $Default, FALSE); // jumlah_tanam
		$this->BuildSearchSql($sWhere, $this->jumlah_panen_stek, $Default, FALSE); // jumlah_panen_stek
		$this->BuildSearchSql($sWhere, $this->ket, $Default, FALSE); // ket
		$this->BuildSearchSql($sWhere, $this->var_nama, $Default, FALSE); // var_nama
		$this->BuildSearchSql($sWhere, $this->id_gen, $Default, FALSE); // id_gen
		$this->BuildSearchSql($sWhere, $this->k_id_kontrak, $Default, FALSE); // k_id_kontrak
		$this->BuildSearchSql($sWhere, $this->co_nama, $Default, FALSE); // co_nama
		$this->BuildSearchSql($sWhere, $this->koord_nama, $Default, FALSE); // koord_nama
		$this->BuildSearchSql($sWhere, $this->pet_nama, $Default, FALSE); // pet_nama
		$this->BuildSearchSql($sWhere, $this->prov_nama, $Default, FALSE); // prov_nama
		$this->BuildSearchSql($sWhere, $this->kab_nama, $Default, FALSE); // kab_nama
		$this->BuildSearchSql($sWhere, $this->kec_nama, $Default, FALSE); // kec_nama
		$this->BuildSearchSql($sWhere, $this->desa_nama, $Default, FALSE); // desa_nama
		$this->BuildSearchSql($sWhere, $this->id_asal_bibit, $Default, FALSE); // id_asal_bibit

		// Set up search parm
		if (!$Default && $sWhere <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$Default && $this->Command == "search") {
			$this->id->AdvancedSearch->Save(); // id
			$this->tgl_tanam->AdvancedSearch->Save(); // tgl_tanam
			$this->jumlah_tanam->AdvancedSearch->Save(); // jumlah_tanam
			$this->jumlah_panen_stek->AdvancedSearch->Save(); // jumlah_panen_stek
			$this->ket->AdvancedSearch->Save(); // ket
			$this->var_nama->AdvancedSearch->Save(); // var_nama
			$this->id_gen->AdvancedSearch->Save(); // id_gen
			$this->k_id_kontrak->AdvancedSearch->Save(); // k_id_kontrak
			$this->co_nama->AdvancedSearch->Save(); // co_nama
			$this->koord_nama->AdvancedSearch->Save(); // koord_nama
			$this->pet_nama->AdvancedSearch->Save(); // pet_nama
			$this->prov_nama->AdvancedSearch->Save(); // prov_nama
			$this->kab_nama->AdvancedSearch->Save(); // kab_nama
			$this->kec_nama->AdvancedSearch->Save(); // kec_nama
			$this->desa_nama->AdvancedSearch->Save(); // desa_nama
			$this->id_asal_bibit->AdvancedSearch->Save(); // id_asal_bibit
		}
		return $sWhere;
	}

	// Build search SQL
	function BuildSearchSql(&$Where, &$Fld, $Default, $MultiValue) {
		$FldParm = $Fld->FldParm();
		$FldVal = ($Default) ? $Fld->AdvancedSearch->SearchValueDefault : $Fld->AdvancedSearch->SearchValue; // @$_GET["x_$FldParm"]
		$FldOpr = ($Default) ? $Fld->AdvancedSearch->SearchOperatorDefault : $Fld->AdvancedSearch->SearchOperator; // @$_GET["z_$FldParm"]
		$FldCond = ($Default) ? $Fld->AdvancedSearch->SearchConditionDefault : $Fld->AdvancedSearch->SearchCondition; // @$_GET["v_$FldParm"]
		$FldVal2 = ($Default) ? $Fld->AdvancedSearch->SearchValue2Default : $Fld->AdvancedSearch->SearchValue2; // @$_GET["y_$FldParm"]
		$FldOpr2 = ($Default) ? $Fld->AdvancedSearch->SearchOperator2Default : $Fld->AdvancedSearch->SearchOperator2; // @$_GET["w_$FldParm"]
		$sWrk = "";
		if (is_array($FldVal)) $FldVal = implode(",", $FldVal);
		if (is_array($FldVal2)) $FldVal2 = implode(",", $FldVal2);
		$FldOpr = strtoupper(trim($FldOpr));
		if ($FldOpr == "") $FldOpr = "=";
		$FldOpr2 = strtoupper(trim($FldOpr2));
		if ($FldOpr2 == "") $FldOpr2 = "=";
		if (EW_SEARCH_MULTI_VALUE_OPTION == 1)
			$MultiValue = FALSE;
		if ($MultiValue) {
			$sWrk1 = ($FldVal <> "") ? ew_GetMultiSearchSql($Fld, $FldOpr, $FldVal, $this->DBID) : ""; // Field value 1
			$sWrk2 = ($FldVal2 <> "") ? ew_GetMultiSearchSql($Fld, $FldOpr2, $FldVal2, $this->DBID) : ""; // Field value 2
			$sWrk = $sWrk1; // Build final SQL
			if ($sWrk2 <> "")
				$sWrk = ($sWrk <> "") ? "($sWrk) $FldCond ($sWrk2)" : $sWrk2;
		} else {
			$FldVal = $this->ConvertSearchValue($Fld, $FldVal);
			$FldVal2 = $this->ConvertSearchValue($Fld, $FldVal2);
			$sWrk = ew_GetSearchSql($Fld, $FldVal, $FldOpr, $FldCond, $FldVal2, $FldOpr2, $this->DBID);
		}
		ew_AddFilter($Where, $sWrk);
	}

	// Convert search value
	function ConvertSearchValue(&$Fld, $FldVal) {
		if ($FldVal == EW_NULL_VALUE || $FldVal == EW_NOT_NULL_VALUE)
			return $FldVal;
		$Value = $FldVal;
		if ($Fld->FldDataType == EW_DATATYPE_BOOLEAN) {
			if ($FldVal <> "") $Value = ($FldVal == "1" || strtolower(strval($FldVal)) == "y" || strtolower(strval($FldVal)) == "t") ? $Fld->TrueValue : $Fld->FalseValue;
		} elseif ($Fld->FldDataType == EW_DATATYPE_DATE || $Fld->FldDataType == EW_DATATYPE_TIME) {
			if ($FldVal <> "") $Value = ew_UnFormatDateTime($FldVal, $Fld->FldDateTimeFormat);
		}
		return $Value;
	}

	// Return basic search SQL
	function BasicSearchSQL($arKeywords, $type) {
		$sWhere = "";
		$this->BuildBasicSearchSQL($sWhere, $this->ket, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->var_nama, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->id_gen, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->k_id_kontrak, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->co_nama, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->koord_nama, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->pet_nama, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->prov_nama, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->kab_nama, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->kec_nama, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->desa_nama, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->id_asal_bibit, $arKeywords, $type);
		return $sWhere;
	}

	// Build basic search SQL
	function BuildBasicSearchSQL(&$Where, &$Fld, $arKeywords, $type) {
		global $EW_BASIC_SEARCH_IGNORE_PATTERN;
		$sDefCond = ($type == "OR") ? "OR" : "AND";
		$arSQL = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$Keyword = $arKeywords[$i];
			$Keyword = trim($Keyword);
			if ($EW_BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$Keyword = preg_replace($EW_BASIC_SEARCH_IGNORE_PATTERN, "\\", $Keyword);
				$ar = explode("\\", $Keyword);
			} else {
				$ar = array($Keyword);
			}
			foreach ($ar as $Keyword) {
				if ($Keyword <> "") {
					$sWrk = "";
					if ($Keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j-1] = "OR";
					} elseif ($Keyword == EW_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NULL";
					} elseif ($Keyword == EW_NOT_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NOT NULL";
					} elseif ($Fld->FldIsVirtual) {
						$sWrk = $Fld->FldVirtualExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					} elseif ($Fld->FldDataType != EW_DATATYPE_NUMBER || is_numeric($Keyword)) {
						$sWrk = $Fld->FldBasicSearchExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					}
					if ($sWrk <> "") {
						$arSQL[$j] = $sWrk;
						$arCond[$j] = $sDefCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSQL);
		$bQuoted = FALSE;
		$sSql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt-1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$bQuoted) $sSql .= "(";
					$bQuoted = TRUE;
				}
				$sSql .= $arSQL[$i];
				if ($bQuoted && $arCond[$i] <> "OR") {
					$sSql .= ")";
					$bQuoted = FALSE;
				}
				$sSql .= " " . $arCond[$i] . " ";
			}
			$sSql .= $arSQL[$cnt-1];
			if ($bQuoted)
				$sSql .= ")";
		}
		if ($sSql <> "") {
			if ($Where <> "") $Where .= " OR ";
			$Where .= "(" . $sSql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	function BasicSearchWhere($Default = FALSE) {
		global $Security;
		$sSearchStr = "";
		if (!$Security->CanSearch()) return "";
		$sSearchKeyword = ($Default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$sSearchType = ($Default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($sSearchKeyword <> "") {
			$ar = $this->BasicSearch->KeywordList($Default);

			// Search keyword in any fields
			if (($sSearchType == "OR" || $sSearchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $sKeyword) {
					if ($sKeyword <> "") {
						if ($sSearchStr <> "") $sSearchStr .= " " . $sSearchType . " ";
						$sSearchStr .= "(" . $this->BasicSearchSQL(array($sKeyword), $sSearchType) . ")";
					}
				}
			} else {
				$sSearchStr = $this->BasicSearchSQL($ar, $sSearchType);
			}
			if (!$Default && in_array($this->Command, array("", "reset", "resetall"))) $this->Command = "search";
		}
		if (!$Default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($sSearchKeyword);
			$this->BasicSearch->setType($sSearchType);
		}
		return $sSearchStr;
	}

	// Check if search parm exists
	function CheckSearchParms() {

		// Check basic search
		if ($this->BasicSearch->IssetSession())
			return TRUE;
		if ($this->id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->tgl_tanam->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->jumlah_tanam->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->jumlah_panen_stek->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->ket->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->var_nama->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->id_gen->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->k_id_kontrak->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->co_nama->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->koord_nama->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->pet_nama->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->prov_nama->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->kab_nama->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->kec_nama->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->desa_nama->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->id_asal_bibit->AdvancedSearch->IssetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	function ResetSearchParms() {

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->ResetBasicSearchParms();

		// Clear advanced search parameters
		$this->ResetAdvancedSearchParms();
	}

	// Load advanced search default values
	function LoadAdvancedSearchDefault() {
		return FALSE;
	}

	// Clear all basic search parameters
	function ResetBasicSearchParms() {
		$this->BasicSearch->UnsetSession();
	}

	// Clear all advanced search parameters
	function ResetAdvancedSearchParms() {
		$this->id->AdvancedSearch->UnsetSession();
		$this->tgl_tanam->AdvancedSearch->UnsetSession();
		$this->jumlah_tanam->AdvancedSearch->UnsetSession();
		$this->jumlah_panen_stek->AdvancedSearch->UnsetSession();
		$this->ket->AdvancedSearch->UnsetSession();
		$this->var_nama->AdvancedSearch->UnsetSession();
		$this->id_gen->AdvancedSearch->UnsetSession();
		$this->k_id_kontrak->AdvancedSearch->UnsetSession();
		$this->co_nama->AdvancedSearch->UnsetSession();
		$this->koord_nama->AdvancedSearch->UnsetSession();
		$this->pet_nama->AdvancedSearch->UnsetSession();
		$this->prov_nama->AdvancedSearch->UnsetSession();
		$this->kab_nama->AdvancedSearch->UnsetSession();
		$this->kec_nama->AdvancedSearch->UnsetSession();
		$this->desa_nama->AdvancedSearch->UnsetSession();
		$this->id_asal_bibit->AdvancedSearch->UnsetSession();
	}

	// Restore all search parameters
	function RestoreSearchParms() {
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->Load();

		// Restore advanced search values
		$this->id->AdvancedSearch->Load();
		$this->tgl_tanam->AdvancedSearch->Load();
		$this->jumlah_tanam->AdvancedSearch->Load();
		$this->jumlah_panen_stek->AdvancedSearch->Load();
		$this->ket->AdvancedSearch->Load();
		$this->var_nama->AdvancedSearch->Load();
		$this->id_gen->AdvancedSearch->Load();
		$this->k_id_kontrak->AdvancedSearch->Load();
		$this->co_nama->AdvancedSearch->Load();
		$this->koord_nama->AdvancedSearch->Load();
		$this->pet_nama->AdvancedSearch->Load();
		$this->prov_nama->AdvancedSearch->Load();
		$this->kab_nama->AdvancedSearch->Load();
		$this->kec_nama->AdvancedSearch->Load();
		$this->desa_nama->AdvancedSearch->Load();
		$this->id_asal_bibit->AdvancedSearch->Load();
	}

	// Set up sort parameters
	function SetupSortOrder() {

		// Check for "order" parameter
		if (@$_GET["order"] <> "") {
			$this->CurrentOrder = @$_GET["order"];
			$this->CurrentOrderType = @$_GET["ordertype"];
			$this->UpdateSort($this->id); // id
			$this->UpdateSort($this->tgl_tanam); // tgl_tanam
			$this->UpdateSort($this->jumlah_tanam); // jumlah_tanam
			$this->UpdateSort($this->jumlah_panen_stek); // jumlah_panen_stek
			$this->UpdateSort($this->ket); // ket
			$this->UpdateSort($this->var_nama); // var_nama
			$this->UpdateSort($this->id_gen); // id_gen
			$this->UpdateSort($this->k_id_kontrak); // k_id_kontrak
			$this->UpdateSort($this->co_nama); // co_nama
			$this->UpdateSort($this->koord_nama); // koord_nama
			$this->UpdateSort($this->pet_nama); // pet_nama
			$this->UpdateSort($this->prov_nama); // prov_nama
			$this->UpdateSort($this->kab_nama); // kab_nama
			$this->UpdateSort($this->kec_nama); // kec_nama
			$this->UpdateSort($this->desa_nama); // desa_nama
			$this->UpdateSort($this->id_asal_bibit); // id_asal_bibit
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	function LoadSortOrder() {
		$sOrderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($sOrderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$sOrderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($sOrderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)
	function ResetCmd() {

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->ResetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$sOrderBy = "";
				$this->setSessionOrderBy($sOrderBy);
				$this->id->setSort("");
				$this->tgl_tanam->setSort("");
				$this->jumlah_tanam->setSort("");
				$this->jumlah_panen_stek->setSort("");
				$this->ket->setSort("");
				$this->var_nama->setSort("");
				$this->id_gen->setSort("");
				$this->k_id_kontrak->setSort("");
				$this->co_nama->setSort("");
				$this->koord_nama->setSort("");
				$this->pet_nama->setSort("");
				$this->prov_nama->setSort("");
				$this->kab_nama->setSort("");
				$this->kec_nama->setSort("");
				$this->desa_nama->setSort("");
				$this->id_asal_bibit->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	function SetupListOptions() {
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->Add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// List actions
		$item = &$this->ListOptions->Add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->Add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew_SelectAllKey(this);\">";
		$item->MoveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseImageAndText = TRUE;
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->Phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		if ($this->ListOptions->UseButtonGroup && ew_IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;
		$this->ListOptions->ButtonClass = "btn-sm"; // Class for button group

		// Call ListOptions_Load event
		$this->ListOptions_Load();
		$this->SetupListOptionsExt();
		$item = &$this->ListOptions->GetItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->GroupOptionVisible();
	}

	// Render list options
	function RenderListOptions() {
		global $Security, $Language, $objForm;
		$this->ListOptions->LoadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// Set up list action buttons
		$oListOpt = &$this->ListOptions->GetItem("listactions");
		if ($oListOpt && $this->Export == "" && $this->CurrentAction == "") {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode(str_replace(" ewIcon", "", $listaction->Icon)) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\"></span> " : "";
					$links[] = "<li><a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" title=\"" . ew_HtmlTitle($caption) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $Language->Phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default btn-sm ewActions\" title=\"" . ew_HtmlTitle($Language->Phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->Phrase("ListActionButton") . "<b class=\"caret\"></b></button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($oListOpt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$oListOpt->Body = $body;
				$oListOpt->Visible = TRUE;
			}
		}

		// "checkbox"
		$oListOpt = &$this->ListOptions->Items["checkbox"];
		$oListOpt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ewMultiSelect\" value=\"" . ew_HtmlEncode($this->id->CurrentValue) . "\" onclick=\"ew_ClickMultiCheckbox(event);\">";
		$this->RenderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	function SetupOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseImageAndText = TRUE;
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;
			$option->ButtonClass = "btn-sm"; // Class for button group
			$item = &$option->Add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->Phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->Phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->Phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->Add("savecurrentfilter");
		$item->Body = "<a class=\"ewSaveFilter\" data-form=\"fbibitlistsrch\" href=\"#\">" . $Language->Phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->Add("deletefilter");
		$item->Body = "<a class=\"ewDeleteFilter\" data-form=\"fbibitlistsrch\" href=\"#\">" . $Language->Phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->Phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->Add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	function RenderOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_MULTIPLE) {
					$item = &$option->Add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode($listaction->Icon) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\"></span> " : $caption;
					$item->Body = "<a class=\"ewAction ewListAction\" title=\"" . ew_HtmlEncode($caption) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({f:document.fbibitlist}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->GetItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->HideAllOptions();
			}
	}

	// Process list action
	function ProcessListAction() {
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$sFilter = $this->GetKeyFilter();
		$UserAction = @$_POST["useraction"];
		if ($sFilter <> "" && $UserAction <> "") {

			// Check permission first
			$ActionCaption = $UserAction;
			if (array_key_exists($UserAction, $this->ListActions->Items)) {
				$ActionCaption = $this->ListActions->Items[$UserAction]->Caption;
				if (!$this->ListActions->Items[$UserAction]->Allow) {
					$errmsg = str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionNotAllowed"));
					if (@$_POST["ajax"] == $UserAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $sFilter;
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			$rs = $conn->Execute($sSql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $UserAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->BeginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$Processed = $this->Row_CustomAction($UserAction, $row);
					if (!$Processed) break;
					$rs->MoveNext();
				}
				if ($Processed) {
					$conn->CommitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->RollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->Close();
			$this->CurrentAction = ""; // Clear action
			if (@$_POST["ajax"] == $UserAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->ClearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->ClearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	function SetupSearchOptions() {
		global $Language;
		$this->SearchOptions = new cListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ewSearchOption";

		// Search button
		$item = &$this->SearchOptions->Add("searchtoggle");
		$SearchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ewSearchToggle" . $SearchToggleClass . "\" title=\"" . $Language->Phrase("SearchPanel") . "\" data-caption=\"" . $Language->Phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fbibitlistsrch\">" . $Language->Phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->Add("showall");
		$item->Body = "<a class=\"btn btn-default ewShowAll\" title=\"" . $Language->Phrase("ShowAll") . "\" data-caption=\"" . $Language->Phrase("ShowAll") . "\" href=\"" . $this->PageUrl() . "cmd=reset\">" . $Language->Phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseImageAndText = TRUE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->Phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->Add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->Export <> "" || $this->CurrentAction <> "")
			$this->SearchOptions->HideAllOptions();
		global $Security;
		if (!$Security->CanSearch()) {
			$this->SearchOptions->HideAllOptions();
			$this->FilterOptions->HideAllOptions();
		}
	}

	function SetupListOptionsExt() {
		global $Security, $Language;
	}

	function RenderListOptionsExt() {
		global $Security, $Language;
	}

	// Set up starting record parameters
	function SetupStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	function LoadBasicSearchValues() {
		$this->BasicSearch->Keyword = @$_GET[EW_TABLE_BASIC_SEARCH];
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "") $this->Command = "search";
		$this->BasicSearch->Type = @$_GET[EW_TABLE_BASIC_SEARCH_TYPE];
	}

	// Load search values for validation
	function LoadSearchValues() {
		global $objForm;

		// Load search values
		// id

		$this->id->AdvancedSearch->SearchValue = @$_GET["x_id"];
		if ($this->id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->id->AdvancedSearch->SearchOperator = @$_GET["z_id"];

		// tgl_tanam
		$this->tgl_tanam->AdvancedSearch->SearchValue = @$_GET["x_tgl_tanam"];
		if ($this->tgl_tanam->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->tgl_tanam->AdvancedSearch->SearchOperator = @$_GET["z_tgl_tanam"];
		$this->tgl_tanam->AdvancedSearch->SearchCondition = @$_GET["v_tgl_tanam"];
		$this->tgl_tanam->AdvancedSearch->SearchValue2 = @$_GET["y_tgl_tanam"];
		if ($this->tgl_tanam->AdvancedSearch->SearchValue2 <> "" && $this->Command == "") $this->Command = "search";
		$this->tgl_tanam->AdvancedSearch->SearchOperator2 = @$_GET["w_tgl_tanam"];

		// jumlah_tanam
		$this->jumlah_tanam->AdvancedSearch->SearchValue = @$_GET["x_jumlah_tanam"];
		if ($this->jumlah_tanam->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->jumlah_tanam->AdvancedSearch->SearchOperator = @$_GET["z_jumlah_tanam"];

		// jumlah_panen_stek
		$this->jumlah_panen_stek->AdvancedSearch->SearchValue = @$_GET["x_jumlah_panen_stek"];
		if ($this->jumlah_panen_stek->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->jumlah_panen_stek->AdvancedSearch->SearchOperator = @$_GET["z_jumlah_panen_stek"];

		// ket
		$this->ket->AdvancedSearch->SearchValue = @$_GET["x_ket"];
		if ($this->ket->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->ket->AdvancedSearch->SearchOperator = @$_GET["z_ket"];

		// var_nama
		$this->var_nama->AdvancedSearch->SearchValue = @$_GET["x_var_nama"];
		if ($this->var_nama->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->var_nama->AdvancedSearch->SearchOperator = @$_GET["z_var_nama"];

		// id_gen
		$this->id_gen->AdvancedSearch->SearchValue = @$_GET["x_id_gen"];
		if ($this->id_gen->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->id_gen->AdvancedSearch->SearchOperator = @$_GET["z_id_gen"];

		// k_id_kontrak
		$this->k_id_kontrak->AdvancedSearch->SearchValue = @$_GET["x_k_id_kontrak"];
		if ($this->k_id_kontrak->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->k_id_kontrak->AdvancedSearch->SearchOperator = @$_GET["z_k_id_kontrak"];

		// co_nama
		$this->co_nama->AdvancedSearch->SearchValue = @$_GET["x_co_nama"];
		if ($this->co_nama->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->co_nama->AdvancedSearch->SearchOperator = @$_GET["z_co_nama"];

		// koord_nama
		$this->koord_nama->AdvancedSearch->SearchValue = @$_GET["x_koord_nama"];
		if ($this->koord_nama->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->koord_nama->AdvancedSearch->SearchOperator = @$_GET["z_koord_nama"];

		// pet_nama
		$this->pet_nama->AdvancedSearch->SearchValue = @$_GET["x_pet_nama"];
		if ($this->pet_nama->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->pet_nama->AdvancedSearch->SearchOperator = @$_GET["z_pet_nama"];

		// prov_nama
		$this->prov_nama->AdvancedSearch->SearchValue = @$_GET["x_prov_nama"];
		if ($this->prov_nama->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->prov_nama->AdvancedSearch->SearchOperator = @$_GET["z_prov_nama"];

		// kab_nama
		$this->kab_nama->AdvancedSearch->SearchValue = @$_GET["x_kab_nama"];
		if ($this->kab_nama->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->kab_nama->AdvancedSearch->SearchOperator = @$_GET["z_kab_nama"];

		// kec_nama
		$this->kec_nama->AdvancedSearch->SearchValue = @$_GET["x_kec_nama"];
		if ($this->kec_nama->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->kec_nama->AdvancedSearch->SearchOperator = @$_GET["z_kec_nama"];

		// desa_nama
		$this->desa_nama->AdvancedSearch->SearchValue = @$_GET["x_desa_nama"];
		if ($this->desa_nama->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->desa_nama->AdvancedSearch->SearchOperator = @$_GET["z_desa_nama"];

		// id_asal_bibit
		$this->id_asal_bibit->AdvancedSearch->SearchValue = @$_GET["x_id_asal_bibit"];
		if ($this->id_asal_bibit->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->id_asal_bibit->AdvancedSearch->SearchOperator = @$_GET["z_id_asal_bibit"];
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {

		// Load List page SQL
		$sSql = $this->ListSQL();
		$conn = &$this->Connection();

		// Load recordset
		$dbtype = ew_GetConnectionType($this->DBID);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset, array("_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())));
			} else {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = ew_LoadRecordset($sSql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues($rs = NULL) {
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->NewRow(); 

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->tgl_tanam->setDbValue($row['tgl_tanam']);
		$this->jumlah_tanam->setDbValue($row['jumlah_tanam']);
		$this->jumlah_panen_stek->setDbValue($row['jumlah_panen_stek']);
		$this->ket->setDbValue($row['ket']);
		$this->var_nama->setDbValue($row['var_nama']);
		$this->id_gen->setDbValue($row['id_gen']);
		$this->k_id_kontrak->setDbValue($row['k_id_kontrak']);
		$this->co_nama->setDbValue($row['co_nama']);
		$this->koord_nama->setDbValue($row['koord_nama']);
		$this->pet_nama->setDbValue($row['pet_nama']);
		$this->prov_nama->setDbValue($row['prov_nama']);
		$this->kab_nama->setDbValue($row['kab_nama']);
		$this->kec_nama->setDbValue($row['kec_nama']);
		$this->desa_nama->setDbValue($row['desa_nama']);
		$this->id_asal_bibit->setDbValue($row['id_asal_bibit']);
	}

	// Return a row with default values
	function NewRow() {
		$row = array();
		$row['id'] = NULL;
		$row['tgl_tanam'] = NULL;
		$row['jumlah_tanam'] = NULL;
		$row['jumlah_panen_stek'] = NULL;
		$row['ket'] = NULL;
		$row['var_nama'] = NULL;
		$row['id_gen'] = NULL;
		$row['k_id_kontrak'] = NULL;
		$row['co_nama'] = NULL;
		$row['koord_nama'] = NULL;
		$row['pet_nama'] = NULL;
		$row['prov_nama'] = NULL;
		$row['kab_nama'] = NULL;
		$row['kec_nama'] = NULL;
		$row['desa_nama'] = NULL;
		$row['id_asal_bibit'] = NULL;
		return $row;
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->tgl_tanam->DbValue = $row['tgl_tanam'];
		$this->jumlah_tanam->DbValue = $row['jumlah_tanam'];
		$this->jumlah_panen_stek->DbValue = $row['jumlah_panen_stek'];
		$this->ket->DbValue = $row['ket'];
		$this->var_nama->DbValue = $row['var_nama'];
		$this->id_gen->DbValue = $row['id_gen'];
		$this->k_id_kontrak->DbValue = $row['k_id_kontrak'];
		$this->co_nama->DbValue = $row['co_nama'];
		$this->koord_nama->DbValue = $row['koord_nama'];
		$this->pet_nama->DbValue = $row['pet_nama'];
		$this->prov_nama->DbValue = $row['prov_nama'];
		$this->kab_nama->DbValue = $row['kab_nama'];
		$this->kec_nama->DbValue = $row['kec_nama'];
		$this->desa_nama->DbValue = $row['desa_nama'];
		$this->id_asal_bibit->DbValue = $row['id_asal_bibit'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$bValidKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
		}
		$this->LoadRowValues($this->OldRecordset); // Load row values
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->GetViewUrl();
		$this->EditUrl = $this->GetEditUrl();
		$this->InlineEditUrl = $this->GetInlineEditUrl();
		$this->CopyUrl = $this->GetCopyUrl();
		$this->InlineCopyUrl = $this->GetInlineCopyUrl();
		$this->DeleteUrl = $this->GetDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// tgl_tanam
		// jumlah_tanam
		// jumlah_panen_stek
		// ket
		// var_nama
		// id_gen
		// k_id_kontrak
		// co_nama
		// koord_nama
		// pet_nama
		// prov_nama
		// kab_nama
		// kec_nama
		// desa_nama
		// id_asal_bibit

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// tgl_tanam
		$this->tgl_tanam->ViewValue = $this->tgl_tanam->CurrentValue;
		$this->tgl_tanam->ViewValue = ew_FormatDateTime($this->tgl_tanam->ViewValue, 0);
		$this->tgl_tanam->ViewCustomAttributes = "";

		// jumlah_tanam
		$this->jumlah_tanam->ViewValue = $this->jumlah_tanam->CurrentValue;
		$this->jumlah_tanam->ViewCustomAttributes = "";

		// jumlah_panen_stek
		$this->jumlah_panen_stek->ViewValue = $this->jumlah_panen_stek->CurrentValue;
		$this->jumlah_panen_stek->ViewCustomAttributes = "";

		// ket
		$this->ket->ViewValue = $this->ket->CurrentValue;
		$this->ket->ViewCustomAttributes = "";

		// var_nama
		if (strval($this->var_nama->CurrentValue) <> "") {
			$sFilterWrk = "`var_nama`" . ew_SearchString("=", $this->var_nama->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `var_nama`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `varietas`";
		$sWhereWrk = "";
		$this->var_nama->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->var_nama, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->var_nama->ViewValue = $this->var_nama->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->var_nama->ViewValue = $this->var_nama->CurrentValue;
			}
		} else {
			$this->var_nama->ViewValue = NULL;
		}
		$this->var_nama->ViewCustomAttributes = "";

		// id_gen
		if (strval($this->id_gen->CurrentValue) <> "") {
			$sFilterWrk = "`id_gen`" . ew_SearchString("=", $this->id_gen->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `id_gen`, `id_gen` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `generasi_bibit`";
		$sWhereWrk = "";
		$this->id_gen->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->id_gen, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->id_gen->ViewValue = $this->id_gen->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->id_gen->ViewValue = $this->id_gen->CurrentValue;
			}
		} else {
			$this->id_gen->ViewValue = NULL;
		}
		$this->id_gen->ViewCustomAttributes = "";

		// k_id_kontrak
		if (strval($this->k_id_kontrak->CurrentValue) <> "") {
			$sFilterWrk = "`k_id_kontrak`" . ew_SearchString("=", $this->k_id_kontrak->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `k_id_kontrak`, `k_id_kontrak` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kontrak`";
		$sWhereWrk = "";
		$this->k_id_kontrak->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->k_id_kontrak, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->k_id_kontrak->ViewValue = $this->k_id_kontrak->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->k_id_kontrak->ViewValue = $this->k_id_kontrak->CurrentValue;
			}
		} else {
			$this->k_id_kontrak->ViewValue = NULL;
		}
		$this->k_id_kontrak->ViewCustomAttributes = "";

		// co_nama
		if (strval($this->co_nama->CurrentValue) <> "") {
			$sFilterWrk = "`co_nama`" . ew_SearchString("=", $this->co_nama->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `co_nama`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `co`";
		$sWhereWrk = "";
		$this->co_nama->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->co_nama, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->co_nama->ViewValue = $this->co_nama->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->co_nama->ViewValue = $this->co_nama->CurrentValue;
			}
		} else {
			$this->co_nama->ViewValue = NULL;
		}
		$this->co_nama->ViewCustomAttributes = "";

		// koord_nama
		$this->koord_nama->ViewValue = $this->koord_nama->CurrentValue;
		if (strval($this->koord_nama->CurrentValue) <> "") {
			$sFilterWrk = "`koord_nama`" . ew_SearchString("=", $this->koord_nama->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `koord_nama`, `koord_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `koord`";
		$sWhereWrk = "";
		$this->koord_nama->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->koord_nama, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->koord_nama->ViewValue = $this->koord_nama->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->koord_nama->ViewValue = $this->koord_nama->CurrentValue;
			}
		} else {
			$this->koord_nama->ViewValue = NULL;
		}
		$this->koord_nama->ViewCustomAttributes = "";

		// pet_nama
		$this->pet_nama->ViewValue = $this->pet_nama->CurrentValue;
		if (strval($this->pet_nama->CurrentValue) <> "") {
			$sFilterWrk = "`pet_nama`" . ew_SearchString("=", $this->pet_nama->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `pet_nama`, `pet_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `petani`";
		$sWhereWrk = "";
		$this->pet_nama->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->pet_nama, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->pet_nama->ViewValue = $this->pet_nama->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->pet_nama->ViewValue = $this->pet_nama->CurrentValue;
			}
		} else {
			$this->pet_nama->ViewValue = NULL;
		}
		$this->pet_nama->ViewCustomAttributes = "";

		// prov_nama
		$this->prov_nama->ViewValue = $this->prov_nama->CurrentValue;
		if (strval($this->prov_nama->CurrentValue) <> "") {
			$sFilterWrk = "`prov_nama`" . ew_SearchString("=", $this->prov_nama->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `prov_nama`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `prov`";
		$sWhereWrk = "";
		$this->prov_nama->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->prov_nama, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->prov_nama->ViewValue = $this->prov_nama->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->prov_nama->ViewValue = $this->prov_nama->CurrentValue;
			}
		} else {
			$this->prov_nama->ViewValue = NULL;
		}
		$this->prov_nama->ViewCustomAttributes = "";

		// kab_nama
		$this->kab_nama->ViewValue = $this->kab_nama->CurrentValue;
		if (strval($this->kab_nama->CurrentValue) <> "") {
			$sFilterWrk = "`kab_nama`" . ew_SearchString("=", $this->kab_nama->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `kab_nama`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kab`";
		$sWhereWrk = "";
		$this->kab_nama->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->kab_nama, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->kab_nama->ViewValue = $this->kab_nama->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->kab_nama->ViewValue = $this->kab_nama->CurrentValue;
			}
		} else {
			$this->kab_nama->ViewValue = NULL;
		}
		$this->kab_nama->ViewCustomAttributes = "";

		// kec_nama
		$this->kec_nama->ViewValue = $this->kec_nama->CurrentValue;
		if (strval($this->kec_nama->CurrentValue) <> "") {
			$sFilterWrk = "`kec_nama`" . ew_SearchString("=", $this->kec_nama->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `kec_nama`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kec`";
		$sWhereWrk = "";
		$this->kec_nama->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->kec_nama, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->kec_nama->ViewValue = $this->kec_nama->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->kec_nama->ViewValue = $this->kec_nama->CurrentValue;
			}
		} else {
			$this->kec_nama->ViewValue = NULL;
		}
		$this->kec_nama->ViewCustomAttributes = "";

		// desa_nama
		$this->desa_nama->ViewValue = $this->desa_nama->CurrentValue;
		if (strval($this->desa_nama->CurrentValue) <> "") {
			$sFilterWrk = "`desa_nama`" . ew_SearchString("=", $this->desa_nama->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `desa_nama`, `desa_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `desa`";
		$sWhereWrk = "";
		$this->desa_nama->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->desa_nama, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->desa_nama->ViewValue = $this->desa_nama->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->desa_nama->ViewValue = $this->desa_nama->CurrentValue;
			}
		} else {
			$this->desa_nama->ViewValue = NULL;
		}
		$this->desa_nama->ViewCustomAttributes = "";

		// id_asal_bibit
		$this->id_asal_bibit->ViewValue = $this->id_asal_bibit->CurrentValue;
		if (strval($this->id_asal_bibit->CurrentValue) <> "") {
			$sFilterWrk = "`id`" . ew_SearchString("=", $this->id_asal_bibit->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `id`, `tgl_tanam` AS `DispFld`, `gen_bibit` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tanam_bibit`";
		$sWhereWrk = "";
		$this->id_asal_bibit->LookupFilters = array("df1" => "0");
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->id_asal_bibit, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = ew_FormatDateTime($rswrk->fields('DispFld'), 0);
				$arwrk[2] = $rswrk->fields('Disp2Fld');
				$this->id_asal_bibit->ViewValue = $this->id_asal_bibit->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->id_asal_bibit->ViewValue = $this->id_asal_bibit->CurrentValue;
			}
		} else {
			$this->id_asal_bibit->ViewValue = NULL;
		}
		$this->id_asal_bibit->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// tgl_tanam
			$this->tgl_tanam->LinkCustomAttributes = "";
			$this->tgl_tanam->HrefValue = "";
			$this->tgl_tanam->TooltipValue = "";

			// jumlah_tanam
			$this->jumlah_tanam->LinkCustomAttributes = "";
			$this->jumlah_tanam->HrefValue = "";
			$this->jumlah_tanam->TooltipValue = "";

			// jumlah_panen_stek
			$this->jumlah_panen_stek->LinkCustomAttributes = "";
			$this->jumlah_panen_stek->HrefValue = "";
			$this->jumlah_panen_stek->TooltipValue = "";

			// ket
			$this->ket->LinkCustomAttributes = "";
			$this->ket->HrefValue = "";
			$this->ket->TooltipValue = "";

			// var_nama
			$this->var_nama->LinkCustomAttributes = "";
			$this->var_nama->HrefValue = "";
			$this->var_nama->TooltipValue = "";

			// id_gen
			$this->id_gen->LinkCustomAttributes = "";
			$this->id_gen->HrefValue = "";
			$this->id_gen->TooltipValue = "";

			// k_id_kontrak
			$this->k_id_kontrak->LinkCustomAttributes = "";
			$this->k_id_kontrak->HrefValue = "";
			$this->k_id_kontrak->TooltipValue = "";

			// co_nama
			$this->co_nama->LinkCustomAttributes = "";
			$this->co_nama->HrefValue = "";
			$this->co_nama->TooltipValue = "";

			// koord_nama
			$this->koord_nama->LinkCustomAttributes = "";
			$this->koord_nama->HrefValue = "";
			$this->koord_nama->TooltipValue = "";

			// pet_nama
			$this->pet_nama->LinkCustomAttributes = "";
			$this->pet_nama->HrefValue = "";
			$this->pet_nama->TooltipValue = "";

			// prov_nama
			$this->prov_nama->LinkCustomAttributes = "";
			$this->prov_nama->HrefValue = "";
			$this->prov_nama->TooltipValue = "";

			// kab_nama
			$this->kab_nama->LinkCustomAttributes = "";
			$this->kab_nama->HrefValue = "";
			$this->kab_nama->TooltipValue = "";

			// kec_nama
			$this->kec_nama->LinkCustomAttributes = "";
			$this->kec_nama->HrefValue = "";
			$this->kec_nama->TooltipValue = "";

			// desa_nama
			$this->desa_nama->LinkCustomAttributes = "";
			$this->desa_nama->HrefValue = "";
			$this->desa_nama->TooltipValue = "";

			// id_asal_bibit
			$this->id_asal_bibit->LinkCustomAttributes = "";
			$this->id_asal_bibit->HrefValue = "";
			$this->id_asal_bibit->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = ew_HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = ew_RemoveHtml($this->id->FldCaption());

			// tgl_tanam
			$this->tgl_tanam->EditAttrs["class"] = "form-control";
			$this->tgl_tanam->EditCustomAttributes = "";
			$this->tgl_tanam->EditValue = ew_HtmlEncode(ew_FormatDateTime(ew_UnFormatDateTime($this->tgl_tanam->AdvancedSearch->SearchValue, 0), 8));
			$this->tgl_tanam->PlaceHolder = ew_RemoveHtml($this->tgl_tanam->FldCaption());
			$this->tgl_tanam->EditAttrs["class"] = "form-control";
			$this->tgl_tanam->EditCustomAttributes = "";
			$this->tgl_tanam->EditValue2 = ew_HtmlEncode(ew_FormatDateTime(ew_UnFormatDateTime($this->tgl_tanam->AdvancedSearch->SearchValue2, 0), 8));
			$this->tgl_tanam->PlaceHolder = ew_RemoveHtml($this->tgl_tanam->FldCaption());

			// jumlah_tanam
			$this->jumlah_tanam->EditAttrs["class"] = "form-control";
			$this->jumlah_tanam->EditCustomAttributes = "";
			$this->jumlah_tanam->EditValue = ew_HtmlEncode($this->jumlah_tanam->AdvancedSearch->SearchValue);
			$this->jumlah_tanam->PlaceHolder = ew_RemoveHtml($this->jumlah_tanam->FldCaption());

			// jumlah_panen_stek
			$this->jumlah_panen_stek->EditAttrs["class"] = "form-control";
			$this->jumlah_panen_stek->EditCustomAttributes = "";
			$this->jumlah_panen_stek->EditValue = ew_HtmlEncode($this->jumlah_panen_stek->AdvancedSearch->SearchValue);
			$this->jumlah_panen_stek->PlaceHolder = ew_RemoveHtml($this->jumlah_panen_stek->FldCaption());

			// ket
			$this->ket->EditAttrs["class"] = "form-control";
			$this->ket->EditCustomAttributes = "";
			$this->ket->EditValue = ew_HtmlEncode($this->ket->AdvancedSearch->SearchValue);
			$this->ket->PlaceHolder = ew_RemoveHtml($this->ket->FldCaption());

			// var_nama
			$this->var_nama->EditAttrs["class"] = "form-control";
			$this->var_nama->EditCustomAttributes = "";
			if (trim(strval($this->var_nama->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`var_nama`" . ew_SearchString("=", $this->var_nama->AdvancedSearch->SearchValue, EW_DATATYPE_STRING, "");
			}
			$sSqlWrk = "SELECT `var_nama`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `varietas`";
			$sWhereWrk = "";
			$this->var_nama->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->var_nama, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->var_nama->EditValue = $arwrk;

			// id_gen
			$this->id_gen->EditAttrs["class"] = "form-control";
			$this->id_gen->EditCustomAttributes = "";
			if (trim(strval($this->id_gen->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`id_gen`" . ew_SearchString("=", $this->id_gen->AdvancedSearch->SearchValue, EW_DATATYPE_STRING, "");
			}
			$sSqlWrk = "SELECT `id_gen`, `id_gen` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `generasi_bibit`";
			$sWhereWrk = "";
			$this->id_gen->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->id_gen, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->id_gen->EditValue = $arwrk;

			// k_id_kontrak
			$this->k_id_kontrak->EditAttrs["class"] = "form-control";
			$this->k_id_kontrak->EditCustomAttributes = "";
			if (trim(strval($this->k_id_kontrak->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`k_id_kontrak`" . ew_SearchString("=", $this->k_id_kontrak->AdvancedSearch->SearchValue, EW_DATATYPE_STRING, "");
			}
			$sSqlWrk = "SELECT `k_id_kontrak`, `k_id_kontrak` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `kontrak`";
			$sWhereWrk = "";
			$this->k_id_kontrak->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->k_id_kontrak, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->k_id_kontrak->EditValue = $arwrk;

			// co_nama
			$this->co_nama->EditAttrs["class"] = "form-control";
			$this->co_nama->EditCustomAttributes = "";
			if (trim(strval($this->co_nama->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`co_nama`" . ew_SearchString("=", $this->co_nama->AdvancedSearch->SearchValue, EW_DATATYPE_STRING, "");
			}
			$sSqlWrk = "SELECT `co_nama`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `co`";
			$sWhereWrk = "";
			$this->co_nama->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->co_nama, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->co_nama->EditValue = $arwrk;

			// koord_nama
			$this->koord_nama->EditAttrs["class"] = "form-control";
			$this->koord_nama->EditCustomAttributes = "";
			$this->koord_nama->EditValue = ew_HtmlEncode($this->koord_nama->AdvancedSearch->SearchValue);
			if (strval($this->koord_nama->AdvancedSearch->SearchValue) <> "") {
				$sFilterWrk = "`koord_nama`" . ew_SearchString("=", $this->koord_nama->AdvancedSearch->SearchValue, EW_DATATYPE_STRING, "");
			$sSqlWrk = "SELECT `koord_nama`, `koord_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `koord`";
			$sWhereWrk = "";
			$this->koord_nama->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->koord_nama, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = Conn()->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = ew_HtmlEncode($rswrk->fields('DispFld'));
					$this->koord_nama->EditValue = $this->koord_nama->DisplayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->koord_nama->EditValue = ew_HtmlEncode($this->koord_nama->AdvancedSearch->SearchValue);
				}
			} else {
				$this->koord_nama->EditValue = NULL;
			}
			$this->koord_nama->PlaceHolder = ew_RemoveHtml($this->koord_nama->FldCaption());

			// pet_nama
			$this->pet_nama->EditAttrs["class"] = "form-control";
			$this->pet_nama->EditCustomAttributes = "";
			$this->pet_nama->EditValue = ew_HtmlEncode($this->pet_nama->AdvancedSearch->SearchValue);
			if (strval($this->pet_nama->AdvancedSearch->SearchValue) <> "") {
				$sFilterWrk = "`pet_nama`" . ew_SearchString("=", $this->pet_nama->AdvancedSearch->SearchValue, EW_DATATYPE_STRING, "");
			$sSqlWrk = "SELECT `pet_nama`, `pet_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `petani`";
			$sWhereWrk = "";
			$this->pet_nama->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->pet_nama, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = Conn()->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = ew_HtmlEncode($rswrk->fields('DispFld'));
					$this->pet_nama->EditValue = $this->pet_nama->DisplayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->pet_nama->EditValue = ew_HtmlEncode($this->pet_nama->AdvancedSearch->SearchValue);
				}
			} else {
				$this->pet_nama->EditValue = NULL;
			}
			$this->pet_nama->PlaceHolder = ew_RemoveHtml($this->pet_nama->FldCaption());

			// prov_nama
			$this->prov_nama->EditAttrs["class"] = "form-control";
			$this->prov_nama->EditCustomAttributes = "";
			$this->prov_nama->EditValue = ew_HtmlEncode($this->prov_nama->AdvancedSearch->SearchValue);
			if (strval($this->prov_nama->AdvancedSearch->SearchValue) <> "") {
				$sFilterWrk = "`prov_nama`" . ew_SearchString("=", $this->prov_nama->AdvancedSearch->SearchValue, EW_DATATYPE_STRING, "");
			$sSqlWrk = "SELECT `prov_nama`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `prov`";
			$sWhereWrk = "";
			$this->prov_nama->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->prov_nama, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = Conn()->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = ew_HtmlEncode($rswrk->fields('DispFld'));
					$this->prov_nama->EditValue = $this->prov_nama->DisplayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->prov_nama->EditValue = ew_HtmlEncode($this->prov_nama->AdvancedSearch->SearchValue);
				}
			} else {
				$this->prov_nama->EditValue = NULL;
			}
			$this->prov_nama->PlaceHolder = ew_RemoveHtml($this->prov_nama->FldCaption());

			// kab_nama
			$this->kab_nama->EditAttrs["class"] = "form-control";
			$this->kab_nama->EditCustomAttributes = "";
			$this->kab_nama->EditValue = ew_HtmlEncode($this->kab_nama->AdvancedSearch->SearchValue);
			if (strval($this->kab_nama->AdvancedSearch->SearchValue) <> "") {
				$sFilterWrk = "`kab_nama`" . ew_SearchString("=", $this->kab_nama->AdvancedSearch->SearchValue, EW_DATATYPE_STRING, "");
			$sSqlWrk = "SELECT `kab_nama`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kab`";
			$sWhereWrk = "";
			$this->kab_nama->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->kab_nama, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = Conn()->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = ew_HtmlEncode($rswrk->fields('DispFld'));
					$this->kab_nama->EditValue = $this->kab_nama->DisplayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->kab_nama->EditValue = ew_HtmlEncode($this->kab_nama->AdvancedSearch->SearchValue);
				}
			} else {
				$this->kab_nama->EditValue = NULL;
			}
			$this->kab_nama->PlaceHolder = ew_RemoveHtml($this->kab_nama->FldCaption());

			// kec_nama
			$this->kec_nama->EditAttrs["class"] = "form-control";
			$this->kec_nama->EditCustomAttributes = "";
			$this->kec_nama->EditValue = ew_HtmlEncode($this->kec_nama->AdvancedSearch->SearchValue);
			if (strval($this->kec_nama->AdvancedSearch->SearchValue) <> "") {
				$sFilterWrk = "`kec_nama`" . ew_SearchString("=", $this->kec_nama->AdvancedSearch->SearchValue, EW_DATATYPE_STRING, "");
			$sSqlWrk = "SELECT `kec_nama`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kec`";
			$sWhereWrk = "";
			$this->kec_nama->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->kec_nama, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = Conn()->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = ew_HtmlEncode($rswrk->fields('DispFld'));
					$this->kec_nama->EditValue = $this->kec_nama->DisplayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->kec_nama->EditValue = ew_HtmlEncode($this->kec_nama->AdvancedSearch->SearchValue);
				}
			} else {
				$this->kec_nama->EditValue = NULL;
			}
			$this->kec_nama->PlaceHolder = ew_RemoveHtml($this->kec_nama->FldCaption());

			// desa_nama
			$this->desa_nama->EditAttrs["class"] = "form-control";
			$this->desa_nama->EditCustomAttributes = "";
			$this->desa_nama->EditValue = ew_HtmlEncode($this->desa_nama->AdvancedSearch->SearchValue);
			if (strval($this->desa_nama->AdvancedSearch->SearchValue) <> "") {
				$sFilterWrk = "`desa_nama`" . ew_SearchString("=", $this->desa_nama->AdvancedSearch->SearchValue, EW_DATATYPE_STRING, "");
			$sSqlWrk = "SELECT `desa_nama`, `desa_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `desa`";
			$sWhereWrk = "";
			$this->desa_nama->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->desa_nama, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = Conn()->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = ew_HtmlEncode($rswrk->fields('DispFld'));
					$this->desa_nama->EditValue = $this->desa_nama->DisplayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->desa_nama->EditValue = ew_HtmlEncode($this->desa_nama->AdvancedSearch->SearchValue);
				}
			} else {
				$this->desa_nama->EditValue = NULL;
			}
			$this->desa_nama->PlaceHolder = ew_RemoveHtml($this->desa_nama->FldCaption());

			// id_asal_bibit
			$this->id_asal_bibit->EditAttrs["class"] = "form-control";
			$this->id_asal_bibit->EditCustomAttributes = "";
			$this->id_asal_bibit->EditValue = ew_HtmlEncode($this->id_asal_bibit->AdvancedSearch->SearchValue);
			$this->id_asal_bibit->PlaceHolder = ew_RemoveHtml($this->id_asal_bibit->FldCaption());
		}
		if ($this->RowType == EW_ROWTYPE_ADD || $this->RowType == EW_ROWTYPE_EDIT || $this->RowType == EW_ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->SetupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	function ValidateSearch() {
		global $gsSearchError;

		// Initialize
		$gsSearchError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return TRUE;
		if (!ew_CheckDateDef($this->tgl_tanam->AdvancedSearch->SearchValue)) {
			ew_AddMessage($gsSearchError, $this->tgl_tanam->FldErrMsg());
		}
		if (!ew_CheckDateDef($this->tgl_tanam->AdvancedSearch->SearchValue2)) {
			ew_AddMessage($gsSearchError, $this->tgl_tanam->FldErrMsg());
		}

		// Return validate result
		$ValidateSearch = ($gsSearchError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateSearch = $ValidateSearch && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsSearchError, $sFormCustomError);
		}
		return $ValidateSearch;
	}

	// Load advanced search
	function LoadAdvancedSearch() {
		$this->id->AdvancedSearch->Load();
		$this->tgl_tanam->AdvancedSearch->Load();
		$this->jumlah_tanam->AdvancedSearch->Load();
		$this->jumlah_panen_stek->AdvancedSearch->Load();
		$this->ket->AdvancedSearch->Load();
		$this->var_nama->AdvancedSearch->Load();
		$this->id_gen->AdvancedSearch->Load();
		$this->k_id_kontrak->AdvancedSearch->Load();
		$this->co_nama->AdvancedSearch->Load();
		$this->koord_nama->AdvancedSearch->Load();
		$this->pet_nama->AdvancedSearch->Load();
		$this->prov_nama->AdvancedSearch->Load();
		$this->kab_nama->AdvancedSearch->Load();
		$this->kec_nama->AdvancedSearch->Load();
		$this->desa_nama->AdvancedSearch->Load();
		$this->id_asal_bibit->AdvancedSearch->Load();
	}

	// Set up export options
	function SetupExportOptions() {
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->Add("print");
		$item->Body = "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ewExportLink ewPrint\" title=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\">" . $Language->Phrase("PrinterFriendly") . "</a>";
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->Add("excel");
		$item->Body = "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ewExportLink ewExcel\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\">" . $Language->Phrase("ExportToExcel") . "</a>";
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->Add("word");
		$item->Body = "<a href=\"" . $this->ExportWordUrl . "\" class=\"ewExportLink ewWord\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\">" . $Language->Phrase("ExportToWord") . "</a>";
		$item->Visible = TRUE;

		// Export to Html
		$item = &$this->ExportOptions->Add("html");
		$item->Body = "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ewExportLink ewHtml\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\">" . $Language->Phrase("ExportToHtml") . "</a>";
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->Add("xml");
		$item->Body = "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ewExportLink ewXml\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\">" . $Language->Phrase("ExportToXml") . "</a>";
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->Add("csv");
		$item->Body = "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ewExportLink ewCsv\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\">" . $Language->Phrase("ExportToCsv") . "</a>";
		$item->Visible = FALSE;

		// Export to Pdf
		$item = &$this->ExportOptions->Add("pdf");
		$item->Body = "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ewExportLink ewPdf\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\">" . $Language->Phrase("ExportToPDF") . "</a>";
		$item->Visible = FALSE;

		// Export to Email
		$item = &$this->ExportOptions->Add("email");
		$url = "";
		$item->Body = "<button id=\"emf_bibit\" class=\"ewExportLink ewEmail\" title=\"" . $Language->Phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->Phrase("ExportToEmailText") . "\" onclick=\"ew_EmailDialogShow({lnk:'emf_bibit',hdr:ewLanguage.Phrase('ExportToEmailText'),f:document.fbibitlist,sel:false" . $url . "});\">" . $Language->Phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseImageAndText = TRUE;
		$this->ExportOptions->UseDropDownButton = FALSE;
		if ($this->ExportOptions->UseButtonGroup && ew_IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->Phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->Add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	function ExportData() {
		$utf8 = (strtolower(EW_CHARSET) == "utf-8");
		$bSelectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($bSelectLimit) {
			$this->TotalRecs = $this->ListRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->LoadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EW_EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->SetupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($bSelectLimit)
			$rs = $this->LoadRecordset($this->StartRec-1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		if (!$rs) {
			header("Content-Type:"); // Remove header
			header("Content-Disposition:");
			$this->ShowMessage();
			return;
		}
		$this->ExportDoc = ew_ExportDocument($this, "h");
		$Doc = &$this->ExportDoc;
		if ($bSelectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		} else {

			//$this->StartRec = $this->StartRec;
			//$this->StopRec = $this->StopRec;

		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$ParentTable = "";
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		$Doc->Text .= $sHeader;
		$this->ExportDocument($Doc, $rs, $this->StartRec, $this->StopRec, "");
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		$Doc->Text .= $sFooter;

		// Close recordset
		$rs->Close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$Doc->ExportHeaderAndFooter();

		// Clean output buffer
		if (!EW_DEBUG_ENABLED && ob_get_length())
			ob_end_clean();

		// Write debug message if enabled
		if (EW_DEBUG_ENABLED && $this->Export <> "pdf")
			echo ew_DebugMsg();

		// Output data
		$Doc->Export();
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->Add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup filters of a field
	function SetupLookupFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		if ($pageId == "list") {
			switch ($fld->FldVar) {
			}
		} elseif ($pageId == "extbs") {
			switch ($fld->FldVar) {
		case "x_var_nama":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `var_nama` AS `LinkFld`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `varietas`";
				$sWhereWrk = "";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`var_nama` IN ({filter_value})', "t0" => "200", "fn0" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->var_nama, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_id_gen":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `id_gen` AS `LinkFld`, `id_gen` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `generasi_bibit`";
				$sWhereWrk = "";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`id_gen` IN ({filter_value})', "t0" => "200", "fn0" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->id_gen, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_k_id_kontrak":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `k_id_kontrak` AS `LinkFld`, `k_id_kontrak` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kontrak`";
				$sWhereWrk = "";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`k_id_kontrak` IN ({filter_value})', "t0" => "200", "fn0" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->k_id_kontrak, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_co_nama":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `co_nama` AS `LinkFld`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `co`";
				$sWhereWrk = "";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`co_nama` IN ({filter_value})', "t0" => "200", "fn0" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->co_nama, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_koord_nama":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `koord_nama` AS `LinkFld`, `koord_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `koord`";
				$sWhereWrk = "{filter}";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`koord_nama` IN ({filter_value})', "t0" => "200", "fn0" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->koord_nama, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_pet_nama":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `pet_nama` AS `LinkFld`, `pet_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `petani`";
				$sWhereWrk = "{filter}";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`pet_nama` IN ({filter_value})', "t0" => "200", "fn0" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->pet_nama, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_prov_nama":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `prov_nama` AS `LinkFld`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `prov`";
				$sWhereWrk = "{filter}";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`prov_nama` IN ({filter_value})', "t0" => "200", "fn0" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->prov_nama, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_kab_nama":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `kab_nama` AS `LinkFld`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kab`";
				$sWhereWrk = "{filter}";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`kab_nama` IN ({filter_value})', "t0" => "200", "fn0" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->kab_nama, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_kec_nama":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `kec_nama` AS `LinkFld`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kec`";
				$sWhereWrk = "{filter}";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`kec_nama` IN ({filter_value})', "t0" => "200", "fn0" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->kec_nama, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_desa_nama":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `desa_nama` AS `LinkFld`, `desa_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `desa`";
				$sWhereWrk = "{filter}";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`desa_nama` IN ({filter_value})', "t0" => "200", "fn0" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->desa_nama, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
			}
		}
	}

	// Setup AutoSuggest filters of a field
	function SetupAutoSuggestFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		if ($pageId == "list") {
			switch ($fld->FldVar) {
			}
		} elseif ($pageId == "extbs") {
			switch ($fld->FldVar) {
		case "x_koord_nama":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `koord_nama`, `koord_nama` AS `DispFld` FROM `koord`";
				$sWhereWrk = "`koord_nama` LIKE '{query_value}%'";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->koord_nama, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_pet_nama":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `pet_nama`, `pet_nama` AS `DispFld` FROM `petani`";
				$sWhereWrk = "`pet_nama` LIKE '{query_value}%'";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->pet_nama, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_prov_nama":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `prov_nama`, `prov_nama` AS `DispFld` FROM `prov`";
				$sWhereWrk = "`prov_nama` LIKE '{query_value}%'";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->prov_nama, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_kab_nama":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `kab_nama`, `kab_nama` AS `DispFld` FROM `kab`";
				$sWhereWrk = "`kab_nama` LIKE '{query_value}%'";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->kab_nama, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_kec_nama":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `kec_nama`, `kec_nama` AS `DispFld` FROM `kec`";
				$sWhereWrk = "`kec_nama` LIKE '{query_value}%'";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->kec_nama, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_desa_nama":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `desa_nama`, `desa_nama` AS `DispFld` FROM `desa`";
				$sWhereWrk = "`desa_nama` LIKE '{query_value}%'";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->desa_nama, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($bibit_list)) $bibit_list = new cbibit_list();

// Page init
$bibit_list->Page_Init();

// Page main
$bibit_list->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$bibit_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if ($bibit->Export == "") { ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "list";
var CurrentForm = fbibitlist = new ew_Form("fbibitlist", "list");
fbibitlist.FormKeyCountName = '<?php echo $bibit_list->FormKeyCountName ?>';

// Form_CustomValidate event
fbibitlist.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fbibitlist.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbibitlist.Lists["x_var_nama"] = {"LinkField":"x_var_nama","Ajax":true,"AutoFill":false,"DisplayFields":["x_var_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"varietas"};
fbibitlist.Lists["x_var_nama"].Data = "<?php echo $bibit_list->var_nama->LookupFilterQuery(FALSE, "list") ?>";
fbibitlist.Lists["x_id_gen"] = {"LinkField":"x_id_gen","Ajax":true,"AutoFill":false,"DisplayFields":["x_id_gen","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"generasi_bibit"};
fbibitlist.Lists["x_id_gen"].Data = "<?php echo $bibit_list->id_gen->LookupFilterQuery(FALSE, "list") ?>";
fbibitlist.Lists["x_k_id_kontrak"] = {"LinkField":"x_k_id_kontrak","Ajax":true,"AutoFill":false,"DisplayFields":["x_k_id_kontrak","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kontrak"};
fbibitlist.Lists["x_k_id_kontrak"].Data = "<?php echo $bibit_list->k_id_kontrak->LookupFilterQuery(FALSE, "list") ?>";
fbibitlist.Lists["x_co_nama"] = {"LinkField":"x_co_nama","Ajax":true,"AutoFill":false,"DisplayFields":["x_co_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"co"};
fbibitlist.Lists["x_co_nama"].Data = "<?php echo $bibit_list->co_nama->LookupFilterQuery(FALSE, "list") ?>";
fbibitlist.Lists["x_koord_nama"] = {"LinkField":"x_koord_nama","Ajax":true,"AutoFill":false,"DisplayFields":["x_koord_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"koord"};
fbibitlist.Lists["x_koord_nama"].Data = "<?php echo $bibit_list->koord_nama->LookupFilterQuery(FALSE, "list") ?>";
fbibitlist.AutoSuggests["x_koord_nama"] = <?php echo json_encode(array("data" => "ajax=autosuggest&" . $bibit_list->koord_nama->LookupFilterQuery(TRUE, "list"))) ?>;
fbibitlist.Lists["x_pet_nama"] = {"LinkField":"x_pet_nama","Ajax":true,"AutoFill":false,"DisplayFields":["x_pet_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"petani"};
fbibitlist.Lists["x_pet_nama"].Data = "<?php echo $bibit_list->pet_nama->LookupFilterQuery(FALSE, "list") ?>";
fbibitlist.AutoSuggests["x_pet_nama"] = <?php echo json_encode(array("data" => "ajax=autosuggest&" . $bibit_list->pet_nama->LookupFilterQuery(TRUE, "list"))) ?>;
fbibitlist.Lists["x_prov_nama"] = {"LinkField":"x_prov_nama","Ajax":true,"AutoFill":false,"DisplayFields":["x_prov_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"prov"};
fbibitlist.Lists["x_prov_nama"].Data = "<?php echo $bibit_list->prov_nama->LookupFilterQuery(FALSE, "list") ?>";
fbibitlist.AutoSuggests["x_prov_nama"] = <?php echo json_encode(array("data" => "ajax=autosuggest&" . $bibit_list->prov_nama->LookupFilterQuery(TRUE, "list"))) ?>;
fbibitlist.Lists["x_kab_nama"] = {"LinkField":"x_kab_nama","Ajax":true,"AutoFill":false,"DisplayFields":["x_kab_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kab"};
fbibitlist.Lists["x_kab_nama"].Data = "<?php echo $bibit_list->kab_nama->LookupFilterQuery(FALSE, "list") ?>";
fbibitlist.AutoSuggests["x_kab_nama"] = <?php echo json_encode(array("data" => "ajax=autosuggest&" . $bibit_list->kab_nama->LookupFilterQuery(TRUE, "list"))) ?>;
fbibitlist.Lists["x_kec_nama"] = {"LinkField":"x_kec_nama","Ajax":true,"AutoFill":false,"DisplayFields":["x_kec_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kec"};
fbibitlist.Lists["x_kec_nama"].Data = "<?php echo $bibit_list->kec_nama->LookupFilterQuery(FALSE, "list") ?>";
fbibitlist.AutoSuggests["x_kec_nama"] = <?php echo json_encode(array("data" => "ajax=autosuggest&" . $bibit_list->kec_nama->LookupFilterQuery(TRUE, "list"))) ?>;
fbibitlist.Lists["x_desa_nama"] = {"LinkField":"x_desa_nama","Ajax":true,"AutoFill":false,"DisplayFields":["x_desa_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"desa"};
fbibitlist.Lists["x_desa_nama"].Data = "<?php echo $bibit_list->desa_nama->LookupFilterQuery(FALSE, "list") ?>";
fbibitlist.AutoSuggests["x_desa_nama"] = <?php echo json_encode(array("data" => "ajax=autosuggest&" . $bibit_list->desa_nama->LookupFilterQuery(TRUE, "list"))) ?>;
fbibitlist.Lists["x_id_asal_bibit"] = {"LinkField":"x_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_tgl_tanam","x_gen_bibit","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"tanam_bibit"};
fbibitlist.Lists["x_id_asal_bibit"].Data = "<?php echo $bibit_list->id_asal_bibit->LookupFilterQuery(FALSE, "list") ?>";
fbibitlist.AutoSuggests["x_id_asal_bibit"] = <?php echo json_encode(array("data" => "ajax=autosuggest&" . $bibit_list->id_asal_bibit->LookupFilterQuery(TRUE, "list"))) ?>;

// Form object for search
var CurrentSearchForm = fbibitlistsrch = new ew_Form("fbibitlistsrch");

// Validate function for search
fbibitlistsrch.Validate = function(fobj) {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	fobj = fobj || this.Form;
	var infix = "";
	elm = this.GetElements("x" + infix + "_tgl_tanam");
	if (elm && !ew_CheckDateDef(elm.value))
		return this.OnError(elm, "<?php echo ew_JsEncode2($bibit->tgl_tanam->FldErrMsg()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fbibitlistsrch.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fbibitlistsrch.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbibitlistsrch.Lists["x_var_nama"] = {"LinkField":"x_var_nama","Ajax":true,"AutoFill":false,"DisplayFields":["x_var_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"varietas"};
fbibitlistsrch.Lists["x_var_nama"].Data = "<?php echo $bibit_list->var_nama->LookupFilterQuery(FALSE, "extbs") ?>";
fbibitlistsrch.Lists["x_id_gen"] = {"LinkField":"x_id_gen","Ajax":true,"AutoFill":false,"DisplayFields":["x_id_gen","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"generasi_bibit"};
fbibitlistsrch.Lists["x_id_gen"].Data = "<?php echo $bibit_list->id_gen->LookupFilterQuery(FALSE, "extbs") ?>";
fbibitlistsrch.Lists["x_k_id_kontrak"] = {"LinkField":"x_k_id_kontrak","Ajax":true,"AutoFill":false,"DisplayFields":["x_k_id_kontrak","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kontrak"};
fbibitlistsrch.Lists["x_k_id_kontrak"].Data = "<?php echo $bibit_list->k_id_kontrak->LookupFilterQuery(FALSE, "extbs") ?>";
fbibitlistsrch.Lists["x_co_nama"] = {"LinkField":"x_co_nama","Ajax":true,"AutoFill":false,"DisplayFields":["x_co_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"co"};
fbibitlistsrch.Lists["x_co_nama"].Data = "<?php echo $bibit_list->co_nama->LookupFilterQuery(FALSE, "extbs") ?>";
fbibitlistsrch.Lists["x_koord_nama"] = {"LinkField":"x_koord_nama","Ajax":true,"AutoFill":false,"DisplayFields":["x_koord_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"koord"};
fbibitlistsrch.Lists["x_koord_nama"].Data = "<?php echo $bibit_list->koord_nama->LookupFilterQuery(FALSE, "extbs") ?>";
fbibitlistsrch.AutoSuggests["x_koord_nama"] = <?php echo json_encode(array("data" => "ajax=autosuggest&" . $bibit_list->koord_nama->LookupFilterQuery(TRUE, "extbs"))) ?>;
fbibitlistsrch.Lists["x_pet_nama"] = {"LinkField":"x_pet_nama","Ajax":true,"AutoFill":false,"DisplayFields":["x_pet_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"petani"};
fbibitlistsrch.Lists["x_pet_nama"].Data = "<?php echo $bibit_list->pet_nama->LookupFilterQuery(FALSE, "extbs") ?>";
fbibitlistsrch.AutoSuggests["x_pet_nama"] = <?php echo json_encode(array("data" => "ajax=autosuggest&" . $bibit_list->pet_nama->LookupFilterQuery(TRUE, "extbs"))) ?>;
fbibitlistsrch.Lists["x_prov_nama"] = {"LinkField":"x_prov_nama","Ajax":true,"AutoFill":false,"DisplayFields":["x_prov_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"prov"};
fbibitlistsrch.Lists["x_prov_nama"].Data = "<?php echo $bibit_list->prov_nama->LookupFilterQuery(FALSE, "extbs") ?>";
fbibitlistsrch.AutoSuggests["x_prov_nama"] = <?php echo json_encode(array("data" => "ajax=autosuggest&" . $bibit_list->prov_nama->LookupFilterQuery(TRUE, "extbs"))) ?>;
fbibitlistsrch.Lists["x_kab_nama"] = {"LinkField":"x_kab_nama","Ajax":true,"AutoFill":false,"DisplayFields":["x_kab_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kab"};
fbibitlistsrch.Lists["x_kab_nama"].Data = "<?php echo $bibit_list->kab_nama->LookupFilterQuery(FALSE, "extbs") ?>";
fbibitlistsrch.AutoSuggests["x_kab_nama"] = <?php echo json_encode(array("data" => "ajax=autosuggest&" . $bibit_list->kab_nama->LookupFilterQuery(TRUE, "extbs"))) ?>;
fbibitlistsrch.Lists["x_kec_nama"] = {"LinkField":"x_kec_nama","Ajax":true,"AutoFill":false,"DisplayFields":["x_kec_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kec"};
fbibitlistsrch.Lists["x_kec_nama"].Data = "<?php echo $bibit_list->kec_nama->LookupFilterQuery(FALSE, "extbs") ?>";
fbibitlistsrch.AutoSuggests["x_kec_nama"] = <?php echo json_encode(array("data" => "ajax=autosuggest&" . $bibit_list->kec_nama->LookupFilterQuery(TRUE, "extbs"))) ?>;
fbibitlistsrch.Lists["x_desa_nama"] = {"LinkField":"x_desa_nama","Ajax":true,"AutoFill":false,"DisplayFields":["x_desa_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"desa"};
fbibitlistsrch.Lists["x_desa_nama"].Data = "<?php echo $bibit_list->desa_nama->LookupFilterQuery(FALSE, "extbs") ?>";
fbibitlistsrch.AutoSuggests["x_desa_nama"] = <?php echo json_encode(array("data" => "ajax=autosuggest&" . $bibit_list->desa_nama->LookupFilterQuery(TRUE, "extbs"))) ?>;

// Init search panel as collapsed
if (fbibitlistsrch) fbibitlistsrch.InitSearchPanel = true;
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if ($bibit->Export == "") { ?>
<div class="ewToolbar">
<?php if ($bibit_list->TotalRecs > 0 && $bibit_list->ExportOptions->Visible()) { ?>
<?php $bibit_list->ExportOptions->Render("body") ?>
<?php } ?>
<?php if ($bibit_list->SearchOptions->Visible()) { ?>
<?php $bibit_list->SearchOptions->Render("body") ?>
<?php } ?>
<?php if ($bibit_list->FilterOptions->Visible()) { ?>
<?php $bibit_list->FilterOptions->Render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
	$bSelectLimit = $bibit_list->UseSelectLimit;
	if ($bSelectLimit) {
		if ($bibit_list->TotalRecs <= 0)
			$bibit_list->TotalRecs = $bibit->ListRecordCount();
	} else {
		if (!$bibit_list->Recordset && ($bibit_list->Recordset = $bibit_list->LoadRecordset()))
			$bibit_list->TotalRecs = $bibit_list->Recordset->RecordCount();
	}
	$bibit_list->StartRec = 1;
	if ($bibit_list->DisplayRecs <= 0 || ($bibit->Export <> "" && $bibit->ExportAll)) // Display all records
		$bibit_list->DisplayRecs = $bibit_list->TotalRecs;
	if (!($bibit->Export <> "" && $bibit->ExportAll))
		$bibit_list->SetupStartRec(); // Set up start record position
	if ($bSelectLimit)
		$bibit_list->Recordset = $bibit_list->LoadRecordset($bibit_list->StartRec-1, $bibit_list->DisplayRecs);

	// Set no record found message
	if ($bibit->CurrentAction == "" && $bibit_list->TotalRecs == 0) {
		if (!$Security->CanList())
			$bibit_list->setWarningMessage(ew_DeniedMsg());
		if ($bibit_list->SearchWhere == "0=101")
			$bibit_list->setWarningMessage($Language->Phrase("EnterSearchCriteria"));
		else
			$bibit_list->setWarningMessage($Language->Phrase("NoRecord"));
	}
$bibit_list->RenderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if ($bibit->Export == "" && $bibit->CurrentAction == "") { ?>
<form name="fbibitlistsrch" id="fbibitlistsrch" class="form-inline ewForm ewExtSearchForm" action="<?php echo ew_CurrentPage() ?>">
<?php $SearchPanelClass = ($bibit_list->SearchWhere <> "") ? " in" : ""; ?>
<div id="fbibitlistsrch_SearchPanel" class="ewSearchPanel collapse<?php echo $SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="bibit">
	<div class="ewBasicSearch">
<?php
if ($gsSearchError == "")
	$bibit_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$bibit->RowType = EW_ROWTYPE_SEARCH;

// Render row
$bibit->ResetAttrs();
$bibit_list->RenderRow();
?>
<div id="xsr_1" class="ewRow">
<?php if ($bibit->tgl_tanam->Visible) { // tgl_tanam ?>
	<div id="xsc_tgl_tanam" class="ewCell form-group">
		<label for="x_tgl_tanam" class="ewSearchCaption ewLabel"><?php echo $bibit->tgl_tanam->FldCaption() ?></label>
		<span class="ewSearchOperator"><select name="z_tgl_tanam" id="z_tgl_tanam" class="form-control" onchange="ewForms(this).SrchOprChanged(this);"><option value="="<?php echo ($bibit->tgl_tanam->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->Phrase("EQUAL") ?></option><option value="<>"<?php echo ($bibit->tgl_tanam->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->Phrase("<>") ?></option><option value="<"<?php echo ($bibit->tgl_tanam->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->Phrase("<") ?></option><option value="<="<?php echo ($bibit->tgl_tanam->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->Phrase("<=") ?></option><option value=">"<?php echo ($bibit->tgl_tanam->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->Phrase(">") ?></option><option value=">="<?php echo ($bibit->tgl_tanam->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->Phrase(">=") ?></option><option value="IS NULL"<?php echo ($bibit->tgl_tanam->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->Phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($bibit->tgl_tanam->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->Phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($bibit->tgl_tanam->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->Phrase("BETWEEN") ?></option></select></span>
		<span class="ewSearchField">
<input type="text" data-table="bibit" data-field="x_tgl_tanam" name="x_tgl_tanam" id="x_tgl_tanam" placeholder="<?php echo ew_HtmlEncode($bibit->tgl_tanam->getPlaceHolder()) ?>" value="<?php echo $bibit->tgl_tanam->EditValue ?>"<?php echo $bibit->tgl_tanam->EditAttributes() ?>>
<?php if (!$bibit->tgl_tanam->ReadOnly && !$bibit->tgl_tanam->Disabled && !isset($bibit->tgl_tanam->EditAttrs["readonly"]) && !isset($bibit->tgl_tanam->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("fbibitlistsrch", "x_tgl_tanam", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		<span class="ewSearchCond btw1_tgl_tanam" style="display: none">&nbsp;<?php echo $Language->Phrase("AND") ?>&nbsp;</span>
		<span class="ewSearchField btw1_tgl_tanam" style="display: none">
<input type="text" data-table="bibit" data-field="x_tgl_tanam" name="y_tgl_tanam" id="y_tgl_tanam" placeholder="<?php echo ew_HtmlEncode($bibit->tgl_tanam->getPlaceHolder()) ?>" value="<?php echo $bibit->tgl_tanam->EditValue2 ?>"<?php echo $bibit->tgl_tanam->EditAttributes() ?>>
<?php if (!$bibit->tgl_tanam->ReadOnly && !$bibit->tgl_tanam->Disabled && !isset($bibit->tgl_tanam->EditAttrs["readonly"]) && !isset($bibit->tgl_tanam->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("fbibitlistsrch", "y_tgl_tanam", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ewRow">
<?php if ($bibit->var_nama->Visible) { // var_nama ?>
	<div id="xsc_var_nama" class="ewCell form-group">
		<label for="x_var_nama" class="ewSearchCaption ewLabel"><?php echo $bibit->var_nama->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_var_nama" id="z_var_nama" value="LIKE"></span>
		<span class="ewSearchField">
<select data-table="bibit" data-field="x_var_nama" data-value-separator="<?php echo $bibit->var_nama->DisplayValueSeparatorAttribute() ?>" id="x_var_nama" name="x_var_nama"<?php echo $bibit->var_nama->EditAttributes() ?>>
<?php echo $bibit->var_nama->SelectOptionListHtml("x_var_nama") ?>
</select>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ewRow">
<?php if ($bibit->id_gen->Visible) { // id_gen ?>
	<div id="xsc_id_gen" class="ewCell form-group">
		<label for="x_id_gen" class="ewSearchCaption ewLabel"><?php echo $bibit->id_gen->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_id_gen" id="z_id_gen" value="LIKE"></span>
		<span class="ewSearchField">
<select data-table="bibit" data-field="x_id_gen" data-value-separator="<?php echo $bibit->id_gen->DisplayValueSeparatorAttribute() ?>" id="x_id_gen" name="x_id_gen"<?php echo $bibit->id_gen->EditAttributes() ?>>
<?php echo $bibit->id_gen->SelectOptionListHtml("x_id_gen") ?>
</select>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ewRow">
<?php if ($bibit->k_id_kontrak->Visible) { // k_id_kontrak ?>
	<div id="xsc_k_id_kontrak" class="ewCell form-group">
		<label for="x_k_id_kontrak" class="ewSearchCaption ewLabel"><?php echo $bibit->k_id_kontrak->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_k_id_kontrak" id="z_k_id_kontrak" value="LIKE"></span>
		<span class="ewSearchField">
<select data-table="bibit" data-field="x_k_id_kontrak" data-value-separator="<?php echo $bibit->k_id_kontrak->DisplayValueSeparatorAttribute() ?>" id="x_k_id_kontrak" name="x_k_id_kontrak"<?php echo $bibit->k_id_kontrak->EditAttributes() ?>>
<?php echo $bibit->k_id_kontrak->SelectOptionListHtml("x_k_id_kontrak") ?>
</select>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_5" class="ewRow">
<?php if ($bibit->co_nama->Visible) { // co_nama ?>
	<div id="xsc_co_nama" class="ewCell form-group">
		<label for="x_co_nama" class="ewSearchCaption ewLabel"><?php echo $bibit->co_nama->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_co_nama" id="z_co_nama" value="LIKE"></span>
		<span class="ewSearchField">
<select data-table="bibit" data-field="x_co_nama" data-value-separator="<?php echo $bibit->co_nama->DisplayValueSeparatorAttribute() ?>" id="x_co_nama" name="x_co_nama"<?php echo $bibit->co_nama->EditAttributes() ?>>
<?php echo $bibit->co_nama->SelectOptionListHtml("x_co_nama") ?>
</select>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_6" class="ewRow">
<?php if ($bibit->koord_nama->Visible) { // koord_nama ?>
	<div id="xsc_koord_nama" class="ewCell form-group">
		<label class="ewSearchCaption ewLabel"><?php echo $bibit->koord_nama->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_koord_nama" id="z_koord_nama" value="LIKE"></span>
		<span class="ewSearchField">
<?php
$wrkonchange = trim(" " . @$bibit->koord_nama->EditAttrs["onchange"]);
if ($wrkonchange <> "") $wrkonchange = " onchange=\"" . ew_JsEncode2($wrkonchange) . "\"";
$bibit->koord_nama->EditAttrs["onchange"] = "";
?>
<span id="as_x_koord_nama" style="white-space: nowrap; z-index: 8900">
	<input type="text" name="sv_x_koord_nama" id="sv_x_koord_nama" value="<?php echo $bibit->koord_nama->EditValue ?>" size="30" maxlength="50" placeholder="<?php echo ew_HtmlEncode($bibit->koord_nama->getPlaceHolder()) ?>" data-placeholder="<?php echo ew_HtmlEncode($bibit->koord_nama->getPlaceHolder()) ?>"<?php echo $bibit->koord_nama->EditAttributes() ?>>
</span>
<input type="hidden" data-table="bibit" data-field="x_koord_nama" data-value-separator="<?php echo $bibit->koord_nama->DisplayValueSeparatorAttribute() ?>" name="x_koord_nama" id="x_koord_nama" value="<?php echo ew_HtmlEncode($bibit->koord_nama->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script type="text/javascript">
fbibitlistsrch.CreateAutoSuggest({"id":"x_koord_nama","forceSelect":false});
</script>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_7" class="ewRow">
<?php if ($bibit->pet_nama->Visible) { // pet_nama ?>
	<div id="xsc_pet_nama" class="ewCell form-group">
		<label class="ewSearchCaption ewLabel"><?php echo $bibit->pet_nama->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_pet_nama" id="z_pet_nama" value="LIKE"></span>
		<span class="ewSearchField">
<?php
$wrkonchange = trim(" " . @$bibit->pet_nama->EditAttrs["onchange"]);
if ($wrkonchange <> "") $wrkonchange = " onchange=\"" . ew_JsEncode2($wrkonchange) . "\"";
$bibit->pet_nama->EditAttrs["onchange"] = "";
?>
<span id="as_x_pet_nama" style="white-space: nowrap; z-index: 8890">
	<input type="text" name="sv_x_pet_nama" id="sv_x_pet_nama" value="<?php echo $bibit->pet_nama->EditValue ?>" size="30" maxlength="50" placeholder="<?php echo ew_HtmlEncode($bibit->pet_nama->getPlaceHolder()) ?>" data-placeholder="<?php echo ew_HtmlEncode($bibit->pet_nama->getPlaceHolder()) ?>"<?php echo $bibit->pet_nama->EditAttributes() ?>>
</span>
<input type="hidden" data-table="bibit" data-field="x_pet_nama" data-value-separator="<?php echo $bibit->pet_nama->DisplayValueSeparatorAttribute() ?>" name="x_pet_nama" id="x_pet_nama" value="<?php echo ew_HtmlEncode($bibit->pet_nama->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script type="text/javascript">
fbibitlistsrch.CreateAutoSuggest({"id":"x_pet_nama","forceSelect":false});
</script>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_8" class="ewRow">
<?php if ($bibit->prov_nama->Visible) { // prov_nama ?>
	<div id="xsc_prov_nama" class="ewCell form-group">
		<label class="ewSearchCaption ewLabel"><?php echo $bibit->prov_nama->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_prov_nama" id="z_prov_nama" value="LIKE"></span>
		<span class="ewSearchField">
<?php
$wrkonchange = trim(" " . @$bibit->prov_nama->EditAttrs["onchange"]);
if ($wrkonchange <> "") $wrkonchange = " onchange=\"" . ew_JsEncode2($wrkonchange) . "\"";
$bibit->prov_nama->EditAttrs["onchange"] = "";
?>
<span id="as_x_prov_nama" style="white-space: nowrap; z-index: 8880">
	<input type="text" name="sv_x_prov_nama" id="sv_x_prov_nama" value="<?php echo $bibit->prov_nama->EditValue ?>" size="30" maxlength="50" placeholder="<?php echo ew_HtmlEncode($bibit->prov_nama->getPlaceHolder()) ?>" data-placeholder="<?php echo ew_HtmlEncode($bibit->prov_nama->getPlaceHolder()) ?>"<?php echo $bibit->prov_nama->EditAttributes() ?>>
</span>
<input type="hidden" data-table="bibit" data-field="x_prov_nama" data-value-separator="<?php echo $bibit->prov_nama->DisplayValueSeparatorAttribute() ?>" name="x_prov_nama" id="x_prov_nama" value="<?php echo ew_HtmlEncode($bibit->prov_nama->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script type="text/javascript">
fbibitlistsrch.CreateAutoSuggest({"id":"x_prov_nama","forceSelect":false});
</script>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_9" class="ewRow">
<?php if ($bibit->kab_nama->Visible) { // kab_nama ?>
	<div id="xsc_kab_nama" class="ewCell form-group">
		<label class="ewSearchCaption ewLabel"><?php echo $bibit->kab_nama->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_kab_nama" id="z_kab_nama" value="LIKE"></span>
		<span class="ewSearchField">
<?php
$wrkonchange = trim(" " . @$bibit->kab_nama->EditAttrs["onchange"]);
if ($wrkonchange <> "") $wrkonchange = " onchange=\"" . ew_JsEncode2($wrkonchange) . "\"";
$bibit->kab_nama->EditAttrs["onchange"] = "";
?>
<span id="as_x_kab_nama" style="white-space: nowrap; z-index: 8870">
	<input type="text" name="sv_x_kab_nama" id="sv_x_kab_nama" value="<?php echo $bibit->kab_nama->EditValue ?>" size="30" maxlength="50" placeholder="<?php echo ew_HtmlEncode($bibit->kab_nama->getPlaceHolder()) ?>" data-placeholder="<?php echo ew_HtmlEncode($bibit->kab_nama->getPlaceHolder()) ?>"<?php echo $bibit->kab_nama->EditAttributes() ?>>
</span>
<input type="hidden" data-table="bibit" data-field="x_kab_nama" data-value-separator="<?php echo $bibit->kab_nama->DisplayValueSeparatorAttribute() ?>" name="x_kab_nama" id="x_kab_nama" value="<?php echo ew_HtmlEncode($bibit->kab_nama->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script type="text/javascript">
fbibitlistsrch.CreateAutoSuggest({"id":"x_kab_nama","forceSelect":false});
</script>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_10" class="ewRow">
<?php if ($bibit->kec_nama->Visible) { // kec_nama ?>
	<div id="xsc_kec_nama" class="ewCell form-group">
		<label class="ewSearchCaption ewLabel"><?php echo $bibit->kec_nama->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_kec_nama" id="z_kec_nama" value="LIKE"></span>
		<span class="ewSearchField">
<?php
$wrkonchange = trim(" " . @$bibit->kec_nama->EditAttrs["onchange"]);
if ($wrkonchange <> "") $wrkonchange = " onchange=\"" . ew_JsEncode2($wrkonchange) . "\"";
$bibit->kec_nama->EditAttrs["onchange"] = "";
?>
<span id="as_x_kec_nama" style="white-space: nowrap; z-index: 8860">
	<input type="text" name="sv_x_kec_nama" id="sv_x_kec_nama" value="<?php echo $bibit->kec_nama->EditValue ?>" size="30" maxlength="50" placeholder="<?php echo ew_HtmlEncode($bibit->kec_nama->getPlaceHolder()) ?>" data-placeholder="<?php echo ew_HtmlEncode($bibit->kec_nama->getPlaceHolder()) ?>"<?php echo $bibit->kec_nama->EditAttributes() ?>>
</span>
<input type="hidden" data-table="bibit" data-field="x_kec_nama" data-value-separator="<?php echo $bibit->kec_nama->DisplayValueSeparatorAttribute() ?>" name="x_kec_nama" id="x_kec_nama" value="<?php echo ew_HtmlEncode($bibit->kec_nama->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script type="text/javascript">
fbibitlistsrch.CreateAutoSuggest({"id":"x_kec_nama","forceSelect":false});
</script>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_11" class="ewRow">
<?php if ($bibit->desa_nama->Visible) { // desa_nama ?>
	<div id="xsc_desa_nama" class="ewCell form-group">
		<label class="ewSearchCaption ewLabel"><?php echo $bibit->desa_nama->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_desa_nama" id="z_desa_nama" value="LIKE"></span>
		<span class="ewSearchField">
<?php
$wrkonchange = trim(" " . @$bibit->desa_nama->EditAttrs["onchange"]);
if ($wrkonchange <> "") $wrkonchange = " onchange=\"" . ew_JsEncode2($wrkonchange) . "\"";
$bibit->desa_nama->EditAttrs["onchange"] = "";
?>
<span id="as_x_desa_nama" style="white-space: nowrap; z-index: 8850">
	<input type="text" name="sv_x_desa_nama" id="sv_x_desa_nama" value="<?php echo $bibit->desa_nama->EditValue ?>" size="30" maxlength="50" placeholder="<?php echo ew_HtmlEncode($bibit->desa_nama->getPlaceHolder()) ?>" data-placeholder="<?php echo ew_HtmlEncode($bibit->desa_nama->getPlaceHolder()) ?>"<?php echo $bibit->desa_nama->EditAttributes() ?>>
</span>
<input type="hidden" data-table="bibit" data-field="x_desa_nama" data-value-separator="<?php echo $bibit->desa_nama->DisplayValueSeparatorAttribute() ?>" name="x_desa_nama" id="x_desa_nama" value="<?php echo ew_HtmlEncode($bibit->desa_nama->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script type="text/javascript">
fbibitlistsrch.CreateAutoSuggest({"id":"x_desa_nama","forceSelect":false});
</script>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_12" class="ewRow">
	<div class="ewQuickSearch input-group">
	<input type="text" name="<?php echo EW_TABLE_BASIC_SEARCH ?>" id="<?php echo EW_TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo ew_HtmlEncode($bibit_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo ew_HtmlEncode($Language->Phrase("Search")) ?>">
	<input type="hidden" name="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo ew_HtmlEncode($bibit_list->BasicSearch->getType()) ?>">
	<div class="input-group-btn">
		<button type="button" data-toggle="dropdown" class="btn btn-default"><span id="searchtype"><?php echo $bibit_list->BasicSearch->getTypeNameShort() ?></span><span class="caret"></span></button>
		<ul class="dropdown-menu pull-right" role="menu">
			<li<?php if ($bibit_list->BasicSearch->getType() == "") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this)"><?php echo $Language->Phrase("QuickSearchAuto") ?></a></li>
			<li<?php if ($bibit_list->BasicSearch->getType() == "=") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'=')"><?php echo $Language->Phrase("QuickSearchExact") ?></a></li>
			<li<?php if ($bibit_list->BasicSearch->getType() == "AND") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'AND')"><?php echo $Language->Phrase("QuickSearchAll") ?></a></li>
			<li<?php if ($bibit_list->BasicSearch->getType() == "OR") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'OR')"><?php echo $Language->Phrase("QuickSearchAny") ?></a></li>
		</ul>
	<button class="btn btn-primary ewButton" name="btnsubmit" id="btnsubmit" type="submit"><?php echo $Language->Phrase("SearchBtn") ?></button>
	</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $bibit_list->ShowPageHeader(); ?>
<?php
$bibit_list->ShowMessage();
?>
<?php if ($bibit_list->TotalRecs > 0 || $bibit->CurrentAction <> "") { ?>
<div class="box ewBox ewGrid<?php if ($bibit_list->IsAddOrEdit()) { ?> ewGridAddEdit<?php } ?> bibit">
<?php if ($bibit->Export == "") { ?>
<div class="box-header ewGridUpperPanel">
<?php if ($bibit->CurrentAction <> "gridadd" && $bibit->CurrentAction <> "gridedit") { ?>
<form name="ewPagerForm" class="form-inline ewForm ewPagerForm" action="<?php echo ew_CurrentPage() ?>">
<?php if (!isset($bibit_list->Pager)) $bibit_list->Pager = new cNumericPager($bibit_list->StartRec, $bibit_list->DisplayRecs, $bibit_list->TotalRecs, $bibit_list->RecRange, $bibit_list->AutoHidePager) ?>
<?php if ($bibit_list->Pager->RecordCount > 0 && $bibit_list->Pager->Visible) { ?>
<div class="ewPager">
<div class="ewNumericPage"><ul class="pagination">
	<?php if ($bibit_list->Pager->FirstButton->Enabled) { ?>
	<li><a href="<?php echo $bibit_list->PageUrl() ?>start=<?php echo $bibit_list->Pager->FirstButton->Start ?>"><?php echo $Language->Phrase("PagerFirst") ?></a></li>
	<?php } ?>
	<?php if ($bibit_list->Pager->PrevButton->Enabled) { ?>
	<li><a href="<?php echo $bibit_list->PageUrl() ?>start=<?php echo $bibit_list->Pager->PrevButton->Start ?>"><?php echo $Language->Phrase("PagerPrevious") ?></a></li>
	<?php } ?>
	<?php foreach ($bibit_list->Pager->Items as $PagerItem) { ?>
		<li<?php if (!$PagerItem->Enabled) { echo " class=\" active\""; } ?>><a href="<?php if ($PagerItem->Enabled) { echo $bibit_list->PageUrl() . "start=" . $PagerItem->Start; } else { echo "#"; } ?>"><?php echo $PagerItem->Text ?></a></li>
	<?php } ?>
	<?php if ($bibit_list->Pager->NextButton->Enabled) { ?>
	<li><a href="<?php echo $bibit_list->PageUrl() ?>start=<?php echo $bibit_list->Pager->NextButton->Start ?>"><?php echo $Language->Phrase("PagerNext") ?></a></li>
	<?php } ?>
	<?php if ($bibit_list->Pager->LastButton->Enabled) { ?>
	<li><a href="<?php echo $bibit_list->PageUrl() ?>start=<?php echo $bibit_list->Pager->LastButton->Start ?>"><?php echo $Language->Phrase("PagerLast") ?></a></li>
	<?php } ?>
</ul></div>
</div>
<?php } ?>
<?php if ($bibit_list->Pager->RecordCount > 0) { ?>
<div class="ewPager ewRec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $bibit_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $bibit_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $bibit_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ewListOtherOptions">
<?php
	foreach ($bibit_list->OtherOptions as &$option)
		$option->Render("body");
?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fbibitlist" id="fbibitlist" class="form-inline ewForm ewListForm" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($bibit_list->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $bibit_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="bibit">
<div id="gmp_bibit" class="<?php if (ew_IsResponsiveLayout()) { ?>table-responsive <?php } ?>ewGridMiddlePanel">
<?php if ($bibit_list->TotalRecs > 0 || $bibit->CurrentAction == "gridedit") { ?>
<table id="tbl_bibitlist" class="table ewTable">
<thead>
	<tr class="ewTableHeader">
<?php

// Header row
$bibit_list->RowType = EW_ROWTYPE_HEADER;

// Render list options
$bibit_list->RenderListOptions();

// Render list options (header, left)
$bibit_list->ListOptions->Render("header", "left");
?>
<?php if ($bibit->id->Visible) { // id ?>
	<?php if ($bibit->SortUrl($bibit->id) == "") { ?>
		<th data-name="id" class="<?php echo $bibit->id->HeaderCellClass() ?>"><div id="elh_bibit_id" class="bibit_id"><div class="ewTableHeaderCaption"><?php echo $bibit->id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $bibit->id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $bibit->SortUrl($bibit->id) ?>',1);"><div id="elh_bibit_id" class="bibit_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $bibit->id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($bibit->id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($bibit->id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bibit->tgl_tanam->Visible) { // tgl_tanam ?>
	<?php if ($bibit->SortUrl($bibit->tgl_tanam) == "") { ?>
		<th data-name="tgl_tanam" class="<?php echo $bibit->tgl_tanam->HeaderCellClass() ?>"><div id="elh_bibit_tgl_tanam" class="bibit_tgl_tanam"><div class="ewTableHeaderCaption"><?php echo $bibit->tgl_tanam->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tgl_tanam" class="<?php echo $bibit->tgl_tanam->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $bibit->SortUrl($bibit->tgl_tanam) ?>',1);"><div id="elh_bibit_tgl_tanam" class="bibit_tgl_tanam">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $bibit->tgl_tanam->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($bibit->tgl_tanam->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($bibit->tgl_tanam->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bibit->jumlah_tanam->Visible) { // jumlah_tanam ?>
	<?php if ($bibit->SortUrl($bibit->jumlah_tanam) == "") { ?>
		<th data-name="jumlah_tanam" class="<?php echo $bibit->jumlah_tanam->HeaderCellClass() ?>"><div id="elh_bibit_jumlah_tanam" class="bibit_jumlah_tanam"><div class="ewTableHeaderCaption"><?php echo $bibit->jumlah_tanam->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jumlah_tanam" class="<?php echo $bibit->jumlah_tanam->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $bibit->SortUrl($bibit->jumlah_tanam) ?>',1);"><div id="elh_bibit_jumlah_tanam" class="bibit_jumlah_tanam">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $bibit->jumlah_tanam->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($bibit->jumlah_tanam->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($bibit->jumlah_tanam->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bibit->jumlah_panen_stek->Visible) { // jumlah_panen_stek ?>
	<?php if ($bibit->SortUrl($bibit->jumlah_panen_stek) == "") { ?>
		<th data-name="jumlah_panen_stek" class="<?php echo $bibit->jumlah_panen_stek->HeaderCellClass() ?>"><div id="elh_bibit_jumlah_panen_stek" class="bibit_jumlah_panen_stek"><div class="ewTableHeaderCaption"><?php echo $bibit->jumlah_panen_stek->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jumlah_panen_stek" class="<?php echo $bibit->jumlah_panen_stek->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $bibit->SortUrl($bibit->jumlah_panen_stek) ?>',1);"><div id="elh_bibit_jumlah_panen_stek" class="bibit_jumlah_panen_stek">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $bibit->jumlah_panen_stek->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($bibit->jumlah_panen_stek->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($bibit->jumlah_panen_stek->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bibit->ket->Visible) { // ket ?>
	<?php if ($bibit->SortUrl($bibit->ket) == "") { ?>
		<th data-name="ket" class="<?php echo $bibit->ket->HeaderCellClass() ?>"><div id="elh_bibit_ket" class="bibit_ket"><div class="ewTableHeaderCaption"><?php echo $bibit->ket->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ket" class="<?php echo $bibit->ket->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $bibit->SortUrl($bibit->ket) ?>',1);"><div id="elh_bibit_ket" class="bibit_ket">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $bibit->ket->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($bibit->ket->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($bibit->ket->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bibit->var_nama->Visible) { // var_nama ?>
	<?php if ($bibit->SortUrl($bibit->var_nama) == "") { ?>
		<th data-name="var_nama" class="<?php echo $bibit->var_nama->HeaderCellClass() ?>"><div id="elh_bibit_var_nama" class="bibit_var_nama"><div class="ewTableHeaderCaption"><?php echo $bibit->var_nama->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="var_nama" class="<?php echo $bibit->var_nama->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $bibit->SortUrl($bibit->var_nama) ?>',1);"><div id="elh_bibit_var_nama" class="bibit_var_nama">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $bibit->var_nama->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($bibit->var_nama->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($bibit->var_nama->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bibit->id_gen->Visible) { // id_gen ?>
	<?php if ($bibit->SortUrl($bibit->id_gen) == "") { ?>
		<th data-name="id_gen" class="<?php echo $bibit->id_gen->HeaderCellClass() ?>"><div id="elh_bibit_id_gen" class="bibit_id_gen"><div class="ewTableHeaderCaption"><?php echo $bibit->id_gen->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id_gen" class="<?php echo $bibit->id_gen->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $bibit->SortUrl($bibit->id_gen) ?>',1);"><div id="elh_bibit_id_gen" class="bibit_id_gen">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $bibit->id_gen->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($bibit->id_gen->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($bibit->id_gen->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bibit->k_id_kontrak->Visible) { // k_id_kontrak ?>
	<?php if ($bibit->SortUrl($bibit->k_id_kontrak) == "") { ?>
		<th data-name="k_id_kontrak" class="<?php echo $bibit->k_id_kontrak->HeaderCellClass() ?>"><div id="elh_bibit_k_id_kontrak" class="bibit_k_id_kontrak"><div class="ewTableHeaderCaption"><?php echo $bibit->k_id_kontrak->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="k_id_kontrak" class="<?php echo $bibit->k_id_kontrak->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $bibit->SortUrl($bibit->k_id_kontrak) ?>',1);"><div id="elh_bibit_k_id_kontrak" class="bibit_k_id_kontrak">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $bibit->k_id_kontrak->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($bibit->k_id_kontrak->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($bibit->k_id_kontrak->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bibit->co_nama->Visible) { // co_nama ?>
	<?php if ($bibit->SortUrl($bibit->co_nama) == "") { ?>
		<th data-name="co_nama" class="<?php echo $bibit->co_nama->HeaderCellClass() ?>"><div id="elh_bibit_co_nama" class="bibit_co_nama"><div class="ewTableHeaderCaption"><?php echo $bibit->co_nama->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="co_nama" class="<?php echo $bibit->co_nama->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $bibit->SortUrl($bibit->co_nama) ?>',1);"><div id="elh_bibit_co_nama" class="bibit_co_nama">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $bibit->co_nama->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($bibit->co_nama->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($bibit->co_nama->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bibit->koord_nama->Visible) { // koord_nama ?>
	<?php if ($bibit->SortUrl($bibit->koord_nama) == "") { ?>
		<th data-name="koord_nama" class="<?php echo $bibit->koord_nama->HeaderCellClass() ?>"><div id="elh_bibit_koord_nama" class="bibit_koord_nama"><div class="ewTableHeaderCaption"><?php echo $bibit->koord_nama->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="koord_nama" class="<?php echo $bibit->koord_nama->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $bibit->SortUrl($bibit->koord_nama) ?>',1);"><div id="elh_bibit_koord_nama" class="bibit_koord_nama">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $bibit->koord_nama->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($bibit->koord_nama->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($bibit->koord_nama->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bibit->pet_nama->Visible) { // pet_nama ?>
	<?php if ($bibit->SortUrl($bibit->pet_nama) == "") { ?>
		<th data-name="pet_nama" class="<?php echo $bibit->pet_nama->HeaderCellClass() ?>"><div id="elh_bibit_pet_nama" class="bibit_pet_nama"><div class="ewTableHeaderCaption"><?php echo $bibit->pet_nama->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pet_nama" class="<?php echo $bibit->pet_nama->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $bibit->SortUrl($bibit->pet_nama) ?>',1);"><div id="elh_bibit_pet_nama" class="bibit_pet_nama">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $bibit->pet_nama->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($bibit->pet_nama->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($bibit->pet_nama->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bibit->prov_nama->Visible) { // prov_nama ?>
	<?php if ($bibit->SortUrl($bibit->prov_nama) == "") { ?>
		<th data-name="prov_nama" class="<?php echo $bibit->prov_nama->HeaderCellClass() ?>"><div id="elh_bibit_prov_nama" class="bibit_prov_nama"><div class="ewTableHeaderCaption"><?php echo $bibit->prov_nama->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="prov_nama" class="<?php echo $bibit->prov_nama->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $bibit->SortUrl($bibit->prov_nama) ?>',1);"><div id="elh_bibit_prov_nama" class="bibit_prov_nama">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $bibit->prov_nama->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($bibit->prov_nama->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($bibit->prov_nama->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bibit->kab_nama->Visible) { // kab_nama ?>
	<?php if ($bibit->SortUrl($bibit->kab_nama) == "") { ?>
		<th data-name="kab_nama" class="<?php echo $bibit->kab_nama->HeaderCellClass() ?>"><div id="elh_bibit_kab_nama" class="bibit_kab_nama"><div class="ewTableHeaderCaption"><?php echo $bibit->kab_nama->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="kab_nama" class="<?php echo $bibit->kab_nama->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $bibit->SortUrl($bibit->kab_nama) ?>',1);"><div id="elh_bibit_kab_nama" class="bibit_kab_nama">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $bibit->kab_nama->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($bibit->kab_nama->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($bibit->kab_nama->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bibit->kec_nama->Visible) { // kec_nama ?>
	<?php if ($bibit->SortUrl($bibit->kec_nama) == "") { ?>
		<th data-name="kec_nama" class="<?php echo $bibit->kec_nama->HeaderCellClass() ?>"><div id="elh_bibit_kec_nama" class="bibit_kec_nama"><div class="ewTableHeaderCaption"><?php echo $bibit->kec_nama->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="kec_nama" class="<?php echo $bibit->kec_nama->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $bibit->SortUrl($bibit->kec_nama) ?>',1);"><div id="elh_bibit_kec_nama" class="bibit_kec_nama">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $bibit->kec_nama->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($bibit->kec_nama->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($bibit->kec_nama->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bibit->desa_nama->Visible) { // desa_nama ?>
	<?php if ($bibit->SortUrl($bibit->desa_nama) == "") { ?>
		<th data-name="desa_nama" class="<?php echo $bibit->desa_nama->HeaderCellClass() ?>"><div id="elh_bibit_desa_nama" class="bibit_desa_nama"><div class="ewTableHeaderCaption"><?php echo $bibit->desa_nama->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="desa_nama" class="<?php echo $bibit->desa_nama->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $bibit->SortUrl($bibit->desa_nama) ?>',1);"><div id="elh_bibit_desa_nama" class="bibit_desa_nama">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $bibit->desa_nama->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($bibit->desa_nama->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($bibit->desa_nama->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bibit->id_asal_bibit->Visible) { // id_asal_bibit ?>
	<?php if ($bibit->SortUrl($bibit->id_asal_bibit) == "") { ?>
		<th data-name="id_asal_bibit" class="<?php echo $bibit->id_asal_bibit->HeaderCellClass() ?>"><div id="elh_bibit_id_asal_bibit" class="bibit_id_asal_bibit"><div class="ewTableHeaderCaption"><?php echo $bibit->id_asal_bibit->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id_asal_bibit" class="<?php echo $bibit->id_asal_bibit->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $bibit->SortUrl($bibit->id_asal_bibit) ?>',1);"><div id="elh_bibit_id_asal_bibit" class="bibit_id_asal_bibit">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $bibit->id_asal_bibit->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($bibit->id_asal_bibit->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($bibit->id_asal_bibit->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$bibit_list->ListOptions->Render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($bibit->ExportAll && $bibit->Export <> "") {
	$bibit_list->StopRec = $bibit_list->TotalRecs;
} else {

	// Set the last record to display
	if ($bibit_list->TotalRecs > $bibit_list->StartRec + $bibit_list->DisplayRecs - 1)
		$bibit_list->StopRec = $bibit_list->StartRec + $bibit_list->DisplayRecs - 1;
	else
		$bibit_list->StopRec = $bibit_list->TotalRecs;
}
$bibit_list->RecCnt = $bibit_list->StartRec - 1;
if ($bibit_list->Recordset && !$bibit_list->Recordset->EOF) {
	$bibit_list->Recordset->MoveFirst();
	$bSelectLimit = $bibit_list->UseSelectLimit;
	if (!$bSelectLimit && $bibit_list->StartRec > 1)
		$bibit_list->Recordset->Move($bibit_list->StartRec - 1);
} elseif (!$bibit->AllowAddDeleteRow && $bibit_list->StopRec == 0) {
	$bibit_list->StopRec = $bibit->GridAddRowCount;
}

// Initialize aggregate
$bibit->RowType = EW_ROWTYPE_AGGREGATEINIT;
$bibit->ResetAttrs();
$bibit_list->RenderRow();
while ($bibit_list->RecCnt < $bibit_list->StopRec) {
	$bibit_list->RecCnt++;
	if (intval($bibit_list->RecCnt) >= intval($bibit_list->StartRec)) {
		$bibit_list->RowCnt++;

		// Set up key count
		$bibit_list->KeyCount = $bibit_list->RowIndex;

		// Init row class and style
		$bibit->ResetAttrs();
		$bibit->CssClass = "";
		if ($bibit->CurrentAction == "gridadd") {
		} else {
			$bibit_list->LoadRowValues($bibit_list->Recordset); // Load row values
		}
		$bibit->RowType = EW_ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$bibit->RowAttrs = array_merge($bibit->RowAttrs, array('data-rowindex'=>$bibit_list->RowCnt, 'id'=>'r' . $bibit_list->RowCnt . '_bibit', 'data-rowtype'=>$bibit->RowType));

		// Render row
		$bibit_list->RenderRow();

		// Render list options
		$bibit_list->RenderListOptions();
?>
	<tr<?php echo $bibit->RowAttributes() ?>>
<?php

// Render list options (body, left)
$bibit_list->ListOptions->Render("body", "left", $bibit_list->RowCnt);
?>
	<?php if ($bibit->id->Visible) { // id ?>
		<td data-name="id"<?php echo $bibit->id->CellAttributes() ?>>
<span id="el<?php echo $bibit_list->RowCnt ?>_bibit_id" class="bibit_id">
<span<?php echo $bibit->id->ViewAttributes() ?>>
<?php echo $bibit->id->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bibit->tgl_tanam->Visible) { // tgl_tanam ?>
		<td data-name="tgl_tanam"<?php echo $bibit->tgl_tanam->CellAttributes() ?>>
<span id="el<?php echo $bibit_list->RowCnt ?>_bibit_tgl_tanam" class="bibit_tgl_tanam">
<span<?php echo $bibit->tgl_tanam->ViewAttributes() ?>>
<?php echo $bibit->tgl_tanam->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bibit->jumlah_tanam->Visible) { // jumlah_tanam ?>
		<td data-name="jumlah_tanam"<?php echo $bibit->jumlah_tanam->CellAttributes() ?>>
<span id="el<?php echo $bibit_list->RowCnt ?>_bibit_jumlah_tanam" class="bibit_jumlah_tanam">
<span<?php echo $bibit->jumlah_tanam->ViewAttributes() ?>>
<?php echo $bibit->jumlah_tanam->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bibit->jumlah_panen_stek->Visible) { // jumlah_panen_stek ?>
		<td data-name="jumlah_panen_stek"<?php echo $bibit->jumlah_panen_stek->CellAttributes() ?>>
<span id="el<?php echo $bibit_list->RowCnt ?>_bibit_jumlah_panen_stek" class="bibit_jumlah_panen_stek">
<span<?php echo $bibit->jumlah_panen_stek->ViewAttributes() ?>>
<?php echo $bibit->jumlah_panen_stek->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bibit->ket->Visible) { // ket ?>
		<td data-name="ket"<?php echo $bibit->ket->CellAttributes() ?>>
<span id="el<?php echo $bibit_list->RowCnt ?>_bibit_ket" class="bibit_ket">
<span<?php echo $bibit->ket->ViewAttributes() ?>>
<?php echo $bibit->ket->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bibit->var_nama->Visible) { // var_nama ?>
		<td data-name="var_nama"<?php echo $bibit->var_nama->CellAttributes() ?>>
<span id="el<?php echo $bibit_list->RowCnt ?>_bibit_var_nama" class="bibit_var_nama">
<span<?php echo $bibit->var_nama->ViewAttributes() ?>>
<?php echo $bibit->var_nama->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bibit->id_gen->Visible) { // id_gen ?>
		<td data-name="id_gen"<?php echo $bibit->id_gen->CellAttributes() ?>>
<span id="el<?php echo $bibit_list->RowCnt ?>_bibit_id_gen" class="bibit_id_gen">
<span<?php echo $bibit->id_gen->ViewAttributes() ?>>
<?php echo $bibit->id_gen->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bibit->k_id_kontrak->Visible) { // k_id_kontrak ?>
		<td data-name="k_id_kontrak"<?php echo $bibit->k_id_kontrak->CellAttributes() ?>>
<span id="el<?php echo $bibit_list->RowCnt ?>_bibit_k_id_kontrak" class="bibit_k_id_kontrak">
<span<?php echo $bibit->k_id_kontrak->ViewAttributes() ?>>
<?php echo $bibit->k_id_kontrak->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bibit->co_nama->Visible) { // co_nama ?>
		<td data-name="co_nama"<?php echo $bibit->co_nama->CellAttributes() ?>>
<span id="el<?php echo $bibit_list->RowCnt ?>_bibit_co_nama" class="bibit_co_nama">
<span<?php echo $bibit->co_nama->ViewAttributes() ?>>
<?php echo $bibit->co_nama->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bibit->koord_nama->Visible) { // koord_nama ?>
		<td data-name="koord_nama"<?php echo $bibit->koord_nama->CellAttributes() ?>>
<span id="el<?php echo $bibit_list->RowCnt ?>_bibit_koord_nama" class="bibit_koord_nama">
<span<?php echo $bibit->koord_nama->ViewAttributes() ?>>
<?php echo $bibit->koord_nama->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bibit->pet_nama->Visible) { // pet_nama ?>
		<td data-name="pet_nama"<?php echo $bibit->pet_nama->CellAttributes() ?>>
<span id="el<?php echo $bibit_list->RowCnt ?>_bibit_pet_nama" class="bibit_pet_nama">
<span<?php echo $bibit->pet_nama->ViewAttributes() ?>>
<?php echo $bibit->pet_nama->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bibit->prov_nama->Visible) { // prov_nama ?>
		<td data-name="prov_nama"<?php echo $bibit->prov_nama->CellAttributes() ?>>
<span id="el<?php echo $bibit_list->RowCnt ?>_bibit_prov_nama" class="bibit_prov_nama">
<span<?php echo $bibit->prov_nama->ViewAttributes() ?>>
<?php echo $bibit->prov_nama->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bibit->kab_nama->Visible) { // kab_nama ?>
		<td data-name="kab_nama"<?php echo $bibit->kab_nama->CellAttributes() ?>>
<span id="el<?php echo $bibit_list->RowCnt ?>_bibit_kab_nama" class="bibit_kab_nama">
<span<?php echo $bibit->kab_nama->ViewAttributes() ?>>
<?php echo $bibit->kab_nama->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bibit->kec_nama->Visible) { // kec_nama ?>
		<td data-name="kec_nama"<?php echo $bibit->kec_nama->CellAttributes() ?>>
<span id="el<?php echo $bibit_list->RowCnt ?>_bibit_kec_nama" class="bibit_kec_nama">
<span<?php echo $bibit->kec_nama->ViewAttributes() ?>>
<?php echo $bibit->kec_nama->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bibit->desa_nama->Visible) { // desa_nama ?>
		<td data-name="desa_nama"<?php echo $bibit->desa_nama->CellAttributes() ?>>
<span id="el<?php echo $bibit_list->RowCnt ?>_bibit_desa_nama" class="bibit_desa_nama">
<span<?php echo $bibit->desa_nama->ViewAttributes() ?>>
<?php echo $bibit->desa_nama->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($bibit->id_asal_bibit->Visible) { // id_asal_bibit ?>
		<td data-name="id_asal_bibit"<?php echo $bibit->id_asal_bibit->CellAttributes() ?>>
<span id="el<?php echo $bibit_list->RowCnt ?>_bibit_id_asal_bibit" class="bibit_id_asal_bibit">
<span<?php echo $bibit->id_asal_bibit->ViewAttributes() ?>>
<?php echo $bibit->id_asal_bibit->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$bibit_list->ListOptions->Render("body", "right", $bibit_list->RowCnt);
?>
	</tr>
<?php
	}
	if ($bibit->CurrentAction <> "gridadd")
		$bibit_list->Recordset->MoveNext();
}
?>
</tbody>
</table>
<?php } ?>
<?php if ($bibit->CurrentAction == "") { ?>
<input type="hidden" name="a_list" id="a_list" value="">
<?php } ?>
</div>
</form>
<?php

// Close recordset
if ($bibit_list->Recordset)
	$bibit_list->Recordset->Close();
?>
<?php if ($bibit->Export == "") { ?>
<div class="box-footer ewGridLowerPanel">
<?php if ($bibit->CurrentAction <> "gridadd" && $bibit->CurrentAction <> "gridedit") { ?>
<form name="ewPagerForm" class="ewForm form-inline ewPagerForm" action="<?php echo ew_CurrentPage() ?>">
<?php if (!isset($bibit_list->Pager)) $bibit_list->Pager = new cNumericPager($bibit_list->StartRec, $bibit_list->DisplayRecs, $bibit_list->TotalRecs, $bibit_list->RecRange, $bibit_list->AutoHidePager) ?>
<?php if ($bibit_list->Pager->RecordCount > 0 && $bibit_list->Pager->Visible) { ?>
<div class="ewPager">
<div class="ewNumericPage"><ul class="pagination">
	<?php if ($bibit_list->Pager->FirstButton->Enabled) { ?>
	<li><a href="<?php echo $bibit_list->PageUrl() ?>start=<?php echo $bibit_list->Pager->FirstButton->Start ?>"><?php echo $Language->Phrase("PagerFirst") ?></a></li>
	<?php } ?>
	<?php if ($bibit_list->Pager->PrevButton->Enabled) { ?>
	<li><a href="<?php echo $bibit_list->PageUrl() ?>start=<?php echo $bibit_list->Pager->PrevButton->Start ?>"><?php echo $Language->Phrase("PagerPrevious") ?></a></li>
	<?php } ?>
	<?php foreach ($bibit_list->Pager->Items as $PagerItem) { ?>
		<li<?php if (!$PagerItem->Enabled) { echo " class=\" active\""; } ?>><a href="<?php if ($PagerItem->Enabled) { echo $bibit_list->PageUrl() . "start=" . $PagerItem->Start; } else { echo "#"; } ?>"><?php echo $PagerItem->Text ?></a></li>
	<?php } ?>
	<?php if ($bibit_list->Pager->NextButton->Enabled) { ?>
	<li><a href="<?php echo $bibit_list->PageUrl() ?>start=<?php echo $bibit_list->Pager->NextButton->Start ?>"><?php echo $Language->Phrase("PagerNext") ?></a></li>
	<?php } ?>
	<?php if ($bibit_list->Pager->LastButton->Enabled) { ?>
	<li><a href="<?php echo $bibit_list->PageUrl() ?>start=<?php echo $bibit_list->Pager->LastButton->Start ?>"><?php echo $Language->Phrase("PagerLast") ?></a></li>
	<?php } ?>
</ul></div>
</div>
<?php } ?>
<?php if ($bibit_list->Pager->RecordCount > 0) { ?>
<div class="ewPager ewRec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $bibit_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $bibit_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $bibit_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ewListOtherOptions">
<?php
	foreach ($bibit_list->OtherOptions as &$option)
		$option->Render("body", "bottom");
?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div>
<?php } ?>
<?php if ($bibit_list->TotalRecs == 0 && $bibit->CurrentAction == "") { // Show other options ?>
<div class="ewListOtherOptions">
<?php
	foreach ($bibit_list->OtherOptions as &$option) {
		$option->ButtonClass = "";
		$option->Render("body", "");
	}
?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php if ($bibit->Export == "") { ?>
<script type="text/javascript">
fbibitlistsrch.FilterList = <?php echo $bibit_list->GetFilterList() ?>;
fbibitlistsrch.Init();
fbibitlist.Init();
</script>
<?php } ?>
<?php
$bibit_list->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<?php if ($bibit->Export == "") { ?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$bibit_list->Page_Terminate();
?>
