<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start();
?>
<?php include_once "phprptinc/ewrcfg10.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "phprptinc/ewmysql.php") ?>
<?php include_once "phprptinc/ewrfn10.php" ?>
<?php include_once "phprptinc/ewrusrfn10.php" ?>
<?php include_once "Kedatangan_Ubismryinfo.php" ?>
<?php

//
// Page class
//

$Kedatangan_Ubi_summary = NULL; // Initialize page object first

class crKedatangan_Ubi_summary extends crKedatangan_Ubi {

	// Page ID
	var $PageID = 'summary';

	// Project ID
	var $ProjectID = "{FAF953E4-B026-4CC4-8D1E-0CFAFEB15236}";

	// Page object name
	var $PageObjName = 'Kedatangan_Ubi_summary';

	// Page name
	function PageName() {
		return ewr_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ewr_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Export URLs
	var $ExportPrintUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportPdfUrl;
	var $ReportTableClass;
	var $ReportTableStyle = "";

	// Custom export
	var $ExportPrintCustom = FALSE;
	var $ExportExcelCustom = FALSE;
	var $ExportWordCustom = FALSE;
	var $ExportPdfCustom = FALSE;
	var $ExportEmailCustom = FALSE;

	// Message
	function getMessage() {
		return @$_SESSION[EWR_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ewr_AddMessage($_SESSION[EWR_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EWR_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ewr_AddMessage($_SESSION[EWR_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EWR_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ewr_AddMessage($_SESSION[EWR_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EWR_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ewr_AddMessage($_SESSION[EWR_SESSION_WARNING_MESSAGE], $v);
	}

		// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EWR_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EWR_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EWR_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EWR_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog ewDisplayTable\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") // Header exists, display
			echo $sHeader;
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") // Fotoer exists, display
			echo $sFooter;
	}

	// Validate page request
	function IsPageRequest() {
		if ($this->UseTokenInUrl) {
			if (ewr_IsHttpPost())
				return ($this->TableVar == @$_POST("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == @$_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $CheckToken = EWR_CHECK_TOKEN;
	var $CheckTokenFn = "ewr_CheckToken";
	var $CreateTokenFn = "ewr_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ewr_IsHttpPost())
			return TRUE;
		if (!isset($_POST[EWR_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EWR_TOKEN_NAME]);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $ReportLanguage;
		global $UserTable, $UserTableConn;

		// Language object
		$ReportLanguage = new crLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (Kedatangan_Ubi)
		if (!isset($GLOBALS["Kedatangan_Ubi"])) {
			$GLOBALS["Kedatangan_Ubi"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["Kedatangan_Ubi"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->PageUrl() . "export=print";
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel";
		$this->ExportWordUrl = $this->PageUrl() . "export=word";
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf";

		// Page ID
		if (!defined("EWR_PAGE_ID"))
			define("EWR_PAGE_ID", 'summary', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EWR_TABLE_NAME"))
			define("EWR_TABLE_NAME", 'Kedatangan Ubi', TRUE);

		// Start timer
		$GLOBALS["gsTimer"] = new crTimer();

		// Open connection
		if (!isset($conn)) $conn = ewr_Connect($this->DBID);

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new cremployees();
			$UserTableConn = ReportConn($UserTable->DBID);
		}

		// Export options
		$this->ExportOptions = new crListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Search options
		$this->SearchOptions = new crListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ewSearchOption";

		// Filter options
		$this->FilterOptions = new crListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ewFilterOption fKedatangan_Ubisummary";

		// Generate report options
		$this->GenerateOptions = new crListOptions();
		$this->GenerateOptions->Tag = "div";
		$this->GenerateOptions->TagClassName = "ewGenerateOption";
	}

	//
	// Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $gsEmailContentType, $ReportLanguage, $Security;
		global $gsCustomExport;

		// Security
		$Security = new crAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin(); // Auto login
		$Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . 'Kedatangan Ubi');
		$Security->TablePermission_Loaded();
		if (!$Security->CanList()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage($ReportLanguage->Phrase("NoPermission")); // Set no permission
			$this->Page_Terminate(ewr_GetUrl("index.php"));
		}

		// Get export parameters
		if (@$_GET["export"] <> "")
			$this->Export = strtolower($_GET["export"]);
		elseif (@$_POST["export"] <> "")
			$this->Export = strtolower($_POST["export"]);
		$gsExport = $this->Export; // Get export parameter, used in header
		$gsExportFile = $this->TableVar; // Get export file, used in header
		$gsEmailContentType = @$_POST["contenttype"]; // Get email content type

		// Setup placeholder
		// Setup export options

		$this->SetupExportOptions();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $ReportLanguage->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Create Token
		$this->CreateToken();
	}

	// Set up export options
	function SetupExportOptions() {
		global $Security, $ReportLanguage, $ReportOptions;
		$exportid = session_id();
		$ReportTypes = array();

		// Printer friendly
		$item = &$this->ExportOptions->Add("print");
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("PrinterFriendly", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("PrinterFriendly", TRUE)) . "\" href=\"" . $this->ExportPrintUrl . "\">" . $ReportLanguage->Phrase("PrinterFriendly") . "</a>";
		$item->Visible = TRUE;
		$ReportTypes["print"] = $item->Visible ? $ReportLanguage->Phrase("ReportFormPrint") : "";

		// Export to Excel
		$item = &$this->ExportOptions->Add("excel");
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToExcel", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToExcel", TRUE)) . "\" href=\"" . $this->ExportExcelUrl . "\">" . $ReportLanguage->Phrase("ExportToExcel") . "</a>";
		$item->Visible = TRUE;
		$ReportTypes["excel"] = $item->Visible ? $ReportLanguage->Phrase("ReportFormExcel") : "";

		// Export to Word
		$item = &$this->ExportOptions->Add("word");
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToWord", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToWord", TRUE)) . "\" href=\"" . $this->ExportWordUrl . "\">" . $ReportLanguage->Phrase("ExportToWord") . "</a>";

		//$item->Visible = TRUE;
		$item->Visible = TRUE;
		$ReportTypes["word"] = $item->Visible ? $ReportLanguage->Phrase("ReportFormWord") : "";

		// Export to Pdf
		$item = &$this->ExportOptions->Add("pdf");
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToPDF", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToPDF", TRUE)) . "\" href=\"" . $this->ExportPdfUrl . "\">" . $ReportLanguage->Phrase("ExportToPDF") . "</a>";
		$item->Visible = FALSE;

		// Uncomment codes below to show export to Pdf link
//		$item->Visible = TRUE;

		$ReportTypes["pdf"] = $item->Visible ? $ReportLanguage->Phrase("ReportFormPdf") : "";

		// Export to Email
		$item = &$this->ExportOptions->Add("email");
		$url = $this->PageUrl() . "export=email";
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToEmail", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToEmail", TRUE)) . "\" id=\"emf_Kedatangan_Ubi\" href=\"javascript:void(0);\" onclick=\"ewr_EmailDialogShow({lnk:'emf_Kedatangan_Ubi',hdr:ewLanguage.Phrase('ExportToEmail'),url:'$url',exportid:'$exportid',el:this});\">" . $ReportLanguage->Phrase("ExportToEmail") . "</a>";
		$item->Visible = FALSE;
		$ReportTypes["email"] = $item->Visible ? $ReportLanguage->Phrase("ReportFormEmail") : "";
		$ReportOptions["ReportTypes"] = $ReportTypes;

		// Drop down button for export
		$this->ExportOptions->UseDropDownButton = FALSE;
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseImageAndText = $this->ExportOptions->UseDropDownButton;
		$this->ExportOptions->DropDownButtonPhrase = $ReportLanguage->Phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->Add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Filter button
		$item = &$this->FilterOptions->Add("savecurrentfilter");
		$item->Body = "<a class=\"ewSaveFilter\" data-form=\"fKedatangan_Ubisummary\" href=\"#\">" . $ReportLanguage->Phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->Add("deletefilter");
		$item->Body = "<a class=\"ewDeleteFilter\" data-form=\"fKedatangan_Ubisummary\" href=\"#\">" . $ReportLanguage->Phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton; // v8
		$this->FilterOptions->DropDownButtonPhrase = $ReportLanguage->Phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->Add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Set up options (extended)
		$this->SetupExportOptionsExt();

		// Hide options for export
		if ($this->Export <> "") {
			$this->ExportOptions->HideAllOptions();
			$this->FilterOptions->HideAllOptions();
		}

		// Set up table class
		if ($this->Export == "word" || $this->Export == "excel" || $this->Export == "pdf")
			$this->ReportTableClass = "ewTable";
		else
			$this->ReportTableClass = "table ewTable";
	}

	// Set up search options
	function SetupSearchOptions() {
		global $ReportLanguage;

		// Filter panel button
		$item = &$this->SearchOptions->Add("searchtoggle");
		$SearchToggleClass = $this->FilterApplied ? " active" : " active";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ewSearchToggle" . $SearchToggleClass . "\" title=\"" . $ReportLanguage->Phrase("SearchBtn", TRUE) . "\" data-caption=\"" . $ReportLanguage->Phrase("SearchBtn", TRUE) . "\" data-toggle=\"button\" data-form=\"fKedatangan_Ubisummary\">" . $ReportLanguage->Phrase("SearchBtn") . "</button>";
		$item->Visible = TRUE;

		// Reset filter
		$item = &$this->SearchOptions->Add("resetfilter");
		$item->Body = "<button type=\"button\" class=\"btn btn-default\" title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ResetAllFilter", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ResetAllFilter", TRUE)) . "\" onclick=\"location='" . ewr_CurrentPage() . "?cmd=reset'\">" . $ReportLanguage->Phrase("ResetAllFilter") . "</button>";
		$item->Visible = TRUE && $this->FilterApplied;

		// Button group for reset filter
		$this->SearchOptions->UseButtonGroup = TRUE;

		// Add group option item
		$item = &$this->SearchOptions->Add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide options for export
		if ($this->Export <> "")
			$this->SearchOptions->HideAllOptions();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $ReportLanguage, $EWR_EXPORT, $gsExportFile;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		if ($this->Export <> "" && array_key_exists($this->Export, $EWR_EXPORT)) {
			$sContent = ob_get_contents();
			if (ob_get_length())
				ob_end_clean();

			// Remove all <div data-tagid="..." id="orig..." class="hide">...</div> (for customviewtag export, except "googlemaps")
			if (preg_match_all('/<div\s+data-tagid=[\'"]([\s\S]*?)[\'"]\s+id=[\'"]orig([\s\S]*?)[\'"]\s+class\s*=\s*[\'"]hide[\'"]>([\s\S]*?)<\/div\s*>/i', $sContent, $divmatches, PREG_SET_ORDER)) {
				foreach ($divmatches as $divmatch) {
					if ($divmatch[1] <> "googlemaps")
						$sContent = str_replace($divmatch[0], '', $sContent);
				}
			}
			$fn = $EWR_EXPORT[$this->Export];
			if ($this->Export == "email") { // Email
				if (@$this->GenOptions["reporttype"] == "email") {
					$saveResponse = $this->$fn($sContent, $this->GenOptions);
					$this->WriteGenResponse($saveResponse);
				} else {
					echo $this->$fn($sContent, array());
				}
				$url = ""; // Avoid redirect
			} else {
				$saveToFile = $this->$fn($sContent, $this->GenOptions);
				if (@$this->GenOptions["reporttype"] <> "") {
					$saveUrl = ($saveToFile <> "") ? ewr_ConvertFullUrl($saveToFile) : $ReportLanguage->Phrase("GenerateSuccess");
					$this->WriteGenResponse($saveUrl);
					$url = ""; // Avoid redirect
				}
			}
		}

		 // Close connection
		ewr_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EWR_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}

	// Initialize common variables
	var $ExportOptions; // Export options
	var $SearchOptions; // Search options
	var $FilterOptions; // Filter options

	// Paging variables
	var $RecIndex = 0; // Record index
	var $RecCount = 0; // Record count
	var $StartGrp = 0; // Start group
	var $StopGrp = 0; // Stop group
	var $TotalGrps = 0; // Total groups
	var $GrpCount = 0; // Group count
	var $GrpCounter = array(); // Group counter
	var $DisplayGrps = 50; // Groups per page
	var $GrpRange = 10;
	var $Sort = "";
	var $Filter = "";
	var $PageFirstGroupFilter = "";
	var $UserIDFilter = "";
	var $DrillDown = FALSE;
	var $DrillDownInPanel = FALSE;
	var $DrillDownList = "";

	// Clear field for ext filter
	var $ClearExtFilter = "";
	var $PopupName = "";
	var $PopupValue = "";
	var $FilterApplied;
	var $SearchCommand = FALSE;
	var $ShowHeader;
	var $GrpColumnCount = 0;
	var $SubGrpColumnCount = 0;
	var $DtlColumnCount = 0;
	var $Cnt, $Col, $Val, $Smry, $Mn, $Mx, $GrandCnt, $GrandSmry, $GrandMn, $GrandMx;
	var $TotCount;
	var $GrandSummarySetup = FALSE;
	var $GrpIdx;
	var $DetailRows = array();

	//
	// Page main
	//
	function Page_Main() {
		global $rs;
		global $rsgrp;
		global $Security;
		global $gsFormError;
		global $gbDrillDownInPanel;
		global $ReportBreadcrumb;
		global $ReportLanguage;

		// Set field visibility for detail fields
		$this->koord_nama->SetVisibility();
		$this->pet_nama->SetVisibility();
		$this->k_id_kontrak->SetVisibility();
		$this->k_luas_lahan->SetVisibility();
		$this->k_es_tgl_panen->SetVisibility();
		$this->k_es_qty->SetVisibility();
		$this->k_ak_tgl_datang->SetVisibility();
		$this->k_ak_qty->SetVisibility();

		// Aggregate variables
		// 1st dimension = no of groups (level 0 used for grand total)
		// 2nd dimension = no of fields

		$nDtls = 9;
		$nGrps = 3;
		$this->Val = &ewr_InitArray($nDtls, 0);
		$this->Cnt = &ewr_Init2DArray($nGrps, $nDtls, 0);
		$this->Smry = &ewr_Init2DArray($nGrps, $nDtls, 0);
		$this->Mn = &ewr_Init2DArray($nGrps, $nDtls, NULL);
		$this->Mx = &ewr_Init2DArray($nGrps, $nDtls, NULL);
		$this->GrandCnt = &ewr_InitArray($nDtls, 0);
		$this->GrandSmry = &ewr_InitArray($nDtls, 0);
		$this->GrandMn = &ewr_InitArray($nDtls, NULL);
		$this->GrandMx = &ewr_InitArray($nDtls, NULL);

		// Set up array if accumulation required: array(Accum, SkipNullOrZero)
		$this->Col = array(array(FALSE, FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(TRUE,FALSE), array(FALSE,FALSE), array(TRUE,TRUE), array(FALSE,FALSE), array(TRUE,TRUE));

		// Set up groups per page dynamically
		$this->SetUpDisplayGrps();

		// Set up Breadcrumb
		if ($this->Export == "")
			$this->SetupBreadcrumb();

		// Check if search command
		$this->SearchCommand = (@$_GET["cmd"] == "search");

		// Load default filter values
		$this->LoadDefaultFilters();

		// Load custom filters
		$this->Page_FilterLoad();

		// Set up popup filter
		$this->SetupPopup();

		// Load group db values if necessary
		$this->LoadGroupDbValues();

		// Handle Ajax popup
		$this->ProcessAjaxPopup();

		// Extended filter
		$sExtendedFilter = "";

		// Restore filter list
		$this->RestoreFilterList();

		// Build extended filter
		$sExtendedFilter = $this->GetExtendedFilter();
		ewr_AddFilter($this->Filter, $sExtendedFilter);

		// Build popup filter
		$sPopupFilter = $this->GetPopupFilter();

		//ewr_SetDebugMsg("popup filter: " . $sPopupFilter);
		ewr_AddFilter($this->Filter, $sPopupFilter);

		// Check if filter applied
		$this->FilterApplied = $this->CheckFilter();

		// Call Page Selecting event
		$this->Page_Selecting($this->Filter);

		// Search options
		$this->SetupSearchOptions();

		// Get sort
		$this->Sort = $this->GetSort($this->GenOptions);

		// Get total group count
		$sGrpSort = ewr_UpdateSortFields($this->getSqlOrderByGroup(), $this->Sort, 2); // Get grouping field only
		$sSql = ewr_BuildReportSql($this->getSqlSelectGroup(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderByGroup(), $this->Filter, $sGrpSort);
		$this->TotalGrps = $this->GetGrpCnt($sSql);
		if ($this->DisplayGrps <= 0 || $this->DrillDown) // Display all groups
			$this->DisplayGrps = $this->TotalGrps;
		$this->StartGrp = 1;

		// Show header
		$this->ShowHeader = ($this->TotalGrps > 0);

		// Set up start position if not export all
		if ($this->ExportAll && $this->Export <> "")
			$this->DisplayGrps = $this->TotalGrps;
		else
			$this->SetUpStartGroup($this->GenOptions);

		// Set no record found message
		if ($this->TotalGrps == 0) {
			if ($Security->CanList()) {
				if ($this->Filter == "0=101") {
					$this->setWarningMessage($ReportLanguage->Phrase("EnterSearchCriteria"));
				} else {
					$this->setWarningMessage($ReportLanguage->Phrase("NoRecord"));
				}
			} else {
				$this->setWarningMessage($ReportLanguage->Phrase("NoPermission"));
			}
		}

		// Hide export options if export
		if ($this->Export <> "")
			$this->ExportOptions->HideAllOptions();

		// Hide search/filter options if export/drilldown
		if ($this->Export <> "" || $this->DrillDown) {
			$this->SearchOptions->HideAllOptions();
			$this->FilterOptions->HideAllOptions();
			$this->GenerateOptions->HideAllOptions();
		}

		// Get current page groups
		$rsgrp = $this->GetGrpRs($sSql, $this->StartGrp, $this->DisplayGrps);

		// Init detail recordset
		$rs = NULL;
		$this->SetupFieldCount();
	}

	// Get summary count
	function GetSummaryCount($lvl, $curValue = TRUE) {
		$cnt = 0;
		foreach ($this->DetailRows as $row) {
			$wrkco_nama = $row["co_nama"];
			$wrkvar_nama = $row["var_nama"];
			if ($lvl >= 1) {
				$val = $curValue ? $this->co_nama->CurrentValue : $this->co_nama->OldValue;
				$grpval = $curValue ? $this->co_nama->GroupValue() : $this->co_nama->GroupOldValue();
				if (is_null($val) && !is_null($wrkco_nama) || !is_null($val) && is_null($wrkco_nama) ||
					$grpval <> $this->co_nama->getGroupValueBase($wrkco_nama))
				continue;
			}
			if ($lvl >= 2) {
				$val = $curValue ? $this->var_nama->CurrentValue : $this->var_nama->OldValue;
				$grpval = $curValue ? $this->var_nama->GroupValue() : $this->var_nama->GroupOldValue();
				if (is_null($val) && !is_null($wrkvar_nama) || !is_null($val) && is_null($wrkvar_nama) ||
					$grpval <> $this->var_nama->getGroupValueBase($wrkvar_nama))
				continue;
			}
			$cnt++;
		}
		return $cnt;
	}

	// Check level break
	function ChkLvlBreak($lvl) {
		switch ($lvl) {
			case 1:
				return (is_null($this->co_nama->CurrentValue) && !is_null($this->co_nama->OldValue)) ||
					(!is_null($this->co_nama->CurrentValue) && is_null($this->co_nama->OldValue)) ||
					($this->co_nama->GroupValue() <> $this->co_nama->GroupOldValue());
			case 2:
				return (is_null($this->var_nama->CurrentValue) && !is_null($this->var_nama->OldValue)) ||
					(!is_null($this->var_nama->CurrentValue) && is_null($this->var_nama->OldValue)) ||
					($this->var_nama->GroupValue() <> $this->var_nama->GroupOldValue()) || $this->ChkLvlBreak(1); // Recurse upper level
		}
	}

	// Accummulate summary
	function AccumulateSummary() {
		$cntx = count($this->Smry);
		for ($ix = 0; $ix < $cntx; $ix++) {
			$cnty = count($this->Smry[$ix]);
			for ($iy = 1; $iy < $cnty; $iy++) {
				if ($this->Col[$iy][0]) { // Accumulate required
					$valwrk = $this->Val[$iy];
					if (is_null($valwrk)) {
						if (!$this->Col[$iy][1])
							$this->Cnt[$ix][$iy]++;
					} else {
						$accum = (!$this->Col[$iy][1] || !is_numeric($valwrk) || $valwrk <> 0);
						if ($accum) {
							$this->Cnt[$ix][$iy]++;
							if (is_numeric($valwrk)) {
								$this->Smry[$ix][$iy] += $valwrk;
								if (is_null($this->Mn[$ix][$iy])) {
									$this->Mn[$ix][$iy] = $valwrk;
									$this->Mx[$ix][$iy] = $valwrk;
								} else {
									if ($this->Mn[$ix][$iy] > $valwrk) $this->Mn[$ix][$iy] = $valwrk;
									if ($this->Mx[$ix][$iy] < $valwrk) $this->Mx[$ix][$iy] = $valwrk;
								}
							}
						}
					}
				}
			}
		}
		$cntx = count($this->Smry);
		for ($ix = 0; $ix < $cntx; $ix++) {
			$this->Cnt[$ix][0]++;
		}
	}

	// Reset level summary
	function ResetLevelSummary($lvl) {

		// Clear summary values
		$cntx = count($this->Smry);
		for ($ix = $lvl; $ix < $cntx; $ix++) {
			$cnty = count($this->Smry[$ix]);
			for ($iy = 1; $iy < $cnty; $iy++) {
				$this->Cnt[$ix][$iy] = 0;
				if ($this->Col[$iy][0]) {
					$this->Smry[$ix][$iy] = 0;
					$this->Mn[$ix][$iy] = NULL;
					$this->Mx[$ix][$iy] = NULL;
				}
			}
		}
		$cntx = count($this->Smry);
		for ($ix = $lvl; $ix < $cntx; $ix++) {
			$this->Cnt[$ix][0] = 0;
		}

		// Reset record count
		$this->RecCount = 0;
	}

	// Accummulate grand summary
	function AccumulateGrandSummary() {
		$this->TotCount++;
		$cntgs = count($this->GrandSmry);
		for ($iy = 1; $iy < $cntgs; $iy++) {
			if ($this->Col[$iy][0]) {
				$valwrk = $this->Val[$iy];
				if (is_null($valwrk) || !is_numeric($valwrk)) {
					if (!$this->Col[$iy][1])
						$this->GrandCnt[$iy]++;
				} else {
					if (!$this->Col[$iy][1] || $valwrk <> 0) {
						$this->GrandCnt[$iy]++;
						$this->GrandSmry[$iy] += $valwrk;
						if (is_null($this->GrandMn[$iy])) {
							$this->GrandMn[$iy] = $valwrk;
							$this->GrandMx[$iy] = $valwrk;
						} else {
							if ($this->GrandMn[$iy] > $valwrk) $this->GrandMn[$iy] = $valwrk;
							if ($this->GrandMx[$iy] < $valwrk) $this->GrandMx[$iy] = $valwrk;
						}
					}
				}
			}
		}
	}

	// Get group count
	function GetGrpCnt($sql) {
		$conn = &$this->Connection();
		$rsgrpcnt = $conn->Execute($sql);
		$grpcnt = ($rsgrpcnt) ? $rsgrpcnt->RecordCount() : 0;
		if ($rsgrpcnt) $rsgrpcnt->Close();
		return $grpcnt;
	}

	// Get group recordset
	function GetGrpRs($wrksql, $start = -1, $grps = -1) {
		$conn = &$this->Connection();
		$conn->raiseErrorFn = $GLOBALS["EWR_ERROR_FN"];
		$rswrk = $conn->SelectLimit($wrksql, $grps, $start - 1);
		$conn->raiseErrorFn = '';
		return $rswrk;
	}

	// Get group row values
	function GetGrpRow($opt) {
		global $rsgrp;
		if (!$rsgrp)
			return;
		if ($opt == 1) { // Get first group

			//$rsgrp->MoveFirst(); // NOTE: no need to move position
			$this->co_nama->setDbValue(""); // Init first value
		} else { // Get next group
			$rsgrp->MoveNext();
		}
		if (!$rsgrp->EOF)
			$this->co_nama->setDbValue($rsgrp->fields[0]);
		if ($rsgrp->EOF) {
			$this->co_nama->setDbValue("");
		}
	}

	// Get detail recordset
	function GetDetailRs($wrksql) {
		$conn = &$this->Connection();
		$conn->raiseErrorFn = $GLOBALS["EWR_ERROR_FN"];
		$rswrk = $conn->Execute($wrksql);
		$dbtype = ewr_GetConnectionType($this->DBID);
		if ($dbtype == "MYSQL" || $dbtype == "POSTGRESQL") {
			$this->DetailRows = ($rswrk) ? $rswrk->GetRows() : array();
		} else { // Cannot MoveFirst, use another recordset
			$rstmp = $conn->Execute($wrksql);
			$this->DetailRows = ($rstmp) ? $rstmp->GetRows() : array();
			$rstmp->Close();
		}
		$conn->raiseErrorFn = "";
		return $rswrk;
	}

	// Get row values
	function GetRow($opt) {
		global $rs;
		if (!$rs)
			return;
		if ($opt == 1) { // Get first row
			$rs->MoveFirst(); // Move first
			if ($this->GrpCount == 1) {
				$this->FirstRowData = array();
				$this->FirstRowData['co_nama'] = ewr_Conv($rs->fields('co_nama'), 200);
				$this->FirstRowData['var_nama'] = ewr_Conv($rs->fields('var_nama'), 200);
				$this->FirstRowData['koord_nama'] = ewr_Conv($rs->fields('koord_nama'), 200);
				$this->FirstRowData['pet_nama'] = ewr_Conv($rs->fields('pet_nama'), 200);
				$this->FirstRowData['k_id_kontrak'] = ewr_Conv($rs->fields('k_id_kontrak'), 200);
				$this->FirstRowData['k_luas_lahan'] = ewr_Conv($rs->fields('k_luas_lahan'), 3);
				$this->FirstRowData['k_es_tgl_panen'] = ewr_Conv($rs->fields('k_es_tgl_panen'), 133);
				$this->FirstRowData['k_es_qty'] = ewr_Conv($rs->fields('k_es_qty'), 3);
				$this->FirstRowData['k_ak_tgl_datang'] = ewr_Conv($rs->fields('k_ak_tgl_datang'), 133);
				$this->FirstRowData['k_ak_qty'] = ewr_Conv($rs->fields('k_ak_qty'), 3);
			}
		} else { // Get next row
			$rs->MoveNext();
		}
		if (!$rs->EOF) {
			if ($opt <> 1) {
				if (is_array($this->co_nama->GroupDbValues))
					$this->co_nama->setDbValue(@$this->co_nama->GroupDbValues[$rs->fields('co_nama')]);
				else
					$this->co_nama->setDbValue(ewr_GroupValue($this->co_nama, $rs->fields('co_nama')));
			}
			$this->var_nama->setDbValue($rs->fields('var_nama'));
			$this->koord_nama->setDbValue($rs->fields('koord_nama'));
			$this->pet_nama->setDbValue($rs->fields('pet_nama'));
			$this->k_id_kontrak->setDbValue($rs->fields('k_id_kontrak'));
			$this->k_luas_lahan->setDbValue($rs->fields('k_luas_lahan'));
			$this->k_es_tgl_panen->setDbValue($rs->fields('k_es_tgl_panen'));
			$this->k_es_qty->setDbValue($rs->fields('k_es_qty'));
			$this->k_ak_tgl_datang->setDbValue($rs->fields('k_ak_tgl_datang'));
			$this->k_ak_qty->setDbValue($rs->fields('k_ak_qty'));
			$this->Val[1] = $this->koord_nama->CurrentValue;
			$this->Val[2] = $this->pet_nama->CurrentValue;
			$this->Val[3] = $this->k_id_kontrak->CurrentValue;
			$this->Val[4] = $this->k_luas_lahan->CurrentValue;
			$this->Val[5] = $this->k_es_tgl_panen->CurrentValue;
			$this->Val[6] = $this->k_es_qty->CurrentValue;
			$this->Val[7] = $this->k_ak_tgl_datang->CurrentValue;
			$this->Val[8] = $this->k_ak_qty->CurrentValue;
		} else {
			$this->co_nama->setDbValue("");
			$this->var_nama->setDbValue("");
			$this->koord_nama->setDbValue("");
			$this->pet_nama->setDbValue("");
			$this->k_id_kontrak->setDbValue("");
			$this->k_luas_lahan->setDbValue("");
			$this->k_es_tgl_panen->setDbValue("");
			$this->k_es_qty->setDbValue("");
			$this->k_ak_tgl_datang->setDbValue("");
			$this->k_ak_qty->setDbValue("");
		}
	}

	// Set up starting group
	function SetUpStartGroup($options = array()) {

		// Exit if no groups
		if ($this->DisplayGrps == 0)
			return;
		$startGrp = (@$options["start"] <> "") ? $options["start"] : @$_GET[EWR_TABLE_START_GROUP];
		$pageNo = (@$options["pageno"] <> "") ? $options["pageno"] : @$_GET["pageno"];

		// Check for a 'start' parameter
		if ($startGrp != "") {
			$this->StartGrp = $startGrp;
			$this->setStartGroup($this->StartGrp);
		} elseif ($pageNo != "") {
			$nPageNo = $pageNo;
			if (is_numeric($nPageNo)) {
				$this->StartGrp = ($nPageNo-1)*$this->DisplayGrps+1;
				if ($this->StartGrp <= 0) {
					$this->StartGrp = 1;
				} elseif ($this->StartGrp >= intval(($this->TotalGrps-1)/$this->DisplayGrps)*$this->DisplayGrps+1) {
					$this->StartGrp = intval(($this->TotalGrps-1)/$this->DisplayGrps)*$this->DisplayGrps+1;
				}
				$this->setStartGroup($this->StartGrp);
			} else {
				$this->StartGrp = $this->getStartGroup();
			}
		} else {
			$this->StartGrp = $this->getStartGroup();
		}

		// Check if correct start group counter
		if (!is_numeric($this->StartGrp) || $this->StartGrp == "") { // Avoid invalid start group counter
			$this->StartGrp = 1; // Reset start group counter
			$this->setStartGroup($this->StartGrp);
		} elseif (intval($this->StartGrp) > intval($this->TotalGrps)) { // Avoid starting group > total groups
			$this->StartGrp = intval(($this->TotalGrps-1)/$this->DisplayGrps) * $this->DisplayGrps + 1; // Point to last page first group
			$this->setStartGroup($this->StartGrp);
		} elseif (($this->StartGrp-1) % $this->DisplayGrps <> 0) {
			$this->StartGrp = intval(($this->StartGrp-1)/$this->DisplayGrps) * $this->DisplayGrps + 1; // Point to page boundary
			$this->setStartGroup($this->StartGrp);
		}
	}

	// Load group db values if necessary
	function LoadGroupDbValues() {
		$conn = &$this->Connection();
	}

	// Process Ajax popup
	function ProcessAjaxPopup() {
		global $ReportLanguage;
		$conn = &$this->Connection();
		$fld = NULL;
		if (@$_GET["popup"] <> "") {
			$popupname = $_GET["popup"];

			// Check popup name
			// Output data as Json

			if (!is_null($fld)) {
				$jsdb = ewr_GetJsDb($fld, $fld->FldType);
				if (ob_get_length())
					ob_end_clean();
				echo $jsdb;
				exit();
			}
		}
	}

	// Set up popup
	function SetupPopup() {
		global $ReportLanguage;
		$conn = &$this->Connection();
		if ($this->DrillDown)
			return;

		// Process post back form
		if (ewr_IsHttpPost()) {
			$sName = @$_POST["popup"]; // Get popup form name
			if ($sName <> "") {
				$cntValues = (is_array(@$_POST["sel_$sName"])) ? count($_POST["sel_$sName"]) : 0;
				if ($cntValues > 0) {
					$arValues = ewr_StripSlashes($_POST["sel_$sName"]);
					if (trim($arValues[0]) == "") // Select all
						$arValues = EWR_INIT_VALUE;
					$this->PopupName = $sName;
					if (ewr_IsAdvancedFilterValue($arValues) || $arValues == EWR_INIT_VALUE)
						$this->PopupValue = $arValues;
					if (!ewr_MatchedArray($arValues, $_SESSION["sel_$sName"])) {
						if ($this->HasSessionFilterValues($sName))
							$this->ClearExtFilter = $sName; // Clear extended filter for this field
					}
					$_SESSION["sel_$sName"] = $arValues;
					$_SESSION["rf_$sName"] = ewr_StripSlashes(@$_POST["rf_$sName"]);
					$_SESSION["rt_$sName"] = ewr_StripSlashes(@$_POST["rt_$sName"]);
					$this->ResetPager();
				}
			}

		// Get 'reset' command
		} elseif (@$_GET["cmd"] <> "") {
			$sCmd = $_GET["cmd"];
			if (strtolower($sCmd) == "reset") {
				$this->ResetPager();
			}
		}

		// Load selection criteria to array
	}

	// Reset pager
	function ResetPager() {

		// Reset start position (reset command)
		$this->StartGrp = 1;
		$this->setStartGroup($this->StartGrp);
	}

	// Set up number of groups displayed per page
	function SetUpDisplayGrps() {
		$sWrk = @$_GET[EWR_TABLE_GROUP_PER_PAGE];
		if ($sWrk <> "") {
			if (is_numeric($sWrk)) {
				$this->DisplayGrps = intval($sWrk);
			} else {
				if (strtoupper($sWrk) == "ALL") { // Display all groups
					$this->DisplayGrps = -1;
				} else {
					$this->DisplayGrps = 50; // Non-numeric, load default
				}
			}
			$this->setGroupPerPage($this->DisplayGrps); // Save to session

			// Reset start position (reset command)
			$this->StartGrp = 1;
			$this->setStartGroup($this->StartGrp);
		} else {
			if ($this->getGroupPerPage() <> "") {
				$this->DisplayGrps = $this->getGroupPerPage(); // Restore from session
			} else {
				$this->DisplayGrps = 50; // Load default
			}
		}
	}

	// Render row
	function RenderRow() {
		global $rs, $Security, $ReportLanguage;
		$conn = &$this->Connection();
		if (!$this->GrandSummarySetup) { // Get Grand total
			$bGotCount = FALSE;
			$bGotSummary = FALSE;

			// Get total count from sql directly
			$sSql = ewr_BuildReportSql($this->getSqlSelectCount(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
			$rstot = $conn->Execute($sSql);
			if ($rstot) {
				$this->TotCount = ($rstot->RecordCount()>1) ? $rstot->RecordCount() : $rstot->fields[0];
				$rstot->Close();
				$bGotCount = TRUE;
			} else {
				$this->TotCount = 0;
			}

			// Get total from sql directly
			$sSql = ewr_BuildReportSql($this->getSqlSelectAgg(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
			$sSql = $this->getSqlAggPfx() . $sSql . $this->getSqlAggSfx();
			$rsagg = $conn->Execute($sSql);
			if ($rsagg) {
				$this->GrandCnt[1] = $this->TotCount;
				$this->GrandCnt[2] = $this->TotCount;
				$this->GrandCnt[3] = $this->TotCount;
				$this->GrandCnt[4] = $this->TotCount;
				$this->GrandSmry[4] = $rsagg->fields("sum_k_luas_lahan");
				$this->GrandCnt[5] = $this->TotCount;
				$this->GrandCnt[6] = $this->TotCount;
				$this->GrandSmry[6] = $rsagg->fields("sum_k_es_qty");
				$this->GrandCnt[6] = $rsagg->fields("cnt_k_es_qty");
				$this->GrandCnt[7] = $this->TotCount;
				$this->GrandCnt[8] = $this->TotCount;
				$this->GrandSmry[8] = $rsagg->fields("sum_k_ak_qty");
				$this->GrandCnt[8] = $rsagg->fields("cnt_k_ak_qty");
				$rsagg->Close();
				$bGotSummary = TRUE;
			}

			// Accumulate grand summary from detail records
			if (!$bGotCount || !$bGotSummary) {
				$sSql = ewr_BuildReportSql($this->getSqlSelect(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
				$rs = $conn->Execute($sSql);
				if ($rs) {
					$this->GetRow(1);
					while (!$rs->EOF) {
						$this->AccumulateGrandSummary();
						$this->GetRow(2);
					}
					$rs->Close();
				}
			}
			$this->GrandSummarySetup = TRUE; // No need to set up again
		}

		// Call Row_Rendering event
		$this->Row_Rendering();

		//
		// Render view codes
		//

		if ($this->RowType == EWR_ROWTYPE_TOTAL && !($this->RowTotalType == EWR_ROWTOTAL_GROUP && $this->RowTotalSubType == EWR_ROWTOTAL_HEADER)) { // Summary row
			ewr_PrependClass($this->RowAttrs["class"], ($this->RowTotalType == EWR_ROWTOTAL_PAGE || $this->RowTotalType == EWR_ROWTOTAL_GRAND) ? "ewRptGrpAggregate" : "ewRptGrpSummary" . $this->RowGroupLevel); // Set up row class
			if ($this->RowTotalType == EWR_ROWTOTAL_GROUP) $this->RowAttrs["data-group"] = $this->co_nama->GroupOldValue(); // Set up group attribute
			if ($this->RowTotalType == EWR_ROWTOTAL_GROUP && $this->RowGroupLevel >= 2) $this->RowAttrs["data-group-2"] = $this->var_nama->GroupOldValue(); // Set up group attribute 2

			// co_nama
			$this->co_nama->GroupViewValue = $this->co_nama->GroupOldValue();
			$this->co_nama->CellAttrs["class"] = ($this->RowGroupLevel == 1) ? "ewRptGrpSummary1" : "ewRptGrpField1";
			$this->co_nama->GroupViewValue = ewr_DisplayGroupValue($this->co_nama, $this->co_nama->GroupViewValue);
			$this->co_nama->GroupSummaryOldValue = $this->co_nama->GroupSummaryValue;
			$this->co_nama->GroupSummaryValue = $this->co_nama->GroupViewValue;
			$this->co_nama->GroupSummaryViewValue = ($this->co_nama->GroupSummaryOldValue <> $this->co_nama->GroupSummaryValue) ? $this->co_nama->GroupSummaryValue : "&nbsp;";

			// var_nama
			$this->var_nama->GroupViewValue = $this->var_nama->GroupOldValue();
			$this->var_nama->CellAttrs["class"] = ($this->RowGroupLevel == 2) ? "ewRptGrpSummary2" : "ewRptGrpField2";
			$this->var_nama->GroupViewValue = ewr_DisplayGroupValue($this->var_nama, $this->var_nama->GroupViewValue);
			$this->var_nama->GroupSummaryOldValue = $this->var_nama->GroupSummaryValue;
			$this->var_nama->GroupSummaryValue = $this->var_nama->GroupViewValue;
			$this->var_nama->GroupSummaryViewValue = ($this->var_nama->GroupSummaryOldValue <> $this->var_nama->GroupSummaryValue) ? $this->var_nama->GroupSummaryValue : "&nbsp;";

			// k_luas_lahan
			$this->k_luas_lahan->SumViewValue = $this->k_luas_lahan->SumValue;
			$this->k_luas_lahan->CellAttrs["class"] = ($this->RowTotalType == EWR_ROWTOTAL_PAGE || $this->RowTotalType == EWR_ROWTOTAL_GRAND) ? "ewRptGrpAggregate" : "ewRptGrpSummary" . $this->RowGroupLevel;

			// k_es_qty
			$this->k_es_qty->SumViewValue = $this->k_es_qty->SumValue;
			$this->k_es_qty->CellAttrs["class"] = ($this->RowTotalType == EWR_ROWTOTAL_PAGE || $this->RowTotalType == EWR_ROWTOTAL_GRAND) ? "ewRptGrpAggregate" : "ewRptGrpSummary" . $this->RowGroupLevel;

			// k_es_qty
			$this->k_es_qty->CntViewValue = $this->k_es_qty->CntValue;
			$this->k_es_qty->CntViewValue = ewr_FormatNumber($this->k_es_qty->CntViewValue, 0, -2, -2, -2);
			$this->k_es_qty->CellAttrs["class"] = ($this->RowTotalType == EWR_ROWTOTAL_PAGE || $this->RowTotalType == EWR_ROWTOTAL_GRAND) ? "ewRptGrpAggregate" : "ewRptGrpSummary" . $this->RowGroupLevel;

			// k_ak_qty
			$this->k_ak_qty->SumViewValue = $this->k_ak_qty->SumValue;
			$this->k_ak_qty->CellAttrs["class"] = ($this->RowTotalType == EWR_ROWTOTAL_PAGE || $this->RowTotalType == EWR_ROWTOTAL_GRAND) ? "ewRptGrpAggregate" : "ewRptGrpSummary" . $this->RowGroupLevel;

			// k_ak_qty
			$this->k_ak_qty->CntViewValue = $this->k_ak_qty->CntValue;
			$this->k_ak_qty->CntViewValue = ewr_FormatNumber($this->k_ak_qty->CntViewValue, 0, -2, -2, -2);
			$this->k_ak_qty->CellAttrs["class"] = ($this->RowTotalType == EWR_ROWTOTAL_PAGE || $this->RowTotalType == EWR_ROWTOTAL_GRAND) ? "ewRptGrpAggregate" : "ewRptGrpSummary" . $this->RowGroupLevel;

			// co_nama
			$this->co_nama->HrefValue = "";

			// var_nama
			$this->var_nama->HrefValue = "";

			// koord_nama
			$this->koord_nama->HrefValue = "";

			// pet_nama
			$this->pet_nama->HrefValue = "";

			// k_id_kontrak
			$this->k_id_kontrak->HrefValue = "";

			// k_luas_lahan
			$this->k_luas_lahan->HrefValue = "";

			// k_es_tgl_panen
			$this->k_es_tgl_panen->HrefValue = "";

			// k_es_qty
			$this->k_es_qty->HrefValue = "";

			// k_ak_tgl_datang
			$this->k_ak_tgl_datang->HrefValue = "";

			// k_ak_qty
			$this->k_ak_qty->HrefValue = "";
		} else {
			if ($this->RowTotalType == EWR_ROWTOTAL_GROUP && $this->RowTotalSubType == EWR_ROWTOTAL_HEADER) {
			$this->RowAttrs["data-group"] = $this->co_nama->GroupValue(); // Set up group attribute
			if ($this->RowGroupLevel >= 2) $this->RowAttrs["data-group-2"] = $this->var_nama->GroupValue(); // Set up group attribute 2
			} else {
			$this->RowAttrs["data-group"] = $this->co_nama->GroupValue(); // Set up group attribute
			$this->RowAttrs["data-group-2"] = $this->var_nama->GroupValue(); // Set up group attribute 2
			}

			// co_nama
			$this->co_nama->GroupViewValue = $this->co_nama->GroupValue();
			$this->co_nama->CellAttrs["class"] = "ewRptGrpField1";
			$this->co_nama->GroupViewValue = ewr_DisplayGroupValue($this->co_nama, $this->co_nama->GroupViewValue);
			if ($this->co_nama->GroupValue() == $this->co_nama->GroupOldValue() && !$this->ChkLvlBreak(1))
				$this->co_nama->GroupViewValue = "&nbsp;";

			// var_nama
			$this->var_nama->GroupViewValue = $this->var_nama->GroupValue();
			$this->var_nama->CellAttrs["class"] = "ewRptGrpField2";
			$this->var_nama->GroupViewValue = ewr_DisplayGroupValue($this->var_nama, $this->var_nama->GroupViewValue);
			if ($this->var_nama->GroupValue() == $this->var_nama->GroupOldValue() && !$this->ChkLvlBreak(2))
				$this->var_nama->GroupViewValue = "&nbsp;";

			// koord_nama
			$this->koord_nama->ViewValue = $this->koord_nama->CurrentValue;
			$this->koord_nama->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// pet_nama
			$this->pet_nama->ViewValue = $this->pet_nama->CurrentValue;
			$this->pet_nama->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// k_id_kontrak
			$this->k_id_kontrak->ViewValue = $this->k_id_kontrak->CurrentValue;
			$this->k_id_kontrak->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// k_luas_lahan
			$this->k_luas_lahan->ViewValue = $this->k_luas_lahan->CurrentValue;
			$this->k_luas_lahan->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// k_es_tgl_panen
			$this->k_es_tgl_panen->ViewValue = $this->k_es_tgl_panen->CurrentValue;
			$this->k_es_tgl_panen->ViewValue = ewr_FormatDateTime($this->k_es_tgl_panen->ViewValue, 0);
			$this->k_es_tgl_panen->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// k_es_qty
			$this->k_es_qty->ViewValue = $this->k_es_qty->CurrentValue;
			$this->k_es_qty->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// k_ak_tgl_datang
			$this->k_ak_tgl_datang->ViewValue = $this->k_ak_tgl_datang->CurrentValue;
			$this->k_ak_tgl_datang->ViewValue = ewr_FormatDateTime($this->k_ak_tgl_datang->ViewValue, 0);
			$this->k_ak_tgl_datang->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// k_ak_qty
			$this->k_ak_qty->ViewValue = $this->k_ak_qty->CurrentValue;
			$this->k_ak_qty->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// co_nama
			$this->co_nama->HrefValue = "";

			// var_nama
			$this->var_nama->HrefValue = "";

			// koord_nama
			$this->koord_nama->HrefValue = "";

			// pet_nama
			$this->pet_nama->HrefValue = "";

			// k_id_kontrak
			$this->k_id_kontrak->HrefValue = "";

			// k_luas_lahan
			$this->k_luas_lahan->HrefValue = "";

			// k_es_tgl_panen
			$this->k_es_tgl_panen->HrefValue = "";

			// k_es_qty
			$this->k_es_qty->HrefValue = "";

			// k_ak_tgl_datang
			$this->k_ak_tgl_datang->HrefValue = "";

			// k_ak_qty
			$this->k_ak_qty->HrefValue = "";
		}

		// Call Cell_Rendered event
		if ($this->RowType == EWR_ROWTYPE_TOTAL) { // Summary row

			// co_nama
			$CurrentValue = $this->co_nama->GroupViewValue;
			$ViewValue = &$this->co_nama->GroupViewValue;
			$ViewAttrs = &$this->co_nama->ViewAttrs;
			$CellAttrs = &$this->co_nama->CellAttrs;
			$HrefValue = &$this->co_nama->HrefValue;
			$LinkAttrs = &$this->co_nama->LinkAttrs;
			$this->Cell_Rendered($this->co_nama, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// var_nama
			$CurrentValue = $this->var_nama->GroupViewValue;
			$ViewValue = &$this->var_nama->GroupViewValue;
			$ViewAttrs = &$this->var_nama->ViewAttrs;
			$CellAttrs = &$this->var_nama->CellAttrs;
			$HrefValue = &$this->var_nama->HrefValue;
			$LinkAttrs = &$this->var_nama->LinkAttrs;
			$this->Cell_Rendered($this->var_nama, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// k_luas_lahan
			$CurrentValue = $this->k_luas_lahan->SumValue;
			$ViewValue = &$this->k_luas_lahan->SumViewValue;
			$ViewAttrs = &$this->k_luas_lahan->ViewAttrs;
			$CellAttrs = &$this->k_luas_lahan->CellAttrs;
			$HrefValue = &$this->k_luas_lahan->HrefValue;
			$LinkAttrs = &$this->k_luas_lahan->LinkAttrs;
			$this->Cell_Rendered($this->k_luas_lahan, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// k_es_qty
			$CurrentValue = $this->k_es_qty->SumValue;
			$ViewValue = &$this->k_es_qty->SumViewValue;
			$ViewAttrs = &$this->k_es_qty->ViewAttrs;
			$CellAttrs = &$this->k_es_qty->CellAttrs;
			$HrefValue = &$this->k_es_qty->HrefValue;
			$LinkAttrs = &$this->k_es_qty->LinkAttrs;
			$this->Cell_Rendered($this->k_es_qty, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// k_es_qty
			$CurrentValue = $this->k_es_qty->CntValue;
			$ViewValue = &$this->k_es_qty->CntViewValue;
			$ViewAttrs = &$this->k_es_qty->ViewAttrs;
			$CellAttrs = &$this->k_es_qty->CellAttrs;
			$HrefValue = &$this->k_es_qty->HrefValue;
			$LinkAttrs = &$this->k_es_qty->LinkAttrs;
			$this->Cell_Rendered($this->k_es_qty, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// k_ak_qty
			$CurrentValue = $this->k_ak_qty->SumValue;
			$ViewValue = &$this->k_ak_qty->SumViewValue;
			$ViewAttrs = &$this->k_ak_qty->ViewAttrs;
			$CellAttrs = &$this->k_ak_qty->CellAttrs;
			$HrefValue = &$this->k_ak_qty->HrefValue;
			$LinkAttrs = &$this->k_ak_qty->LinkAttrs;
			$this->Cell_Rendered($this->k_ak_qty, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// k_ak_qty
			$CurrentValue = $this->k_ak_qty->CntValue;
			$ViewValue = &$this->k_ak_qty->CntViewValue;
			$ViewAttrs = &$this->k_ak_qty->ViewAttrs;
			$CellAttrs = &$this->k_ak_qty->CellAttrs;
			$HrefValue = &$this->k_ak_qty->HrefValue;
			$LinkAttrs = &$this->k_ak_qty->LinkAttrs;
			$this->Cell_Rendered($this->k_ak_qty, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);
		} else {

			// co_nama
			$CurrentValue = $this->co_nama->GroupValue();
			$ViewValue = &$this->co_nama->GroupViewValue;
			$ViewAttrs = &$this->co_nama->ViewAttrs;
			$CellAttrs = &$this->co_nama->CellAttrs;
			$HrefValue = &$this->co_nama->HrefValue;
			$LinkAttrs = &$this->co_nama->LinkAttrs;
			$this->Cell_Rendered($this->co_nama, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// var_nama
			$CurrentValue = $this->var_nama->GroupValue();
			$ViewValue = &$this->var_nama->GroupViewValue;
			$ViewAttrs = &$this->var_nama->ViewAttrs;
			$CellAttrs = &$this->var_nama->CellAttrs;
			$HrefValue = &$this->var_nama->HrefValue;
			$LinkAttrs = &$this->var_nama->LinkAttrs;
			$this->Cell_Rendered($this->var_nama, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// koord_nama
			$CurrentValue = $this->koord_nama->CurrentValue;
			$ViewValue = &$this->koord_nama->ViewValue;
			$ViewAttrs = &$this->koord_nama->ViewAttrs;
			$CellAttrs = &$this->koord_nama->CellAttrs;
			$HrefValue = &$this->koord_nama->HrefValue;
			$LinkAttrs = &$this->koord_nama->LinkAttrs;
			$this->Cell_Rendered($this->koord_nama, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// pet_nama
			$CurrentValue = $this->pet_nama->CurrentValue;
			$ViewValue = &$this->pet_nama->ViewValue;
			$ViewAttrs = &$this->pet_nama->ViewAttrs;
			$CellAttrs = &$this->pet_nama->CellAttrs;
			$HrefValue = &$this->pet_nama->HrefValue;
			$LinkAttrs = &$this->pet_nama->LinkAttrs;
			$this->Cell_Rendered($this->pet_nama, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// k_id_kontrak
			$CurrentValue = $this->k_id_kontrak->CurrentValue;
			$ViewValue = &$this->k_id_kontrak->ViewValue;
			$ViewAttrs = &$this->k_id_kontrak->ViewAttrs;
			$CellAttrs = &$this->k_id_kontrak->CellAttrs;
			$HrefValue = &$this->k_id_kontrak->HrefValue;
			$LinkAttrs = &$this->k_id_kontrak->LinkAttrs;
			$this->Cell_Rendered($this->k_id_kontrak, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// k_luas_lahan
			$CurrentValue = $this->k_luas_lahan->CurrentValue;
			$ViewValue = &$this->k_luas_lahan->ViewValue;
			$ViewAttrs = &$this->k_luas_lahan->ViewAttrs;
			$CellAttrs = &$this->k_luas_lahan->CellAttrs;
			$HrefValue = &$this->k_luas_lahan->HrefValue;
			$LinkAttrs = &$this->k_luas_lahan->LinkAttrs;
			$this->Cell_Rendered($this->k_luas_lahan, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// k_es_tgl_panen
			$CurrentValue = $this->k_es_tgl_panen->CurrentValue;
			$ViewValue = &$this->k_es_tgl_panen->ViewValue;
			$ViewAttrs = &$this->k_es_tgl_panen->ViewAttrs;
			$CellAttrs = &$this->k_es_tgl_panen->CellAttrs;
			$HrefValue = &$this->k_es_tgl_panen->HrefValue;
			$LinkAttrs = &$this->k_es_tgl_panen->LinkAttrs;
			$this->Cell_Rendered($this->k_es_tgl_panen, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// k_es_qty
			$CurrentValue = $this->k_es_qty->CurrentValue;
			$ViewValue = &$this->k_es_qty->ViewValue;
			$ViewAttrs = &$this->k_es_qty->ViewAttrs;
			$CellAttrs = &$this->k_es_qty->CellAttrs;
			$HrefValue = &$this->k_es_qty->HrefValue;
			$LinkAttrs = &$this->k_es_qty->LinkAttrs;
			$this->Cell_Rendered($this->k_es_qty, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// k_ak_tgl_datang
			$CurrentValue = $this->k_ak_tgl_datang->CurrentValue;
			$ViewValue = &$this->k_ak_tgl_datang->ViewValue;
			$ViewAttrs = &$this->k_ak_tgl_datang->ViewAttrs;
			$CellAttrs = &$this->k_ak_tgl_datang->CellAttrs;
			$HrefValue = &$this->k_ak_tgl_datang->HrefValue;
			$LinkAttrs = &$this->k_ak_tgl_datang->LinkAttrs;
			$this->Cell_Rendered($this->k_ak_tgl_datang, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// k_ak_qty
			$CurrentValue = $this->k_ak_qty->CurrentValue;
			$ViewValue = &$this->k_ak_qty->ViewValue;
			$ViewAttrs = &$this->k_ak_qty->ViewAttrs;
			$CellAttrs = &$this->k_ak_qty->CellAttrs;
			$HrefValue = &$this->k_ak_qty->HrefValue;
			$LinkAttrs = &$this->k_ak_qty->LinkAttrs;
			$this->Cell_Rendered($this->k_ak_qty, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);
		}

		// Call Row_Rendered event
		$this->Row_Rendered();
		$this->SetupFieldCount();
	}

	// Setup field count
	function SetupFieldCount() {
		$this->GrpColumnCount = 0;
		$this->SubGrpColumnCount = 0;
		$this->DtlColumnCount = 0;
		if ($this->co_nama->Visible) $this->GrpColumnCount += 1;
		if ($this->var_nama->Visible) { $this->GrpColumnCount += 1; $this->SubGrpColumnCount += 1; }
		if ($this->koord_nama->Visible) $this->DtlColumnCount += 1;
		if ($this->pet_nama->Visible) $this->DtlColumnCount += 1;
		if ($this->k_id_kontrak->Visible) $this->DtlColumnCount += 1;
		if ($this->k_luas_lahan->Visible) $this->DtlColumnCount += 1;
		if ($this->k_es_tgl_panen->Visible) $this->DtlColumnCount += 1;
		if ($this->k_es_qty->Visible) $this->DtlColumnCount += 1;
		if ($this->k_ak_tgl_datang->Visible) $this->DtlColumnCount += 1;
		if ($this->k_ak_qty->Visible) $this->DtlColumnCount += 1;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $ReportBreadcrumb;
		$ReportBreadcrumb = new crBreadcrumb();
		$url = substr(ewr_CurrentUrl(), strrpos(ewr_CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$ReportBreadcrumb->Add("summary", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	function SetupExportOptionsExt() {
		global $ReportLanguage, $ReportOptions;
		$ReportTypes = $ReportOptions["ReportTypes"];
		$item =& $this->ExportOptions->GetItem("pdf");
		$item->Visible = TRUE;
		if ($item->Visible)
			$ReportTypes["pdf"] = $ReportLanguage->Phrase("ReportFormPdf");
		$exportid = session_id();
		$url = $this->ExportPdfUrl;
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToPDF", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToPDF", TRUE)) . "\" href=\"javascript:void(0);\" onclick=\"ewr_ExportCharts(this, '" . $url . "', '" . $exportid . "');\">" . $ReportLanguage->Phrase("ExportToPDF") . "</a>";
		$ReportOptions["ReportTypes"] = $ReportTypes;
	}

	// Return extended filter
	function GetExtendedFilter() {
		global $gsFormError;
		$sFilter = "";
		if ($this->DrillDown)
			return "";
		$bPostBack = ewr_IsHttpPost();
		$bRestoreSession = TRUE;
		$bSetupFilter = FALSE;

		// Reset extended filter if filter changed
		if ($bPostBack) {

		// Reset search command
		} elseif (@$_GET["cmd"] == "reset") {

			// Load default values
			$this->SetSessionDropDownValue($this->co_nama->DropDownValue, $this->co_nama->SearchOperator, 'co_nama'); // Field co_nama
			$this->SetSessionDropDownValue($this->var_nama->DropDownValue, $this->var_nama->SearchOperator, 'var_nama'); // Field var_nama
			$this->SetSessionDropDownValue($this->k_es_tgl_panen->DropDownValue, $this->k_es_tgl_panen->SearchOperator, 'k_es_tgl_panen'); // Field k_es_tgl_panen
			$this->SetSessionDropDownValue($this->k_ak_tgl_datang->DropDownValue, $this->k_ak_tgl_datang->SearchOperator, 'k_ak_tgl_datang'); // Field k_ak_tgl_datang

			//$bSetupFilter = TRUE; // No need to set up, just use default
		} else {
			$bRestoreSession = !$this->SearchCommand;

			// Field co_nama
			if ($this->GetDropDownValue($this->co_nama)) {
				$bSetupFilter = TRUE;
			} elseif ($this->co_nama->DropDownValue <> EWR_INIT_VALUE && !isset($_SESSION['sv_Kedatangan_Ubi_co_nama'])) {
				$bSetupFilter = TRUE;
			}

			// Field var_nama
			if ($this->GetDropDownValue($this->var_nama)) {
				$bSetupFilter = TRUE;
			} elseif ($this->var_nama->DropDownValue <> EWR_INIT_VALUE && !isset($_SESSION['sv_Kedatangan_Ubi_var_nama'])) {
				$bSetupFilter = TRUE;
			}

			// Field k_es_tgl_panen
			if ($this->GetDropDownValue($this->k_es_tgl_panen)) {
				$bSetupFilter = TRUE;
			} elseif ($this->k_es_tgl_panen->DropDownValue <> EWR_INIT_VALUE && !isset($_SESSION['sv_Kedatangan_Ubi_k_es_tgl_panen'])) {
				$bSetupFilter = TRUE;
			}

			// Field k_ak_tgl_datang
			if ($this->GetDropDownValue($this->k_ak_tgl_datang)) {
				$bSetupFilter = TRUE;
			} elseif ($this->k_ak_tgl_datang->DropDownValue <> EWR_INIT_VALUE && !isset($_SESSION['sv_Kedatangan_Ubi_k_ak_tgl_datang'])) {
				$bSetupFilter = TRUE;
			}
			if (!$this->ValidateForm()) {
				$this->setFailureMessage($gsFormError);
				return $sFilter;
			}
		}

		// Restore session
		if ($bRestoreSession) {
			$this->GetSessionDropDownValue($this->co_nama); // Field co_nama
			$this->GetSessionDropDownValue($this->var_nama); // Field var_nama
			$this->GetSessionDropDownValue($this->k_es_tgl_panen); // Field k_es_tgl_panen
			$this->GetSessionDropDownValue($this->k_ak_tgl_datang); // Field k_ak_tgl_datang
		}

		// Call page filter validated event
		$this->Page_FilterValidated();

		// Build SQL
		$this->BuildDropDownFilter($this->co_nama, $sFilter, $this->co_nama->SearchOperator, FALSE, TRUE); // Field co_nama
		$this->BuildDropDownFilter($this->var_nama, $sFilter, $this->var_nama->SearchOperator, FALSE, TRUE); // Field var_nama
		$this->BuildDropDownFilter($this->k_es_tgl_panen, $sFilter, $this->k_es_tgl_panen->DateFilter, FALSE, TRUE); // Field k_es_tgl_panen
		$this->BuildDropDownFilter($this->k_ak_tgl_datang, $sFilter, $this->k_ak_tgl_datang->DateFilter, FALSE, TRUE); // Field k_ak_tgl_datang

		// Save parms to session
		$this->SetSessionDropDownValue($this->co_nama->DropDownValue, $this->co_nama->SearchOperator, 'co_nama'); // Field co_nama
		$this->SetSessionDropDownValue($this->var_nama->DropDownValue, $this->var_nama->SearchOperator, 'var_nama'); // Field var_nama
		$this->SetSessionDropDownValue($this->k_es_tgl_panen->DropDownValue, $this->k_es_tgl_panen->SearchOperator, 'k_es_tgl_panen'); // Field k_es_tgl_panen
		$this->SetSessionDropDownValue($this->k_ak_tgl_datang->DropDownValue, $this->k_ak_tgl_datang->SearchOperator, 'k_ak_tgl_datang'); // Field k_ak_tgl_datang

		// Setup filter
		if ($bSetupFilter) {
		}

		// Field co_nama
		ewr_LoadDropDownList($this->co_nama->DropDownList, $this->co_nama->DropDownValue);

		// Field var_nama
		ewr_LoadDropDownList($this->var_nama->DropDownList, $this->var_nama->DropDownValue);

		// Field k_es_tgl_panen
		ewr_LoadDropDownList($this->k_es_tgl_panen->DropDownList, $this->k_es_tgl_panen->DropDownValue);

		// Field k_ak_tgl_datang
		ewr_LoadDropDownList($this->k_ak_tgl_datang->DropDownList, $this->k_ak_tgl_datang->DropDownValue);
		return $sFilter;
	}

	// Build dropdown filter
	function BuildDropDownFilter(&$fld, &$FilterClause, $FldOpr, $Default = FALSE, $SaveFilter = FALSE) {
		$FldVal = ($Default) ? $fld->DefaultDropDownValue : $fld->DropDownValue;
		$sSql = "";
		if (is_array($FldVal)) {
			foreach ($FldVal as $val) {
				$sWrk = $this->GetDropDownFilter($fld, $val, $FldOpr);

				// Call Page Filtering event
				if (substr($val, 0, 2) <> "@@") $this->Page_Filtering($fld, $sWrk, "dropdown", $FldOpr, $val);
				if ($sWrk <> "") {
					if ($sSql <> "")
						$sSql .= " OR " . $sWrk;
					else
						$sSql = $sWrk;
				}
			}
		} else {
			$sSql = $this->GetDropDownFilter($fld, $FldVal, $FldOpr);

			// Call Page Filtering event
			if (substr($FldVal, 0, 2) <> "@@") $this->Page_Filtering($fld, $sSql, "dropdown", $FldOpr, $FldVal);
		}
		if ($sSql <> "") {
			ewr_AddFilter($FilterClause, $sSql);
			if ($SaveFilter) $fld->CurrentFilter = $sSql;
		}
	}

	function GetDropDownFilter(&$fld, $FldVal, $FldOpr) {
		$FldName = $fld->FldName;
		$FldExpression = $fld->FldExpression;
		$FldDataType = $fld->FldDataType;
		$FldDelimiter = $fld->FldDelimiter;
		$FldVal = strval($FldVal);
		if ($FldOpr == "") $FldOpr = "=";
		$sWrk = "";
		if (ewr_SameStr($FldVal, EWR_NULL_VALUE)) {
			$sWrk = $FldExpression . " IS NULL";
		} elseif (ewr_SameStr($FldVal, EWR_NOT_NULL_VALUE)) {
			$sWrk = $FldExpression . " IS NOT NULL";
		} elseif (ewr_SameStr($FldVal, EWR_EMPTY_VALUE)) {
			$sWrk = $FldExpression . " = ''";
		} elseif (ewr_SameStr($FldVal, EWR_ALL_VALUE)) {
			$sWrk = "1 = 1";
		} else {
			if (substr($FldVal, 0, 2) == "@@") {
				$sWrk = $this->GetCustomFilter($fld, $FldVal, $this->DBID);
			} elseif ($FldDelimiter <> "" && trim($FldVal) <> "" && ($FldDataType == EWR_DATATYPE_STRING || $FldDataType == EWR_DATATYPE_MEMO)) {
				$sWrk = ewr_GetMultiSearchSql($FldExpression, trim($FldVal), $this->DBID);
			} else {
				if ($FldVal <> "" && $FldVal <> EWR_INIT_VALUE) {
					if ($FldDataType == EWR_DATATYPE_DATE && $FldOpr <> "") {
						$sWrk = ewr_DateFilterString($FldExpression, $FldOpr, $FldVal, $FldDataType, $this->DBID);
					} else {
						$sWrk = ewr_FilterString($FldOpr, $FldVal, $FldDataType, $this->DBID);
						if ($sWrk <> "") $sWrk = $FldExpression . $sWrk;
					}
				}
			}
		}
		return $sWrk;
	}

	// Get custom filter
	function GetCustomFilter(&$fld, $FldVal, $dbid = 0) {
		$sWrk = "";
		if (is_array($fld->AdvancedFilters)) {
			foreach ($fld->AdvancedFilters as $filter) {
				if ($filter->ID == $FldVal && $filter->Enabled) {
					$sFld = $fld->FldExpression;
					$sFn = $filter->FunctionName;
					$wrkid = (substr($filter->ID,0,2) == "@@") ? substr($filter->ID,2) : $filter->ID;
					if ($sFn <> "")
						$sWrk = $sFn($sFld, $dbid);
					else
						$sWrk = "";
					$this->Page_Filtering($fld, $sWrk, "custom", $wrkid);
					break;
				}
			}
		}
		return $sWrk;
	}

	// Build extended filter
	function BuildExtendedFilter(&$fld, &$FilterClause, $Default = FALSE, $SaveFilter = FALSE) {
		$sWrk = ewr_GetExtendedFilter($fld, $Default, $this->DBID);
		if (!$Default)
			$this->Page_Filtering($fld, $sWrk, "extended", $fld->SearchOperator, $fld->SearchValue, $fld->SearchCondition, $fld->SearchOperator2, $fld->SearchValue2);
		if ($sWrk <> "") {
			ewr_AddFilter($FilterClause, $sWrk);
			if ($SaveFilter) $fld->CurrentFilter = $sWrk;
		}
	}

	// Get drop down value from querystring
	function GetDropDownValue(&$fld) {
		$parm = substr($fld->FldVar, 2);
		if (ewr_IsHttpPost())
			return FALSE; // Skip post back
		if (isset($_GET["so_$parm"]))
			$fld->SearchOperator = ewr_StripSlashes(@$_GET["so_$parm"]);
		if (isset($_GET["sv_$parm"])) {
			$fld->DropDownValue = ewr_StripSlashes(@$_GET["sv_$parm"]);
			return TRUE;
		}
		return FALSE;
	}

	// Get filter values from querystring
	function GetFilterValues(&$fld) {
		$parm = substr($fld->FldVar, 2);
		if (ewr_IsHttpPost())
			return; // Skip post back
		$got = FALSE;
		if (isset($_GET["sv_$parm"])) {
			$fld->SearchValue = ewr_StripSlashes(@$_GET["sv_$parm"]);
			$got = TRUE;
		}
		if (isset($_GET["so_$parm"])) {
			$fld->SearchOperator = ewr_StripSlashes(@$_GET["so_$parm"]);
			$got = TRUE;
		}
		if (isset($_GET["sc_$parm"])) {
			$fld->SearchCondition = ewr_StripSlashes(@$_GET["sc_$parm"]);
			$got = TRUE;
		}
		if (isset($_GET["sv2_$parm"])) {
			$fld->SearchValue2 = ewr_StripSlashes(@$_GET["sv2_$parm"]);
			$got = TRUE;
		}
		if (isset($_GET["so2_$parm"])) {
			$fld->SearchOperator2 = ewr_StripSlashes($_GET["so2_$parm"]);
			$got = TRUE;
		}
		return $got;
	}

	// Set default ext filter
	function SetDefaultExtFilter(&$fld, $so1, $sv1, $sc, $so2, $sv2) {
		$fld->DefaultSearchValue = $sv1; // Default ext filter value 1
		$fld->DefaultSearchValue2 = $sv2; // Default ext filter value 2 (if operator 2 is enabled)
		$fld->DefaultSearchOperator = $so1; // Default search operator 1
		$fld->DefaultSearchOperator2 = $so2; // Default search operator 2 (if operator 2 is enabled)
		$fld->DefaultSearchCondition = $sc; // Default search condition (if operator 2 is enabled)
	}

	// Apply default ext filter
	function ApplyDefaultExtFilter(&$fld) {
		$fld->SearchValue = $fld->DefaultSearchValue;
		$fld->SearchValue2 = $fld->DefaultSearchValue2;
		$fld->SearchOperator = $fld->DefaultSearchOperator;
		$fld->SearchOperator2 = $fld->DefaultSearchOperator2;
		$fld->SearchCondition = $fld->DefaultSearchCondition;
	}

	// Check if Text Filter applied
	function TextFilterApplied(&$fld) {
		return (strval($fld->SearchValue) <> strval($fld->DefaultSearchValue) ||
			strval($fld->SearchValue2) <> strval($fld->DefaultSearchValue2) ||
			(strval($fld->SearchValue) <> "" &&
				strval($fld->SearchOperator) <> strval($fld->DefaultSearchOperator)) ||
			(strval($fld->SearchValue2) <> "" &&
				strval($fld->SearchOperator2) <> strval($fld->DefaultSearchOperator2)) ||
			strval($fld->SearchCondition) <> strval($fld->DefaultSearchCondition));
	}

	// Check if Non-Text Filter applied
	function NonTextFilterApplied(&$fld) {
		if (is_array($fld->DropDownValue)) {
			if (is_array($fld->DefaultDropDownValue)) {
				if (count($fld->DefaultDropDownValue) <> count($fld->DropDownValue))
					return TRUE;
				else
					return (count(array_diff($fld->DefaultDropDownValue, $fld->DropDownValue)) <> 0);
			} else {
				return TRUE;
			}
		} else {
			if (is_array($fld->DefaultDropDownValue))
				return TRUE;
			else
				$v1 = strval($fld->DefaultDropDownValue);
			if ($v1 == EWR_INIT_VALUE)
				$v1 = "";
			$v2 = strval($fld->DropDownValue);
			if ($v2 == EWR_INIT_VALUE || $v2 == EWR_ALL_VALUE)
				$v2 = "";
			return ($v1 <> $v2);
		}
	}

	// Get dropdown value from session
	function GetSessionDropDownValue(&$fld) {
		$parm = substr($fld->FldVar, 2);
		$this->GetSessionValue($fld->DropDownValue, 'sv_Kedatangan_Ubi_' . $parm);
		$this->GetSessionValue($fld->SearchOperator, 'so_Kedatangan_Ubi_' . $parm);
	}

	// Get filter values from session
	function GetSessionFilterValues(&$fld) {
		$parm = substr($fld->FldVar, 2);
		$this->GetSessionValue($fld->SearchValue, 'sv_Kedatangan_Ubi_' . $parm);
		$this->GetSessionValue($fld->SearchOperator, 'so_Kedatangan_Ubi_' . $parm);
		$this->GetSessionValue($fld->SearchCondition, 'sc_Kedatangan_Ubi_' . $parm);
		$this->GetSessionValue($fld->SearchValue2, 'sv2_Kedatangan_Ubi_' . $parm);
		$this->GetSessionValue($fld->SearchOperator2, 'so2_Kedatangan_Ubi_' . $parm);
	}

	// Get value from session
	function GetSessionValue(&$sv, $sn) {
		if (array_key_exists($sn, $_SESSION))
			$sv = $_SESSION[$sn];
	}

	// Set dropdown value to session
	function SetSessionDropDownValue($sv, $so, $parm) {
		$_SESSION['sv_Kedatangan_Ubi_' . $parm] = $sv;
		$_SESSION['so_Kedatangan_Ubi_' . $parm] = $so;
	}

	// Set filter values to session
	function SetSessionFilterValues($sv1, $so1, $sc, $sv2, $so2, $parm) {
		$_SESSION['sv_Kedatangan_Ubi_' . $parm] = $sv1;
		$_SESSION['so_Kedatangan_Ubi_' . $parm] = $so1;
		$_SESSION['sc_Kedatangan_Ubi_' . $parm] = $sc;
		$_SESSION['sv2_Kedatangan_Ubi_' . $parm] = $sv2;
		$_SESSION['so2_Kedatangan_Ubi_' . $parm] = $so2;
	}

	// Check if has Session filter values
	function HasSessionFilterValues($parm) {
		return ((@$_SESSION['sv_' . $parm] <> "" && @$_SESSION['sv_' . $parm] <> EWR_INIT_VALUE) ||
			(@$_SESSION['sv_' . $parm] <> "" && @$_SESSION['sv_' . $parm] <> EWR_INIT_VALUE) ||
			(@$_SESSION['sv2_' . $parm] <> "" && @$_SESSION['sv2_' . $parm] <> EWR_INIT_VALUE));
	}

	// Dropdown filter exist
	function DropDownFilterExist(&$fld, $FldOpr) {
		$sWrk = "";
		$this->BuildDropDownFilter($fld, $sWrk, $FldOpr);
		return ($sWrk <> "");
	}

	// Extended filter exist
	function ExtendedFilterExist(&$fld) {
		$sExtWrk = "";
		$this->BuildExtendedFilter($fld, $sExtWrk);
		return ($sExtWrk <> "");
	}

	// Validate form
	function ValidateForm() {
		global $ReportLanguage, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EWR_SERVER_VALIDATE)
			return ($gsFormError == "");

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			$gsFormError .= ($gsFormError <> "") ? "<p>&nbsp;</p>" : "";
			$gsFormError .= $sFormCustomError;
		}
		return $ValidateForm;
	}

	// Clear selection stored in session
	function ClearSessionSelection($parm) {
		$_SESSION["sel_Kedatangan_Ubi_$parm"] = "";
		$_SESSION["rf_Kedatangan_Ubi_$parm"] = "";
		$_SESSION["rt_Kedatangan_Ubi_$parm"] = "";
	}

	// Load selection from session
	function LoadSelectionFromSession($parm) {
		$fld = &$this->FieldByParm($parm);
		$fld->SelectionList = @$_SESSION["sel_Kedatangan_Ubi_$parm"];
		$fld->RangeFrom = @$_SESSION["rf_Kedatangan_Ubi_$parm"];
		$fld->RangeTo = @$_SESSION["rt_Kedatangan_Ubi_$parm"];
	}

	// Load default value for filters
	function LoadDefaultFilters() {
		/**
		* Set up default values for non Text filters
		*/

		// Field co_nama
		$this->co_nama->DefaultDropDownValue = EWR_INIT_VALUE;
		if (!$this->SearchCommand) $this->co_nama->DropDownValue = $this->co_nama->DefaultDropDownValue;

		// Field var_nama
		$this->var_nama->DefaultDropDownValue = EWR_INIT_VALUE;
		if (!$this->SearchCommand) $this->var_nama->DropDownValue = $this->var_nama->DefaultDropDownValue;

		// Field k_es_tgl_panen
		$this->k_es_tgl_panen->DefaultDropDownValue = EWR_INIT_VALUE;
		if (!$this->SearchCommand) $this->k_es_tgl_panen->DropDownValue = $this->k_es_tgl_panen->DefaultDropDownValue;

		// Field k_ak_tgl_datang
		$this->k_ak_tgl_datang->DefaultDropDownValue = EWR_INIT_VALUE;
		if (!$this->SearchCommand) $this->k_ak_tgl_datang->DropDownValue = $this->k_ak_tgl_datang->DefaultDropDownValue;
		/**
		* Set up default values for extended filters
		* function SetDefaultExtFilter(&$fld, $so1, $sv1, $sc, $so2, $sv2)
		* Parameters:
		* $fld - Field object
		* $so1 - Default search operator 1
		* $sv1 - Default ext filter value 1
		* $sc - Default search condition (if operator 2 is enabled)
		* $so2 - Default search operator 2 (if operator 2 is enabled)
		* $sv2 - Default ext filter value 2 (if operator 2 is enabled)
		*/
		/**
		* Set up default values for popup filters
		*/
	}

	// Check if filter applied
	function CheckFilter() {

		// Check co_nama extended filter
		if ($this->NonTextFilterApplied($this->co_nama))
			return TRUE;

		// Check var_nama extended filter
		if ($this->NonTextFilterApplied($this->var_nama))
			return TRUE;

		// Check k_es_tgl_panen extended filter
		if ($this->NonTextFilterApplied($this->k_es_tgl_panen))
			return TRUE;

		// Check k_ak_tgl_datang extended filter
		if ($this->NonTextFilterApplied($this->k_ak_tgl_datang))
			return TRUE;
		return FALSE;
	}

	// Show list of filters
	function ShowFilterList($showDate = FALSE) {
		global $ReportLanguage;

		// Initialize
		$sFilterList = "";

		// Field co_nama
		$sExtWrk = "";
		$sWrk = "";
		$this->BuildDropDownFilter($this->co_nama, $sExtWrk, $this->co_nama->SearchOperator);
		$sFilter = "";
		if ($sExtWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sExtWrk</span>";
		elseif ($sWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sWrk</span>";
		if ($sFilter <> "")
			$sFilterList .= "<div><span class=\"ewFilterCaption\">" . $this->co_nama->FldCaption() . "</span>" . $sFilter . "</div>";

		// Field var_nama
		$sExtWrk = "";
		$sWrk = "";
		$this->BuildDropDownFilter($this->var_nama, $sExtWrk, $this->var_nama->SearchOperator);
		$sFilter = "";
		if ($sExtWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sExtWrk</span>";
		elseif ($sWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sWrk</span>";
		if ($sFilter <> "")
			$sFilterList .= "<div><span class=\"ewFilterCaption\">" . $this->var_nama->FldCaption() . "</span>" . $sFilter . "</div>";

		// Field k_es_tgl_panen
		$sExtWrk = "";
		$sWrk = "";
		$this->BuildDropDownFilter($this->k_es_tgl_panen, $sExtWrk, $this->k_es_tgl_panen->DateFilter);
		$sFilter = "";
		if ($sExtWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sExtWrk</span>";
		elseif ($sWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sWrk</span>";
		if ($sFilter <> "")
			$sFilterList .= "<div><span class=\"ewFilterCaption\">" . $this->k_es_tgl_panen->FldCaption() . "</span>" . $sFilter . "</div>";

		// Field k_ak_tgl_datang
		$sExtWrk = "";
		$sWrk = "";
		$this->BuildDropDownFilter($this->k_ak_tgl_datang, $sExtWrk, $this->k_ak_tgl_datang->DateFilter);
		$sFilter = "";
		if ($sExtWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sExtWrk</span>";
		elseif ($sWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sWrk</span>";
		if ($sFilter <> "")
			$sFilterList .= "<div><span class=\"ewFilterCaption\">" . $this->k_ak_tgl_datang->FldCaption() . "</span>" . $sFilter . "</div>";
		$divstyle = "";
		$divdataclass = "";

		// Show Filters
		if ($sFilterList <> "" || $showDate) {
			$sMessage = "<div" . $divstyle . $divdataclass . "><div id=\"ewrFilterList\" class=\"alert alert-info ewDisplayTable\">";
			if ($showDate)
				$sMessage .= "<div id=\"ewrCurrentDate\">" . $ReportLanguage->Phrase("ReportGeneratedDate") . ewr_FormatDateTime(date("Y-m-d H:i:s"), 1) . "</div>";
			if ($sFilterList <> "")
				$sMessage .= "<div id=\"ewrCurrentFilters\">" . $ReportLanguage->Phrase("CurrentFilters") . "</div>" . $sFilterList;
			$sMessage .= "</div></div>";
			$this->Message_Showing($sMessage, "");
			echo $sMessage;
		}
	}

	// Get list of filters
	function GetFilterList() {

		// Initialize
		$sFilterList = "";

		// Field co_nama
		$sWrk = "";
		$sWrk = ($this->co_nama->DropDownValue <> EWR_INIT_VALUE) ? $this->co_nama->DropDownValue : "";
		if (is_array($sWrk))
			$sWrk = implode("||", $sWrk);
		if ($sWrk <> "")
			$sWrk = "\"sv_co_nama\":\"" . ewr_JsEncode2($sWrk) . "\"";
		if ($sWrk <> "") {
			if ($sFilterList <> "") $sFilterList .= ",";
			$sFilterList .= $sWrk;
		}

		// Field var_nama
		$sWrk = "";
		$sWrk = ($this->var_nama->DropDownValue <> EWR_INIT_VALUE) ? $this->var_nama->DropDownValue : "";
		if (is_array($sWrk))
			$sWrk = implode("||", $sWrk);
		if ($sWrk <> "")
			$sWrk = "\"sv_var_nama\":\"" . ewr_JsEncode2($sWrk) . "\"";
		if ($sWrk <> "") {
			if ($sFilterList <> "") $sFilterList .= ",";
			$sFilterList .= $sWrk;
		}

		// Field k_es_tgl_panen
		$sWrk = "";
		$sWrk = ($this->k_es_tgl_panen->DropDownValue <> EWR_INIT_VALUE) ? $this->k_es_tgl_panen->DropDownValue : "";
		if (is_array($sWrk))
			$sWrk = implode("||", $sWrk);
		if ($sWrk <> "")
			$sWrk = "\"sv_k_es_tgl_panen\":\"" . ewr_JsEncode2($sWrk) . "\"";
		if ($sWrk <> "") {
			if ($sFilterList <> "") $sFilterList .= ",";
			$sFilterList .= $sWrk;
		}

		// Field k_ak_tgl_datang
		$sWrk = "";
		$sWrk = ($this->k_ak_tgl_datang->DropDownValue <> EWR_INIT_VALUE) ? $this->k_ak_tgl_datang->DropDownValue : "";
		if (is_array($sWrk))
			$sWrk = implode("||", $sWrk);
		if ($sWrk <> "")
			$sWrk = "\"sv_k_ak_tgl_datang\":\"" . ewr_JsEncode2($sWrk) . "\"";
		if ($sWrk <> "") {
			if ($sFilterList <> "") $sFilterList .= ",";
			$sFilterList .= $sWrk;
		}

		// Return filter list in json
		if ($sFilterList <> "")
			return "{" . $sFilterList . "}";
		else
			return "null";
	}

	// Restore list of filters
	function RestoreFilterList() {

		// Return if not reset filter
		if (@$_POST["cmd"] <> "resetfilter")
			return FALSE;
		$filter = json_decode(ewr_StripSlashes(@$_POST["filter"]), TRUE);
		return $this->SetupFilterList($filter);
	}

	// Setup list of filters
	function SetupFilterList($filter) {
		if (!is_array($filter))
			return FALSE;

		// Field co_nama
		$bRestoreFilter = FALSE;
		if (array_key_exists("sv_co_nama", $filter)) {
			$sWrk = $filter["sv_co_nama"];
			if (strpos($sWrk, "||") !== FALSE)
				$sWrk = explode("||", $sWrk);
			$this->SetSessionDropDownValue($sWrk, @$filter["so_co_nama"], "co_nama");
			$bRestoreFilter = TRUE;
		}
		if (!$bRestoreFilter) { // Clear filter
			$this->SetSessionDropDownValue(EWR_INIT_VALUE, "", "co_nama");
		}

		// Field var_nama
		$bRestoreFilter = FALSE;
		if (array_key_exists("sv_var_nama", $filter)) {
			$sWrk = $filter["sv_var_nama"];
			if (strpos($sWrk, "||") !== FALSE)
				$sWrk = explode("||", $sWrk);
			$this->SetSessionDropDownValue($sWrk, @$filter["so_var_nama"], "var_nama");
			$bRestoreFilter = TRUE;
		}
		if (!$bRestoreFilter) { // Clear filter
			$this->SetSessionDropDownValue(EWR_INIT_VALUE, "", "var_nama");
		}

		// Field k_es_tgl_panen
		$bRestoreFilter = FALSE;
		if (array_key_exists("sv_k_es_tgl_panen", $filter)) {
			$sWrk = $filter["sv_k_es_tgl_panen"];
			if (strpos($sWrk, "||") !== FALSE)
				$sWrk = explode("||", $sWrk);
			$this->SetSessionDropDownValue($sWrk, @$filter["so_k_es_tgl_panen"], "k_es_tgl_panen");
			$bRestoreFilter = TRUE;
		}
		if (!$bRestoreFilter) { // Clear filter
			$this->SetSessionDropDownValue(EWR_INIT_VALUE, "", "k_es_tgl_panen");
		}

		// Field k_ak_tgl_datang
		$bRestoreFilter = FALSE;
		if (array_key_exists("sv_k_ak_tgl_datang", $filter)) {
			$sWrk = $filter["sv_k_ak_tgl_datang"];
			if (strpos($sWrk, "||") !== FALSE)
				$sWrk = explode("||", $sWrk);
			$this->SetSessionDropDownValue($sWrk, @$filter["so_k_ak_tgl_datang"], "k_ak_tgl_datang");
			$bRestoreFilter = TRUE;
		}
		if (!$bRestoreFilter) { // Clear filter
			$this->SetSessionDropDownValue(EWR_INIT_VALUE, "", "k_ak_tgl_datang");
		}
		return TRUE;
	}

	// Return popup filter
	function GetPopupFilter() {
		$sWrk = "";
		if ($this->DrillDown)
			return "";
		return $sWrk;
	}

	//-------------------------------------------------------------------------------
	// Function GetSort
	// - Return Sort parameters based on Sort Links clicked
	// - Variables setup: Session[EWR_TABLE_SESSION_ORDER_BY], Session["sort_Table_Field"]
	function GetSort($options = array()) {
		if ($this->DrillDown)
			return "`k_id_kontrak` ASC";
		$bResetSort = @$options["resetsort"] == "1" || @$_GET["cmd"] == "resetsort";
		$orderBy = (@$options["order"] <> "") ? @$options["order"] : ewr_StripSlashes(@$_GET["order"]);
		$orderType = (@$options["ordertype"] <> "") ? @$options["ordertype"] : ewr_StripSlashes(@$_GET["ordertype"]);

		// Check for a resetsort command
		if ($bResetSort) {
			$this->setOrderBy("");
			$this->setStartGroup(1);
			$this->co_nama->setSort("");
			$this->var_nama->setSort("");
			$this->koord_nama->setSort("");
			$this->pet_nama->setSort("");
			$this->k_id_kontrak->setSort("");
			$this->k_luas_lahan->setSort("");
			$this->k_es_tgl_panen->setSort("");
			$this->k_es_qty->setSort("");
			$this->k_ak_tgl_datang->setSort("");
			$this->k_ak_qty->setSort("");

		// Check for an Order parameter
		} elseif ($orderBy <> "") {
			$this->CurrentOrder = $orderBy;
			$this->CurrentOrderType = $orderType;
			$sSortSql = $this->SortSql();
			$this->setOrderBy($sSortSql);
			$this->setStartGroup(1);
		}

		// Set up default sort
		if ($this->getOrderBy() == "") {
			$this->setOrderBy("`k_id_kontrak` ASC");
			$this->k_id_kontrak->setSort("ASC");
		}
		return $this->getOrderBy();
	}

	// Export to HTML
	function ExportHtml($html, $options = array()) {

		//global $gsExportFile;
		//header('Content-Type: text/html' . (EWR_CHARSET <> '' ? ';charset=' . EWR_CHARSET : ''));
		//header('Content-Disposition: attachment; filename=' . $gsExportFile . '.html');

		$folder = @$this->GenOptions["folder"];
		$fileName = @$this->GenOptions["filename"];
		$responseType = @$options["responsetype"];
		$saveToFile = "";

		// Save generate file for print
		if ($folder <> "" && $fileName <> "" && ($responseType == "json" || $responseType == "file" && EWR_REPORT_SAVE_OUTPUT_ON_SERVER)) {
			$baseTag = "<base href=\"" . ewr_BaseUrl() . "\">";
			$html = preg_replace('/<head>/', '<head>' . $baseTag, $html);
			ewr_SaveFile($folder, $fileName, $html);
			$saveToFile = ewr_UploadPathEx(FALSE, $folder) . $fileName;
		}
		if ($saveToFile == "" || $responseType == "file")
			echo $html;
		return $saveToFile;
	}

	// Export to WORD
	function ExportWord($html, $options = array()) {
		global $gsExportFile;
		$folder = @$options["folder"];
		$fileName = @$options["filename"];
		$responseType = @$options["responsetype"];
		$saveToFile = "";
		if ($folder <> "" && $fileName <> "" && ($responseType == "json" || $responseType == "file" && EWR_REPORT_SAVE_OUTPUT_ON_SERVER)) {
		 	ewr_SaveFile(ewr_PathCombine(ewr_AppRoot(), $folder, TRUE), $fileName, $html);
			$saveToFile = ewr_UploadPathEx(FALSE, $folder) . $fileName;
		}
		if ($saveToFile == "" || $responseType == "file") {
			header('Content-Type: application/vnd.ms-word' . (EWR_CHARSET <> '' ? ';charset=' . EWR_CHARSET : ''));
			header('Content-Disposition: attachment; filename=' . $gsExportFile . '.doc');
			echo $html;
		}
		return $saveToFile;
	}

	// Export to EXCEL
	function ExportExcel($html, $options = array()) {
		global $gsExportFile;
		$folder = @$options["folder"];
		$fileName = @$options["filename"];
		$responseType = @$options["responsetype"];
		$saveToFile = "";
		if ($folder <> "" && $fileName <> "" && ($responseType == "json" || $responseType == "file" && EWR_REPORT_SAVE_OUTPUT_ON_SERVER)) {
		 	ewr_SaveFile(ewr_PathCombine(ewr_AppRoot(), $folder, TRUE), $fileName, $html);
			$saveToFile = ewr_UploadPathEx(FALSE, $folder) . $fileName;
		}
		if ($saveToFile == "" || $responseType == "file") {
			header('Content-Type: application/vnd.ms-excel' . (EWR_CHARSET <> '' ? ';charset=' . EWR_CHARSET : ''));
			header('Content-Disposition: attachment; filename=' . $gsExportFile . '.xls');
			echo $html;
		}
		return $saveToFile;
	}

	// Export PDF
	function ExportPdf($html, $options = array()) {
		global $gsExportFile;
		@ini_set("memory_limit", EWR_PDF_MEMORY_LIMIT);
		set_time_limit(EWR_PDF_TIME_LIMIT);
		if (EWR_DEBUG_ENABLED) // Add debug message
			$html = str_replace("</body>", ewr_DebugMsg() . "</body>", $html);
		$dompdf = new \Dompdf\Dompdf(array("pdf_backend" => "Cpdf"));
		$doc = new DOMDocument();
		@$doc->loadHTML('<?xml encoding="uft-8">' . ewr_ConvertToUtf8($html)); // Convert to utf-8
		$spans = $doc->getElementsByTagName("span");
		foreach ($spans as $span) {
			if ($span->getAttribute("class") == "ewFilterCaption")
				$span->parentNode->insertBefore($doc->createElement("span", ":&nbsp;"), $span->nextSibling);
		}
		$html = $doc->saveHTML();
		$html = ewr_ConvertFromUtf8($html);
		$dompdf->load_html($html);
		$dompdf->set_paper("a4", "portrait");
		$dompdf->render();
		$folder = @$options["folder"];
		$fileName = @$options["filename"];
		$responseType = @$options["responsetype"];
		$saveToFile = "";
		if ($folder <> "" && $fileName <> "" && ($responseType == "json" || $responseType == "file" && EWR_REPORT_SAVE_OUTPUT_ON_SERVER)) {
			ewr_SaveFile(ewr_PathCombine(ewr_AppRoot(), $folder, TRUE), $fileName, $dompdf->output());
			$saveToFile = ewr_UploadPathEx(FALSE, $folder) . $fileName;
		}
		if ($saveToFile == "" || $responseType == "file") {
			$sExportFile = strtolower(substr($gsExportFile, -4)) == ".pdf" ? $gsExportFile : $gsExportFile . ".pdf";
			$dompdf->stream($sExportFile, array("Attachment" => 1)); // 0 to open in browser, 1 to download
		}
		ewr_DeleteTmpImages($html);
		return $saveToFile;
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ewr_Header(FALSE) ?>
<?php

// Create page object
if (!isset($Kedatangan_Ubi_summary)) $Kedatangan_Ubi_summary = new crKedatangan_Ubi_summary();
if (isset($Page)) $OldPage = $Page;
$Page = &$Kedatangan_Ubi_summary;

// Page init
$Page->Page_Init();

// Page main
$Page->Page_Main();

// Global Page Rendering event (in ewrusrfn*.php)
Page_Rendering();

// Page Rendering event
$Page->Page_Render();
?>
<?php include_once "header.php" ?>
<?php include_once "phprptinc/header.php" ?>
<?php if ($Page->Export == "" || $Page->Export == "print" || $Page->Export == "email" && @$gsEmailContentType == "url") { ?>
<script type="text/javascript">

// Create page object
var Kedatangan_Ubi_summary = new ewr_Page("Kedatangan_Ubi_summary");

// Page properties
Kedatangan_Ubi_summary.PageID = "summary"; // Page ID
var EWR_PAGE_ID = Kedatangan_Ubi_summary.PageID;

// Extend page with Chart_Rendering function
Kedatangan_Ubi_summary.Chart_Rendering = 
 function(chart, chartid) { // DO NOT CHANGE THIS LINE!

 	//alert(chartid);
 }

// Extend page with Chart_Rendered function
Kedatangan_Ubi_summary.Chart_Rendered = 
 function(chart, chartid) { // DO NOT CHANGE THIS LINE!

 	//alert(chartid);
 }
</script>
<?php } ?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<script type="text/javascript">

// Form object
var CurrentForm = fKedatangan_Ubisummary = new ewr_Form("fKedatangan_Ubisummary");

// Validate method
fKedatangan_Ubisummary.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);

	// Call Form Custom Validate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate method
fKedatangan_Ubisummary.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }
<?php if (EWR_CLIENT_VALIDATE) { ?>
fKedatangan_Ubisummary.ValidateRequired = true; // Uses JavaScript validation
<?php } else { ?>
fKedatangan_Ubisummary.ValidateRequired = false; // No JavaScript validation
<?php } ?>

// Use Ajax
fKedatangan_Ubisummary.Lists["sv_co_nama"] = {"LinkField":"sv_co_nama","Ajax":true,"DisplayFields":["sv_co_nama","","",""],"ParentFields":[],"FilterFields":[],"Options":[],"Template":""};
fKedatangan_Ubisummary.Lists["sv_var_nama"] = {"LinkField":"sv_var_nama","Ajax":true,"DisplayFields":["sv_var_nama","","",""],"ParentFields":[],"FilterFields":[],"Options":[],"Template":""};
fKedatangan_Ubisummary.Lists["sv_k_es_tgl_panen"] = {"LinkField":"sv_k_es_tgl_panen","Ajax":true,"DisplayFields":["sv_k_es_tgl_panen","","",""],"ParentFields":[],"FilterFields":[],"Options":[],"Template":""};
fKedatangan_Ubisummary.Lists["sv_k_ak_tgl_datang"] = {"LinkField":"sv_k_ak_tgl_datang","Ajax":true,"DisplayFields":["sv_k_ak_tgl_datang","","",""],"ParentFields":[],"FilterFields":[],"Options":[],"Template":""};
</script>
<?php } ?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if ($Page->Export == "") { ?>
<!-- container (begin) -->
<div id="ewContainer" class="ewContainer">
<!-- top container (begin) -->
<div id="ewTop" class="ewTop">
<a id="top"></a>
<?php } ?>
<?php if (@$Page->GenOptions["showfilter"] == "1") { ?>
<?php $Page->ShowFilterList(TRUE) ?>
<?php } ?>
<!-- top slot -->
<div class="ewToolbar">
<?php
if (!$Page->DrillDownInPanel) {
	$Page->ExportOptions->Render("body");
	$Page->SearchOptions->Render("body");
	$Page->FilterOptions->Render("body");
	$Page->GenerateOptions->Render("body");
}
?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<?php echo $ReportLanguage->SelectionForm(); ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php $Page->ShowPageHeader(); ?>
<?php $Page->ShowMessage(); ?>
<?php if ($Page->Export == "") { ?>
</div>
<!-- top container (end) -->
	<!-- left container (begin) -->
	<div id="ewLeft" class="ewLeft">
<?php } ?>
	<!-- Left slot -->
<?php if ($Page->Export == "") { ?>
	</div>
	<!-- left container (end) -->
	<!-- center container - report (begin) -->
	<div id="ewCenter" class="ewCenter">
<?php } ?>
	<!-- center slot -->
<!-- summary report starts -->
<?php if ($Page->Export <> "pdf") { ?>
<div id="report_summary">
<?php } ?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<!-- Search form (begin) -->
<form name="fKedatangan_Ubisummary" id="fKedatangan_Ubisummary" class="form-inline ewForm ewExtFilterForm" action="<?php echo ewr_CurrentPage() ?>">
<?php $SearchPanelClass = ($Page->Filter <> "") ? " in" : " in"; ?>
<div id="fKedatangan_Ubisummary_SearchPanel" class="ewSearchPanel collapse<?php echo $SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<div id="r_1" class="ewRow">
<div id="c_co_nama" class="ewCell form-group">
	<label for="sv_co_nama" class="ewSearchCaption ewLabel"><?php echo $Page->co_nama->FldCaption() ?></label>
	<span class="ewSearchField">
<?php ewr_PrependClass($Page->co_nama->EditAttrs["class"], "form-control"); ?>
<select data-table="Kedatangan_Ubi" data-field="x_co_nama" data-value-separator="<?php echo ewr_HtmlEncode(is_array($Page->co_nama->DisplayValueSeparator) ? json_encode($Page->co_nama->DisplayValueSeparator) : $Page->co_nama->DisplayValueSeparator) ?>" id="sv_co_nama" name="sv_co_nama"<?php echo $Page->co_nama->EditAttributes() ?>>
<option value=""><?php echo $ReportLanguage->Phrase("PleaseSelect") ?></option>
<?php
	$cntf = is_array($Page->co_nama->AdvancedFilters) ? count($Page->co_nama->AdvancedFilters) : 0;
	$cntd = is_array($Page->co_nama->DropDownList) ? count($Page->co_nama->DropDownList) : 0;
	$totcnt = $cntf + $cntd;
	$wrkcnt = 0;
	if ($cntf > 0) {
		foreach ($Page->co_nama->AdvancedFilters as $filter) {
			if ($filter->Enabled) {
				$selwrk = ewr_MatchedFilterValue($Page->co_nama->DropDownValue, $filter->ID) ? " selected" : "";
?>
<option value="<?php echo $filter->ID ?>"<?php echo $selwrk ?>><?php echo $filter->Name ?></option>
<?php
				$wrkcnt += 1;
			}
		}
	}
	for ($i = 0; $i < $cntd; $i++) {
		$selwrk = " selected";
?>
<option value="<?php echo $Page->co_nama->DropDownList[$i] ?>"<?php echo $selwrk ?>><?php echo ewr_DropDownDisplayValue($Page->co_nama->DropDownList[$i], "", 0) ?></option>
<?php
		$wrkcnt += 1;
	}
?>
</select>
<input type="hidden" name="s_sv_co_nama" id="s_sv_co_nama" value="<?php echo $Page->co_nama->LookupFilterQuery() ?>"></span>
</div>
</div>
<div id="r_2" class="ewRow">
<div id="c_var_nama" class="ewCell form-group">
	<label for="sv_var_nama" class="ewSearchCaption ewLabel"><?php echo $Page->var_nama->FldCaption() ?></label>
	<span class="ewSearchField">
<?php ewr_PrependClass($Page->var_nama->EditAttrs["class"], "form-control"); ?>
<select data-table="Kedatangan_Ubi" data-field="x_var_nama" data-value-separator="<?php echo ewr_HtmlEncode(is_array($Page->var_nama->DisplayValueSeparator) ? json_encode($Page->var_nama->DisplayValueSeparator) : $Page->var_nama->DisplayValueSeparator) ?>" id="sv_var_nama" name="sv_var_nama"<?php echo $Page->var_nama->EditAttributes() ?>>
<option value=""><?php echo $ReportLanguage->Phrase("PleaseSelect") ?></option>
<?php
	$cntf = is_array($Page->var_nama->AdvancedFilters) ? count($Page->var_nama->AdvancedFilters) : 0;
	$cntd = is_array($Page->var_nama->DropDownList) ? count($Page->var_nama->DropDownList) : 0;
	$totcnt = $cntf + $cntd;
	$wrkcnt = 0;
	if ($cntf > 0) {
		foreach ($Page->var_nama->AdvancedFilters as $filter) {
			if ($filter->Enabled) {
				$selwrk = ewr_MatchedFilterValue($Page->var_nama->DropDownValue, $filter->ID) ? " selected" : "";
?>
<option value="<?php echo $filter->ID ?>"<?php echo $selwrk ?>><?php echo $filter->Name ?></option>
<?php
				$wrkcnt += 1;
			}
		}
	}
	for ($i = 0; $i < $cntd; $i++) {
		$selwrk = " selected";
?>
<option value="<?php echo $Page->var_nama->DropDownList[$i] ?>"<?php echo $selwrk ?>><?php echo ewr_DropDownDisplayValue($Page->var_nama->DropDownList[$i], "", 0) ?></option>
<?php
		$wrkcnt += 1;
	}
?>
</select>
<input type="hidden" name="s_sv_var_nama" id="s_sv_var_nama" value="<?php echo $Page->var_nama->LookupFilterQuery() ?>"></span>
</div>
</div>
<div id="r_3" class="ewRow">
<div id="c_k_es_tgl_panen" class="ewCell form-group">
	<label for="sv_k_es_tgl_panen" class="ewSearchCaption ewLabel"><?php echo $Page->k_es_tgl_panen->FldCaption() ?></label>
	<span class="ewSearchField">
<?php ewr_PrependClass($Page->k_es_tgl_panen->EditAttrs["class"], "form-control"); ?>
<select data-table="Kedatangan_Ubi" data-field="x_k_es_tgl_panen" data-value-separator="<?php echo ewr_HtmlEncode(is_array($Page->k_es_tgl_panen->DisplayValueSeparator) ? json_encode($Page->k_es_tgl_panen->DisplayValueSeparator) : $Page->k_es_tgl_panen->DisplayValueSeparator) ?>" id="sv_k_es_tgl_panen" name="sv_k_es_tgl_panen"<?php echo $Page->k_es_tgl_panen->EditAttributes() ?>>
<option value=""><?php echo $ReportLanguage->Phrase("PleaseSelect") ?></option>
<?php
	$cntf = is_array($Page->k_es_tgl_panen->AdvancedFilters) ? count($Page->k_es_tgl_panen->AdvancedFilters) : 0;
	$cntd = is_array($Page->k_es_tgl_panen->DropDownList) ? count($Page->k_es_tgl_panen->DropDownList) : 0;
	$totcnt = $cntf + $cntd;
	$wrkcnt = 0;
	if ($cntf > 0) {
		foreach ($Page->k_es_tgl_panen->AdvancedFilters as $filter) {
			if ($filter->Enabled) {
				$selwrk = ewr_MatchedFilterValue($Page->k_es_tgl_panen->DropDownValue, $filter->ID) ? " selected" : "";
?>
<option value="<?php echo $filter->ID ?>"<?php echo $selwrk ?>><?php echo $filter->Name ?></option>
<?php
				$wrkcnt += 1;
			}
		}
	}
	for ($i = 0; $i < $cntd; $i++) {
		$selwrk = " selected";
?>
<option value="<?php echo $Page->k_es_tgl_panen->DropDownList[$i] ?>"<?php echo $selwrk ?>><?php echo ewr_DropDownDisplayValue($Page->k_es_tgl_panen->DropDownList[$i], $Page->k_es_tgl_panen->DateFilter, 0) ?></option>
<?php
		$wrkcnt += 1;
	}
?>
</select>
<input type="hidden" name="s_sv_k_es_tgl_panen" id="s_sv_k_es_tgl_panen" value="<?php echo $Page->k_es_tgl_panen->LookupFilterQuery() ?>"></span>
</div>
</div>
<div id="r_4" class="ewRow">
<div id="c_k_ak_tgl_datang" class="ewCell form-group">
	<label for="sv_k_ak_tgl_datang" class="ewSearchCaption ewLabel"><?php echo $Page->k_ak_tgl_datang->FldCaption() ?></label>
	<span class="ewSearchField">
<?php ewr_PrependClass($Page->k_ak_tgl_datang->EditAttrs["class"], "form-control"); ?>
<select data-table="Kedatangan_Ubi" data-field="x_k_ak_tgl_datang" data-value-separator="<?php echo ewr_HtmlEncode(is_array($Page->k_ak_tgl_datang->DisplayValueSeparator) ? json_encode($Page->k_ak_tgl_datang->DisplayValueSeparator) : $Page->k_ak_tgl_datang->DisplayValueSeparator) ?>" id="sv_k_ak_tgl_datang" name="sv_k_ak_tgl_datang"<?php echo $Page->k_ak_tgl_datang->EditAttributes() ?>>
<option value=""><?php echo $ReportLanguage->Phrase("PleaseSelect") ?></option>
<?php
	$cntf = is_array($Page->k_ak_tgl_datang->AdvancedFilters) ? count($Page->k_ak_tgl_datang->AdvancedFilters) : 0;
	$cntd = is_array($Page->k_ak_tgl_datang->DropDownList) ? count($Page->k_ak_tgl_datang->DropDownList) : 0;
	$totcnt = $cntf + $cntd;
	$wrkcnt = 0;
	if ($cntf > 0) {
		foreach ($Page->k_ak_tgl_datang->AdvancedFilters as $filter) {
			if ($filter->Enabled) {
				$selwrk = ewr_MatchedFilterValue($Page->k_ak_tgl_datang->DropDownValue, $filter->ID) ? " selected" : "";
?>
<option value="<?php echo $filter->ID ?>"<?php echo $selwrk ?>><?php echo $filter->Name ?></option>
<?php
				$wrkcnt += 1;
			}
		}
	}
	for ($i = 0; $i < $cntd; $i++) {
		$selwrk = " selected";
?>
<option value="<?php echo $Page->k_ak_tgl_datang->DropDownList[$i] ?>"<?php echo $selwrk ?>><?php echo ewr_DropDownDisplayValue($Page->k_ak_tgl_datang->DropDownList[$i], $Page->k_ak_tgl_datang->DateFilter, 0) ?></option>
<?php
		$wrkcnt += 1;
	}
?>
</select>
<input type="hidden" name="s_sv_k_ak_tgl_datang" id="s_sv_k_ak_tgl_datang" value="<?php echo $Page->k_ak_tgl_datang->LookupFilterQuery() ?>"></span>
</div>
</div>
<div class="ewRow"><input type="submit" name="btnsubmit" id="btnsubmit" class="btn btn-primary" value="<?php echo $ReportLanguage->Phrase("Search") ?>">
<input type="reset" name="btnreset" id="btnreset" class="btn hide" value="<?php echo $ReportLanguage->Phrase("Reset") ?>"></div>
</div>
</form>
<script type="text/javascript">
fKedatangan_Ubisummary.Init();
fKedatangan_Ubisummary.FilterList = <?php echo $Page->GetFilterList() ?>;
</script>
<!-- Search form (end) -->
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->ShowFilterList() ?>
<?php } ?>
<?php

// Set the last group to display if not export all
if ($Page->ExportAll && $Page->Export <> "") {
	$Page->StopGrp = $Page->TotalGrps;
} else {
	$Page->StopGrp = $Page->StartGrp + $Page->DisplayGrps - 1;
}

// Stop group <= total number of groups
if (intval($Page->StopGrp) > intval($Page->TotalGrps))
	$Page->StopGrp = $Page->TotalGrps;
$Page->RecCount = 0;
$Page->RecIndex = 0;

// Get first row
if ($Page->TotalGrps > 0) {
	$Page->GetGrpRow(1);
	$Page->GrpCounter[0] = 1;
	$Page->GrpCount = 1;
}
$Page->GrpIdx = ewr_InitArray($Page->StopGrp - $Page->StartGrp + 1, -1);
while ($rsgrp && !$rsgrp->EOF && $Page->GrpCount <= $Page->DisplayGrps || $Page->ShowHeader) {

	// Show dummy header for custom template
	// Show header

	if ($Page->ShowHeader) {
?>
<?php if ($Page->GrpCount > 1) { ?>
</tbody>
</table>
<?php if ($Page->Export <> "pdf") { ?>
</div>
<?php } ?>
<?php if ($Page->Export == "" && !($Page->DrillDown && $Page->TotalGrps > 0)) { ?>
<div class="panel-footer ewGridLowerPanel">
<?php include "Kedatangan_Ubismrypager.php" ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($Page->Export <> "pdf") { ?>
</div>
<?php } ?>
<span data-class="tpb<?php echo $Page->GrpCount-1 ?>_Kedatangan_Ubi"><?php echo $Page->PageBreakContent ?></span>
<?php } ?>
<?php if ($Page->Export <> "pdf") { ?>
<?php if ($Page->Export == "word" || $Page->Export == "excel") { ?>
<div class="ewGrid"<?php echo $Page->ReportTableStyle ?>>
<?php } else { ?>
<div class="panel panel-default ewGrid"<?php echo $Page->ReportTableStyle ?>>
<?php } ?>
<?php } ?>
<!-- Report grid (begin) -->
<?php if ($Page->Export <> "pdf") { ?>
<div class="<?php if (ewr_IsResponsiveLayout()) { echo "table-responsive "; } ?>ewGridMiddlePanel">
<?php } ?>
<table class="<?php echo $Page->ReportTableClass ?>">
<thead>
	<!-- Table header -->
	<tr class="ewTableHeader">
<?php if ($Page->co_nama->Visible) { ?>
	<?php if ($Page->co_nama->ShowGroupHeaderAsRow) { ?>
	<td data-field="co_nama">&nbsp;</td>
	<?php } else { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="co_nama"><div class="Kedatangan_Ubi_co_nama"><span class="ewTableHeaderCaption"><?php echo $Page->co_nama->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="co_nama">
<?php if ($Page->SortUrl($Page->co_nama) == "") { ?>
		<div class="ewTableHeaderBtn Kedatangan_Ubi_co_nama">
			<span class="ewTableHeaderCaption"><?php echo $Page->co_nama->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Kedatangan_Ubi_co_nama" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->co_nama) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->co_nama->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->co_nama->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->co_nama->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
	<?php } ?>
<?php } ?>
<?php if ($Page->var_nama->Visible) { ?>
	<?php if ($Page->var_nama->ShowGroupHeaderAsRow) { ?>
	<td data-field="var_nama">&nbsp;</td>
	<?php } else { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="var_nama"><div class="Kedatangan_Ubi_var_nama"><span class="ewTableHeaderCaption"><?php echo $Page->var_nama->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="var_nama">
<?php if ($Page->SortUrl($Page->var_nama) == "") { ?>
		<div class="ewTableHeaderBtn Kedatangan_Ubi_var_nama">
			<span class="ewTableHeaderCaption"><?php echo $Page->var_nama->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Kedatangan_Ubi_var_nama" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->var_nama) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->var_nama->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->var_nama->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->var_nama->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
	<?php } ?>
<?php } ?>
<?php if ($Page->koord_nama->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="koord_nama"><div class="Kedatangan_Ubi_koord_nama"><span class="ewTableHeaderCaption"><?php echo $Page->koord_nama->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="koord_nama">
<?php if ($Page->SortUrl($Page->koord_nama) == "") { ?>
		<div class="ewTableHeaderBtn Kedatangan_Ubi_koord_nama">
			<span class="ewTableHeaderCaption"><?php echo $Page->koord_nama->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Kedatangan_Ubi_koord_nama" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->koord_nama) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->koord_nama->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->koord_nama->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->koord_nama->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->pet_nama->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="pet_nama"><div class="Kedatangan_Ubi_pet_nama"><span class="ewTableHeaderCaption"><?php echo $Page->pet_nama->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="pet_nama">
<?php if ($Page->SortUrl($Page->pet_nama) == "") { ?>
		<div class="ewTableHeaderBtn Kedatangan_Ubi_pet_nama">
			<span class="ewTableHeaderCaption"><?php echo $Page->pet_nama->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Kedatangan_Ubi_pet_nama" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->pet_nama) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->pet_nama->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->pet_nama->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->pet_nama->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->k_id_kontrak->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="k_id_kontrak"><div class="Kedatangan_Ubi_k_id_kontrak"><span class="ewTableHeaderCaption"><?php echo $Page->k_id_kontrak->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="k_id_kontrak">
<?php if ($Page->SortUrl($Page->k_id_kontrak) == "") { ?>
		<div class="ewTableHeaderBtn Kedatangan_Ubi_k_id_kontrak">
			<span class="ewTableHeaderCaption"><?php echo $Page->k_id_kontrak->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Kedatangan_Ubi_k_id_kontrak" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->k_id_kontrak) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->k_id_kontrak->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->k_id_kontrak->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->k_id_kontrak->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->k_luas_lahan->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="k_luas_lahan"><div class="Kedatangan_Ubi_k_luas_lahan"><span class="ewTableHeaderCaption"><?php echo $Page->k_luas_lahan->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="k_luas_lahan">
<?php if ($Page->SortUrl($Page->k_luas_lahan) == "") { ?>
		<div class="ewTableHeaderBtn Kedatangan_Ubi_k_luas_lahan">
			<span class="ewTableHeaderCaption"><?php echo $Page->k_luas_lahan->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Kedatangan_Ubi_k_luas_lahan" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->k_luas_lahan) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->k_luas_lahan->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->k_luas_lahan->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->k_luas_lahan->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->k_es_tgl_panen->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="k_es_tgl_panen"><div class="Kedatangan_Ubi_k_es_tgl_panen"><span class="ewTableHeaderCaption"><?php echo $Page->k_es_tgl_panen->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="k_es_tgl_panen">
<?php if ($Page->SortUrl($Page->k_es_tgl_panen) == "") { ?>
		<div class="ewTableHeaderBtn Kedatangan_Ubi_k_es_tgl_panen">
			<span class="ewTableHeaderCaption"><?php echo $Page->k_es_tgl_panen->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Kedatangan_Ubi_k_es_tgl_panen" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->k_es_tgl_panen) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->k_es_tgl_panen->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->k_es_tgl_panen->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->k_es_tgl_panen->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->k_es_qty->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="k_es_qty"><div class="Kedatangan_Ubi_k_es_qty"><span class="ewTableHeaderCaption"><?php echo $Page->k_es_qty->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="k_es_qty">
<?php if ($Page->SortUrl($Page->k_es_qty) == "") { ?>
		<div class="ewTableHeaderBtn Kedatangan_Ubi_k_es_qty">
			<span class="ewTableHeaderCaption"><?php echo $Page->k_es_qty->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Kedatangan_Ubi_k_es_qty" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->k_es_qty) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->k_es_qty->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->k_es_qty->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->k_es_qty->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->k_ak_tgl_datang->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="k_ak_tgl_datang"><div class="Kedatangan_Ubi_k_ak_tgl_datang"><span class="ewTableHeaderCaption"><?php echo $Page->k_ak_tgl_datang->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="k_ak_tgl_datang">
<?php if ($Page->SortUrl($Page->k_ak_tgl_datang) == "") { ?>
		<div class="ewTableHeaderBtn Kedatangan_Ubi_k_ak_tgl_datang">
			<span class="ewTableHeaderCaption"><?php echo $Page->k_ak_tgl_datang->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Kedatangan_Ubi_k_ak_tgl_datang" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->k_ak_tgl_datang) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->k_ak_tgl_datang->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->k_ak_tgl_datang->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->k_ak_tgl_datang->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->k_ak_qty->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="k_ak_qty"><div class="Kedatangan_Ubi_k_ak_qty"><span class="ewTableHeaderCaption"><?php echo $Page->k_ak_qty->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="k_ak_qty">
<?php if ($Page->SortUrl($Page->k_ak_qty) == "") { ?>
		<div class="ewTableHeaderBtn Kedatangan_Ubi_k_ak_qty">
			<span class="ewTableHeaderCaption"><?php echo $Page->k_ak_qty->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Kedatangan_Ubi_k_ak_qty" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->k_ak_qty) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->k_ak_qty->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->k_ak_qty->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->k_ak_qty->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
	</tr>
</thead>
<tbody>
<?php
		if ($Page->TotalGrps == 0) break; // Show header only
		$Page->ShowHeader = FALSE;
	}

	// Build detail SQL
	$sWhere = ewr_DetailFilterSQL($Page->co_nama, $Page->getSqlFirstGroupField(), $Page->co_nama->GroupValue(), $Page->DBID);
	if ($Page->PageFirstGroupFilter <> "") $Page->PageFirstGroupFilter .= " OR ";
	$Page->PageFirstGroupFilter .= $sWhere;
	if ($Page->Filter != "")
		$sWhere = "($Page->Filter) AND ($sWhere)";
	$sSql = ewr_BuildReportSql($Page->getSqlSelect(), $Page->getSqlWhere(), $Page->getSqlGroupBy(), $Page->getSqlHaving(), $Page->getSqlOrderBy(), $sWhere, $Page->Sort);
	$rs = $Page->GetDetailRs($sSql);
	$rsdtlcnt = ($rs) ? $rs->RecordCount() : 0;
	if ($rsdtlcnt > 0)
		$Page->GetRow(1);
	$Page->GrpIdx[$Page->GrpCount] = array(-1);
	while ($rs && !$rs->EOF) { // Loop detail records
		$Page->RecCount++;
		$Page->RecIndex++;
?>
<?php if ($Page->co_nama->Visible && $Page->ChkLvlBreak(1) && $Page->co_nama->ShowGroupHeaderAsRow) { ?>
<?php

		// Render header row
		$Page->ResetAttrs();
		$Page->RowType = EWR_ROWTYPE_TOTAL;
		$Page->RowTotalType = EWR_ROWTOTAL_GROUP;
		$Page->RowTotalSubType = EWR_ROWTOTAL_HEADER;
		$Page->RowGroupLevel = 1;
		$Page->co_nama->Count = $Page->GetSummaryCount(1);
		$Page->RenderRow();
?>
	<tr<?php echo $Page->RowAttributes(); ?>>
<?php if ($Page->co_nama->Visible) { ?>
		<td data-field="co_nama"<?php echo $Page->co_nama->CellAttributes(); ?>><span class="ewGroupToggle icon-collapse"></span></td>
<?php } ?>
		<td data-field="co_nama" colspan="<?php echo ($Page->GrpColumnCount + $Page->DtlColumnCount - 1) ?>"<?php echo $Page->co_nama->CellAttributes() ?>>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
		<span class="ewSummaryCaption Kedatangan_Ubi_co_nama"><span class="ewTableHeaderCaption"><?php echo $Page->co_nama->FldCaption() ?></span></span>
<?php } else { ?>
	<?php if ($Page->SortUrl($Page->co_nama) == "") { ?>
		<span class="ewSummaryCaption Kedatangan_Ubi_co_nama">
			<span class="ewTableHeaderCaption"><?php echo $Page->co_nama->FldCaption() ?></span>
		</span>
	<?php } else { ?>
		<span class="ewTableHeaderBtn ewPointer ewSummaryCaption Kedatangan_Ubi_co_nama" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->co_nama) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->co_nama->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->co_nama->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->co_nama->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</span>
	<?php } ?>
<?php } ?>
		<?php echo $ReportLanguage->Phrase("SummaryColon") ?>
<span data-class="tpx<?php echo $Page->GrpCount ?>_Kedatangan_Ubi_co_nama"<?php echo $Page->co_nama->ViewAttributes() ?>><?php echo $Page->co_nama->GroupViewValue ?></span>
		<span class="ewSummaryCount">(<span class="ewAggregateCaption"><?php echo $ReportLanguage->Phrase("RptCnt") ?></span><?php echo $ReportLanguage->Phrase("AggregateEqual") ?><span class="ewAggregateValue"><?php echo ewr_FormatNumber($Page->co_nama->Count,0,-2,-2,-2) ?></span>)</span>
		</td>
	</tr>
<?php } ?>
<?php if ($Page->var_nama->Visible && $Page->ChkLvlBreak(2) && $Page->var_nama->ShowGroupHeaderAsRow) { ?>
<?php

		// Render header row
		$Page->ResetAttrs();
		$Page->RowType = EWR_ROWTYPE_TOTAL;
		$Page->RowTotalType = EWR_ROWTOTAL_GROUP;
		$Page->RowTotalSubType = EWR_ROWTOTAL_HEADER;
		$Page->RowGroupLevel = 2;
		$Page->var_nama->Count = $Page->GetSummaryCount(2);
		$Page->RenderRow();
?>
	<tr<?php echo $Page->RowAttributes(); ?>>
<?php if ($Page->co_nama->Visible) { ?>
		<td data-field="co_nama"<?php echo $Page->co_nama->CellAttributes(); ?>></td>
<?php } ?>
<?php if ($Page->var_nama->Visible) { ?>
		<td data-field="var_nama"<?php echo $Page->var_nama->CellAttributes(); ?>><span class="ewGroupToggle icon-collapse"></span></td>
<?php } ?>
		<td data-field="var_nama" colspan="<?php echo ($Page->GrpColumnCount + $Page->DtlColumnCount - 2) ?>"<?php echo $Page->var_nama->CellAttributes() ?>>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
		<span class="ewSummaryCaption Kedatangan_Ubi_var_nama"><span class="ewTableHeaderCaption"><?php echo $Page->var_nama->FldCaption() ?></span></span>
<?php } else { ?>
	<?php if ($Page->SortUrl($Page->var_nama) == "") { ?>
		<span class="ewSummaryCaption Kedatangan_Ubi_var_nama">
			<span class="ewTableHeaderCaption"><?php echo $Page->var_nama->FldCaption() ?></span>
		</span>
	<?php } else { ?>
		<span class="ewTableHeaderBtn ewPointer ewSummaryCaption Kedatangan_Ubi_var_nama" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->var_nama) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->var_nama->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->var_nama->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->var_nama->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</span>
	<?php } ?>
<?php } ?>
		<?php echo $ReportLanguage->Phrase("SummaryColon") ?>
<span data-class="tpx<?php echo $Page->GrpCount ?>_<?php echo $Page->GrpCounter[0] ?>_Kedatangan_Ubi_var_nama"<?php echo $Page->var_nama->ViewAttributes() ?>><?php echo $Page->var_nama->GroupViewValue ?></span>
		<span class="ewSummaryCount">(<span class="ewAggregateCaption"><?php echo $ReportLanguage->Phrase("RptCnt") ?></span><?php echo $ReportLanguage->Phrase("AggregateEqual") ?><span class="ewAggregateValue"><?php echo ewr_FormatNumber($Page->var_nama->Count,0,-2,-2,-2) ?></span>)</span>
		</td>
	</tr>
<?php } ?>
<?php

		// Render detail row
		$Page->ResetAttrs();
		$Page->RowType = EWR_ROWTYPE_DETAIL;
		$Page->RenderRow();
?>
	<tr<?php echo $Page->RowAttributes(); ?>>
<?php if ($Page->co_nama->Visible) { ?>
	<?php if ($Page->co_nama->ShowGroupHeaderAsRow) { ?>
		<td data-field="co_nama"<?php echo $Page->co_nama->CellAttributes(); ?>>&nbsp;</td>
	<?php } else { ?>
		<td data-field="co_nama"<?php echo $Page->co_nama->CellAttributes(); ?>>
<span data-class="tpx<?php echo $Page->GrpCount ?>_Kedatangan_Ubi_co_nama"<?php echo $Page->co_nama->ViewAttributes() ?>><?php echo $Page->co_nama->GroupViewValue ?></span></td>
	<?php } ?>
<?php } ?>
<?php if ($Page->var_nama->Visible) { ?>
	<?php if ($Page->var_nama->ShowGroupHeaderAsRow) { ?>
		<td data-field="var_nama"<?php echo $Page->var_nama->CellAttributes(); ?>>&nbsp;</td>
	<?php } else { ?>
		<td data-field="var_nama"<?php echo $Page->var_nama->CellAttributes(); ?>>
<span data-class="tpx<?php echo $Page->GrpCount ?>_<?php echo $Page->GrpCounter[0] ?>_Kedatangan_Ubi_var_nama"<?php echo $Page->var_nama->ViewAttributes() ?>><?php echo $Page->var_nama->GroupViewValue ?></span></td>
	<?php } ?>
<?php } ?>
<?php if ($Page->koord_nama->Visible) { ?>
		<td data-field="koord_nama"<?php echo $Page->koord_nama->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->GrpCount ?>_<?php echo $Page->GrpCounter[0] ?>_<?php echo $Page->RecCount ?>_Kedatangan_Ubi_koord_nama"<?php echo $Page->koord_nama->ViewAttributes() ?>><?php echo $Page->koord_nama->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->pet_nama->Visible) { ?>
		<td data-field="pet_nama"<?php echo $Page->pet_nama->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->GrpCount ?>_<?php echo $Page->GrpCounter[0] ?>_<?php echo $Page->RecCount ?>_Kedatangan_Ubi_pet_nama"<?php echo $Page->pet_nama->ViewAttributes() ?>><?php echo $Page->pet_nama->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->k_id_kontrak->Visible) { ?>
		<td data-field="k_id_kontrak"<?php echo $Page->k_id_kontrak->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->GrpCount ?>_<?php echo $Page->GrpCounter[0] ?>_<?php echo $Page->RecCount ?>_Kedatangan_Ubi_k_id_kontrak"<?php echo $Page->k_id_kontrak->ViewAttributes() ?>><?php echo $Page->k_id_kontrak->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->k_luas_lahan->Visible) { ?>
		<td data-field="k_luas_lahan"<?php echo $Page->k_luas_lahan->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->GrpCount ?>_<?php echo $Page->GrpCounter[0] ?>_<?php echo $Page->RecCount ?>_Kedatangan_Ubi_k_luas_lahan"<?php echo $Page->k_luas_lahan->ViewAttributes() ?>><?php echo $Page->k_luas_lahan->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->k_es_tgl_panen->Visible) { ?>
		<td data-field="k_es_tgl_panen"<?php echo $Page->k_es_tgl_panen->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->GrpCount ?>_<?php echo $Page->GrpCounter[0] ?>_<?php echo $Page->RecCount ?>_Kedatangan_Ubi_k_es_tgl_panen"<?php echo $Page->k_es_tgl_panen->ViewAttributes() ?>><?php echo $Page->k_es_tgl_panen->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->k_es_qty->Visible) { ?>
		<td data-field="k_es_qty"<?php echo $Page->k_es_qty->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->GrpCount ?>_<?php echo $Page->GrpCounter[0] ?>_<?php echo $Page->RecCount ?>_Kedatangan_Ubi_k_es_qty"<?php echo $Page->k_es_qty->ViewAttributes() ?>><?php echo $Page->k_es_qty->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->k_ak_tgl_datang->Visible) { ?>
		<td data-field="k_ak_tgl_datang"<?php echo $Page->k_ak_tgl_datang->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->GrpCount ?>_<?php echo $Page->GrpCounter[0] ?>_<?php echo $Page->RecCount ?>_Kedatangan_Ubi_k_ak_tgl_datang"<?php echo $Page->k_ak_tgl_datang->ViewAttributes() ?>><?php echo $Page->k_ak_tgl_datang->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->k_ak_qty->Visible) { ?>
		<td data-field="k_ak_qty"<?php echo $Page->k_ak_qty->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->GrpCount ?>_<?php echo $Page->GrpCounter[0] ?>_<?php echo $Page->RecCount ?>_Kedatangan_Ubi_k_ak_qty"<?php echo $Page->k_ak_qty->ViewAttributes() ?>><?php echo $Page->k_ak_qty->ListViewValue() ?></span></td>
<?php } ?>
	</tr>
<?php

		// Accumulate page summary
		$Page->AccumulateSummary();

		// Get next record
		$Page->GetRow(2);

		// Show Footers
?>
<?php
		if ($Page->ChkLvlBreak(2)) {
			$cnt = count(@$Page->GrpIdx[$Page->GrpCount]);
			$Page->GrpIdx[$Page->GrpCount][$cnt] = $Page->RecCount;
		}
		if ($Page->ChkLvlBreak(2) && $Page->var_nama->Visible) {
?>
<?php
			$Page->co_nama->Count = $Page->GetSummaryCount(1, FALSE);
			$Page->var_nama->Count = $Page->GetSummaryCount(2, FALSE);
			$Page->k_luas_lahan->Count = $Page->Cnt[2][4];
			$Page->k_luas_lahan->SumValue = $Page->Smry[2][4]; // Load SUM
			$Page->k_es_qty->Count = $Page->Cnt[2][6];
			$Page->k_es_qty->SumValue = $Page->Smry[2][6]; // Load SUM
			$Page->k_ak_qty->Count = $Page->Cnt[2][8];
			$Page->k_ak_qty->SumValue = $Page->Smry[2][8]; // Load SUM
			$Page->k_es_qty->Count = $Page->Cnt[2][6];
			$Page->k_es_qty->CntValue = $Page->Cnt[2][6]; // Load CNT
			$Page->k_ak_qty->Count = $Page->Cnt[2][8];
			$Page->k_ak_qty->CntValue = $Page->Cnt[2][8]; // Load CNT
			$Page->ResetAttrs();
			$Page->RowType = EWR_ROWTYPE_TOTAL;
			$Page->RowTotalType = EWR_ROWTOTAL_GROUP;
			$Page->RowTotalSubType = EWR_ROWTOTAL_FOOTER;
			$Page->RowGroupLevel = 2;
			$Page->RenderRow();
?>
<?php if ($Page->var_nama->ShowCompactSummaryFooter) { ?>
	<tr<?php echo $Page->RowAttributes(); ?>>
<?php if ($Page->co_nama->Visible) { ?>
		<td data-field="co_nama"<?php echo $Page->co_nama->CellAttributes() ?>>
	<?php if ($Page->co_nama->ShowGroupHeaderAsRow) { ?>
		&nbsp;
	<?php } elseif ($Page->RowGroupLevel <> 1) { ?>
		&nbsp;
	<?php } else { ?>
		<span class="ewSummaryCount"><span class="ewAggregateCaption"><?php echo $ReportLanguage->Phrase("RptCnt") ?></span><?php echo $ReportLanguage->Phrase("AggregateEqual") ?><span class="ewAggregateValue"><?php echo ewr_FormatNumber($Page->co_nama->Count,0,-2,-2,-2) ?></span></span>
	<?php } ?>
		</td>
<?php } ?>
<?php if ($Page->var_nama->Visible) { ?>
		<td data-field="var_nama"<?php echo $Page->var_nama->CellAttributes() ?>>
	<?php if ($Page->var_nama->ShowGroupHeaderAsRow) { ?>
		&nbsp;
	<?php } elseif ($Page->RowGroupLevel <> 2) { ?>
		&nbsp;
	<?php } else { ?>
		<span class="ewSummaryCount"><span class="ewAggregateCaption"><?php echo $ReportLanguage->Phrase("RptCnt") ?></span><?php echo $ReportLanguage->Phrase("AggregateEqual") ?><span class="ewAggregateValue"><?php echo ewr_FormatNumber($Page->var_nama->Count,0,-2,-2,-2) ?></span></span>
	<?php } ?>
		</td>
<?php } ?>
<?php if ($Page->koord_nama->Visible) { ?>
		<td data-field="koord_nama"<?php echo $Page->var_nama->CellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->pet_nama->Visible) { ?>
		<td data-field="pet_nama"<?php echo $Page->var_nama->CellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->k_id_kontrak->Visible) { ?>
		<td data-field="k_id_kontrak"<?php echo $Page->var_nama->CellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->k_luas_lahan->Visible) { ?>
		<td data-field="k_luas_lahan"<?php echo $Page->var_nama->CellAttributes() ?>><span class="ewAggregateCaption"><?php echo $ReportLanguage->Phrase("RptSum") ?></span><?php echo $ReportLanguage->Phrase("AggregateEqual") ?><span class="ewAggregateValue"><span data-class="tpgs<?php echo $Page->GrpCount ?>_<?php echo $Page->GrpCounter[0] ?>_Kedatangan_Ubi_k_luas_lahan"<?php echo $Page->k_luas_lahan->ViewAttributes() ?>><?php echo $Page->k_luas_lahan->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->k_es_tgl_panen->Visible) { ?>
		<td data-field="k_es_tgl_panen"<?php echo $Page->var_nama->CellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->k_es_qty->Visible) { ?>
		<td data-field="k_es_qty"<?php echo $Page->var_nama->CellAttributes() ?>><span class="ewAggregateCaption"><?php echo $ReportLanguage->Phrase("RptSum") ?></span><?php echo $ReportLanguage->Phrase("AggregateEqual") ?><span class="ewAggregateValue"><span data-class="tpgs<?php echo $Page->GrpCount ?>_<?php echo $Page->GrpCounter[0] ?>_Kedatangan_Ubi_k_es_qty"<?php echo $Page->k_es_qty->ViewAttributes() ?>><?php echo $Page->k_es_qty->SumViewValue ?></span></span><br><span class="ewAggregateCaption"><?php echo $ReportLanguage->Phrase("RptCnt") ?></span><?php echo $ReportLanguage->Phrase("AggregateEqual") ?><span class="ewAggregateValue"><span data-class="tpgc<?php echo $Page->GrpCount ?>_<?php echo $Page->GrpCounter[0] ?>_Kedatangan_Ubi_k_es_qty"<?php echo $Page->k_es_qty->ViewAttributes() ?>><?php echo $Page->k_es_qty->CntViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->k_ak_tgl_datang->Visible) { ?>
		<td data-field="k_ak_tgl_datang"<?php echo $Page->var_nama->CellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->k_ak_qty->Visible) { ?>
		<td data-field="k_ak_qty"<?php echo $Page->var_nama->CellAttributes() ?>><span class="ewAggregateCaption"><?php echo $ReportLanguage->Phrase("RptSum") ?></span><?php echo $ReportLanguage->Phrase("AggregateEqual") ?><span class="ewAggregateValue"><span data-class="tpgs<?php echo $Page->GrpCount ?>_<?php echo $Page->GrpCounter[0] ?>_Kedatangan_Ubi_k_ak_qty"<?php echo $Page->k_ak_qty->ViewAttributes() ?>><?php echo $Page->k_ak_qty->SumViewValue ?></span></span><br><span class="ewAggregateCaption"><?php echo $ReportLanguage->Phrase("RptCnt") ?></span><?php echo $ReportLanguage->Phrase("AggregateEqual") ?><span class="ewAggregateValue"><span data-class="tpgc<?php echo $Page->GrpCount ?>_<?php echo $Page->GrpCounter[0] ?>_Kedatangan_Ubi_k_ak_qty"<?php echo $Page->k_ak_qty->ViewAttributes() ?>><?php echo $Page->k_ak_qty->CntViewValue ?></span></span></td>
<?php } ?>
	</tr>
<?php } else { ?>
	<tr<?php echo $Page->RowAttributes(); ?>>
<?php if ($Page->co_nama->Visible) { ?>
		<td data-field="co_nama"<?php echo $Page->co_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->SubGrpColumnCount + $Page->DtlColumnCount > 0) { ?>
		<td colspan="<?php echo ($Page->SubGrpColumnCount + $Page->DtlColumnCount) ?>"<?php echo $Page->k_ak_qty->CellAttributes() ?>><?php echo str_replace(array("%v", "%c"), array($Page->var_nama->GroupViewValue, $Page->var_nama->FldCaption()), $ReportLanguage->Phrase("RptSumHead")) ?> <span class="ewDirLtr">(<?php echo ewr_FormatNumber($Page->Cnt[2][0],0,-2,-2,-2) ?><?php echo $ReportLanguage->Phrase("RptDtlRec") ?>)</span></td>
<?php } ?>
	</tr>
	<tr<?php echo $Page->RowAttributes(); ?>>
<?php if ($Page->co_nama->Visible) { ?>
		<td data-field="co_nama"<?php echo $Page->co_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->GrpColumnCount > 0) { ?>
		<td colspan="<?php echo ($Page->GrpColumnCount - 1) ?>"<?php echo $Page->var_nama->CellAttributes() ?>><?php echo $ReportLanguage->Phrase("RptSum") ?></td>
<?php } ?>
<?php if ($Page->koord_nama->Visible) { ?>
		<td data-field="koord_nama"<?php echo $Page->var_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->pet_nama->Visible) { ?>
		<td data-field="pet_nama"<?php echo $Page->var_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_id_kontrak->Visible) { ?>
		<td data-field="k_id_kontrak"<?php echo $Page->var_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_luas_lahan->Visible) { ?>
		<td data-field="k_luas_lahan"<?php echo $Page->k_ak_qty->CellAttributes() ?>>
<span data-class="tpgs<?php echo $Page->GrpCount ?>_<?php echo $Page->GrpCounter[0] ?>_Kedatangan_Ubi_k_luas_lahan"<?php echo $Page->k_luas_lahan->ViewAttributes() ?>><?php echo $Page->k_luas_lahan->SumViewValue ?></span></td>
<?php } ?>
<?php if ($Page->k_es_tgl_panen->Visible) { ?>
		<td data-field="k_es_tgl_panen"<?php echo $Page->var_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_es_qty->Visible) { ?>
		<td data-field="k_es_qty"<?php echo $Page->k_ak_qty->CellAttributes() ?>>
<span data-class="tpgs<?php echo $Page->GrpCount ?>_<?php echo $Page->GrpCounter[0] ?>_Kedatangan_Ubi_k_es_qty"<?php echo $Page->k_es_qty->ViewAttributes() ?>><?php echo $Page->k_es_qty->SumViewValue ?></span></td>
<?php } ?>
<?php if ($Page->k_ak_tgl_datang->Visible) { ?>
		<td data-field="k_ak_tgl_datang"<?php echo $Page->var_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_ak_qty->Visible) { ?>
		<td data-field="k_ak_qty"<?php echo $Page->k_ak_qty->CellAttributes() ?>>
<span data-class="tpgs<?php echo $Page->GrpCount ?>_<?php echo $Page->GrpCounter[0] ?>_Kedatangan_Ubi_k_ak_qty"<?php echo $Page->k_ak_qty->ViewAttributes() ?>><?php echo $Page->k_ak_qty->SumViewValue ?></span></td>
<?php } ?>
	</tr>
	<tr<?php echo $Page->RowAttributes(); ?>>
<?php if ($Page->co_nama->Visible) { ?>
		<td data-field="co_nama"<?php echo $Page->co_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->GrpColumnCount > 0) { ?>
		<td colspan="<?php echo ($Page->GrpColumnCount - 1) ?>"<?php echo $Page->var_nama->CellAttributes() ?>><?php echo $ReportLanguage->Phrase("RptCnt") ?></td>
<?php } ?>
<?php if ($Page->koord_nama->Visible) { ?>
		<td data-field="koord_nama"<?php echo $Page->var_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->pet_nama->Visible) { ?>
		<td data-field="pet_nama"<?php echo $Page->var_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_id_kontrak->Visible) { ?>
		<td data-field="k_id_kontrak"<?php echo $Page->var_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_luas_lahan->Visible) { ?>
		<td data-field="k_luas_lahan"<?php echo $Page->var_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_es_tgl_panen->Visible) { ?>
		<td data-field="k_es_tgl_panen"<?php echo $Page->var_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_es_qty->Visible) { ?>
		<td data-field="k_es_qty"<?php echo $Page->k_ak_qty->CellAttributes() ?>>
<span data-class="tpgc<?php echo $Page->GrpCount ?>_<?php echo $Page->GrpCounter[0] ?>_Kedatangan_Ubi_k_es_qty"<?php echo $Page->k_es_qty->ViewAttributes() ?>><?php echo $Page->k_es_qty->CntViewValue ?></span></td>
<?php } ?>
<?php if ($Page->k_ak_tgl_datang->Visible) { ?>
		<td data-field="k_ak_tgl_datang"<?php echo $Page->var_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_ak_qty->Visible) { ?>
		<td data-field="k_ak_qty"<?php echo $Page->k_ak_qty->CellAttributes() ?>>
<span data-class="tpgc<?php echo $Page->GrpCount ?>_<?php echo $Page->GrpCounter[0] ?>_Kedatangan_Ubi_k_ak_qty"<?php echo $Page->k_ak_qty->ViewAttributes() ?>><?php echo $Page->k_ak_qty->CntViewValue ?></span></td>
<?php } ?>
	</tr>
<?php } ?>
<?php

			// Reset level 2 summary
			$Page->ResetLevelSummary(2);
		} // End show footer check
		if ($Page->ChkLvlBreak(2)) {
			$Page->GrpCounter[0]++;
		}
?>
<?php
	} // End detail records loop
?>
<?php
		if ($Page->co_nama->Visible) {
?>
<?php
			$Page->co_nama->Count = $Page->GetSummaryCount(1, FALSE);
			$Page->var_nama->Count = $Page->GetSummaryCount(2, FALSE);
			$Page->k_luas_lahan->Count = $Page->Cnt[1][4];
			$Page->k_luas_lahan->SumValue = $Page->Smry[1][4]; // Load SUM
			$Page->k_es_qty->Count = $Page->Cnt[1][6];
			$Page->k_es_qty->SumValue = $Page->Smry[1][6]; // Load SUM
			$Page->k_ak_qty->Count = $Page->Cnt[1][8];
			$Page->k_ak_qty->SumValue = $Page->Smry[1][8]; // Load SUM
			$Page->k_es_qty->Count = $Page->Cnt[1][6];
			$Page->k_es_qty->CntValue = $Page->Cnt[1][6]; // Load CNT
			$Page->k_ak_qty->Count = $Page->Cnt[1][8];
			$Page->k_ak_qty->CntValue = $Page->Cnt[1][8]; // Load CNT
			$Page->ResetAttrs();
			$Page->RowType = EWR_ROWTYPE_TOTAL;
			$Page->RowTotalType = EWR_ROWTOTAL_GROUP;
			$Page->RowTotalSubType = EWR_ROWTOTAL_FOOTER;
			$Page->RowGroupLevel = 1;
			$Page->RenderRow();
?>
<?php if ($Page->co_nama->ShowCompactSummaryFooter) { ?>
	<tr<?php echo $Page->RowAttributes(); ?>>
<?php if ($Page->co_nama->Visible) { ?>
		<td data-field="co_nama"<?php echo $Page->co_nama->CellAttributes() ?>>
	<?php if ($Page->co_nama->ShowGroupHeaderAsRow) { ?>
		&nbsp;
	<?php } elseif ($Page->RowGroupLevel <> 1) { ?>
		&nbsp;
	<?php } else { ?>
		<span class="ewSummaryCount"><span class="ewAggregateCaption"><?php echo $ReportLanguage->Phrase("RptCnt") ?></span><?php echo $ReportLanguage->Phrase("AggregateEqual") ?><span class="ewAggregateValue"><?php echo ewr_FormatNumber($Page->co_nama->Count,0,-2,-2,-2) ?></span></span>
	<?php } ?>
		</td>
<?php } ?>
<?php if ($Page->var_nama->Visible) { ?>
		<td data-field="var_nama"<?php echo $Page->co_nama->CellAttributes() ?>>
	<?php if ($Page->var_nama->ShowGroupHeaderAsRow) { ?>
		&nbsp;
	<?php } elseif ($Page->RowGroupLevel <> 2) { ?>
		&nbsp;
	<?php } else { ?>
		<span class="ewSummaryCount"><span class="ewAggregateCaption"><?php echo $ReportLanguage->Phrase("RptCnt") ?></span><?php echo $ReportLanguage->Phrase("AggregateEqual") ?><span class="ewAggregateValue"><?php echo ewr_FormatNumber($Page->var_nama->Count,0,-2,-2,-2) ?></span></span>
	<?php } ?>
		</td>
<?php } ?>
<?php if ($Page->koord_nama->Visible) { ?>
		<td data-field="koord_nama"<?php echo $Page->co_nama->CellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->pet_nama->Visible) { ?>
		<td data-field="pet_nama"<?php echo $Page->co_nama->CellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->k_id_kontrak->Visible) { ?>
		<td data-field="k_id_kontrak"<?php echo $Page->co_nama->CellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->k_luas_lahan->Visible) { ?>
		<td data-field="k_luas_lahan"<?php echo $Page->co_nama->CellAttributes() ?>><span class="ewAggregateCaption"><?php echo $ReportLanguage->Phrase("RptSum") ?></span><?php echo $ReportLanguage->Phrase("AggregateEqual") ?><span class="ewAggregateValue"><span data-class="tpgs<?php echo $Page->GrpCount ?>_Kedatangan_Ubi_k_luas_lahan"<?php echo $Page->k_luas_lahan->ViewAttributes() ?>><?php echo $Page->k_luas_lahan->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->k_es_tgl_panen->Visible) { ?>
		<td data-field="k_es_tgl_panen"<?php echo $Page->co_nama->CellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->k_es_qty->Visible) { ?>
		<td data-field="k_es_qty"<?php echo $Page->co_nama->CellAttributes() ?>><span class="ewAggregateCaption"><?php echo $ReportLanguage->Phrase("RptSum") ?></span><?php echo $ReportLanguage->Phrase("AggregateEqual") ?><span class="ewAggregateValue"><span data-class="tpgs<?php echo $Page->GrpCount ?>_Kedatangan_Ubi_k_es_qty"<?php echo $Page->k_es_qty->ViewAttributes() ?>><?php echo $Page->k_es_qty->SumViewValue ?></span></span><br><span class="ewAggregateCaption"><?php echo $ReportLanguage->Phrase("RptCnt") ?></span><?php echo $ReportLanguage->Phrase("AggregateEqual") ?><span class="ewAggregateValue"><span data-class="tpgc<?php echo $Page->GrpCount ?>_Kedatangan_Ubi_k_es_qty"<?php echo $Page->k_es_qty->ViewAttributes() ?>><?php echo $Page->k_es_qty->CntViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->k_ak_tgl_datang->Visible) { ?>
		<td data-field="k_ak_tgl_datang"<?php echo $Page->co_nama->CellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->k_ak_qty->Visible) { ?>
		<td data-field="k_ak_qty"<?php echo $Page->co_nama->CellAttributes() ?>><span class="ewAggregateCaption"><?php echo $ReportLanguage->Phrase("RptSum") ?></span><?php echo $ReportLanguage->Phrase("AggregateEqual") ?><span class="ewAggregateValue"><span data-class="tpgs<?php echo $Page->GrpCount ?>_Kedatangan_Ubi_k_ak_qty"<?php echo $Page->k_ak_qty->ViewAttributes() ?>><?php echo $Page->k_ak_qty->SumViewValue ?></span></span><br><span class="ewAggregateCaption"><?php echo $ReportLanguage->Phrase("RptCnt") ?></span><?php echo $ReportLanguage->Phrase("AggregateEqual") ?><span class="ewAggregateValue"><span data-class="tpgc<?php echo $Page->GrpCount ?>_Kedatangan_Ubi_k_ak_qty"<?php echo $Page->k_ak_qty->ViewAttributes() ?>><?php echo $Page->k_ak_qty->CntViewValue ?></span></span></td>
<?php } ?>
	</tr>
<?php } else { ?>
	<tr<?php echo $Page->RowAttributes(); ?>>
<?php if ($Page->GrpColumnCount + $Page->DtlColumnCount > 0) { ?>
		<td colspan="<?php echo ($Page->GrpColumnCount + $Page->DtlColumnCount) ?>"<?php echo $Page->k_ak_qty->CellAttributes() ?>><?php echo str_replace(array("%v", "%c"), array($Page->co_nama->GroupViewValue, $Page->co_nama->FldCaption()), $ReportLanguage->Phrase("RptSumHead")) ?> <span class="ewDirLtr">(<?php echo ewr_FormatNumber($Page->Cnt[1][0],0,-2,-2,-2) ?><?php echo $ReportLanguage->Phrase("RptDtlRec") ?>)</span></td>
<?php } ?>
	</tr>
	<tr<?php echo $Page->RowAttributes(); ?>>
<?php if ($Page->GrpColumnCount > 0) { ?>
		<td colspan="<?php echo ($Page->GrpColumnCount - 0) ?>"<?php echo $Page->co_nama->CellAttributes() ?>><?php echo $ReportLanguage->Phrase("RptSum") ?></td>
<?php } ?>
<?php if ($Page->koord_nama->Visible) { ?>
		<td data-field="koord_nama"<?php echo $Page->co_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->pet_nama->Visible) { ?>
		<td data-field="pet_nama"<?php echo $Page->co_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_id_kontrak->Visible) { ?>
		<td data-field="k_id_kontrak"<?php echo $Page->co_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_luas_lahan->Visible) { ?>
		<td data-field="k_luas_lahan"<?php echo $Page->k_ak_qty->CellAttributes() ?>>
<span data-class="tpgs<?php echo $Page->GrpCount ?>_Kedatangan_Ubi_k_luas_lahan"<?php echo $Page->k_luas_lahan->ViewAttributes() ?>><?php echo $Page->k_luas_lahan->SumViewValue ?></span></td>
<?php } ?>
<?php if ($Page->k_es_tgl_panen->Visible) { ?>
		<td data-field="k_es_tgl_panen"<?php echo $Page->co_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_es_qty->Visible) { ?>
		<td data-field="k_es_qty"<?php echo $Page->k_ak_qty->CellAttributes() ?>>
<span data-class="tpgs<?php echo $Page->GrpCount ?>_Kedatangan_Ubi_k_es_qty"<?php echo $Page->k_es_qty->ViewAttributes() ?>><?php echo $Page->k_es_qty->SumViewValue ?></span></td>
<?php } ?>
<?php if ($Page->k_ak_tgl_datang->Visible) { ?>
		<td data-field="k_ak_tgl_datang"<?php echo $Page->co_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_ak_qty->Visible) { ?>
		<td data-field="k_ak_qty"<?php echo $Page->k_ak_qty->CellAttributes() ?>>
<span data-class="tpgs<?php echo $Page->GrpCount ?>_Kedatangan_Ubi_k_ak_qty"<?php echo $Page->k_ak_qty->ViewAttributes() ?>><?php echo $Page->k_ak_qty->SumViewValue ?></span></td>
<?php } ?>
	</tr>
	<tr<?php echo $Page->RowAttributes(); ?>>
<?php if ($Page->GrpColumnCount > 0) { ?>
		<td colspan="<?php echo ($Page->GrpColumnCount - 0) ?>"<?php echo $Page->co_nama->CellAttributes() ?>><?php echo $ReportLanguage->Phrase("RptCnt") ?></td>
<?php } ?>
<?php if ($Page->koord_nama->Visible) { ?>
		<td data-field="koord_nama"<?php echo $Page->co_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->pet_nama->Visible) { ?>
		<td data-field="pet_nama"<?php echo $Page->co_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_id_kontrak->Visible) { ?>
		<td data-field="k_id_kontrak"<?php echo $Page->co_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_luas_lahan->Visible) { ?>
		<td data-field="k_luas_lahan"<?php echo $Page->co_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_es_tgl_panen->Visible) { ?>
		<td data-field="k_es_tgl_panen"<?php echo $Page->co_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_es_qty->Visible) { ?>
		<td data-field="k_es_qty"<?php echo $Page->k_ak_qty->CellAttributes() ?>>
<span data-class="tpgc<?php echo $Page->GrpCount ?>_Kedatangan_Ubi_k_es_qty"<?php echo $Page->k_es_qty->ViewAttributes() ?>><?php echo $Page->k_es_qty->CntViewValue ?></span></td>
<?php } ?>
<?php if ($Page->k_ak_tgl_datang->Visible) { ?>
		<td data-field="k_ak_tgl_datang"<?php echo $Page->co_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_ak_qty->Visible) { ?>
		<td data-field="k_ak_qty"<?php echo $Page->k_ak_qty->CellAttributes() ?>>
<span data-class="tpgc<?php echo $Page->GrpCount ?>_Kedatangan_Ubi_k_ak_qty"<?php echo $Page->k_ak_qty->ViewAttributes() ?>><?php echo $Page->k_ak_qty->CntViewValue ?></span></td>
<?php } ?>
	</tr>
<?php } ?>
<?php

			// Reset level 1 summary
			$Page->ResetLevelSummary(1);
		} // End show footer check
?>
<?php

	// Next group
	$Page->GetGrpRow(2);

	// Show header if page break
	if ($Page->Export <> "")
		$Page->ShowHeader = ($Page->ExportPageBreakCount == 0) ? FALSE : ($Page->GrpCount % $Page->ExportPageBreakCount == 0);

	// Page_Breaking server event
	if ($Page->ShowHeader)
		$Page->Page_Breaking($Page->ShowHeader, $Page->PageBreakContent);
	$Page->GrpCount++;
	$Page->GrpCounter[0] = 1;

	// Handle EOF
	if (!$rsgrp || $rsgrp->EOF)
		$Page->ShowHeader = FALSE;
} // End while
?>
<?php if ($Page->TotalGrps > 0) { ?>
</tbody>
<tfoot>
<?php
	$Page->k_luas_lahan->Count = $Page->GrandCnt[4];
	$Page->k_luas_lahan->SumValue = $Page->GrandSmry[4]; // Load SUM
	$Page->k_es_qty->Count = $Page->GrandCnt[6];
	$Page->k_es_qty->SumValue = $Page->GrandSmry[6]; // Load SUM
	$Page->k_ak_qty->Count = $Page->GrandCnt[8];
	$Page->k_ak_qty->SumValue = $Page->GrandSmry[8]; // Load SUM
	$Page->k_es_qty->Count = $Page->GrandCnt[6];
	$Page->k_es_qty->CntValue = $Page->GrandCnt[6]; // Load CNT
	$Page->k_ak_qty->Count = $Page->GrandCnt[8];
	$Page->k_ak_qty->CntValue = $Page->GrandCnt[8]; // Load CNT
	$Page->ResetAttrs();
	$Page->RowType = EWR_ROWTYPE_TOTAL;
	$Page->RowTotalType = EWR_ROWTOTAL_GRAND;
	$Page->RowTotalSubType = EWR_ROWTOTAL_FOOTER;
	$Page->RowAttrs["class"] = "ewRptGrandSummary";
	$Page->RenderRow();
?>
<?php if ($Page->co_nama->ShowCompactSummaryFooter) { ?>
	<tr<?php echo $Page->RowAttributes() ?>><td colspan="<?php echo ($Page->GrpColumnCount + $Page->DtlColumnCount) ?>"><?php echo $ReportLanguage->Phrase("RptGrandSummary") ?> (<span class="ewAggregateCaption"><?php echo $ReportLanguage->Phrase("RptCnt") ?></span><?php echo $ReportLanguage->Phrase("AggregateEqual") ?><span class="ewAggregateValue"><?php echo ewr_FormatNumber($Page->TotCount,0,-2,-2,-2) ?></span>)</td></tr>
	<tr<?php echo $Page->RowAttributes() ?>>
<?php if ($Page->GrpColumnCount > 0) { ?>
		<td colspan="<?php echo $Page->GrpColumnCount ?>" class="ewRptGrpAggregate">&nbsp;</td>
<?php } ?>
<?php if ($Page->koord_nama->Visible) { ?>
		<td data-field="koord_nama"<?php echo $Page->koord_nama->CellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->pet_nama->Visible) { ?>
		<td data-field="pet_nama"<?php echo $Page->pet_nama->CellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->k_id_kontrak->Visible) { ?>
		<td data-field="k_id_kontrak"<?php echo $Page->k_id_kontrak->CellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->k_luas_lahan->Visible) { ?>
		<td data-field="k_luas_lahan"<?php echo $Page->k_luas_lahan->CellAttributes() ?>><?php echo $ReportLanguage->Phrase("RptSum") ?>=<span data-class="tpts_Kedatangan_Ubi_k_luas_lahan"<?php echo $Page->k_luas_lahan->ViewAttributes() ?>><?php echo $Page->k_luas_lahan->SumViewValue ?></span></td>
<?php } ?>
<?php if ($Page->k_es_tgl_panen->Visible) { ?>
		<td data-field="k_es_tgl_panen"<?php echo $Page->k_es_tgl_panen->CellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->k_es_qty->Visible) { ?>
		<td data-field="k_es_qty"<?php echo $Page->k_es_qty->CellAttributes() ?>><?php echo $ReportLanguage->Phrase("RptSum") ?>=<span data-class="tpts_Kedatangan_Ubi_k_es_qty"<?php echo $Page->k_es_qty->ViewAttributes() ?>><?php echo $Page->k_es_qty->SumViewValue ?></span><br><?php echo $ReportLanguage->Phrase("RptCnt") ?>=<span data-class="tptc_Kedatangan_Ubi_k_es_qty"<?php echo $Page->k_es_qty->ViewAttributes() ?>><?php echo $Page->k_es_qty->CntViewValue ?></span></td>
<?php } ?>
<?php if ($Page->k_ak_tgl_datang->Visible) { ?>
		<td data-field="k_ak_tgl_datang"<?php echo $Page->k_ak_tgl_datang->CellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->k_ak_qty->Visible) { ?>
		<td data-field="k_ak_qty"<?php echo $Page->k_ak_qty->CellAttributes() ?>><?php echo $ReportLanguage->Phrase("RptSum") ?>=<span data-class="tpts_Kedatangan_Ubi_k_ak_qty"<?php echo $Page->k_ak_qty->ViewAttributes() ?>><?php echo $Page->k_ak_qty->SumViewValue ?></span><br><?php echo $ReportLanguage->Phrase("RptCnt") ?>=<span data-class="tptc_Kedatangan_Ubi_k_ak_qty"<?php echo $Page->k_ak_qty->ViewAttributes() ?>><?php echo $Page->k_ak_qty->CntViewValue ?></span></td>
<?php } ?>
	</tr>
<?php } else { ?>
	<tr<?php echo $Page->RowAttributes() ?>><td colspan="<?php echo ($Page->GrpColumnCount + $Page->DtlColumnCount) ?>"><?php echo $ReportLanguage->Phrase("RptGrandSummary") ?> <span class="ewDirLtr">(<?php echo ewr_FormatNumber($Page->TotCount,0,-2,-2,-2); ?><?php echo $ReportLanguage->Phrase("RptDtlRec") ?>)</span></td></tr>
	<tr<?php echo $Page->RowAttributes() ?>>
<?php if ($Page->GrpColumnCount > 0) { ?>
		<td colspan="<?php echo $Page->GrpColumnCount ?>" class="ewRptGrpAggregate"><?php echo $ReportLanguage->Phrase("RptSum") ?></td>
<?php } ?>
<?php if ($Page->koord_nama->Visible) { ?>
		<td data-field="koord_nama"<?php echo $Page->koord_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->pet_nama->Visible) { ?>
		<td data-field="pet_nama"<?php echo $Page->pet_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_id_kontrak->Visible) { ?>
		<td data-field="k_id_kontrak"<?php echo $Page->k_id_kontrak->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_luas_lahan->Visible) { ?>
		<td data-field="k_luas_lahan"<?php echo $Page->k_luas_lahan->CellAttributes() ?>>
<span data-class="tpts_Kedatangan_Ubi_k_luas_lahan"<?php echo $Page->k_luas_lahan->ViewAttributes() ?>><?php echo $Page->k_luas_lahan->SumViewValue ?></span></td>
<?php } ?>
<?php if ($Page->k_es_tgl_panen->Visible) { ?>
		<td data-field="k_es_tgl_panen"<?php echo $Page->k_es_tgl_panen->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_es_qty->Visible) { ?>
		<td data-field="k_es_qty"<?php echo $Page->k_es_qty->CellAttributes() ?>>
<span data-class="tpts_Kedatangan_Ubi_k_es_qty"<?php echo $Page->k_es_qty->ViewAttributes() ?>><?php echo $Page->k_es_qty->SumViewValue ?></span></td>
<?php } ?>
<?php if ($Page->k_ak_tgl_datang->Visible) { ?>
		<td data-field="k_ak_tgl_datang"<?php echo $Page->k_ak_tgl_datang->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_ak_qty->Visible) { ?>
		<td data-field="k_ak_qty"<?php echo $Page->k_ak_qty->CellAttributes() ?>>
<span data-class="tpts_Kedatangan_Ubi_k_ak_qty"<?php echo $Page->k_ak_qty->ViewAttributes() ?>><?php echo $Page->k_ak_qty->SumViewValue ?></span></td>
<?php } ?>
	</tr>
	<tr<?php echo $Page->RowAttributes() ?>>
<?php if ($Page->GrpColumnCount > 0) { ?>
		<td colspan="<?php echo $Page->GrpColumnCount ?>" class="ewRptGrpAggregate"><?php echo $ReportLanguage->Phrase("RptCnt") ?></td>
<?php } ?>
<?php if ($Page->koord_nama->Visible) { ?>
		<td data-field="koord_nama"<?php echo $Page->koord_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->pet_nama->Visible) { ?>
		<td data-field="pet_nama"<?php echo $Page->pet_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_id_kontrak->Visible) { ?>
		<td data-field="k_id_kontrak"<?php echo $Page->k_id_kontrak->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_luas_lahan->Visible) { ?>
		<td data-field="k_luas_lahan"<?php echo $Page->k_luas_lahan->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_es_tgl_panen->Visible) { ?>
		<td data-field="k_es_tgl_panen"<?php echo $Page->k_es_tgl_panen->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_es_qty->Visible) { ?>
		<td data-field="k_es_qty"<?php echo $Page->k_es_qty->CellAttributes() ?>>
<span data-class="tptc_Kedatangan_Ubi_k_es_qty"<?php echo $Page->k_es_qty->ViewAttributes() ?>><?php echo $Page->k_es_qty->CntViewValue ?></span></td>
<?php } ?>
<?php if ($Page->k_ak_tgl_datang->Visible) { ?>
		<td data-field="k_ak_tgl_datang"<?php echo $Page->k_ak_tgl_datang->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_ak_qty->Visible) { ?>
		<td data-field="k_ak_qty"<?php echo $Page->k_ak_qty->CellAttributes() ?>>
<span data-class="tptc_Kedatangan_Ubi_k_ak_qty"<?php echo $Page->k_ak_qty->ViewAttributes() ?>><?php echo $Page->k_ak_qty->CntViewValue ?></span></td>
<?php } ?>
	</tr>
<?php } ?>
	</tfoot>
<?php } elseif (!$Page->ShowHeader && FALSE) { // No header displayed ?>
<?php if ($Page->Export <> "pdf") { ?>
<?php if ($Page->Export == "word" || $Page->Export == "excel") { ?>
<div class="ewGrid"<?php echo $Page->ReportTableStyle ?>>
<?php } else { ?>
<div class="panel panel-default ewGrid"<?php echo $Page->ReportTableStyle ?>>
<?php } ?>
<?php } ?>
<!-- Report grid (begin) -->
<?php if ($Page->Export <> "pdf") { ?>
<div class="<?php if (ewr_IsResponsiveLayout()) { echo "table-responsive "; } ?>ewGridMiddlePanel">
<?php } ?>
<table class="<?php echo $Page->ReportTableClass ?>">
<?php } ?>
<?php if ($Page->TotalGrps > 0 || FALSE) { // Show footer ?>
</table>
<?php if ($Page->Export <> "pdf") { ?>
</div>
<?php } ?>
<?php if ($Page->Export == "" && !($Page->DrillDown && $Page->TotalGrps > 0)) { ?>
<div class="panel-footer ewGridLowerPanel">
<?php include "Kedatangan_Ubismrypager.php" ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($Page->Export <> "pdf") { ?>
</div>
<?php } ?>
<?php } ?>
<?php if ($Page->Export <> "pdf") { ?>
</div>
<?php } ?>
<!-- Summary Report Ends -->
<?php if ($Page->Export == "") { ?>
	</div>
	<!-- center container - report (end) -->
	<!-- right container (begin) -->
	<div id="ewRight" class="ewRight">
<?php } ?>
	<!-- Right slot -->
<?php if ($Page->Export == "") { ?>
	</div>
	<!-- right container (end) -->
<div class="clearfix"></div>
<!-- bottom container (begin) -->
<div id="ewBottom" class="ewBottom">
<?php } ?>
	<!-- Bottom slot -->
<?php if ($Page->Export == "") { ?>
	</div>
<!-- Bottom Container (End) -->
</div>
<!-- Table Container (End) -->
<?php } ?>
<?php $Page->ShowPageFooter(); ?>
<?php if (EWR_DEBUG_ENABLED) echo ewr_DebugMsg(); ?>
<?php

// Close recordsets
if ($rsgrp) $rsgrp->Close();
if ($rs) $rs->Close();
?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "phprptinc/footer.php" ?>
<?php include_once "footer.php" ?>
<?php
$Page->Page_Terminate();
if (isset($OldPage)) $Page = $OldPage;
?>
