<?php
if (session_id() == "") session_start(); // Init session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg14.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql14.php") ?>
<?php include_once "phpfn14.php" ?>
<?php include_once "tanam_bibitinfo.php" ?>
<?php include_once "employeesinfo.php" ?>
<?php include_once "userfn14.php" ?>
<?php

//
// Page class
//

$tanam_bibit_edit = NULL; // Initialize page object first

class ctanam_bibit_edit extends ctanam_bibit {

	// Page ID
	var $PageID = 'edit';

	// Project ID
	var $ProjectID = '{CC60B42B-604B-412A-B014-2315920AF6AA}';

	// Table name
	var $TableName = 'tanam_bibit';

	// Page object name
	var $PageObjName = 'tanam_bibit_edit';

	// Page headings
	var $Heading = '';
	var $Subheading = '';

	// Page heading
	function PageHeading() {
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->TableCaption();
		return "";
	}

	// Page subheading
	function PageSubheading() {
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->Phrase($this->PageID);
		return "";
	}

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (tanam_bibit)
		if (!isset($GLOBALS["tanam_bibit"]) || get_class($GLOBALS["tanam_bibit"]) == "ctanam_bibit") {
			$GLOBALS["tanam_bibit"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["tanam_bibit"];
		}

		// Table object (employees)
		if (!isset($GLOBALS['employees'])) $GLOBALS['employees'] = new cemployees();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'edit', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'tanam_bibit', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"]))
			$GLOBALS["gTimer"] = new cTimer();

		// Debug message
		ew_LoadDebugMsg();

		// Open connection
		if (!isset($conn))
			$conn = ew_Connect($this->DBID);

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new cemployees();
			$UserTableConn = Conn($UserTable->DBID);
		}
	}

	//
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Is modal
		$this->IsModal = (@$_GET["modal"] == "1" || @$_POST["modal"] == "1");

		// User profile
		$UserProfile = new cUserProfile();

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanEdit()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			if ($Security->CanList())
				$this->Page_Terminate(ew_GetUrl("tanam_bibitlist.php"));
			else
				$this->Page_Terminate(ew_GetUrl("login.php"));
		}

		// NOTE: Security object may be needed in other part of the script, skip set to Nothing
		// 
		// Security = null;
		// 
		// Create form object

		$objForm = new cFormObj();
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action
		$this->id->SetVisibility();
		if ($this->IsAdd() || $this->IsCopy() || $this->IsGridAdd())
			$this->id->Visible = FALSE;
		$this->tgl_tanam->SetVisibility();
		$this->jenis_lahan->SetVisibility();
		$this->varietas->SetVisibility();
		$this->jumlah_tanam->SetVisibility();
		$this->ket->SetVisibility();
		$this->id_kontrak_tanam->SetVisibility();
		$this->gen_bibit->SetVisibility();
		$this->id_asal_bibit->SetVisibility();
		$this->jumlah_panen_stek->SetVisibility();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $tanam_bibit;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($tanam_bibit);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		// Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = ew_GetPageName($url);
				if ($pageName != $this->GetListUrl()) { // Not List page
					$row["caption"] = $this->GetModalCaption($pageName);
					if ($pageName == "tanam_bibitview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				header("Content-Type: application/json; charset=utf-8");
				echo ew_ConvertToUtf8(ew_ArrayToJson(array($row)));
			} else {
				ew_SaveDebugMsg();
				header("Location: " . $url);
			}
		}
		exit();
	}
	var $FormClassName = "form-horizontal ewForm ewEditForm";
	var $IsModal = FALSE;
	var $IsMobileOrModal = FALSE;
	var $DbMasterFilter;
	var $DbDetailFilter;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError, $gbSkipHeaderFooter;

		// Check modal
		if ($this->IsModal)
			$gbSkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = ew_IsMobile() || $this->IsModal;
		$this->FormClassName = "ewForm ewEditForm form-horizontal";
		$sReturnUrl = "";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (@$_POST["a_edit"] <> "") {
			$this->CurrentAction = $_POST["a_edit"]; // Get action code
			if ($this->CurrentAction <> "I") // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($objForm->HasValue("x_id")) {
				$this->id->setFormValue($objForm->GetValue("x_id"));
			}
		} else {
			$this->CurrentAction = "I"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (isset($_GET["id"])) {
				$this->id->setQueryStringValue($_GET["id"]);
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->LoadRow();

		// Process form if post back
		if ($postBack) {
			$this->LoadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->ValidateForm()) {
				$this->CurrentAction = ""; // Form error, reset action
				$this->setFailureMessage($gsFormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->RestoreFormValues();
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "I": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "") $this->setFailureMessage($Language->Phrase("NoRecord")); // No record found
					$this->Page_Terminate("tanam_bibitlist.php"); // No matching record, return to list
				}
				break;
			Case "U": // Update
				$sReturnUrl = $this->getReturnUrl();
				if (ew_GetPageName($sReturnUrl) == "tanam_bibitlist.php")
					$sReturnUrl = $this->AddMasterUrl($sReturnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->EditRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->Phrase("UpdateSuccess")); // Update success
					$this->Page_Terminate($sReturnUrl); // Return to caller
				} elseif ($this->getFailureMessage() == $Language->Phrase("NoRecord")) {
					$this->Page_Terminate($sReturnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->RestoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->SetupBreadcrumb();

		// Render the record
		$this->RowType = EW_ROWTYPE_EDIT; // Render as Edit
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Set up starting record parameters
	function SetupStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	function GetUploadFiles() {
		global $objForm, $Language;

		// Get upload data
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm;
		if (!$this->id->FldIsDetailKey)
			$this->id->setFormValue($objForm->GetValue("x_id"));
		if (!$this->tgl_tanam->FldIsDetailKey) {
			$this->tgl_tanam->setFormValue($objForm->GetValue("x_tgl_tanam"));
			$this->tgl_tanam->CurrentValue = ew_UnFormatDateTime($this->tgl_tanam->CurrentValue, 0);
		}
		if (!$this->jenis_lahan->FldIsDetailKey) {
			$this->jenis_lahan->setFormValue($objForm->GetValue("x_jenis_lahan"));
		}
		if (!$this->varietas->FldIsDetailKey) {
			$this->varietas->setFormValue($objForm->GetValue("x_varietas"));
		}
		if (!$this->jumlah_tanam->FldIsDetailKey) {
			$this->jumlah_tanam->setFormValue($objForm->GetValue("x_jumlah_tanam"));
		}
		if (!$this->ket->FldIsDetailKey) {
			$this->ket->setFormValue($objForm->GetValue("x_ket"));
		}
		if (!$this->id_kontrak_tanam->FldIsDetailKey) {
			$this->id_kontrak_tanam->setFormValue($objForm->GetValue("x_id_kontrak_tanam"));
		}
		if (!$this->gen_bibit->FldIsDetailKey) {
			$this->gen_bibit->setFormValue($objForm->GetValue("x_gen_bibit"));
		}
		if (!$this->id_asal_bibit->FldIsDetailKey) {
			$this->id_asal_bibit->setFormValue($objForm->GetValue("x_id_asal_bibit"));
		}
		if (!$this->jumlah_panen_stek->FldIsDetailKey) {
			$this->jumlah_panen_stek->setFormValue($objForm->GetValue("x_jumlah_panen_stek"));
		}
	}

	// Restore form values
	function RestoreFormValues() {
		global $objForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->tgl_tanam->CurrentValue = $this->tgl_tanam->FormValue;
		$this->tgl_tanam->CurrentValue = ew_UnFormatDateTime($this->tgl_tanam->CurrentValue, 0);
		$this->jenis_lahan->CurrentValue = $this->jenis_lahan->FormValue;
		$this->varietas->CurrentValue = $this->varietas->FormValue;
		$this->jumlah_tanam->CurrentValue = $this->jumlah_tanam->FormValue;
		$this->ket->CurrentValue = $this->ket->FormValue;
		$this->id_kontrak_tanam->CurrentValue = $this->id_kontrak_tanam->FormValue;
		$this->gen_bibit->CurrentValue = $this->gen_bibit->FormValue;
		$this->id_asal_bibit->CurrentValue = $this->id_asal_bibit->FormValue;
		$this->jumlah_panen_stek->CurrentValue = $this->jumlah_panen_stek->FormValue;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues($rs = NULL) {
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->NewRow(); 

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->tgl_tanam->setDbValue($row['tgl_tanam']);
		$this->jenis_lahan->setDbValue($row['jenis_lahan']);
		$this->varietas->setDbValue($row['varietas']);
		$this->jumlah_tanam->setDbValue($row['jumlah_tanam']);
		$this->ket->setDbValue($row['ket']);
		$this->id_kontrak_tanam->setDbValue($row['id_kontrak_tanam']);
		$this->gen_bibit->setDbValue($row['gen_bibit']);
		$this->id_asal_bibit->setDbValue($row['id_asal_bibit']);
		$this->jumlah_panen_stek->setDbValue($row['jumlah_panen_stek']);
	}

	// Return a row with default values
	function NewRow() {
		$row = array();
		$row['id'] = NULL;
		$row['tgl_tanam'] = NULL;
		$row['jenis_lahan'] = NULL;
		$row['varietas'] = NULL;
		$row['jumlah_tanam'] = NULL;
		$row['ket'] = NULL;
		$row['id_kontrak_tanam'] = NULL;
		$row['gen_bibit'] = NULL;
		$row['id_asal_bibit'] = NULL;
		$row['jumlah_panen_stek'] = NULL;
		return $row;
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->tgl_tanam->DbValue = $row['tgl_tanam'];
		$this->jenis_lahan->DbValue = $row['jenis_lahan'];
		$this->varietas->DbValue = $row['varietas'];
		$this->jumlah_tanam->DbValue = $row['jumlah_tanam'];
		$this->ket->DbValue = $row['ket'];
		$this->id_kontrak_tanam->DbValue = $row['id_kontrak_tanam'];
		$this->gen_bibit->DbValue = $row['gen_bibit'];
		$this->id_asal_bibit->DbValue = $row['id_asal_bibit'];
		$this->jumlah_panen_stek->DbValue = $row['jumlah_panen_stek'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$bValidKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
		}
		$this->LoadRowValues($this->OldRecordset); // Load row values
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// tgl_tanam
		// jenis_lahan
		// varietas
		// jumlah_tanam
		// ket
		// id_kontrak_tanam
		// gen_bibit
		// id_asal_bibit
		// jumlah_panen_stek

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// tgl_tanam
		$this->tgl_tanam->ViewValue = $this->tgl_tanam->CurrentValue;
		$this->tgl_tanam->ViewValue = ew_FormatDateTime($this->tgl_tanam->ViewValue, 0);
		$this->tgl_tanam->ViewCustomAttributes = "";

		// jenis_lahan
		if (strval($this->jenis_lahan->CurrentValue) <> "") {
			$sFilterWrk = "`jenis_lahan_bibit`" . ew_SearchString("=", $this->jenis_lahan->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `jenis_lahan_bibit`, `jenis_lahan_bibit` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `jenis_lahan_bibit`";
		$sWhereWrk = "";
		$this->jenis_lahan->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->jenis_lahan, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->jenis_lahan->ViewValue = $this->jenis_lahan->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->jenis_lahan->ViewValue = $this->jenis_lahan->CurrentValue;
			}
		} else {
			$this->jenis_lahan->ViewValue = NULL;
		}
		$this->jenis_lahan->ViewCustomAttributes = "";

		// varietas
		if (strval($this->varietas->CurrentValue) <> "") {
			$sFilterWrk = "`var_id`" . ew_SearchString("=", $this->varietas->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `var_id`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `varietas`";
		$sWhereWrk = "";
		$this->varietas->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->varietas, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->varietas->ViewValue = $this->varietas->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->varietas->ViewValue = $this->varietas->CurrentValue;
			}
		} else {
			$this->varietas->ViewValue = NULL;
		}
		$this->varietas->ViewCustomAttributes = "";

		// jumlah_tanam
		$this->jumlah_tanam->ViewValue = $this->jumlah_tanam->CurrentValue;
		$this->jumlah_tanam->ViewValue = ew_FormatNumber($this->jumlah_tanam->ViewValue, 0, -1, 0, 0);
		$this->jumlah_tanam->ViewCustomAttributes = "";

		// ket
		$this->ket->ViewValue = $this->ket->CurrentValue;
		$this->ket->ViewCustomAttributes = "";

		// id_kontrak_tanam
		if (strval($this->id_kontrak_tanam->CurrentValue) <> "") {
			$sFilterWrk = "`k_id_kontrak`" . ew_SearchString("=", $this->id_kontrak_tanam->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `k_id_kontrak`, `k_id_kontrak` AS `DispFld`, `k_tgl_tanam` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kontrak`";
		$sWhereWrk = "";
		$this->id_kontrak_tanam->LookupFilters = array("df2" => "5");
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->id_kontrak_tanam, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `k_id_kontrak` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = ew_FormatDateTime($rswrk->fields('Disp2Fld'), 5);
				$this->id_kontrak_tanam->ViewValue = $this->id_kontrak_tanam->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->id_kontrak_tanam->ViewValue = $this->id_kontrak_tanam->CurrentValue;
			}
		} else {
			$this->id_kontrak_tanam->ViewValue = NULL;
		}
		$this->id_kontrak_tanam->ViewCustomAttributes = "";

		// gen_bibit
		if (strval($this->gen_bibit->CurrentValue) <> "") {
			$sFilterWrk = "`id_gen`" . ew_SearchString("=", $this->gen_bibit->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `id_gen`, `id_gen` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `generasi_bibit`";
		$sWhereWrk = "";
		$this->gen_bibit->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gen_bibit, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gen_bibit->ViewValue = $this->gen_bibit->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gen_bibit->ViewValue = $this->gen_bibit->CurrentValue;
			}
		} else {
			$this->gen_bibit->ViewValue = NULL;
		}
		$this->gen_bibit->ViewCustomAttributes = "";

		// id_asal_bibit
		if (strval($this->id_asal_bibit->CurrentValue) <> "") {
			$sFilterWrk = "`id`" . ew_SearchString("=", $this->id_asal_bibit->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `id`, `id` AS `DispFld`, `tgl_tanam` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tanam_bibit`";
		$sWhereWrk = "";
		$this->id_asal_bibit->LookupFilters = array("df2" => "0");
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->id_asal_bibit, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `id` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = ew_FormatDateTime($rswrk->fields('Disp2Fld'), 0);
				$this->id_asal_bibit->ViewValue = $this->id_asal_bibit->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->id_asal_bibit->ViewValue = $this->id_asal_bibit->CurrentValue;
			}
		} else {
			$this->id_asal_bibit->ViewValue = NULL;
		}
		$this->id_asal_bibit->ViewValue = ew_FormatDateTime($this->id_asal_bibit->ViewValue, 5);
		$this->id_asal_bibit->ViewCustomAttributes = "";

		// jumlah_panen_stek
		$this->jumlah_panen_stek->ViewValue = $this->jumlah_panen_stek->CurrentValue;
		$this->jumlah_panen_stek->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// tgl_tanam
			$this->tgl_tanam->LinkCustomAttributes = "";
			$this->tgl_tanam->HrefValue = "";
			$this->tgl_tanam->TooltipValue = "";

			// jenis_lahan
			$this->jenis_lahan->LinkCustomAttributes = "";
			$this->jenis_lahan->HrefValue = "";
			$this->jenis_lahan->TooltipValue = "";

			// varietas
			$this->varietas->LinkCustomAttributes = "";
			$this->varietas->HrefValue = "";
			$this->varietas->TooltipValue = "";

			// jumlah_tanam
			$this->jumlah_tanam->LinkCustomAttributes = "";
			$this->jumlah_tanam->HrefValue = "";
			$this->jumlah_tanam->TooltipValue = "";

			// ket
			$this->ket->LinkCustomAttributes = "";
			$this->ket->HrefValue = "";
			$this->ket->TooltipValue = "";

			// id_kontrak_tanam
			$this->id_kontrak_tanam->LinkCustomAttributes = "";
			$this->id_kontrak_tanam->HrefValue = "";
			$this->id_kontrak_tanam->TooltipValue = "";

			// gen_bibit
			$this->gen_bibit->LinkCustomAttributes = "";
			$this->gen_bibit->HrefValue = "";
			$this->gen_bibit->TooltipValue = "";

			// id_asal_bibit
			$this->id_asal_bibit->LinkCustomAttributes = "";
			$this->id_asal_bibit->HrefValue = "";
			$this->id_asal_bibit->TooltipValue = "";

			// jumlah_panen_stek
			$this->jumlah_panen_stek->LinkCustomAttributes = "";
			$this->jumlah_panen_stek->HrefValue = "";
			$this->jumlah_panen_stek->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// tgl_tanam
			$this->tgl_tanam->EditAttrs["class"] = "form-control";
			$this->tgl_tanam->EditCustomAttributes = "";
			$this->tgl_tanam->EditValue = $this->tgl_tanam->CurrentValue;
			$this->tgl_tanam->EditValue = ew_FormatDateTime($this->tgl_tanam->EditValue, 0);
			$this->tgl_tanam->ViewCustomAttributes = "";

			// jenis_lahan
			$this->jenis_lahan->EditAttrs["class"] = "form-control";
			$this->jenis_lahan->EditCustomAttributes = "";
			if (strval($this->jenis_lahan->CurrentValue) <> "") {
				$sFilterWrk = "`jenis_lahan_bibit`" . ew_SearchString("=", $this->jenis_lahan->CurrentValue, EW_DATATYPE_STRING, "");
			$sSqlWrk = "SELECT `jenis_lahan_bibit`, `jenis_lahan_bibit` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `jenis_lahan_bibit`";
			$sWhereWrk = "";
			$this->jenis_lahan->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->jenis_lahan, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = Conn()->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('DispFld');
					$this->jenis_lahan->EditValue = $this->jenis_lahan->DisplayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->jenis_lahan->EditValue = $this->jenis_lahan->CurrentValue;
				}
			} else {
				$this->jenis_lahan->EditValue = NULL;
			}
			$this->jenis_lahan->ViewCustomAttributes = "";

			// varietas
			$this->varietas->EditAttrs["class"] = "form-control";
			$this->varietas->EditCustomAttributes = "";
			if (strval($this->varietas->CurrentValue) <> "") {
				$sFilterWrk = "`var_id`" . ew_SearchString("=", $this->varietas->CurrentValue, EW_DATATYPE_NUMBER, "");
			$sSqlWrk = "SELECT `var_id`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `varietas`";
			$sWhereWrk = "";
			$this->varietas->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->varietas, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = Conn()->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('DispFld');
					$this->varietas->EditValue = $this->varietas->DisplayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->varietas->EditValue = $this->varietas->CurrentValue;
				}
			} else {
				$this->varietas->EditValue = NULL;
			}
			$this->varietas->ViewCustomAttributes = "";

			// jumlah_tanam
			$this->jumlah_tanam->EditAttrs["class"] = "form-control";
			$this->jumlah_tanam->EditCustomAttributes = "";
			$this->jumlah_tanam->EditValue = ew_HtmlEncode($this->jumlah_tanam->CurrentValue);
			$this->jumlah_tanam->PlaceHolder = ew_RemoveHtml($this->jumlah_tanam->FldCaption());

			// ket
			$this->ket->EditAttrs["class"] = "form-control";
			$this->ket->EditCustomAttributes = "";
			$this->ket->EditValue = ew_HtmlEncode($this->ket->CurrentValue);
			$this->ket->PlaceHolder = ew_RemoveHtml($this->ket->FldCaption());

			// id_kontrak_tanam
			$this->id_kontrak_tanam->EditAttrs["class"] = "form-control";
			$this->id_kontrak_tanam->EditCustomAttributes = "";
			if (trim(strval($this->id_kontrak_tanam->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`k_id_kontrak`" . ew_SearchString("=", $this->id_kontrak_tanam->CurrentValue, EW_DATATYPE_STRING, "");
			}
			$sSqlWrk = "SELECT `k_id_kontrak`, `k_id_kontrak` AS `DispFld`, `k_tgl_tanam` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `kontrak`";
			$sWhereWrk = "";
			$this->id_kontrak_tanam->LookupFilters = array("df2" => "5");
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->id_kontrak_tanam, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `k_id_kontrak` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$rowswrk = count($arwrk);
			for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
				$arwrk[$rowcntwrk][2] = ew_FormatDateTime($arwrk[$rowcntwrk][2], 5);
			}
			$this->id_kontrak_tanam->EditValue = $arwrk;

			// gen_bibit
			$this->gen_bibit->EditAttrs["class"] = "form-control";
			$this->gen_bibit->EditCustomAttributes = "";
			if (trim(strval($this->gen_bibit->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`id_gen`" . ew_SearchString("=", $this->gen_bibit->CurrentValue, EW_DATATYPE_STRING, "");
			}
			$sSqlWrk = "SELECT `id_gen`, `id_gen` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `generasi_bibit`";
			$sWhereWrk = "";
			$this->gen_bibit->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->gen_bibit, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->gen_bibit->EditValue = $arwrk;

			// id_asal_bibit
			$this->id_asal_bibit->EditAttrs["class"] = "form-control";
			$this->id_asal_bibit->EditCustomAttributes = "";
			if (trim(strval($this->id_asal_bibit->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`id`" . ew_SearchString("=", $this->id_asal_bibit->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `id`, `id` AS `DispFld`, `tgl_tanam` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `tanam_bibit`";
			$sWhereWrk = "";
			$this->id_asal_bibit->LookupFilters = array("df2" => "0");
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->id_asal_bibit, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `id` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$rowswrk = count($arwrk);
			for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
				$arwrk[$rowcntwrk][2] = ew_FormatDateTime($arwrk[$rowcntwrk][2], 0);
			}
			$this->id_asal_bibit->EditValue = $arwrk;

			// jumlah_panen_stek
			$this->jumlah_panen_stek->EditAttrs["class"] = "form-control";
			$this->jumlah_panen_stek->EditCustomAttributes = "";
			$this->jumlah_panen_stek->EditValue = ew_HtmlEncode($this->jumlah_panen_stek->CurrentValue);
			$this->jumlah_panen_stek->PlaceHolder = ew_RemoveHtml($this->jumlah_panen_stek->FldCaption());

			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// tgl_tanam
			$this->tgl_tanam->LinkCustomAttributes = "";
			$this->tgl_tanam->HrefValue = "";
			$this->tgl_tanam->TooltipValue = "";

			// jenis_lahan
			$this->jenis_lahan->LinkCustomAttributes = "";
			$this->jenis_lahan->HrefValue = "";
			$this->jenis_lahan->TooltipValue = "";

			// varietas
			$this->varietas->LinkCustomAttributes = "";
			$this->varietas->HrefValue = "";
			$this->varietas->TooltipValue = "";

			// jumlah_tanam
			$this->jumlah_tanam->LinkCustomAttributes = "";
			$this->jumlah_tanam->HrefValue = "";

			// ket
			$this->ket->LinkCustomAttributes = "";
			$this->ket->HrefValue = "";

			// id_kontrak_tanam
			$this->id_kontrak_tanam->LinkCustomAttributes = "";
			$this->id_kontrak_tanam->HrefValue = "";

			// gen_bibit
			$this->gen_bibit->LinkCustomAttributes = "";
			$this->gen_bibit->HrefValue = "";

			// id_asal_bibit
			$this->id_asal_bibit->LinkCustomAttributes = "";
			$this->id_asal_bibit->HrefValue = "";

			// jumlah_panen_stek
			$this->jumlah_panen_stek->LinkCustomAttributes = "";
			$this->jumlah_panen_stek->HrefValue = "";
		}
		if ($this->RowType == EW_ROWTYPE_ADD || $this->RowType == EW_ROWTYPE_EDIT || $this->RowType == EW_ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->SetupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $Language, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return ($gsFormError == "");
		if (!ew_CheckInteger($this->jumlah_tanam->FormValue)) {
			ew_AddMessage($gsFormError, $this->jumlah_tanam->FldErrMsg());
		}
		if (!$this->id_kontrak_tanam->FldIsDetailKey && !is_null($this->id_kontrak_tanam->FormValue) && $this->id_kontrak_tanam->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->id_kontrak_tanam->FldCaption(), $this->id_kontrak_tanam->ReqErrMsg));
		}
		if (!$this->gen_bibit->FldIsDetailKey && !is_null($this->gen_bibit->FormValue) && $this->gen_bibit->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->gen_bibit->FldCaption(), $this->gen_bibit->ReqErrMsg));
		}
		if (!$this->id_asal_bibit->FldIsDetailKey && !is_null($this->id_asal_bibit->FormValue) && $this->id_asal_bibit->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->id_asal_bibit->FldCaption(), $this->id_asal_bibit->ReqErrMsg));
		}
		if (!$this->jumlah_panen_stek->FldIsDetailKey && !is_null($this->jumlah_panen_stek->FormValue) && $this->jumlah_panen_stek->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->jumlah_panen_stek->FldCaption(), $this->jumlah_panen_stek->ReqErrMsg));
		}
		if (!ew_CheckInteger($this->jumlah_panen_stek->FormValue)) {
			ew_AddMessage($gsFormError, $this->jumlah_panen_stek->FldErrMsg());
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsFormError, $sFormCustomError);
		}
		return $ValidateForm;
	}

	// Update record based on key values
	function EditRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();
		$sFilter = $this->ApplyUserIDFilters($sFilter);
		$conn = &$this->Connection();
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
		$rs = $conn->Execute($sSql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->Phrase("NoRecord")); // Set no record message
			$EditRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->LoadDbValues($rsold);
			$rsnew = array();

			// jumlah_tanam
			$this->jumlah_tanam->SetDbValueDef($rsnew, $this->jumlah_tanam->CurrentValue, NULL, $this->jumlah_tanam->ReadOnly);

			// ket
			$this->ket->SetDbValueDef($rsnew, $this->ket->CurrentValue, NULL, $this->ket->ReadOnly);

			// id_kontrak_tanam
			$this->id_kontrak_tanam->SetDbValueDef($rsnew, $this->id_kontrak_tanam->CurrentValue, "", $this->id_kontrak_tanam->ReadOnly);

			// gen_bibit
			$this->gen_bibit->SetDbValueDef($rsnew, $this->gen_bibit->CurrentValue, "", $this->gen_bibit->ReadOnly);

			// id_asal_bibit
			$this->id_asal_bibit->SetDbValueDef($rsnew, $this->id_asal_bibit->CurrentValue, 0, $this->id_asal_bibit->ReadOnly);

			// jumlah_panen_stek
			$this->jumlah_panen_stek->SetDbValueDef($rsnew, $this->jumlah_panen_stek->CurrentValue, 0, $this->jumlah_panen_stek->ReadOnly);

			// Call Row Updating event
			$bUpdateRow = $this->Row_Updating($rsold, $rsnew);
			if ($bUpdateRow) {
				$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
				if (count($rsnew) > 0)
					$EditRow = $this->Update($rsnew, "", $rsold);
				else
					$EditRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($EditRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->Phrase("UpdateCancelled"));
				}
				$EditRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($EditRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->Close();
		return $EditRow;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$Breadcrumb->Add("list", $this->TableVar, $this->AddMasterUrl("tanam_bibitlist.php"), "", $this->TableVar, TRUE);
		$PageId = "edit";
		$Breadcrumb->Add("edit", $PageId, $url);
	}

	// Setup lookup filters of a field
	function SetupLookupFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		case "x_id_kontrak_tanam":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `k_id_kontrak` AS `LinkFld`, `k_id_kontrak` AS `DispFld`, `k_tgl_tanam` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kontrak`";
			$sWhereWrk = "";
			$fld->LookupFilters = array("df2" => "5");
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`k_id_kontrak` IN ({filter_value})', "t0" => "200", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->id_kontrak_tanam, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `k_id_kontrak` DESC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_gen_bibit":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `id_gen` AS `LinkFld`, `id_gen` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `generasi_bibit`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`id_gen` IN ({filter_value})', "t0" => "200", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->gen_bibit, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_id_asal_bibit":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `id` AS `LinkFld`, `id` AS `DispFld`, `tgl_tanam` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tanam_bibit`";
			$sWhereWrk = "";
			$fld->LookupFilters = array("df2" => "0");
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->id_asal_bibit, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `id` DESC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		}
	}

	// Setup AutoSuggest filters of a field
	function SetupAutoSuggestFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($tanam_bibit_edit)) $tanam_bibit_edit = new ctanam_bibit_edit();

// Page init
$tanam_bibit_edit->Page_Init();

// Page main
$tanam_bibit_edit->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tanam_bibit_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "edit";
var CurrentForm = ftanam_bibitedit = new ew_Form("ftanam_bibitedit", "edit");

// Validate form
ftanam_bibitedit.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);
	if ($fobj.find("#a_confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.FormKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = $fobj.find("#a_list").val() == "gridinsert";
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
			elm = this.GetElements("x" + infix + "_jumlah_tanam");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($tanam_bibit->jumlah_tanam->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_id_kontrak_tanam");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $tanam_bibit->id_kontrak_tanam->FldCaption(), $tanam_bibit->id_kontrak_tanam->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_gen_bibit");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $tanam_bibit->gen_bibit->FldCaption(), $tanam_bibit->gen_bibit->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_id_asal_bibit");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $tanam_bibit->id_asal_bibit->FldCaption(), $tanam_bibit->id_asal_bibit->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_jumlah_panen_stek");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $tanam_bibit->jumlah_panen_stek->FldCaption(), $tanam_bibit->jumlah_panen_stek->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_jumlah_panen_stek");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($tanam_bibit->jumlah_panen_stek->FldErrMsg()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ewForms[val])
			if (!ewForms[val].Validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
ftanam_bibitedit.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
ftanam_bibitedit.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ftanam_bibitedit.Lists["x_jenis_lahan"] = {"LinkField":"x_jenis_lahan_bibit","Ajax":true,"AutoFill":false,"DisplayFields":["x_jenis_lahan_bibit","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"jenis_lahan_bibit"};
ftanam_bibitedit.Lists["x_jenis_lahan"].Data = "<?php echo $tanam_bibit_edit->jenis_lahan->LookupFilterQuery(FALSE, "edit") ?>";
ftanam_bibitedit.Lists["x_varietas"] = {"LinkField":"x_var_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_var_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"varietas"};
ftanam_bibitedit.Lists["x_varietas"].Data = "<?php echo $tanam_bibit_edit->varietas->LookupFilterQuery(FALSE, "edit") ?>";
ftanam_bibitedit.Lists["x_id_kontrak_tanam"] = {"LinkField":"x_k_id_kontrak","Ajax":true,"AutoFill":false,"DisplayFields":["x_k_id_kontrak","x_k_tgl_tanam","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kontrak"};
ftanam_bibitedit.Lists["x_id_kontrak_tanam"].Data = "<?php echo $tanam_bibit_edit->id_kontrak_tanam->LookupFilterQuery(FALSE, "edit") ?>";
ftanam_bibitedit.Lists["x_gen_bibit"] = {"LinkField":"x_id_gen","Ajax":true,"AutoFill":false,"DisplayFields":["x_id_gen","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"generasi_bibit"};
ftanam_bibitedit.Lists["x_gen_bibit"].Data = "<?php echo $tanam_bibit_edit->gen_bibit->LookupFilterQuery(FALSE, "edit") ?>";
ftanam_bibitedit.Lists["x_id_asal_bibit"] = {"LinkField":"x_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_id","x_tgl_tanam","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"tanam_bibit"};
ftanam_bibitedit.Lists["x_id_asal_bibit"].Data = "<?php echo $tanam_bibit_edit->id_asal_bibit->LookupFilterQuery(FALSE, "edit") ?>";

// Form object for search
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php $tanam_bibit_edit->ShowPageHeader(); ?>
<?php
$tanam_bibit_edit->ShowMessage();
?>
<form name="ftanam_bibitedit" id="ftanam_bibitedit" class="<?php echo $tanam_bibit_edit->FormClassName ?>" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($tanam_bibit_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $tanam_bibit_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tanam_bibit">
<input type="hidden" name="a_edit" id="a_edit" value="U">
<input type="hidden" name="modal" value="<?php echo intval($tanam_bibit_edit->IsModal) ?>">
<div class="ewEditDiv"><!-- page* -->
<?php if ($tanam_bibit->id->Visible) { // id ?>
	<div id="r_id" class="form-group">
		<label id="elh_tanam_bibit_id" class="<?php echo $tanam_bibit_edit->LeftColumnClass ?>"><?php echo $tanam_bibit->id->FldCaption() ?></label>
		<div class="<?php echo $tanam_bibit_edit->RightColumnClass ?>"><div<?php echo $tanam_bibit->id->CellAttributes() ?>>
<span id="el_tanam_bibit_id">
<span<?php echo $tanam_bibit->id->ViewAttributes() ?>>
<p class="form-control-static"><?php echo $tanam_bibit->id->EditValue ?></p></span>
</span>
<input type="hidden" data-table="tanam_bibit" data-field="x_id" name="x_id" id="x_id" value="<?php echo ew_HtmlEncode($tanam_bibit->id->CurrentValue) ?>">
<?php echo $tanam_bibit->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tanam_bibit->tgl_tanam->Visible) { // tgl_tanam ?>
	<div id="r_tgl_tanam" class="form-group">
		<label id="elh_tanam_bibit_tgl_tanam" for="x_tgl_tanam" class="<?php echo $tanam_bibit_edit->LeftColumnClass ?>"><?php echo $tanam_bibit->tgl_tanam->FldCaption() ?></label>
		<div class="<?php echo $tanam_bibit_edit->RightColumnClass ?>"><div<?php echo $tanam_bibit->tgl_tanam->CellAttributes() ?>>
<span id="el_tanam_bibit_tgl_tanam">
<span<?php echo $tanam_bibit->tgl_tanam->ViewAttributes() ?>>
<p class="form-control-static"><?php echo $tanam_bibit->tgl_tanam->EditValue ?></p></span>
</span>
<input type="hidden" data-table="tanam_bibit" data-field="x_tgl_tanam" name="x_tgl_tanam" id="x_tgl_tanam" value="<?php echo ew_HtmlEncode($tanam_bibit->tgl_tanam->CurrentValue) ?>">
<?php echo $tanam_bibit->tgl_tanam->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tanam_bibit->jenis_lahan->Visible) { // jenis_lahan ?>
	<div id="r_jenis_lahan" class="form-group">
		<label id="elh_tanam_bibit_jenis_lahan" class="<?php echo $tanam_bibit_edit->LeftColumnClass ?>"><?php echo $tanam_bibit->jenis_lahan->FldCaption() ?></label>
		<div class="<?php echo $tanam_bibit_edit->RightColumnClass ?>"><div<?php echo $tanam_bibit->jenis_lahan->CellAttributes() ?>>
<span id="el_tanam_bibit_jenis_lahan">
<span<?php echo $tanam_bibit->jenis_lahan->ViewAttributes() ?>>
<p class="form-control-static"><?php echo $tanam_bibit->jenis_lahan->EditValue ?></p></span>
</span>
<input type="hidden" data-table="tanam_bibit" data-field="x_jenis_lahan" name="x_jenis_lahan" id="x_jenis_lahan" value="<?php echo ew_HtmlEncode($tanam_bibit->jenis_lahan->CurrentValue) ?>">
<?php echo $tanam_bibit->jenis_lahan->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tanam_bibit->varietas->Visible) { // varietas ?>
	<div id="r_varietas" class="form-group">
		<label id="elh_tanam_bibit_varietas" for="x_varietas" class="<?php echo $tanam_bibit_edit->LeftColumnClass ?>"><?php echo $tanam_bibit->varietas->FldCaption() ?></label>
		<div class="<?php echo $tanam_bibit_edit->RightColumnClass ?>"><div<?php echo $tanam_bibit->varietas->CellAttributes() ?>>
<span id="el_tanam_bibit_varietas">
<span<?php echo $tanam_bibit->varietas->ViewAttributes() ?>>
<p class="form-control-static"><?php echo $tanam_bibit->varietas->EditValue ?></p></span>
</span>
<input type="hidden" data-table="tanam_bibit" data-field="x_varietas" name="x_varietas" id="x_varietas" value="<?php echo ew_HtmlEncode($tanam_bibit->varietas->CurrentValue) ?>">
<?php echo $tanam_bibit->varietas->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tanam_bibit->jumlah_tanam->Visible) { // jumlah_tanam ?>
	<div id="r_jumlah_tanam" class="form-group">
		<label id="elh_tanam_bibit_jumlah_tanam" for="x_jumlah_tanam" class="<?php echo $tanam_bibit_edit->LeftColumnClass ?>"><?php echo $tanam_bibit->jumlah_tanam->FldCaption() ?></label>
		<div class="<?php echo $tanam_bibit_edit->RightColumnClass ?>"><div<?php echo $tanam_bibit->jumlah_tanam->CellAttributes() ?>>
<span id="el_tanam_bibit_jumlah_tanam">
<input type="text" data-table="tanam_bibit" data-field="x_jumlah_tanam" name="x_jumlah_tanam" id="x_jumlah_tanam" size="30" placeholder="<?php echo ew_HtmlEncode($tanam_bibit->jumlah_tanam->getPlaceHolder()) ?>" value="<?php echo $tanam_bibit->jumlah_tanam->EditValue ?>"<?php echo $tanam_bibit->jumlah_tanam->EditAttributes() ?>>
</span>
<?php echo $tanam_bibit->jumlah_tanam->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tanam_bibit->ket->Visible) { // ket ?>
	<div id="r_ket" class="form-group">
		<label id="elh_tanam_bibit_ket" for="x_ket" class="<?php echo $tanam_bibit_edit->LeftColumnClass ?>"><?php echo $tanam_bibit->ket->FldCaption() ?></label>
		<div class="<?php echo $tanam_bibit_edit->RightColumnClass ?>"><div<?php echo $tanam_bibit->ket->CellAttributes() ?>>
<span id="el_tanam_bibit_ket">
<textarea data-table="tanam_bibit" data-field="x_ket" name="x_ket" id="x_ket" cols="35" rows="4" placeholder="<?php echo ew_HtmlEncode($tanam_bibit->ket->getPlaceHolder()) ?>"<?php echo $tanam_bibit->ket->EditAttributes() ?>><?php echo $tanam_bibit->ket->EditValue ?></textarea>
</span>
<?php echo $tanam_bibit->ket->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tanam_bibit->id_kontrak_tanam->Visible) { // id_kontrak_tanam ?>
	<div id="r_id_kontrak_tanam" class="form-group">
		<label id="elh_tanam_bibit_id_kontrak_tanam" for="x_id_kontrak_tanam" class="<?php echo $tanam_bibit_edit->LeftColumnClass ?>"><?php echo $tanam_bibit->id_kontrak_tanam->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $tanam_bibit_edit->RightColumnClass ?>"><div<?php echo $tanam_bibit->id_kontrak_tanam->CellAttributes() ?>>
<span id="el_tanam_bibit_id_kontrak_tanam">
<select data-table="tanam_bibit" data-field="x_id_kontrak_tanam" data-value-separator="<?php echo $tanam_bibit->id_kontrak_tanam->DisplayValueSeparatorAttribute() ?>" id="x_id_kontrak_tanam" name="x_id_kontrak_tanam"<?php echo $tanam_bibit->id_kontrak_tanam->EditAttributes() ?>>
<?php echo $tanam_bibit->id_kontrak_tanam->SelectOptionListHtml("x_id_kontrak_tanam") ?>
</select>
</span>
<?php echo $tanam_bibit->id_kontrak_tanam->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tanam_bibit->gen_bibit->Visible) { // gen_bibit ?>
	<div id="r_gen_bibit" class="form-group">
		<label id="elh_tanam_bibit_gen_bibit" for="x_gen_bibit" class="<?php echo $tanam_bibit_edit->LeftColumnClass ?>"><?php echo $tanam_bibit->gen_bibit->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $tanam_bibit_edit->RightColumnClass ?>"><div<?php echo $tanam_bibit->gen_bibit->CellAttributes() ?>>
<span id="el_tanam_bibit_gen_bibit">
<select data-table="tanam_bibit" data-field="x_gen_bibit" data-value-separator="<?php echo $tanam_bibit->gen_bibit->DisplayValueSeparatorAttribute() ?>" id="x_gen_bibit" name="x_gen_bibit"<?php echo $tanam_bibit->gen_bibit->EditAttributes() ?>>
<?php echo $tanam_bibit->gen_bibit->SelectOptionListHtml("x_gen_bibit") ?>
</select>
</span>
<?php echo $tanam_bibit->gen_bibit->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tanam_bibit->id_asal_bibit->Visible) { // id_asal_bibit ?>
	<div id="r_id_asal_bibit" class="form-group">
		<label id="elh_tanam_bibit_id_asal_bibit" for="x_id_asal_bibit" class="<?php echo $tanam_bibit_edit->LeftColumnClass ?>"><?php echo $tanam_bibit->id_asal_bibit->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $tanam_bibit_edit->RightColumnClass ?>"><div<?php echo $tanam_bibit->id_asal_bibit->CellAttributes() ?>>
<span id="el_tanam_bibit_id_asal_bibit">
<select data-table="tanam_bibit" data-field="x_id_asal_bibit" data-value-separator="<?php echo $tanam_bibit->id_asal_bibit->DisplayValueSeparatorAttribute() ?>" id="x_id_asal_bibit" name="x_id_asal_bibit"<?php echo $tanam_bibit->id_asal_bibit->EditAttributes() ?>>
<?php echo $tanam_bibit->id_asal_bibit->SelectOptionListHtml("x_id_asal_bibit") ?>
</select>
</span>
<?php echo $tanam_bibit->id_asal_bibit->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tanam_bibit->jumlah_panen_stek->Visible) { // jumlah_panen_stek ?>
	<div id="r_jumlah_panen_stek" class="form-group">
		<label id="elh_tanam_bibit_jumlah_panen_stek" for="x_jumlah_panen_stek" class="<?php echo $tanam_bibit_edit->LeftColumnClass ?>"><?php echo $tanam_bibit->jumlah_panen_stek->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $tanam_bibit_edit->RightColumnClass ?>"><div<?php echo $tanam_bibit->jumlah_panen_stek->CellAttributes() ?>>
<span id="el_tanam_bibit_jumlah_panen_stek">
<input type="text" data-table="tanam_bibit" data-field="x_jumlah_panen_stek" name="x_jumlah_panen_stek" id="x_jumlah_panen_stek" size="30" placeholder="<?php echo ew_HtmlEncode($tanam_bibit->jumlah_panen_stek->getPlaceHolder()) ?>" value="<?php echo $tanam_bibit->jumlah_panen_stek->EditValue ?>"<?php echo $tanam_bibit->jumlah_panen_stek->EditAttributes() ?>>
</span>
<?php echo $tanam_bibit->jumlah_panen_stek->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$tanam_bibit_edit->IsModal) { ?>
<div class="form-group"><!-- buttons .form-group -->
	<div class="<?php echo $tanam_bibit_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ewButton" name="btnAction" id="btnAction" type="submit"><?php echo $Language->Phrase("SaveBtn") ?></button>
<button class="btn btn-default ewButton" name="btnCancel" id="btnCancel" type="button" data-href="<?php echo $tanam_bibit_edit->getReturnUrl() ?>"><?php echo $Language->Phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<script type="text/javascript">
ftanam_bibitedit.Init();
</script>
<?php
$tanam_bibit_edit->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$tanam_bibit_edit->Page_Terminate();
?>
