<?php
if (session_id() == "") session_start(); // Init session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg14.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql14.php") ?>
<?php include_once "phpfn14.php" ?>
<?php include_once "sosialisasiinfo.php" ?>
<?php include_once "employeesinfo.php" ?>
<?php include_once "userfn14.php" ?>
<?php

//
// Page class
//

$sosialisasi_edit = NULL; // Initialize page object first

class csosialisasi_edit extends csosialisasi {

	// Page ID
	var $PageID = 'edit';

	// Project ID
	var $ProjectID = '{CC60B42B-604B-412A-B014-2315920AF6AA}';

	// Table name
	var $TableName = 'sosialisasi';

	// Page object name
	var $PageObjName = 'sosialisasi_edit';

	// Page headings
	var $Heading = '';
	var $Subheading = '';

	// Page heading
	function PageHeading() {
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->TableCaption();
		return "";
	}

	// Page subheading
	function PageSubheading() {
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->Phrase($this->PageID);
		return "";
	}

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (sosialisasi)
		if (!isset($GLOBALS["sosialisasi"]) || get_class($GLOBALS["sosialisasi"]) == "csosialisasi") {
			$GLOBALS["sosialisasi"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["sosialisasi"];
		}

		// Table object (employees)
		if (!isset($GLOBALS['employees'])) $GLOBALS['employees'] = new cemployees();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'edit', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'sosialisasi', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"]))
			$GLOBALS["gTimer"] = new cTimer();

		// Debug message
		ew_LoadDebugMsg();

		// Open connection
		if (!isset($conn))
			$conn = ew_Connect($this->DBID);

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new cemployees();
			$UserTableConn = Conn($UserTable->DBID);
		}
	}

	//
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Is modal
		$this->IsModal = (@$_GET["modal"] == "1" || @$_POST["modal"] == "1");

		// User profile
		$UserProfile = new cUserProfile();

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanEdit()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			if ($Security->CanList())
				$this->Page_Terminate(ew_GetUrl("sosialisasilist.php"));
			else
				$this->Page_Terminate(ew_GetUrl("login.php"));
		}

		// NOTE: Security object may be needed in other part of the script, skip set to Nothing
		// 
		// Security = null;
		// 
		// Create form object

		$objForm = new cFormObj();
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action
		$this->sos_id->SetVisibility();
		if ($this->IsAdd() || $this->IsCopy() || $this->IsGridAdd())
			$this->sos_id->Visible = FALSE;
		$this->sos_tgl->SetVisibility();
		$this->ts_id->SetVisibility();
		$this->sos_co->SetVisibility();
		$this->sos_peserta->SetVisibility();
		$this->sos_prov->SetVisibility();
		$this->sos_kab->SetVisibility();
		$this->sos_kec->SetVisibility();
		$this->sos_desa->SetVisibility();
		$this->sos_alamat->SetVisibility();
		$this->sos_pot_lahan->SetVisibility();
		$this->sos_katinggian->SetVisibility();
		$this->sos_biaya->SetVisibility();
		$this->sos_kesimpulan->SetVisibility();
		$this->sos_foto->SetVisibility();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $sosialisasi;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($sosialisasi);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		// Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = ew_GetPageName($url);
				if ($pageName != $this->GetListUrl()) { // Not List page
					$row["caption"] = $this->GetModalCaption($pageName);
					if ($pageName == "sosialisasiview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				header("Content-Type: application/json; charset=utf-8");
				echo ew_ConvertToUtf8(ew_ArrayToJson(array($row)));
			} else {
				ew_SaveDebugMsg();
				header("Location: " . $url);
			}
		}
		exit();
	}
	var $FormClassName = "form-horizontal ewForm ewEditForm";
	var $IsModal = FALSE;
	var $IsMobileOrModal = FALSE;
	var $DbMasterFilter;
	var $DbDetailFilter;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError, $gbSkipHeaderFooter;

		// Check modal
		if ($this->IsModal)
			$gbSkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = ew_IsMobile() || $this->IsModal;
		$this->FormClassName = "ewForm ewEditForm form-horizontal";
		$sReturnUrl = "";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (@$_POST["a_edit"] <> "") {
			$this->CurrentAction = $_POST["a_edit"]; // Get action code
			if ($this->CurrentAction <> "I") // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($objForm->HasValue("x_sos_id")) {
				$this->sos_id->setFormValue($objForm->GetValue("x_sos_id"));
			}
		} else {
			$this->CurrentAction = "I"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (isset($_GET["sos_id"])) {
				$this->sos_id->setQueryStringValue($_GET["sos_id"]);
				$loadByQuery = TRUE;
			} else {
				$this->sos_id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->LoadRow();

		// Process form if post back
		if ($postBack) {
			$this->LoadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->ValidateForm()) {
				$this->CurrentAction = ""; // Form error, reset action
				$this->setFailureMessage($gsFormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->RestoreFormValues();
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "I": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "") $this->setFailureMessage($Language->Phrase("NoRecord")); // No record found
					$this->Page_Terminate("sosialisasilist.php"); // No matching record, return to list
				}
				break;
			Case "U": // Update
				$sReturnUrl = $this->getReturnUrl();
				if (ew_GetPageName($sReturnUrl) == "sosialisasilist.php")
					$sReturnUrl = $this->AddMasterUrl($sReturnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->EditRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->Phrase("UpdateSuccess")); // Update success
					$this->Page_Terminate($sReturnUrl); // Return to caller
				} elseif ($this->getFailureMessage() == $Language->Phrase("NoRecord")) {
					$this->Page_Terminate($sReturnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->RestoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->SetupBreadcrumb();

		// Render the record
		$this->RowType = EW_ROWTYPE_EDIT; // Render as Edit
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Set up starting record parameters
	function SetupStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	function GetUploadFiles() {
		global $objForm, $Language;

		// Get upload data
		$this->sos_foto->Upload->Index = $objForm->Index;
		$this->sos_foto->Upload->UploadFile();
		$this->sos_foto->CurrentValue = $this->sos_foto->Upload->FileName;
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm;
		$this->GetUploadFiles(); // Get upload files
		if (!$this->sos_id->FldIsDetailKey)
			$this->sos_id->setFormValue($objForm->GetValue("x_sos_id"));
		if (!$this->sos_tgl->FldIsDetailKey) {
			$this->sos_tgl->setFormValue($objForm->GetValue("x_sos_tgl"));
			$this->sos_tgl->CurrentValue = ew_UnFormatDateTime($this->sos_tgl->CurrentValue, 0);
		}
		if (!$this->ts_id->FldIsDetailKey) {
			$this->ts_id->setFormValue($objForm->GetValue("x_ts_id"));
		}
		if (!$this->sos_co->FldIsDetailKey) {
			$this->sos_co->setFormValue($objForm->GetValue("x_sos_co"));
		}
		if (!$this->sos_peserta->FldIsDetailKey) {
			$this->sos_peserta->setFormValue($objForm->GetValue("x_sos_peserta"));
		}
		if (!$this->sos_prov->FldIsDetailKey) {
			$this->sos_prov->setFormValue($objForm->GetValue("x_sos_prov"));
		}
		if (!$this->sos_kab->FldIsDetailKey) {
			$this->sos_kab->setFormValue($objForm->GetValue("x_sos_kab"));
		}
		if (!$this->sos_kec->FldIsDetailKey) {
			$this->sos_kec->setFormValue($objForm->GetValue("x_sos_kec"));
		}
		if (!$this->sos_desa->FldIsDetailKey) {
			$this->sos_desa->setFormValue($objForm->GetValue("x_sos_desa"));
		}
		if (!$this->sos_alamat->FldIsDetailKey) {
			$this->sos_alamat->setFormValue($objForm->GetValue("x_sos_alamat"));
		}
		if (!$this->sos_pot_lahan->FldIsDetailKey) {
			$this->sos_pot_lahan->setFormValue($objForm->GetValue("x_sos_pot_lahan"));
		}
		if (!$this->sos_katinggian->FldIsDetailKey) {
			$this->sos_katinggian->setFormValue($objForm->GetValue("x_sos_katinggian"));
		}
		if (!$this->sos_biaya->FldIsDetailKey) {
			$this->sos_biaya->setFormValue($objForm->GetValue("x_sos_biaya"));
		}
		if (!$this->sos_kesimpulan->FldIsDetailKey) {
			$this->sos_kesimpulan->setFormValue($objForm->GetValue("x_sos_kesimpulan"));
		}
	}

	// Restore form values
	function RestoreFormValues() {
		global $objForm;
		$this->sos_id->CurrentValue = $this->sos_id->FormValue;
		$this->sos_tgl->CurrentValue = $this->sos_tgl->FormValue;
		$this->sos_tgl->CurrentValue = ew_UnFormatDateTime($this->sos_tgl->CurrentValue, 0);
		$this->ts_id->CurrentValue = $this->ts_id->FormValue;
		$this->sos_co->CurrentValue = $this->sos_co->FormValue;
		$this->sos_peserta->CurrentValue = $this->sos_peserta->FormValue;
		$this->sos_prov->CurrentValue = $this->sos_prov->FormValue;
		$this->sos_kab->CurrentValue = $this->sos_kab->FormValue;
		$this->sos_kec->CurrentValue = $this->sos_kec->FormValue;
		$this->sos_desa->CurrentValue = $this->sos_desa->FormValue;
		$this->sos_alamat->CurrentValue = $this->sos_alamat->FormValue;
		$this->sos_pot_lahan->CurrentValue = $this->sos_pot_lahan->FormValue;
		$this->sos_katinggian->CurrentValue = $this->sos_katinggian->FormValue;
		$this->sos_biaya->CurrentValue = $this->sos_biaya->FormValue;
		$this->sos_kesimpulan->CurrentValue = $this->sos_kesimpulan->FormValue;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues($rs = NULL) {
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->NewRow(); 

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->sos_id->setDbValue($row['sos_id']);
		$this->sos_tgl->setDbValue($row['sos_tgl']);
		$this->ts_id->setDbValue($row['ts_id']);
		$this->sos_co->setDbValue($row['sos_co']);
		$this->sos_peserta->setDbValue($row['sos_peserta']);
		$this->sos_prov->setDbValue($row['sos_prov']);
		$this->sos_kab->setDbValue($row['sos_kab']);
		$this->sos_kec->setDbValue($row['sos_kec']);
		$this->sos_desa->setDbValue($row['sos_desa']);
		$this->sos_alamat->setDbValue($row['sos_alamat']);
		$this->sos_pot_lahan->setDbValue($row['sos_pot_lahan']);
		$this->sos_katinggian->setDbValue($row['sos_katinggian']);
		$this->sos_biaya->setDbValue($row['sos_biaya']);
		$this->sos_kesimpulan->setDbValue($row['sos_kesimpulan']);
		$this->sos_foto->Upload->DbValue = $row['sos_foto'];
		$this->sos_foto->setDbValue($this->sos_foto->Upload->DbValue);
	}

	// Return a row with default values
	function NewRow() {
		$row = array();
		$row['sos_id'] = NULL;
		$row['sos_tgl'] = NULL;
		$row['ts_id'] = NULL;
		$row['sos_co'] = NULL;
		$row['sos_peserta'] = NULL;
		$row['sos_prov'] = NULL;
		$row['sos_kab'] = NULL;
		$row['sos_kec'] = NULL;
		$row['sos_desa'] = NULL;
		$row['sos_alamat'] = NULL;
		$row['sos_pot_lahan'] = NULL;
		$row['sos_katinggian'] = NULL;
		$row['sos_biaya'] = NULL;
		$row['sos_kesimpulan'] = NULL;
		$row['sos_foto'] = NULL;
		return $row;
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->sos_id->DbValue = $row['sos_id'];
		$this->sos_tgl->DbValue = $row['sos_tgl'];
		$this->ts_id->DbValue = $row['ts_id'];
		$this->sos_co->DbValue = $row['sos_co'];
		$this->sos_peserta->DbValue = $row['sos_peserta'];
		$this->sos_prov->DbValue = $row['sos_prov'];
		$this->sos_kab->DbValue = $row['sos_kab'];
		$this->sos_kec->DbValue = $row['sos_kec'];
		$this->sos_desa->DbValue = $row['sos_desa'];
		$this->sos_alamat->DbValue = $row['sos_alamat'];
		$this->sos_pot_lahan->DbValue = $row['sos_pot_lahan'];
		$this->sos_katinggian->DbValue = $row['sos_katinggian'];
		$this->sos_biaya->DbValue = $row['sos_biaya'];
		$this->sos_kesimpulan->DbValue = $row['sos_kesimpulan'];
		$this->sos_foto->Upload->DbValue = $row['sos_foto'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("sos_id")) <> "")
			$this->sos_id->CurrentValue = $this->getKey("sos_id"); // sos_id
		else
			$bValidKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
		}
		$this->LoadRowValues($this->OldRecordset); // Load row values
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// sos_id
		// sos_tgl
		// ts_id
		// sos_co
		// sos_peserta
		// sos_prov
		// sos_kab
		// sos_kec
		// sos_desa
		// sos_alamat
		// sos_pot_lahan
		// sos_katinggian
		// sos_biaya
		// sos_kesimpulan
		// sos_foto

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// sos_id
		$this->sos_id->ViewValue = $this->sos_id->CurrentValue;
		$this->sos_id->ViewCustomAttributes = "";

		// sos_tgl
		$this->sos_tgl->ViewValue = $this->sos_tgl->CurrentValue;
		$this->sos_tgl->ViewValue = ew_FormatDateTime($this->sos_tgl->ViewValue, 0);
		$this->sos_tgl->ViewCustomAttributes = "";

		// ts_id
		if (strval($this->ts_id->CurrentValue) <> "") {
			$sFilterWrk = "`ts_id`" . ew_SearchString("=", $this->ts_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `ts_id`, `ts_judul` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tema_sosialisasi`";
		$sWhereWrk = "";
		$this->ts_id->LookupFilters = array("dx1" => '`ts_judul`');
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->ts_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->ts_id->ViewValue = $this->ts_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->ts_id->ViewValue = $this->ts_id->CurrentValue;
			}
		} else {
			$this->ts_id->ViewValue = NULL;
		}
		$this->ts_id->ViewCustomAttributes = "";

		// sos_co
		if (strval($this->sos_co->CurrentValue) <> "") {
			$sFilterWrk = "`co_id`" . ew_SearchString("=", $this->sos_co->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `co_id`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `co`";
		$sWhereWrk = "";
		$this->sos_co->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->sos_co, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `co_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->sos_co->ViewValue = $this->sos_co->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->sos_co->ViewValue = $this->sos_co->CurrentValue;
			}
		} else {
			$this->sos_co->ViewValue = NULL;
		}
		$this->sos_co->ViewCustomAttributes = "";

		// sos_peserta
		if (strval($this->sos_peserta->CurrentValue) <> "") {
			$arwrk = explode(",", $this->sos_peserta->CurrentValue);
			$sFilterWrk = "";
			foreach ($arwrk as $wrk) {
				if ($sFilterWrk <> "") $sFilterWrk .= " OR ";
				$sFilterWrk .= "`pes_id`" . ew_SearchString("=", trim($wrk), EW_DATATYPE_NUMBER, "");
			}
		$sSqlWrk = "SELECT `pes_id`, `pes_nama` AS `DispFld`, `kab_id` AS `Disp2Fld`, `kec_id` AS `Disp3Fld`, `desa_id` AS `Disp4Fld` FROM `peserta`";
		$sWhereWrk = "";
		$this->sos_peserta->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->sos_peserta, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `pes_id` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$this->sos_peserta->ViewValue = "";
				$ari = 0;
				while (!$rswrk->EOF) {
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('DispFld');
					$arwrk[2] = $rswrk->fields('Disp2Fld');
					$arwrk[3] = $rswrk->fields('Disp3Fld');
					$arwrk[4] = $rswrk->fields('Disp4Fld');
					$this->sos_peserta->ViewValue .= $this->sos_peserta->DisplayValue($arwrk);
					$rswrk->MoveNext();
					if (!$rswrk->EOF) $this->sos_peserta->ViewValue .= ew_ViewOptionSeparator($ari); // Separate Options
					$ari++;
				}
				$rswrk->Close();
			} else {
				$this->sos_peserta->ViewValue = $this->sos_peserta->CurrentValue;
			}
		} else {
			$this->sos_peserta->ViewValue = NULL;
		}
		$this->sos_peserta->CellCssStyle .= "text-align: left;";
		$this->sos_peserta->ViewCustomAttributes = "";

		// sos_prov
		if (strval($this->sos_prov->CurrentValue) <> "") {
			$sFilterWrk = "`prov_id`" . ew_SearchString("=", $this->sos_prov->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `prov_id`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `prov`";
		$sWhereWrk = "";
		$this->sos_prov->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->sos_prov, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `prov_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->sos_prov->ViewValue = $this->sos_prov->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->sos_prov->ViewValue = $this->sos_prov->CurrentValue;
			}
		} else {
			$this->sos_prov->ViewValue = NULL;
		}
		$this->sos_prov->ViewCustomAttributes = "";

		// sos_kab
		if (strval($this->sos_kab->CurrentValue) <> "") {
			$sFilterWrk = "`kab_id`" . ew_SearchString("=", $this->sos_kab->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `kab_id`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kab`";
		$sWhereWrk = "";
		$this->sos_kab->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->sos_kab, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `kab_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->sos_kab->ViewValue = $this->sos_kab->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->sos_kab->ViewValue = $this->sos_kab->CurrentValue;
			}
		} else {
			$this->sos_kab->ViewValue = NULL;
		}
		$this->sos_kab->ViewCustomAttributes = "";

		// sos_kec
		if (strval($this->sos_kec->CurrentValue) <> "") {
			$sFilterWrk = "`kec_id`" . ew_SearchString("=", $this->sos_kec->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `kec_id`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kec`";
		$sWhereWrk = "";
		$this->sos_kec->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->sos_kec, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `kec_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->sos_kec->ViewValue = $this->sos_kec->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->sos_kec->ViewValue = $this->sos_kec->CurrentValue;
			}
		} else {
			$this->sos_kec->ViewValue = NULL;
		}
		$this->sos_kec->ViewCustomAttributes = "";

		// sos_desa
		if (strval($this->sos_desa->CurrentValue) <> "") {
			$sFilterWrk = "`desa_id`" . ew_SearchString("=", $this->sos_desa->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `desa_id`, `desa_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `desa`";
		$sWhereWrk = "";
		$this->sos_desa->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->sos_desa, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `desa_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->sos_desa->ViewValue = $this->sos_desa->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->sos_desa->ViewValue = $this->sos_desa->CurrentValue;
			}
		} else {
			$this->sos_desa->ViewValue = NULL;
		}
		$this->sos_desa->ViewCustomAttributes = "";

		// sos_alamat
		$this->sos_alamat->ViewValue = $this->sos_alamat->CurrentValue;
		$this->sos_alamat->ViewCustomAttributes = "";

		// sos_pot_lahan
		$this->sos_pot_lahan->ViewValue = $this->sos_pot_lahan->CurrentValue;
		$this->sos_pot_lahan->CellCssStyle .= "text-align: right;";
		$this->sos_pot_lahan->ViewCustomAttributes = "";

		// sos_katinggian
		$this->sos_katinggian->ViewValue = $this->sos_katinggian->CurrentValue;
		$this->sos_katinggian->CellCssStyle .= "text-align: right;";
		$this->sos_katinggian->ViewCustomAttributes = "";

		// sos_biaya
		$this->sos_biaya->ViewValue = $this->sos_biaya->CurrentValue;
		$this->sos_biaya->ViewCustomAttributes = "";

		// sos_kesimpulan
		$this->sos_kesimpulan->ViewValue = $this->sos_kesimpulan->CurrentValue;
		$this->sos_kesimpulan->ViewCustomAttributes = "";

		// sos_foto
		$this->sos_foto->UploadPath = "foto_sosialisasi";
		if (!ew_Empty($this->sos_foto->Upload->DbValue)) {
			$this->sos_foto->ImageWidth = 80;
			$this->sos_foto->ImageHeight = 60;
			$this->sos_foto->ImageAlt = $this->sos_foto->FldAlt();
			$this->sos_foto->ViewValue = $this->sos_foto->Upload->DbValue;
		} else {
			$this->sos_foto->ViewValue = "";
		}
		$this->sos_foto->CellCssStyle .= "text-align: center;";
		$this->sos_foto->ViewCustomAttributes = "";

			// sos_id
			$this->sos_id->LinkCustomAttributes = "";
			$this->sos_id->HrefValue = "";
			$this->sos_id->TooltipValue = "";

			// sos_tgl
			$this->sos_tgl->LinkCustomAttributes = "";
			$this->sos_tgl->HrefValue = "";
			$this->sos_tgl->TooltipValue = "";

			// ts_id
			$this->ts_id->LinkCustomAttributes = "";
			$this->ts_id->HrefValue = "";
			$this->ts_id->TooltipValue = "";

			// sos_co
			$this->sos_co->LinkCustomAttributes = "";
			$this->sos_co->HrefValue = "";
			$this->sos_co->TooltipValue = "";

			// sos_peserta
			$this->sos_peserta->LinkCustomAttributes = "";
			$this->sos_peserta->HrefValue = "";
			$this->sos_peserta->TooltipValue = "";

			// sos_prov
			$this->sos_prov->LinkCustomAttributes = "";
			$this->sos_prov->HrefValue = "";
			$this->sos_prov->TooltipValue = "";

			// sos_kab
			$this->sos_kab->LinkCustomAttributes = "";
			$this->sos_kab->HrefValue = "";
			$this->sos_kab->TooltipValue = "";

			// sos_kec
			$this->sos_kec->LinkCustomAttributes = "";
			$this->sos_kec->HrefValue = "";
			$this->sos_kec->TooltipValue = "";

			// sos_desa
			$this->sos_desa->LinkCustomAttributes = "";
			$this->sos_desa->HrefValue = "";
			$this->sos_desa->TooltipValue = "";

			// sos_alamat
			$this->sos_alamat->LinkCustomAttributes = "";
			$this->sos_alamat->HrefValue = "";
			$this->sos_alamat->TooltipValue = "";

			// sos_pot_lahan
			$this->sos_pot_lahan->LinkCustomAttributes = "";
			$this->sos_pot_lahan->HrefValue = "";
			$this->sos_pot_lahan->TooltipValue = "";

			// sos_katinggian
			$this->sos_katinggian->LinkCustomAttributes = "";
			$this->sos_katinggian->HrefValue = "";
			$this->sos_katinggian->TooltipValue = "";

			// sos_biaya
			$this->sos_biaya->LinkCustomAttributes = "";
			$this->sos_biaya->HrefValue = "";
			$this->sos_biaya->TooltipValue = "";

			// sos_kesimpulan
			$this->sos_kesimpulan->LinkCustomAttributes = "";
			$this->sos_kesimpulan->HrefValue = "";
			$this->sos_kesimpulan->TooltipValue = "";

			// sos_foto
			$this->sos_foto->LinkCustomAttributes = "";
			$this->sos_foto->UploadPath = "foto_sosialisasi";
			if (!ew_Empty($this->sos_foto->Upload->DbValue)) {
				$this->sos_foto->HrefValue = "%u"; // Add prefix/suffix
				$this->sos_foto->LinkAttrs["target"] = ""; // Add target
				if ($this->Export <> "") $this->sos_foto->HrefValue = ew_FullUrl($this->sos_foto->HrefValue, "href");
			} else {
				$this->sos_foto->HrefValue = "";
			}
			$this->sos_foto->HrefValue2 = $this->sos_foto->UploadPath . $this->sos_foto->Upload->DbValue;
			$this->sos_foto->TooltipValue = "";
			if ($this->sos_foto->UseColorbox) {
				if (ew_Empty($this->sos_foto->TooltipValue))
					$this->sos_foto->LinkAttrs["title"] = $Language->Phrase("ViewImageGallery");
				$this->sos_foto->LinkAttrs["data-rel"] = "sosialisasi_x_sos_foto";
				ew_AppendClass($this->sos_foto->LinkAttrs["class"], "ewLightbox");
			}
		} elseif ($this->RowType == EW_ROWTYPE_EDIT) { // Edit row

			// sos_id
			$this->sos_id->EditAttrs["class"] = "form-control";
			$this->sos_id->EditCustomAttributes = "";
			$this->sos_id->EditValue = $this->sos_id->CurrentValue;
			$this->sos_id->ViewCustomAttributes = "";

			// sos_tgl
			$this->sos_tgl->EditAttrs["class"] = "form-control";
			$this->sos_tgl->EditCustomAttributes = "";
			$this->sos_tgl->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->sos_tgl->CurrentValue, 8));
			$this->sos_tgl->PlaceHolder = ew_RemoveHtml($this->sos_tgl->FldCaption());

			// ts_id
			$this->ts_id->EditCustomAttributes = "";
			if (trim(strval($this->ts_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`ts_id`" . ew_SearchString("=", $this->ts_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `ts_id`, `ts_judul` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `tema_sosialisasi`";
			$sWhereWrk = "";
			$this->ts_id->LookupFilters = array("dx1" => '`ts_judul`');
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->ts_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = ew_HtmlEncode($rswrk->fields('DispFld'));
				$this->ts_id->ViewValue = $this->ts_id->DisplayValue($arwrk);
			} else {
				$this->ts_id->ViewValue = $Language->Phrase("PleaseSelect");
			}
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->ts_id->EditValue = $arwrk;

			// sos_co
			$this->sos_co->EditAttrs["class"] = "form-control";
			$this->sos_co->EditCustomAttributes = "";
			if (trim(strval($this->sos_co->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`co_id`" . ew_SearchString("=", $this->sos_co->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `co_id`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `co`";
			$sWhereWrk = "";
			$this->sos_co->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->sos_co, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `co_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->sos_co->EditValue = $arwrk;

			// sos_peserta
			$this->sos_peserta->EditCustomAttributes = "";
			if (trim(strval($this->sos_peserta->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$arwrk = explode(",", $this->sos_peserta->CurrentValue);
				$sFilterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($sFilterWrk <> "") $sFilterWrk .= " OR ";
					$sFilterWrk .= "`pes_id`" . ew_SearchString("=", trim($wrk), EW_DATATYPE_NUMBER, "");
				}
			}
			$sSqlWrk = "SELECT `pes_id`, `pes_nama` AS `DispFld`, `kab_id` AS `Disp2Fld`, `kec_id` AS `Disp3Fld`, `desa_id` AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `peserta`";
			$sWhereWrk = "";
			$this->sos_peserta->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->sos_peserta, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `pes_id` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$this->sos_peserta->ViewValue = "";
				$ari = 0;
				while (!$rswrk->EOF) {
					$arwrk = array();
					$arwrk[1] = ew_HtmlEncode($rswrk->fields('DispFld'));
					$arwrk[2] = ew_HtmlEncode($rswrk->fields('Disp2Fld'));
					$arwrk[3] = ew_HtmlEncode($rswrk->fields('Disp3Fld'));
					$arwrk[4] = ew_HtmlEncode($rswrk->fields('Disp4Fld'));
					$this->sos_peserta->ViewValue .= $this->sos_peserta->DisplayValue($arwrk);
					$rswrk->MoveNext();
					if (!$rswrk->EOF) $this->sos_peserta->ViewValue .= ew_ViewOptionSeparator($ari); // Separate Options
					$ari++;
				}
				$rswrk->MoveFirst();
			} else {
				$this->sos_peserta->ViewValue = $Language->Phrase("PleaseSelect");
			}
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->sos_peserta->EditValue = $arwrk;

			// sos_prov
			$this->sos_prov->EditAttrs["class"] = "form-control";
			$this->sos_prov->EditCustomAttributes = "";
			if (trim(strval($this->sos_prov->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`prov_id`" . ew_SearchString("=", $this->sos_prov->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `prov_id`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `prov`";
			$sWhereWrk = "";
			$this->sos_prov->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->sos_prov, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `prov_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->sos_prov->EditValue = $arwrk;

			// sos_kab
			$this->sos_kab->EditAttrs["class"] = "form-control";
			$this->sos_kab->EditCustomAttributes = "";
			if (trim(strval($this->sos_kab->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`kab_id`" . ew_SearchString("=", $this->sos_kab->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `kab_id`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, `kab_prov_id` AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `kab`";
			$sWhereWrk = "";
			$this->sos_kab->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->sos_kab, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `kab_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->sos_kab->EditValue = $arwrk;

			// sos_kec
			$this->sos_kec->EditAttrs["class"] = "form-control";
			$this->sos_kec->EditCustomAttributes = "";
			if (trim(strval($this->sos_kec->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`kec_id`" . ew_SearchString("=", $this->sos_kec->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `kec_id`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, `kec_prov_id` AS `SelectFilterFld`, `kec_kab_id` AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `kec`";
			$sWhereWrk = "";
			$this->sos_kec->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->sos_kec, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `kec_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->sos_kec->EditValue = $arwrk;

			// sos_desa
			$this->sos_desa->EditAttrs["class"] = "form-control";
			$this->sos_desa->EditCustomAttributes = "";
			if (trim(strval($this->sos_desa->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`desa_id`" . ew_SearchString("=", $this->sos_desa->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `desa_id`, `desa_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, `desa_prov_id` AS `SelectFilterFld`, `desa_kab_id` AS `SelectFilterFld2`, `desa_kec_id` AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `desa`";
			$sWhereWrk = "";
			$this->sos_desa->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->sos_desa, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `desa_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->sos_desa->EditValue = $arwrk;

			// sos_alamat
			$this->sos_alamat->EditAttrs["class"] = "form-control";
			$this->sos_alamat->EditCustomAttributes = "";
			$this->sos_alamat->EditValue = ew_HtmlEncode($this->sos_alamat->CurrentValue);
			$this->sos_alamat->PlaceHolder = ew_RemoveHtml($this->sos_alamat->FldCaption());

			// sos_pot_lahan
			$this->sos_pot_lahan->EditAttrs["class"] = "form-control";
			$this->sos_pot_lahan->EditCustomAttributes = "";
			$this->sos_pot_lahan->EditValue = ew_HtmlEncode($this->sos_pot_lahan->CurrentValue);
			$this->sos_pot_lahan->PlaceHolder = ew_RemoveHtml($this->sos_pot_lahan->FldCaption());

			// sos_katinggian
			$this->sos_katinggian->EditAttrs["class"] = "form-control";
			$this->sos_katinggian->EditCustomAttributes = "";
			$this->sos_katinggian->EditValue = ew_HtmlEncode($this->sos_katinggian->CurrentValue);
			$this->sos_katinggian->PlaceHolder = ew_RemoveHtml($this->sos_katinggian->FldCaption());

			// sos_biaya
			$this->sos_biaya->EditAttrs["class"] = "form-control";
			$this->sos_biaya->EditCustomAttributes = "";
			$this->sos_biaya->EditValue = ew_HtmlEncode($this->sos_biaya->CurrentValue);
			$this->sos_biaya->PlaceHolder = ew_RemoveHtml($this->sos_biaya->FldCaption());

			// sos_kesimpulan
			$this->sos_kesimpulan->EditAttrs["class"] = "form-control";
			$this->sos_kesimpulan->EditCustomAttributes = "";
			$this->sos_kesimpulan->EditValue = ew_HtmlEncode($this->sos_kesimpulan->CurrentValue);
			$this->sos_kesimpulan->PlaceHolder = ew_RemoveHtml($this->sos_kesimpulan->FldCaption());

			// sos_foto
			$this->sos_foto->EditAttrs["class"] = "form-control";
			$this->sos_foto->EditCustomAttributes = "";
			$this->sos_foto->UploadPath = "foto_sosialisasi";
			if (!ew_Empty($this->sos_foto->Upload->DbValue)) {
				$this->sos_foto->ImageWidth = 80;
				$this->sos_foto->ImageHeight = 60;
				$this->sos_foto->ImageAlt = $this->sos_foto->FldAlt();
				$this->sos_foto->EditValue = $this->sos_foto->Upload->DbValue;
			} else {
				$this->sos_foto->EditValue = "";
			}
			if (!ew_Empty($this->sos_foto->CurrentValue))
					$this->sos_foto->Upload->FileName = $this->sos_foto->CurrentValue;
			if ($this->CurrentAction == "I" && !$this->EventCancelled) ew_RenderUploadField($this->sos_foto);

			// Edit refer script
			// sos_id

			$this->sos_id->LinkCustomAttributes = "";
			$this->sos_id->HrefValue = "";

			// sos_tgl
			$this->sos_tgl->LinkCustomAttributes = "";
			$this->sos_tgl->HrefValue = "";

			// ts_id
			$this->ts_id->LinkCustomAttributes = "";
			$this->ts_id->HrefValue = "";

			// sos_co
			$this->sos_co->LinkCustomAttributes = "";
			$this->sos_co->HrefValue = "";

			// sos_peserta
			$this->sos_peserta->LinkCustomAttributes = "";
			$this->sos_peserta->HrefValue = "";

			// sos_prov
			$this->sos_prov->LinkCustomAttributes = "";
			$this->sos_prov->HrefValue = "";

			// sos_kab
			$this->sos_kab->LinkCustomAttributes = "";
			$this->sos_kab->HrefValue = "";

			// sos_kec
			$this->sos_kec->LinkCustomAttributes = "";
			$this->sos_kec->HrefValue = "";

			// sos_desa
			$this->sos_desa->LinkCustomAttributes = "";
			$this->sos_desa->HrefValue = "";

			// sos_alamat
			$this->sos_alamat->LinkCustomAttributes = "";
			$this->sos_alamat->HrefValue = "";

			// sos_pot_lahan
			$this->sos_pot_lahan->LinkCustomAttributes = "";
			$this->sos_pot_lahan->HrefValue = "";

			// sos_katinggian
			$this->sos_katinggian->LinkCustomAttributes = "";
			$this->sos_katinggian->HrefValue = "";

			// sos_biaya
			$this->sos_biaya->LinkCustomAttributes = "";
			$this->sos_biaya->HrefValue = "";

			// sos_kesimpulan
			$this->sos_kesimpulan->LinkCustomAttributes = "";
			$this->sos_kesimpulan->HrefValue = "";

			// sos_foto
			$this->sos_foto->LinkCustomAttributes = "";
			$this->sos_foto->UploadPath = "foto_sosialisasi";
			if (!ew_Empty($this->sos_foto->Upload->DbValue)) {
				$this->sos_foto->HrefValue = "%u"; // Add prefix/suffix
				$this->sos_foto->LinkAttrs["target"] = ""; // Add target
				if ($this->Export <> "") $this->sos_foto->HrefValue = ew_FullUrl($this->sos_foto->HrefValue, "href");
			} else {
				$this->sos_foto->HrefValue = "";
			}
			$this->sos_foto->HrefValue2 = $this->sos_foto->UploadPath . $this->sos_foto->Upload->DbValue;
		}
		if ($this->RowType == EW_ROWTYPE_ADD || $this->RowType == EW_ROWTYPE_EDIT || $this->RowType == EW_ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->SetupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $Language, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return ($gsFormError == "");
		if (!$this->sos_tgl->FldIsDetailKey && !is_null($this->sos_tgl->FormValue) && $this->sos_tgl->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->sos_tgl->FldCaption(), $this->sos_tgl->ReqErrMsg));
		}
		if (!ew_CheckDateDef($this->sos_tgl->FormValue)) {
			ew_AddMessage($gsFormError, $this->sos_tgl->FldErrMsg());
		}
		if (!$this->sos_co->FldIsDetailKey && !is_null($this->sos_co->FormValue) && $this->sos_co->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->sos_co->FldCaption(), $this->sos_co->ReqErrMsg));
		}
		if (!ew_CheckInteger($this->sos_pot_lahan->FormValue)) {
			ew_AddMessage($gsFormError, $this->sos_pot_lahan->FldErrMsg());
		}
		if (!ew_CheckInteger($this->sos_katinggian->FormValue)) {
			ew_AddMessage($gsFormError, $this->sos_katinggian->FldErrMsg());
		}
		if (!ew_CheckInteger($this->sos_biaya->FormValue)) {
			ew_AddMessage($gsFormError, $this->sos_biaya->FldErrMsg());
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsFormError, $sFormCustomError);
		}
		return $ValidateForm;
	}

	// Update record based on key values
	function EditRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();
		$sFilter = $this->ApplyUserIDFilters($sFilter);
		$conn = &$this->Connection();
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
		$rs = $conn->Execute($sSql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->Phrase("NoRecord")); // Set no record message
			$EditRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->LoadDbValues($rsold);
			$this->sos_foto->OldUploadPath = "foto_sosialisasi";
			$this->sos_foto->UploadPath = $this->sos_foto->OldUploadPath;
			$rsnew = array();

			// sos_tgl
			$this->sos_tgl->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->sos_tgl->CurrentValue, 0), NULL, $this->sos_tgl->ReadOnly);

			// ts_id
			$this->ts_id->SetDbValueDef($rsnew, $this->ts_id->CurrentValue, NULL, $this->ts_id->ReadOnly);

			// sos_co
			$this->sos_co->SetDbValueDef($rsnew, $this->sos_co->CurrentValue, NULL, $this->sos_co->ReadOnly);

			// sos_peserta
			$this->sos_peserta->SetDbValueDef($rsnew, $this->sos_peserta->CurrentValue, NULL, $this->sos_peserta->ReadOnly);

			// sos_prov
			$this->sos_prov->SetDbValueDef($rsnew, $this->sos_prov->CurrentValue, NULL, $this->sos_prov->ReadOnly);

			// sos_kab
			$this->sos_kab->SetDbValueDef($rsnew, $this->sos_kab->CurrentValue, NULL, $this->sos_kab->ReadOnly);

			// sos_kec
			$this->sos_kec->SetDbValueDef($rsnew, $this->sos_kec->CurrentValue, NULL, $this->sos_kec->ReadOnly);

			// sos_desa
			$this->sos_desa->SetDbValueDef($rsnew, $this->sos_desa->CurrentValue, NULL, $this->sos_desa->ReadOnly);

			// sos_alamat
			$this->sos_alamat->SetDbValueDef($rsnew, $this->sos_alamat->CurrentValue, NULL, $this->sos_alamat->ReadOnly);

			// sos_pot_lahan
			$this->sos_pot_lahan->SetDbValueDef($rsnew, $this->sos_pot_lahan->CurrentValue, NULL, $this->sos_pot_lahan->ReadOnly);

			// sos_katinggian
			$this->sos_katinggian->SetDbValueDef($rsnew, $this->sos_katinggian->CurrentValue, NULL, $this->sos_katinggian->ReadOnly);

			// sos_biaya
			$this->sos_biaya->SetDbValueDef($rsnew, $this->sos_biaya->CurrentValue, NULL, $this->sos_biaya->ReadOnly);

			// sos_kesimpulan
			$this->sos_kesimpulan->SetDbValueDef($rsnew, $this->sos_kesimpulan->CurrentValue, NULL, $this->sos_kesimpulan->ReadOnly);

			// sos_foto
			if ($this->sos_foto->Visible && !$this->sos_foto->ReadOnly && !$this->sos_foto->Upload->KeepFile) {
				$this->sos_foto->Upload->DbValue = $rsold['sos_foto']; // Get original value
				if ($this->sos_foto->Upload->FileName == "") {
					$rsnew['sos_foto'] = NULL;
				} else {
					$rsnew['sos_foto'] = $this->sos_foto->Upload->FileName;
				}
				$this->sos_foto->ImageWidth = 800; // Resize width
				$this->sos_foto->ImageHeight = 600; // Resize height
			}
			if ($this->sos_foto->Visible && !$this->sos_foto->Upload->KeepFile) {
				$this->sos_foto->UploadPath = "foto_sosialisasi";
				$OldFiles = ew_Empty($this->sos_foto->Upload->DbValue) ? array() : explode(EW_MULTIPLE_UPLOAD_SEPARATOR, strval($this->sos_foto->Upload->DbValue));
				if (!ew_Empty($this->sos_foto->Upload->FileName)) {
					$NewFiles = explode(EW_MULTIPLE_UPLOAD_SEPARATOR, strval($this->sos_foto->Upload->FileName));
					$NewFileCount = count($NewFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						$fldvar = ($this->sos_foto->Upload->Index < 0) ? $this->sos_foto->FldVar : substr($this->sos_foto->FldVar, 0, 1) . $this->sos_foto->Upload->Index . substr($this->sos_foto->FldVar, 1);
						if ($NewFiles[$i] <> "") {
							$file = $NewFiles[$i];
							if (file_exists(ew_UploadTempPath($fldvar, $this->sos_foto->TblVar) . $file)) {
								$OldFileFound = FALSE;
								$OldFileCount = count($OldFiles);
								for ($j = 0; $j < $OldFileCount; $j++) {
									$file1 = $OldFiles[$j];
									if ($file1 == $file) { // Old file found, no need to delete anymore
										unset($OldFiles[$j]);
										$OldFileFound = TRUE;
										break;
									}
								}
								if ($OldFileFound) // No need to check if file exists further
									continue;
								$file1 = ew_UploadFileNameEx($this->sos_foto->PhysicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(ew_UploadTempPath($fldvar, $this->sos_foto->TblVar) . $file1) || file_exists($this->sos_foto->PhysicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = ew_UniqueFilename($this->sos_foto->PhysicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(ew_UploadTempPath($fldvar, $this->sos_foto->TblVar) . $file, ew_UploadTempPath($fldvar, $this->sos_foto->TblVar) . $file1);
									$NewFiles[$i] = $file1;
								}
							}
						}
					}
					$this->sos_foto->Upload->DbValue = empty($OldFiles) ? "" : implode(EW_MULTIPLE_UPLOAD_SEPARATOR, $OldFiles);
					$this->sos_foto->Upload->FileName = implode(EW_MULTIPLE_UPLOAD_SEPARATOR, $NewFiles);
					$this->sos_foto->SetDbValueDef($rsnew, $this->sos_foto->Upload->FileName, NULL, $this->sos_foto->ReadOnly);
				}
			}

			// Call Row Updating event
			$bUpdateRow = $this->Row_Updating($rsold, $rsnew);
			if ($bUpdateRow) {
				$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
				if (count($rsnew) > 0)
					$EditRow = $this->Update($rsnew, "", $rsold);
				else
					$EditRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($EditRow) {
					if ($this->sos_foto->Visible && !$this->sos_foto->Upload->KeepFile) {
						$OldFiles = ew_Empty($this->sos_foto->Upload->DbValue) ? array() : explode(EW_MULTIPLE_UPLOAD_SEPARATOR, strval($this->sos_foto->Upload->DbValue));
						if (!ew_Empty($this->sos_foto->Upload->FileName)) {
							$NewFiles = explode(EW_MULTIPLE_UPLOAD_SEPARATOR, $this->sos_foto->Upload->FileName);
							$NewFiles2 = explode(EW_MULTIPLE_UPLOAD_SEPARATOR, $rsnew['sos_foto']);
							$NewFileCount = count($NewFiles);
							for ($i = 0; $i < $NewFileCount; $i++) {
								$fldvar = ($this->sos_foto->Upload->Index < 0) ? $this->sos_foto->FldVar : substr($this->sos_foto->FldVar, 0, 1) . $this->sos_foto->Upload->Index . substr($this->sos_foto->FldVar, 1);
								if ($NewFiles[$i] <> "") {
									$file = ew_UploadTempPath($fldvar, $this->sos_foto->TblVar) . $NewFiles[$i];
									if (file_exists($file)) {
										if (@$NewFiles2[$i] <> "") // Use correct file name
											$NewFiles[$i] = $NewFiles2[$i];
										if (!$this->sos_foto->Upload->ResizeAndSaveToFile($this->sos_foto->ImageWidth, $this->sos_foto->ImageHeight, EW_THUMBNAIL_DEFAULT_QUALITY, $NewFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->Phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$NewFiles = array();
						}
						$OldFileCount = count($OldFiles);
						for ($i = 0; $i < $OldFileCount; $i++) {
							if ($OldFiles[$i] <> "" && !in_array($OldFiles[$i], $NewFiles))
								@unlink($this->sos_foto->OldPhysicalUploadPath() . $OldFiles[$i]);
						}
					}
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->Phrase("UpdateCancelled"));
				}
				$EditRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($EditRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->Close();

		// sos_foto
		ew_CleanUploadTempPath($this->sos_foto, $this->sos_foto->Upload->Index);
		return $EditRow;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$Breadcrumb->Add("list", $this->TableVar, $this->AddMasterUrl("sosialisasilist.php"), "", $this->TableVar, TRUE);
		$PageId = "edit";
		$Breadcrumb->Add("edit", $PageId, $url);
	}

	// Setup lookup filters of a field
	function SetupLookupFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		case "x_ts_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `ts_id` AS `LinkFld`, `ts_judul` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tema_sosialisasi`";
			$sWhereWrk = "{filter}";
			$fld->LookupFilters = array("dx1" => '`ts_judul`');
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`ts_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->ts_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_sos_co":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `co_id` AS `LinkFld`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `co`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`co_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->sos_co, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `co_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_sos_peserta":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `pes_id` AS `LinkFld`, `pes_nama` AS `DispFld`, `kab_id` AS `Disp2Fld`, `kec_id` AS `Disp3Fld`, `desa_id` AS `Disp4Fld` FROM `peserta`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`pes_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->sos_peserta, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `pes_id` DESC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_sos_prov":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `prov_id` AS `LinkFld`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `prov`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`prov_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->sos_prov, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `prov_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_sos_kab":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `kab_id` AS `LinkFld`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kab`";
			$sWhereWrk = "{filter}";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`kab_id` IN ({filter_value})', "t0" => "3", "fn0" => "", "f1" => '`kab_prov_id` IN ({filter_value})', "t1" => "3", "fn1" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->sos_kab, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `kab_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_sos_kec":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `kec_id` AS `LinkFld`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kec`";
			$sWhereWrk = "{filter}";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`kec_id` IN ({filter_value})', "t0" => "3", "fn0" => "", "f1" => '`kec_prov_id` IN ({filter_value})', "t1" => "3", "fn1" => "", "f2" => '`kec_kab_id` IN ({filter_value})', "t2" => "3", "fn2" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->sos_kec, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `kec_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_sos_desa":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `desa_id` AS `LinkFld`, `desa_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `desa`";
			$sWhereWrk = "{filter}";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`desa_id` IN ({filter_value})', "t0" => "3", "fn0" => "", "f1" => '`desa_prov_id` IN ({filter_value})', "t1" => "3", "fn1" => "", "f2" => '`desa_kab_id` IN ({filter_value})', "t2" => "3", "fn2" => "", "f3" => '`desa_kec_id` IN ({filter_value})', "t3" => "3", "fn3" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->sos_desa, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `desa_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		}
	}

	// Setup AutoSuggest filters of a field
	function SetupAutoSuggestFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($sosialisasi_edit)) $sosialisasi_edit = new csosialisasi_edit();

// Page init
$sosialisasi_edit->Page_Init();

// Page main
$sosialisasi_edit->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sosialisasi_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "edit";
var CurrentForm = fsosialisasiedit = new ew_Form("fsosialisasiedit", "edit");

// Validate form
fsosialisasiedit.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);
	if ($fobj.find("#a_confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.FormKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = $fobj.find("#a_list").val() == "gridinsert";
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
			elm = this.GetElements("x" + infix + "_sos_tgl");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $sosialisasi->sos_tgl->FldCaption(), $sosialisasi->sos_tgl->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_sos_tgl");
			if (elm && !ew_CheckDateDef(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($sosialisasi->sos_tgl->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_sos_co");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $sosialisasi->sos_co->FldCaption(), $sosialisasi->sos_co->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_sos_pot_lahan");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($sosialisasi->sos_pot_lahan->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_sos_katinggian");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($sosialisasi->sos_katinggian->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_sos_biaya");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($sosialisasi->sos_biaya->FldErrMsg()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ewForms[val])
			if (!ewForms[val].Validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fsosialisasiedit.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fsosialisasiedit.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsosialisasiedit.Lists["x_ts_id"] = {"LinkField":"x_ts_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_ts_judul","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"tema_sosialisasi"};
fsosialisasiedit.Lists["x_ts_id"].Data = "<?php echo $sosialisasi_edit->ts_id->LookupFilterQuery(FALSE, "edit") ?>";
fsosialisasiedit.Lists["x_sos_co"] = {"LinkField":"x_co_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_co_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"co"};
fsosialisasiedit.Lists["x_sos_co"].Data = "<?php echo $sosialisasi_edit->sos_co->LookupFilterQuery(FALSE, "edit") ?>";
fsosialisasiedit.Lists["x_sos_peserta[]"] = {"LinkField":"x_pes_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_pes_nama","x_kab_id","x_kec_id","x_desa_id"],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"peserta"};
fsosialisasiedit.Lists["x_sos_peserta[]"].Data = "<?php echo $sosialisasi_edit->sos_peserta->LookupFilterQuery(FALSE, "edit") ?>";
fsosialisasiedit.Lists["x_sos_prov"] = {"LinkField":"x_prov_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_prov_nama","","",""],"ParentFields":[],"ChildFields":["x_sos_kab","x_sos_kec","x_sos_desa"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"prov"};
fsosialisasiedit.Lists["x_sos_prov"].Data = "<?php echo $sosialisasi_edit->sos_prov->LookupFilterQuery(FALSE, "edit") ?>";
fsosialisasiedit.Lists["x_sos_kab"] = {"LinkField":"x_kab_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kab_nama","","",""],"ParentFields":["x_sos_prov"],"ChildFields":["x_sos_kec","x_sos_desa"],"FilterFields":["x_kab_prov_id"],"Options":[],"Template":"","LinkTable":"kab"};
fsosialisasiedit.Lists["x_sos_kab"].Data = "<?php echo $sosialisasi_edit->sos_kab->LookupFilterQuery(FALSE, "edit") ?>";
fsosialisasiedit.Lists["x_sos_kec"] = {"LinkField":"x_kec_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kec_nama","","",""],"ParentFields":["x_sos_prov","x_sos_kab"],"ChildFields":["x_sos_desa"],"FilterFields":["x_kec_prov_id","x_kec_kab_id"],"Options":[],"Template":"","LinkTable":"kec"};
fsosialisasiedit.Lists["x_sos_kec"].Data = "<?php echo $sosialisasi_edit->sos_kec->LookupFilterQuery(FALSE, "edit") ?>";
fsosialisasiedit.Lists["x_sos_desa"] = {"LinkField":"x_desa_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_desa_nama","","",""],"ParentFields":["x_sos_prov","x_sos_kab","x_sos_kec"],"ChildFields":[],"FilterFields":["x_desa_prov_id","x_desa_kab_id","x_desa_kec_id"],"Options":[],"Template":"","LinkTable":"desa"};
fsosialisasiedit.Lists["x_sos_desa"].Data = "<?php echo $sosialisasi_edit->sos_desa->LookupFilterQuery(FALSE, "edit") ?>";

// Form object for search
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php $sosialisasi_edit->ShowPageHeader(); ?>
<?php
$sosialisasi_edit->ShowMessage();
?>
<form name="fsosialisasiedit" id="fsosialisasiedit" class="<?php echo $sosialisasi_edit->FormClassName ?>" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($sosialisasi_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $sosialisasi_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sosialisasi">
<input type="hidden" name="a_edit" id="a_edit" value="U">
<input type="hidden" name="modal" value="<?php echo intval($sosialisasi_edit->IsModal) ?>">
<div class="ewEditDiv"><!-- page* -->
<?php if ($sosialisasi->sos_id->Visible) { // sos_id ?>
	<div id="r_sos_id" class="form-group">
		<label id="elh_sosialisasi_sos_id" class="<?php echo $sosialisasi_edit->LeftColumnClass ?>"><?php echo $sosialisasi->sos_id->FldCaption() ?></label>
		<div class="<?php echo $sosialisasi_edit->RightColumnClass ?>"><div<?php echo $sosialisasi->sos_id->CellAttributes() ?>>
<span id="el_sosialisasi_sos_id">
<span<?php echo $sosialisasi->sos_id->ViewAttributes() ?>>
<p class="form-control-static"><?php echo $sosialisasi->sos_id->EditValue ?></p></span>
</span>
<input type="hidden" data-table="sosialisasi" data-field="x_sos_id" name="x_sos_id" id="x_sos_id" value="<?php echo ew_HtmlEncode($sosialisasi->sos_id->CurrentValue) ?>">
<?php echo $sosialisasi->sos_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sosialisasi->sos_tgl->Visible) { // sos_tgl ?>
	<div id="r_sos_tgl" class="form-group">
		<label id="elh_sosialisasi_sos_tgl" for="x_sos_tgl" class="<?php echo $sosialisasi_edit->LeftColumnClass ?>"><?php echo $sosialisasi->sos_tgl->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $sosialisasi_edit->RightColumnClass ?>"><div<?php echo $sosialisasi->sos_tgl->CellAttributes() ?>>
<span id="el_sosialisasi_sos_tgl">
<input type="text" data-table="sosialisasi" data-field="x_sos_tgl" name="x_sos_tgl" id="x_sos_tgl" placeholder="<?php echo ew_HtmlEncode($sosialisasi->sos_tgl->getPlaceHolder()) ?>" value="<?php echo $sosialisasi->sos_tgl->EditValue ?>"<?php echo $sosialisasi->sos_tgl->EditAttributes() ?>>
<?php if (!$sosialisasi->sos_tgl->ReadOnly && !$sosialisasi->sos_tgl->Disabled && !isset($sosialisasi->sos_tgl->EditAttrs["readonly"]) && !isset($sosialisasi->sos_tgl->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("fsosialisasiedit", "x_sos_tgl", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $sosialisasi->sos_tgl->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sosialisasi->ts_id->Visible) { // ts_id ?>
	<div id="r_ts_id" class="form-group">
		<label id="elh_sosialisasi_ts_id" for="x_ts_id" class="<?php echo $sosialisasi_edit->LeftColumnClass ?>"><?php echo $sosialisasi->ts_id->FldCaption() ?></label>
		<div class="<?php echo $sosialisasi_edit->RightColumnClass ?>"><div<?php echo $sosialisasi->ts_id->CellAttributes() ?>>
<span id="el_sosialisasi_ts_id">
<span class="ewLookupList">
	<span onclick="jQuery(this).parent().next(":not([disabled])").click();" tabindex="-1" class="form-control ewLookupText" id="lu_x_ts_id"><?php echo (strval($sosialisasi->ts_id->ViewValue) == "" ? $Language->Phrase("PleaseSelect") : $sosialisasi->ts_id->ViewValue); ?></span>
</span>
<button type="button" title="<?php echo ew_HtmlEncode(str_replace("%s", ew_RemoveHtml($sosialisasi->ts_id->FldCaption()), $Language->Phrase("LookupLink", TRUE))) ?>" onclick="ew_ModalLookupShow({lnk:this,el:'x_ts_id',m:0,n:10});" class="ewLookupBtn btn btn-default btn-sm"<?php echo (($sosialisasi->ts_id->ReadOnly || $sosialisasi->ts_id->Disabled) ? " disabled" : "")?>><span class="glyphicon glyphicon-search ewIcon"></span></button>
<input type="hidden" data-table="sosialisasi" data-field="x_ts_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $sosialisasi->ts_id->DisplayValueSeparatorAttribute() ?>" name="x_ts_id" id="x_ts_id" value="<?php echo $sosialisasi->ts_id->CurrentValue ?>"<?php echo $sosialisasi->ts_id->EditAttributes() ?>>
</span>
<?php echo $sosialisasi->ts_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sosialisasi->sos_co->Visible) { // sos_co ?>
	<div id="r_sos_co" class="form-group">
		<label id="elh_sosialisasi_sos_co" for="x_sos_co" class="<?php echo $sosialisasi_edit->LeftColumnClass ?>"><?php echo $sosialisasi->sos_co->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $sosialisasi_edit->RightColumnClass ?>"><div<?php echo $sosialisasi->sos_co->CellAttributes() ?>>
<span id="el_sosialisasi_sos_co">
<select data-table="sosialisasi" data-field="x_sos_co" data-value-separator="<?php echo $sosialisasi->sos_co->DisplayValueSeparatorAttribute() ?>" id="x_sos_co" name="x_sos_co"<?php echo $sosialisasi->sos_co->EditAttributes() ?>>
<?php echo $sosialisasi->sos_co->SelectOptionListHtml("x_sos_co") ?>
</select>
</span>
<?php echo $sosialisasi->sos_co->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sosialisasi->sos_peserta->Visible) { // sos_peserta ?>
	<div id="r_sos_peserta" class="form-group">
		<label id="elh_sosialisasi_sos_peserta" for="x_sos_peserta" class="<?php echo $sosialisasi_edit->LeftColumnClass ?>"><?php echo $sosialisasi->sos_peserta->FldCaption() ?></label>
		<div class="<?php echo $sosialisasi_edit->RightColumnClass ?>"><div<?php echo $sosialisasi->sos_peserta->CellAttributes() ?>>
<span id="el_sosialisasi_sos_peserta">
<div class="ewDropdownList has-feedback">
	<span onclick="" class="form-control dropdown-toggle" aria-expanded="false"<?php if ($sosialisasi->sos_peserta->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>>
		<?php echo $sosialisasi->sos_peserta->ViewValue ?>
	</span>
	<?php if (!$sosialisasi->sos_peserta->ReadOnly) { ?>
	<span class="glyphicon glyphicon-remove form-control-feedback ewDropdownListClear"></span>
	<span class="form-control-feedback"><span class="caret"></span></span>
	<?php } ?>
	<div id="dsl_x_sos_peserta" data-repeatcolumn="1" class="dropdown-menu">
		<div class="ewItems" style="position: relative; overflow-x: hidden;">
<?php echo $sosialisasi->sos_peserta->CheckBoxListHtml(TRUE, "x_sos_peserta[]") ?>
		</div>
	</div>
	<div id="tp_x_sos_peserta" class="ewTemplate"><input type="checkbox" data-table="sosialisasi" data-field="x_sos_peserta" data-value-separator="<?php echo $sosialisasi->sos_peserta->DisplayValueSeparatorAttribute() ?>" name="x_sos_peserta[]" id="x_sos_peserta[]" value="{value}"<?php echo $sosialisasi->sos_peserta->EditAttributes() ?>></div>
</div>
<?php if (AllowAdd(CurrentProjectID() . "peserta") && !$sosialisasi->sos_peserta->ReadOnly) { ?>
<button type="button" title="<?php echo ew_HtmlTitle($Language->Phrase("AddLink")) . "&nbsp;" . $sosialisasi->sos_peserta->FldCaption() ?>" onclick="ew_AddOptDialogShow({lnk:this,el:'x_sos_peserta[]',url:'pesertaaddopt.php'});" class="ewAddOptBtn btn btn-default btn-sm" id="aol_x_sos_peserta"><span class="glyphicon glyphicon-plus ewIcon"></span><span class="hide"><?php echo $Language->Phrase("AddLink") ?>&nbsp;<?php echo $sosialisasi->sos_peserta->FldCaption() ?></span></button>
<?php } ?>
</span>
<?php echo $sosialisasi->sos_peserta->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sosialisasi->sos_prov->Visible) { // sos_prov ?>
	<div id="r_sos_prov" class="form-group">
		<label id="elh_sosialisasi_sos_prov" for="x_sos_prov" class="<?php echo $sosialisasi_edit->LeftColumnClass ?>"><?php echo $sosialisasi->sos_prov->FldCaption() ?></label>
		<div class="<?php echo $sosialisasi_edit->RightColumnClass ?>"><div<?php echo $sosialisasi->sos_prov->CellAttributes() ?>>
<span id="el_sosialisasi_sos_prov">
<?php $sosialisasi->sos_prov->EditAttrs["onchange"] = "ew_UpdateOpt.call(this); " . @$sosialisasi->sos_prov->EditAttrs["onchange"]; ?>
<select data-table="sosialisasi" data-field="x_sos_prov" data-value-separator="<?php echo $sosialisasi->sos_prov->DisplayValueSeparatorAttribute() ?>" id="x_sos_prov" name="x_sos_prov"<?php echo $sosialisasi->sos_prov->EditAttributes() ?>>
<?php echo $sosialisasi->sos_prov->SelectOptionListHtml("x_sos_prov") ?>
</select>
<?php if (AllowAdd(CurrentProjectID() . "prov") && !$sosialisasi->sos_prov->ReadOnly) { ?>
<button type="button" title="<?php echo ew_HtmlTitle($Language->Phrase("AddLink")) . "&nbsp;" . $sosialisasi->sos_prov->FldCaption() ?>" onclick="ew_AddOptDialogShow({lnk:this,el:'x_sos_prov',url:'provaddopt.php'});" class="ewAddOptBtn btn btn-default btn-sm" id="aol_x_sos_prov"><span class="glyphicon glyphicon-plus ewIcon"></span><span class="hide"><?php echo $Language->Phrase("AddLink") ?>&nbsp;<?php echo $sosialisasi->sos_prov->FldCaption() ?></span></button>
<?php } ?>
</span>
<?php echo $sosialisasi->sos_prov->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sosialisasi->sos_kab->Visible) { // sos_kab ?>
	<div id="r_sos_kab" class="form-group">
		<label id="elh_sosialisasi_sos_kab" for="x_sos_kab" class="<?php echo $sosialisasi_edit->LeftColumnClass ?>"><?php echo $sosialisasi->sos_kab->FldCaption() ?></label>
		<div class="<?php echo $sosialisasi_edit->RightColumnClass ?>"><div<?php echo $sosialisasi->sos_kab->CellAttributes() ?>>
<span id="el_sosialisasi_sos_kab">
<?php $sosialisasi->sos_kab->EditAttrs["onchange"] = "ew_UpdateOpt.call(this); " . @$sosialisasi->sos_kab->EditAttrs["onchange"]; ?>
<select data-table="sosialisasi" data-field="x_sos_kab" data-value-separator="<?php echo $sosialisasi->sos_kab->DisplayValueSeparatorAttribute() ?>" id="x_sos_kab" name="x_sos_kab"<?php echo $sosialisasi->sos_kab->EditAttributes() ?>>
<?php echo $sosialisasi->sos_kab->SelectOptionListHtml("x_sos_kab") ?>
</select>
<?php if (AllowAdd(CurrentProjectID() . "kab") && !$sosialisasi->sos_kab->ReadOnly) { ?>
<button type="button" title="<?php echo ew_HtmlTitle($Language->Phrase("AddLink")) . "&nbsp;" . $sosialisasi->sos_kab->FldCaption() ?>" onclick="ew_AddOptDialogShow({lnk:this,el:'x_sos_kab',url:'kabaddopt.php'});" class="ewAddOptBtn btn btn-default btn-sm" id="aol_x_sos_kab"><span class="glyphicon glyphicon-plus ewIcon"></span><span class="hide"><?php echo $Language->Phrase("AddLink") ?>&nbsp;<?php echo $sosialisasi->sos_kab->FldCaption() ?></span></button>
<?php } ?>
</span>
<?php echo $sosialisasi->sos_kab->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sosialisasi->sos_kec->Visible) { // sos_kec ?>
	<div id="r_sos_kec" class="form-group">
		<label id="elh_sosialisasi_sos_kec" for="x_sos_kec" class="<?php echo $sosialisasi_edit->LeftColumnClass ?>"><?php echo $sosialisasi->sos_kec->FldCaption() ?></label>
		<div class="<?php echo $sosialisasi_edit->RightColumnClass ?>"><div<?php echo $sosialisasi->sos_kec->CellAttributes() ?>>
<span id="el_sosialisasi_sos_kec">
<?php $sosialisasi->sos_kec->EditAttrs["onchange"] = "ew_UpdateOpt.call(this); " . @$sosialisasi->sos_kec->EditAttrs["onchange"]; ?>
<select data-table="sosialisasi" data-field="x_sos_kec" data-value-separator="<?php echo $sosialisasi->sos_kec->DisplayValueSeparatorAttribute() ?>" id="x_sos_kec" name="x_sos_kec"<?php echo $sosialisasi->sos_kec->EditAttributes() ?>>
<?php echo $sosialisasi->sos_kec->SelectOptionListHtml("x_sos_kec") ?>
</select>
<?php if (AllowAdd(CurrentProjectID() . "kec") && !$sosialisasi->sos_kec->ReadOnly) { ?>
<button type="button" title="<?php echo ew_HtmlTitle($Language->Phrase("AddLink")) . "&nbsp;" . $sosialisasi->sos_kec->FldCaption() ?>" onclick="ew_AddOptDialogShow({lnk:this,el:'x_sos_kec',url:'kecaddopt.php'});" class="ewAddOptBtn btn btn-default btn-sm" id="aol_x_sos_kec"><span class="glyphicon glyphicon-plus ewIcon"></span><span class="hide"><?php echo $Language->Phrase("AddLink") ?>&nbsp;<?php echo $sosialisasi->sos_kec->FldCaption() ?></span></button>
<?php } ?>
</span>
<?php echo $sosialisasi->sos_kec->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sosialisasi->sos_desa->Visible) { // sos_desa ?>
	<div id="r_sos_desa" class="form-group">
		<label id="elh_sosialisasi_sos_desa" for="x_sos_desa" class="<?php echo $sosialisasi_edit->LeftColumnClass ?>"><?php echo $sosialisasi->sos_desa->FldCaption() ?></label>
		<div class="<?php echo $sosialisasi_edit->RightColumnClass ?>"><div<?php echo $sosialisasi->sos_desa->CellAttributes() ?>>
<span id="el_sosialisasi_sos_desa">
<select data-table="sosialisasi" data-field="x_sos_desa" data-value-separator="<?php echo $sosialisasi->sos_desa->DisplayValueSeparatorAttribute() ?>" id="x_sos_desa" name="x_sos_desa"<?php echo $sosialisasi->sos_desa->EditAttributes() ?>>
<?php echo $sosialisasi->sos_desa->SelectOptionListHtml("x_sos_desa") ?>
</select>
<?php if (AllowAdd(CurrentProjectID() . "desa") && !$sosialisasi->sos_desa->ReadOnly) { ?>
<button type="button" title="<?php echo ew_HtmlTitle($Language->Phrase("AddLink")) . "&nbsp;" . $sosialisasi->sos_desa->FldCaption() ?>" onclick="ew_AddOptDialogShow({lnk:this,el:'x_sos_desa',url:'desaaddopt.php'});" class="ewAddOptBtn btn btn-default btn-sm" id="aol_x_sos_desa"><span class="glyphicon glyphicon-plus ewIcon"></span><span class="hide"><?php echo $Language->Phrase("AddLink") ?>&nbsp;<?php echo $sosialisasi->sos_desa->FldCaption() ?></span></button>
<?php } ?>
</span>
<?php echo $sosialisasi->sos_desa->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sosialisasi->sos_alamat->Visible) { // sos_alamat ?>
	<div id="r_sos_alamat" class="form-group">
		<label id="elh_sosialisasi_sos_alamat" for="x_sos_alamat" class="<?php echo $sosialisasi_edit->LeftColumnClass ?>"><?php echo $sosialisasi->sos_alamat->FldCaption() ?></label>
		<div class="<?php echo $sosialisasi_edit->RightColumnClass ?>"><div<?php echo $sosialisasi->sos_alamat->CellAttributes() ?>>
<span id="el_sosialisasi_sos_alamat">
<textarea data-table="sosialisasi" data-field="x_sos_alamat" name="x_sos_alamat" id="x_sos_alamat" cols="35" rows="4" placeholder="<?php echo ew_HtmlEncode($sosialisasi->sos_alamat->getPlaceHolder()) ?>"<?php echo $sosialisasi->sos_alamat->EditAttributes() ?>><?php echo $sosialisasi->sos_alamat->EditValue ?></textarea>
</span>
<?php echo $sosialisasi->sos_alamat->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sosialisasi->sos_pot_lahan->Visible) { // sos_pot_lahan ?>
	<div id="r_sos_pot_lahan" class="form-group">
		<label id="elh_sosialisasi_sos_pot_lahan" for="x_sos_pot_lahan" class="<?php echo $sosialisasi_edit->LeftColumnClass ?>"><?php echo $sosialisasi->sos_pot_lahan->FldCaption() ?></label>
		<div class="<?php echo $sosialisasi_edit->RightColumnClass ?>"><div<?php echo $sosialisasi->sos_pot_lahan->CellAttributes() ?>>
<span id="el_sosialisasi_sos_pot_lahan">
<input type="text" data-table="sosialisasi" data-field="x_sos_pot_lahan" name="x_sos_pot_lahan" id="x_sos_pot_lahan" size="30" placeholder="<?php echo ew_HtmlEncode($sosialisasi->sos_pot_lahan->getPlaceHolder()) ?>" value="<?php echo $sosialisasi->sos_pot_lahan->EditValue ?>"<?php echo $sosialisasi->sos_pot_lahan->EditAttributes() ?>>
</span>
<?php echo $sosialisasi->sos_pot_lahan->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sosialisasi->sos_katinggian->Visible) { // sos_katinggian ?>
	<div id="r_sos_katinggian" class="form-group">
		<label id="elh_sosialisasi_sos_katinggian" for="x_sos_katinggian" class="<?php echo $sosialisasi_edit->LeftColumnClass ?>"><?php echo $sosialisasi->sos_katinggian->FldCaption() ?></label>
		<div class="<?php echo $sosialisasi_edit->RightColumnClass ?>"><div<?php echo $sosialisasi->sos_katinggian->CellAttributes() ?>>
<span id="el_sosialisasi_sos_katinggian">
<input type="text" data-table="sosialisasi" data-field="x_sos_katinggian" name="x_sos_katinggian" id="x_sos_katinggian" size="30" placeholder="<?php echo ew_HtmlEncode($sosialisasi->sos_katinggian->getPlaceHolder()) ?>" value="<?php echo $sosialisasi->sos_katinggian->EditValue ?>"<?php echo $sosialisasi->sos_katinggian->EditAttributes() ?>>
</span>
<?php echo $sosialisasi->sos_katinggian->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sosialisasi->sos_biaya->Visible) { // sos_biaya ?>
	<div id="r_sos_biaya" class="form-group">
		<label id="elh_sosialisasi_sos_biaya" for="x_sos_biaya" class="<?php echo $sosialisasi_edit->LeftColumnClass ?>"><?php echo $sosialisasi->sos_biaya->FldCaption() ?></label>
		<div class="<?php echo $sosialisasi_edit->RightColumnClass ?>"><div<?php echo $sosialisasi->sos_biaya->CellAttributes() ?>>
<span id="el_sosialisasi_sos_biaya">
<input type="text" data-table="sosialisasi" data-field="x_sos_biaya" name="x_sos_biaya" id="x_sos_biaya" size="30" placeholder="<?php echo ew_HtmlEncode($sosialisasi->sos_biaya->getPlaceHolder()) ?>" value="<?php echo $sosialisasi->sos_biaya->EditValue ?>"<?php echo $sosialisasi->sos_biaya->EditAttributes() ?>>
</span>
<?php echo $sosialisasi->sos_biaya->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sosialisasi->sos_kesimpulan->Visible) { // sos_kesimpulan ?>
	<div id="r_sos_kesimpulan" class="form-group">
		<label id="elh_sosialisasi_sos_kesimpulan" class="<?php echo $sosialisasi_edit->LeftColumnClass ?>"><?php echo $sosialisasi->sos_kesimpulan->FldCaption() ?></label>
		<div class="<?php echo $sosialisasi_edit->RightColumnClass ?>"><div<?php echo $sosialisasi->sos_kesimpulan->CellAttributes() ?>>
<span id="el_sosialisasi_sos_kesimpulan">
<?php ew_AppendClass($sosialisasi->sos_kesimpulan->EditAttrs["class"], "editor"); ?>
<textarea data-table="sosialisasi" data-field="x_sos_kesimpulan" name="x_sos_kesimpulan" id="x_sos_kesimpulan" cols="35" rows="4" placeholder="<?php echo ew_HtmlEncode($sosialisasi->sos_kesimpulan->getPlaceHolder()) ?>"<?php echo $sosialisasi->sos_kesimpulan->EditAttributes() ?>><?php echo $sosialisasi->sos_kesimpulan->EditValue ?></textarea>
<script type="text/javascript">
ew_CreateEditor("fsosialisasiedit", "x_sos_kesimpulan", 35, 4, <?php echo ($sosialisasi->sos_kesimpulan->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $sosialisasi->sos_kesimpulan->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sosialisasi->sos_foto->Visible) { // sos_foto ?>
	<div id="r_sos_foto" class="form-group">
		<label id="elh_sosialisasi_sos_foto" class="<?php echo $sosialisasi_edit->LeftColumnClass ?>"><?php echo $sosialisasi->sos_foto->FldCaption() ?></label>
		<div class="<?php echo $sosialisasi_edit->RightColumnClass ?>"><div<?php echo $sosialisasi->sos_foto->CellAttributes() ?>>
<span id="el_sosialisasi_sos_foto">
<div id="fd_x_sos_foto">
<span title="<?php echo $sosialisasi->sos_foto->FldTitle() ? $sosialisasi->sos_foto->FldTitle() : $Language->Phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ewTooltip<?php if ($sosialisasi->sos_foto->ReadOnly || $sosialisasi->sos_foto->Disabled) echo " hide"; ?>" data-trigger="hover">
	<span><?php echo $Language->Phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="sosialisasi" data-field="x_sos_foto" name="x_sos_foto" id="x_sos_foto" multiple="multiple"<?php echo $sosialisasi->sos_foto->EditAttributes() ?>>
</span>
<input type="hidden" name="fn_x_sos_foto" id= "fn_x_sos_foto" value="<?php echo $sosialisasi->sos_foto->Upload->FileName ?>">
<?php if (@$_POST["fa_x_sos_foto"] == "0") { ?>
<input type="hidden" name="fa_x_sos_foto" id= "fa_x_sos_foto" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_sos_foto" id= "fa_x_sos_foto" value="1">
<?php } ?>
<input type="hidden" name="fs_x_sos_foto" id= "fs_x_sos_foto" value="20">
<input type="hidden" name="fx_x_sos_foto" id= "fx_x_sos_foto" value="<?php echo $sosialisasi->sos_foto->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_sos_foto" id= "fm_x_sos_foto" value="<?php echo $sosialisasi->sos_foto->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_sos_foto" id= "fc_x_sos_foto" value="<?php echo $sosialisasi->sos_foto->UploadMaxFileCount ?>">
</div>
<table id="ft_x_sos_foto" class="table table-condensed pull-left ewUploadTable"><tbody class="files"></tbody></table>
</span>
<?php echo $sosialisasi->sos_foto->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$sosialisasi_edit->IsModal) { ?>
<div class="form-group"><!-- buttons .form-group -->
	<div class="<?php echo $sosialisasi_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ewButton" name="btnAction" id="btnAction" type="submit"><?php echo $Language->Phrase("SaveBtn") ?></button>
<button class="btn btn-default ewButton" name="btnCancel" id="btnCancel" type="button" data-href="<?php echo $sosialisasi_edit->getReturnUrl() ?>"><?php echo $Language->Phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<script type="text/javascript">
fsosialisasiedit.Init();
</script>
<?php
$sosialisasi_edit->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$sosialisasi_edit->Page_Terminate();
?>
