<?php
if (session_id() == "") session_start(); // Init session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg14.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql14.php") ?>
<?php include_once "phpfn14.php" ?>
<?php include_once "pesertainfo.php" ?>
<?php include_once "employeesinfo.php" ?>
<?php include_once "userfn14.php" ?>
<?php

//
// Page class
//

$peserta_list = NULL; // Initialize page object first

class cpeserta_list extends cpeserta {

	// Page ID
	var $PageID = 'list';

	// Project ID
	var $ProjectID = '{CC60B42B-604B-412A-B014-2315920AF6AA}';

	// Table name
	var $TableName = 'peserta';

	// Page object name
	var $PageObjName = 'peserta_list';

	// Grid form hidden field names
	var $FormName = 'fpesertalist';
	var $FormActionName = 'k_action';
	var $FormKeyName = 'k_key';
	var $FormOldKeyName = 'k_oldkey';
	var $FormBlankRowName = 'k_blankrow';
	var $FormKeyCountName = 'key_count';

	// Page headings
	var $Heading = '';
	var $Subheading = '';

	// Page heading
	function PageHeading() {
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->TableCaption();
		return "";
	}

	// Page subheading
	function PageSubheading() {
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->Phrase($this->PageID);
		return "";
	}

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;
	var $ExportPdfUrl;

	// Custom export
	var $ExportExcelCustom = FALSE;
	var $ExportWordCustom = FALSE;
	var $ExportPdfCustom = FALSE;
	var $ExportEmailCustom = FALSE;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (peserta)
		if (!isset($GLOBALS["peserta"]) || get_class($GLOBALS["peserta"]) == "cpeserta") {
			$GLOBALS["peserta"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["peserta"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->PageUrl() . "export=print";
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel";
		$this->ExportWordUrl = $this->PageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->PageUrl() . "export=html";
		$this->ExportXmlUrl = $this->PageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->PageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf";
		$this->AddUrl = "pesertaadd.php";
		$this->InlineAddUrl = $this->PageUrl() . "a=add";
		$this->GridAddUrl = $this->PageUrl() . "a=gridadd";
		$this->GridEditUrl = $this->PageUrl() . "a=gridedit";
		$this->MultiDeleteUrl = "pesertadelete.php";
		$this->MultiUpdateUrl = "pesertaupdate.php";

		// Table object (employees)
		if (!isset($GLOBALS['employees'])) $GLOBALS['employees'] = new cemployees();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'list', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'peserta', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"]))
			$GLOBALS["gTimer"] = new cTimer();

		// Debug message
		ew_LoadDebugMsg();

		// Open connection
		if (!isset($conn))
			$conn = ew_Connect($this->DBID);

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new cemployees();
			$UserTableConn = Conn($UserTable->DBID);
		}

		// List options
		$this->ListOptions = new cListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new cListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Other options
		$this->OtherOptions['addedit'] = new cListOptions();
		$this->OtherOptions['addedit']->Tag = "div";
		$this->OtherOptions['addedit']->TagClassName = "ewAddEditOption";
		$this->OtherOptions['detail'] = new cListOptions();
		$this->OtherOptions['detail']->Tag = "div";
		$this->OtherOptions['detail']->TagClassName = "ewDetailOption";
		$this->OtherOptions['action'] = new cListOptions();
		$this->OtherOptions['action']->Tag = "div";
		$this->OtherOptions['action']->TagClassName = "ewActionOption";

		// Filter options
		$this->FilterOptions = new cListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ewFilterOption fpesertalistsrch";

		// List actions
		$this->ListActions = new cListActions();
	}

	//
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// User profile
		$UserProfile = new cUserProfile();

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanList()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			$this->Page_Terminate(ew_GetUrl("index.php"));
		}

		// NOTE: Security object may be needed in other part of the script, skip set to Nothing
		// 
		// Security = null;
		// 
		// Get export parameters

		$custom = "";
		if (@$_GET["export"] <> "") {
			$this->Export = $_GET["export"];
			$custom = @$_GET["custom"];
		} elseif (@$_POST["export"] <> "") {
			$this->Export = $_POST["export"];
			$custom = @$_POST["custom"];
		} elseif (ew_IsPost()) {
			if (@$_POST["exporttype"] <> "")
				$this->Export = $_POST["exporttype"];
			$custom = @$_POST["custom"];
		} elseif (@$_GET["cmd"] == "json") {
			$this->Export = $_GET["cmd"];
		} else {
			$this->setExportReturnUrl(ew_CurrentUrl());
		}
		$gsExportFile = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->Export <> "" && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$gsCustomExport = $this->CustomExport;
		$gsExport = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined("EW_USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined("EW_USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action

		// Get grid add count
		$gridaddcnt = @$_GET[EW_TABLE_GRID_ADD_ROW_COUNT];
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->SetupListOptions();

		// Setup export options
		$this->SetupExportOptions();
		$this->pes_id->SetVisibility();
		if ($this->IsAdd() || $this->IsCopy() || $this->IsGridAdd())
			$this->pes_id->Visible = FALSE;
		$this->pes_nama->SetVisibility();
		$this->sos_id->SetVisibility();
		$this->co_id->SetVisibility();
		$this->prov_id->SetVisibility();
		$this->kab_id->SetVisibility();
		$this->kec_id->SetVisibility();
		$this->desa_id->SetVisibility();
		$this->pes_alamat->SetVisibility();
		$this->pes_hp->SetVisibility();
		$this->pes_foto->SetVisibility();
		$this->pes_luas_lahan->SetVisibility();
		$this->pes_r_tanam_tgl->SetVisibility();
		$this->pes_foto_lahan->SetVisibility();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();

		// Setup other options
		$this->SetupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->Add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == EW_ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $peserta;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($peserta);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		// Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			ew_SaveDebugMsg();
			header("Location: " . $url);
		}
		exit();
	}

	// Class variables
	var $ListOptions; // List options
	var $ExportOptions; // Export options
	var $SearchOptions; // Search options
	var $OtherOptions = array(); // Other options
	var $FilterOptions; // Filter options
	var $ListActions; // List actions
	var $SelectedCount = 0;
	var $SelectedIndex = 0;
	var $DisplayRecs = 100;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $Pager;
	var $AutoHidePager = EW_AUTO_HIDE_PAGER;
	var $AutoHidePageSizeSelector = EW_AUTO_HIDE_PAGE_SIZE_SELECTOR;
	var $DefaultSearchWhere = ""; // Default search WHERE clause
	var $SearchWhere = ""; // Search WHERE clause
	var $RecCnt = 0; // Record count
	var $EditRowCnt;
	var $StartRowCnt = 1;
	var $RowCnt = 0;
	var $Attrs = array(); // Row attributes and cell attributes
	var $RowIndex = 0; // Row index
	var $KeyCount = 0; // Key count
	var $RowAction = ""; // Row action
	var $RowOldKey = ""; // Row old key (for copy)
	var $RecPerRow = 0;
	var $MultiColumnClass;
	var $MultiColumnEditClass = "col-sm-12";
	var $MultiColumnCnt = 12;
	var $MultiColumnEditCnt = 12;
	var $GridCnt = 0;
	var $ColCnt = 0;
	var $DbMasterFilter = ""; // Master filter
	var $DbDetailFilter = ""; // Detail filter
	var $MasterRecordExists;
	var $MultiSelectKey;
	var $Command;
	var $RestoreSearch = FALSE;
	var $DetailPages;
	var $Recordset;
	var $OldRecordset;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError, $gsSearchError, $Security, $EW_EXPORT;

		// Search filters
		$sSrchAdvanced = ""; // Advanced search filter
		$sSrchBasic = ""; // Basic search filter
		$sFilter = "";

		// Get command
		$this->Command = strtolower(@$_GET["cmd"]);
		if ($this->IsPageRequest()) { // Validate request

			// Process list action first
			if ($this->ProcessListAction()) // Ajax request
				$this->Page_Terminate();

			// Handle reset command
			$this->ResetCmd();

			// Set up Breadcrumb
			if ($this->Export == "")
				$this->SetupBreadcrumb();

			// Hide list options
			if ($this->Export <> "") {
				$this->ListOptions->HideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->CurrentAction == "gridadd" || $this->CurrentAction == "gridedit") {
				$this->ListOptions->HideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->Export <> "" || $this->CurrentAction <> "") {
				$this->ExportOptions->HideAllOptions();
				$this->FilterOptions->HideAllOptions();
			}

			// Hide other options
			if ($this->Export <> "") {
				foreach ($this->OtherOptions as &$option)
					$option->HideAllOptions();
			}

			// Get default search criteria
			ew_AddFilter($this->DefaultSearchWhere, $this->BasicSearchWhere(TRUE));
			ew_AddFilter($this->DefaultSearchWhere, $this->AdvancedSearchWhere(TRUE));

			// Get basic search values
			$this->LoadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->LoadSearchValues(); // Get search values

			// Process filter list
			$this->ProcessFilterList();
			if (!$this->ValidateSearch())
				$this->setFailureMessage($gsSearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->Export <> "" || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->CheckSearchParms())
				$this->RestoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->SetupSortOrder();

			// Get basic search criteria
			if ($gsSearchError == "")
				$sSrchBasic = $this->BasicSearchWhere();

			// Get search criteria for advanced search
			if ($gsSearchError == "")
				$sSrchAdvanced = $this->AdvancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 100; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->LoadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->CheckSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->LoadDefault();
			if ($this->BasicSearch->Keyword != "")
				$sSrchBasic = $this->BasicSearchWhere();

			// Load advanced search from default
			if ($this->LoadAdvancedSearchDefault()) {
				$sSrchAdvanced = $this->AdvancedSearchWhere();
			}
		}

		// Build search criteria
		ew_AddFilter($this->SearchWhere, $sSrchAdvanced);
		ew_AddFilter($this->SearchWhere, $sSrchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$sFilter = "";
		if (!$Security->CanList())
			$sFilter = "(0=1)"; // Filter all records
		ew_AddFilter($sFilter, $this->DbDetailFilter);
		ew_AddFilter($sFilter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSQL = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $sFilter;
		} else {
			$this->setSessionWhere($sFilter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if ($this->CustomExport == "" && in_array($this->Export, array_keys($EW_EXPORT))) {
			$this->ExportData();
			$this->Page_Terminate(); // Terminate response
			exit();
		}

		// Load record count first
		if (!$this->IsAddOrEdit()) {
			$bSelectLimit = $this->UseSelectLimit;
			if ($bSelectLimit) {
				$this->TotalRecs = $this->ListRecordCount();
			} else {
				if ($this->Recordset = $this->LoadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
		}

		// Search options
		$this->SetupSearchOptions();
	}

	// Build filter for all keys
	function BuildKeyFilter() {
		global $objForm;
		$sWrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$objForm->Index = $rowindex;
		$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		while ($sThisKey <> "") {
			if ($this->SetupKeyValues($sThisKey)) {
				$sFilter = $this->KeyFilter();
				if ($sWrkFilter <> "") $sWrkFilter .= " OR ";
				$sWrkFilter .= $sFilter;
			} else {
				$sWrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$objForm->Index = $rowindex;
			$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		}
		return $sWrkFilter;
	}

	// Set up key values
	function SetupKeyValues($key) {
		$arrKeyFlds = explode($GLOBALS["EW_COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arrKeyFlds) >= 1) {
			$this->pes_id->setFormValue($arrKeyFlds[0]);
			if (!is_numeric($this->pes_id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	function GetFilterList() {
		global $UserProfile;

		// Initialize
		$sFilterList = "";
		$sSavedFilterList = "";
		$sFilterList = ew_Concat($sFilterList, $this->pes_id->AdvancedSearch->ToJson(), ","); // Field pes_id
		$sFilterList = ew_Concat($sFilterList, $this->pes_nama->AdvancedSearch->ToJson(), ","); // Field pes_nama
		$sFilterList = ew_Concat($sFilterList, $this->sos_id->AdvancedSearch->ToJson(), ","); // Field sos_id
		$sFilterList = ew_Concat($sFilterList, $this->co_id->AdvancedSearch->ToJson(), ","); // Field co_id
		$sFilterList = ew_Concat($sFilterList, $this->prov_id->AdvancedSearch->ToJson(), ","); // Field prov_id
		$sFilterList = ew_Concat($sFilterList, $this->kab_id->AdvancedSearch->ToJson(), ","); // Field kab_id
		$sFilterList = ew_Concat($sFilterList, $this->kec_id->AdvancedSearch->ToJson(), ","); // Field kec_id
		$sFilterList = ew_Concat($sFilterList, $this->desa_id->AdvancedSearch->ToJson(), ","); // Field desa_id
		$sFilterList = ew_Concat($sFilterList, $this->pes_alamat->AdvancedSearch->ToJson(), ","); // Field pes_alamat
		$sFilterList = ew_Concat($sFilterList, $this->pes_hp->AdvancedSearch->ToJson(), ","); // Field pes_hp
		$sFilterList = ew_Concat($sFilterList, $this->pes_foto->AdvancedSearch->ToJson(), ","); // Field pes_foto
		$sFilterList = ew_Concat($sFilterList, $this->pes_luas_lahan->AdvancedSearch->ToJson(), ","); // Field pes_luas_lahan
		$sFilterList = ew_Concat($sFilterList, $this->pes_r_tanam_tgl->AdvancedSearch->ToJson(), ","); // Field pes_r_tanam_tgl
		$sFilterList = ew_Concat($sFilterList, $this->pes_foto_lahan->AdvancedSearch->ToJson(), ","); // Field pes_foto_lahan
		if ($this->BasicSearch->Keyword <> "") {
			$sWrk = "\"" . EW_TABLE_BASIC_SEARCH . "\":\"" . ew_JsEncode2($this->BasicSearch->Keyword) . "\",\"" . EW_TABLE_BASIC_SEARCH_TYPE . "\":\"" . ew_JsEncode2($this->BasicSearch->Type) . "\"";
			$sFilterList = ew_Concat($sFilterList, $sWrk, ",");
		}
		$sFilterList = preg_replace('/,$/', "", $sFilterList);

		// Return filter list in json
		if ($sFilterList <> "")
			$sFilterList = "\"data\":{" . $sFilterList . "}";
		if ($sSavedFilterList <> "") {
			if ($sFilterList <> "")
				$sFilterList .= ",";
			$sFilterList .= "\"filters\":" . $sSavedFilterList;
		}
		return ($sFilterList <> "") ? "{" . $sFilterList . "}" : "null";
	}

	// Process filter list
	function ProcessFilterList() {
		global $UserProfile;
		if (@$_POST["ajax"] == "savefilters") { // Save filter request (Ajax)
			$filters = @$_POST["filters"];
			$UserProfile->SetSearchFilters(CurrentUserName(), "fpesertalistsrch", $filters);

			// Clean output buffer
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			echo ew_ArrayToJson(array(array("success" => TRUE))); // Success
			$this->Page_Terminate();
			exit();
		} elseif (@$_POST["cmd"] == "resetfilter") {
			$this->RestoreFilterList();
		}
	}

	// Restore list of filters
	function RestoreFilterList() {

		// Return if not reset filter
		if (@$_POST["cmd"] <> "resetfilter")
			return FALSE;
		$filter = json_decode(@$_POST["filter"], TRUE);
		$this->Command = "search";

		// Field pes_id
		$this->pes_id->AdvancedSearch->SearchValue = @$filter["x_pes_id"];
		$this->pes_id->AdvancedSearch->SearchOperator = @$filter["z_pes_id"];
		$this->pes_id->AdvancedSearch->SearchCondition = @$filter["v_pes_id"];
		$this->pes_id->AdvancedSearch->SearchValue2 = @$filter["y_pes_id"];
		$this->pes_id->AdvancedSearch->SearchOperator2 = @$filter["w_pes_id"];
		$this->pes_id->AdvancedSearch->Save();

		// Field pes_nama
		$this->pes_nama->AdvancedSearch->SearchValue = @$filter["x_pes_nama"];
		$this->pes_nama->AdvancedSearch->SearchOperator = @$filter["z_pes_nama"];
		$this->pes_nama->AdvancedSearch->SearchCondition = @$filter["v_pes_nama"];
		$this->pes_nama->AdvancedSearch->SearchValue2 = @$filter["y_pes_nama"];
		$this->pes_nama->AdvancedSearch->SearchOperator2 = @$filter["w_pes_nama"];
		$this->pes_nama->AdvancedSearch->Save();

		// Field sos_id
		$this->sos_id->AdvancedSearch->SearchValue = @$filter["x_sos_id"];
		$this->sos_id->AdvancedSearch->SearchOperator = @$filter["z_sos_id"];
		$this->sos_id->AdvancedSearch->SearchCondition = @$filter["v_sos_id"];
		$this->sos_id->AdvancedSearch->SearchValue2 = @$filter["y_sos_id"];
		$this->sos_id->AdvancedSearch->SearchOperator2 = @$filter["w_sos_id"];
		$this->sos_id->AdvancedSearch->Save();

		// Field co_id
		$this->co_id->AdvancedSearch->SearchValue = @$filter["x_co_id"];
		$this->co_id->AdvancedSearch->SearchOperator = @$filter["z_co_id"];
		$this->co_id->AdvancedSearch->SearchCondition = @$filter["v_co_id"];
		$this->co_id->AdvancedSearch->SearchValue2 = @$filter["y_co_id"];
		$this->co_id->AdvancedSearch->SearchOperator2 = @$filter["w_co_id"];
		$this->co_id->AdvancedSearch->Save();

		// Field prov_id
		$this->prov_id->AdvancedSearch->SearchValue = @$filter["x_prov_id"];
		$this->prov_id->AdvancedSearch->SearchOperator = @$filter["z_prov_id"];
		$this->prov_id->AdvancedSearch->SearchCondition = @$filter["v_prov_id"];
		$this->prov_id->AdvancedSearch->SearchValue2 = @$filter["y_prov_id"];
		$this->prov_id->AdvancedSearch->SearchOperator2 = @$filter["w_prov_id"];
		$this->prov_id->AdvancedSearch->Save();

		// Field kab_id
		$this->kab_id->AdvancedSearch->SearchValue = @$filter["x_kab_id"];
		$this->kab_id->AdvancedSearch->SearchOperator = @$filter["z_kab_id"];
		$this->kab_id->AdvancedSearch->SearchCondition = @$filter["v_kab_id"];
		$this->kab_id->AdvancedSearch->SearchValue2 = @$filter["y_kab_id"];
		$this->kab_id->AdvancedSearch->SearchOperator2 = @$filter["w_kab_id"];
		$this->kab_id->AdvancedSearch->Save();

		// Field kec_id
		$this->kec_id->AdvancedSearch->SearchValue = @$filter["x_kec_id"];
		$this->kec_id->AdvancedSearch->SearchOperator = @$filter["z_kec_id"];
		$this->kec_id->AdvancedSearch->SearchCondition = @$filter["v_kec_id"];
		$this->kec_id->AdvancedSearch->SearchValue2 = @$filter["y_kec_id"];
		$this->kec_id->AdvancedSearch->SearchOperator2 = @$filter["w_kec_id"];
		$this->kec_id->AdvancedSearch->Save();

		// Field desa_id
		$this->desa_id->AdvancedSearch->SearchValue = @$filter["x_desa_id"];
		$this->desa_id->AdvancedSearch->SearchOperator = @$filter["z_desa_id"];
		$this->desa_id->AdvancedSearch->SearchCondition = @$filter["v_desa_id"];
		$this->desa_id->AdvancedSearch->SearchValue2 = @$filter["y_desa_id"];
		$this->desa_id->AdvancedSearch->SearchOperator2 = @$filter["w_desa_id"];
		$this->desa_id->AdvancedSearch->Save();

		// Field pes_alamat
		$this->pes_alamat->AdvancedSearch->SearchValue = @$filter["x_pes_alamat"];
		$this->pes_alamat->AdvancedSearch->SearchOperator = @$filter["z_pes_alamat"];
		$this->pes_alamat->AdvancedSearch->SearchCondition = @$filter["v_pes_alamat"];
		$this->pes_alamat->AdvancedSearch->SearchValue2 = @$filter["y_pes_alamat"];
		$this->pes_alamat->AdvancedSearch->SearchOperator2 = @$filter["w_pes_alamat"];
		$this->pes_alamat->AdvancedSearch->Save();

		// Field pes_hp
		$this->pes_hp->AdvancedSearch->SearchValue = @$filter["x_pes_hp"];
		$this->pes_hp->AdvancedSearch->SearchOperator = @$filter["z_pes_hp"];
		$this->pes_hp->AdvancedSearch->SearchCondition = @$filter["v_pes_hp"];
		$this->pes_hp->AdvancedSearch->SearchValue2 = @$filter["y_pes_hp"];
		$this->pes_hp->AdvancedSearch->SearchOperator2 = @$filter["w_pes_hp"];
		$this->pes_hp->AdvancedSearch->Save();

		// Field pes_foto
		$this->pes_foto->AdvancedSearch->SearchValue = @$filter["x_pes_foto"];
		$this->pes_foto->AdvancedSearch->SearchOperator = @$filter["z_pes_foto"];
		$this->pes_foto->AdvancedSearch->SearchCondition = @$filter["v_pes_foto"];
		$this->pes_foto->AdvancedSearch->SearchValue2 = @$filter["y_pes_foto"];
		$this->pes_foto->AdvancedSearch->SearchOperator2 = @$filter["w_pes_foto"];
		$this->pes_foto->AdvancedSearch->Save();

		// Field pes_luas_lahan
		$this->pes_luas_lahan->AdvancedSearch->SearchValue = @$filter["x_pes_luas_lahan"];
		$this->pes_luas_lahan->AdvancedSearch->SearchOperator = @$filter["z_pes_luas_lahan"];
		$this->pes_luas_lahan->AdvancedSearch->SearchCondition = @$filter["v_pes_luas_lahan"];
		$this->pes_luas_lahan->AdvancedSearch->SearchValue2 = @$filter["y_pes_luas_lahan"];
		$this->pes_luas_lahan->AdvancedSearch->SearchOperator2 = @$filter["w_pes_luas_lahan"];
		$this->pes_luas_lahan->AdvancedSearch->Save();

		// Field pes_r_tanam_tgl
		$this->pes_r_tanam_tgl->AdvancedSearch->SearchValue = @$filter["x_pes_r_tanam_tgl"];
		$this->pes_r_tanam_tgl->AdvancedSearch->SearchOperator = @$filter["z_pes_r_tanam_tgl"];
		$this->pes_r_tanam_tgl->AdvancedSearch->SearchCondition = @$filter["v_pes_r_tanam_tgl"];
		$this->pes_r_tanam_tgl->AdvancedSearch->SearchValue2 = @$filter["y_pes_r_tanam_tgl"];
		$this->pes_r_tanam_tgl->AdvancedSearch->SearchOperator2 = @$filter["w_pes_r_tanam_tgl"];
		$this->pes_r_tanam_tgl->AdvancedSearch->Save();

		// Field pes_foto_lahan
		$this->pes_foto_lahan->AdvancedSearch->SearchValue = @$filter["x_pes_foto_lahan"];
		$this->pes_foto_lahan->AdvancedSearch->SearchOperator = @$filter["z_pes_foto_lahan"];
		$this->pes_foto_lahan->AdvancedSearch->SearchCondition = @$filter["v_pes_foto_lahan"];
		$this->pes_foto_lahan->AdvancedSearch->SearchValue2 = @$filter["y_pes_foto_lahan"];
		$this->pes_foto_lahan->AdvancedSearch->SearchOperator2 = @$filter["w_pes_foto_lahan"];
		$this->pes_foto_lahan->AdvancedSearch->Save();
		$this->BasicSearch->setKeyword(@$filter[EW_TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[EW_TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	function AdvancedSearchWhere($Default = FALSE) {
		global $Security;
		$sWhere = "";
		if (!$Security->CanSearch()) return "";
		$this->BuildSearchSql($sWhere, $this->pes_id, $Default, FALSE); // pes_id
		$this->BuildSearchSql($sWhere, $this->pes_nama, $Default, FALSE); // pes_nama
		$this->BuildSearchSql($sWhere, $this->sos_id, $Default, FALSE); // sos_id
		$this->BuildSearchSql($sWhere, $this->co_id, $Default, FALSE); // co_id
		$this->BuildSearchSql($sWhere, $this->prov_id, $Default, FALSE); // prov_id
		$this->BuildSearchSql($sWhere, $this->kab_id, $Default, FALSE); // kab_id
		$this->BuildSearchSql($sWhere, $this->kec_id, $Default, FALSE); // kec_id
		$this->BuildSearchSql($sWhere, $this->desa_id, $Default, FALSE); // desa_id
		$this->BuildSearchSql($sWhere, $this->pes_alamat, $Default, FALSE); // pes_alamat
		$this->BuildSearchSql($sWhere, $this->pes_hp, $Default, FALSE); // pes_hp
		$this->BuildSearchSql($sWhere, $this->pes_foto, $Default, FALSE); // pes_foto
		$this->BuildSearchSql($sWhere, $this->pes_luas_lahan, $Default, FALSE); // pes_luas_lahan
		$this->BuildSearchSql($sWhere, $this->pes_r_tanam_tgl, $Default, FALSE); // pes_r_tanam_tgl
		$this->BuildSearchSql($sWhere, $this->pes_foto_lahan, $Default, FALSE); // pes_foto_lahan

		// Set up search parm
		if (!$Default && $sWhere <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$Default && $this->Command == "search") {
			$this->pes_id->AdvancedSearch->Save(); // pes_id
			$this->pes_nama->AdvancedSearch->Save(); // pes_nama
			$this->sos_id->AdvancedSearch->Save(); // sos_id
			$this->co_id->AdvancedSearch->Save(); // co_id
			$this->prov_id->AdvancedSearch->Save(); // prov_id
			$this->kab_id->AdvancedSearch->Save(); // kab_id
			$this->kec_id->AdvancedSearch->Save(); // kec_id
			$this->desa_id->AdvancedSearch->Save(); // desa_id
			$this->pes_alamat->AdvancedSearch->Save(); // pes_alamat
			$this->pes_hp->AdvancedSearch->Save(); // pes_hp
			$this->pes_foto->AdvancedSearch->Save(); // pes_foto
			$this->pes_luas_lahan->AdvancedSearch->Save(); // pes_luas_lahan
			$this->pes_r_tanam_tgl->AdvancedSearch->Save(); // pes_r_tanam_tgl
			$this->pes_foto_lahan->AdvancedSearch->Save(); // pes_foto_lahan
		}
		return $sWhere;
	}

	// Build search SQL
	function BuildSearchSql(&$Where, &$Fld, $Default, $MultiValue) {
		$FldParm = $Fld->FldParm();
		$FldVal = ($Default) ? $Fld->AdvancedSearch->SearchValueDefault : $Fld->AdvancedSearch->SearchValue; // @$_GET["x_$FldParm"]
		$FldOpr = ($Default) ? $Fld->AdvancedSearch->SearchOperatorDefault : $Fld->AdvancedSearch->SearchOperator; // @$_GET["z_$FldParm"]
		$FldCond = ($Default) ? $Fld->AdvancedSearch->SearchConditionDefault : $Fld->AdvancedSearch->SearchCondition; // @$_GET["v_$FldParm"]
		$FldVal2 = ($Default) ? $Fld->AdvancedSearch->SearchValue2Default : $Fld->AdvancedSearch->SearchValue2; // @$_GET["y_$FldParm"]
		$FldOpr2 = ($Default) ? $Fld->AdvancedSearch->SearchOperator2Default : $Fld->AdvancedSearch->SearchOperator2; // @$_GET["w_$FldParm"]
		$sWrk = "";
		if (is_array($FldVal)) $FldVal = implode(",", $FldVal);
		if (is_array($FldVal2)) $FldVal2 = implode(",", $FldVal2);
		$FldOpr = strtoupper(trim($FldOpr));
		if ($FldOpr == "") $FldOpr = "=";
		$FldOpr2 = strtoupper(trim($FldOpr2));
		if ($FldOpr2 == "") $FldOpr2 = "=";
		if (EW_SEARCH_MULTI_VALUE_OPTION == 1)
			$MultiValue = FALSE;
		if ($MultiValue) {
			$sWrk1 = ($FldVal <> "") ? ew_GetMultiSearchSql($Fld, $FldOpr, $FldVal, $this->DBID) : ""; // Field value 1
			$sWrk2 = ($FldVal2 <> "") ? ew_GetMultiSearchSql($Fld, $FldOpr2, $FldVal2, $this->DBID) : ""; // Field value 2
			$sWrk = $sWrk1; // Build final SQL
			if ($sWrk2 <> "")
				$sWrk = ($sWrk <> "") ? "($sWrk) $FldCond ($sWrk2)" : $sWrk2;
		} else {
			$FldVal = $this->ConvertSearchValue($Fld, $FldVal);
			$FldVal2 = $this->ConvertSearchValue($Fld, $FldVal2);
			$sWrk = ew_GetSearchSql($Fld, $FldVal, $FldOpr, $FldCond, $FldVal2, $FldOpr2, $this->DBID);
		}
		ew_AddFilter($Where, $sWrk);
	}

	// Convert search value
	function ConvertSearchValue(&$Fld, $FldVal) {
		if ($FldVal == EW_NULL_VALUE || $FldVal == EW_NOT_NULL_VALUE)
			return $FldVal;
		$Value = $FldVal;
		if ($Fld->FldDataType == EW_DATATYPE_BOOLEAN) {
			if ($FldVal <> "") $Value = ($FldVal == "1" || strtolower(strval($FldVal)) == "y" || strtolower(strval($FldVal)) == "t") ? $Fld->TrueValue : $Fld->FalseValue;
		} elseif ($Fld->FldDataType == EW_DATATYPE_DATE || $Fld->FldDataType == EW_DATATYPE_TIME) {
			if ($FldVal <> "") $Value = ew_UnFormatDateTime($FldVal, $Fld->FldDateTimeFormat);
		}
		return $Value;
	}

	// Return basic search SQL
	function BasicSearchSQL($arKeywords, $type) {
		$sWhere = "";
		$this->BuildBasicSearchSQL($sWhere, $this->pes_nama, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->pes_alamat, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->pes_hp, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->pes_foto, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->pes_foto_lahan, $arKeywords, $type);
		return $sWhere;
	}

	// Build basic search SQL
	function BuildBasicSearchSQL(&$Where, &$Fld, $arKeywords, $type) {
		global $EW_BASIC_SEARCH_IGNORE_PATTERN;
		$sDefCond = ($type == "OR") ? "OR" : "AND";
		$arSQL = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$Keyword = $arKeywords[$i];
			$Keyword = trim($Keyword);
			if ($EW_BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$Keyword = preg_replace($EW_BASIC_SEARCH_IGNORE_PATTERN, "\\", $Keyword);
				$ar = explode("\\", $Keyword);
			} else {
				$ar = array($Keyword);
			}
			foreach ($ar as $Keyword) {
				if ($Keyword <> "") {
					$sWrk = "";
					if ($Keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j-1] = "OR";
					} elseif ($Keyword == EW_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NULL";
					} elseif ($Keyword == EW_NOT_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NOT NULL";
					} elseif ($Fld->FldIsVirtual) {
						$sWrk = $Fld->FldVirtualExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					} elseif ($Fld->FldDataType != EW_DATATYPE_NUMBER || is_numeric($Keyword)) {
						$sWrk = $Fld->FldBasicSearchExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					}
					if ($sWrk <> "") {
						$arSQL[$j] = $sWrk;
						$arCond[$j] = $sDefCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSQL);
		$bQuoted = FALSE;
		$sSql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt-1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$bQuoted) $sSql .= "(";
					$bQuoted = TRUE;
				}
				$sSql .= $arSQL[$i];
				if ($bQuoted && $arCond[$i] <> "OR") {
					$sSql .= ")";
					$bQuoted = FALSE;
				}
				$sSql .= " " . $arCond[$i] . " ";
			}
			$sSql .= $arSQL[$cnt-1];
			if ($bQuoted)
				$sSql .= ")";
		}
		if ($sSql <> "") {
			if ($Where <> "") $Where .= " OR ";
			$Where .= "(" . $sSql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	function BasicSearchWhere($Default = FALSE) {
		global $Security;
		$sSearchStr = "";
		if (!$Security->CanSearch()) return "";
		$sSearchKeyword = ($Default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$sSearchType = ($Default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($sSearchKeyword <> "") {
			$ar = $this->BasicSearch->KeywordList($Default);

			// Search keyword in any fields
			if (($sSearchType == "OR" || $sSearchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $sKeyword) {
					if ($sKeyword <> "") {
						if ($sSearchStr <> "") $sSearchStr .= " " . $sSearchType . " ";
						$sSearchStr .= "(" . $this->BasicSearchSQL(array($sKeyword), $sSearchType) . ")";
					}
				}
			} else {
				$sSearchStr = $this->BasicSearchSQL($ar, $sSearchType);
			}
			if (!$Default && in_array($this->Command, array("", "reset", "resetall"))) $this->Command = "search";
		}
		if (!$Default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($sSearchKeyword);
			$this->BasicSearch->setType($sSearchType);
		}
		return $sSearchStr;
	}

	// Check if search parm exists
	function CheckSearchParms() {

		// Check basic search
		if ($this->BasicSearch->IssetSession())
			return TRUE;
		if ($this->pes_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->pes_nama->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->sos_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->co_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->prov_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->kab_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->kec_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->desa_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->pes_alamat->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->pes_hp->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->pes_foto->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->pes_luas_lahan->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->pes_r_tanam_tgl->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->pes_foto_lahan->AdvancedSearch->IssetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	function ResetSearchParms() {

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->ResetBasicSearchParms();

		// Clear advanced search parameters
		$this->ResetAdvancedSearchParms();
	}

	// Load advanced search default values
	function LoadAdvancedSearchDefault() {
		return FALSE;
	}

	// Clear all basic search parameters
	function ResetBasicSearchParms() {
		$this->BasicSearch->UnsetSession();
	}

	// Clear all advanced search parameters
	function ResetAdvancedSearchParms() {
		$this->pes_id->AdvancedSearch->UnsetSession();
		$this->pes_nama->AdvancedSearch->UnsetSession();
		$this->sos_id->AdvancedSearch->UnsetSession();
		$this->co_id->AdvancedSearch->UnsetSession();
		$this->prov_id->AdvancedSearch->UnsetSession();
		$this->kab_id->AdvancedSearch->UnsetSession();
		$this->kec_id->AdvancedSearch->UnsetSession();
		$this->desa_id->AdvancedSearch->UnsetSession();
		$this->pes_alamat->AdvancedSearch->UnsetSession();
		$this->pes_hp->AdvancedSearch->UnsetSession();
		$this->pes_foto->AdvancedSearch->UnsetSession();
		$this->pes_luas_lahan->AdvancedSearch->UnsetSession();
		$this->pes_r_tanam_tgl->AdvancedSearch->UnsetSession();
		$this->pes_foto_lahan->AdvancedSearch->UnsetSession();
	}

	// Restore all search parameters
	function RestoreSearchParms() {
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->Load();

		// Restore advanced search values
		$this->pes_id->AdvancedSearch->Load();
		$this->pes_nama->AdvancedSearch->Load();
		$this->sos_id->AdvancedSearch->Load();
		$this->co_id->AdvancedSearch->Load();
		$this->prov_id->AdvancedSearch->Load();
		$this->kab_id->AdvancedSearch->Load();
		$this->kec_id->AdvancedSearch->Load();
		$this->desa_id->AdvancedSearch->Load();
		$this->pes_alamat->AdvancedSearch->Load();
		$this->pes_hp->AdvancedSearch->Load();
		$this->pes_foto->AdvancedSearch->Load();
		$this->pes_luas_lahan->AdvancedSearch->Load();
		$this->pes_r_tanam_tgl->AdvancedSearch->Load();
		$this->pes_foto_lahan->AdvancedSearch->Load();
	}

	// Set up sort parameters
	function SetupSortOrder() {

		// Check for "order" parameter
		if (@$_GET["order"] <> "") {
			$this->CurrentOrder = @$_GET["order"];
			$this->CurrentOrderType = @$_GET["ordertype"];
			$this->UpdateSort($this->pes_id); // pes_id
			$this->UpdateSort($this->pes_nama); // pes_nama
			$this->UpdateSort($this->sos_id); // sos_id
			$this->UpdateSort($this->co_id); // co_id
			$this->UpdateSort($this->prov_id); // prov_id
			$this->UpdateSort($this->kab_id); // kab_id
			$this->UpdateSort($this->kec_id); // kec_id
			$this->UpdateSort($this->desa_id); // desa_id
			$this->UpdateSort($this->pes_alamat); // pes_alamat
			$this->UpdateSort($this->pes_hp); // pes_hp
			$this->UpdateSort($this->pes_foto); // pes_foto
			$this->UpdateSort($this->pes_luas_lahan); // pes_luas_lahan
			$this->UpdateSort($this->pes_r_tanam_tgl); // pes_r_tanam_tgl
			$this->UpdateSort($this->pes_foto_lahan); // pes_foto_lahan
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	function LoadSortOrder() {
		$sOrderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($sOrderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$sOrderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($sOrderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)
	function ResetCmd() {

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->ResetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$sOrderBy = "";
				$this->setSessionOrderBy($sOrderBy);
				$this->setSessionOrderByList($sOrderBy);
				$this->pes_id->setSort("");
				$this->pes_nama->setSort("");
				$this->sos_id->setSort("");
				$this->co_id->setSort("");
				$this->prov_id->setSort("");
				$this->kab_id->setSort("");
				$this->kec_id->setSort("");
				$this->desa_id->setSort("");
				$this->pes_alamat->setSort("");
				$this->pes_hp->setSort("");
				$this->pes_foto->setSort("");
				$this->pes_luas_lahan->setSort("");
				$this->pes_r_tanam_tgl->setSort("");
				$this->pes_foto_lahan->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	function SetupListOptions() {
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->Add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->Add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->CanView();
		$item->OnLeft = TRUE;

		// "edit"
		$item = &$this->ListOptions->Add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->CanEdit();
		$item->OnLeft = TRUE;

		// "copy"
		$item = &$this->ListOptions->Add("copy");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->CanAdd();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->Add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->Add("checkbox");
		$item->Visible = $Security->CanDelete();
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew_SelectAllKey(this);\">";
		$item->MoveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseImageAndText = TRUE;
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->Phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		if ($this->ListOptions->UseButtonGroup && ew_IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;
		$this->ListOptions->ButtonClass = "btn-sm"; // Class for button group

		// Call ListOptions_Load event
		$this->ListOptions_Load();
		$this->SetupListOptionsExt();
		$item = &$this->ListOptions->GetItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->GroupOptionVisible();
	}

	// Render list options
	function RenderListOptions() {
		global $Security, $Language, $objForm;
		$this->ListOptions->LoadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$oListOpt = &$this->ListOptions->Items["view"];
		$viewcaption = ew_HtmlTitle($Language->Phrase("ViewLink"));
		if ($Security->CanView()) {
			$oListOpt->Body = "<a class=\"ewRowLink ewView\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . ew_HtmlEncode($this->ViewUrl) . "\">" . $Language->Phrase("ViewLink") . "</a>";
		} else {
			$oListOpt->Body = "";
		}

		// "edit"
		$oListOpt = &$this->ListOptions->Items["edit"];
		$editcaption = ew_HtmlTitle($Language->Phrase("EditLink"));
		if ($Security->CanEdit()) {
			$oListOpt->Body = "<a class=\"ewRowLink ewEdit\" title=\"" . ew_HtmlTitle($Language->Phrase("EditLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("EditLink")) . "\" href=\"" . ew_HtmlEncode($this->EditUrl) . "\">" . $Language->Phrase("EditLink") . "</a>";
		} else {
			$oListOpt->Body = "";
		}

		// "copy"
		$oListOpt = &$this->ListOptions->Items["copy"];
		$copycaption = ew_HtmlTitle($Language->Phrase("CopyLink"));
		if ($Security->CanAdd()) {
			$oListOpt->Body = "<a class=\"ewRowLink ewCopy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . ew_HtmlEncode($this->CopyUrl) . "\">" . $Language->Phrase("CopyLink") . "</a>";
		} else {
			$oListOpt->Body = "";
		}

		// Set up list action buttons
		$oListOpt = &$this->ListOptions->GetItem("listactions");
		if ($oListOpt && $this->Export == "" && $this->CurrentAction == "") {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode(str_replace(" ewIcon", "", $listaction->Icon)) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\"></span> " : "";
					$links[] = "<li><a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" title=\"" . ew_HtmlTitle($caption) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $Language->Phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default btn-sm ewActions\" title=\"" . ew_HtmlTitle($Language->Phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->Phrase("ListActionButton") . "<b class=\"caret\"></b></button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($oListOpt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$oListOpt->Body = $body;
				$oListOpt->Visible = TRUE;
			}
		}

		// "checkbox"
		$oListOpt = &$this->ListOptions->Items["checkbox"];
		$oListOpt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ewMultiSelect\" value=\"" . ew_HtmlEncode($this->pes_id->CurrentValue) . "\" onclick=\"ew_ClickMultiCheckbox(event);\">";
		$this->RenderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	function SetupOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->Add("add");
		$addcaption = ew_HtmlTitle($Language->Phrase("AddLink"));
		$item->Body = "<a class=\"ewAddEdit ewAdd\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . ew_HtmlEncode($this->AddUrl) . "\">" . $Language->Phrase("AddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->CanAdd());
		$option = $options["action"];

		// Add multi delete
		$item = &$option->Add("multidelete");
		$item->Body = "<a class=\"ewAction ewMultiDelete\" title=\"" . ew_HtmlTitle($Language->Phrase("DeleteSelectedLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("DeleteSelectedLink")) . "\" href=\"\" onclick=\"ew_SubmitAction(event,{f:document.fpesertalist,url:'" . $this->MultiDeleteUrl . "'});return false;\">" . $Language->Phrase("DeleteSelectedLink") . "</a>";
		$item->Visible = ($Security->CanDelete());

		// Set up options default
		foreach ($options as &$option) {
			$option->UseImageAndText = TRUE;
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;
			$option->ButtonClass = "btn-sm"; // Class for button group
			$item = &$option->Add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->Phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->Phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->Phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->Add("savecurrentfilter");
		$item->Body = "<a class=\"ewSaveFilter\" data-form=\"fpesertalistsrch\" href=\"#\">" . $Language->Phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->Add("deletefilter");
		$item->Body = "<a class=\"ewDeleteFilter\" data-form=\"fpesertalistsrch\" href=\"#\">" . $Language->Phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->Phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->Add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	function RenderOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_MULTIPLE) {
					$item = &$option->Add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode($listaction->Icon) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\"></span> " : $caption;
					$item->Body = "<a class=\"ewAction ewListAction\" title=\"" . ew_HtmlEncode($caption) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({f:document.fpesertalist}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->GetItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->HideAllOptions();
			}
	}

	// Process list action
	function ProcessListAction() {
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$sFilter = $this->GetKeyFilter();
		$UserAction = @$_POST["useraction"];
		if ($sFilter <> "" && $UserAction <> "") {

			// Check permission first
			$ActionCaption = $UserAction;
			if (array_key_exists($UserAction, $this->ListActions->Items)) {
				$ActionCaption = $this->ListActions->Items[$UserAction]->Caption;
				if (!$this->ListActions->Items[$UserAction]->Allow) {
					$errmsg = str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionNotAllowed"));
					if (@$_POST["ajax"] == $UserAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $sFilter;
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			$rs = $conn->Execute($sSql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $UserAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->BeginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$Processed = $this->Row_CustomAction($UserAction, $row);
					if (!$Processed) break;
					$rs->MoveNext();
				}
				if ($Processed) {
					$conn->CommitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->RollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->Close();
			$this->CurrentAction = ""; // Clear action
			if (@$_POST["ajax"] == $UserAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->ClearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->ClearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	function SetupSearchOptions() {
		global $Language;
		$this->SearchOptions = new cListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ewSearchOption";

		// Search button
		$item = &$this->SearchOptions->Add("searchtoggle");
		$SearchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ewSearchToggle" . $SearchToggleClass . "\" title=\"" . $Language->Phrase("SearchPanel") . "\" data-caption=\"" . $Language->Phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fpesertalistsrch\">" . $Language->Phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->Add("showall");
		$item->Body = "<a class=\"btn btn-default ewShowAll\" title=\"" . $Language->Phrase("ShowAll") . "\" data-caption=\"" . $Language->Phrase("ShowAll") . "\" href=\"" . $this->PageUrl() . "cmd=reset\">" . $Language->Phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseImageAndText = TRUE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->Phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->Add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->Export <> "" || $this->CurrentAction <> "")
			$this->SearchOptions->HideAllOptions();
		global $Security;
		if (!$Security->CanSearch()) {
			$this->SearchOptions->HideAllOptions();
			$this->FilterOptions->HideAllOptions();
		}
	}

	function SetupListOptionsExt() {
		global $Security, $Language;
	}

	function RenderListOptionsExt() {
		global $Security, $Language;
	}

	// Set up starting record parameters
	function SetupStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	function LoadBasicSearchValues() {
		$this->BasicSearch->Keyword = @$_GET[EW_TABLE_BASIC_SEARCH];
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "") $this->Command = "search";
		$this->BasicSearch->Type = @$_GET[EW_TABLE_BASIC_SEARCH_TYPE];
	}

	// Load search values for validation
	function LoadSearchValues() {
		global $objForm;

		// Load search values
		// pes_id

		$this->pes_id->AdvancedSearch->SearchValue = @$_GET["x_pes_id"];
		if ($this->pes_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->pes_id->AdvancedSearch->SearchOperator = @$_GET["z_pes_id"];

		// pes_nama
		$this->pes_nama->AdvancedSearch->SearchValue = @$_GET["x_pes_nama"];
		if ($this->pes_nama->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->pes_nama->AdvancedSearch->SearchOperator = @$_GET["z_pes_nama"];

		// sos_id
		$this->sos_id->AdvancedSearch->SearchValue = @$_GET["x_sos_id"];
		if ($this->sos_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->sos_id->AdvancedSearch->SearchOperator = @$_GET["z_sos_id"];

		// co_id
		$this->co_id->AdvancedSearch->SearchValue = @$_GET["x_co_id"];
		if ($this->co_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->co_id->AdvancedSearch->SearchOperator = @$_GET["z_co_id"];

		// prov_id
		$this->prov_id->AdvancedSearch->SearchValue = @$_GET["x_prov_id"];
		if ($this->prov_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->prov_id->AdvancedSearch->SearchOperator = @$_GET["z_prov_id"];

		// kab_id
		$this->kab_id->AdvancedSearch->SearchValue = @$_GET["x_kab_id"];
		if ($this->kab_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->kab_id->AdvancedSearch->SearchOperator = @$_GET["z_kab_id"];

		// kec_id
		$this->kec_id->AdvancedSearch->SearchValue = @$_GET["x_kec_id"];
		if ($this->kec_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->kec_id->AdvancedSearch->SearchOperator = @$_GET["z_kec_id"];

		// desa_id
		$this->desa_id->AdvancedSearch->SearchValue = @$_GET["x_desa_id"];
		if ($this->desa_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->desa_id->AdvancedSearch->SearchOperator = @$_GET["z_desa_id"];

		// pes_alamat
		$this->pes_alamat->AdvancedSearch->SearchValue = @$_GET["x_pes_alamat"];
		if ($this->pes_alamat->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->pes_alamat->AdvancedSearch->SearchOperator = @$_GET["z_pes_alamat"];

		// pes_hp
		$this->pes_hp->AdvancedSearch->SearchValue = @$_GET["x_pes_hp"];
		if ($this->pes_hp->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->pes_hp->AdvancedSearch->SearchOperator = @$_GET["z_pes_hp"];

		// pes_foto
		$this->pes_foto->AdvancedSearch->SearchValue = @$_GET["x_pes_foto"];
		if ($this->pes_foto->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->pes_foto->AdvancedSearch->SearchOperator = @$_GET["z_pes_foto"];

		// pes_luas_lahan
		$this->pes_luas_lahan->AdvancedSearch->SearchValue = @$_GET["x_pes_luas_lahan"];
		if ($this->pes_luas_lahan->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->pes_luas_lahan->AdvancedSearch->SearchOperator = @$_GET["z_pes_luas_lahan"];

		// pes_r_tanam_tgl
		$this->pes_r_tanam_tgl->AdvancedSearch->SearchValue = @$_GET["x_pes_r_tanam_tgl"];
		if ($this->pes_r_tanam_tgl->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->pes_r_tanam_tgl->AdvancedSearch->SearchOperator = @$_GET["z_pes_r_tanam_tgl"];

		// pes_foto_lahan
		$this->pes_foto_lahan->AdvancedSearch->SearchValue = @$_GET["x_pes_foto_lahan"];
		if ($this->pes_foto_lahan->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->pes_foto_lahan->AdvancedSearch->SearchOperator = @$_GET["z_pes_foto_lahan"];
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {

		// Load List page SQL
		$sSql = $this->ListSQL();
		$conn = &$this->Connection();

		// Load recordset
		$dbtype = ew_GetConnectionType($this->DBID);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset, array("_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderByList())));
			} else {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = ew_LoadRecordset($sSql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues($rs = NULL) {
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->NewRow(); 

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->pes_id->setDbValue($row['pes_id']);
		$this->pes_nama->setDbValue($row['pes_nama']);
		$this->sos_id->setDbValue($row['sos_id']);
		$this->co_id->setDbValue($row['co_id']);
		$this->prov_id->setDbValue($row['prov_id']);
		if (array_key_exists('EV__prov_id', $rs->fields)) {
			$this->prov_id->VirtualValue = $rs->fields('EV__prov_id'); // Set up virtual field value
		} else {
			$this->prov_id->VirtualValue = ""; // Clear value
		}
		$this->kab_id->setDbValue($row['kab_id']);
		if (array_key_exists('EV__kab_id', $rs->fields)) {
			$this->kab_id->VirtualValue = $rs->fields('EV__kab_id'); // Set up virtual field value
		} else {
			$this->kab_id->VirtualValue = ""; // Clear value
		}
		$this->kec_id->setDbValue($row['kec_id']);
		if (array_key_exists('EV__kec_id', $rs->fields)) {
			$this->kec_id->VirtualValue = $rs->fields('EV__kec_id'); // Set up virtual field value
		} else {
			$this->kec_id->VirtualValue = ""; // Clear value
		}
		$this->desa_id->setDbValue($row['desa_id']);
		if (array_key_exists('EV__desa_id', $rs->fields)) {
			$this->desa_id->VirtualValue = $rs->fields('EV__desa_id'); // Set up virtual field value
		} else {
			$this->desa_id->VirtualValue = ""; // Clear value
		}
		$this->pes_alamat->setDbValue($row['pes_alamat']);
		$this->pes_hp->setDbValue($row['pes_hp']);
		$this->pes_foto->Upload->DbValue = $row['pes_foto'];
		$this->pes_foto->setDbValue($this->pes_foto->Upload->DbValue);
		$this->pes_luas_lahan->setDbValue($row['pes_luas_lahan']);
		$this->pes_r_tanam_tgl->setDbValue($row['pes_r_tanam_tgl']);
		$this->pes_foto_lahan->Upload->DbValue = $row['pes_foto_lahan'];
		$this->pes_foto_lahan->setDbValue($this->pes_foto_lahan->Upload->DbValue);
	}

	// Return a row with default values
	function NewRow() {
		$row = array();
		$row['pes_id'] = NULL;
		$row['pes_nama'] = NULL;
		$row['sos_id'] = NULL;
		$row['co_id'] = NULL;
		$row['prov_id'] = NULL;
		$row['kab_id'] = NULL;
		$row['kec_id'] = NULL;
		$row['desa_id'] = NULL;
		$row['pes_alamat'] = NULL;
		$row['pes_hp'] = NULL;
		$row['pes_foto'] = NULL;
		$row['pes_luas_lahan'] = NULL;
		$row['pes_r_tanam_tgl'] = NULL;
		$row['pes_foto_lahan'] = NULL;
		return $row;
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->pes_id->DbValue = $row['pes_id'];
		$this->pes_nama->DbValue = $row['pes_nama'];
		$this->sos_id->DbValue = $row['sos_id'];
		$this->co_id->DbValue = $row['co_id'];
		$this->prov_id->DbValue = $row['prov_id'];
		$this->kab_id->DbValue = $row['kab_id'];
		$this->kec_id->DbValue = $row['kec_id'];
		$this->desa_id->DbValue = $row['desa_id'];
		$this->pes_alamat->DbValue = $row['pes_alamat'];
		$this->pes_hp->DbValue = $row['pes_hp'];
		$this->pes_foto->Upload->DbValue = $row['pes_foto'];
		$this->pes_luas_lahan->DbValue = $row['pes_luas_lahan'];
		$this->pes_r_tanam_tgl->DbValue = $row['pes_r_tanam_tgl'];
		$this->pes_foto_lahan->Upload->DbValue = $row['pes_foto_lahan'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("pes_id")) <> "")
			$this->pes_id->CurrentValue = $this->getKey("pes_id"); // pes_id
		else
			$bValidKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
		}
		$this->LoadRowValues($this->OldRecordset); // Load row values
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->GetViewUrl();
		$this->EditUrl = $this->GetEditUrl();
		$this->InlineEditUrl = $this->GetInlineEditUrl();
		$this->CopyUrl = $this->GetCopyUrl();
		$this->InlineCopyUrl = $this->GetInlineCopyUrl();
		$this->DeleteUrl = $this->GetDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// pes_id
		// pes_nama
		// sos_id
		// co_id
		// prov_id
		// kab_id
		// kec_id
		// desa_id
		// pes_alamat
		// pes_hp
		// pes_foto
		// pes_luas_lahan
		// pes_r_tanam_tgl
		// pes_foto_lahan

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// pes_id
		$this->pes_id->ViewValue = $this->pes_id->CurrentValue;
		$this->pes_id->ViewCustomAttributes = "";

		// pes_nama
		$this->pes_nama->ViewValue = $this->pes_nama->CurrentValue;
		$this->pes_nama->ViewCustomAttributes = "";

		// sos_id
		if (strval($this->sos_id->CurrentValue) <> "") {
			$sFilterWrk = "`sos_id`" . ew_SearchString("=", $this->sos_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `sos_id`, `sos_tgl` AS `DispFld`, `sos_kab` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `sosialisasi`";
		$sWhereWrk = "";
		$this->sos_id->LookupFilters = array("df1" => "0");
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->sos_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `sos_id` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = ew_FormatDateTime($rswrk->fields('DispFld'), 0);
				$arwrk[2] = $rswrk->fields('Disp2Fld');
				$this->sos_id->ViewValue = $this->sos_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->sos_id->ViewValue = $this->sos_id->CurrentValue;
			}
		} else {
			$this->sos_id->ViewValue = NULL;
		}
		$this->sos_id->ViewCustomAttributes = "";

		// co_id
		if (strval($this->co_id->CurrentValue) <> "") {
			$sFilterWrk = "`co_id`" . ew_SearchString("=", $this->co_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `co_id`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `co`";
		$sWhereWrk = "";
		$this->co_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->co_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->co_id->ViewValue = $this->co_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->co_id->ViewValue = $this->co_id->CurrentValue;
			}
		} else {
			$this->co_id->ViewValue = NULL;
		}
		$this->co_id->ViewCustomAttributes = "";

		// prov_id
		if ($this->prov_id->VirtualValue <> "") {
			$this->prov_id->ViewValue = $this->prov_id->VirtualValue;
		} else {
		if (strval($this->prov_id->CurrentValue) <> "") {
			$sFilterWrk = "`prov_id`" . ew_SearchString("=", $this->prov_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `prov_id`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `prov`";
		$sWhereWrk = "";
		$this->prov_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->prov_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `prov_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->prov_id->ViewValue = $this->prov_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->prov_id->ViewValue = $this->prov_id->CurrentValue;
			}
		} else {
			$this->prov_id->ViewValue = NULL;
		}
		}
		$this->prov_id->ViewCustomAttributes = "";

		// kab_id
		if ($this->kab_id->VirtualValue <> "") {
			$this->kab_id->ViewValue = $this->kab_id->VirtualValue;
		} else {
		if (strval($this->kab_id->CurrentValue) <> "") {
			$sFilterWrk = "`kab_id`" . ew_SearchString("=", $this->kab_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `kab_id`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kab`";
		$sWhereWrk = "";
		$this->kab_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->kab_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `kab_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->kab_id->ViewValue = $this->kab_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->kab_id->ViewValue = $this->kab_id->CurrentValue;
			}
		} else {
			$this->kab_id->ViewValue = NULL;
		}
		}
		$this->kab_id->ViewCustomAttributes = "";

		// kec_id
		if ($this->kec_id->VirtualValue <> "") {
			$this->kec_id->ViewValue = $this->kec_id->VirtualValue;
		} else {
		if (strval($this->kec_id->CurrentValue) <> "") {
			$sFilterWrk = "`kec_id`" . ew_SearchString("=", $this->kec_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `kec_id`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kec`";
		$sWhereWrk = "";
		$this->kec_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->kec_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `kec_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->kec_id->ViewValue = $this->kec_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->kec_id->ViewValue = $this->kec_id->CurrentValue;
			}
		} else {
			$this->kec_id->ViewValue = NULL;
		}
		}
		$this->kec_id->ViewCustomAttributes = "";

		// desa_id
		if ($this->desa_id->VirtualValue <> "") {
			$this->desa_id->ViewValue = $this->desa_id->VirtualValue;
		} else {
		if (strval($this->desa_id->CurrentValue) <> "") {
			$sFilterWrk = "`desa_id`" . ew_SearchString("=", $this->desa_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `desa_id`, `desa_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `desa`";
		$sWhereWrk = "";
		$this->desa_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->desa_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `desa_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->desa_id->ViewValue = $this->desa_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->desa_id->ViewValue = $this->desa_id->CurrentValue;
			}
		} else {
			$this->desa_id->ViewValue = NULL;
		}
		}
		$this->desa_id->ViewCustomAttributes = "";

		// pes_alamat
		$this->pes_alamat->ViewValue = $this->pes_alamat->CurrentValue;
		$this->pes_alamat->ViewCustomAttributes = "";

		// pes_hp
		$this->pes_hp->ViewValue = $this->pes_hp->CurrentValue;
		$this->pes_hp->ViewCustomAttributes = "";

		// pes_foto
		$this->pes_foto->UploadPath = "foto_peserta";
		if (!ew_Empty($this->pes_foto->Upload->DbValue)) {
			$this->pes_foto->ImageWidth = 60;
			$this->pes_foto->ImageHeight = 60;
			$this->pes_foto->ImageAlt = $this->pes_foto->FldAlt();
			$this->pes_foto->ViewValue = $this->pes_foto->Upload->DbValue;
		} else {
			$this->pes_foto->ViewValue = "";
		}
		$this->pes_foto->ViewCustomAttributes = "";

		// pes_luas_lahan
		$this->pes_luas_lahan->ViewValue = $this->pes_luas_lahan->CurrentValue;
		$this->pes_luas_lahan->CellCssStyle .= "text-align: right;";
		$this->pes_luas_lahan->ViewCustomAttributes = "";

		// pes_r_tanam_tgl
		$this->pes_r_tanam_tgl->ViewValue = $this->pes_r_tanam_tgl->CurrentValue;
		$this->pes_r_tanam_tgl->ViewValue = ew_FormatDateTime($this->pes_r_tanam_tgl->ViewValue, 0);
		$this->pes_r_tanam_tgl->ViewCustomAttributes = "";

		// pes_foto_lahan
		$this->pes_foto_lahan->UploadPath = "foto_potensi_lahan";
		if (!ew_Empty($this->pes_foto_lahan->Upload->DbValue)) {
			$this->pes_foto_lahan->ImageWidth = 80;
			$this->pes_foto_lahan->ImageHeight = 60;
			$this->pes_foto_lahan->ImageAlt = $this->pes_foto_lahan->FldAlt();
			$this->pes_foto_lahan->ViewValue = $this->pes_foto_lahan->Upload->DbValue;
		} else {
			$this->pes_foto_lahan->ViewValue = "";
		}
		$this->pes_foto_lahan->ViewCustomAttributes = "";

			// pes_id
			$this->pes_id->LinkCustomAttributes = "";
			$this->pes_id->HrefValue = "";
			$this->pes_id->TooltipValue = "";

			// pes_nama
			$this->pes_nama->LinkCustomAttributes = "";
			$this->pes_nama->HrefValue = "";
			$this->pes_nama->TooltipValue = "";

			// sos_id
			$this->sos_id->LinkCustomAttributes = "";
			$this->sos_id->HrefValue = "";
			$this->sos_id->TooltipValue = "";

			// co_id
			$this->co_id->LinkCustomAttributes = "";
			$this->co_id->HrefValue = "";
			$this->co_id->TooltipValue = "";

			// prov_id
			$this->prov_id->LinkCustomAttributes = "";
			$this->prov_id->HrefValue = "";
			$this->prov_id->TooltipValue = "";

			// kab_id
			$this->kab_id->LinkCustomAttributes = "";
			$this->kab_id->HrefValue = "";
			$this->kab_id->TooltipValue = "";

			// kec_id
			$this->kec_id->LinkCustomAttributes = "";
			$this->kec_id->HrefValue = "";
			$this->kec_id->TooltipValue = "";

			// desa_id
			$this->desa_id->LinkCustomAttributes = "";
			$this->desa_id->HrefValue = "";
			$this->desa_id->TooltipValue = "";

			// pes_alamat
			$this->pes_alamat->LinkCustomAttributes = "";
			$this->pes_alamat->HrefValue = "";
			$this->pes_alamat->TooltipValue = "";

			// pes_hp
			$this->pes_hp->LinkCustomAttributes = "";
			$this->pes_hp->HrefValue = "";
			$this->pes_hp->TooltipValue = "";

			// pes_foto
			$this->pes_foto->LinkCustomAttributes = "";
			$this->pes_foto->UploadPath = "foto_peserta";
			if (!ew_Empty($this->pes_foto->Upload->DbValue)) {
				$this->pes_foto->HrefValue = ew_GetFileUploadUrl($this->pes_foto, $this->pes_foto->Upload->DbValue); // Add prefix/suffix
				$this->pes_foto->LinkAttrs["target"] = ""; // Add target
				if ($this->Export <> "") $this->pes_foto->HrefValue = ew_FullUrl($this->pes_foto->HrefValue, "href");
			} else {
				$this->pes_foto->HrefValue = "";
			}
			$this->pes_foto->HrefValue2 = $this->pes_foto->UploadPath . $this->pes_foto->Upload->DbValue;
			$this->pes_foto->TooltipValue = "";
			if ($this->pes_foto->UseColorbox) {
				if (ew_Empty($this->pes_foto->TooltipValue))
					$this->pes_foto->LinkAttrs["title"] = $Language->Phrase("ViewImageGallery");
				$this->pes_foto->LinkAttrs["data-rel"] = "peserta_x" . $this->RowCnt . "_pes_foto";
				ew_AppendClass($this->pes_foto->LinkAttrs["class"], "ewLightbox");
			}

			// pes_luas_lahan
			$this->pes_luas_lahan->LinkCustomAttributes = "";
			$this->pes_luas_lahan->HrefValue = "";
			$this->pes_luas_lahan->TooltipValue = "";

			// pes_r_tanam_tgl
			$this->pes_r_tanam_tgl->LinkCustomAttributes = "";
			$this->pes_r_tanam_tgl->HrefValue = "";
			$this->pes_r_tanam_tgl->TooltipValue = "";

			// pes_foto_lahan
			$this->pes_foto_lahan->LinkCustomAttributes = "";
			$this->pes_foto_lahan->UploadPath = "foto_potensi_lahan";
			if (!ew_Empty($this->pes_foto_lahan->Upload->DbValue)) {
				$this->pes_foto_lahan->HrefValue = "%u"; // Add prefix/suffix
				$this->pes_foto_lahan->LinkAttrs["target"] = ""; // Add target
				if ($this->Export <> "") $this->pes_foto_lahan->HrefValue = ew_FullUrl($this->pes_foto_lahan->HrefValue, "href");
			} else {
				$this->pes_foto_lahan->HrefValue = "";
			}
			$this->pes_foto_lahan->HrefValue2 = $this->pes_foto_lahan->UploadPath . $this->pes_foto_lahan->Upload->DbValue;
			$this->pes_foto_lahan->TooltipValue = "";
			if ($this->pes_foto_lahan->UseColorbox) {
				if (ew_Empty($this->pes_foto_lahan->TooltipValue))
					$this->pes_foto_lahan->LinkAttrs["title"] = $Language->Phrase("ViewImageGallery");
				$this->pes_foto_lahan->LinkAttrs["data-rel"] = "peserta_x" . $this->RowCnt . "_pes_foto_lahan";
				ew_AppendClass($this->pes_foto_lahan->LinkAttrs["class"], "ewLightbox");
			}
		} elseif ($this->RowType == EW_ROWTYPE_SEARCH) { // Search row

			// pes_id
			$this->pes_id->EditAttrs["class"] = "form-control";
			$this->pes_id->EditCustomAttributes = "";
			$this->pes_id->EditValue = ew_HtmlEncode($this->pes_id->AdvancedSearch->SearchValue);
			$this->pes_id->PlaceHolder = ew_RemoveHtml($this->pes_id->FldCaption());

			// pes_nama
			$this->pes_nama->EditAttrs["class"] = "form-control";
			$this->pes_nama->EditCustomAttributes = "";
			$this->pes_nama->EditValue = ew_HtmlEncode($this->pes_nama->AdvancedSearch->SearchValue);
			$this->pes_nama->PlaceHolder = ew_RemoveHtml($this->pes_nama->FldCaption());

			// sos_id
			$this->sos_id->EditAttrs["class"] = "form-control";
			$this->sos_id->EditCustomAttributes = "";

			// co_id
			$this->co_id->EditAttrs["class"] = "form-control";
			$this->co_id->EditCustomAttributes = "";

			// prov_id
			$this->prov_id->EditAttrs["class"] = "form-control";
			$this->prov_id->EditCustomAttributes = "";
			$this->prov_id->EditValue = ew_HtmlEncode($this->prov_id->AdvancedSearch->SearchValue);
			$this->prov_id->PlaceHolder = ew_RemoveHtml($this->prov_id->FldCaption());

			// kab_id
			$this->kab_id->EditAttrs["class"] = "form-control";
			$this->kab_id->EditCustomAttributes = "";
			$this->kab_id->EditValue = ew_HtmlEncode($this->kab_id->AdvancedSearch->SearchValue);
			$this->kab_id->PlaceHolder = ew_RemoveHtml($this->kab_id->FldCaption());

			// kec_id
			$this->kec_id->EditAttrs["class"] = "form-control";
			$this->kec_id->EditCustomAttributes = "";
			$this->kec_id->EditValue = ew_HtmlEncode($this->kec_id->AdvancedSearch->SearchValue);
			$this->kec_id->PlaceHolder = ew_RemoveHtml($this->kec_id->FldCaption());

			// desa_id
			$this->desa_id->EditAttrs["class"] = "form-control";
			$this->desa_id->EditCustomAttributes = "";
			$this->desa_id->EditValue = ew_HtmlEncode($this->desa_id->AdvancedSearch->SearchValue);
			$this->desa_id->PlaceHolder = ew_RemoveHtml($this->desa_id->FldCaption());

			// pes_alamat
			$this->pes_alamat->EditAttrs["class"] = "form-control";
			$this->pes_alamat->EditCustomAttributes = "";
			$this->pes_alamat->EditValue = ew_HtmlEncode($this->pes_alamat->AdvancedSearch->SearchValue);
			$this->pes_alamat->PlaceHolder = ew_RemoveHtml($this->pes_alamat->FldCaption());

			// pes_hp
			$this->pes_hp->EditAttrs["class"] = "form-control";
			$this->pes_hp->EditCustomAttributes = "";
			$this->pes_hp->EditValue = ew_HtmlEncode($this->pes_hp->AdvancedSearch->SearchValue);
			$this->pes_hp->PlaceHolder = ew_RemoveHtml($this->pes_hp->FldCaption());

			// pes_foto
			$this->pes_foto->EditAttrs["class"] = "form-control";
			$this->pes_foto->EditCustomAttributes = "";
			$this->pes_foto->EditValue = ew_HtmlEncode($this->pes_foto->AdvancedSearch->SearchValue);
			$this->pes_foto->PlaceHolder = ew_RemoveHtml($this->pes_foto->FldCaption());

			// pes_luas_lahan
			$this->pes_luas_lahan->EditAttrs["class"] = "form-control";
			$this->pes_luas_lahan->EditCustomAttributes = "";
			$this->pes_luas_lahan->EditValue = ew_HtmlEncode($this->pes_luas_lahan->AdvancedSearch->SearchValue);
			$this->pes_luas_lahan->PlaceHolder = ew_RemoveHtml($this->pes_luas_lahan->FldCaption());

			// pes_r_tanam_tgl
			$this->pes_r_tanam_tgl->EditAttrs["class"] = "form-control";
			$this->pes_r_tanam_tgl->EditCustomAttributes = "";
			$this->pes_r_tanam_tgl->EditValue = ew_HtmlEncode(ew_FormatDateTime(ew_UnFormatDateTime($this->pes_r_tanam_tgl->AdvancedSearch->SearchValue, 0), 8));
			$this->pes_r_tanam_tgl->PlaceHolder = ew_RemoveHtml($this->pes_r_tanam_tgl->FldCaption());

			// pes_foto_lahan
			$this->pes_foto_lahan->EditAttrs["class"] = "form-control";
			$this->pes_foto_lahan->EditCustomAttributes = "";
			$this->pes_foto_lahan->EditValue = ew_HtmlEncode($this->pes_foto_lahan->AdvancedSearch->SearchValue);
			$this->pes_foto_lahan->PlaceHolder = ew_RemoveHtml($this->pes_foto_lahan->FldCaption());
		}
		if ($this->RowType == EW_ROWTYPE_ADD || $this->RowType == EW_ROWTYPE_EDIT || $this->RowType == EW_ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->SetupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	function ValidateSearch() {
		global $gsSearchError;

		// Initialize
		$gsSearchError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return TRUE;
		if (!ew_CheckDateDef($this->pes_r_tanam_tgl->AdvancedSearch->SearchValue)) {
			ew_AddMessage($gsSearchError, $this->pes_r_tanam_tgl->FldErrMsg());
		}

		// Return validate result
		$ValidateSearch = ($gsSearchError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateSearch = $ValidateSearch && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsSearchError, $sFormCustomError);
		}
		return $ValidateSearch;
	}

	// Load advanced search
	function LoadAdvancedSearch() {
		$this->pes_id->AdvancedSearch->Load();
		$this->pes_nama->AdvancedSearch->Load();
		$this->sos_id->AdvancedSearch->Load();
		$this->co_id->AdvancedSearch->Load();
		$this->prov_id->AdvancedSearch->Load();
		$this->kab_id->AdvancedSearch->Load();
		$this->kec_id->AdvancedSearch->Load();
		$this->desa_id->AdvancedSearch->Load();
		$this->pes_alamat->AdvancedSearch->Load();
		$this->pes_hp->AdvancedSearch->Load();
		$this->pes_foto->AdvancedSearch->Load();
		$this->pes_luas_lahan->AdvancedSearch->Load();
		$this->pes_r_tanam_tgl->AdvancedSearch->Load();
		$this->pes_foto_lahan->AdvancedSearch->Load();
	}

	// Set up export options
	function SetupExportOptions() {
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->Add("print");
		$item->Body = "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ewExportLink ewPrint\" title=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\">" . $Language->Phrase("PrinterFriendly") . "</a>";
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->Add("excel");
		$item->Body = "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ewExportLink ewExcel\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\">" . $Language->Phrase("ExportToExcel") . "</a>";
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->Add("word");
		$item->Body = "<a href=\"" . $this->ExportWordUrl . "\" class=\"ewExportLink ewWord\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\">" . $Language->Phrase("ExportToWord") . "</a>";
		$item->Visible = TRUE;

		// Export to Html
		$item = &$this->ExportOptions->Add("html");
		$item->Body = "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ewExportLink ewHtml\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\">" . $Language->Phrase("ExportToHtml") . "</a>";
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->Add("xml");
		$item->Body = "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ewExportLink ewXml\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\">" . $Language->Phrase("ExportToXml") . "</a>";
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->Add("csv");
		$item->Body = "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ewExportLink ewCsv\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\">" . $Language->Phrase("ExportToCsv") . "</a>";
		$item->Visible = FALSE;

		// Export to Pdf
		$item = &$this->ExportOptions->Add("pdf");
		$item->Body = "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ewExportLink ewPdf\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\">" . $Language->Phrase("ExportToPDF") . "</a>";
		$item->Visible = FALSE;

		// Export to Email
		$item = &$this->ExportOptions->Add("email");
		$url = "";
		$item->Body = "<button id=\"emf_peserta\" class=\"ewExportLink ewEmail\" title=\"" . $Language->Phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->Phrase("ExportToEmailText") . "\" onclick=\"ew_EmailDialogShow({lnk:'emf_peserta',hdr:ewLanguage.Phrase('ExportToEmailText'),f:document.fpesertalist,sel:false" . $url . "});\">" . $Language->Phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseImageAndText = TRUE;
		$this->ExportOptions->UseDropDownButton = FALSE;
		if ($this->ExportOptions->UseButtonGroup && ew_IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->Phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->Add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	function ExportData() {
		$utf8 = (strtolower(EW_CHARSET) == "utf-8");
		$bSelectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($bSelectLimit) {
			$this->TotalRecs = $this->ListRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->LoadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EW_EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->SetupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($bSelectLimit)
			$rs = $this->LoadRecordset($this->StartRec-1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		if (!$rs) {
			header("Content-Type:"); // Remove header
			header("Content-Disposition:");
			$this->ShowMessage();
			return;
		}
		$this->ExportDoc = ew_ExportDocument($this, "h");
		$Doc = &$this->ExportDoc;
		if ($bSelectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		} else {

			//$this->StartRec = $this->StartRec;
			//$this->StopRec = $this->StopRec;

		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$ParentTable = "";
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		$Doc->Text .= $sHeader;
		$this->ExportDocument($Doc, $rs, $this->StartRec, $this->StopRec, "");
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		$Doc->Text .= $sFooter;

		// Close recordset
		$rs->Close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$Doc->ExportHeaderAndFooter();

		// Clean output buffer
		if (!EW_DEBUG_ENABLED && ob_get_length())
			ob_end_clean();

		// Write debug message if enabled
		if (EW_DEBUG_ENABLED && $this->Export <> "pdf")
			echo ew_DebugMsg();

		// Output data
		$Doc->Export();
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->Add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup filters of a field
	function SetupLookupFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		if ($pageId == "list") {
			switch ($fld->FldVar) {
			}
		} elseif ($pageId == "extbs") {
			switch ($fld->FldVar) {
			}
		}
	}

	// Setup AutoSuggest filters of a field
	function SetupAutoSuggestFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		if ($pageId == "list") {
			switch ($fld->FldVar) {
			}
		} elseif ($pageId == "extbs") {
			switch ($fld->FldVar) {
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($peserta_list)) $peserta_list = new cpeserta_list();

// Page init
$peserta_list->Page_Init();

// Page main
$peserta_list->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$peserta_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if ($peserta->Export == "") { ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "list";
var CurrentForm = fpesertalist = new ew_Form("fpesertalist", "list");
fpesertalist.FormKeyCountName = '<?php echo $peserta_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpesertalist.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fpesertalist.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpesertalist.Lists["x_sos_id"] = {"LinkField":"x_sos_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_sos_tgl","x_sos_kab","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"sosialisasi"};
fpesertalist.Lists["x_sos_id"].Data = "<?php echo $peserta_list->sos_id->LookupFilterQuery(FALSE, "list") ?>";
fpesertalist.Lists["x_co_id"] = {"LinkField":"x_co_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_co_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"co"};
fpesertalist.Lists["x_co_id"].Data = "<?php echo $peserta_list->co_id->LookupFilterQuery(FALSE, "list") ?>";
fpesertalist.Lists["x_prov_id"] = {"LinkField":"x_prov_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_prov_nama","","",""],"ParentFields":[],"ChildFields":["x_kab_id","x_kec_id","x_desa_id"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"prov"};
fpesertalist.Lists["x_prov_id"].Data = "<?php echo $peserta_list->prov_id->LookupFilterQuery(FALSE, "list") ?>";
fpesertalist.Lists["x_kab_id"] = {"LinkField":"x_kab_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kab_nama","","",""],"ParentFields":[],"ChildFields":["x_kec_id","x_desa_id"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kab"};
fpesertalist.Lists["x_kab_id"].Data = "<?php echo $peserta_list->kab_id->LookupFilterQuery(FALSE, "list") ?>";
fpesertalist.Lists["x_kec_id"] = {"LinkField":"x_kec_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kec_nama","","",""],"ParentFields":[],"ChildFields":["x_desa_id"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kec"};
fpesertalist.Lists["x_kec_id"].Data = "<?php echo $peserta_list->kec_id->LookupFilterQuery(FALSE, "list") ?>";
fpesertalist.Lists["x_desa_id"] = {"LinkField":"x_desa_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_desa_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"desa"};
fpesertalist.Lists["x_desa_id"].Data = "<?php echo $peserta_list->desa_id->LookupFilterQuery(FALSE, "list") ?>";

// Form object for search
var CurrentSearchForm = fpesertalistsrch = new ew_Form("fpesertalistsrch");

// Validate function for search
fpesertalistsrch.Validate = function(fobj) {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	fobj = fobj || this.Form;
	var infix = "";
	elm = this.GetElements("x" + infix + "_pes_r_tanam_tgl");
	if (elm && !ew_CheckDateDef(elm.value))
		return this.OnError(elm, "<?php echo ew_JsEncode2($peserta->pes_r_tanam_tgl->FldErrMsg()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fpesertalistsrch.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fpesertalistsrch.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Init search panel as collapsed

if (fpesertalistsrch) fpesertalistsrch.InitSearchPanel = true;
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if ($peserta->Export == "") { ?>
<div class="ewToolbar">
<?php if ($peserta_list->TotalRecs > 0 && $peserta_list->ExportOptions->Visible()) { ?>
<?php $peserta_list->ExportOptions->Render("body") ?>
<?php } ?>
<?php if ($peserta_list->SearchOptions->Visible()) { ?>
<?php $peserta_list->SearchOptions->Render("body") ?>
<?php } ?>
<?php if ($peserta_list->FilterOptions->Visible()) { ?>
<?php $peserta_list->FilterOptions->Render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
	$bSelectLimit = $peserta_list->UseSelectLimit;
	if ($bSelectLimit) {
		if ($peserta_list->TotalRecs <= 0)
			$peserta_list->TotalRecs = $peserta->ListRecordCount();
	} else {
		if (!$peserta_list->Recordset && ($peserta_list->Recordset = $peserta_list->LoadRecordset()))
			$peserta_list->TotalRecs = $peserta_list->Recordset->RecordCount();
	}
	$peserta_list->StartRec = 1;
	if ($peserta_list->DisplayRecs <= 0 || ($peserta->Export <> "" && $peserta->ExportAll)) // Display all records
		$peserta_list->DisplayRecs = $peserta_list->TotalRecs;
	if (!($peserta->Export <> "" && $peserta->ExportAll))
		$peserta_list->SetupStartRec(); // Set up start record position
	if ($bSelectLimit)
		$peserta_list->Recordset = $peserta_list->LoadRecordset($peserta_list->StartRec-1, $peserta_list->DisplayRecs);

	// Set no record found message
	if ($peserta->CurrentAction == "" && $peserta_list->TotalRecs == 0) {
		if (!$Security->CanList())
			$peserta_list->setWarningMessage(ew_DeniedMsg());
		if ($peserta_list->SearchWhere == "0=101")
			$peserta_list->setWarningMessage($Language->Phrase("EnterSearchCriteria"));
		else
			$peserta_list->setWarningMessage($Language->Phrase("NoRecord"));
	}
$peserta_list->RenderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if ($peserta->Export == "" && $peserta->CurrentAction == "") { ?>
<form name="fpesertalistsrch" id="fpesertalistsrch" class="form-inline ewForm ewExtSearchForm" action="<?php echo ew_CurrentPage() ?>">
<?php $SearchPanelClass = ($peserta_list->SearchWhere <> "") ? " in" : ""; ?>
<div id="fpesertalistsrch_SearchPanel" class="ewSearchPanel collapse<?php echo $SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="peserta">
	<div class="ewBasicSearch">
<?php
if ($gsSearchError == "")
	$peserta_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$peserta->RowType = EW_ROWTYPE_SEARCH;

// Render row
$peserta->ResetAttrs();
$peserta_list->RenderRow();
?>
<div id="xsr_1" class="ewRow">
<?php if ($peserta->pes_nama->Visible) { // pes_nama ?>
	<div id="xsc_pes_nama" class="ewCell form-group">
		<label for="x_pes_nama" class="ewSearchCaption ewLabel"><?php echo $peserta->pes_nama->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_pes_nama" id="z_pes_nama" value="LIKE"></span>
		<span class="ewSearchField">
<input type="text" data-table="peserta" data-field="x_pes_nama" name="x_pes_nama" id="x_pes_nama" size="30" maxlength="100" placeholder="<?php echo ew_HtmlEncode($peserta->pes_nama->getPlaceHolder()) ?>" value="<?php echo $peserta->pes_nama->EditValue ?>"<?php echo $peserta->pes_nama->EditAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ewRow">
<?php if ($peserta->pes_alamat->Visible) { // pes_alamat ?>
	<div id="xsc_pes_alamat" class="ewCell form-group">
		<label for="x_pes_alamat" class="ewSearchCaption ewLabel"><?php echo $peserta->pes_alamat->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_pes_alamat" id="z_pes_alamat" value="LIKE"></span>
		<span class="ewSearchField">
<input type="text" data-table="peserta" data-field="x_pes_alamat" name="x_pes_alamat" id="x_pes_alamat" size="30" maxlength="200" placeholder="<?php echo ew_HtmlEncode($peserta->pes_alamat->getPlaceHolder()) ?>" value="<?php echo $peserta->pes_alamat->EditValue ?>"<?php echo $peserta->pes_alamat->EditAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ewRow">
<?php if ($peserta->pes_r_tanam_tgl->Visible) { // pes_r_tanam_tgl ?>
	<div id="xsc_pes_r_tanam_tgl" class="ewCell form-group">
		<label for="x_pes_r_tanam_tgl" class="ewSearchCaption ewLabel"><?php echo $peserta->pes_r_tanam_tgl->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_pes_r_tanam_tgl" id="z_pes_r_tanam_tgl" value="="></span>
		<span class="ewSearchField">
<input type="text" data-table="peserta" data-field="x_pes_r_tanam_tgl" name="x_pes_r_tanam_tgl" id="x_pes_r_tanam_tgl" placeholder="<?php echo ew_HtmlEncode($peserta->pes_r_tanam_tgl->getPlaceHolder()) ?>" value="<?php echo $peserta->pes_r_tanam_tgl->EditValue ?>"<?php echo $peserta->pes_r_tanam_tgl->EditAttributes() ?>>
<?php if (!$peserta->pes_r_tanam_tgl->ReadOnly && !$peserta->pes_r_tanam_tgl->Disabled && !isset($peserta->pes_r_tanam_tgl->EditAttrs["readonly"]) && !isset($peserta->pes_r_tanam_tgl->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("fpesertalistsrch", "x_pes_r_tanam_tgl", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ewRow">
	<div class="ewQuickSearch input-group">
	<input type="text" name="<?php echo EW_TABLE_BASIC_SEARCH ?>" id="<?php echo EW_TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo ew_HtmlEncode($peserta_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo ew_HtmlEncode($Language->Phrase("Search")) ?>">
	<input type="hidden" name="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo ew_HtmlEncode($peserta_list->BasicSearch->getType()) ?>">
	<div class="input-group-btn">
		<button type="button" data-toggle="dropdown" class="btn btn-default"><span id="searchtype"><?php echo $peserta_list->BasicSearch->getTypeNameShort() ?></span><span class="caret"></span></button>
		<ul class="dropdown-menu pull-right" role="menu">
			<li<?php if ($peserta_list->BasicSearch->getType() == "") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this)"><?php echo $Language->Phrase("QuickSearchAuto") ?></a></li>
			<li<?php if ($peserta_list->BasicSearch->getType() == "=") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'=')"><?php echo $Language->Phrase("QuickSearchExact") ?></a></li>
			<li<?php if ($peserta_list->BasicSearch->getType() == "AND") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'AND')"><?php echo $Language->Phrase("QuickSearchAll") ?></a></li>
			<li<?php if ($peserta_list->BasicSearch->getType() == "OR") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'OR')"><?php echo $Language->Phrase("QuickSearchAny") ?></a></li>
		</ul>
	<button class="btn btn-primary ewButton" name="btnsubmit" id="btnsubmit" type="submit"><?php echo $Language->Phrase("SearchBtn") ?></button>
	</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $peserta_list->ShowPageHeader(); ?>
<?php
$peserta_list->ShowMessage();
?>
<?php if ($peserta_list->TotalRecs > 0 || $peserta->CurrentAction <> "") { ?>
<div class="box ewBox ewGrid<?php if ($peserta_list->IsAddOrEdit()) { ?> ewGridAddEdit<?php } ?> peserta">
<?php if ($peserta->Export == "") { ?>
<div class="box-header ewGridUpperPanel">
<?php if ($peserta->CurrentAction <> "gridadd" && $peserta->CurrentAction <> "gridedit") { ?>
<form name="ewPagerForm" class="form-inline ewForm ewPagerForm" action="<?php echo ew_CurrentPage() ?>">
<?php if (!isset($peserta_list->Pager)) $peserta_list->Pager = new cNumericPager($peserta_list->StartRec, $peserta_list->DisplayRecs, $peserta_list->TotalRecs, $peserta_list->RecRange, $peserta_list->AutoHidePager) ?>
<?php if ($peserta_list->Pager->RecordCount > 0 && $peserta_list->Pager->Visible) { ?>
<div class="ewPager">
<div class="ewNumericPage"><ul class="pagination">
	<?php if ($peserta_list->Pager->FirstButton->Enabled) { ?>
	<li><a href="<?php echo $peserta_list->PageUrl() ?>start=<?php echo $peserta_list->Pager->FirstButton->Start ?>"><?php echo $Language->Phrase("PagerFirst") ?></a></li>
	<?php } ?>
	<?php if ($peserta_list->Pager->PrevButton->Enabled) { ?>
	<li><a href="<?php echo $peserta_list->PageUrl() ?>start=<?php echo $peserta_list->Pager->PrevButton->Start ?>"><?php echo $Language->Phrase("PagerPrevious") ?></a></li>
	<?php } ?>
	<?php foreach ($peserta_list->Pager->Items as $PagerItem) { ?>
		<li<?php if (!$PagerItem->Enabled) { echo " class=\" active\""; } ?>><a href="<?php if ($PagerItem->Enabled) { echo $peserta_list->PageUrl() . "start=" . $PagerItem->Start; } else { echo "#"; } ?>"><?php echo $PagerItem->Text ?></a></li>
	<?php } ?>
	<?php if ($peserta_list->Pager->NextButton->Enabled) { ?>
	<li><a href="<?php echo $peserta_list->PageUrl() ?>start=<?php echo $peserta_list->Pager->NextButton->Start ?>"><?php echo $Language->Phrase("PagerNext") ?></a></li>
	<?php } ?>
	<?php if ($peserta_list->Pager->LastButton->Enabled) { ?>
	<li><a href="<?php echo $peserta_list->PageUrl() ?>start=<?php echo $peserta_list->Pager->LastButton->Start ?>"><?php echo $Language->Phrase("PagerLast") ?></a></li>
	<?php } ?>
</ul></div>
</div>
<?php } ?>
<?php if ($peserta_list->Pager->RecordCount > 0) { ?>
<div class="ewPager ewRec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $peserta_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $peserta_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $peserta_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ewListOtherOptions">
<?php
	foreach ($peserta_list->OtherOptions as &$option)
		$option->Render("body");
?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpesertalist" id="fpesertalist" class="form-inline ewForm ewListForm" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($peserta_list->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $peserta_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="peserta">
<div id="gmp_peserta" class="<?php if (ew_IsResponsiveLayout()) { ?>table-responsive <?php } ?>ewGridMiddlePanel">
<?php if ($peserta_list->TotalRecs > 0 || $peserta->CurrentAction == "gridedit") { ?>
<table id="tbl_pesertalist" class="table ewTable">
<thead>
	<tr class="ewTableHeader">
<?php

// Header row
$peserta_list->RowType = EW_ROWTYPE_HEADER;

// Render list options
$peserta_list->RenderListOptions();

// Render list options (header, left)
$peserta_list->ListOptions->Render("header", "left");
?>
<?php if ($peserta->pes_id->Visible) { // pes_id ?>
	<?php if ($peserta->SortUrl($peserta->pes_id) == "") { ?>
		<th data-name="pes_id" class="<?php echo $peserta->pes_id->HeaderCellClass() ?>"><div id="elh_peserta_pes_id" class="peserta_pes_id"><div class="ewTableHeaderCaption"><?php echo $peserta->pes_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pes_id" class="<?php echo $peserta->pes_id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $peserta->SortUrl($peserta->pes_id) ?>',1);"><div id="elh_peserta_pes_id" class="peserta_pes_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $peserta->pes_id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($peserta->pes_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($peserta->pes_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($peserta->pes_nama->Visible) { // pes_nama ?>
	<?php if ($peserta->SortUrl($peserta->pes_nama) == "") { ?>
		<th data-name="pes_nama" class="<?php echo $peserta->pes_nama->HeaderCellClass() ?>"><div id="elh_peserta_pes_nama" class="peserta_pes_nama"><div class="ewTableHeaderCaption"><?php echo $peserta->pes_nama->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pes_nama" class="<?php echo $peserta->pes_nama->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $peserta->SortUrl($peserta->pes_nama) ?>',1);"><div id="elh_peserta_pes_nama" class="peserta_pes_nama">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $peserta->pes_nama->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($peserta->pes_nama->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($peserta->pes_nama->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($peserta->sos_id->Visible) { // sos_id ?>
	<?php if ($peserta->SortUrl($peserta->sos_id) == "") { ?>
		<th data-name="sos_id" class="<?php echo $peserta->sos_id->HeaderCellClass() ?>"><div id="elh_peserta_sos_id" class="peserta_sos_id"><div class="ewTableHeaderCaption"><?php echo $peserta->sos_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sos_id" class="<?php echo $peserta->sos_id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $peserta->SortUrl($peserta->sos_id) ?>',1);"><div id="elh_peserta_sos_id" class="peserta_sos_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $peserta->sos_id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($peserta->sos_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($peserta->sos_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($peserta->co_id->Visible) { // co_id ?>
	<?php if ($peserta->SortUrl($peserta->co_id) == "") { ?>
		<th data-name="co_id" class="<?php echo $peserta->co_id->HeaderCellClass() ?>"><div id="elh_peserta_co_id" class="peserta_co_id"><div class="ewTableHeaderCaption"><?php echo $peserta->co_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="co_id" class="<?php echo $peserta->co_id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $peserta->SortUrl($peserta->co_id) ?>',1);"><div id="elh_peserta_co_id" class="peserta_co_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $peserta->co_id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($peserta->co_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($peserta->co_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($peserta->prov_id->Visible) { // prov_id ?>
	<?php if ($peserta->SortUrl($peserta->prov_id) == "") { ?>
		<th data-name="prov_id" class="<?php echo $peserta->prov_id->HeaderCellClass() ?>"><div id="elh_peserta_prov_id" class="peserta_prov_id"><div class="ewTableHeaderCaption"><?php echo $peserta->prov_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="prov_id" class="<?php echo $peserta->prov_id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $peserta->SortUrl($peserta->prov_id) ?>',1);"><div id="elh_peserta_prov_id" class="peserta_prov_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $peserta->prov_id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($peserta->prov_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($peserta->prov_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($peserta->kab_id->Visible) { // kab_id ?>
	<?php if ($peserta->SortUrl($peserta->kab_id) == "") { ?>
		<th data-name="kab_id" class="<?php echo $peserta->kab_id->HeaderCellClass() ?>"><div id="elh_peserta_kab_id" class="peserta_kab_id"><div class="ewTableHeaderCaption"><?php echo $peserta->kab_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="kab_id" class="<?php echo $peserta->kab_id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $peserta->SortUrl($peserta->kab_id) ?>',1);"><div id="elh_peserta_kab_id" class="peserta_kab_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $peserta->kab_id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($peserta->kab_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($peserta->kab_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($peserta->kec_id->Visible) { // kec_id ?>
	<?php if ($peserta->SortUrl($peserta->kec_id) == "") { ?>
		<th data-name="kec_id" class="<?php echo $peserta->kec_id->HeaderCellClass() ?>"><div id="elh_peserta_kec_id" class="peserta_kec_id"><div class="ewTableHeaderCaption"><?php echo $peserta->kec_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="kec_id" class="<?php echo $peserta->kec_id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $peserta->SortUrl($peserta->kec_id) ?>',1);"><div id="elh_peserta_kec_id" class="peserta_kec_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $peserta->kec_id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($peserta->kec_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($peserta->kec_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($peserta->desa_id->Visible) { // desa_id ?>
	<?php if ($peserta->SortUrl($peserta->desa_id) == "") { ?>
		<th data-name="desa_id" class="<?php echo $peserta->desa_id->HeaderCellClass() ?>"><div id="elh_peserta_desa_id" class="peserta_desa_id"><div class="ewTableHeaderCaption"><?php echo $peserta->desa_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="desa_id" class="<?php echo $peserta->desa_id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $peserta->SortUrl($peserta->desa_id) ?>',1);"><div id="elh_peserta_desa_id" class="peserta_desa_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $peserta->desa_id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($peserta->desa_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($peserta->desa_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($peserta->pes_alamat->Visible) { // pes_alamat ?>
	<?php if ($peserta->SortUrl($peserta->pes_alamat) == "") { ?>
		<th data-name="pes_alamat" class="<?php echo $peserta->pes_alamat->HeaderCellClass() ?>"><div id="elh_peserta_pes_alamat" class="peserta_pes_alamat"><div class="ewTableHeaderCaption"><?php echo $peserta->pes_alamat->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pes_alamat" class="<?php echo $peserta->pes_alamat->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $peserta->SortUrl($peserta->pes_alamat) ?>',1);"><div id="elh_peserta_pes_alamat" class="peserta_pes_alamat">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $peserta->pes_alamat->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($peserta->pes_alamat->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($peserta->pes_alamat->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($peserta->pes_hp->Visible) { // pes_hp ?>
	<?php if ($peserta->SortUrl($peserta->pes_hp) == "") { ?>
		<th data-name="pes_hp" class="<?php echo $peserta->pes_hp->HeaderCellClass() ?>"><div id="elh_peserta_pes_hp" class="peserta_pes_hp"><div class="ewTableHeaderCaption"><?php echo $peserta->pes_hp->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pes_hp" class="<?php echo $peserta->pes_hp->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $peserta->SortUrl($peserta->pes_hp) ?>',1);"><div id="elh_peserta_pes_hp" class="peserta_pes_hp">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $peserta->pes_hp->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($peserta->pes_hp->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($peserta->pes_hp->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($peserta->pes_foto->Visible) { // pes_foto ?>
	<?php if ($peserta->SortUrl($peserta->pes_foto) == "") { ?>
		<th data-name="pes_foto" class="<?php echo $peserta->pes_foto->HeaderCellClass() ?>"><div id="elh_peserta_pes_foto" class="peserta_pes_foto"><div class="ewTableHeaderCaption"><?php echo $peserta->pes_foto->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pes_foto" class="<?php echo $peserta->pes_foto->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $peserta->SortUrl($peserta->pes_foto) ?>',1);"><div id="elh_peserta_pes_foto" class="peserta_pes_foto">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $peserta->pes_foto->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($peserta->pes_foto->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($peserta->pes_foto->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($peserta->pes_luas_lahan->Visible) { // pes_luas_lahan ?>
	<?php if ($peserta->SortUrl($peserta->pes_luas_lahan) == "") { ?>
		<th data-name="pes_luas_lahan" class="<?php echo $peserta->pes_luas_lahan->HeaderCellClass() ?>"><div id="elh_peserta_pes_luas_lahan" class="peserta_pes_luas_lahan"><div class="ewTableHeaderCaption"><?php echo $peserta->pes_luas_lahan->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pes_luas_lahan" class="<?php echo $peserta->pes_luas_lahan->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $peserta->SortUrl($peserta->pes_luas_lahan) ?>',1);"><div id="elh_peserta_pes_luas_lahan" class="peserta_pes_luas_lahan">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $peserta->pes_luas_lahan->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($peserta->pes_luas_lahan->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($peserta->pes_luas_lahan->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($peserta->pes_r_tanam_tgl->Visible) { // pes_r_tanam_tgl ?>
	<?php if ($peserta->SortUrl($peserta->pes_r_tanam_tgl) == "") { ?>
		<th data-name="pes_r_tanam_tgl" class="<?php echo $peserta->pes_r_tanam_tgl->HeaderCellClass() ?>"><div id="elh_peserta_pes_r_tanam_tgl" class="peserta_pes_r_tanam_tgl"><div class="ewTableHeaderCaption"><?php echo $peserta->pes_r_tanam_tgl->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pes_r_tanam_tgl" class="<?php echo $peserta->pes_r_tanam_tgl->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $peserta->SortUrl($peserta->pes_r_tanam_tgl) ?>',1);"><div id="elh_peserta_pes_r_tanam_tgl" class="peserta_pes_r_tanam_tgl">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $peserta->pes_r_tanam_tgl->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($peserta->pes_r_tanam_tgl->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($peserta->pes_r_tanam_tgl->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($peserta->pes_foto_lahan->Visible) { // pes_foto_lahan ?>
	<?php if ($peserta->SortUrl($peserta->pes_foto_lahan) == "") { ?>
		<th data-name="pes_foto_lahan" class="<?php echo $peserta->pes_foto_lahan->HeaderCellClass() ?>"><div id="elh_peserta_pes_foto_lahan" class="peserta_pes_foto_lahan"><div class="ewTableHeaderCaption"><?php echo $peserta->pes_foto_lahan->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pes_foto_lahan" class="<?php echo $peserta->pes_foto_lahan->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $peserta->SortUrl($peserta->pes_foto_lahan) ?>',1);"><div id="elh_peserta_pes_foto_lahan" class="peserta_pes_foto_lahan">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $peserta->pes_foto_lahan->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($peserta->pes_foto_lahan->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($peserta->pes_foto_lahan->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$peserta_list->ListOptions->Render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($peserta->ExportAll && $peserta->Export <> "") {
	$peserta_list->StopRec = $peserta_list->TotalRecs;
} else {

	// Set the last record to display
	if ($peserta_list->TotalRecs > $peserta_list->StartRec + $peserta_list->DisplayRecs - 1)
		$peserta_list->StopRec = $peserta_list->StartRec + $peserta_list->DisplayRecs - 1;
	else
		$peserta_list->StopRec = $peserta_list->TotalRecs;
}
$peserta_list->RecCnt = $peserta_list->StartRec - 1;
if ($peserta_list->Recordset && !$peserta_list->Recordset->EOF) {
	$peserta_list->Recordset->MoveFirst();
	$bSelectLimit = $peserta_list->UseSelectLimit;
	if (!$bSelectLimit && $peserta_list->StartRec > 1)
		$peserta_list->Recordset->Move($peserta_list->StartRec - 1);
} elseif (!$peserta->AllowAddDeleteRow && $peserta_list->StopRec == 0) {
	$peserta_list->StopRec = $peserta->GridAddRowCount;
}

// Initialize aggregate
$peserta->RowType = EW_ROWTYPE_AGGREGATEINIT;
$peserta->ResetAttrs();
$peserta_list->RenderRow();
while ($peserta_list->RecCnt < $peserta_list->StopRec) {
	$peserta_list->RecCnt++;
	if (intval($peserta_list->RecCnt) >= intval($peserta_list->StartRec)) {
		$peserta_list->RowCnt++;

		// Set up key count
		$peserta_list->KeyCount = $peserta_list->RowIndex;

		// Init row class and style
		$peserta->ResetAttrs();
		$peserta->CssClass = "";
		if ($peserta->CurrentAction == "gridadd") {
		} else {
			$peserta_list->LoadRowValues($peserta_list->Recordset); // Load row values
		}
		$peserta->RowType = EW_ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$peserta->RowAttrs = array_merge($peserta->RowAttrs, array('data-rowindex'=>$peserta_list->RowCnt, 'id'=>'r' . $peserta_list->RowCnt . '_peserta', 'data-rowtype'=>$peserta->RowType));

		// Render row
		$peserta_list->RenderRow();

		// Render list options
		$peserta_list->RenderListOptions();
?>
	<tr<?php echo $peserta->RowAttributes() ?>>
<?php

// Render list options (body, left)
$peserta_list->ListOptions->Render("body", "left", $peserta_list->RowCnt);
?>
	<?php if ($peserta->pes_id->Visible) { // pes_id ?>
		<td data-name="pes_id"<?php echo $peserta->pes_id->CellAttributes() ?>>
<span id="el<?php echo $peserta_list->RowCnt ?>_peserta_pes_id" class="peserta_pes_id">
<span<?php echo $peserta->pes_id->ViewAttributes() ?>>
<?php echo $peserta->pes_id->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($peserta->pes_nama->Visible) { // pes_nama ?>
		<td data-name="pes_nama"<?php echo $peserta->pes_nama->CellAttributes() ?>>
<span id="el<?php echo $peserta_list->RowCnt ?>_peserta_pes_nama" class="peserta_pes_nama">
<span<?php echo $peserta->pes_nama->ViewAttributes() ?>>
<?php echo $peserta->pes_nama->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($peserta->sos_id->Visible) { // sos_id ?>
		<td data-name="sos_id"<?php echo $peserta->sos_id->CellAttributes() ?>>
<span id="el<?php echo $peserta_list->RowCnt ?>_peserta_sos_id" class="peserta_sos_id">
<span<?php echo $peserta->sos_id->ViewAttributes() ?>>
<?php echo $peserta->sos_id->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($peserta->co_id->Visible) { // co_id ?>
		<td data-name="co_id"<?php echo $peserta->co_id->CellAttributes() ?>>
<span id="el<?php echo $peserta_list->RowCnt ?>_peserta_co_id" class="peserta_co_id">
<span<?php echo $peserta->co_id->ViewAttributes() ?>>
<?php echo $peserta->co_id->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($peserta->prov_id->Visible) { // prov_id ?>
		<td data-name="prov_id"<?php echo $peserta->prov_id->CellAttributes() ?>>
<span id="el<?php echo $peserta_list->RowCnt ?>_peserta_prov_id" class="peserta_prov_id">
<span<?php echo $peserta->prov_id->ViewAttributes() ?>>
<?php echo $peserta->prov_id->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($peserta->kab_id->Visible) { // kab_id ?>
		<td data-name="kab_id"<?php echo $peserta->kab_id->CellAttributes() ?>>
<span id="el<?php echo $peserta_list->RowCnt ?>_peserta_kab_id" class="peserta_kab_id">
<span<?php echo $peserta->kab_id->ViewAttributes() ?>>
<?php echo $peserta->kab_id->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($peserta->kec_id->Visible) { // kec_id ?>
		<td data-name="kec_id"<?php echo $peserta->kec_id->CellAttributes() ?>>
<span id="el<?php echo $peserta_list->RowCnt ?>_peserta_kec_id" class="peserta_kec_id">
<span<?php echo $peserta->kec_id->ViewAttributes() ?>>
<?php echo $peserta->kec_id->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($peserta->desa_id->Visible) { // desa_id ?>
		<td data-name="desa_id"<?php echo $peserta->desa_id->CellAttributes() ?>>
<span id="el<?php echo $peserta_list->RowCnt ?>_peserta_desa_id" class="peserta_desa_id">
<span<?php echo $peserta->desa_id->ViewAttributes() ?>>
<?php echo $peserta->desa_id->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($peserta->pes_alamat->Visible) { // pes_alamat ?>
		<td data-name="pes_alamat"<?php echo $peserta->pes_alamat->CellAttributes() ?>>
<span id="el<?php echo $peserta_list->RowCnt ?>_peserta_pes_alamat" class="peserta_pes_alamat">
<span<?php echo $peserta->pes_alamat->ViewAttributes() ?>>
<?php echo $peserta->pes_alamat->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($peserta->pes_hp->Visible) { // pes_hp ?>
		<td data-name="pes_hp"<?php echo $peserta->pes_hp->CellAttributes() ?>>
<span id="el<?php echo $peserta_list->RowCnt ?>_peserta_pes_hp" class="peserta_pes_hp">
<span<?php echo $peserta->pes_hp->ViewAttributes() ?>>
<?php echo $peserta->pes_hp->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($peserta->pes_foto->Visible) { // pes_foto ?>
		<td data-name="pes_foto"<?php echo $peserta->pes_foto->CellAttributes() ?>>
<span id="el<?php echo $peserta_list->RowCnt ?>_peserta_pes_foto" class="peserta_pes_foto">
<span>
<?php echo ew_GetFileViewTag($peserta->pes_foto, $peserta->pes_foto->ListViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($peserta->pes_luas_lahan->Visible) { // pes_luas_lahan ?>
		<td data-name="pes_luas_lahan"<?php echo $peserta->pes_luas_lahan->CellAttributes() ?>>
<span id="el<?php echo $peserta_list->RowCnt ?>_peserta_pes_luas_lahan" class="peserta_pes_luas_lahan">
<span<?php echo $peserta->pes_luas_lahan->ViewAttributes() ?>>
<?php echo $peserta->pes_luas_lahan->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($peserta->pes_r_tanam_tgl->Visible) { // pes_r_tanam_tgl ?>
		<td data-name="pes_r_tanam_tgl"<?php echo $peserta->pes_r_tanam_tgl->CellAttributes() ?>>
<span id="el<?php echo $peserta_list->RowCnt ?>_peserta_pes_r_tanam_tgl" class="peserta_pes_r_tanam_tgl">
<span<?php echo $peserta->pes_r_tanam_tgl->ViewAttributes() ?>>
<?php echo $peserta->pes_r_tanam_tgl->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($peserta->pes_foto_lahan->Visible) { // pes_foto_lahan ?>
		<td data-name="pes_foto_lahan"<?php echo $peserta->pes_foto_lahan->CellAttributes() ?>>
<span id="el<?php echo $peserta_list->RowCnt ?>_peserta_pes_foto_lahan" class="peserta_pes_foto_lahan">
<span>
<?php echo ew_GetFileViewTag($peserta->pes_foto_lahan, $peserta->pes_foto_lahan->ListViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$peserta_list->ListOptions->Render("body", "right", $peserta_list->RowCnt);
?>
	</tr>
<?php
	}
	if ($peserta->CurrentAction <> "gridadd")
		$peserta_list->Recordset->MoveNext();
}
?>
</tbody>
</table>
<?php } ?>
<?php if ($peserta->CurrentAction == "") { ?>
<input type="hidden" name="a_list" id="a_list" value="">
<?php } ?>
</div>
</form>
<?php

// Close recordset
if ($peserta_list->Recordset)
	$peserta_list->Recordset->Close();
?>
<?php if ($peserta->Export == "") { ?>
<div class="box-footer ewGridLowerPanel">
<?php if ($peserta->CurrentAction <> "gridadd" && $peserta->CurrentAction <> "gridedit") { ?>
<form name="ewPagerForm" class="ewForm form-inline ewPagerForm" action="<?php echo ew_CurrentPage() ?>">
<?php if (!isset($peserta_list->Pager)) $peserta_list->Pager = new cNumericPager($peserta_list->StartRec, $peserta_list->DisplayRecs, $peserta_list->TotalRecs, $peserta_list->RecRange, $peserta_list->AutoHidePager) ?>
<?php if ($peserta_list->Pager->RecordCount > 0 && $peserta_list->Pager->Visible) { ?>
<div class="ewPager">
<div class="ewNumericPage"><ul class="pagination">
	<?php if ($peserta_list->Pager->FirstButton->Enabled) { ?>
	<li><a href="<?php echo $peserta_list->PageUrl() ?>start=<?php echo $peserta_list->Pager->FirstButton->Start ?>"><?php echo $Language->Phrase("PagerFirst") ?></a></li>
	<?php } ?>
	<?php if ($peserta_list->Pager->PrevButton->Enabled) { ?>
	<li><a href="<?php echo $peserta_list->PageUrl() ?>start=<?php echo $peserta_list->Pager->PrevButton->Start ?>"><?php echo $Language->Phrase("PagerPrevious") ?></a></li>
	<?php } ?>
	<?php foreach ($peserta_list->Pager->Items as $PagerItem) { ?>
		<li<?php if (!$PagerItem->Enabled) { echo " class=\" active\""; } ?>><a href="<?php if ($PagerItem->Enabled) { echo $peserta_list->PageUrl() . "start=" . $PagerItem->Start; } else { echo "#"; } ?>"><?php echo $PagerItem->Text ?></a></li>
	<?php } ?>
	<?php if ($peserta_list->Pager->NextButton->Enabled) { ?>
	<li><a href="<?php echo $peserta_list->PageUrl() ?>start=<?php echo $peserta_list->Pager->NextButton->Start ?>"><?php echo $Language->Phrase("PagerNext") ?></a></li>
	<?php } ?>
	<?php if ($peserta_list->Pager->LastButton->Enabled) { ?>
	<li><a href="<?php echo $peserta_list->PageUrl() ?>start=<?php echo $peserta_list->Pager->LastButton->Start ?>"><?php echo $Language->Phrase("PagerLast") ?></a></li>
	<?php } ?>
</ul></div>
</div>
<?php } ?>
<?php if ($peserta_list->Pager->RecordCount > 0) { ?>
<div class="ewPager ewRec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $peserta_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $peserta_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $peserta_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ewListOtherOptions">
<?php
	foreach ($peserta_list->OtherOptions as &$option)
		$option->Render("body", "bottom");
?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div>
<?php } ?>
<?php if ($peserta_list->TotalRecs == 0 && $peserta->CurrentAction == "") { // Show other options ?>
<div class="ewListOtherOptions">
<?php
	foreach ($peserta_list->OtherOptions as &$option) {
		$option->ButtonClass = "";
		$option->Render("body", "");
	}
?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php if ($peserta->Export == "") { ?>
<script type="text/javascript">
fpesertalistsrch.FilterList = <?php echo $peserta_list->GetFilterList() ?>;
fpesertalistsrch.Init();
fpesertalist.Init();
</script>
<?php } ?>
<?php
$peserta_list->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<?php if ($peserta->Export == "") { ?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$peserta_list->Page_Terminate();
?>
