<?php
if (session_id() == "") session_start(); // Init session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg14.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql14.php") ?>
<?php include_once "phpfn14.php" ?>
<?php include_once "order_bibitinfo.php" ?>
<?php include_once "employeesinfo.php" ?>
<?php include_once "userfn14.php" ?>
<?php

//
// Page class
//

$order_bibit_add = NULL; // Initialize page object first

class corder_bibit_add extends corder_bibit {

	// Page ID
	var $PageID = 'add';

	// Project ID
	var $ProjectID = '{CC60B42B-604B-412A-B014-2315920AF6AA}';

	// Table name
	var $TableName = 'order_bibit';

	// Page object name
	var $PageObjName = 'order_bibit_add';

	// Page headings
	var $Heading = '';
	var $Subheading = '';

	// Page heading
	function PageHeading() {
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->TableCaption();
		return "";
	}

	// Page subheading
	function PageSubheading() {
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->Phrase($this->PageID);
		return "";
	}

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (order_bibit)
		if (!isset($GLOBALS["order_bibit"]) || get_class($GLOBALS["order_bibit"]) == "corder_bibit") {
			$GLOBALS["order_bibit"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["order_bibit"];
		}

		// Table object (employees)
		if (!isset($GLOBALS['employees'])) $GLOBALS['employees'] = new cemployees();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'add', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'order_bibit', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"]))
			$GLOBALS["gTimer"] = new cTimer();

		// Debug message
		ew_LoadDebugMsg();

		// Open connection
		if (!isset($conn))
			$conn = ew_Connect($this->DBID);

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new cemployees();
			$UserTableConn = Conn($UserTable->DBID);
		}
	}

	//
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Is modal
		$this->IsModal = (@$_GET["modal"] == "1" || @$_POST["modal"] == "1");

		// User profile
		$UserProfile = new cUserProfile();

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanAdd()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			if ($Security->CanList())
				$this->Page_Terminate(ew_GetUrl("order_bibitlist.php"));
			else
				$this->Page_Terminate(ew_GetUrl("login.php"));
		}

		// NOTE: Security object may be needed in other part of the script, skip set to Nothing
		// 
		// Security = null;
		// 
		// Create form object

		$objForm = new cFormObj();
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action
		$this->ob_co->SetVisibility();
		$this->ob_k_tanam->SetVisibility();
		$this->ob_pembeli->SetVisibility();
		$this->ob_tgl_kirim->SetVisibility();
		$this->ob_var->SetVisibility();
		$this->ob_jumlah->SetVisibility();
		$this->status->SetVisibility();
		$this->ob_tgl_real_kirim->SetVisibility();
		$this->ob_jumlah_real_kirim->SetVisibility();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $order_bibit;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($order_bibit);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		// Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = ew_GetPageName($url);
				if ($pageName != $this->GetListUrl()) { // Not List page
					$row["caption"] = $this->GetModalCaption($pageName);
					if ($pageName == "order_bibitview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				header("Content-Type: application/json; charset=utf-8");
				echo ew_ConvertToUtf8(ew_ArrayToJson(array($row)));
			} else {
				ew_SaveDebugMsg();
				header("Location: " . $url);
			}
		}
		exit();
	}
	var $FormClassName = "form-horizontal ewForm ewAddForm";
	var $IsModal = FALSE;
	var $IsMobileOrModal = FALSE;
	var $DbMasterFilter = "";
	var $DbDetailFilter = "";
	var $StartRec;
	var $Priv = 0;
	var $OldRecordset;
	var $CopyRecord;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError;
		global $gbSkipHeaderFooter;

		// Check modal
		if ($this->IsModal)
			$gbSkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = ew_IsMobile() || $this->IsModal;
		$this->FormClassName = "ewForm ewAddForm form-horizontal";

		// Set up current action
		if (@$_POST["a_add"] <> "") {
			$this->CurrentAction = $_POST["a_add"]; // Get form action
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (@$_GET["ob_id"] != "") {
				$this->ob_id->setQueryStringValue($_GET["ob_id"]);
				$this->setKey("ob_id", $this->ob_id->CurrentValue); // Set up key
			} else {
				$this->setKey("ob_id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "C"; // Copy record
			} else {
				$this->CurrentAction = "I"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->LoadOldRecord();

		// Load form values
		if (@$_POST["a_add"] <> "") {
			$this->LoadFormValues(); // Load form values
		}

		// Validate form if post back
		if (@$_POST["a_add"] <> "") {
			if (!$this->ValidateForm()) {
				$this->CurrentAction = "I"; // Form error, reset action
				$this->EventCancelled = TRUE; // Event cancelled
				$this->RestoreFormValues(); // Restore form values
				$this->setFailureMessage($gsFormError);
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "I": // Blank record
				break;
			case "C": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "") $this->setFailureMessage($Language->Phrase("NoRecord")); // No record found
					$this->Page_Terminate("order_bibitlist.php"); // No matching record, return to list
				}
				break;
			case "A": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->AddRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->Phrase("AddSuccess")); // Set up success message
					$sReturnUrl = $this->getReturnUrl();
					if (ew_GetPageName($sReturnUrl) == "order_bibitlist.php")
						$sReturnUrl = $this->AddMasterUrl($sReturnUrl); // List page, return to List page with correct master key if necessary
					elseif (ew_GetPageName($sReturnUrl) == "order_bibitview.php")
						$sReturnUrl = $this->GetViewUrl(); // View page, return to View page with keyurl directly
					$this->Page_Terminate($sReturnUrl); // Clean up and return
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->RestoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->SetupBreadcrumb();

		// Render row based on row type
		$this->RowType = EW_ROWTYPE_ADD; // Render add type

		// Render row
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Get upload files
	function GetUploadFiles() {
		global $objForm, $Language;

		// Get upload data
	}

	// Load default values
	function LoadDefaultValues() {
		$this->ob_id->CurrentValue = NULL;
		$this->ob_id->OldValue = $this->ob_id->CurrentValue;
		$this->ob_co->CurrentValue = NULL;
		$this->ob_co->OldValue = $this->ob_co->CurrentValue;
		$this->ob_k_tanam->CurrentValue = NULL;
		$this->ob_k_tanam->OldValue = $this->ob_k_tanam->CurrentValue;
		$this->ob_pembeli->CurrentValue = NULL;
		$this->ob_pembeli->OldValue = $this->ob_pembeli->CurrentValue;
		$this->ob_tgl_kirim->CurrentValue = NULL;
		$this->ob_tgl_kirim->OldValue = $this->ob_tgl_kirim->CurrentValue;
		$this->ob_var->CurrentValue = NULL;
		$this->ob_var->OldValue = $this->ob_var->CurrentValue;
		$this->ob_jumlah->CurrentValue = NULL;
		$this->ob_jumlah->OldValue = $this->ob_jumlah->CurrentValue;
		$this->status->CurrentValue = NULL;
		$this->status->OldValue = $this->status->CurrentValue;
		$this->ob_tgl_real_kirim->CurrentValue = NULL;
		$this->ob_tgl_real_kirim->OldValue = $this->ob_tgl_real_kirim->CurrentValue;
		$this->ob_jumlah_real_kirim->CurrentValue = NULL;
		$this->ob_jumlah_real_kirim->OldValue = $this->ob_jumlah_real_kirim->CurrentValue;
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm;
		if (!$this->ob_co->FldIsDetailKey) {
			$this->ob_co->setFormValue($objForm->GetValue("x_ob_co"));
		}
		if (!$this->ob_k_tanam->FldIsDetailKey) {
			$this->ob_k_tanam->setFormValue($objForm->GetValue("x_ob_k_tanam"));
		}
		if (!$this->ob_pembeli->FldIsDetailKey) {
			$this->ob_pembeli->setFormValue($objForm->GetValue("x_ob_pembeli"));
		}
		if (!$this->ob_tgl_kirim->FldIsDetailKey) {
			$this->ob_tgl_kirim->setFormValue($objForm->GetValue("x_ob_tgl_kirim"));
			$this->ob_tgl_kirim->CurrentValue = ew_UnFormatDateTime($this->ob_tgl_kirim->CurrentValue, 0);
		}
		if (!$this->ob_var->FldIsDetailKey) {
			$this->ob_var->setFormValue($objForm->GetValue("x_ob_var"));
		}
		if (!$this->ob_jumlah->FldIsDetailKey) {
			$this->ob_jumlah->setFormValue($objForm->GetValue("x_ob_jumlah"));
		}
		if (!$this->status->FldIsDetailKey) {
			$this->status->setFormValue($objForm->GetValue("x_status"));
		}
		if (!$this->ob_tgl_real_kirim->FldIsDetailKey) {
			$this->ob_tgl_real_kirim->setFormValue($objForm->GetValue("x_ob_tgl_real_kirim"));
			$this->ob_tgl_real_kirim->CurrentValue = ew_UnFormatDateTime($this->ob_tgl_real_kirim->CurrentValue, 0);
		}
		if (!$this->ob_jumlah_real_kirim->FldIsDetailKey) {
			$this->ob_jumlah_real_kirim->setFormValue($objForm->GetValue("x_ob_jumlah_real_kirim"));
		}
	}

	// Restore form values
	function RestoreFormValues() {
		global $objForm;
		$this->ob_co->CurrentValue = $this->ob_co->FormValue;
		$this->ob_k_tanam->CurrentValue = $this->ob_k_tanam->FormValue;
		$this->ob_pembeli->CurrentValue = $this->ob_pembeli->FormValue;
		$this->ob_tgl_kirim->CurrentValue = $this->ob_tgl_kirim->FormValue;
		$this->ob_tgl_kirim->CurrentValue = ew_UnFormatDateTime($this->ob_tgl_kirim->CurrentValue, 0);
		$this->ob_var->CurrentValue = $this->ob_var->FormValue;
		$this->ob_jumlah->CurrentValue = $this->ob_jumlah->FormValue;
		$this->status->CurrentValue = $this->status->FormValue;
		$this->ob_tgl_real_kirim->CurrentValue = $this->ob_tgl_real_kirim->FormValue;
		$this->ob_tgl_real_kirim->CurrentValue = ew_UnFormatDateTime($this->ob_tgl_real_kirim->CurrentValue, 0);
		$this->ob_jumlah_real_kirim->CurrentValue = $this->ob_jumlah_real_kirim->FormValue;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues($rs = NULL) {
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->NewRow(); 

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->ob_id->setDbValue($row['ob_id']);
		$this->ob_co->setDbValue($row['ob_co']);
		$this->ob_k_tanam->setDbValue($row['ob_k_tanam']);
		$this->ob_pembeli->setDbValue($row['ob_pembeli']);
		$this->ob_tgl_kirim->setDbValue($row['ob_tgl_kirim']);
		$this->ob_var->setDbValue($row['ob_var']);
		$this->ob_jumlah->setDbValue($row['ob_jumlah']);
		$this->status->setDbValue($row['status']);
		$this->ob_tgl_real_kirim->setDbValue($row['ob_tgl_real_kirim']);
		$this->ob_jumlah_real_kirim->setDbValue($row['ob_jumlah_real_kirim']);
	}

	// Return a row with default values
	function NewRow() {
		$this->LoadDefaultValues();
		$row = array();
		$row['ob_id'] = $this->ob_id->CurrentValue;
		$row['ob_co'] = $this->ob_co->CurrentValue;
		$row['ob_k_tanam'] = $this->ob_k_tanam->CurrentValue;
		$row['ob_pembeli'] = $this->ob_pembeli->CurrentValue;
		$row['ob_tgl_kirim'] = $this->ob_tgl_kirim->CurrentValue;
		$row['ob_var'] = $this->ob_var->CurrentValue;
		$row['ob_jumlah'] = $this->ob_jumlah->CurrentValue;
		$row['status'] = $this->status->CurrentValue;
		$row['ob_tgl_real_kirim'] = $this->ob_tgl_real_kirim->CurrentValue;
		$row['ob_jumlah_real_kirim'] = $this->ob_jumlah_real_kirim->CurrentValue;
		return $row;
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->ob_id->DbValue = $row['ob_id'];
		$this->ob_co->DbValue = $row['ob_co'];
		$this->ob_k_tanam->DbValue = $row['ob_k_tanam'];
		$this->ob_pembeli->DbValue = $row['ob_pembeli'];
		$this->ob_tgl_kirim->DbValue = $row['ob_tgl_kirim'];
		$this->ob_var->DbValue = $row['ob_var'];
		$this->ob_jumlah->DbValue = $row['ob_jumlah'];
		$this->status->DbValue = $row['status'];
		$this->ob_tgl_real_kirim->DbValue = $row['ob_tgl_real_kirim'];
		$this->ob_jumlah_real_kirim->DbValue = $row['ob_jumlah_real_kirim'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("ob_id")) <> "")
			$this->ob_id->CurrentValue = $this->getKey("ob_id"); // ob_id
		else
			$bValidKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
		}
		$this->LoadRowValues($this->OldRecordset); // Load row values
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// ob_id
		// ob_co
		// ob_k_tanam
		// ob_pembeli
		// ob_tgl_kirim
		// ob_var
		// ob_jumlah
		// status
		// ob_tgl_real_kirim
		// ob_jumlah_real_kirim

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// ob_id
		$this->ob_id->ViewValue = $this->ob_id->CurrentValue;
		$this->ob_id->ViewCustomAttributes = "";

		// ob_co
		if (strval($this->ob_co->CurrentValue) <> "") {
			$sFilterWrk = "`co_id`" . ew_SearchString("=", $this->ob_co->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `co_id`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `co`";
		$sWhereWrk = "";
		$this->ob_co->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->ob_co, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->ob_co->ViewValue = $this->ob_co->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->ob_co->ViewValue = $this->ob_co->CurrentValue;
			}
		} else {
			$this->ob_co->ViewValue = NULL;
		}
		$this->ob_co->ViewCustomAttributes = "";

		// ob_k_tanam
		if (strval($this->ob_k_tanam->CurrentValue) <> "") {
			$sFilterWrk = "`k_id`" . ew_SearchString("=", $this->ob_k_tanam->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `k_id`, `k_id_kontrak` AS `DispFld`, `k_luas_lahan` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kontrak`";
		$sWhereWrk = "";
		$this->ob_k_tanam->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->ob_k_tanam, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = $rswrk->fields('Disp2Fld');
				$this->ob_k_tanam->ViewValue = $this->ob_k_tanam->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->ob_k_tanam->ViewValue = $this->ob_k_tanam->CurrentValue;
			}
		} else {
			$this->ob_k_tanam->ViewValue = NULL;
		}
		$this->ob_k_tanam->ViewCustomAttributes = "";

		// ob_pembeli
		$this->ob_pembeli->ViewValue = $this->ob_pembeli->CurrentValue;
		$this->ob_pembeli->ViewCustomAttributes = "";

		// ob_tgl_kirim
		$this->ob_tgl_kirim->ViewValue = $this->ob_tgl_kirim->CurrentValue;
		$this->ob_tgl_kirim->ViewValue = ew_FormatDateTime($this->ob_tgl_kirim->ViewValue, 0);
		$this->ob_tgl_kirim->ViewCustomAttributes = "";

		// ob_var
		if (strval($this->ob_var->CurrentValue) <> "") {
			$sFilterWrk = "`var_id`" . ew_SearchString("=", $this->ob_var->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `var_id`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `varietas`";
		$sWhereWrk = "";
		$this->ob_var->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->ob_var, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->ob_var->ViewValue = $this->ob_var->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->ob_var->ViewValue = $this->ob_var->CurrentValue;
			}
		} else {
			$this->ob_var->ViewValue = NULL;
		}
		$this->ob_var->ViewCustomAttributes = "";

		// ob_jumlah
		$this->ob_jumlah->ViewValue = $this->ob_jumlah->CurrentValue;
		$this->ob_jumlah->ViewCustomAttributes = "";

		// status
		if (strval($this->status->CurrentValue) <> "") {
			$sFilterWrk = "`status_order_bibit`" . ew_SearchString("=", $this->status->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `status_order_bibit`, `status_order_bibit` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `status_order_bibit`";
		$sWhereWrk = "";
		$this->status->LookupFilters = array("dx1" => '`status_order_bibit`');
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->status, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->status->ViewValue = $this->status->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->status->ViewValue = $this->status->CurrentValue;
			}
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// ob_tgl_real_kirim
		$this->ob_tgl_real_kirim->ViewValue = $this->ob_tgl_real_kirim->CurrentValue;
		$this->ob_tgl_real_kirim->ViewValue = ew_FormatDateTime($this->ob_tgl_real_kirim->ViewValue, 0);
		$this->ob_tgl_real_kirim->ViewCustomAttributes = "";

		// ob_jumlah_real_kirim
		$this->ob_jumlah_real_kirim->ViewValue = $this->ob_jumlah_real_kirim->CurrentValue;
		$this->ob_jumlah_real_kirim->ViewCustomAttributes = "";

			// ob_co
			$this->ob_co->LinkCustomAttributes = "";
			$this->ob_co->HrefValue = "";
			$this->ob_co->TooltipValue = "";

			// ob_k_tanam
			$this->ob_k_tanam->LinkCustomAttributes = "";
			$this->ob_k_tanam->HrefValue = "";
			$this->ob_k_tanam->TooltipValue = "";

			// ob_pembeli
			$this->ob_pembeli->LinkCustomAttributes = "";
			$this->ob_pembeli->HrefValue = "";
			$this->ob_pembeli->TooltipValue = "";

			// ob_tgl_kirim
			$this->ob_tgl_kirim->LinkCustomAttributes = "";
			$this->ob_tgl_kirim->HrefValue = "";
			$this->ob_tgl_kirim->TooltipValue = "";

			// ob_var
			$this->ob_var->LinkCustomAttributes = "";
			$this->ob_var->HrefValue = "";
			$this->ob_var->TooltipValue = "";

			// ob_jumlah
			$this->ob_jumlah->LinkCustomAttributes = "";
			$this->ob_jumlah->HrefValue = "";
			$this->ob_jumlah->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// ob_tgl_real_kirim
			$this->ob_tgl_real_kirim->LinkCustomAttributes = "";
			$this->ob_tgl_real_kirim->HrefValue = "";
			$this->ob_tgl_real_kirim->TooltipValue = "";

			// ob_jumlah_real_kirim
			$this->ob_jumlah_real_kirim->LinkCustomAttributes = "";
			$this->ob_jumlah_real_kirim->HrefValue = "";
			$this->ob_jumlah_real_kirim->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_ADD) { // Add row

			// ob_co
			$this->ob_co->EditAttrs["class"] = "form-control";
			$this->ob_co->EditCustomAttributes = "";
			if (trim(strval($this->ob_co->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`co_id`" . ew_SearchString("=", $this->ob_co->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `co_id`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `co`";
			$sWhereWrk = "";
			$this->ob_co->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->ob_co, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->ob_co->EditValue = $arwrk;

			// ob_k_tanam
			$this->ob_k_tanam->EditAttrs["class"] = "form-control";
			$this->ob_k_tanam->EditCustomAttributes = "";
			if (trim(strval($this->ob_k_tanam->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`k_id`" . ew_SearchString("=", $this->ob_k_tanam->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `k_id`, `k_id_kontrak` AS `DispFld`, `k_luas_lahan` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `kontrak`";
			$sWhereWrk = "";
			$this->ob_k_tanam->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->ob_k_tanam, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->ob_k_tanam->EditValue = $arwrk;

			// ob_pembeli
			$this->ob_pembeli->EditAttrs["class"] = "form-control";
			$this->ob_pembeli->EditCustomAttributes = "";
			$this->ob_pembeli->EditValue = ew_HtmlEncode($this->ob_pembeli->CurrentValue);
			$this->ob_pembeli->PlaceHolder = ew_RemoveHtml($this->ob_pembeli->FldCaption());

			// ob_tgl_kirim
			$this->ob_tgl_kirim->EditAttrs["class"] = "form-control";
			$this->ob_tgl_kirim->EditCustomAttributes = "";
			$this->ob_tgl_kirim->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->ob_tgl_kirim->CurrentValue, 8));
			$this->ob_tgl_kirim->PlaceHolder = ew_RemoveHtml($this->ob_tgl_kirim->FldCaption());

			// ob_var
			$this->ob_var->EditAttrs["class"] = "form-control";
			$this->ob_var->EditCustomAttributes = "";
			if (trim(strval($this->ob_var->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`var_id`" . ew_SearchString("=", $this->ob_var->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `var_id`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `varietas`";
			$sWhereWrk = "";
			$this->ob_var->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->ob_var, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->ob_var->EditValue = $arwrk;

			// ob_jumlah
			$this->ob_jumlah->EditAttrs["class"] = "form-control";
			$this->ob_jumlah->EditCustomAttributes = "";
			$this->ob_jumlah->EditValue = ew_HtmlEncode($this->ob_jumlah->CurrentValue);
			$this->ob_jumlah->PlaceHolder = ew_RemoveHtml($this->ob_jumlah->FldCaption());

			// status
			$this->status->EditCustomAttributes = "";
			if (trim(strval($this->status->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`status_order_bibit`" . ew_SearchString("=", $this->status->CurrentValue, EW_DATATYPE_STRING, "");
			}
			$sSqlWrk = "SELECT `status_order_bibit`, `status_order_bibit` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `status_order_bibit`";
			$sWhereWrk = "";
			$this->status->LookupFilters = array("dx1" => '`status_order_bibit`');
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->status, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = ew_HtmlEncode($rswrk->fields('DispFld'));
				$this->status->ViewValue = $this->status->DisplayValue($arwrk);
			} else {
				$this->status->ViewValue = $Language->Phrase("PleaseSelect");
			}
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->status->EditValue = $arwrk;

			// ob_tgl_real_kirim
			$this->ob_tgl_real_kirim->EditAttrs["class"] = "form-control";
			$this->ob_tgl_real_kirim->EditCustomAttributes = "";
			$this->ob_tgl_real_kirim->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->ob_tgl_real_kirim->CurrentValue, 8));
			$this->ob_tgl_real_kirim->PlaceHolder = ew_RemoveHtml($this->ob_tgl_real_kirim->FldCaption());

			// ob_jumlah_real_kirim
			$this->ob_jumlah_real_kirim->EditAttrs["class"] = "form-control";
			$this->ob_jumlah_real_kirim->EditCustomAttributes = "";
			$this->ob_jumlah_real_kirim->EditValue = ew_HtmlEncode($this->ob_jumlah_real_kirim->CurrentValue);
			$this->ob_jumlah_real_kirim->PlaceHolder = ew_RemoveHtml($this->ob_jumlah_real_kirim->FldCaption());

			// Add refer script
			// ob_co

			$this->ob_co->LinkCustomAttributes = "";
			$this->ob_co->HrefValue = "";

			// ob_k_tanam
			$this->ob_k_tanam->LinkCustomAttributes = "";
			$this->ob_k_tanam->HrefValue = "";

			// ob_pembeli
			$this->ob_pembeli->LinkCustomAttributes = "";
			$this->ob_pembeli->HrefValue = "";

			// ob_tgl_kirim
			$this->ob_tgl_kirim->LinkCustomAttributes = "";
			$this->ob_tgl_kirim->HrefValue = "";

			// ob_var
			$this->ob_var->LinkCustomAttributes = "";
			$this->ob_var->HrefValue = "";

			// ob_jumlah
			$this->ob_jumlah->LinkCustomAttributes = "";
			$this->ob_jumlah->HrefValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";

			// ob_tgl_real_kirim
			$this->ob_tgl_real_kirim->LinkCustomAttributes = "";
			$this->ob_tgl_real_kirim->HrefValue = "";

			// ob_jumlah_real_kirim
			$this->ob_jumlah_real_kirim->LinkCustomAttributes = "";
			$this->ob_jumlah_real_kirim->HrefValue = "";
		}
		if ($this->RowType == EW_ROWTYPE_ADD || $this->RowType == EW_ROWTYPE_EDIT || $this->RowType == EW_ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->SetupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $Language, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return ($gsFormError == "");
		if (!ew_CheckDateDef($this->ob_tgl_kirim->FormValue)) {
			ew_AddMessage($gsFormError, $this->ob_tgl_kirim->FldErrMsg());
		}
		if (!ew_CheckInteger($this->ob_jumlah->FormValue)) {
			ew_AddMessage($gsFormError, $this->ob_jumlah->FldErrMsg());
		}
		if (!ew_CheckDateDef($this->ob_tgl_real_kirim->FormValue)) {
			ew_AddMessage($gsFormError, $this->ob_tgl_real_kirim->FldErrMsg());
		}
		if (!ew_CheckInteger($this->ob_jumlah_real_kirim->FormValue)) {
			ew_AddMessage($gsFormError, $this->ob_jumlah_real_kirim->FldErrMsg());
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsFormError, $sFormCustomError);
		}
		return $ValidateForm;
	}

	// Add record
	function AddRow($rsold = NULL) {
		global $Language, $Security;
		$conn = &$this->Connection();

		// Load db values from rsold
		$this->LoadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = array();

		// ob_co
		$this->ob_co->SetDbValueDef($rsnew, $this->ob_co->CurrentValue, NULL, FALSE);

		// ob_k_tanam
		$this->ob_k_tanam->SetDbValueDef($rsnew, $this->ob_k_tanam->CurrentValue, NULL, FALSE);

		// ob_pembeli
		$this->ob_pembeli->SetDbValueDef($rsnew, $this->ob_pembeli->CurrentValue, NULL, FALSE);

		// ob_tgl_kirim
		$this->ob_tgl_kirim->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->ob_tgl_kirim->CurrentValue, 0), NULL, FALSE);

		// ob_var
		$this->ob_var->SetDbValueDef($rsnew, $this->ob_var->CurrentValue, NULL, FALSE);

		// ob_jumlah
		$this->ob_jumlah->SetDbValueDef($rsnew, $this->ob_jumlah->CurrentValue, NULL, FALSE);

		// status
		$this->status->SetDbValueDef($rsnew, $this->status->CurrentValue, NULL, FALSE);

		// ob_tgl_real_kirim
		$this->ob_tgl_real_kirim->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->ob_tgl_real_kirim->CurrentValue, 0), NULL, FALSE);

		// ob_jumlah_real_kirim
		$this->ob_jumlah_real_kirim->SetDbValueDef($rsnew, $this->ob_jumlah_real_kirim->CurrentValue, NULL, FALSE);

		// Call Row Inserting event
		$rs = ($rsold == NULL) ? NULL : $rsold->fields;
		$bInsertRow = $this->Row_Inserting($rs, $rsnew);
		if ($bInsertRow) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			$AddRow = $this->Insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($AddRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->Phrase("InsertCancelled"));
			}
			$AddRow = FALSE;
		}
		if ($AddRow) {

			// Call Row Inserted event
			$rs = ($rsold == NULL) ? NULL : $rsold->fields;
			$this->Row_Inserted($rs, $rsnew);
		}
		return $AddRow;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$Breadcrumb->Add("list", $this->TableVar, $this->AddMasterUrl("order_bibitlist.php"), "", $this->TableVar, TRUE);
		$PageId = ($this->CurrentAction == "C") ? "Copy" : "Add";
		$Breadcrumb->Add("add", $PageId, $url);
	}

	// Setup lookup filters of a field
	function SetupLookupFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		case "x_ob_co":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `co_id` AS `LinkFld`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `co`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`co_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->ob_co, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_ob_k_tanam":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `k_id` AS `LinkFld`, `k_id_kontrak` AS `DispFld`, `k_luas_lahan` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kontrak`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`k_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->ob_k_tanam, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_ob_var":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `var_id` AS `LinkFld`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `varietas`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`var_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->ob_var, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_status":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `status_order_bibit` AS `LinkFld`, `status_order_bibit` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `status_order_bibit`";
			$sWhereWrk = "{filter}";
			$fld->LookupFilters = array("dx1" => '`status_order_bibit`');
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`status_order_bibit` IN ({filter_value})', "t0" => "200", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->status, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		}
	}

	// Setup AutoSuggest filters of a field
	function SetupAutoSuggestFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($order_bibit_add)) $order_bibit_add = new corder_bibit_add();

// Page init
$order_bibit_add->Page_Init();

// Page main
$order_bibit_add->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$order_bibit_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "add";
var CurrentForm = forder_bibitadd = new ew_Form("forder_bibitadd", "add");

// Validate form
forder_bibitadd.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);
	if ($fobj.find("#a_confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.FormKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = $fobj.find("#a_list").val() == "gridinsert";
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
			elm = this.GetElements("x" + infix + "_ob_tgl_kirim");
			if (elm && !ew_CheckDateDef(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($order_bibit->ob_tgl_kirim->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_ob_jumlah");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($order_bibit->ob_jumlah->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_ob_tgl_real_kirim");
			if (elm && !ew_CheckDateDef(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($order_bibit->ob_tgl_real_kirim->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_ob_jumlah_real_kirim");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($order_bibit->ob_jumlah_real_kirim->FldErrMsg()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ewForms[val])
			if (!ewForms[val].Validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
forder_bibitadd.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
forder_bibitadd.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
forder_bibitadd.Lists["x_ob_co"] = {"LinkField":"x_co_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_co_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"co"};
forder_bibitadd.Lists["x_ob_co"].Data = "<?php echo $order_bibit_add->ob_co->LookupFilterQuery(FALSE, "add") ?>";
forder_bibitadd.Lists["x_ob_k_tanam"] = {"LinkField":"x_k_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_k_id_kontrak","x_k_luas_lahan","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kontrak"};
forder_bibitadd.Lists["x_ob_k_tanam"].Data = "<?php echo $order_bibit_add->ob_k_tanam->LookupFilterQuery(FALSE, "add") ?>";
forder_bibitadd.Lists["x_ob_var"] = {"LinkField":"x_var_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_var_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"varietas"};
forder_bibitadd.Lists["x_ob_var"].Data = "<?php echo $order_bibit_add->ob_var->LookupFilterQuery(FALSE, "add") ?>";
forder_bibitadd.Lists["x_status"] = {"LinkField":"x_status_order_bibit","Ajax":true,"AutoFill":false,"DisplayFields":["x_status_order_bibit","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"status_order_bibit"};
forder_bibitadd.Lists["x_status"].Data = "<?php echo $order_bibit_add->status->LookupFilterQuery(FALSE, "add") ?>";

// Form object for search
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php $order_bibit_add->ShowPageHeader(); ?>
<?php
$order_bibit_add->ShowMessage();
?>
<form name="forder_bibitadd" id="forder_bibitadd" class="<?php echo $order_bibit_add->FormClassName ?>" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($order_bibit_add->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $order_bibit_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="order_bibit">
<input type="hidden" name="a_add" id="a_add" value="A">
<input type="hidden" name="modal" value="<?php echo intval($order_bibit_add->IsModal) ?>">
<div class="ewAddDiv"><!-- page* -->
<?php if ($order_bibit->ob_co->Visible) { // ob_co ?>
	<div id="r_ob_co" class="form-group">
		<label id="elh_order_bibit_ob_co" for="x_ob_co" class="<?php echo $order_bibit_add->LeftColumnClass ?>"><?php echo $order_bibit->ob_co->FldCaption() ?></label>
		<div class="<?php echo $order_bibit_add->RightColumnClass ?>"><div<?php echo $order_bibit->ob_co->CellAttributes() ?>>
<span id="el_order_bibit_ob_co">
<select data-table="order_bibit" data-field="x_ob_co" data-value-separator="<?php echo $order_bibit->ob_co->DisplayValueSeparatorAttribute() ?>" id="x_ob_co" name="x_ob_co"<?php echo $order_bibit->ob_co->EditAttributes() ?>>
<?php echo $order_bibit->ob_co->SelectOptionListHtml("x_ob_co") ?>
</select>
</span>
<?php echo $order_bibit->ob_co->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($order_bibit->ob_k_tanam->Visible) { // ob_k_tanam ?>
	<div id="r_ob_k_tanam" class="form-group">
		<label id="elh_order_bibit_ob_k_tanam" for="x_ob_k_tanam" class="<?php echo $order_bibit_add->LeftColumnClass ?>"><?php echo $order_bibit->ob_k_tanam->FldCaption() ?></label>
		<div class="<?php echo $order_bibit_add->RightColumnClass ?>"><div<?php echo $order_bibit->ob_k_tanam->CellAttributes() ?>>
<span id="el_order_bibit_ob_k_tanam">
<select data-table="order_bibit" data-field="x_ob_k_tanam" data-value-separator="<?php echo $order_bibit->ob_k_tanam->DisplayValueSeparatorAttribute() ?>" id="x_ob_k_tanam" name="x_ob_k_tanam"<?php echo $order_bibit->ob_k_tanam->EditAttributes() ?>>
<?php echo $order_bibit->ob_k_tanam->SelectOptionListHtml("x_ob_k_tanam") ?>
</select>
</span>
<?php echo $order_bibit->ob_k_tanam->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($order_bibit->ob_pembeli->Visible) { // ob_pembeli ?>
	<div id="r_ob_pembeli" class="form-group">
		<label id="elh_order_bibit_ob_pembeli" for="x_ob_pembeli" class="<?php echo $order_bibit_add->LeftColumnClass ?>"><?php echo $order_bibit->ob_pembeli->FldCaption() ?></label>
		<div class="<?php echo $order_bibit_add->RightColumnClass ?>"><div<?php echo $order_bibit->ob_pembeli->CellAttributes() ?>>
<span id="el_order_bibit_ob_pembeli">
<input type="text" data-table="order_bibit" data-field="x_ob_pembeli" name="x_ob_pembeli" id="x_ob_pembeli" size="30" maxlength="100" placeholder="<?php echo ew_HtmlEncode($order_bibit->ob_pembeli->getPlaceHolder()) ?>" value="<?php echo $order_bibit->ob_pembeli->EditValue ?>"<?php echo $order_bibit->ob_pembeli->EditAttributes() ?>>
</span>
<?php echo $order_bibit->ob_pembeli->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($order_bibit->ob_tgl_kirim->Visible) { // ob_tgl_kirim ?>
	<div id="r_ob_tgl_kirim" class="form-group">
		<label id="elh_order_bibit_ob_tgl_kirim" for="x_ob_tgl_kirim" class="<?php echo $order_bibit_add->LeftColumnClass ?>"><?php echo $order_bibit->ob_tgl_kirim->FldCaption() ?></label>
		<div class="<?php echo $order_bibit_add->RightColumnClass ?>"><div<?php echo $order_bibit->ob_tgl_kirim->CellAttributes() ?>>
<span id="el_order_bibit_ob_tgl_kirim">
<input type="text" data-table="order_bibit" data-field="x_ob_tgl_kirim" name="x_ob_tgl_kirim" id="x_ob_tgl_kirim" placeholder="<?php echo ew_HtmlEncode($order_bibit->ob_tgl_kirim->getPlaceHolder()) ?>" value="<?php echo $order_bibit->ob_tgl_kirim->EditValue ?>"<?php echo $order_bibit->ob_tgl_kirim->EditAttributes() ?>>
<?php if (!$order_bibit->ob_tgl_kirim->ReadOnly && !$order_bibit->ob_tgl_kirim->Disabled && !isset($order_bibit->ob_tgl_kirim->EditAttrs["readonly"]) && !isset($order_bibit->ob_tgl_kirim->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("forder_bibitadd", "x_ob_tgl_kirim", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $order_bibit->ob_tgl_kirim->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($order_bibit->ob_var->Visible) { // ob_var ?>
	<div id="r_ob_var" class="form-group">
		<label id="elh_order_bibit_ob_var" for="x_ob_var" class="<?php echo $order_bibit_add->LeftColumnClass ?>"><?php echo $order_bibit->ob_var->FldCaption() ?></label>
		<div class="<?php echo $order_bibit_add->RightColumnClass ?>"><div<?php echo $order_bibit->ob_var->CellAttributes() ?>>
<span id="el_order_bibit_ob_var">
<select data-table="order_bibit" data-field="x_ob_var" data-value-separator="<?php echo $order_bibit->ob_var->DisplayValueSeparatorAttribute() ?>" id="x_ob_var" name="x_ob_var"<?php echo $order_bibit->ob_var->EditAttributes() ?>>
<?php echo $order_bibit->ob_var->SelectOptionListHtml("x_ob_var") ?>
</select>
</span>
<?php echo $order_bibit->ob_var->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($order_bibit->ob_jumlah->Visible) { // ob_jumlah ?>
	<div id="r_ob_jumlah" class="form-group">
		<label id="elh_order_bibit_ob_jumlah" for="x_ob_jumlah" class="<?php echo $order_bibit_add->LeftColumnClass ?>"><?php echo $order_bibit->ob_jumlah->FldCaption() ?></label>
		<div class="<?php echo $order_bibit_add->RightColumnClass ?>"><div<?php echo $order_bibit->ob_jumlah->CellAttributes() ?>>
<span id="el_order_bibit_ob_jumlah">
<input type="text" data-table="order_bibit" data-field="x_ob_jumlah" name="x_ob_jumlah" id="x_ob_jumlah" size="30" placeholder="<?php echo ew_HtmlEncode($order_bibit->ob_jumlah->getPlaceHolder()) ?>" value="<?php echo $order_bibit->ob_jumlah->EditValue ?>"<?php echo $order_bibit->ob_jumlah->EditAttributes() ?>>
</span>
<?php echo $order_bibit->ob_jumlah->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($order_bibit->status->Visible) { // status ?>
	<div id="r_status" class="form-group">
		<label id="elh_order_bibit_status" class="<?php echo $order_bibit_add->LeftColumnClass ?>"><?php echo $order_bibit->status->FldCaption() ?></label>
		<div class="<?php echo $order_bibit_add->RightColumnClass ?>"><div<?php echo $order_bibit->status->CellAttributes() ?>>
<span id="el_order_bibit_status">
<span class="ewLookupList">
	<span onclick="jQuery(this).parent().next(":not([disabled])").click();" tabindex="-1" class="form-control ewLookupText" id="lu_x_status"><?php echo (strval($order_bibit->status->ViewValue) == "" ? $Language->Phrase("PleaseSelect") : $order_bibit->status->ViewValue); ?></span>
</span>
<button type="button" title="<?php echo ew_HtmlEncode(str_replace("%s", ew_RemoveHtml($order_bibit->status->FldCaption()), $Language->Phrase("LookupLink", TRUE))) ?>" onclick="ew_ModalLookupShow({lnk:this,el:'x_status',m:0,n:10});" class="ewLookupBtn btn btn-default btn-sm"<?php echo (($order_bibit->status->ReadOnly || $order_bibit->status->Disabled) ? " disabled" : "")?>><span class="glyphicon glyphicon-search ewIcon"></span></button>
<input type="hidden" data-table="order_bibit" data-field="x_status" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $order_bibit->status->DisplayValueSeparatorAttribute() ?>" name="x_status" id="x_status" value="<?php echo $order_bibit->status->CurrentValue ?>"<?php echo $order_bibit->status->EditAttributes() ?>>
</span>
<?php echo $order_bibit->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($order_bibit->ob_tgl_real_kirim->Visible) { // ob_tgl_real_kirim ?>
	<div id="r_ob_tgl_real_kirim" class="form-group">
		<label id="elh_order_bibit_ob_tgl_real_kirim" for="x_ob_tgl_real_kirim" class="<?php echo $order_bibit_add->LeftColumnClass ?>"><?php echo $order_bibit->ob_tgl_real_kirim->FldCaption() ?></label>
		<div class="<?php echo $order_bibit_add->RightColumnClass ?>"><div<?php echo $order_bibit->ob_tgl_real_kirim->CellAttributes() ?>>
<span id="el_order_bibit_ob_tgl_real_kirim">
<input type="text" data-table="order_bibit" data-field="x_ob_tgl_real_kirim" name="x_ob_tgl_real_kirim" id="x_ob_tgl_real_kirim" placeholder="<?php echo ew_HtmlEncode($order_bibit->ob_tgl_real_kirim->getPlaceHolder()) ?>" value="<?php echo $order_bibit->ob_tgl_real_kirim->EditValue ?>"<?php echo $order_bibit->ob_tgl_real_kirim->EditAttributes() ?>>
<?php if (!$order_bibit->ob_tgl_real_kirim->ReadOnly && !$order_bibit->ob_tgl_real_kirim->Disabled && !isset($order_bibit->ob_tgl_real_kirim->EditAttrs["readonly"]) && !isset($order_bibit->ob_tgl_real_kirim->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("forder_bibitadd", "x_ob_tgl_real_kirim", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $order_bibit->ob_tgl_real_kirim->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($order_bibit->ob_jumlah_real_kirim->Visible) { // ob_jumlah_real_kirim ?>
	<div id="r_ob_jumlah_real_kirim" class="form-group">
		<label id="elh_order_bibit_ob_jumlah_real_kirim" for="x_ob_jumlah_real_kirim" class="<?php echo $order_bibit_add->LeftColumnClass ?>"><?php echo $order_bibit->ob_jumlah_real_kirim->FldCaption() ?></label>
		<div class="<?php echo $order_bibit_add->RightColumnClass ?>"><div<?php echo $order_bibit->ob_jumlah_real_kirim->CellAttributes() ?>>
<span id="el_order_bibit_ob_jumlah_real_kirim">
<input type="text" data-table="order_bibit" data-field="x_ob_jumlah_real_kirim" name="x_ob_jumlah_real_kirim" id="x_ob_jumlah_real_kirim" size="30" placeholder="<?php echo ew_HtmlEncode($order_bibit->ob_jumlah_real_kirim->getPlaceHolder()) ?>" value="<?php echo $order_bibit->ob_jumlah_real_kirim->EditValue ?>"<?php echo $order_bibit->ob_jumlah_real_kirim->EditAttributes() ?>>
</span>
<?php echo $order_bibit->ob_jumlah_real_kirim->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$order_bibit_add->IsModal) { ?>
<div class="form-group"><!-- buttons .form-group -->
	<div class="<?php echo $order_bibit_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ewButton" name="btnAction" id="btnAction" type="submit"><?php echo $Language->Phrase("AddBtn") ?></button>
<button class="btn btn-default ewButton" name="btnCancel" id="btnCancel" type="button" data-href="<?php echo $order_bibit_add->getReturnUrl() ?>"><?php echo $Language->Phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<script type="text/javascript">
forder_bibitadd.Init();
</script>
<?php
$order_bibit_add->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$order_bibit_add->Page_Terminate();
?>
