<?php
if (session_id() == "") session_start(); // Init session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg14.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql14.php") ?>
<?php include_once "phpfn14.php" ?>
<?php include_once "verifikasiinfo.php" ?>
<?php include_once "employeesinfo.php" ?>
<?php include_once "userfn14.php" ?>
<?php

//
// Page class
//

$verifikasi_list = NULL; // Initialize page object first

class cverifikasi_list extends cverifikasi {

	// Page ID
	var $PageID = 'list';

	// Project ID
	var $ProjectID = '{CC60B42B-604B-412A-B014-2315920AF6AA}';

	// Table name
	var $TableName = 'verifikasi';

	// Page object name
	var $PageObjName = 'verifikasi_list';

	// Grid form hidden field names
	var $FormName = 'fverifikasilist';
	var $FormActionName = 'k_action';
	var $FormKeyName = 'k_key';
	var $FormOldKeyName = 'k_oldkey';
	var $FormBlankRowName = 'k_blankrow';
	var $FormKeyCountName = 'key_count';

	// Page headings
	var $Heading = '';
	var $Subheading = '';

	// Page heading
	function PageHeading() {
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->TableCaption();
		return "";
	}

	// Page subheading
	function PageSubheading() {
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->Phrase($this->PageID);
		return "";
	}

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;
	var $ExportPdfUrl;

	// Custom export
	var $ExportExcelCustom = FALSE;
	var $ExportWordCustom = FALSE;
	var $ExportPdfCustom = FALSE;
	var $ExportEmailCustom = FALSE;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (verifikasi)
		if (!isset($GLOBALS["verifikasi"]) || get_class($GLOBALS["verifikasi"]) == "cverifikasi") {
			$GLOBALS["verifikasi"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["verifikasi"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->PageUrl() . "export=print";
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel";
		$this->ExportWordUrl = $this->PageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->PageUrl() . "export=html";
		$this->ExportXmlUrl = $this->PageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->PageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf";
		$this->AddUrl = "verifikasiadd.php";
		$this->InlineAddUrl = $this->PageUrl() . "a=add";
		$this->GridAddUrl = $this->PageUrl() . "a=gridadd";
		$this->GridEditUrl = $this->PageUrl() . "a=gridedit";
		$this->MultiDeleteUrl = "verifikasidelete.php";
		$this->MultiUpdateUrl = "verifikasiupdate.php";

		// Table object (employees)
		if (!isset($GLOBALS['employees'])) $GLOBALS['employees'] = new cemployees();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'list', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'verifikasi', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"]))
			$GLOBALS["gTimer"] = new cTimer();

		// Debug message
		ew_LoadDebugMsg();

		// Open connection
		if (!isset($conn))
			$conn = ew_Connect($this->DBID);

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new cemployees();
			$UserTableConn = Conn($UserTable->DBID);
		}

		// List options
		$this->ListOptions = new cListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new cListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Other options
		$this->OtherOptions['addedit'] = new cListOptions();
		$this->OtherOptions['addedit']->Tag = "div";
		$this->OtherOptions['addedit']->TagClassName = "ewAddEditOption";
		$this->OtherOptions['detail'] = new cListOptions();
		$this->OtherOptions['detail']->Tag = "div";
		$this->OtherOptions['detail']->TagClassName = "ewDetailOption";
		$this->OtherOptions['action'] = new cListOptions();
		$this->OtherOptions['action']->Tag = "div";
		$this->OtherOptions['action']->TagClassName = "ewActionOption";

		// Filter options
		$this->FilterOptions = new cListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ewFilterOption fverifikasilistsrch";

		// List actions
		$this->ListActions = new cListActions();
	}

	//
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// User profile
		$UserProfile = new cUserProfile();

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanList()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			$this->Page_Terminate(ew_GetUrl("index.php"));
		}

		// NOTE: Security object may be needed in other part of the script, skip set to Nothing
		// 
		// Security = null;
		// 
		// Get export parameters

		$custom = "";
		if (@$_GET["export"] <> "") {
			$this->Export = $_GET["export"];
			$custom = @$_GET["custom"];
		} elseif (@$_POST["export"] <> "") {
			$this->Export = $_POST["export"];
			$custom = @$_POST["custom"];
		} elseif (ew_IsPost()) {
			if (@$_POST["exporttype"] <> "")
				$this->Export = $_POST["exporttype"];
			$custom = @$_POST["custom"];
		} elseif (@$_GET["cmd"] == "json") {
			$this->Export = $_GET["cmd"];
		} else {
			$this->setExportReturnUrl(ew_CurrentUrl());
		}
		$gsExportFile = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->Export <> "" && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$gsCustomExport = $this->CustomExport;
		$gsExport = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined("EW_USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined("EW_USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action

		// Get grid add count
		$gridaddcnt = @$_GET[EW_TABLE_GRID_ADD_ROW_COUNT];
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->SetupListOptions();

		// Setup export options
		$this->SetupExportOptions();
		$this->ver_id->SetVisibility();
		if ($this->IsAdd() || $this->IsCopy() || $this->IsGridAdd())
			$this->ver_id->Visible = FALSE;
		$this->qc_id->SetVisibility();
		$this->datang_id->SetVisibility();
		$this->ver_tgl->SetVisibility();
		$this->ver_hasil_id->SetVisibility();
		$this->ver_foto->SetVisibility();
		$this->ver_catatan->SetVisibility();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();

		// Setup other options
		$this->SetupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->Add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == EW_ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $verifikasi;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($verifikasi);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		// Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			ew_SaveDebugMsg();
			header("Location: " . $url);
		}
		exit();
	}

	// Class variables
	var $ListOptions; // List options
	var $ExportOptions; // Export options
	var $SearchOptions; // Search options
	var $OtherOptions = array(); // Other options
	var $FilterOptions; // Filter options
	var $ListActions; // List actions
	var $SelectedCount = 0;
	var $SelectedIndex = 0;
	var $DisplayRecs = 100;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $Pager;
	var $AutoHidePager = EW_AUTO_HIDE_PAGER;
	var $AutoHidePageSizeSelector = EW_AUTO_HIDE_PAGE_SIZE_SELECTOR;
	var $DefaultSearchWhere = ""; // Default search WHERE clause
	var $SearchWhere = ""; // Search WHERE clause
	var $RecCnt = 0; // Record count
	var $EditRowCnt;
	var $StartRowCnt = 1;
	var $RowCnt = 0;
	var $Attrs = array(); // Row attributes and cell attributes
	var $RowIndex = 0; // Row index
	var $KeyCount = 0; // Key count
	var $RowAction = ""; // Row action
	var $RowOldKey = ""; // Row old key (for copy)
	var $RecPerRow = 0;
	var $MultiColumnClass;
	var $MultiColumnEditClass = "col-sm-12";
	var $MultiColumnCnt = 12;
	var $MultiColumnEditCnt = 12;
	var $GridCnt = 0;
	var $ColCnt = 0;
	var $DbMasterFilter = ""; // Master filter
	var $DbDetailFilter = ""; // Detail filter
	var $MasterRecordExists;
	var $MultiSelectKey;
	var $Command;
	var $RestoreSearch = FALSE;
	var $DetailPages;
	var $Recordset;
	var $OldRecordset;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError, $gsSearchError, $Security, $EW_EXPORT;

		// Search filters
		$sSrchAdvanced = ""; // Advanced search filter
		$sSrchBasic = ""; // Basic search filter
		$sFilter = "";

		// Get command
		$this->Command = strtolower(@$_GET["cmd"]);
		if ($this->IsPageRequest()) { // Validate request

			// Process list action first
			if ($this->ProcessListAction()) // Ajax request
				$this->Page_Terminate();

			// Handle reset command
			$this->ResetCmd();

			// Set up Breadcrumb
			if ($this->Export == "")
				$this->SetupBreadcrumb();

			// Hide list options
			if ($this->Export <> "") {
				$this->ListOptions->HideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->CurrentAction == "gridadd" || $this->CurrentAction == "gridedit") {
				$this->ListOptions->HideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->Export <> "" || $this->CurrentAction <> "") {
				$this->ExportOptions->HideAllOptions();
				$this->FilterOptions->HideAllOptions();
			}

			// Hide other options
			if ($this->Export <> "") {
				foreach ($this->OtherOptions as &$option)
					$option->HideAllOptions();
			}

			// Get default search criteria
			ew_AddFilter($this->DefaultSearchWhere, $this->BasicSearchWhere(TRUE));
			ew_AddFilter($this->DefaultSearchWhere, $this->AdvancedSearchWhere(TRUE));

			// Get basic search values
			$this->LoadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->LoadSearchValues(); // Get search values

			// Process filter list
			$this->ProcessFilterList();
			if (!$this->ValidateSearch())
				$this->setFailureMessage($gsSearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->Export <> "" || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->CheckSearchParms())
				$this->RestoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->SetupSortOrder();

			// Get basic search criteria
			if ($gsSearchError == "")
				$sSrchBasic = $this->BasicSearchWhere();

			// Get search criteria for advanced search
			if ($gsSearchError == "")
				$sSrchAdvanced = $this->AdvancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 100; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->LoadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->CheckSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->LoadDefault();
			if ($this->BasicSearch->Keyword != "")
				$sSrchBasic = $this->BasicSearchWhere();

			// Load advanced search from default
			if ($this->LoadAdvancedSearchDefault()) {
				$sSrchAdvanced = $this->AdvancedSearchWhere();
			}
		}

		// Build search criteria
		ew_AddFilter($this->SearchWhere, $sSrchAdvanced);
		ew_AddFilter($this->SearchWhere, $sSrchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$sFilter = "";
		if (!$Security->CanList())
			$sFilter = "(0=1)"; // Filter all records
		ew_AddFilter($sFilter, $this->DbDetailFilter);
		ew_AddFilter($sFilter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSQL = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $sFilter;
		} else {
			$this->setSessionWhere($sFilter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if ($this->CustomExport == "" && in_array($this->Export, array_keys($EW_EXPORT))) {
			$this->ExportData();
			$this->Page_Terminate(); // Terminate response
			exit();
		}

		// Load record count first
		if (!$this->IsAddOrEdit()) {
			$bSelectLimit = $this->UseSelectLimit;
			if ($bSelectLimit) {
				$this->TotalRecs = $this->ListRecordCount();
			} else {
				if ($this->Recordset = $this->LoadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
		}

		// Search options
		$this->SetupSearchOptions();
	}

	// Build filter for all keys
	function BuildKeyFilter() {
		global $objForm;
		$sWrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$objForm->Index = $rowindex;
		$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		while ($sThisKey <> "") {
			if ($this->SetupKeyValues($sThisKey)) {
				$sFilter = $this->KeyFilter();
				if ($sWrkFilter <> "") $sWrkFilter .= " OR ";
				$sWrkFilter .= $sFilter;
			} else {
				$sWrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$objForm->Index = $rowindex;
			$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		}
		return $sWrkFilter;
	}

	// Set up key values
	function SetupKeyValues($key) {
		$arrKeyFlds = explode($GLOBALS["EW_COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arrKeyFlds) >= 1) {
			$this->ver_id->setFormValue($arrKeyFlds[0]);
			if (!is_numeric($this->ver_id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	function GetFilterList() {
		global $UserProfile;

		// Initialize
		$sFilterList = "";
		$sSavedFilterList = "";
		$sFilterList = ew_Concat($sFilterList, $this->ver_id->AdvancedSearch->ToJson(), ","); // Field ver_id
		$sFilterList = ew_Concat($sFilterList, $this->qc_id->AdvancedSearch->ToJson(), ","); // Field qc_id
		$sFilterList = ew_Concat($sFilterList, $this->datang_id->AdvancedSearch->ToJson(), ","); // Field datang_id
		$sFilterList = ew_Concat($sFilterList, $this->ver_tgl->AdvancedSearch->ToJson(), ","); // Field ver_tgl
		$sFilterList = ew_Concat($sFilterList, $this->ver_hasil_id->AdvancedSearch->ToJson(), ","); // Field ver_hasil_id
		$sFilterList = ew_Concat($sFilterList, $this->ver_foto->AdvancedSearch->ToJson(), ","); // Field ver_foto
		$sFilterList = ew_Concat($sFilterList, $this->ver_catatan->AdvancedSearch->ToJson(), ","); // Field ver_catatan
		if ($this->BasicSearch->Keyword <> "") {
			$sWrk = "\"" . EW_TABLE_BASIC_SEARCH . "\":\"" . ew_JsEncode2($this->BasicSearch->Keyword) . "\",\"" . EW_TABLE_BASIC_SEARCH_TYPE . "\":\"" . ew_JsEncode2($this->BasicSearch->Type) . "\"";
			$sFilterList = ew_Concat($sFilterList, $sWrk, ",");
		}
		$sFilterList = preg_replace('/,$/', "", $sFilterList);

		// Return filter list in json
		if ($sFilterList <> "")
			$sFilterList = "\"data\":{" . $sFilterList . "}";
		if ($sSavedFilterList <> "") {
			if ($sFilterList <> "")
				$sFilterList .= ",";
			$sFilterList .= "\"filters\":" . $sSavedFilterList;
		}
		return ($sFilterList <> "") ? "{" . $sFilterList . "}" : "null";
	}

	// Process filter list
	function ProcessFilterList() {
		global $UserProfile;
		if (@$_POST["ajax"] == "savefilters") { // Save filter request (Ajax)
			$filters = @$_POST["filters"];
			$UserProfile->SetSearchFilters(CurrentUserName(), "fverifikasilistsrch", $filters);

			// Clean output buffer
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			echo ew_ArrayToJson(array(array("success" => TRUE))); // Success
			$this->Page_Terminate();
			exit();
		} elseif (@$_POST["cmd"] == "resetfilter") {
			$this->RestoreFilterList();
		}
	}

	// Restore list of filters
	function RestoreFilterList() {

		// Return if not reset filter
		if (@$_POST["cmd"] <> "resetfilter")
			return FALSE;
		$filter = json_decode(@$_POST["filter"], TRUE);
		$this->Command = "search";

		// Field ver_id
		$this->ver_id->AdvancedSearch->SearchValue = @$filter["x_ver_id"];
		$this->ver_id->AdvancedSearch->SearchOperator = @$filter["z_ver_id"];
		$this->ver_id->AdvancedSearch->SearchCondition = @$filter["v_ver_id"];
		$this->ver_id->AdvancedSearch->SearchValue2 = @$filter["y_ver_id"];
		$this->ver_id->AdvancedSearch->SearchOperator2 = @$filter["w_ver_id"];
		$this->ver_id->AdvancedSearch->Save();

		// Field qc_id
		$this->qc_id->AdvancedSearch->SearchValue = @$filter["x_qc_id"];
		$this->qc_id->AdvancedSearch->SearchOperator = @$filter["z_qc_id"];
		$this->qc_id->AdvancedSearch->SearchCondition = @$filter["v_qc_id"];
		$this->qc_id->AdvancedSearch->SearchValue2 = @$filter["y_qc_id"];
		$this->qc_id->AdvancedSearch->SearchOperator2 = @$filter["w_qc_id"];
		$this->qc_id->AdvancedSearch->Save();

		// Field datang_id
		$this->datang_id->AdvancedSearch->SearchValue = @$filter["x_datang_id"];
		$this->datang_id->AdvancedSearch->SearchOperator = @$filter["z_datang_id"];
		$this->datang_id->AdvancedSearch->SearchCondition = @$filter["v_datang_id"];
		$this->datang_id->AdvancedSearch->SearchValue2 = @$filter["y_datang_id"];
		$this->datang_id->AdvancedSearch->SearchOperator2 = @$filter["w_datang_id"];
		$this->datang_id->AdvancedSearch->Save();

		// Field ver_tgl
		$this->ver_tgl->AdvancedSearch->SearchValue = @$filter["x_ver_tgl"];
		$this->ver_tgl->AdvancedSearch->SearchOperator = @$filter["z_ver_tgl"];
		$this->ver_tgl->AdvancedSearch->SearchCondition = @$filter["v_ver_tgl"];
		$this->ver_tgl->AdvancedSearch->SearchValue2 = @$filter["y_ver_tgl"];
		$this->ver_tgl->AdvancedSearch->SearchOperator2 = @$filter["w_ver_tgl"];
		$this->ver_tgl->AdvancedSearch->Save();

		// Field ver_hasil_id
		$this->ver_hasil_id->AdvancedSearch->SearchValue = @$filter["x_ver_hasil_id"];
		$this->ver_hasil_id->AdvancedSearch->SearchOperator = @$filter["z_ver_hasil_id"];
		$this->ver_hasil_id->AdvancedSearch->SearchCondition = @$filter["v_ver_hasil_id"];
		$this->ver_hasil_id->AdvancedSearch->SearchValue2 = @$filter["y_ver_hasil_id"];
		$this->ver_hasil_id->AdvancedSearch->SearchOperator2 = @$filter["w_ver_hasil_id"];
		$this->ver_hasil_id->AdvancedSearch->Save();

		// Field ver_foto
		$this->ver_foto->AdvancedSearch->SearchValue = @$filter["x_ver_foto"];
		$this->ver_foto->AdvancedSearch->SearchOperator = @$filter["z_ver_foto"];
		$this->ver_foto->AdvancedSearch->SearchCondition = @$filter["v_ver_foto"];
		$this->ver_foto->AdvancedSearch->SearchValue2 = @$filter["y_ver_foto"];
		$this->ver_foto->AdvancedSearch->SearchOperator2 = @$filter["w_ver_foto"];
		$this->ver_foto->AdvancedSearch->Save();

		// Field ver_catatan
		$this->ver_catatan->AdvancedSearch->SearchValue = @$filter["x_ver_catatan"];
		$this->ver_catatan->AdvancedSearch->SearchOperator = @$filter["z_ver_catatan"];
		$this->ver_catatan->AdvancedSearch->SearchCondition = @$filter["v_ver_catatan"];
		$this->ver_catatan->AdvancedSearch->SearchValue2 = @$filter["y_ver_catatan"];
		$this->ver_catatan->AdvancedSearch->SearchOperator2 = @$filter["w_ver_catatan"];
		$this->ver_catatan->AdvancedSearch->Save();
		$this->BasicSearch->setKeyword(@$filter[EW_TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[EW_TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	function AdvancedSearchWhere($Default = FALSE) {
		global $Security;
		$sWhere = "";
		if (!$Security->CanSearch()) return "";
		$this->BuildSearchSql($sWhere, $this->ver_id, $Default, FALSE); // ver_id
		$this->BuildSearchSql($sWhere, $this->qc_id, $Default, FALSE); // qc_id
		$this->BuildSearchSql($sWhere, $this->datang_id, $Default, FALSE); // datang_id
		$this->BuildSearchSql($sWhere, $this->ver_tgl, $Default, FALSE); // ver_tgl
		$this->BuildSearchSql($sWhere, $this->ver_hasil_id, $Default, FALSE); // ver_hasil_id
		$this->BuildSearchSql($sWhere, $this->ver_foto, $Default, FALSE); // ver_foto
		$this->BuildSearchSql($sWhere, $this->ver_catatan, $Default, FALSE); // ver_catatan

		// Set up search parm
		if (!$Default && $sWhere <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$Default && $this->Command == "search") {
			$this->ver_id->AdvancedSearch->Save(); // ver_id
			$this->qc_id->AdvancedSearch->Save(); // qc_id
			$this->datang_id->AdvancedSearch->Save(); // datang_id
			$this->ver_tgl->AdvancedSearch->Save(); // ver_tgl
			$this->ver_hasil_id->AdvancedSearch->Save(); // ver_hasil_id
			$this->ver_foto->AdvancedSearch->Save(); // ver_foto
			$this->ver_catatan->AdvancedSearch->Save(); // ver_catatan
		}
		return $sWhere;
	}

	// Build search SQL
	function BuildSearchSql(&$Where, &$Fld, $Default, $MultiValue) {
		$FldParm = $Fld->FldParm();
		$FldVal = ($Default) ? $Fld->AdvancedSearch->SearchValueDefault : $Fld->AdvancedSearch->SearchValue; // @$_GET["x_$FldParm"]
		$FldOpr = ($Default) ? $Fld->AdvancedSearch->SearchOperatorDefault : $Fld->AdvancedSearch->SearchOperator; // @$_GET["z_$FldParm"]
		$FldCond = ($Default) ? $Fld->AdvancedSearch->SearchConditionDefault : $Fld->AdvancedSearch->SearchCondition; // @$_GET["v_$FldParm"]
		$FldVal2 = ($Default) ? $Fld->AdvancedSearch->SearchValue2Default : $Fld->AdvancedSearch->SearchValue2; // @$_GET["y_$FldParm"]
		$FldOpr2 = ($Default) ? $Fld->AdvancedSearch->SearchOperator2Default : $Fld->AdvancedSearch->SearchOperator2; // @$_GET["w_$FldParm"]
		$sWrk = "";
		if (is_array($FldVal)) $FldVal = implode(",", $FldVal);
		if (is_array($FldVal2)) $FldVal2 = implode(",", $FldVal2);
		$FldOpr = strtoupper(trim($FldOpr));
		if ($FldOpr == "") $FldOpr = "=";
		$FldOpr2 = strtoupper(trim($FldOpr2));
		if ($FldOpr2 == "") $FldOpr2 = "=";
		if (EW_SEARCH_MULTI_VALUE_OPTION == 1)
			$MultiValue = FALSE;
		if ($MultiValue) {
			$sWrk1 = ($FldVal <> "") ? ew_GetMultiSearchSql($Fld, $FldOpr, $FldVal, $this->DBID) : ""; // Field value 1
			$sWrk2 = ($FldVal2 <> "") ? ew_GetMultiSearchSql($Fld, $FldOpr2, $FldVal2, $this->DBID) : ""; // Field value 2
			$sWrk = $sWrk1; // Build final SQL
			if ($sWrk2 <> "")
				$sWrk = ($sWrk <> "") ? "($sWrk) $FldCond ($sWrk2)" : $sWrk2;
		} else {
			$FldVal = $this->ConvertSearchValue($Fld, $FldVal);
			$FldVal2 = $this->ConvertSearchValue($Fld, $FldVal2);
			$sWrk = ew_GetSearchSql($Fld, $FldVal, $FldOpr, $FldCond, $FldVal2, $FldOpr2, $this->DBID);
		}
		ew_AddFilter($Where, $sWrk);
	}

	// Convert search value
	function ConvertSearchValue(&$Fld, $FldVal) {
		if ($FldVal == EW_NULL_VALUE || $FldVal == EW_NOT_NULL_VALUE)
			return $FldVal;
		$Value = $FldVal;
		if ($Fld->FldDataType == EW_DATATYPE_BOOLEAN) {
			if ($FldVal <> "") $Value = ($FldVal == "1" || strtolower(strval($FldVal)) == "y" || strtolower(strval($FldVal)) == "t") ? $Fld->TrueValue : $Fld->FalseValue;
		} elseif ($Fld->FldDataType == EW_DATATYPE_DATE || $Fld->FldDataType == EW_DATATYPE_TIME) {
			if ($FldVal <> "") $Value = ew_UnFormatDateTime($FldVal, $Fld->FldDateTimeFormat);
		}
		return $Value;
	}

	// Return basic search SQL
	function BasicSearchSQL($arKeywords, $type) {
		$sWhere = "";
		$this->BuildBasicSearchSQL($sWhere, $this->ver_hasil_id, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->ver_foto, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->ver_catatan, $arKeywords, $type);
		return $sWhere;
	}

	// Build basic search SQL
	function BuildBasicSearchSQL(&$Where, &$Fld, $arKeywords, $type) {
		global $EW_BASIC_SEARCH_IGNORE_PATTERN;
		$sDefCond = ($type == "OR") ? "OR" : "AND";
		$arSQL = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$Keyword = $arKeywords[$i];
			$Keyword = trim($Keyword);
			if ($EW_BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$Keyword = preg_replace($EW_BASIC_SEARCH_IGNORE_PATTERN, "\\", $Keyword);
				$ar = explode("\\", $Keyword);
			} else {
				$ar = array($Keyword);
			}
			foreach ($ar as $Keyword) {
				if ($Keyword <> "") {
					$sWrk = "";
					if ($Keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j-1] = "OR";
					} elseif ($Keyword == EW_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NULL";
					} elseif ($Keyword == EW_NOT_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NOT NULL";
					} elseif ($Fld->FldIsVirtual) {
						$sWrk = $Fld->FldVirtualExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					} elseif ($Fld->FldDataType != EW_DATATYPE_NUMBER || is_numeric($Keyword)) {
						$sWrk = $Fld->FldBasicSearchExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					}
					if ($sWrk <> "") {
						$arSQL[$j] = $sWrk;
						$arCond[$j] = $sDefCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSQL);
		$bQuoted = FALSE;
		$sSql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt-1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$bQuoted) $sSql .= "(";
					$bQuoted = TRUE;
				}
				$sSql .= $arSQL[$i];
				if ($bQuoted && $arCond[$i] <> "OR") {
					$sSql .= ")";
					$bQuoted = FALSE;
				}
				$sSql .= " " . $arCond[$i] . " ";
			}
			$sSql .= $arSQL[$cnt-1];
			if ($bQuoted)
				$sSql .= ")";
		}
		if ($sSql <> "") {
			if ($Where <> "") $Where .= " OR ";
			$Where .= "(" . $sSql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	function BasicSearchWhere($Default = FALSE) {
		global $Security;
		$sSearchStr = "";
		if (!$Security->CanSearch()) return "";
		$sSearchKeyword = ($Default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$sSearchType = ($Default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($sSearchKeyword <> "") {
			$ar = $this->BasicSearch->KeywordList($Default);

			// Search keyword in any fields
			if (($sSearchType == "OR" || $sSearchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $sKeyword) {
					if ($sKeyword <> "") {
						if ($sSearchStr <> "") $sSearchStr .= " " . $sSearchType . " ";
						$sSearchStr .= "(" . $this->BasicSearchSQL(array($sKeyword), $sSearchType) . ")";
					}
				}
			} else {
				$sSearchStr = $this->BasicSearchSQL($ar, $sSearchType);
			}
			if (!$Default && in_array($this->Command, array("", "reset", "resetall"))) $this->Command = "search";
		}
		if (!$Default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($sSearchKeyword);
			$this->BasicSearch->setType($sSearchType);
		}
		return $sSearchStr;
	}

	// Check if search parm exists
	function CheckSearchParms() {

		// Check basic search
		if ($this->BasicSearch->IssetSession())
			return TRUE;
		if ($this->ver_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->qc_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->datang_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->ver_tgl->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->ver_hasil_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->ver_foto->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->ver_catatan->AdvancedSearch->IssetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	function ResetSearchParms() {

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->ResetBasicSearchParms();

		// Clear advanced search parameters
		$this->ResetAdvancedSearchParms();
	}

	// Load advanced search default values
	function LoadAdvancedSearchDefault() {
		return FALSE;
	}

	// Clear all basic search parameters
	function ResetBasicSearchParms() {
		$this->BasicSearch->UnsetSession();
	}

	// Clear all advanced search parameters
	function ResetAdvancedSearchParms() {
		$this->ver_id->AdvancedSearch->UnsetSession();
		$this->qc_id->AdvancedSearch->UnsetSession();
		$this->datang_id->AdvancedSearch->UnsetSession();
		$this->ver_tgl->AdvancedSearch->UnsetSession();
		$this->ver_hasil_id->AdvancedSearch->UnsetSession();
		$this->ver_foto->AdvancedSearch->UnsetSession();
		$this->ver_catatan->AdvancedSearch->UnsetSession();
	}

	// Restore all search parameters
	function RestoreSearchParms() {
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->Load();

		// Restore advanced search values
		$this->ver_id->AdvancedSearch->Load();
		$this->qc_id->AdvancedSearch->Load();
		$this->datang_id->AdvancedSearch->Load();
		$this->ver_tgl->AdvancedSearch->Load();
		$this->ver_hasil_id->AdvancedSearch->Load();
		$this->ver_foto->AdvancedSearch->Load();
		$this->ver_catatan->AdvancedSearch->Load();
	}

	// Set up sort parameters
	function SetupSortOrder() {

		// Check for "order" parameter
		if (@$_GET["order"] <> "") {
			$this->CurrentOrder = @$_GET["order"];
			$this->CurrentOrderType = @$_GET["ordertype"];
			$this->UpdateSort($this->ver_id); // ver_id
			$this->UpdateSort($this->qc_id); // qc_id
			$this->UpdateSort($this->datang_id); // datang_id
			$this->UpdateSort($this->ver_tgl); // ver_tgl
			$this->UpdateSort($this->ver_hasil_id); // ver_hasil_id
			$this->UpdateSort($this->ver_foto); // ver_foto
			$this->UpdateSort($this->ver_catatan); // ver_catatan
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	function LoadSortOrder() {
		$sOrderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($sOrderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$sOrderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($sOrderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)
	function ResetCmd() {

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->ResetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$sOrderBy = "";
				$this->setSessionOrderBy($sOrderBy);
				$this->ver_id->setSort("");
				$this->qc_id->setSort("");
				$this->datang_id->setSort("");
				$this->ver_tgl->setSort("");
				$this->ver_hasil_id->setSort("");
				$this->ver_foto->setSort("");
				$this->ver_catatan->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	function SetupListOptions() {
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->Add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->Add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->CanView();
		$item->OnLeft = TRUE;

		// "edit"
		$item = &$this->ListOptions->Add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->CanEdit();
		$item->OnLeft = TRUE;

		// "copy"
		$item = &$this->ListOptions->Add("copy");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->CanAdd();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->Add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->Add("checkbox");
		$item->Visible = $Security->CanDelete();
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew_SelectAllKey(this);\">";
		$item->MoveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseImageAndText = TRUE;
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->Phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		if ($this->ListOptions->UseButtonGroup && ew_IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;
		$this->ListOptions->ButtonClass = "btn-sm"; // Class for button group

		// Call ListOptions_Load event
		$this->ListOptions_Load();
		$this->SetupListOptionsExt();
		$item = &$this->ListOptions->GetItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->GroupOptionVisible();
	}

	// Render list options
	function RenderListOptions() {
		global $Security, $Language, $objForm;
		$this->ListOptions->LoadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$oListOpt = &$this->ListOptions->Items["view"];
		$viewcaption = ew_HtmlTitle($Language->Phrase("ViewLink"));
		if ($Security->CanView()) {
			$oListOpt->Body = "<a class=\"ewRowLink ewView\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . ew_HtmlEncode($this->ViewUrl) . "\">" . $Language->Phrase("ViewLink") . "</a>";
		} else {
			$oListOpt->Body = "";
		}

		// "edit"
		$oListOpt = &$this->ListOptions->Items["edit"];
		$editcaption = ew_HtmlTitle($Language->Phrase("EditLink"));
		if ($Security->CanEdit()) {
			$oListOpt->Body = "<a class=\"ewRowLink ewEdit\" title=\"" . ew_HtmlTitle($Language->Phrase("EditLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("EditLink")) . "\" href=\"" . ew_HtmlEncode($this->EditUrl) . "\">" . $Language->Phrase("EditLink") . "</a>";
		} else {
			$oListOpt->Body = "";
		}

		// "copy"
		$oListOpt = &$this->ListOptions->Items["copy"];
		$copycaption = ew_HtmlTitle($Language->Phrase("CopyLink"));
		if ($Security->CanAdd()) {
			$oListOpt->Body = "<a class=\"ewRowLink ewCopy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . ew_HtmlEncode($this->CopyUrl) . "\">" . $Language->Phrase("CopyLink") . "</a>";
		} else {
			$oListOpt->Body = "";
		}

		// Set up list action buttons
		$oListOpt = &$this->ListOptions->GetItem("listactions");
		if ($oListOpt && $this->Export == "" && $this->CurrentAction == "") {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode(str_replace(" ewIcon", "", $listaction->Icon)) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\"></span> " : "";
					$links[] = "<li><a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" title=\"" . ew_HtmlTitle($caption) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $Language->Phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default btn-sm ewActions\" title=\"" . ew_HtmlTitle($Language->Phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->Phrase("ListActionButton") . "<b class=\"caret\"></b></button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($oListOpt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$oListOpt->Body = $body;
				$oListOpt->Visible = TRUE;
			}
		}

		// "checkbox"
		$oListOpt = &$this->ListOptions->Items["checkbox"];
		$oListOpt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ewMultiSelect\" value=\"" . ew_HtmlEncode($this->ver_id->CurrentValue) . "\" onclick=\"ew_ClickMultiCheckbox(event);\">";
		$this->RenderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	function SetupOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->Add("add");
		$addcaption = ew_HtmlTitle($Language->Phrase("AddLink"));
		$item->Body = "<a class=\"ewAddEdit ewAdd\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . ew_HtmlEncode($this->AddUrl) . "\">" . $Language->Phrase("AddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->CanAdd());
		$option = $options["action"];

		// Add multi delete
		$item = &$option->Add("multidelete");
		$item->Body = "<a class=\"ewAction ewMultiDelete\" title=\"" . ew_HtmlTitle($Language->Phrase("DeleteSelectedLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("DeleteSelectedLink")) . "\" href=\"\" onclick=\"ew_SubmitAction(event,{f:document.fverifikasilist,url:'" . $this->MultiDeleteUrl . "'});return false;\">" . $Language->Phrase("DeleteSelectedLink") . "</a>";
		$item->Visible = ($Security->CanDelete());

		// Set up options default
		foreach ($options as &$option) {
			$option->UseImageAndText = TRUE;
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;
			$option->ButtonClass = "btn-sm"; // Class for button group
			$item = &$option->Add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->Phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->Phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->Phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->Add("savecurrentfilter");
		$item->Body = "<a class=\"ewSaveFilter\" data-form=\"fverifikasilistsrch\" href=\"#\">" . $Language->Phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->Add("deletefilter");
		$item->Body = "<a class=\"ewDeleteFilter\" data-form=\"fverifikasilistsrch\" href=\"#\">" . $Language->Phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->Phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->Add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	function RenderOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_MULTIPLE) {
					$item = &$option->Add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode($listaction->Icon) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\"></span> " : $caption;
					$item->Body = "<a class=\"ewAction ewListAction\" title=\"" . ew_HtmlEncode($caption) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({f:document.fverifikasilist}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->GetItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->HideAllOptions();
			}
	}

	// Process list action
	function ProcessListAction() {
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$sFilter = $this->GetKeyFilter();
		$UserAction = @$_POST["useraction"];
		if ($sFilter <> "" && $UserAction <> "") {

			// Check permission first
			$ActionCaption = $UserAction;
			if (array_key_exists($UserAction, $this->ListActions->Items)) {
				$ActionCaption = $this->ListActions->Items[$UserAction]->Caption;
				if (!$this->ListActions->Items[$UserAction]->Allow) {
					$errmsg = str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionNotAllowed"));
					if (@$_POST["ajax"] == $UserAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $sFilter;
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			$rs = $conn->Execute($sSql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $UserAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->BeginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$Processed = $this->Row_CustomAction($UserAction, $row);
					if (!$Processed) break;
					$rs->MoveNext();
				}
				if ($Processed) {
					$conn->CommitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->RollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->Close();
			$this->CurrentAction = ""; // Clear action
			if (@$_POST["ajax"] == $UserAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->ClearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->ClearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	function SetupSearchOptions() {
		global $Language;
		$this->SearchOptions = new cListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ewSearchOption";

		// Search button
		$item = &$this->SearchOptions->Add("searchtoggle");
		$SearchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ewSearchToggle" . $SearchToggleClass . "\" title=\"" . $Language->Phrase("SearchPanel") . "\" data-caption=\"" . $Language->Phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fverifikasilistsrch\">" . $Language->Phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->Add("showall");
		$item->Body = "<a class=\"btn btn-default ewShowAll\" title=\"" . $Language->Phrase("ShowAll") . "\" data-caption=\"" . $Language->Phrase("ShowAll") . "\" href=\"" . $this->PageUrl() . "cmd=reset\">" . $Language->Phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseImageAndText = TRUE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->Phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->Add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->Export <> "" || $this->CurrentAction <> "")
			$this->SearchOptions->HideAllOptions();
		global $Security;
		if (!$Security->CanSearch()) {
			$this->SearchOptions->HideAllOptions();
			$this->FilterOptions->HideAllOptions();
		}
	}

	function SetupListOptionsExt() {
		global $Security, $Language;
	}

	function RenderListOptionsExt() {
		global $Security, $Language;
	}

	// Set up starting record parameters
	function SetupStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	function LoadBasicSearchValues() {
		$this->BasicSearch->Keyword = @$_GET[EW_TABLE_BASIC_SEARCH];
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "") $this->Command = "search";
		$this->BasicSearch->Type = @$_GET[EW_TABLE_BASIC_SEARCH_TYPE];
	}

	// Load search values for validation
	function LoadSearchValues() {
		global $objForm;

		// Load search values
		// ver_id

		$this->ver_id->AdvancedSearch->SearchValue = @$_GET["x_ver_id"];
		if ($this->ver_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->ver_id->AdvancedSearch->SearchOperator = @$_GET["z_ver_id"];

		// qc_id
		$this->qc_id->AdvancedSearch->SearchValue = @$_GET["x_qc_id"];
		if ($this->qc_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->qc_id->AdvancedSearch->SearchOperator = @$_GET["z_qc_id"];

		// datang_id
		$this->datang_id->AdvancedSearch->SearchValue = @$_GET["x_datang_id"];
		if ($this->datang_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->datang_id->AdvancedSearch->SearchOperator = @$_GET["z_datang_id"];

		// ver_tgl
		$this->ver_tgl->AdvancedSearch->SearchValue = @$_GET["x_ver_tgl"];
		if ($this->ver_tgl->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->ver_tgl->AdvancedSearch->SearchOperator = @$_GET["z_ver_tgl"];

		// ver_hasil_id
		$this->ver_hasil_id->AdvancedSearch->SearchValue = @$_GET["x_ver_hasil_id"];
		if ($this->ver_hasil_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->ver_hasil_id->AdvancedSearch->SearchOperator = @$_GET["z_ver_hasil_id"];

		// ver_foto
		$this->ver_foto->AdvancedSearch->SearchValue = @$_GET["x_ver_foto"];
		if ($this->ver_foto->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->ver_foto->AdvancedSearch->SearchOperator = @$_GET["z_ver_foto"];

		// ver_catatan
		$this->ver_catatan->AdvancedSearch->SearchValue = @$_GET["x_ver_catatan"];
		if ($this->ver_catatan->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->ver_catatan->AdvancedSearch->SearchOperator = @$_GET["z_ver_catatan"];
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {

		// Load List page SQL
		$sSql = $this->ListSQL();
		$conn = &$this->Connection();

		// Load recordset
		$dbtype = ew_GetConnectionType($this->DBID);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset, array("_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())));
			} else {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = ew_LoadRecordset($sSql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues($rs = NULL) {
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->NewRow(); 

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->ver_id->setDbValue($row['ver_id']);
		$this->qc_id->setDbValue($row['qc_id']);
		$this->datang_id->setDbValue($row['datang_id']);
		$this->ver_tgl->setDbValue($row['ver_tgl']);
		$this->ver_hasil_id->setDbValue($row['ver_hasil_id']);
		$this->ver_foto->Upload->DbValue = $row['ver_foto'];
		$this->ver_foto->setDbValue($this->ver_foto->Upload->DbValue);
		$this->ver_catatan->setDbValue($row['ver_catatan']);
	}

	// Return a row with default values
	function NewRow() {
		$row = array();
		$row['ver_id'] = NULL;
		$row['qc_id'] = NULL;
		$row['datang_id'] = NULL;
		$row['ver_tgl'] = NULL;
		$row['ver_hasil_id'] = NULL;
		$row['ver_foto'] = NULL;
		$row['ver_catatan'] = NULL;
		return $row;
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->ver_id->DbValue = $row['ver_id'];
		$this->qc_id->DbValue = $row['qc_id'];
		$this->datang_id->DbValue = $row['datang_id'];
		$this->ver_tgl->DbValue = $row['ver_tgl'];
		$this->ver_hasil_id->DbValue = $row['ver_hasil_id'];
		$this->ver_foto->Upload->DbValue = $row['ver_foto'];
		$this->ver_catatan->DbValue = $row['ver_catatan'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("ver_id")) <> "")
			$this->ver_id->CurrentValue = $this->getKey("ver_id"); // ver_id
		else
			$bValidKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
		}
		$this->LoadRowValues($this->OldRecordset); // Load row values
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->GetViewUrl();
		$this->EditUrl = $this->GetEditUrl();
		$this->InlineEditUrl = $this->GetInlineEditUrl();
		$this->CopyUrl = $this->GetCopyUrl();
		$this->InlineCopyUrl = $this->GetInlineCopyUrl();
		$this->DeleteUrl = $this->GetDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// ver_id
		// qc_id
		// datang_id
		// ver_tgl
		// ver_hasil_id
		// ver_foto

		$this->ver_foto->CellCssStyle = "width: 200px;";

		// ver_catatan
		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// ver_id
		$this->ver_id->ViewValue = $this->ver_id->CurrentValue;
		$this->ver_id->ViewCustomAttributes = "";

		// qc_id
		if (strval($this->qc_id->CurrentValue) <> "") {
			$sFilterWrk = "`qc_id`" . ew_SearchString("=", $this->qc_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `qc_id`, `qc_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `qc`";
		$sWhereWrk = "";
		$this->qc_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->qc_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `qc_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->qc_id->ViewValue = $this->qc_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->qc_id->ViewValue = $this->qc_id->CurrentValue;
			}
		} else {
			$this->qc_id->ViewValue = NULL;
		}
		$this->qc_id->ViewCustomAttributes = "";

		// datang_id
		if (strval($this->datang_id->CurrentValue) <> "") {
			$sFilterWrk = "`datang_id`" . ew_SearchString("=", $this->datang_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `datang_id`, `datang_id` AS `DispFld`, `datang_jumlah` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kedatangan`";
		$sWhereWrk = "";
		$this->datang_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->datang_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `datang_id` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = $rswrk->fields('Disp2Fld');
				$this->datang_id->ViewValue = $this->datang_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->datang_id->ViewValue = $this->datang_id->CurrentValue;
			}
		} else {
			$this->datang_id->ViewValue = NULL;
		}
		$this->datang_id->ViewCustomAttributes = "";

		// ver_tgl
		$this->ver_tgl->ViewValue = $this->ver_tgl->CurrentValue;
		$this->ver_tgl->ViewValue = ew_FormatDateTime($this->ver_tgl->ViewValue, 0);
		$this->ver_tgl->ViewCustomAttributes = "";

		// ver_hasil_id
		if (strval($this->ver_hasil_id->CurrentValue) <> "") {
			$sFilterWrk = "`vh_id`" . ew_SearchString("=", $this->ver_hasil_id->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `vh_id`, `vh_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `verifikasi_hasil`";
		$sWhereWrk = "";
		$this->ver_hasil_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->ver_hasil_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `vh_id` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->ver_hasil_id->ViewValue = $this->ver_hasil_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->ver_hasil_id->ViewValue = $this->ver_hasil_id->CurrentValue;
			}
		} else {
			$this->ver_hasil_id->ViewValue = NULL;
		}
		$this->ver_hasil_id->ViewCustomAttributes = "";

		// ver_foto
		if (!ew_Empty($this->ver_foto->Upload->DbValue)) {
			$this->ver_foto->ImageWidth = 200;
			$this->ver_foto->ImageHeight = 100;
			$this->ver_foto->ImageAlt = $this->ver_foto->FldAlt();
			$this->ver_foto->ViewValue = $this->ver_foto->Upload->DbValue;
		} else {
			$this->ver_foto->ViewValue = "";
		}
		$this->ver_foto->ViewCustomAttributes = "";

		// ver_catatan
		$this->ver_catatan->ViewValue = $this->ver_catatan->CurrentValue;
		$this->ver_catatan->ViewCustomAttributes = "";

			// ver_id
			$this->ver_id->LinkCustomAttributes = "";
			$this->ver_id->HrefValue = "";
			$this->ver_id->TooltipValue = "";

			// qc_id
			$this->qc_id->LinkCustomAttributes = "";
			$this->qc_id->HrefValue = "";
			$this->qc_id->TooltipValue = "";

			// datang_id
			$this->datang_id->LinkCustomAttributes = "";
			$this->datang_id->HrefValue = "";
			$this->datang_id->TooltipValue = "";

			// ver_tgl
			$this->ver_tgl->LinkCustomAttributes = "";
			$this->ver_tgl->HrefValue = "";
			$this->ver_tgl->TooltipValue = "";

			// ver_hasil_id
			$this->ver_hasil_id->LinkCustomAttributes = "";
			$this->ver_hasil_id->HrefValue = "";
			$this->ver_hasil_id->TooltipValue = "";

			// ver_foto
			$this->ver_foto->LinkCustomAttributes = "";
			if (!ew_Empty($this->ver_foto->Upload->DbValue)) {
				$this->ver_foto->HrefValue = "%u"; // Add prefix/suffix
				$this->ver_foto->LinkAttrs["target"] = ""; // Add target
				if ($this->Export <> "") $this->ver_foto->HrefValue = ew_FullUrl($this->ver_foto->HrefValue, "href");
			} else {
				$this->ver_foto->HrefValue = "";
			}
			$this->ver_foto->HrefValue2 = $this->ver_foto->UploadPath . $this->ver_foto->Upload->DbValue;
			$this->ver_foto->TooltipValue = "";
			if ($this->ver_foto->UseColorbox) {
				if (ew_Empty($this->ver_foto->TooltipValue))
					$this->ver_foto->LinkAttrs["title"] = $Language->Phrase("ViewImageGallery");
				$this->ver_foto->LinkAttrs["data-rel"] = "verifikasi_x" . $this->RowCnt . "_ver_foto";
				ew_AppendClass($this->ver_foto->LinkAttrs["class"], "ewLightbox");
			}

			// ver_catatan
			$this->ver_catatan->LinkCustomAttributes = "";
			$this->ver_catatan->HrefValue = "";
			$this->ver_catatan->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_SEARCH) { // Search row

			// ver_id
			$this->ver_id->EditAttrs["class"] = "form-control";
			$this->ver_id->EditCustomAttributes = "";
			$this->ver_id->EditValue = ew_HtmlEncode($this->ver_id->AdvancedSearch->SearchValue);
			$this->ver_id->PlaceHolder = ew_RemoveHtml($this->ver_id->FldCaption());

			// qc_id
			$this->qc_id->EditAttrs["class"] = "form-control";
			$this->qc_id->EditCustomAttributes = "";
			if (trim(strval($this->qc_id->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`qc_id`" . ew_SearchString("=", $this->qc_id->AdvancedSearch->SearchValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `qc_id`, `qc_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `qc`";
			$sWhereWrk = "";
			$this->qc_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->qc_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `qc_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->qc_id->EditValue = $arwrk;

			// datang_id
			$this->datang_id->EditAttrs["class"] = "form-control";
			$this->datang_id->EditCustomAttributes = "";

			// ver_tgl
			$this->ver_tgl->EditAttrs["class"] = "form-control";
			$this->ver_tgl->EditCustomAttributes = "";
			$this->ver_tgl->EditValue = ew_HtmlEncode(ew_FormatDateTime(ew_UnFormatDateTime($this->ver_tgl->AdvancedSearch->SearchValue, 0), 8));
			$this->ver_tgl->PlaceHolder = ew_RemoveHtml($this->ver_tgl->FldCaption());

			// ver_hasil_id
			$this->ver_hasil_id->EditAttrs["class"] = "form-control";
			$this->ver_hasil_id->EditCustomAttributes = "";
			if (trim(strval($this->ver_hasil_id->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`vh_id`" . ew_SearchString("=", $this->ver_hasil_id->AdvancedSearch->SearchValue, EW_DATATYPE_STRING, "");
			}
			$sSqlWrk = "SELECT `vh_id`, `vh_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `verifikasi_hasil`";
			$sWhereWrk = "";
			$this->ver_hasil_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->ver_hasil_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `vh_id` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->ver_hasil_id->EditValue = $arwrk;

			// ver_foto
			$this->ver_foto->EditAttrs["class"] = "form-control";
			$this->ver_foto->EditCustomAttributes = "";
			$this->ver_foto->EditValue = ew_HtmlEncode($this->ver_foto->AdvancedSearch->SearchValue);
			$this->ver_foto->PlaceHolder = ew_RemoveHtml($this->ver_foto->FldCaption());

			// ver_catatan
			$this->ver_catatan->EditAttrs["class"] = "form-control";
			$this->ver_catatan->EditCustomAttributes = "";
			$this->ver_catatan->EditValue = ew_HtmlEncode($this->ver_catatan->AdvancedSearch->SearchValue);
			$this->ver_catatan->PlaceHolder = ew_RemoveHtml($this->ver_catatan->FldCaption());
		}
		if ($this->RowType == EW_ROWTYPE_ADD || $this->RowType == EW_ROWTYPE_EDIT || $this->RowType == EW_ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->SetupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	function ValidateSearch() {
		global $gsSearchError;

		// Initialize
		$gsSearchError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return TRUE;
		if (!ew_CheckDateDef($this->ver_tgl->AdvancedSearch->SearchValue)) {
			ew_AddMessage($gsSearchError, $this->ver_tgl->FldErrMsg());
		}

		// Return validate result
		$ValidateSearch = ($gsSearchError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateSearch = $ValidateSearch && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsSearchError, $sFormCustomError);
		}
		return $ValidateSearch;
	}

	// Load advanced search
	function LoadAdvancedSearch() {
		$this->ver_id->AdvancedSearch->Load();
		$this->qc_id->AdvancedSearch->Load();
		$this->datang_id->AdvancedSearch->Load();
		$this->ver_tgl->AdvancedSearch->Load();
		$this->ver_hasil_id->AdvancedSearch->Load();
		$this->ver_foto->AdvancedSearch->Load();
		$this->ver_catatan->AdvancedSearch->Load();
	}

	// Set up export options
	function SetupExportOptions() {
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->Add("print");
		$item->Body = "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ewExportLink ewPrint\" title=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\">" . $Language->Phrase("PrinterFriendly") . "</a>";
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->Add("excel");
		$item->Body = "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ewExportLink ewExcel\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\">" . $Language->Phrase("ExportToExcel") . "</a>";
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->Add("word");
		$item->Body = "<a href=\"" . $this->ExportWordUrl . "\" class=\"ewExportLink ewWord\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\">" . $Language->Phrase("ExportToWord") . "</a>";
		$item->Visible = TRUE;

		// Export to Html
		$item = &$this->ExportOptions->Add("html");
		$item->Body = "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ewExportLink ewHtml\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\">" . $Language->Phrase("ExportToHtml") . "</a>";
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->Add("xml");
		$item->Body = "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ewExportLink ewXml\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\">" . $Language->Phrase("ExportToXml") . "</a>";
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->Add("csv");
		$item->Body = "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ewExportLink ewCsv\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\">" . $Language->Phrase("ExportToCsv") . "</a>";
		$item->Visible = FALSE;

		// Export to Pdf
		$item = &$this->ExportOptions->Add("pdf");
		$item->Body = "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ewExportLink ewPdf\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\">" . $Language->Phrase("ExportToPDF") . "</a>";
		$item->Visible = FALSE;

		// Export to Email
		$item = &$this->ExportOptions->Add("email");
		$url = "";
		$item->Body = "<button id=\"emf_verifikasi\" class=\"ewExportLink ewEmail\" title=\"" . $Language->Phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->Phrase("ExportToEmailText") . "\" onclick=\"ew_EmailDialogShow({lnk:'emf_verifikasi',hdr:ewLanguage.Phrase('ExportToEmailText'),f:document.fverifikasilist,sel:false" . $url . "});\">" . $Language->Phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseImageAndText = TRUE;
		$this->ExportOptions->UseDropDownButton = FALSE;
		if ($this->ExportOptions->UseButtonGroup && ew_IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->Phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->Add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	function ExportData() {
		$utf8 = (strtolower(EW_CHARSET) == "utf-8");
		$bSelectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($bSelectLimit) {
			$this->TotalRecs = $this->ListRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->LoadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EW_EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->SetupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($bSelectLimit)
			$rs = $this->LoadRecordset($this->StartRec-1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		if (!$rs) {
			header("Content-Type:"); // Remove header
			header("Content-Disposition:");
			$this->ShowMessage();
			return;
		}
		$this->ExportDoc = ew_ExportDocument($this, "h");
		$Doc = &$this->ExportDoc;
		if ($bSelectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		} else {

			//$this->StartRec = $this->StartRec;
			//$this->StopRec = $this->StopRec;

		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$ParentTable = "";
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		$Doc->Text .= $sHeader;
		$this->ExportDocument($Doc, $rs, $this->StartRec, $this->StopRec, "");
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		$Doc->Text .= $sFooter;

		// Close recordset
		$rs->Close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$Doc->ExportHeaderAndFooter();

		// Clean output buffer
		if (!EW_DEBUG_ENABLED && ob_get_length())
			ob_end_clean();

		// Write debug message if enabled
		if (EW_DEBUG_ENABLED && $this->Export <> "pdf")
			echo ew_DebugMsg();

		// Output data
		$Doc->Export();
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->Add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup filters of a field
	function SetupLookupFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		if ($pageId == "list") {
			switch ($fld->FldVar) {
			}
		} elseif ($pageId == "extbs") {
			switch ($fld->FldVar) {
		case "x_qc_id":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `qc_id` AS `LinkFld`, `qc_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `qc`";
				$sWhereWrk = "";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`qc_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->qc_id, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$sSqlWrk .= " ORDER BY `qc_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_ver_hasil_id":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `vh_id` AS `LinkFld`, `vh_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `verifikasi_hasil`";
				$sWhereWrk = "";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`vh_id` IN ({filter_value})', "t0" => "200", "fn0" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->ver_hasil_id, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$sSqlWrk .= " ORDER BY `vh_id` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
			}
		}
	}

	// Setup AutoSuggest filters of a field
	function SetupAutoSuggestFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		if ($pageId == "list") {
			switch ($fld->FldVar) {
			}
		} elseif ($pageId == "extbs") {
			switch ($fld->FldVar) {
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($verifikasi_list)) $verifikasi_list = new cverifikasi_list();

// Page init
$verifikasi_list->Page_Init();

// Page main
$verifikasi_list->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$verifikasi_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if ($verifikasi->Export == "") { ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "list";
var CurrentForm = fverifikasilist = new ew_Form("fverifikasilist", "list");
fverifikasilist.FormKeyCountName = '<?php echo $verifikasi_list->FormKeyCountName ?>';

// Form_CustomValidate event
fverifikasilist.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fverifikasilist.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fverifikasilist.Lists["x_qc_id"] = {"LinkField":"x_qc_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_qc_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"qc"};
fverifikasilist.Lists["x_qc_id"].Data = "<?php echo $verifikasi_list->qc_id->LookupFilterQuery(FALSE, "list") ?>";
fverifikasilist.Lists["x_datang_id"] = {"LinkField":"x_datang_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_datang_id","x_datang_jumlah","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kedatangan"};
fverifikasilist.Lists["x_datang_id"].Data = "<?php echo $verifikasi_list->datang_id->LookupFilterQuery(FALSE, "list") ?>";
fverifikasilist.Lists["x_ver_hasil_id"] = {"LinkField":"x_vh_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_vh_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"verifikasi_hasil"};
fverifikasilist.Lists["x_ver_hasil_id"].Data = "<?php echo $verifikasi_list->ver_hasil_id->LookupFilterQuery(FALSE, "list") ?>";

// Form object for search
var CurrentSearchForm = fverifikasilistsrch = new ew_Form("fverifikasilistsrch");

// Validate function for search
fverifikasilistsrch.Validate = function(fobj) {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	fobj = fobj || this.Form;
	var infix = "";
	elm = this.GetElements("x" + infix + "_ver_tgl");
	if (elm && !ew_CheckDateDef(elm.value))
		return this.OnError(elm, "<?php echo ew_JsEncode2($verifikasi->ver_tgl->FldErrMsg()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fverifikasilistsrch.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fverifikasilistsrch.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fverifikasilistsrch.Lists["x_qc_id"] = {"LinkField":"x_qc_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_qc_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"qc"};
fverifikasilistsrch.Lists["x_qc_id"].Data = "<?php echo $verifikasi_list->qc_id->LookupFilterQuery(FALSE, "extbs") ?>";
fverifikasilistsrch.Lists["x_ver_hasil_id"] = {"LinkField":"x_vh_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_vh_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"verifikasi_hasil"};
fverifikasilistsrch.Lists["x_ver_hasil_id"].Data = "<?php echo $verifikasi_list->ver_hasil_id->LookupFilterQuery(FALSE, "extbs") ?>";

// Init search panel as collapsed
if (fverifikasilistsrch) fverifikasilistsrch.InitSearchPanel = true;
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if ($verifikasi->Export == "") { ?>
<div class="ewToolbar">
<?php if ($verifikasi_list->TotalRecs > 0 && $verifikasi_list->ExportOptions->Visible()) { ?>
<?php $verifikasi_list->ExportOptions->Render("body") ?>
<?php } ?>
<?php if ($verifikasi_list->SearchOptions->Visible()) { ?>
<?php $verifikasi_list->SearchOptions->Render("body") ?>
<?php } ?>
<?php if ($verifikasi_list->FilterOptions->Visible()) { ?>
<?php $verifikasi_list->FilterOptions->Render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
	$bSelectLimit = $verifikasi_list->UseSelectLimit;
	if ($bSelectLimit) {
		if ($verifikasi_list->TotalRecs <= 0)
			$verifikasi_list->TotalRecs = $verifikasi->ListRecordCount();
	} else {
		if (!$verifikasi_list->Recordset && ($verifikasi_list->Recordset = $verifikasi_list->LoadRecordset()))
			$verifikasi_list->TotalRecs = $verifikasi_list->Recordset->RecordCount();
	}
	$verifikasi_list->StartRec = 1;
	if ($verifikasi_list->DisplayRecs <= 0 || ($verifikasi->Export <> "" && $verifikasi->ExportAll)) // Display all records
		$verifikasi_list->DisplayRecs = $verifikasi_list->TotalRecs;
	if (!($verifikasi->Export <> "" && $verifikasi->ExportAll))
		$verifikasi_list->SetupStartRec(); // Set up start record position
	if ($bSelectLimit)
		$verifikasi_list->Recordset = $verifikasi_list->LoadRecordset($verifikasi_list->StartRec-1, $verifikasi_list->DisplayRecs);

	// Set no record found message
	if ($verifikasi->CurrentAction == "" && $verifikasi_list->TotalRecs == 0) {
		if (!$Security->CanList())
			$verifikasi_list->setWarningMessage(ew_DeniedMsg());
		if ($verifikasi_list->SearchWhere == "0=101")
			$verifikasi_list->setWarningMessage($Language->Phrase("EnterSearchCriteria"));
		else
			$verifikasi_list->setWarningMessage($Language->Phrase("NoRecord"));
	}
$verifikasi_list->RenderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if ($verifikasi->Export == "" && $verifikasi->CurrentAction == "") { ?>
<form name="fverifikasilistsrch" id="fverifikasilistsrch" class="form-inline ewForm ewExtSearchForm" action="<?php echo ew_CurrentPage() ?>">
<?php $SearchPanelClass = ($verifikasi_list->SearchWhere <> "") ? " in" : ""; ?>
<div id="fverifikasilistsrch_SearchPanel" class="ewSearchPanel collapse<?php echo $SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="verifikasi">
	<div class="ewBasicSearch">
<?php
if ($gsSearchError == "")
	$verifikasi_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$verifikasi->RowType = EW_ROWTYPE_SEARCH;

// Render row
$verifikasi->ResetAttrs();
$verifikasi_list->RenderRow();
?>
<div id="xsr_1" class="ewRow">
<?php if ($verifikasi->qc_id->Visible) { // qc_id ?>
	<div id="xsc_qc_id" class="ewCell form-group">
		<label for="x_qc_id" class="ewSearchCaption ewLabel"><?php echo $verifikasi->qc_id->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_qc_id" id="z_qc_id" value="="></span>
		<span class="ewSearchField">
<select data-table="verifikasi" data-field="x_qc_id" data-value-separator="<?php echo $verifikasi->qc_id->DisplayValueSeparatorAttribute() ?>" id="x_qc_id" name="x_qc_id"<?php echo $verifikasi->qc_id->EditAttributes() ?>>
<?php echo $verifikasi->qc_id->SelectOptionListHtml("x_qc_id") ?>
</select>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ewRow">
<?php if ($verifikasi->ver_tgl->Visible) { // ver_tgl ?>
	<div id="xsc_ver_tgl" class="ewCell form-group">
		<label for="x_ver_tgl" class="ewSearchCaption ewLabel"><?php echo $verifikasi->ver_tgl->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_ver_tgl" id="z_ver_tgl" value="="></span>
		<span class="ewSearchField">
<input type="text" data-table="verifikasi" data-field="x_ver_tgl" name="x_ver_tgl" id="x_ver_tgl" placeholder="<?php echo ew_HtmlEncode($verifikasi->ver_tgl->getPlaceHolder()) ?>" value="<?php echo $verifikasi->ver_tgl->EditValue ?>"<?php echo $verifikasi->ver_tgl->EditAttributes() ?>>
<?php if (!$verifikasi->ver_tgl->ReadOnly && !$verifikasi->ver_tgl->Disabled && !isset($verifikasi->ver_tgl->EditAttrs["readonly"]) && !isset($verifikasi->ver_tgl->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("fverifikasilistsrch", "x_ver_tgl", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ewRow">
<?php if ($verifikasi->ver_hasil_id->Visible) { // ver_hasil_id ?>
	<div id="xsc_ver_hasil_id" class="ewCell form-group">
		<label for="x_ver_hasil_id" class="ewSearchCaption ewLabel"><?php echo $verifikasi->ver_hasil_id->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_ver_hasil_id" id="z_ver_hasil_id" value="LIKE"></span>
		<span class="ewSearchField">
<select data-table="verifikasi" data-field="x_ver_hasil_id" data-value-separator="<?php echo $verifikasi->ver_hasil_id->DisplayValueSeparatorAttribute() ?>" id="x_ver_hasil_id" name="x_ver_hasil_id"<?php echo $verifikasi->ver_hasil_id->EditAttributes() ?>>
<?php echo $verifikasi->ver_hasil_id->SelectOptionListHtml("x_ver_hasil_id") ?>
</select>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ewRow">
	<div class="ewQuickSearch input-group">
	<input type="text" name="<?php echo EW_TABLE_BASIC_SEARCH ?>" id="<?php echo EW_TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo ew_HtmlEncode($verifikasi_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo ew_HtmlEncode($Language->Phrase("Search")) ?>">
	<input type="hidden" name="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo ew_HtmlEncode($verifikasi_list->BasicSearch->getType()) ?>">
	<div class="input-group-btn">
		<button type="button" data-toggle="dropdown" class="btn btn-default"><span id="searchtype"><?php echo $verifikasi_list->BasicSearch->getTypeNameShort() ?></span><span class="caret"></span></button>
		<ul class="dropdown-menu pull-right" role="menu">
			<li<?php if ($verifikasi_list->BasicSearch->getType() == "") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this)"><?php echo $Language->Phrase("QuickSearchAuto") ?></a></li>
			<li<?php if ($verifikasi_list->BasicSearch->getType() == "=") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'=')"><?php echo $Language->Phrase("QuickSearchExact") ?></a></li>
			<li<?php if ($verifikasi_list->BasicSearch->getType() == "AND") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'AND')"><?php echo $Language->Phrase("QuickSearchAll") ?></a></li>
			<li<?php if ($verifikasi_list->BasicSearch->getType() == "OR") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'OR')"><?php echo $Language->Phrase("QuickSearchAny") ?></a></li>
		</ul>
	<button class="btn btn-primary ewButton" name="btnsubmit" id="btnsubmit" type="submit"><?php echo $Language->Phrase("SearchBtn") ?></button>
	</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $verifikasi_list->ShowPageHeader(); ?>
<?php
$verifikasi_list->ShowMessage();
?>
<?php if ($verifikasi_list->TotalRecs > 0 || $verifikasi->CurrentAction <> "") { ?>
<div class="box ewBox ewGrid<?php if ($verifikasi_list->IsAddOrEdit()) { ?> ewGridAddEdit<?php } ?> verifikasi">
<?php if ($verifikasi->Export == "") { ?>
<div class="box-header ewGridUpperPanel">
<?php if ($verifikasi->CurrentAction <> "gridadd" && $verifikasi->CurrentAction <> "gridedit") { ?>
<form name="ewPagerForm" class="form-inline ewForm ewPagerForm" action="<?php echo ew_CurrentPage() ?>">
<?php if (!isset($verifikasi_list->Pager)) $verifikasi_list->Pager = new cNumericPager($verifikasi_list->StartRec, $verifikasi_list->DisplayRecs, $verifikasi_list->TotalRecs, $verifikasi_list->RecRange, $verifikasi_list->AutoHidePager) ?>
<?php if ($verifikasi_list->Pager->RecordCount > 0 && $verifikasi_list->Pager->Visible) { ?>
<div class="ewPager">
<div class="ewNumericPage"><ul class="pagination">
	<?php if ($verifikasi_list->Pager->FirstButton->Enabled) { ?>
	<li><a href="<?php echo $verifikasi_list->PageUrl() ?>start=<?php echo $verifikasi_list->Pager->FirstButton->Start ?>"><?php echo $Language->Phrase("PagerFirst") ?></a></li>
	<?php } ?>
	<?php if ($verifikasi_list->Pager->PrevButton->Enabled) { ?>
	<li><a href="<?php echo $verifikasi_list->PageUrl() ?>start=<?php echo $verifikasi_list->Pager->PrevButton->Start ?>"><?php echo $Language->Phrase("PagerPrevious") ?></a></li>
	<?php } ?>
	<?php foreach ($verifikasi_list->Pager->Items as $PagerItem) { ?>
		<li<?php if (!$PagerItem->Enabled) { echo " class=\" active\""; } ?>><a href="<?php if ($PagerItem->Enabled) { echo $verifikasi_list->PageUrl() . "start=" . $PagerItem->Start; } else { echo "#"; } ?>"><?php echo $PagerItem->Text ?></a></li>
	<?php } ?>
	<?php if ($verifikasi_list->Pager->NextButton->Enabled) { ?>
	<li><a href="<?php echo $verifikasi_list->PageUrl() ?>start=<?php echo $verifikasi_list->Pager->NextButton->Start ?>"><?php echo $Language->Phrase("PagerNext") ?></a></li>
	<?php } ?>
	<?php if ($verifikasi_list->Pager->LastButton->Enabled) { ?>
	<li><a href="<?php echo $verifikasi_list->PageUrl() ?>start=<?php echo $verifikasi_list->Pager->LastButton->Start ?>"><?php echo $Language->Phrase("PagerLast") ?></a></li>
	<?php } ?>
</ul></div>
</div>
<?php } ?>
<?php if ($verifikasi_list->Pager->RecordCount > 0) { ?>
<div class="ewPager ewRec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $verifikasi_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $verifikasi_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $verifikasi_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ewListOtherOptions">
<?php
	foreach ($verifikasi_list->OtherOptions as &$option)
		$option->Render("body");
?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fverifikasilist" id="fverifikasilist" class="form-inline ewForm ewListForm" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($verifikasi_list->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $verifikasi_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="verifikasi">
<div id="gmp_verifikasi" class="<?php if (ew_IsResponsiveLayout()) { ?>table-responsive <?php } ?>ewGridMiddlePanel">
<?php if ($verifikasi_list->TotalRecs > 0 || $verifikasi->CurrentAction == "gridedit") { ?>
<table id="tbl_verifikasilist" class="table ewTable">
<thead>
	<tr class="ewTableHeader">
<?php

// Header row
$verifikasi_list->RowType = EW_ROWTYPE_HEADER;

// Render list options
$verifikasi_list->RenderListOptions();

// Render list options (header, left)
$verifikasi_list->ListOptions->Render("header", "left");
?>
<?php if ($verifikasi->ver_id->Visible) { // ver_id ?>
	<?php if ($verifikasi->SortUrl($verifikasi->ver_id) == "") { ?>
		<th data-name="ver_id" class="<?php echo $verifikasi->ver_id->HeaderCellClass() ?>"><div id="elh_verifikasi_ver_id" class="verifikasi_ver_id"><div class="ewTableHeaderCaption"><?php echo $verifikasi->ver_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ver_id" class="<?php echo $verifikasi->ver_id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $verifikasi->SortUrl($verifikasi->ver_id) ?>',1);"><div id="elh_verifikasi_ver_id" class="verifikasi_ver_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $verifikasi->ver_id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($verifikasi->ver_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($verifikasi->ver_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($verifikasi->qc_id->Visible) { // qc_id ?>
	<?php if ($verifikasi->SortUrl($verifikasi->qc_id) == "") { ?>
		<th data-name="qc_id" class="<?php echo $verifikasi->qc_id->HeaderCellClass() ?>"><div id="elh_verifikasi_qc_id" class="verifikasi_qc_id"><div class="ewTableHeaderCaption"><?php echo $verifikasi->qc_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="qc_id" class="<?php echo $verifikasi->qc_id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $verifikasi->SortUrl($verifikasi->qc_id) ?>',1);"><div id="elh_verifikasi_qc_id" class="verifikasi_qc_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $verifikasi->qc_id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($verifikasi->qc_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($verifikasi->qc_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($verifikasi->datang_id->Visible) { // datang_id ?>
	<?php if ($verifikasi->SortUrl($verifikasi->datang_id) == "") { ?>
		<th data-name="datang_id" class="<?php echo $verifikasi->datang_id->HeaderCellClass() ?>"><div id="elh_verifikasi_datang_id" class="verifikasi_datang_id"><div class="ewTableHeaderCaption"><?php echo $verifikasi->datang_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datang_id" class="<?php echo $verifikasi->datang_id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $verifikasi->SortUrl($verifikasi->datang_id) ?>',1);"><div id="elh_verifikasi_datang_id" class="verifikasi_datang_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $verifikasi->datang_id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($verifikasi->datang_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($verifikasi->datang_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($verifikasi->ver_tgl->Visible) { // ver_tgl ?>
	<?php if ($verifikasi->SortUrl($verifikasi->ver_tgl) == "") { ?>
		<th data-name="ver_tgl" class="<?php echo $verifikasi->ver_tgl->HeaderCellClass() ?>"><div id="elh_verifikasi_ver_tgl" class="verifikasi_ver_tgl"><div class="ewTableHeaderCaption"><?php echo $verifikasi->ver_tgl->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ver_tgl" class="<?php echo $verifikasi->ver_tgl->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $verifikasi->SortUrl($verifikasi->ver_tgl) ?>',1);"><div id="elh_verifikasi_ver_tgl" class="verifikasi_ver_tgl">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $verifikasi->ver_tgl->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($verifikasi->ver_tgl->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($verifikasi->ver_tgl->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($verifikasi->ver_hasil_id->Visible) { // ver_hasil_id ?>
	<?php if ($verifikasi->SortUrl($verifikasi->ver_hasil_id) == "") { ?>
		<th data-name="ver_hasil_id" class="<?php echo $verifikasi->ver_hasil_id->HeaderCellClass() ?>"><div id="elh_verifikasi_ver_hasil_id" class="verifikasi_ver_hasil_id"><div class="ewTableHeaderCaption"><?php echo $verifikasi->ver_hasil_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ver_hasil_id" class="<?php echo $verifikasi->ver_hasil_id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $verifikasi->SortUrl($verifikasi->ver_hasil_id) ?>',1);"><div id="elh_verifikasi_ver_hasil_id" class="verifikasi_ver_hasil_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $verifikasi->ver_hasil_id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($verifikasi->ver_hasil_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($verifikasi->ver_hasil_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($verifikasi->ver_foto->Visible) { // ver_foto ?>
	<?php if ($verifikasi->SortUrl($verifikasi->ver_foto) == "") { ?>
		<th data-name="ver_foto" class="<?php echo $verifikasi->ver_foto->HeaderCellClass() ?>"><div id="elh_verifikasi_ver_foto" class="verifikasi_ver_foto"><div class="ewTableHeaderCaption" style="width: 200px;"><?php echo $verifikasi->ver_foto->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ver_foto" class="<?php echo $verifikasi->ver_foto->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $verifikasi->SortUrl($verifikasi->ver_foto) ?>',1);"><div id="elh_verifikasi_ver_foto" class="verifikasi_ver_foto">
			<div class="ewTableHeaderBtn" style="width: 200px;"><span class="ewTableHeaderCaption"><?php echo $verifikasi->ver_foto->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($verifikasi->ver_foto->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($verifikasi->ver_foto->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($verifikasi->ver_catatan->Visible) { // ver_catatan ?>
	<?php if ($verifikasi->SortUrl($verifikasi->ver_catatan) == "") { ?>
		<th data-name="ver_catatan" class="<?php echo $verifikasi->ver_catatan->HeaderCellClass() ?>"><div id="elh_verifikasi_ver_catatan" class="verifikasi_ver_catatan"><div class="ewTableHeaderCaption"><?php echo $verifikasi->ver_catatan->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ver_catatan" class="<?php echo $verifikasi->ver_catatan->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $verifikasi->SortUrl($verifikasi->ver_catatan) ?>',1);"><div id="elh_verifikasi_ver_catatan" class="verifikasi_ver_catatan">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $verifikasi->ver_catatan->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($verifikasi->ver_catatan->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($verifikasi->ver_catatan->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$verifikasi_list->ListOptions->Render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($verifikasi->ExportAll && $verifikasi->Export <> "") {
	$verifikasi_list->StopRec = $verifikasi_list->TotalRecs;
} else {

	// Set the last record to display
	if ($verifikasi_list->TotalRecs > $verifikasi_list->StartRec + $verifikasi_list->DisplayRecs - 1)
		$verifikasi_list->StopRec = $verifikasi_list->StartRec + $verifikasi_list->DisplayRecs - 1;
	else
		$verifikasi_list->StopRec = $verifikasi_list->TotalRecs;
}
$verifikasi_list->RecCnt = $verifikasi_list->StartRec - 1;
if ($verifikasi_list->Recordset && !$verifikasi_list->Recordset->EOF) {
	$verifikasi_list->Recordset->MoveFirst();
	$bSelectLimit = $verifikasi_list->UseSelectLimit;
	if (!$bSelectLimit && $verifikasi_list->StartRec > 1)
		$verifikasi_list->Recordset->Move($verifikasi_list->StartRec - 1);
} elseif (!$verifikasi->AllowAddDeleteRow && $verifikasi_list->StopRec == 0) {
	$verifikasi_list->StopRec = $verifikasi->GridAddRowCount;
}

// Initialize aggregate
$verifikasi->RowType = EW_ROWTYPE_AGGREGATEINIT;
$verifikasi->ResetAttrs();
$verifikasi_list->RenderRow();
while ($verifikasi_list->RecCnt < $verifikasi_list->StopRec) {
	$verifikasi_list->RecCnt++;
	if (intval($verifikasi_list->RecCnt) >= intval($verifikasi_list->StartRec)) {
		$verifikasi_list->RowCnt++;

		// Set up key count
		$verifikasi_list->KeyCount = $verifikasi_list->RowIndex;

		// Init row class and style
		$verifikasi->ResetAttrs();
		$verifikasi->CssClass = "";
		if ($verifikasi->CurrentAction == "gridadd") {
		} else {
			$verifikasi_list->LoadRowValues($verifikasi_list->Recordset); // Load row values
		}
		$verifikasi->RowType = EW_ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$verifikasi->RowAttrs = array_merge($verifikasi->RowAttrs, array('data-rowindex'=>$verifikasi_list->RowCnt, 'id'=>'r' . $verifikasi_list->RowCnt . '_verifikasi', 'data-rowtype'=>$verifikasi->RowType));

		// Render row
		$verifikasi_list->RenderRow();

		// Render list options
		$verifikasi_list->RenderListOptions();
?>
	<tr<?php echo $verifikasi->RowAttributes() ?>>
<?php

// Render list options (body, left)
$verifikasi_list->ListOptions->Render("body", "left", $verifikasi_list->RowCnt);
?>
	<?php if ($verifikasi->ver_id->Visible) { // ver_id ?>
		<td data-name="ver_id"<?php echo $verifikasi->ver_id->CellAttributes() ?>>
<span id="el<?php echo $verifikasi_list->RowCnt ?>_verifikasi_ver_id" class="verifikasi_ver_id">
<span<?php echo $verifikasi->ver_id->ViewAttributes() ?>>
<?php echo $verifikasi->ver_id->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($verifikasi->qc_id->Visible) { // qc_id ?>
		<td data-name="qc_id"<?php echo $verifikasi->qc_id->CellAttributes() ?>>
<span id="el<?php echo $verifikasi_list->RowCnt ?>_verifikasi_qc_id" class="verifikasi_qc_id">
<span<?php echo $verifikasi->qc_id->ViewAttributes() ?>>
<?php echo $verifikasi->qc_id->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($verifikasi->datang_id->Visible) { // datang_id ?>
		<td data-name="datang_id"<?php echo $verifikasi->datang_id->CellAttributes() ?>>
<span id="el<?php echo $verifikasi_list->RowCnt ?>_verifikasi_datang_id" class="verifikasi_datang_id">
<span<?php echo $verifikasi->datang_id->ViewAttributes() ?>>
<?php echo $verifikasi->datang_id->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($verifikasi->ver_tgl->Visible) { // ver_tgl ?>
		<td data-name="ver_tgl"<?php echo $verifikasi->ver_tgl->CellAttributes() ?>>
<span id="el<?php echo $verifikasi_list->RowCnt ?>_verifikasi_ver_tgl" class="verifikasi_ver_tgl">
<span<?php echo $verifikasi->ver_tgl->ViewAttributes() ?>>
<?php echo $verifikasi->ver_tgl->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($verifikasi->ver_hasil_id->Visible) { // ver_hasil_id ?>
		<td data-name="ver_hasil_id"<?php echo $verifikasi->ver_hasil_id->CellAttributes() ?>>
<span id="el<?php echo $verifikasi_list->RowCnt ?>_verifikasi_ver_hasil_id" class="verifikasi_ver_hasil_id">
<span<?php echo $verifikasi->ver_hasil_id->ViewAttributes() ?>>
<?php echo $verifikasi->ver_hasil_id->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($verifikasi->ver_foto->Visible) { // ver_foto ?>
		<td data-name="ver_foto"<?php echo $verifikasi->ver_foto->CellAttributes() ?>>
<span id="el<?php echo $verifikasi_list->RowCnt ?>_verifikasi_ver_foto" class="verifikasi_ver_foto">
<span>
<?php echo ew_GetFileViewTag($verifikasi->ver_foto, $verifikasi->ver_foto->ListViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($verifikasi->ver_catatan->Visible) { // ver_catatan ?>
		<td data-name="ver_catatan"<?php echo $verifikasi->ver_catatan->CellAttributes() ?>>
<span id="el<?php echo $verifikasi_list->RowCnt ?>_verifikasi_ver_catatan" class="verifikasi_ver_catatan">
<span<?php echo $verifikasi->ver_catatan->ViewAttributes() ?>>
<?php echo $verifikasi->ver_catatan->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$verifikasi_list->ListOptions->Render("body", "right", $verifikasi_list->RowCnt);
?>
	</tr>
<?php
	}
	if ($verifikasi->CurrentAction <> "gridadd")
		$verifikasi_list->Recordset->MoveNext();
}
?>
</tbody>
</table>
<?php } ?>
<?php if ($verifikasi->CurrentAction == "") { ?>
<input type="hidden" name="a_list" id="a_list" value="">
<?php } ?>
</div>
</form>
<?php

// Close recordset
if ($verifikasi_list->Recordset)
	$verifikasi_list->Recordset->Close();
?>
<?php if ($verifikasi->Export == "") { ?>
<div class="box-footer ewGridLowerPanel">
<?php if ($verifikasi->CurrentAction <> "gridadd" && $verifikasi->CurrentAction <> "gridedit") { ?>
<form name="ewPagerForm" class="ewForm form-inline ewPagerForm" action="<?php echo ew_CurrentPage() ?>">
<?php if (!isset($verifikasi_list->Pager)) $verifikasi_list->Pager = new cNumericPager($verifikasi_list->StartRec, $verifikasi_list->DisplayRecs, $verifikasi_list->TotalRecs, $verifikasi_list->RecRange, $verifikasi_list->AutoHidePager) ?>
<?php if ($verifikasi_list->Pager->RecordCount > 0 && $verifikasi_list->Pager->Visible) { ?>
<div class="ewPager">
<div class="ewNumericPage"><ul class="pagination">
	<?php if ($verifikasi_list->Pager->FirstButton->Enabled) { ?>
	<li><a href="<?php echo $verifikasi_list->PageUrl() ?>start=<?php echo $verifikasi_list->Pager->FirstButton->Start ?>"><?php echo $Language->Phrase("PagerFirst") ?></a></li>
	<?php } ?>
	<?php if ($verifikasi_list->Pager->PrevButton->Enabled) { ?>
	<li><a href="<?php echo $verifikasi_list->PageUrl() ?>start=<?php echo $verifikasi_list->Pager->PrevButton->Start ?>"><?php echo $Language->Phrase("PagerPrevious") ?></a></li>
	<?php } ?>
	<?php foreach ($verifikasi_list->Pager->Items as $PagerItem) { ?>
		<li<?php if (!$PagerItem->Enabled) { echo " class=\" active\""; } ?>><a href="<?php if ($PagerItem->Enabled) { echo $verifikasi_list->PageUrl() . "start=" . $PagerItem->Start; } else { echo "#"; } ?>"><?php echo $PagerItem->Text ?></a></li>
	<?php } ?>
	<?php if ($verifikasi_list->Pager->NextButton->Enabled) { ?>
	<li><a href="<?php echo $verifikasi_list->PageUrl() ?>start=<?php echo $verifikasi_list->Pager->NextButton->Start ?>"><?php echo $Language->Phrase("PagerNext") ?></a></li>
	<?php } ?>
	<?php if ($verifikasi_list->Pager->LastButton->Enabled) { ?>
	<li><a href="<?php echo $verifikasi_list->PageUrl() ?>start=<?php echo $verifikasi_list->Pager->LastButton->Start ?>"><?php echo $Language->Phrase("PagerLast") ?></a></li>
	<?php } ?>
</ul></div>
</div>
<?php } ?>
<?php if ($verifikasi_list->Pager->RecordCount > 0) { ?>
<div class="ewPager ewRec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $verifikasi_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $verifikasi_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $verifikasi_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ewListOtherOptions">
<?php
	foreach ($verifikasi_list->OtherOptions as &$option)
		$option->Render("body", "bottom");
?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div>
<?php } ?>
<?php if ($verifikasi_list->TotalRecs == 0 && $verifikasi->CurrentAction == "") { // Show other options ?>
<div class="ewListOtherOptions">
<?php
	foreach ($verifikasi_list->OtherOptions as &$option) {
		$option->ButtonClass = "";
		$option->Render("body", "");
	}
?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php if ($verifikasi->Export == "") { ?>
<script type="text/javascript">
fverifikasilistsrch.FilterList = <?php echo $verifikasi_list->GetFilterList() ?>;
fverifikasilistsrch.Init();
fverifikasilist.Init();
</script>
<?php } ?>
<?php
$verifikasi_list->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<?php if ($verifikasi->Export == "") { ?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$verifikasi_list->Page_Terminate();
?>
