<?php
if (session_id() == "") session_start(); // Init session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg14.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql14.php") ?>
<?php include_once "phpfn14.php" ?>
<?php include_once "verifikasiinfo.php" ?>
<?php include_once "employeesinfo.php" ?>
<?php include_once "userfn14.php" ?>
<?php

//
// Page class
//

$verifikasi_edit = NULL; // Initialize page object first

class cverifikasi_edit extends cverifikasi {

	// Page ID
	var $PageID = 'edit';

	// Project ID
	var $ProjectID = '{CC60B42B-604B-412A-B014-2315920AF6AA}';

	// Table name
	var $TableName = 'verifikasi';

	// Page object name
	var $PageObjName = 'verifikasi_edit';

	// Page headings
	var $Heading = '';
	var $Subheading = '';

	// Page heading
	function PageHeading() {
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->TableCaption();
		return "";
	}

	// Page subheading
	function PageSubheading() {
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->Phrase($this->PageID);
		return "";
	}

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (verifikasi)
		if (!isset($GLOBALS["verifikasi"]) || get_class($GLOBALS["verifikasi"]) == "cverifikasi") {
			$GLOBALS["verifikasi"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["verifikasi"];
		}

		// Table object (employees)
		if (!isset($GLOBALS['employees'])) $GLOBALS['employees'] = new cemployees();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'edit', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'verifikasi', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"]))
			$GLOBALS["gTimer"] = new cTimer();

		// Debug message
		ew_LoadDebugMsg();

		// Open connection
		if (!isset($conn))
			$conn = ew_Connect($this->DBID);

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new cemployees();
			$UserTableConn = Conn($UserTable->DBID);
		}
	}

	//
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Is modal
		$this->IsModal = (@$_GET["modal"] == "1" || @$_POST["modal"] == "1");

		// User profile
		$UserProfile = new cUserProfile();

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanEdit()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			if ($Security->CanList())
				$this->Page_Terminate(ew_GetUrl("verifikasilist.php"));
			else
				$this->Page_Terminate(ew_GetUrl("login.php"));
		}

		// NOTE: Security object may be needed in other part of the script, skip set to Nothing
		// 
		// Security = null;
		// 
		// Create form object

		$objForm = new cFormObj();
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action
		$this->qc_id->SetVisibility();
		$this->datang_id->SetVisibility();
		$this->ver_tgl->SetVisibility();
		$this->ver_hasil_id->SetVisibility();
		$this->ver_foto->SetVisibility();
		$this->ver_catatan->SetVisibility();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $verifikasi;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($verifikasi);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		// Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = ew_GetPageName($url);
				if ($pageName != $this->GetListUrl()) { // Not List page
					$row["caption"] = $this->GetModalCaption($pageName);
					if ($pageName == "verifikasiview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				header("Content-Type: application/json; charset=utf-8");
				echo ew_ConvertToUtf8(ew_ArrayToJson(array($row)));
			} else {
				ew_SaveDebugMsg();
				header("Location: " . $url);
			}
		}
		exit();
	}
	var $FormClassName = "form-horizontal ewForm ewEditForm";
	var $IsModal = FALSE;
	var $IsMobileOrModal = FALSE;
	var $DbMasterFilter;
	var $DbDetailFilter;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError, $gbSkipHeaderFooter;

		// Check modal
		if ($this->IsModal)
			$gbSkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = ew_IsMobile() || $this->IsModal;
		$this->FormClassName = "ewForm ewEditForm form-horizontal";
		$sReturnUrl = "";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (@$_POST["a_edit"] <> "") {
			$this->CurrentAction = $_POST["a_edit"]; // Get action code
			if ($this->CurrentAction <> "I") // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($objForm->HasValue("x_ver_id")) {
				$this->ver_id->setFormValue($objForm->GetValue("x_ver_id"));
			}
		} else {
			$this->CurrentAction = "I"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (isset($_GET["ver_id"])) {
				$this->ver_id->setQueryStringValue($_GET["ver_id"]);
				$loadByQuery = TRUE;
			} else {
				$this->ver_id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->LoadRow();

		// Process form if post back
		if ($postBack) {
			$this->LoadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->ValidateForm()) {
				$this->CurrentAction = ""; // Form error, reset action
				$this->setFailureMessage($gsFormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->RestoreFormValues();
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "I": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "") $this->setFailureMessage($Language->Phrase("NoRecord")); // No record found
					$this->Page_Terminate("verifikasilist.php"); // No matching record, return to list
				}
				break;
			Case "U": // Update
				$sReturnUrl = $this->getReturnUrl();
				if (ew_GetPageName($sReturnUrl) == "verifikasilist.php")
					$sReturnUrl = $this->AddMasterUrl($sReturnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->EditRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->Phrase("UpdateSuccess")); // Update success
					$this->Page_Terminate($sReturnUrl); // Return to caller
				} elseif ($this->getFailureMessage() == $Language->Phrase("NoRecord")) {
					$this->Page_Terminate($sReturnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->RestoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->SetupBreadcrumb();

		// Render the record
		$this->RowType = EW_ROWTYPE_EDIT; // Render as Edit
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Set up starting record parameters
	function SetupStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	function GetUploadFiles() {
		global $objForm, $Language;

		// Get upload data
		$this->ver_foto->Upload->Index = $objForm->Index;
		$this->ver_foto->Upload->UploadFile();
		$this->ver_foto->CurrentValue = $this->ver_foto->Upload->FileName;
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm;
		$this->GetUploadFiles(); // Get upload files
		if (!$this->qc_id->FldIsDetailKey) {
			$this->qc_id->setFormValue($objForm->GetValue("x_qc_id"));
		}
		if (!$this->datang_id->FldIsDetailKey) {
			$this->datang_id->setFormValue($objForm->GetValue("x_datang_id"));
		}
		if (!$this->ver_tgl->FldIsDetailKey) {
			$this->ver_tgl->setFormValue($objForm->GetValue("x_ver_tgl"));
			$this->ver_tgl->CurrentValue = ew_UnFormatDateTime($this->ver_tgl->CurrentValue, 0);
		}
		if (!$this->ver_hasil_id->FldIsDetailKey) {
			$this->ver_hasil_id->setFormValue($objForm->GetValue("x_ver_hasil_id"));
		}
		if (!$this->ver_catatan->FldIsDetailKey) {
			$this->ver_catatan->setFormValue($objForm->GetValue("x_ver_catatan"));
		}
		if (!$this->ver_id->FldIsDetailKey)
			$this->ver_id->setFormValue($objForm->GetValue("x_ver_id"));
	}

	// Restore form values
	function RestoreFormValues() {
		global $objForm;
		$this->ver_id->CurrentValue = $this->ver_id->FormValue;
		$this->qc_id->CurrentValue = $this->qc_id->FormValue;
		$this->datang_id->CurrentValue = $this->datang_id->FormValue;
		$this->ver_tgl->CurrentValue = $this->ver_tgl->FormValue;
		$this->ver_tgl->CurrentValue = ew_UnFormatDateTime($this->ver_tgl->CurrentValue, 0);
		$this->ver_hasil_id->CurrentValue = $this->ver_hasil_id->FormValue;
		$this->ver_catatan->CurrentValue = $this->ver_catatan->FormValue;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues($rs = NULL) {
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->NewRow(); 

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->ver_id->setDbValue($row['ver_id']);
		$this->qc_id->setDbValue($row['qc_id']);
		$this->datang_id->setDbValue($row['datang_id']);
		$this->ver_tgl->setDbValue($row['ver_tgl']);
		$this->ver_hasil_id->setDbValue($row['ver_hasil_id']);
		$this->ver_foto->Upload->DbValue = $row['ver_foto'];
		$this->ver_foto->setDbValue($this->ver_foto->Upload->DbValue);
		$this->ver_catatan->setDbValue($row['ver_catatan']);
	}

	// Return a row with default values
	function NewRow() {
		$row = array();
		$row['ver_id'] = NULL;
		$row['qc_id'] = NULL;
		$row['datang_id'] = NULL;
		$row['ver_tgl'] = NULL;
		$row['ver_hasil_id'] = NULL;
		$row['ver_foto'] = NULL;
		$row['ver_catatan'] = NULL;
		return $row;
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->ver_id->DbValue = $row['ver_id'];
		$this->qc_id->DbValue = $row['qc_id'];
		$this->datang_id->DbValue = $row['datang_id'];
		$this->ver_tgl->DbValue = $row['ver_tgl'];
		$this->ver_hasil_id->DbValue = $row['ver_hasil_id'];
		$this->ver_foto->Upload->DbValue = $row['ver_foto'];
		$this->ver_catatan->DbValue = $row['ver_catatan'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("ver_id")) <> "")
			$this->ver_id->CurrentValue = $this->getKey("ver_id"); // ver_id
		else
			$bValidKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
		}
		$this->LoadRowValues($this->OldRecordset); // Load row values
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// ver_id
		// qc_id
		// datang_id
		// ver_tgl
		// ver_hasil_id
		// ver_foto
		// ver_catatan

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// ver_id
		$this->ver_id->ViewValue = $this->ver_id->CurrentValue;
		$this->ver_id->ViewCustomAttributes = "";

		// qc_id
		if (strval($this->qc_id->CurrentValue) <> "") {
			$sFilterWrk = "`qc_id`" . ew_SearchString("=", $this->qc_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `qc_id`, `qc_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `qc`";
		$sWhereWrk = "";
		$this->qc_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->qc_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `qc_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->qc_id->ViewValue = $this->qc_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->qc_id->ViewValue = $this->qc_id->CurrentValue;
			}
		} else {
			$this->qc_id->ViewValue = NULL;
		}
		$this->qc_id->ViewCustomAttributes = "";

		// datang_id
		if (strval($this->datang_id->CurrentValue) <> "") {
			$sFilterWrk = "`datang_id`" . ew_SearchString("=", $this->datang_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `datang_id`, `datang_id` AS `DispFld`, `datang_jumlah` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kedatangan`";
		$sWhereWrk = "";
		$this->datang_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->datang_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `datang_id` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = $rswrk->fields('Disp2Fld');
				$this->datang_id->ViewValue = $this->datang_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->datang_id->ViewValue = $this->datang_id->CurrentValue;
			}
		} else {
			$this->datang_id->ViewValue = NULL;
		}
		$this->datang_id->ViewCustomAttributes = "";

		// ver_tgl
		$this->ver_tgl->ViewValue = $this->ver_tgl->CurrentValue;
		$this->ver_tgl->ViewValue = ew_FormatDateTime($this->ver_tgl->ViewValue, 0);
		$this->ver_tgl->ViewCustomAttributes = "";

		// ver_hasil_id
		if (strval($this->ver_hasil_id->CurrentValue) <> "") {
			$sFilterWrk = "`vh_id`" . ew_SearchString("=", $this->ver_hasil_id->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `vh_id`, `vh_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `verifikasi_hasil`";
		$sWhereWrk = "";
		$this->ver_hasil_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->ver_hasil_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `vh_id` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->ver_hasil_id->ViewValue = $this->ver_hasil_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->ver_hasil_id->ViewValue = $this->ver_hasil_id->CurrentValue;
			}
		} else {
			$this->ver_hasil_id->ViewValue = NULL;
		}
		$this->ver_hasil_id->ViewCustomAttributes = "";

		// ver_foto
		if (!ew_Empty($this->ver_foto->Upload->DbValue)) {
			$this->ver_foto->ImageWidth = 200;
			$this->ver_foto->ImageHeight = 100;
			$this->ver_foto->ImageAlt = $this->ver_foto->FldAlt();
			$this->ver_foto->ViewValue = $this->ver_foto->Upload->DbValue;
		} else {
			$this->ver_foto->ViewValue = "";
		}
		$this->ver_foto->ViewCustomAttributes = "";

		// ver_catatan
		$this->ver_catatan->ViewValue = $this->ver_catatan->CurrentValue;
		$this->ver_catatan->ViewCustomAttributes = "";

			// qc_id
			$this->qc_id->LinkCustomAttributes = "";
			$this->qc_id->HrefValue = "";
			$this->qc_id->TooltipValue = "";

			// datang_id
			$this->datang_id->LinkCustomAttributes = "";
			$this->datang_id->HrefValue = "";
			$this->datang_id->TooltipValue = "";

			// ver_tgl
			$this->ver_tgl->LinkCustomAttributes = "";
			$this->ver_tgl->HrefValue = "";
			$this->ver_tgl->TooltipValue = "";

			// ver_hasil_id
			$this->ver_hasil_id->LinkCustomAttributes = "";
			$this->ver_hasil_id->HrefValue = "";
			$this->ver_hasil_id->TooltipValue = "";

			// ver_foto
			$this->ver_foto->LinkCustomAttributes = "";
			if (!ew_Empty($this->ver_foto->Upload->DbValue)) {
				$this->ver_foto->HrefValue = "%u"; // Add prefix/suffix
				$this->ver_foto->LinkAttrs["target"] = ""; // Add target
				if ($this->Export <> "") $this->ver_foto->HrefValue = ew_FullUrl($this->ver_foto->HrefValue, "href");
			} else {
				$this->ver_foto->HrefValue = "";
			}
			$this->ver_foto->HrefValue2 = $this->ver_foto->UploadPath . $this->ver_foto->Upload->DbValue;
			$this->ver_foto->TooltipValue = "";
			if ($this->ver_foto->UseColorbox) {
				if (ew_Empty($this->ver_foto->TooltipValue))
					$this->ver_foto->LinkAttrs["title"] = $Language->Phrase("ViewImageGallery");
				$this->ver_foto->LinkAttrs["data-rel"] = "verifikasi_x_ver_foto";
				ew_AppendClass($this->ver_foto->LinkAttrs["class"], "ewLightbox");
			}

			// ver_catatan
			$this->ver_catatan->LinkCustomAttributes = "";
			$this->ver_catatan->HrefValue = "";
			$this->ver_catatan->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_EDIT) { // Edit row

			// qc_id
			$this->qc_id->EditAttrs["class"] = "form-control";
			$this->qc_id->EditCustomAttributes = "";
			if (trim(strval($this->qc_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`qc_id`" . ew_SearchString("=", $this->qc_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `qc_id`, `qc_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `qc`";
			$sWhereWrk = "";
			$this->qc_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->qc_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `qc_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->qc_id->EditValue = $arwrk;

			// datang_id
			$this->datang_id->EditAttrs["class"] = "form-control";
			$this->datang_id->EditCustomAttributes = "";
			if (trim(strval($this->datang_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`datang_id`" . ew_SearchString("=", $this->datang_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `datang_id`, `datang_id` AS `DispFld`, `datang_jumlah` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `kedatangan`";
			$sWhereWrk = "";
			$this->datang_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->datang_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `datang_id` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->datang_id->EditValue = $arwrk;

			// ver_tgl
			$this->ver_tgl->EditAttrs["class"] = "form-control";
			$this->ver_tgl->EditCustomAttributes = "";
			$this->ver_tgl->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->ver_tgl->CurrentValue, 8));
			$this->ver_tgl->PlaceHolder = ew_RemoveHtml($this->ver_tgl->FldCaption());

			// ver_hasil_id
			$this->ver_hasil_id->EditAttrs["class"] = "form-control";
			$this->ver_hasil_id->EditCustomAttributes = "";
			if (trim(strval($this->ver_hasil_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`vh_id`" . ew_SearchString("=", $this->ver_hasil_id->CurrentValue, EW_DATATYPE_STRING, "");
			}
			$sSqlWrk = "SELECT `vh_id`, `vh_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `verifikasi_hasil`";
			$sWhereWrk = "";
			$this->ver_hasil_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->ver_hasil_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `vh_id` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->ver_hasil_id->EditValue = $arwrk;

			// ver_foto
			$this->ver_foto->EditAttrs["class"] = "form-control";
			$this->ver_foto->EditCustomAttributes = "";
			if (!ew_Empty($this->ver_foto->Upload->DbValue)) {
				$this->ver_foto->ImageWidth = 200;
				$this->ver_foto->ImageHeight = 100;
				$this->ver_foto->ImageAlt = $this->ver_foto->FldAlt();
				$this->ver_foto->EditValue = $this->ver_foto->Upload->DbValue;
			} else {
				$this->ver_foto->EditValue = "";
			}
			if (!ew_Empty($this->ver_foto->CurrentValue))
					$this->ver_foto->Upload->FileName = $this->ver_foto->CurrentValue;
			if ($this->CurrentAction == "I" && !$this->EventCancelled) ew_RenderUploadField($this->ver_foto);

			// ver_catatan
			$this->ver_catatan->EditAttrs["class"] = "form-control";
			$this->ver_catatan->EditCustomAttributes = "";
			$this->ver_catatan->EditValue = ew_HtmlEncode($this->ver_catatan->CurrentValue);
			$this->ver_catatan->PlaceHolder = ew_RemoveHtml($this->ver_catatan->FldCaption());

			// Edit refer script
			// qc_id

			$this->qc_id->LinkCustomAttributes = "";
			$this->qc_id->HrefValue = "";

			// datang_id
			$this->datang_id->LinkCustomAttributes = "";
			$this->datang_id->HrefValue = "";

			// ver_tgl
			$this->ver_tgl->LinkCustomAttributes = "";
			$this->ver_tgl->HrefValue = "";

			// ver_hasil_id
			$this->ver_hasil_id->LinkCustomAttributes = "";
			$this->ver_hasil_id->HrefValue = "";

			// ver_foto
			$this->ver_foto->LinkCustomAttributes = "";
			if (!ew_Empty($this->ver_foto->Upload->DbValue)) {
				$this->ver_foto->HrefValue = "%u"; // Add prefix/suffix
				$this->ver_foto->LinkAttrs["target"] = ""; // Add target
				if ($this->Export <> "") $this->ver_foto->HrefValue = ew_FullUrl($this->ver_foto->HrefValue, "href");
			} else {
				$this->ver_foto->HrefValue = "";
			}
			$this->ver_foto->HrefValue2 = $this->ver_foto->UploadPath . $this->ver_foto->Upload->DbValue;

			// ver_catatan
			$this->ver_catatan->LinkCustomAttributes = "";
			$this->ver_catatan->HrefValue = "";
		}
		if ($this->RowType == EW_ROWTYPE_ADD || $this->RowType == EW_ROWTYPE_EDIT || $this->RowType == EW_ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->SetupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $Language, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return ($gsFormError == "");
		if (!$this->qc_id->FldIsDetailKey && !is_null($this->qc_id->FormValue) && $this->qc_id->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->qc_id->FldCaption(), $this->qc_id->ReqErrMsg));
		}
		if (!$this->datang_id->FldIsDetailKey && !is_null($this->datang_id->FormValue) && $this->datang_id->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->datang_id->FldCaption(), $this->datang_id->ReqErrMsg));
		}
		if (!$this->ver_tgl->FldIsDetailKey && !is_null($this->ver_tgl->FormValue) && $this->ver_tgl->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->ver_tgl->FldCaption(), $this->ver_tgl->ReqErrMsg));
		}
		if (!ew_CheckDateDef($this->ver_tgl->FormValue)) {
			ew_AddMessage($gsFormError, $this->ver_tgl->FldErrMsg());
		}
		if (!$this->ver_hasil_id->FldIsDetailKey && !is_null($this->ver_hasil_id->FormValue) && $this->ver_hasil_id->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->ver_hasil_id->FldCaption(), $this->ver_hasil_id->ReqErrMsg));
		}
		if ($this->ver_foto->Upload->FileName == "" && !$this->ver_foto->Upload->KeepFile) {
			ew_AddMessage($gsFormError, str_replace("%s", $this->ver_foto->FldCaption(), $this->ver_foto->ReqErrMsg));
		}
		if (!$this->ver_catatan->FldIsDetailKey && !is_null($this->ver_catatan->FormValue) && $this->ver_catatan->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->ver_catatan->FldCaption(), $this->ver_catatan->ReqErrMsg));
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsFormError, $sFormCustomError);
		}
		return $ValidateForm;
	}

	// Update record based on key values
	function EditRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();
		$sFilter = $this->ApplyUserIDFilters($sFilter);
		$conn = &$this->Connection();
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
		$rs = $conn->Execute($sSql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->Phrase("NoRecord")); // Set no record message
			$EditRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->LoadDbValues($rsold);
			$rsnew = array();

			// qc_id
			$this->qc_id->SetDbValueDef($rsnew, $this->qc_id->CurrentValue, NULL, $this->qc_id->ReadOnly);

			// datang_id
			$this->datang_id->SetDbValueDef($rsnew, $this->datang_id->CurrentValue, NULL, $this->datang_id->ReadOnly);

			// ver_tgl
			$this->ver_tgl->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->ver_tgl->CurrentValue, 0), NULL, $this->ver_tgl->ReadOnly);

			// ver_hasil_id
			$this->ver_hasil_id->SetDbValueDef($rsnew, $this->ver_hasil_id->CurrentValue, NULL, $this->ver_hasil_id->ReadOnly);

			// ver_foto
			if ($this->ver_foto->Visible && !$this->ver_foto->ReadOnly && !$this->ver_foto->Upload->KeepFile) {
				$this->ver_foto->Upload->DbValue = $rsold['ver_foto']; // Get original value
				if ($this->ver_foto->Upload->FileName == "") {
					$rsnew['ver_foto'] = NULL;
				} else {
					$rsnew['ver_foto'] = $this->ver_foto->Upload->FileName;
				}
				$this->ver_foto->ImageWidth = EW_THUMBNAIL_DEFAULT_WIDTH; // Resize width
				$this->ver_foto->ImageHeight = EW_THUMBNAIL_DEFAULT_HEIGHT; // Resize height
			}

			// ver_catatan
			$this->ver_catatan->SetDbValueDef($rsnew, $this->ver_catatan->CurrentValue, NULL, $this->ver_catatan->ReadOnly);
			if ($this->ver_foto->Visible && !$this->ver_foto->Upload->KeepFile) {
				$OldFiles = ew_Empty($this->ver_foto->Upload->DbValue) ? array() : explode(EW_MULTIPLE_UPLOAD_SEPARATOR, strval($this->ver_foto->Upload->DbValue));
				if (!ew_Empty($this->ver_foto->Upload->FileName)) {
					$NewFiles = explode(EW_MULTIPLE_UPLOAD_SEPARATOR, strval($this->ver_foto->Upload->FileName));
					$NewFileCount = count($NewFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						$fldvar = ($this->ver_foto->Upload->Index < 0) ? $this->ver_foto->FldVar : substr($this->ver_foto->FldVar, 0, 1) . $this->ver_foto->Upload->Index . substr($this->ver_foto->FldVar, 1);
						if ($NewFiles[$i] <> "") {
							$file = $NewFiles[$i];
							if (file_exists(ew_UploadTempPath($fldvar, $this->ver_foto->TblVar) . $file)) {
								$OldFileFound = FALSE;
								$OldFileCount = count($OldFiles);
								for ($j = 0; $j < $OldFileCount; $j++) {
									$file1 = $OldFiles[$j];
									if ($file1 == $file) { // Old file found, no need to delete anymore
										unset($OldFiles[$j]);
										$OldFileFound = TRUE;
										break;
									}
								}
								if ($OldFileFound) // No need to check if file exists further
									continue;
								$file1 = ew_UploadFileNameEx($this->ver_foto->PhysicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(ew_UploadTempPath($fldvar, $this->ver_foto->TblVar) . $file1) || file_exists($this->ver_foto->PhysicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = ew_UniqueFilename($this->ver_foto->PhysicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(ew_UploadTempPath($fldvar, $this->ver_foto->TblVar) . $file, ew_UploadTempPath($fldvar, $this->ver_foto->TblVar) . $file1);
									$NewFiles[$i] = $file1;
								}
							}
						}
					}
					$this->ver_foto->Upload->DbValue = empty($OldFiles) ? "" : implode(EW_MULTIPLE_UPLOAD_SEPARATOR, $OldFiles);
					$this->ver_foto->Upload->FileName = implode(EW_MULTIPLE_UPLOAD_SEPARATOR, $NewFiles);
					$this->ver_foto->SetDbValueDef($rsnew, $this->ver_foto->Upload->FileName, NULL, $this->ver_foto->ReadOnly);
				}
			}

			// Call Row Updating event
			$bUpdateRow = $this->Row_Updating($rsold, $rsnew);
			if ($bUpdateRow) {
				$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
				if (count($rsnew) > 0)
					$EditRow = $this->Update($rsnew, "", $rsold);
				else
					$EditRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($EditRow) {
					if ($this->ver_foto->Visible && !$this->ver_foto->Upload->KeepFile) {
						$OldFiles = ew_Empty($this->ver_foto->Upload->DbValue) ? array() : explode(EW_MULTIPLE_UPLOAD_SEPARATOR, strval($this->ver_foto->Upload->DbValue));
						if (!ew_Empty($this->ver_foto->Upload->FileName)) {
							$NewFiles = explode(EW_MULTIPLE_UPLOAD_SEPARATOR, $this->ver_foto->Upload->FileName);
							$NewFiles2 = explode(EW_MULTIPLE_UPLOAD_SEPARATOR, $rsnew['ver_foto']);
							$NewFileCount = count($NewFiles);
							for ($i = 0; $i < $NewFileCount; $i++) {
								$fldvar = ($this->ver_foto->Upload->Index < 0) ? $this->ver_foto->FldVar : substr($this->ver_foto->FldVar, 0, 1) . $this->ver_foto->Upload->Index . substr($this->ver_foto->FldVar, 1);
								if ($NewFiles[$i] <> "") {
									$file = ew_UploadTempPath($fldvar, $this->ver_foto->TblVar) . $NewFiles[$i];
									if (file_exists($file)) {
										if (@$NewFiles2[$i] <> "") // Use correct file name
											$NewFiles[$i] = $NewFiles2[$i];
										if (!$this->ver_foto->Upload->ResizeAndSaveToFile($this->ver_foto->ImageWidth, $this->ver_foto->ImageHeight, EW_THUMBNAIL_DEFAULT_QUALITY, $NewFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->Phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$NewFiles = array();
						}
						$OldFileCount = count($OldFiles);
						for ($i = 0; $i < $OldFileCount; $i++) {
							if ($OldFiles[$i] <> "" && !in_array($OldFiles[$i], $NewFiles))
								@unlink($this->ver_foto->OldPhysicalUploadPath() . $OldFiles[$i]);
						}
					}
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->Phrase("UpdateCancelled"));
				}
				$EditRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($EditRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->Close();

		// ver_foto
		ew_CleanUploadTempPath($this->ver_foto, $this->ver_foto->Upload->Index);
		return $EditRow;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$Breadcrumb->Add("list", $this->TableVar, $this->AddMasterUrl("verifikasilist.php"), "", $this->TableVar, TRUE);
		$PageId = "edit";
		$Breadcrumb->Add("edit", $PageId, $url);
	}

	// Setup lookup filters of a field
	function SetupLookupFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		case "x_qc_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `qc_id` AS `LinkFld`, `qc_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `qc`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`qc_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->qc_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `qc_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_datang_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `datang_id` AS `LinkFld`, `datang_id` AS `DispFld`, `datang_jumlah` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kedatangan`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`datang_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->datang_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `datang_id` DESC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_ver_hasil_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `vh_id` AS `LinkFld`, `vh_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `verifikasi_hasil`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`vh_id` IN ({filter_value})', "t0" => "200", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->ver_hasil_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `vh_id` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		}
	}

	// Setup AutoSuggest filters of a field
	function SetupAutoSuggestFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($verifikasi_edit)) $verifikasi_edit = new cverifikasi_edit();

// Page init
$verifikasi_edit->Page_Init();

// Page main
$verifikasi_edit->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$verifikasi_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "edit";
var CurrentForm = fverifikasiedit = new ew_Form("fverifikasiedit", "edit");

// Validate form
fverifikasiedit.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);
	if ($fobj.find("#a_confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.FormKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = $fobj.find("#a_list").val() == "gridinsert";
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
			elm = this.GetElements("x" + infix + "_qc_id");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $verifikasi->qc_id->FldCaption(), $verifikasi->qc_id->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_datang_id");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $verifikasi->datang_id->FldCaption(), $verifikasi->datang_id->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_ver_tgl");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $verifikasi->ver_tgl->FldCaption(), $verifikasi->ver_tgl->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_ver_tgl");
			if (elm && !ew_CheckDateDef(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($verifikasi->ver_tgl->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_ver_hasil_id");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $verifikasi->ver_hasil_id->FldCaption(), $verifikasi->ver_hasil_id->ReqErrMsg)) ?>");
			felm = this.GetElements("x" + infix + "_ver_foto");
			elm = this.GetElements("fn_x" + infix + "_ver_foto");
			if (felm && elm && !ew_HasValue(elm))
				return this.OnError(felm, "<?php echo ew_JsEncode2(str_replace("%s", $verifikasi->ver_foto->FldCaption(), $verifikasi->ver_foto->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_ver_catatan");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $verifikasi->ver_catatan->FldCaption(), $verifikasi->ver_catatan->ReqErrMsg)) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ewForms[val])
			if (!ewForms[val].Validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fverifikasiedit.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fverifikasiedit.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fverifikasiedit.Lists["x_qc_id"] = {"LinkField":"x_qc_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_qc_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"qc"};
fverifikasiedit.Lists["x_qc_id"].Data = "<?php echo $verifikasi_edit->qc_id->LookupFilterQuery(FALSE, "edit") ?>";
fverifikasiedit.Lists["x_datang_id"] = {"LinkField":"x_datang_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_datang_id","x_datang_jumlah","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kedatangan"};
fverifikasiedit.Lists["x_datang_id"].Data = "<?php echo $verifikasi_edit->datang_id->LookupFilterQuery(FALSE, "edit") ?>";
fverifikasiedit.Lists["x_ver_hasil_id"] = {"LinkField":"x_vh_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_vh_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"verifikasi_hasil"};
fverifikasiedit.Lists["x_ver_hasil_id"].Data = "<?php echo $verifikasi_edit->ver_hasil_id->LookupFilterQuery(FALSE, "edit") ?>";

// Form object for search
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php $verifikasi_edit->ShowPageHeader(); ?>
<?php
$verifikasi_edit->ShowMessage();
?>
<form name="fverifikasiedit" id="fverifikasiedit" class="<?php echo $verifikasi_edit->FormClassName ?>" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($verifikasi_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $verifikasi_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="verifikasi">
<input type="hidden" name="a_edit" id="a_edit" value="U">
<input type="hidden" name="modal" value="<?php echo intval($verifikasi_edit->IsModal) ?>">
<div class="ewEditDiv"><!-- page* -->
<?php if ($verifikasi->qc_id->Visible) { // qc_id ?>
	<div id="r_qc_id" class="form-group">
		<label id="elh_verifikasi_qc_id" for="x_qc_id" class="<?php echo $verifikasi_edit->LeftColumnClass ?>"><?php echo $verifikasi->qc_id->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $verifikasi_edit->RightColumnClass ?>"><div<?php echo $verifikasi->qc_id->CellAttributes() ?>>
<span id="el_verifikasi_qc_id">
<select data-table="verifikasi" data-field="x_qc_id" data-value-separator="<?php echo $verifikasi->qc_id->DisplayValueSeparatorAttribute() ?>" id="x_qc_id" name="x_qc_id"<?php echo $verifikasi->qc_id->EditAttributes() ?>>
<?php echo $verifikasi->qc_id->SelectOptionListHtml("x_qc_id") ?>
</select>
</span>
<?php echo $verifikasi->qc_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($verifikasi->datang_id->Visible) { // datang_id ?>
	<div id="r_datang_id" class="form-group">
		<label id="elh_verifikasi_datang_id" for="x_datang_id" class="<?php echo $verifikasi_edit->LeftColumnClass ?>"><?php echo $verifikasi->datang_id->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $verifikasi_edit->RightColumnClass ?>"><div<?php echo $verifikasi->datang_id->CellAttributes() ?>>
<span id="el_verifikasi_datang_id">
<select data-table="verifikasi" data-field="x_datang_id" data-value-separator="<?php echo $verifikasi->datang_id->DisplayValueSeparatorAttribute() ?>" id="x_datang_id" name="x_datang_id"<?php echo $verifikasi->datang_id->EditAttributes() ?>>
<?php echo $verifikasi->datang_id->SelectOptionListHtml("x_datang_id") ?>
</select>
</span>
<?php echo $verifikasi->datang_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($verifikasi->ver_tgl->Visible) { // ver_tgl ?>
	<div id="r_ver_tgl" class="form-group">
		<label id="elh_verifikasi_ver_tgl" for="x_ver_tgl" class="<?php echo $verifikasi_edit->LeftColumnClass ?>"><?php echo $verifikasi->ver_tgl->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $verifikasi_edit->RightColumnClass ?>"><div<?php echo $verifikasi->ver_tgl->CellAttributes() ?>>
<span id="el_verifikasi_ver_tgl">
<input type="text" data-table="verifikasi" data-field="x_ver_tgl" name="x_ver_tgl" id="x_ver_tgl" placeholder="<?php echo ew_HtmlEncode($verifikasi->ver_tgl->getPlaceHolder()) ?>" value="<?php echo $verifikasi->ver_tgl->EditValue ?>"<?php echo $verifikasi->ver_tgl->EditAttributes() ?>>
<?php if (!$verifikasi->ver_tgl->ReadOnly && !$verifikasi->ver_tgl->Disabled && !isset($verifikasi->ver_tgl->EditAttrs["readonly"]) && !isset($verifikasi->ver_tgl->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("fverifikasiedit", "x_ver_tgl", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $verifikasi->ver_tgl->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($verifikasi->ver_hasil_id->Visible) { // ver_hasil_id ?>
	<div id="r_ver_hasil_id" class="form-group">
		<label id="elh_verifikasi_ver_hasil_id" for="x_ver_hasil_id" class="<?php echo $verifikasi_edit->LeftColumnClass ?>"><?php echo $verifikasi->ver_hasil_id->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $verifikasi_edit->RightColumnClass ?>"><div<?php echo $verifikasi->ver_hasil_id->CellAttributes() ?>>
<span id="el_verifikasi_ver_hasil_id">
<select data-table="verifikasi" data-field="x_ver_hasil_id" data-value-separator="<?php echo $verifikasi->ver_hasil_id->DisplayValueSeparatorAttribute() ?>" id="x_ver_hasil_id" name="x_ver_hasil_id"<?php echo $verifikasi->ver_hasil_id->EditAttributes() ?>>
<?php echo $verifikasi->ver_hasil_id->SelectOptionListHtml("x_ver_hasil_id") ?>
</select>
</span>
<?php echo $verifikasi->ver_hasil_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($verifikasi->ver_foto->Visible) { // ver_foto ?>
	<div id="r_ver_foto" class="form-group">
		<label id="elh_verifikasi_ver_foto" class="<?php echo $verifikasi_edit->LeftColumnClass ?>"><?php echo $verifikasi->ver_foto->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $verifikasi_edit->RightColumnClass ?>"><div<?php echo $verifikasi->ver_foto->CellAttributes() ?>>
<span id="el_verifikasi_ver_foto">
<div id="fd_x_ver_foto">
<span title="<?php echo $verifikasi->ver_foto->FldTitle() ? $verifikasi->ver_foto->FldTitle() : $Language->Phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ewTooltip<?php if ($verifikasi->ver_foto->ReadOnly || $verifikasi->ver_foto->Disabled) echo " hide"; ?>" data-trigger="hover">
	<span><?php echo $Language->Phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="verifikasi" data-field="x_ver_foto" name="x_ver_foto" id="x_ver_foto" multiple="multiple"<?php echo $verifikasi->ver_foto->EditAttributes() ?>>
</span>
<input type="hidden" name="fn_x_ver_foto" id= "fn_x_ver_foto" value="<?php echo $verifikasi->ver_foto->Upload->FileName ?>">
<?php if (@$_POST["fa_x_ver_foto"] == "0") { ?>
<input type="hidden" name="fa_x_ver_foto" id= "fa_x_ver_foto" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_ver_foto" id= "fa_x_ver_foto" value="1">
<?php } ?>
<input type="hidden" name="fs_x_ver_foto" id= "fs_x_ver_foto" value="100">
<input type="hidden" name="fx_x_ver_foto" id= "fx_x_ver_foto" value="<?php echo $verifikasi->ver_foto->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_ver_foto" id= "fm_x_ver_foto" value="<?php echo $verifikasi->ver_foto->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_ver_foto" id= "fc_x_ver_foto" value="<?php echo $verifikasi->ver_foto->UploadMaxFileCount ?>">
</div>
<table id="ft_x_ver_foto" class="table table-condensed pull-left ewUploadTable"><tbody class="files"></tbody></table>
</span>
<?php echo $verifikasi->ver_foto->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($verifikasi->ver_catatan->Visible) { // ver_catatan ?>
	<div id="r_ver_catatan" class="form-group">
		<label id="elh_verifikasi_ver_catatan" for="x_ver_catatan" class="<?php echo $verifikasi_edit->LeftColumnClass ?>"><?php echo $verifikasi->ver_catatan->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $verifikasi_edit->RightColumnClass ?>"><div<?php echo $verifikasi->ver_catatan->CellAttributes() ?>>
<span id="el_verifikasi_ver_catatan">
<textarea data-table="verifikasi" data-field="x_ver_catatan" name="x_ver_catatan" id="x_ver_catatan" cols="35" rows="4" placeholder="<?php echo ew_HtmlEncode($verifikasi->ver_catatan->getPlaceHolder()) ?>"<?php echo $verifikasi->ver_catatan->EditAttributes() ?>><?php echo $verifikasi->ver_catatan->EditValue ?></textarea>
</span>
<?php echo $verifikasi->ver_catatan->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<input type="hidden" data-table="verifikasi" data-field="x_ver_id" name="x_ver_id" id="x_ver_id" value="<?php echo ew_HtmlEncode($verifikasi->ver_id->CurrentValue) ?>">
<?php if (!$verifikasi_edit->IsModal) { ?>
<div class="form-group"><!-- buttons .form-group -->
	<div class="<?php echo $verifikasi_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ewButton" name="btnAction" id="btnAction" type="submit"><?php echo $Language->Phrase("SaveBtn") ?></button>
<button class="btn btn-default ewButton" name="btnCancel" id="btnCancel" type="button" data-href="<?php echo $verifikasi_edit->getReturnUrl() ?>"><?php echo $Language->Phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<script type="text/javascript">
fverifikasiedit.Init();
</script>
<?php
$verifikasi_edit->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$verifikasi_edit->Page_Terminate();
?>
