<?php
if (session_id() == "") session_start(); // Init session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg14.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql14.php") ?>
<?php include_once "phpfn14.php" ?>
<?php include_once "tanam_bibitinfo.php" ?>
<?php include_once "employeesinfo.php" ?>
<?php include_once "userfn14.php" ?>
<?php

//
// Page class
//

$tanam_bibit_list = NULL; // Initialize page object first

class ctanam_bibit_list extends ctanam_bibit {

	// Page ID
	var $PageID = 'list';

	// Project ID
	var $ProjectID = '{CC60B42B-604B-412A-B014-2315920AF6AA}';

	// Table name
	var $TableName = 'tanam_bibit';

	// Page object name
	var $PageObjName = 'tanam_bibit_list';

	// Grid form hidden field names
	var $FormName = 'ftanam_bibitlist';
	var $FormActionName = 'k_action';
	var $FormKeyName = 'k_key';
	var $FormOldKeyName = 'k_oldkey';
	var $FormBlankRowName = 'k_blankrow';
	var $FormKeyCountName = 'key_count';

	// Page headings
	var $Heading = '';
	var $Subheading = '';

	// Page heading
	function PageHeading() {
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->TableCaption();
		return "";
	}

	// Page subheading
	function PageSubheading() {
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->Phrase($this->PageID);
		return "";
	}

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;
	var $ExportPdfUrl;

	// Custom export
	var $ExportExcelCustom = FALSE;
	var $ExportWordCustom = FALSE;
	var $ExportPdfCustom = FALSE;
	var $ExportEmailCustom = FALSE;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (tanam_bibit)
		if (!isset($GLOBALS["tanam_bibit"]) || get_class($GLOBALS["tanam_bibit"]) == "ctanam_bibit") {
			$GLOBALS["tanam_bibit"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["tanam_bibit"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->PageUrl() . "export=print";
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel";
		$this->ExportWordUrl = $this->PageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->PageUrl() . "export=html";
		$this->ExportXmlUrl = $this->PageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->PageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf";
		$this->AddUrl = "tanam_bibitadd.php";
		$this->InlineAddUrl = $this->PageUrl() . "a=add";
		$this->GridAddUrl = $this->PageUrl() . "a=gridadd";
		$this->GridEditUrl = $this->PageUrl() . "a=gridedit";
		$this->MultiDeleteUrl = "tanam_bibitdelete.php";
		$this->MultiUpdateUrl = "tanam_bibitupdate.php";

		// Table object (employees)
		if (!isset($GLOBALS['employees'])) $GLOBALS['employees'] = new cemployees();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'list', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'tanam_bibit', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"]))
			$GLOBALS["gTimer"] = new cTimer();

		// Debug message
		ew_LoadDebugMsg();

		// Open connection
		if (!isset($conn))
			$conn = ew_Connect($this->DBID);

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new cemployees();
			$UserTableConn = Conn($UserTable->DBID);
		}

		// List options
		$this->ListOptions = new cListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new cListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Other options
		$this->OtherOptions['addedit'] = new cListOptions();
		$this->OtherOptions['addedit']->Tag = "div";
		$this->OtherOptions['addedit']->TagClassName = "ewAddEditOption";
		$this->OtherOptions['detail'] = new cListOptions();
		$this->OtherOptions['detail']->Tag = "div";
		$this->OtherOptions['detail']->TagClassName = "ewDetailOption";
		$this->OtherOptions['action'] = new cListOptions();
		$this->OtherOptions['action']->Tag = "div";
		$this->OtherOptions['action']->TagClassName = "ewActionOption";

		// Filter options
		$this->FilterOptions = new cListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ewFilterOption ftanam_bibitlistsrch";

		// List actions
		$this->ListActions = new cListActions();
	}

	//
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// User profile
		$UserProfile = new cUserProfile();

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanList()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			$this->Page_Terminate(ew_GetUrl("index.php"));
		}

		// NOTE: Security object may be needed in other part of the script, skip set to Nothing
		// 
		// Security = null;
		// 
		// Get export parameters

		$custom = "";
		if (@$_GET["export"] <> "") {
			$this->Export = $_GET["export"];
			$custom = @$_GET["custom"];
		} elseif (@$_POST["export"] <> "") {
			$this->Export = $_POST["export"];
			$custom = @$_POST["custom"];
		} elseif (ew_IsPost()) {
			if (@$_POST["exporttype"] <> "")
				$this->Export = $_POST["exporttype"];
			$custom = @$_POST["custom"];
		} elseif (@$_GET["cmd"] == "json") {
			$this->Export = $_GET["cmd"];
		} else {
			$this->setExportReturnUrl(ew_CurrentUrl());
		}
		$gsExportFile = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->Export <> "" && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$gsCustomExport = $this->CustomExport;
		$gsExport = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined("EW_USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined("EW_USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action

		// Get grid add count
		$gridaddcnt = @$_GET[EW_TABLE_GRID_ADD_ROW_COUNT];
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->SetupListOptions();

		// Setup export options
		$this->SetupExportOptions();
		$this->id->SetVisibility();
		if ($this->IsAdd() || $this->IsCopy() || $this->IsGridAdd())
			$this->id->Visible = FALSE;
		$this->tgl_tanam->SetVisibility();
		$this->jenis_lahan->SetVisibility();
		$this->varietas->SetVisibility();
		$this->jumlah_tanam->SetVisibility();
		$this->ket->SetVisibility();
		$this->id_kontrak_tanam->SetVisibility();
		$this->gen_bibit->SetVisibility();
		$this->id_asal_bibit->SetVisibility();
		$this->jumlah_panen_stek->SetVisibility();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();

		// Setup other options
		$this->SetupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->Add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == EW_ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $tanam_bibit;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($tanam_bibit);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		// Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			ew_SaveDebugMsg();
			header("Location: " . $url);
		}
		exit();
	}

	// Class variables
	var $ListOptions; // List options
	var $ExportOptions; // Export options
	var $SearchOptions; // Search options
	var $OtherOptions = array(); // Other options
	var $FilterOptions; // Filter options
	var $ListActions; // List actions
	var $SelectedCount = 0;
	var $SelectedIndex = 0;
	var $DisplayRecs = 100;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $Pager;
	var $AutoHidePager = EW_AUTO_HIDE_PAGER;
	var $AutoHidePageSizeSelector = EW_AUTO_HIDE_PAGE_SIZE_SELECTOR;
	var $DefaultSearchWhere = ""; // Default search WHERE clause
	var $SearchWhere = ""; // Search WHERE clause
	var $RecCnt = 0; // Record count
	var $EditRowCnt;
	var $StartRowCnt = 1;
	var $RowCnt = 0;
	var $Attrs = array(); // Row attributes and cell attributes
	var $RowIndex = 0; // Row index
	var $KeyCount = 0; // Key count
	var $RowAction = ""; // Row action
	var $RowOldKey = ""; // Row old key (for copy)
	var $RecPerRow = 0;
	var $MultiColumnClass;
	var $MultiColumnEditClass = "col-sm-12";
	var $MultiColumnCnt = 12;
	var $MultiColumnEditCnt = 12;
	var $GridCnt = 0;
	var $ColCnt = 0;
	var $DbMasterFilter = ""; // Master filter
	var $DbDetailFilter = ""; // Detail filter
	var $MasterRecordExists;
	var $MultiSelectKey;
	var $Command;
	var $RestoreSearch = FALSE;
	var $DetailPages;
	var $Recordset;
	var $OldRecordset;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError, $gsSearchError, $Security, $EW_EXPORT;

		// Search filters
		$sSrchAdvanced = ""; // Advanced search filter
		$sSrchBasic = ""; // Basic search filter
		$sFilter = "";

		// Get command
		$this->Command = strtolower(@$_GET["cmd"]);
		if ($this->IsPageRequest()) { // Validate request

			// Process list action first
			if ($this->ProcessListAction()) // Ajax request
				$this->Page_Terminate();

			// Handle reset command
			$this->ResetCmd();

			// Set up Breadcrumb
			if ($this->Export == "")
				$this->SetupBreadcrumb();

			// Hide list options
			if ($this->Export <> "") {
				$this->ListOptions->HideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->CurrentAction == "gridadd" || $this->CurrentAction == "gridedit") {
				$this->ListOptions->HideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->Export <> "" || $this->CurrentAction <> "") {
				$this->ExportOptions->HideAllOptions();
				$this->FilterOptions->HideAllOptions();
			}

			// Hide other options
			if ($this->Export <> "") {
				foreach ($this->OtherOptions as &$option)
					$option->HideAllOptions();
			}

			// Get default search criteria
			ew_AddFilter($this->DefaultSearchWhere, $this->BasicSearchWhere(TRUE));
			ew_AddFilter($this->DefaultSearchWhere, $this->AdvancedSearchWhere(TRUE));

			// Get basic search values
			$this->LoadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->LoadSearchValues(); // Get search values

			// Process filter list
			$this->ProcessFilterList();
			if (!$this->ValidateSearch())
				$this->setFailureMessage($gsSearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->Export <> "" || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->CheckSearchParms())
				$this->RestoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->SetupSortOrder();

			// Get basic search criteria
			if ($gsSearchError == "")
				$sSrchBasic = $this->BasicSearchWhere();

			// Get search criteria for advanced search
			if ($gsSearchError == "")
				$sSrchAdvanced = $this->AdvancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 100; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->LoadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->CheckSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->LoadDefault();
			if ($this->BasicSearch->Keyword != "")
				$sSrchBasic = $this->BasicSearchWhere();

			// Load advanced search from default
			if ($this->LoadAdvancedSearchDefault()) {
				$sSrchAdvanced = $this->AdvancedSearchWhere();
			}
		}

		// Build search criteria
		ew_AddFilter($this->SearchWhere, $sSrchAdvanced);
		ew_AddFilter($this->SearchWhere, $sSrchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$sFilter = "";
		if (!$Security->CanList())
			$sFilter = "(0=1)"; // Filter all records
		ew_AddFilter($sFilter, $this->DbDetailFilter);
		ew_AddFilter($sFilter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSQL = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $sFilter;
		} else {
			$this->setSessionWhere($sFilter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if ($this->CustomExport == "" && in_array($this->Export, array_keys($EW_EXPORT))) {
			$this->ExportData();
			$this->Page_Terminate(); // Terminate response
			exit();
		}

		// Load record count first
		if (!$this->IsAddOrEdit()) {
			$bSelectLimit = $this->UseSelectLimit;
			if ($bSelectLimit) {
				$this->TotalRecs = $this->ListRecordCount();
			} else {
				if ($this->Recordset = $this->LoadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
		}

		// Search options
		$this->SetupSearchOptions();
	}

	// Build filter for all keys
	function BuildKeyFilter() {
		global $objForm;
		$sWrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$objForm->Index = $rowindex;
		$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		while ($sThisKey <> "") {
			if ($this->SetupKeyValues($sThisKey)) {
				$sFilter = $this->KeyFilter();
				if ($sWrkFilter <> "") $sWrkFilter .= " OR ";
				$sWrkFilter .= $sFilter;
			} else {
				$sWrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$objForm->Index = $rowindex;
			$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		}
		return $sWrkFilter;
	}

	// Set up key values
	function SetupKeyValues($key) {
		$arrKeyFlds = explode($GLOBALS["EW_COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arrKeyFlds) >= 1) {
			$this->id->setFormValue($arrKeyFlds[0]);
			if (!is_numeric($this->id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	function GetFilterList() {
		global $UserProfile;

		// Initialize
		$sFilterList = "";
		$sSavedFilterList = "";
		$sFilterList = ew_Concat($sFilterList, $this->id->AdvancedSearch->ToJson(), ","); // Field id
		$sFilterList = ew_Concat($sFilterList, $this->tgl_tanam->AdvancedSearch->ToJson(), ","); // Field tgl_tanam
		$sFilterList = ew_Concat($sFilterList, $this->jenis_lahan->AdvancedSearch->ToJson(), ","); // Field jenis_lahan
		$sFilterList = ew_Concat($sFilterList, $this->varietas->AdvancedSearch->ToJson(), ","); // Field varietas
		$sFilterList = ew_Concat($sFilterList, $this->jumlah_tanam->AdvancedSearch->ToJson(), ","); // Field jumlah_tanam
		$sFilterList = ew_Concat($sFilterList, $this->ket->AdvancedSearch->ToJson(), ","); // Field ket
		$sFilterList = ew_Concat($sFilterList, $this->id_kontrak_tanam->AdvancedSearch->ToJson(), ","); // Field id_kontrak_tanam
		$sFilterList = ew_Concat($sFilterList, $this->gen_bibit->AdvancedSearch->ToJson(), ","); // Field gen_bibit
		$sFilterList = ew_Concat($sFilterList, $this->id_asal_bibit->AdvancedSearch->ToJson(), ","); // Field id_asal_bibit
		$sFilterList = ew_Concat($sFilterList, $this->jumlah_panen_stek->AdvancedSearch->ToJson(), ","); // Field jumlah_panen_stek
		if ($this->BasicSearch->Keyword <> "") {
			$sWrk = "\"" . EW_TABLE_BASIC_SEARCH . "\":\"" . ew_JsEncode2($this->BasicSearch->Keyword) . "\",\"" . EW_TABLE_BASIC_SEARCH_TYPE . "\":\"" . ew_JsEncode2($this->BasicSearch->Type) . "\"";
			$sFilterList = ew_Concat($sFilterList, $sWrk, ",");
		}
		$sFilterList = preg_replace('/,$/', "", $sFilterList);

		// Return filter list in json
		if ($sFilterList <> "")
			$sFilterList = "\"data\":{" . $sFilterList . "}";
		if ($sSavedFilterList <> "") {
			if ($sFilterList <> "")
				$sFilterList .= ",";
			$sFilterList .= "\"filters\":" . $sSavedFilterList;
		}
		return ($sFilterList <> "") ? "{" . $sFilterList . "}" : "null";
	}

	// Process filter list
	function ProcessFilterList() {
		global $UserProfile;
		if (@$_POST["ajax"] == "savefilters") { // Save filter request (Ajax)
			$filters = @$_POST["filters"];
			$UserProfile->SetSearchFilters(CurrentUserName(), "ftanam_bibitlistsrch", $filters);

			// Clean output buffer
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			echo ew_ArrayToJson(array(array("success" => TRUE))); // Success
			$this->Page_Terminate();
			exit();
		} elseif (@$_POST["cmd"] == "resetfilter") {
			$this->RestoreFilterList();
		}
	}

	// Restore list of filters
	function RestoreFilterList() {

		// Return if not reset filter
		if (@$_POST["cmd"] <> "resetfilter")
			return FALSE;
		$filter = json_decode(@$_POST["filter"], TRUE);
		$this->Command = "search";

		// Field id
		$this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
		$this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
		$this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
		$this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
		$this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
		$this->id->AdvancedSearch->Save();

		// Field tgl_tanam
		$this->tgl_tanam->AdvancedSearch->SearchValue = @$filter["x_tgl_tanam"];
		$this->tgl_tanam->AdvancedSearch->SearchOperator = @$filter["z_tgl_tanam"];
		$this->tgl_tanam->AdvancedSearch->SearchCondition = @$filter["v_tgl_tanam"];
		$this->tgl_tanam->AdvancedSearch->SearchValue2 = @$filter["y_tgl_tanam"];
		$this->tgl_tanam->AdvancedSearch->SearchOperator2 = @$filter["w_tgl_tanam"];
		$this->tgl_tanam->AdvancedSearch->Save();

		// Field jenis_lahan
		$this->jenis_lahan->AdvancedSearch->SearchValue = @$filter["x_jenis_lahan"];
		$this->jenis_lahan->AdvancedSearch->SearchOperator = @$filter["z_jenis_lahan"];
		$this->jenis_lahan->AdvancedSearch->SearchCondition = @$filter["v_jenis_lahan"];
		$this->jenis_lahan->AdvancedSearch->SearchValue2 = @$filter["y_jenis_lahan"];
		$this->jenis_lahan->AdvancedSearch->SearchOperator2 = @$filter["w_jenis_lahan"];
		$this->jenis_lahan->AdvancedSearch->Save();

		// Field varietas
		$this->varietas->AdvancedSearch->SearchValue = @$filter["x_varietas"];
		$this->varietas->AdvancedSearch->SearchOperator = @$filter["z_varietas"];
		$this->varietas->AdvancedSearch->SearchCondition = @$filter["v_varietas"];
		$this->varietas->AdvancedSearch->SearchValue2 = @$filter["y_varietas"];
		$this->varietas->AdvancedSearch->SearchOperator2 = @$filter["w_varietas"];
		$this->varietas->AdvancedSearch->Save();

		// Field jumlah_tanam
		$this->jumlah_tanam->AdvancedSearch->SearchValue = @$filter["x_jumlah_tanam"];
		$this->jumlah_tanam->AdvancedSearch->SearchOperator = @$filter["z_jumlah_tanam"];
		$this->jumlah_tanam->AdvancedSearch->SearchCondition = @$filter["v_jumlah_tanam"];
		$this->jumlah_tanam->AdvancedSearch->SearchValue2 = @$filter["y_jumlah_tanam"];
		$this->jumlah_tanam->AdvancedSearch->SearchOperator2 = @$filter["w_jumlah_tanam"];
		$this->jumlah_tanam->AdvancedSearch->Save();

		// Field ket
		$this->ket->AdvancedSearch->SearchValue = @$filter["x_ket"];
		$this->ket->AdvancedSearch->SearchOperator = @$filter["z_ket"];
		$this->ket->AdvancedSearch->SearchCondition = @$filter["v_ket"];
		$this->ket->AdvancedSearch->SearchValue2 = @$filter["y_ket"];
		$this->ket->AdvancedSearch->SearchOperator2 = @$filter["w_ket"];
		$this->ket->AdvancedSearch->Save();

		// Field id_kontrak_tanam
		$this->id_kontrak_tanam->AdvancedSearch->SearchValue = @$filter["x_id_kontrak_tanam"];
		$this->id_kontrak_tanam->AdvancedSearch->SearchOperator = @$filter["z_id_kontrak_tanam"];
		$this->id_kontrak_tanam->AdvancedSearch->SearchCondition = @$filter["v_id_kontrak_tanam"];
		$this->id_kontrak_tanam->AdvancedSearch->SearchValue2 = @$filter["y_id_kontrak_tanam"];
		$this->id_kontrak_tanam->AdvancedSearch->SearchOperator2 = @$filter["w_id_kontrak_tanam"];
		$this->id_kontrak_tanam->AdvancedSearch->Save();

		// Field gen_bibit
		$this->gen_bibit->AdvancedSearch->SearchValue = @$filter["x_gen_bibit"];
		$this->gen_bibit->AdvancedSearch->SearchOperator = @$filter["z_gen_bibit"];
		$this->gen_bibit->AdvancedSearch->SearchCondition = @$filter["v_gen_bibit"];
		$this->gen_bibit->AdvancedSearch->SearchValue2 = @$filter["y_gen_bibit"];
		$this->gen_bibit->AdvancedSearch->SearchOperator2 = @$filter["w_gen_bibit"];
		$this->gen_bibit->AdvancedSearch->Save();

		// Field id_asal_bibit
		$this->id_asal_bibit->AdvancedSearch->SearchValue = @$filter["x_id_asal_bibit"];
		$this->id_asal_bibit->AdvancedSearch->SearchOperator = @$filter["z_id_asal_bibit"];
		$this->id_asal_bibit->AdvancedSearch->SearchCondition = @$filter["v_id_asal_bibit"];
		$this->id_asal_bibit->AdvancedSearch->SearchValue2 = @$filter["y_id_asal_bibit"];
		$this->id_asal_bibit->AdvancedSearch->SearchOperator2 = @$filter["w_id_asal_bibit"];
		$this->id_asal_bibit->AdvancedSearch->Save();

		// Field jumlah_panen_stek
		$this->jumlah_panen_stek->AdvancedSearch->SearchValue = @$filter["x_jumlah_panen_stek"];
		$this->jumlah_panen_stek->AdvancedSearch->SearchOperator = @$filter["z_jumlah_panen_stek"];
		$this->jumlah_panen_stek->AdvancedSearch->SearchCondition = @$filter["v_jumlah_panen_stek"];
		$this->jumlah_panen_stek->AdvancedSearch->SearchValue2 = @$filter["y_jumlah_panen_stek"];
		$this->jumlah_panen_stek->AdvancedSearch->SearchOperator2 = @$filter["w_jumlah_panen_stek"];
		$this->jumlah_panen_stek->AdvancedSearch->Save();
		$this->BasicSearch->setKeyword(@$filter[EW_TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[EW_TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	function AdvancedSearchWhere($Default = FALSE) {
		global $Security;
		$sWhere = "";
		if (!$Security->CanSearch()) return "";
		$this->BuildSearchSql($sWhere, $this->id, $Default, FALSE); // id
		$this->BuildSearchSql($sWhere, $this->tgl_tanam, $Default, FALSE); // tgl_tanam
		$this->BuildSearchSql($sWhere, $this->jenis_lahan, $Default, FALSE); // jenis_lahan
		$this->BuildSearchSql($sWhere, $this->varietas, $Default, FALSE); // varietas
		$this->BuildSearchSql($sWhere, $this->jumlah_tanam, $Default, FALSE); // jumlah_tanam
		$this->BuildSearchSql($sWhere, $this->ket, $Default, FALSE); // ket
		$this->BuildSearchSql($sWhere, $this->id_kontrak_tanam, $Default, FALSE); // id_kontrak_tanam
		$this->BuildSearchSql($sWhere, $this->gen_bibit, $Default, FALSE); // gen_bibit
		$this->BuildSearchSql($sWhere, $this->id_asal_bibit, $Default, FALSE); // id_asal_bibit
		$this->BuildSearchSql($sWhere, $this->jumlah_panen_stek, $Default, FALSE); // jumlah_panen_stek

		// Set up search parm
		if (!$Default && $sWhere <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$Default && $this->Command == "search") {
			$this->id->AdvancedSearch->Save(); // id
			$this->tgl_tanam->AdvancedSearch->Save(); // tgl_tanam
			$this->jenis_lahan->AdvancedSearch->Save(); // jenis_lahan
			$this->varietas->AdvancedSearch->Save(); // varietas
			$this->jumlah_tanam->AdvancedSearch->Save(); // jumlah_tanam
			$this->ket->AdvancedSearch->Save(); // ket
			$this->id_kontrak_tanam->AdvancedSearch->Save(); // id_kontrak_tanam
			$this->gen_bibit->AdvancedSearch->Save(); // gen_bibit
			$this->id_asal_bibit->AdvancedSearch->Save(); // id_asal_bibit
			$this->jumlah_panen_stek->AdvancedSearch->Save(); // jumlah_panen_stek
		}
		return $sWhere;
	}

	// Build search SQL
	function BuildSearchSql(&$Where, &$Fld, $Default, $MultiValue) {
		$FldParm = $Fld->FldParm();
		$FldVal = ($Default) ? $Fld->AdvancedSearch->SearchValueDefault : $Fld->AdvancedSearch->SearchValue; // @$_GET["x_$FldParm"]
		$FldOpr = ($Default) ? $Fld->AdvancedSearch->SearchOperatorDefault : $Fld->AdvancedSearch->SearchOperator; // @$_GET["z_$FldParm"]
		$FldCond = ($Default) ? $Fld->AdvancedSearch->SearchConditionDefault : $Fld->AdvancedSearch->SearchCondition; // @$_GET["v_$FldParm"]
		$FldVal2 = ($Default) ? $Fld->AdvancedSearch->SearchValue2Default : $Fld->AdvancedSearch->SearchValue2; // @$_GET["y_$FldParm"]
		$FldOpr2 = ($Default) ? $Fld->AdvancedSearch->SearchOperator2Default : $Fld->AdvancedSearch->SearchOperator2; // @$_GET["w_$FldParm"]
		$sWrk = "";
		if (is_array($FldVal)) $FldVal = implode(",", $FldVal);
		if (is_array($FldVal2)) $FldVal2 = implode(",", $FldVal2);
		$FldOpr = strtoupper(trim($FldOpr));
		if ($FldOpr == "") $FldOpr = "=";
		$FldOpr2 = strtoupper(trim($FldOpr2));
		if ($FldOpr2 == "") $FldOpr2 = "=";
		if (EW_SEARCH_MULTI_VALUE_OPTION == 1)
			$MultiValue = FALSE;
		if ($MultiValue) {
			$sWrk1 = ($FldVal <> "") ? ew_GetMultiSearchSql($Fld, $FldOpr, $FldVal, $this->DBID) : ""; // Field value 1
			$sWrk2 = ($FldVal2 <> "") ? ew_GetMultiSearchSql($Fld, $FldOpr2, $FldVal2, $this->DBID) : ""; // Field value 2
			$sWrk = $sWrk1; // Build final SQL
			if ($sWrk2 <> "")
				$sWrk = ($sWrk <> "") ? "($sWrk) $FldCond ($sWrk2)" : $sWrk2;
		} else {
			$FldVal = $this->ConvertSearchValue($Fld, $FldVal);
			$FldVal2 = $this->ConvertSearchValue($Fld, $FldVal2);
			$sWrk = ew_GetSearchSql($Fld, $FldVal, $FldOpr, $FldCond, $FldVal2, $FldOpr2, $this->DBID);
		}
		ew_AddFilter($Where, $sWrk);
	}

	// Convert search value
	function ConvertSearchValue(&$Fld, $FldVal) {
		if ($FldVal == EW_NULL_VALUE || $FldVal == EW_NOT_NULL_VALUE)
			return $FldVal;
		$Value = $FldVal;
		if ($Fld->FldDataType == EW_DATATYPE_BOOLEAN) {
			if ($FldVal <> "") $Value = ($FldVal == "1" || strtolower(strval($FldVal)) == "y" || strtolower(strval($FldVal)) == "t") ? $Fld->TrueValue : $Fld->FalseValue;
		} elseif ($Fld->FldDataType == EW_DATATYPE_DATE || $Fld->FldDataType == EW_DATATYPE_TIME) {
			if ($FldVal <> "") $Value = ew_UnFormatDateTime($FldVal, $Fld->FldDateTimeFormat);
		}
		return $Value;
	}

	// Return basic search SQL
	function BasicSearchSQL($arKeywords, $type) {
		$sWhere = "";
		$this->BuildBasicSearchSQL($sWhere, $this->id, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->tgl_tanam, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->jenis_lahan, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->varietas, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->jumlah_tanam, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->ket, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->id_kontrak_tanam, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->gen_bibit, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->id_asal_bibit, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->jumlah_panen_stek, $arKeywords, $type);
		return $sWhere;
	}

	// Build basic search SQL
	function BuildBasicSearchSQL(&$Where, &$Fld, $arKeywords, $type) {
		global $EW_BASIC_SEARCH_IGNORE_PATTERN;
		$sDefCond = ($type == "OR") ? "OR" : "AND";
		$arSQL = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$Keyword = $arKeywords[$i];
			$Keyword = trim($Keyword);
			if ($EW_BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$Keyword = preg_replace($EW_BASIC_SEARCH_IGNORE_PATTERN, "\\", $Keyword);
				$ar = explode("\\", $Keyword);
			} else {
				$ar = array($Keyword);
			}
			foreach ($ar as $Keyword) {
				if ($Keyword <> "") {
					$sWrk = "";
					if ($Keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j-1] = "OR";
					} elseif ($Keyword == EW_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NULL";
					} elseif ($Keyword == EW_NOT_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NOT NULL";
					} elseif ($Fld->FldIsVirtual) {
						$sWrk = $Fld->FldVirtualExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					} elseif ($Fld->FldDataType != EW_DATATYPE_NUMBER || is_numeric($Keyword)) {
						$sWrk = $Fld->FldBasicSearchExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					}
					if ($sWrk <> "") {
						$arSQL[$j] = $sWrk;
						$arCond[$j] = $sDefCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSQL);
		$bQuoted = FALSE;
		$sSql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt-1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$bQuoted) $sSql .= "(";
					$bQuoted = TRUE;
				}
				$sSql .= $arSQL[$i];
				if ($bQuoted && $arCond[$i] <> "OR") {
					$sSql .= ")";
					$bQuoted = FALSE;
				}
				$sSql .= " " . $arCond[$i] . " ";
			}
			$sSql .= $arSQL[$cnt-1];
			if ($bQuoted)
				$sSql .= ")";
		}
		if ($sSql <> "") {
			if ($Where <> "") $Where .= " OR ";
			$Where .= "(" . $sSql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	function BasicSearchWhere($Default = FALSE) {
		global $Security;
		$sSearchStr = "";
		if (!$Security->CanSearch()) return "";
		$sSearchKeyword = ($Default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$sSearchType = ($Default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($sSearchKeyword <> "") {
			$ar = $this->BasicSearch->KeywordList($Default);

			// Search keyword in any fields
			if (($sSearchType == "OR" || $sSearchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $sKeyword) {
					if ($sKeyword <> "") {
						if ($sSearchStr <> "") $sSearchStr .= " " . $sSearchType . " ";
						$sSearchStr .= "(" . $this->BasicSearchSQL(array($sKeyword), $sSearchType) . ")";
					}
				}
			} else {
				$sSearchStr = $this->BasicSearchSQL($ar, $sSearchType);
			}
			if (!$Default && in_array($this->Command, array("", "reset", "resetall"))) $this->Command = "search";
		}
		if (!$Default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($sSearchKeyword);
			$this->BasicSearch->setType($sSearchType);
		}
		return $sSearchStr;
	}

	// Check if search parm exists
	function CheckSearchParms() {

		// Check basic search
		if ($this->BasicSearch->IssetSession())
			return TRUE;
		if ($this->id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->tgl_tanam->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->jenis_lahan->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->varietas->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->jumlah_tanam->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->ket->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->id_kontrak_tanam->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->gen_bibit->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->id_asal_bibit->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->jumlah_panen_stek->AdvancedSearch->IssetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	function ResetSearchParms() {

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->ResetBasicSearchParms();

		// Clear advanced search parameters
		$this->ResetAdvancedSearchParms();
	}

	// Load advanced search default values
	function LoadAdvancedSearchDefault() {
		return FALSE;
	}

	// Clear all basic search parameters
	function ResetBasicSearchParms() {
		$this->BasicSearch->UnsetSession();
	}

	// Clear all advanced search parameters
	function ResetAdvancedSearchParms() {
		$this->id->AdvancedSearch->UnsetSession();
		$this->tgl_tanam->AdvancedSearch->UnsetSession();
		$this->jenis_lahan->AdvancedSearch->UnsetSession();
		$this->varietas->AdvancedSearch->UnsetSession();
		$this->jumlah_tanam->AdvancedSearch->UnsetSession();
		$this->ket->AdvancedSearch->UnsetSession();
		$this->id_kontrak_tanam->AdvancedSearch->UnsetSession();
		$this->gen_bibit->AdvancedSearch->UnsetSession();
		$this->id_asal_bibit->AdvancedSearch->UnsetSession();
		$this->jumlah_panen_stek->AdvancedSearch->UnsetSession();
	}

	// Restore all search parameters
	function RestoreSearchParms() {
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->Load();

		// Restore advanced search values
		$this->id->AdvancedSearch->Load();
		$this->tgl_tanam->AdvancedSearch->Load();
		$this->jenis_lahan->AdvancedSearch->Load();
		$this->varietas->AdvancedSearch->Load();
		$this->jumlah_tanam->AdvancedSearch->Load();
		$this->ket->AdvancedSearch->Load();
		$this->id_kontrak_tanam->AdvancedSearch->Load();
		$this->gen_bibit->AdvancedSearch->Load();
		$this->id_asal_bibit->AdvancedSearch->Load();
		$this->jumlah_panen_stek->AdvancedSearch->Load();
	}

	// Set up sort parameters
	function SetupSortOrder() {

		// Check for "order" parameter
		if (@$_GET["order"] <> "") {
			$this->CurrentOrder = @$_GET["order"];
			$this->CurrentOrderType = @$_GET["ordertype"];
			$this->UpdateSort($this->id); // id
			$this->UpdateSort($this->tgl_tanam); // tgl_tanam
			$this->UpdateSort($this->jenis_lahan); // jenis_lahan
			$this->UpdateSort($this->varietas); // varietas
			$this->UpdateSort($this->jumlah_tanam); // jumlah_tanam
			$this->UpdateSort($this->ket); // ket
			$this->UpdateSort($this->id_kontrak_tanam); // id_kontrak_tanam
			$this->UpdateSort($this->gen_bibit); // gen_bibit
			$this->UpdateSort($this->id_asal_bibit); // id_asal_bibit
			$this->UpdateSort($this->jumlah_panen_stek); // jumlah_panen_stek
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	function LoadSortOrder() {
		$sOrderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($sOrderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$sOrderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($sOrderBy);
				$this->id->setSort("DESC");
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)
	function ResetCmd() {

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->ResetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$sOrderBy = "";
				$this->setSessionOrderBy($sOrderBy);
				$this->id->setSort("");
				$this->tgl_tanam->setSort("");
				$this->jenis_lahan->setSort("");
				$this->varietas->setSort("");
				$this->jumlah_tanam->setSort("");
				$this->ket->setSort("");
				$this->id_kontrak_tanam->setSort("");
				$this->gen_bibit->setSort("");
				$this->id_asal_bibit->setSort("");
				$this->jumlah_panen_stek->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	function SetupListOptions() {
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->Add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->Add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->CanView();
		$item->OnLeft = TRUE;

		// "edit"
		$item = &$this->ListOptions->Add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->CanEdit();
		$item->OnLeft = TRUE;

		// "copy"
		$item = &$this->ListOptions->Add("copy");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->CanAdd();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->Add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->Add("checkbox");
		$item->Visible = $Security->CanDelete();
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew_SelectAllKey(this);\">";
		$item->MoveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseImageAndText = TRUE;
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->Phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		if ($this->ListOptions->UseButtonGroup && ew_IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;
		$this->ListOptions->ButtonClass = "btn-sm"; // Class for button group

		// Call ListOptions_Load event
		$this->ListOptions_Load();
		$this->SetupListOptionsExt();
		$item = &$this->ListOptions->GetItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->GroupOptionVisible();
	}

	// Render list options
	function RenderListOptions() {
		global $Security, $Language, $objForm;
		$this->ListOptions->LoadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$oListOpt = &$this->ListOptions->Items["view"];
		$viewcaption = ew_HtmlTitle($Language->Phrase("ViewLink"));
		if ($Security->CanView()) {
			$oListOpt->Body = "<a class=\"ewRowLink ewView\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . ew_HtmlEncode($this->ViewUrl) . "\">" . $Language->Phrase("ViewLink") . "</a>";
		} else {
			$oListOpt->Body = "";
		}

		// "edit"
		$oListOpt = &$this->ListOptions->Items["edit"];
		$editcaption = ew_HtmlTitle($Language->Phrase("EditLink"));
		if ($Security->CanEdit()) {
			$oListOpt->Body = "<a class=\"ewRowLink ewEdit\" title=\"" . ew_HtmlTitle($Language->Phrase("EditLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("EditLink")) . "\" href=\"" . ew_HtmlEncode($this->EditUrl) . "\">" . $Language->Phrase("EditLink") . "</a>";
		} else {
			$oListOpt->Body = "";
		}

		// "copy"
		$oListOpt = &$this->ListOptions->Items["copy"];
		$copycaption = ew_HtmlTitle($Language->Phrase("CopyLink"));
		if ($Security->CanAdd()) {
			$oListOpt->Body = "<a class=\"ewRowLink ewCopy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . ew_HtmlEncode($this->CopyUrl) . "\">" . $Language->Phrase("CopyLink") . "</a>";
		} else {
			$oListOpt->Body = "";
		}

		// Set up list action buttons
		$oListOpt = &$this->ListOptions->GetItem("listactions");
		if ($oListOpt && $this->Export == "" && $this->CurrentAction == "") {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode(str_replace(" ewIcon", "", $listaction->Icon)) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\"></span> " : "";
					$links[] = "<li><a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" title=\"" . ew_HtmlTitle($caption) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $Language->Phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default btn-sm ewActions\" title=\"" . ew_HtmlTitle($Language->Phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->Phrase("ListActionButton") . "<b class=\"caret\"></b></button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($oListOpt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$oListOpt->Body = $body;
				$oListOpt->Visible = TRUE;
			}
		}

		// "checkbox"
		$oListOpt = &$this->ListOptions->Items["checkbox"];
		$oListOpt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ewMultiSelect\" value=\"" . ew_HtmlEncode($this->id->CurrentValue) . "\" onclick=\"ew_ClickMultiCheckbox(event);\">";
		$this->RenderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	function SetupOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->Add("add");
		$addcaption = ew_HtmlTitle($Language->Phrase("AddLink"));
		$item->Body = "<a class=\"ewAddEdit ewAdd\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . ew_HtmlEncode($this->AddUrl) . "\">" . $Language->Phrase("AddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->CanAdd());
		$option = $options["action"];

		// Add multi delete
		$item = &$option->Add("multidelete");
		$item->Body = "<a class=\"ewAction ewMultiDelete\" title=\"" . ew_HtmlTitle($Language->Phrase("DeleteSelectedLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("DeleteSelectedLink")) . "\" href=\"\" onclick=\"ew_SubmitAction(event,{f:document.ftanam_bibitlist,url:'" . $this->MultiDeleteUrl . "'});return false;\">" . $Language->Phrase("DeleteSelectedLink") . "</a>";
		$item->Visible = ($Security->CanDelete());

		// Set up options default
		foreach ($options as &$option) {
			$option->UseImageAndText = TRUE;
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;
			$option->ButtonClass = "btn-sm"; // Class for button group
			$item = &$option->Add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->Phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->Phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->Phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->Add("savecurrentfilter");
		$item->Body = "<a class=\"ewSaveFilter\" data-form=\"ftanam_bibitlistsrch\" href=\"#\">" . $Language->Phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->Add("deletefilter");
		$item->Body = "<a class=\"ewDeleteFilter\" data-form=\"ftanam_bibitlistsrch\" href=\"#\">" . $Language->Phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->Phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->Add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	function RenderOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_MULTIPLE) {
					$item = &$option->Add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode($listaction->Icon) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\"></span> " : $caption;
					$item->Body = "<a class=\"ewAction ewListAction\" title=\"" . ew_HtmlEncode($caption) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({f:document.ftanam_bibitlist}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->GetItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->HideAllOptions();
			}
	}

	// Process list action
	function ProcessListAction() {
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$sFilter = $this->GetKeyFilter();
		$UserAction = @$_POST["useraction"];
		if ($sFilter <> "" && $UserAction <> "") {

			// Check permission first
			$ActionCaption = $UserAction;
			if (array_key_exists($UserAction, $this->ListActions->Items)) {
				$ActionCaption = $this->ListActions->Items[$UserAction]->Caption;
				if (!$this->ListActions->Items[$UserAction]->Allow) {
					$errmsg = str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionNotAllowed"));
					if (@$_POST["ajax"] == $UserAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $sFilter;
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			$rs = $conn->Execute($sSql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $UserAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->BeginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$Processed = $this->Row_CustomAction($UserAction, $row);
					if (!$Processed) break;
					$rs->MoveNext();
				}
				if ($Processed) {
					$conn->CommitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->RollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->Close();
			$this->CurrentAction = ""; // Clear action
			if (@$_POST["ajax"] == $UserAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->ClearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->ClearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	function SetupSearchOptions() {
		global $Language;
		$this->SearchOptions = new cListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ewSearchOption";

		// Search button
		$item = &$this->SearchOptions->Add("searchtoggle");
		$SearchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ewSearchToggle" . $SearchToggleClass . "\" title=\"" . $Language->Phrase("SearchPanel") . "\" data-caption=\"" . $Language->Phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"ftanam_bibitlistsrch\">" . $Language->Phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->Add("showall");
		$item->Body = "<a class=\"btn btn-default ewShowAll\" title=\"" . $Language->Phrase("ShowAll") . "\" data-caption=\"" . $Language->Phrase("ShowAll") . "\" href=\"" . $this->PageUrl() . "cmd=reset\">" . $Language->Phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseImageAndText = TRUE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->Phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->Add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->Export <> "" || $this->CurrentAction <> "")
			$this->SearchOptions->HideAllOptions();
		global $Security;
		if (!$Security->CanSearch()) {
			$this->SearchOptions->HideAllOptions();
			$this->FilterOptions->HideAllOptions();
		}
	}

	function SetupListOptionsExt() {
		global $Security, $Language;
	}

	function RenderListOptionsExt() {
		global $Security, $Language;
	}

	// Set up starting record parameters
	function SetupStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	function LoadBasicSearchValues() {
		$this->BasicSearch->Keyword = @$_GET[EW_TABLE_BASIC_SEARCH];
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "") $this->Command = "search";
		$this->BasicSearch->Type = @$_GET[EW_TABLE_BASIC_SEARCH_TYPE];
	}

	// Load search values for validation
	function LoadSearchValues() {
		global $objForm;

		// Load search values
		// id

		$this->id->AdvancedSearch->SearchValue = @$_GET["x_id"];
		if ($this->id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->id->AdvancedSearch->SearchOperator = @$_GET["z_id"];

		// tgl_tanam
		$this->tgl_tanam->AdvancedSearch->SearchValue = @$_GET["x_tgl_tanam"];
		if ($this->tgl_tanam->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->tgl_tanam->AdvancedSearch->SearchOperator = @$_GET["z_tgl_tanam"];
		$this->tgl_tanam->AdvancedSearch->SearchCondition = @$_GET["v_tgl_tanam"];
		$this->tgl_tanam->AdvancedSearch->SearchValue2 = @$_GET["y_tgl_tanam"];
		if ($this->tgl_tanam->AdvancedSearch->SearchValue2 <> "" && $this->Command == "") $this->Command = "search";
		$this->tgl_tanam->AdvancedSearch->SearchOperator2 = @$_GET["w_tgl_tanam"];

		// jenis_lahan
		$this->jenis_lahan->AdvancedSearch->SearchValue = @$_GET["x_jenis_lahan"];
		if ($this->jenis_lahan->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->jenis_lahan->AdvancedSearch->SearchOperator = @$_GET["z_jenis_lahan"];

		// varietas
		$this->varietas->AdvancedSearch->SearchValue = @$_GET["x_varietas"];
		if ($this->varietas->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->varietas->AdvancedSearch->SearchOperator = @$_GET["z_varietas"];

		// jumlah_tanam
		$this->jumlah_tanam->AdvancedSearch->SearchValue = @$_GET["x_jumlah_tanam"];
		if ($this->jumlah_tanam->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->jumlah_tanam->AdvancedSearch->SearchOperator = @$_GET["z_jumlah_tanam"];

		// ket
		$this->ket->AdvancedSearch->SearchValue = @$_GET["x_ket"];
		if ($this->ket->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->ket->AdvancedSearch->SearchOperator = @$_GET["z_ket"];

		// id_kontrak_tanam
		$this->id_kontrak_tanam->AdvancedSearch->SearchValue = @$_GET["x_id_kontrak_tanam"];
		if ($this->id_kontrak_tanam->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->id_kontrak_tanam->AdvancedSearch->SearchOperator = @$_GET["z_id_kontrak_tanam"];

		// gen_bibit
		$this->gen_bibit->AdvancedSearch->SearchValue = @$_GET["x_gen_bibit"];
		if ($this->gen_bibit->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->gen_bibit->AdvancedSearch->SearchOperator = @$_GET["z_gen_bibit"];

		// id_asal_bibit
		$this->id_asal_bibit->AdvancedSearch->SearchValue = @$_GET["x_id_asal_bibit"];
		if ($this->id_asal_bibit->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->id_asal_bibit->AdvancedSearch->SearchOperator = @$_GET["z_id_asal_bibit"];

		// jumlah_panen_stek
		$this->jumlah_panen_stek->AdvancedSearch->SearchValue = @$_GET["x_jumlah_panen_stek"];
		if ($this->jumlah_panen_stek->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->jumlah_panen_stek->AdvancedSearch->SearchOperator = @$_GET["z_jumlah_panen_stek"];
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {

		// Load List page SQL
		$sSql = $this->ListSQL();
		$conn = &$this->Connection();

		// Load recordset
		$dbtype = ew_GetConnectionType($this->DBID);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset, array("_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())));
			} else {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = ew_LoadRecordset($sSql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues($rs = NULL) {
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->NewRow(); 

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->tgl_tanam->setDbValue($row['tgl_tanam']);
		$this->jenis_lahan->setDbValue($row['jenis_lahan']);
		$this->varietas->setDbValue($row['varietas']);
		$this->jumlah_tanam->setDbValue($row['jumlah_tanam']);
		$this->ket->setDbValue($row['ket']);
		$this->id_kontrak_tanam->setDbValue($row['id_kontrak_tanam']);
		$this->gen_bibit->setDbValue($row['gen_bibit']);
		$this->id_asal_bibit->setDbValue($row['id_asal_bibit']);
		$this->jumlah_panen_stek->setDbValue($row['jumlah_panen_stek']);
	}

	// Return a row with default values
	function NewRow() {
		$row = array();
		$row['id'] = NULL;
		$row['tgl_tanam'] = NULL;
		$row['jenis_lahan'] = NULL;
		$row['varietas'] = NULL;
		$row['jumlah_tanam'] = NULL;
		$row['ket'] = NULL;
		$row['id_kontrak_tanam'] = NULL;
		$row['gen_bibit'] = NULL;
		$row['id_asal_bibit'] = NULL;
		$row['jumlah_panen_stek'] = NULL;
		return $row;
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->tgl_tanam->DbValue = $row['tgl_tanam'];
		$this->jenis_lahan->DbValue = $row['jenis_lahan'];
		$this->varietas->DbValue = $row['varietas'];
		$this->jumlah_tanam->DbValue = $row['jumlah_tanam'];
		$this->ket->DbValue = $row['ket'];
		$this->id_kontrak_tanam->DbValue = $row['id_kontrak_tanam'];
		$this->gen_bibit->DbValue = $row['gen_bibit'];
		$this->id_asal_bibit->DbValue = $row['id_asal_bibit'];
		$this->jumlah_panen_stek->DbValue = $row['jumlah_panen_stek'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$bValidKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
		}
		$this->LoadRowValues($this->OldRecordset); // Load row values
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->GetViewUrl();
		$this->EditUrl = $this->GetEditUrl();
		$this->InlineEditUrl = $this->GetInlineEditUrl();
		$this->CopyUrl = $this->GetCopyUrl();
		$this->InlineCopyUrl = $this->GetInlineCopyUrl();
		$this->DeleteUrl = $this->GetDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// tgl_tanam
		// jenis_lahan
		// varietas
		// jumlah_tanam
		// ket
		// id_kontrak_tanam
		// gen_bibit
		// id_asal_bibit
		// jumlah_panen_stek
		// Accumulate aggregate value

		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT && $this->RowType <> EW_ROWTYPE_AGGREGATE) {
			if (is_numeric($this->jumlah_tanam->CurrentValue))
				$this->jumlah_tanam->Total += $this->jumlah_tanam->CurrentValue; // Accumulate total
		}
		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// tgl_tanam
		$this->tgl_tanam->ViewValue = $this->tgl_tanam->CurrentValue;
		$this->tgl_tanam->ViewValue = ew_FormatDateTime($this->tgl_tanam->ViewValue, 0);
		$this->tgl_tanam->ViewCustomAttributes = "";

		// jenis_lahan
		if (strval($this->jenis_lahan->CurrentValue) <> "") {
			$sFilterWrk = "`jenis_lahan_bibit`" . ew_SearchString("=", $this->jenis_lahan->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `jenis_lahan_bibit`, `jenis_lahan_bibit` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `jenis_lahan_bibit`";
		$sWhereWrk = "";
		$this->jenis_lahan->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->jenis_lahan, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->jenis_lahan->ViewValue = $this->jenis_lahan->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->jenis_lahan->ViewValue = $this->jenis_lahan->CurrentValue;
			}
		} else {
			$this->jenis_lahan->ViewValue = NULL;
		}
		$this->jenis_lahan->ViewCustomAttributes = "";

		// varietas
		if (strval($this->varietas->CurrentValue) <> "") {
			$sFilterWrk = "`var_id`" . ew_SearchString("=", $this->varietas->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `var_id`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `varietas`";
		$sWhereWrk = "";
		$this->varietas->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->varietas, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->varietas->ViewValue = $this->varietas->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->varietas->ViewValue = $this->varietas->CurrentValue;
			}
		} else {
			$this->varietas->ViewValue = NULL;
		}
		$this->varietas->ViewCustomAttributes = "";

		// jumlah_tanam
		$this->jumlah_tanam->ViewValue = $this->jumlah_tanam->CurrentValue;
		$this->jumlah_tanam->ViewValue = ew_FormatNumber($this->jumlah_tanam->ViewValue, 0, -1, 0, 0);
		$this->jumlah_tanam->ViewCustomAttributes = "";

		// ket
		$this->ket->ViewValue = $this->ket->CurrentValue;
		$this->ket->ViewCustomAttributes = "";

		// id_kontrak_tanam
		if (strval($this->id_kontrak_tanam->CurrentValue) <> "") {
			$sFilterWrk = "`k_id_kontrak`" . ew_SearchString("=", $this->id_kontrak_tanam->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `k_id_kontrak`, `k_id_kontrak` AS `DispFld`, `k_tgl_tanam` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kontrak`";
		$sWhereWrk = "";
		$this->id_kontrak_tanam->LookupFilters = array("df2" => "5");
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->id_kontrak_tanam, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `k_id_kontrak` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = ew_FormatDateTime($rswrk->fields('Disp2Fld'), 5);
				$this->id_kontrak_tanam->ViewValue = $this->id_kontrak_tanam->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->id_kontrak_tanam->ViewValue = $this->id_kontrak_tanam->CurrentValue;
			}
		} else {
			$this->id_kontrak_tanam->ViewValue = NULL;
		}
		$this->id_kontrak_tanam->ViewCustomAttributes = "";

		// gen_bibit
		if (strval($this->gen_bibit->CurrentValue) <> "") {
			$sFilterWrk = "`id_gen`" . ew_SearchString("=", $this->gen_bibit->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `id_gen`, `id_gen` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `generasi_bibit`";
		$sWhereWrk = "";
		$this->gen_bibit->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gen_bibit, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gen_bibit->ViewValue = $this->gen_bibit->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gen_bibit->ViewValue = $this->gen_bibit->CurrentValue;
			}
		} else {
			$this->gen_bibit->ViewValue = NULL;
		}
		$this->gen_bibit->ViewCustomAttributes = "";

		// id_asal_bibit
		if (strval($this->id_asal_bibit->CurrentValue) <> "") {
			$sFilterWrk = "`id`" . ew_SearchString("=", $this->id_asal_bibit->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `id`, `id` AS `DispFld`, `tgl_tanam` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tanam_bibit`";
		$sWhereWrk = "";
		$this->id_asal_bibit->LookupFilters = array("df2" => "0");
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->id_asal_bibit, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `id` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = ew_FormatDateTime($rswrk->fields('Disp2Fld'), 0);
				$this->id_asal_bibit->ViewValue = $this->id_asal_bibit->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->id_asal_bibit->ViewValue = $this->id_asal_bibit->CurrentValue;
			}
		} else {
			$this->id_asal_bibit->ViewValue = NULL;
		}
		$this->id_asal_bibit->ViewValue = ew_FormatDateTime($this->id_asal_bibit->ViewValue, 5);
		$this->id_asal_bibit->ViewCustomAttributes = "";

		// jumlah_panen_stek
		$this->jumlah_panen_stek->ViewValue = $this->jumlah_panen_stek->CurrentValue;
		$this->jumlah_panen_stek->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// tgl_tanam
			$this->tgl_tanam->LinkCustomAttributes = "";
			$this->tgl_tanam->HrefValue = "";
			$this->tgl_tanam->TooltipValue = "";

			// jenis_lahan
			$this->jenis_lahan->LinkCustomAttributes = "";
			$this->jenis_lahan->HrefValue = "";
			$this->jenis_lahan->TooltipValue = "";

			// varietas
			$this->varietas->LinkCustomAttributes = "";
			$this->varietas->HrefValue = "";
			$this->varietas->TooltipValue = "";

			// jumlah_tanam
			$this->jumlah_tanam->LinkCustomAttributes = "";
			$this->jumlah_tanam->HrefValue = "";
			$this->jumlah_tanam->TooltipValue = "";

			// ket
			$this->ket->LinkCustomAttributes = "";
			$this->ket->HrefValue = "";
			$this->ket->TooltipValue = "";

			// id_kontrak_tanam
			$this->id_kontrak_tanam->LinkCustomAttributes = "";
			$this->id_kontrak_tanam->HrefValue = "";
			$this->id_kontrak_tanam->TooltipValue = "";

			// gen_bibit
			$this->gen_bibit->LinkCustomAttributes = "";
			$this->gen_bibit->HrefValue = "";
			$this->gen_bibit->TooltipValue = "";

			// id_asal_bibit
			$this->id_asal_bibit->LinkCustomAttributes = "";
			$this->id_asal_bibit->HrefValue = "";
			$this->id_asal_bibit->TooltipValue = "";

			// jumlah_panen_stek
			$this->jumlah_panen_stek->LinkCustomAttributes = "";
			$this->jumlah_panen_stek->HrefValue = "";
			$this->jumlah_panen_stek->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = ew_HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = ew_RemoveHtml($this->id->FldCaption());

			// tgl_tanam
			$this->tgl_tanam->EditAttrs["class"] = "form-control";
			$this->tgl_tanam->EditCustomAttributes = "";
			$this->tgl_tanam->EditValue = ew_HtmlEncode(ew_FormatDateTime(ew_UnFormatDateTime($this->tgl_tanam->AdvancedSearch->SearchValue, 0), 8));
			$this->tgl_tanam->PlaceHolder = ew_RemoveHtml($this->tgl_tanam->FldCaption());
			$this->tgl_tanam->EditAttrs["class"] = "form-control";
			$this->tgl_tanam->EditCustomAttributes = "";
			$this->tgl_tanam->EditValue2 = ew_HtmlEncode(ew_FormatDateTime(ew_UnFormatDateTime($this->tgl_tanam->AdvancedSearch->SearchValue2, 0), 8));
			$this->tgl_tanam->PlaceHolder = ew_RemoveHtml($this->tgl_tanam->FldCaption());

			// jenis_lahan
			$this->jenis_lahan->EditCustomAttributes = "";
			if (trim(strval($this->jenis_lahan->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`jenis_lahan_bibit`" . ew_SearchString("=", $this->jenis_lahan->AdvancedSearch->SearchValue, EW_DATATYPE_STRING, "");
			}
			$sSqlWrk = "SELECT `jenis_lahan_bibit`, `jenis_lahan_bibit` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `jenis_lahan_bibit`";
			$sWhereWrk = "";
			$this->jenis_lahan->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->jenis_lahan, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->jenis_lahan->EditValue = $arwrk;

			// varietas
			$this->varietas->EditAttrs["class"] = "form-control";
			$this->varietas->EditCustomAttributes = "";
			if (trim(strval($this->varietas->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`var_id`" . ew_SearchString("=", $this->varietas->AdvancedSearch->SearchValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `var_id`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `varietas`";
			$sWhereWrk = "";
			$this->varietas->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->varietas, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->varietas->EditValue = $arwrk;

			// jumlah_tanam
			$this->jumlah_tanam->EditAttrs["class"] = "form-control";
			$this->jumlah_tanam->EditCustomAttributes = "";
			$this->jumlah_tanam->EditValue = ew_HtmlEncode($this->jumlah_tanam->AdvancedSearch->SearchValue);
			$this->jumlah_tanam->PlaceHolder = ew_RemoveHtml($this->jumlah_tanam->FldCaption());

			// ket
			$this->ket->EditAttrs["class"] = "form-control";
			$this->ket->EditCustomAttributes = "";
			$this->ket->EditValue = ew_HtmlEncode($this->ket->AdvancedSearch->SearchValue);
			$this->ket->PlaceHolder = ew_RemoveHtml($this->ket->FldCaption());

			// id_kontrak_tanam
			$this->id_kontrak_tanam->EditAttrs["class"] = "form-control";
			$this->id_kontrak_tanam->EditCustomAttributes = "";
			if (trim(strval($this->id_kontrak_tanam->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`k_id_kontrak`" . ew_SearchString("=", $this->id_kontrak_tanam->AdvancedSearch->SearchValue, EW_DATATYPE_STRING, "");
			}
			$sSqlWrk = "SELECT `k_id_kontrak`, `k_id_kontrak` AS `DispFld`, `k_tgl_tanam` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `kontrak`";
			$sWhereWrk = "";
			$this->id_kontrak_tanam->LookupFilters = array("df2" => "5");
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->id_kontrak_tanam, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `k_id_kontrak` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$rowswrk = count($arwrk);
			for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
				$arwrk[$rowcntwrk][2] = ew_FormatDateTime($arwrk[$rowcntwrk][2], 5);
			}
			$this->id_kontrak_tanam->EditValue = $arwrk;

			// gen_bibit
			$this->gen_bibit->EditAttrs["class"] = "form-control";
			$this->gen_bibit->EditCustomAttributes = "";
			if (trim(strval($this->gen_bibit->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`id_gen`" . ew_SearchString("=", $this->gen_bibit->AdvancedSearch->SearchValue, EW_DATATYPE_STRING, "");
			}
			$sSqlWrk = "SELECT `id_gen`, `id_gen` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `generasi_bibit`";
			$sWhereWrk = "";
			$this->gen_bibit->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->gen_bibit, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->gen_bibit->EditValue = $arwrk;

			// id_asal_bibit
			$this->id_asal_bibit->EditAttrs["class"] = "form-control";
			$this->id_asal_bibit->EditCustomAttributes = "";
			if (trim(strval($this->id_asal_bibit->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`id`" . ew_SearchString("=", $this->id_asal_bibit->AdvancedSearch->SearchValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `id`, `id` AS `DispFld`, `tgl_tanam` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `tanam_bibit`";
			$sWhereWrk = "";
			$this->id_asal_bibit->LookupFilters = array("df2" => "0");
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->id_asal_bibit, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `id` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$rowswrk = count($arwrk);
			for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
				$arwrk[$rowcntwrk][2] = ew_FormatDateTime($arwrk[$rowcntwrk][2], 0);
			}
			$this->id_asal_bibit->EditValue = $arwrk;

			// jumlah_panen_stek
			$this->jumlah_panen_stek->EditAttrs["class"] = "form-control";
			$this->jumlah_panen_stek->EditCustomAttributes = "";
			$this->jumlah_panen_stek->EditValue = ew_HtmlEncode($this->jumlah_panen_stek->AdvancedSearch->SearchValue);
			$this->jumlah_panen_stek->PlaceHolder = ew_RemoveHtml($this->jumlah_panen_stek->FldCaption());
		} elseif ($this->RowType == EW_ROWTYPE_AGGREGATEINIT) { // Initialize aggregate row
			$this->jumlah_tanam->Total = 0; // Initialize total
		} elseif ($this->RowType == EW_ROWTYPE_AGGREGATE) { // Aggregate row
			$this->jumlah_tanam->CurrentValue = $this->jumlah_tanam->Total;
			$this->jumlah_tanam->ViewValue = $this->jumlah_tanam->CurrentValue;
			$this->jumlah_tanam->ViewValue = ew_FormatNumber($this->jumlah_tanam->ViewValue, 0, -1, 0, 0);
			$this->jumlah_tanam->ViewCustomAttributes = "";
			$this->jumlah_tanam->HrefValue = ""; // Clear href value
		}
		if ($this->RowType == EW_ROWTYPE_ADD || $this->RowType == EW_ROWTYPE_EDIT || $this->RowType == EW_ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->SetupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	function ValidateSearch() {
		global $gsSearchError;

		// Initialize
		$gsSearchError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return TRUE;
		if (!ew_CheckDateDef($this->tgl_tanam->AdvancedSearch->SearchValue)) {
			ew_AddMessage($gsSearchError, $this->tgl_tanam->FldErrMsg());
		}
		if (!ew_CheckDateDef($this->tgl_tanam->AdvancedSearch->SearchValue2)) {
			ew_AddMessage($gsSearchError, $this->tgl_tanam->FldErrMsg());
		}

		// Return validate result
		$ValidateSearch = ($gsSearchError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateSearch = $ValidateSearch && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsSearchError, $sFormCustomError);
		}
		return $ValidateSearch;
	}

	// Load advanced search
	function LoadAdvancedSearch() {
		$this->id->AdvancedSearch->Load();
		$this->tgl_tanam->AdvancedSearch->Load();
		$this->jenis_lahan->AdvancedSearch->Load();
		$this->varietas->AdvancedSearch->Load();
		$this->jumlah_tanam->AdvancedSearch->Load();
		$this->ket->AdvancedSearch->Load();
		$this->id_kontrak_tanam->AdvancedSearch->Load();
		$this->gen_bibit->AdvancedSearch->Load();
		$this->id_asal_bibit->AdvancedSearch->Load();
		$this->jumlah_panen_stek->AdvancedSearch->Load();
	}

	// Set up export options
	function SetupExportOptions() {
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->Add("print");
		$item->Body = "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ewExportLink ewPrint\" title=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\">" . $Language->Phrase("PrinterFriendly") . "</a>";
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->Add("excel");
		$item->Body = "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ewExportLink ewExcel\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\">" . $Language->Phrase("ExportToExcel") . "</a>";
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->Add("word");
		$item->Body = "<a href=\"" . $this->ExportWordUrl . "\" class=\"ewExportLink ewWord\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\">" . $Language->Phrase("ExportToWord") . "</a>";
		$item->Visible = TRUE;

		// Export to Html
		$item = &$this->ExportOptions->Add("html");
		$item->Body = "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ewExportLink ewHtml\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\">" . $Language->Phrase("ExportToHtml") . "</a>";
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->Add("xml");
		$item->Body = "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ewExportLink ewXml\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\">" . $Language->Phrase("ExportToXml") . "</a>";
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->Add("csv");
		$item->Body = "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ewExportLink ewCsv\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\">" . $Language->Phrase("ExportToCsv") . "</a>";
		$item->Visible = FALSE;

		// Export to Pdf
		$item = &$this->ExportOptions->Add("pdf");
		$item->Body = "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ewExportLink ewPdf\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\">" . $Language->Phrase("ExportToPDF") . "</a>";
		$item->Visible = FALSE;

		// Export to Email
		$item = &$this->ExportOptions->Add("email");
		$url = "";
		$item->Body = "<button id=\"emf_tanam_bibit\" class=\"ewExportLink ewEmail\" title=\"" . $Language->Phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->Phrase("ExportToEmailText") . "\" onclick=\"ew_EmailDialogShow({lnk:'emf_tanam_bibit',hdr:ewLanguage.Phrase('ExportToEmailText'),f:document.ftanam_bibitlist,sel:false" . $url . "});\">" . $Language->Phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseImageAndText = TRUE;
		$this->ExportOptions->UseDropDownButton = FALSE;
		if ($this->ExportOptions->UseButtonGroup && ew_IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->Phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->Add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	function ExportData() {
		$utf8 = (strtolower(EW_CHARSET) == "utf-8");
		$bSelectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($bSelectLimit) {
			$this->TotalRecs = $this->ListRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->LoadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EW_EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->SetupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($bSelectLimit)
			$rs = $this->LoadRecordset($this->StartRec-1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		if (!$rs) {
			header("Content-Type:"); // Remove header
			header("Content-Disposition:");
			$this->ShowMessage();
			return;
		}
		$this->ExportDoc = ew_ExportDocument($this, "h");
		$Doc = &$this->ExportDoc;
		if ($bSelectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		} else {

			//$this->StartRec = $this->StartRec;
			//$this->StopRec = $this->StopRec;

		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$ParentTable = "";
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		$Doc->Text .= $sHeader;
		$this->ExportDocument($Doc, $rs, $this->StartRec, $this->StopRec, "");
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		$Doc->Text .= $sFooter;

		// Close recordset
		$rs->Close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$Doc->ExportHeaderAndFooter();

		// Clean output buffer
		if (!EW_DEBUG_ENABLED && ob_get_length())
			ob_end_clean();

		// Write debug message if enabled
		if (EW_DEBUG_ENABLED && $this->Export <> "pdf")
			echo ew_DebugMsg();

		// Output data
		$Doc->Export();
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->Add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup filters of a field
	function SetupLookupFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		if ($pageId == "list") {
			switch ($fld->FldVar) {
			}
		} elseif ($pageId == "extbs") {
			switch ($fld->FldVar) {
		case "x_jenis_lahan":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `jenis_lahan_bibit` AS `LinkFld`, `jenis_lahan_bibit` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `jenis_lahan_bibit`";
				$sWhereWrk = "";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`jenis_lahan_bibit` IN ({filter_value})', "t0" => "200", "fn0" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->jenis_lahan, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_varietas":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `var_id` AS `LinkFld`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `varietas`";
				$sWhereWrk = "";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`var_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->varietas, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_id_kontrak_tanam":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `k_id_kontrak` AS `LinkFld`, `k_id_kontrak` AS `DispFld`, `k_tgl_tanam` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kontrak`";
				$sWhereWrk = "";
				$fld->LookupFilters = array("df2" => "5");
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`k_id_kontrak` IN ({filter_value})', "t0" => "200", "fn0" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->id_kontrak_tanam, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$sSqlWrk .= " ORDER BY `k_id_kontrak` DESC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_gen_bibit":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `id_gen` AS `LinkFld`, `id_gen` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `generasi_bibit`";
				$sWhereWrk = "";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`id_gen` IN ({filter_value})', "t0" => "200", "fn0" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->gen_bibit, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_id_asal_bibit":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `id` AS `LinkFld`, `id` AS `DispFld`, `tgl_tanam` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tanam_bibit`";
				$sWhereWrk = "";
				$fld->LookupFilters = array("df2" => "0");
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->id_asal_bibit, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$sSqlWrk .= " ORDER BY `id` DESC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
			}
		}
	}

	// Setup AutoSuggest filters of a field
	function SetupAutoSuggestFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		if ($pageId == "list") {
			switch ($fld->FldVar) {
			}
		} elseif ($pageId == "extbs") {
			switch ($fld->FldVar) {
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($tanam_bibit_list)) $tanam_bibit_list = new ctanam_bibit_list();

// Page init
$tanam_bibit_list->Page_Init();

// Page main
$tanam_bibit_list->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tanam_bibit_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if ($tanam_bibit->Export == "") { ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "list";
var CurrentForm = ftanam_bibitlist = new ew_Form("ftanam_bibitlist", "list");
ftanam_bibitlist.FormKeyCountName = '<?php echo $tanam_bibit_list->FormKeyCountName ?>';

// Form_CustomValidate event
ftanam_bibitlist.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
ftanam_bibitlist.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ftanam_bibitlist.Lists["x_jenis_lahan"] = {"LinkField":"x_jenis_lahan_bibit","Ajax":true,"AutoFill":false,"DisplayFields":["x_jenis_lahan_bibit","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"jenis_lahan_bibit"};
ftanam_bibitlist.Lists["x_jenis_lahan"].Data = "<?php echo $tanam_bibit_list->jenis_lahan->LookupFilterQuery(FALSE, "list") ?>";
ftanam_bibitlist.Lists["x_varietas"] = {"LinkField":"x_var_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_var_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"varietas"};
ftanam_bibitlist.Lists["x_varietas"].Data = "<?php echo $tanam_bibit_list->varietas->LookupFilterQuery(FALSE, "list") ?>";
ftanam_bibitlist.Lists["x_id_kontrak_tanam"] = {"LinkField":"x_k_id_kontrak","Ajax":true,"AutoFill":false,"DisplayFields":["x_k_id_kontrak","x_k_tgl_tanam","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kontrak"};
ftanam_bibitlist.Lists["x_id_kontrak_tanam"].Data = "<?php echo $tanam_bibit_list->id_kontrak_tanam->LookupFilterQuery(FALSE, "list") ?>";
ftanam_bibitlist.Lists["x_gen_bibit"] = {"LinkField":"x_id_gen","Ajax":true,"AutoFill":false,"DisplayFields":["x_id_gen","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"generasi_bibit"};
ftanam_bibitlist.Lists["x_gen_bibit"].Data = "<?php echo $tanam_bibit_list->gen_bibit->LookupFilterQuery(FALSE, "list") ?>";
ftanam_bibitlist.Lists["x_id_asal_bibit"] = {"LinkField":"x_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_id","x_tgl_tanam","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"tanam_bibit"};
ftanam_bibitlist.Lists["x_id_asal_bibit"].Data = "<?php echo $tanam_bibit_list->id_asal_bibit->LookupFilterQuery(FALSE, "list") ?>";

// Form object for search
var CurrentSearchForm = ftanam_bibitlistsrch = new ew_Form("ftanam_bibitlistsrch");

// Validate function for search
ftanam_bibitlistsrch.Validate = function(fobj) {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	fobj = fobj || this.Form;
	var infix = "";
	elm = this.GetElements("x" + infix + "_tgl_tanam");
	if (elm && !ew_CheckDateDef(elm.value))
		return this.OnError(elm, "<?php echo ew_JsEncode2($tanam_bibit->tgl_tanam->FldErrMsg()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
ftanam_bibitlistsrch.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
ftanam_bibitlistsrch.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ftanam_bibitlistsrch.Lists["x_jenis_lahan"] = {"LinkField":"x_jenis_lahan_bibit","Ajax":true,"AutoFill":false,"DisplayFields":["x_jenis_lahan_bibit","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"jenis_lahan_bibit"};
ftanam_bibitlistsrch.Lists["x_jenis_lahan"].Data = "<?php echo $tanam_bibit_list->jenis_lahan->LookupFilterQuery(FALSE, "extbs") ?>";
ftanam_bibitlistsrch.Lists["x_varietas"] = {"LinkField":"x_var_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_var_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"varietas"};
ftanam_bibitlistsrch.Lists["x_varietas"].Data = "<?php echo $tanam_bibit_list->varietas->LookupFilterQuery(FALSE, "extbs") ?>";
ftanam_bibitlistsrch.Lists["x_id_kontrak_tanam"] = {"LinkField":"x_k_id_kontrak","Ajax":true,"AutoFill":false,"DisplayFields":["x_k_id_kontrak","x_k_tgl_tanam","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kontrak"};
ftanam_bibitlistsrch.Lists["x_id_kontrak_tanam"].Data = "<?php echo $tanam_bibit_list->id_kontrak_tanam->LookupFilterQuery(FALSE, "extbs") ?>";
ftanam_bibitlistsrch.Lists["x_gen_bibit"] = {"LinkField":"x_id_gen","Ajax":true,"AutoFill":false,"DisplayFields":["x_id_gen","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"generasi_bibit"};
ftanam_bibitlistsrch.Lists["x_gen_bibit"].Data = "<?php echo $tanam_bibit_list->gen_bibit->LookupFilterQuery(FALSE, "extbs") ?>";
ftanam_bibitlistsrch.Lists["x_id_asal_bibit"] = {"LinkField":"x_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_id","x_tgl_tanam","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"tanam_bibit"};
ftanam_bibitlistsrch.Lists["x_id_asal_bibit"].Data = "<?php echo $tanam_bibit_list->id_asal_bibit->LookupFilterQuery(FALSE, "extbs") ?>";

// Init search panel as collapsed
if (ftanam_bibitlistsrch) ftanam_bibitlistsrch.InitSearchPanel = true;
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if ($tanam_bibit->Export == "") { ?>
<div class="ewToolbar">
<?php if ($tanam_bibit_list->TotalRecs > 0 && $tanam_bibit_list->ExportOptions->Visible()) { ?>
<?php $tanam_bibit_list->ExportOptions->Render("body") ?>
<?php } ?>
<?php if ($tanam_bibit_list->SearchOptions->Visible()) { ?>
<?php $tanam_bibit_list->SearchOptions->Render("body") ?>
<?php } ?>
<?php if ($tanam_bibit_list->FilterOptions->Visible()) { ?>
<?php $tanam_bibit_list->FilterOptions->Render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
	$bSelectLimit = $tanam_bibit_list->UseSelectLimit;
	if ($bSelectLimit) {
		if ($tanam_bibit_list->TotalRecs <= 0)
			$tanam_bibit_list->TotalRecs = $tanam_bibit->ListRecordCount();
	} else {
		if (!$tanam_bibit_list->Recordset && ($tanam_bibit_list->Recordset = $tanam_bibit_list->LoadRecordset()))
			$tanam_bibit_list->TotalRecs = $tanam_bibit_list->Recordset->RecordCount();
	}
	$tanam_bibit_list->StartRec = 1;
	if ($tanam_bibit_list->DisplayRecs <= 0 || ($tanam_bibit->Export <> "" && $tanam_bibit->ExportAll)) // Display all records
		$tanam_bibit_list->DisplayRecs = $tanam_bibit_list->TotalRecs;
	if (!($tanam_bibit->Export <> "" && $tanam_bibit->ExportAll))
		$tanam_bibit_list->SetupStartRec(); // Set up start record position
	if ($bSelectLimit)
		$tanam_bibit_list->Recordset = $tanam_bibit_list->LoadRecordset($tanam_bibit_list->StartRec-1, $tanam_bibit_list->DisplayRecs);

	// Set no record found message
	if ($tanam_bibit->CurrentAction == "" && $tanam_bibit_list->TotalRecs == 0) {
		if (!$Security->CanList())
			$tanam_bibit_list->setWarningMessage(ew_DeniedMsg());
		if ($tanam_bibit_list->SearchWhere == "0=101")
			$tanam_bibit_list->setWarningMessage($Language->Phrase("EnterSearchCriteria"));
		else
			$tanam_bibit_list->setWarningMessage($Language->Phrase("NoRecord"));
	}
$tanam_bibit_list->RenderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if ($tanam_bibit->Export == "" && $tanam_bibit->CurrentAction == "") { ?>
<form name="ftanam_bibitlistsrch" id="ftanam_bibitlistsrch" class="form-inline ewForm ewExtSearchForm" action="<?php echo ew_CurrentPage() ?>">
<?php $SearchPanelClass = ($tanam_bibit_list->SearchWhere <> "") ? " in" : ""; ?>
<div id="ftanam_bibitlistsrch_SearchPanel" class="ewSearchPanel collapse<?php echo $SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="tanam_bibit">
	<div class="ewBasicSearch">
<?php
if ($gsSearchError == "")
	$tanam_bibit_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$tanam_bibit->RowType = EW_ROWTYPE_SEARCH;

// Render row
$tanam_bibit->ResetAttrs();
$tanam_bibit_list->RenderRow();
?>
<div id="xsr_1" class="ewRow">
<?php if ($tanam_bibit->tgl_tanam->Visible) { // tgl_tanam ?>
	<div id="xsc_tgl_tanam" class="ewCell form-group">
		<label for="x_tgl_tanam" class="ewSearchCaption ewLabel"><?php echo $tanam_bibit->tgl_tanam->FldCaption() ?></label>
		<span class="ewSearchOperator"><select name="z_tgl_tanam" id="z_tgl_tanam" class="form-control" onchange="ewForms(this).SrchOprChanged(this);"><option value="="<?php echo ($tanam_bibit->tgl_tanam->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->Phrase("EQUAL") ?></option><option value="<>"<?php echo ($tanam_bibit->tgl_tanam->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->Phrase("<>") ?></option><option value="<"<?php echo ($tanam_bibit->tgl_tanam->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->Phrase("<") ?></option><option value="<="<?php echo ($tanam_bibit->tgl_tanam->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->Phrase("<=") ?></option><option value=">"<?php echo ($tanam_bibit->tgl_tanam->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->Phrase(">") ?></option><option value=">="<?php echo ($tanam_bibit->tgl_tanam->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->Phrase(">=") ?></option><option value="IS NULL"<?php echo ($tanam_bibit->tgl_tanam->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->Phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($tanam_bibit->tgl_tanam->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->Phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($tanam_bibit->tgl_tanam->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->Phrase("BETWEEN") ?></option></select></span>
		<span class="ewSearchField">
<input type="text" data-table="tanam_bibit" data-field="x_tgl_tanam" name="x_tgl_tanam" id="x_tgl_tanam" placeholder="<?php echo ew_HtmlEncode($tanam_bibit->tgl_tanam->getPlaceHolder()) ?>" value="<?php echo $tanam_bibit->tgl_tanam->EditValue ?>"<?php echo $tanam_bibit->tgl_tanam->EditAttributes() ?>>
<?php if (!$tanam_bibit->tgl_tanam->ReadOnly && !$tanam_bibit->tgl_tanam->Disabled && !isset($tanam_bibit->tgl_tanam->EditAttrs["readonly"]) && !isset($tanam_bibit->tgl_tanam->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("ftanam_bibitlistsrch", "x_tgl_tanam", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		<span class="ewSearchCond btw1_tgl_tanam" style="display: none">&nbsp;<?php echo $Language->Phrase("AND") ?>&nbsp;</span>
		<span class="ewSearchField btw1_tgl_tanam" style="display: none">
<input type="text" data-table="tanam_bibit" data-field="x_tgl_tanam" name="y_tgl_tanam" id="y_tgl_tanam" placeholder="<?php echo ew_HtmlEncode($tanam_bibit->tgl_tanam->getPlaceHolder()) ?>" value="<?php echo $tanam_bibit->tgl_tanam->EditValue2 ?>"<?php echo $tanam_bibit->tgl_tanam->EditAttributes() ?>>
<?php if (!$tanam_bibit->tgl_tanam->ReadOnly && !$tanam_bibit->tgl_tanam->Disabled && !isset($tanam_bibit->tgl_tanam->EditAttrs["readonly"]) && !isset($tanam_bibit->tgl_tanam->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("ftanam_bibitlistsrch", "y_tgl_tanam", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ewRow">
<?php if ($tanam_bibit->jenis_lahan->Visible) { // jenis_lahan ?>
	<div id="xsc_jenis_lahan" class="ewCell form-group">
		<label class="ewSearchCaption ewLabel"><?php echo $tanam_bibit->jenis_lahan->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_jenis_lahan" id="z_jenis_lahan" value="LIKE"></span>
		<span class="ewSearchField">
<div id="tp_x_jenis_lahan" class="ewTemplate"><input type="radio" data-table="tanam_bibit" data-field="x_jenis_lahan" data-value-separator="<?php echo $tanam_bibit->jenis_lahan->DisplayValueSeparatorAttribute() ?>" name="x_jenis_lahan" id="x_jenis_lahan" value="{value}"<?php echo $tanam_bibit->jenis_lahan->EditAttributes() ?>></div>
<div id="dsl_x_jenis_lahan" data-repeatcolumn="5" class="ewItemList" style="display: none;"><div>
<?php echo $tanam_bibit->jenis_lahan->RadioButtonListHtml(FALSE, "x_jenis_lahan") ?>
</div></div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ewRow">
<?php if ($tanam_bibit->varietas->Visible) { // varietas ?>
	<div id="xsc_varietas" class="ewCell form-group">
		<label for="x_varietas" class="ewSearchCaption ewLabel"><?php echo $tanam_bibit->varietas->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_varietas" id="z_varietas" value="="></span>
		<span class="ewSearchField">
<select data-table="tanam_bibit" data-field="x_varietas" data-value-separator="<?php echo $tanam_bibit->varietas->DisplayValueSeparatorAttribute() ?>" id="x_varietas" name="x_varietas"<?php echo $tanam_bibit->varietas->EditAttributes() ?>>
<?php echo $tanam_bibit->varietas->SelectOptionListHtml("x_varietas") ?>
</select>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ewRow">
<?php if ($tanam_bibit->id_kontrak_tanam->Visible) { // id_kontrak_tanam ?>
	<div id="xsc_id_kontrak_tanam" class="ewCell form-group">
		<label for="x_id_kontrak_tanam" class="ewSearchCaption ewLabel"><?php echo $tanam_bibit->id_kontrak_tanam->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_id_kontrak_tanam" id="z_id_kontrak_tanam" value="LIKE"></span>
		<span class="ewSearchField">
<select data-table="tanam_bibit" data-field="x_id_kontrak_tanam" data-value-separator="<?php echo $tanam_bibit->id_kontrak_tanam->DisplayValueSeparatorAttribute() ?>" id="x_id_kontrak_tanam" name="x_id_kontrak_tanam"<?php echo $tanam_bibit->id_kontrak_tanam->EditAttributes() ?>>
<?php echo $tanam_bibit->id_kontrak_tanam->SelectOptionListHtml("x_id_kontrak_tanam") ?>
</select>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_5" class="ewRow">
<?php if ($tanam_bibit->gen_bibit->Visible) { // gen_bibit ?>
	<div id="xsc_gen_bibit" class="ewCell form-group">
		<label for="x_gen_bibit" class="ewSearchCaption ewLabel"><?php echo $tanam_bibit->gen_bibit->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_gen_bibit" id="z_gen_bibit" value="LIKE"></span>
		<span class="ewSearchField">
<select data-table="tanam_bibit" data-field="x_gen_bibit" data-value-separator="<?php echo $tanam_bibit->gen_bibit->DisplayValueSeparatorAttribute() ?>" id="x_gen_bibit" name="x_gen_bibit"<?php echo $tanam_bibit->gen_bibit->EditAttributes() ?>>
<?php echo $tanam_bibit->gen_bibit->SelectOptionListHtml("x_gen_bibit") ?>
</select>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_6" class="ewRow">
<?php if ($tanam_bibit->id_asal_bibit->Visible) { // id_asal_bibit ?>
	<div id="xsc_id_asal_bibit" class="ewCell form-group">
		<label for="x_id_asal_bibit" class="ewSearchCaption ewLabel"><?php echo $tanam_bibit->id_asal_bibit->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_id_asal_bibit" id="z_id_asal_bibit" value="="></span>
		<span class="ewSearchField">
<select data-table="tanam_bibit" data-field="x_id_asal_bibit" data-value-separator="<?php echo $tanam_bibit->id_asal_bibit->DisplayValueSeparatorAttribute() ?>" id="x_id_asal_bibit" name="x_id_asal_bibit"<?php echo $tanam_bibit->id_asal_bibit->EditAttributes() ?>>
<?php echo $tanam_bibit->id_asal_bibit->SelectOptionListHtml("x_id_asal_bibit") ?>
</select>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_7" class="ewRow">
	<div class="ewQuickSearch input-group">
	<input type="text" name="<?php echo EW_TABLE_BASIC_SEARCH ?>" id="<?php echo EW_TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo ew_HtmlEncode($tanam_bibit_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo ew_HtmlEncode($Language->Phrase("Search")) ?>">
	<input type="hidden" name="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo ew_HtmlEncode($tanam_bibit_list->BasicSearch->getType()) ?>">
	<div class="input-group-btn">
		<button type="button" data-toggle="dropdown" class="btn btn-default"><span id="searchtype"><?php echo $tanam_bibit_list->BasicSearch->getTypeNameShort() ?></span><span class="caret"></span></button>
		<ul class="dropdown-menu pull-right" role="menu">
			<li<?php if ($tanam_bibit_list->BasicSearch->getType() == "") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this)"><?php echo $Language->Phrase("QuickSearchAuto") ?></a></li>
			<li<?php if ($tanam_bibit_list->BasicSearch->getType() == "=") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'=')"><?php echo $Language->Phrase("QuickSearchExact") ?></a></li>
			<li<?php if ($tanam_bibit_list->BasicSearch->getType() == "AND") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'AND')"><?php echo $Language->Phrase("QuickSearchAll") ?></a></li>
			<li<?php if ($tanam_bibit_list->BasicSearch->getType() == "OR") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'OR')"><?php echo $Language->Phrase("QuickSearchAny") ?></a></li>
		</ul>
	<button class="btn btn-primary ewButton" name="btnsubmit" id="btnsubmit" type="submit"><?php echo $Language->Phrase("SearchBtn") ?></button>
	</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $tanam_bibit_list->ShowPageHeader(); ?>
<?php
$tanam_bibit_list->ShowMessage();
?>
<?php if ($tanam_bibit_list->TotalRecs > 0 || $tanam_bibit->CurrentAction <> "") { ?>
<div class="box ewBox ewGrid<?php if ($tanam_bibit_list->IsAddOrEdit()) { ?> ewGridAddEdit<?php } ?> tanam_bibit">
<?php if ($tanam_bibit->Export == "") { ?>
<div class="box-header ewGridUpperPanel">
<?php if ($tanam_bibit->CurrentAction <> "gridadd" && $tanam_bibit->CurrentAction <> "gridedit") { ?>
<form name="ewPagerForm" class="form-inline ewForm ewPagerForm" action="<?php echo ew_CurrentPage() ?>">
<?php if (!isset($tanam_bibit_list->Pager)) $tanam_bibit_list->Pager = new cNumericPager($tanam_bibit_list->StartRec, $tanam_bibit_list->DisplayRecs, $tanam_bibit_list->TotalRecs, $tanam_bibit_list->RecRange, $tanam_bibit_list->AutoHidePager) ?>
<?php if ($tanam_bibit_list->Pager->RecordCount > 0 && $tanam_bibit_list->Pager->Visible) { ?>
<div class="ewPager">
<div class="ewNumericPage"><ul class="pagination">
	<?php if ($tanam_bibit_list->Pager->FirstButton->Enabled) { ?>
	<li><a href="<?php echo $tanam_bibit_list->PageUrl() ?>start=<?php echo $tanam_bibit_list->Pager->FirstButton->Start ?>"><?php echo $Language->Phrase("PagerFirst") ?></a></li>
	<?php } ?>
	<?php if ($tanam_bibit_list->Pager->PrevButton->Enabled) { ?>
	<li><a href="<?php echo $tanam_bibit_list->PageUrl() ?>start=<?php echo $tanam_bibit_list->Pager->PrevButton->Start ?>"><?php echo $Language->Phrase("PagerPrevious") ?></a></li>
	<?php } ?>
	<?php foreach ($tanam_bibit_list->Pager->Items as $PagerItem) { ?>
		<li<?php if (!$PagerItem->Enabled) { echo " class=\" active\""; } ?>><a href="<?php if ($PagerItem->Enabled) { echo $tanam_bibit_list->PageUrl() . "start=" . $PagerItem->Start; } else { echo "#"; } ?>"><?php echo $PagerItem->Text ?></a></li>
	<?php } ?>
	<?php if ($tanam_bibit_list->Pager->NextButton->Enabled) { ?>
	<li><a href="<?php echo $tanam_bibit_list->PageUrl() ?>start=<?php echo $tanam_bibit_list->Pager->NextButton->Start ?>"><?php echo $Language->Phrase("PagerNext") ?></a></li>
	<?php } ?>
	<?php if ($tanam_bibit_list->Pager->LastButton->Enabled) { ?>
	<li><a href="<?php echo $tanam_bibit_list->PageUrl() ?>start=<?php echo $tanam_bibit_list->Pager->LastButton->Start ?>"><?php echo $Language->Phrase("PagerLast") ?></a></li>
	<?php } ?>
</ul></div>
</div>
<?php } ?>
<?php if ($tanam_bibit_list->Pager->RecordCount > 0) { ?>
<div class="ewPager ewRec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $tanam_bibit_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $tanam_bibit_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $tanam_bibit_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ewListOtherOptions">
<?php
	foreach ($tanam_bibit_list->OtherOptions as &$option)
		$option->Render("body");
?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="ftanam_bibitlist" id="ftanam_bibitlist" class="form-inline ewForm ewListForm" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($tanam_bibit_list->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $tanam_bibit_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tanam_bibit">
<div id="gmp_tanam_bibit" class="<?php if (ew_IsResponsiveLayout()) { ?>table-responsive <?php } ?>ewGridMiddlePanel">
<?php if ($tanam_bibit_list->TotalRecs > 0 || $tanam_bibit->CurrentAction == "gridedit") { ?>
<table id="tbl_tanam_bibitlist" class="table ewTable">
<thead>
	<tr class="ewTableHeader">
<?php

// Header row
$tanam_bibit_list->RowType = EW_ROWTYPE_HEADER;

// Render list options
$tanam_bibit_list->RenderListOptions();

// Render list options (header, left)
$tanam_bibit_list->ListOptions->Render("header", "left");
?>
<?php if ($tanam_bibit->id->Visible) { // id ?>
	<?php if ($tanam_bibit->SortUrl($tanam_bibit->id) == "") { ?>
		<th data-name="id" class="<?php echo $tanam_bibit->id->HeaderCellClass() ?>"><div id="elh_tanam_bibit_id" class="tanam_bibit_id"><div class="ewTableHeaderCaption"><?php echo $tanam_bibit->id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $tanam_bibit->id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $tanam_bibit->SortUrl($tanam_bibit->id) ?>',1);"><div id="elh_tanam_bibit_id" class="tanam_bibit_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $tanam_bibit->id->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($tanam_bibit->id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($tanam_bibit->id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tanam_bibit->tgl_tanam->Visible) { // tgl_tanam ?>
	<?php if ($tanam_bibit->SortUrl($tanam_bibit->tgl_tanam) == "") { ?>
		<th data-name="tgl_tanam" class="<?php echo $tanam_bibit->tgl_tanam->HeaderCellClass() ?>"><div id="elh_tanam_bibit_tgl_tanam" class="tanam_bibit_tgl_tanam"><div class="ewTableHeaderCaption"><?php echo $tanam_bibit->tgl_tanam->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tgl_tanam" class="<?php echo $tanam_bibit->tgl_tanam->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $tanam_bibit->SortUrl($tanam_bibit->tgl_tanam) ?>',1);"><div id="elh_tanam_bibit_tgl_tanam" class="tanam_bibit_tgl_tanam">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $tanam_bibit->tgl_tanam->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($tanam_bibit->tgl_tanam->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($tanam_bibit->tgl_tanam->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tanam_bibit->jenis_lahan->Visible) { // jenis_lahan ?>
	<?php if ($tanam_bibit->SortUrl($tanam_bibit->jenis_lahan) == "") { ?>
		<th data-name="jenis_lahan" class="<?php echo $tanam_bibit->jenis_lahan->HeaderCellClass() ?>"><div id="elh_tanam_bibit_jenis_lahan" class="tanam_bibit_jenis_lahan"><div class="ewTableHeaderCaption"><?php echo $tanam_bibit->jenis_lahan->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jenis_lahan" class="<?php echo $tanam_bibit->jenis_lahan->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $tanam_bibit->SortUrl($tanam_bibit->jenis_lahan) ?>',1);"><div id="elh_tanam_bibit_jenis_lahan" class="tanam_bibit_jenis_lahan">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $tanam_bibit->jenis_lahan->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($tanam_bibit->jenis_lahan->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($tanam_bibit->jenis_lahan->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tanam_bibit->varietas->Visible) { // varietas ?>
	<?php if ($tanam_bibit->SortUrl($tanam_bibit->varietas) == "") { ?>
		<th data-name="varietas" class="<?php echo $tanam_bibit->varietas->HeaderCellClass() ?>"><div id="elh_tanam_bibit_varietas" class="tanam_bibit_varietas"><div class="ewTableHeaderCaption"><?php echo $tanam_bibit->varietas->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="varietas" class="<?php echo $tanam_bibit->varietas->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $tanam_bibit->SortUrl($tanam_bibit->varietas) ?>',1);"><div id="elh_tanam_bibit_varietas" class="tanam_bibit_varietas">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $tanam_bibit->varietas->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($tanam_bibit->varietas->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($tanam_bibit->varietas->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tanam_bibit->jumlah_tanam->Visible) { // jumlah_tanam ?>
	<?php if ($tanam_bibit->SortUrl($tanam_bibit->jumlah_tanam) == "") { ?>
		<th data-name="jumlah_tanam" class="<?php echo $tanam_bibit->jumlah_tanam->HeaderCellClass() ?>"><div id="elh_tanam_bibit_jumlah_tanam" class="tanam_bibit_jumlah_tanam"><div class="ewTableHeaderCaption"><?php echo $tanam_bibit->jumlah_tanam->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jumlah_tanam" class="<?php echo $tanam_bibit->jumlah_tanam->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $tanam_bibit->SortUrl($tanam_bibit->jumlah_tanam) ?>',1);"><div id="elh_tanam_bibit_jumlah_tanam" class="tanam_bibit_jumlah_tanam">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $tanam_bibit->jumlah_tanam->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($tanam_bibit->jumlah_tanam->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($tanam_bibit->jumlah_tanam->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tanam_bibit->ket->Visible) { // ket ?>
	<?php if ($tanam_bibit->SortUrl($tanam_bibit->ket) == "") { ?>
		<th data-name="ket" class="<?php echo $tanam_bibit->ket->HeaderCellClass() ?>"><div id="elh_tanam_bibit_ket" class="tanam_bibit_ket"><div class="ewTableHeaderCaption"><?php echo $tanam_bibit->ket->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ket" class="<?php echo $tanam_bibit->ket->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $tanam_bibit->SortUrl($tanam_bibit->ket) ?>',1);"><div id="elh_tanam_bibit_ket" class="tanam_bibit_ket">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $tanam_bibit->ket->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($tanam_bibit->ket->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($tanam_bibit->ket->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tanam_bibit->id_kontrak_tanam->Visible) { // id_kontrak_tanam ?>
	<?php if ($tanam_bibit->SortUrl($tanam_bibit->id_kontrak_tanam) == "") { ?>
		<th data-name="id_kontrak_tanam" class="<?php echo $tanam_bibit->id_kontrak_tanam->HeaderCellClass() ?>"><div id="elh_tanam_bibit_id_kontrak_tanam" class="tanam_bibit_id_kontrak_tanam"><div class="ewTableHeaderCaption"><?php echo $tanam_bibit->id_kontrak_tanam->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id_kontrak_tanam" class="<?php echo $tanam_bibit->id_kontrak_tanam->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $tanam_bibit->SortUrl($tanam_bibit->id_kontrak_tanam) ?>',1);"><div id="elh_tanam_bibit_id_kontrak_tanam" class="tanam_bibit_id_kontrak_tanam">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $tanam_bibit->id_kontrak_tanam->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($tanam_bibit->id_kontrak_tanam->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($tanam_bibit->id_kontrak_tanam->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tanam_bibit->gen_bibit->Visible) { // gen_bibit ?>
	<?php if ($tanam_bibit->SortUrl($tanam_bibit->gen_bibit) == "") { ?>
		<th data-name="gen_bibit" class="<?php echo $tanam_bibit->gen_bibit->HeaderCellClass() ?>"><div id="elh_tanam_bibit_gen_bibit" class="tanam_bibit_gen_bibit"><div class="ewTableHeaderCaption"><?php echo $tanam_bibit->gen_bibit->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gen_bibit" class="<?php echo $tanam_bibit->gen_bibit->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $tanam_bibit->SortUrl($tanam_bibit->gen_bibit) ?>',1);"><div id="elh_tanam_bibit_gen_bibit" class="tanam_bibit_gen_bibit">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $tanam_bibit->gen_bibit->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($tanam_bibit->gen_bibit->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($tanam_bibit->gen_bibit->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tanam_bibit->id_asal_bibit->Visible) { // id_asal_bibit ?>
	<?php if ($tanam_bibit->SortUrl($tanam_bibit->id_asal_bibit) == "") { ?>
		<th data-name="id_asal_bibit" class="<?php echo $tanam_bibit->id_asal_bibit->HeaderCellClass() ?>"><div id="elh_tanam_bibit_id_asal_bibit" class="tanam_bibit_id_asal_bibit"><div class="ewTableHeaderCaption"><?php echo $tanam_bibit->id_asal_bibit->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id_asal_bibit" class="<?php echo $tanam_bibit->id_asal_bibit->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $tanam_bibit->SortUrl($tanam_bibit->id_asal_bibit) ?>',1);"><div id="elh_tanam_bibit_id_asal_bibit" class="tanam_bibit_id_asal_bibit">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $tanam_bibit->id_asal_bibit->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($tanam_bibit->id_asal_bibit->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($tanam_bibit->id_asal_bibit->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tanam_bibit->jumlah_panen_stek->Visible) { // jumlah_panen_stek ?>
	<?php if ($tanam_bibit->SortUrl($tanam_bibit->jumlah_panen_stek) == "") { ?>
		<th data-name="jumlah_panen_stek" class="<?php echo $tanam_bibit->jumlah_panen_stek->HeaderCellClass() ?>"><div id="elh_tanam_bibit_jumlah_panen_stek" class="tanam_bibit_jumlah_panen_stek"><div class="ewTableHeaderCaption"><?php echo $tanam_bibit->jumlah_panen_stek->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jumlah_panen_stek" class="<?php echo $tanam_bibit->jumlah_panen_stek->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $tanam_bibit->SortUrl($tanam_bibit->jumlah_panen_stek) ?>',1);"><div id="elh_tanam_bibit_jumlah_panen_stek" class="tanam_bibit_jumlah_panen_stek">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $tanam_bibit->jumlah_panen_stek->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($tanam_bibit->jumlah_panen_stek->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($tanam_bibit->jumlah_panen_stek->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$tanam_bibit_list->ListOptions->Render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($tanam_bibit->ExportAll && $tanam_bibit->Export <> "") {
	$tanam_bibit_list->StopRec = $tanam_bibit_list->TotalRecs;
} else {

	// Set the last record to display
	if ($tanam_bibit_list->TotalRecs > $tanam_bibit_list->StartRec + $tanam_bibit_list->DisplayRecs - 1)
		$tanam_bibit_list->StopRec = $tanam_bibit_list->StartRec + $tanam_bibit_list->DisplayRecs - 1;
	else
		$tanam_bibit_list->StopRec = $tanam_bibit_list->TotalRecs;
}
$tanam_bibit_list->RecCnt = $tanam_bibit_list->StartRec - 1;
if ($tanam_bibit_list->Recordset && !$tanam_bibit_list->Recordset->EOF) {
	$tanam_bibit_list->Recordset->MoveFirst();
	$bSelectLimit = $tanam_bibit_list->UseSelectLimit;
	if (!$bSelectLimit && $tanam_bibit_list->StartRec > 1)
		$tanam_bibit_list->Recordset->Move($tanam_bibit_list->StartRec - 1);
} elseif (!$tanam_bibit->AllowAddDeleteRow && $tanam_bibit_list->StopRec == 0) {
	$tanam_bibit_list->StopRec = $tanam_bibit->GridAddRowCount;
}

// Initialize aggregate
$tanam_bibit->RowType = EW_ROWTYPE_AGGREGATEINIT;
$tanam_bibit->ResetAttrs();
$tanam_bibit_list->RenderRow();
while ($tanam_bibit_list->RecCnt < $tanam_bibit_list->StopRec) {
	$tanam_bibit_list->RecCnt++;
	if (intval($tanam_bibit_list->RecCnt) >= intval($tanam_bibit_list->StartRec)) {
		$tanam_bibit_list->RowCnt++;

		// Set up key count
		$tanam_bibit_list->KeyCount = $tanam_bibit_list->RowIndex;

		// Init row class and style
		$tanam_bibit->ResetAttrs();
		$tanam_bibit->CssClass = "";
		if ($tanam_bibit->CurrentAction == "gridadd") {
		} else {
			$tanam_bibit_list->LoadRowValues($tanam_bibit_list->Recordset); // Load row values
		}
		$tanam_bibit->RowType = EW_ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$tanam_bibit->RowAttrs = array_merge($tanam_bibit->RowAttrs, array('data-rowindex'=>$tanam_bibit_list->RowCnt, 'id'=>'r' . $tanam_bibit_list->RowCnt . '_tanam_bibit', 'data-rowtype'=>$tanam_bibit->RowType));

		// Render row
		$tanam_bibit_list->RenderRow();

		// Render list options
		$tanam_bibit_list->RenderListOptions();
?>
	<tr<?php echo $tanam_bibit->RowAttributes() ?>>
<?php

// Render list options (body, left)
$tanam_bibit_list->ListOptions->Render("body", "left", $tanam_bibit_list->RowCnt);
?>
	<?php if ($tanam_bibit->id->Visible) { // id ?>
		<td data-name="id"<?php echo $tanam_bibit->id->CellAttributes() ?>>
<span id="el<?php echo $tanam_bibit_list->RowCnt ?>_tanam_bibit_id" class="tanam_bibit_id">
<span<?php echo $tanam_bibit->id->ViewAttributes() ?>>
<?php echo $tanam_bibit->id->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tanam_bibit->tgl_tanam->Visible) { // tgl_tanam ?>
		<td data-name="tgl_tanam"<?php echo $tanam_bibit->tgl_tanam->CellAttributes() ?>>
<span id="el<?php echo $tanam_bibit_list->RowCnt ?>_tanam_bibit_tgl_tanam" class="tanam_bibit_tgl_tanam">
<span<?php echo $tanam_bibit->tgl_tanam->ViewAttributes() ?>>
<?php echo $tanam_bibit->tgl_tanam->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tanam_bibit->jenis_lahan->Visible) { // jenis_lahan ?>
		<td data-name="jenis_lahan"<?php echo $tanam_bibit->jenis_lahan->CellAttributes() ?>>
<span id="el<?php echo $tanam_bibit_list->RowCnt ?>_tanam_bibit_jenis_lahan" class="tanam_bibit_jenis_lahan">
<span<?php echo $tanam_bibit->jenis_lahan->ViewAttributes() ?>>
<?php echo $tanam_bibit->jenis_lahan->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tanam_bibit->varietas->Visible) { // varietas ?>
		<td data-name="varietas"<?php echo $tanam_bibit->varietas->CellAttributes() ?>>
<span id="el<?php echo $tanam_bibit_list->RowCnt ?>_tanam_bibit_varietas" class="tanam_bibit_varietas">
<span<?php echo $tanam_bibit->varietas->ViewAttributes() ?>>
<?php echo $tanam_bibit->varietas->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tanam_bibit->jumlah_tanam->Visible) { // jumlah_tanam ?>
		<td data-name="jumlah_tanam"<?php echo $tanam_bibit->jumlah_tanam->CellAttributes() ?>>
<span id="el<?php echo $tanam_bibit_list->RowCnt ?>_tanam_bibit_jumlah_tanam" class="tanam_bibit_jumlah_tanam">
<span<?php echo $tanam_bibit->jumlah_tanam->ViewAttributes() ?>>
<?php echo $tanam_bibit->jumlah_tanam->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tanam_bibit->ket->Visible) { // ket ?>
		<td data-name="ket"<?php echo $tanam_bibit->ket->CellAttributes() ?>>
<span id="el<?php echo $tanam_bibit_list->RowCnt ?>_tanam_bibit_ket" class="tanam_bibit_ket">
<span<?php echo $tanam_bibit->ket->ViewAttributes() ?>>
<?php echo $tanam_bibit->ket->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tanam_bibit->id_kontrak_tanam->Visible) { // id_kontrak_tanam ?>
		<td data-name="id_kontrak_tanam"<?php echo $tanam_bibit->id_kontrak_tanam->CellAttributes() ?>>
<span id="el<?php echo $tanam_bibit_list->RowCnt ?>_tanam_bibit_id_kontrak_tanam" class="tanam_bibit_id_kontrak_tanam">
<span<?php echo $tanam_bibit->id_kontrak_tanam->ViewAttributes() ?>>
<?php echo $tanam_bibit->id_kontrak_tanam->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tanam_bibit->gen_bibit->Visible) { // gen_bibit ?>
		<td data-name="gen_bibit"<?php echo $tanam_bibit->gen_bibit->CellAttributes() ?>>
<span id="el<?php echo $tanam_bibit_list->RowCnt ?>_tanam_bibit_gen_bibit" class="tanam_bibit_gen_bibit">
<span<?php echo $tanam_bibit->gen_bibit->ViewAttributes() ?>>
<?php echo $tanam_bibit->gen_bibit->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tanam_bibit->id_asal_bibit->Visible) { // id_asal_bibit ?>
		<td data-name="id_asal_bibit"<?php echo $tanam_bibit->id_asal_bibit->CellAttributes() ?>>
<span id="el<?php echo $tanam_bibit_list->RowCnt ?>_tanam_bibit_id_asal_bibit" class="tanam_bibit_id_asal_bibit">
<span<?php echo $tanam_bibit->id_asal_bibit->ViewAttributes() ?>>
<?php echo $tanam_bibit->id_asal_bibit->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tanam_bibit->jumlah_panen_stek->Visible) { // jumlah_panen_stek ?>
		<td data-name="jumlah_panen_stek"<?php echo $tanam_bibit->jumlah_panen_stek->CellAttributes() ?>>
<span id="el<?php echo $tanam_bibit_list->RowCnt ?>_tanam_bibit_jumlah_panen_stek" class="tanam_bibit_jumlah_panen_stek">
<span<?php echo $tanam_bibit->jumlah_panen_stek->ViewAttributes() ?>>
<?php echo $tanam_bibit->jumlah_panen_stek->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$tanam_bibit_list->ListOptions->Render("body", "right", $tanam_bibit_list->RowCnt);
?>
	</tr>
<?php
	}
	if ($tanam_bibit->CurrentAction <> "gridadd")
		$tanam_bibit_list->Recordset->MoveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$tanam_bibit->RowType = EW_ROWTYPE_AGGREGATE;
$tanam_bibit->ResetAttrs();
$tanam_bibit_list->RenderRow();
?>
<?php if ($tanam_bibit_list->TotalRecs > 0 && ($tanam_bibit->CurrentAction <> "gridadd" && $tanam_bibit->CurrentAction <> "gridedit")) { ?>
<tfoot><!-- Table footer -->
	<tr class="ewTableFooter">
<?php

// Render list options
$tanam_bibit_list->RenderListOptions();

// Render list options (footer, left)
$tanam_bibit_list->ListOptions->Render("footer", "left");
?>
	<?php if ($tanam_bibit->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $tanam_bibit->id->FooterCellClass() ?>"><span id="elf_tanam_bibit_id" class="tanam_bibit_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($tanam_bibit->tgl_tanam->Visible) { // tgl_tanam ?>
		<td data-name="tgl_tanam" class="<?php echo $tanam_bibit->tgl_tanam->FooterCellClass() ?>"><span id="elf_tanam_bibit_tgl_tanam" class="tanam_bibit_tgl_tanam">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($tanam_bibit->jenis_lahan->Visible) { // jenis_lahan ?>
		<td data-name="jenis_lahan" class="<?php echo $tanam_bibit->jenis_lahan->FooterCellClass() ?>"><span id="elf_tanam_bibit_jenis_lahan" class="tanam_bibit_jenis_lahan">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($tanam_bibit->varietas->Visible) { // varietas ?>
		<td data-name="varietas" class="<?php echo $tanam_bibit->varietas->FooterCellClass() ?>"><span id="elf_tanam_bibit_varietas" class="tanam_bibit_varietas">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($tanam_bibit->jumlah_tanam->Visible) { // jumlah_tanam ?>
		<td data-name="jumlah_tanam" class="<?php echo $tanam_bibit->jumlah_tanam->FooterCellClass() ?>"><span id="elf_tanam_bibit_jumlah_tanam" class="tanam_bibit_jumlah_tanam">
<span class="ewAggregate"><?php echo $Language->Phrase("TOTAL") ?></span><span class="ewAggregateValue">
<?php echo $tanam_bibit->jumlah_tanam->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($tanam_bibit->ket->Visible) { // ket ?>
		<td data-name="ket" class="<?php echo $tanam_bibit->ket->FooterCellClass() ?>"><span id="elf_tanam_bibit_ket" class="tanam_bibit_ket">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($tanam_bibit->id_kontrak_tanam->Visible) { // id_kontrak_tanam ?>
		<td data-name="id_kontrak_tanam" class="<?php echo $tanam_bibit->id_kontrak_tanam->FooterCellClass() ?>"><span id="elf_tanam_bibit_id_kontrak_tanam" class="tanam_bibit_id_kontrak_tanam">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($tanam_bibit->gen_bibit->Visible) { // gen_bibit ?>
		<td data-name="gen_bibit" class="<?php echo $tanam_bibit->gen_bibit->FooterCellClass() ?>"><span id="elf_tanam_bibit_gen_bibit" class="tanam_bibit_gen_bibit">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($tanam_bibit->id_asal_bibit->Visible) { // id_asal_bibit ?>
		<td data-name="id_asal_bibit" class="<?php echo $tanam_bibit->id_asal_bibit->FooterCellClass() ?>"><span id="elf_tanam_bibit_id_asal_bibit" class="tanam_bibit_id_asal_bibit">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($tanam_bibit->jumlah_panen_stek->Visible) { // jumlah_panen_stek ?>
		<td data-name="jumlah_panen_stek" class="<?php echo $tanam_bibit->jumlah_panen_stek->FooterCellClass() ?>"><span id="elf_tanam_bibit_jumlah_panen_stek" class="tanam_bibit_jumlah_panen_stek">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$tanam_bibit_list->ListOptions->Render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table>
<?php } ?>
<?php if ($tanam_bibit->CurrentAction == "") { ?>
<input type="hidden" name="a_list" id="a_list" value="">
<?php } ?>
</div>
</form>
<?php

// Close recordset
if ($tanam_bibit_list->Recordset)
	$tanam_bibit_list->Recordset->Close();
?>
<?php if ($tanam_bibit->Export == "") { ?>
<div class="box-footer ewGridLowerPanel">
<?php if ($tanam_bibit->CurrentAction <> "gridadd" && $tanam_bibit->CurrentAction <> "gridedit") { ?>
<form name="ewPagerForm" class="ewForm form-inline ewPagerForm" action="<?php echo ew_CurrentPage() ?>">
<?php if (!isset($tanam_bibit_list->Pager)) $tanam_bibit_list->Pager = new cNumericPager($tanam_bibit_list->StartRec, $tanam_bibit_list->DisplayRecs, $tanam_bibit_list->TotalRecs, $tanam_bibit_list->RecRange, $tanam_bibit_list->AutoHidePager) ?>
<?php if ($tanam_bibit_list->Pager->RecordCount > 0 && $tanam_bibit_list->Pager->Visible) { ?>
<div class="ewPager">
<div class="ewNumericPage"><ul class="pagination">
	<?php if ($tanam_bibit_list->Pager->FirstButton->Enabled) { ?>
	<li><a href="<?php echo $tanam_bibit_list->PageUrl() ?>start=<?php echo $tanam_bibit_list->Pager->FirstButton->Start ?>"><?php echo $Language->Phrase("PagerFirst") ?></a></li>
	<?php } ?>
	<?php if ($tanam_bibit_list->Pager->PrevButton->Enabled) { ?>
	<li><a href="<?php echo $tanam_bibit_list->PageUrl() ?>start=<?php echo $tanam_bibit_list->Pager->PrevButton->Start ?>"><?php echo $Language->Phrase("PagerPrevious") ?></a></li>
	<?php } ?>
	<?php foreach ($tanam_bibit_list->Pager->Items as $PagerItem) { ?>
		<li<?php if (!$PagerItem->Enabled) { echo " class=\" active\""; } ?>><a href="<?php if ($PagerItem->Enabled) { echo $tanam_bibit_list->PageUrl() . "start=" . $PagerItem->Start; } else { echo "#"; } ?>"><?php echo $PagerItem->Text ?></a></li>
	<?php } ?>
	<?php if ($tanam_bibit_list->Pager->NextButton->Enabled) { ?>
	<li><a href="<?php echo $tanam_bibit_list->PageUrl() ?>start=<?php echo $tanam_bibit_list->Pager->NextButton->Start ?>"><?php echo $Language->Phrase("PagerNext") ?></a></li>
	<?php } ?>
	<?php if ($tanam_bibit_list->Pager->LastButton->Enabled) { ?>
	<li><a href="<?php echo $tanam_bibit_list->PageUrl() ?>start=<?php echo $tanam_bibit_list->Pager->LastButton->Start ?>"><?php echo $Language->Phrase("PagerLast") ?></a></li>
	<?php } ?>
</ul></div>
</div>
<?php } ?>
<?php if ($tanam_bibit_list->Pager->RecordCount > 0) { ?>
<div class="ewPager ewRec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $tanam_bibit_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $tanam_bibit_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $tanam_bibit_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ewListOtherOptions">
<?php
	foreach ($tanam_bibit_list->OtherOptions as &$option)
		$option->Render("body", "bottom");
?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div>
<?php } ?>
<?php if ($tanam_bibit_list->TotalRecs == 0 && $tanam_bibit->CurrentAction == "") { // Show other options ?>
<div class="ewListOtherOptions">
<?php
	foreach ($tanam_bibit_list->OtherOptions as &$option) {
		$option->ButtonClass = "";
		$option->Render("body", "");
	}
?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php if ($tanam_bibit->Export == "") { ?>
<script type="text/javascript">
ftanam_bibitlistsrch.FilterList = <?php echo $tanam_bibit_list->GetFilterList() ?>;
ftanam_bibitlistsrch.Init();
ftanam_bibitlist.Init();
</script>
<?php } ?>
<?php
$tanam_bibit_list->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<?php if ($tanam_bibit->Export == "") { ?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$tanam_bibit_list->Page_Terminate();
?>
