<?php
if (session_id() == "") session_start(); // Init session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg14.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql14.php") ?>
<?php include_once "phpfn14.php" ?>
<?php include_once "petaniinfo.php" ?>
<?php include_once "employeesinfo.php" ?>
<?php include_once "userfn14.php" ?>
<?php

//
// Page class
//

$petani_add = NULL; // Initialize page object first

class cpetani_add extends cpetani {

	// Page ID
	var $PageID = 'add';

	// Project ID
	var $ProjectID = '{CC60B42B-604B-412A-B014-2315920AF6AA}';

	// Table name
	var $TableName = 'petani';

	// Page object name
	var $PageObjName = 'petani_add';

	// Page headings
	var $Heading = '';
	var $Subheading = '';

	// Page heading
	function PageHeading() {
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->TableCaption();
		return "";
	}

	// Page subheading
	function PageSubheading() {
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->Phrase($this->PageID);
		return "";
	}

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (petani)
		if (!isset($GLOBALS["petani"]) || get_class($GLOBALS["petani"]) == "cpetani") {
			$GLOBALS["petani"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["petani"];
		}

		// Table object (employees)
		if (!isset($GLOBALS['employees'])) $GLOBALS['employees'] = new cemployees();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'add', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'petani', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"]))
			$GLOBALS["gTimer"] = new cTimer();

		// Debug message
		ew_LoadDebugMsg();

		// Open connection
		if (!isset($conn))
			$conn = ew_Connect($this->DBID);

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new cemployees();
			$UserTableConn = Conn($UserTable->DBID);
		}
	}

	//
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Is modal
		$this->IsModal = (@$_GET["modal"] == "1" || @$_POST["modal"] == "1");

		// User profile
		$UserProfile = new cUserProfile();

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanAdd()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			if ($Security->CanList())
				$this->Page_Terminate(ew_GetUrl("petanilist.php"));
			else
				$this->Page_Terminate(ew_GetUrl("login.php"));
		}

		// NOTE: Security object may be needed in other part of the script, skip set to Nothing
		// 
		// Security = null;
		// 
		// Create form object

		$objForm = new cFormObj();
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action
		$this->pet_nama->SetVisibility();
		$this->pet_hp->SetVisibility();
		$this->prov_id->SetVisibility();
		$this->kab_id->SetVisibility();
		$this->kec_id->SetVisibility();
		$this->desa_id->SetVisibility();
		$this->pet_alamat->SetVisibility();
		$this->pet_foto->SetVisibility();
		$this->co_id->SetVisibility();
		$this->koord_id->SetVisibility();
		$this->tr_id->SetVisibility();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $petani;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($petani);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		// Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = ew_GetPageName($url);
				if ($pageName != $this->GetListUrl()) { // Not List page
					$row["caption"] = $this->GetModalCaption($pageName);
					if ($pageName == "petaniview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				header("Content-Type: application/json; charset=utf-8");
				echo ew_ConvertToUtf8(ew_ArrayToJson(array($row)));
			} else {
				ew_SaveDebugMsg();
				header("Location: " . $url);
			}
		}
		exit();
	}
	var $FormClassName = "form-horizontal ewForm ewAddForm";
	var $IsModal = FALSE;
	var $IsMobileOrModal = FALSE;
	var $DbMasterFilter = "";
	var $DbDetailFilter = "";
	var $StartRec;
	var $Priv = 0;
	var $OldRecordset;
	var $CopyRecord;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError;
		global $gbSkipHeaderFooter;

		// Check modal
		if ($this->IsModal)
			$gbSkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = ew_IsMobile() || $this->IsModal;
		$this->FormClassName = "ewForm ewAddForm form-horizontal";

		// Set up current action
		if (@$_POST["a_add"] <> "") {
			$this->CurrentAction = $_POST["a_add"]; // Get form action
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (@$_GET["pet_id"] != "") {
				$this->pet_id->setQueryStringValue($_GET["pet_id"]);
				$this->setKey("pet_id", $this->pet_id->CurrentValue); // Set up key
			} else {
				$this->setKey("pet_id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "C"; // Copy record
			} else {
				$this->CurrentAction = "I"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->LoadOldRecord();

		// Load form values
		if (@$_POST["a_add"] <> "") {
			$this->LoadFormValues(); // Load form values
		}

		// Validate form if post back
		if (@$_POST["a_add"] <> "") {
			if (!$this->ValidateForm()) {
				$this->CurrentAction = "I"; // Form error, reset action
				$this->EventCancelled = TRUE; // Event cancelled
				$this->RestoreFormValues(); // Restore form values
				$this->setFailureMessage($gsFormError);
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "I": // Blank record
				break;
			case "C": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "") $this->setFailureMessage($Language->Phrase("NoRecord")); // No record found
					$this->Page_Terminate("petanilist.php"); // No matching record, return to list
				}
				break;
			case "A": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->AddRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->Phrase("AddSuccess")); // Set up success message
					$sReturnUrl = $this->getReturnUrl();
					if (ew_GetPageName($sReturnUrl) == "petanilist.php")
						$sReturnUrl = $this->AddMasterUrl($sReturnUrl); // List page, return to List page with correct master key if necessary
					elseif (ew_GetPageName($sReturnUrl) == "petaniview.php")
						$sReturnUrl = $this->GetViewUrl(); // View page, return to View page with keyurl directly
					$this->Page_Terminate($sReturnUrl); // Clean up and return
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->RestoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->SetupBreadcrumb();

		// Render row based on row type
		$this->RowType = EW_ROWTYPE_ADD; // Render add type

		// Render row
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Get upload files
	function GetUploadFiles() {
		global $objForm, $Language;

		// Get upload data
		$this->pet_foto->Upload->Index = $objForm->Index;
		$this->pet_foto->Upload->UploadFile();
		$this->pet_foto->CurrentValue = $this->pet_foto->Upload->FileName;
	}

	// Load default values
	function LoadDefaultValues() {
		$this->pet_id->CurrentValue = NULL;
		$this->pet_id->OldValue = $this->pet_id->CurrentValue;
		$this->pet_nama->CurrentValue = NULL;
		$this->pet_nama->OldValue = $this->pet_nama->CurrentValue;
		$this->pet_hp->CurrentValue = NULL;
		$this->pet_hp->OldValue = $this->pet_hp->CurrentValue;
		$this->prov_id->CurrentValue = NULL;
		$this->prov_id->OldValue = $this->prov_id->CurrentValue;
		$this->kab_id->CurrentValue = NULL;
		$this->kab_id->OldValue = $this->kab_id->CurrentValue;
		$this->kec_id->CurrentValue = NULL;
		$this->kec_id->OldValue = $this->kec_id->CurrentValue;
		$this->desa_id->CurrentValue = NULL;
		$this->desa_id->OldValue = $this->desa_id->CurrentValue;
		$this->pet_alamat->CurrentValue = NULL;
		$this->pet_alamat->OldValue = $this->pet_alamat->CurrentValue;
		$this->pet_foto->Upload->DbValue = NULL;
		$this->pet_foto->OldValue = $this->pet_foto->Upload->DbValue;
		$this->pet_foto->CurrentValue = NULL; // Clear file related field
		$this->co_id->CurrentValue = NULL;
		$this->co_id->OldValue = $this->co_id->CurrentValue;
		$this->koord_id->CurrentValue = NULL;
		$this->koord_id->OldValue = $this->koord_id->CurrentValue;
		$this->tr_id->CurrentValue = NULL;
		$this->tr_id->OldValue = $this->tr_id->CurrentValue;
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm;
		$this->GetUploadFiles(); // Get upload files
		if (!$this->pet_nama->FldIsDetailKey) {
			$this->pet_nama->setFormValue($objForm->GetValue("x_pet_nama"));
		}
		if (!$this->pet_hp->FldIsDetailKey) {
			$this->pet_hp->setFormValue($objForm->GetValue("x_pet_hp"));
		}
		if (!$this->prov_id->FldIsDetailKey) {
			$this->prov_id->setFormValue($objForm->GetValue("x_prov_id"));
		}
		if (!$this->kab_id->FldIsDetailKey) {
			$this->kab_id->setFormValue($objForm->GetValue("x_kab_id"));
		}
		if (!$this->kec_id->FldIsDetailKey) {
			$this->kec_id->setFormValue($objForm->GetValue("x_kec_id"));
		}
		if (!$this->desa_id->FldIsDetailKey) {
			$this->desa_id->setFormValue($objForm->GetValue("x_desa_id"));
		}
		if (!$this->pet_alamat->FldIsDetailKey) {
			$this->pet_alamat->setFormValue($objForm->GetValue("x_pet_alamat"));
		}
		if (!$this->co_id->FldIsDetailKey) {
			$this->co_id->setFormValue($objForm->GetValue("x_co_id"));
		}
		if (!$this->koord_id->FldIsDetailKey) {
			$this->koord_id->setFormValue($objForm->GetValue("x_koord_id"));
		}
		if (!$this->tr_id->FldIsDetailKey) {
			$this->tr_id->setFormValue($objForm->GetValue("x_tr_id"));
		}
	}

	// Restore form values
	function RestoreFormValues() {
		global $objForm;
		$this->pet_nama->CurrentValue = $this->pet_nama->FormValue;
		$this->pet_hp->CurrentValue = $this->pet_hp->FormValue;
		$this->prov_id->CurrentValue = $this->prov_id->FormValue;
		$this->kab_id->CurrentValue = $this->kab_id->FormValue;
		$this->kec_id->CurrentValue = $this->kec_id->FormValue;
		$this->desa_id->CurrentValue = $this->desa_id->FormValue;
		$this->pet_alamat->CurrentValue = $this->pet_alamat->FormValue;
		$this->co_id->CurrentValue = $this->co_id->FormValue;
		$this->koord_id->CurrentValue = $this->koord_id->FormValue;
		$this->tr_id->CurrentValue = $this->tr_id->FormValue;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues($rs = NULL) {
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->NewRow(); 

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->pet_id->setDbValue($row['pet_id']);
		$this->pet_nama->setDbValue($row['pet_nama']);
		$this->pet_hp->setDbValue($row['pet_hp']);
		$this->prov_id->setDbValue($row['prov_id']);
		$this->kab_id->setDbValue($row['kab_id']);
		$this->kec_id->setDbValue($row['kec_id']);
		$this->desa_id->setDbValue($row['desa_id']);
		$this->pet_alamat->setDbValue($row['pet_alamat']);
		$this->pet_foto->Upload->DbValue = $row['pet_foto'];
		$this->pet_foto->setDbValue($this->pet_foto->Upload->DbValue);
		$this->co_id->setDbValue($row['co_id']);
		$this->koord_id->setDbValue($row['koord_id']);
		if (array_key_exists('EV__koord_id', $rs->fields)) {
			$this->koord_id->VirtualValue = $rs->fields('EV__koord_id'); // Set up virtual field value
		} else {
			$this->koord_id->VirtualValue = ""; // Clear value
		}
		$this->tr_id->setDbValue($row['tr_id']);
	}

	// Return a row with default values
	function NewRow() {
		$this->LoadDefaultValues();
		$row = array();
		$row['pet_id'] = $this->pet_id->CurrentValue;
		$row['pet_nama'] = $this->pet_nama->CurrentValue;
		$row['pet_hp'] = $this->pet_hp->CurrentValue;
		$row['prov_id'] = $this->prov_id->CurrentValue;
		$row['kab_id'] = $this->kab_id->CurrentValue;
		$row['kec_id'] = $this->kec_id->CurrentValue;
		$row['desa_id'] = $this->desa_id->CurrentValue;
		$row['pet_alamat'] = $this->pet_alamat->CurrentValue;
		$row['pet_foto'] = $this->pet_foto->Upload->DbValue;
		$row['co_id'] = $this->co_id->CurrentValue;
		$row['koord_id'] = $this->koord_id->CurrentValue;
		$row['tr_id'] = $this->tr_id->CurrentValue;
		return $row;
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->pet_id->DbValue = $row['pet_id'];
		$this->pet_nama->DbValue = $row['pet_nama'];
		$this->pet_hp->DbValue = $row['pet_hp'];
		$this->prov_id->DbValue = $row['prov_id'];
		$this->kab_id->DbValue = $row['kab_id'];
		$this->kec_id->DbValue = $row['kec_id'];
		$this->desa_id->DbValue = $row['desa_id'];
		$this->pet_alamat->DbValue = $row['pet_alamat'];
		$this->pet_foto->Upload->DbValue = $row['pet_foto'];
		$this->co_id->DbValue = $row['co_id'];
		$this->koord_id->DbValue = $row['koord_id'];
		$this->tr_id->DbValue = $row['tr_id'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("pet_id")) <> "")
			$this->pet_id->CurrentValue = $this->getKey("pet_id"); // pet_id
		else
			$bValidKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
		}
		$this->LoadRowValues($this->OldRecordset); // Load row values
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// pet_id
		// pet_nama
		// pet_hp
		// prov_id
		// kab_id
		// kec_id
		// desa_id
		// pet_alamat
		// pet_foto
		// co_id
		// koord_id
		// tr_id

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// pet_id
		$this->pet_id->ViewValue = $this->pet_id->CurrentValue;
		$this->pet_id->ViewCustomAttributes = "";

		// pet_nama
		$this->pet_nama->ViewValue = $this->pet_nama->CurrentValue;
		$this->pet_nama->ViewCustomAttributes = "";

		// pet_hp
		$this->pet_hp->ViewValue = $this->pet_hp->CurrentValue;
		$this->pet_hp->ViewCustomAttributes = "";

		// prov_id
		if (strval($this->prov_id->CurrentValue) <> "") {
			$sFilterWrk = "`prov_id`" . ew_SearchString("=", $this->prov_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `prov_id`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `prov`";
		$sWhereWrk = "";
		$this->prov_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->prov_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `prov_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->prov_id->ViewValue = $this->prov_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->prov_id->ViewValue = $this->prov_id->CurrentValue;
			}
		} else {
			$this->prov_id->ViewValue = NULL;
		}
		$this->prov_id->ViewCustomAttributes = "";

		// kab_id
		if (strval($this->kab_id->CurrentValue) <> "") {
			$sFilterWrk = "`kab_id`" . ew_SearchString("=", $this->kab_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `kab_id`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kab`";
		$sWhereWrk = "";
		$this->kab_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->kab_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `kab_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->kab_id->ViewValue = $this->kab_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->kab_id->ViewValue = $this->kab_id->CurrentValue;
			}
		} else {
			$this->kab_id->ViewValue = NULL;
		}
		$this->kab_id->ViewCustomAttributes = "";

		// kec_id
		if (strval($this->kec_id->CurrentValue) <> "") {
			$sFilterWrk = "`kec_id`" . ew_SearchString("=", $this->kec_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `kec_id`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kec`";
		$sWhereWrk = "";
		$this->kec_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->kec_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `kec_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->kec_id->ViewValue = $this->kec_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->kec_id->ViewValue = $this->kec_id->CurrentValue;
			}
		} else {
			$this->kec_id->ViewValue = NULL;
		}
		$this->kec_id->ViewCustomAttributes = "";

		// desa_id
		if (strval($this->desa_id->CurrentValue) <> "") {
			$sFilterWrk = "`desa_id`" . ew_SearchString("=", $this->desa_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `desa_id`, `desa_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `desa`";
		$sWhereWrk = "";
		$this->desa_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->desa_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `desa_id` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->desa_id->ViewValue = $this->desa_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->desa_id->ViewValue = $this->desa_id->CurrentValue;
			}
		} else {
			$this->desa_id->ViewValue = NULL;
		}
		$this->desa_id->ViewCustomAttributes = "";

		// pet_alamat
		$this->pet_alamat->ViewValue = $this->pet_alamat->CurrentValue;
		$this->pet_alamat->ViewCustomAttributes = "";

		// pet_foto
		$this->pet_foto->UploadPath = "foto_petani";
		if (!ew_Empty($this->pet_foto->Upload->DbValue)) {
			$this->pet_foto->ImageWidth = 30;
			$this->pet_foto->ImageHeight = 40;
			$this->pet_foto->ImageAlt = $this->pet_foto->FldAlt();
			$this->pet_foto->ViewValue = $this->pet_foto->Upload->DbValue;
		} else {
			$this->pet_foto->ViewValue = "";
		}
		$this->pet_foto->ViewCustomAttributes = "";

		// co_id
		if (strval($this->co_id->CurrentValue) <> "") {
			$sFilterWrk = "`co_id`" . ew_SearchString("=", $this->co_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `co_id`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `co`";
		$sWhereWrk = "";
		$this->co_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->co_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `co_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->co_id->ViewValue = $this->co_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->co_id->ViewValue = $this->co_id->CurrentValue;
			}
		} else {
			$this->co_id->ViewValue = NULL;
		}
		$this->co_id->ViewCustomAttributes = "";

		// koord_id
		if ($this->koord_id->VirtualValue <> "") {
			$this->koord_id->ViewValue = $this->koord_id->VirtualValue;
		} else {
			$this->koord_id->ViewValue = $this->koord_id->CurrentValue;
		if (strval($this->koord_id->CurrentValue) <> "") {
			$sFilterWrk = "`koord_id`" . ew_SearchString("=", $this->koord_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `koord_id`, `koord_nama` AS `DispFld`, `koord_alamat` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `koord`";
		$sWhereWrk = "";
		$this->koord_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->koord_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = $rswrk->fields('Disp2Fld');
				$this->koord_id->ViewValue = $this->koord_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->koord_id->ViewValue = $this->koord_id->CurrentValue;
			}
		} else {
			$this->koord_id->ViewValue = NULL;
		}
		}
		$this->koord_id->ViewCustomAttributes = "";

		// tr_id
		if (strval($this->tr_id->CurrentValue) <> "") {
			$sFilterWrk = "`tr_id`" . ew_SearchString("=", $this->tr_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `tr_id`, `tr_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tingkat_resiko`";
		$sWhereWrk = "";
		$this->tr_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->tr_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `tr_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->tr_id->ViewValue = $this->tr_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->tr_id->ViewValue = $this->tr_id->CurrentValue;
			}
		} else {
			$this->tr_id->ViewValue = NULL;
		}
		$this->tr_id->ViewCustomAttributes = "";

			// pet_nama
			$this->pet_nama->LinkCustomAttributes = "";
			$this->pet_nama->HrefValue = "";
			$this->pet_nama->TooltipValue = "";

			// pet_hp
			$this->pet_hp->LinkCustomAttributes = "";
			$this->pet_hp->HrefValue = "";
			$this->pet_hp->TooltipValue = "";

			// prov_id
			$this->prov_id->LinkCustomAttributes = "";
			$this->prov_id->HrefValue = "";
			$this->prov_id->TooltipValue = "";

			// kab_id
			$this->kab_id->LinkCustomAttributes = "";
			$this->kab_id->HrefValue = "";
			$this->kab_id->TooltipValue = "";

			// kec_id
			$this->kec_id->LinkCustomAttributes = "";
			$this->kec_id->HrefValue = "";
			$this->kec_id->TooltipValue = "";

			// desa_id
			$this->desa_id->LinkCustomAttributes = "";
			$this->desa_id->HrefValue = "";
			$this->desa_id->TooltipValue = "";

			// pet_alamat
			$this->pet_alamat->LinkCustomAttributes = "";
			$this->pet_alamat->HrefValue = "";
			$this->pet_alamat->TooltipValue = "";

			// pet_foto
			$this->pet_foto->LinkCustomAttributes = "";
			$this->pet_foto->UploadPath = "foto_petani";
			if (!ew_Empty($this->pet_foto->Upload->DbValue)) {
				$this->pet_foto->HrefValue = ew_GetFileUploadUrl($this->pet_foto, $this->pet_foto->Upload->DbValue); // Add prefix/suffix
				$this->pet_foto->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->pet_foto->HrefValue = ew_FullUrl($this->pet_foto->HrefValue, "href");
			} else {
				$this->pet_foto->HrefValue = "";
			}
			$this->pet_foto->HrefValue2 = $this->pet_foto->UploadPath . $this->pet_foto->Upload->DbValue;
			$this->pet_foto->TooltipValue = "";
			if ($this->pet_foto->UseColorbox) {
				if (ew_Empty($this->pet_foto->TooltipValue))
					$this->pet_foto->LinkAttrs["title"] = $Language->Phrase("ViewImageGallery");
				$this->pet_foto->LinkAttrs["data-rel"] = "petani_x_pet_foto";
				ew_AppendClass($this->pet_foto->LinkAttrs["class"], "ewLightbox");
			}

			// co_id
			$this->co_id->LinkCustomAttributes = "";
			$this->co_id->HrefValue = "";
			$this->co_id->TooltipValue = "";

			// koord_id
			$this->koord_id->LinkCustomAttributes = "";
			$this->koord_id->HrefValue = "";
			$this->koord_id->TooltipValue = "";

			// tr_id
			$this->tr_id->LinkCustomAttributes = "";
			$this->tr_id->HrefValue = "";
			$this->tr_id->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_ADD) { // Add row

			// pet_nama
			$this->pet_nama->EditAttrs["class"] = "form-control";
			$this->pet_nama->EditCustomAttributes = "";
			$this->pet_nama->EditValue = ew_HtmlEncode($this->pet_nama->CurrentValue);
			$this->pet_nama->PlaceHolder = ew_RemoveHtml($this->pet_nama->FldCaption());

			// pet_hp
			$this->pet_hp->EditAttrs["class"] = "form-control";
			$this->pet_hp->EditCustomAttributes = "";
			$this->pet_hp->EditValue = ew_HtmlEncode($this->pet_hp->CurrentValue);
			$this->pet_hp->PlaceHolder = ew_RemoveHtml($this->pet_hp->FldCaption());

			// prov_id
			$this->prov_id->EditAttrs["class"] = "form-control";
			$this->prov_id->EditCustomAttributes = "";
			if (trim(strval($this->prov_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`prov_id`" . ew_SearchString("=", $this->prov_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `prov_id`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `prov`";
			$sWhereWrk = "";
			$this->prov_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->prov_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `prov_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->prov_id->EditValue = $arwrk;

			// kab_id
			$this->kab_id->EditAttrs["class"] = "form-control";
			$this->kab_id->EditCustomAttributes = "";
			if (trim(strval($this->kab_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`kab_id`" . ew_SearchString("=", $this->kab_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `kab_id`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, `kab_prov_id` AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `kab`";
			$sWhereWrk = "";
			$this->kab_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->kab_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `kab_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->kab_id->EditValue = $arwrk;

			// kec_id
			$this->kec_id->EditAttrs["class"] = "form-control";
			$this->kec_id->EditCustomAttributes = "";
			if (trim(strval($this->kec_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`kec_id`" . ew_SearchString("=", $this->kec_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `kec_id`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, `kec_prov_id` AS `SelectFilterFld`, `kec_kab_id` AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `kec`";
			$sWhereWrk = "";
			$this->kec_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->kec_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `kec_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->kec_id->EditValue = $arwrk;

			// desa_id
			$this->desa_id->EditAttrs["class"] = "form-control";
			$this->desa_id->EditCustomAttributes = "";
			if (trim(strval($this->desa_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`desa_id`" . ew_SearchString("=", $this->desa_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `desa_id`, `desa_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, `desa_prov_id` AS `SelectFilterFld`, `desa_kab_id` AS `SelectFilterFld2`, `desa_kec_id` AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `desa`";
			$sWhereWrk = "";
			$this->desa_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->desa_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `desa_id` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->desa_id->EditValue = $arwrk;

			// pet_alamat
			$this->pet_alamat->EditAttrs["class"] = "form-control";
			$this->pet_alamat->EditCustomAttributes = "";
			$this->pet_alamat->EditValue = ew_HtmlEncode($this->pet_alamat->CurrentValue);
			$this->pet_alamat->PlaceHolder = ew_RemoveHtml($this->pet_alamat->FldCaption());

			// pet_foto
			$this->pet_foto->EditAttrs["class"] = "form-control";
			$this->pet_foto->EditCustomAttributes = "";
			$this->pet_foto->UploadPath = "foto_petani";
			if (!ew_Empty($this->pet_foto->Upload->DbValue)) {
				$this->pet_foto->ImageWidth = 30;
				$this->pet_foto->ImageHeight = 40;
				$this->pet_foto->ImageAlt = $this->pet_foto->FldAlt();
				$this->pet_foto->EditValue = $this->pet_foto->Upload->DbValue;
			} else {
				$this->pet_foto->EditValue = "";
			}
			if (!ew_Empty($this->pet_foto->CurrentValue))
					$this->pet_foto->Upload->FileName = $this->pet_foto->CurrentValue;
			if (($this->CurrentAction == "I" || $this->CurrentAction == "C") && !$this->EventCancelled) ew_RenderUploadField($this->pet_foto);

			// co_id
			$this->co_id->EditAttrs["class"] = "form-control";
			$this->co_id->EditCustomAttributes = "";
			if (trim(strval($this->co_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`co_id`" . ew_SearchString("=", $this->co_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `co_id`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `co`";
			$sWhereWrk = "";
			$this->co_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->co_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `co_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->co_id->EditValue = $arwrk;

			// koord_id
			$this->koord_id->EditAttrs["class"] = "form-control";
			$this->koord_id->EditCustomAttributes = "";
			$this->koord_id->EditValue = ew_HtmlEncode($this->koord_id->CurrentValue);
			$this->koord_id->PlaceHolder = ew_RemoveHtml($this->koord_id->FldCaption());

			// tr_id
			$this->tr_id->EditAttrs["class"] = "form-control";
			$this->tr_id->EditCustomAttributes = "";
			if (trim(strval($this->tr_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`tr_id`" . ew_SearchString("=", $this->tr_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `tr_id`, `tr_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `tingkat_resiko`";
			$sWhereWrk = "";
			$this->tr_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->tr_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `tr_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->tr_id->EditValue = $arwrk;

			// Add refer script
			// pet_nama

			$this->pet_nama->LinkCustomAttributes = "";
			$this->pet_nama->HrefValue = "";

			// pet_hp
			$this->pet_hp->LinkCustomAttributes = "";
			$this->pet_hp->HrefValue = "";

			// prov_id
			$this->prov_id->LinkCustomAttributes = "";
			$this->prov_id->HrefValue = "";

			// kab_id
			$this->kab_id->LinkCustomAttributes = "";
			$this->kab_id->HrefValue = "";

			// kec_id
			$this->kec_id->LinkCustomAttributes = "";
			$this->kec_id->HrefValue = "";

			// desa_id
			$this->desa_id->LinkCustomAttributes = "";
			$this->desa_id->HrefValue = "";

			// pet_alamat
			$this->pet_alamat->LinkCustomAttributes = "";
			$this->pet_alamat->HrefValue = "";

			// pet_foto
			$this->pet_foto->LinkCustomAttributes = "";
			$this->pet_foto->UploadPath = "foto_petani";
			if (!ew_Empty($this->pet_foto->Upload->DbValue)) {
				$this->pet_foto->HrefValue = ew_GetFileUploadUrl($this->pet_foto, $this->pet_foto->Upload->DbValue); // Add prefix/suffix
				$this->pet_foto->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->pet_foto->HrefValue = ew_FullUrl($this->pet_foto->HrefValue, "href");
			} else {
				$this->pet_foto->HrefValue = "";
			}
			$this->pet_foto->HrefValue2 = $this->pet_foto->UploadPath . $this->pet_foto->Upload->DbValue;

			// co_id
			$this->co_id->LinkCustomAttributes = "";
			$this->co_id->HrefValue = "";

			// koord_id
			$this->koord_id->LinkCustomAttributes = "";
			$this->koord_id->HrefValue = "";

			// tr_id
			$this->tr_id->LinkCustomAttributes = "";
			$this->tr_id->HrefValue = "";
		}
		if ($this->RowType == EW_ROWTYPE_ADD || $this->RowType == EW_ROWTYPE_EDIT || $this->RowType == EW_ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->SetupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $Language, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return ($gsFormError == "");
		if (!$this->pet_nama->FldIsDetailKey && !is_null($this->pet_nama->FormValue) && $this->pet_nama->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->pet_nama->FldCaption(), $this->pet_nama->ReqErrMsg));
		}
		if (!ew_CheckInteger($this->pet_hp->FormValue)) {
			ew_AddMessage($gsFormError, $this->pet_hp->FldErrMsg());
		}
		if (!$this->prov_id->FldIsDetailKey && !is_null($this->prov_id->FormValue) && $this->prov_id->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->prov_id->FldCaption(), $this->prov_id->ReqErrMsg));
		}
		if (!$this->kab_id->FldIsDetailKey && !is_null($this->kab_id->FormValue) && $this->kab_id->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->kab_id->FldCaption(), $this->kab_id->ReqErrMsg));
		}
		if (!$this->kec_id->FldIsDetailKey && !is_null($this->kec_id->FormValue) && $this->kec_id->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->kec_id->FldCaption(), $this->kec_id->ReqErrMsg));
		}
		if (!$this->desa_id->FldIsDetailKey && !is_null($this->desa_id->FormValue) && $this->desa_id->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->desa_id->FldCaption(), $this->desa_id->ReqErrMsg));
		}
		if (!$this->pet_alamat->FldIsDetailKey && !is_null($this->pet_alamat->FormValue) && $this->pet_alamat->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->pet_alamat->FldCaption(), $this->pet_alamat->ReqErrMsg));
		}
		if (!$this->co_id->FldIsDetailKey && !is_null($this->co_id->FormValue) && $this->co_id->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->co_id->FldCaption(), $this->co_id->ReqErrMsg));
		}
		if (!$this->koord_id->FldIsDetailKey && !is_null($this->koord_id->FormValue) && $this->koord_id->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->koord_id->FldCaption(), $this->koord_id->ReqErrMsg));
		}
		if (!$this->tr_id->FldIsDetailKey && !is_null($this->tr_id->FormValue) && $this->tr_id->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->tr_id->FldCaption(), $this->tr_id->ReqErrMsg));
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsFormError, $sFormCustomError);
		}
		return $ValidateForm;
	}

	// Add record
	function AddRow($rsold = NULL) {
		global $Language, $Security;
		if ($this->pet_nama->CurrentValue <> "") { // Check field with unique index
			$sFilter = "(pet_nama = '" . ew_AdjustSql($this->pet_nama->CurrentValue, $this->DBID) . "')";
			$rsChk = $this->LoadRs($sFilter);
			if ($rsChk && !$rsChk->EOF) {
				$sIdxErrMsg = str_replace("%f", $this->pet_nama->FldCaption(), $Language->Phrase("DupIndex"));
				$sIdxErrMsg = str_replace("%v", $this->pet_nama->CurrentValue, $sIdxErrMsg);
				$this->setFailureMessage($sIdxErrMsg);
				$rsChk->Close();
				return FALSE;
			}
		}
		$conn = &$this->Connection();

		// Load db values from rsold
		$this->LoadDbValues($rsold);
		if ($rsold) {
			$this->pet_foto->OldUploadPath = "foto_petani";
			$this->pet_foto->UploadPath = $this->pet_foto->OldUploadPath;
		}
		$rsnew = array();

		// pet_nama
		$this->pet_nama->SetDbValueDef($rsnew, $this->pet_nama->CurrentValue, NULL, FALSE);

		// pet_hp
		$this->pet_hp->SetDbValueDef($rsnew, $this->pet_hp->CurrentValue, NULL, FALSE);

		// prov_id
		$this->prov_id->SetDbValueDef($rsnew, $this->prov_id->CurrentValue, NULL, FALSE);

		// kab_id
		$this->kab_id->SetDbValueDef($rsnew, $this->kab_id->CurrentValue, NULL, FALSE);

		// kec_id
		$this->kec_id->SetDbValueDef($rsnew, $this->kec_id->CurrentValue, NULL, FALSE);

		// desa_id
		$this->desa_id->SetDbValueDef($rsnew, $this->desa_id->CurrentValue, NULL, FALSE);

		// pet_alamat
		$this->pet_alamat->SetDbValueDef($rsnew, $this->pet_alamat->CurrentValue, NULL, FALSE);

		// pet_foto
		if ($this->pet_foto->Visible && !$this->pet_foto->Upload->KeepFile) {
			$this->pet_foto->Upload->DbValue = ""; // No need to delete old file
			if ($this->pet_foto->Upload->FileName == "") {
				$rsnew['pet_foto'] = NULL;
			} else {
				$rsnew['pet_foto'] = $this->pet_foto->Upload->FileName;
			}
			$this->pet_foto->ImageWidth = 300; // Resize width
			$this->pet_foto->ImageHeight = 400; // Resize height
		}

		// co_id
		$this->co_id->SetDbValueDef($rsnew, $this->co_id->CurrentValue, NULL, FALSE);

		// koord_id
		$this->koord_id->SetDbValueDef($rsnew, $this->koord_id->CurrentValue, NULL, FALSE);

		// tr_id
		$this->tr_id->SetDbValueDef($rsnew, $this->tr_id->CurrentValue, NULL, FALSE);
		if ($this->pet_foto->Visible && !$this->pet_foto->Upload->KeepFile) {
			$this->pet_foto->UploadPath = "foto_petani";
			$OldFiles = ew_Empty($this->pet_foto->Upload->DbValue) ? array() : array($this->pet_foto->Upload->DbValue);
			if (!ew_Empty($this->pet_foto->Upload->FileName)) {
				$NewFiles = array($this->pet_foto->Upload->FileName);
				$NewFileCount = count($NewFiles);
				for ($i = 0; $i < $NewFileCount; $i++) {
					$fldvar = ($this->pet_foto->Upload->Index < 0) ? $this->pet_foto->FldVar : substr($this->pet_foto->FldVar, 0, 1) . $this->pet_foto->Upload->Index . substr($this->pet_foto->FldVar, 1);
					if ($NewFiles[$i] <> "") {
						$file = $NewFiles[$i];
						if (file_exists(ew_UploadTempPath($fldvar, $this->pet_foto->TblVar) . $file)) {
							$OldFileFound = FALSE;
							$OldFileCount = count($OldFiles);
							for ($j = 0; $j < $OldFileCount; $j++) {
								$file1 = $OldFiles[$j];
								if ($file1 == $file) { // Old file found, no need to delete anymore
									unset($OldFiles[$j]);
									$OldFileFound = TRUE;
									break;
								}
							}
							if ($OldFileFound) // No need to check if file exists further
								continue;
							$file1 = ew_UploadFileNameEx($this->pet_foto->PhysicalUploadPath(), $file); // Get new file name
							if ($file1 <> $file) { // Rename temp file
								while (file_exists(ew_UploadTempPath($fldvar, $this->pet_foto->TblVar) . $file1) || file_exists($this->pet_foto->PhysicalUploadPath() . $file1)) // Make sure no file name clash
									$file1 = ew_UniqueFilename($this->pet_foto->PhysicalUploadPath(), $file1, TRUE); // Use indexed name
								rename(ew_UploadTempPath($fldvar, $this->pet_foto->TblVar) . $file, ew_UploadTempPath($fldvar, $this->pet_foto->TblVar) . $file1);
								$NewFiles[$i] = $file1;
							}
						}
					}
				}
				$this->pet_foto->Upload->DbValue = empty($OldFiles) ? "" : implode(EW_MULTIPLE_UPLOAD_SEPARATOR, $OldFiles);
				$this->pet_foto->Upload->FileName = implode(EW_MULTIPLE_UPLOAD_SEPARATOR, $NewFiles);
				$this->pet_foto->SetDbValueDef($rsnew, $this->pet_foto->Upload->FileName, NULL, FALSE);
			}
		}

		// Call Row Inserting event
		$rs = ($rsold == NULL) ? NULL : $rsold->fields;
		$bInsertRow = $this->Row_Inserting($rs, $rsnew);
		if ($bInsertRow) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			$AddRow = $this->Insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($AddRow) {
				if ($this->pet_foto->Visible && !$this->pet_foto->Upload->KeepFile) {
					$OldFiles = ew_Empty($this->pet_foto->Upload->DbValue) ? array() : array($this->pet_foto->Upload->DbValue);
					if (!ew_Empty($this->pet_foto->Upload->FileName)) {
						$NewFiles = array($this->pet_foto->Upload->FileName);
						$NewFiles2 = array($rsnew['pet_foto']);
						$NewFileCount = count($NewFiles);
						for ($i = 0; $i < $NewFileCount; $i++) {
							$fldvar = ($this->pet_foto->Upload->Index < 0) ? $this->pet_foto->FldVar : substr($this->pet_foto->FldVar, 0, 1) . $this->pet_foto->Upload->Index . substr($this->pet_foto->FldVar, 1);
							if ($NewFiles[$i] <> "") {
								$file = ew_UploadTempPath($fldvar, $this->pet_foto->TblVar) . $NewFiles[$i];
								if (file_exists($file)) {
									if (@$NewFiles2[$i] <> "") // Use correct file name
										$NewFiles[$i] = $NewFiles2[$i];
									if (!$this->pet_foto->Upload->ResizeAndSaveToFile($this->pet_foto->ImageWidth, $this->pet_foto->ImageHeight, EW_THUMBNAIL_DEFAULT_QUALITY, $NewFiles[$i], TRUE, $i)) {
										$this->setFailureMessage($Language->Phrase("UploadErrMsg7"));
										return FALSE;
									}
								}
							}
						}
					} else {
						$NewFiles = array();
					}
					$OldFileCount = count($OldFiles);
					for ($i = 0; $i < $OldFileCount; $i++) {
						if ($OldFiles[$i] <> "" && !in_array($OldFiles[$i], $NewFiles))
							@unlink($this->pet_foto->OldPhysicalUploadPath() . $OldFiles[$i]);
					}
				}
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->Phrase("InsertCancelled"));
			}
			$AddRow = FALSE;
		}
		if ($AddRow) {

			// Call Row Inserted event
			$rs = ($rsold == NULL) ? NULL : $rsold->fields;
			$this->Row_Inserted($rs, $rsnew);
		}

		// pet_foto
		ew_CleanUploadTempPath($this->pet_foto, $this->pet_foto->Upload->Index);
		return $AddRow;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$Breadcrumb->Add("list", $this->TableVar, $this->AddMasterUrl("petanilist.php"), "", $this->TableVar, TRUE);
		$PageId = ($this->CurrentAction == "C") ? "Copy" : "Add";
		$Breadcrumb->Add("add", $PageId, $url);
	}

	// Setup lookup filters of a field
	function SetupLookupFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		case "x_prov_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `prov_id` AS `LinkFld`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `prov`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`prov_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->prov_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `prov_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_kab_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `kab_id` AS `LinkFld`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kab`";
			$sWhereWrk = "{filter}";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`kab_id` IN ({filter_value})', "t0" => "3", "fn0" => "", "f1" => '`kab_prov_id` IN ({filter_value})', "t1" => "3", "fn1" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->kab_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `kab_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_kec_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `kec_id` AS `LinkFld`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kec`";
			$sWhereWrk = "{filter}";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`kec_id` IN ({filter_value})', "t0" => "3", "fn0" => "", "f1" => '`kec_prov_id` IN ({filter_value})', "t1" => "3", "fn1" => "", "f2" => '`kec_kab_id` IN ({filter_value})', "t2" => "3", "fn2" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->kec_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `kec_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_desa_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `desa_id` AS `LinkFld`, `desa_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `desa`";
			$sWhereWrk = "{filter}";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`desa_id` IN ({filter_value})', "t0" => "3", "fn0" => "", "f1" => '`desa_prov_id` IN ({filter_value})', "t1" => "3", "fn1" => "", "f2" => '`desa_kab_id` IN ({filter_value})', "t2" => "3", "fn2" => "", "f3" => '`desa_kec_id` IN ({filter_value})', "t3" => "3", "fn3" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->desa_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `desa_id` DESC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_co_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `co_id` AS `LinkFld`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `co`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`co_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->co_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `co_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_koord_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `koord_id` AS `LinkFld`, `koord_nama` AS `DispFld`, `koord_alamat` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `koord`";
			$sWhereWrk = "{filter}";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`koord_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->koord_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_tr_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `tr_id` AS `LinkFld`, `tr_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tingkat_resiko`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`tr_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->tr_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `tr_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		}
	}

	// Setup AutoSuggest filters of a field
	function SetupAutoSuggestFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		case "x_koord_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `koord_id`, `koord_nama` AS `DispFld`, `koord_alamat` AS `Disp2Fld` FROM `koord`";
			$sWhereWrk = "`koord_nama` LIKE '{query_value}%' OR CONCAT(COALESCE(`koord_nama`, ''),'" . ew_ValueSeparator(1, $this->koord_id) . "',COALESCE(`koord_alamat`,'')) LIKE '{query_value}%'";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->koord_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($petani_add)) $petani_add = new cpetani_add();

// Page init
$petani_add->Page_Init();

// Page main
$petani_add->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$petani_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "add";
var CurrentForm = fpetaniadd = new ew_Form("fpetaniadd", "add");

// Validate form
fpetaniadd.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);
	if ($fobj.find("#a_confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.FormKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = $fobj.find("#a_list").val() == "gridinsert";
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
			elm = this.GetElements("x" + infix + "_pet_nama");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $petani->pet_nama->FldCaption(), $petani->pet_nama->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_pet_hp");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($petani->pet_hp->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_prov_id");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $petani->prov_id->FldCaption(), $petani->prov_id->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_kab_id");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $petani->kab_id->FldCaption(), $petani->kab_id->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_kec_id");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $petani->kec_id->FldCaption(), $petani->kec_id->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_desa_id");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $petani->desa_id->FldCaption(), $petani->desa_id->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_pet_alamat");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $petani->pet_alamat->FldCaption(), $petani->pet_alamat->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_co_id");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $petani->co_id->FldCaption(), $petani->co_id->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_koord_id");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $petani->koord_id->FldCaption(), $petani->koord_id->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_tr_id");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $petani->tr_id->FldCaption(), $petani->tr_id->ReqErrMsg)) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ewForms[val])
			if (!ewForms[val].Validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpetaniadd.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fpetaniadd.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpetaniadd.Lists["x_prov_id"] = {"LinkField":"x_prov_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_prov_nama","","",""],"ParentFields":[],"ChildFields":["x_kab_id","x_kec_id","x_desa_id"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"prov"};
fpetaniadd.Lists["x_prov_id"].Data = "<?php echo $petani_add->prov_id->LookupFilterQuery(FALSE, "add") ?>";
fpetaniadd.Lists["x_kab_id"] = {"LinkField":"x_kab_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kab_nama","","",""],"ParentFields":["x_prov_id"],"ChildFields":["x_kec_id","x_desa_id"],"FilterFields":["x_kab_prov_id"],"Options":[],"Template":"","LinkTable":"kab"};
fpetaniadd.Lists["x_kab_id"].Data = "<?php echo $petani_add->kab_id->LookupFilterQuery(FALSE, "add") ?>";
fpetaniadd.Lists["x_kec_id"] = {"LinkField":"x_kec_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kec_nama","","",""],"ParentFields":["x_prov_id","x_kab_id"],"ChildFields":["x_desa_id"],"FilterFields":["x_kec_prov_id","x_kec_kab_id"],"Options":[],"Template":"","LinkTable":"kec"};
fpetaniadd.Lists["x_kec_id"].Data = "<?php echo $petani_add->kec_id->LookupFilterQuery(FALSE, "add") ?>";
fpetaniadd.Lists["x_desa_id"] = {"LinkField":"x_desa_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_desa_nama","","",""],"ParentFields":["x_prov_id","x_kab_id","x_kec_id"],"ChildFields":[],"FilterFields":["x_desa_prov_id","x_desa_kab_id","x_desa_kec_id"],"Options":[],"Template":"","LinkTable":"desa"};
fpetaniadd.Lists["x_desa_id"].Data = "<?php echo $petani_add->desa_id->LookupFilterQuery(FALSE, "add") ?>";
fpetaniadd.Lists["x_co_id"] = {"LinkField":"x_co_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_co_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"co"};
fpetaniadd.Lists["x_co_id"].Data = "<?php echo $petani_add->co_id->LookupFilterQuery(FALSE, "add") ?>";
fpetaniadd.Lists["x_koord_id"] = {"LinkField":"x_koord_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_koord_nama","x_koord_alamat","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"koord"};
fpetaniadd.Lists["x_koord_id"].Data = "<?php echo $petani_add->koord_id->LookupFilterQuery(FALSE, "add") ?>";
fpetaniadd.AutoSuggests["x_koord_id"] = <?php echo json_encode(array("data" => "ajax=autosuggest&" . $petani_add->koord_id->LookupFilterQuery(TRUE, "add"))) ?>;
fpetaniadd.Lists["x_tr_id"] = {"LinkField":"x_tr_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_tr_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"tingkat_resiko"};
fpetaniadd.Lists["x_tr_id"].Data = "<?php echo $petani_add->tr_id->LookupFilterQuery(FALSE, "add") ?>";

// Form object for search
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php $petani_add->ShowPageHeader(); ?>
<?php
$petani_add->ShowMessage();
?>
<form name="fpetaniadd" id="fpetaniadd" class="<?php echo $petani_add->FormClassName ?>" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($petani_add->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $petani_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="petani">
<input type="hidden" name="a_add" id="a_add" value="A">
<input type="hidden" name="modal" value="<?php echo intval($petani_add->IsModal) ?>">
<div class="ewAddDiv"><!-- page* -->
<?php if ($petani->pet_nama->Visible) { // pet_nama ?>
	<div id="r_pet_nama" class="form-group">
		<label id="elh_petani_pet_nama" for="x_pet_nama" class="<?php echo $petani_add->LeftColumnClass ?>"><?php echo $petani->pet_nama->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $petani_add->RightColumnClass ?>"><div<?php echo $petani->pet_nama->CellAttributes() ?>>
<span id="el_petani_pet_nama">
<input type="text" data-table="petani" data-field="x_pet_nama" name="x_pet_nama" id="x_pet_nama" size="30" maxlength="50" placeholder="<?php echo ew_HtmlEncode($petani->pet_nama->getPlaceHolder()) ?>" value="<?php echo $petani->pet_nama->EditValue ?>"<?php echo $petani->pet_nama->EditAttributes() ?>>
</span>
<?php echo $petani->pet_nama->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($petani->pet_hp->Visible) { // pet_hp ?>
	<div id="r_pet_hp" class="form-group">
		<label id="elh_petani_pet_hp" for="x_pet_hp" class="<?php echo $petani_add->LeftColumnClass ?>"><?php echo $petani->pet_hp->FldCaption() ?></label>
		<div class="<?php echo $petani_add->RightColumnClass ?>"><div<?php echo $petani->pet_hp->CellAttributes() ?>>
<span id="el_petani_pet_hp">
<input type="text" data-table="petani" data-field="x_pet_hp" name="x_pet_hp" id="x_pet_hp" size="30" placeholder="<?php echo ew_HtmlEncode($petani->pet_hp->getPlaceHolder()) ?>" value="<?php echo $petani->pet_hp->EditValue ?>"<?php echo $petani->pet_hp->EditAttributes() ?>>
</span>
<?php echo $petani->pet_hp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($petani->prov_id->Visible) { // prov_id ?>
	<div id="r_prov_id" class="form-group">
		<label id="elh_petani_prov_id" for="x_prov_id" class="<?php echo $petani_add->LeftColumnClass ?>"><?php echo $petani->prov_id->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $petani_add->RightColumnClass ?>"><div<?php echo $petani->prov_id->CellAttributes() ?>>
<span id="el_petani_prov_id">
<?php $petani->prov_id->EditAttrs["onchange"] = "ew_UpdateOpt.call(this); " . @$petani->prov_id->EditAttrs["onchange"]; ?>
<select data-table="petani" data-field="x_prov_id" data-value-separator="<?php echo $petani->prov_id->DisplayValueSeparatorAttribute() ?>" id="x_prov_id" name="x_prov_id"<?php echo $petani->prov_id->EditAttributes() ?>>
<?php echo $petani->prov_id->SelectOptionListHtml("x_prov_id") ?>
</select>
</span>
<?php echo $petani->prov_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($petani->kab_id->Visible) { // kab_id ?>
	<div id="r_kab_id" class="form-group">
		<label id="elh_petani_kab_id" for="x_kab_id" class="<?php echo $petani_add->LeftColumnClass ?>"><?php echo $petani->kab_id->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $petani_add->RightColumnClass ?>"><div<?php echo $petani->kab_id->CellAttributes() ?>>
<span id="el_petani_kab_id">
<?php $petani->kab_id->EditAttrs["onchange"] = "ew_UpdateOpt.call(this); " . @$petani->kab_id->EditAttrs["onchange"]; ?>
<select data-table="petani" data-field="x_kab_id" data-value-separator="<?php echo $petani->kab_id->DisplayValueSeparatorAttribute() ?>" id="x_kab_id" name="x_kab_id"<?php echo $petani->kab_id->EditAttributes() ?>>
<?php echo $petani->kab_id->SelectOptionListHtml("x_kab_id") ?>
</select>
</span>
<?php echo $petani->kab_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($petani->kec_id->Visible) { // kec_id ?>
	<div id="r_kec_id" class="form-group">
		<label id="elh_petani_kec_id" for="x_kec_id" class="<?php echo $petani_add->LeftColumnClass ?>"><?php echo $petani->kec_id->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $petani_add->RightColumnClass ?>"><div<?php echo $petani->kec_id->CellAttributes() ?>>
<span id="el_petani_kec_id">
<?php $petani->kec_id->EditAttrs["onchange"] = "ew_UpdateOpt.call(this); " . @$petani->kec_id->EditAttrs["onchange"]; ?>
<select data-table="petani" data-field="x_kec_id" data-value-separator="<?php echo $petani->kec_id->DisplayValueSeparatorAttribute() ?>" id="x_kec_id" name="x_kec_id"<?php echo $petani->kec_id->EditAttributes() ?>>
<?php echo $petani->kec_id->SelectOptionListHtml("x_kec_id") ?>
</select>
</span>
<?php echo $petani->kec_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($petani->desa_id->Visible) { // desa_id ?>
	<div id="r_desa_id" class="form-group">
		<label id="elh_petani_desa_id" for="x_desa_id" class="<?php echo $petani_add->LeftColumnClass ?>"><?php echo $petani->desa_id->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $petani_add->RightColumnClass ?>"><div<?php echo $petani->desa_id->CellAttributes() ?>>
<span id="el_petani_desa_id">
<select data-table="petani" data-field="x_desa_id" data-value-separator="<?php echo $petani->desa_id->DisplayValueSeparatorAttribute() ?>" id="x_desa_id" name="x_desa_id"<?php echo $petani->desa_id->EditAttributes() ?>>
<?php echo $petani->desa_id->SelectOptionListHtml("x_desa_id") ?>
</select>
</span>
<?php echo $petani->desa_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($petani->pet_alamat->Visible) { // pet_alamat ?>
	<div id="r_pet_alamat" class="form-group">
		<label id="elh_petani_pet_alamat" for="x_pet_alamat" class="<?php echo $petani_add->LeftColumnClass ?>"><?php echo $petani->pet_alamat->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $petani_add->RightColumnClass ?>"><div<?php echo $petani->pet_alamat->CellAttributes() ?>>
<span id="el_petani_pet_alamat">
<input type="text" data-table="petani" data-field="x_pet_alamat" name="x_pet_alamat" id="x_pet_alamat" size="30" maxlength="200" placeholder="<?php echo ew_HtmlEncode($petani->pet_alamat->getPlaceHolder()) ?>" value="<?php echo $petani->pet_alamat->EditValue ?>"<?php echo $petani->pet_alamat->EditAttributes() ?>>
</span>
<?php echo $petani->pet_alamat->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($petani->pet_foto->Visible) { // pet_foto ?>
	<div id="r_pet_foto" class="form-group">
		<label id="elh_petani_pet_foto" class="<?php echo $petani_add->LeftColumnClass ?>"><?php echo $petani->pet_foto->FldCaption() ?></label>
		<div class="<?php echo $petani_add->RightColumnClass ?>"><div<?php echo $petani->pet_foto->CellAttributes() ?>>
<span id="el_petani_pet_foto">
<div id="fd_x_pet_foto">
<span title="<?php echo $petani->pet_foto->FldTitle() ? $petani->pet_foto->FldTitle() : $Language->Phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ewTooltip<?php if ($petani->pet_foto->ReadOnly || $petani->pet_foto->Disabled) echo " hide"; ?>" data-trigger="hover">
	<span><?php echo $Language->Phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="petani" data-field="x_pet_foto" name="x_pet_foto" id="x_pet_foto"<?php echo $petani->pet_foto->EditAttributes() ?>>
</span>
<input type="hidden" name="fn_x_pet_foto" id= "fn_x_pet_foto" value="<?php echo $petani->pet_foto->Upload->FileName ?>">
<input type="hidden" name="fa_x_pet_foto" id= "fa_x_pet_foto" value="0">
<input type="hidden" name="fs_x_pet_foto" id= "fs_x_pet_foto" value="50">
<input type="hidden" name="fx_x_pet_foto" id= "fx_x_pet_foto" value="<?php echo $petani->pet_foto->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_pet_foto" id= "fm_x_pet_foto" value="<?php echo $petani->pet_foto->UploadMaxFileSize ?>">
</div>
<table id="ft_x_pet_foto" class="table table-condensed pull-left ewUploadTable"><tbody class="files"></tbody></table>
</span>
<?php echo $petani->pet_foto->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($petani->co_id->Visible) { // co_id ?>
	<div id="r_co_id" class="form-group">
		<label id="elh_petani_co_id" for="x_co_id" class="<?php echo $petani_add->LeftColumnClass ?>"><?php echo $petani->co_id->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $petani_add->RightColumnClass ?>"><div<?php echo $petani->co_id->CellAttributes() ?>>
<span id="el_petani_co_id">
<select data-table="petani" data-field="x_co_id" data-value-separator="<?php echo $petani->co_id->DisplayValueSeparatorAttribute() ?>" id="x_co_id" name="x_co_id"<?php echo $petani->co_id->EditAttributes() ?>>
<?php echo $petani->co_id->SelectOptionListHtml("x_co_id") ?>
</select>
</span>
<?php echo $petani->co_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($petani->koord_id->Visible) { // koord_id ?>
	<div id="r_koord_id" class="form-group">
		<label id="elh_petani_koord_id" class="<?php echo $petani_add->LeftColumnClass ?>"><?php echo $petani->koord_id->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $petani_add->RightColumnClass ?>"><div<?php echo $petani->koord_id->CellAttributes() ?>>
<span id="el_petani_koord_id">
<?php
$wrkonchange = trim(" " . @$petani->koord_id->EditAttrs["onchange"]);
if ($wrkonchange <> "") $wrkonchange = " onchange=\"" . ew_JsEncode2($wrkonchange) . "\"";
$petani->koord_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_koord_id" style="white-space: nowrap; z-index: 8890">
	<input type="text" name="sv_x_koord_id" id="sv_x_koord_id" value="<?php echo $petani->koord_id->EditValue ?>" size="30" placeholder="<?php echo ew_HtmlEncode($petani->koord_id->getPlaceHolder()) ?>" data-placeholder="<?php echo ew_HtmlEncode($petani->koord_id->getPlaceHolder()) ?>"<?php echo $petani->koord_id->EditAttributes() ?>>
</span>
<input type="hidden" data-table="petani" data-field="x_koord_id" data-value-separator="<?php echo $petani->koord_id->DisplayValueSeparatorAttribute() ?>" name="x_koord_id" id="x_koord_id" value="<?php echo ew_HtmlEncode($petani->koord_id->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script type="text/javascript">
fpetaniadd.CreateAutoSuggest({"id":"x_koord_id","forceSelect":false});
</script>
</span>
<?php echo $petani->koord_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($petani->tr_id->Visible) { // tr_id ?>
	<div id="r_tr_id" class="form-group">
		<label id="elh_petani_tr_id" for="x_tr_id" class="<?php echo $petani_add->LeftColumnClass ?>"><?php echo $petani->tr_id->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $petani_add->RightColumnClass ?>"><div<?php echo $petani->tr_id->CellAttributes() ?>>
<span id="el_petani_tr_id">
<select data-table="petani" data-field="x_tr_id" data-value-separator="<?php echo $petani->tr_id->DisplayValueSeparatorAttribute() ?>" id="x_tr_id" name="x_tr_id"<?php echo $petani->tr_id->EditAttributes() ?>>
<?php echo $petani->tr_id->SelectOptionListHtml("x_tr_id") ?>
</select>
</span>
<?php echo $petani->tr_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$petani_add->IsModal) { ?>
<div class="form-group"><!-- buttons .form-group -->
	<div class="<?php echo $petani_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ewButton" name="btnAction" id="btnAction" type="submit"><?php echo $Language->Phrase("AddBtn") ?></button>
<button class="btn btn-default ewButton" name="btnCancel" id="btnCancel" type="button" data-href="<?php echo $petani_add->getReturnUrl() ?>"><?php echo $Language->Phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<script type="text/javascript">
fpetaniadd.Init();
</script>
<?php
$petani_add->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$petani_add->Page_Terminate();
?>
