<?php
if (session_id() == "") session_start(); // Init session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg14.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql14.php") ?>
<?php include_once "phpfn14.php" ?>
<?php include_once "kontrak_koordinfo.php" ?>
<?php include_once "employeesinfo.php" ?>
<?php include_once "userfn14.php" ?>
<?php

//
// Page class
//

$kontrak_koord_add = NULL; // Initialize page object first

class ckontrak_koord_add extends ckontrak_koord {

	// Page ID
	var $PageID = 'add';

	// Project ID
	var $ProjectID = '{CC60B42B-604B-412A-B014-2315920AF6AA}';

	// Table name
	var $TableName = 'kontrak_koord';

	// Page object name
	var $PageObjName = 'kontrak_koord_add';

	// Page headings
	var $Heading = '';
	var $Subheading = '';

	// Page heading
	function PageHeading() {
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->TableCaption();
		return "";
	}

	// Page subheading
	function PageSubheading() {
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->Phrase($this->PageID);
		return "";
	}

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (kontrak_koord)
		if (!isset($GLOBALS["kontrak_koord"]) || get_class($GLOBALS["kontrak_koord"]) == "ckontrak_koord") {
			$GLOBALS["kontrak_koord"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["kontrak_koord"];
		}

		// Table object (employees)
		if (!isset($GLOBALS['employees'])) $GLOBALS['employees'] = new cemployees();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'add', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'kontrak_koord', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"]))
			$GLOBALS["gTimer"] = new cTimer();

		// Debug message
		ew_LoadDebugMsg();

		// Open connection
		if (!isset($conn))
			$conn = ew_Connect($this->DBID);

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new cemployees();
			$UserTableConn = Conn($UserTable->DBID);
		}
	}

	//
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Is modal
		$this->IsModal = (@$_GET["modal"] == "1" || @$_POST["modal"] == "1");

		// User profile
		$UserProfile = new cUserProfile();

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanAdd()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			if ($Security->CanList())
				$this->Page_Terminate(ew_GetUrl("kontrak_koordlist.php"));
			else
				$this->Page_Terminate(ew_GetUrl("login.php"));
		}

		// NOTE: Security object may be needed in other part of the script, skip set to Nothing
		// 
		// Security = null;
		// 
		// Create form object

		$objForm = new cFormObj();
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action
		$this->kk_no_kontrak->SetVisibility();
		$this->koord_id->SetVisibility();
		$this->kk_tgl_mulai->SetVisibility();
		$this->kk_tgl_akhir->SetVisibility();
		$this->kk_periode->SetVisibility();
		$this->var_id->SetVisibility();
		$this->kk_harga->SetVisibility();
		$this->kk_luas->SetVisibility();
		$this->kk_dok->SetVisibility();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $kontrak_koord;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($kontrak_koord);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		// Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = ew_GetPageName($url);
				if ($pageName != $this->GetListUrl()) { // Not List page
					$row["caption"] = $this->GetModalCaption($pageName);
					if ($pageName == "kontrak_koordview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				header("Content-Type: application/json; charset=utf-8");
				echo ew_ConvertToUtf8(ew_ArrayToJson(array($row)));
			} else {
				ew_SaveDebugMsg();
				header("Location: " . $url);
			}
		}
		exit();
	}
	var $FormClassName = "form-horizontal ewForm ewAddForm";
	var $IsModal = FALSE;
	var $IsMobileOrModal = FALSE;
	var $DbMasterFilter = "";
	var $DbDetailFilter = "";
	var $StartRec;
	var $Priv = 0;
	var $OldRecordset;
	var $CopyRecord;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError;
		global $gbSkipHeaderFooter;

		// Check modal
		if ($this->IsModal)
			$gbSkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = ew_IsMobile() || $this->IsModal;
		$this->FormClassName = "ewForm ewAddForm form-horizontal";

		// Set up current action
		if (@$_POST["a_add"] <> "") {
			$this->CurrentAction = $_POST["a_add"]; // Get form action
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (@$_GET["kk_id"] != "") {
				$this->kk_id->setQueryStringValue($_GET["kk_id"]);
				$this->setKey("kk_id", $this->kk_id->CurrentValue); // Set up key
			} else {
				$this->setKey("kk_id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "C"; // Copy record
			} else {
				$this->CurrentAction = "I"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->LoadOldRecord();

		// Load form values
		if (@$_POST["a_add"] <> "") {
			$this->LoadFormValues(); // Load form values
		}

		// Validate form if post back
		if (@$_POST["a_add"] <> "") {
			if (!$this->ValidateForm()) {
				$this->CurrentAction = "I"; // Form error, reset action
				$this->EventCancelled = TRUE; // Event cancelled
				$this->RestoreFormValues(); // Restore form values
				$this->setFailureMessage($gsFormError);
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "I": // Blank record
				break;
			case "C": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "") $this->setFailureMessage($Language->Phrase("NoRecord")); // No record found
					$this->Page_Terminate("kontrak_koordlist.php"); // No matching record, return to list
				}
				break;
			case "A": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->AddRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->Phrase("AddSuccess")); // Set up success message
					$sReturnUrl = $this->getReturnUrl();
					if (ew_GetPageName($sReturnUrl) == "kontrak_koordlist.php")
						$sReturnUrl = $this->AddMasterUrl($sReturnUrl); // List page, return to List page with correct master key if necessary
					elseif (ew_GetPageName($sReturnUrl) == "kontrak_koordview.php")
						$sReturnUrl = $this->GetViewUrl(); // View page, return to View page with keyurl directly
					$this->Page_Terminate($sReturnUrl); // Clean up and return
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->RestoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->SetupBreadcrumb();

		// Render row based on row type
		$this->RowType = EW_ROWTYPE_ADD; // Render add type

		// Render row
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Get upload files
	function GetUploadFiles() {
		global $objForm, $Language;

		// Get upload data
		$this->kk_dok->Upload->Index = $objForm->Index;
		$this->kk_dok->Upload->UploadFile();
		$this->kk_dok->CurrentValue = $this->kk_dok->Upload->FileName;
	}

	// Load default values
	function LoadDefaultValues() {
		$this->kk_id->CurrentValue = NULL;
		$this->kk_id->OldValue = $this->kk_id->CurrentValue;
		$this->kk_no_kontrak->CurrentValue = NULL;
		$this->kk_no_kontrak->OldValue = $this->kk_no_kontrak->CurrentValue;
		$this->koord_id->CurrentValue = NULL;
		$this->koord_id->OldValue = $this->koord_id->CurrentValue;
		$this->kk_tgl_mulai->CurrentValue = NULL;
		$this->kk_tgl_mulai->OldValue = $this->kk_tgl_mulai->CurrentValue;
		$this->kk_tgl_akhir->CurrentValue = NULL;
		$this->kk_tgl_akhir->OldValue = $this->kk_tgl_akhir->CurrentValue;
		$this->kk_periode->CurrentValue = NULL;
		$this->kk_periode->OldValue = $this->kk_periode->CurrentValue;
		$this->var_id->CurrentValue = NULL;
		$this->var_id->OldValue = $this->var_id->CurrentValue;
		$this->kk_harga->CurrentValue = NULL;
		$this->kk_harga->OldValue = $this->kk_harga->CurrentValue;
		$this->kk_luas->CurrentValue = NULL;
		$this->kk_luas->OldValue = $this->kk_luas->CurrentValue;
		$this->kk_dok->Upload->DbValue = NULL;
		$this->kk_dok->OldValue = $this->kk_dok->Upload->DbValue;
		$this->kk_dok->CurrentValue = NULL; // Clear file related field
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm;
		$this->GetUploadFiles(); // Get upload files
		if (!$this->kk_no_kontrak->FldIsDetailKey) {
			$this->kk_no_kontrak->setFormValue($objForm->GetValue("x_kk_no_kontrak"));
		}
		if (!$this->koord_id->FldIsDetailKey) {
			$this->koord_id->setFormValue($objForm->GetValue("x_koord_id"));
		}
		if (!$this->kk_tgl_mulai->FldIsDetailKey) {
			$this->kk_tgl_mulai->setFormValue($objForm->GetValue("x_kk_tgl_mulai"));
			$this->kk_tgl_mulai->CurrentValue = ew_UnFormatDateTime($this->kk_tgl_mulai->CurrentValue, 5);
		}
		if (!$this->kk_tgl_akhir->FldIsDetailKey) {
			$this->kk_tgl_akhir->setFormValue($objForm->GetValue("x_kk_tgl_akhir"));
			$this->kk_tgl_akhir->CurrentValue = ew_UnFormatDateTime($this->kk_tgl_akhir->CurrentValue, 5);
		}
		if (!$this->kk_periode->FldIsDetailKey) {
			$this->kk_periode->setFormValue($objForm->GetValue("x_kk_periode"));
		}
		if (!$this->var_id->FldIsDetailKey) {
			$this->var_id->setFormValue($objForm->GetValue("x_var_id"));
		}
		if (!$this->kk_harga->FldIsDetailKey) {
			$this->kk_harga->setFormValue($objForm->GetValue("x_kk_harga"));
		}
		if (!$this->kk_luas->FldIsDetailKey) {
			$this->kk_luas->setFormValue($objForm->GetValue("x_kk_luas"));
		}
	}

	// Restore form values
	function RestoreFormValues() {
		global $objForm;
		$this->kk_no_kontrak->CurrentValue = $this->kk_no_kontrak->FormValue;
		$this->koord_id->CurrentValue = $this->koord_id->FormValue;
		$this->kk_tgl_mulai->CurrentValue = $this->kk_tgl_mulai->FormValue;
		$this->kk_tgl_mulai->CurrentValue = ew_UnFormatDateTime($this->kk_tgl_mulai->CurrentValue, 5);
		$this->kk_tgl_akhir->CurrentValue = $this->kk_tgl_akhir->FormValue;
		$this->kk_tgl_akhir->CurrentValue = ew_UnFormatDateTime($this->kk_tgl_akhir->CurrentValue, 5);
		$this->kk_periode->CurrentValue = $this->kk_periode->FormValue;
		$this->var_id->CurrentValue = $this->var_id->FormValue;
		$this->kk_harga->CurrentValue = $this->kk_harga->FormValue;
		$this->kk_luas->CurrentValue = $this->kk_luas->FormValue;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues($rs = NULL) {
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->NewRow(); 

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->kk_id->setDbValue($row['kk_id']);
		$this->kk_no_kontrak->setDbValue($row['kk_no_kontrak']);
		$this->koord_id->setDbValue($row['koord_id']);
		$this->kk_tgl_mulai->setDbValue($row['kk_tgl_mulai']);
		$this->kk_tgl_akhir->setDbValue($row['kk_tgl_akhir']);
		$this->kk_periode->setDbValue($row['kk_periode']);
		$this->var_id->setDbValue($row['var_id']);
		$this->kk_harga->setDbValue($row['kk_harga']);
		$this->kk_luas->setDbValue($row['kk_luas']);
		$this->kk_dok->Upload->DbValue = $row['kk_dok'];
		$this->kk_dok->setDbValue($this->kk_dok->Upload->DbValue);
	}

	// Return a row with default values
	function NewRow() {
		$this->LoadDefaultValues();
		$row = array();
		$row['kk_id'] = $this->kk_id->CurrentValue;
		$row['kk_no_kontrak'] = $this->kk_no_kontrak->CurrentValue;
		$row['koord_id'] = $this->koord_id->CurrentValue;
		$row['kk_tgl_mulai'] = $this->kk_tgl_mulai->CurrentValue;
		$row['kk_tgl_akhir'] = $this->kk_tgl_akhir->CurrentValue;
		$row['kk_periode'] = $this->kk_periode->CurrentValue;
		$row['var_id'] = $this->var_id->CurrentValue;
		$row['kk_harga'] = $this->kk_harga->CurrentValue;
		$row['kk_luas'] = $this->kk_luas->CurrentValue;
		$row['kk_dok'] = $this->kk_dok->Upload->DbValue;
		return $row;
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->kk_id->DbValue = $row['kk_id'];
		$this->kk_no_kontrak->DbValue = $row['kk_no_kontrak'];
		$this->koord_id->DbValue = $row['koord_id'];
		$this->kk_tgl_mulai->DbValue = $row['kk_tgl_mulai'];
		$this->kk_tgl_akhir->DbValue = $row['kk_tgl_akhir'];
		$this->kk_periode->DbValue = $row['kk_periode'];
		$this->var_id->DbValue = $row['var_id'];
		$this->kk_harga->DbValue = $row['kk_harga'];
		$this->kk_luas->DbValue = $row['kk_luas'];
		$this->kk_dok->Upload->DbValue = $row['kk_dok'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("kk_id")) <> "")
			$this->kk_id->CurrentValue = $this->getKey("kk_id"); // kk_id
		else
			$bValidKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
		}
		$this->LoadRowValues($this->OldRecordset); // Load row values
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// kk_id
		// kk_no_kontrak
		// koord_id
		// kk_tgl_mulai
		// kk_tgl_akhir
		// kk_periode
		// var_id
		// kk_harga
		// kk_luas
		// kk_dok

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// kk_id
		$this->kk_id->ViewValue = $this->kk_id->CurrentValue;
		$this->kk_id->ViewCustomAttributes = "";

		// kk_no_kontrak
		$this->kk_no_kontrak->ViewValue = $this->kk_no_kontrak->CurrentValue;
		$this->kk_no_kontrak->ViewCustomAttributes = "";

		// koord_id
		if (strval($this->koord_id->CurrentValue) <> "") {
			$sFilterWrk = "`koord_id`" . ew_SearchString("=", $this->koord_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `koord_id`, `koord_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `koord`";
		$sWhereWrk = "";
		$this->koord_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->koord_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `koord_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->koord_id->ViewValue = $this->koord_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->koord_id->ViewValue = $this->koord_id->CurrentValue;
			}
		} else {
			$this->koord_id->ViewValue = NULL;
		}
		$this->koord_id->ViewCustomAttributes = "";

		// kk_tgl_mulai
		$this->kk_tgl_mulai->ViewValue = $this->kk_tgl_mulai->CurrentValue;
		$this->kk_tgl_mulai->ViewValue = ew_FormatDateTime($this->kk_tgl_mulai->ViewValue, 5);
		$this->kk_tgl_mulai->ViewCustomAttributes = "";

		// kk_tgl_akhir
		$this->kk_tgl_akhir->ViewValue = $this->kk_tgl_akhir->CurrentValue;
		$this->kk_tgl_akhir->ViewValue = ew_FormatDateTime($this->kk_tgl_akhir->ViewValue, 5);
		$this->kk_tgl_akhir->ViewCustomAttributes = "";

		// kk_periode
		$this->kk_periode->ViewValue = $this->kk_periode->CurrentValue;
		$this->kk_periode->ViewCustomAttributes = "";

		// var_id
		if (strval($this->var_id->CurrentValue) <> "") {
			$sFilterWrk = "`var_id`" . ew_SearchString("=", $this->var_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `var_id`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `varietas`";
		$sWhereWrk = "";
		$this->var_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->var_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->var_id->ViewValue = $this->var_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->var_id->ViewValue = $this->var_id->CurrentValue;
			}
		} else {
			$this->var_id->ViewValue = NULL;
		}
		$this->var_id->ViewCustomAttributes = "";

		// kk_harga
		$this->kk_harga->ViewValue = $this->kk_harga->CurrentValue;
		$this->kk_harga->ViewCustomAttributes = "";

		// kk_luas
		$this->kk_luas->ViewValue = $this->kk_luas->CurrentValue;
		$this->kk_luas->ViewCustomAttributes = "";

		// kk_dok
		$this->kk_dok->UploadPath = "dokumen_kontrak_koordinator";
		if (!ew_Empty($this->kk_dok->Upload->DbValue)) {
			$this->kk_dok->ImageWidth = 42;
			$this->kk_dok->ImageHeight = 70;
			$this->kk_dok->ImageAlt = $this->kk_dok->FldAlt();
			$this->kk_dok->ViewValue = $this->kk_dok->Upload->DbValue;
		} else {
			$this->kk_dok->ViewValue = "";
		}
		$this->kk_dok->ViewCustomAttributes = "";

			// kk_no_kontrak
			$this->kk_no_kontrak->LinkCustomAttributes = "";
			$this->kk_no_kontrak->HrefValue = "";
			$this->kk_no_kontrak->TooltipValue = "";

			// koord_id
			$this->koord_id->LinkCustomAttributes = "";
			if (!ew_Empty($this->koord_id->CurrentValue)) {
				$this->koord_id->HrefValue = "koordview.php?showdetail=&koord_id=" . $this->koord_id->CurrentValue; // Add prefix/suffix
				$this->koord_id->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->koord_id->HrefValue = ew_FullUrl($this->koord_id->HrefValue, "href");
			} else {
				$this->koord_id->HrefValue = "";
			}
			$this->koord_id->TooltipValue = "";

			// kk_tgl_mulai
			$this->kk_tgl_mulai->LinkCustomAttributes = "";
			$this->kk_tgl_mulai->HrefValue = "";
			$this->kk_tgl_mulai->TooltipValue = "";

			// kk_tgl_akhir
			$this->kk_tgl_akhir->LinkCustomAttributes = "";
			$this->kk_tgl_akhir->HrefValue = "";
			$this->kk_tgl_akhir->TooltipValue = "";

			// kk_periode
			$this->kk_periode->LinkCustomAttributes = "";
			$this->kk_periode->HrefValue = "";
			$this->kk_periode->TooltipValue = "";

			// var_id
			$this->var_id->LinkCustomAttributes = "";
			$this->var_id->HrefValue = "";
			$this->var_id->TooltipValue = "";

			// kk_harga
			$this->kk_harga->LinkCustomAttributes = "";
			$this->kk_harga->HrefValue = "";
			$this->kk_harga->TooltipValue = "";

			// kk_luas
			$this->kk_luas->LinkCustomAttributes = "";
			$this->kk_luas->HrefValue = "";
			$this->kk_luas->TooltipValue = "";

			// kk_dok
			$this->kk_dok->LinkCustomAttributes = "";
			$this->kk_dok->UploadPath = "dokumen_kontrak_koordinator";
			if (!ew_Empty($this->kk_dok->Upload->DbValue)) {
				$this->kk_dok->HrefValue = ew_GetFileUploadUrl($this->kk_dok, $this->kk_dok->Upload->DbValue); // Add prefix/suffix
				$this->kk_dok->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->kk_dok->HrefValue = ew_FullUrl($this->kk_dok->HrefValue, "href");
			} else {
				$this->kk_dok->HrefValue = "";
			}
			$this->kk_dok->HrefValue2 = $this->kk_dok->UploadPath . $this->kk_dok->Upload->DbValue;
			$this->kk_dok->TooltipValue = "";
			if ($this->kk_dok->UseColorbox) {
				if (ew_Empty($this->kk_dok->TooltipValue))
					$this->kk_dok->LinkAttrs["title"] = $Language->Phrase("ViewImageGallery");
				$this->kk_dok->LinkAttrs["data-rel"] = "kontrak_koord_x_kk_dok";
				ew_AppendClass($this->kk_dok->LinkAttrs["class"], "ewLightbox");
			}
		} elseif ($this->RowType == EW_ROWTYPE_ADD) { // Add row

			// kk_no_kontrak
			$this->kk_no_kontrak->EditAttrs["class"] = "form-control";
			$this->kk_no_kontrak->EditCustomAttributes = "";
			$this->kk_no_kontrak->EditValue = ew_HtmlEncode($this->kk_no_kontrak->CurrentValue);
			$this->kk_no_kontrak->PlaceHolder = ew_RemoveHtml($this->kk_no_kontrak->FldCaption());

			// koord_id
			$this->koord_id->EditAttrs["class"] = "form-control";
			$this->koord_id->EditCustomAttributes = "";
			if (trim(strval($this->koord_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`koord_id`" . ew_SearchString("=", $this->koord_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `koord_id`, `koord_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `koord`";
			$sWhereWrk = "";
			$this->koord_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->koord_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `koord_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->koord_id->EditValue = $arwrk;

			// kk_tgl_mulai
			$this->kk_tgl_mulai->EditAttrs["class"] = "form-control";
			$this->kk_tgl_mulai->EditCustomAttributes = "";
			$this->kk_tgl_mulai->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->kk_tgl_mulai->CurrentValue, 5));
			$this->kk_tgl_mulai->PlaceHolder = ew_RemoveHtml($this->kk_tgl_mulai->FldCaption());

			// kk_tgl_akhir
			$this->kk_tgl_akhir->EditAttrs["class"] = "form-control";
			$this->kk_tgl_akhir->EditCustomAttributes = "";
			$this->kk_tgl_akhir->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->kk_tgl_akhir->CurrentValue, 5));
			$this->kk_tgl_akhir->PlaceHolder = ew_RemoveHtml($this->kk_tgl_akhir->FldCaption());

			// kk_periode
			$this->kk_periode->EditAttrs["class"] = "form-control";
			$this->kk_periode->EditCustomAttributes = "";
			$this->kk_periode->EditValue = ew_HtmlEncode($this->kk_periode->CurrentValue);
			$this->kk_periode->PlaceHolder = ew_RemoveHtml($this->kk_periode->FldCaption());

			// var_id
			$this->var_id->EditAttrs["class"] = "form-control";
			$this->var_id->EditCustomAttributes = "";
			if (trim(strval($this->var_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`var_id`" . ew_SearchString("=", $this->var_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `var_id`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `varietas`";
			$sWhereWrk = "";
			$this->var_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->var_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->var_id->EditValue = $arwrk;

			// kk_harga
			$this->kk_harga->EditAttrs["class"] = "form-control";
			$this->kk_harga->EditCustomAttributes = "";
			$this->kk_harga->EditValue = ew_HtmlEncode($this->kk_harga->CurrentValue);
			$this->kk_harga->PlaceHolder = ew_RemoveHtml($this->kk_harga->FldCaption());

			// kk_luas
			$this->kk_luas->EditAttrs["class"] = "form-control";
			$this->kk_luas->EditCustomAttributes = "";
			$this->kk_luas->EditValue = ew_HtmlEncode($this->kk_luas->CurrentValue);
			$this->kk_luas->PlaceHolder = ew_RemoveHtml($this->kk_luas->FldCaption());

			// kk_dok
			$this->kk_dok->EditAttrs["class"] = "form-control";
			$this->kk_dok->EditCustomAttributes = "";
			$this->kk_dok->UploadPath = "dokumen_kontrak_koordinator";
			if (!ew_Empty($this->kk_dok->Upload->DbValue)) {
				$this->kk_dok->ImageWidth = 42;
				$this->kk_dok->ImageHeight = 70;
				$this->kk_dok->ImageAlt = $this->kk_dok->FldAlt();
				$this->kk_dok->EditValue = $this->kk_dok->Upload->DbValue;
			} else {
				$this->kk_dok->EditValue = "";
			}
			if (!ew_Empty($this->kk_dok->CurrentValue))
					$this->kk_dok->Upload->FileName = $this->kk_dok->CurrentValue;
			if (($this->CurrentAction == "I" || $this->CurrentAction == "C") && !$this->EventCancelled) ew_RenderUploadField($this->kk_dok);

			// Add refer script
			// kk_no_kontrak

			$this->kk_no_kontrak->LinkCustomAttributes = "";
			$this->kk_no_kontrak->HrefValue = "";

			// koord_id
			$this->koord_id->LinkCustomAttributes = "";
			if (!ew_Empty($this->koord_id->CurrentValue)) {
				$this->koord_id->HrefValue = "koordview.php?showdetail=&koord_id=" . $this->koord_id->CurrentValue; // Add prefix/suffix
				$this->koord_id->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->koord_id->HrefValue = ew_FullUrl($this->koord_id->HrefValue, "href");
			} else {
				$this->koord_id->HrefValue = "";
			}

			// kk_tgl_mulai
			$this->kk_tgl_mulai->LinkCustomAttributes = "";
			$this->kk_tgl_mulai->HrefValue = "";

			// kk_tgl_akhir
			$this->kk_tgl_akhir->LinkCustomAttributes = "";
			$this->kk_tgl_akhir->HrefValue = "";

			// kk_periode
			$this->kk_periode->LinkCustomAttributes = "";
			$this->kk_periode->HrefValue = "";

			// var_id
			$this->var_id->LinkCustomAttributes = "";
			$this->var_id->HrefValue = "";

			// kk_harga
			$this->kk_harga->LinkCustomAttributes = "";
			$this->kk_harga->HrefValue = "";

			// kk_luas
			$this->kk_luas->LinkCustomAttributes = "";
			$this->kk_luas->HrefValue = "";

			// kk_dok
			$this->kk_dok->LinkCustomAttributes = "";
			$this->kk_dok->UploadPath = "dokumen_kontrak_koordinator";
			if (!ew_Empty($this->kk_dok->Upload->DbValue)) {
				$this->kk_dok->HrefValue = ew_GetFileUploadUrl($this->kk_dok, $this->kk_dok->Upload->DbValue); // Add prefix/suffix
				$this->kk_dok->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->kk_dok->HrefValue = ew_FullUrl($this->kk_dok->HrefValue, "href");
			} else {
				$this->kk_dok->HrefValue = "";
			}
			$this->kk_dok->HrefValue2 = $this->kk_dok->UploadPath . $this->kk_dok->Upload->DbValue;
		}
		if ($this->RowType == EW_ROWTYPE_ADD || $this->RowType == EW_ROWTYPE_EDIT || $this->RowType == EW_ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->SetupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $Language, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return ($gsFormError == "");
		if (!ew_CheckDate($this->kk_tgl_mulai->FormValue)) {
			ew_AddMessage($gsFormError, $this->kk_tgl_mulai->FldErrMsg());
		}
		if (!ew_CheckDate($this->kk_tgl_akhir->FormValue)) {
			ew_AddMessage($gsFormError, $this->kk_tgl_akhir->FldErrMsg());
		}
		if (!ew_CheckInteger($this->kk_periode->FormValue)) {
			ew_AddMessage($gsFormError, $this->kk_periode->FldErrMsg());
		}
		if (!ew_CheckInteger($this->kk_harga->FormValue)) {
			ew_AddMessage($gsFormError, $this->kk_harga->FldErrMsg());
		}
		if (!ew_CheckInteger($this->kk_luas->FormValue)) {
			ew_AddMessage($gsFormError, $this->kk_luas->FldErrMsg());
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsFormError, $sFormCustomError);
		}
		return $ValidateForm;
	}

	// Add record
	function AddRow($rsold = NULL) {
		global $Language, $Security;
		$conn = &$this->Connection();

		// Load db values from rsold
		$this->LoadDbValues($rsold);
		if ($rsold) {
			$this->kk_dok->OldUploadPath = "dokumen_kontrak_koordinator";
			$this->kk_dok->UploadPath = $this->kk_dok->OldUploadPath;
		}
		$rsnew = array();

		// kk_no_kontrak
		$this->kk_no_kontrak->SetDbValueDef($rsnew, $this->kk_no_kontrak->CurrentValue, NULL, FALSE);

		// koord_id
		$this->koord_id->SetDbValueDef($rsnew, $this->koord_id->CurrentValue, NULL, FALSE);

		// kk_tgl_mulai
		$this->kk_tgl_mulai->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->kk_tgl_mulai->CurrentValue, 5), NULL, FALSE);

		// kk_tgl_akhir
		$this->kk_tgl_akhir->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->kk_tgl_akhir->CurrentValue, 5), NULL, FALSE);

		// kk_periode
		$this->kk_periode->SetDbValueDef($rsnew, $this->kk_periode->CurrentValue, NULL, FALSE);

		// var_id
		$this->var_id->SetDbValueDef($rsnew, $this->var_id->CurrentValue, NULL, FALSE);

		// kk_harga
		$this->kk_harga->SetDbValueDef($rsnew, $this->kk_harga->CurrentValue, NULL, FALSE);

		// kk_luas
		$this->kk_luas->SetDbValueDef($rsnew, $this->kk_luas->CurrentValue, NULL, FALSE);

		// kk_dok
		if ($this->kk_dok->Visible && !$this->kk_dok->Upload->KeepFile) {
			$this->kk_dok->Upload->DbValue = ""; // No need to delete old file
			if ($this->kk_dok->Upload->FileName == "") {
				$rsnew['kk_dok'] = NULL;
			} else {
				$rsnew['kk_dok'] = $this->kk_dok->Upload->FileName;
			}
			$this->kk_dok->ImageWidth = 420; // Resize width
			$this->kk_dok->ImageHeight = 700; // Resize height
		}
		if ($this->kk_dok->Visible && !$this->kk_dok->Upload->KeepFile) {
			$this->kk_dok->UploadPath = "dokumen_kontrak_koordinator";
			$OldFiles = ew_Empty($this->kk_dok->Upload->DbValue) ? array() : array($this->kk_dok->Upload->DbValue);
			if (!ew_Empty($this->kk_dok->Upload->FileName)) {
				$NewFiles = array($this->kk_dok->Upload->FileName);
				$NewFileCount = count($NewFiles);
				for ($i = 0; $i < $NewFileCount; $i++) {
					$fldvar = ($this->kk_dok->Upload->Index < 0) ? $this->kk_dok->FldVar : substr($this->kk_dok->FldVar, 0, 1) . $this->kk_dok->Upload->Index . substr($this->kk_dok->FldVar, 1);
					if ($NewFiles[$i] <> "") {
						$file = $NewFiles[$i];
						if (file_exists(ew_UploadTempPath($fldvar, $this->kk_dok->TblVar) . $file)) {
							$OldFileFound = FALSE;
							$OldFileCount = count($OldFiles);
							for ($j = 0; $j < $OldFileCount; $j++) {
								$file1 = $OldFiles[$j];
								if ($file1 == $file) { // Old file found, no need to delete anymore
									unset($OldFiles[$j]);
									$OldFileFound = TRUE;
									break;
								}
							}
							if ($OldFileFound) // No need to check if file exists further
								continue;
							$file1 = ew_UploadFileNameEx($this->kk_dok->PhysicalUploadPath(), $file); // Get new file name
							if ($file1 <> $file) { // Rename temp file
								while (file_exists(ew_UploadTempPath($fldvar, $this->kk_dok->TblVar) . $file1) || file_exists($this->kk_dok->PhysicalUploadPath() . $file1)) // Make sure no file name clash
									$file1 = ew_UniqueFilename($this->kk_dok->PhysicalUploadPath(), $file1, TRUE); // Use indexed name
								rename(ew_UploadTempPath($fldvar, $this->kk_dok->TblVar) . $file, ew_UploadTempPath($fldvar, $this->kk_dok->TblVar) . $file1);
								$NewFiles[$i] = $file1;
							}
						}
					}
				}
				$this->kk_dok->Upload->DbValue = empty($OldFiles) ? "" : implode(EW_MULTIPLE_UPLOAD_SEPARATOR, $OldFiles);
				$this->kk_dok->Upload->FileName = implode(EW_MULTIPLE_UPLOAD_SEPARATOR, $NewFiles);
				$this->kk_dok->SetDbValueDef($rsnew, $this->kk_dok->Upload->FileName, NULL, FALSE);
			}
		}

		// Call Row Inserting event
		$rs = ($rsold == NULL) ? NULL : $rsold->fields;
		$bInsertRow = $this->Row_Inserting($rs, $rsnew);
		if ($bInsertRow) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			$AddRow = $this->Insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($AddRow) {
				if ($this->kk_dok->Visible && !$this->kk_dok->Upload->KeepFile) {
					$OldFiles = ew_Empty($this->kk_dok->Upload->DbValue) ? array() : array($this->kk_dok->Upload->DbValue);
					if (!ew_Empty($this->kk_dok->Upload->FileName)) {
						$NewFiles = array($this->kk_dok->Upload->FileName);
						$NewFiles2 = array($rsnew['kk_dok']);
						$NewFileCount = count($NewFiles);
						for ($i = 0; $i < $NewFileCount; $i++) {
							$fldvar = ($this->kk_dok->Upload->Index < 0) ? $this->kk_dok->FldVar : substr($this->kk_dok->FldVar, 0, 1) . $this->kk_dok->Upload->Index . substr($this->kk_dok->FldVar, 1);
							if ($NewFiles[$i] <> "") {
								$file = ew_UploadTempPath($fldvar, $this->kk_dok->TblVar) . $NewFiles[$i];
								if (file_exists($file)) {
									if (@$NewFiles2[$i] <> "") // Use correct file name
										$NewFiles[$i] = $NewFiles2[$i];
									if (!$this->kk_dok->Upload->ResizeAndSaveToFile($this->kk_dok->ImageWidth, $this->kk_dok->ImageHeight, EW_THUMBNAIL_DEFAULT_QUALITY, $NewFiles[$i], TRUE, $i)) {
										$this->setFailureMessage($Language->Phrase("UploadErrMsg7"));
										return FALSE;
									}
								}
							}
						}
					} else {
						$NewFiles = array();
					}
					$OldFileCount = count($OldFiles);
					for ($i = 0; $i < $OldFileCount; $i++) {
						if ($OldFiles[$i] <> "" && !in_array($OldFiles[$i], $NewFiles))
							@unlink($this->kk_dok->OldPhysicalUploadPath() . $OldFiles[$i]);
					}
				}
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->Phrase("InsertCancelled"));
			}
			$AddRow = FALSE;
		}
		if ($AddRow) {

			// Call Row Inserted event
			$rs = ($rsold == NULL) ? NULL : $rsold->fields;
			$this->Row_Inserted($rs, $rsnew);
		}

		// kk_dok
		ew_CleanUploadTempPath($this->kk_dok, $this->kk_dok->Upload->Index);
		return $AddRow;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$Breadcrumb->Add("list", $this->TableVar, $this->AddMasterUrl("kontrak_koordlist.php"), "", $this->TableVar, TRUE);
		$PageId = ($this->CurrentAction == "C") ? "Copy" : "Add";
		$Breadcrumb->Add("add", $PageId, $url);
	}

	// Setup lookup filters of a field
	function SetupLookupFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		case "x_koord_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `koord_id` AS `LinkFld`, `koord_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `koord`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`koord_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->koord_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `koord_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_var_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `var_id` AS `LinkFld`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `varietas`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`var_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->var_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		}
	}

	// Setup AutoSuggest filters of a field
	function SetupAutoSuggestFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($kontrak_koord_add)) $kontrak_koord_add = new ckontrak_koord_add();

// Page init
$kontrak_koord_add->Page_Init();

// Page main
$kontrak_koord_add->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$kontrak_koord_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "add";
var CurrentForm = fkontrak_koordadd = new ew_Form("fkontrak_koordadd", "add");

// Validate form
fkontrak_koordadd.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);
	if ($fobj.find("#a_confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.FormKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = $fobj.find("#a_list").val() == "gridinsert";
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
			elm = this.GetElements("x" + infix + "_kk_tgl_mulai");
			if (elm && !ew_CheckDate(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($kontrak_koord->kk_tgl_mulai->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_kk_tgl_akhir");
			if (elm && !ew_CheckDate(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($kontrak_koord->kk_tgl_akhir->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_kk_periode");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($kontrak_koord->kk_periode->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_kk_harga");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($kontrak_koord->kk_harga->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_kk_luas");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($kontrak_koord->kk_luas->FldErrMsg()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ewForms[val])
			if (!ewForms[val].Validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fkontrak_koordadd.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fkontrak_koordadd.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fkontrak_koordadd.Lists["x_koord_id"] = {"LinkField":"x_koord_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_koord_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"koord"};
fkontrak_koordadd.Lists["x_koord_id"].Data = "<?php echo $kontrak_koord_add->koord_id->LookupFilterQuery(FALSE, "add") ?>";
fkontrak_koordadd.Lists["x_var_id"] = {"LinkField":"x_var_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_var_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"varietas"};
fkontrak_koordadd.Lists["x_var_id"].Data = "<?php echo $kontrak_koord_add->var_id->LookupFilterQuery(FALSE, "add") ?>";

// Form object for search
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php $kontrak_koord_add->ShowPageHeader(); ?>
<?php
$kontrak_koord_add->ShowMessage();
?>
<form name="fkontrak_koordadd" id="fkontrak_koordadd" class="<?php echo $kontrak_koord_add->FormClassName ?>" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($kontrak_koord_add->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $kontrak_koord_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="kontrak_koord">
<input type="hidden" name="a_add" id="a_add" value="A">
<input type="hidden" name="modal" value="<?php echo intval($kontrak_koord_add->IsModal) ?>">
<div class="ewAddDiv"><!-- page* -->
<?php if ($kontrak_koord->kk_no_kontrak->Visible) { // kk_no_kontrak ?>
	<div id="r_kk_no_kontrak" class="form-group">
		<label id="elh_kontrak_koord_kk_no_kontrak" for="x_kk_no_kontrak" class="<?php echo $kontrak_koord_add->LeftColumnClass ?>"><?php echo $kontrak_koord->kk_no_kontrak->FldCaption() ?></label>
		<div class="<?php echo $kontrak_koord_add->RightColumnClass ?>"><div<?php echo $kontrak_koord->kk_no_kontrak->CellAttributes() ?>>
<span id="el_kontrak_koord_kk_no_kontrak">
<input type="text" data-table="kontrak_koord" data-field="x_kk_no_kontrak" name="x_kk_no_kontrak" id="x_kk_no_kontrak" size="30" maxlength="50" placeholder="<?php echo ew_HtmlEncode($kontrak_koord->kk_no_kontrak->getPlaceHolder()) ?>" value="<?php echo $kontrak_koord->kk_no_kontrak->EditValue ?>"<?php echo $kontrak_koord->kk_no_kontrak->EditAttributes() ?>>
</span>
<?php echo $kontrak_koord->kk_no_kontrak->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak_koord->koord_id->Visible) { // koord_id ?>
	<div id="r_koord_id" class="form-group">
		<label id="elh_kontrak_koord_koord_id" for="x_koord_id" class="<?php echo $kontrak_koord_add->LeftColumnClass ?>"><?php echo $kontrak_koord->koord_id->FldCaption() ?></label>
		<div class="<?php echo $kontrak_koord_add->RightColumnClass ?>"><div<?php echo $kontrak_koord->koord_id->CellAttributes() ?>>
<span id="el_kontrak_koord_koord_id">
<select data-table="kontrak_koord" data-field="x_koord_id" data-value-separator="<?php echo $kontrak_koord->koord_id->DisplayValueSeparatorAttribute() ?>" id="x_koord_id" name="x_koord_id"<?php echo $kontrak_koord->koord_id->EditAttributes() ?>>
<?php echo $kontrak_koord->koord_id->SelectOptionListHtml("x_koord_id") ?>
</select>
<?php if (AllowAdd(CurrentProjectID() . "koord") && !$kontrak_koord->koord_id->ReadOnly) { ?>
<button type="button" title="<?php echo ew_HtmlTitle($Language->Phrase("AddLink")) . "&nbsp;" . $kontrak_koord->koord_id->FldCaption() ?>" onclick="ew_AddOptDialogShow({lnk:this,el:'x_koord_id',url:'koordaddopt.php'});" class="ewAddOptBtn btn btn-default btn-sm" id="aol_x_koord_id"><span class="glyphicon glyphicon-plus ewIcon"></span><span class="hide"><?php echo $Language->Phrase("AddLink") ?>&nbsp;<?php echo $kontrak_koord->koord_id->FldCaption() ?></span></button>
<?php } ?>
</span>
<?php echo $kontrak_koord->koord_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak_koord->kk_tgl_mulai->Visible) { // kk_tgl_mulai ?>
	<div id="r_kk_tgl_mulai" class="form-group">
		<label id="elh_kontrak_koord_kk_tgl_mulai" for="x_kk_tgl_mulai" class="<?php echo $kontrak_koord_add->LeftColumnClass ?>"><?php echo $kontrak_koord->kk_tgl_mulai->FldCaption() ?></label>
		<div class="<?php echo $kontrak_koord_add->RightColumnClass ?>"><div<?php echo $kontrak_koord->kk_tgl_mulai->CellAttributes() ?>>
<span id="el_kontrak_koord_kk_tgl_mulai">
<input type="text" data-table="kontrak_koord" data-field="x_kk_tgl_mulai" data-format="5" name="x_kk_tgl_mulai" id="x_kk_tgl_mulai" placeholder="<?php echo ew_HtmlEncode($kontrak_koord->kk_tgl_mulai->getPlaceHolder()) ?>" value="<?php echo $kontrak_koord->kk_tgl_mulai->EditValue ?>"<?php echo $kontrak_koord->kk_tgl_mulai->EditAttributes() ?>>
<?php if (!$kontrak_koord->kk_tgl_mulai->ReadOnly && !$kontrak_koord->kk_tgl_mulai->Disabled && !isset($kontrak_koord->kk_tgl_mulai->EditAttrs["readonly"]) && !isset($kontrak_koord->kk_tgl_mulai->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("fkontrak_koordadd", "x_kk_tgl_mulai", {"ignoreReadonly":true,"useCurrent":false,"format":5});
</script>
<?php } ?>
</span>
<?php echo $kontrak_koord->kk_tgl_mulai->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak_koord->kk_tgl_akhir->Visible) { // kk_tgl_akhir ?>
	<div id="r_kk_tgl_akhir" class="form-group">
		<label id="elh_kontrak_koord_kk_tgl_akhir" for="x_kk_tgl_akhir" class="<?php echo $kontrak_koord_add->LeftColumnClass ?>"><?php echo $kontrak_koord->kk_tgl_akhir->FldCaption() ?></label>
		<div class="<?php echo $kontrak_koord_add->RightColumnClass ?>"><div<?php echo $kontrak_koord->kk_tgl_akhir->CellAttributes() ?>>
<span id="el_kontrak_koord_kk_tgl_akhir">
<input type="text" data-table="kontrak_koord" data-field="x_kk_tgl_akhir" data-format="5" name="x_kk_tgl_akhir" id="x_kk_tgl_akhir" placeholder="<?php echo ew_HtmlEncode($kontrak_koord->kk_tgl_akhir->getPlaceHolder()) ?>" value="<?php echo $kontrak_koord->kk_tgl_akhir->EditValue ?>"<?php echo $kontrak_koord->kk_tgl_akhir->EditAttributes() ?>>
<?php if (!$kontrak_koord->kk_tgl_akhir->ReadOnly && !$kontrak_koord->kk_tgl_akhir->Disabled && !isset($kontrak_koord->kk_tgl_akhir->EditAttrs["readonly"]) && !isset($kontrak_koord->kk_tgl_akhir->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("fkontrak_koordadd", "x_kk_tgl_akhir", {"ignoreReadonly":true,"useCurrent":false,"format":5});
</script>
<?php } ?>
</span>
<?php echo $kontrak_koord->kk_tgl_akhir->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak_koord->kk_periode->Visible) { // kk_periode ?>
	<div id="r_kk_periode" class="form-group">
		<label id="elh_kontrak_koord_kk_periode" for="x_kk_periode" class="<?php echo $kontrak_koord_add->LeftColumnClass ?>"><?php echo $kontrak_koord->kk_periode->FldCaption() ?></label>
		<div class="<?php echo $kontrak_koord_add->RightColumnClass ?>"><div<?php echo $kontrak_koord->kk_periode->CellAttributes() ?>>
<span id="el_kontrak_koord_kk_periode">
<input type="text" data-table="kontrak_koord" data-field="x_kk_periode" name="x_kk_periode" id="x_kk_periode" size="30" placeholder="<?php echo ew_HtmlEncode($kontrak_koord->kk_periode->getPlaceHolder()) ?>" value="<?php echo $kontrak_koord->kk_periode->EditValue ?>"<?php echo $kontrak_koord->kk_periode->EditAttributes() ?>>
</span>
<?php echo $kontrak_koord->kk_periode->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak_koord->var_id->Visible) { // var_id ?>
	<div id="r_var_id" class="form-group">
		<label id="elh_kontrak_koord_var_id" for="x_var_id" class="<?php echo $kontrak_koord_add->LeftColumnClass ?>"><?php echo $kontrak_koord->var_id->FldCaption() ?></label>
		<div class="<?php echo $kontrak_koord_add->RightColumnClass ?>"><div<?php echo $kontrak_koord->var_id->CellAttributes() ?>>
<span id="el_kontrak_koord_var_id">
<select data-table="kontrak_koord" data-field="x_var_id" data-value-separator="<?php echo $kontrak_koord->var_id->DisplayValueSeparatorAttribute() ?>" id="x_var_id" name="x_var_id"<?php echo $kontrak_koord->var_id->EditAttributes() ?>>
<?php echo $kontrak_koord->var_id->SelectOptionListHtml("x_var_id") ?>
</select>
</span>
<?php echo $kontrak_koord->var_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak_koord->kk_harga->Visible) { // kk_harga ?>
	<div id="r_kk_harga" class="form-group">
		<label id="elh_kontrak_koord_kk_harga" for="x_kk_harga" class="<?php echo $kontrak_koord_add->LeftColumnClass ?>"><?php echo $kontrak_koord->kk_harga->FldCaption() ?></label>
		<div class="<?php echo $kontrak_koord_add->RightColumnClass ?>"><div<?php echo $kontrak_koord->kk_harga->CellAttributes() ?>>
<span id="el_kontrak_koord_kk_harga">
<input type="text" data-table="kontrak_koord" data-field="x_kk_harga" name="x_kk_harga" id="x_kk_harga" size="30" placeholder="<?php echo ew_HtmlEncode($kontrak_koord->kk_harga->getPlaceHolder()) ?>" value="<?php echo $kontrak_koord->kk_harga->EditValue ?>"<?php echo $kontrak_koord->kk_harga->EditAttributes() ?>>
</span>
<?php echo $kontrak_koord->kk_harga->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak_koord->kk_luas->Visible) { // kk_luas ?>
	<div id="r_kk_luas" class="form-group">
		<label id="elh_kontrak_koord_kk_luas" for="x_kk_luas" class="<?php echo $kontrak_koord_add->LeftColumnClass ?>"><?php echo $kontrak_koord->kk_luas->FldCaption() ?></label>
		<div class="<?php echo $kontrak_koord_add->RightColumnClass ?>"><div<?php echo $kontrak_koord->kk_luas->CellAttributes() ?>>
<span id="el_kontrak_koord_kk_luas">
<input type="text" data-table="kontrak_koord" data-field="x_kk_luas" name="x_kk_luas" id="x_kk_luas" size="30" placeholder="<?php echo ew_HtmlEncode($kontrak_koord->kk_luas->getPlaceHolder()) ?>" value="<?php echo $kontrak_koord->kk_luas->EditValue ?>"<?php echo $kontrak_koord->kk_luas->EditAttributes() ?>>
</span>
<?php echo $kontrak_koord->kk_luas->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak_koord->kk_dok->Visible) { // kk_dok ?>
	<div id="r_kk_dok" class="form-group">
		<label id="elh_kontrak_koord_kk_dok" class="<?php echo $kontrak_koord_add->LeftColumnClass ?>"><?php echo $kontrak_koord->kk_dok->FldCaption() ?></label>
		<div class="<?php echo $kontrak_koord_add->RightColumnClass ?>"><div<?php echo $kontrak_koord->kk_dok->CellAttributes() ?>>
<span id="el_kontrak_koord_kk_dok">
<div id="fd_x_kk_dok">
<span title="<?php echo $kontrak_koord->kk_dok->FldTitle() ? $kontrak_koord->kk_dok->FldTitle() : $Language->Phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ewTooltip<?php if ($kontrak_koord->kk_dok->ReadOnly || $kontrak_koord->kk_dok->Disabled) echo " hide"; ?>" data-trigger="hover">
	<span><?php echo $Language->Phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="kontrak_koord" data-field="x_kk_dok" name="x_kk_dok" id="x_kk_dok"<?php echo $kontrak_koord->kk_dok->EditAttributes() ?>>
</span>
<input type="hidden" name="fn_x_kk_dok" id= "fn_x_kk_dok" value="<?php echo $kontrak_koord->kk_dok->Upload->FileName ?>">
<input type="hidden" name="fa_x_kk_dok" id= "fa_x_kk_dok" value="0">
<input type="hidden" name="fs_x_kk_dok" id= "fs_x_kk_dok" value="50">
<input type="hidden" name="fx_x_kk_dok" id= "fx_x_kk_dok" value="<?php echo $kontrak_koord->kk_dok->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_kk_dok" id= "fm_x_kk_dok" value="<?php echo $kontrak_koord->kk_dok->UploadMaxFileSize ?>">
</div>
<table id="ft_x_kk_dok" class="table table-condensed pull-left ewUploadTable"><tbody class="files"></tbody></table>
</span>
<?php echo $kontrak_koord->kk_dok->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$kontrak_koord_add->IsModal) { ?>
<div class="form-group"><!-- buttons .form-group -->
	<div class="<?php echo $kontrak_koord_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ewButton" name="btnAction" id="btnAction" type="submit"><?php echo $Language->Phrase("AddBtn") ?></button>
<button class="btn btn-default ewButton" name="btnCancel" id="btnCancel" type="button" data-href="<?php echo $kontrak_koord_add->getReturnUrl() ?>"><?php echo $Language->Phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<script type="text/javascript">
fkontrak_koordadd.Init();
</script>
<?php
$kontrak_koord_add->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$kontrak_koord_add->Page_Terminate();
?>
