<?php
if (session_id() == "") session_start(); // Init session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg14.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql14.php") ?>
<?php include_once "phpfn14.php" ?>
<?php include_once "kegiatan_harianinfo.php" ?>
<?php include_once "employeesinfo.php" ?>
<?php include_once "userfn14.php" ?>
<?php

//
// Page class
//

$kegiatan_harian_edit = NULL; // Initialize page object first

class ckegiatan_harian_edit extends ckegiatan_harian {

	// Page ID
	var $PageID = 'edit';

	// Project ID
	var $ProjectID = '{CC60B42B-604B-412A-B014-2315920AF6AA}';

	// Table name
	var $TableName = 'kegiatan_harian';

	// Page object name
	var $PageObjName = 'kegiatan_harian_edit';

	// Page headings
	var $Heading = '';
	var $Subheading = '';

	// Page heading
	function PageHeading() {
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->TableCaption();
		return "";
	}

	// Page subheading
	function PageSubheading() {
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->Phrase($this->PageID);
		return "";
	}

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (kegiatan_harian)
		if (!isset($GLOBALS["kegiatan_harian"]) || get_class($GLOBALS["kegiatan_harian"]) == "ckegiatan_harian") {
			$GLOBALS["kegiatan_harian"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["kegiatan_harian"];
		}

		// Table object (employees)
		if (!isset($GLOBALS['employees'])) $GLOBALS['employees'] = new cemployees();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'edit', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'kegiatan_harian', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"]))
			$GLOBALS["gTimer"] = new cTimer();

		// Debug message
		ew_LoadDebugMsg();

		// Open connection
		if (!isset($conn))
			$conn = ew_Connect($this->DBID);

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new cemployees();
			$UserTableConn = Conn($UserTable->DBID);
		}
	}

	//
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Is modal
		$this->IsModal = (@$_GET["modal"] == "1" || @$_POST["modal"] == "1");

		// User profile
		$UserProfile = new cUserProfile();

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanEdit()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			if ($Security->CanList())
				$this->Page_Terminate(ew_GetUrl("kegiatan_harianlist.php"));
			else
				$this->Page_Terminate(ew_GetUrl("login.php"));
		}

		// NOTE: Security object may be needed in other part of the script, skip set to Nothing
		// 
		// Security = null;
		// 
		// Create form object

		$objForm = new cFormObj();
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action
		$this->kh_id->SetVisibility();
		if ($this->IsAdd() || $this->IsCopy() || $this->IsGridAdd())
			$this->kh_id->Visible = FALSE;
		$this->kh_tgl->SetVisibility();
		$this->kh_co_id->SetVisibility();
		$this->kh_rencana->SetVisibility();
		$this->kh_realisasi->SetVisibility();
		$this->kh_hasil->SetVisibility();
		$this->kh_foto->SetVisibility();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $kegiatan_harian;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($kegiatan_harian);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		// Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = ew_GetPageName($url);
				if ($pageName != $this->GetListUrl()) { // Not List page
					$row["caption"] = $this->GetModalCaption($pageName);
					if ($pageName == "kegiatan_harianview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				header("Content-Type: application/json; charset=utf-8");
				echo ew_ConvertToUtf8(ew_ArrayToJson(array($row)));
			} else {
				ew_SaveDebugMsg();
				header("Location: " . $url);
			}
		}
		exit();
	}
	var $FormClassName = "form-horizontal ewForm ewEditForm";
	var $IsModal = FALSE;
	var $IsMobileOrModal = FALSE;
	var $DbMasterFilter;
	var $DbDetailFilter;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError, $gbSkipHeaderFooter;

		// Check modal
		if ($this->IsModal)
			$gbSkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = ew_IsMobile() || $this->IsModal;
		$this->FormClassName = "ewForm ewEditForm form-horizontal";
		$sReturnUrl = "";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (@$_POST["a_edit"] <> "") {
			$this->CurrentAction = $_POST["a_edit"]; // Get action code
			if ($this->CurrentAction <> "I") // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($objForm->HasValue("x_kh_id")) {
				$this->kh_id->setFormValue($objForm->GetValue("x_kh_id"));
			}
		} else {
			$this->CurrentAction = "I"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (isset($_GET["kh_id"])) {
				$this->kh_id->setQueryStringValue($_GET["kh_id"]);
				$loadByQuery = TRUE;
			} else {
				$this->kh_id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->LoadRow();

		// Process form if post back
		if ($postBack) {
			$this->LoadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->ValidateForm()) {
				$this->CurrentAction = ""; // Form error, reset action
				$this->setFailureMessage($gsFormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->RestoreFormValues();
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "I": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "") $this->setFailureMessage($Language->Phrase("NoRecord")); // No record found
					$this->Page_Terminate("kegiatan_harianlist.php"); // No matching record, return to list
				}
				break;
			Case "U": // Update
				$sReturnUrl = $this->getReturnUrl();
				if (ew_GetPageName($sReturnUrl) == "kegiatan_harianlist.php")
					$sReturnUrl = $this->AddMasterUrl($sReturnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->EditRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->Phrase("UpdateSuccess")); // Update success
					$this->Page_Terminate($sReturnUrl); // Return to caller
				} elseif ($this->getFailureMessage() == $Language->Phrase("NoRecord")) {
					$this->Page_Terminate($sReturnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->RestoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->SetupBreadcrumb();

		// Render the record
		$this->RowType = EW_ROWTYPE_EDIT; // Render as Edit
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Set up starting record parameters
	function SetupStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	function GetUploadFiles() {
		global $objForm, $Language;

		// Get upload data
		$this->kh_foto->Upload->Index = $objForm->Index;
		$this->kh_foto->Upload->UploadFile();
		$this->kh_foto->CurrentValue = $this->kh_foto->Upload->FileName;
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm;
		$this->GetUploadFiles(); // Get upload files
		if (!$this->kh_id->FldIsDetailKey)
			$this->kh_id->setFormValue($objForm->GetValue("x_kh_id"));
		if (!$this->kh_tgl->FldIsDetailKey) {
			$this->kh_tgl->setFormValue($objForm->GetValue("x_kh_tgl"));
			$this->kh_tgl->CurrentValue = ew_UnFormatDateTime($this->kh_tgl->CurrentValue, 0);
		}
		if (!$this->kh_co_id->FldIsDetailKey) {
			$this->kh_co_id->setFormValue($objForm->GetValue("x_kh_co_id"));
		}
		if (!$this->kh_rencana->FldIsDetailKey) {
			$this->kh_rencana->setFormValue($objForm->GetValue("x_kh_rencana"));
		}
		if (!$this->kh_realisasi->FldIsDetailKey) {
			$this->kh_realisasi->setFormValue($objForm->GetValue("x_kh_realisasi"));
		}
		if (!$this->kh_hasil->FldIsDetailKey) {
			$this->kh_hasil->setFormValue($objForm->GetValue("x_kh_hasil"));
		}
	}

	// Restore form values
	function RestoreFormValues() {
		global $objForm;
		$this->kh_id->CurrentValue = $this->kh_id->FormValue;
		$this->kh_tgl->CurrentValue = $this->kh_tgl->FormValue;
		$this->kh_tgl->CurrentValue = ew_UnFormatDateTime($this->kh_tgl->CurrentValue, 0);
		$this->kh_co_id->CurrentValue = $this->kh_co_id->FormValue;
		$this->kh_rencana->CurrentValue = $this->kh_rencana->FormValue;
		$this->kh_realisasi->CurrentValue = $this->kh_realisasi->FormValue;
		$this->kh_hasil->CurrentValue = $this->kh_hasil->FormValue;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues($rs = NULL) {
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->NewRow(); 

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->kh_id->setDbValue($row['kh_id']);
		$this->kh_tgl->setDbValue($row['kh_tgl']);
		$this->kh_co_id->setDbValue($row['kh_co_id']);
		$this->kh_rencana->setDbValue($row['kh_rencana']);
		$this->kh_realisasi->setDbValue($row['kh_realisasi']);
		$this->kh_hasil->setDbValue($row['kh_hasil']);
		$this->kh_foto->Upload->DbValue = $row['kh_foto'];
		$this->kh_foto->setDbValue($this->kh_foto->Upload->DbValue);
	}

	// Return a row with default values
	function NewRow() {
		$row = array();
		$row['kh_id'] = NULL;
		$row['kh_tgl'] = NULL;
		$row['kh_co_id'] = NULL;
		$row['kh_rencana'] = NULL;
		$row['kh_realisasi'] = NULL;
		$row['kh_hasil'] = NULL;
		$row['kh_foto'] = NULL;
		return $row;
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->kh_id->DbValue = $row['kh_id'];
		$this->kh_tgl->DbValue = $row['kh_tgl'];
		$this->kh_co_id->DbValue = $row['kh_co_id'];
		$this->kh_rencana->DbValue = $row['kh_rencana'];
		$this->kh_realisasi->DbValue = $row['kh_realisasi'];
		$this->kh_hasil->DbValue = $row['kh_hasil'];
		$this->kh_foto->Upload->DbValue = $row['kh_foto'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("kh_id")) <> "")
			$this->kh_id->CurrentValue = $this->getKey("kh_id"); // kh_id
		else
			$bValidKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
		}
		$this->LoadRowValues($this->OldRecordset); // Load row values
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// kh_id
		// kh_tgl
		// kh_co_id
		// kh_rencana
		// kh_realisasi
		// kh_hasil
		// kh_foto

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// kh_id
		$this->kh_id->ViewValue = $this->kh_id->CurrentValue;
		$this->kh_id->ViewCustomAttributes = "";

		// kh_tgl
		$this->kh_tgl->ViewValue = $this->kh_tgl->CurrentValue;
		$this->kh_tgl->ViewValue = ew_FormatDateTime($this->kh_tgl->ViewValue, 0);
		$this->kh_tgl->ViewCustomAttributes = "";

		// kh_co_id
		if (strval($this->kh_co_id->CurrentValue) <> "") {
			$sFilterWrk = "`co_id`" . ew_SearchString("=", $this->kh_co_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `co_id`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `co`";
		$sWhereWrk = "";
		$this->kh_co_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->kh_co_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->kh_co_id->ViewValue = $this->kh_co_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->kh_co_id->ViewValue = $this->kh_co_id->CurrentValue;
			}
		} else {
			$this->kh_co_id->ViewValue = NULL;
		}
		$this->kh_co_id->ViewCustomAttributes = "";

		// kh_rencana
		$this->kh_rencana->ViewValue = $this->kh_rencana->CurrentValue;
		$this->kh_rencana->ViewCustomAttributes = "";

		// kh_realisasi
		$this->kh_realisasi->ViewValue = $this->kh_realisasi->CurrentValue;
		$this->kh_realisasi->ViewCustomAttributes = "";

		// kh_hasil
		$this->kh_hasil->ViewValue = $this->kh_hasil->CurrentValue;
		$this->kh_hasil->ViewCustomAttributes = "";

		// kh_foto
		$this->kh_foto->UploadPath = "kegiatan_foto";
		if (!ew_Empty($this->kh_foto->Upload->DbValue)) {
			$this->kh_foto->ImageWidth = 80;
			$this->kh_foto->ImageHeight = 60;
			$this->kh_foto->ImageAlt = $this->kh_foto->FldAlt();
			$this->kh_foto->ViewValue = $this->kh_foto->Upload->DbValue;
		} else {
			$this->kh_foto->ViewValue = "";
		}
		$this->kh_foto->CellCssStyle .= "text-align: center;";
		$this->kh_foto->ViewCustomAttributes = "";

			// kh_id
			$this->kh_id->LinkCustomAttributes = "";
			$this->kh_id->HrefValue = "";
			$this->kh_id->TooltipValue = "";

			// kh_tgl
			$this->kh_tgl->LinkCustomAttributes = "";
			$this->kh_tgl->HrefValue = "";
			$this->kh_tgl->TooltipValue = "";

			// kh_co_id
			$this->kh_co_id->LinkCustomAttributes = "";
			$this->kh_co_id->HrefValue = "";
			$this->kh_co_id->TooltipValue = "";

			// kh_rencana
			$this->kh_rencana->LinkCustomAttributes = "";
			$this->kh_rencana->HrefValue = "";
			$this->kh_rencana->TooltipValue = "";

			// kh_realisasi
			$this->kh_realisasi->LinkCustomAttributes = "";
			$this->kh_realisasi->HrefValue = "";
			$this->kh_realisasi->TooltipValue = "";

			// kh_hasil
			$this->kh_hasil->LinkCustomAttributes = "";
			$this->kh_hasil->HrefValue = "";
			$this->kh_hasil->TooltipValue = "";

			// kh_foto
			$this->kh_foto->LinkCustomAttributes = "";
			$this->kh_foto->UploadPath = "kegiatan_foto";
			if (!ew_Empty($this->kh_foto->Upload->DbValue)) {
				$this->kh_foto->HrefValue = "%u"; // Add prefix/suffix
				$this->kh_foto->LinkAttrs["target"] = ""; // Add target
				if ($this->Export <> "") $this->kh_foto->HrefValue = ew_FullUrl($this->kh_foto->HrefValue, "href");
			} else {
				$this->kh_foto->HrefValue = "";
			}
			$this->kh_foto->HrefValue2 = $this->kh_foto->UploadPath . $this->kh_foto->Upload->DbValue;
			$this->kh_foto->TooltipValue = "";
			if ($this->kh_foto->UseColorbox) {
				if (ew_Empty($this->kh_foto->TooltipValue))
					$this->kh_foto->LinkAttrs["title"] = $Language->Phrase("ViewImageGallery");
				$this->kh_foto->LinkAttrs["data-rel"] = "kegiatan_harian_x_kh_foto";
				ew_AppendClass($this->kh_foto->LinkAttrs["class"], "ewLightbox");
			}
		} elseif ($this->RowType == EW_ROWTYPE_EDIT) { // Edit row

			// kh_id
			$this->kh_id->EditAttrs["class"] = "form-control";
			$this->kh_id->EditCustomAttributes = "";
			$this->kh_id->EditValue = $this->kh_id->CurrentValue;
			$this->kh_id->ViewCustomAttributes = "";

			// kh_tgl
			$this->kh_tgl->EditAttrs["class"] = "form-control";
			$this->kh_tgl->EditCustomAttributes = "";
			$this->kh_tgl->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->kh_tgl->CurrentValue, 8));
			$this->kh_tgl->PlaceHolder = ew_RemoveHtml($this->kh_tgl->FldCaption());

			// kh_co_id
			$this->kh_co_id->EditAttrs["class"] = "form-control";
			$this->kh_co_id->EditCustomAttributes = "";
			if (trim(strval($this->kh_co_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`co_id`" . ew_SearchString("=", $this->kh_co_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `co_id`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `co`";
			$sWhereWrk = "";
			$this->kh_co_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->kh_co_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->kh_co_id->EditValue = $arwrk;

			// kh_rencana
			$this->kh_rencana->EditAttrs["class"] = "form-control";
			$this->kh_rencana->EditCustomAttributes = "";
			$this->kh_rencana->EditValue = $this->kh_rencana->CurrentValue;
			$this->kh_rencana->ViewCustomAttributes = "";

			// kh_realisasi
			$this->kh_realisasi->EditAttrs["class"] = "form-control";
			$this->kh_realisasi->EditCustomAttributes = "";
			$this->kh_realisasi->EditValue = ew_HtmlEncode($this->kh_realisasi->CurrentValue);
			$this->kh_realisasi->PlaceHolder = ew_RemoveHtml($this->kh_realisasi->FldCaption());

			// kh_hasil
			$this->kh_hasil->EditAttrs["class"] = "form-control";
			$this->kh_hasil->EditCustomAttributes = "";
			$this->kh_hasil->EditValue = ew_HtmlEncode($this->kh_hasil->CurrentValue);
			$this->kh_hasil->PlaceHolder = ew_RemoveHtml($this->kh_hasil->FldCaption());

			// kh_foto
			$this->kh_foto->EditAttrs["class"] = "form-control";
			$this->kh_foto->EditCustomAttributes = "";
			$this->kh_foto->UploadPath = "kegiatan_foto";
			if (!ew_Empty($this->kh_foto->Upload->DbValue)) {
				$this->kh_foto->ImageWidth = 80;
				$this->kh_foto->ImageHeight = 60;
				$this->kh_foto->ImageAlt = $this->kh_foto->FldAlt();
				$this->kh_foto->EditValue = $this->kh_foto->Upload->DbValue;
			} else {
				$this->kh_foto->EditValue = "";
			}
			if (!ew_Empty($this->kh_foto->CurrentValue))
					$this->kh_foto->Upload->FileName = $this->kh_foto->CurrentValue;
			if ($this->CurrentAction == "I" && !$this->EventCancelled) ew_RenderUploadField($this->kh_foto);

			// Edit refer script
			// kh_id

			$this->kh_id->LinkCustomAttributes = "";
			$this->kh_id->HrefValue = "";

			// kh_tgl
			$this->kh_tgl->LinkCustomAttributes = "";
			$this->kh_tgl->HrefValue = "";

			// kh_co_id
			$this->kh_co_id->LinkCustomAttributes = "";
			$this->kh_co_id->HrefValue = "";

			// kh_rencana
			$this->kh_rencana->LinkCustomAttributes = "";
			$this->kh_rencana->HrefValue = "";
			$this->kh_rencana->TooltipValue = "";

			// kh_realisasi
			$this->kh_realisasi->LinkCustomAttributes = "";
			$this->kh_realisasi->HrefValue = "";

			// kh_hasil
			$this->kh_hasil->LinkCustomAttributes = "";
			$this->kh_hasil->HrefValue = "";

			// kh_foto
			$this->kh_foto->LinkCustomAttributes = "";
			$this->kh_foto->UploadPath = "kegiatan_foto";
			if (!ew_Empty($this->kh_foto->Upload->DbValue)) {
				$this->kh_foto->HrefValue = "%u"; // Add prefix/suffix
				$this->kh_foto->LinkAttrs["target"] = ""; // Add target
				if ($this->Export <> "") $this->kh_foto->HrefValue = ew_FullUrl($this->kh_foto->HrefValue, "href");
			} else {
				$this->kh_foto->HrefValue = "";
			}
			$this->kh_foto->HrefValue2 = $this->kh_foto->UploadPath . $this->kh_foto->Upload->DbValue;
		}
		if ($this->RowType == EW_ROWTYPE_ADD || $this->RowType == EW_ROWTYPE_EDIT || $this->RowType == EW_ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->SetupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $Language, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return ($gsFormError == "");
		if (!$this->kh_tgl->FldIsDetailKey && !is_null($this->kh_tgl->FormValue) && $this->kh_tgl->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->kh_tgl->FldCaption(), $this->kh_tgl->ReqErrMsg));
		}
		if (!ew_CheckDateDef($this->kh_tgl->FormValue)) {
			ew_AddMessage($gsFormError, $this->kh_tgl->FldErrMsg());
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsFormError, $sFormCustomError);
		}
		return $ValidateForm;
	}

	// Update record based on key values
	function EditRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();
		$sFilter = $this->ApplyUserIDFilters($sFilter);
		$conn = &$this->Connection();
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
		$rs = $conn->Execute($sSql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->Phrase("NoRecord")); // Set no record message
			$EditRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->LoadDbValues($rsold);
			$this->kh_foto->OldUploadPath = "kegiatan_foto";
			$this->kh_foto->UploadPath = $this->kh_foto->OldUploadPath;
			$rsnew = array();

			// kh_tgl
			$this->kh_tgl->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->kh_tgl->CurrentValue, 0), NULL, $this->kh_tgl->ReadOnly);

			// kh_co_id
			$this->kh_co_id->SetDbValueDef($rsnew, $this->kh_co_id->CurrentValue, NULL, $this->kh_co_id->ReadOnly);

			// kh_realisasi
			$this->kh_realisasi->SetDbValueDef($rsnew, $this->kh_realisasi->CurrentValue, NULL, $this->kh_realisasi->ReadOnly);

			// kh_hasil
			$this->kh_hasil->SetDbValueDef($rsnew, $this->kh_hasil->CurrentValue, NULL, $this->kh_hasil->ReadOnly);

			// kh_foto
			if ($this->kh_foto->Visible && !$this->kh_foto->ReadOnly && !$this->kh_foto->Upload->KeepFile) {
				$this->kh_foto->Upload->DbValue = $rsold['kh_foto']; // Get original value
				if ($this->kh_foto->Upload->FileName == "") {
					$rsnew['kh_foto'] = NULL;
				} else {
					$rsnew['kh_foto'] = $this->kh_foto->Upload->FileName;
				}
				$this->kh_foto->ImageWidth = 800; // Resize width
				$this->kh_foto->ImageHeight = 600; // Resize height
			}
			if ($this->kh_foto->Visible && !$this->kh_foto->Upload->KeepFile) {
				$this->kh_foto->UploadPath = "kegiatan_foto";
				$OldFiles = ew_Empty($this->kh_foto->Upload->DbValue) ? array() : explode(EW_MULTIPLE_UPLOAD_SEPARATOR, strval($this->kh_foto->Upload->DbValue));
				if (!ew_Empty($this->kh_foto->Upload->FileName)) {
					$NewFiles = explode(EW_MULTIPLE_UPLOAD_SEPARATOR, strval($this->kh_foto->Upload->FileName));
					$NewFileCount = count($NewFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						$fldvar = ($this->kh_foto->Upload->Index < 0) ? $this->kh_foto->FldVar : substr($this->kh_foto->FldVar, 0, 1) . $this->kh_foto->Upload->Index . substr($this->kh_foto->FldVar, 1);
						if ($NewFiles[$i] <> "") {
							$file = $NewFiles[$i];
							if (file_exists(ew_UploadTempPath($fldvar, $this->kh_foto->TblVar) . $file)) {
								$OldFileFound = FALSE;
								$OldFileCount = count($OldFiles);
								for ($j = 0; $j < $OldFileCount; $j++) {
									$file1 = $OldFiles[$j];
									if ($file1 == $file) { // Old file found, no need to delete anymore
										unset($OldFiles[$j]);
										$OldFileFound = TRUE;
										break;
									}
								}
								if ($OldFileFound) // No need to check if file exists further
									continue;
								$file1 = ew_UploadFileNameEx($this->kh_foto->PhysicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(ew_UploadTempPath($fldvar, $this->kh_foto->TblVar) . $file1) || file_exists($this->kh_foto->PhysicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = ew_UniqueFilename($this->kh_foto->PhysicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(ew_UploadTempPath($fldvar, $this->kh_foto->TblVar) . $file, ew_UploadTempPath($fldvar, $this->kh_foto->TblVar) . $file1);
									$NewFiles[$i] = $file1;
								}
							}
						}
					}
					$this->kh_foto->Upload->DbValue = empty($OldFiles) ? "" : implode(EW_MULTIPLE_UPLOAD_SEPARATOR, $OldFiles);
					$this->kh_foto->Upload->FileName = implode(EW_MULTIPLE_UPLOAD_SEPARATOR, $NewFiles);
					$this->kh_foto->SetDbValueDef($rsnew, $this->kh_foto->Upload->FileName, NULL, $this->kh_foto->ReadOnly);
				}
			}

			// Call Row Updating event
			$bUpdateRow = $this->Row_Updating($rsold, $rsnew);
			if ($bUpdateRow) {
				$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
				if (count($rsnew) > 0)
					$EditRow = $this->Update($rsnew, "", $rsold);
				else
					$EditRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($EditRow) {
					if ($this->kh_foto->Visible && !$this->kh_foto->Upload->KeepFile) {
						$OldFiles = ew_Empty($this->kh_foto->Upload->DbValue) ? array() : explode(EW_MULTIPLE_UPLOAD_SEPARATOR, strval($this->kh_foto->Upload->DbValue));
						if (!ew_Empty($this->kh_foto->Upload->FileName)) {
							$NewFiles = explode(EW_MULTIPLE_UPLOAD_SEPARATOR, $this->kh_foto->Upload->FileName);
							$NewFiles2 = explode(EW_MULTIPLE_UPLOAD_SEPARATOR, $rsnew['kh_foto']);
							$NewFileCount = count($NewFiles);
							for ($i = 0; $i < $NewFileCount; $i++) {
								$fldvar = ($this->kh_foto->Upload->Index < 0) ? $this->kh_foto->FldVar : substr($this->kh_foto->FldVar, 0, 1) . $this->kh_foto->Upload->Index . substr($this->kh_foto->FldVar, 1);
								if ($NewFiles[$i] <> "") {
									$file = ew_UploadTempPath($fldvar, $this->kh_foto->TblVar) . $NewFiles[$i];
									if (file_exists($file)) {
										if (@$NewFiles2[$i] <> "") // Use correct file name
											$NewFiles[$i] = $NewFiles2[$i];
										if (!$this->kh_foto->Upload->ResizeAndSaveToFile($this->kh_foto->ImageWidth, $this->kh_foto->ImageHeight, EW_THUMBNAIL_DEFAULT_QUALITY, $NewFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->Phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$NewFiles = array();
						}
						$OldFileCount = count($OldFiles);
						for ($i = 0; $i < $OldFileCount; $i++) {
							if ($OldFiles[$i] <> "" && !in_array($OldFiles[$i], $NewFiles))
								@unlink($this->kh_foto->OldPhysicalUploadPath() . $OldFiles[$i]);
						}
					}
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->Phrase("UpdateCancelled"));
				}
				$EditRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($EditRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->Close();

		// kh_foto
		ew_CleanUploadTempPath($this->kh_foto, $this->kh_foto->Upload->Index);
		return $EditRow;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$Breadcrumb->Add("list", $this->TableVar, $this->AddMasterUrl("kegiatan_harianlist.php"), "", $this->TableVar, TRUE);
		$PageId = "edit";
		$Breadcrumb->Add("edit", $PageId, $url);
	}

	// Setup lookup filters of a field
	function SetupLookupFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		case "x_kh_co_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `co_id` AS `LinkFld`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `co`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`co_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->kh_co_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		}
	}

	// Setup AutoSuggest filters of a field
	function SetupAutoSuggestFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($kegiatan_harian_edit)) $kegiatan_harian_edit = new ckegiatan_harian_edit();

// Page init
$kegiatan_harian_edit->Page_Init();

// Page main
$kegiatan_harian_edit->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$kegiatan_harian_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "edit";
var CurrentForm = fkegiatan_harianedit = new ew_Form("fkegiatan_harianedit", "edit");

// Validate form
fkegiatan_harianedit.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);
	if ($fobj.find("#a_confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.FormKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = $fobj.find("#a_list").val() == "gridinsert";
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
			elm = this.GetElements("x" + infix + "_kh_tgl");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $kegiatan_harian->kh_tgl->FldCaption(), $kegiatan_harian->kh_tgl->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_kh_tgl");
			if (elm && !ew_CheckDateDef(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($kegiatan_harian->kh_tgl->FldErrMsg()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ewForms[val])
			if (!ewForms[val].Validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fkegiatan_harianedit.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fkegiatan_harianedit.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fkegiatan_harianedit.Lists["x_kh_co_id"] = {"LinkField":"x_co_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_co_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"co"};
fkegiatan_harianedit.Lists["x_kh_co_id"].Data = "<?php echo $kegiatan_harian_edit->kh_co_id->LookupFilterQuery(FALSE, "edit") ?>";

// Form object for search
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php $kegiatan_harian_edit->ShowPageHeader(); ?>
<?php
$kegiatan_harian_edit->ShowMessage();
?>
<form name="fkegiatan_harianedit" id="fkegiatan_harianedit" class="<?php echo $kegiatan_harian_edit->FormClassName ?>" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($kegiatan_harian_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $kegiatan_harian_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="kegiatan_harian">
<input type="hidden" name="a_edit" id="a_edit" value="U">
<input type="hidden" name="modal" value="<?php echo intval($kegiatan_harian_edit->IsModal) ?>">
<div class="ewEditDiv"><!-- page* -->
<?php if ($kegiatan_harian->kh_id->Visible) { // kh_id ?>
	<div id="r_kh_id" class="form-group">
		<label id="elh_kegiatan_harian_kh_id" class="<?php echo $kegiatan_harian_edit->LeftColumnClass ?>"><?php echo $kegiatan_harian->kh_id->FldCaption() ?></label>
		<div class="<?php echo $kegiatan_harian_edit->RightColumnClass ?>"><div<?php echo $kegiatan_harian->kh_id->CellAttributes() ?>>
<span id="el_kegiatan_harian_kh_id">
<span<?php echo $kegiatan_harian->kh_id->ViewAttributes() ?>>
<p class="form-control-static"><?php echo $kegiatan_harian->kh_id->EditValue ?></p></span>
</span>
<input type="hidden" data-table="kegiatan_harian" data-field="x_kh_id" name="x_kh_id" id="x_kh_id" value="<?php echo ew_HtmlEncode($kegiatan_harian->kh_id->CurrentValue) ?>">
<?php echo $kegiatan_harian->kh_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kegiatan_harian->kh_tgl->Visible) { // kh_tgl ?>
	<div id="r_kh_tgl" class="form-group">
		<label id="elh_kegiatan_harian_kh_tgl" for="x_kh_tgl" class="<?php echo $kegiatan_harian_edit->LeftColumnClass ?>"><?php echo $kegiatan_harian->kh_tgl->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $kegiatan_harian_edit->RightColumnClass ?>"><div<?php echo $kegiatan_harian->kh_tgl->CellAttributes() ?>>
<span id="el_kegiatan_harian_kh_tgl">
<input type="text" data-table="kegiatan_harian" data-field="x_kh_tgl" name="x_kh_tgl" id="x_kh_tgl" placeholder="<?php echo ew_HtmlEncode($kegiatan_harian->kh_tgl->getPlaceHolder()) ?>" value="<?php echo $kegiatan_harian->kh_tgl->EditValue ?>"<?php echo $kegiatan_harian->kh_tgl->EditAttributes() ?>>
<?php if (!$kegiatan_harian->kh_tgl->ReadOnly && !$kegiatan_harian->kh_tgl->Disabled && !isset($kegiatan_harian->kh_tgl->EditAttrs["readonly"]) && !isset($kegiatan_harian->kh_tgl->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("fkegiatan_harianedit", "x_kh_tgl", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $kegiatan_harian->kh_tgl->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kegiatan_harian->kh_co_id->Visible) { // kh_co_id ?>
	<div id="r_kh_co_id" class="form-group">
		<label id="elh_kegiatan_harian_kh_co_id" for="x_kh_co_id" class="<?php echo $kegiatan_harian_edit->LeftColumnClass ?>"><?php echo $kegiatan_harian->kh_co_id->FldCaption() ?></label>
		<div class="<?php echo $kegiatan_harian_edit->RightColumnClass ?>"><div<?php echo $kegiatan_harian->kh_co_id->CellAttributes() ?>>
<span id="el_kegiatan_harian_kh_co_id">
<select data-table="kegiatan_harian" data-field="x_kh_co_id" data-value-separator="<?php echo $kegiatan_harian->kh_co_id->DisplayValueSeparatorAttribute() ?>" id="x_kh_co_id" name="x_kh_co_id"<?php echo $kegiatan_harian->kh_co_id->EditAttributes() ?>>
<?php echo $kegiatan_harian->kh_co_id->SelectOptionListHtml("x_kh_co_id") ?>
</select>
</span>
<?php echo $kegiatan_harian->kh_co_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kegiatan_harian->kh_rencana->Visible) { // kh_rencana ?>
	<div id="r_kh_rencana" class="form-group">
		<label id="elh_kegiatan_harian_kh_rencana" class="<?php echo $kegiatan_harian_edit->LeftColumnClass ?>"><?php echo $kegiatan_harian->kh_rencana->FldCaption() ?></label>
		<div class="<?php echo $kegiatan_harian_edit->RightColumnClass ?>"><div<?php echo $kegiatan_harian->kh_rencana->CellAttributes() ?>>
<span id="el_kegiatan_harian_kh_rencana">
<?php ew_AppendClass($kegiatan_harian->kh_rencana->EditAttrs["class"], "editor"); ?>
<textarea data-table="kegiatan_harian" data-field="x_kh_rencana" name="x_kh_rencana" id="x_kh_rencana" cols="35" rows="4" placeholder="<?php echo ew_HtmlEncode($kegiatan_harian->kh_rencana->getPlaceHolder()) ?>"<?php echo $kegiatan_harian->kh_rencana->EditAttributes() ?>><?php echo $kegiatan_harian->kh_rencana->EditValue ?></textarea>
<script type="text/javascript">
ew_CreateEditor("fkegiatan_harianedit", "x_kh_rencana", 35, 4, <?php echo ($kegiatan_harian->kh_rencana->ReadOnly || TRUE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $kegiatan_harian->kh_rencana->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kegiatan_harian->kh_realisasi->Visible) { // kh_realisasi ?>
	<div id="r_kh_realisasi" class="form-group">
		<label id="elh_kegiatan_harian_kh_realisasi" class="<?php echo $kegiatan_harian_edit->LeftColumnClass ?>"><?php echo $kegiatan_harian->kh_realisasi->FldCaption() ?></label>
		<div class="<?php echo $kegiatan_harian_edit->RightColumnClass ?>"><div<?php echo $kegiatan_harian->kh_realisasi->CellAttributes() ?>>
<span id="el_kegiatan_harian_kh_realisasi">
<?php ew_AppendClass($kegiatan_harian->kh_realisasi->EditAttrs["class"], "editor"); ?>
<textarea data-table="kegiatan_harian" data-field="x_kh_realisasi" name="x_kh_realisasi" id="x_kh_realisasi" cols="35" rows="4" placeholder="<?php echo ew_HtmlEncode($kegiatan_harian->kh_realisasi->getPlaceHolder()) ?>"<?php echo $kegiatan_harian->kh_realisasi->EditAttributes() ?>><?php echo $kegiatan_harian->kh_realisasi->EditValue ?></textarea>
<script type="text/javascript">
ew_CreateEditor("fkegiatan_harianedit", "x_kh_realisasi", 35, 4, <?php echo ($kegiatan_harian->kh_realisasi->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $kegiatan_harian->kh_realisasi->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kegiatan_harian->kh_hasil->Visible) { // kh_hasil ?>
	<div id="r_kh_hasil" class="form-group">
		<label id="elh_kegiatan_harian_kh_hasil" class="<?php echo $kegiatan_harian_edit->LeftColumnClass ?>"><?php echo $kegiatan_harian->kh_hasil->FldCaption() ?></label>
		<div class="<?php echo $kegiatan_harian_edit->RightColumnClass ?>"><div<?php echo $kegiatan_harian->kh_hasil->CellAttributes() ?>>
<span id="el_kegiatan_harian_kh_hasil">
<?php ew_AppendClass($kegiatan_harian->kh_hasil->EditAttrs["class"], "editor"); ?>
<textarea data-table="kegiatan_harian" data-field="x_kh_hasil" name="x_kh_hasil" id="x_kh_hasil" cols="35" rows="4" placeholder="<?php echo ew_HtmlEncode($kegiatan_harian->kh_hasil->getPlaceHolder()) ?>"<?php echo $kegiatan_harian->kh_hasil->EditAttributes() ?>><?php echo $kegiatan_harian->kh_hasil->EditValue ?></textarea>
<script type="text/javascript">
ew_CreateEditor("fkegiatan_harianedit", "x_kh_hasil", 35, 4, <?php echo ($kegiatan_harian->kh_hasil->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $kegiatan_harian->kh_hasil->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kegiatan_harian->kh_foto->Visible) { // kh_foto ?>
	<div id="r_kh_foto" class="form-group">
		<label id="elh_kegiatan_harian_kh_foto" class="<?php echo $kegiatan_harian_edit->LeftColumnClass ?>"><?php echo $kegiatan_harian->kh_foto->FldCaption() ?></label>
		<div class="<?php echo $kegiatan_harian_edit->RightColumnClass ?>"><div<?php echo $kegiatan_harian->kh_foto->CellAttributes() ?>>
<span id="el_kegiatan_harian_kh_foto">
<div id="fd_x_kh_foto">
<span title="<?php echo $kegiatan_harian->kh_foto->FldTitle() ? $kegiatan_harian->kh_foto->FldTitle() : $Language->Phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ewTooltip<?php if ($kegiatan_harian->kh_foto->ReadOnly || $kegiatan_harian->kh_foto->Disabled) echo " hide"; ?>" data-trigger="hover">
	<span><?php echo $Language->Phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="kegiatan_harian" data-field="x_kh_foto" name="x_kh_foto" id="x_kh_foto" multiple="multiple"<?php echo $kegiatan_harian->kh_foto->EditAttributes() ?>>
</span>
<input type="hidden" name="fn_x_kh_foto" id= "fn_x_kh_foto" value="<?php echo $kegiatan_harian->kh_foto->Upload->FileName ?>">
<?php if (@$_POST["fa_x_kh_foto"] == "0") { ?>
<input type="hidden" name="fa_x_kh_foto" id= "fa_x_kh_foto" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_kh_foto" id= "fa_x_kh_foto" value="1">
<?php } ?>
<input type="hidden" name="fs_x_kh_foto" id= "fs_x_kh_foto" value="100">
<input type="hidden" name="fx_x_kh_foto" id= "fx_x_kh_foto" value="<?php echo $kegiatan_harian->kh_foto->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_kh_foto" id= "fm_x_kh_foto" value="<?php echo $kegiatan_harian->kh_foto->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_kh_foto" id= "fc_x_kh_foto" value="<?php echo $kegiatan_harian->kh_foto->UploadMaxFileCount ?>">
</div>
<table id="ft_x_kh_foto" class="table table-condensed pull-left ewUploadTable"><tbody class="files"></tbody></table>
</span>
<?php echo $kegiatan_harian->kh_foto->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$kegiatan_harian_edit->IsModal) { ?>
<div class="form-group"><!-- buttons .form-group -->
	<div class="<?php echo $kegiatan_harian_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ewButton" name="btnAction" id="btnAction" type="submit"><?php echo $Language->Phrase("SaveBtn") ?></button>
<button class="btn btn-default ewButton" name="btnCancel" id="btnCancel" type="button" data-href="<?php echo $kegiatan_harian_edit->getReturnUrl() ?>"><?php echo $Language->Phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<script type="text/javascript">
fkegiatan_harianedit.Init();
</script>
<?php
$kegiatan_harian_edit->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$kegiatan_harian_edit->Page_Terminate();
?>
