<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start();
?>
<?php include_once "phprptinc/ewrcfg10.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "phprptinc/ewmysql.php") ?>
<?php include_once "phprptinc/ewrfn10.php" ?>
<?php include_once "phprptinc/ewrusrfn10.php" ?>
<?php include_once "Kedatangan_Dan_Verifikasismryinfo.php" ?>
<?php

//
// Page class
//

$Kedatangan_Dan_Verifikasi_summary = NULL; // Initialize page object first

class crKedatangan_Dan_Verifikasi_summary extends crKedatangan_Dan_Verifikasi {

	// Page ID
	var $PageID = 'summary';

	// Project ID
	var $ProjectID = "{FAF953E4-B026-4CC4-8D1E-0CFAFEB15236}";

	// Page object name
	var $PageObjName = 'Kedatangan_Dan_Verifikasi_summary';

	// Page name
	function PageName() {
		return ewr_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ewr_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Export URLs
	var $ExportPrintUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportPdfUrl;
	var $ReportTableClass;
	var $ReportTableStyle = "";

	// Custom export
	var $ExportPrintCustom = FALSE;
	var $ExportExcelCustom = FALSE;
	var $ExportWordCustom = FALSE;
	var $ExportPdfCustom = FALSE;
	var $ExportEmailCustom = FALSE;

	// Message
	function getMessage() {
		return @$_SESSION[EWR_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ewr_AddMessage($_SESSION[EWR_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EWR_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ewr_AddMessage($_SESSION[EWR_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EWR_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ewr_AddMessage($_SESSION[EWR_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EWR_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ewr_AddMessage($_SESSION[EWR_SESSION_WARNING_MESSAGE], $v);
	}

		// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EWR_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EWR_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EWR_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EWR_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog ewDisplayTable\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") // Header exists, display
			echo $sHeader;
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") // Fotoer exists, display
			echo $sFooter;
	}

	// Validate page request
	function IsPageRequest() {
		if ($this->UseTokenInUrl) {
			if (ewr_IsHttpPost())
				return ($this->TableVar == @$_POST("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == @$_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $CheckToken = EWR_CHECK_TOKEN;
	var $CheckTokenFn = "ewr_CheckToken";
	var $CreateTokenFn = "ewr_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ewr_IsHttpPost())
			return TRUE;
		if (!isset($_POST[EWR_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EWR_TOKEN_NAME]);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $ReportLanguage;
		global $UserTable, $UserTableConn;

		// Language object
		$ReportLanguage = new crLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (Kedatangan_Dan_Verifikasi)
		if (!isset($GLOBALS["Kedatangan_Dan_Verifikasi"])) {
			$GLOBALS["Kedatangan_Dan_Verifikasi"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["Kedatangan_Dan_Verifikasi"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->PageUrl() . "export=print";
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel";
		$this->ExportWordUrl = $this->PageUrl() . "export=word";
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf";

		// Page ID
		if (!defined("EWR_PAGE_ID"))
			define("EWR_PAGE_ID", 'summary', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EWR_TABLE_NAME"))
			define("EWR_TABLE_NAME", 'Kedatangan Dan Verifikasi', TRUE);

		// Start timer
		$GLOBALS["gsTimer"] = new crTimer();

		// Open connection
		if (!isset($conn)) $conn = ewr_Connect($this->DBID);

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new cremployees();
			$UserTableConn = ReportConn($UserTable->DBID);
		}

		// Export options
		$this->ExportOptions = new crListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Search options
		$this->SearchOptions = new crListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ewSearchOption";

		// Filter options
		$this->FilterOptions = new crListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ewFilterOption fKedatangan_Dan_Verifikasisummary";

		// Generate report options
		$this->GenerateOptions = new crListOptions();
		$this->GenerateOptions->Tag = "div";
		$this->GenerateOptions->TagClassName = "ewGenerateOption";
	}

	//
	// Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $gsEmailContentType, $ReportLanguage, $Security;
		global $gsCustomExport;

		// Security
		$Security = new crAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin(); // Auto login
		$Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . 'Kedatangan Dan Verifikasi');
		$Security->TablePermission_Loaded();
		if (!$Security->CanList()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage($ReportLanguage->Phrase("NoPermission")); // Set no permission
			$this->Page_Terminate(ewr_GetUrl("index.php"));
		}

		// Get export parameters
		if (@$_GET["export"] <> "")
			$this->Export = strtolower($_GET["export"]);
		elseif (@$_POST["export"] <> "")
			$this->Export = strtolower($_POST["export"]);
		$gsExport = $this->Export; // Get export parameter, used in header
		$gsExportFile = $this->TableVar; // Get export file, used in header
		$gsEmailContentType = @$_POST["contenttype"]; // Get email content type

		// Setup placeholder
		$this->datang_tgl->PlaceHolder = $this->datang_tgl->FldCaption();
		$this->k_es_tgl_panen->PlaceHolder = $this->k_es_tgl_panen->FldCaption();
		$this->ver_tgl->PlaceHolder = $this->ver_tgl->FldCaption();

		// Setup export options
		$this->SetupExportOptions();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $ReportLanguage->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Create Token
		$this->CreateToken();
	}

	// Set up export options
	function SetupExportOptions() {
		global $Security, $ReportLanguage, $ReportOptions;
		$exportid = session_id();
		$ReportTypes = array();

		// Printer friendly
		$item = &$this->ExportOptions->Add("print");
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("PrinterFriendly", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("PrinterFriendly", TRUE)) . "\" href=\"" . $this->ExportPrintUrl . "\">" . $ReportLanguage->Phrase("PrinterFriendly") . "</a>";
		$item->Visible = TRUE;
		$ReportTypes["print"] = $item->Visible ? $ReportLanguage->Phrase("ReportFormPrint") : "";

		// Export to Excel
		$item = &$this->ExportOptions->Add("excel");
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToExcel", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToExcel", TRUE)) . "\" href=\"" . $this->ExportExcelUrl . "\">" . $ReportLanguage->Phrase("ExportToExcel") . "</a>";
		$item->Visible = TRUE;
		$ReportTypes["excel"] = $item->Visible ? $ReportLanguage->Phrase("ReportFormExcel") : "";

		// Export to Word
		$item = &$this->ExportOptions->Add("word");
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToWord", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToWord", TRUE)) . "\" href=\"" . $this->ExportWordUrl . "\">" . $ReportLanguage->Phrase("ExportToWord") . "</a>";

		//$item->Visible = TRUE;
		$item->Visible = TRUE;
		$ReportTypes["word"] = $item->Visible ? $ReportLanguage->Phrase("ReportFormWord") : "";

		// Export to Pdf
		$item = &$this->ExportOptions->Add("pdf");
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToPDF", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToPDF", TRUE)) . "\" href=\"" . $this->ExportPdfUrl . "\">" . $ReportLanguage->Phrase("ExportToPDF") . "</a>";
		$item->Visible = FALSE;

		// Uncomment codes below to show export to Pdf link
//		$item->Visible = TRUE;

		$ReportTypes["pdf"] = $item->Visible ? $ReportLanguage->Phrase("ReportFormPdf") : "";

		// Export to Email
		$item = &$this->ExportOptions->Add("email");
		$url = $this->PageUrl() . "export=email";
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToEmail", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToEmail", TRUE)) . "\" id=\"emf_Kedatangan_Dan_Verifikasi\" href=\"javascript:void(0);\" onclick=\"ewr_EmailDialogShow({lnk:'emf_Kedatangan_Dan_Verifikasi',hdr:ewLanguage.Phrase('ExportToEmail'),url:'$url',exportid:'$exportid',el:this});\">" . $ReportLanguage->Phrase("ExportToEmail") . "</a>";
		$item->Visible = FALSE;
		$ReportTypes["email"] = $item->Visible ? $ReportLanguage->Phrase("ReportFormEmail") : "";
		$ReportOptions["ReportTypes"] = $ReportTypes;

		// Drop down button for export
		$this->ExportOptions->UseDropDownButton = FALSE;
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseImageAndText = $this->ExportOptions->UseDropDownButton;
		$this->ExportOptions->DropDownButtonPhrase = $ReportLanguage->Phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->Add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Filter button
		$item = &$this->FilterOptions->Add("savecurrentfilter");
		$item->Body = "<a class=\"ewSaveFilter\" data-form=\"fKedatangan_Dan_Verifikasisummary\" href=\"#\">" . $ReportLanguage->Phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->Add("deletefilter");
		$item->Body = "<a class=\"ewDeleteFilter\" data-form=\"fKedatangan_Dan_Verifikasisummary\" href=\"#\">" . $ReportLanguage->Phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton; // v8
		$this->FilterOptions->DropDownButtonPhrase = $ReportLanguage->Phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->Add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Set up options (extended)
		$this->SetupExportOptionsExt();

		// Hide options for export
		if ($this->Export <> "") {
			$this->ExportOptions->HideAllOptions();
			$this->FilterOptions->HideAllOptions();
		}

		// Set up table class
		if ($this->Export == "word" || $this->Export == "excel" || $this->Export == "pdf")
			$this->ReportTableClass = "ewTable";
		else
			$this->ReportTableClass = "table ewTable";
	}

	// Set up search options
	function SetupSearchOptions() {
		global $ReportLanguage;

		// Filter panel button
		$item = &$this->SearchOptions->Add("searchtoggle");
		$SearchToggleClass = $this->FilterApplied ? " active" : " active";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ewSearchToggle" . $SearchToggleClass . "\" title=\"" . $ReportLanguage->Phrase("SearchBtn", TRUE) . "\" data-caption=\"" . $ReportLanguage->Phrase("SearchBtn", TRUE) . "\" data-toggle=\"button\" data-form=\"fKedatangan_Dan_Verifikasisummary\">" . $ReportLanguage->Phrase("SearchBtn") . "</button>";
		$item->Visible = TRUE;

		// Reset filter
		$item = &$this->SearchOptions->Add("resetfilter");
		$item->Body = "<button type=\"button\" class=\"btn btn-default\" title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ResetAllFilter", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ResetAllFilter", TRUE)) . "\" onclick=\"location='" . ewr_CurrentPage() . "?cmd=reset'\">" . $ReportLanguage->Phrase("ResetAllFilter") . "</button>";
		$item->Visible = TRUE && $this->FilterApplied;

		// Button group for reset filter
		$this->SearchOptions->UseButtonGroup = TRUE;

		// Add group option item
		$item = &$this->SearchOptions->Add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide options for export
		if ($this->Export <> "")
			$this->SearchOptions->HideAllOptions();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $ReportLanguage, $EWR_EXPORT, $gsExportFile;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		if ($this->Export <> "" && array_key_exists($this->Export, $EWR_EXPORT)) {
			$sContent = ob_get_contents();
			if (ob_get_length())
				ob_end_clean();

			// Remove all <div data-tagid="..." id="orig..." class="hide">...</div> (for customviewtag export, except "googlemaps")
			if (preg_match_all('/<div\s+data-tagid=[\'"]([\s\S]*?)[\'"]\s+id=[\'"]orig([\s\S]*?)[\'"]\s+class\s*=\s*[\'"]hide[\'"]>([\s\S]*?)<\/div\s*>/i', $sContent, $divmatches, PREG_SET_ORDER)) {
				foreach ($divmatches as $divmatch) {
					if ($divmatch[1] <> "googlemaps")
						$sContent = str_replace($divmatch[0], '', $sContent);
				}
			}
			$fn = $EWR_EXPORT[$this->Export];
			if ($this->Export == "email") { // Email
				if (@$this->GenOptions["reporttype"] == "email") {
					$saveResponse = $this->$fn($sContent, $this->GenOptions);
					$this->WriteGenResponse($saveResponse);
				} else {
					echo $this->$fn($sContent, array());
				}
				$url = ""; // Avoid redirect
			} else {
				$saveToFile = $this->$fn($sContent, $this->GenOptions);
				if (@$this->GenOptions["reporttype"] <> "") {
					$saveUrl = ($saveToFile <> "") ? ewr_ConvertFullUrl($saveToFile) : $ReportLanguage->Phrase("GenerateSuccess");
					$this->WriteGenResponse($saveUrl);
					$url = ""; // Avoid redirect
				}
			}
		}

		 // Close connection
		ewr_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EWR_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}

	// Initialize common variables
	var $ExportOptions; // Export options
	var $SearchOptions; // Search options
	var $FilterOptions; // Filter options

	// Paging variables
	var $RecIndex = 0; // Record index
	var $RecCount = 0; // Record count
	var $StartGrp = 0; // Start group
	var $StopGrp = 0; // Stop group
	var $TotalGrps = 0; // Total groups
	var $GrpCount = 0; // Group count
	var $GrpCounter = array(); // Group counter
	var $DisplayGrps = 50; // Groups per page
	var $GrpRange = 10;
	var $Sort = "";
	var $Filter = "";
	var $PageFirstGroupFilter = "";
	var $UserIDFilter = "";
	var $DrillDown = FALSE;
	var $DrillDownInPanel = FALSE;
	var $DrillDownList = "";

	// Clear field for ext filter
	var $ClearExtFilter = "";
	var $PopupName = "";
	var $PopupValue = "";
	var $FilterApplied;
	var $SearchCommand = FALSE;
	var $ShowHeader;
	var $GrpColumnCount = 0;
	var $SubGrpColumnCount = 0;
	var $DtlColumnCount = 0;
	var $Cnt, $Col, $Val, $Smry, $Mn, $Mx, $GrandCnt, $GrandSmry, $GrandMn, $GrandMx;
	var $TotCount;
	var $GrandSummarySetup = FALSE;
	var $GrpIdx;
	var $DetailRows = array();

	//
	// Page main
	//
	function Page_Main() {
		global $rs;
		global $rsgrp;
		global $Security;
		global $gsFormError;
		global $gbDrillDownInPanel;
		global $ReportBreadcrumb;
		global $ReportLanguage;

		// Set field visibility for detail fields
		$this->datang_id->SetVisibility();
		$this->datang_tgl->SetVisibility();
		$this->datang_jumlah->SetVisibility();
		$this->ds_nama->SetVisibility();
		$this->datang_terpakai->SetVisibility();
		$this->var_nama->SetVisibility();
		$this->sup_nama->SetVisibility();
		$this->pet_nama->SetVisibility();
		$this->co_nama->SetVisibility();
		$this->k_id_kontrak->SetVisibility();
		$this->k_luas_lahan->SetVisibility();
		$this->k_es_tgl_panen->SetVisibility();
		$this->k_es_qty->SetVisibility();
		$this->ver_tgl->SetVisibility();
		$this->ver_presentasi_rijek->SetVisibility();
		$this->ver_hasil_id->SetVisibility();
		$this->qc_nama->SetVisibility();
		$this->ver_catatan->SetVisibility();

		// Aggregate variables
		// 1st dimension = no of groups (level 0 used for grand total)
		// 2nd dimension = no of fields

		$nDtls = 19;
		$nGrps = 1;
		$this->Val = &ewr_InitArray($nDtls, 0);
		$this->Cnt = &ewr_Init2DArray($nGrps, $nDtls, 0);
		$this->Smry = &ewr_Init2DArray($nGrps, $nDtls, 0);
		$this->Mn = &ewr_Init2DArray($nGrps, $nDtls, NULL);
		$this->Mx = &ewr_Init2DArray($nGrps, $nDtls, NULL);
		$this->GrandCnt = &ewr_InitArray($nDtls, 0);
		$this->GrandSmry = &ewr_InitArray($nDtls, 0);
		$this->GrandMn = &ewr_InitArray($nDtls, NULL);
		$this->GrandMx = &ewr_InitArray($nDtls, NULL);

		// Set up array if accumulation required: array(Accum, SkipNullOrZero)
		$this->Col = array(array(FALSE, FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(TRUE,FALSE), array(FALSE,FALSE), array(TRUE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(TRUE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE));

		// Set up groups per page dynamically
		$this->SetUpDisplayGrps();

		// Set up Breadcrumb
		if ($this->Export == "")
			$this->SetupBreadcrumb();
		$this->qc_nama->SelectionList = "";
		$this->qc_nama->DefaultSelectionList = "";
		$this->qc_nama->ValueList = "";

		// Check if search command
		$this->SearchCommand = (@$_GET["cmd"] == "search");

		// Load default filter values
		$this->LoadDefaultFilters();

		// Load custom filters
		$this->Page_FilterLoad();

		// Set up popup filter
		$this->SetupPopup();

		// Load group db values if necessary
		$this->LoadGroupDbValues();

		// Handle Ajax popup
		$this->ProcessAjaxPopup();

		// Extended filter
		$sExtendedFilter = "";

		// Restore filter list
		$this->RestoreFilterList();

		// Build extended filter
		$sExtendedFilter = $this->GetExtendedFilter();
		ewr_AddFilter($this->Filter, $sExtendedFilter);

		// Build popup filter
		$sPopupFilter = $this->GetPopupFilter();

		//ewr_SetDebugMsg("popup filter: " . $sPopupFilter);
		ewr_AddFilter($this->Filter, $sPopupFilter);

		// Check if filter applied
		$this->FilterApplied = $this->CheckFilter();

		// Call Page Selecting event
		$this->Page_Selecting($this->Filter);

		// Search options
		$this->SetupSearchOptions();

		// Get sort
		$this->Sort = $this->GetSort($this->GenOptions);

		// Get total count
		$sSql = ewr_BuildReportSql($this->getSqlSelect(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(), $this->Filter, $this->Sort);
		$this->TotalGrps = $this->GetCnt($sSql);
		if ($this->DisplayGrps <= 0 || $this->DrillDown) // Display all groups
			$this->DisplayGrps = $this->TotalGrps;
		$this->StartGrp = 1;

		// Show header
		$this->ShowHeader = TRUE;

		// Set up start position if not export all
		if ($this->ExportAll && $this->Export <> "")
			$this->DisplayGrps = $this->TotalGrps;
		else
			$this->SetUpStartGroup($this->GenOptions);

		// Set no record found message
		if ($this->TotalGrps == 0) {
			if ($Security->CanList()) {
				if ($this->Filter == "0=101") {
					$this->setWarningMessage($ReportLanguage->Phrase("EnterSearchCriteria"));
				} else {
					$this->setWarningMessage($ReportLanguage->Phrase("NoRecord"));
				}
			} else {
				$this->setWarningMessage($ReportLanguage->Phrase("NoPermission"));
			}
		}

		// Hide export options if export
		if ($this->Export <> "")
			$this->ExportOptions->HideAllOptions();

		// Hide search/filter options if export/drilldown
		if ($this->Export <> "" || $this->DrillDown) {
			$this->SearchOptions->HideAllOptions();
			$this->FilterOptions->HideAllOptions();
			$this->GenerateOptions->HideAllOptions();
		}

		// Get current page records
		$rs = $this->GetRs($sSql, $this->StartGrp, $this->DisplayGrps);
		$this->SetupFieldCount();
	}

	// Accummulate summary
	function AccumulateSummary() {
		$cntx = count($this->Smry);
		for ($ix = 0; $ix < $cntx; $ix++) {
			$cnty = count($this->Smry[$ix]);
			for ($iy = 1; $iy < $cnty; $iy++) {
				if ($this->Col[$iy][0]) { // Accumulate required
					$valwrk = $this->Val[$iy];
					if (is_null($valwrk)) {
						if (!$this->Col[$iy][1])
							$this->Cnt[$ix][$iy]++;
					} else {
						$accum = (!$this->Col[$iy][1] || !is_numeric($valwrk) || $valwrk <> 0);
						if ($accum) {
							$this->Cnt[$ix][$iy]++;
							if (is_numeric($valwrk)) {
								$this->Smry[$ix][$iy] += $valwrk;
								if (is_null($this->Mn[$ix][$iy])) {
									$this->Mn[$ix][$iy] = $valwrk;
									$this->Mx[$ix][$iy] = $valwrk;
								} else {
									if ($this->Mn[$ix][$iy] > $valwrk) $this->Mn[$ix][$iy] = $valwrk;
									if ($this->Mx[$ix][$iy] < $valwrk) $this->Mx[$ix][$iy] = $valwrk;
								}
							}
						}
					}
				}
			}
		}
		$cntx = count($this->Smry);
		for ($ix = 0; $ix < $cntx; $ix++) {
			$this->Cnt[$ix][0]++;
		}
	}

	// Reset level summary
	function ResetLevelSummary($lvl) {

		// Clear summary values
		$cntx = count($this->Smry);
		for ($ix = $lvl; $ix < $cntx; $ix++) {
			$cnty = count($this->Smry[$ix]);
			for ($iy = 1; $iy < $cnty; $iy++) {
				$this->Cnt[$ix][$iy] = 0;
				if ($this->Col[$iy][0]) {
					$this->Smry[$ix][$iy] = 0;
					$this->Mn[$ix][$iy] = NULL;
					$this->Mx[$ix][$iy] = NULL;
				}
			}
		}
		$cntx = count($this->Smry);
		for ($ix = $lvl; $ix < $cntx; $ix++) {
			$this->Cnt[$ix][0] = 0;
		}

		// Reset record count
		$this->RecCount = 0;
	}

	// Accummulate grand summary
	function AccumulateGrandSummary() {
		$this->TotCount++;
		$cntgs = count($this->GrandSmry);
		for ($iy = 1; $iy < $cntgs; $iy++) {
			if ($this->Col[$iy][0]) {
				$valwrk = $this->Val[$iy];
				if (is_null($valwrk) || !is_numeric($valwrk)) {
					if (!$this->Col[$iy][1])
						$this->GrandCnt[$iy]++;
				} else {
					if (!$this->Col[$iy][1] || $valwrk <> 0) {
						$this->GrandCnt[$iy]++;
						$this->GrandSmry[$iy] += $valwrk;
						if (is_null($this->GrandMn[$iy])) {
							$this->GrandMn[$iy] = $valwrk;
							$this->GrandMx[$iy] = $valwrk;
						} else {
							if ($this->GrandMn[$iy] > $valwrk) $this->GrandMn[$iy] = $valwrk;
							if ($this->GrandMx[$iy] < $valwrk) $this->GrandMx[$iy] = $valwrk;
						}
					}
				}
			}
		}
	}

	// Get count
	function GetCnt($sql) {
		$conn = &$this->Connection();
		$rscnt = $conn->Execute($sql);
		$cnt = ($rscnt) ? $rscnt->RecordCount() : 0;
		if ($rscnt) $rscnt->Close();
		return $cnt;
	}

	// Get recordset
	function GetRs($wrksql, $start, $grps) {
		$conn = &$this->Connection();
		$conn->raiseErrorFn = $GLOBALS["EWR_ERROR_FN"];
		$rswrk = $conn->SelectLimit($wrksql, $grps, $start - 1);
		$conn->raiseErrorFn = '';
		return $rswrk;
	}

	// Get row values
	function GetRow($opt) {
		global $rs;
		if (!$rs)
			return;
		if ($opt == 1) { // Get first row
				$this->FirstRowData = array();
				$this->FirstRowData['datang_id'] = ewr_Conv($rs->fields('datang_id'), 3);
				$this->FirstRowData['datang_tgl'] = ewr_Conv($rs->fields('datang_tgl'), 135);
				$this->FirstRowData['datang_jumlah'] = ewr_Conv($rs->fields('datang_jumlah'), 3);
				$this->FirstRowData['ds_nama'] = ewr_Conv($rs->fields('ds_nama'), 200);
				$this->FirstRowData['datang_terpakai'] = ewr_Conv($rs->fields('datang_terpakai'), 3);
				$this->FirstRowData['var_nama'] = ewr_Conv($rs->fields('var_nama'), 200);
				$this->FirstRowData['sup_nama'] = ewr_Conv($rs->fields('sup_nama'), 200);
				$this->FirstRowData['pet_nama'] = ewr_Conv($rs->fields('pet_nama'), 200);
				$this->FirstRowData['co_nama'] = ewr_Conv($rs->fields('co_nama'), 200);
				$this->FirstRowData['k_id_kontrak'] = ewr_Conv($rs->fields('k_id_kontrak'), 200);
				$this->FirstRowData['k_luas_lahan'] = ewr_Conv($rs->fields('k_luas_lahan'), 3);
				$this->FirstRowData['k_es_tgl_panen'] = ewr_Conv($rs->fields('k_es_tgl_panen'), 133);
				$this->FirstRowData['k_es_qty'] = ewr_Conv($rs->fields('k_es_qty'), 3);
				$this->FirstRowData['ver_tgl'] = ewr_Conv($rs->fields('ver_tgl'), 135);
				$this->FirstRowData['ver_presentasi_rijek'] = ewr_Conv($rs->fields('ver_presentasi_rijek'), 3);
				$this->FirstRowData['ver_hasil_id'] = ewr_Conv($rs->fields('ver_hasil_id'), 200);
				$this->FirstRowData['ver_foto'] = ewr_Conv($rs->fields('ver_foto'), 200);
				$this->FirstRowData['qc_nama'] = ewr_Conv($rs->fields('qc_nama'), 200);
		} else { // Get next row
			$rs->MoveNext();
		}
		if (!$rs->EOF) {
			$this->datang_id->setDbValue($rs->fields('datang_id'));
			$this->datang_tgl->setDbValue($rs->fields('datang_tgl'));
			$this->datang_jumlah->setDbValue($rs->fields('datang_jumlah'));
			$this->ds_nama->setDbValue($rs->fields('ds_nama'));
			$this->datang_terpakai->setDbValue($rs->fields('datang_terpakai'));
			$this->var_nama->setDbValue($rs->fields('var_nama'));
			$this->sup_nama->setDbValue($rs->fields('sup_nama'));
			$this->pet_nama->setDbValue($rs->fields('pet_nama'));
			$this->co_nama->setDbValue($rs->fields('co_nama'));
			$this->k_id_kontrak->setDbValue($rs->fields('k_id_kontrak'));
			$this->k_luas_lahan->setDbValue($rs->fields('k_luas_lahan'));
			$this->k_es_tgl_panen->setDbValue($rs->fields('k_es_tgl_panen'));
			$this->k_es_qty->setDbValue($rs->fields('k_es_qty'));
			$this->ver_tgl->setDbValue($rs->fields('ver_tgl'));
			$this->ver_presentasi_rijek->setDbValue($rs->fields('ver_presentasi_rijek'));
			$this->ver_hasil_id->setDbValue($rs->fields('ver_hasil_id'));
			$this->ver_foto->setDbValue($rs->fields('ver_foto'));
			$this->qc_nama->setDbValue($rs->fields('qc_nama'));
			$this->ver_catatan->setDbValue($rs->fields('ver_catatan'));
			$this->Val[1] = $this->datang_id->CurrentValue;
			$this->Val[2] = $this->datang_tgl->CurrentValue;
			$this->Val[3] = $this->datang_jumlah->CurrentValue;
			$this->Val[4] = $this->ds_nama->CurrentValue;
			$this->Val[5] = $this->datang_terpakai->CurrentValue;
			$this->Val[6] = $this->var_nama->CurrentValue;
			$this->Val[7] = $this->sup_nama->CurrentValue;
			$this->Val[8] = $this->pet_nama->CurrentValue;
			$this->Val[9] = $this->co_nama->CurrentValue;
			$this->Val[10] = $this->k_id_kontrak->CurrentValue;
			$this->Val[11] = $this->k_luas_lahan->CurrentValue;
			$this->Val[12] = $this->k_es_tgl_panen->CurrentValue;
			$this->Val[13] = $this->k_es_qty->CurrentValue;
			$this->Val[14] = $this->ver_tgl->CurrentValue;
			$this->Val[15] = $this->ver_presentasi_rijek->CurrentValue;
			$this->Val[16] = $this->ver_hasil_id->CurrentValue;
			$this->Val[17] = $this->qc_nama->CurrentValue;
			$this->Val[18] = $this->ver_catatan->CurrentValue;
		} else {
			$this->datang_id->setDbValue("");
			$this->datang_tgl->setDbValue("");
			$this->datang_jumlah->setDbValue("");
			$this->ds_nama->setDbValue("");
			$this->datang_terpakai->setDbValue("");
			$this->var_nama->setDbValue("");
			$this->sup_nama->setDbValue("");
			$this->pet_nama->setDbValue("");
			$this->co_nama->setDbValue("");
			$this->k_id_kontrak->setDbValue("");
			$this->k_luas_lahan->setDbValue("");
			$this->k_es_tgl_panen->setDbValue("");
			$this->k_es_qty->setDbValue("");
			$this->ver_tgl->setDbValue("");
			$this->ver_presentasi_rijek->setDbValue("");
			$this->ver_hasil_id->setDbValue("");
			$this->ver_foto->setDbValue("");
			$this->qc_nama->setDbValue("");
			$this->ver_catatan->setDbValue("");
		}
	}

	// Set up starting group
	function SetUpStartGroup($options = array()) {

		// Exit if no groups
		if ($this->DisplayGrps == 0)
			return;
		$startGrp = (@$options["start"] <> "") ? $options["start"] : @$_GET[EWR_TABLE_START_GROUP];
		$pageNo = (@$options["pageno"] <> "") ? $options["pageno"] : @$_GET["pageno"];

		// Check for a 'start' parameter
		if ($startGrp != "") {
			$this->StartGrp = $startGrp;
			$this->setStartGroup($this->StartGrp);
		} elseif ($pageNo != "") {
			$nPageNo = $pageNo;
			if (is_numeric($nPageNo)) {
				$this->StartGrp = ($nPageNo-1)*$this->DisplayGrps+1;
				if ($this->StartGrp <= 0) {
					$this->StartGrp = 1;
				} elseif ($this->StartGrp >= intval(($this->TotalGrps-1)/$this->DisplayGrps)*$this->DisplayGrps+1) {
					$this->StartGrp = intval(($this->TotalGrps-1)/$this->DisplayGrps)*$this->DisplayGrps+1;
				}
				$this->setStartGroup($this->StartGrp);
			} else {
				$this->StartGrp = $this->getStartGroup();
			}
		} else {
			$this->StartGrp = $this->getStartGroup();
		}

		// Check if correct start group counter
		if (!is_numeric($this->StartGrp) || $this->StartGrp == "") { // Avoid invalid start group counter
			$this->StartGrp = 1; // Reset start group counter
			$this->setStartGroup($this->StartGrp);
		} elseif (intval($this->StartGrp) > intval($this->TotalGrps)) { // Avoid starting group > total groups
			$this->StartGrp = intval(($this->TotalGrps-1)/$this->DisplayGrps) * $this->DisplayGrps + 1; // Point to last page first group
			$this->setStartGroup($this->StartGrp);
		} elseif (($this->StartGrp-1) % $this->DisplayGrps <> 0) {
			$this->StartGrp = intval(($this->StartGrp-1)/$this->DisplayGrps) * $this->DisplayGrps + 1; // Point to page boundary
			$this->setStartGroup($this->StartGrp);
		}
	}

	// Load group db values if necessary
	function LoadGroupDbValues() {
		$conn = &$this->Connection();
	}

	// Process Ajax popup
	function ProcessAjaxPopup() {
		global $ReportLanguage;
		$conn = &$this->Connection();
		$fld = NULL;
		if (@$_GET["popup"] <> "") {
			$popupname = $_GET["popup"];

			// Check popup name
			// Build distinct values for qc_nama

			if ($popupname == 'Kedatangan_Dan_Verifikasi_qc_nama') {
				$bNullValue = FALSE;
				$bEmptyValue = FALSE;
				$sFilter = $this->Filter;

				// Call Page Filtering event
				$this->Page_Filtering($this->qc_nama, $sFilter, "popup");
				$sSql = ewr_BuildReportSql($this->qc_nama->SqlSelect, $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), $this->qc_nama->SqlOrderBy, $sFilter, "");
				$rswrk = $conn->Execute($sSql);
				while ($rswrk && !$rswrk->EOF) {
					$this->qc_nama->setDbValue($rswrk->fields[0]);
					$this->qc_nama->ViewValue = @$rswrk->fields[1];
					if (is_null($this->qc_nama->CurrentValue)) {
						$bNullValue = TRUE;
					} elseif ($this->qc_nama->CurrentValue == "") {
						$bEmptyValue = TRUE;
					} else {
						ewr_SetupDistinctValues($this->qc_nama->ValueList, $this->qc_nama->CurrentValue, $this->qc_nama->ViewValue, FALSE, $this->qc_nama->FldDelimiter);
					}
					$rswrk->MoveNext();
				}
				if ($rswrk)
					$rswrk->Close();
				if ($bEmptyValue)
					ewr_SetupDistinctValues($this->qc_nama->ValueList, EWR_EMPTY_VALUE, $ReportLanguage->Phrase("EmptyLabel"), FALSE);
				if ($bNullValue)
					ewr_SetupDistinctValues($this->qc_nama->ValueList, EWR_NULL_VALUE, $ReportLanguage->Phrase("NullLabel"), FALSE);
				$fld = &$this->qc_nama;
			}

			// Output data as Json
			if (!is_null($fld)) {
				$jsdb = ewr_GetJsDb($fld, $fld->FldType);
				if (ob_get_length())
					ob_end_clean();
				echo $jsdb;
				exit();
			}
		}
	}

	// Set up popup
	function SetupPopup() {
		global $ReportLanguage;
		$conn = &$this->Connection();
		if ($this->DrillDown)
			return;

		// Process post back form
		if (ewr_IsHttpPost()) {
			$sName = @$_POST["popup"]; // Get popup form name
			if ($sName <> "") {
				$cntValues = (is_array(@$_POST["sel_$sName"])) ? count($_POST["sel_$sName"]) : 0;
				if ($cntValues > 0) {
					$arValues = ewr_StripSlashes($_POST["sel_$sName"]);
					if (trim($arValues[0]) == "") // Select all
						$arValues = EWR_INIT_VALUE;
					$this->PopupName = $sName;
					if (ewr_IsAdvancedFilterValue($arValues) || $arValues == EWR_INIT_VALUE)
						$this->PopupValue = $arValues;
					if (!ewr_MatchedArray($arValues, $_SESSION["sel_$sName"])) {
						if ($this->HasSessionFilterValues($sName))
							$this->ClearExtFilter = $sName; // Clear extended filter for this field
					}
					$_SESSION["sel_$sName"] = $arValues;
					$_SESSION["rf_$sName"] = ewr_StripSlashes(@$_POST["rf_$sName"]);
					$_SESSION["rt_$sName"] = ewr_StripSlashes(@$_POST["rt_$sName"]);
					$this->ResetPager();
				}
			}

		// Get 'reset' command
		} elseif (@$_GET["cmd"] <> "") {
			$sCmd = $_GET["cmd"];
			if (strtolower($sCmd) == "reset") {
				$this->ClearSessionSelection('qc_nama');
				$this->ResetPager();
			}
		}

		// Load selection criteria to array
		// Get qc_nama selected values

		if (is_array(@$_SESSION["sel_Kedatangan_Dan_Verifikasi_qc_nama"])) {
			$this->LoadSelectionFromSession('qc_nama');
		} elseif (@$_SESSION["sel_Kedatangan_Dan_Verifikasi_qc_nama"] == EWR_INIT_VALUE) { // Select all
			$this->qc_nama->SelectionList = "";
		}
	}

	// Reset pager
	function ResetPager() {

		// Reset start position (reset command)
		$this->StartGrp = 1;
		$this->setStartGroup($this->StartGrp);
	}

	// Set up number of groups displayed per page
	function SetUpDisplayGrps() {
		$sWrk = @$_GET[EWR_TABLE_GROUP_PER_PAGE];
		if ($sWrk <> "") {
			if (is_numeric($sWrk)) {
				$this->DisplayGrps = intval($sWrk);
			} else {
				if (strtoupper($sWrk) == "ALL") { // Display all groups
					$this->DisplayGrps = -1;
				} else {
					$this->DisplayGrps = 50; // Non-numeric, load default
				}
			}
			$this->setGroupPerPage($this->DisplayGrps); // Save to session

			// Reset start position (reset command)
			$this->StartGrp = 1;
			$this->setStartGroup($this->StartGrp);
		} else {
			if ($this->getGroupPerPage() <> "") {
				$this->DisplayGrps = $this->getGroupPerPage(); // Restore from session
			} else {
				$this->DisplayGrps = 50; // Load default
			}
		}
	}

	// Render row
	function RenderRow() {
		global $rs, $Security, $ReportLanguage;
		$conn = &$this->Connection();
		if (!$this->GrandSummarySetup) { // Get Grand total
			$bGotCount = FALSE;
			$bGotSummary = FALSE;

			// Get total count from sql directly
			$sSql = ewr_BuildReportSql($this->getSqlSelectCount(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
			$rstot = $conn->Execute($sSql);
			if ($rstot) {
				$this->TotCount = ($rstot->RecordCount()>1) ? $rstot->RecordCount() : $rstot->fields[0];
				$rstot->Close();
				$bGotCount = TRUE;
			} else {
				$this->TotCount = 0;
			}

			// Get total from sql directly
			$sSql = ewr_BuildReportSql($this->getSqlSelectAgg(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
			$sSql = $this->getSqlAggPfx() . $sSql . $this->getSqlAggSfx();
			$rsagg = $conn->Execute($sSql);
			if ($rsagg) {
				$this->GrandCnt[1] = $this->TotCount;
				$this->GrandCnt[2] = $this->TotCount;
				$this->GrandCnt[3] = $this->TotCount;
				$this->GrandSmry[3] = $rsagg->fields("sum_datang_jumlah");
				$this->GrandCnt[4] = $this->TotCount;
				$this->GrandCnt[5] = $this->TotCount;
				$this->GrandSmry[5] = $rsagg->fields("sum_datang_terpakai");
				$this->GrandCnt[6] = $this->TotCount;
				$this->GrandCnt[7] = $this->TotCount;
				$this->GrandCnt[8] = $this->TotCount;
				$this->GrandCnt[9] = $this->TotCount;
				$this->GrandCnt[10] = $this->TotCount;
				$this->GrandCnt[11] = $this->TotCount;
				$this->GrandCnt[12] = $this->TotCount;
				$this->GrandCnt[13] = $this->TotCount;
				$this->GrandCnt[14] = $this->TotCount;
				$this->GrandCnt[15] = $this->TotCount;
				$this->GrandSmry[15] = $rsagg->fields("sum_ver_presentasi_rijek");
				$this->GrandCnt[16] = $this->TotCount;
				$this->GrandCnt[17] = $this->TotCount;
				$this->GrandCnt[18] = $this->TotCount;
				$rsagg->Close();
				$bGotSummary = TRUE;
			}

			// Accumulate grand summary from detail records
			if (!$bGotCount || !$bGotSummary) {
				$sSql = ewr_BuildReportSql($this->getSqlSelect(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
				$rs = $conn->Execute($sSql);
				if ($rs) {
					$this->GetRow(1);
					while (!$rs->EOF) {
						$this->AccumulateGrandSummary();
						$this->GetRow(2);
					}
					$rs->Close();
				}
			}
			$this->GrandSummarySetup = TRUE; // No need to set up again
		}

		// Call Row_Rendering event
		$this->Row_Rendering();

		//
		// Render view codes
		//

		if ($this->RowType == EWR_ROWTYPE_TOTAL && !($this->RowTotalType == EWR_ROWTOTAL_GROUP && $this->RowTotalSubType == EWR_ROWTOTAL_HEADER)) { // Summary row
			ewr_PrependClass($this->RowAttrs["class"], ($this->RowTotalType == EWR_ROWTOTAL_PAGE || $this->RowTotalType == EWR_ROWTOTAL_GRAND) ? "ewRptGrpAggregate" : "ewRptGrpSummary" . $this->RowGroupLevel); // Set up row class

			// datang_jumlah
			$this->datang_jumlah->SumViewValue = $this->datang_jumlah->SumValue;
			$this->datang_jumlah->SumViewValue = ewr_FormatNumber($this->datang_jumlah->SumViewValue, 0, -1, -2, -2);
			$this->datang_jumlah->CellAttrs["class"] = ($this->RowTotalType == EWR_ROWTOTAL_PAGE || $this->RowTotalType == EWR_ROWTOTAL_GRAND) ? "ewRptGrpAggregate" : "ewRptGrpSummary" . $this->RowGroupLevel;

			// datang_terpakai
			$this->datang_terpakai->SumViewValue = $this->datang_terpakai->SumValue;
			$this->datang_terpakai->CellAttrs["class"] = ($this->RowTotalType == EWR_ROWTOTAL_PAGE || $this->RowTotalType == EWR_ROWTOTAL_GRAND) ? "ewRptGrpAggregate" : "ewRptGrpSummary" . $this->RowGroupLevel;

			// ver_presentasi_rijek
			$this->ver_presentasi_rijek->AvgViewValue = $this->ver_presentasi_rijek->AvgValue;
			$this->ver_presentasi_rijek->AvgViewValue = ewr_FormatNumber($this->ver_presentasi_rijek->AvgViewValue, $this->ver_presentasi_rijek->DefaultDecimalPrecision, -1, 0, 0);
			$this->ver_presentasi_rijek->CellAttrs["class"] = ($this->RowTotalType == EWR_ROWTOTAL_PAGE || $this->RowTotalType == EWR_ROWTOTAL_GRAND) ? "ewRptGrpAggregate" : "ewRptGrpSummary" . $this->RowGroupLevel;

			// datang_id
			$this->datang_id->HrefValue = "";

			// datang_tgl
			$this->datang_tgl->HrefValue = "";

			// datang_jumlah
			$this->datang_jumlah->HrefValue = "";

			// ds_nama
			$this->ds_nama->HrefValue = "";

			// datang_terpakai
			$this->datang_terpakai->HrefValue = "";

			// var_nama
			$this->var_nama->HrefValue = "";

			// sup_nama
			$this->sup_nama->HrefValue = "";

			// pet_nama
			$this->pet_nama->HrefValue = "";

			// co_nama
			$this->co_nama->HrefValue = "";

			// k_id_kontrak
			$this->k_id_kontrak->HrefValue = "";

			// k_luas_lahan
			$this->k_luas_lahan->HrefValue = "";

			// k_es_tgl_panen
			$this->k_es_tgl_panen->HrefValue = "";

			// k_es_qty
			$this->k_es_qty->HrefValue = "";

			// ver_tgl
			$this->ver_tgl->HrefValue = "";

			// ver_presentasi_rijek
			$this->ver_presentasi_rijek->HrefValue = "";

			// ver_hasil_id
			$this->ver_hasil_id->HrefValue = "";

			// qc_nama
			$this->qc_nama->HrefValue = "";

			// ver_catatan
			$this->ver_catatan->HrefValue = "";
		} else {
			if ($this->RowTotalType == EWR_ROWTOTAL_GROUP && $this->RowTotalSubType == EWR_ROWTOTAL_HEADER) {
			} else {
			}

			// datang_id
			$this->datang_id->ViewValue = $this->datang_id->CurrentValue;
			$this->datang_id->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// datang_tgl
			$this->datang_tgl->ViewValue = $this->datang_tgl->CurrentValue;
			$this->datang_tgl->ViewValue = ewr_FormatDateTime($this->datang_tgl->ViewValue, 0);
			$this->datang_tgl->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// datang_jumlah
			$this->datang_jumlah->ViewValue = $this->datang_jumlah->CurrentValue;
			$this->datang_jumlah->ViewValue = ewr_FormatNumber($this->datang_jumlah->ViewValue, 0, -1, -2, -2);
			$this->datang_jumlah->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// ds_nama
			$this->ds_nama->ViewValue = $this->ds_nama->CurrentValue;
			$this->ds_nama->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// datang_terpakai
			$this->datang_terpakai->ViewValue = $this->datang_terpakai->CurrentValue;
			$this->datang_terpakai->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// var_nama
			$this->var_nama->ViewValue = $this->var_nama->CurrentValue;
			$this->var_nama->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// sup_nama
			$this->sup_nama->ViewValue = $this->sup_nama->CurrentValue;
			$this->sup_nama->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// pet_nama
			$this->pet_nama->ViewValue = $this->pet_nama->CurrentValue;
			$this->pet_nama->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// co_nama
			$this->co_nama->ViewValue = $this->co_nama->CurrentValue;
			$this->co_nama->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// k_id_kontrak
			$this->k_id_kontrak->ViewValue = $this->k_id_kontrak->CurrentValue;
			$this->k_id_kontrak->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// k_luas_lahan
			$this->k_luas_lahan->ViewValue = $this->k_luas_lahan->CurrentValue;
			$this->k_luas_lahan->ViewValue = ewr_FormatNumber($this->k_luas_lahan->ViewValue, 0, -1, -2, -2);
			$this->k_luas_lahan->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// k_es_tgl_panen
			$this->k_es_tgl_panen->ViewValue = $this->k_es_tgl_panen->CurrentValue;
			$this->k_es_tgl_panen->ViewValue = ewr_FormatDateTime($this->k_es_tgl_panen->ViewValue, 0);
			$this->k_es_tgl_panen->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// k_es_qty
			$this->k_es_qty->ViewValue = $this->k_es_qty->CurrentValue;
			$this->k_es_qty->ViewValue = ewr_FormatNumber($this->k_es_qty->ViewValue, 0, -1, -2, -2);
			$this->k_es_qty->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// ver_tgl
			$this->ver_tgl->ViewValue = $this->ver_tgl->CurrentValue;
			$this->ver_tgl->ViewValue = ewr_FormatDateTime($this->ver_tgl->ViewValue, 0);
			$this->ver_tgl->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// ver_presentasi_rijek
			$this->ver_presentasi_rijek->ViewValue = $this->ver_presentasi_rijek->CurrentValue;
			$this->ver_presentasi_rijek->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// ver_hasil_id
			$this->ver_hasil_id->ViewValue = $this->ver_hasil_id->CurrentValue;
			$this->ver_hasil_id->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// qc_nama
			$this->qc_nama->ViewValue = $this->qc_nama->CurrentValue;
			$this->qc_nama->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// ver_catatan
			$this->ver_catatan->ViewValue = $this->ver_catatan->CurrentValue;
			$this->ver_catatan->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// datang_id
			$this->datang_id->HrefValue = "";

			// datang_tgl
			$this->datang_tgl->HrefValue = "";

			// datang_jumlah
			$this->datang_jumlah->HrefValue = "";

			// ds_nama
			$this->ds_nama->HrefValue = "";

			// datang_terpakai
			$this->datang_terpakai->HrefValue = "";

			// var_nama
			$this->var_nama->HrefValue = "";

			// sup_nama
			$this->sup_nama->HrefValue = "";

			// pet_nama
			$this->pet_nama->HrefValue = "";

			// co_nama
			$this->co_nama->HrefValue = "";

			// k_id_kontrak
			$this->k_id_kontrak->HrefValue = "";

			// k_luas_lahan
			$this->k_luas_lahan->HrefValue = "";

			// k_es_tgl_panen
			$this->k_es_tgl_panen->HrefValue = "";

			// k_es_qty
			$this->k_es_qty->HrefValue = "";

			// ver_tgl
			$this->ver_tgl->HrefValue = "";

			// ver_presentasi_rijek
			$this->ver_presentasi_rijek->HrefValue = "";

			// ver_hasil_id
			$this->ver_hasil_id->HrefValue = "";

			// qc_nama
			$this->qc_nama->HrefValue = "";

			// ver_catatan
			$this->ver_catatan->HrefValue = "";
		}

		// Call Cell_Rendered event
		if ($this->RowType == EWR_ROWTYPE_TOTAL) { // Summary row

			// datang_jumlah
			$CurrentValue = $this->datang_jumlah->SumValue;
			$ViewValue = &$this->datang_jumlah->SumViewValue;
			$ViewAttrs = &$this->datang_jumlah->ViewAttrs;
			$CellAttrs = &$this->datang_jumlah->CellAttrs;
			$HrefValue = &$this->datang_jumlah->HrefValue;
			$LinkAttrs = &$this->datang_jumlah->LinkAttrs;
			$this->Cell_Rendered($this->datang_jumlah, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// datang_terpakai
			$CurrentValue = $this->datang_terpakai->SumValue;
			$ViewValue = &$this->datang_terpakai->SumViewValue;
			$ViewAttrs = &$this->datang_terpakai->ViewAttrs;
			$CellAttrs = &$this->datang_terpakai->CellAttrs;
			$HrefValue = &$this->datang_terpakai->HrefValue;
			$LinkAttrs = &$this->datang_terpakai->LinkAttrs;
			$this->Cell_Rendered($this->datang_terpakai, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// ver_presentasi_rijek
			$CurrentValue = $this->ver_presentasi_rijek->AvgValue;
			$ViewValue = &$this->ver_presentasi_rijek->AvgViewValue;
			$ViewAttrs = &$this->ver_presentasi_rijek->ViewAttrs;
			$CellAttrs = &$this->ver_presentasi_rijek->CellAttrs;
			$HrefValue = &$this->ver_presentasi_rijek->HrefValue;
			$LinkAttrs = &$this->ver_presentasi_rijek->LinkAttrs;
			$this->Cell_Rendered($this->ver_presentasi_rijek, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);
		} else {

			// datang_id
			$CurrentValue = $this->datang_id->CurrentValue;
			$ViewValue = &$this->datang_id->ViewValue;
			$ViewAttrs = &$this->datang_id->ViewAttrs;
			$CellAttrs = &$this->datang_id->CellAttrs;
			$HrefValue = &$this->datang_id->HrefValue;
			$LinkAttrs = &$this->datang_id->LinkAttrs;
			$this->Cell_Rendered($this->datang_id, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// datang_tgl
			$CurrentValue = $this->datang_tgl->CurrentValue;
			$ViewValue = &$this->datang_tgl->ViewValue;
			$ViewAttrs = &$this->datang_tgl->ViewAttrs;
			$CellAttrs = &$this->datang_tgl->CellAttrs;
			$HrefValue = &$this->datang_tgl->HrefValue;
			$LinkAttrs = &$this->datang_tgl->LinkAttrs;
			$this->Cell_Rendered($this->datang_tgl, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// datang_jumlah
			$CurrentValue = $this->datang_jumlah->CurrentValue;
			$ViewValue = &$this->datang_jumlah->ViewValue;
			$ViewAttrs = &$this->datang_jumlah->ViewAttrs;
			$CellAttrs = &$this->datang_jumlah->CellAttrs;
			$HrefValue = &$this->datang_jumlah->HrefValue;
			$LinkAttrs = &$this->datang_jumlah->LinkAttrs;
			$this->Cell_Rendered($this->datang_jumlah, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// ds_nama
			$CurrentValue = $this->ds_nama->CurrentValue;
			$ViewValue = &$this->ds_nama->ViewValue;
			$ViewAttrs = &$this->ds_nama->ViewAttrs;
			$CellAttrs = &$this->ds_nama->CellAttrs;
			$HrefValue = &$this->ds_nama->HrefValue;
			$LinkAttrs = &$this->ds_nama->LinkAttrs;
			$this->Cell_Rendered($this->ds_nama, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// datang_terpakai
			$CurrentValue = $this->datang_terpakai->CurrentValue;
			$ViewValue = &$this->datang_terpakai->ViewValue;
			$ViewAttrs = &$this->datang_terpakai->ViewAttrs;
			$CellAttrs = &$this->datang_terpakai->CellAttrs;
			$HrefValue = &$this->datang_terpakai->HrefValue;
			$LinkAttrs = &$this->datang_terpakai->LinkAttrs;
			$this->Cell_Rendered($this->datang_terpakai, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// var_nama
			$CurrentValue = $this->var_nama->CurrentValue;
			$ViewValue = &$this->var_nama->ViewValue;
			$ViewAttrs = &$this->var_nama->ViewAttrs;
			$CellAttrs = &$this->var_nama->CellAttrs;
			$HrefValue = &$this->var_nama->HrefValue;
			$LinkAttrs = &$this->var_nama->LinkAttrs;
			$this->Cell_Rendered($this->var_nama, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// sup_nama
			$CurrentValue = $this->sup_nama->CurrentValue;
			$ViewValue = &$this->sup_nama->ViewValue;
			$ViewAttrs = &$this->sup_nama->ViewAttrs;
			$CellAttrs = &$this->sup_nama->CellAttrs;
			$HrefValue = &$this->sup_nama->HrefValue;
			$LinkAttrs = &$this->sup_nama->LinkAttrs;
			$this->Cell_Rendered($this->sup_nama, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// pet_nama
			$CurrentValue = $this->pet_nama->CurrentValue;
			$ViewValue = &$this->pet_nama->ViewValue;
			$ViewAttrs = &$this->pet_nama->ViewAttrs;
			$CellAttrs = &$this->pet_nama->CellAttrs;
			$HrefValue = &$this->pet_nama->HrefValue;
			$LinkAttrs = &$this->pet_nama->LinkAttrs;
			$this->Cell_Rendered($this->pet_nama, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// co_nama
			$CurrentValue = $this->co_nama->CurrentValue;
			$ViewValue = &$this->co_nama->ViewValue;
			$ViewAttrs = &$this->co_nama->ViewAttrs;
			$CellAttrs = &$this->co_nama->CellAttrs;
			$HrefValue = &$this->co_nama->HrefValue;
			$LinkAttrs = &$this->co_nama->LinkAttrs;
			$this->Cell_Rendered($this->co_nama, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// k_id_kontrak
			$CurrentValue = $this->k_id_kontrak->CurrentValue;
			$ViewValue = &$this->k_id_kontrak->ViewValue;
			$ViewAttrs = &$this->k_id_kontrak->ViewAttrs;
			$CellAttrs = &$this->k_id_kontrak->CellAttrs;
			$HrefValue = &$this->k_id_kontrak->HrefValue;
			$LinkAttrs = &$this->k_id_kontrak->LinkAttrs;
			$this->Cell_Rendered($this->k_id_kontrak, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// k_luas_lahan
			$CurrentValue = $this->k_luas_lahan->CurrentValue;
			$ViewValue = &$this->k_luas_lahan->ViewValue;
			$ViewAttrs = &$this->k_luas_lahan->ViewAttrs;
			$CellAttrs = &$this->k_luas_lahan->CellAttrs;
			$HrefValue = &$this->k_luas_lahan->HrefValue;
			$LinkAttrs = &$this->k_luas_lahan->LinkAttrs;
			$this->Cell_Rendered($this->k_luas_lahan, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// k_es_tgl_panen
			$CurrentValue = $this->k_es_tgl_panen->CurrentValue;
			$ViewValue = &$this->k_es_tgl_panen->ViewValue;
			$ViewAttrs = &$this->k_es_tgl_panen->ViewAttrs;
			$CellAttrs = &$this->k_es_tgl_panen->CellAttrs;
			$HrefValue = &$this->k_es_tgl_panen->HrefValue;
			$LinkAttrs = &$this->k_es_tgl_panen->LinkAttrs;
			$this->Cell_Rendered($this->k_es_tgl_panen, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// k_es_qty
			$CurrentValue = $this->k_es_qty->CurrentValue;
			$ViewValue = &$this->k_es_qty->ViewValue;
			$ViewAttrs = &$this->k_es_qty->ViewAttrs;
			$CellAttrs = &$this->k_es_qty->CellAttrs;
			$HrefValue = &$this->k_es_qty->HrefValue;
			$LinkAttrs = &$this->k_es_qty->LinkAttrs;
			$this->Cell_Rendered($this->k_es_qty, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// ver_tgl
			$CurrentValue = $this->ver_tgl->CurrentValue;
			$ViewValue = &$this->ver_tgl->ViewValue;
			$ViewAttrs = &$this->ver_tgl->ViewAttrs;
			$CellAttrs = &$this->ver_tgl->CellAttrs;
			$HrefValue = &$this->ver_tgl->HrefValue;
			$LinkAttrs = &$this->ver_tgl->LinkAttrs;
			$this->Cell_Rendered($this->ver_tgl, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// ver_presentasi_rijek
			$CurrentValue = $this->ver_presentasi_rijek->CurrentValue;
			$ViewValue = &$this->ver_presentasi_rijek->ViewValue;
			$ViewAttrs = &$this->ver_presentasi_rijek->ViewAttrs;
			$CellAttrs = &$this->ver_presentasi_rijek->CellAttrs;
			$HrefValue = &$this->ver_presentasi_rijek->HrefValue;
			$LinkAttrs = &$this->ver_presentasi_rijek->LinkAttrs;
			$this->Cell_Rendered($this->ver_presentasi_rijek, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// ver_hasil_id
			$CurrentValue = $this->ver_hasil_id->CurrentValue;
			$ViewValue = &$this->ver_hasil_id->ViewValue;
			$ViewAttrs = &$this->ver_hasil_id->ViewAttrs;
			$CellAttrs = &$this->ver_hasil_id->CellAttrs;
			$HrefValue = &$this->ver_hasil_id->HrefValue;
			$LinkAttrs = &$this->ver_hasil_id->LinkAttrs;
			$this->Cell_Rendered($this->ver_hasil_id, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// qc_nama
			$CurrentValue = $this->qc_nama->CurrentValue;
			$ViewValue = &$this->qc_nama->ViewValue;
			$ViewAttrs = &$this->qc_nama->ViewAttrs;
			$CellAttrs = &$this->qc_nama->CellAttrs;
			$HrefValue = &$this->qc_nama->HrefValue;
			$LinkAttrs = &$this->qc_nama->LinkAttrs;
			$this->Cell_Rendered($this->qc_nama, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// ver_catatan
			$CurrentValue = $this->ver_catatan->CurrentValue;
			$ViewValue = &$this->ver_catatan->ViewValue;
			$ViewAttrs = &$this->ver_catatan->ViewAttrs;
			$CellAttrs = &$this->ver_catatan->CellAttrs;
			$HrefValue = &$this->ver_catatan->HrefValue;
			$LinkAttrs = &$this->ver_catatan->LinkAttrs;
			$this->Cell_Rendered($this->ver_catatan, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);
		}

		// Call Row_Rendered event
		$this->Row_Rendered();
		$this->SetupFieldCount();
	}

	// Setup field count
	function SetupFieldCount() {
		$this->GrpColumnCount = 0;
		$this->SubGrpColumnCount = 0;
		$this->DtlColumnCount = 0;
		if ($this->datang_id->Visible) $this->DtlColumnCount += 1;
		if ($this->datang_tgl->Visible) $this->DtlColumnCount += 1;
		if ($this->datang_jumlah->Visible) $this->DtlColumnCount += 1;
		if ($this->ds_nama->Visible) $this->DtlColumnCount += 1;
		if ($this->datang_terpakai->Visible) $this->DtlColumnCount += 1;
		if ($this->var_nama->Visible) $this->DtlColumnCount += 1;
		if ($this->sup_nama->Visible) $this->DtlColumnCount += 1;
		if ($this->pet_nama->Visible) $this->DtlColumnCount += 1;
		if ($this->co_nama->Visible) $this->DtlColumnCount += 1;
		if ($this->k_id_kontrak->Visible) $this->DtlColumnCount += 1;
		if ($this->k_luas_lahan->Visible) $this->DtlColumnCount += 1;
		if ($this->k_es_tgl_panen->Visible) $this->DtlColumnCount += 1;
		if ($this->k_es_qty->Visible) $this->DtlColumnCount += 1;
		if ($this->ver_tgl->Visible) $this->DtlColumnCount += 1;
		if ($this->ver_presentasi_rijek->Visible) $this->DtlColumnCount += 1;
		if ($this->ver_hasil_id->Visible) $this->DtlColumnCount += 1;
		if ($this->qc_nama->Visible) $this->DtlColumnCount += 1;
		if ($this->ver_catatan->Visible) $this->DtlColumnCount += 1;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $ReportBreadcrumb;
		$ReportBreadcrumb = new crBreadcrumb();
		$url = substr(ewr_CurrentUrl(), strrpos(ewr_CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$ReportBreadcrumb->Add("summary", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	function SetupExportOptionsExt() {
		global $ReportLanguage, $ReportOptions;
		$ReportTypes = $ReportOptions["ReportTypes"];
		$item =& $this->ExportOptions->GetItem("pdf");
		$item->Visible = TRUE;
		if ($item->Visible)
			$ReportTypes["pdf"] = $ReportLanguage->Phrase("ReportFormPdf");
		$exportid = session_id();
		$url = $this->ExportPdfUrl;
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToPDF", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToPDF", TRUE)) . "\" href=\"javascript:void(0);\" onclick=\"ewr_ExportCharts(this, '" . $url . "', '" . $exportid . "');\">" . $ReportLanguage->Phrase("ExportToPDF") . "</a>";
		$ReportOptions["ReportTypes"] = $ReportTypes;
	}

	// Return extended filter
	function GetExtendedFilter() {
		global $gsFormError;
		$sFilter = "";
		if ($this->DrillDown)
			return "";
		$bPostBack = ewr_IsHttpPost();
		$bRestoreSession = TRUE;
		$bSetupFilter = FALSE;

		// Reset extended filter if filter changed
		if ($bPostBack) {

			// Set/clear dropdown for field qc_nama
			if ($this->PopupName == 'Kedatangan_Dan_Verifikasi_qc_nama' && $this->PopupValue <> "") {
				if ($this->PopupValue == EWR_INIT_VALUE)
					$this->qc_nama->DropDownValue = EWR_ALL_VALUE;
				else
					$this->qc_nama->DropDownValue = $this->PopupValue;
				$bRestoreSession = FALSE; // Do not restore
			} elseif ($this->ClearExtFilter == 'Kedatangan_Dan_Verifikasi_qc_nama') {
				$this->SetSessionDropDownValue(EWR_INIT_VALUE, '', 'qc_nama');
			}

		// Reset search command
		} elseif (@$_GET["cmd"] == "reset") {

			// Load default values
			$this->SetSessionFilterValues($this->datang_tgl->SearchValue, $this->datang_tgl->SearchOperator, $this->datang_tgl->SearchCondition, $this->datang_tgl->SearchValue2, $this->datang_tgl->SearchOperator2, 'datang_tgl'); // Field datang_tgl
			$this->SetSessionDropDownValue($this->ds_nama->DropDownValue, $this->ds_nama->SearchOperator, 'ds_nama'); // Field ds_nama
			$this->SetSessionDropDownValue($this->var_nama->DropDownValue, $this->var_nama->SearchOperator, 'var_nama'); // Field var_nama
			$this->SetSessionDropDownValue($this->sup_nama->DropDownValue, $this->sup_nama->SearchOperator, 'sup_nama'); // Field sup_nama
			$this->SetSessionDropDownValue($this->pet_nama->DropDownValue, $this->pet_nama->SearchOperator, 'pet_nama'); // Field pet_nama
			$this->SetSessionDropDownValue($this->co_nama->DropDownValue, $this->co_nama->SearchOperator, 'co_nama'); // Field co_nama
			$this->SetSessionDropDownValue($this->k_id_kontrak->DropDownValue, $this->k_id_kontrak->SearchOperator, 'k_id_kontrak'); // Field k_id_kontrak
			$this->SetSessionFilterValues($this->k_es_tgl_panen->SearchValue, $this->k_es_tgl_panen->SearchOperator, $this->k_es_tgl_panen->SearchCondition, $this->k_es_tgl_panen->SearchValue2, $this->k_es_tgl_panen->SearchOperator2, 'k_es_tgl_panen'); // Field k_es_tgl_panen
			$this->SetSessionFilterValues($this->ver_tgl->SearchValue, $this->ver_tgl->SearchOperator, $this->ver_tgl->SearchCondition, $this->ver_tgl->SearchValue2, $this->ver_tgl->SearchOperator2, 'ver_tgl'); // Field ver_tgl
			$this->SetSessionDropDownValue($this->ver_hasil_id->DropDownValue, $this->ver_hasil_id->SearchOperator, 'ver_hasil_id'); // Field ver_hasil_id
			$this->SetSessionDropDownValue($this->qc_nama->DropDownValue, $this->qc_nama->SearchOperator, 'qc_nama'); // Field qc_nama

			//$bSetupFilter = TRUE; // No need to set up, just use default
		} else {
			$bRestoreSession = !$this->SearchCommand;

			// Field datang_tgl
			if ($this->GetFilterValues($this->datang_tgl)) {
				$bSetupFilter = TRUE;
			}

			// Field ds_nama
			if ($this->GetDropDownValue($this->ds_nama)) {
				$bSetupFilter = TRUE;
			} elseif ($this->ds_nama->DropDownValue <> EWR_INIT_VALUE && !isset($_SESSION['sv_Kedatangan_Dan_Verifikasi_ds_nama'])) {
				$bSetupFilter = TRUE;
			}

			// Field var_nama
			if ($this->GetDropDownValue($this->var_nama)) {
				$bSetupFilter = TRUE;
			} elseif ($this->var_nama->DropDownValue <> EWR_INIT_VALUE && !isset($_SESSION['sv_Kedatangan_Dan_Verifikasi_var_nama'])) {
				$bSetupFilter = TRUE;
			}

			// Field sup_nama
			if ($this->GetDropDownValue($this->sup_nama)) {
				$bSetupFilter = TRUE;
			} elseif ($this->sup_nama->DropDownValue <> EWR_INIT_VALUE && !isset($_SESSION['sv_Kedatangan_Dan_Verifikasi_sup_nama'])) {
				$bSetupFilter = TRUE;
			}

			// Field pet_nama
			if ($this->GetDropDownValue($this->pet_nama)) {
				$bSetupFilter = TRUE;
			} elseif ($this->pet_nama->DropDownValue <> EWR_INIT_VALUE && !isset($_SESSION['sv_Kedatangan_Dan_Verifikasi_pet_nama'])) {
				$bSetupFilter = TRUE;
			}

			// Field co_nama
			if ($this->GetDropDownValue($this->co_nama)) {
				$bSetupFilter = TRUE;
			} elseif ($this->co_nama->DropDownValue <> EWR_INIT_VALUE && !isset($_SESSION['sv_Kedatangan_Dan_Verifikasi_co_nama'])) {
				$bSetupFilter = TRUE;
			}

			// Field k_id_kontrak
			if ($this->GetDropDownValue($this->k_id_kontrak)) {
				$bSetupFilter = TRUE;
			} elseif ($this->k_id_kontrak->DropDownValue <> EWR_INIT_VALUE && !isset($_SESSION['sv_Kedatangan_Dan_Verifikasi_k_id_kontrak'])) {
				$bSetupFilter = TRUE;
			}

			// Field k_es_tgl_panen
			if ($this->GetFilterValues($this->k_es_tgl_panen)) {
				$bSetupFilter = TRUE;
			}

			// Field ver_tgl
			if ($this->GetFilterValues($this->ver_tgl)) {
				$bSetupFilter = TRUE;
			}

			// Field ver_hasil_id
			if ($this->GetDropDownValue($this->ver_hasil_id)) {
				$bSetupFilter = TRUE;
			} elseif ($this->ver_hasil_id->DropDownValue <> EWR_INIT_VALUE && !isset($_SESSION['sv_Kedatangan_Dan_Verifikasi_ver_hasil_id'])) {
				$bSetupFilter = TRUE;
			}

			// Field qc_nama
			if ($this->GetDropDownValue($this->qc_nama)) {
				$bSetupFilter = TRUE;
			} elseif ($this->qc_nama->DropDownValue <> EWR_INIT_VALUE && !isset($_SESSION['sv_Kedatangan_Dan_Verifikasi_qc_nama'])) {
				$bSetupFilter = TRUE;
			}
			if (!$this->ValidateForm()) {
				$this->setFailureMessage($gsFormError);
				return $sFilter;
			}
		}

		// Restore session
		if ($bRestoreSession) {
			$this->GetSessionFilterValues($this->datang_tgl); // Field datang_tgl
			$this->GetSessionDropDownValue($this->ds_nama); // Field ds_nama
			$this->GetSessionDropDownValue($this->var_nama); // Field var_nama
			$this->GetSessionDropDownValue($this->sup_nama); // Field sup_nama
			$this->GetSessionDropDownValue($this->pet_nama); // Field pet_nama
			$this->GetSessionDropDownValue($this->co_nama); // Field co_nama
			$this->GetSessionDropDownValue($this->k_id_kontrak); // Field k_id_kontrak
			$this->GetSessionFilterValues($this->k_es_tgl_panen); // Field k_es_tgl_panen
			$this->GetSessionFilterValues($this->ver_tgl); // Field ver_tgl
			$this->GetSessionDropDownValue($this->ver_hasil_id); // Field ver_hasil_id
			$this->GetSessionDropDownValue($this->qc_nama); // Field qc_nama
		}

		// Call page filter validated event
		$this->Page_FilterValidated();

		// Build SQL
		$this->BuildExtendedFilter($this->datang_tgl, $sFilter, FALSE, TRUE); // Field datang_tgl
		$this->BuildDropDownFilter($this->ds_nama, $sFilter, $this->ds_nama->SearchOperator, FALSE, TRUE); // Field ds_nama
		$this->BuildDropDownFilter($this->var_nama, $sFilter, $this->var_nama->SearchOperator, FALSE, TRUE); // Field var_nama
		$this->BuildDropDownFilter($this->sup_nama, $sFilter, $this->sup_nama->SearchOperator, FALSE, TRUE); // Field sup_nama
		$this->BuildDropDownFilter($this->pet_nama, $sFilter, $this->pet_nama->SearchOperator, FALSE, TRUE); // Field pet_nama
		$this->BuildDropDownFilter($this->co_nama, $sFilter, $this->co_nama->SearchOperator, FALSE, TRUE); // Field co_nama
		$this->BuildDropDownFilter($this->k_id_kontrak, $sFilter, $this->k_id_kontrak->SearchOperator, FALSE, TRUE); // Field k_id_kontrak
		$this->BuildExtendedFilter($this->k_es_tgl_panen, $sFilter, FALSE, TRUE); // Field k_es_tgl_panen
		$this->BuildExtendedFilter($this->ver_tgl, $sFilter, FALSE, TRUE); // Field ver_tgl
		$this->BuildDropDownFilter($this->ver_hasil_id, $sFilter, $this->ver_hasil_id->SearchOperator, FALSE, TRUE); // Field ver_hasil_id
		$this->BuildDropDownFilter($this->qc_nama, $sFilter, $this->qc_nama->SearchOperator, FALSE, TRUE); // Field qc_nama

		// Save parms to session
		$this->SetSessionFilterValues($this->datang_tgl->SearchValue, $this->datang_tgl->SearchOperator, $this->datang_tgl->SearchCondition, $this->datang_tgl->SearchValue2, $this->datang_tgl->SearchOperator2, 'datang_tgl'); // Field datang_tgl
		$this->SetSessionDropDownValue($this->ds_nama->DropDownValue, $this->ds_nama->SearchOperator, 'ds_nama'); // Field ds_nama
		$this->SetSessionDropDownValue($this->var_nama->DropDownValue, $this->var_nama->SearchOperator, 'var_nama'); // Field var_nama
		$this->SetSessionDropDownValue($this->sup_nama->DropDownValue, $this->sup_nama->SearchOperator, 'sup_nama'); // Field sup_nama
		$this->SetSessionDropDownValue($this->pet_nama->DropDownValue, $this->pet_nama->SearchOperator, 'pet_nama'); // Field pet_nama
		$this->SetSessionDropDownValue($this->co_nama->DropDownValue, $this->co_nama->SearchOperator, 'co_nama'); // Field co_nama
		$this->SetSessionDropDownValue($this->k_id_kontrak->DropDownValue, $this->k_id_kontrak->SearchOperator, 'k_id_kontrak'); // Field k_id_kontrak
		$this->SetSessionFilterValues($this->k_es_tgl_panen->SearchValue, $this->k_es_tgl_panen->SearchOperator, $this->k_es_tgl_panen->SearchCondition, $this->k_es_tgl_panen->SearchValue2, $this->k_es_tgl_panen->SearchOperator2, 'k_es_tgl_panen'); // Field k_es_tgl_panen
		$this->SetSessionFilterValues($this->ver_tgl->SearchValue, $this->ver_tgl->SearchOperator, $this->ver_tgl->SearchCondition, $this->ver_tgl->SearchValue2, $this->ver_tgl->SearchOperator2, 'ver_tgl'); // Field ver_tgl
		$this->SetSessionDropDownValue($this->ver_hasil_id->DropDownValue, $this->ver_hasil_id->SearchOperator, 'ver_hasil_id'); // Field ver_hasil_id
		$this->SetSessionDropDownValue($this->qc_nama->DropDownValue, $this->qc_nama->SearchOperator, 'qc_nama'); // Field qc_nama

		// Setup filter
		if ($bSetupFilter) {

			// Field qc_nama
			$sWrk = "";
			$this->BuildDropDownFilter($this->qc_nama, $sWrk, $this->qc_nama->SearchOperator);
			ewr_LoadSelectionFromFilter($this->qc_nama, $sWrk, $this->qc_nama->SelectionList, $this->qc_nama->DropDownValue);
			$_SESSION['sel_Kedatangan_Dan_Verifikasi_qc_nama'] = ($this->qc_nama->SelectionList == "") ? EWR_INIT_VALUE : $this->qc_nama->SelectionList;
		}

		// Field ds_nama
		ewr_LoadDropDownList($this->ds_nama->DropDownList, $this->ds_nama->DropDownValue);

		// Field var_nama
		ewr_LoadDropDownList($this->var_nama->DropDownList, $this->var_nama->DropDownValue);

		// Field sup_nama
		ewr_LoadDropDownList($this->sup_nama->DropDownList, $this->sup_nama->DropDownValue);

		// Field pet_nama
		ewr_LoadDropDownList($this->pet_nama->DropDownList, $this->pet_nama->DropDownValue);

		// Field co_nama
		ewr_LoadDropDownList($this->co_nama->DropDownList, $this->co_nama->DropDownValue);

		// Field k_id_kontrak
		ewr_LoadDropDownList($this->k_id_kontrak->DropDownList, $this->k_id_kontrak->DropDownValue);

		// Field ver_hasil_id
		ewr_LoadDropDownList($this->ver_hasil_id->DropDownList, $this->ver_hasil_id->DropDownValue);

		// Field qc_nama
		ewr_LoadDropDownList($this->qc_nama->DropDownList, $this->qc_nama->DropDownValue);
		return $sFilter;
	}

	// Build dropdown filter
	function BuildDropDownFilter(&$fld, &$FilterClause, $FldOpr, $Default = FALSE, $SaveFilter = FALSE) {
		$FldVal = ($Default) ? $fld->DefaultDropDownValue : $fld->DropDownValue;
		$sSql = "";
		if (is_array($FldVal)) {
			foreach ($FldVal as $val) {
				$sWrk = $this->GetDropDownFilter($fld, $val, $FldOpr);

				// Call Page Filtering event
				if (substr($val, 0, 2) <> "@@") $this->Page_Filtering($fld, $sWrk, "dropdown", $FldOpr, $val);
				if ($sWrk <> "") {
					if ($sSql <> "")
						$sSql .= " OR " . $sWrk;
					else
						$sSql = $sWrk;
				}
			}
		} else {
			$sSql = $this->GetDropDownFilter($fld, $FldVal, $FldOpr);

			// Call Page Filtering event
			if (substr($FldVal, 0, 2) <> "@@") $this->Page_Filtering($fld, $sSql, "dropdown", $FldOpr, $FldVal);
		}
		if ($sSql <> "") {
			ewr_AddFilter($FilterClause, $sSql);
			if ($SaveFilter) $fld->CurrentFilter = $sSql;
		}
	}

	function GetDropDownFilter(&$fld, $FldVal, $FldOpr) {
		$FldName = $fld->FldName;
		$FldExpression = $fld->FldExpression;
		$FldDataType = $fld->FldDataType;
		$FldDelimiter = $fld->FldDelimiter;
		$FldVal = strval($FldVal);
		if ($FldOpr == "") $FldOpr = "=";
		$sWrk = "";
		if (ewr_SameStr($FldVal, EWR_NULL_VALUE)) {
			$sWrk = $FldExpression . " IS NULL";
		} elseif (ewr_SameStr($FldVal, EWR_NOT_NULL_VALUE)) {
			$sWrk = $FldExpression . " IS NOT NULL";
		} elseif (ewr_SameStr($FldVal, EWR_EMPTY_VALUE)) {
			$sWrk = $FldExpression . " = ''";
		} elseif (ewr_SameStr($FldVal, EWR_ALL_VALUE)) {
			$sWrk = "1 = 1";
		} else {
			if (substr($FldVal, 0, 2) == "@@") {
				$sWrk = $this->GetCustomFilter($fld, $FldVal, $this->DBID);
			} elseif ($FldDelimiter <> "" && trim($FldVal) <> "" && ($FldDataType == EWR_DATATYPE_STRING || $FldDataType == EWR_DATATYPE_MEMO)) {
				$sWrk = ewr_GetMultiSearchSql($FldExpression, trim($FldVal), $this->DBID);
			} else {
				if ($FldVal <> "" && $FldVal <> EWR_INIT_VALUE) {
					if ($FldDataType == EWR_DATATYPE_DATE && $FldOpr <> "") {
						$sWrk = ewr_DateFilterString($FldExpression, $FldOpr, $FldVal, $FldDataType, $this->DBID);
					} else {
						$sWrk = ewr_FilterString($FldOpr, $FldVal, $FldDataType, $this->DBID);
						if ($sWrk <> "") $sWrk = $FldExpression . $sWrk;
					}
				}
			}
		}
		return $sWrk;
	}

	// Get custom filter
	function GetCustomFilter(&$fld, $FldVal, $dbid = 0) {
		$sWrk = "";
		if (is_array($fld->AdvancedFilters)) {
			foreach ($fld->AdvancedFilters as $filter) {
				if ($filter->ID == $FldVal && $filter->Enabled) {
					$sFld = $fld->FldExpression;
					$sFn = $filter->FunctionName;
					$wrkid = (substr($filter->ID,0,2) == "@@") ? substr($filter->ID,2) : $filter->ID;
					if ($sFn <> "")
						$sWrk = $sFn($sFld, $dbid);
					else
						$sWrk = "";
					$this->Page_Filtering($fld, $sWrk, "custom", $wrkid);
					break;
				}
			}
		}
		return $sWrk;
	}

	// Build extended filter
	function BuildExtendedFilter(&$fld, &$FilterClause, $Default = FALSE, $SaveFilter = FALSE) {
		$sWrk = ewr_GetExtendedFilter($fld, $Default, $this->DBID);
		if (!$Default)
			$this->Page_Filtering($fld, $sWrk, "extended", $fld->SearchOperator, $fld->SearchValue, $fld->SearchCondition, $fld->SearchOperator2, $fld->SearchValue2);
		if ($sWrk <> "") {
			ewr_AddFilter($FilterClause, $sWrk);
			if ($SaveFilter) $fld->CurrentFilter = $sWrk;
		}
	}

	// Get drop down value from querystring
	function GetDropDownValue(&$fld) {
		$parm = substr($fld->FldVar, 2);
		if (ewr_IsHttpPost())
			return FALSE; // Skip post back
		if (isset($_GET["so_$parm"]))
			$fld->SearchOperator = ewr_StripSlashes(@$_GET["so_$parm"]);
		if (isset($_GET["sv_$parm"])) {
			$fld->DropDownValue = ewr_StripSlashes(@$_GET["sv_$parm"]);
			return TRUE;
		}
		return FALSE;
	}

	// Get filter values from querystring
	function GetFilterValues(&$fld) {
		$parm = substr($fld->FldVar, 2);
		if (ewr_IsHttpPost())
			return; // Skip post back
		$got = FALSE;
		if (isset($_GET["sv_$parm"])) {
			$fld->SearchValue = ewr_StripSlashes(@$_GET["sv_$parm"]);
			$got = TRUE;
		}
		if (isset($_GET["so_$parm"])) {
			$fld->SearchOperator = ewr_StripSlashes(@$_GET["so_$parm"]);
			$got = TRUE;
		}
		if (isset($_GET["sc_$parm"])) {
			$fld->SearchCondition = ewr_StripSlashes(@$_GET["sc_$parm"]);
			$got = TRUE;
		}
		if (isset($_GET["sv2_$parm"])) {
			$fld->SearchValue2 = ewr_StripSlashes(@$_GET["sv2_$parm"]);
			$got = TRUE;
		}
		if (isset($_GET["so2_$parm"])) {
			$fld->SearchOperator2 = ewr_StripSlashes($_GET["so2_$parm"]);
			$got = TRUE;
		}
		return $got;
	}

	// Set default ext filter
	function SetDefaultExtFilter(&$fld, $so1, $sv1, $sc, $so2, $sv2) {
		$fld->DefaultSearchValue = $sv1; // Default ext filter value 1
		$fld->DefaultSearchValue2 = $sv2; // Default ext filter value 2 (if operator 2 is enabled)
		$fld->DefaultSearchOperator = $so1; // Default search operator 1
		$fld->DefaultSearchOperator2 = $so2; // Default search operator 2 (if operator 2 is enabled)
		$fld->DefaultSearchCondition = $sc; // Default search condition (if operator 2 is enabled)
	}

	// Apply default ext filter
	function ApplyDefaultExtFilter(&$fld) {
		$fld->SearchValue = $fld->DefaultSearchValue;
		$fld->SearchValue2 = $fld->DefaultSearchValue2;
		$fld->SearchOperator = $fld->DefaultSearchOperator;
		$fld->SearchOperator2 = $fld->DefaultSearchOperator2;
		$fld->SearchCondition = $fld->DefaultSearchCondition;
	}

	// Check if Text Filter applied
	function TextFilterApplied(&$fld) {
		return (strval($fld->SearchValue) <> strval($fld->DefaultSearchValue) ||
			strval($fld->SearchValue2) <> strval($fld->DefaultSearchValue2) ||
			(strval($fld->SearchValue) <> "" &&
				strval($fld->SearchOperator) <> strval($fld->DefaultSearchOperator)) ||
			(strval($fld->SearchValue2) <> "" &&
				strval($fld->SearchOperator2) <> strval($fld->DefaultSearchOperator2)) ||
			strval($fld->SearchCondition) <> strval($fld->DefaultSearchCondition));
	}

	// Check if Non-Text Filter applied
	function NonTextFilterApplied(&$fld) {
		if (is_array($fld->DropDownValue)) {
			if (is_array($fld->DefaultDropDownValue)) {
				if (count($fld->DefaultDropDownValue) <> count($fld->DropDownValue))
					return TRUE;
				else
					return (count(array_diff($fld->DefaultDropDownValue, $fld->DropDownValue)) <> 0);
			} else {
				return TRUE;
			}
		} else {
			if (is_array($fld->DefaultDropDownValue))
				return TRUE;
			else
				$v1 = strval($fld->DefaultDropDownValue);
			if ($v1 == EWR_INIT_VALUE)
				$v1 = "";
			$v2 = strval($fld->DropDownValue);
			if ($v2 == EWR_INIT_VALUE || $v2 == EWR_ALL_VALUE)
				$v2 = "";
			return ($v1 <> $v2);
		}
	}

	// Get dropdown value from session
	function GetSessionDropDownValue(&$fld) {
		$parm = substr($fld->FldVar, 2);
		$this->GetSessionValue($fld->DropDownValue, 'sv_Kedatangan_Dan_Verifikasi_' . $parm);
		$this->GetSessionValue($fld->SearchOperator, 'so_Kedatangan_Dan_Verifikasi_' . $parm);
	}

	// Get filter values from session
	function GetSessionFilterValues(&$fld) {
		$parm = substr($fld->FldVar, 2);
		$this->GetSessionValue($fld->SearchValue, 'sv_Kedatangan_Dan_Verifikasi_' . $parm);
		$this->GetSessionValue($fld->SearchOperator, 'so_Kedatangan_Dan_Verifikasi_' . $parm);
		$this->GetSessionValue($fld->SearchCondition, 'sc_Kedatangan_Dan_Verifikasi_' . $parm);
		$this->GetSessionValue($fld->SearchValue2, 'sv2_Kedatangan_Dan_Verifikasi_' . $parm);
		$this->GetSessionValue($fld->SearchOperator2, 'so2_Kedatangan_Dan_Verifikasi_' . $parm);
	}

	// Get value from session
	function GetSessionValue(&$sv, $sn) {
		if (array_key_exists($sn, $_SESSION))
			$sv = $_SESSION[$sn];
	}

	// Set dropdown value to session
	function SetSessionDropDownValue($sv, $so, $parm) {
		$_SESSION['sv_Kedatangan_Dan_Verifikasi_' . $parm] = $sv;
		$_SESSION['so_Kedatangan_Dan_Verifikasi_' . $parm] = $so;
	}

	// Set filter values to session
	function SetSessionFilterValues($sv1, $so1, $sc, $sv2, $so2, $parm) {
		$_SESSION['sv_Kedatangan_Dan_Verifikasi_' . $parm] = $sv1;
		$_SESSION['so_Kedatangan_Dan_Verifikasi_' . $parm] = $so1;
		$_SESSION['sc_Kedatangan_Dan_Verifikasi_' . $parm] = $sc;
		$_SESSION['sv2_Kedatangan_Dan_Verifikasi_' . $parm] = $sv2;
		$_SESSION['so2_Kedatangan_Dan_Verifikasi_' . $parm] = $so2;
	}

	// Check if has Session filter values
	function HasSessionFilterValues($parm) {
		return ((@$_SESSION['sv_' . $parm] <> "" && @$_SESSION['sv_' . $parm] <> EWR_INIT_VALUE) ||
			(@$_SESSION['sv_' . $parm] <> "" && @$_SESSION['sv_' . $parm] <> EWR_INIT_VALUE) ||
			(@$_SESSION['sv2_' . $parm] <> "" && @$_SESSION['sv2_' . $parm] <> EWR_INIT_VALUE));
	}

	// Dropdown filter exist
	function DropDownFilterExist(&$fld, $FldOpr) {
		$sWrk = "";
		$this->BuildDropDownFilter($fld, $sWrk, $FldOpr);
		return ($sWrk <> "");
	}

	// Extended filter exist
	function ExtendedFilterExist(&$fld) {
		$sExtWrk = "";
		$this->BuildExtendedFilter($fld, $sExtWrk);
		return ($sExtWrk <> "");
	}

	// Validate form
	function ValidateForm() {
		global $ReportLanguage, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EWR_SERVER_VALIDATE)
			return ($gsFormError == "");
		if (!ewr_CheckDateDef($this->datang_tgl->SearchValue)) {
			if ($gsFormError <> "") $gsFormError .= "<br>";
			$gsFormError .= $this->datang_tgl->FldErrMsg();
		}
		if (!ewr_CheckDateDef($this->k_es_tgl_panen->SearchValue)) {
			if ($gsFormError <> "") $gsFormError .= "<br>";
			$gsFormError .= $this->k_es_tgl_panen->FldErrMsg();
		}
		if (!ewr_CheckDateDef($this->ver_tgl->SearchValue)) {
			if ($gsFormError <> "") $gsFormError .= "<br>";
			$gsFormError .= $this->ver_tgl->FldErrMsg();
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			$gsFormError .= ($gsFormError <> "") ? "<p>&nbsp;</p>" : "";
			$gsFormError .= $sFormCustomError;
		}
		return $ValidateForm;
	}

	// Clear selection stored in session
	function ClearSessionSelection($parm) {
		$_SESSION["sel_Kedatangan_Dan_Verifikasi_$parm"] = "";
		$_SESSION["rf_Kedatangan_Dan_Verifikasi_$parm"] = "";
		$_SESSION["rt_Kedatangan_Dan_Verifikasi_$parm"] = "";
	}

	// Load selection from session
	function LoadSelectionFromSession($parm) {
		$fld = &$this->FieldByParm($parm);
		$fld->SelectionList = @$_SESSION["sel_Kedatangan_Dan_Verifikasi_$parm"];
		$fld->RangeFrom = @$_SESSION["rf_Kedatangan_Dan_Verifikasi_$parm"];
		$fld->RangeTo = @$_SESSION["rt_Kedatangan_Dan_Verifikasi_$parm"];
	}

	// Load default value for filters
	function LoadDefaultFilters() {
		/**
		* Set up default values for non Text filters
		*/

		// Field ds_nama
		$this->ds_nama->DefaultDropDownValue = EWR_INIT_VALUE;
		if (!$this->SearchCommand) $this->ds_nama->DropDownValue = $this->ds_nama->DefaultDropDownValue;

		// Field var_nama
		$this->var_nama->DefaultDropDownValue = EWR_INIT_VALUE;
		if (!$this->SearchCommand) $this->var_nama->DropDownValue = $this->var_nama->DefaultDropDownValue;

		// Field sup_nama
		$this->sup_nama->DefaultDropDownValue = EWR_INIT_VALUE;
		if (!$this->SearchCommand) $this->sup_nama->DropDownValue = $this->sup_nama->DefaultDropDownValue;

		// Field pet_nama
		$this->pet_nama->DefaultDropDownValue = EWR_INIT_VALUE;
		if (!$this->SearchCommand) $this->pet_nama->DropDownValue = $this->pet_nama->DefaultDropDownValue;

		// Field co_nama
		$this->co_nama->DefaultDropDownValue = EWR_INIT_VALUE;
		if (!$this->SearchCommand) $this->co_nama->DropDownValue = $this->co_nama->DefaultDropDownValue;

		// Field k_id_kontrak
		$this->k_id_kontrak->DefaultDropDownValue = EWR_INIT_VALUE;
		if (!$this->SearchCommand) $this->k_id_kontrak->DropDownValue = $this->k_id_kontrak->DefaultDropDownValue;

		// Field ver_hasil_id
		$this->ver_hasil_id->DefaultDropDownValue = EWR_INIT_VALUE;
		if (!$this->SearchCommand) $this->ver_hasil_id->DropDownValue = $this->ver_hasil_id->DefaultDropDownValue;

		// Field qc_nama
		$this->qc_nama->DefaultDropDownValue = EWR_INIT_VALUE;
		if (!$this->SearchCommand) $this->qc_nama->DropDownValue = $this->qc_nama->DefaultDropDownValue;
		$sWrk = "";
		$this->BuildDropDownFilter($this->qc_nama, $sWrk, $this->qc_nama->SearchOperator, TRUE);
		ewr_LoadSelectionFromFilter($this->qc_nama, $sWrk, $this->qc_nama->DefaultSelectionList);
		if (!$this->SearchCommand) $this->qc_nama->SelectionList = $this->qc_nama->DefaultSelectionList;
		/**
		* Set up default values for extended filters
		* function SetDefaultExtFilter(&$fld, $so1, $sv1, $sc, $so2, $sv2)
		* Parameters:
		* $fld - Field object
		* $so1 - Default search operator 1
		* $sv1 - Default ext filter value 1
		* $sc - Default search condition (if operator 2 is enabled)
		* $so2 - Default search operator 2 (if operator 2 is enabled)
		* $sv2 - Default ext filter value 2 (if operator 2 is enabled)
		*/

		// Field datang_tgl
		$this->SetDefaultExtFilter($this->datang_tgl, "=", NULL, 'AND', "=", NULL);
		if (!$this->SearchCommand) $this->ApplyDefaultExtFilter($this->datang_tgl);

		// Field k_es_tgl_panen
		$this->SetDefaultExtFilter($this->k_es_tgl_panen, "=", NULL, 'AND', "=", NULL);
		if (!$this->SearchCommand) $this->ApplyDefaultExtFilter($this->k_es_tgl_panen);

		// Field ver_tgl
		$this->SetDefaultExtFilter($this->ver_tgl, "=", NULL, 'AND', "=", NULL);
		if (!$this->SearchCommand) $this->ApplyDefaultExtFilter($this->ver_tgl);
		/**
		* Set up default values for popup filters
		*/

		// Field qc_nama
		// $this->qc_nama->DefaultSelectionList = array("val1", "val2");

	}

	// Check if filter applied
	function CheckFilter() {

		// Check datang_tgl text filter
		if ($this->TextFilterApplied($this->datang_tgl))
			return TRUE;

		// Check ds_nama extended filter
		if ($this->NonTextFilterApplied($this->ds_nama))
			return TRUE;

		// Check var_nama extended filter
		if ($this->NonTextFilterApplied($this->var_nama))
			return TRUE;

		// Check sup_nama extended filter
		if ($this->NonTextFilterApplied($this->sup_nama))
			return TRUE;

		// Check pet_nama extended filter
		if ($this->NonTextFilterApplied($this->pet_nama))
			return TRUE;

		// Check co_nama extended filter
		if ($this->NonTextFilterApplied($this->co_nama))
			return TRUE;

		// Check k_id_kontrak extended filter
		if ($this->NonTextFilterApplied($this->k_id_kontrak))
			return TRUE;

		// Check k_es_tgl_panen text filter
		if ($this->TextFilterApplied($this->k_es_tgl_panen))
			return TRUE;

		// Check ver_tgl text filter
		if ($this->TextFilterApplied($this->ver_tgl))
			return TRUE;

		// Check ver_hasil_id extended filter
		if ($this->NonTextFilterApplied($this->ver_hasil_id))
			return TRUE;

		// Check qc_nama extended filter
		if ($this->NonTextFilterApplied($this->qc_nama))
			return TRUE;

		// Check qc_nama popup filter
		if (!ewr_MatchedArray($this->qc_nama->DefaultSelectionList, $this->qc_nama->SelectionList))
			return TRUE;
		return FALSE;
	}

	// Show list of filters
	function ShowFilterList($showDate = FALSE) {
		global $ReportLanguage;

		// Initialize
		$sFilterList = "";

		// Field datang_tgl
		$sExtWrk = "";
		$sWrk = "";
		$this->BuildExtendedFilter($this->datang_tgl, $sExtWrk);
		$sFilter = "";
		if ($sExtWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sExtWrk</span>";
		elseif ($sWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sWrk</span>";
		if ($sFilter <> "")
			$sFilterList .= "<div><span class=\"ewFilterCaption\">" . $this->datang_tgl->FldCaption() . "</span>" . $sFilter . "</div>";

		// Field ds_nama
		$sExtWrk = "";
		$sWrk = "";
		$this->BuildDropDownFilter($this->ds_nama, $sExtWrk, $this->ds_nama->SearchOperator);
		$sFilter = "";
		if ($sExtWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sExtWrk</span>";
		elseif ($sWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sWrk</span>";
		if ($sFilter <> "")
			$sFilterList .= "<div><span class=\"ewFilterCaption\">" . $this->ds_nama->FldCaption() . "</span>" . $sFilter . "</div>";

		// Field var_nama
		$sExtWrk = "";
		$sWrk = "";
		$this->BuildDropDownFilter($this->var_nama, $sExtWrk, $this->var_nama->SearchOperator);
		$sFilter = "";
		if ($sExtWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sExtWrk</span>";
		elseif ($sWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sWrk</span>";
		if ($sFilter <> "")
			$sFilterList .= "<div><span class=\"ewFilterCaption\">" . $this->var_nama->FldCaption() . "</span>" . $sFilter . "</div>";

		// Field sup_nama
		$sExtWrk = "";
		$sWrk = "";
		$this->BuildDropDownFilter($this->sup_nama, $sExtWrk, $this->sup_nama->SearchOperator);
		$sFilter = "";
		if ($sExtWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sExtWrk</span>";
		elseif ($sWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sWrk</span>";
		if ($sFilter <> "")
			$sFilterList .= "<div><span class=\"ewFilterCaption\">" . $this->sup_nama->FldCaption() . "</span>" . $sFilter . "</div>";

		// Field pet_nama
		$sExtWrk = "";
		$sWrk = "";
		$this->BuildDropDownFilter($this->pet_nama, $sExtWrk, $this->pet_nama->SearchOperator);
		$sFilter = "";
		if ($sExtWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sExtWrk</span>";
		elseif ($sWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sWrk</span>";
		if ($sFilter <> "")
			$sFilterList .= "<div><span class=\"ewFilterCaption\">" . $this->pet_nama->FldCaption() . "</span>" . $sFilter . "</div>";

		// Field co_nama
		$sExtWrk = "";
		$sWrk = "";
		$this->BuildDropDownFilter($this->co_nama, $sExtWrk, $this->co_nama->SearchOperator);
		$sFilter = "";
		if ($sExtWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sExtWrk</span>";
		elseif ($sWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sWrk</span>";
		if ($sFilter <> "")
			$sFilterList .= "<div><span class=\"ewFilterCaption\">" . $this->co_nama->FldCaption() . "</span>" . $sFilter . "</div>";

		// Field k_id_kontrak
		$sExtWrk = "";
		$sWrk = "";
		$this->BuildDropDownFilter($this->k_id_kontrak, $sExtWrk, $this->k_id_kontrak->SearchOperator);
		$sFilter = "";
		if ($sExtWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sExtWrk</span>";
		elseif ($sWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sWrk</span>";
		if ($sFilter <> "")
			$sFilterList .= "<div><span class=\"ewFilterCaption\">" . $this->k_id_kontrak->FldCaption() . "</span>" . $sFilter . "</div>";

		// Field k_es_tgl_panen
		$sExtWrk = "";
		$sWrk = "";
		$this->BuildExtendedFilter($this->k_es_tgl_panen, $sExtWrk);
		$sFilter = "";
		if ($sExtWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sExtWrk</span>";
		elseif ($sWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sWrk</span>";
		if ($sFilter <> "")
			$sFilterList .= "<div><span class=\"ewFilterCaption\">" . $this->k_es_tgl_panen->FldCaption() . "</span>" . $sFilter . "</div>";

		// Field ver_tgl
		$sExtWrk = "";
		$sWrk = "";
		$this->BuildExtendedFilter($this->ver_tgl, $sExtWrk);
		$sFilter = "";
		if ($sExtWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sExtWrk</span>";
		elseif ($sWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sWrk</span>";
		if ($sFilter <> "")
			$sFilterList .= "<div><span class=\"ewFilterCaption\">" . $this->ver_tgl->FldCaption() . "</span>" . $sFilter . "</div>";

		// Field ver_hasil_id
		$sExtWrk = "";
		$sWrk = "";
		$this->BuildDropDownFilter($this->ver_hasil_id, $sExtWrk, $this->ver_hasil_id->SearchOperator);
		$sFilter = "";
		if ($sExtWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sExtWrk</span>";
		elseif ($sWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sWrk</span>";
		if ($sFilter <> "")
			$sFilterList .= "<div><span class=\"ewFilterCaption\">" . $this->ver_hasil_id->FldCaption() . "</span>" . $sFilter . "</div>";

		// Field qc_nama
		$sExtWrk = "";
		$sWrk = "";
		$this->BuildDropDownFilter($this->qc_nama, $sExtWrk, $this->qc_nama->SearchOperator);
		if (is_array($this->qc_nama->SelectionList))
			$sWrk = ewr_JoinArray($this->qc_nama->SelectionList, ", ", EWR_DATATYPE_STRING, 0, $this->DBID);
		$sFilter = "";
		if ($sExtWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sExtWrk</span>";
		elseif ($sWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sWrk</span>";
		if ($sFilter <> "")
			$sFilterList .= "<div><span class=\"ewFilterCaption\">" . $this->qc_nama->FldCaption() . "</span>" . $sFilter . "</div>";
		$divstyle = "";
		$divdataclass = "";

		// Show Filters
		if ($sFilterList <> "" || $showDate) {
			$sMessage = "<div" . $divstyle . $divdataclass . "><div id=\"ewrFilterList\" class=\"alert alert-info ewDisplayTable\">";
			if ($showDate)
				$sMessage .= "<div id=\"ewrCurrentDate\">" . $ReportLanguage->Phrase("ReportGeneratedDate") . ewr_FormatDateTime(date("Y-m-d H:i:s"), 1) . "</div>";
			if ($sFilterList <> "")
				$sMessage .= "<div id=\"ewrCurrentFilters\">" . $ReportLanguage->Phrase("CurrentFilters") . "</div>" . $sFilterList;
			$sMessage .= "</div></div>";
			$this->Message_Showing($sMessage, "");
			echo $sMessage;
		}
	}

	// Get list of filters
	function GetFilterList() {

		// Initialize
		$sFilterList = "";

		// Field datang_tgl
		$sWrk = "";
		if ($this->datang_tgl->SearchValue <> "" || $this->datang_tgl->SearchValue2 <> "") {
			$sWrk = "\"sv_datang_tgl\":\"" . ewr_JsEncode2($this->datang_tgl->SearchValue) . "\"," .
				"\"so_datang_tgl\":\"" . ewr_JsEncode2($this->datang_tgl->SearchOperator) . "\"," .
				"\"sc_datang_tgl\":\"" . ewr_JsEncode2($this->datang_tgl->SearchCondition) . "\"," .
				"\"sv2_datang_tgl\":\"" . ewr_JsEncode2($this->datang_tgl->SearchValue2) . "\"," .
				"\"so2_datang_tgl\":\"" . ewr_JsEncode2($this->datang_tgl->SearchOperator2) . "\"";
		}
		if ($sWrk <> "") {
			if ($sFilterList <> "") $sFilterList .= ",";
			$sFilterList .= $sWrk;
		}

		// Field ds_nama
		$sWrk = "";
		$sWrk = ($this->ds_nama->DropDownValue <> EWR_INIT_VALUE) ? $this->ds_nama->DropDownValue : "";
		if (is_array($sWrk))
			$sWrk = implode("||", $sWrk);
		if ($sWrk <> "")
			$sWrk = "\"sv_ds_nama\":\"" . ewr_JsEncode2($sWrk) . "\"";
		if ($sWrk <> "") {
			if ($sFilterList <> "") $sFilterList .= ",";
			$sFilterList .= $sWrk;
		}

		// Field var_nama
		$sWrk = "";
		$sWrk = ($this->var_nama->DropDownValue <> EWR_INIT_VALUE) ? $this->var_nama->DropDownValue : "";
		if (is_array($sWrk))
			$sWrk = implode("||", $sWrk);
		if ($sWrk <> "")
			$sWrk = "\"sv_var_nama\":\"" . ewr_JsEncode2($sWrk) . "\"";
		if ($sWrk <> "") {
			if ($sFilterList <> "") $sFilterList .= ",";
			$sFilterList .= $sWrk;
		}

		// Field sup_nama
		$sWrk = "";
		$sWrk = ($this->sup_nama->DropDownValue <> EWR_INIT_VALUE) ? $this->sup_nama->DropDownValue : "";
		if (is_array($sWrk))
			$sWrk = implode("||", $sWrk);
		if ($sWrk <> "")
			$sWrk = "\"sv_sup_nama\":\"" . ewr_JsEncode2($sWrk) . "\"";
		if ($sWrk <> "") {
			if ($sFilterList <> "") $sFilterList .= ",";
			$sFilterList .= $sWrk;
		}

		// Field pet_nama
		$sWrk = "";
		$sWrk = ($this->pet_nama->DropDownValue <> EWR_INIT_VALUE) ? $this->pet_nama->DropDownValue : "";
		if (is_array($sWrk))
			$sWrk = implode("||", $sWrk);
		if ($sWrk <> "")
			$sWrk = "\"sv_pet_nama\":\"" . ewr_JsEncode2($sWrk) . "\"";
		if ($sWrk <> "") {
			if ($sFilterList <> "") $sFilterList .= ",";
			$sFilterList .= $sWrk;
		}

		// Field co_nama
		$sWrk = "";
		$sWrk = ($this->co_nama->DropDownValue <> EWR_INIT_VALUE) ? $this->co_nama->DropDownValue : "";
		if (is_array($sWrk))
			$sWrk = implode("||", $sWrk);
		if ($sWrk <> "")
			$sWrk = "\"sv_co_nama\":\"" . ewr_JsEncode2($sWrk) . "\"";
		if ($sWrk <> "") {
			if ($sFilterList <> "") $sFilterList .= ",";
			$sFilterList .= $sWrk;
		}

		// Field k_id_kontrak
		$sWrk = "";
		$sWrk = ($this->k_id_kontrak->DropDownValue <> EWR_INIT_VALUE) ? $this->k_id_kontrak->DropDownValue : "";
		if (is_array($sWrk))
			$sWrk = implode("||", $sWrk);
		if ($sWrk <> "")
			$sWrk = "\"sv_k_id_kontrak\":\"" . ewr_JsEncode2($sWrk) . "\"";
		if ($sWrk <> "") {
			if ($sFilterList <> "") $sFilterList .= ",";
			$sFilterList .= $sWrk;
		}

		// Field k_es_tgl_panen
		$sWrk = "";
		if ($this->k_es_tgl_panen->SearchValue <> "" || $this->k_es_tgl_panen->SearchValue2 <> "") {
			$sWrk = "\"sv_k_es_tgl_panen\":\"" . ewr_JsEncode2($this->k_es_tgl_panen->SearchValue) . "\"," .
				"\"so_k_es_tgl_panen\":\"" . ewr_JsEncode2($this->k_es_tgl_panen->SearchOperator) . "\"," .
				"\"sc_k_es_tgl_panen\":\"" . ewr_JsEncode2($this->k_es_tgl_panen->SearchCondition) . "\"," .
				"\"sv2_k_es_tgl_panen\":\"" . ewr_JsEncode2($this->k_es_tgl_panen->SearchValue2) . "\"," .
				"\"so2_k_es_tgl_panen\":\"" . ewr_JsEncode2($this->k_es_tgl_panen->SearchOperator2) . "\"";
		}
		if ($sWrk <> "") {
			if ($sFilterList <> "") $sFilterList .= ",";
			$sFilterList .= $sWrk;
		}

		// Field ver_tgl
		$sWrk = "";
		if ($this->ver_tgl->SearchValue <> "" || $this->ver_tgl->SearchValue2 <> "") {
			$sWrk = "\"sv_ver_tgl\":\"" . ewr_JsEncode2($this->ver_tgl->SearchValue) . "\"," .
				"\"so_ver_tgl\":\"" . ewr_JsEncode2($this->ver_tgl->SearchOperator) . "\"," .
				"\"sc_ver_tgl\":\"" . ewr_JsEncode2($this->ver_tgl->SearchCondition) . "\"," .
				"\"sv2_ver_tgl\":\"" . ewr_JsEncode2($this->ver_tgl->SearchValue2) . "\"," .
				"\"so2_ver_tgl\":\"" . ewr_JsEncode2($this->ver_tgl->SearchOperator2) . "\"";
		}
		if ($sWrk <> "") {
			if ($sFilterList <> "") $sFilterList .= ",";
			$sFilterList .= $sWrk;
		}

		// Field ver_hasil_id
		$sWrk = "";
		$sWrk = ($this->ver_hasil_id->DropDownValue <> EWR_INIT_VALUE) ? $this->ver_hasil_id->DropDownValue : "";
		if (is_array($sWrk))
			$sWrk = implode("||", $sWrk);
		if ($sWrk <> "")
			$sWrk = "\"sv_ver_hasil_id\":\"" . ewr_JsEncode2($sWrk) . "\"";
		if ($sWrk <> "") {
			if ($sFilterList <> "") $sFilterList .= ",";
			$sFilterList .= $sWrk;
		}

		// Field qc_nama
		$sWrk = "";
		$sWrk = ($this->qc_nama->DropDownValue <> EWR_INIT_VALUE) ? $this->qc_nama->DropDownValue : "";
		if (is_array($sWrk))
			$sWrk = implode("||", $sWrk);
		if ($sWrk <> "")
			$sWrk = "\"sv_qc_nama\":\"" . ewr_JsEncode2($sWrk) . "\"";
		if ($sWrk == "") {
			$sWrk = ($this->qc_nama->SelectionList <> EWR_INIT_VALUE) ? $this->qc_nama->SelectionList : "";
			if (is_array($sWrk))
				$sWrk = implode("||", $sWrk);
			if ($sWrk <> "")
				$sWrk = "\"sel_qc_nama\":\"" . ewr_JsEncode2($sWrk) . "\"";
		}
		if ($sWrk <> "") {
			if ($sFilterList <> "") $sFilterList .= ",";
			$sFilterList .= $sWrk;
		}

		// Return filter list in json
		if ($sFilterList <> "")
			return "{" . $sFilterList . "}";
		else
			return "null";
	}

	// Restore list of filters
	function RestoreFilterList() {

		// Return if not reset filter
		if (@$_POST["cmd"] <> "resetfilter")
			return FALSE;
		$filter = json_decode(ewr_StripSlashes(@$_POST["filter"]), TRUE);
		return $this->SetupFilterList($filter);
	}

	// Setup list of filters
	function SetupFilterList($filter) {
		if (!is_array($filter))
			return FALSE;

		// Field datang_tgl
		$bRestoreFilter = FALSE;
		if (array_key_exists("sv_datang_tgl", $filter) || array_key_exists("so_datang_tgl", $filter) ||
			array_key_exists("sc_datang_tgl", $filter) ||
			array_key_exists("sv2_datang_tgl", $filter) || array_key_exists("so2_datang_tgl", $filter)) {
			$this->SetSessionFilterValues(@$filter["sv_datang_tgl"], @$filter["so_datang_tgl"], @$filter["sc_datang_tgl"], @$filter["sv2_datang_tgl"], @$filter["so2_datang_tgl"], "datang_tgl");
			$bRestoreFilter = TRUE;
		}
		if (!$bRestoreFilter) { // Clear filter
			$this->SetSessionFilterValues("", "=", "AND", "", "=", "datang_tgl");
		}

		// Field ds_nama
		$bRestoreFilter = FALSE;
		if (array_key_exists("sv_ds_nama", $filter)) {
			$sWrk = $filter["sv_ds_nama"];
			if (strpos($sWrk, "||") !== FALSE)
				$sWrk = explode("||", $sWrk);
			$this->SetSessionDropDownValue($sWrk, @$filter["so_ds_nama"], "ds_nama");
			$bRestoreFilter = TRUE;
		}
		if (!$bRestoreFilter) { // Clear filter
			$this->SetSessionDropDownValue(EWR_INIT_VALUE, "", "ds_nama");
		}

		// Field var_nama
		$bRestoreFilter = FALSE;
		if (array_key_exists("sv_var_nama", $filter)) {
			$sWrk = $filter["sv_var_nama"];
			if (strpos($sWrk, "||") !== FALSE)
				$sWrk = explode("||", $sWrk);
			$this->SetSessionDropDownValue($sWrk, @$filter["so_var_nama"], "var_nama");
			$bRestoreFilter = TRUE;
		}
		if (!$bRestoreFilter) { // Clear filter
			$this->SetSessionDropDownValue(EWR_INIT_VALUE, "", "var_nama");
		}

		// Field sup_nama
		$bRestoreFilter = FALSE;
		if (array_key_exists("sv_sup_nama", $filter)) {
			$sWrk = $filter["sv_sup_nama"];
			if (strpos($sWrk, "||") !== FALSE)
				$sWrk = explode("||", $sWrk);
			$this->SetSessionDropDownValue($sWrk, @$filter["so_sup_nama"], "sup_nama");
			$bRestoreFilter = TRUE;
		}
		if (!$bRestoreFilter) { // Clear filter
			$this->SetSessionDropDownValue(EWR_INIT_VALUE, "", "sup_nama");
		}

		// Field pet_nama
		$bRestoreFilter = FALSE;
		if (array_key_exists("sv_pet_nama", $filter)) {
			$sWrk = $filter["sv_pet_nama"];
			if (strpos($sWrk, "||") !== FALSE)
				$sWrk = explode("||", $sWrk);
			$this->SetSessionDropDownValue($sWrk, @$filter["so_pet_nama"], "pet_nama");
			$bRestoreFilter = TRUE;
		}
		if (!$bRestoreFilter) { // Clear filter
			$this->SetSessionDropDownValue(EWR_INIT_VALUE, "", "pet_nama");
		}

		// Field co_nama
		$bRestoreFilter = FALSE;
		if (array_key_exists("sv_co_nama", $filter)) {
			$sWrk = $filter["sv_co_nama"];
			if (strpos($sWrk, "||") !== FALSE)
				$sWrk = explode("||", $sWrk);
			$this->SetSessionDropDownValue($sWrk, @$filter["so_co_nama"], "co_nama");
			$bRestoreFilter = TRUE;
		}
		if (!$bRestoreFilter) { // Clear filter
			$this->SetSessionDropDownValue(EWR_INIT_VALUE, "", "co_nama");
		}

		// Field k_id_kontrak
		$bRestoreFilter = FALSE;
		if (array_key_exists("sv_k_id_kontrak", $filter)) {
			$sWrk = $filter["sv_k_id_kontrak"];
			if (strpos($sWrk, "||") !== FALSE)
				$sWrk = explode("||", $sWrk);
			$this->SetSessionDropDownValue($sWrk, @$filter["so_k_id_kontrak"], "k_id_kontrak");
			$bRestoreFilter = TRUE;
		}
		if (!$bRestoreFilter) { // Clear filter
			$this->SetSessionDropDownValue(EWR_INIT_VALUE, "", "k_id_kontrak");
		}

		// Field k_es_tgl_panen
		$bRestoreFilter = FALSE;
		if (array_key_exists("sv_k_es_tgl_panen", $filter) || array_key_exists("so_k_es_tgl_panen", $filter) ||
			array_key_exists("sc_k_es_tgl_panen", $filter) ||
			array_key_exists("sv2_k_es_tgl_panen", $filter) || array_key_exists("so2_k_es_tgl_panen", $filter)) {
			$this->SetSessionFilterValues(@$filter["sv_k_es_tgl_panen"], @$filter["so_k_es_tgl_panen"], @$filter["sc_k_es_tgl_panen"], @$filter["sv2_k_es_tgl_panen"], @$filter["so2_k_es_tgl_panen"], "k_es_tgl_panen");
			$bRestoreFilter = TRUE;
		}
		if (!$bRestoreFilter) { // Clear filter
			$this->SetSessionFilterValues("", "=", "AND", "", "=", "k_es_tgl_panen");
		}

		// Field ver_tgl
		$bRestoreFilter = FALSE;
		if (array_key_exists("sv_ver_tgl", $filter) || array_key_exists("so_ver_tgl", $filter) ||
			array_key_exists("sc_ver_tgl", $filter) ||
			array_key_exists("sv2_ver_tgl", $filter) || array_key_exists("so2_ver_tgl", $filter)) {
			$this->SetSessionFilterValues(@$filter["sv_ver_tgl"], @$filter["so_ver_tgl"], @$filter["sc_ver_tgl"], @$filter["sv2_ver_tgl"], @$filter["so2_ver_tgl"], "ver_tgl");
			$bRestoreFilter = TRUE;
		}
		if (!$bRestoreFilter) { // Clear filter
			$this->SetSessionFilterValues("", "=", "AND", "", "=", "ver_tgl");
		}

		// Field ver_hasil_id
		$bRestoreFilter = FALSE;
		if (array_key_exists("sv_ver_hasil_id", $filter)) {
			$sWrk = $filter["sv_ver_hasil_id"];
			if (strpos($sWrk, "||") !== FALSE)
				$sWrk = explode("||", $sWrk);
			$this->SetSessionDropDownValue($sWrk, @$filter["so_ver_hasil_id"], "ver_hasil_id");
			$bRestoreFilter = TRUE;
		}
		if (!$bRestoreFilter) { // Clear filter
			$this->SetSessionDropDownValue(EWR_INIT_VALUE, "", "ver_hasil_id");
		}

		// Field qc_nama
		$bRestoreFilter = FALSE;
		if (array_key_exists("sv_qc_nama", $filter)) {
			$sWrk = $filter["sv_qc_nama"];
			if (strpos($sWrk, "||") !== FALSE)
				$sWrk = explode("||", $sWrk);
			$this->SetSessionDropDownValue($sWrk, @$filter["so_qc_nama"], "qc_nama");
			$bRestoreFilter = TRUE;
		}
		if (array_key_exists("sel_qc_nama", $filter)) {
			$sWrk = $filter["sel_qc_nama"];
			$sWrk = explode("||", $sWrk);
			$this->qc_nama->SelectionList = $sWrk;
			$_SESSION["sel_Kedatangan_Dan_Verifikasi_qc_nama"] = $sWrk;
			$this->SetSessionDropDownValue(EWR_INIT_VALUE, "", "qc_nama"); // Clear drop down
			$bRestoreFilter = TRUE;
		}
		if (!$bRestoreFilter) { // Clear filter
			$this->SetSessionDropDownValue(EWR_INIT_VALUE, "", "qc_nama");
			$this->qc_nama->SelectionList = "";
			$_SESSION["sel_Kedatangan_Dan_Verifikasi_qc_nama"] = "";
		}
		return TRUE;
	}

	// Return popup filter
	function GetPopupFilter() {
		$sWrk = "";
		if ($this->DrillDown)
			return "";
		if (!$this->DropDownFilterExist($this->qc_nama, $this->qc_nama->SearchOperator)) {
			if (is_array($this->qc_nama->SelectionList)) {
				$sFilter = ewr_FilterSQL($this->qc_nama, "`qc_nama`", EWR_DATATYPE_STRING, $this->DBID);

				// Call Page Filtering event
				$this->Page_Filtering($this->qc_nama, $sFilter, "popup");
				$this->qc_nama->CurrentFilter = $sFilter;
				ewr_AddFilter($sWrk, $sFilter);
			}
		}
		return $sWrk;
	}

	//-------------------------------------------------------------------------------
	// Function GetSort
	// - Return Sort parameters based on Sort Links clicked
	// - Variables setup: Session[EWR_TABLE_SESSION_ORDER_BY], Session["sort_Table_Field"]
	function GetSort($options = array()) {
		if ($this->DrillDown)
			return "`datang_tgl` DESC, `ver_tgl` DESC";
		$bResetSort = @$options["resetsort"] == "1" || @$_GET["cmd"] == "resetsort";
		$orderBy = (@$options["order"] <> "") ? @$options["order"] : ewr_StripSlashes(@$_GET["order"]);
		$orderType = (@$options["ordertype"] <> "") ? @$options["ordertype"] : ewr_StripSlashes(@$_GET["ordertype"]);

		// Check for a resetsort command
		if ($bResetSort) {
			$this->setOrderBy("");
			$this->setStartGroup(1);
			$this->datang_id->setSort("");
			$this->datang_tgl->setSort("");
			$this->datang_jumlah->setSort("");
			$this->ds_nama->setSort("");
			$this->datang_terpakai->setSort("");
			$this->var_nama->setSort("");
			$this->sup_nama->setSort("");
			$this->pet_nama->setSort("");
			$this->co_nama->setSort("");
			$this->k_id_kontrak->setSort("");
			$this->k_luas_lahan->setSort("");
			$this->k_es_tgl_panen->setSort("");
			$this->k_es_qty->setSort("");
			$this->ver_tgl->setSort("");
			$this->ver_presentasi_rijek->setSort("");
			$this->ver_hasil_id->setSort("");
			$this->qc_nama->setSort("");
			$this->ver_catatan->setSort("");

		// Check for an Order parameter
		} elseif ($orderBy <> "") {
			$this->CurrentOrder = $orderBy;
			$this->CurrentOrderType = $orderType;
			$sSortSql = $this->SortSql();
			$this->setOrderBy($sSortSql);
			$this->setStartGroup(1);
		}

		// Set up default sort
		if ($this->getOrderBy() == "") {
			$this->setOrderBy("`datang_tgl` DESC, `ver_tgl` DESC");
			$this->datang_tgl->setSort("DESC");
			$this->ver_tgl->setSort("DESC");
		}
		return $this->getOrderBy();
	}

	// Export to HTML
	function ExportHtml($html, $options = array()) {

		//global $gsExportFile;
		//header('Content-Type: text/html' . (EWR_CHARSET <> '' ? ';charset=' . EWR_CHARSET : ''));
		//header('Content-Disposition: attachment; filename=' . $gsExportFile . '.html');

		$folder = @$this->GenOptions["folder"];
		$fileName = @$this->GenOptions["filename"];
		$responseType = @$options["responsetype"];
		$saveToFile = "";

		// Save generate file for print
		if ($folder <> "" && $fileName <> "" && ($responseType == "json" || $responseType == "file" && EWR_REPORT_SAVE_OUTPUT_ON_SERVER)) {
			$baseTag = "<base href=\"" . ewr_BaseUrl() . "\">";
			$html = preg_replace('/<head>/', '<head>' . $baseTag, $html);
			ewr_SaveFile($folder, $fileName, $html);
			$saveToFile = ewr_UploadPathEx(FALSE, $folder) . $fileName;
		}
		if ($saveToFile == "" || $responseType == "file")
			echo $html;
		return $saveToFile;
	}

	// Export to WORD
	function ExportWord($html, $options = array()) {
		global $gsExportFile;
		$folder = @$options["folder"];
		$fileName = @$options["filename"];
		$responseType = @$options["responsetype"];
		$saveToFile = "";
		if ($folder <> "" && $fileName <> "" && ($responseType == "json" || $responseType == "file" && EWR_REPORT_SAVE_OUTPUT_ON_SERVER)) {
		 	ewr_SaveFile(ewr_PathCombine(ewr_AppRoot(), $folder, TRUE), $fileName, $html);
			$saveToFile = ewr_UploadPathEx(FALSE, $folder) . $fileName;
		}
		if ($saveToFile == "" || $responseType == "file") {
			header('Content-Type: application/vnd.ms-word' . (EWR_CHARSET <> '' ? ';charset=' . EWR_CHARSET : ''));
			header('Content-Disposition: attachment; filename=' . $gsExportFile . '.doc');
			echo $html;
		}
		return $saveToFile;
	}

	// Export to EXCEL
	function ExportExcel($html, $options = array()) {
		global $gsExportFile;
		$folder = @$options["folder"];
		$fileName = @$options["filename"];
		$responseType = @$options["responsetype"];
		$saveToFile = "";
		if ($folder <> "" && $fileName <> "" && ($responseType == "json" || $responseType == "file" && EWR_REPORT_SAVE_OUTPUT_ON_SERVER)) {
		 	ewr_SaveFile(ewr_PathCombine(ewr_AppRoot(), $folder, TRUE), $fileName, $html);
			$saveToFile = ewr_UploadPathEx(FALSE, $folder) . $fileName;
		}
		if ($saveToFile == "" || $responseType == "file") {
			header('Content-Type: application/vnd.ms-excel' . (EWR_CHARSET <> '' ? ';charset=' . EWR_CHARSET : ''));
			header('Content-Disposition: attachment; filename=' . $gsExportFile . '.xls');
			echo $html;
		}
		return $saveToFile;
	}

	// Export PDF
	function ExportPdf($html, $options = array()) {
		global $gsExportFile;
		@ini_set("memory_limit", EWR_PDF_MEMORY_LIMIT);
		set_time_limit(EWR_PDF_TIME_LIMIT);
		if (EWR_DEBUG_ENABLED) // Add debug message
			$html = str_replace("</body>", ewr_DebugMsg() . "</body>", $html);
		$dompdf = new \Dompdf\Dompdf(array("pdf_backend" => "Cpdf"));
		$doc = new DOMDocument();
		@$doc->loadHTML('<?xml encoding="uft-8">' . ewr_ConvertToUtf8($html)); // Convert to utf-8
		$spans = $doc->getElementsByTagName("span");
		foreach ($spans as $span) {
			if ($span->getAttribute("class") == "ewFilterCaption")
				$span->parentNode->insertBefore($doc->createElement("span", ":&nbsp;"), $span->nextSibling);
		}
		$html = $doc->saveHTML();
		$html = ewr_ConvertFromUtf8($html);
		$dompdf->load_html($html);
		$dompdf->set_paper("a4", "portrait");
		$dompdf->render();
		$folder = @$options["folder"];
		$fileName = @$options["filename"];
		$responseType = @$options["responsetype"];
		$saveToFile = "";
		if ($folder <> "" && $fileName <> "" && ($responseType == "json" || $responseType == "file" && EWR_REPORT_SAVE_OUTPUT_ON_SERVER)) {
			ewr_SaveFile(ewr_PathCombine(ewr_AppRoot(), $folder, TRUE), $fileName, $dompdf->output());
			$saveToFile = ewr_UploadPathEx(FALSE, $folder) . $fileName;
		}
		if ($saveToFile == "" || $responseType == "file") {
			$sExportFile = strtolower(substr($gsExportFile, -4)) == ".pdf" ? $gsExportFile : $gsExportFile . ".pdf";
			$dompdf->stream($sExportFile, array("Attachment" => 1)); // 0 to open in browser, 1 to download
		}
		ewr_DeleteTmpImages($html);
		return $saveToFile;
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ewr_Header(FALSE) ?>
<?php

// Create page object
if (!isset($Kedatangan_Dan_Verifikasi_summary)) $Kedatangan_Dan_Verifikasi_summary = new crKedatangan_Dan_Verifikasi_summary();
if (isset($Page)) $OldPage = $Page;
$Page = &$Kedatangan_Dan_Verifikasi_summary;

// Page init
$Page->Page_Init();

// Page main
$Page->Page_Main();

// Global Page Rendering event (in ewrusrfn*.php)
Page_Rendering();

// Page Rendering event
$Page->Page_Render();
?>
<?php include_once "header.php" ?>
<?php include_once "phprptinc/header.php" ?>
<?php if ($Page->Export == "" || $Page->Export == "print" || $Page->Export == "email" && @$gsEmailContentType == "url") { ?>
<script type="text/javascript">

// Create page object
var Kedatangan_Dan_Verifikasi_summary = new ewr_Page("Kedatangan_Dan_Verifikasi_summary");

// Page properties
Kedatangan_Dan_Verifikasi_summary.PageID = "summary"; // Page ID
var EWR_PAGE_ID = Kedatangan_Dan_Verifikasi_summary.PageID;

// Extend page with Chart_Rendering function
Kedatangan_Dan_Verifikasi_summary.Chart_Rendering = 
 function(chart, chartid) { // DO NOT CHANGE THIS LINE!

 	//alert(chartid);
 }

// Extend page with Chart_Rendered function
Kedatangan_Dan_Verifikasi_summary.Chart_Rendered = 
 function(chart, chartid) { // DO NOT CHANGE THIS LINE!

 	//alert(chartid);
 }
</script>
<?php } ?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<script type="text/javascript">

// Form object
var CurrentForm = fKedatangan_Dan_Verifikasisummary = new ewr_Form("fKedatangan_Dan_Verifikasisummary");

// Validate method
fKedatangan_Dan_Verifikasisummary.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);
	var elm = fobj.sv_datang_tgl;
	if (elm && !ewr_CheckDateDef(elm.value)) {
		if (!this.OnError(elm, "<?php echo ewr_JsEncode2($Page->datang_tgl->FldErrMsg()) ?>"))
			return false;
	}
	var elm = fobj.sv_k_es_tgl_panen;
	if (elm && !ewr_CheckDateDef(elm.value)) {
		if (!this.OnError(elm, "<?php echo ewr_JsEncode2($Page->k_es_tgl_panen->FldErrMsg()) ?>"))
			return false;
	}
	var elm = fobj.sv_ver_tgl;
	if (elm && !ewr_CheckDateDef(elm.value)) {
		if (!this.OnError(elm, "<?php echo ewr_JsEncode2($Page->ver_tgl->FldErrMsg()) ?>"))
			return false;
	}

	// Call Form Custom Validate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate method
fKedatangan_Dan_Verifikasisummary.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }
<?php if (EWR_CLIENT_VALIDATE) { ?>
fKedatangan_Dan_Verifikasisummary.ValidateRequired = true; // Uses JavaScript validation
<?php } else { ?>
fKedatangan_Dan_Verifikasisummary.ValidateRequired = false; // No JavaScript validation
<?php } ?>

// Use Ajax
fKedatangan_Dan_Verifikasisummary.Lists["sv_ds_nama"] = {"LinkField":"sv_ds_nama","Ajax":true,"DisplayFields":["sv_ds_nama","","",""],"ParentFields":[],"FilterFields":[],"Options":[],"Template":""};
fKedatangan_Dan_Verifikasisummary.Lists["sv_var_nama"] = {"LinkField":"sv_var_nama","Ajax":true,"DisplayFields":["sv_var_nama","","",""],"ParentFields":[],"FilterFields":[],"Options":[],"Template":""};
fKedatangan_Dan_Verifikasisummary.Lists["sv_sup_nama"] = {"LinkField":"sv_sup_nama","Ajax":true,"DisplayFields":["sv_sup_nama","","",""],"ParentFields":[],"FilterFields":[],"Options":[],"Template":""};
fKedatangan_Dan_Verifikasisummary.Lists["sv_pet_nama"] = {"LinkField":"sv_pet_nama","Ajax":true,"DisplayFields":["sv_pet_nama","","",""],"ParentFields":[],"FilterFields":[],"Options":[],"Template":""};
fKedatangan_Dan_Verifikasisummary.Lists["sv_co_nama"] = {"LinkField":"sv_co_nama","Ajax":true,"DisplayFields":["sv_co_nama","","",""],"ParentFields":[],"FilterFields":[],"Options":[],"Template":""};
fKedatangan_Dan_Verifikasisummary.Lists["sv_k_id_kontrak"] = {"LinkField":"sv_k_id_kontrak","Ajax":true,"DisplayFields":["sv_k_id_kontrak","","",""],"ParentFields":[],"FilterFields":[],"Options":[],"Template":""};
fKedatangan_Dan_Verifikasisummary.Lists["sv_ver_hasil_id"] = {"LinkField":"sv_ver_hasil_id","Ajax":true,"DisplayFields":["sv_ver_hasil_id","","",""],"ParentFields":[],"FilterFields":[],"Options":[],"Template":""};
fKedatangan_Dan_Verifikasisummary.Lists["sv_qc_nama"] = {"LinkField":"sv_qc_nama","Ajax":true,"DisplayFields":["sv_qc_nama","","",""],"ParentFields":[],"FilterFields":[],"Options":[],"Template":""};
</script>
<?php } ?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if ($Page->Export == "") { ?>
<!-- container (begin) -->
<div id="ewContainer" class="ewContainer">
<!-- top container (begin) -->
<div id="ewTop" class="ewTop">
<a id="top"></a>
<?php } ?>
<?php if (@$Page->GenOptions["showfilter"] == "1") { ?>
<?php $Page->ShowFilterList(TRUE) ?>
<?php } ?>
<!-- top slot -->
<div class="ewToolbar">
<?php
if (!$Page->DrillDownInPanel) {
	$Page->ExportOptions->Render("body");
	$Page->SearchOptions->Render("body");
	$Page->FilterOptions->Render("body");
	$Page->GenerateOptions->Render("body");
}
?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<?php echo $ReportLanguage->SelectionForm(); ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php $Page->ShowPageHeader(); ?>
<?php $Page->ShowMessage(); ?>
<?php if ($Page->Export == "") { ?>
</div>
<!-- top container (end) -->
	<!-- left container (begin) -->
	<div id="ewLeft" class="ewLeft">
<?php } ?>
	<!-- Left slot -->
<?php if ($Page->Export == "") { ?>
	</div>
	<!-- left container (end) -->
	<!-- center container - report (begin) -->
	<div id="ewCenter" class="ewCenter">
<?php } ?>
	<!-- center slot -->
<!-- summary report starts -->
<?php if ($Page->Export <> "pdf") { ?>
<div id="report_summary">
<?php } ?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<!-- Search form (begin) -->
<form name="fKedatangan_Dan_Verifikasisummary" id="fKedatangan_Dan_Verifikasisummary" class="form-inline ewForm ewExtFilterForm" action="<?php echo ewr_CurrentPage() ?>">
<?php $SearchPanelClass = ($Page->Filter <> "") ? " in" : " in"; ?>
<div id="fKedatangan_Dan_Verifikasisummary_SearchPanel" class="ewSearchPanel collapse<?php echo $SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<div id="r_1" class="ewRow">
<div id="c_datang_tgl" class="ewCell form-group">
	<label for="sv_datang_tgl" class="ewSearchCaption ewLabel"><?php echo $Page->datang_tgl->FldCaption() ?></label>
	<span class="ewSearchOperator"><?php echo $ReportLanguage->Phrase("="); ?><input type="hidden" name="so_datang_tgl" id="so_datang_tgl" value="="></span>
	<span class="control-group ewSearchField">
<?php ewr_PrependClass($Page->datang_tgl->EditAttrs["class"], "form-control"); // PR8 ?>
<input type="text" data-table="Kedatangan_Dan_Verifikasi" data-field="x_datang_tgl" id="sv_datang_tgl" name="sv_datang_tgl" placeholder="<?php echo $Page->datang_tgl->PlaceHolder ?>" value="<?php echo ewr_HtmlEncode($Page->datang_tgl->SearchValue) ?>" data-calendar="true" data-formatid="0"<?php echo $Page->datang_tgl->EditAttributes() ?>>
</span>
</div>
</div>
<div id="r_2" class="ewRow">
<div id="c_ds_nama" class="ewCell form-group">
	<label for="sv_ds_nama" class="ewSearchCaption ewLabel"><?php echo $Page->ds_nama->FldCaption() ?></label>
	<span class="ewSearchField">
<span class="ewLookupList">
	<span onclick="jQuery(this).parent().next().click();" tabindex="-1" class="form-control ewLookupText" id="lu_sv_ds_nama"><?php echo (strval(ewr_FilterDropDownValue($Page->ds_nama)) == "" ? $ReportLanguage->Phrase("PleaseSelect") : ewr_FilterDropDownValue($Page->ds_nama)); ?></span>
</span>
<button type="button" title="<?php echo ewr_HtmlEncode(str_replace("%s", ewr_RemoveHtml($Page->ds_nama->FldCaption()), $ReportLanguage->Phrase("LookupLink", TRUE))) ?>" onclick="ewr_ModalLookupShow({lnk:this,el:'sv_ds_nama',m:0,n:10});" class="ewLookupBtn btn btn-default btn-sm"><span class="glyphicon glyphicon-search ewIcon"></span></button>
<input type="hidden" data-table="Kedatangan_Dan_Verifikasi" data-field="x_ds_nama" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $Page->ds_nama->DisplayValueSeparatorAttribute() ?>" name="sv_ds_nama" id="sv_ds_nama" value="<?php echo ewr_FilterDropDownValue($Page->ds_nama, ",") ?>"<?php echo $Page->ds_nama->EditAttributes() ?>>
<input type="hidden" name="s_sv_ds_nama" id="s_sv_ds_nama" value="<?php echo $Page->ds_nama->LookupFilterQuery() ?>"></span>
</div>
</div>
<div id="r_3" class="ewRow">
<div id="c_var_nama" class="ewCell form-group">
	<label for="sv_var_nama" class="ewSearchCaption ewLabel"><?php echo $Page->var_nama->FldCaption() ?></label>
	<span class="ewSearchField">
<span class="ewLookupList">
	<span onclick="jQuery(this).parent().next().click();" tabindex="-1" class="form-control ewLookupText" id="lu_sv_var_nama"><?php echo (strval(ewr_FilterDropDownValue($Page->var_nama)) == "" ? $ReportLanguage->Phrase("PleaseSelect") : ewr_FilterDropDownValue($Page->var_nama)); ?></span>
</span>
<button type="button" title="<?php echo ewr_HtmlEncode(str_replace("%s", ewr_RemoveHtml($Page->var_nama->FldCaption()), $ReportLanguage->Phrase("LookupLink", TRUE))) ?>" onclick="ewr_ModalLookupShow({lnk:this,el:'sv_var_nama',m:0,n:10});" class="ewLookupBtn btn btn-default btn-sm"><span class="glyphicon glyphicon-search ewIcon"></span></button>
<input type="hidden" data-table="Kedatangan_Dan_Verifikasi" data-field="x_var_nama" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $Page->var_nama->DisplayValueSeparatorAttribute() ?>" name="sv_var_nama" id="sv_var_nama" value="<?php echo ewr_FilterDropDownValue($Page->var_nama, ",") ?>"<?php echo $Page->var_nama->EditAttributes() ?>>
<input type="hidden" name="s_sv_var_nama" id="s_sv_var_nama" value="<?php echo $Page->var_nama->LookupFilterQuery() ?>"></span>
</div>
</div>
<div id="r_4" class="ewRow">
<div id="c_sup_nama" class="ewCell form-group">
	<label for="sv_sup_nama" class="ewSearchCaption ewLabel"><?php echo $Page->sup_nama->FldCaption() ?></label>
	<span class="ewSearchField">
<span class="ewLookupList">
	<span onclick="jQuery(this).parent().next().click();" tabindex="-1" class="form-control ewLookupText" id="lu_sv_sup_nama"><?php echo (strval(ewr_FilterDropDownValue($Page->sup_nama)) == "" ? $ReportLanguage->Phrase("PleaseSelect") : ewr_FilterDropDownValue($Page->sup_nama)); ?></span>
</span>
<button type="button" title="<?php echo ewr_HtmlEncode(str_replace("%s", ewr_RemoveHtml($Page->sup_nama->FldCaption()), $ReportLanguage->Phrase("LookupLink", TRUE))) ?>" onclick="ewr_ModalLookupShow({lnk:this,el:'sv_sup_nama',m:0,n:10});" class="ewLookupBtn btn btn-default btn-sm"><span class="glyphicon glyphicon-search ewIcon"></span></button>
<input type="hidden" data-table="Kedatangan_Dan_Verifikasi" data-field="x_sup_nama" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $Page->sup_nama->DisplayValueSeparatorAttribute() ?>" name="sv_sup_nama" id="sv_sup_nama" value="<?php echo ewr_FilterDropDownValue($Page->sup_nama, ",") ?>"<?php echo $Page->sup_nama->EditAttributes() ?>>
<input type="hidden" name="s_sv_sup_nama" id="s_sv_sup_nama" value="<?php echo $Page->sup_nama->LookupFilterQuery() ?>"></span>
</div>
</div>
<div id="r_5" class="ewRow">
<div id="c_pet_nama" class="ewCell form-group">
	<label for="sv_pet_nama" class="ewSearchCaption ewLabel"><?php echo $Page->pet_nama->FldCaption() ?></label>
	<span class="ewSearchField">
<span class="ewLookupList">
	<span onclick="jQuery(this).parent().next().click();" tabindex="-1" class="form-control ewLookupText" id="lu_sv_pet_nama"><?php echo (strval(ewr_FilterDropDownValue($Page->pet_nama)) == "" ? $ReportLanguage->Phrase("PleaseSelect") : ewr_FilterDropDownValue($Page->pet_nama)); ?></span>
</span>
<button type="button" title="<?php echo ewr_HtmlEncode(str_replace("%s", ewr_RemoveHtml($Page->pet_nama->FldCaption()), $ReportLanguage->Phrase("LookupLink", TRUE))) ?>" onclick="ewr_ModalLookupShow({lnk:this,el:'sv_pet_nama',m:0,n:10});" class="ewLookupBtn btn btn-default btn-sm"><span class="glyphicon glyphicon-search ewIcon"></span></button>
<input type="hidden" data-table="Kedatangan_Dan_Verifikasi" data-field="x_pet_nama" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $Page->pet_nama->DisplayValueSeparatorAttribute() ?>" name="sv_pet_nama" id="sv_pet_nama" value="<?php echo ewr_FilterDropDownValue($Page->pet_nama, ",") ?>"<?php echo $Page->pet_nama->EditAttributes() ?>>
<input type="hidden" name="s_sv_pet_nama" id="s_sv_pet_nama" value="<?php echo $Page->pet_nama->LookupFilterQuery() ?>"></span>
</div>
</div>
<div id="r_6" class="ewRow">
<div id="c_co_nama" class="ewCell form-group">
	<label for="sv_co_nama" class="ewSearchCaption ewLabel"><?php echo $Page->co_nama->FldCaption() ?></label>
	<span class="ewSearchField">
<span class="ewLookupList">
	<span onclick="jQuery(this).parent().next().click();" tabindex="-1" class="form-control ewLookupText" id="lu_sv_co_nama"><?php echo (strval(ewr_FilterDropDownValue($Page->co_nama)) == "" ? $ReportLanguage->Phrase("PleaseSelect") : ewr_FilterDropDownValue($Page->co_nama)); ?></span>
</span>
<button type="button" title="<?php echo ewr_HtmlEncode(str_replace("%s", ewr_RemoveHtml($Page->co_nama->FldCaption()), $ReportLanguage->Phrase("LookupLink", TRUE))) ?>" onclick="ewr_ModalLookupShow({lnk:this,el:'sv_co_nama',m:0,n:10});" class="ewLookupBtn btn btn-default btn-sm"><span class="glyphicon glyphicon-search ewIcon"></span></button>
<input type="hidden" data-table="Kedatangan_Dan_Verifikasi" data-field="x_co_nama" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $Page->co_nama->DisplayValueSeparatorAttribute() ?>" name="sv_co_nama" id="sv_co_nama" value="<?php echo ewr_FilterDropDownValue($Page->co_nama, ",") ?>"<?php echo $Page->co_nama->EditAttributes() ?>>
<input type="hidden" name="s_sv_co_nama" id="s_sv_co_nama" value="<?php echo $Page->co_nama->LookupFilterQuery() ?>"></span>
</div>
</div>
<div id="r_7" class="ewRow">
<div id="c_k_id_kontrak" class="ewCell form-group">
	<label for="sv_k_id_kontrak" class="ewSearchCaption ewLabel"><?php echo $Page->k_id_kontrak->FldCaption() ?></label>
	<span class="ewSearchField">
<span class="ewLookupList">
	<span onclick="jQuery(this).parent().next().click();" tabindex="-1" class="form-control ewLookupText" id="lu_sv_k_id_kontrak"><?php echo (strval(ewr_FilterDropDownValue($Page->k_id_kontrak)) == "" ? $ReportLanguage->Phrase("PleaseSelect") : ewr_FilterDropDownValue($Page->k_id_kontrak)); ?></span>
</span>
<button type="button" title="<?php echo ewr_HtmlEncode(str_replace("%s", ewr_RemoveHtml($Page->k_id_kontrak->FldCaption()), $ReportLanguage->Phrase("LookupLink", TRUE))) ?>" onclick="ewr_ModalLookupShow({lnk:this,el:'sv_k_id_kontrak',m:0,n:10});" class="ewLookupBtn btn btn-default btn-sm"><span class="glyphicon glyphicon-search ewIcon"></span></button>
<input type="hidden" data-table="Kedatangan_Dan_Verifikasi" data-field="x_k_id_kontrak" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $Page->k_id_kontrak->DisplayValueSeparatorAttribute() ?>" name="sv_k_id_kontrak" id="sv_k_id_kontrak" value="<?php echo ewr_FilterDropDownValue($Page->k_id_kontrak, ",") ?>"<?php echo $Page->k_id_kontrak->EditAttributes() ?>>
<input type="hidden" name="s_sv_k_id_kontrak" id="s_sv_k_id_kontrak" value="<?php echo $Page->k_id_kontrak->LookupFilterQuery() ?>"></span>
</div>
</div>
<div id="r_8" class="ewRow">
<div id="c_k_es_tgl_panen" class="ewCell form-group">
	<label for="sv_k_es_tgl_panen" class="ewSearchCaption ewLabel"><?php echo $Page->k_es_tgl_panen->FldCaption() ?></label>
	<span class="ewSearchOperator"><?php echo $ReportLanguage->Phrase("="); ?><input type="hidden" name="so_k_es_tgl_panen" id="so_k_es_tgl_panen" value="="></span>
	<span class="control-group ewSearchField">
<?php ewr_PrependClass($Page->k_es_tgl_panen->EditAttrs["class"], "form-control"); // PR8 ?>
<input type="text" data-table="Kedatangan_Dan_Verifikasi" data-field="x_k_es_tgl_panen" id="sv_k_es_tgl_panen" name="sv_k_es_tgl_panen" placeholder="<?php echo $Page->k_es_tgl_panen->PlaceHolder ?>" value="<?php echo ewr_HtmlEncode($Page->k_es_tgl_panen->SearchValue) ?>" data-calendar="true" data-formatid="0"<?php echo $Page->k_es_tgl_panen->EditAttributes() ?>>
</span>
</div>
</div>
<div id="r_9" class="ewRow">
<div id="c_ver_tgl" class="ewCell form-group">
	<label for="sv_ver_tgl" class="ewSearchCaption ewLabel"><?php echo $Page->ver_tgl->FldCaption() ?></label>
	<span class="ewSearchOperator"><?php echo $ReportLanguage->Phrase("="); ?><input type="hidden" name="so_ver_tgl" id="so_ver_tgl" value="="></span>
	<span class="control-group ewSearchField">
<?php ewr_PrependClass($Page->ver_tgl->EditAttrs["class"], "form-control"); // PR8 ?>
<input type="text" data-table="Kedatangan_Dan_Verifikasi" data-field="x_ver_tgl" id="sv_ver_tgl" name="sv_ver_tgl" placeholder="<?php echo $Page->ver_tgl->PlaceHolder ?>" value="<?php echo ewr_HtmlEncode($Page->ver_tgl->SearchValue) ?>" data-calendar="true" data-formatid="0"<?php echo $Page->ver_tgl->EditAttributes() ?>>
</span>
</div>
</div>
<div id="r_10" class="ewRow">
<div id="c_ver_hasil_id" class="ewCell form-group">
	<label for="sv_ver_hasil_id" class="ewSearchCaption ewLabel"><?php echo $Page->ver_hasil_id->FldCaption() ?></label>
	<span class="ewSearchField">
<span class="ewLookupList">
	<span onclick="jQuery(this).parent().next().click();" tabindex="-1" class="form-control ewLookupText" id="lu_sv_ver_hasil_id"><?php echo (strval(ewr_FilterDropDownValue($Page->ver_hasil_id)) == "" ? $ReportLanguage->Phrase("PleaseSelect") : ewr_FilterDropDownValue($Page->ver_hasil_id)); ?></span>
</span>
<button type="button" title="<?php echo ewr_HtmlEncode(str_replace("%s", ewr_RemoveHtml($Page->ver_hasil_id->FldCaption()), $ReportLanguage->Phrase("LookupLink", TRUE))) ?>" onclick="ewr_ModalLookupShow({lnk:this,el:'sv_ver_hasil_id',m:0,n:10});" class="ewLookupBtn btn btn-default btn-sm"><span class="glyphicon glyphicon-search ewIcon"></span></button>
<input type="hidden" data-table="Kedatangan_Dan_Verifikasi" data-field="x_ver_hasil_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $Page->ver_hasil_id->DisplayValueSeparatorAttribute() ?>" name="sv_ver_hasil_id" id="sv_ver_hasil_id" value="<?php echo ewr_FilterDropDownValue($Page->ver_hasil_id, ",") ?>"<?php echo $Page->ver_hasil_id->EditAttributes() ?>>
<input type="hidden" name="s_sv_ver_hasil_id" id="s_sv_ver_hasil_id" value="<?php echo $Page->ver_hasil_id->LookupFilterQuery() ?>"></span>
</div>
</div>
<div id="r_11" class="ewRow">
<div id="c_qc_nama" class="ewCell form-group">
	<label for="sv_qc_nama" class="ewSearchCaption ewLabel"><?php echo $Page->qc_nama->FldCaption() ?></label>
	<span class="ewSearchField">
<span class="ewLookupList">
	<span onclick="jQuery(this).parent().next().click();" tabindex="-1" class="form-control ewLookupText" id="lu_sv_qc_nama"><?php echo (strval(ewr_FilterDropDownValue($Page->qc_nama)) == "" ? $ReportLanguage->Phrase("PleaseSelect") : ewr_FilterDropDownValue($Page->qc_nama)); ?></span>
</span>
<button type="button" title="<?php echo ewr_HtmlEncode(str_replace("%s", ewr_RemoveHtml($Page->qc_nama->FldCaption()), $ReportLanguage->Phrase("LookupLink", TRUE))) ?>" onclick="ewr_ModalLookupShow({lnk:this,el:'sv_qc_nama',m:0,n:10});" class="ewLookupBtn btn btn-default btn-sm"><span class="glyphicon glyphicon-search ewIcon"></span></button>
<input type="hidden" data-table="Kedatangan_Dan_Verifikasi" data-field="x_qc_nama" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $Page->qc_nama->DisplayValueSeparatorAttribute() ?>" name="sv_qc_nama" id="sv_qc_nama" value="<?php echo ewr_FilterDropDownValue($Page->qc_nama, ",") ?>"<?php echo $Page->qc_nama->EditAttributes() ?>>
<input type="hidden" name="s_sv_qc_nama" id="s_sv_qc_nama" value="<?php echo $Page->qc_nama->LookupFilterQuery() ?>"></span>
</div>
</div>
<div class="ewRow"><input type="submit" name="btnsubmit" id="btnsubmit" class="btn btn-primary" value="<?php echo $ReportLanguage->Phrase("Search") ?>">
<input type="reset" name="btnreset" id="btnreset" class="btn hide" value="<?php echo $ReportLanguage->Phrase("Reset") ?>"></div>
</div>
</form>
<script type="text/javascript">
fKedatangan_Dan_Verifikasisummary.Init();
fKedatangan_Dan_Verifikasisummary.FilterList = <?php echo $Page->GetFilterList() ?>;
</script>
<!-- Search form (end) -->
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->ShowFilterList() ?>
<?php } ?>
<?php

// Set the last group to display if not export all
if ($Page->ExportAll && $Page->Export <> "") {
	$Page->StopGrp = $Page->TotalGrps;
} else {
	$Page->StopGrp = $Page->StartGrp + $Page->DisplayGrps - 1;
}

// Stop group <= total number of groups
if (intval($Page->StopGrp) > intval($Page->TotalGrps))
	$Page->StopGrp = $Page->TotalGrps;
$Page->RecCount = 0;
$Page->RecIndex = 0;

// Get first row
if ($Page->TotalGrps > 0) {
	$Page->GetRow(1);
	$Page->GrpCount = 1;
}
$Page->GrpIdx = ewr_InitArray(2, -1);
$Page->GrpIdx[0] = -1;
$Page->GrpIdx[1] = $Page->StopGrp - $Page->StartGrp + 1;
while ($rs && !$rs->EOF && $Page->GrpCount <= $Page->DisplayGrps || $Page->ShowHeader) {

	// Show dummy header for custom template
	// Show header

	if ($Page->ShowHeader) {
?>
<?php if ($Page->Export <> "pdf") { ?>
<?php if ($Page->Export == "word" || $Page->Export == "excel") { ?>
<div class="ewGrid"<?php echo $Page->ReportTableStyle ?>>
<?php } else { ?>
<div class="panel panel-default ewGrid"<?php echo $Page->ReportTableStyle ?>>
<?php } ?>
<?php } ?>
<!-- Report grid (begin) -->
<?php if ($Page->Export <> "pdf") { ?>
<div class="<?php if (ewr_IsResponsiveLayout()) { echo "table-responsive "; } ?>ewGridMiddlePanel">
<?php } ?>
<table class="<?php echo $Page->ReportTableClass ?>">
<thead>
	<!-- Table header -->
	<tr class="ewTableHeader">
<?php if ($Page->datang_id->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="datang_id"><div class="Kedatangan_Dan_Verifikasi_datang_id"><span class="ewTableHeaderCaption"><?php echo $Page->datang_id->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="datang_id">
<?php if ($Page->SortUrl($Page->datang_id) == "") { ?>
		<div class="ewTableHeaderBtn Kedatangan_Dan_Verifikasi_datang_id">
			<span class="ewTableHeaderCaption"><?php echo $Page->datang_id->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Kedatangan_Dan_Verifikasi_datang_id" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->datang_id) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->datang_id->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->datang_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->datang_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->datang_tgl->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="datang_tgl"><div class="Kedatangan_Dan_Verifikasi_datang_tgl"><span class="ewTableHeaderCaption"><?php echo $Page->datang_tgl->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="datang_tgl">
<?php if ($Page->SortUrl($Page->datang_tgl) == "") { ?>
		<div class="ewTableHeaderBtn Kedatangan_Dan_Verifikasi_datang_tgl">
			<span class="ewTableHeaderCaption"><?php echo $Page->datang_tgl->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Kedatangan_Dan_Verifikasi_datang_tgl" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->datang_tgl) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->datang_tgl->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->datang_tgl->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->datang_tgl->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->datang_jumlah->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="datang_jumlah"><div class="Kedatangan_Dan_Verifikasi_datang_jumlah"><span class="ewTableHeaderCaption"><?php echo $Page->datang_jumlah->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="datang_jumlah">
<?php if ($Page->SortUrl($Page->datang_jumlah) == "") { ?>
		<div class="ewTableHeaderBtn Kedatangan_Dan_Verifikasi_datang_jumlah">
			<span class="ewTableHeaderCaption"><?php echo $Page->datang_jumlah->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Kedatangan_Dan_Verifikasi_datang_jumlah" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->datang_jumlah) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->datang_jumlah->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->datang_jumlah->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->datang_jumlah->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->ds_nama->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="ds_nama"><div class="Kedatangan_Dan_Verifikasi_ds_nama"><span class="ewTableHeaderCaption"><?php echo $Page->ds_nama->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="ds_nama">
<?php if ($Page->SortUrl($Page->ds_nama) == "") { ?>
		<div class="ewTableHeaderBtn Kedatangan_Dan_Verifikasi_ds_nama">
			<span class="ewTableHeaderCaption"><?php echo $Page->ds_nama->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Kedatangan_Dan_Verifikasi_ds_nama" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->ds_nama) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->ds_nama->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->ds_nama->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->ds_nama->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->datang_terpakai->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="datang_terpakai"><div class="Kedatangan_Dan_Verifikasi_datang_terpakai"><span class="ewTableHeaderCaption"><?php echo $Page->datang_terpakai->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="datang_terpakai">
<?php if ($Page->SortUrl($Page->datang_terpakai) == "") { ?>
		<div class="ewTableHeaderBtn Kedatangan_Dan_Verifikasi_datang_terpakai">
			<span class="ewTableHeaderCaption"><?php echo $Page->datang_terpakai->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Kedatangan_Dan_Verifikasi_datang_terpakai" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->datang_terpakai) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->datang_terpakai->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->datang_terpakai->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->datang_terpakai->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->var_nama->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="var_nama"><div class="Kedatangan_Dan_Verifikasi_var_nama"><span class="ewTableHeaderCaption"><?php echo $Page->var_nama->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="var_nama">
<?php if ($Page->SortUrl($Page->var_nama) == "") { ?>
		<div class="ewTableHeaderBtn Kedatangan_Dan_Verifikasi_var_nama">
			<span class="ewTableHeaderCaption"><?php echo $Page->var_nama->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Kedatangan_Dan_Verifikasi_var_nama" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->var_nama) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->var_nama->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->var_nama->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->var_nama->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->sup_nama->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="sup_nama"><div class="Kedatangan_Dan_Verifikasi_sup_nama"><span class="ewTableHeaderCaption"><?php echo $Page->sup_nama->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="sup_nama">
<?php if ($Page->SortUrl($Page->sup_nama) == "") { ?>
		<div class="ewTableHeaderBtn Kedatangan_Dan_Verifikasi_sup_nama">
			<span class="ewTableHeaderCaption"><?php echo $Page->sup_nama->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Kedatangan_Dan_Verifikasi_sup_nama" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->sup_nama) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->sup_nama->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->sup_nama->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->sup_nama->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->pet_nama->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="pet_nama"><div class="Kedatangan_Dan_Verifikasi_pet_nama"><span class="ewTableHeaderCaption"><?php echo $Page->pet_nama->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="pet_nama">
<?php if ($Page->SortUrl($Page->pet_nama) == "") { ?>
		<div class="ewTableHeaderBtn Kedatangan_Dan_Verifikasi_pet_nama">
			<span class="ewTableHeaderCaption"><?php echo $Page->pet_nama->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Kedatangan_Dan_Verifikasi_pet_nama" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->pet_nama) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->pet_nama->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->pet_nama->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->pet_nama->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->co_nama->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="co_nama"><div class="Kedatangan_Dan_Verifikasi_co_nama"><span class="ewTableHeaderCaption"><?php echo $Page->co_nama->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="co_nama">
<?php if ($Page->SortUrl($Page->co_nama) == "") { ?>
		<div class="ewTableHeaderBtn Kedatangan_Dan_Verifikasi_co_nama">
			<span class="ewTableHeaderCaption"><?php echo $Page->co_nama->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Kedatangan_Dan_Verifikasi_co_nama" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->co_nama) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->co_nama->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->co_nama->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->co_nama->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->k_id_kontrak->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="k_id_kontrak"><div class="Kedatangan_Dan_Verifikasi_k_id_kontrak"><span class="ewTableHeaderCaption"><?php echo $Page->k_id_kontrak->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="k_id_kontrak">
<?php if ($Page->SortUrl($Page->k_id_kontrak) == "") { ?>
		<div class="ewTableHeaderBtn Kedatangan_Dan_Verifikasi_k_id_kontrak">
			<span class="ewTableHeaderCaption"><?php echo $Page->k_id_kontrak->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Kedatangan_Dan_Verifikasi_k_id_kontrak" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->k_id_kontrak) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->k_id_kontrak->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->k_id_kontrak->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->k_id_kontrak->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->k_luas_lahan->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="k_luas_lahan"><div class="Kedatangan_Dan_Verifikasi_k_luas_lahan"><span class="ewTableHeaderCaption"><?php echo $Page->k_luas_lahan->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="k_luas_lahan">
<?php if ($Page->SortUrl($Page->k_luas_lahan) == "") { ?>
		<div class="ewTableHeaderBtn Kedatangan_Dan_Verifikasi_k_luas_lahan">
			<span class="ewTableHeaderCaption"><?php echo $Page->k_luas_lahan->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Kedatangan_Dan_Verifikasi_k_luas_lahan" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->k_luas_lahan) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->k_luas_lahan->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->k_luas_lahan->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->k_luas_lahan->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->k_es_tgl_panen->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="k_es_tgl_panen"><div class="Kedatangan_Dan_Verifikasi_k_es_tgl_panen"><span class="ewTableHeaderCaption"><?php echo $Page->k_es_tgl_panen->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="k_es_tgl_panen">
<?php if ($Page->SortUrl($Page->k_es_tgl_panen) == "") { ?>
		<div class="ewTableHeaderBtn Kedatangan_Dan_Verifikasi_k_es_tgl_panen">
			<span class="ewTableHeaderCaption"><?php echo $Page->k_es_tgl_panen->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Kedatangan_Dan_Verifikasi_k_es_tgl_panen" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->k_es_tgl_panen) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->k_es_tgl_panen->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->k_es_tgl_panen->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->k_es_tgl_panen->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->k_es_qty->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="k_es_qty"><div class="Kedatangan_Dan_Verifikasi_k_es_qty"><span class="ewTableHeaderCaption"><?php echo $Page->k_es_qty->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="k_es_qty">
<?php if ($Page->SortUrl($Page->k_es_qty) == "") { ?>
		<div class="ewTableHeaderBtn Kedatangan_Dan_Verifikasi_k_es_qty">
			<span class="ewTableHeaderCaption"><?php echo $Page->k_es_qty->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Kedatangan_Dan_Verifikasi_k_es_qty" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->k_es_qty) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->k_es_qty->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->k_es_qty->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->k_es_qty->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->ver_tgl->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="ver_tgl"><div class="Kedatangan_Dan_Verifikasi_ver_tgl"><span class="ewTableHeaderCaption"><?php echo $Page->ver_tgl->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="ver_tgl">
<?php if ($Page->SortUrl($Page->ver_tgl) == "") { ?>
		<div class="ewTableHeaderBtn Kedatangan_Dan_Verifikasi_ver_tgl">
			<span class="ewTableHeaderCaption"><?php echo $Page->ver_tgl->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Kedatangan_Dan_Verifikasi_ver_tgl" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->ver_tgl) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->ver_tgl->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->ver_tgl->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->ver_tgl->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->ver_presentasi_rijek->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="ver_presentasi_rijek"><div class="Kedatangan_Dan_Verifikasi_ver_presentasi_rijek"><span class="ewTableHeaderCaption"><?php echo $Page->ver_presentasi_rijek->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="ver_presentasi_rijek">
<?php if ($Page->SortUrl($Page->ver_presentasi_rijek) == "") { ?>
		<div class="ewTableHeaderBtn Kedatangan_Dan_Verifikasi_ver_presentasi_rijek">
			<span class="ewTableHeaderCaption"><?php echo $Page->ver_presentasi_rijek->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Kedatangan_Dan_Verifikasi_ver_presentasi_rijek" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->ver_presentasi_rijek) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->ver_presentasi_rijek->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->ver_presentasi_rijek->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->ver_presentasi_rijek->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->ver_hasil_id->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="ver_hasil_id"><div class="Kedatangan_Dan_Verifikasi_ver_hasil_id"><span class="ewTableHeaderCaption"><?php echo $Page->ver_hasil_id->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="ver_hasil_id">
<?php if ($Page->SortUrl($Page->ver_hasil_id) == "") { ?>
		<div class="ewTableHeaderBtn Kedatangan_Dan_Verifikasi_ver_hasil_id">
			<span class="ewTableHeaderCaption"><?php echo $Page->ver_hasil_id->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Kedatangan_Dan_Verifikasi_ver_hasil_id" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->ver_hasil_id) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->ver_hasil_id->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->ver_hasil_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->ver_hasil_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->qc_nama->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="qc_nama"><div class="Kedatangan_Dan_Verifikasi_qc_nama"><span class="ewTableHeaderCaption"><?php echo $Page->qc_nama->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="qc_nama">
<?php if ($Page->SortUrl($Page->qc_nama) == "") { ?>
		<div class="ewTableHeaderBtn Kedatangan_Dan_Verifikasi_qc_nama">
			<span class="ewTableHeaderCaption"><?php echo $Page->qc_nama->FldCaption() ?></span>
			<a class="ewTableHeaderPopup" title="<?php echo $ReportLanguage->Phrase("Filter"); ?>" onclick="ewr_ShowPopup.call(this, event, 'Kedatangan_Dan_Verifikasi_qc_nama', false, '<?php echo $Page->qc_nama->RangeFrom; ?>', '<?php echo $Page->qc_nama->RangeTo; ?>');" id="x_qc_nama<?php echo $Page->Cnt[0][0]; ?>"><span class="icon-filter"></span></a>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Kedatangan_Dan_Verifikasi_qc_nama" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->qc_nama) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->qc_nama->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->qc_nama->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->qc_nama->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
			<a class="ewTableHeaderPopup" title="<?php echo $ReportLanguage->Phrase("Filter"); ?>" onclick="ewr_ShowPopup.call(this, event, 'Kedatangan_Dan_Verifikasi_qc_nama', false, '<?php echo $Page->qc_nama->RangeFrom; ?>', '<?php echo $Page->qc_nama->RangeTo; ?>');" id="x_qc_nama<?php echo $Page->Cnt[0][0]; ?>"><span class="icon-filter"></span></a>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->ver_catatan->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="ver_catatan"><div class="Kedatangan_Dan_Verifikasi_ver_catatan"><span class="ewTableHeaderCaption"><?php echo $Page->ver_catatan->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="ver_catatan">
<?php if ($Page->SortUrl($Page->ver_catatan) == "") { ?>
		<div class="ewTableHeaderBtn Kedatangan_Dan_Verifikasi_ver_catatan">
			<span class="ewTableHeaderCaption"><?php echo $Page->ver_catatan->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Kedatangan_Dan_Verifikasi_ver_catatan" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->ver_catatan) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->ver_catatan->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->ver_catatan->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->ver_catatan->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
	</tr>
</thead>
<tbody>
<?php
		if ($Page->TotalGrps == 0) break; // Show header only
		$Page->ShowHeader = FALSE;
	}
	$Page->RecCount++;
	$Page->RecIndex++;
?>
<?php

		// Render detail row
		$Page->ResetAttrs();
		$Page->RowType = EWR_ROWTYPE_DETAIL;
		$Page->RenderRow();
?>
	<tr<?php echo $Page->RowAttributes(); ?>>
<?php if ($Page->datang_id->Visible) { ?>
		<td data-field="datang_id"<?php echo $Page->datang_id->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->GrpCount ?>_<?php echo $Page->RecCount ?>_Kedatangan_Dan_Verifikasi_datang_id"<?php echo $Page->datang_id->ViewAttributes() ?>><?php echo $Page->datang_id->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->datang_tgl->Visible) { ?>
		<td data-field="datang_tgl"<?php echo $Page->datang_tgl->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->GrpCount ?>_<?php echo $Page->RecCount ?>_Kedatangan_Dan_Verifikasi_datang_tgl"<?php echo $Page->datang_tgl->ViewAttributes() ?>><?php echo $Page->datang_tgl->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->datang_jumlah->Visible) { ?>
		<td data-field="datang_jumlah"<?php echo $Page->datang_jumlah->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->GrpCount ?>_<?php echo $Page->RecCount ?>_Kedatangan_Dan_Verifikasi_datang_jumlah"<?php echo $Page->datang_jumlah->ViewAttributes() ?>><?php echo $Page->datang_jumlah->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->ds_nama->Visible) { ?>
		<td data-field="ds_nama"<?php echo $Page->ds_nama->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->GrpCount ?>_<?php echo $Page->RecCount ?>_Kedatangan_Dan_Verifikasi_ds_nama"<?php echo $Page->ds_nama->ViewAttributes() ?>><?php echo $Page->ds_nama->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->datang_terpakai->Visible) { ?>
		<td data-field="datang_terpakai"<?php echo $Page->datang_terpakai->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->GrpCount ?>_<?php echo $Page->RecCount ?>_Kedatangan_Dan_Verifikasi_datang_terpakai"<?php echo $Page->datang_terpakai->ViewAttributes() ?>><?php echo $Page->datang_terpakai->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->var_nama->Visible) { ?>
		<td data-field="var_nama"<?php echo $Page->var_nama->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->GrpCount ?>_<?php echo $Page->RecCount ?>_Kedatangan_Dan_Verifikasi_var_nama"<?php echo $Page->var_nama->ViewAttributes() ?>><?php echo $Page->var_nama->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->sup_nama->Visible) { ?>
		<td data-field="sup_nama"<?php echo $Page->sup_nama->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->GrpCount ?>_<?php echo $Page->RecCount ?>_Kedatangan_Dan_Verifikasi_sup_nama"<?php echo $Page->sup_nama->ViewAttributes() ?>><?php echo $Page->sup_nama->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->pet_nama->Visible) { ?>
		<td data-field="pet_nama"<?php echo $Page->pet_nama->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->GrpCount ?>_<?php echo $Page->RecCount ?>_Kedatangan_Dan_Verifikasi_pet_nama"<?php echo $Page->pet_nama->ViewAttributes() ?>><?php echo $Page->pet_nama->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->co_nama->Visible) { ?>
		<td data-field="co_nama"<?php echo $Page->co_nama->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->GrpCount ?>_<?php echo $Page->RecCount ?>_Kedatangan_Dan_Verifikasi_co_nama"<?php echo $Page->co_nama->ViewAttributes() ?>><?php echo $Page->co_nama->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->k_id_kontrak->Visible) { ?>
		<td data-field="k_id_kontrak"<?php echo $Page->k_id_kontrak->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->GrpCount ?>_<?php echo $Page->RecCount ?>_Kedatangan_Dan_Verifikasi_k_id_kontrak"<?php echo $Page->k_id_kontrak->ViewAttributes() ?>><?php echo $Page->k_id_kontrak->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->k_luas_lahan->Visible) { ?>
		<td data-field="k_luas_lahan"<?php echo $Page->k_luas_lahan->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->GrpCount ?>_<?php echo $Page->RecCount ?>_Kedatangan_Dan_Verifikasi_k_luas_lahan"<?php echo $Page->k_luas_lahan->ViewAttributes() ?>><?php echo $Page->k_luas_lahan->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->k_es_tgl_panen->Visible) { ?>
		<td data-field="k_es_tgl_panen"<?php echo $Page->k_es_tgl_panen->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->GrpCount ?>_<?php echo $Page->RecCount ?>_Kedatangan_Dan_Verifikasi_k_es_tgl_panen"<?php echo $Page->k_es_tgl_panen->ViewAttributes() ?>><?php echo $Page->k_es_tgl_panen->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->k_es_qty->Visible) { ?>
		<td data-field="k_es_qty"<?php echo $Page->k_es_qty->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->GrpCount ?>_<?php echo $Page->RecCount ?>_Kedatangan_Dan_Verifikasi_k_es_qty"<?php echo $Page->k_es_qty->ViewAttributes() ?>><?php echo $Page->k_es_qty->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->ver_tgl->Visible) { ?>
		<td data-field="ver_tgl"<?php echo $Page->ver_tgl->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->GrpCount ?>_<?php echo $Page->RecCount ?>_Kedatangan_Dan_Verifikasi_ver_tgl"<?php echo $Page->ver_tgl->ViewAttributes() ?>><?php echo $Page->ver_tgl->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->ver_presentasi_rijek->Visible) { ?>
		<td data-field="ver_presentasi_rijek"<?php echo $Page->ver_presentasi_rijek->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->GrpCount ?>_<?php echo $Page->RecCount ?>_Kedatangan_Dan_Verifikasi_ver_presentasi_rijek"<?php echo $Page->ver_presentasi_rijek->ViewAttributes() ?>><?php echo $Page->ver_presentasi_rijek->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->ver_hasil_id->Visible) { ?>
		<td data-field="ver_hasil_id"<?php echo $Page->ver_hasil_id->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->GrpCount ?>_<?php echo $Page->RecCount ?>_Kedatangan_Dan_Verifikasi_ver_hasil_id"<?php echo $Page->ver_hasil_id->ViewAttributes() ?>><?php echo $Page->ver_hasil_id->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->qc_nama->Visible) { ?>
		<td data-field="qc_nama"<?php echo $Page->qc_nama->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->GrpCount ?>_<?php echo $Page->RecCount ?>_Kedatangan_Dan_Verifikasi_qc_nama"<?php echo $Page->qc_nama->ViewAttributes() ?>><?php echo $Page->qc_nama->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->ver_catatan->Visible) { ?>
		<td data-field="ver_catatan"<?php echo $Page->ver_catatan->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->GrpCount ?>_<?php echo $Page->RecCount ?>_Kedatangan_Dan_Verifikasi_ver_catatan"<?php echo $Page->ver_catatan->ViewAttributes() ?>><?php echo $Page->ver_catatan->ListViewValue() ?></span></td>
<?php } ?>
	</tr>
<?php

		// Accumulate page summary
		$Page->AccumulateSummary();

		// Get next record
		$Page->GetRow(2);
	$Page->GrpCount++;
} // End while
?>
<?php if ($Page->TotalGrps > 0) { ?>
</tbody>
<tfoot>
<?php
	$Page->datang_jumlah->Count = $Page->GrandCnt[3];
	$Page->datang_jumlah->SumValue = $Page->GrandSmry[3]; // Load SUM
	$Page->datang_terpakai->Count = $Page->GrandCnt[5];
	$Page->datang_terpakai->SumValue = $Page->GrandSmry[5]; // Load SUM
	$Page->ver_presentasi_rijek->Count = $Page->GrandCnt[15];
	$Page->ver_presentasi_rijek->AvgValue = ($Page->ver_presentasi_rijek->Count > 0) ? $Page->GrandSmry[15]/$Page->ver_presentasi_rijek->Count : 0; // Load AVG
	$Page->ResetAttrs();
	$Page->RowType = EWR_ROWTYPE_TOTAL;
	$Page->RowTotalType = EWR_ROWTOTAL_GRAND;
	$Page->RowTotalSubType = EWR_ROWTOTAL_FOOTER;
	$Page->RowAttrs["class"] = "ewRptGrandSummary";
	$Page->RenderRow();
?>
	<tr<?php echo $Page->RowAttributes() ?>><td colspan="<?php echo ($Page->GrpColumnCount + $Page->DtlColumnCount) ?>"><?php echo $ReportLanguage->Phrase("RptGrandSummary") ?> <span class="ewDirLtr">(<?php echo ewr_FormatNumber($Page->TotCount,0,-2,-2,-2); ?><?php echo $ReportLanguage->Phrase("RptDtlRec") ?>)</span></td></tr>
	<tr<?php echo $Page->RowAttributes() ?>>
<?php if ($Page->datang_id->Visible) { ?>
		<td data-field="datang_id"<?php echo $Page->datang_id->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->datang_tgl->Visible) { ?>
		<td data-field="datang_tgl"<?php echo $Page->datang_tgl->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->datang_jumlah->Visible) { ?>
		<td data-field="datang_jumlah"<?php echo $Page->datang_jumlah->CellAttributes() ?>><span class="ewAggregate"><?php echo $ReportLanguage->Phrase("RptSum") ?></span><?php echo $ReportLanguage->Phrase("AggregateColon") ?>
<span data-class="tpts_Kedatangan_Dan_Verifikasi_datang_jumlah"<?php echo $Page->datang_jumlah->ViewAttributes() ?>><?php echo $Page->datang_jumlah->SumViewValue ?></span></td>
<?php } ?>
<?php if ($Page->ds_nama->Visible) { ?>
		<td data-field="ds_nama"<?php echo $Page->ds_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->datang_terpakai->Visible) { ?>
		<td data-field="datang_terpakai"<?php echo $Page->datang_terpakai->CellAttributes() ?>><span class="ewAggregate"><?php echo $ReportLanguage->Phrase("RptSum") ?></span><?php echo $ReportLanguage->Phrase("AggregateColon") ?>
<span data-class="tpts_Kedatangan_Dan_Verifikasi_datang_terpakai"<?php echo $Page->datang_terpakai->ViewAttributes() ?>><?php echo $Page->datang_terpakai->SumViewValue ?></span></td>
<?php } ?>
<?php if ($Page->var_nama->Visible) { ?>
		<td data-field="var_nama"<?php echo $Page->var_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->sup_nama->Visible) { ?>
		<td data-field="sup_nama"<?php echo $Page->sup_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->pet_nama->Visible) { ?>
		<td data-field="pet_nama"<?php echo $Page->pet_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->co_nama->Visible) { ?>
		<td data-field="co_nama"<?php echo $Page->co_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_id_kontrak->Visible) { ?>
		<td data-field="k_id_kontrak"<?php echo $Page->k_id_kontrak->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_luas_lahan->Visible) { ?>
		<td data-field="k_luas_lahan"<?php echo $Page->k_luas_lahan->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_es_tgl_panen->Visible) { ?>
		<td data-field="k_es_tgl_panen"<?php echo $Page->k_es_tgl_panen->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_es_qty->Visible) { ?>
		<td data-field="k_es_qty"<?php echo $Page->k_es_qty->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->ver_tgl->Visible) { ?>
		<td data-field="ver_tgl"<?php echo $Page->ver_tgl->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->ver_presentasi_rijek->Visible) { ?>
		<td data-field="ver_presentasi_rijek"<?php echo $Page->ver_presentasi_rijek->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->ver_hasil_id->Visible) { ?>
		<td data-field="ver_hasil_id"<?php echo $Page->ver_hasil_id->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->qc_nama->Visible) { ?>
		<td data-field="qc_nama"<?php echo $Page->qc_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->ver_catatan->Visible) { ?>
		<td data-field="ver_catatan"<?php echo $Page->ver_catatan->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
	</tr>
	<tr<?php echo $Page->RowAttributes() ?>>
<?php if ($Page->datang_id->Visible) { ?>
		<td data-field="datang_id"<?php echo $Page->datang_id->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->datang_tgl->Visible) { ?>
		<td data-field="datang_tgl"<?php echo $Page->datang_tgl->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->datang_jumlah->Visible) { ?>
		<td data-field="datang_jumlah"<?php echo $Page->datang_jumlah->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->ds_nama->Visible) { ?>
		<td data-field="ds_nama"<?php echo $Page->ds_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->datang_terpakai->Visible) { ?>
		<td data-field="datang_terpakai"<?php echo $Page->datang_terpakai->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->var_nama->Visible) { ?>
		<td data-field="var_nama"<?php echo $Page->var_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->sup_nama->Visible) { ?>
		<td data-field="sup_nama"<?php echo $Page->sup_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->pet_nama->Visible) { ?>
		<td data-field="pet_nama"<?php echo $Page->pet_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->co_nama->Visible) { ?>
		<td data-field="co_nama"<?php echo $Page->co_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_id_kontrak->Visible) { ?>
		<td data-field="k_id_kontrak"<?php echo $Page->k_id_kontrak->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_luas_lahan->Visible) { ?>
		<td data-field="k_luas_lahan"<?php echo $Page->k_luas_lahan->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_es_tgl_panen->Visible) { ?>
		<td data-field="k_es_tgl_panen"<?php echo $Page->k_es_tgl_panen->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->k_es_qty->Visible) { ?>
		<td data-field="k_es_qty"<?php echo $Page->k_es_qty->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->ver_tgl->Visible) { ?>
		<td data-field="ver_tgl"<?php echo $Page->ver_tgl->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->ver_presentasi_rijek->Visible) { ?>
		<td data-field="ver_presentasi_rijek"<?php echo $Page->ver_presentasi_rijek->CellAttributes() ?>><span class="ewAggregate"><?php echo $ReportLanguage->Phrase("RptAvg") ?></span><?php echo $ReportLanguage->Phrase("AggregateColon") ?>
<span data-class="tpta_Kedatangan_Dan_Verifikasi_ver_presentasi_rijek"<?php echo $Page->ver_presentasi_rijek->ViewAttributes() ?>><?php echo $Page->ver_presentasi_rijek->AvgViewValue ?></span></td>
<?php } ?>
<?php if ($Page->ver_hasil_id->Visible) { ?>
		<td data-field="ver_hasil_id"<?php echo $Page->ver_hasil_id->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->qc_nama->Visible) { ?>
		<td data-field="qc_nama"<?php echo $Page->qc_nama->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->ver_catatan->Visible) { ?>
		<td data-field="ver_catatan"<?php echo $Page->ver_catatan->CellAttributes() ?>>&nbsp;</td>
<?php } ?>
	</tr>
	</tfoot>
<?php } elseif (!$Page->ShowHeader && TRUE) { // No header displayed ?>
<?php if ($Page->Export <> "pdf") { ?>
<?php if ($Page->Export == "word" || $Page->Export == "excel") { ?>
<div class="ewGrid"<?php echo $Page->ReportTableStyle ?>>
<?php } else { ?>
<div class="panel panel-default ewGrid"<?php echo $Page->ReportTableStyle ?>>
<?php } ?>
<?php } ?>
<!-- Report grid (begin) -->
<?php if ($Page->Export <> "pdf") { ?>
<div class="<?php if (ewr_IsResponsiveLayout()) { echo "table-responsive "; } ?>ewGridMiddlePanel">
<?php } ?>
<table class="<?php echo $Page->ReportTableClass ?>">
<?php } ?>
<?php if ($Page->TotalGrps > 0 || TRUE) { // Show footer ?>
</table>
<?php if ($Page->Export <> "pdf") { ?>
</div>
<?php } ?>
<?php if ($Page->Export == "" && !($Page->DrillDown && $Page->TotalGrps > 0)) { ?>
<div class="panel-footer ewGridLowerPanel">
<?php include "Kedatangan_Dan_Verifikasismrypager.php" ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($Page->Export <> "pdf") { ?>
</div>
<?php } ?>
<?php } ?>
<?php if ($Page->Export <> "pdf") { ?>
</div>
<?php } ?>
<!-- Summary Report Ends -->
<?php if ($Page->Export == "") { ?>
	</div>
	<!-- center container - report (end) -->
	<!-- right container (begin) -->
	<div id="ewRight" class="ewRight">
<?php } ?>
	<!-- Right slot -->
<?php if ($Page->Export == "") { ?>
	</div>
	<!-- right container (end) -->
<div class="clearfix"></div>
<!-- bottom container (begin) -->
<div id="ewBottom" class="ewBottom">
<?php } ?>
	<!-- Bottom slot -->
<?php if ($Page->Export == "") { ?>
	</div>
<!-- Bottom Container (End) -->
</div>
<!-- Table Container (End) -->
<?php } ?>
<?php $Page->ShowPageFooter(); ?>
<?php if (EWR_DEBUG_ENABLED) echo ewr_DebugMsg(); ?>
<?php

// Close recordsets
if ($rsgrp) $rsgrp->Close();
if ($rs) $rs->Close();
?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "phprptinc/footer.php" ?>
<?php include_once "footer.php" ?>
<?php
$Page->Page_Terminate();
if (isset($OldPage)) $Page = $OldPage;
?>
