<?php
if (session_id() == "") session_start(); // Init session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg14.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql14.php") ?>
<?php include_once "phpfn14.php" ?>
<?php include_once "sosialisasiinfo.php" ?>
<?php include_once "employeesinfo.php" ?>
<?php include_once "userfn14.php" ?>
<?php

//
// Page class
//

$sosialisasi_view = NULL; // Initialize page object first

class csosialisasi_view extends csosialisasi {

	// Page ID
	var $PageID = 'view';

	// Project ID
	var $ProjectID = '{CC60B42B-604B-412A-B014-2315920AF6AA}';

	// Table name
	var $TableName = 'sosialisasi';

	// Page object name
	var $PageObjName = 'sosialisasi_view';

	// Page headings
	var $Heading = '';
	var $Subheading = '';

	// Page heading
	function PageHeading() {
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->TableCaption();
		return "";
	}

	// Page subheading
	function PageSubheading() {
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->Phrase($this->PageID);
		return "";
	}

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;
	var $ExportPdfUrl;

	// Custom export
	var $ExportExcelCustom = FALSE;
	var $ExportWordCustom = FALSE;
	var $ExportPdfCustom = FALSE;
	var $ExportEmailCustom = FALSE;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (sosialisasi)
		if (!isset($GLOBALS["sosialisasi"]) || get_class($GLOBALS["sosialisasi"]) == "csosialisasi") {
			$GLOBALS["sosialisasi"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["sosialisasi"];
		}
		$KeyUrl = "";
		if (@$_GET["sos_id"] <> "") {
			$this->RecKey["sos_id"] = $_GET["sos_id"];
			$KeyUrl .= "&amp;sos_id=" . urlencode($this->RecKey["sos_id"]);
		}
		$this->ExportPrintUrl = $this->PageUrl() . "export=print" . $KeyUrl;
		$this->ExportHtmlUrl = $this->PageUrl() . "export=html" . $KeyUrl;
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel" . $KeyUrl;
		$this->ExportWordUrl = $this->PageUrl() . "export=word" . $KeyUrl;
		$this->ExportXmlUrl = $this->PageUrl() . "export=xml" . $KeyUrl;
		$this->ExportCsvUrl = $this->PageUrl() . "export=csv" . $KeyUrl;
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf" . $KeyUrl;

		// Table object (employees)
		if (!isset($GLOBALS['employees'])) $GLOBALS['employees'] = new cemployees();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'view', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'sosialisasi', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"]))
			$GLOBALS["gTimer"] = new cTimer();

		// Debug message
		ew_LoadDebugMsg();

		// Open connection
		if (!isset($conn))
			$conn = ew_Connect($this->DBID);

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new cemployees();
			$UserTableConn = Conn($UserTable->DBID);
		}

		// Export options
		$this->ExportOptions = new cListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Other options
		$this->OtherOptions['action'] = new cListOptions();
		$this->OtherOptions['action']->Tag = "div";
		$this->OtherOptions['action']->TagClassName = "ewActionOption";
		$this->OtherOptions['detail'] = new cListOptions();
		$this->OtherOptions['detail']->Tag = "div";
		$this->OtherOptions['detail']->TagClassName = "ewDetailOption";
	}

	//
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Is modal
		$this->IsModal = (@$_GET["modal"] == "1" || @$_POST["modal"] == "1");

		// User profile
		$UserProfile = new cUserProfile();

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanView()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			if ($Security->CanList())
				$this->Page_Terminate(ew_GetUrl("sosialisasilist.php"));
			else
				$this->Page_Terminate(ew_GetUrl("login.php"));
		}

		// NOTE: Security object may be needed in other part of the script, skip set to Nothing
		// 
		// Security = null;
		// 
		// Get export parameters

		$custom = "";
		if (@$_GET["export"] <> "") {
			$this->Export = $_GET["export"];
			$custom = @$_GET["custom"];
		} elseif (@$_POST["export"] <> "") {
			$this->Export = $_POST["export"];
			$custom = @$_POST["custom"];
		} elseif (ew_IsPost()) {
			if (@$_POST["exporttype"] <> "")
				$this->Export = $_POST["exporttype"];
			$custom = @$_POST["custom"];
		} elseif (@$_GET["cmd"] == "json") {
			$this->Export = $_GET["cmd"];
		} else {
			$this->setExportReturnUrl(ew_CurrentUrl());
		}
		$gsExportFile = $this->TableVar; // Get export file, used in header
		if (@$_GET["sos_id"] <> "") {
			if ($gsExportFile <> "") $gsExportFile .= "_";
			$gsExportFile .= $_GET["sos_id"];
		}

		// Get custom export parameters
		if ($this->Export <> "" && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$gsCustomExport = $this->CustomExport;
		$gsExport = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined("EW_USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined("EW_USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action

		// Setup export options
		$this->SetupExportOptions();
		$this->sos_id->SetVisibility();
		if ($this->IsAdd() || $this->IsCopy() || $this->IsGridAdd())
			$this->sos_id->Visible = FALSE;
		$this->sos_tgl->SetVisibility();
		$this->sos_co->SetVisibility();
		$this->sos_peserta->SetVisibility();
		$this->sos_prov->SetVisibility();
		$this->sos_kab->SetVisibility();
		$this->sos_kec->SetVisibility();
		$this->sos_desa->SetVisibility();
		$this->sos_alamat->SetVisibility();
		$this->sos_pot_lahan->SetVisibility();
		$this->sos_katinggian->SetVisibility();
		$this->sos_biaya->SetVisibility();
		$this->sos_kesimpulan->SetVisibility();
		$this->sos_foto->SetVisibility();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Create Token
		$this->CreateToken();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $sosialisasi;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($sosialisasi);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		// Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = ew_GetPageName($url);
				if ($pageName != $this->GetListUrl()) { // Not List page
					$row["caption"] = $this->GetModalCaption($pageName);
					if ($pageName == "sosialisasiview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				header("Content-Type: application/json; charset=utf-8");
				echo ew_ConvertToUtf8(ew_ArrayToJson(array($row)));
			} else {
				ew_SaveDebugMsg();
				header("Location: " . $url);
			}
		}
		exit();
	}
	var $ExportOptions; // Export options
	var $OtherOptions = array(); // Other options
	var $DisplayRecs = 1;
	var $DbMasterFilter;
	var $DbDetailFilter;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $RecCnt;
	var $RecKey = array();
	var $IsModal = FALSE;
	var $Recordset;

	//
	// Page main
	//
	function Page_Main() {
		global $Language, $gbSkipHeaderFooter, $EW_EXPORT;

		// Check modal
		if ($this->IsModal)
			$gbSkipHeaderFooter = TRUE;

		// Load current record
		$bLoadCurrentRecord = FALSE;
		$sReturnUrl = "";
		$bMatchRecord = FALSE;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET["sos_id"] <> "") {
				$this->sos_id->setQueryStringValue($_GET["sos_id"]);
				$this->RecKey["sos_id"] = $this->sos_id->QueryStringValue;
			} elseif (@$_POST["sos_id"] <> "") {
				$this->sos_id->setFormValue($_POST["sos_id"]);
				$this->RecKey["sos_id"] = $this->sos_id->FormValue;
			} else {
				$sReturnUrl = "sosialisasilist.php"; // Return to list
			}

			// Get action
			$this->CurrentAction = "I"; // Display form
			switch ($this->CurrentAction) {
				case "I": // Get a record to display
					if (!$this->LoadRow()) { // Load record based on key
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->Phrase("NoRecord")); // Set no record message
						$sReturnUrl = "sosialisasilist.php"; // No matching record, return to list
					}
			}

			// Export data only
			if ($this->CustomExport == "" && in_array($this->Export, array_keys($EW_EXPORT))) {
				$this->ExportData();
				$this->Page_Terminate(); // Terminate response
				exit();
			}
		} else {
			$sReturnUrl = "sosialisasilist.php"; // Not page request, return to list
		}
		if ($sReturnUrl <> "")
			$this->Page_Terminate($sReturnUrl);

		// Set up Breadcrumb
		if ($this->Export == "")
			$this->SetupBreadcrumb();

		// Render row
		$this->RowType = EW_ROWTYPE_VIEW;
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Set up other options
	function SetupOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = &$options["action"];

		// Add
		$item = &$option->Add("add");
		$addcaption = ew_HtmlTitle($Language->Phrase("ViewPageAddLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ewAction ewAdd\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"javascript:void(0);\" onclick=\"ew_ModalDialogShow({lnk:this,url:'" . ew_HtmlEncode($this->AddUrl) . "'});\">" . $Language->Phrase("ViewPageAddLink") . "</a>";
		else
			$item->Body = "<a class=\"ewAction ewAdd\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . ew_HtmlEncode($this->AddUrl) . "\">" . $Language->Phrase("ViewPageAddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->CanAdd());

		// Edit
		$item = &$option->Add("edit");
		$editcaption = ew_HtmlTitle($Language->Phrase("ViewPageEditLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ewAction ewEdit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"javascript:void(0);\" onclick=\"ew_ModalDialogShow({lnk:this,url:'" . ew_HtmlEncode($this->EditUrl) . "'});\">" . $Language->Phrase("ViewPageEditLink") . "</a>";
		else
			$item->Body = "<a class=\"ewAction ewEdit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . ew_HtmlEncode($this->EditUrl) . "\">" . $Language->Phrase("ViewPageEditLink") . "</a>";
		$item->Visible = ($this->EditUrl <> "" && $Security->CanEdit());

		// Copy
		$item = &$option->Add("copy");
		$copycaption = ew_HtmlTitle($Language->Phrase("ViewPageCopyLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ewAction ewCopy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"javascript:void(0);\" onclick=\"ew_ModalDialogShow({lnk:this,btn:'AddBtn',url:'" . ew_HtmlEncode($this->CopyUrl) . "'});\">" . $Language->Phrase("ViewPageCopyLink") . "</a>";
		else
			$item->Body = "<a class=\"ewAction ewCopy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . ew_HtmlEncode($this->CopyUrl) . "\">" . $Language->Phrase("ViewPageCopyLink") . "</a>";
		$item->Visible = ($this->CopyUrl <> "" && $Security->CanAdd());

		// Delete
		$item = &$option->Add("delete");
		if ($this->IsModal) // Handle as inline delete
			$item->Body = "<a onclick=\"return ew_ConfirmDelete(this);\" class=\"ewAction ewDelete\" title=\"" . ew_HtmlTitle($Language->Phrase("ViewPageDeleteLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("ViewPageDeleteLink")) . "\" href=\"" . ew_HtmlEncode(ew_UrlAddQuery($this->DeleteUrl, "a_delete=1")) . "\">" . $Language->Phrase("ViewPageDeleteLink") . "</a>";
		else
			$item->Body = "<a class=\"ewAction ewDelete\" title=\"" . ew_HtmlTitle($Language->Phrase("ViewPageDeleteLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("ViewPageDeleteLink")) . "\" href=\"" . ew_HtmlEncode($this->DeleteUrl) . "\">" . $Language->Phrase("ViewPageDeleteLink") . "</a>";
		$item->Visible = ($this->DeleteUrl <> "" && $Security->CanDelete());

		// Set up action default
		$option = &$options["action"];
		$option->DropDownButtonPhrase = $Language->Phrase("ButtonActions");
		$option->UseImageAndText = TRUE;
		$option->UseDropDownButton = FALSE;
		$option->UseButtonGroup = TRUE;
		$item = &$option->Add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Set up starting record parameters
	function SetupStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {

		// Load List page SQL
		$sSql = $this->ListSQL();
		$conn = &$this->Connection();

		// Load recordset
		$dbtype = ew_GetConnectionType($this->DBID);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset, array("_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())));
			} else {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = ew_LoadRecordset($sSql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues($rs = NULL) {
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->NewRow(); 

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->sos_id->setDbValue($row['sos_id']);
		$this->sos_tgl->setDbValue($row['sos_tgl']);
		$this->sos_co->setDbValue($row['sos_co']);
		$this->sos_peserta->setDbValue($row['sos_peserta']);
		$this->sos_prov->setDbValue($row['sos_prov']);
		$this->sos_kab->setDbValue($row['sos_kab']);
		$this->sos_kec->setDbValue($row['sos_kec']);
		$this->sos_desa->setDbValue($row['sos_desa']);
		$this->sos_alamat->setDbValue($row['sos_alamat']);
		$this->sos_pot_lahan->setDbValue($row['sos_pot_lahan']);
		$this->sos_katinggian->setDbValue($row['sos_katinggian']);
		$this->sos_biaya->setDbValue($row['sos_biaya']);
		$this->sos_kesimpulan->setDbValue($row['sos_kesimpulan']);
		$this->sos_foto->Upload->DbValue = $row['sos_foto'];
		$this->sos_foto->setDbValue($this->sos_foto->Upload->DbValue);
	}

	// Return a row with default values
	function NewRow() {
		$row = array();
		$row['sos_id'] = NULL;
		$row['sos_tgl'] = NULL;
		$row['sos_co'] = NULL;
		$row['sos_peserta'] = NULL;
		$row['sos_prov'] = NULL;
		$row['sos_kab'] = NULL;
		$row['sos_kec'] = NULL;
		$row['sos_desa'] = NULL;
		$row['sos_alamat'] = NULL;
		$row['sos_pot_lahan'] = NULL;
		$row['sos_katinggian'] = NULL;
		$row['sos_biaya'] = NULL;
		$row['sos_kesimpulan'] = NULL;
		$row['sos_foto'] = NULL;
		return $row;
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->sos_id->DbValue = $row['sos_id'];
		$this->sos_tgl->DbValue = $row['sos_tgl'];
		$this->sos_co->DbValue = $row['sos_co'];
		$this->sos_peserta->DbValue = $row['sos_peserta'];
		$this->sos_prov->DbValue = $row['sos_prov'];
		$this->sos_kab->DbValue = $row['sos_kab'];
		$this->sos_kec->DbValue = $row['sos_kec'];
		$this->sos_desa->DbValue = $row['sos_desa'];
		$this->sos_alamat->DbValue = $row['sos_alamat'];
		$this->sos_pot_lahan->DbValue = $row['sos_pot_lahan'];
		$this->sos_katinggian->DbValue = $row['sos_katinggian'];
		$this->sos_biaya->DbValue = $row['sos_biaya'];
		$this->sos_kesimpulan->DbValue = $row['sos_kesimpulan'];
		$this->sos_foto->Upload->DbValue = $row['sos_foto'];
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		$this->AddUrl = $this->GetAddUrl();
		$this->EditUrl = $this->GetEditUrl();
		$this->CopyUrl = $this->GetCopyUrl();
		$this->DeleteUrl = $this->GetDeleteUrl();
		$this->ListUrl = $this->GetListUrl();
		$this->SetupOtherOptions();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// sos_id
		// sos_tgl
		// sos_co
		// sos_peserta
		// sos_prov
		// sos_kab
		// sos_kec
		// sos_desa
		// sos_alamat
		// sos_pot_lahan
		// sos_katinggian
		// sos_biaya
		// sos_kesimpulan
		// sos_foto

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// sos_id
		$this->sos_id->ViewValue = $this->sos_id->CurrentValue;
		$this->sos_id->ViewCustomAttributes = "";

		// sos_tgl
		$this->sos_tgl->ViewValue = $this->sos_tgl->CurrentValue;
		$this->sos_tgl->ViewValue = ew_FormatDateTime($this->sos_tgl->ViewValue, 0);
		$this->sos_tgl->ViewCustomAttributes = "";

		// sos_co
		if (strval($this->sos_co->CurrentValue) <> "") {
			$sFilterWrk = "`co_id`" . ew_SearchString("=", $this->sos_co->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `co_id`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `co`";
		$sWhereWrk = "";
		$this->sos_co->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->sos_co, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `co_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->sos_co->ViewValue = $this->sos_co->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->sos_co->ViewValue = $this->sos_co->CurrentValue;
			}
		} else {
			$this->sos_co->ViewValue = NULL;
		}
		$this->sos_co->ViewCustomAttributes = "";

		// sos_peserta
		if (strval($this->sos_peserta->CurrentValue) <> "") {
			$arwrk = explode(",", $this->sos_peserta->CurrentValue);
			$sFilterWrk = "";
			foreach ($arwrk as $wrk) {
				if ($sFilterWrk <> "") $sFilterWrk .= " OR ";
				$sFilterWrk .= "`pes_id`" . ew_SearchString("=", trim($wrk), EW_DATATYPE_NUMBER, "");
			}
		$sSqlWrk = "SELECT `pes_id`, `pes_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `peserta`";
		$sWhereWrk = "";
		$this->sos_peserta->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->sos_peserta, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `pes_id` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$this->sos_peserta->ViewValue = "";
				$ari = 0;
				while (!$rswrk->EOF) {
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('DispFld');
					$this->sos_peserta->ViewValue .= $this->sos_peserta->DisplayValue($arwrk);
					$rswrk->MoveNext();
					if (!$rswrk->EOF) $this->sos_peserta->ViewValue .= ew_ViewOptionSeparator($ari); // Separate Options
					$ari++;
				}
				$rswrk->Close();
			} else {
				$this->sos_peserta->ViewValue = $this->sos_peserta->CurrentValue;
			}
		} else {
			$this->sos_peserta->ViewValue = NULL;
		}
		$this->sos_peserta->CellCssStyle .= "text-align: left;";
		$this->sos_peserta->ViewCustomAttributes = "";

		// sos_prov
		if (strval($this->sos_prov->CurrentValue) <> "") {
			$sFilterWrk = "`prov_id`" . ew_SearchString("=", $this->sos_prov->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `prov_id`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `prov`";
		$sWhereWrk = "";
		$this->sos_prov->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->sos_prov, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `prov_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->sos_prov->ViewValue = $this->sos_prov->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->sos_prov->ViewValue = $this->sos_prov->CurrentValue;
			}
		} else {
			$this->sos_prov->ViewValue = NULL;
		}
		$this->sos_prov->ViewCustomAttributes = "";

		// sos_kab
		if (strval($this->sos_kab->CurrentValue) <> "") {
			$sFilterWrk = "`kab_id`" . ew_SearchString("=", $this->sos_kab->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `kab_id`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kab`";
		$sWhereWrk = "";
		$this->sos_kab->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->sos_kab, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `kab_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->sos_kab->ViewValue = $this->sos_kab->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->sos_kab->ViewValue = $this->sos_kab->CurrentValue;
			}
		} else {
			$this->sos_kab->ViewValue = NULL;
		}
		$this->sos_kab->ViewCustomAttributes = "";

		// sos_kec
		if (strval($this->sos_kec->CurrentValue) <> "") {
			$sFilterWrk = "`kec_id`" . ew_SearchString("=", $this->sos_kec->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `kec_id`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kec`";
		$sWhereWrk = "";
		$this->sos_kec->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->sos_kec, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `kec_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->sos_kec->ViewValue = $this->sos_kec->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->sos_kec->ViewValue = $this->sos_kec->CurrentValue;
			}
		} else {
			$this->sos_kec->ViewValue = NULL;
		}
		$this->sos_kec->ViewCustomAttributes = "";

		// sos_desa
		if (strval($this->sos_desa->CurrentValue) <> "") {
			$sFilterWrk = "`desa_id`" . ew_SearchString("=", $this->sos_desa->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `desa_id`, `desa_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `desa`";
		$sWhereWrk = "";
		$this->sos_desa->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->sos_desa, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `desa_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->sos_desa->ViewValue = $this->sos_desa->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->sos_desa->ViewValue = $this->sos_desa->CurrentValue;
			}
		} else {
			$this->sos_desa->ViewValue = NULL;
		}
		$this->sos_desa->ViewCustomAttributes = "";

		// sos_alamat
		$this->sos_alamat->ViewValue = $this->sos_alamat->CurrentValue;
		$this->sos_alamat->ViewCustomAttributes = "";

		// sos_pot_lahan
		$this->sos_pot_lahan->ViewValue = $this->sos_pot_lahan->CurrentValue;
		$this->sos_pot_lahan->CellCssStyle .= "text-align: right;";
		$this->sos_pot_lahan->ViewCustomAttributes = "";

		// sos_katinggian
		$this->sos_katinggian->ViewValue = $this->sos_katinggian->CurrentValue;
		$this->sos_katinggian->CellCssStyle .= "text-align: right;";
		$this->sos_katinggian->ViewCustomAttributes = "";

		// sos_biaya
		$this->sos_biaya->ViewValue = $this->sos_biaya->CurrentValue;
		$this->sos_biaya->ViewCustomAttributes = "";

		// sos_kesimpulan
		$this->sos_kesimpulan->ViewValue = $this->sos_kesimpulan->CurrentValue;
		$this->sos_kesimpulan->ViewCustomAttributes = "";

		// sos_foto
		$this->sos_foto->UploadPath = "foto_sosialisasi";
		if (!ew_Empty($this->sos_foto->Upload->DbValue)) {
			$this->sos_foto->ImageWidth = 80;
			$this->sos_foto->ImageHeight = 60;
			$this->sos_foto->ImageAlt = $this->sos_foto->FldAlt();
			$this->sos_foto->ViewValue = $this->sos_foto->Upload->DbValue;
		} else {
			$this->sos_foto->ViewValue = "";
		}
		$this->sos_foto->CellCssStyle .= "text-align: center;";
		$this->sos_foto->ViewCustomAttributes = "";

			// sos_id
			$this->sos_id->LinkCustomAttributes = "";
			$this->sos_id->HrefValue = "";
			$this->sos_id->TooltipValue = "";

			// sos_tgl
			$this->sos_tgl->LinkCustomAttributes = "";
			$this->sos_tgl->HrefValue = "";
			$this->sos_tgl->TooltipValue = "";

			// sos_co
			$this->sos_co->LinkCustomAttributes = "";
			$this->sos_co->HrefValue = "";
			$this->sos_co->TooltipValue = "";

			// sos_peserta
			$this->sos_peserta->LinkCustomAttributes = "";
			$this->sos_peserta->HrefValue = "";
			$this->sos_peserta->TooltipValue = "";

			// sos_prov
			$this->sos_prov->LinkCustomAttributes = "";
			$this->sos_prov->HrefValue = "";
			$this->sos_prov->TooltipValue = "";

			// sos_kab
			$this->sos_kab->LinkCustomAttributes = "";
			$this->sos_kab->HrefValue = "";
			$this->sos_kab->TooltipValue = "";

			// sos_kec
			$this->sos_kec->LinkCustomAttributes = "";
			$this->sos_kec->HrefValue = "";
			$this->sos_kec->TooltipValue = "";

			// sos_desa
			$this->sos_desa->LinkCustomAttributes = "";
			$this->sos_desa->HrefValue = "";
			$this->sos_desa->TooltipValue = "";

			// sos_alamat
			$this->sos_alamat->LinkCustomAttributes = "";
			$this->sos_alamat->HrefValue = "";
			$this->sos_alamat->TooltipValue = "";

			// sos_pot_lahan
			$this->sos_pot_lahan->LinkCustomAttributes = "";
			$this->sos_pot_lahan->HrefValue = "";
			$this->sos_pot_lahan->TooltipValue = "";

			// sos_katinggian
			$this->sos_katinggian->LinkCustomAttributes = "";
			$this->sos_katinggian->HrefValue = "";
			$this->sos_katinggian->TooltipValue = "";

			// sos_biaya
			$this->sos_biaya->LinkCustomAttributes = "";
			$this->sos_biaya->HrefValue = "";
			$this->sos_biaya->TooltipValue = "";

			// sos_kesimpulan
			$this->sos_kesimpulan->LinkCustomAttributes = "";
			$this->sos_kesimpulan->HrefValue = "";
			$this->sos_kesimpulan->TooltipValue = "";

			// sos_foto
			$this->sos_foto->LinkCustomAttributes = "";
			$this->sos_foto->UploadPath = "foto_sosialisasi";
			if (!ew_Empty($this->sos_foto->Upload->DbValue)) {
				$this->sos_foto->HrefValue = "%u"; // Add prefix/suffix
				$this->sos_foto->LinkAttrs["target"] = ""; // Add target
				if ($this->Export <> "") $this->sos_foto->HrefValue = ew_FullUrl($this->sos_foto->HrefValue, "href");
			} else {
				$this->sos_foto->HrefValue = "";
			}
			$this->sos_foto->HrefValue2 = $this->sos_foto->UploadPath . $this->sos_foto->Upload->DbValue;
			$this->sos_foto->TooltipValue = "";
			if ($this->sos_foto->UseColorbox) {
				if (ew_Empty($this->sos_foto->TooltipValue))
					$this->sos_foto->LinkAttrs["title"] = $Language->Phrase("ViewImageGallery");
				$this->sos_foto->LinkAttrs["data-rel"] = "sosialisasi_x_sos_foto";
				ew_AppendClass($this->sos_foto->LinkAttrs["class"], "ewLightbox");
			}
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up export options
	function SetupExportOptions() {
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->Add("print");
		$item->Body = "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ewExportLink ewPrint\" title=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\">" . $Language->Phrase("PrinterFriendly") . "</a>";
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->Add("excel");
		$item->Body = "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ewExportLink ewExcel\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\">" . $Language->Phrase("ExportToExcel") . "</a>";
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->Add("word");
		$item->Body = "<a href=\"" . $this->ExportWordUrl . "\" class=\"ewExportLink ewWord\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\">" . $Language->Phrase("ExportToWord") . "</a>";
		$item->Visible = TRUE;

		// Export to Html
		$item = &$this->ExportOptions->Add("html");
		$item->Body = "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ewExportLink ewHtml\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\">" . $Language->Phrase("ExportToHtml") . "</a>";
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->Add("xml");
		$item->Body = "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ewExportLink ewXml\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\">" . $Language->Phrase("ExportToXml") . "</a>";
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->Add("csv");
		$item->Body = "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ewExportLink ewCsv\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\">" . $Language->Phrase("ExportToCsv") . "</a>";
		$item->Visible = FALSE;

		// Export to Pdf
		$item = &$this->ExportOptions->Add("pdf");
		$item->Body = "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ewExportLink ewPdf\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\">" . $Language->Phrase("ExportToPDF") . "</a>";
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->Add("email");
		$url = "";
		$item->Body = "<button id=\"emf_sosialisasi\" class=\"ewExportLink ewEmail\" title=\"" . $Language->Phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->Phrase("ExportToEmailText") . "\" onclick=\"ew_EmailDialogShow({lnk:'emf_sosialisasi',hdr:ewLanguage.Phrase('ExportToEmailText'),f:document.fsosialisasiview,key:" . ew_ArrayToJsonAttr($this->RecKey) . ",sel:false" . $url . "});\">" . $Language->Phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseImageAndText = TRUE;
		$this->ExportOptions->UseDropDownButton = FALSE;
		if ($this->ExportOptions->UseButtonGroup && ew_IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->Phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->Add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide options for export
		if ($this->Export <> "")
			$this->ExportOptions->HideAllOptions();
	}

	// Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	function ExportData() {
		$utf8 = (strtolower(EW_CHARSET) == "utf-8");
		$bSelectLimit = FALSE;

		// Load recordset
		if ($bSelectLimit) {
			$this->TotalRecs = $this->ListRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->LoadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;
		$this->SetupStartRec(); // Set up start record position

		// Set the last record to display
		if ($this->DisplayRecs <= 0) {
			$this->StopRec = $this->TotalRecs;
		} else {
			$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
		}
		if (!$rs) {
			header("Content-Type:"); // Remove header
			header("Content-Disposition:");
			$this->ShowMessage();
			return;
		}
		$this->ExportDoc = ew_ExportDocument($this, "v");
		$Doc = &$this->ExportDoc;
		if ($bSelectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		} else {

			//$this->StartRec = $this->StartRec;
			//$this->StopRec = $this->StopRec;

		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$ParentTable = "";
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		$Doc->Text .= $sHeader;
		$this->ExportDocument($Doc, $rs, $this->StartRec, $this->StopRec, "view");
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		$Doc->Text .= $sFooter;

		// Close recordset
		$rs->Close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$Doc->ExportHeaderAndFooter();

		// Clean output buffer
		if (!EW_DEBUG_ENABLED && ob_get_length())
			ob_end_clean();

		// Write debug message if enabled
		if (EW_DEBUG_ENABLED && $this->Export <> "pdf")
			echo ew_DebugMsg();

		// Output data
		$Doc->Export();
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$Breadcrumb->Add("list", $this->TableVar, $this->AddMasterUrl("sosialisasilist.php"), "", $this->TableVar, TRUE);
		$PageId = "view";
		$Breadcrumb->Add("view", $PageId, $url);
	}

	// Setup lookup filters of a field
	function SetupLookupFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		}
	}

	// Setup AutoSuggest filters of a field
	function SetupAutoSuggestFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($sosialisasi_view)) $sosialisasi_view = new csosialisasi_view();

// Page init
$sosialisasi_view->Page_Init();

// Page main
$sosialisasi_view->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sosialisasi_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if ($sosialisasi->Export == "") { ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "view";
var CurrentForm = fsosialisasiview = new ew_Form("fsosialisasiview", "view");

// Form_CustomValidate event
fsosialisasiview.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fsosialisasiview.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsosialisasiview.Lists["x_sos_co"] = {"LinkField":"x_co_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_co_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"co"};
fsosialisasiview.Lists["x_sos_co"].Data = "<?php echo $sosialisasi_view->sos_co->LookupFilterQuery(FALSE, "view") ?>";
fsosialisasiview.Lists["x_sos_peserta[]"] = {"LinkField":"x_pes_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_pes_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"peserta"};
fsosialisasiview.Lists["x_sos_peserta[]"].Data = "<?php echo $sosialisasi_view->sos_peserta->LookupFilterQuery(FALSE, "view") ?>";
fsosialisasiview.Lists["x_sos_prov"] = {"LinkField":"x_prov_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_prov_nama","","",""],"ParentFields":[],"ChildFields":["x_sos_kab","x_sos_kec","x_sos_desa"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"prov"};
fsosialisasiview.Lists["x_sos_prov"].Data = "<?php echo $sosialisasi_view->sos_prov->LookupFilterQuery(FALSE, "view") ?>";
fsosialisasiview.Lists["x_sos_kab"] = {"LinkField":"x_kab_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kab_nama","","",""],"ParentFields":[],"ChildFields":["x_sos_kec","x_sos_desa"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kab"};
fsosialisasiview.Lists["x_sos_kab"].Data = "<?php echo $sosialisasi_view->sos_kab->LookupFilterQuery(FALSE, "view") ?>";
fsosialisasiview.Lists["x_sos_kec"] = {"LinkField":"x_kec_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kec_nama","","",""],"ParentFields":[],"ChildFields":["x_sos_desa"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kec"};
fsosialisasiview.Lists["x_sos_kec"].Data = "<?php echo $sosialisasi_view->sos_kec->LookupFilterQuery(FALSE, "view") ?>";
fsosialisasiview.Lists["x_sos_desa"] = {"LinkField":"x_desa_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_desa_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"desa"};
fsosialisasiview.Lists["x_sos_desa"].Data = "<?php echo $sosialisasi_view->sos_desa->LookupFilterQuery(FALSE, "view") ?>";

// Form object for search
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if ($sosialisasi->Export == "") { ?>
<div class="ewToolbar">
<?php $sosialisasi_view->ExportOptions->Render("body") ?>
<?php
	foreach ($sosialisasi_view->OtherOptions as &$option)
		$option->Render("body");
?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $sosialisasi_view->ShowPageHeader(); ?>
<?php
$sosialisasi_view->ShowMessage();
?>
<form name="fsosialisasiview" id="fsosialisasiview" class="form-inline ewForm ewViewForm" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($sosialisasi_view->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $sosialisasi_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sosialisasi">
<input type="hidden" name="modal" value="<?php echo intval($sosialisasi_view->IsModal) ?>">
<table class="table table-striped table-bordered table-hover table-condensed ewViewTable">
<?php if ($sosialisasi->sos_id->Visible) { // sos_id ?>
	<tr id="r_sos_id">
		<td class="col-sm-2"><span id="elh_sosialisasi_sos_id"><?php echo $sosialisasi->sos_id->FldCaption() ?></span></td>
		<td data-name="sos_id"<?php echo $sosialisasi->sos_id->CellAttributes() ?>>
<span id="el_sosialisasi_sos_id">
<span<?php echo $sosialisasi->sos_id->ViewAttributes() ?>>
<?php echo $sosialisasi->sos_id->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sosialisasi->sos_tgl->Visible) { // sos_tgl ?>
	<tr id="r_sos_tgl">
		<td class="col-sm-2"><span id="elh_sosialisasi_sos_tgl"><?php echo $sosialisasi->sos_tgl->FldCaption() ?></span></td>
		<td data-name="sos_tgl"<?php echo $sosialisasi->sos_tgl->CellAttributes() ?>>
<span id="el_sosialisasi_sos_tgl">
<span<?php echo $sosialisasi->sos_tgl->ViewAttributes() ?>>
<?php echo $sosialisasi->sos_tgl->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sosialisasi->sos_co->Visible) { // sos_co ?>
	<tr id="r_sos_co">
		<td class="col-sm-2"><span id="elh_sosialisasi_sos_co"><?php echo $sosialisasi->sos_co->FldCaption() ?></span></td>
		<td data-name="sos_co"<?php echo $sosialisasi->sos_co->CellAttributes() ?>>
<span id="el_sosialisasi_sos_co">
<span<?php echo $sosialisasi->sos_co->ViewAttributes() ?>>
<?php echo $sosialisasi->sos_co->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sosialisasi->sos_peserta->Visible) { // sos_peserta ?>
	<tr id="r_sos_peserta">
		<td class="col-sm-2"><span id="elh_sosialisasi_sos_peserta"><?php echo $sosialisasi->sos_peserta->FldCaption() ?></span></td>
		<td data-name="sos_peserta"<?php echo $sosialisasi->sos_peserta->CellAttributes() ?>>
<span id="el_sosialisasi_sos_peserta">
<span<?php echo $sosialisasi->sos_peserta->ViewAttributes() ?>>
<?php echo $sosialisasi->sos_peserta->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sosialisasi->sos_prov->Visible) { // sos_prov ?>
	<tr id="r_sos_prov">
		<td class="col-sm-2"><span id="elh_sosialisasi_sos_prov"><?php echo $sosialisasi->sos_prov->FldCaption() ?></span></td>
		<td data-name="sos_prov"<?php echo $sosialisasi->sos_prov->CellAttributes() ?>>
<span id="el_sosialisasi_sos_prov">
<span<?php echo $sosialisasi->sos_prov->ViewAttributes() ?>>
<?php echo $sosialisasi->sos_prov->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sosialisasi->sos_kab->Visible) { // sos_kab ?>
	<tr id="r_sos_kab">
		<td class="col-sm-2"><span id="elh_sosialisasi_sos_kab"><?php echo $sosialisasi->sos_kab->FldCaption() ?></span></td>
		<td data-name="sos_kab"<?php echo $sosialisasi->sos_kab->CellAttributes() ?>>
<span id="el_sosialisasi_sos_kab">
<span<?php echo $sosialisasi->sos_kab->ViewAttributes() ?>>
<?php echo $sosialisasi->sos_kab->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sosialisasi->sos_kec->Visible) { // sos_kec ?>
	<tr id="r_sos_kec">
		<td class="col-sm-2"><span id="elh_sosialisasi_sos_kec"><?php echo $sosialisasi->sos_kec->FldCaption() ?></span></td>
		<td data-name="sos_kec"<?php echo $sosialisasi->sos_kec->CellAttributes() ?>>
<span id="el_sosialisasi_sos_kec">
<span<?php echo $sosialisasi->sos_kec->ViewAttributes() ?>>
<?php echo $sosialisasi->sos_kec->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sosialisasi->sos_desa->Visible) { // sos_desa ?>
	<tr id="r_sos_desa">
		<td class="col-sm-2"><span id="elh_sosialisasi_sos_desa"><?php echo $sosialisasi->sos_desa->FldCaption() ?></span></td>
		<td data-name="sos_desa"<?php echo $sosialisasi->sos_desa->CellAttributes() ?>>
<span id="el_sosialisasi_sos_desa">
<span<?php echo $sosialisasi->sos_desa->ViewAttributes() ?>>
<?php echo $sosialisasi->sos_desa->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sosialisasi->sos_alamat->Visible) { // sos_alamat ?>
	<tr id="r_sos_alamat">
		<td class="col-sm-2"><span id="elh_sosialisasi_sos_alamat"><?php echo $sosialisasi->sos_alamat->FldCaption() ?></span></td>
		<td data-name="sos_alamat"<?php echo $sosialisasi->sos_alamat->CellAttributes() ?>>
<span id="el_sosialisasi_sos_alamat">
<span<?php echo $sosialisasi->sos_alamat->ViewAttributes() ?>>
<?php echo $sosialisasi->sos_alamat->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sosialisasi->sos_pot_lahan->Visible) { // sos_pot_lahan ?>
	<tr id="r_sos_pot_lahan">
		<td class="col-sm-2"><span id="elh_sosialisasi_sos_pot_lahan"><?php echo $sosialisasi->sos_pot_lahan->FldCaption() ?></span></td>
		<td data-name="sos_pot_lahan"<?php echo $sosialisasi->sos_pot_lahan->CellAttributes() ?>>
<span id="el_sosialisasi_sos_pot_lahan">
<span<?php echo $sosialisasi->sos_pot_lahan->ViewAttributes() ?>>
<?php echo $sosialisasi->sos_pot_lahan->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sosialisasi->sos_katinggian->Visible) { // sos_katinggian ?>
	<tr id="r_sos_katinggian">
		<td class="col-sm-2"><span id="elh_sosialisasi_sos_katinggian"><?php echo $sosialisasi->sos_katinggian->FldCaption() ?></span></td>
		<td data-name="sos_katinggian"<?php echo $sosialisasi->sos_katinggian->CellAttributes() ?>>
<span id="el_sosialisasi_sos_katinggian">
<span<?php echo $sosialisasi->sos_katinggian->ViewAttributes() ?>>
<?php echo $sosialisasi->sos_katinggian->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sosialisasi->sos_biaya->Visible) { // sos_biaya ?>
	<tr id="r_sos_biaya">
		<td class="col-sm-2"><span id="elh_sosialisasi_sos_biaya"><?php echo $sosialisasi->sos_biaya->FldCaption() ?></span></td>
		<td data-name="sos_biaya"<?php echo $sosialisasi->sos_biaya->CellAttributes() ?>>
<span id="el_sosialisasi_sos_biaya">
<span<?php echo $sosialisasi->sos_biaya->ViewAttributes() ?>>
<?php echo $sosialisasi->sos_biaya->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sosialisasi->sos_kesimpulan->Visible) { // sos_kesimpulan ?>
	<tr id="r_sos_kesimpulan">
		<td class="col-sm-2"><span id="elh_sosialisasi_sos_kesimpulan"><?php echo $sosialisasi->sos_kesimpulan->FldCaption() ?></span></td>
		<td data-name="sos_kesimpulan"<?php echo $sosialisasi->sos_kesimpulan->CellAttributes() ?>>
<span id="el_sosialisasi_sos_kesimpulan">
<span<?php echo $sosialisasi->sos_kesimpulan->ViewAttributes() ?>>
<?php echo $sosialisasi->sos_kesimpulan->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sosialisasi->sos_foto->Visible) { // sos_foto ?>
	<tr id="r_sos_foto">
		<td class="col-sm-2"><span id="elh_sosialisasi_sos_foto"><?php echo $sosialisasi->sos_foto->FldCaption() ?></span></td>
		<td data-name="sos_foto"<?php echo $sosialisasi->sos_foto->CellAttributes() ?>>
<span id="el_sosialisasi_sos_foto">
<span>
<?php echo ew_GetFileViewTag($sosialisasi->sos_foto, $sosialisasi->sos_foto->ViewValue) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php if ($sosialisasi->Export == "") { ?>
<script type="text/javascript">
fsosialisasiview.Init();
</script>
<?php } ?>
<?php
$sosialisasi_view->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<?php if ($sosialisasi->Export == "") { ?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$sosialisasi_view->Page_Terminate();
?>
