<?php
if (session_id() == "") session_start(); // Init session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg14.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql14.php") ?>
<?php include_once "phpfn14.php" ?>
<?php include_once "sosialisasiinfo.php" ?>
<?php include_once "employeesinfo.php" ?>
<?php include_once "userfn14.php" ?>
<?php

//
// Page class
//

$sosialisasi_list = NULL; // Initialize page object first

class csosialisasi_list extends csosialisasi {

	// Page ID
	var $PageID = 'list';

	// Project ID
	var $ProjectID = '{CC60B42B-604B-412A-B014-2315920AF6AA}';

	// Table name
	var $TableName = 'sosialisasi';

	// Page object name
	var $PageObjName = 'sosialisasi_list';

	// Grid form hidden field names
	var $FormName = 'fsosialisasilist';
	var $FormActionName = 'k_action';
	var $FormKeyName = 'k_key';
	var $FormOldKeyName = 'k_oldkey';
	var $FormBlankRowName = 'k_blankrow';
	var $FormKeyCountName = 'key_count';

	// Page headings
	var $Heading = '';
	var $Subheading = '';

	// Page heading
	function PageHeading() {
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->TableCaption();
		return "";
	}

	// Page subheading
	function PageSubheading() {
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->Phrase($this->PageID);
		return "";
	}

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;
	var $ExportPdfUrl;

	// Custom export
	var $ExportExcelCustom = FALSE;
	var $ExportWordCustom = FALSE;
	var $ExportPdfCustom = FALSE;
	var $ExportEmailCustom = FALSE;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (sosialisasi)
		if (!isset($GLOBALS["sosialisasi"]) || get_class($GLOBALS["sosialisasi"]) == "csosialisasi") {
			$GLOBALS["sosialisasi"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["sosialisasi"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->PageUrl() . "export=print";
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel";
		$this->ExportWordUrl = $this->PageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->PageUrl() . "export=html";
		$this->ExportXmlUrl = $this->PageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->PageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf";
		$this->AddUrl = "sosialisasiadd.php";
		$this->InlineAddUrl = $this->PageUrl() . "a=add";
		$this->GridAddUrl = $this->PageUrl() . "a=gridadd";
		$this->GridEditUrl = $this->PageUrl() . "a=gridedit";
		$this->MultiDeleteUrl = "sosialisasidelete.php";
		$this->MultiUpdateUrl = "sosialisasiupdate.php";

		// Table object (employees)
		if (!isset($GLOBALS['employees'])) $GLOBALS['employees'] = new cemployees();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'list', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'sosialisasi', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"]))
			$GLOBALS["gTimer"] = new cTimer();

		// Debug message
		ew_LoadDebugMsg();

		// Open connection
		if (!isset($conn))
			$conn = ew_Connect($this->DBID);

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new cemployees();
			$UserTableConn = Conn($UserTable->DBID);
		}

		// List options
		$this->ListOptions = new cListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new cListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Other options
		$this->OtherOptions['addedit'] = new cListOptions();
		$this->OtherOptions['addedit']->Tag = "div";
		$this->OtherOptions['addedit']->TagClassName = "ewAddEditOption";
		$this->OtherOptions['detail'] = new cListOptions();
		$this->OtherOptions['detail']->Tag = "div";
		$this->OtherOptions['detail']->TagClassName = "ewDetailOption";
		$this->OtherOptions['action'] = new cListOptions();
		$this->OtherOptions['action']->Tag = "div";
		$this->OtherOptions['action']->TagClassName = "ewActionOption";

		// Filter options
		$this->FilterOptions = new cListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ewFilterOption fsosialisasilistsrch";

		// List actions
		$this->ListActions = new cListActions();
	}

	//
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// User profile
		$UserProfile = new cUserProfile();

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanList()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			$this->Page_Terminate(ew_GetUrl("index.php"));
		}

		// NOTE: Security object may be needed in other part of the script, skip set to Nothing
		// 
		// Security = null;
		// 
		// Get export parameters

		$custom = "";
		if (@$_GET["export"] <> "") {
			$this->Export = $_GET["export"];
			$custom = @$_GET["custom"];
		} elseif (@$_POST["export"] <> "") {
			$this->Export = $_POST["export"];
			$custom = @$_POST["custom"];
		} elseif (ew_IsPost()) {
			if (@$_POST["exporttype"] <> "")
				$this->Export = $_POST["exporttype"];
			$custom = @$_POST["custom"];
		} elseif (@$_GET["cmd"] == "json") {
			$this->Export = $_GET["cmd"];
		} else {
			$this->setExportReturnUrl(ew_CurrentUrl());
		}
		$gsExportFile = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->Export <> "" && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$gsCustomExport = $this->CustomExport;
		$gsExport = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined("EW_USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined("EW_USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action

		// Get grid add count
		$gridaddcnt = @$_GET[EW_TABLE_GRID_ADD_ROW_COUNT];
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->SetupListOptions();

		// Setup export options
		$this->SetupExportOptions();
		$this->sos_id->SetVisibility();
		if ($this->IsAdd() || $this->IsCopy() || $this->IsGridAdd())
			$this->sos_id->Visible = FALSE;
		$this->sos_tgl->SetVisibility();
		$this->sos_co->SetVisibility();
		$this->sos_peserta->SetVisibility();
		$this->sos_prov->SetVisibility();
		$this->sos_kab->SetVisibility();
		$this->sos_kec->SetVisibility();
		$this->sos_desa->SetVisibility();
		$this->sos_alamat->SetVisibility();
		$this->sos_pot_lahan->SetVisibility();
		$this->sos_katinggian->SetVisibility();
		$this->sos_biaya->SetVisibility();
		$this->sos_kesimpulan->SetVisibility();
		$this->sos_foto->SetVisibility();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();

		// Setup other options
		$this->SetupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->Add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == EW_ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $sosialisasi;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($sosialisasi);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		// Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			ew_SaveDebugMsg();
			header("Location: " . $url);
		}
		exit();
	}

	// Class variables
	var $ListOptions; // List options
	var $ExportOptions; // Export options
	var $SearchOptions; // Search options
	var $OtherOptions = array(); // Other options
	var $FilterOptions; // Filter options
	var $ListActions; // List actions
	var $SelectedCount = 0;
	var $SelectedIndex = 0;
	var $DisplayRecs = 100;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $Pager;
	var $AutoHidePager = EW_AUTO_HIDE_PAGER;
	var $AutoHidePageSizeSelector = EW_AUTO_HIDE_PAGE_SIZE_SELECTOR;
	var $DefaultSearchWhere = ""; // Default search WHERE clause
	var $SearchWhere = ""; // Search WHERE clause
	var $RecCnt = 0; // Record count
	var $EditRowCnt;
	var $StartRowCnt = 1;
	var $RowCnt = 0;
	var $Attrs = array(); // Row attributes and cell attributes
	var $RowIndex = 0; // Row index
	var $KeyCount = 0; // Key count
	var $RowAction = ""; // Row action
	var $RowOldKey = ""; // Row old key (for copy)
	var $RecPerRow = 0;
	var $MultiColumnClass;
	var $MultiColumnEditClass = "col-sm-12";
	var $MultiColumnCnt = 12;
	var $MultiColumnEditCnt = 12;
	var $GridCnt = 0;
	var $ColCnt = 0;
	var $DbMasterFilter = ""; // Master filter
	var $DbDetailFilter = ""; // Detail filter
	var $MasterRecordExists;
	var $MultiSelectKey;
	var $Command;
	var $RestoreSearch = FALSE;
	var $DetailPages;
	var $Recordset;
	var $OldRecordset;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError, $gsSearchError, $Security, $EW_EXPORT;

		// Search filters
		$sSrchAdvanced = ""; // Advanced search filter
		$sSrchBasic = ""; // Basic search filter
		$sFilter = "";

		// Get command
		$this->Command = strtolower(@$_GET["cmd"]);
		if ($this->IsPageRequest()) { // Validate request

			// Process list action first
			if ($this->ProcessListAction()) // Ajax request
				$this->Page_Terminate();

			// Handle reset command
			$this->ResetCmd();

			// Set up Breadcrumb
			if ($this->Export == "")
				$this->SetupBreadcrumb();

			// Hide list options
			if ($this->Export <> "") {
				$this->ListOptions->HideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->CurrentAction == "gridadd" || $this->CurrentAction == "gridedit") {
				$this->ListOptions->HideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->Export <> "" || $this->CurrentAction <> "") {
				$this->ExportOptions->HideAllOptions();
				$this->FilterOptions->HideAllOptions();
			}

			// Hide other options
			if ($this->Export <> "") {
				foreach ($this->OtherOptions as &$option)
					$option->HideAllOptions();
			}

			// Get default search criteria
			ew_AddFilter($this->DefaultSearchWhere, $this->BasicSearchWhere(TRUE));
			ew_AddFilter($this->DefaultSearchWhere, $this->AdvancedSearchWhere(TRUE));

			// Get basic search values
			$this->LoadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->LoadSearchValues(); // Get search values

			// Process filter list
			$this->ProcessFilterList();
			if (!$this->ValidateSearch())
				$this->setFailureMessage($gsSearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->Export <> "" || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->CheckSearchParms())
				$this->RestoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->SetupSortOrder();

			// Get basic search criteria
			if ($gsSearchError == "")
				$sSrchBasic = $this->BasicSearchWhere();

			// Get search criteria for advanced search
			if ($gsSearchError == "")
				$sSrchAdvanced = $this->AdvancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 100; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->LoadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->CheckSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->LoadDefault();
			if ($this->BasicSearch->Keyword != "")
				$sSrchBasic = $this->BasicSearchWhere();

			// Load advanced search from default
			if ($this->LoadAdvancedSearchDefault()) {
				$sSrchAdvanced = $this->AdvancedSearchWhere();
			}
		}

		// Build search criteria
		ew_AddFilter($this->SearchWhere, $sSrchAdvanced);
		ew_AddFilter($this->SearchWhere, $sSrchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$sFilter = "";
		if (!$Security->CanList())
			$sFilter = "(0=1)"; // Filter all records
		ew_AddFilter($sFilter, $this->DbDetailFilter);
		ew_AddFilter($sFilter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSQL = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $sFilter;
		} else {
			$this->setSessionWhere($sFilter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if ($this->CustomExport == "" && in_array($this->Export, array_keys($EW_EXPORT))) {
			$this->ExportData();
			$this->Page_Terminate(); // Terminate response
			exit();
		}

		// Load record count first
		if (!$this->IsAddOrEdit()) {
			$bSelectLimit = $this->UseSelectLimit;
			if ($bSelectLimit) {
				$this->TotalRecs = $this->ListRecordCount();
			} else {
				if ($this->Recordset = $this->LoadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
		}

		// Search options
		$this->SetupSearchOptions();
	}

	// Build filter for all keys
	function BuildKeyFilter() {
		global $objForm;
		$sWrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$objForm->Index = $rowindex;
		$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		while ($sThisKey <> "") {
			if ($this->SetupKeyValues($sThisKey)) {
				$sFilter = $this->KeyFilter();
				if ($sWrkFilter <> "") $sWrkFilter .= " OR ";
				$sWrkFilter .= $sFilter;
			} else {
				$sWrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$objForm->Index = $rowindex;
			$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		}
		return $sWrkFilter;
	}

	// Set up key values
	function SetupKeyValues($key) {
		$arrKeyFlds = explode($GLOBALS["EW_COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arrKeyFlds) >= 1) {
			$this->sos_id->setFormValue($arrKeyFlds[0]);
			if (!is_numeric($this->sos_id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	function GetFilterList() {
		global $UserProfile;

		// Initialize
		$sFilterList = "";
		$sSavedFilterList = "";
		$sFilterList = ew_Concat($sFilterList, $this->sos_id->AdvancedSearch->ToJson(), ","); // Field sos_id
		$sFilterList = ew_Concat($sFilterList, $this->sos_tgl->AdvancedSearch->ToJson(), ","); // Field sos_tgl
		$sFilterList = ew_Concat($sFilterList, $this->sos_co->AdvancedSearch->ToJson(), ","); // Field sos_co
		$sFilterList = ew_Concat($sFilterList, $this->sos_peserta->AdvancedSearch->ToJson(), ","); // Field sos_peserta
		$sFilterList = ew_Concat($sFilterList, $this->sos_prov->AdvancedSearch->ToJson(), ","); // Field sos_prov
		$sFilterList = ew_Concat($sFilterList, $this->sos_kab->AdvancedSearch->ToJson(), ","); // Field sos_kab
		$sFilterList = ew_Concat($sFilterList, $this->sos_kec->AdvancedSearch->ToJson(), ","); // Field sos_kec
		$sFilterList = ew_Concat($sFilterList, $this->sos_desa->AdvancedSearch->ToJson(), ","); // Field sos_desa
		$sFilterList = ew_Concat($sFilterList, $this->sos_alamat->AdvancedSearch->ToJson(), ","); // Field sos_alamat
		$sFilterList = ew_Concat($sFilterList, $this->sos_pot_lahan->AdvancedSearch->ToJson(), ","); // Field sos_pot_lahan
		$sFilterList = ew_Concat($sFilterList, $this->sos_katinggian->AdvancedSearch->ToJson(), ","); // Field sos_katinggian
		$sFilterList = ew_Concat($sFilterList, $this->sos_biaya->AdvancedSearch->ToJson(), ","); // Field sos_biaya
		$sFilterList = ew_Concat($sFilterList, $this->sos_kesimpulan->AdvancedSearch->ToJson(), ","); // Field sos_kesimpulan
		$sFilterList = ew_Concat($sFilterList, $this->sos_foto->AdvancedSearch->ToJson(), ","); // Field sos_foto
		if ($this->BasicSearch->Keyword <> "") {
			$sWrk = "\"" . EW_TABLE_BASIC_SEARCH . "\":\"" . ew_JsEncode2($this->BasicSearch->Keyword) . "\",\"" . EW_TABLE_BASIC_SEARCH_TYPE . "\":\"" . ew_JsEncode2($this->BasicSearch->Type) . "\"";
			$sFilterList = ew_Concat($sFilterList, $sWrk, ",");
		}
		$sFilterList = preg_replace('/,$/', "", $sFilterList);

		// Return filter list in json
		if ($sFilterList <> "")
			$sFilterList = "\"data\":{" . $sFilterList . "}";
		if ($sSavedFilterList <> "") {
			if ($sFilterList <> "")
				$sFilterList .= ",";
			$sFilterList .= "\"filters\":" . $sSavedFilterList;
		}
		return ($sFilterList <> "") ? "{" . $sFilterList . "}" : "null";
	}

	// Process filter list
	function ProcessFilterList() {
		global $UserProfile;
		if (@$_POST["ajax"] == "savefilters") { // Save filter request (Ajax)
			$filters = @$_POST["filters"];
			$UserProfile->SetSearchFilters(CurrentUserName(), "fsosialisasilistsrch", $filters);

			// Clean output buffer
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			echo ew_ArrayToJson(array(array("success" => TRUE))); // Success
			$this->Page_Terminate();
			exit();
		} elseif (@$_POST["cmd"] == "resetfilter") {
			$this->RestoreFilterList();
		}
	}

	// Restore list of filters
	function RestoreFilterList() {

		// Return if not reset filter
		if (@$_POST["cmd"] <> "resetfilter")
			return FALSE;
		$filter = json_decode(@$_POST["filter"], TRUE);
		$this->Command = "search";

		// Field sos_id
		$this->sos_id->AdvancedSearch->SearchValue = @$filter["x_sos_id"];
		$this->sos_id->AdvancedSearch->SearchOperator = @$filter["z_sos_id"];
		$this->sos_id->AdvancedSearch->SearchCondition = @$filter["v_sos_id"];
		$this->sos_id->AdvancedSearch->SearchValue2 = @$filter["y_sos_id"];
		$this->sos_id->AdvancedSearch->SearchOperator2 = @$filter["w_sos_id"];
		$this->sos_id->AdvancedSearch->Save();

		// Field sos_tgl
		$this->sos_tgl->AdvancedSearch->SearchValue = @$filter["x_sos_tgl"];
		$this->sos_tgl->AdvancedSearch->SearchOperator = @$filter["z_sos_tgl"];
		$this->sos_tgl->AdvancedSearch->SearchCondition = @$filter["v_sos_tgl"];
		$this->sos_tgl->AdvancedSearch->SearchValue2 = @$filter["y_sos_tgl"];
		$this->sos_tgl->AdvancedSearch->SearchOperator2 = @$filter["w_sos_tgl"];
		$this->sos_tgl->AdvancedSearch->Save();

		// Field sos_co
		$this->sos_co->AdvancedSearch->SearchValue = @$filter["x_sos_co"];
		$this->sos_co->AdvancedSearch->SearchOperator = @$filter["z_sos_co"];
		$this->sos_co->AdvancedSearch->SearchCondition = @$filter["v_sos_co"];
		$this->sos_co->AdvancedSearch->SearchValue2 = @$filter["y_sos_co"];
		$this->sos_co->AdvancedSearch->SearchOperator2 = @$filter["w_sos_co"];
		$this->sos_co->AdvancedSearch->Save();

		// Field sos_peserta
		$this->sos_peserta->AdvancedSearch->SearchValue = @$filter["x_sos_peserta"];
		$this->sos_peserta->AdvancedSearch->SearchOperator = @$filter["z_sos_peserta"];
		$this->sos_peserta->AdvancedSearch->SearchCondition = @$filter["v_sos_peserta"];
		$this->sos_peserta->AdvancedSearch->SearchValue2 = @$filter["y_sos_peserta"];
		$this->sos_peserta->AdvancedSearch->SearchOperator2 = @$filter["w_sos_peserta"];
		$this->sos_peserta->AdvancedSearch->Save();

		// Field sos_prov
		$this->sos_prov->AdvancedSearch->SearchValue = @$filter["x_sos_prov"];
		$this->sos_prov->AdvancedSearch->SearchOperator = @$filter["z_sos_prov"];
		$this->sos_prov->AdvancedSearch->SearchCondition = @$filter["v_sos_prov"];
		$this->sos_prov->AdvancedSearch->SearchValue2 = @$filter["y_sos_prov"];
		$this->sos_prov->AdvancedSearch->SearchOperator2 = @$filter["w_sos_prov"];
		$this->sos_prov->AdvancedSearch->Save();

		// Field sos_kab
		$this->sos_kab->AdvancedSearch->SearchValue = @$filter["x_sos_kab"];
		$this->sos_kab->AdvancedSearch->SearchOperator = @$filter["z_sos_kab"];
		$this->sos_kab->AdvancedSearch->SearchCondition = @$filter["v_sos_kab"];
		$this->sos_kab->AdvancedSearch->SearchValue2 = @$filter["y_sos_kab"];
		$this->sos_kab->AdvancedSearch->SearchOperator2 = @$filter["w_sos_kab"];
		$this->sos_kab->AdvancedSearch->Save();

		// Field sos_kec
		$this->sos_kec->AdvancedSearch->SearchValue = @$filter["x_sos_kec"];
		$this->sos_kec->AdvancedSearch->SearchOperator = @$filter["z_sos_kec"];
		$this->sos_kec->AdvancedSearch->SearchCondition = @$filter["v_sos_kec"];
		$this->sos_kec->AdvancedSearch->SearchValue2 = @$filter["y_sos_kec"];
		$this->sos_kec->AdvancedSearch->SearchOperator2 = @$filter["w_sos_kec"];
		$this->sos_kec->AdvancedSearch->Save();

		// Field sos_desa
		$this->sos_desa->AdvancedSearch->SearchValue = @$filter["x_sos_desa"];
		$this->sos_desa->AdvancedSearch->SearchOperator = @$filter["z_sos_desa"];
		$this->sos_desa->AdvancedSearch->SearchCondition = @$filter["v_sos_desa"];
		$this->sos_desa->AdvancedSearch->SearchValue2 = @$filter["y_sos_desa"];
		$this->sos_desa->AdvancedSearch->SearchOperator2 = @$filter["w_sos_desa"];
		$this->sos_desa->AdvancedSearch->Save();

		// Field sos_alamat
		$this->sos_alamat->AdvancedSearch->SearchValue = @$filter["x_sos_alamat"];
		$this->sos_alamat->AdvancedSearch->SearchOperator = @$filter["z_sos_alamat"];
		$this->sos_alamat->AdvancedSearch->SearchCondition = @$filter["v_sos_alamat"];
		$this->sos_alamat->AdvancedSearch->SearchValue2 = @$filter["y_sos_alamat"];
		$this->sos_alamat->AdvancedSearch->SearchOperator2 = @$filter["w_sos_alamat"];
		$this->sos_alamat->AdvancedSearch->Save();

		// Field sos_pot_lahan
		$this->sos_pot_lahan->AdvancedSearch->SearchValue = @$filter["x_sos_pot_lahan"];
		$this->sos_pot_lahan->AdvancedSearch->SearchOperator = @$filter["z_sos_pot_lahan"];
		$this->sos_pot_lahan->AdvancedSearch->SearchCondition = @$filter["v_sos_pot_lahan"];
		$this->sos_pot_lahan->AdvancedSearch->SearchValue2 = @$filter["y_sos_pot_lahan"];
		$this->sos_pot_lahan->AdvancedSearch->SearchOperator2 = @$filter["w_sos_pot_lahan"];
		$this->sos_pot_lahan->AdvancedSearch->Save();

		// Field sos_katinggian
		$this->sos_katinggian->AdvancedSearch->SearchValue = @$filter["x_sos_katinggian"];
		$this->sos_katinggian->AdvancedSearch->SearchOperator = @$filter["z_sos_katinggian"];
		$this->sos_katinggian->AdvancedSearch->SearchCondition = @$filter["v_sos_katinggian"];
		$this->sos_katinggian->AdvancedSearch->SearchValue2 = @$filter["y_sos_katinggian"];
		$this->sos_katinggian->AdvancedSearch->SearchOperator2 = @$filter["w_sos_katinggian"];
		$this->sos_katinggian->AdvancedSearch->Save();

		// Field sos_biaya
		$this->sos_biaya->AdvancedSearch->SearchValue = @$filter["x_sos_biaya"];
		$this->sos_biaya->AdvancedSearch->SearchOperator = @$filter["z_sos_biaya"];
		$this->sos_biaya->AdvancedSearch->SearchCondition = @$filter["v_sos_biaya"];
		$this->sos_biaya->AdvancedSearch->SearchValue2 = @$filter["y_sos_biaya"];
		$this->sos_biaya->AdvancedSearch->SearchOperator2 = @$filter["w_sos_biaya"];
		$this->sos_biaya->AdvancedSearch->Save();

		// Field sos_kesimpulan
		$this->sos_kesimpulan->AdvancedSearch->SearchValue = @$filter["x_sos_kesimpulan"];
		$this->sos_kesimpulan->AdvancedSearch->SearchOperator = @$filter["z_sos_kesimpulan"];
		$this->sos_kesimpulan->AdvancedSearch->SearchCondition = @$filter["v_sos_kesimpulan"];
		$this->sos_kesimpulan->AdvancedSearch->SearchValue2 = @$filter["y_sos_kesimpulan"];
		$this->sos_kesimpulan->AdvancedSearch->SearchOperator2 = @$filter["w_sos_kesimpulan"];
		$this->sos_kesimpulan->AdvancedSearch->Save();

		// Field sos_foto
		$this->sos_foto->AdvancedSearch->SearchValue = @$filter["x_sos_foto"];
		$this->sos_foto->AdvancedSearch->SearchOperator = @$filter["z_sos_foto"];
		$this->sos_foto->AdvancedSearch->SearchCondition = @$filter["v_sos_foto"];
		$this->sos_foto->AdvancedSearch->SearchValue2 = @$filter["y_sos_foto"];
		$this->sos_foto->AdvancedSearch->SearchOperator2 = @$filter["w_sos_foto"];
		$this->sos_foto->AdvancedSearch->Save();
		$this->BasicSearch->setKeyword(@$filter[EW_TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[EW_TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	function AdvancedSearchWhere($Default = FALSE) {
		global $Security;
		$sWhere = "";
		if (!$Security->CanSearch()) return "";
		$this->BuildSearchSql($sWhere, $this->sos_id, $Default, FALSE); // sos_id
		$this->BuildSearchSql($sWhere, $this->sos_tgl, $Default, FALSE); // sos_tgl
		$this->BuildSearchSql($sWhere, $this->sos_co, $Default, FALSE); // sos_co
		$this->BuildSearchSql($sWhere, $this->sos_peserta, $Default, TRUE); // sos_peserta
		$this->BuildSearchSql($sWhere, $this->sos_prov, $Default, FALSE); // sos_prov
		$this->BuildSearchSql($sWhere, $this->sos_kab, $Default, FALSE); // sos_kab
		$this->BuildSearchSql($sWhere, $this->sos_kec, $Default, FALSE); // sos_kec
		$this->BuildSearchSql($sWhere, $this->sos_desa, $Default, FALSE); // sos_desa
		$this->BuildSearchSql($sWhere, $this->sos_alamat, $Default, FALSE); // sos_alamat
		$this->BuildSearchSql($sWhere, $this->sos_pot_lahan, $Default, FALSE); // sos_pot_lahan
		$this->BuildSearchSql($sWhere, $this->sos_katinggian, $Default, FALSE); // sos_katinggian
		$this->BuildSearchSql($sWhere, $this->sos_biaya, $Default, FALSE); // sos_biaya
		$this->BuildSearchSql($sWhere, $this->sos_kesimpulan, $Default, FALSE); // sos_kesimpulan
		$this->BuildSearchSql($sWhere, $this->sos_foto, $Default, FALSE); // sos_foto

		// Set up search parm
		if (!$Default && $sWhere <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$Default && $this->Command == "search") {
			$this->sos_id->AdvancedSearch->Save(); // sos_id
			$this->sos_tgl->AdvancedSearch->Save(); // sos_tgl
			$this->sos_co->AdvancedSearch->Save(); // sos_co
			$this->sos_peserta->AdvancedSearch->Save(); // sos_peserta
			$this->sos_prov->AdvancedSearch->Save(); // sos_prov
			$this->sos_kab->AdvancedSearch->Save(); // sos_kab
			$this->sos_kec->AdvancedSearch->Save(); // sos_kec
			$this->sos_desa->AdvancedSearch->Save(); // sos_desa
			$this->sos_alamat->AdvancedSearch->Save(); // sos_alamat
			$this->sos_pot_lahan->AdvancedSearch->Save(); // sos_pot_lahan
			$this->sos_katinggian->AdvancedSearch->Save(); // sos_katinggian
			$this->sos_biaya->AdvancedSearch->Save(); // sos_biaya
			$this->sos_kesimpulan->AdvancedSearch->Save(); // sos_kesimpulan
			$this->sos_foto->AdvancedSearch->Save(); // sos_foto
		}
		return $sWhere;
	}

	// Build search SQL
	function BuildSearchSql(&$Where, &$Fld, $Default, $MultiValue) {
		$FldParm = $Fld->FldParm();
		$FldVal = ($Default) ? $Fld->AdvancedSearch->SearchValueDefault : $Fld->AdvancedSearch->SearchValue; // @$_GET["x_$FldParm"]
		$FldOpr = ($Default) ? $Fld->AdvancedSearch->SearchOperatorDefault : $Fld->AdvancedSearch->SearchOperator; // @$_GET["z_$FldParm"]
		$FldCond = ($Default) ? $Fld->AdvancedSearch->SearchConditionDefault : $Fld->AdvancedSearch->SearchCondition; // @$_GET["v_$FldParm"]
		$FldVal2 = ($Default) ? $Fld->AdvancedSearch->SearchValue2Default : $Fld->AdvancedSearch->SearchValue2; // @$_GET["y_$FldParm"]
		$FldOpr2 = ($Default) ? $Fld->AdvancedSearch->SearchOperator2Default : $Fld->AdvancedSearch->SearchOperator2; // @$_GET["w_$FldParm"]
		$sWrk = "";
		if (is_array($FldVal)) $FldVal = implode(",", $FldVal);
		if (is_array($FldVal2)) $FldVal2 = implode(",", $FldVal2);
		$FldOpr = strtoupper(trim($FldOpr));
		if ($FldOpr == "") $FldOpr = "=";
		$FldOpr2 = strtoupper(trim($FldOpr2));
		if ($FldOpr2 == "") $FldOpr2 = "=";
		if (EW_SEARCH_MULTI_VALUE_OPTION == 1)
			$MultiValue = FALSE;
		if ($MultiValue) {
			$sWrk1 = ($FldVal <> "") ? ew_GetMultiSearchSql($Fld, $FldOpr, $FldVal, $this->DBID) : ""; // Field value 1
			$sWrk2 = ($FldVal2 <> "") ? ew_GetMultiSearchSql($Fld, $FldOpr2, $FldVal2, $this->DBID) : ""; // Field value 2
			$sWrk = $sWrk1; // Build final SQL
			if ($sWrk2 <> "")
				$sWrk = ($sWrk <> "") ? "($sWrk) $FldCond ($sWrk2)" : $sWrk2;
		} else {
			$FldVal = $this->ConvertSearchValue($Fld, $FldVal);
			$FldVal2 = $this->ConvertSearchValue($Fld, $FldVal2);
			$sWrk = ew_GetSearchSql($Fld, $FldVal, $FldOpr, $FldCond, $FldVal2, $FldOpr2, $this->DBID);
		}
		ew_AddFilter($Where, $sWrk);
	}

	// Convert search value
	function ConvertSearchValue(&$Fld, $FldVal) {
		if ($FldVal == EW_NULL_VALUE || $FldVal == EW_NOT_NULL_VALUE)
			return $FldVal;
		$Value = $FldVal;
		if ($Fld->FldDataType == EW_DATATYPE_BOOLEAN) {
			if ($FldVal <> "") $Value = ($FldVal == "1" || strtolower(strval($FldVal)) == "y" || strtolower(strval($FldVal)) == "t") ? $Fld->TrueValue : $Fld->FalseValue;
		} elseif ($Fld->FldDataType == EW_DATATYPE_DATE || $Fld->FldDataType == EW_DATATYPE_TIME) {
			if ($FldVal <> "") $Value = ew_UnFormatDateTime($FldVal, $Fld->FldDateTimeFormat);
		}
		return $Value;
	}

	// Return basic search SQL
	function BasicSearchSQL($arKeywords, $type) {
		$sWhere = "";
		$this->BuildBasicSearchSQL($sWhere, $this->sos_id, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->sos_tgl, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->sos_co, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->sos_peserta, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->sos_prov, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->sos_kab, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->sos_kec, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->sos_desa, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->sos_alamat, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->sos_pot_lahan, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->sos_katinggian, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->sos_biaya, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->sos_kesimpulan, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->sos_foto, $arKeywords, $type);
		return $sWhere;
	}

	// Build basic search SQL
	function BuildBasicSearchSQL(&$Where, &$Fld, $arKeywords, $type) {
		global $EW_BASIC_SEARCH_IGNORE_PATTERN;
		$sDefCond = ($type == "OR") ? "OR" : "AND";
		$arSQL = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$Keyword = $arKeywords[$i];
			$Keyword = trim($Keyword);
			if ($EW_BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$Keyword = preg_replace($EW_BASIC_SEARCH_IGNORE_PATTERN, "\\", $Keyword);
				$ar = explode("\\", $Keyword);
			} else {
				$ar = array($Keyword);
			}
			foreach ($ar as $Keyword) {
				if ($Keyword <> "") {
					$sWrk = "";
					if ($Keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j-1] = "OR";
					} elseif ($Keyword == EW_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NULL";
					} elseif ($Keyword == EW_NOT_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NOT NULL";
					} elseif ($Fld->FldIsVirtual) {
						$sWrk = $Fld->FldVirtualExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					} elseif ($Fld->FldDataType != EW_DATATYPE_NUMBER || is_numeric($Keyword)) {
						$sWrk = $Fld->FldBasicSearchExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					}
					if ($sWrk <> "") {
						$arSQL[$j] = $sWrk;
						$arCond[$j] = $sDefCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSQL);
		$bQuoted = FALSE;
		$sSql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt-1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$bQuoted) $sSql .= "(";
					$bQuoted = TRUE;
				}
				$sSql .= $arSQL[$i];
				if ($bQuoted && $arCond[$i] <> "OR") {
					$sSql .= ")";
					$bQuoted = FALSE;
				}
				$sSql .= " " . $arCond[$i] . " ";
			}
			$sSql .= $arSQL[$cnt-1];
			if ($bQuoted)
				$sSql .= ")";
		}
		if ($sSql <> "") {
			if ($Where <> "") $Where .= " OR ";
			$Where .= "(" . $sSql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	function BasicSearchWhere($Default = FALSE) {
		global $Security;
		$sSearchStr = "";
		if (!$Security->CanSearch()) return "";
		$sSearchKeyword = ($Default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$sSearchType = ($Default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($sSearchKeyword <> "") {
			$ar = $this->BasicSearch->KeywordList($Default);

			// Search keyword in any fields
			if (($sSearchType == "OR" || $sSearchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $sKeyword) {
					if ($sKeyword <> "") {
						if ($sSearchStr <> "") $sSearchStr .= " " . $sSearchType . " ";
						$sSearchStr .= "(" . $this->BasicSearchSQL(array($sKeyword), $sSearchType) . ")";
					}
				}
			} else {
				$sSearchStr = $this->BasicSearchSQL($ar, $sSearchType);
			}
			if (!$Default && in_array($this->Command, array("", "reset", "resetall"))) $this->Command = "search";
		}
		if (!$Default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($sSearchKeyword);
			$this->BasicSearch->setType($sSearchType);
		}
		return $sSearchStr;
	}

	// Check if search parm exists
	function CheckSearchParms() {

		// Check basic search
		if ($this->BasicSearch->IssetSession())
			return TRUE;
		if ($this->sos_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->sos_tgl->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->sos_co->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->sos_peserta->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->sos_prov->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->sos_kab->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->sos_kec->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->sos_desa->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->sos_alamat->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->sos_pot_lahan->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->sos_katinggian->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->sos_biaya->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->sos_kesimpulan->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->sos_foto->AdvancedSearch->IssetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	function ResetSearchParms() {

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->ResetBasicSearchParms();

		// Clear advanced search parameters
		$this->ResetAdvancedSearchParms();
	}

	// Load advanced search default values
	function LoadAdvancedSearchDefault() {
		return FALSE;
	}

	// Clear all basic search parameters
	function ResetBasicSearchParms() {
		$this->BasicSearch->UnsetSession();
	}

	// Clear all advanced search parameters
	function ResetAdvancedSearchParms() {
		$this->sos_id->AdvancedSearch->UnsetSession();
		$this->sos_tgl->AdvancedSearch->UnsetSession();
		$this->sos_co->AdvancedSearch->UnsetSession();
		$this->sos_peserta->AdvancedSearch->UnsetSession();
		$this->sos_prov->AdvancedSearch->UnsetSession();
		$this->sos_kab->AdvancedSearch->UnsetSession();
		$this->sos_kec->AdvancedSearch->UnsetSession();
		$this->sos_desa->AdvancedSearch->UnsetSession();
		$this->sos_alamat->AdvancedSearch->UnsetSession();
		$this->sos_pot_lahan->AdvancedSearch->UnsetSession();
		$this->sos_katinggian->AdvancedSearch->UnsetSession();
		$this->sos_biaya->AdvancedSearch->UnsetSession();
		$this->sos_kesimpulan->AdvancedSearch->UnsetSession();
		$this->sos_foto->AdvancedSearch->UnsetSession();
	}

	// Restore all search parameters
	function RestoreSearchParms() {
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->Load();

		// Restore advanced search values
		$this->sos_id->AdvancedSearch->Load();
		$this->sos_tgl->AdvancedSearch->Load();
		$this->sos_co->AdvancedSearch->Load();
		$this->sos_peserta->AdvancedSearch->Load();
		$this->sos_prov->AdvancedSearch->Load();
		$this->sos_kab->AdvancedSearch->Load();
		$this->sos_kec->AdvancedSearch->Load();
		$this->sos_desa->AdvancedSearch->Load();
		$this->sos_alamat->AdvancedSearch->Load();
		$this->sos_pot_lahan->AdvancedSearch->Load();
		$this->sos_katinggian->AdvancedSearch->Load();
		$this->sos_biaya->AdvancedSearch->Load();
		$this->sos_kesimpulan->AdvancedSearch->Load();
		$this->sos_foto->AdvancedSearch->Load();
	}

	// Set up sort parameters
	function SetupSortOrder() {

		// Check for "order" parameter
		if (@$_GET["order"] <> "") {
			$this->CurrentOrder = @$_GET["order"];
			$this->CurrentOrderType = @$_GET["ordertype"];
			$this->UpdateSort($this->sos_id); // sos_id
			$this->UpdateSort($this->sos_tgl); // sos_tgl
			$this->UpdateSort($this->sos_co); // sos_co
			$this->UpdateSort($this->sos_peserta); // sos_peserta
			$this->UpdateSort($this->sos_prov); // sos_prov
			$this->UpdateSort($this->sos_kab); // sos_kab
			$this->UpdateSort($this->sos_kec); // sos_kec
			$this->UpdateSort($this->sos_desa); // sos_desa
			$this->UpdateSort($this->sos_alamat); // sos_alamat
			$this->UpdateSort($this->sos_pot_lahan); // sos_pot_lahan
			$this->UpdateSort($this->sos_katinggian); // sos_katinggian
			$this->UpdateSort($this->sos_biaya); // sos_biaya
			$this->UpdateSort($this->sos_kesimpulan); // sos_kesimpulan
			$this->UpdateSort($this->sos_foto); // sos_foto
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	function LoadSortOrder() {
		$sOrderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($sOrderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$sOrderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($sOrderBy);
				$this->sos_id->setSort("DESC");
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)
	function ResetCmd() {

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->ResetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$sOrderBy = "";
				$this->setSessionOrderBy($sOrderBy);
				$this->sos_id->setSort("");
				$this->sos_tgl->setSort("");
				$this->sos_co->setSort("");
				$this->sos_peserta->setSort("");
				$this->sos_prov->setSort("");
				$this->sos_kab->setSort("");
				$this->sos_kec->setSort("");
				$this->sos_desa->setSort("");
				$this->sos_alamat->setSort("");
				$this->sos_pot_lahan->setSort("");
				$this->sos_katinggian->setSort("");
				$this->sos_biaya->setSort("");
				$this->sos_kesimpulan->setSort("");
				$this->sos_foto->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	function SetupListOptions() {
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->Add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->Add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->CanView();
		$item->OnLeft = TRUE;

		// "edit"
		$item = &$this->ListOptions->Add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->CanEdit();
		$item->OnLeft = TRUE;

		// "copy"
		$item = &$this->ListOptions->Add("copy");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->CanAdd();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->Add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->Add("checkbox");
		$item->Visible = $Security->CanDelete();
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew_SelectAllKey(this);\">";
		$item->MoveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseImageAndText = TRUE;
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->Phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		if ($this->ListOptions->UseButtonGroup && ew_IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;
		$this->ListOptions->ButtonClass = "btn-sm"; // Class for button group

		// Call ListOptions_Load event
		$this->ListOptions_Load();
		$this->SetupListOptionsExt();
		$item = &$this->ListOptions->GetItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->GroupOptionVisible();
	}

	// Render list options
	function RenderListOptions() {
		global $Security, $Language, $objForm;
		$this->ListOptions->LoadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$oListOpt = &$this->ListOptions->Items["view"];
		$viewcaption = ew_HtmlTitle($Language->Phrase("ViewLink"));
		if ($Security->CanView()) {
			$oListOpt->Body = "<a class=\"ewRowLink ewView\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . ew_HtmlEncode($this->ViewUrl) . "\">" . $Language->Phrase("ViewLink") . "</a>";
		} else {
			$oListOpt->Body = "";
		}

		// "edit"
		$oListOpt = &$this->ListOptions->Items["edit"];
		$editcaption = ew_HtmlTitle($Language->Phrase("EditLink"));
		if ($Security->CanEdit()) {
			$oListOpt->Body = "<a class=\"ewRowLink ewEdit\" title=\"" . ew_HtmlTitle($Language->Phrase("EditLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("EditLink")) . "\" href=\"" . ew_HtmlEncode($this->EditUrl) . "\">" . $Language->Phrase("EditLink") . "</a>";
		} else {
			$oListOpt->Body = "";
		}

		// "copy"
		$oListOpt = &$this->ListOptions->Items["copy"];
		$copycaption = ew_HtmlTitle($Language->Phrase("CopyLink"));
		if ($Security->CanAdd()) {
			$oListOpt->Body = "<a class=\"ewRowLink ewCopy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . ew_HtmlEncode($this->CopyUrl) . "\">" . $Language->Phrase("CopyLink") . "</a>";
		} else {
			$oListOpt->Body = "";
		}

		// Set up list action buttons
		$oListOpt = &$this->ListOptions->GetItem("listactions");
		if ($oListOpt && $this->Export == "" && $this->CurrentAction == "") {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode(str_replace(" ewIcon", "", $listaction->Icon)) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\"></span> " : "";
					$links[] = "<li><a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" title=\"" . ew_HtmlTitle($caption) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $Language->Phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default btn-sm ewActions\" title=\"" . ew_HtmlTitle($Language->Phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->Phrase("ListActionButton") . "<b class=\"caret\"></b></button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($oListOpt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$oListOpt->Body = $body;
				$oListOpt->Visible = TRUE;
			}
		}

		// "checkbox"
		$oListOpt = &$this->ListOptions->Items["checkbox"];
		$oListOpt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ewMultiSelect\" value=\"" . ew_HtmlEncode($this->sos_id->CurrentValue) . "\" onclick=\"ew_ClickMultiCheckbox(event);\">";
		$this->RenderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	function SetupOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->Add("add");
		$addcaption = ew_HtmlTitle($Language->Phrase("AddLink"));
		$item->Body = "<a class=\"ewAddEdit ewAdd\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . ew_HtmlEncode($this->AddUrl) . "\">" . $Language->Phrase("AddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->CanAdd());
		$option = $options["action"];

		// Add multi delete
		$item = &$option->Add("multidelete");
		$item->Body = "<a class=\"ewAction ewMultiDelete\" title=\"" . ew_HtmlTitle($Language->Phrase("DeleteSelectedLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("DeleteSelectedLink")) . "\" href=\"\" onclick=\"ew_SubmitAction(event,{f:document.fsosialisasilist,url:'" . $this->MultiDeleteUrl . "'});return false;\">" . $Language->Phrase("DeleteSelectedLink") . "</a>";
		$item->Visible = ($Security->CanDelete());

		// Set up options default
		foreach ($options as &$option) {
			$option->UseImageAndText = TRUE;
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;
			$option->ButtonClass = "btn-sm"; // Class for button group
			$item = &$option->Add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->Phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->Phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->Phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->Add("savecurrentfilter");
		$item->Body = "<a class=\"ewSaveFilter\" data-form=\"fsosialisasilistsrch\" href=\"#\">" . $Language->Phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->Add("deletefilter");
		$item->Body = "<a class=\"ewDeleteFilter\" data-form=\"fsosialisasilistsrch\" href=\"#\">" . $Language->Phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->Phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->Add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	function RenderOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_MULTIPLE) {
					$item = &$option->Add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode($listaction->Icon) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\"></span> " : $caption;
					$item->Body = "<a class=\"ewAction ewListAction\" title=\"" . ew_HtmlEncode($caption) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({f:document.fsosialisasilist}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->GetItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->HideAllOptions();
			}
	}

	// Process list action
	function ProcessListAction() {
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$sFilter = $this->GetKeyFilter();
		$UserAction = @$_POST["useraction"];
		if ($sFilter <> "" && $UserAction <> "") {

			// Check permission first
			$ActionCaption = $UserAction;
			if (array_key_exists($UserAction, $this->ListActions->Items)) {
				$ActionCaption = $this->ListActions->Items[$UserAction]->Caption;
				if (!$this->ListActions->Items[$UserAction]->Allow) {
					$errmsg = str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionNotAllowed"));
					if (@$_POST["ajax"] == $UserAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $sFilter;
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			$rs = $conn->Execute($sSql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $UserAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->BeginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$Processed = $this->Row_CustomAction($UserAction, $row);
					if (!$Processed) break;
					$rs->MoveNext();
				}
				if ($Processed) {
					$conn->CommitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->RollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->Close();
			$this->CurrentAction = ""; // Clear action
			if (@$_POST["ajax"] == $UserAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->ClearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->ClearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	function SetupSearchOptions() {
		global $Language;
		$this->SearchOptions = new cListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ewSearchOption";

		// Search button
		$item = &$this->SearchOptions->Add("searchtoggle");
		$SearchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ewSearchToggle" . $SearchToggleClass . "\" title=\"" . $Language->Phrase("SearchPanel") . "\" data-caption=\"" . $Language->Phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fsosialisasilistsrch\">" . $Language->Phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->Add("showall");
		$item->Body = "<a class=\"btn btn-default ewShowAll\" title=\"" . $Language->Phrase("ShowAll") . "\" data-caption=\"" . $Language->Phrase("ShowAll") . "\" href=\"" . $this->PageUrl() . "cmd=reset\">" . $Language->Phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseImageAndText = TRUE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->Phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->Add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->Export <> "" || $this->CurrentAction <> "")
			$this->SearchOptions->HideAllOptions();
		global $Security;
		if (!$Security->CanSearch()) {
			$this->SearchOptions->HideAllOptions();
			$this->FilterOptions->HideAllOptions();
		}
	}

	function SetupListOptionsExt() {
		global $Security, $Language;
	}

	function RenderListOptionsExt() {
		global $Security, $Language;
	}

	// Set up starting record parameters
	function SetupStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	function LoadBasicSearchValues() {
		$this->BasicSearch->Keyword = @$_GET[EW_TABLE_BASIC_SEARCH];
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "") $this->Command = "search";
		$this->BasicSearch->Type = @$_GET[EW_TABLE_BASIC_SEARCH_TYPE];
	}

	// Load search values for validation
	function LoadSearchValues() {
		global $objForm;

		// Load search values
		// sos_id

		$this->sos_id->AdvancedSearch->SearchValue = @$_GET["x_sos_id"];
		if ($this->sos_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->sos_id->AdvancedSearch->SearchOperator = @$_GET["z_sos_id"];

		// sos_tgl
		$this->sos_tgl->AdvancedSearch->SearchValue = @$_GET["x_sos_tgl"];
		if ($this->sos_tgl->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->sos_tgl->AdvancedSearch->SearchOperator = @$_GET["z_sos_tgl"];
		$this->sos_tgl->AdvancedSearch->SearchCondition = @$_GET["v_sos_tgl"];
		$this->sos_tgl->AdvancedSearch->SearchValue2 = @$_GET["y_sos_tgl"];
		if ($this->sos_tgl->AdvancedSearch->SearchValue2 <> "" && $this->Command == "") $this->Command = "search";
		$this->sos_tgl->AdvancedSearch->SearchOperator2 = @$_GET["w_sos_tgl"];

		// sos_co
		$this->sos_co->AdvancedSearch->SearchValue = @$_GET["x_sos_co"];
		if ($this->sos_co->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->sos_co->AdvancedSearch->SearchOperator = @$_GET["z_sos_co"];

		// sos_peserta
		$this->sos_peserta->AdvancedSearch->SearchValue = @$_GET["x_sos_peserta"];
		if ($this->sos_peserta->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->sos_peserta->AdvancedSearch->SearchOperator = @$_GET["z_sos_peserta"];
		if (is_array($this->sos_peserta->AdvancedSearch->SearchValue)) $this->sos_peserta->AdvancedSearch->SearchValue = implode(",", $this->sos_peserta->AdvancedSearch->SearchValue);
		if (is_array($this->sos_peserta->AdvancedSearch->SearchValue2)) $this->sos_peserta->AdvancedSearch->SearchValue2 = implode(",", $this->sos_peserta->AdvancedSearch->SearchValue2);

		// sos_prov
		$this->sos_prov->AdvancedSearch->SearchValue = @$_GET["x_sos_prov"];
		if ($this->sos_prov->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->sos_prov->AdvancedSearch->SearchOperator = @$_GET["z_sos_prov"];

		// sos_kab
		$this->sos_kab->AdvancedSearch->SearchValue = @$_GET["x_sos_kab"];
		if ($this->sos_kab->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->sos_kab->AdvancedSearch->SearchOperator = @$_GET["z_sos_kab"];

		// sos_kec
		$this->sos_kec->AdvancedSearch->SearchValue = @$_GET["x_sos_kec"];
		if ($this->sos_kec->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->sos_kec->AdvancedSearch->SearchOperator = @$_GET["z_sos_kec"];

		// sos_desa
		$this->sos_desa->AdvancedSearch->SearchValue = @$_GET["x_sos_desa"];
		if ($this->sos_desa->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->sos_desa->AdvancedSearch->SearchOperator = @$_GET["z_sos_desa"];

		// sos_alamat
		$this->sos_alamat->AdvancedSearch->SearchValue = @$_GET["x_sos_alamat"];
		if ($this->sos_alamat->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->sos_alamat->AdvancedSearch->SearchOperator = @$_GET["z_sos_alamat"];

		// sos_pot_lahan
		$this->sos_pot_lahan->AdvancedSearch->SearchValue = @$_GET["x_sos_pot_lahan"];
		if ($this->sos_pot_lahan->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->sos_pot_lahan->AdvancedSearch->SearchOperator = @$_GET["z_sos_pot_lahan"];

		// sos_katinggian
		$this->sos_katinggian->AdvancedSearch->SearchValue = @$_GET["x_sos_katinggian"];
		if ($this->sos_katinggian->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->sos_katinggian->AdvancedSearch->SearchOperator = @$_GET["z_sos_katinggian"];

		// sos_biaya
		$this->sos_biaya->AdvancedSearch->SearchValue = @$_GET["x_sos_biaya"];
		if ($this->sos_biaya->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->sos_biaya->AdvancedSearch->SearchOperator = @$_GET["z_sos_biaya"];

		// sos_kesimpulan
		$this->sos_kesimpulan->AdvancedSearch->SearchValue = @$_GET["x_sos_kesimpulan"];
		if ($this->sos_kesimpulan->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->sos_kesimpulan->AdvancedSearch->SearchOperator = @$_GET["z_sos_kesimpulan"];

		// sos_foto
		$this->sos_foto->AdvancedSearch->SearchValue = @$_GET["x_sos_foto"];
		if ($this->sos_foto->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->sos_foto->AdvancedSearch->SearchOperator = @$_GET["z_sos_foto"];
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {

		// Load List page SQL
		$sSql = $this->ListSQL();
		$conn = &$this->Connection();

		// Load recordset
		$dbtype = ew_GetConnectionType($this->DBID);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset, array("_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())));
			} else {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = ew_LoadRecordset($sSql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues($rs = NULL) {
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->NewRow(); 

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->sos_id->setDbValue($row['sos_id']);
		$this->sos_tgl->setDbValue($row['sos_tgl']);
		$this->sos_co->setDbValue($row['sos_co']);
		$this->sos_peserta->setDbValue($row['sos_peserta']);
		$this->sos_prov->setDbValue($row['sos_prov']);
		$this->sos_kab->setDbValue($row['sos_kab']);
		$this->sos_kec->setDbValue($row['sos_kec']);
		$this->sos_desa->setDbValue($row['sos_desa']);
		$this->sos_alamat->setDbValue($row['sos_alamat']);
		$this->sos_pot_lahan->setDbValue($row['sos_pot_lahan']);
		$this->sos_katinggian->setDbValue($row['sos_katinggian']);
		$this->sos_biaya->setDbValue($row['sos_biaya']);
		$this->sos_kesimpulan->setDbValue($row['sos_kesimpulan']);
		$this->sos_foto->Upload->DbValue = $row['sos_foto'];
		$this->sos_foto->setDbValue($this->sos_foto->Upload->DbValue);
	}

	// Return a row with default values
	function NewRow() {
		$row = array();
		$row['sos_id'] = NULL;
		$row['sos_tgl'] = NULL;
		$row['sos_co'] = NULL;
		$row['sos_peserta'] = NULL;
		$row['sos_prov'] = NULL;
		$row['sos_kab'] = NULL;
		$row['sos_kec'] = NULL;
		$row['sos_desa'] = NULL;
		$row['sos_alamat'] = NULL;
		$row['sos_pot_lahan'] = NULL;
		$row['sos_katinggian'] = NULL;
		$row['sos_biaya'] = NULL;
		$row['sos_kesimpulan'] = NULL;
		$row['sos_foto'] = NULL;
		return $row;
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->sos_id->DbValue = $row['sos_id'];
		$this->sos_tgl->DbValue = $row['sos_tgl'];
		$this->sos_co->DbValue = $row['sos_co'];
		$this->sos_peserta->DbValue = $row['sos_peserta'];
		$this->sos_prov->DbValue = $row['sos_prov'];
		$this->sos_kab->DbValue = $row['sos_kab'];
		$this->sos_kec->DbValue = $row['sos_kec'];
		$this->sos_desa->DbValue = $row['sos_desa'];
		$this->sos_alamat->DbValue = $row['sos_alamat'];
		$this->sos_pot_lahan->DbValue = $row['sos_pot_lahan'];
		$this->sos_katinggian->DbValue = $row['sos_katinggian'];
		$this->sos_biaya->DbValue = $row['sos_biaya'];
		$this->sos_kesimpulan->DbValue = $row['sos_kesimpulan'];
		$this->sos_foto->Upload->DbValue = $row['sos_foto'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("sos_id")) <> "")
			$this->sos_id->CurrentValue = $this->getKey("sos_id"); // sos_id
		else
			$bValidKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
		}
		$this->LoadRowValues($this->OldRecordset); // Load row values
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->GetViewUrl();
		$this->EditUrl = $this->GetEditUrl();
		$this->InlineEditUrl = $this->GetInlineEditUrl();
		$this->CopyUrl = $this->GetCopyUrl();
		$this->InlineCopyUrl = $this->GetInlineCopyUrl();
		$this->DeleteUrl = $this->GetDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// sos_id
		// sos_tgl
		// sos_co
		// sos_peserta
		// sos_prov
		// sos_kab
		// sos_kec
		// sos_desa
		// sos_alamat
		// sos_pot_lahan
		// sos_katinggian
		// sos_biaya
		// sos_kesimpulan
		// sos_foto

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// sos_id
		$this->sos_id->ViewValue = $this->sos_id->CurrentValue;
		$this->sos_id->ViewCustomAttributes = "";

		// sos_tgl
		$this->sos_tgl->ViewValue = $this->sos_tgl->CurrentValue;
		$this->sos_tgl->ViewValue = ew_FormatDateTime($this->sos_tgl->ViewValue, 0);
		$this->sos_tgl->ViewCustomAttributes = "";

		// sos_co
		if (strval($this->sos_co->CurrentValue) <> "") {
			$sFilterWrk = "`co_id`" . ew_SearchString("=", $this->sos_co->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `co_id`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `co`";
		$sWhereWrk = "";
		$this->sos_co->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->sos_co, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `co_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->sos_co->ViewValue = $this->sos_co->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->sos_co->ViewValue = $this->sos_co->CurrentValue;
			}
		} else {
			$this->sos_co->ViewValue = NULL;
		}
		$this->sos_co->ViewCustomAttributes = "";

		// sos_peserta
		if (strval($this->sos_peserta->CurrentValue) <> "") {
			$arwrk = explode(",", $this->sos_peserta->CurrentValue);
			$sFilterWrk = "";
			foreach ($arwrk as $wrk) {
				if ($sFilterWrk <> "") $sFilterWrk .= " OR ";
				$sFilterWrk .= "`pes_id`" . ew_SearchString("=", trim($wrk), EW_DATATYPE_NUMBER, "");
			}
		$sSqlWrk = "SELECT `pes_id`, `pes_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `peserta`";
		$sWhereWrk = "";
		$this->sos_peserta->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->sos_peserta, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `pes_id` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$this->sos_peserta->ViewValue = "";
				$ari = 0;
				while (!$rswrk->EOF) {
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('DispFld');
					$this->sos_peserta->ViewValue .= $this->sos_peserta->DisplayValue($arwrk);
					$rswrk->MoveNext();
					if (!$rswrk->EOF) $this->sos_peserta->ViewValue .= ew_ViewOptionSeparator($ari); // Separate Options
					$ari++;
				}
				$rswrk->Close();
			} else {
				$this->sos_peserta->ViewValue = $this->sos_peserta->CurrentValue;
			}
		} else {
			$this->sos_peserta->ViewValue = NULL;
		}
		$this->sos_peserta->CellCssStyle .= "text-align: left;";
		$this->sos_peserta->ViewCustomAttributes = "";

		// sos_prov
		if (strval($this->sos_prov->CurrentValue) <> "") {
			$sFilterWrk = "`prov_id`" . ew_SearchString("=", $this->sos_prov->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `prov_id`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `prov`";
		$sWhereWrk = "";
		$this->sos_prov->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->sos_prov, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `prov_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->sos_prov->ViewValue = $this->sos_prov->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->sos_prov->ViewValue = $this->sos_prov->CurrentValue;
			}
		} else {
			$this->sos_prov->ViewValue = NULL;
		}
		$this->sos_prov->ViewCustomAttributes = "";

		// sos_kab
		if (strval($this->sos_kab->CurrentValue) <> "") {
			$sFilterWrk = "`kab_id`" . ew_SearchString("=", $this->sos_kab->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `kab_id`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kab`";
		$sWhereWrk = "";
		$this->sos_kab->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->sos_kab, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `kab_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->sos_kab->ViewValue = $this->sos_kab->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->sos_kab->ViewValue = $this->sos_kab->CurrentValue;
			}
		} else {
			$this->sos_kab->ViewValue = NULL;
		}
		$this->sos_kab->ViewCustomAttributes = "";

		// sos_kec
		if (strval($this->sos_kec->CurrentValue) <> "") {
			$sFilterWrk = "`kec_id`" . ew_SearchString("=", $this->sos_kec->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `kec_id`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kec`";
		$sWhereWrk = "";
		$this->sos_kec->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->sos_kec, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `kec_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->sos_kec->ViewValue = $this->sos_kec->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->sos_kec->ViewValue = $this->sos_kec->CurrentValue;
			}
		} else {
			$this->sos_kec->ViewValue = NULL;
		}
		$this->sos_kec->ViewCustomAttributes = "";

		// sos_desa
		if (strval($this->sos_desa->CurrentValue) <> "") {
			$sFilterWrk = "`desa_id`" . ew_SearchString("=", $this->sos_desa->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `desa_id`, `desa_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `desa`";
		$sWhereWrk = "";
		$this->sos_desa->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->sos_desa, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `desa_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->sos_desa->ViewValue = $this->sos_desa->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->sos_desa->ViewValue = $this->sos_desa->CurrentValue;
			}
		} else {
			$this->sos_desa->ViewValue = NULL;
		}
		$this->sos_desa->ViewCustomAttributes = "";

		// sos_alamat
		$this->sos_alamat->ViewValue = $this->sos_alamat->CurrentValue;
		$this->sos_alamat->ViewCustomAttributes = "";

		// sos_pot_lahan
		$this->sos_pot_lahan->ViewValue = $this->sos_pot_lahan->CurrentValue;
		$this->sos_pot_lahan->CellCssStyle .= "text-align: right;";
		$this->sos_pot_lahan->ViewCustomAttributes = "";

		// sos_katinggian
		$this->sos_katinggian->ViewValue = $this->sos_katinggian->CurrentValue;
		$this->sos_katinggian->CellCssStyle .= "text-align: right;";
		$this->sos_katinggian->ViewCustomAttributes = "";

		// sos_biaya
		$this->sos_biaya->ViewValue = $this->sos_biaya->CurrentValue;
		$this->sos_biaya->ViewCustomAttributes = "";

		// sos_kesimpulan
		$this->sos_kesimpulan->ViewValue = $this->sos_kesimpulan->CurrentValue;
		$this->sos_kesimpulan->ViewCustomAttributes = "";

		// sos_foto
		$this->sos_foto->UploadPath = "foto_sosialisasi";
		if (!ew_Empty($this->sos_foto->Upload->DbValue)) {
			$this->sos_foto->ImageWidth = 80;
			$this->sos_foto->ImageHeight = 60;
			$this->sos_foto->ImageAlt = $this->sos_foto->FldAlt();
			$this->sos_foto->ViewValue = $this->sos_foto->Upload->DbValue;
		} else {
			$this->sos_foto->ViewValue = "";
		}
		$this->sos_foto->CellCssStyle .= "text-align: center;";
		$this->sos_foto->ViewCustomAttributes = "";

			// sos_id
			$this->sos_id->LinkCustomAttributes = "";
			$this->sos_id->HrefValue = "";
			$this->sos_id->TooltipValue = "";

			// sos_tgl
			$this->sos_tgl->LinkCustomAttributes = "";
			$this->sos_tgl->HrefValue = "";
			$this->sos_tgl->TooltipValue = "";

			// sos_co
			$this->sos_co->LinkCustomAttributes = "";
			$this->sos_co->HrefValue = "";
			$this->sos_co->TooltipValue = "";

			// sos_peserta
			$this->sos_peserta->LinkCustomAttributes = "";
			$this->sos_peserta->HrefValue = "";
			$this->sos_peserta->TooltipValue = "";

			// sos_prov
			$this->sos_prov->LinkCustomAttributes = "";
			$this->sos_prov->HrefValue = "";
			$this->sos_prov->TooltipValue = "";

			// sos_kab
			$this->sos_kab->LinkCustomAttributes = "";
			$this->sos_kab->HrefValue = "";
			$this->sos_kab->TooltipValue = "";

			// sos_kec
			$this->sos_kec->LinkCustomAttributes = "";
			$this->sos_kec->HrefValue = "";
			$this->sos_kec->TooltipValue = "";

			// sos_desa
			$this->sos_desa->LinkCustomAttributes = "";
			$this->sos_desa->HrefValue = "";
			$this->sos_desa->TooltipValue = "";

			// sos_alamat
			$this->sos_alamat->LinkCustomAttributes = "";
			$this->sos_alamat->HrefValue = "";
			$this->sos_alamat->TooltipValue = "";

			// sos_pot_lahan
			$this->sos_pot_lahan->LinkCustomAttributes = "";
			$this->sos_pot_lahan->HrefValue = "";
			$this->sos_pot_lahan->TooltipValue = "";

			// sos_katinggian
			$this->sos_katinggian->LinkCustomAttributes = "";
			$this->sos_katinggian->HrefValue = "";
			$this->sos_katinggian->TooltipValue = "";

			// sos_biaya
			$this->sos_biaya->LinkCustomAttributes = "";
			$this->sos_biaya->HrefValue = "";
			$this->sos_biaya->TooltipValue = "";

			// sos_kesimpulan
			$this->sos_kesimpulan->LinkCustomAttributes = "";
			$this->sos_kesimpulan->HrefValue = "";
			$this->sos_kesimpulan->TooltipValue = "";

			// sos_foto
			$this->sos_foto->LinkCustomAttributes = "";
			$this->sos_foto->UploadPath = "foto_sosialisasi";
			if (!ew_Empty($this->sos_foto->Upload->DbValue)) {
				$this->sos_foto->HrefValue = "%u"; // Add prefix/suffix
				$this->sos_foto->LinkAttrs["target"] = ""; // Add target
				if ($this->Export <> "") $this->sos_foto->HrefValue = ew_FullUrl($this->sos_foto->HrefValue, "href");
			} else {
				$this->sos_foto->HrefValue = "";
			}
			$this->sos_foto->HrefValue2 = $this->sos_foto->UploadPath . $this->sos_foto->Upload->DbValue;
			$this->sos_foto->TooltipValue = "";
			if ($this->sos_foto->UseColorbox) {
				if (ew_Empty($this->sos_foto->TooltipValue))
					$this->sos_foto->LinkAttrs["title"] = $Language->Phrase("ViewImageGallery");
				$this->sos_foto->LinkAttrs["data-rel"] = "sosialisasi_x" . $this->RowCnt . "_sos_foto";
				ew_AppendClass($this->sos_foto->LinkAttrs["class"], "ewLightbox");
			}
		} elseif ($this->RowType == EW_ROWTYPE_SEARCH) { // Search row

			// sos_id
			$this->sos_id->EditAttrs["class"] = "form-control";
			$this->sos_id->EditCustomAttributes = "";
			$this->sos_id->EditValue = ew_HtmlEncode($this->sos_id->AdvancedSearch->SearchValue);
			$this->sos_id->PlaceHolder = ew_RemoveHtml($this->sos_id->FldCaption());

			// sos_tgl
			$this->sos_tgl->EditAttrs["class"] = "form-control";
			$this->sos_tgl->EditCustomAttributes = "";
			$this->sos_tgl->EditValue = ew_HtmlEncode(ew_FormatDateTime(ew_UnFormatDateTime($this->sos_tgl->AdvancedSearch->SearchValue, 0), 8));
			$this->sos_tgl->PlaceHolder = ew_RemoveHtml($this->sos_tgl->FldCaption());
			$this->sos_tgl->EditAttrs["class"] = "form-control";
			$this->sos_tgl->EditCustomAttributes = "";
			$this->sos_tgl->EditValue2 = ew_HtmlEncode(ew_FormatDateTime(ew_UnFormatDateTime($this->sos_tgl->AdvancedSearch->SearchValue2, 0), 8));
			$this->sos_tgl->PlaceHolder = ew_RemoveHtml($this->sos_tgl->FldCaption());

			// sos_co
			$this->sos_co->EditAttrs["class"] = "form-control";
			$this->sos_co->EditCustomAttributes = "";
			if (trim(strval($this->sos_co->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`co_id`" . ew_SearchString("=", $this->sos_co->AdvancedSearch->SearchValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `co_id`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `co`";
			$sWhereWrk = "";
			$this->sos_co->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->sos_co, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `co_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->sos_co->EditValue = $arwrk;

			// sos_peserta
			$this->sos_peserta->EditCustomAttributes = "";

			// sos_prov
			$this->sos_prov->EditAttrs["class"] = "form-control";
			$this->sos_prov->EditCustomAttributes = "";
			if (trim(strval($this->sos_prov->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`prov_id`" . ew_SearchString("=", $this->sos_prov->AdvancedSearch->SearchValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `prov_id`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `prov`";
			$sWhereWrk = "";
			$this->sos_prov->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->sos_prov, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `prov_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->sos_prov->EditValue = $arwrk;

			// sos_kab
			$this->sos_kab->EditAttrs["class"] = "form-control";
			$this->sos_kab->EditCustomAttributes = "";
			if (trim(strval($this->sos_kab->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`kab_id`" . ew_SearchString("=", $this->sos_kab->AdvancedSearch->SearchValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `kab_id`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, `kab_prov_id` AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `kab`";
			$sWhereWrk = "";
			$this->sos_kab->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->sos_kab, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `kab_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->sos_kab->EditValue = $arwrk;

			// sos_kec
			$this->sos_kec->EditAttrs["class"] = "form-control";
			$this->sos_kec->EditCustomAttributes = "";
			if (trim(strval($this->sos_kec->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`kec_id`" . ew_SearchString("=", $this->sos_kec->AdvancedSearch->SearchValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `kec_id`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, `kec_prov_id` AS `SelectFilterFld`, `kec_kab_id` AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `kec`";
			$sWhereWrk = "";
			$this->sos_kec->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->sos_kec, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `kec_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->sos_kec->EditValue = $arwrk;

			// sos_desa
			$this->sos_desa->EditAttrs["class"] = "form-control";
			$this->sos_desa->EditCustomAttributes = "";
			if (trim(strval($this->sos_desa->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`desa_id`" . ew_SearchString("=", $this->sos_desa->AdvancedSearch->SearchValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `desa_id`, `desa_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, `desa_prov_id` AS `SelectFilterFld`, `desa_kab_id` AS `SelectFilterFld2`, `desa_kec_id` AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `desa`";
			$sWhereWrk = "";
			$this->sos_desa->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->sos_desa, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `desa_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->sos_desa->EditValue = $arwrk;

			// sos_alamat
			$this->sos_alamat->EditAttrs["class"] = "form-control";
			$this->sos_alamat->EditCustomAttributes = "";
			$this->sos_alamat->EditValue = ew_HtmlEncode($this->sos_alamat->AdvancedSearch->SearchValue);
			$this->sos_alamat->PlaceHolder = ew_RemoveHtml($this->sos_alamat->FldCaption());

			// sos_pot_lahan
			$this->sos_pot_lahan->EditAttrs["class"] = "form-control";
			$this->sos_pot_lahan->EditCustomAttributes = "";
			$this->sos_pot_lahan->EditValue = ew_HtmlEncode($this->sos_pot_lahan->AdvancedSearch->SearchValue);
			$this->sos_pot_lahan->PlaceHolder = ew_RemoveHtml($this->sos_pot_lahan->FldCaption());

			// sos_katinggian
			$this->sos_katinggian->EditAttrs["class"] = "form-control";
			$this->sos_katinggian->EditCustomAttributes = "";
			$this->sos_katinggian->EditValue = ew_HtmlEncode($this->sos_katinggian->AdvancedSearch->SearchValue);
			$this->sos_katinggian->PlaceHolder = ew_RemoveHtml($this->sos_katinggian->FldCaption());

			// sos_biaya
			$this->sos_biaya->EditAttrs["class"] = "form-control";
			$this->sos_biaya->EditCustomAttributes = "";
			$this->sos_biaya->EditValue = ew_HtmlEncode($this->sos_biaya->AdvancedSearch->SearchValue);
			$this->sos_biaya->PlaceHolder = ew_RemoveHtml($this->sos_biaya->FldCaption());

			// sos_kesimpulan
			$this->sos_kesimpulan->EditAttrs["class"] = "form-control";
			$this->sos_kesimpulan->EditCustomAttributes = "";
			$this->sos_kesimpulan->EditValue = ew_HtmlEncode($this->sos_kesimpulan->AdvancedSearch->SearchValue);
			$this->sos_kesimpulan->PlaceHolder = ew_RemoveHtml($this->sos_kesimpulan->FldCaption());

			// sos_foto
			$this->sos_foto->EditAttrs["class"] = "form-control";
			$this->sos_foto->EditCustomAttributes = "";
			$this->sos_foto->EditValue = ew_HtmlEncode($this->sos_foto->AdvancedSearch->SearchValue);
			$this->sos_foto->PlaceHolder = ew_RemoveHtml($this->sos_foto->FldCaption());
		}
		if ($this->RowType == EW_ROWTYPE_ADD || $this->RowType == EW_ROWTYPE_EDIT || $this->RowType == EW_ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->SetupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	function ValidateSearch() {
		global $gsSearchError;

		// Initialize
		$gsSearchError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return TRUE;
		if (!ew_CheckDateDef($this->sos_tgl->AdvancedSearch->SearchValue)) {
			ew_AddMessage($gsSearchError, $this->sos_tgl->FldErrMsg());
		}
		if (!ew_CheckDateDef($this->sos_tgl->AdvancedSearch->SearchValue2)) {
			ew_AddMessage($gsSearchError, $this->sos_tgl->FldErrMsg());
		}

		// Return validate result
		$ValidateSearch = ($gsSearchError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateSearch = $ValidateSearch && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsSearchError, $sFormCustomError);
		}
		return $ValidateSearch;
	}

	// Load advanced search
	function LoadAdvancedSearch() {
		$this->sos_id->AdvancedSearch->Load();
		$this->sos_tgl->AdvancedSearch->Load();
		$this->sos_co->AdvancedSearch->Load();
		$this->sos_peserta->AdvancedSearch->Load();
		$this->sos_prov->AdvancedSearch->Load();
		$this->sos_kab->AdvancedSearch->Load();
		$this->sos_kec->AdvancedSearch->Load();
		$this->sos_desa->AdvancedSearch->Load();
		$this->sos_alamat->AdvancedSearch->Load();
		$this->sos_pot_lahan->AdvancedSearch->Load();
		$this->sos_katinggian->AdvancedSearch->Load();
		$this->sos_biaya->AdvancedSearch->Load();
		$this->sos_kesimpulan->AdvancedSearch->Load();
		$this->sos_foto->AdvancedSearch->Load();
	}

	// Set up export options
	function SetupExportOptions() {
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->Add("print");
		$item->Body = "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ewExportLink ewPrint\" title=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\">" . $Language->Phrase("PrinterFriendly") . "</a>";
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->Add("excel");
		$item->Body = "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ewExportLink ewExcel\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\">" . $Language->Phrase("ExportToExcel") . "</a>";
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->Add("word");
		$item->Body = "<a href=\"" . $this->ExportWordUrl . "\" class=\"ewExportLink ewWord\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\">" . $Language->Phrase("ExportToWord") . "</a>";
		$item->Visible = TRUE;

		// Export to Html
		$item = &$this->ExportOptions->Add("html");
		$item->Body = "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ewExportLink ewHtml\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\">" . $Language->Phrase("ExportToHtml") . "</a>";
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->Add("xml");
		$item->Body = "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ewExportLink ewXml\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\">" . $Language->Phrase("ExportToXml") . "</a>";
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->Add("csv");
		$item->Body = "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ewExportLink ewCsv\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\">" . $Language->Phrase("ExportToCsv") . "</a>";
		$item->Visible = FALSE;

		// Export to Pdf
		$item = &$this->ExportOptions->Add("pdf");
		$item->Body = "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ewExportLink ewPdf\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\">" . $Language->Phrase("ExportToPDF") . "</a>";
		$item->Visible = FALSE;

		// Export to Email
		$item = &$this->ExportOptions->Add("email");
		$url = "";
		$item->Body = "<button id=\"emf_sosialisasi\" class=\"ewExportLink ewEmail\" title=\"" . $Language->Phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->Phrase("ExportToEmailText") . "\" onclick=\"ew_EmailDialogShow({lnk:'emf_sosialisasi',hdr:ewLanguage.Phrase('ExportToEmailText'),f:document.fsosialisasilist,sel:false" . $url . "});\">" . $Language->Phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseImageAndText = TRUE;
		$this->ExportOptions->UseDropDownButton = FALSE;
		if ($this->ExportOptions->UseButtonGroup && ew_IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->Phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->Add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	function ExportData() {
		$utf8 = (strtolower(EW_CHARSET) == "utf-8");
		$bSelectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($bSelectLimit) {
			$this->TotalRecs = $this->ListRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->LoadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EW_EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->SetupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($bSelectLimit)
			$rs = $this->LoadRecordset($this->StartRec-1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		if (!$rs) {
			header("Content-Type:"); // Remove header
			header("Content-Disposition:");
			$this->ShowMessage();
			return;
		}
		$this->ExportDoc = ew_ExportDocument($this, "h");
		$Doc = &$this->ExportDoc;
		if ($bSelectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		} else {

			//$this->StartRec = $this->StartRec;
			//$this->StopRec = $this->StopRec;

		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$ParentTable = "";
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		$Doc->Text .= $sHeader;
		$this->ExportDocument($Doc, $rs, $this->StartRec, $this->StopRec, "");
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		$Doc->Text .= $sFooter;

		// Close recordset
		$rs->Close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$Doc->ExportHeaderAndFooter();

		// Clean output buffer
		if (!EW_DEBUG_ENABLED && ob_get_length())
			ob_end_clean();

		// Write debug message if enabled
		if (EW_DEBUG_ENABLED && $this->Export <> "pdf")
			echo ew_DebugMsg();

		// Output data
		$Doc->Export();
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->Add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup filters of a field
	function SetupLookupFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		if ($pageId == "list") {
			switch ($fld->FldVar) {
			}
		} elseif ($pageId == "extbs") {
			switch ($fld->FldVar) {
		case "x_sos_co":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `co_id` AS `LinkFld`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `co`";
				$sWhereWrk = "";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`co_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->sos_co, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$sSqlWrk .= " ORDER BY `co_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_sos_prov":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `prov_id` AS `LinkFld`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `prov`";
				$sWhereWrk = "";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`prov_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->sos_prov, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$sSqlWrk .= " ORDER BY `prov_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_sos_kab":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `kab_id` AS `LinkFld`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kab`";
				$sWhereWrk = "{filter}";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`kab_id` IN ({filter_value})', "t0" => "3", "fn0" => "", "f1" => '`kab_prov_id` IN ({filter_value})', "t1" => "3", "fn1" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->sos_kab, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$sSqlWrk .= " ORDER BY `kab_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_sos_kec":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `kec_id` AS `LinkFld`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kec`";
				$sWhereWrk = "{filter}";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`kec_id` IN ({filter_value})', "t0" => "3", "fn0" => "", "f1" => '`kec_prov_id` IN ({filter_value})', "t1" => "3", "fn1" => "", "f2" => '`kec_kab_id` IN ({filter_value})', "t2" => "3", "fn2" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->sos_kec, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$sSqlWrk .= " ORDER BY `kec_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_sos_desa":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `desa_id` AS `LinkFld`, `desa_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `desa`";
				$sWhereWrk = "{filter}";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`desa_id` IN ({filter_value})', "t0" => "3", "fn0" => "", "f1" => '`desa_prov_id` IN ({filter_value})', "t1" => "3", "fn1" => "", "f2" => '`desa_kab_id` IN ({filter_value})', "t2" => "3", "fn2" => "", "f3" => '`desa_kec_id` IN ({filter_value})', "t3" => "3", "fn3" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->sos_desa, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$sSqlWrk .= " ORDER BY `desa_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
			}
		}
	}

	// Setup AutoSuggest filters of a field
	function SetupAutoSuggestFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		if ($pageId == "list") {
			switch ($fld->FldVar) {
			}
		} elseif ($pageId == "extbs") {
			switch ($fld->FldVar) {
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($sosialisasi_list)) $sosialisasi_list = new csosialisasi_list();

// Page init
$sosialisasi_list->Page_Init();

// Page main
$sosialisasi_list->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sosialisasi_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if ($sosialisasi->Export == "") { ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "list";
var CurrentForm = fsosialisasilist = new ew_Form("fsosialisasilist", "list");
fsosialisasilist.FormKeyCountName = '<?php echo $sosialisasi_list->FormKeyCountName ?>';

// Form_CustomValidate event
fsosialisasilist.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fsosialisasilist.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsosialisasilist.Lists["x_sos_co"] = {"LinkField":"x_co_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_co_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"co"};
fsosialisasilist.Lists["x_sos_co"].Data = "<?php echo $sosialisasi_list->sos_co->LookupFilterQuery(FALSE, "list") ?>";
fsosialisasilist.Lists["x_sos_peserta[]"] = {"LinkField":"x_pes_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_pes_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"peserta"};
fsosialisasilist.Lists["x_sos_peserta[]"].Data = "<?php echo $sosialisasi_list->sos_peserta->LookupFilterQuery(FALSE, "list") ?>";
fsosialisasilist.Lists["x_sos_prov"] = {"LinkField":"x_prov_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_prov_nama","","",""],"ParentFields":[],"ChildFields":["x_sos_kab","x_sos_kec","x_sos_desa"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"prov"};
fsosialisasilist.Lists["x_sos_prov"].Data = "<?php echo $sosialisasi_list->sos_prov->LookupFilterQuery(FALSE, "list") ?>";
fsosialisasilist.Lists["x_sos_kab"] = {"LinkField":"x_kab_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kab_nama","","",""],"ParentFields":[],"ChildFields":["x_sos_kec","x_sos_desa"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kab"};
fsosialisasilist.Lists["x_sos_kab"].Data = "<?php echo $sosialisasi_list->sos_kab->LookupFilterQuery(FALSE, "list") ?>";
fsosialisasilist.Lists["x_sos_kec"] = {"LinkField":"x_kec_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kec_nama","","",""],"ParentFields":[],"ChildFields":["x_sos_desa"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kec"};
fsosialisasilist.Lists["x_sos_kec"].Data = "<?php echo $sosialisasi_list->sos_kec->LookupFilterQuery(FALSE, "list") ?>";
fsosialisasilist.Lists["x_sos_desa"] = {"LinkField":"x_desa_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_desa_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"desa"};
fsosialisasilist.Lists["x_sos_desa"].Data = "<?php echo $sosialisasi_list->sos_desa->LookupFilterQuery(FALSE, "list") ?>";

// Form object for search
var CurrentSearchForm = fsosialisasilistsrch = new ew_Form("fsosialisasilistsrch");

// Validate function for search
fsosialisasilistsrch.Validate = function(fobj) {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	fobj = fobj || this.Form;
	var infix = "";
	elm = this.GetElements("x" + infix + "_sos_tgl");
	if (elm && !ew_CheckDateDef(elm.value))
		return this.OnError(elm, "<?php echo ew_JsEncode2($sosialisasi->sos_tgl->FldErrMsg()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fsosialisasilistsrch.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fsosialisasilistsrch.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsosialisasilistsrch.Lists["x_sos_co"] = {"LinkField":"x_co_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_co_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"co"};
fsosialisasilistsrch.Lists["x_sos_co"].Data = "<?php echo $sosialisasi_list->sos_co->LookupFilterQuery(FALSE, "extbs") ?>";
fsosialisasilistsrch.Lists["x_sos_prov"] = {"LinkField":"x_prov_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_prov_nama","","",""],"ParentFields":[],"ChildFields":["x_sos_kab","x_sos_kec","x_sos_desa"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"prov"};
fsosialisasilistsrch.Lists["x_sos_prov"].Data = "<?php echo $sosialisasi_list->sos_prov->LookupFilterQuery(FALSE, "extbs") ?>";
fsosialisasilistsrch.Lists["x_sos_kab"] = {"LinkField":"x_kab_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kab_nama","","",""],"ParentFields":["x_sos_prov"],"ChildFields":["x_sos_kec","x_sos_desa"],"FilterFields":["x_kab_prov_id"],"Options":[],"Template":"","LinkTable":"kab"};
fsosialisasilistsrch.Lists["x_sos_kab"].Data = "<?php echo $sosialisasi_list->sos_kab->LookupFilterQuery(FALSE, "extbs") ?>";
fsosialisasilistsrch.Lists["x_sos_kec"] = {"LinkField":"x_kec_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kec_nama","","",""],"ParentFields":["x_sos_prov","x_sos_kab"],"ChildFields":["x_sos_desa"],"FilterFields":["x_kec_prov_id","x_kec_kab_id"],"Options":[],"Template":"","LinkTable":"kec"};
fsosialisasilistsrch.Lists["x_sos_kec"].Data = "<?php echo $sosialisasi_list->sos_kec->LookupFilterQuery(FALSE, "extbs") ?>";
fsosialisasilistsrch.Lists["x_sos_desa"] = {"LinkField":"x_desa_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_desa_nama","","",""],"ParentFields":["x_sos_prov","x_sos_kab","x_sos_kec"],"ChildFields":[],"FilterFields":["x_desa_prov_id","x_desa_kab_id","x_desa_kec_id"],"Options":[],"Template":"","LinkTable":"desa"};
fsosialisasilistsrch.Lists["x_sos_desa"].Data = "<?php echo $sosialisasi_list->sos_desa->LookupFilterQuery(FALSE, "extbs") ?>";

// Init search panel as collapsed
if (fsosialisasilistsrch) fsosialisasilistsrch.InitSearchPanel = true;
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if ($sosialisasi->Export == "") { ?>
<div class="ewToolbar">
<?php if ($sosialisasi_list->TotalRecs > 0 && $sosialisasi_list->ExportOptions->Visible()) { ?>
<?php $sosialisasi_list->ExportOptions->Render("body") ?>
<?php } ?>
<?php if ($sosialisasi_list->SearchOptions->Visible()) { ?>
<?php $sosialisasi_list->SearchOptions->Render("body") ?>
<?php } ?>
<?php if ($sosialisasi_list->FilterOptions->Visible()) { ?>
<?php $sosialisasi_list->FilterOptions->Render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
	$bSelectLimit = $sosialisasi_list->UseSelectLimit;
	if ($bSelectLimit) {
		if ($sosialisasi_list->TotalRecs <= 0)
			$sosialisasi_list->TotalRecs = $sosialisasi->ListRecordCount();
	} else {
		if (!$sosialisasi_list->Recordset && ($sosialisasi_list->Recordset = $sosialisasi_list->LoadRecordset()))
			$sosialisasi_list->TotalRecs = $sosialisasi_list->Recordset->RecordCount();
	}
	$sosialisasi_list->StartRec = 1;
	if ($sosialisasi_list->DisplayRecs <= 0 || ($sosialisasi->Export <> "" && $sosialisasi->ExportAll)) // Display all records
		$sosialisasi_list->DisplayRecs = $sosialisasi_list->TotalRecs;
	if (!($sosialisasi->Export <> "" && $sosialisasi->ExportAll))
		$sosialisasi_list->SetupStartRec(); // Set up start record position
	if ($bSelectLimit)
		$sosialisasi_list->Recordset = $sosialisasi_list->LoadRecordset($sosialisasi_list->StartRec-1, $sosialisasi_list->DisplayRecs);

	// Set no record found message
	if ($sosialisasi->CurrentAction == "" && $sosialisasi_list->TotalRecs == 0) {
		if (!$Security->CanList())
			$sosialisasi_list->setWarningMessage(ew_DeniedMsg());
		if ($sosialisasi_list->SearchWhere == "0=101")
			$sosialisasi_list->setWarningMessage($Language->Phrase("EnterSearchCriteria"));
		else
			$sosialisasi_list->setWarningMessage($Language->Phrase("NoRecord"));
	}
$sosialisasi_list->RenderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if ($sosialisasi->Export == "" && $sosialisasi->CurrentAction == "") { ?>
<form name="fsosialisasilistsrch" id="fsosialisasilistsrch" class="form-inline ewForm ewExtSearchForm" action="<?php echo ew_CurrentPage() ?>">
<?php $SearchPanelClass = ($sosialisasi_list->SearchWhere <> "") ? " in" : ""; ?>
<div id="fsosialisasilistsrch_SearchPanel" class="ewSearchPanel collapse<?php echo $SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="sosialisasi">
	<div class="ewBasicSearch">
<?php
if ($gsSearchError == "")
	$sosialisasi_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$sosialisasi->RowType = EW_ROWTYPE_SEARCH;

// Render row
$sosialisasi->ResetAttrs();
$sosialisasi_list->RenderRow();
?>
<div id="xsr_1" class="ewRow">
<?php if ($sosialisasi->sos_tgl->Visible) { // sos_tgl ?>
	<div id="xsc_sos_tgl" class="ewCell form-group">
		<label for="x_sos_tgl" class="ewSearchCaption ewLabel"><?php echo $sosialisasi->sos_tgl->FldCaption() ?></label>
		<span class="ewSearchOperator"><select name="z_sos_tgl" id="z_sos_tgl" class="form-control" onchange="ewForms(this).SrchOprChanged(this);"><option value="="<?php echo ($sosialisasi->sos_tgl->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->Phrase("EQUAL") ?></option><option value="<>"<?php echo ($sosialisasi->sos_tgl->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->Phrase("<>") ?></option><option value="<"<?php echo ($sosialisasi->sos_tgl->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->Phrase("<") ?></option><option value="<="<?php echo ($sosialisasi->sos_tgl->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->Phrase("<=") ?></option><option value=">"<?php echo ($sosialisasi->sos_tgl->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->Phrase(">") ?></option><option value=">="<?php echo ($sosialisasi->sos_tgl->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->Phrase(">=") ?></option><option value="IS NULL"<?php echo ($sosialisasi->sos_tgl->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->Phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($sosialisasi->sos_tgl->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->Phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($sosialisasi->sos_tgl->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->Phrase("BETWEEN") ?></option></select></span>
		<span class="ewSearchField">
<input type="text" data-table="sosialisasi" data-field="x_sos_tgl" name="x_sos_tgl" id="x_sos_tgl" placeholder="<?php echo ew_HtmlEncode($sosialisasi->sos_tgl->getPlaceHolder()) ?>" value="<?php echo $sosialisasi->sos_tgl->EditValue ?>"<?php echo $sosialisasi->sos_tgl->EditAttributes() ?>>
<?php if (!$sosialisasi->sos_tgl->ReadOnly && !$sosialisasi->sos_tgl->Disabled && !isset($sosialisasi->sos_tgl->EditAttrs["readonly"]) && !isset($sosialisasi->sos_tgl->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("fsosialisasilistsrch", "x_sos_tgl", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		<span class="ewSearchCond btw1_sos_tgl" style="display: none">&nbsp;<?php echo $Language->Phrase("AND") ?>&nbsp;</span>
		<span class="ewSearchField btw1_sos_tgl" style="display: none">
<input type="text" data-table="sosialisasi" data-field="x_sos_tgl" name="y_sos_tgl" id="y_sos_tgl" placeholder="<?php echo ew_HtmlEncode($sosialisasi->sos_tgl->getPlaceHolder()) ?>" value="<?php echo $sosialisasi->sos_tgl->EditValue2 ?>"<?php echo $sosialisasi->sos_tgl->EditAttributes() ?>>
<?php if (!$sosialisasi->sos_tgl->ReadOnly && !$sosialisasi->sos_tgl->Disabled && !isset($sosialisasi->sos_tgl->EditAttrs["readonly"]) && !isset($sosialisasi->sos_tgl->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("fsosialisasilistsrch", "y_sos_tgl", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ewRow">
<?php if ($sosialisasi->sos_co->Visible) { // sos_co ?>
	<div id="xsc_sos_co" class="ewCell form-group">
		<label for="x_sos_co" class="ewSearchCaption ewLabel"><?php echo $sosialisasi->sos_co->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_sos_co" id="z_sos_co" value="="></span>
		<span class="ewSearchField">
<select data-table="sosialisasi" data-field="x_sos_co" data-value-separator="<?php echo $sosialisasi->sos_co->DisplayValueSeparatorAttribute() ?>" id="x_sos_co" name="x_sos_co"<?php echo $sosialisasi->sos_co->EditAttributes() ?>>
<?php echo $sosialisasi->sos_co->SelectOptionListHtml("x_sos_co") ?>
</select>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ewRow">
<?php if ($sosialisasi->sos_prov->Visible) { // sos_prov ?>
	<div id="xsc_sos_prov" class="ewCell form-group">
		<label for="x_sos_prov" class="ewSearchCaption ewLabel"><?php echo $sosialisasi->sos_prov->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_sos_prov" id="z_sos_prov" value="="></span>
		<span class="ewSearchField">
<?php $sosialisasi->sos_prov->EditAttrs["onchange"] = "ew_UpdateOpt.call(this); " . @$sosialisasi->sos_prov->EditAttrs["onchange"]; ?>
<select data-table="sosialisasi" data-field="x_sos_prov" data-value-separator="<?php echo $sosialisasi->sos_prov->DisplayValueSeparatorAttribute() ?>" id="x_sos_prov" name="x_sos_prov"<?php echo $sosialisasi->sos_prov->EditAttributes() ?>>
<?php echo $sosialisasi->sos_prov->SelectOptionListHtml("x_sos_prov") ?>
</select>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ewRow">
<?php if ($sosialisasi->sos_kab->Visible) { // sos_kab ?>
	<div id="xsc_sos_kab" class="ewCell form-group">
		<label for="x_sos_kab" class="ewSearchCaption ewLabel"><?php echo $sosialisasi->sos_kab->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_sos_kab" id="z_sos_kab" value="="></span>
		<span class="ewSearchField">
<?php $sosialisasi->sos_kab->EditAttrs["onchange"] = "ew_UpdateOpt.call(this); " . @$sosialisasi->sos_kab->EditAttrs["onchange"]; ?>
<select data-table="sosialisasi" data-field="x_sos_kab" data-value-separator="<?php echo $sosialisasi->sos_kab->DisplayValueSeparatorAttribute() ?>" id="x_sos_kab" name="x_sos_kab"<?php echo $sosialisasi->sos_kab->EditAttributes() ?>>
<?php echo $sosialisasi->sos_kab->SelectOptionListHtml("x_sos_kab") ?>
</select>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_5" class="ewRow">
<?php if ($sosialisasi->sos_kec->Visible) { // sos_kec ?>
	<div id="xsc_sos_kec" class="ewCell form-group">
		<label for="x_sos_kec" class="ewSearchCaption ewLabel"><?php echo $sosialisasi->sos_kec->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_sos_kec" id="z_sos_kec" value="="></span>
		<span class="ewSearchField">
<?php $sosialisasi->sos_kec->EditAttrs["onchange"] = "ew_UpdateOpt.call(this); " . @$sosialisasi->sos_kec->EditAttrs["onchange"]; ?>
<select data-table="sosialisasi" data-field="x_sos_kec" data-value-separator="<?php echo $sosialisasi->sos_kec->DisplayValueSeparatorAttribute() ?>" id="x_sos_kec" name="x_sos_kec"<?php echo $sosialisasi->sos_kec->EditAttributes() ?>>
<?php echo $sosialisasi->sos_kec->SelectOptionListHtml("x_sos_kec") ?>
</select>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_6" class="ewRow">
<?php if ($sosialisasi->sos_desa->Visible) { // sos_desa ?>
	<div id="xsc_sos_desa" class="ewCell form-group">
		<label for="x_sos_desa" class="ewSearchCaption ewLabel"><?php echo $sosialisasi->sos_desa->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_sos_desa" id="z_sos_desa" value="="></span>
		<span class="ewSearchField">
<select data-table="sosialisasi" data-field="x_sos_desa" data-value-separator="<?php echo $sosialisasi->sos_desa->DisplayValueSeparatorAttribute() ?>" id="x_sos_desa" name="x_sos_desa"<?php echo $sosialisasi->sos_desa->EditAttributes() ?>>
<?php echo $sosialisasi->sos_desa->SelectOptionListHtml("x_sos_desa") ?>
</select>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_7" class="ewRow">
	<div class="ewQuickSearch input-group">
	<input type="text" name="<?php echo EW_TABLE_BASIC_SEARCH ?>" id="<?php echo EW_TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo ew_HtmlEncode($sosialisasi_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo ew_HtmlEncode($Language->Phrase("Search")) ?>">
	<input type="hidden" name="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo ew_HtmlEncode($sosialisasi_list->BasicSearch->getType()) ?>">
	<div class="input-group-btn">
		<button type="button" data-toggle="dropdown" class="btn btn-default"><span id="searchtype"><?php echo $sosialisasi_list->BasicSearch->getTypeNameShort() ?></span><span class="caret"></span></button>
		<ul class="dropdown-menu pull-right" role="menu">
			<li<?php if ($sosialisasi_list->BasicSearch->getType() == "") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this)"><?php echo $Language->Phrase("QuickSearchAuto") ?></a></li>
			<li<?php if ($sosialisasi_list->BasicSearch->getType() == "=") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'=')"><?php echo $Language->Phrase("QuickSearchExact") ?></a></li>
			<li<?php if ($sosialisasi_list->BasicSearch->getType() == "AND") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'AND')"><?php echo $Language->Phrase("QuickSearchAll") ?></a></li>
			<li<?php if ($sosialisasi_list->BasicSearch->getType() == "OR") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'OR')"><?php echo $Language->Phrase("QuickSearchAny") ?></a></li>
		</ul>
	<button class="btn btn-primary ewButton" name="btnsubmit" id="btnsubmit" type="submit"><?php echo $Language->Phrase("SearchBtn") ?></button>
	</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $sosialisasi_list->ShowPageHeader(); ?>
<?php
$sosialisasi_list->ShowMessage();
?>
<?php if ($sosialisasi_list->TotalRecs > 0 || $sosialisasi->CurrentAction <> "") { ?>
<div class="box ewBox ewGrid<?php if ($sosialisasi_list->IsAddOrEdit()) { ?> ewGridAddEdit<?php } ?> sosialisasi">
<?php if ($sosialisasi->Export == "") { ?>
<div class="box-header ewGridUpperPanel">
<?php if ($sosialisasi->CurrentAction <> "gridadd" && $sosialisasi->CurrentAction <> "gridedit") { ?>
<form name="ewPagerForm" class="form-inline ewForm ewPagerForm" action="<?php echo ew_CurrentPage() ?>">
<?php if (!isset($sosialisasi_list->Pager)) $sosialisasi_list->Pager = new cNumericPager($sosialisasi_list->StartRec, $sosialisasi_list->DisplayRecs, $sosialisasi_list->TotalRecs, $sosialisasi_list->RecRange, $sosialisasi_list->AutoHidePager) ?>
<?php if ($sosialisasi_list->Pager->RecordCount > 0 && $sosialisasi_list->Pager->Visible) { ?>
<div class="ewPager">
<div class="ewNumericPage"><ul class="pagination">
	<?php if ($sosialisasi_list->Pager->FirstButton->Enabled) { ?>
	<li><a href="<?php echo $sosialisasi_list->PageUrl() ?>start=<?php echo $sosialisasi_list->Pager->FirstButton->Start ?>"><?php echo $Language->Phrase("PagerFirst") ?></a></li>
	<?php } ?>
	<?php if ($sosialisasi_list->Pager->PrevButton->Enabled) { ?>
	<li><a href="<?php echo $sosialisasi_list->PageUrl() ?>start=<?php echo $sosialisasi_list->Pager->PrevButton->Start ?>"><?php echo $Language->Phrase("PagerPrevious") ?></a></li>
	<?php } ?>
	<?php foreach ($sosialisasi_list->Pager->Items as $PagerItem) { ?>
		<li<?php if (!$PagerItem->Enabled) { echo " class=\" active\""; } ?>><a href="<?php if ($PagerItem->Enabled) { echo $sosialisasi_list->PageUrl() . "start=" . $PagerItem->Start; } else { echo "#"; } ?>"><?php echo $PagerItem->Text ?></a></li>
	<?php } ?>
	<?php if ($sosialisasi_list->Pager->NextButton->Enabled) { ?>
	<li><a href="<?php echo $sosialisasi_list->PageUrl() ?>start=<?php echo $sosialisasi_list->Pager->NextButton->Start ?>"><?php echo $Language->Phrase("PagerNext") ?></a></li>
	<?php } ?>
	<?php if ($sosialisasi_list->Pager->LastButton->Enabled) { ?>
	<li><a href="<?php echo $sosialisasi_list->PageUrl() ?>start=<?php echo $sosialisasi_list->Pager->LastButton->Start ?>"><?php echo $Language->Phrase("PagerLast") ?></a></li>
	<?php } ?>
</ul></div>
</div>
<?php } ?>
<?php if ($sosialisasi_list->Pager->RecordCount > 0) { ?>
<div class="ewPager ewRec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $sosialisasi_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $sosialisasi_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $sosialisasi_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ewListOtherOptions">
<?php
	foreach ($sosialisasi_list->OtherOptions as &$option)
		$option->Render("body");
?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fsosialisasilist" id="fsosialisasilist" class="form-inline ewForm ewListForm" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($sosialisasi_list->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $sosialisasi_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sosialisasi">
<div id="gmp_sosialisasi" class="<?php if (ew_IsResponsiveLayout()) { ?>table-responsive <?php } ?>ewGridMiddlePanel">
<?php if ($sosialisasi_list->TotalRecs > 0 || $sosialisasi->CurrentAction == "gridedit") { ?>
<table id="tbl_sosialisasilist" class="table ewTable">
<thead>
	<tr class="ewTableHeader">
<?php

// Header row
$sosialisasi_list->RowType = EW_ROWTYPE_HEADER;

// Render list options
$sosialisasi_list->RenderListOptions();

// Render list options (header, left)
$sosialisasi_list->ListOptions->Render("header", "left");
?>
<?php if ($sosialisasi->sos_id->Visible) { // sos_id ?>
	<?php if ($sosialisasi->SortUrl($sosialisasi->sos_id) == "") { ?>
		<th data-name="sos_id" class="<?php echo $sosialisasi->sos_id->HeaderCellClass() ?>"><div id="elh_sosialisasi_sos_id" class="sosialisasi_sos_id"><div class="ewTableHeaderCaption"><?php echo $sosialisasi->sos_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sos_id" class="<?php echo $sosialisasi->sos_id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $sosialisasi->SortUrl($sosialisasi->sos_id) ?>',1);"><div id="elh_sosialisasi_sos_id" class="sosialisasi_sos_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $sosialisasi->sos_id->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($sosialisasi->sos_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($sosialisasi->sos_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sosialisasi->sos_tgl->Visible) { // sos_tgl ?>
	<?php if ($sosialisasi->SortUrl($sosialisasi->sos_tgl) == "") { ?>
		<th data-name="sos_tgl" class="<?php echo $sosialisasi->sos_tgl->HeaderCellClass() ?>"><div id="elh_sosialisasi_sos_tgl" class="sosialisasi_sos_tgl"><div class="ewTableHeaderCaption"><?php echo $sosialisasi->sos_tgl->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sos_tgl" class="<?php echo $sosialisasi->sos_tgl->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $sosialisasi->SortUrl($sosialisasi->sos_tgl) ?>',1);"><div id="elh_sosialisasi_sos_tgl" class="sosialisasi_sos_tgl">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $sosialisasi->sos_tgl->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($sosialisasi->sos_tgl->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($sosialisasi->sos_tgl->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sosialisasi->sos_co->Visible) { // sos_co ?>
	<?php if ($sosialisasi->SortUrl($sosialisasi->sos_co) == "") { ?>
		<th data-name="sos_co" class="<?php echo $sosialisasi->sos_co->HeaderCellClass() ?>"><div id="elh_sosialisasi_sos_co" class="sosialisasi_sos_co"><div class="ewTableHeaderCaption"><?php echo $sosialisasi->sos_co->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sos_co" class="<?php echo $sosialisasi->sos_co->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $sosialisasi->SortUrl($sosialisasi->sos_co) ?>',1);"><div id="elh_sosialisasi_sos_co" class="sosialisasi_sos_co">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $sosialisasi->sos_co->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($sosialisasi->sos_co->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($sosialisasi->sos_co->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sosialisasi->sos_peserta->Visible) { // sos_peserta ?>
	<?php if ($sosialisasi->SortUrl($sosialisasi->sos_peserta) == "") { ?>
		<th data-name="sos_peserta" class="<?php echo $sosialisasi->sos_peserta->HeaderCellClass() ?>"><div id="elh_sosialisasi_sos_peserta" class="sosialisasi_sos_peserta"><div class="ewTableHeaderCaption"><?php echo $sosialisasi->sos_peserta->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sos_peserta" class="<?php echo $sosialisasi->sos_peserta->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $sosialisasi->SortUrl($sosialisasi->sos_peserta) ?>',1);"><div id="elh_sosialisasi_sos_peserta" class="sosialisasi_sos_peserta">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $sosialisasi->sos_peserta->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($sosialisasi->sos_peserta->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($sosialisasi->sos_peserta->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sosialisasi->sos_prov->Visible) { // sos_prov ?>
	<?php if ($sosialisasi->SortUrl($sosialisasi->sos_prov) == "") { ?>
		<th data-name="sos_prov" class="<?php echo $sosialisasi->sos_prov->HeaderCellClass() ?>"><div id="elh_sosialisasi_sos_prov" class="sosialisasi_sos_prov"><div class="ewTableHeaderCaption"><?php echo $sosialisasi->sos_prov->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sos_prov" class="<?php echo $sosialisasi->sos_prov->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $sosialisasi->SortUrl($sosialisasi->sos_prov) ?>',1);"><div id="elh_sosialisasi_sos_prov" class="sosialisasi_sos_prov">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $sosialisasi->sos_prov->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($sosialisasi->sos_prov->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($sosialisasi->sos_prov->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sosialisasi->sos_kab->Visible) { // sos_kab ?>
	<?php if ($sosialisasi->SortUrl($sosialisasi->sos_kab) == "") { ?>
		<th data-name="sos_kab" class="<?php echo $sosialisasi->sos_kab->HeaderCellClass() ?>"><div id="elh_sosialisasi_sos_kab" class="sosialisasi_sos_kab"><div class="ewTableHeaderCaption"><?php echo $sosialisasi->sos_kab->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sos_kab" class="<?php echo $sosialisasi->sos_kab->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $sosialisasi->SortUrl($sosialisasi->sos_kab) ?>',1);"><div id="elh_sosialisasi_sos_kab" class="sosialisasi_sos_kab">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $sosialisasi->sos_kab->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($sosialisasi->sos_kab->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($sosialisasi->sos_kab->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sosialisasi->sos_kec->Visible) { // sos_kec ?>
	<?php if ($sosialisasi->SortUrl($sosialisasi->sos_kec) == "") { ?>
		<th data-name="sos_kec" class="<?php echo $sosialisasi->sos_kec->HeaderCellClass() ?>"><div id="elh_sosialisasi_sos_kec" class="sosialisasi_sos_kec"><div class="ewTableHeaderCaption"><?php echo $sosialisasi->sos_kec->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sos_kec" class="<?php echo $sosialisasi->sos_kec->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $sosialisasi->SortUrl($sosialisasi->sos_kec) ?>',1);"><div id="elh_sosialisasi_sos_kec" class="sosialisasi_sos_kec">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $sosialisasi->sos_kec->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($sosialisasi->sos_kec->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($sosialisasi->sos_kec->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sosialisasi->sos_desa->Visible) { // sos_desa ?>
	<?php if ($sosialisasi->SortUrl($sosialisasi->sos_desa) == "") { ?>
		<th data-name="sos_desa" class="<?php echo $sosialisasi->sos_desa->HeaderCellClass() ?>"><div id="elh_sosialisasi_sos_desa" class="sosialisasi_sos_desa"><div class="ewTableHeaderCaption"><?php echo $sosialisasi->sos_desa->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sos_desa" class="<?php echo $sosialisasi->sos_desa->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $sosialisasi->SortUrl($sosialisasi->sos_desa) ?>',1);"><div id="elh_sosialisasi_sos_desa" class="sosialisasi_sos_desa">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $sosialisasi->sos_desa->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($sosialisasi->sos_desa->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($sosialisasi->sos_desa->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sosialisasi->sos_alamat->Visible) { // sos_alamat ?>
	<?php if ($sosialisasi->SortUrl($sosialisasi->sos_alamat) == "") { ?>
		<th data-name="sos_alamat" class="<?php echo $sosialisasi->sos_alamat->HeaderCellClass() ?>"><div id="elh_sosialisasi_sos_alamat" class="sosialisasi_sos_alamat"><div class="ewTableHeaderCaption"><?php echo $sosialisasi->sos_alamat->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sos_alamat" class="<?php echo $sosialisasi->sos_alamat->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $sosialisasi->SortUrl($sosialisasi->sos_alamat) ?>',1);"><div id="elh_sosialisasi_sos_alamat" class="sosialisasi_sos_alamat">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $sosialisasi->sos_alamat->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($sosialisasi->sos_alamat->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($sosialisasi->sos_alamat->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sosialisasi->sos_pot_lahan->Visible) { // sos_pot_lahan ?>
	<?php if ($sosialisasi->SortUrl($sosialisasi->sos_pot_lahan) == "") { ?>
		<th data-name="sos_pot_lahan" class="<?php echo $sosialisasi->sos_pot_lahan->HeaderCellClass() ?>"><div id="elh_sosialisasi_sos_pot_lahan" class="sosialisasi_sos_pot_lahan"><div class="ewTableHeaderCaption"><?php echo $sosialisasi->sos_pot_lahan->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sos_pot_lahan" class="<?php echo $sosialisasi->sos_pot_lahan->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $sosialisasi->SortUrl($sosialisasi->sos_pot_lahan) ?>',1);"><div id="elh_sosialisasi_sos_pot_lahan" class="sosialisasi_sos_pot_lahan">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $sosialisasi->sos_pot_lahan->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($sosialisasi->sos_pot_lahan->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($sosialisasi->sos_pot_lahan->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sosialisasi->sos_katinggian->Visible) { // sos_katinggian ?>
	<?php if ($sosialisasi->SortUrl($sosialisasi->sos_katinggian) == "") { ?>
		<th data-name="sos_katinggian" class="<?php echo $sosialisasi->sos_katinggian->HeaderCellClass() ?>"><div id="elh_sosialisasi_sos_katinggian" class="sosialisasi_sos_katinggian"><div class="ewTableHeaderCaption"><?php echo $sosialisasi->sos_katinggian->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sos_katinggian" class="<?php echo $sosialisasi->sos_katinggian->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $sosialisasi->SortUrl($sosialisasi->sos_katinggian) ?>',1);"><div id="elh_sosialisasi_sos_katinggian" class="sosialisasi_sos_katinggian">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $sosialisasi->sos_katinggian->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($sosialisasi->sos_katinggian->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($sosialisasi->sos_katinggian->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sosialisasi->sos_biaya->Visible) { // sos_biaya ?>
	<?php if ($sosialisasi->SortUrl($sosialisasi->sos_biaya) == "") { ?>
		<th data-name="sos_biaya" class="<?php echo $sosialisasi->sos_biaya->HeaderCellClass() ?>"><div id="elh_sosialisasi_sos_biaya" class="sosialisasi_sos_biaya"><div class="ewTableHeaderCaption"><?php echo $sosialisasi->sos_biaya->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sos_biaya" class="<?php echo $sosialisasi->sos_biaya->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $sosialisasi->SortUrl($sosialisasi->sos_biaya) ?>',1);"><div id="elh_sosialisasi_sos_biaya" class="sosialisasi_sos_biaya">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $sosialisasi->sos_biaya->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($sosialisasi->sos_biaya->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($sosialisasi->sos_biaya->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sosialisasi->sos_kesimpulan->Visible) { // sos_kesimpulan ?>
	<?php if ($sosialisasi->SortUrl($sosialisasi->sos_kesimpulan) == "") { ?>
		<th data-name="sos_kesimpulan" class="<?php echo $sosialisasi->sos_kesimpulan->HeaderCellClass() ?>"><div id="elh_sosialisasi_sos_kesimpulan" class="sosialisasi_sos_kesimpulan"><div class="ewTableHeaderCaption"><?php echo $sosialisasi->sos_kesimpulan->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sos_kesimpulan" class="<?php echo $sosialisasi->sos_kesimpulan->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $sosialisasi->SortUrl($sosialisasi->sos_kesimpulan) ?>',1);"><div id="elh_sosialisasi_sos_kesimpulan" class="sosialisasi_sos_kesimpulan">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $sosialisasi->sos_kesimpulan->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($sosialisasi->sos_kesimpulan->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($sosialisasi->sos_kesimpulan->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sosialisasi->sos_foto->Visible) { // sos_foto ?>
	<?php if ($sosialisasi->SortUrl($sosialisasi->sos_foto) == "") { ?>
		<th data-name="sos_foto" class="<?php echo $sosialisasi->sos_foto->HeaderCellClass() ?>"><div id="elh_sosialisasi_sos_foto" class="sosialisasi_sos_foto"><div class="ewTableHeaderCaption"><?php echo $sosialisasi->sos_foto->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sos_foto" class="<?php echo $sosialisasi->sos_foto->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $sosialisasi->SortUrl($sosialisasi->sos_foto) ?>',1);"><div id="elh_sosialisasi_sos_foto" class="sosialisasi_sos_foto">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $sosialisasi->sos_foto->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($sosialisasi->sos_foto->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($sosialisasi->sos_foto->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$sosialisasi_list->ListOptions->Render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($sosialisasi->ExportAll && $sosialisasi->Export <> "") {
	$sosialisasi_list->StopRec = $sosialisasi_list->TotalRecs;
} else {

	// Set the last record to display
	if ($sosialisasi_list->TotalRecs > $sosialisasi_list->StartRec + $sosialisasi_list->DisplayRecs - 1)
		$sosialisasi_list->StopRec = $sosialisasi_list->StartRec + $sosialisasi_list->DisplayRecs - 1;
	else
		$sosialisasi_list->StopRec = $sosialisasi_list->TotalRecs;
}
$sosialisasi_list->RecCnt = $sosialisasi_list->StartRec - 1;
if ($sosialisasi_list->Recordset && !$sosialisasi_list->Recordset->EOF) {
	$sosialisasi_list->Recordset->MoveFirst();
	$bSelectLimit = $sosialisasi_list->UseSelectLimit;
	if (!$bSelectLimit && $sosialisasi_list->StartRec > 1)
		$sosialisasi_list->Recordset->Move($sosialisasi_list->StartRec - 1);
} elseif (!$sosialisasi->AllowAddDeleteRow && $sosialisasi_list->StopRec == 0) {
	$sosialisasi_list->StopRec = $sosialisasi->GridAddRowCount;
}

// Initialize aggregate
$sosialisasi->RowType = EW_ROWTYPE_AGGREGATEINIT;
$sosialisasi->ResetAttrs();
$sosialisasi_list->RenderRow();
while ($sosialisasi_list->RecCnt < $sosialisasi_list->StopRec) {
	$sosialisasi_list->RecCnt++;
	if (intval($sosialisasi_list->RecCnt) >= intval($sosialisasi_list->StartRec)) {
		$sosialisasi_list->RowCnt++;

		// Set up key count
		$sosialisasi_list->KeyCount = $sosialisasi_list->RowIndex;

		// Init row class and style
		$sosialisasi->ResetAttrs();
		$sosialisasi->CssClass = "";
		if ($sosialisasi->CurrentAction == "gridadd") {
		} else {
			$sosialisasi_list->LoadRowValues($sosialisasi_list->Recordset); // Load row values
		}
		$sosialisasi->RowType = EW_ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$sosialisasi->RowAttrs = array_merge($sosialisasi->RowAttrs, array('data-rowindex'=>$sosialisasi_list->RowCnt, 'id'=>'r' . $sosialisasi_list->RowCnt . '_sosialisasi', 'data-rowtype'=>$sosialisasi->RowType));

		// Render row
		$sosialisasi_list->RenderRow();

		// Render list options
		$sosialisasi_list->RenderListOptions();
?>
	<tr<?php echo $sosialisasi->RowAttributes() ?>>
<?php

// Render list options (body, left)
$sosialisasi_list->ListOptions->Render("body", "left", $sosialisasi_list->RowCnt);
?>
	<?php if ($sosialisasi->sos_id->Visible) { // sos_id ?>
		<td data-name="sos_id"<?php echo $sosialisasi->sos_id->CellAttributes() ?>>
<span id="el<?php echo $sosialisasi_list->RowCnt ?>_sosialisasi_sos_id" class="sosialisasi_sos_id">
<span<?php echo $sosialisasi->sos_id->ViewAttributes() ?>>
<?php echo $sosialisasi->sos_id->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sosialisasi->sos_tgl->Visible) { // sos_tgl ?>
		<td data-name="sos_tgl"<?php echo $sosialisasi->sos_tgl->CellAttributes() ?>>
<span id="el<?php echo $sosialisasi_list->RowCnt ?>_sosialisasi_sos_tgl" class="sosialisasi_sos_tgl">
<span<?php echo $sosialisasi->sos_tgl->ViewAttributes() ?>>
<?php echo $sosialisasi->sos_tgl->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sosialisasi->sos_co->Visible) { // sos_co ?>
		<td data-name="sos_co"<?php echo $sosialisasi->sos_co->CellAttributes() ?>>
<span id="el<?php echo $sosialisasi_list->RowCnt ?>_sosialisasi_sos_co" class="sosialisasi_sos_co">
<span<?php echo $sosialisasi->sos_co->ViewAttributes() ?>>
<?php echo $sosialisasi->sos_co->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sosialisasi->sos_peserta->Visible) { // sos_peserta ?>
		<td data-name="sos_peserta"<?php echo $sosialisasi->sos_peserta->CellAttributes() ?>>
<span id="el<?php echo $sosialisasi_list->RowCnt ?>_sosialisasi_sos_peserta" class="sosialisasi_sos_peserta">
<span<?php echo $sosialisasi->sos_peserta->ViewAttributes() ?>>
<?php echo $sosialisasi->sos_peserta->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sosialisasi->sos_prov->Visible) { // sos_prov ?>
		<td data-name="sos_prov"<?php echo $sosialisasi->sos_prov->CellAttributes() ?>>
<span id="el<?php echo $sosialisasi_list->RowCnt ?>_sosialisasi_sos_prov" class="sosialisasi_sos_prov">
<span<?php echo $sosialisasi->sos_prov->ViewAttributes() ?>>
<?php echo $sosialisasi->sos_prov->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sosialisasi->sos_kab->Visible) { // sos_kab ?>
		<td data-name="sos_kab"<?php echo $sosialisasi->sos_kab->CellAttributes() ?>>
<span id="el<?php echo $sosialisasi_list->RowCnt ?>_sosialisasi_sos_kab" class="sosialisasi_sos_kab">
<span<?php echo $sosialisasi->sos_kab->ViewAttributes() ?>>
<?php echo $sosialisasi->sos_kab->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sosialisasi->sos_kec->Visible) { // sos_kec ?>
		<td data-name="sos_kec"<?php echo $sosialisasi->sos_kec->CellAttributes() ?>>
<span id="el<?php echo $sosialisasi_list->RowCnt ?>_sosialisasi_sos_kec" class="sosialisasi_sos_kec">
<span<?php echo $sosialisasi->sos_kec->ViewAttributes() ?>>
<?php echo $sosialisasi->sos_kec->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sosialisasi->sos_desa->Visible) { // sos_desa ?>
		<td data-name="sos_desa"<?php echo $sosialisasi->sos_desa->CellAttributes() ?>>
<span id="el<?php echo $sosialisasi_list->RowCnt ?>_sosialisasi_sos_desa" class="sosialisasi_sos_desa">
<span<?php echo $sosialisasi->sos_desa->ViewAttributes() ?>>
<?php echo $sosialisasi->sos_desa->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sosialisasi->sos_alamat->Visible) { // sos_alamat ?>
		<td data-name="sos_alamat"<?php echo $sosialisasi->sos_alamat->CellAttributes() ?>>
<span id="el<?php echo $sosialisasi_list->RowCnt ?>_sosialisasi_sos_alamat" class="sosialisasi_sos_alamat">
<span<?php echo $sosialisasi->sos_alamat->ViewAttributes() ?>>
<?php echo $sosialisasi->sos_alamat->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sosialisasi->sos_pot_lahan->Visible) { // sos_pot_lahan ?>
		<td data-name="sos_pot_lahan"<?php echo $sosialisasi->sos_pot_lahan->CellAttributes() ?>>
<span id="el<?php echo $sosialisasi_list->RowCnt ?>_sosialisasi_sos_pot_lahan" class="sosialisasi_sos_pot_lahan">
<span<?php echo $sosialisasi->sos_pot_lahan->ViewAttributes() ?>>
<?php echo $sosialisasi->sos_pot_lahan->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sosialisasi->sos_katinggian->Visible) { // sos_katinggian ?>
		<td data-name="sos_katinggian"<?php echo $sosialisasi->sos_katinggian->CellAttributes() ?>>
<span id="el<?php echo $sosialisasi_list->RowCnt ?>_sosialisasi_sos_katinggian" class="sosialisasi_sos_katinggian">
<span<?php echo $sosialisasi->sos_katinggian->ViewAttributes() ?>>
<?php echo $sosialisasi->sos_katinggian->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sosialisasi->sos_biaya->Visible) { // sos_biaya ?>
		<td data-name="sos_biaya"<?php echo $sosialisasi->sos_biaya->CellAttributes() ?>>
<span id="el<?php echo $sosialisasi_list->RowCnt ?>_sosialisasi_sos_biaya" class="sosialisasi_sos_biaya">
<span<?php echo $sosialisasi->sos_biaya->ViewAttributes() ?>>
<?php echo $sosialisasi->sos_biaya->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sosialisasi->sos_kesimpulan->Visible) { // sos_kesimpulan ?>
		<td data-name="sos_kesimpulan"<?php echo $sosialisasi->sos_kesimpulan->CellAttributes() ?>>
<span id="el<?php echo $sosialisasi_list->RowCnt ?>_sosialisasi_sos_kesimpulan" class="sosialisasi_sos_kesimpulan">
<span<?php echo $sosialisasi->sos_kesimpulan->ViewAttributes() ?>>
<?php echo $sosialisasi->sos_kesimpulan->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sosialisasi->sos_foto->Visible) { // sos_foto ?>
		<td data-name="sos_foto"<?php echo $sosialisasi->sos_foto->CellAttributes() ?>>
<span id="el<?php echo $sosialisasi_list->RowCnt ?>_sosialisasi_sos_foto" class="sosialisasi_sos_foto">
<span>
<?php echo ew_GetFileViewTag($sosialisasi->sos_foto, $sosialisasi->sos_foto->ListViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$sosialisasi_list->ListOptions->Render("body", "right", $sosialisasi_list->RowCnt);
?>
	</tr>
<?php
	}
	if ($sosialisasi->CurrentAction <> "gridadd")
		$sosialisasi_list->Recordset->MoveNext();
}
?>
</tbody>
</table>
<?php } ?>
<?php if ($sosialisasi->CurrentAction == "") { ?>
<input type="hidden" name="a_list" id="a_list" value="">
<?php } ?>
</div>
</form>
<?php

// Close recordset
if ($sosialisasi_list->Recordset)
	$sosialisasi_list->Recordset->Close();
?>
<?php if ($sosialisasi->Export == "") { ?>
<div class="box-footer ewGridLowerPanel">
<?php if ($sosialisasi->CurrentAction <> "gridadd" && $sosialisasi->CurrentAction <> "gridedit") { ?>
<form name="ewPagerForm" class="ewForm form-inline ewPagerForm" action="<?php echo ew_CurrentPage() ?>">
<?php if (!isset($sosialisasi_list->Pager)) $sosialisasi_list->Pager = new cNumericPager($sosialisasi_list->StartRec, $sosialisasi_list->DisplayRecs, $sosialisasi_list->TotalRecs, $sosialisasi_list->RecRange, $sosialisasi_list->AutoHidePager) ?>
<?php if ($sosialisasi_list->Pager->RecordCount > 0 && $sosialisasi_list->Pager->Visible) { ?>
<div class="ewPager">
<div class="ewNumericPage"><ul class="pagination">
	<?php if ($sosialisasi_list->Pager->FirstButton->Enabled) { ?>
	<li><a href="<?php echo $sosialisasi_list->PageUrl() ?>start=<?php echo $sosialisasi_list->Pager->FirstButton->Start ?>"><?php echo $Language->Phrase("PagerFirst") ?></a></li>
	<?php } ?>
	<?php if ($sosialisasi_list->Pager->PrevButton->Enabled) { ?>
	<li><a href="<?php echo $sosialisasi_list->PageUrl() ?>start=<?php echo $sosialisasi_list->Pager->PrevButton->Start ?>"><?php echo $Language->Phrase("PagerPrevious") ?></a></li>
	<?php } ?>
	<?php foreach ($sosialisasi_list->Pager->Items as $PagerItem) { ?>
		<li<?php if (!$PagerItem->Enabled) { echo " class=\" active\""; } ?>><a href="<?php if ($PagerItem->Enabled) { echo $sosialisasi_list->PageUrl() . "start=" . $PagerItem->Start; } else { echo "#"; } ?>"><?php echo $PagerItem->Text ?></a></li>
	<?php } ?>
	<?php if ($sosialisasi_list->Pager->NextButton->Enabled) { ?>
	<li><a href="<?php echo $sosialisasi_list->PageUrl() ?>start=<?php echo $sosialisasi_list->Pager->NextButton->Start ?>"><?php echo $Language->Phrase("PagerNext") ?></a></li>
	<?php } ?>
	<?php if ($sosialisasi_list->Pager->LastButton->Enabled) { ?>
	<li><a href="<?php echo $sosialisasi_list->PageUrl() ?>start=<?php echo $sosialisasi_list->Pager->LastButton->Start ?>"><?php echo $Language->Phrase("PagerLast") ?></a></li>
	<?php } ?>
</ul></div>
</div>
<?php } ?>
<?php if ($sosialisasi_list->Pager->RecordCount > 0) { ?>
<div class="ewPager ewRec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $sosialisasi_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $sosialisasi_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $sosialisasi_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ewListOtherOptions">
<?php
	foreach ($sosialisasi_list->OtherOptions as &$option)
		$option->Render("body", "bottom");
?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div>
<?php } ?>
<?php if ($sosialisasi_list->TotalRecs == 0 && $sosialisasi->CurrentAction == "") { // Show other options ?>
<div class="ewListOtherOptions">
<?php
	foreach ($sosialisasi_list->OtherOptions as &$option) {
		$option->ButtonClass = "";
		$option->Render("body", "");
	}
?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php if ($sosialisasi->Export == "") { ?>
<script type="text/javascript">
fsosialisasilistsrch.FilterList = <?php echo $sosialisasi_list->GetFilterList() ?>;
fsosialisasilistsrch.Init();
fsosialisasilist.Init();
</script>
<?php } ?>
<?php
$sosialisasi_list->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<?php if ($sosialisasi->Export == "") { ?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$sosialisasi_list->Page_Terminate();
?>
