<?php
if (session_id() == "") session_start(); // Init session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg14.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql14.php") ?>
<?php include_once "phpfn14.php" ?>
<?php include_once "koordinfo.php" ?>
<?php include_once "employeesinfo.php" ?>
<?php include_once "userfn14.php" ?>
<?php

//
// Page class
//

$koord_edit = NULL; // Initialize page object first

class ckoord_edit extends ckoord {

	// Page ID
	var $PageID = 'edit';

	// Project ID
	var $ProjectID = '{CC60B42B-604B-412A-B014-2315920AF6AA}';

	// Table name
	var $TableName = 'koord';

	// Page object name
	var $PageObjName = 'koord_edit';

	// Page headings
	var $Heading = '';
	var $Subheading = '';

	// Page heading
	function PageHeading() {
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->TableCaption();
		return "";
	}

	// Page subheading
	function PageSubheading() {
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->Phrase($this->PageID);
		return "";
	}

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (koord)
		if (!isset($GLOBALS["koord"]) || get_class($GLOBALS["koord"]) == "ckoord") {
			$GLOBALS["koord"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["koord"];
		}

		// Table object (employees)
		if (!isset($GLOBALS['employees'])) $GLOBALS['employees'] = new cemployees();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'edit', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'koord', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"]))
			$GLOBALS["gTimer"] = new cTimer();

		// Debug message
		ew_LoadDebugMsg();

		// Open connection
		if (!isset($conn))
			$conn = ew_Connect($this->DBID);

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new cemployees();
			$UserTableConn = Conn($UserTable->DBID);
		}
	}

	//
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Is modal
		$this->IsModal = (@$_GET["modal"] == "1" || @$_POST["modal"] == "1");

		// User profile
		$UserProfile = new cUserProfile();

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanEdit()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			if ($Security->CanList())
				$this->Page_Terminate(ew_GetUrl("koordlist.php"));
			else
				$this->Page_Terminate(ew_GetUrl("login.php"));
		}

		// NOTE: Security object may be needed in other part of the script, skip set to Nothing
		// 
		// Security = null;
		// 
		// Create form object

		$objForm = new cFormObj();
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action
		$this->koord_id->SetVisibility();
		if ($this->IsAdd() || $this->IsCopy() || $this->IsGridAdd())
			$this->koord_id->Visible = FALSE;
		$this->koord_nama->SetVisibility();
		$this->koord_alamat->SetVisibility();
		$this->koord_hp->SetVisibility();
		$this->koord_foto->SetVisibility();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $koord;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($koord);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		// Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = ew_GetPageName($url);
				if ($pageName != $this->GetListUrl()) { // Not List page
					$row["caption"] = $this->GetModalCaption($pageName);
					if ($pageName == "koordview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				header("Content-Type: application/json; charset=utf-8");
				echo ew_ConvertToUtf8(ew_ArrayToJson(array($row)));
			} else {
				ew_SaveDebugMsg();
				header("Location: " . $url);
			}
		}
		exit();
	}
	var $FormClassName = "form-horizontal ewForm ewEditForm";
	var $IsModal = FALSE;
	var $IsMobileOrModal = FALSE;
	var $DbMasterFilter;
	var $DbDetailFilter;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError, $gbSkipHeaderFooter;

		// Check modal
		if ($this->IsModal)
			$gbSkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = ew_IsMobile() || $this->IsModal;
		$this->FormClassName = "ewForm ewEditForm form-horizontal";
		$sReturnUrl = "";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (@$_POST["a_edit"] <> "") {
			$this->CurrentAction = $_POST["a_edit"]; // Get action code
			if ($this->CurrentAction <> "I") // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($objForm->HasValue("x_koord_id")) {
				$this->koord_id->setFormValue($objForm->GetValue("x_koord_id"));
			}
		} else {
			$this->CurrentAction = "I"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (isset($_GET["koord_id"])) {
				$this->koord_id->setQueryStringValue($_GET["koord_id"]);
				$loadByQuery = TRUE;
			} else {
				$this->koord_id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->LoadRow();

		// Process form if post back
		if ($postBack) {
			$this->LoadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->ValidateForm()) {
				$this->CurrentAction = ""; // Form error, reset action
				$this->setFailureMessage($gsFormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->RestoreFormValues();
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "I": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "") $this->setFailureMessage($Language->Phrase("NoRecord")); // No record found
					$this->Page_Terminate("koordlist.php"); // No matching record, return to list
				}
				break;
			Case "U": // Update
				$sReturnUrl = $this->getReturnUrl();
				if (ew_GetPageName($sReturnUrl) == "koordlist.php")
					$sReturnUrl = $this->AddMasterUrl($sReturnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->EditRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->Phrase("UpdateSuccess")); // Update success
					$this->Page_Terminate($sReturnUrl); // Return to caller
				} elseif ($this->getFailureMessage() == $Language->Phrase("NoRecord")) {
					$this->Page_Terminate($sReturnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->RestoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->SetupBreadcrumb();

		// Render the record
		$this->RowType = EW_ROWTYPE_EDIT; // Render as Edit
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Set up starting record parameters
	function SetupStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	function GetUploadFiles() {
		global $objForm, $Language;

		// Get upload data
		$this->koord_foto->Upload->Index = $objForm->Index;
		$this->koord_foto->Upload->UploadFile();
		$this->koord_foto->CurrentValue = $this->koord_foto->Upload->FileName;
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm;
		$this->GetUploadFiles(); // Get upload files
		if (!$this->koord_id->FldIsDetailKey)
			$this->koord_id->setFormValue($objForm->GetValue("x_koord_id"));
		if (!$this->koord_nama->FldIsDetailKey) {
			$this->koord_nama->setFormValue($objForm->GetValue("x_koord_nama"));
		}
		if (!$this->koord_alamat->FldIsDetailKey) {
			$this->koord_alamat->setFormValue($objForm->GetValue("x_koord_alamat"));
		}
		if (!$this->koord_hp->FldIsDetailKey) {
			$this->koord_hp->setFormValue($objForm->GetValue("x_koord_hp"));
		}
	}

	// Restore form values
	function RestoreFormValues() {
		global $objForm;
		$this->koord_id->CurrentValue = $this->koord_id->FormValue;
		$this->koord_nama->CurrentValue = $this->koord_nama->FormValue;
		$this->koord_alamat->CurrentValue = $this->koord_alamat->FormValue;
		$this->koord_hp->CurrentValue = $this->koord_hp->FormValue;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues($rs = NULL) {
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->NewRow(); 

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->koord_id->setDbValue($row['koord_id']);
		$this->koord_nama->setDbValue($row['koord_nama']);
		$this->koord_alamat->setDbValue($row['koord_alamat']);
		$this->koord_hp->setDbValue($row['koord_hp']);
		$this->koord_foto->Upload->DbValue = $row['koord_foto'];
		$this->koord_foto->setDbValue($this->koord_foto->Upload->DbValue);
	}

	// Return a row with default values
	function NewRow() {
		$row = array();
		$row['koord_id'] = NULL;
		$row['koord_nama'] = NULL;
		$row['koord_alamat'] = NULL;
		$row['koord_hp'] = NULL;
		$row['koord_foto'] = NULL;
		return $row;
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->koord_id->DbValue = $row['koord_id'];
		$this->koord_nama->DbValue = $row['koord_nama'];
		$this->koord_alamat->DbValue = $row['koord_alamat'];
		$this->koord_hp->DbValue = $row['koord_hp'];
		$this->koord_foto->Upload->DbValue = $row['koord_foto'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("koord_id")) <> "")
			$this->koord_id->CurrentValue = $this->getKey("koord_id"); // koord_id
		else
			$bValidKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
		}
		$this->LoadRowValues($this->OldRecordset); // Load row values
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// koord_id
		// koord_nama
		// koord_alamat
		// koord_hp
		// koord_foto

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// koord_id
		$this->koord_id->ViewValue = $this->koord_id->CurrentValue;
		$this->koord_id->ViewCustomAttributes = "";

		// koord_nama
		$this->koord_nama->ViewValue = $this->koord_nama->CurrentValue;
		$this->koord_nama->ViewCustomAttributes = "";

		// koord_alamat
		$this->koord_alamat->ViewValue = $this->koord_alamat->CurrentValue;
		$this->koord_alamat->ViewCustomAttributes = "";

		// koord_hp
		$this->koord_hp->ViewValue = $this->koord_hp->CurrentValue;
		$this->koord_hp->ViewCustomAttributes = "";

		// koord_foto
		$this->koord_foto->UploadPath = "foto_koordinator";
		if (!ew_Empty($this->koord_foto->Upload->DbValue)) {
			$this->koord_foto->ImageWidth = 30;
			$this->koord_foto->ImageHeight = 40;
			$this->koord_foto->ImageAlt = $this->koord_foto->FldAlt();
			$this->koord_foto->ViewValue = $this->koord_foto->Upload->DbValue;
		} else {
			$this->koord_foto->ViewValue = "";
		}
		$this->koord_foto->ViewCustomAttributes = "";

			// koord_id
			$this->koord_id->LinkCustomAttributes = "";
			$this->koord_id->HrefValue = "";
			$this->koord_id->TooltipValue = "";

			// koord_nama
			$this->koord_nama->LinkCustomAttributes = "";
			$this->koord_nama->HrefValue = "";
			$this->koord_nama->TooltipValue = "";

			// koord_alamat
			$this->koord_alamat->LinkCustomAttributes = "";
			$this->koord_alamat->HrefValue = "";
			$this->koord_alamat->TooltipValue = "";

			// koord_hp
			$this->koord_hp->LinkCustomAttributes = "";
			$this->koord_hp->HrefValue = "";
			$this->koord_hp->TooltipValue = "";

			// koord_foto
			$this->koord_foto->LinkCustomAttributes = "";
			$this->koord_foto->UploadPath = "foto_koordinator";
			if (!ew_Empty($this->koord_foto->Upload->DbValue)) {
				$this->koord_foto->HrefValue = ew_GetFileUploadUrl($this->koord_foto, $this->koord_foto->Upload->DbValue); // Add prefix/suffix
				$this->koord_foto->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->koord_foto->HrefValue = ew_FullUrl($this->koord_foto->HrefValue, "href");
			} else {
				$this->koord_foto->HrefValue = "";
			}
			$this->koord_foto->HrefValue2 = $this->koord_foto->UploadPath . $this->koord_foto->Upload->DbValue;
			$this->koord_foto->TooltipValue = "";
			if ($this->koord_foto->UseColorbox) {
				if (ew_Empty($this->koord_foto->TooltipValue))
					$this->koord_foto->LinkAttrs["title"] = $Language->Phrase("ViewImageGallery");
				$this->koord_foto->LinkAttrs["data-rel"] = "koord_x_koord_foto";
				ew_AppendClass($this->koord_foto->LinkAttrs["class"], "ewLightbox");
			}
		} elseif ($this->RowType == EW_ROWTYPE_EDIT) { // Edit row

			// koord_id
			$this->koord_id->EditAttrs["class"] = "form-control";
			$this->koord_id->EditCustomAttributes = "";
			$this->koord_id->EditValue = $this->koord_id->CurrentValue;
			$this->koord_id->ViewCustomAttributes = "";

			// koord_nama
			$this->koord_nama->EditAttrs["class"] = "form-control";
			$this->koord_nama->EditCustomAttributes = "";
			$this->koord_nama->EditValue = ew_HtmlEncode($this->koord_nama->CurrentValue);
			$this->koord_nama->PlaceHolder = ew_RemoveHtml($this->koord_nama->FldCaption());

			// koord_alamat
			$this->koord_alamat->EditAttrs["class"] = "form-control";
			$this->koord_alamat->EditCustomAttributes = "";
			$this->koord_alamat->EditValue = ew_HtmlEncode($this->koord_alamat->CurrentValue);
			$this->koord_alamat->PlaceHolder = ew_RemoveHtml($this->koord_alamat->FldCaption());

			// koord_hp
			$this->koord_hp->EditAttrs["class"] = "form-control";
			$this->koord_hp->EditCustomAttributes = "";
			$this->koord_hp->EditValue = ew_HtmlEncode($this->koord_hp->CurrentValue);
			$this->koord_hp->PlaceHolder = ew_RemoveHtml($this->koord_hp->FldCaption());

			// koord_foto
			$this->koord_foto->EditAttrs["class"] = "form-control";
			$this->koord_foto->EditCustomAttributes = "";
			$this->koord_foto->UploadPath = "foto_koordinator";
			if (!ew_Empty($this->koord_foto->Upload->DbValue)) {
				$this->koord_foto->ImageWidth = 30;
				$this->koord_foto->ImageHeight = 40;
				$this->koord_foto->ImageAlt = $this->koord_foto->FldAlt();
				$this->koord_foto->EditValue = $this->koord_foto->Upload->DbValue;
			} else {
				$this->koord_foto->EditValue = "";
			}
			if (!ew_Empty($this->koord_foto->CurrentValue))
					$this->koord_foto->Upload->FileName = $this->koord_foto->CurrentValue;
			if ($this->CurrentAction == "I" && !$this->EventCancelled) ew_RenderUploadField($this->koord_foto);

			// Edit refer script
			// koord_id

			$this->koord_id->LinkCustomAttributes = "";
			$this->koord_id->HrefValue = "";

			// koord_nama
			$this->koord_nama->LinkCustomAttributes = "";
			$this->koord_nama->HrefValue = "";

			// koord_alamat
			$this->koord_alamat->LinkCustomAttributes = "";
			$this->koord_alamat->HrefValue = "";

			// koord_hp
			$this->koord_hp->LinkCustomAttributes = "";
			$this->koord_hp->HrefValue = "";

			// koord_foto
			$this->koord_foto->LinkCustomAttributes = "";
			$this->koord_foto->UploadPath = "foto_koordinator";
			if (!ew_Empty($this->koord_foto->Upload->DbValue)) {
				$this->koord_foto->HrefValue = ew_GetFileUploadUrl($this->koord_foto, $this->koord_foto->Upload->DbValue); // Add prefix/suffix
				$this->koord_foto->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->koord_foto->HrefValue = ew_FullUrl($this->koord_foto->HrefValue, "href");
			} else {
				$this->koord_foto->HrefValue = "";
			}
			$this->koord_foto->HrefValue2 = $this->koord_foto->UploadPath . $this->koord_foto->Upload->DbValue;
		}
		if ($this->RowType == EW_ROWTYPE_ADD || $this->RowType == EW_ROWTYPE_EDIT || $this->RowType == EW_ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->SetupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $Language, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return ($gsFormError == "");
		if (!ew_CheckInteger($this->koord_id->FormValue)) {
			ew_AddMessage($gsFormError, $this->koord_id->FldErrMsg());
		}
		if (!ew_CheckInteger($this->koord_hp->FormValue)) {
			ew_AddMessage($gsFormError, $this->koord_hp->FldErrMsg());
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsFormError, $sFormCustomError);
		}
		return $ValidateForm;
	}

	// Update record based on key values
	function EditRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();
		$sFilter = $this->ApplyUserIDFilters($sFilter);
		$conn = &$this->Connection();
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
		$rs = $conn->Execute($sSql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->Phrase("NoRecord")); // Set no record message
			$EditRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->LoadDbValues($rsold);
			$this->koord_foto->OldUploadPath = "foto_koordinator";
			$this->koord_foto->UploadPath = $this->koord_foto->OldUploadPath;
			$rsnew = array();

			// koord_nama
			$this->koord_nama->SetDbValueDef($rsnew, $this->koord_nama->CurrentValue, NULL, $this->koord_nama->ReadOnly);

			// koord_alamat
			$this->koord_alamat->SetDbValueDef($rsnew, $this->koord_alamat->CurrentValue, NULL, $this->koord_alamat->ReadOnly);

			// koord_hp
			$this->koord_hp->SetDbValueDef($rsnew, $this->koord_hp->CurrentValue, NULL, $this->koord_hp->ReadOnly);

			// koord_foto
			if ($this->koord_foto->Visible && !$this->koord_foto->ReadOnly && !$this->koord_foto->Upload->KeepFile) {
				$this->koord_foto->Upload->DbValue = $rsold['koord_foto']; // Get original value
				if ($this->koord_foto->Upload->FileName == "") {
					$rsnew['koord_foto'] = NULL;
				} else {
					$rsnew['koord_foto'] = $this->koord_foto->Upload->FileName;
				}
				$this->koord_foto->ImageWidth = 300; // Resize width
				$this->koord_foto->ImageHeight = 400; // Resize height
			}
			if ($this->koord_foto->Visible && !$this->koord_foto->Upload->KeepFile) {
				$this->koord_foto->UploadPath = "foto_koordinator";
				$OldFiles = ew_Empty($this->koord_foto->Upload->DbValue) ? array() : array($this->koord_foto->Upload->DbValue);
				if (!ew_Empty($this->koord_foto->Upload->FileName)) {
					$NewFiles = array($this->koord_foto->Upload->FileName);
					$NewFileCount = count($NewFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						$fldvar = ($this->koord_foto->Upload->Index < 0) ? $this->koord_foto->FldVar : substr($this->koord_foto->FldVar, 0, 1) . $this->koord_foto->Upload->Index . substr($this->koord_foto->FldVar, 1);
						if ($NewFiles[$i] <> "") {
							$file = $NewFiles[$i];
							if (file_exists(ew_UploadTempPath($fldvar, $this->koord_foto->TblVar) . $file)) {
								$OldFileFound = FALSE;
								$OldFileCount = count($OldFiles);
								for ($j = 0; $j < $OldFileCount; $j++) {
									$file1 = $OldFiles[$j];
									if ($file1 == $file) { // Old file found, no need to delete anymore
										unset($OldFiles[$j]);
										$OldFileFound = TRUE;
										break;
									}
								}
								if ($OldFileFound) // No need to check if file exists further
									continue;
								$file1 = ew_UploadFileNameEx($this->koord_foto->PhysicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(ew_UploadTempPath($fldvar, $this->koord_foto->TblVar) . $file1) || file_exists($this->koord_foto->PhysicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = ew_UniqueFilename($this->koord_foto->PhysicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(ew_UploadTempPath($fldvar, $this->koord_foto->TblVar) . $file, ew_UploadTempPath($fldvar, $this->koord_foto->TblVar) . $file1);
									$NewFiles[$i] = $file1;
								}
							}
						}
					}
					$this->koord_foto->Upload->DbValue = empty($OldFiles) ? "" : implode(EW_MULTIPLE_UPLOAD_SEPARATOR, $OldFiles);
					$this->koord_foto->Upload->FileName = implode(EW_MULTIPLE_UPLOAD_SEPARATOR, $NewFiles);
					$this->koord_foto->SetDbValueDef($rsnew, $this->koord_foto->Upload->FileName, NULL, $this->koord_foto->ReadOnly);
				}
			}

			// Call Row Updating event
			$bUpdateRow = $this->Row_Updating($rsold, $rsnew);
			if ($bUpdateRow) {
				$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
				if (count($rsnew) > 0)
					$EditRow = $this->Update($rsnew, "", $rsold);
				else
					$EditRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($EditRow) {
					if ($this->koord_foto->Visible && !$this->koord_foto->Upload->KeepFile) {
						$OldFiles = ew_Empty($this->koord_foto->Upload->DbValue) ? array() : array($this->koord_foto->Upload->DbValue);
						if (!ew_Empty($this->koord_foto->Upload->FileName)) {
							$NewFiles = array($this->koord_foto->Upload->FileName);
							$NewFiles2 = array($rsnew['koord_foto']);
							$NewFileCount = count($NewFiles);
							for ($i = 0; $i < $NewFileCount; $i++) {
								$fldvar = ($this->koord_foto->Upload->Index < 0) ? $this->koord_foto->FldVar : substr($this->koord_foto->FldVar, 0, 1) . $this->koord_foto->Upload->Index . substr($this->koord_foto->FldVar, 1);
								if ($NewFiles[$i] <> "") {
									$file = ew_UploadTempPath($fldvar, $this->koord_foto->TblVar) . $NewFiles[$i];
									if (file_exists($file)) {
										if (@$NewFiles2[$i] <> "") // Use correct file name
											$NewFiles[$i] = $NewFiles2[$i];
										if (!$this->koord_foto->Upload->ResizeAndSaveToFile($this->koord_foto->ImageWidth, $this->koord_foto->ImageHeight, EW_THUMBNAIL_DEFAULT_QUALITY, $NewFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->Phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$NewFiles = array();
						}
						$OldFileCount = count($OldFiles);
						for ($i = 0; $i < $OldFileCount; $i++) {
							if ($OldFiles[$i] <> "" && !in_array($OldFiles[$i], $NewFiles))
								@unlink($this->koord_foto->OldPhysicalUploadPath() . $OldFiles[$i]);
						}
					}
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->Phrase("UpdateCancelled"));
				}
				$EditRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($EditRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->Close();

		// koord_foto
		ew_CleanUploadTempPath($this->koord_foto, $this->koord_foto->Upload->Index);
		return $EditRow;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$Breadcrumb->Add("list", $this->TableVar, $this->AddMasterUrl("koordlist.php"), "", $this->TableVar, TRUE);
		$PageId = "edit";
		$Breadcrumb->Add("edit", $PageId, $url);
	}

	// Setup lookup filters of a field
	function SetupLookupFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		}
	}

	// Setup AutoSuggest filters of a field
	function SetupAutoSuggestFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($koord_edit)) $koord_edit = new ckoord_edit();

// Page init
$koord_edit->Page_Init();

// Page main
$koord_edit->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$koord_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "edit";
var CurrentForm = fkoordedit = new ew_Form("fkoordedit", "edit");

// Validate form
fkoordedit.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);
	if ($fobj.find("#a_confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.FormKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = $fobj.find("#a_list").val() == "gridinsert";
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
			elm = this.GetElements("x" + infix + "_koord_id");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($koord->koord_id->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_koord_hp");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($koord->koord_hp->FldErrMsg()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ewForms[val])
			if (!ewForms[val].Validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fkoordedit.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fkoordedit.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php $koord_edit->ShowPageHeader(); ?>
<?php
$koord_edit->ShowMessage();
?>
<form name="fkoordedit" id="fkoordedit" class="<?php echo $koord_edit->FormClassName ?>" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($koord_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $koord_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="koord">
<input type="hidden" name="a_edit" id="a_edit" value="U">
<input type="hidden" name="modal" value="<?php echo intval($koord_edit->IsModal) ?>">
<div class="ewEditDiv"><!-- page* -->
<?php if ($koord->koord_id->Visible) { // koord_id ?>
	<div id="r_koord_id" class="form-group">
		<label id="elh_koord_koord_id" for="x_koord_id" class="<?php echo $koord_edit->LeftColumnClass ?>"><?php echo $koord->koord_id->FldCaption() ?></label>
		<div class="<?php echo $koord_edit->RightColumnClass ?>"><div<?php echo $koord->koord_id->CellAttributes() ?>>
<span id="el_koord_koord_id">
<span<?php echo $koord->koord_id->ViewAttributes() ?>>
<p class="form-control-static"><?php echo $koord->koord_id->EditValue ?></p></span>
</span>
<input type="hidden" data-table="koord" data-field="x_koord_id" name="x_koord_id" id="x_koord_id" value="<?php echo ew_HtmlEncode($koord->koord_id->CurrentValue) ?>">
<?php echo $koord->koord_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($koord->koord_nama->Visible) { // koord_nama ?>
	<div id="r_koord_nama" class="form-group">
		<label id="elh_koord_koord_nama" for="x_koord_nama" class="<?php echo $koord_edit->LeftColumnClass ?>"><?php echo $koord->koord_nama->FldCaption() ?></label>
		<div class="<?php echo $koord_edit->RightColumnClass ?>"><div<?php echo $koord->koord_nama->CellAttributes() ?>>
<span id="el_koord_koord_nama">
<input type="text" data-table="koord" data-field="x_koord_nama" name="x_koord_nama" id="x_koord_nama" size="30" maxlength="50" placeholder="<?php echo ew_HtmlEncode($koord->koord_nama->getPlaceHolder()) ?>" value="<?php echo $koord->koord_nama->EditValue ?>"<?php echo $koord->koord_nama->EditAttributes() ?>>
</span>
<?php echo $koord->koord_nama->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($koord->koord_alamat->Visible) { // koord_alamat ?>
	<div id="r_koord_alamat" class="form-group">
		<label id="elh_koord_koord_alamat" for="x_koord_alamat" class="<?php echo $koord_edit->LeftColumnClass ?>"><?php echo $koord->koord_alamat->FldCaption() ?></label>
		<div class="<?php echo $koord_edit->RightColumnClass ?>"><div<?php echo $koord->koord_alamat->CellAttributes() ?>>
<span id="el_koord_koord_alamat">
<input type="text" data-table="koord" data-field="x_koord_alamat" name="x_koord_alamat" id="x_koord_alamat" size="30" maxlength="200" placeholder="<?php echo ew_HtmlEncode($koord->koord_alamat->getPlaceHolder()) ?>" value="<?php echo $koord->koord_alamat->EditValue ?>"<?php echo $koord->koord_alamat->EditAttributes() ?>>
</span>
<?php echo $koord->koord_alamat->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($koord->koord_hp->Visible) { // koord_hp ?>
	<div id="r_koord_hp" class="form-group">
		<label id="elh_koord_koord_hp" for="x_koord_hp" class="<?php echo $koord_edit->LeftColumnClass ?>"><?php echo $koord->koord_hp->FldCaption() ?></label>
		<div class="<?php echo $koord_edit->RightColumnClass ?>"><div<?php echo $koord->koord_hp->CellAttributes() ?>>
<span id="el_koord_koord_hp">
<input type="text" data-table="koord" data-field="x_koord_hp" name="x_koord_hp" id="x_koord_hp" size="30" placeholder="<?php echo ew_HtmlEncode($koord->koord_hp->getPlaceHolder()) ?>" value="<?php echo $koord->koord_hp->EditValue ?>"<?php echo $koord->koord_hp->EditAttributes() ?>>
</span>
<?php echo $koord->koord_hp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($koord->koord_foto->Visible) { // koord_foto ?>
	<div id="r_koord_foto" class="form-group">
		<label id="elh_koord_koord_foto" class="<?php echo $koord_edit->LeftColumnClass ?>"><?php echo $koord->koord_foto->FldCaption() ?></label>
		<div class="<?php echo $koord_edit->RightColumnClass ?>"><div<?php echo $koord->koord_foto->CellAttributes() ?>>
<span id="el_koord_koord_foto">
<div id="fd_x_koord_foto">
<span title="<?php echo $koord->koord_foto->FldTitle() ? $koord->koord_foto->FldTitle() : $Language->Phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ewTooltip<?php if ($koord->koord_foto->ReadOnly || $koord->koord_foto->Disabled) echo " hide"; ?>" data-trigger="hover">
	<span><?php echo $Language->Phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="koord" data-field="x_koord_foto" name="x_koord_foto" id="x_koord_foto"<?php echo $koord->koord_foto->EditAttributes() ?>>
</span>
<input type="hidden" name="fn_x_koord_foto" id= "fn_x_koord_foto" value="<?php echo $koord->koord_foto->Upload->FileName ?>">
<?php if (@$_POST["fa_x_koord_foto"] == "0") { ?>
<input type="hidden" name="fa_x_koord_foto" id= "fa_x_koord_foto" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_koord_foto" id= "fa_x_koord_foto" value="1">
<?php } ?>
<input type="hidden" name="fs_x_koord_foto" id= "fs_x_koord_foto" value="50">
<input type="hidden" name="fx_x_koord_foto" id= "fx_x_koord_foto" value="<?php echo $koord->koord_foto->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_koord_foto" id= "fm_x_koord_foto" value="<?php echo $koord->koord_foto->UploadMaxFileSize ?>">
</div>
<table id="ft_x_koord_foto" class="table table-condensed pull-left ewUploadTable"><tbody class="files"></tbody></table>
</span>
<?php echo $koord->koord_foto->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$koord_edit->IsModal) { ?>
<div class="form-group"><!-- buttons .form-group -->
	<div class="<?php echo $koord_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ewButton" name="btnAction" id="btnAction" type="submit"><?php echo $Language->Phrase("SaveBtn") ?></button>
<button class="btn btn-default ewButton" name="btnCancel" id="btnCancel" type="button" data-href="<?php echo $koord_edit->getReturnUrl() ?>"><?php echo $Language->Phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<script type="text/javascript">
fkoordedit.Init();
</script>
<?php
$koord_edit->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$koord_edit->Page_Terminate();
?>
