<?php
if (session_id() == "") session_start(); // Init session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg14.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql14.php") ?>
<?php include_once "phpfn14.php" ?>
<?php include_once "kontrakinfo.php" ?>
<?php include_once "employeesinfo.php" ?>
<?php include_once "userfn14.php" ?>
<?php

//
// Page class
//

$kontrak_view = NULL; // Initialize page object first

class ckontrak_view extends ckontrak {

	// Page ID
	var $PageID = 'view';

	// Project ID
	var $ProjectID = '{CC60B42B-604B-412A-B014-2315920AF6AA}';

	// Table name
	var $TableName = 'kontrak';

	// Page object name
	var $PageObjName = 'kontrak_view';

	// Page headings
	var $Heading = '';
	var $Subheading = '';

	// Page heading
	function PageHeading() {
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->TableCaption();
		return "";
	}

	// Page subheading
	function PageSubheading() {
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->Phrase($this->PageID);
		return "";
	}

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;
	var $ExportPdfUrl;

	// Custom export
	var $ExportExcelCustom = FALSE;
	var $ExportWordCustom = FALSE;
	var $ExportPdfCustom = FALSE;
	var $ExportEmailCustom = FALSE;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (kontrak)
		if (!isset($GLOBALS["kontrak"]) || get_class($GLOBALS["kontrak"]) == "ckontrak") {
			$GLOBALS["kontrak"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["kontrak"];
		}
		$KeyUrl = "";
		if (@$_GET["k_id"] <> "") {
			$this->RecKey["k_id"] = $_GET["k_id"];
			$KeyUrl .= "&amp;k_id=" . urlencode($this->RecKey["k_id"]);
		}
		$this->ExportPrintUrl = $this->PageUrl() . "export=print" . $KeyUrl;
		$this->ExportHtmlUrl = $this->PageUrl() . "export=html" . $KeyUrl;
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel" . $KeyUrl;
		$this->ExportWordUrl = $this->PageUrl() . "export=word" . $KeyUrl;
		$this->ExportXmlUrl = $this->PageUrl() . "export=xml" . $KeyUrl;
		$this->ExportCsvUrl = $this->PageUrl() . "export=csv" . $KeyUrl;
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf" . $KeyUrl;

		// Table object (employees)
		if (!isset($GLOBALS['employees'])) $GLOBALS['employees'] = new cemployees();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'view', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'kontrak', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"]))
			$GLOBALS["gTimer"] = new cTimer();

		// Debug message
		ew_LoadDebugMsg();

		// Open connection
		if (!isset($conn))
			$conn = ew_Connect($this->DBID);

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new cemployees();
			$UserTableConn = Conn($UserTable->DBID);
		}

		// Export options
		$this->ExportOptions = new cListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Other options
		$this->OtherOptions['action'] = new cListOptions();
		$this->OtherOptions['action']->Tag = "div";
		$this->OtherOptions['action']->TagClassName = "ewActionOption";
		$this->OtherOptions['detail'] = new cListOptions();
		$this->OtherOptions['detail']->Tag = "div";
		$this->OtherOptions['detail']->TagClassName = "ewDetailOption";
	}

	//
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Is modal
		$this->IsModal = (@$_GET["modal"] == "1" || @$_POST["modal"] == "1");

		// User profile
		$UserProfile = new cUserProfile();

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanView()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			if ($Security->CanList())
				$this->Page_Terminate(ew_GetUrl("kontraklist.php"));
			else
				$this->Page_Terminate(ew_GetUrl("login.php"));
		}

		// NOTE: Security object may be needed in other part of the script, skip set to Nothing
		// 
		// Security = null;
		// 
		// Get export parameters

		$custom = "";
		if (@$_GET["export"] <> "") {
			$this->Export = $_GET["export"];
			$custom = @$_GET["custom"];
		} elseif (@$_POST["export"] <> "") {
			$this->Export = $_POST["export"];
			$custom = @$_POST["custom"];
		} elseif (ew_IsPost()) {
			if (@$_POST["exporttype"] <> "")
				$this->Export = $_POST["exporttype"];
			$custom = @$_POST["custom"];
		} elseif (@$_GET["cmd"] == "json") {
			$this->Export = $_GET["cmd"];
		} else {
			$this->setExportReturnUrl(ew_CurrentUrl());
		}
		$gsExportFile = $this->TableVar; // Get export file, used in header
		if (@$_GET["k_id"] <> "") {
			if ($gsExportFile <> "") $gsExportFile .= "_";
			$gsExportFile .= $_GET["k_id"];
		}

		// Get custom export parameters
		if ($this->Export <> "" && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$gsCustomExport = $this->CustomExport;
		$gsExport = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined("EW_USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined("EW_USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action

		// Setup export options
		$this->SetupExportOptions();
		$this->k_id_kontrak->SetVisibility();
		$this->k_id_lama->SetVisibility();
		$this->k_no_kontrak->SetVisibility();
		$this->k_luas_lahan->SetVisibility();
		$this->pet_id->SetVisibility();
		$this->koord_id->SetVisibility();
		$this->kk_id->SetVisibility();
		$this->prov_id->SetVisibility();
		$this->kab_id->SetVisibility();
		$this->kec_id->SetVisibility();
		$this->desa_id->SetVisibility();
		$this->blok_id->SetVisibility();
		$this->sos_id->SetVisibility();
		$this->var_id->SetVisibility();
		$this->co_id->SetVisibility();
		$this->k_jumlah_bibit->SetVisibility();
		$this->k_asal_bibit->SetVisibility();
		$this->k_tgl_tanam->SetVisibility();
		$this->k_es_tgl_panen->SetVisibility();
		$this->k_ak_tgl_datang->SetVisibility();
		$this->k_es_qty->SetVisibility();
		$this->k_ak_qty->SetVisibility();
		$this->k_es_perhektar->SetVisibility();
		$this->k_ak_perhektar->SetVisibility();
		$this->k_skor->SetVisibility();
		$this->k_ket->SetVisibility();
		$this->k_cat->SetVisibility();
		$this->k_titik_koordinat->SetVisibility();
		$this->k_foto_lahan->SetVisibility();
		$this->k_dok->SetVisibility();
		$this->k_harga_bibit->SetVisibility();
		$this->k_bayar_bibit->SetVisibility();
		$this->k_pinjaman->SetVisibility();
		$this->k_bayar_pinjaman->SetVisibility();
		$this->k_sisa_hutang->SetVisibility();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Create Token
		$this->CreateToken();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $kontrak;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($kontrak);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		// Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = ew_GetPageName($url);
				if ($pageName != $this->GetListUrl()) { // Not List page
					$row["caption"] = $this->GetModalCaption($pageName);
					if ($pageName == "kontrakview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				header("Content-Type: application/json; charset=utf-8");
				echo ew_ConvertToUtf8(ew_ArrayToJson(array($row)));
			} else {
				ew_SaveDebugMsg();
				header("Location: " . $url);
			}
		}
		exit();
	}
	var $ExportOptions; // Export options
	var $OtherOptions = array(); // Other options
	var $DisplayRecs = 1;
	var $DbMasterFilter;
	var $DbDetailFilter;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $RecCnt;
	var $RecKey = array();
	var $IsModal = FALSE;
	var $Recordset;

	//
	// Page main
	//
	function Page_Main() {
		global $Language, $gbSkipHeaderFooter, $EW_EXPORT;

		// Check modal
		if ($this->IsModal)
			$gbSkipHeaderFooter = TRUE;

		// Load current record
		$bLoadCurrentRecord = FALSE;
		$sReturnUrl = "";
		$bMatchRecord = FALSE;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET["k_id"] <> "") {
				$this->k_id->setQueryStringValue($_GET["k_id"]);
				$this->RecKey["k_id"] = $this->k_id->QueryStringValue;
			} elseif (@$_POST["k_id"] <> "") {
				$this->k_id->setFormValue($_POST["k_id"]);
				$this->RecKey["k_id"] = $this->k_id->FormValue;
			} else {
				$sReturnUrl = "kontraklist.php"; // Return to list
			}

			// Get action
			$this->CurrentAction = "I"; // Display form
			switch ($this->CurrentAction) {
				case "I": // Get a record to display
					if (!$this->LoadRow()) { // Load record based on key
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->Phrase("NoRecord")); // Set no record message
						$sReturnUrl = "kontraklist.php"; // No matching record, return to list
					}
			}

			// Export data only
			if ($this->CustomExport == "" && in_array($this->Export, array_keys($EW_EXPORT))) {
				$this->ExportData();
				$this->Page_Terminate(); // Terminate response
				exit();
			}
		} else {
			$sReturnUrl = "kontraklist.php"; // Not page request, return to list
		}
		if ($sReturnUrl <> "")
			$this->Page_Terminate($sReturnUrl);

		// Set up Breadcrumb
		if ($this->Export == "")
			$this->SetupBreadcrumb();

		// Render row
		$this->RowType = EW_ROWTYPE_VIEW;
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Set up other options
	function SetupOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = &$options["action"];

		// Add
		$item = &$option->Add("add");
		$addcaption = ew_HtmlTitle($Language->Phrase("ViewPageAddLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ewAction ewAdd\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"javascript:void(0);\" onclick=\"ew_ModalDialogShow({lnk:this,url:'" . ew_HtmlEncode($this->AddUrl) . "'});\">" . $Language->Phrase("ViewPageAddLink") . "</a>";
		else
			$item->Body = "<a class=\"ewAction ewAdd\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . ew_HtmlEncode($this->AddUrl) . "\">" . $Language->Phrase("ViewPageAddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->CanAdd());

		// Edit
		$item = &$option->Add("edit");
		$editcaption = ew_HtmlTitle($Language->Phrase("ViewPageEditLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ewAction ewEdit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"javascript:void(0);\" onclick=\"ew_ModalDialogShow({lnk:this,url:'" . ew_HtmlEncode($this->EditUrl) . "'});\">" . $Language->Phrase("ViewPageEditLink") . "</a>";
		else
			$item->Body = "<a class=\"ewAction ewEdit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . ew_HtmlEncode($this->EditUrl) . "\">" . $Language->Phrase("ViewPageEditLink") . "</a>";
		$item->Visible = ($this->EditUrl <> "" && $Security->CanEdit());

		// Copy
		$item = &$option->Add("copy");
		$copycaption = ew_HtmlTitle($Language->Phrase("ViewPageCopyLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ewAction ewCopy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"javascript:void(0);\" onclick=\"ew_ModalDialogShow({lnk:this,btn:'AddBtn',url:'" . ew_HtmlEncode($this->CopyUrl) . "'});\">" . $Language->Phrase("ViewPageCopyLink") . "</a>";
		else
			$item->Body = "<a class=\"ewAction ewCopy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . ew_HtmlEncode($this->CopyUrl) . "\">" . $Language->Phrase("ViewPageCopyLink") . "</a>";
		$item->Visible = ($this->CopyUrl <> "" && $Security->CanAdd());

		// Delete
		$item = &$option->Add("delete");
		if ($this->IsModal) // Handle as inline delete
			$item->Body = "<a onclick=\"return ew_ConfirmDelete(this);\" class=\"ewAction ewDelete\" title=\"" . ew_HtmlTitle($Language->Phrase("ViewPageDeleteLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("ViewPageDeleteLink")) . "\" href=\"" . ew_HtmlEncode(ew_UrlAddQuery($this->DeleteUrl, "a_delete=1")) . "\">" . $Language->Phrase("ViewPageDeleteLink") . "</a>";
		else
			$item->Body = "<a class=\"ewAction ewDelete\" title=\"" . ew_HtmlTitle($Language->Phrase("ViewPageDeleteLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("ViewPageDeleteLink")) . "\" href=\"" . ew_HtmlEncode($this->DeleteUrl) . "\">" . $Language->Phrase("ViewPageDeleteLink") . "</a>";
		$item->Visible = ($this->DeleteUrl <> "" && $Security->CanDelete());

		// Set up action default
		$option = &$options["action"];
		$option->DropDownButtonPhrase = $Language->Phrase("ButtonActions");
		$option->UseImageAndText = TRUE;
		$option->UseDropDownButton = FALSE;
		$option->UseButtonGroup = TRUE;
		$item = &$option->Add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Set up starting record parameters
	function SetupStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {

		// Load List page SQL
		$sSql = $this->ListSQL();
		$conn = &$this->Connection();

		// Load recordset
		$dbtype = ew_GetConnectionType($this->DBID);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset, array("_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderByList())));
			} else {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = ew_LoadRecordset($sSql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues($rs = NULL) {
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->NewRow(); 

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->k_id->setDbValue($row['k_id']);
		$this->k_id_kontrak->setDbValue($row['k_id_kontrak']);
		$this->k_id_lama->setDbValue($row['k_id_lama']);
		$this->k_no_kontrak->setDbValue($row['k_no_kontrak']);
		$this->k_luas_lahan->setDbValue($row['k_luas_lahan']);
		$this->pet_id->setDbValue($row['pet_id']);
		if (array_key_exists('EV__pet_id', $rs->fields)) {
			$this->pet_id->VirtualValue = $rs->fields('EV__pet_id'); // Set up virtual field value
		} else {
			$this->pet_id->VirtualValue = ""; // Clear value
		}
		$this->koord_id->setDbValue($row['koord_id']);
		if (array_key_exists('EV__koord_id', $rs->fields)) {
			$this->koord_id->VirtualValue = $rs->fields('EV__koord_id'); // Set up virtual field value
		} else {
			$this->koord_id->VirtualValue = ""; // Clear value
		}
		$this->kk_id->setDbValue($row['kk_id']);
		$this->prov_id->setDbValue($row['prov_id']);
		$this->kab_id->setDbValue($row['kab_id']);
		$this->kec_id->setDbValue($row['kec_id']);
		if (array_key_exists('EV__kec_id', $rs->fields)) {
			$this->kec_id->VirtualValue = $rs->fields('EV__kec_id'); // Set up virtual field value
		} else {
			$this->kec_id->VirtualValue = ""; // Clear value
		}
		$this->desa_id->setDbValue($row['desa_id']);
		if (array_key_exists('EV__desa_id', $rs->fields)) {
			$this->desa_id->VirtualValue = $rs->fields('EV__desa_id'); // Set up virtual field value
		} else {
			$this->desa_id->VirtualValue = ""; // Clear value
		}
		$this->blok_id->setDbValue($row['blok_id']);
		if (array_key_exists('EV__blok_id', $rs->fields)) {
			$this->blok_id->VirtualValue = $rs->fields('EV__blok_id'); // Set up virtual field value
		} else {
			$this->blok_id->VirtualValue = ""; // Clear value
		}
		$this->sos_id->setDbValue($row['sos_id']);
		if (array_key_exists('EV__sos_id', $rs->fields)) {
			$this->sos_id->VirtualValue = $rs->fields('EV__sos_id'); // Set up virtual field value
		} else {
			$this->sos_id->VirtualValue = ""; // Clear value
		}
		$this->var_id->setDbValue($row['var_id']);
		$this->co_id->setDbValue($row['co_id']);
		$this->k_jumlah_bibit->setDbValue($row['k_jumlah_bibit']);
		$this->k_asal_bibit->setDbValue($row['k_asal_bibit']);
		$this->k_tgl_tanam->setDbValue($row['k_tgl_tanam']);
		$this->k_es_tgl_panen->setDbValue($row['k_es_tgl_panen']);
		$this->k_ak_tgl_datang->setDbValue($row['k_ak_tgl_datang']);
		$this->k_es_qty->setDbValue($row['k_es_qty']);
		$this->k_ak_qty->setDbValue($row['k_ak_qty']);
		$this->k_es_perhektar->setDbValue($row['k_es_perhektar']);
		$this->k_ak_perhektar->setDbValue($row['k_ak_perhektar']);
		$this->k_skor->setDbValue($row['k_skor']);
		$this->k_ket->setDbValue($row['k_ket']);
		$this->k_cat->setDbValue($row['k_cat']);
		$this->k_titik_koordinat->setDbValue($row['k_titik_koordinat']);
		$this->k_foto_lahan->Upload->DbValue = $row['k_foto_lahan'];
		$this->k_foto_lahan->setDbValue($this->k_foto_lahan->Upload->DbValue);
		$this->k_dok->Upload->DbValue = $row['k_dok'];
		$this->k_dok->setDbValue($this->k_dok->Upload->DbValue);
		$this->k_harga_bibit->setDbValue($row['k_harga_bibit']);
		$this->k_bayar_bibit->setDbValue($row['k_bayar_bibit']);
		$this->k_pinjaman->setDbValue($row['k_pinjaman']);
		$this->k_bayar_pinjaman->setDbValue($row['k_bayar_pinjaman']);
		$this->k_sisa_hutang->setDbValue($row['k_sisa_hutang']);
	}

	// Return a row with default values
	function NewRow() {
		$row = array();
		$row['k_id'] = NULL;
		$row['k_id_kontrak'] = NULL;
		$row['k_id_lama'] = NULL;
		$row['k_no_kontrak'] = NULL;
		$row['k_luas_lahan'] = NULL;
		$row['pet_id'] = NULL;
		$row['koord_id'] = NULL;
		$row['kk_id'] = NULL;
		$row['prov_id'] = NULL;
		$row['kab_id'] = NULL;
		$row['kec_id'] = NULL;
		$row['desa_id'] = NULL;
		$row['blok_id'] = NULL;
		$row['sos_id'] = NULL;
		$row['var_id'] = NULL;
		$row['co_id'] = NULL;
		$row['k_jumlah_bibit'] = NULL;
		$row['k_asal_bibit'] = NULL;
		$row['k_tgl_tanam'] = NULL;
		$row['k_es_tgl_panen'] = NULL;
		$row['k_ak_tgl_datang'] = NULL;
		$row['k_es_qty'] = NULL;
		$row['k_ak_qty'] = NULL;
		$row['k_es_perhektar'] = NULL;
		$row['k_ak_perhektar'] = NULL;
		$row['k_skor'] = NULL;
		$row['k_ket'] = NULL;
		$row['k_cat'] = NULL;
		$row['k_titik_koordinat'] = NULL;
		$row['k_foto_lahan'] = NULL;
		$row['k_dok'] = NULL;
		$row['k_harga_bibit'] = NULL;
		$row['k_bayar_bibit'] = NULL;
		$row['k_pinjaman'] = NULL;
		$row['k_bayar_pinjaman'] = NULL;
		$row['k_sisa_hutang'] = NULL;
		return $row;
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->k_id->DbValue = $row['k_id'];
		$this->k_id_kontrak->DbValue = $row['k_id_kontrak'];
		$this->k_id_lama->DbValue = $row['k_id_lama'];
		$this->k_no_kontrak->DbValue = $row['k_no_kontrak'];
		$this->k_luas_lahan->DbValue = $row['k_luas_lahan'];
		$this->pet_id->DbValue = $row['pet_id'];
		$this->koord_id->DbValue = $row['koord_id'];
		$this->kk_id->DbValue = $row['kk_id'];
		$this->prov_id->DbValue = $row['prov_id'];
		$this->kab_id->DbValue = $row['kab_id'];
		$this->kec_id->DbValue = $row['kec_id'];
		$this->desa_id->DbValue = $row['desa_id'];
		$this->blok_id->DbValue = $row['blok_id'];
		$this->sos_id->DbValue = $row['sos_id'];
		$this->var_id->DbValue = $row['var_id'];
		$this->co_id->DbValue = $row['co_id'];
		$this->k_jumlah_bibit->DbValue = $row['k_jumlah_bibit'];
		$this->k_asal_bibit->DbValue = $row['k_asal_bibit'];
		$this->k_tgl_tanam->DbValue = $row['k_tgl_tanam'];
		$this->k_es_tgl_panen->DbValue = $row['k_es_tgl_panen'];
		$this->k_ak_tgl_datang->DbValue = $row['k_ak_tgl_datang'];
		$this->k_es_qty->DbValue = $row['k_es_qty'];
		$this->k_ak_qty->DbValue = $row['k_ak_qty'];
		$this->k_es_perhektar->DbValue = $row['k_es_perhektar'];
		$this->k_ak_perhektar->DbValue = $row['k_ak_perhektar'];
		$this->k_skor->DbValue = $row['k_skor'];
		$this->k_ket->DbValue = $row['k_ket'];
		$this->k_cat->DbValue = $row['k_cat'];
		$this->k_titik_koordinat->DbValue = $row['k_titik_koordinat'];
		$this->k_foto_lahan->Upload->DbValue = $row['k_foto_lahan'];
		$this->k_dok->Upload->DbValue = $row['k_dok'];
		$this->k_harga_bibit->DbValue = $row['k_harga_bibit'];
		$this->k_bayar_bibit->DbValue = $row['k_bayar_bibit'];
		$this->k_pinjaman->DbValue = $row['k_pinjaman'];
		$this->k_bayar_pinjaman->DbValue = $row['k_bayar_pinjaman'];
		$this->k_sisa_hutang->DbValue = $row['k_sisa_hutang'];
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		$this->AddUrl = $this->GetAddUrl();
		$this->EditUrl = $this->GetEditUrl();
		$this->CopyUrl = $this->GetCopyUrl();
		$this->DeleteUrl = $this->GetDeleteUrl();
		$this->ListUrl = $this->GetListUrl();
		$this->SetupOtherOptions();

		// Convert decimal values if posted back
		if ($this->k_ak_perhektar->FormValue == $this->k_ak_perhektar->CurrentValue && is_numeric(ew_StrToFloat($this->k_ak_perhektar->CurrentValue)))
			$this->k_ak_perhektar->CurrentValue = ew_StrToFloat($this->k_ak_perhektar->CurrentValue);

		// Convert decimal values if posted back
		if ($this->k_skor->FormValue == $this->k_skor->CurrentValue && is_numeric(ew_StrToFloat($this->k_skor->CurrentValue)))
			$this->k_skor->CurrentValue = ew_StrToFloat($this->k_skor->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// k_id
		// k_id_kontrak
		// k_id_lama
		// k_no_kontrak
		// k_luas_lahan
		// pet_id
		// koord_id
		// kk_id
		// prov_id
		// kab_id
		// kec_id
		// desa_id
		// blok_id
		// sos_id
		// var_id
		// co_id
		// k_jumlah_bibit
		// k_asal_bibit
		// k_tgl_tanam
		// k_es_tgl_panen
		// k_ak_tgl_datang
		// k_es_qty
		// k_ak_qty
		// k_es_perhektar
		// k_ak_perhektar
		// k_skor
		// k_ket
		// k_cat
		// k_titik_koordinat
		// k_foto_lahan
		// k_dok
		// k_harga_bibit
		// k_bayar_bibit
		// k_pinjaman
		// k_bayar_pinjaman
		// k_sisa_hutang

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// k_id
		$this->k_id->ViewValue = $this->k_id->CurrentValue;
		$this->k_id->ViewCustomAttributes = "";

		// k_id_kontrak
		$this->k_id_kontrak->ViewValue = $this->k_id_kontrak->CurrentValue;
		$this->k_id_kontrak->ViewCustomAttributes = "";

		// k_id_lama
		$this->k_id_lama->ViewValue = $this->k_id_lama->CurrentValue;
		$this->k_id_lama->ViewCustomAttributes = "";

		// k_no_kontrak
		$this->k_no_kontrak->ViewValue = $this->k_no_kontrak->CurrentValue;
		$this->k_no_kontrak->ViewCustomAttributes = "";

		// k_luas_lahan
		$this->k_luas_lahan->ViewValue = $this->k_luas_lahan->CurrentValue;
		$this->k_luas_lahan->ViewCustomAttributes = "";

		// pet_id
		if ($this->pet_id->VirtualValue <> "") {
			$this->pet_id->ViewValue = $this->pet_id->VirtualValue;
		} else {
		if (strval($this->pet_id->CurrentValue) <> "") {
			$sFilterWrk = "`pet_id`" . ew_SearchString("=", $this->pet_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `pet_id`, `pet_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `petani`";
		$sWhereWrk = "";
		$this->pet_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->pet_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `pet_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->pet_id->ViewValue = $this->pet_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->pet_id->ViewValue = $this->pet_id->CurrentValue;
			}
		} else {
			$this->pet_id->ViewValue = NULL;
		}
		}
		$this->pet_id->ViewCustomAttributes = "";

		// koord_id
		if ($this->koord_id->VirtualValue <> "") {
			$this->koord_id->ViewValue = $this->koord_id->VirtualValue;
		} else {
		if (strval($this->koord_id->CurrentValue) <> "") {
			$sFilterWrk = "`koord_id`" . ew_SearchString("=", $this->koord_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `koord_id`, `koord_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `koord`";
		$sWhereWrk = "";
		$this->koord_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->koord_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `koord_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->koord_id->ViewValue = $this->koord_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->koord_id->ViewValue = $this->koord_id->CurrentValue;
			}
		} else {
			$this->koord_id->ViewValue = NULL;
		}
		}
		$this->koord_id->ViewCustomAttributes = "";

		// kk_id
		if (strval($this->kk_id->CurrentValue) <> "") {
			$sFilterWrk = "`kk_id`" . ew_SearchString("=", $this->kk_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `kk_id`, `kk_periode` AS `DispFld`, `kk_tgl_mulai` AS `Disp2Fld`, `kk_tgl_akhir` AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kontrak_koord`";
		$sWhereWrk = "";
		$this->kk_id->LookupFilters = array("df2" => "5", "df3" => "5");
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->kk_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = ew_FormatDateTime($rswrk->fields('Disp2Fld'), 5);
				$arwrk[3] = ew_FormatDateTime($rswrk->fields('Disp3Fld'), 5);
				$this->kk_id->ViewValue = $this->kk_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->kk_id->ViewValue = $this->kk_id->CurrentValue;
			}
		} else {
			$this->kk_id->ViewValue = NULL;
		}
		$this->kk_id->ViewCustomAttributes = "";

		// prov_id
		if (strval($this->prov_id->CurrentValue) <> "") {
			$sFilterWrk = "`prov_id`" . ew_SearchString("=", $this->prov_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `prov_id`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `prov`";
		$sWhereWrk = "";
		$this->prov_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->prov_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `prov_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->prov_id->ViewValue = $this->prov_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->prov_id->ViewValue = $this->prov_id->CurrentValue;
			}
		} else {
			$this->prov_id->ViewValue = NULL;
		}
		$this->prov_id->ViewCustomAttributes = "";

		// kab_id
		if (strval($this->kab_id->CurrentValue) <> "") {
			$sFilterWrk = "`kab_id`" . ew_SearchString("=", $this->kab_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `kab_id`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kab`";
		$sWhereWrk = "";
		$this->kab_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->kab_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `kab_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->kab_id->ViewValue = $this->kab_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->kab_id->ViewValue = $this->kab_id->CurrentValue;
			}
		} else {
			$this->kab_id->ViewValue = NULL;
		}
		$this->kab_id->ViewCustomAttributes = "";

		// kec_id
		if ($this->kec_id->VirtualValue <> "") {
			$this->kec_id->ViewValue = $this->kec_id->VirtualValue;
		} else {
		if (strval($this->kec_id->CurrentValue) <> "") {
			$sFilterWrk = "`kec_id`" . ew_SearchString("=", $this->kec_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `kec_id`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kec`";
		$sWhereWrk = "";
		$this->kec_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->kec_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `kec_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->kec_id->ViewValue = $this->kec_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->kec_id->ViewValue = $this->kec_id->CurrentValue;
			}
		} else {
			$this->kec_id->ViewValue = NULL;
		}
		}
		$this->kec_id->ViewCustomAttributes = "";

		// desa_id
		if ($this->desa_id->VirtualValue <> "") {
			$this->desa_id->ViewValue = $this->desa_id->VirtualValue;
		} else {
		if (strval($this->desa_id->CurrentValue) <> "") {
			$sFilterWrk = "`desa_id`" . ew_SearchString("=", $this->desa_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `desa_id`, `desa_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `desa`";
		$sWhereWrk = "";
		$this->desa_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->desa_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `desa_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->desa_id->ViewValue = $this->desa_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->desa_id->ViewValue = $this->desa_id->CurrentValue;
			}
		} else {
			$this->desa_id->ViewValue = NULL;
		}
		}
		$this->desa_id->ViewCustomAttributes = "";

		// blok_id
		if ($this->blok_id->VirtualValue <> "") {
			$this->blok_id->ViewValue = $this->blok_id->VirtualValue;
		} else {
		if (strval($this->blok_id->CurrentValue) <> "") {
			$sFilterWrk = "`blok_id`" . ew_SearchString("=", $this->blok_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `blok_id`, `blok_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `blok`";
		$sWhereWrk = "";
		$this->blok_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->blok_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `blok_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->blok_id->ViewValue = $this->blok_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->blok_id->ViewValue = $this->blok_id->CurrentValue;
			}
		} else {
			$this->blok_id->ViewValue = NULL;
		}
		}
		$this->blok_id->ViewCustomAttributes = "";

		// sos_id
		if ($this->sos_id->VirtualValue <> "") {
			$this->sos_id->ViewValue = $this->sos_id->VirtualValue;
		} else {
		if (strval($this->sos_id->CurrentValue) <> "") {
			$sFilterWrk = "`sos_id`" . ew_SearchString("=", $this->sos_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `sos_id`, `sos_id` AS `DispFld`, `sos_tgl` AS `Disp2Fld`, `sos_alamat` AS `Disp3Fld`, '' AS `Disp4Fld` FROM `sosialisasi`";
		$sWhereWrk = "";
		$this->sos_id->LookupFilters = array("df2" => "0");
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->sos_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `sos_tgl` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = ew_FormatDateTime($rswrk->fields('Disp2Fld'), 0);
				$arwrk[3] = $rswrk->fields('Disp3Fld');
				$this->sos_id->ViewValue = $this->sos_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->sos_id->ViewValue = $this->sos_id->CurrentValue;
			}
		} else {
			$this->sos_id->ViewValue = NULL;
		}
		}
		$this->sos_id->ViewCustomAttributes = "";

		// var_id
		if (strval($this->var_id->CurrentValue) <> "") {
			$sFilterWrk = "`var_id`" . ew_SearchString("=", $this->var_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `var_id`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `varietas`";
		$sWhereWrk = "";
		$this->var_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->var_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `var_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->var_id->ViewValue = $this->var_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->var_id->ViewValue = $this->var_id->CurrentValue;
			}
		} else {
			$this->var_id->ViewValue = NULL;
		}
		$this->var_id->ViewCustomAttributes = "";

		// co_id
		if (strval($this->co_id->CurrentValue) <> "") {
			$sFilterWrk = "`co_id`" . ew_SearchString("=", $this->co_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `co_id`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `co`";
		$sWhereWrk = "";
		$this->co_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->co_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `co_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->co_id->ViewValue = $this->co_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->co_id->ViewValue = $this->co_id->CurrentValue;
			}
		} else {
			$this->co_id->ViewValue = NULL;
		}
		$this->co_id->ViewCustomAttributes = "";

		// k_jumlah_bibit
		$this->k_jumlah_bibit->ViewValue = $this->k_jumlah_bibit->CurrentValue;
		$this->k_jumlah_bibit->ViewCustomAttributes = "";

		// k_asal_bibit
		$this->k_asal_bibit->ViewValue = $this->k_asal_bibit->CurrentValue;
		$this->k_asal_bibit->ViewCustomAttributes = "";

		// k_tgl_tanam
		$this->k_tgl_tanam->ViewValue = $this->k_tgl_tanam->CurrentValue;
		$this->k_tgl_tanam->ViewValue = ew_FormatDateTime($this->k_tgl_tanam->ViewValue, 5);
		$this->k_tgl_tanam->ViewCustomAttributes = "";

		// k_es_tgl_panen
		$this->k_es_tgl_panen->ViewValue = $this->k_es_tgl_panen->CurrentValue;
		$this->k_es_tgl_panen->ViewValue = ew_FormatDateTime($this->k_es_tgl_panen->ViewValue, 5);
		$this->k_es_tgl_panen->ViewCustomAttributes = "";

		// k_ak_tgl_datang
		$this->k_ak_tgl_datang->ViewValue = $this->k_ak_tgl_datang->CurrentValue;
		$this->k_ak_tgl_datang->ViewValue = ew_FormatDateTime($this->k_ak_tgl_datang->ViewValue, 5);
		$this->k_ak_tgl_datang->ViewCustomAttributes = "";

		// k_es_qty
		$this->k_es_qty->ViewValue = $this->k_es_qty->CurrentValue;
		$this->k_es_qty->ViewCustomAttributes = "";

		// k_ak_qty
		$this->k_ak_qty->ViewValue = $this->k_ak_qty->CurrentValue;
		$this->k_ak_qty->ViewCustomAttributes = "";

		// k_es_perhektar
		$this->k_es_perhektar->ViewValue = $this->k_es_perhektar->CurrentValue;
		$this->k_es_perhektar->ViewCustomAttributes = "";

		// k_ak_perhektar
		$this->k_ak_perhektar->ViewValue = $this->k_ak_perhektar->CurrentValue;
		$this->k_ak_perhektar->ViewCustomAttributes = "";

		// k_skor
		$this->k_skor->ViewValue = $this->k_skor->CurrentValue;
		$this->k_skor->ViewCustomAttributes = "";

		// k_ket
		$this->k_ket->ViewValue = $this->k_ket->CurrentValue;
		$this->k_ket->ViewCustomAttributes = "";

		// k_cat
		$this->k_cat->ViewValue = $this->k_cat->CurrentValue;
		$this->k_cat->ViewCustomAttributes = "";

		// k_titik_koordinat
		$this->k_titik_koordinat->ViewValue = $this->k_titik_koordinat->CurrentValue;
		$this->k_titik_koordinat->CellCssStyle .= "text-align: left;";
		$this->k_titik_koordinat->ViewCustomAttributes = "";

		// k_foto_lahan
		$this->k_foto_lahan->UploadPath = "foto_lahan";
		if (!ew_Empty($this->k_foto_lahan->Upload->DbValue)) {
			$this->k_foto_lahan->ImageWidth = 40;
			$this->k_foto_lahan->ImageHeight = 30;
			$this->k_foto_lahan->ImageAlt = $this->k_foto_lahan->FldAlt();
			$this->k_foto_lahan->ViewValue = $this->k_foto_lahan->Upload->DbValue;
		} else {
			$this->k_foto_lahan->ViewValue = "";
		}
		$this->k_foto_lahan->CellCssStyle .= "text-align: left;";
		$this->k_foto_lahan->ViewCustomAttributes = "";

		// k_dok
		$this->k_dok->UploadPath = "dokumen_kontrak_lahan";
		if (!ew_Empty($this->k_dok->Upload->DbValue)) {
			$this->k_dok->ImageWidth = 42;
			$this->k_dok->ImageHeight = 70;
			$this->k_dok->ImageAlt = $this->k_dok->FldAlt();
			$this->k_dok->ViewValue = $this->k_dok->Upload->DbValue;
		} else {
			$this->k_dok->ViewValue = "";
		}
		$this->k_dok->ViewCustomAttributes = "";

		// k_harga_bibit
		$this->k_harga_bibit->ViewValue = $this->k_harga_bibit->CurrentValue;
		$this->k_harga_bibit->ViewCustomAttributes = "";

		// k_bayar_bibit
		$this->k_bayar_bibit->ViewValue = $this->k_bayar_bibit->CurrentValue;
		$this->k_bayar_bibit->ViewCustomAttributes = "";

		// k_pinjaman
		$this->k_pinjaman->ViewValue = $this->k_pinjaman->CurrentValue;
		$this->k_pinjaman->ViewCustomAttributes = "";

		// k_bayar_pinjaman
		$this->k_bayar_pinjaman->ViewValue = $this->k_bayar_pinjaman->CurrentValue;
		$this->k_bayar_pinjaman->ViewCustomAttributes = "";

		// k_sisa_hutang
		$this->k_sisa_hutang->ViewValue = $this->k_sisa_hutang->CurrentValue;
		$this->k_sisa_hutang->ViewCustomAttributes = "";

			// k_id_kontrak
			$this->k_id_kontrak->LinkCustomAttributes = "";
			$this->k_id_kontrak->HrefValue = "";
			$this->k_id_kontrak->TooltipValue = "";

			// k_id_lama
			$this->k_id_lama->LinkCustomAttributes = "";
			$this->k_id_lama->HrefValue = "";
			$this->k_id_lama->TooltipValue = "";

			// k_no_kontrak
			$this->k_no_kontrak->LinkCustomAttributes = "";
			$this->k_no_kontrak->HrefValue = "";
			$this->k_no_kontrak->TooltipValue = "";

			// k_luas_lahan
			$this->k_luas_lahan->LinkCustomAttributes = "";
			$this->k_luas_lahan->HrefValue = "";
			$this->k_luas_lahan->TooltipValue = "";

			// pet_id
			$this->pet_id->LinkCustomAttributes = "";
			if (!ew_Empty($this->pet_id->CurrentValue)) {
				$this->pet_id->HrefValue = "petaniview.php?showdetail=&pet_id=" . $this->pet_id->CurrentValue; // Add prefix/suffix
				$this->pet_id->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->pet_id->HrefValue = ew_FullUrl($this->pet_id->HrefValue, "href");
			} else {
				$this->pet_id->HrefValue = "";
			}
			$this->pet_id->TooltipValue = "";

			// koord_id
			$this->koord_id->LinkCustomAttributes = "";
			if (!ew_Empty($this->koord_id->CurrentValue)) {
				$this->koord_id->HrefValue = "koordview.php?showdetail=&koord_id=" . $this->koord_id->CurrentValue; // Add prefix/suffix
				$this->koord_id->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->koord_id->HrefValue = ew_FullUrl($this->koord_id->HrefValue, "href");
			} else {
				$this->koord_id->HrefValue = "";
			}
			$this->koord_id->TooltipValue = "";

			// kk_id
			$this->kk_id->LinkCustomAttributes = "";
			if (!ew_Empty($this->kk_id->CurrentValue)) {
				$this->kk_id->HrefValue = "kontrak_koordview.php?showdetail=&kk_id=" . $this->kk_id->CurrentValue; // Add prefix/suffix
				$this->kk_id->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->kk_id->HrefValue = ew_FullUrl($this->kk_id->HrefValue, "href");
			} else {
				$this->kk_id->HrefValue = "";
			}
			$this->kk_id->TooltipValue = "";

			// prov_id
			$this->prov_id->LinkCustomAttributes = "";
			$this->prov_id->HrefValue = "";
			$this->prov_id->TooltipValue = "";

			// kab_id
			$this->kab_id->LinkCustomAttributes = "";
			$this->kab_id->HrefValue = "";
			$this->kab_id->TooltipValue = "";

			// kec_id
			$this->kec_id->LinkCustomAttributes = "";
			$this->kec_id->HrefValue = "";
			$this->kec_id->TooltipValue = "";

			// desa_id
			$this->desa_id->LinkCustomAttributes = "";
			$this->desa_id->HrefValue = "";
			$this->desa_id->TooltipValue = "";

			// blok_id
			$this->blok_id->LinkCustomAttributes = "";
			$this->blok_id->HrefValue = "";
			$this->blok_id->TooltipValue = "";

			// sos_id
			$this->sos_id->LinkCustomAttributes = "";
			$this->sos_id->HrefValue = "";
			$this->sos_id->TooltipValue = "";

			// var_id
			$this->var_id->LinkCustomAttributes = "";
			if (!ew_Empty($this->var_id->CurrentValue)) {
				$this->var_id->HrefValue = "varietasview.php?showdetail=&var_id=" . $this->var_id->CurrentValue; // Add prefix/suffix
				$this->var_id->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->var_id->HrefValue = ew_FullUrl($this->var_id->HrefValue, "href");
			} else {
				$this->var_id->HrefValue = "";
			}
			$this->var_id->TooltipValue = "";

			// co_id
			$this->co_id->LinkCustomAttributes = "";
			if (!ew_Empty($this->co_id->CurrentValue)) {
				$this->co_id->HrefValue = "coview.php?showdetail=&co_id=" . $this->co_id->CurrentValue; // Add prefix/suffix
				$this->co_id->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->co_id->HrefValue = ew_FullUrl($this->co_id->HrefValue, "href");
			} else {
				$this->co_id->HrefValue = "";
			}
			$this->co_id->TooltipValue = "";

			// k_jumlah_bibit
			$this->k_jumlah_bibit->LinkCustomAttributes = "";
			$this->k_jumlah_bibit->HrefValue = "";
			$this->k_jumlah_bibit->TooltipValue = "";

			// k_asal_bibit
			$this->k_asal_bibit->LinkCustomAttributes = "";
			$this->k_asal_bibit->HrefValue = "";
			$this->k_asal_bibit->TooltipValue = "";

			// k_tgl_tanam
			$this->k_tgl_tanam->LinkCustomAttributes = "";
			$this->k_tgl_tanam->HrefValue = "";
			$this->k_tgl_tanam->TooltipValue = "";

			// k_es_tgl_panen
			$this->k_es_tgl_panen->LinkCustomAttributes = "";
			$this->k_es_tgl_panen->HrefValue = "";
			$this->k_es_tgl_panen->TooltipValue = "";

			// k_ak_tgl_datang
			$this->k_ak_tgl_datang->LinkCustomAttributes = "";
			$this->k_ak_tgl_datang->HrefValue = "";
			$this->k_ak_tgl_datang->TooltipValue = "";

			// k_es_qty
			$this->k_es_qty->LinkCustomAttributes = "";
			$this->k_es_qty->HrefValue = "";
			$this->k_es_qty->TooltipValue = "";

			// k_ak_qty
			$this->k_ak_qty->LinkCustomAttributes = "";
			$this->k_ak_qty->HrefValue = "";
			$this->k_ak_qty->TooltipValue = "";

			// k_es_perhektar
			$this->k_es_perhektar->LinkCustomAttributes = "";
			$this->k_es_perhektar->HrefValue = "";
			$this->k_es_perhektar->TooltipValue = "";

			// k_ak_perhektar
			$this->k_ak_perhektar->LinkCustomAttributes = "";
			$this->k_ak_perhektar->HrefValue = "";
			$this->k_ak_perhektar->TooltipValue = "";

			// k_skor
			$this->k_skor->LinkCustomAttributes = "";
			$this->k_skor->HrefValue = "";
			$this->k_skor->TooltipValue = "";

			// k_ket
			$this->k_ket->LinkCustomAttributes = "";
			$this->k_ket->HrefValue = "";
			$this->k_ket->TooltipValue = "";

			// k_cat
			$this->k_cat->LinkCustomAttributes = "";
			$this->k_cat->HrefValue = "";
			$this->k_cat->TooltipValue = "";

			// k_titik_koordinat
			$this->k_titik_koordinat->LinkCustomAttributes = "";
			if (!ew_Empty($this->k_titik_koordinat->CurrentValue)) {
				$this->k_titik_koordinat->HrefValue = ((!empty($this->k_titik_koordinat->ViewValue) && !is_array($this->k_titik_koordinat->ViewValue)) ? ew_RemoveHtml($this->k_titik_koordinat->ViewValue) : $this->k_titik_koordinat->CurrentValue); // Add prefix/suffix
				$this->k_titik_koordinat->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->k_titik_koordinat->HrefValue = ew_FullUrl($this->k_titik_koordinat->HrefValue, "href");
			} else {
				$this->k_titik_koordinat->HrefValue = "";
			}
			$this->k_titik_koordinat->TooltipValue = "";

			// k_foto_lahan
			$this->k_foto_lahan->LinkCustomAttributes = "";
			$this->k_foto_lahan->UploadPath = "foto_lahan";
			if (!ew_Empty($this->k_foto_lahan->Upload->DbValue)) {
				$this->k_foto_lahan->HrefValue = "%u"; // Add prefix/suffix
				$this->k_foto_lahan->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->k_foto_lahan->HrefValue = ew_FullUrl($this->k_foto_lahan->HrefValue, "href");
			} else {
				$this->k_foto_lahan->HrefValue = "";
			}
			$this->k_foto_lahan->HrefValue2 = $this->k_foto_lahan->UploadPath . $this->k_foto_lahan->Upload->DbValue;
			$this->k_foto_lahan->TooltipValue = "";
			if ($this->k_foto_lahan->UseColorbox) {
				if (ew_Empty($this->k_foto_lahan->TooltipValue))
					$this->k_foto_lahan->LinkAttrs["title"] = $Language->Phrase("ViewImageGallery");
				$this->k_foto_lahan->LinkAttrs["data-rel"] = "kontrak_x_k_foto_lahan";
				ew_AppendClass($this->k_foto_lahan->LinkAttrs["class"], "ewLightbox");
			}

			// k_dok
			$this->k_dok->LinkCustomAttributes = "";
			$this->k_dok->UploadPath = "dokumen_kontrak_lahan";
			if (!ew_Empty($this->k_dok->Upload->DbValue)) {
				$this->k_dok->HrefValue = "%u"; // Add prefix/suffix
				$this->k_dok->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->k_dok->HrefValue = ew_FullUrl($this->k_dok->HrefValue, "href");
			} else {
				$this->k_dok->HrefValue = "";
			}
			$this->k_dok->HrefValue2 = $this->k_dok->UploadPath . $this->k_dok->Upload->DbValue;
			$this->k_dok->TooltipValue = "";
			if ($this->k_dok->UseColorbox) {
				if (ew_Empty($this->k_dok->TooltipValue))
					$this->k_dok->LinkAttrs["title"] = $Language->Phrase("ViewImageGallery");
				$this->k_dok->LinkAttrs["data-rel"] = "kontrak_x_k_dok";
				ew_AppendClass($this->k_dok->LinkAttrs["class"], "ewLightbox");
			}

			// k_harga_bibit
			$this->k_harga_bibit->LinkCustomAttributes = "";
			$this->k_harga_bibit->HrefValue = "";
			$this->k_harga_bibit->TooltipValue = "";

			// k_bayar_bibit
			$this->k_bayar_bibit->LinkCustomAttributes = "";
			$this->k_bayar_bibit->HrefValue = "";
			$this->k_bayar_bibit->TooltipValue = "";

			// k_pinjaman
			$this->k_pinjaman->LinkCustomAttributes = "";
			$this->k_pinjaman->HrefValue = "";
			$this->k_pinjaman->TooltipValue = "";

			// k_bayar_pinjaman
			$this->k_bayar_pinjaman->LinkCustomAttributes = "";
			$this->k_bayar_pinjaman->HrefValue = "";
			$this->k_bayar_pinjaman->TooltipValue = "";

			// k_sisa_hutang
			$this->k_sisa_hutang->LinkCustomAttributes = "";
			$this->k_sisa_hutang->HrefValue = "";
			$this->k_sisa_hutang->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up export options
	function SetupExportOptions() {
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->Add("print");
		$item->Body = "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ewExportLink ewPrint\" title=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\">" . $Language->Phrase("PrinterFriendly") . "</a>";
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->Add("excel");
		$item->Body = "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ewExportLink ewExcel\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\">" . $Language->Phrase("ExportToExcel") . "</a>";
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->Add("word");
		$item->Body = "<a href=\"" . $this->ExportWordUrl . "\" class=\"ewExportLink ewWord\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\">" . $Language->Phrase("ExportToWord") . "</a>";
		$item->Visible = TRUE;

		// Export to Html
		$item = &$this->ExportOptions->Add("html");
		$item->Body = "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ewExportLink ewHtml\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\">" . $Language->Phrase("ExportToHtml") . "</a>";
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->Add("xml");
		$item->Body = "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ewExportLink ewXml\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\">" . $Language->Phrase("ExportToXml") . "</a>";
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->Add("csv");
		$item->Body = "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ewExportLink ewCsv\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\">" . $Language->Phrase("ExportToCsv") . "</a>";
		$item->Visible = FALSE;

		// Export to Pdf
		$item = &$this->ExportOptions->Add("pdf");
		$item->Body = "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ewExportLink ewPdf\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\">" . $Language->Phrase("ExportToPDF") . "</a>";
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->Add("email");
		$url = "";
		$item->Body = "<button id=\"emf_kontrak\" class=\"ewExportLink ewEmail\" title=\"" . $Language->Phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->Phrase("ExportToEmailText") . "\" onclick=\"ew_EmailDialogShow({lnk:'emf_kontrak',hdr:ewLanguage.Phrase('ExportToEmailText'),f:document.fkontrakview,key:" . ew_ArrayToJsonAttr($this->RecKey) . ",sel:false" . $url . "});\">" . $Language->Phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseImageAndText = TRUE;
		$this->ExportOptions->UseDropDownButton = FALSE;
		if ($this->ExportOptions->UseButtonGroup && ew_IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->Phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->Add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide options for export
		if ($this->Export <> "")
			$this->ExportOptions->HideAllOptions();
	}

	// Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	function ExportData() {
		$utf8 = (strtolower(EW_CHARSET) == "utf-8");
		$bSelectLimit = FALSE;

		// Load recordset
		if ($bSelectLimit) {
			$this->TotalRecs = $this->ListRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->LoadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;
		$this->SetupStartRec(); // Set up start record position

		// Set the last record to display
		if ($this->DisplayRecs <= 0) {
			$this->StopRec = $this->TotalRecs;
		} else {
			$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
		}
		if (!$rs) {
			header("Content-Type:"); // Remove header
			header("Content-Disposition:");
			$this->ShowMessage();
			return;
		}
		$this->ExportDoc = ew_ExportDocument($this, "v");
		$Doc = &$this->ExportDoc;
		if ($bSelectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		} else {

			//$this->StartRec = $this->StartRec;
			//$this->StopRec = $this->StopRec;

		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$ParentTable = "";
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		$Doc->Text .= $sHeader;
		$this->ExportDocument($Doc, $rs, $this->StartRec, $this->StopRec, "view");
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		$Doc->Text .= $sFooter;

		// Close recordset
		$rs->Close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$Doc->ExportHeaderAndFooter();

		// Clean output buffer
		if (!EW_DEBUG_ENABLED && ob_get_length())
			ob_end_clean();

		// Write debug message if enabled
		if (EW_DEBUG_ENABLED && $this->Export <> "pdf")
			echo ew_DebugMsg();

		// Output data
		$Doc->Export();
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$Breadcrumb->Add("list", $this->TableVar, $this->AddMasterUrl("kontraklist.php"), "", $this->TableVar, TRUE);
		$PageId = "view";
		$Breadcrumb->Add("view", $PageId, $url);
	}

	// Setup lookup filters of a field
	function SetupLookupFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		}
	}

	// Setup AutoSuggest filters of a field
	function SetupAutoSuggestFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($kontrak_view)) $kontrak_view = new ckontrak_view();

// Page init
$kontrak_view->Page_Init();

// Page main
$kontrak_view->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$kontrak_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if ($kontrak->Export == "") { ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "view";
var CurrentForm = fkontrakview = new ew_Form("fkontrakview", "view");

// Form_CustomValidate event
fkontrakview.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fkontrakview.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fkontrakview.Lists["x_pet_id"] = {"LinkField":"x_pet_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_pet_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"petani"};
fkontrakview.Lists["x_pet_id"].Data = "<?php echo $kontrak_view->pet_id->LookupFilterQuery(FALSE, "view") ?>";
fkontrakview.Lists["x_koord_id"] = {"LinkField":"x_koord_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_koord_nama","","",""],"ParentFields":[],"ChildFields":["x_kk_id"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"koord"};
fkontrakview.Lists["x_koord_id"].Data = "<?php echo $kontrak_view->koord_id->LookupFilterQuery(FALSE, "view") ?>";
fkontrakview.Lists["x_kk_id"] = {"LinkField":"x_kk_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kk_periode","x_kk_tgl_mulai","x_kk_tgl_akhir",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kontrak_koord"};
fkontrakview.Lists["x_kk_id"].Data = "<?php echo $kontrak_view->kk_id->LookupFilterQuery(FALSE, "view") ?>";
fkontrakview.Lists["x_prov_id"] = {"LinkField":"x_prov_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_prov_nama","","",""],"ParentFields":[],"ChildFields":["x_kab_id","x_kec_id"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"prov"};
fkontrakview.Lists["x_prov_id"].Data = "<?php echo $kontrak_view->prov_id->LookupFilterQuery(FALSE, "view") ?>";
fkontrakview.Lists["x_kab_id"] = {"LinkField":"x_kab_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kab_nama","","",""],"ParentFields":[],"ChildFields":["x_kec_id"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kab"};
fkontrakview.Lists["x_kab_id"].Data = "<?php echo $kontrak_view->kab_id->LookupFilterQuery(FALSE, "view") ?>";
fkontrakview.Lists["x_kec_id"] = {"LinkField":"x_kec_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kec_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kec"};
fkontrakview.Lists["x_kec_id"].Data = "<?php echo $kontrak_view->kec_id->LookupFilterQuery(FALSE, "view") ?>";
fkontrakview.Lists["x_desa_id"] = {"LinkField":"x_desa_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_desa_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"desa"};
fkontrakview.Lists["x_desa_id"].Data = "<?php echo $kontrak_view->desa_id->LookupFilterQuery(FALSE, "view") ?>";
fkontrakview.Lists["x_blok_id"] = {"LinkField":"x_blok_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_blok_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"blok"};
fkontrakview.Lists["x_blok_id"].Data = "<?php echo $kontrak_view->blok_id->LookupFilterQuery(FALSE, "view") ?>";
fkontrakview.Lists["x_sos_id"] = {"LinkField":"x_sos_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_sos_id","x_sos_tgl","x_sos_alamat",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"sosialisasi"};
fkontrakview.Lists["x_sos_id"].Data = "<?php echo $kontrak_view->sos_id->LookupFilterQuery(FALSE, "view") ?>";
fkontrakview.Lists["x_var_id"] = {"LinkField":"x_var_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_var_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"varietas"};
fkontrakview.Lists["x_var_id"].Data = "<?php echo $kontrak_view->var_id->LookupFilterQuery(FALSE, "view") ?>";
fkontrakview.Lists["x_co_id"] = {"LinkField":"x_co_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_co_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"co"};
fkontrakview.Lists["x_co_id"].Data = "<?php echo $kontrak_view->co_id->LookupFilterQuery(FALSE, "view") ?>";

// Form object for search
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if ($kontrak->Export == "") { ?>
<div class="ewToolbar">
<?php $kontrak_view->ExportOptions->Render("body") ?>
<?php
	foreach ($kontrak_view->OtherOptions as &$option)
		$option->Render("body");
?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $kontrak_view->ShowPageHeader(); ?>
<?php
$kontrak_view->ShowMessage();
?>
<form name="fkontrakview" id="fkontrakview" class="form-inline ewForm ewViewForm" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($kontrak_view->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $kontrak_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="kontrak">
<input type="hidden" name="modal" value="<?php echo intval($kontrak_view->IsModal) ?>">
<table class="table table-striped table-bordered table-hover table-condensed ewViewTable">
<?php if ($kontrak->k_id_kontrak->Visible) { // k_id_kontrak ?>
	<tr id="r_k_id_kontrak">
		<td class="col-sm-2"><span id="elh_kontrak_k_id_kontrak"><?php echo $kontrak->k_id_kontrak->FldCaption() ?></span></td>
		<td data-name="k_id_kontrak"<?php echo $kontrak->k_id_kontrak->CellAttributes() ?>>
<span id="el_kontrak_k_id_kontrak">
<span<?php echo $kontrak->k_id_kontrak->ViewAttributes() ?>>
<?php echo $kontrak->k_id_kontrak->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->k_id_lama->Visible) { // k_id_lama ?>
	<tr id="r_k_id_lama">
		<td class="col-sm-2"><span id="elh_kontrak_k_id_lama"><?php echo $kontrak->k_id_lama->FldCaption() ?></span></td>
		<td data-name="k_id_lama"<?php echo $kontrak->k_id_lama->CellAttributes() ?>>
<span id="el_kontrak_k_id_lama">
<span<?php echo $kontrak->k_id_lama->ViewAttributes() ?>>
<?php echo $kontrak->k_id_lama->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->k_no_kontrak->Visible) { // k_no_kontrak ?>
	<tr id="r_k_no_kontrak">
		<td class="col-sm-2"><span id="elh_kontrak_k_no_kontrak"><?php echo $kontrak->k_no_kontrak->FldCaption() ?></span></td>
		<td data-name="k_no_kontrak"<?php echo $kontrak->k_no_kontrak->CellAttributes() ?>>
<span id="el_kontrak_k_no_kontrak">
<span<?php echo $kontrak->k_no_kontrak->ViewAttributes() ?>>
<?php echo $kontrak->k_no_kontrak->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->k_luas_lahan->Visible) { // k_luas_lahan ?>
	<tr id="r_k_luas_lahan">
		<td class="col-sm-2"><span id="elh_kontrak_k_luas_lahan"><?php echo $kontrak->k_luas_lahan->FldCaption() ?></span></td>
		<td data-name="k_luas_lahan"<?php echo $kontrak->k_luas_lahan->CellAttributes() ?>>
<span id="el_kontrak_k_luas_lahan">
<span<?php echo $kontrak->k_luas_lahan->ViewAttributes() ?>>
<?php echo $kontrak->k_luas_lahan->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->pet_id->Visible) { // pet_id ?>
	<tr id="r_pet_id">
		<td class="col-sm-2"><span id="elh_kontrak_pet_id"><?php echo $kontrak->pet_id->FldCaption() ?></span></td>
		<td data-name="pet_id"<?php echo $kontrak->pet_id->CellAttributes() ?>>
<span id="el_kontrak_pet_id">
<span<?php echo $kontrak->pet_id->ViewAttributes() ?>>
<?php if ((!ew_EmptyStr($kontrak->pet_id->ViewValue)) && $kontrak->pet_id->LinkAttributes() <> "") { ?>
<a<?php echo $kontrak->pet_id->LinkAttributes() ?>><?php echo $kontrak->pet_id->ViewValue ?></a>
<?php } else { ?>
<?php echo $kontrak->pet_id->ViewValue ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->koord_id->Visible) { // koord_id ?>
	<tr id="r_koord_id">
		<td class="col-sm-2"><span id="elh_kontrak_koord_id"><?php echo $kontrak->koord_id->FldCaption() ?></span></td>
		<td data-name="koord_id"<?php echo $kontrak->koord_id->CellAttributes() ?>>
<span id="el_kontrak_koord_id">
<span<?php echo $kontrak->koord_id->ViewAttributes() ?>>
<?php if ((!ew_EmptyStr($kontrak->koord_id->ViewValue)) && $kontrak->koord_id->LinkAttributes() <> "") { ?>
<a<?php echo $kontrak->koord_id->LinkAttributes() ?>><?php echo $kontrak->koord_id->ViewValue ?></a>
<?php } else { ?>
<?php echo $kontrak->koord_id->ViewValue ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->kk_id->Visible) { // kk_id ?>
	<tr id="r_kk_id">
		<td class="col-sm-2"><span id="elh_kontrak_kk_id"><?php echo $kontrak->kk_id->FldCaption() ?></span></td>
		<td data-name="kk_id"<?php echo $kontrak->kk_id->CellAttributes() ?>>
<span id="el_kontrak_kk_id">
<span<?php echo $kontrak->kk_id->ViewAttributes() ?>>
<?php if ((!ew_EmptyStr($kontrak->kk_id->ViewValue)) && $kontrak->kk_id->LinkAttributes() <> "") { ?>
<a<?php echo $kontrak->kk_id->LinkAttributes() ?>><?php echo $kontrak->kk_id->ViewValue ?></a>
<?php } else { ?>
<?php echo $kontrak->kk_id->ViewValue ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->prov_id->Visible) { // prov_id ?>
	<tr id="r_prov_id">
		<td class="col-sm-2"><span id="elh_kontrak_prov_id"><?php echo $kontrak->prov_id->FldCaption() ?></span></td>
		<td data-name="prov_id"<?php echo $kontrak->prov_id->CellAttributes() ?>>
<span id="el_kontrak_prov_id">
<span<?php echo $kontrak->prov_id->ViewAttributes() ?>>
<?php echo $kontrak->prov_id->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->kab_id->Visible) { // kab_id ?>
	<tr id="r_kab_id">
		<td class="col-sm-2"><span id="elh_kontrak_kab_id"><?php echo $kontrak->kab_id->FldCaption() ?></span></td>
		<td data-name="kab_id"<?php echo $kontrak->kab_id->CellAttributes() ?>>
<span id="el_kontrak_kab_id">
<span<?php echo $kontrak->kab_id->ViewAttributes() ?>>
<?php echo $kontrak->kab_id->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->kec_id->Visible) { // kec_id ?>
	<tr id="r_kec_id">
		<td class="col-sm-2"><span id="elh_kontrak_kec_id"><?php echo $kontrak->kec_id->FldCaption() ?></span></td>
		<td data-name="kec_id"<?php echo $kontrak->kec_id->CellAttributes() ?>>
<span id="el_kontrak_kec_id">
<span<?php echo $kontrak->kec_id->ViewAttributes() ?>>
<?php echo $kontrak->kec_id->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->desa_id->Visible) { // desa_id ?>
	<tr id="r_desa_id">
		<td class="col-sm-2"><span id="elh_kontrak_desa_id"><?php echo $kontrak->desa_id->FldCaption() ?></span></td>
		<td data-name="desa_id"<?php echo $kontrak->desa_id->CellAttributes() ?>>
<span id="el_kontrak_desa_id">
<span<?php echo $kontrak->desa_id->ViewAttributes() ?>>
<?php echo $kontrak->desa_id->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->blok_id->Visible) { // blok_id ?>
	<tr id="r_blok_id">
		<td class="col-sm-2"><span id="elh_kontrak_blok_id"><?php echo $kontrak->blok_id->FldCaption() ?></span></td>
		<td data-name="blok_id"<?php echo $kontrak->blok_id->CellAttributes() ?>>
<span id="el_kontrak_blok_id">
<span<?php echo $kontrak->blok_id->ViewAttributes() ?>>
<?php echo $kontrak->blok_id->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->sos_id->Visible) { // sos_id ?>
	<tr id="r_sos_id">
		<td class="col-sm-2"><span id="elh_kontrak_sos_id"><?php echo $kontrak->sos_id->FldCaption() ?></span></td>
		<td data-name="sos_id"<?php echo $kontrak->sos_id->CellAttributes() ?>>
<span id="el_kontrak_sos_id">
<span<?php echo $kontrak->sos_id->ViewAttributes() ?>>
<?php echo $kontrak->sos_id->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->var_id->Visible) { // var_id ?>
	<tr id="r_var_id">
		<td class="col-sm-2"><span id="elh_kontrak_var_id"><?php echo $kontrak->var_id->FldCaption() ?></span></td>
		<td data-name="var_id"<?php echo $kontrak->var_id->CellAttributes() ?>>
<span id="el_kontrak_var_id">
<span<?php echo $kontrak->var_id->ViewAttributes() ?>>
<?php if ((!ew_EmptyStr($kontrak->var_id->ViewValue)) && $kontrak->var_id->LinkAttributes() <> "") { ?>
<a<?php echo $kontrak->var_id->LinkAttributes() ?>><?php echo $kontrak->var_id->ViewValue ?></a>
<?php } else { ?>
<?php echo $kontrak->var_id->ViewValue ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->co_id->Visible) { // co_id ?>
	<tr id="r_co_id">
		<td class="col-sm-2"><span id="elh_kontrak_co_id"><?php echo $kontrak->co_id->FldCaption() ?></span></td>
		<td data-name="co_id"<?php echo $kontrak->co_id->CellAttributes() ?>>
<span id="el_kontrak_co_id">
<span<?php echo $kontrak->co_id->ViewAttributes() ?>>
<?php if ((!ew_EmptyStr($kontrak->co_id->ViewValue)) && $kontrak->co_id->LinkAttributes() <> "") { ?>
<a<?php echo $kontrak->co_id->LinkAttributes() ?>><?php echo $kontrak->co_id->ViewValue ?></a>
<?php } else { ?>
<?php echo $kontrak->co_id->ViewValue ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->k_jumlah_bibit->Visible) { // k_jumlah_bibit ?>
	<tr id="r_k_jumlah_bibit">
		<td class="col-sm-2"><span id="elh_kontrak_k_jumlah_bibit"><?php echo $kontrak->k_jumlah_bibit->FldCaption() ?></span></td>
		<td data-name="k_jumlah_bibit"<?php echo $kontrak->k_jumlah_bibit->CellAttributes() ?>>
<span id="el_kontrak_k_jumlah_bibit">
<span<?php echo $kontrak->k_jumlah_bibit->ViewAttributes() ?>>
<?php echo $kontrak->k_jumlah_bibit->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->k_asal_bibit->Visible) { // k_asal_bibit ?>
	<tr id="r_k_asal_bibit">
		<td class="col-sm-2"><span id="elh_kontrak_k_asal_bibit"><?php echo $kontrak->k_asal_bibit->FldCaption() ?></span></td>
		<td data-name="k_asal_bibit"<?php echo $kontrak->k_asal_bibit->CellAttributes() ?>>
<span id="el_kontrak_k_asal_bibit">
<span<?php echo $kontrak->k_asal_bibit->ViewAttributes() ?>>
<?php echo $kontrak->k_asal_bibit->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->k_tgl_tanam->Visible) { // k_tgl_tanam ?>
	<tr id="r_k_tgl_tanam">
		<td class="col-sm-2"><span id="elh_kontrak_k_tgl_tanam"><?php echo $kontrak->k_tgl_tanam->FldCaption() ?></span></td>
		<td data-name="k_tgl_tanam"<?php echo $kontrak->k_tgl_tanam->CellAttributes() ?>>
<span id="el_kontrak_k_tgl_tanam">
<span<?php echo $kontrak->k_tgl_tanam->ViewAttributes() ?>>
<?php echo $kontrak->k_tgl_tanam->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->k_es_tgl_panen->Visible) { // k_es_tgl_panen ?>
	<tr id="r_k_es_tgl_panen">
		<td class="col-sm-2"><span id="elh_kontrak_k_es_tgl_panen"><?php echo $kontrak->k_es_tgl_panen->FldCaption() ?></span></td>
		<td data-name="k_es_tgl_panen"<?php echo $kontrak->k_es_tgl_panen->CellAttributes() ?>>
<span id="el_kontrak_k_es_tgl_panen">
<span<?php echo $kontrak->k_es_tgl_panen->ViewAttributes() ?>>
<?php echo $kontrak->k_es_tgl_panen->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->k_ak_tgl_datang->Visible) { // k_ak_tgl_datang ?>
	<tr id="r_k_ak_tgl_datang">
		<td class="col-sm-2"><span id="elh_kontrak_k_ak_tgl_datang"><?php echo $kontrak->k_ak_tgl_datang->FldCaption() ?></span></td>
		<td data-name="k_ak_tgl_datang"<?php echo $kontrak->k_ak_tgl_datang->CellAttributes() ?>>
<span id="el_kontrak_k_ak_tgl_datang">
<span<?php echo $kontrak->k_ak_tgl_datang->ViewAttributes() ?>>
<?php echo $kontrak->k_ak_tgl_datang->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->k_es_qty->Visible) { // k_es_qty ?>
	<tr id="r_k_es_qty">
		<td class="col-sm-2"><span id="elh_kontrak_k_es_qty"><?php echo $kontrak->k_es_qty->FldCaption() ?></span></td>
		<td data-name="k_es_qty"<?php echo $kontrak->k_es_qty->CellAttributes() ?>>
<span id="el_kontrak_k_es_qty">
<span<?php echo $kontrak->k_es_qty->ViewAttributes() ?>>
<?php echo $kontrak->k_es_qty->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->k_ak_qty->Visible) { // k_ak_qty ?>
	<tr id="r_k_ak_qty">
		<td class="col-sm-2"><span id="elh_kontrak_k_ak_qty"><?php echo $kontrak->k_ak_qty->FldCaption() ?></span></td>
		<td data-name="k_ak_qty"<?php echo $kontrak->k_ak_qty->CellAttributes() ?>>
<span id="el_kontrak_k_ak_qty">
<span<?php echo $kontrak->k_ak_qty->ViewAttributes() ?>>
<?php echo $kontrak->k_ak_qty->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->k_es_perhektar->Visible) { // k_es_perhektar ?>
	<tr id="r_k_es_perhektar">
		<td class="col-sm-2"><span id="elh_kontrak_k_es_perhektar"><?php echo $kontrak->k_es_perhektar->FldCaption() ?></span></td>
		<td data-name="k_es_perhektar"<?php echo $kontrak->k_es_perhektar->CellAttributes() ?>>
<span id="el_kontrak_k_es_perhektar">
<span<?php echo $kontrak->k_es_perhektar->ViewAttributes() ?>>
<?php echo $kontrak->k_es_perhektar->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->k_ak_perhektar->Visible) { // k_ak_perhektar ?>
	<tr id="r_k_ak_perhektar">
		<td class="col-sm-2"><span id="elh_kontrak_k_ak_perhektar"><?php echo $kontrak->k_ak_perhektar->FldCaption() ?></span></td>
		<td data-name="k_ak_perhektar"<?php echo $kontrak->k_ak_perhektar->CellAttributes() ?>>
<span id="el_kontrak_k_ak_perhektar">
<span<?php echo $kontrak->k_ak_perhektar->ViewAttributes() ?>>
<?php echo $kontrak->k_ak_perhektar->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->k_skor->Visible) { // k_skor ?>
	<tr id="r_k_skor">
		<td class="col-sm-2"><span id="elh_kontrak_k_skor"><?php echo $kontrak->k_skor->FldCaption() ?></span></td>
		<td data-name="k_skor"<?php echo $kontrak->k_skor->CellAttributes() ?>>
<span id="el_kontrak_k_skor">
<span<?php echo $kontrak->k_skor->ViewAttributes() ?>>
<?php echo $kontrak->k_skor->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->k_ket->Visible) { // k_ket ?>
	<tr id="r_k_ket">
		<td class="col-sm-2"><span id="elh_kontrak_k_ket"><?php echo $kontrak->k_ket->FldCaption() ?></span></td>
		<td data-name="k_ket"<?php echo $kontrak->k_ket->CellAttributes() ?>>
<span id="el_kontrak_k_ket">
<span<?php echo $kontrak->k_ket->ViewAttributes() ?>>
<?php echo $kontrak->k_ket->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->k_cat->Visible) { // k_cat ?>
	<tr id="r_k_cat">
		<td class="col-sm-2"><span id="elh_kontrak_k_cat"><?php echo $kontrak->k_cat->FldCaption() ?></span></td>
		<td data-name="k_cat"<?php echo $kontrak->k_cat->CellAttributes() ?>>
<span id="el_kontrak_k_cat">
<span<?php echo $kontrak->k_cat->ViewAttributes() ?>>
<?php echo $kontrak->k_cat->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->k_titik_koordinat->Visible) { // k_titik_koordinat ?>
	<tr id="r_k_titik_koordinat">
		<td class="col-sm-2"><span id="elh_kontrak_k_titik_koordinat"><?php echo $kontrak->k_titik_koordinat->FldCaption() ?></span></td>
		<td data-name="k_titik_koordinat"<?php echo $kontrak->k_titik_koordinat->CellAttributes() ?>>
<span id="el_kontrak_k_titik_koordinat">
<span<?php echo $kontrak->k_titik_koordinat->ViewAttributes() ?>>
<?php if ((!ew_EmptyStr($kontrak->k_titik_koordinat->ViewValue)) && $kontrak->k_titik_koordinat->LinkAttributes() <> "") { ?>
<a<?php echo $kontrak->k_titik_koordinat->LinkAttributes() ?>><?php echo $kontrak->k_titik_koordinat->ViewValue ?></a>
<?php } else { ?>
<?php echo $kontrak->k_titik_koordinat->ViewValue ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->k_foto_lahan->Visible) { // k_foto_lahan ?>
	<tr id="r_k_foto_lahan">
		<td class="col-sm-2"><span id="elh_kontrak_k_foto_lahan"><?php echo $kontrak->k_foto_lahan->FldCaption() ?></span></td>
		<td data-name="k_foto_lahan"<?php echo $kontrak->k_foto_lahan->CellAttributes() ?>>
<span id="el_kontrak_k_foto_lahan">
<span>
<?php echo ew_GetFileViewTag($kontrak->k_foto_lahan, $kontrak->k_foto_lahan->ViewValue) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->k_dok->Visible) { // k_dok ?>
	<tr id="r_k_dok">
		<td class="col-sm-2"><span id="elh_kontrak_k_dok"><?php echo $kontrak->k_dok->FldCaption() ?></span></td>
		<td data-name="k_dok"<?php echo $kontrak->k_dok->CellAttributes() ?>>
<span id="el_kontrak_k_dok">
<span>
<?php echo ew_GetFileViewTag($kontrak->k_dok, $kontrak->k_dok->ViewValue) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->k_harga_bibit->Visible) { // k_harga_bibit ?>
	<tr id="r_k_harga_bibit">
		<td class="col-sm-2"><span id="elh_kontrak_k_harga_bibit"><?php echo $kontrak->k_harga_bibit->FldCaption() ?></span></td>
		<td data-name="k_harga_bibit"<?php echo $kontrak->k_harga_bibit->CellAttributes() ?>>
<span id="el_kontrak_k_harga_bibit">
<span<?php echo $kontrak->k_harga_bibit->ViewAttributes() ?>>
<?php echo $kontrak->k_harga_bibit->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->k_bayar_bibit->Visible) { // k_bayar_bibit ?>
	<tr id="r_k_bayar_bibit">
		<td class="col-sm-2"><span id="elh_kontrak_k_bayar_bibit"><?php echo $kontrak->k_bayar_bibit->FldCaption() ?></span></td>
		<td data-name="k_bayar_bibit"<?php echo $kontrak->k_bayar_bibit->CellAttributes() ?>>
<span id="el_kontrak_k_bayar_bibit">
<span<?php echo $kontrak->k_bayar_bibit->ViewAttributes() ?>>
<?php echo $kontrak->k_bayar_bibit->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->k_pinjaman->Visible) { // k_pinjaman ?>
	<tr id="r_k_pinjaman">
		<td class="col-sm-2"><span id="elh_kontrak_k_pinjaman"><?php echo $kontrak->k_pinjaman->FldCaption() ?></span></td>
		<td data-name="k_pinjaman"<?php echo $kontrak->k_pinjaman->CellAttributes() ?>>
<span id="el_kontrak_k_pinjaman">
<span<?php echo $kontrak->k_pinjaman->ViewAttributes() ?>>
<?php echo $kontrak->k_pinjaman->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->k_bayar_pinjaman->Visible) { // k_bayar_pinjaman ?>
	<tr id="r_k_bayar_pinjaman">
		<td class="col-sm-2"><span id="elh_kontrak_k_bayar_pinjaman"><?php echo $kontrak->k_bayar_pinjaman->FldCaption() ?></span></td>
		<td data-name="k_bayar_pinjaman"<?php echo $kontrak->k_bayar_pinjaman->CellAttributes() ?>>
<span id="el_kontrak_k_bayar_pinjaman">
<span<?php echo $kontrak->k_bayar_pinjaman->ViewAttributes() ?>>
<?php echo $kontrak->k_bayar_pinjaman->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kontrak->k_sisa_hutang->Visible) { // k_sisa_hutang ?>
	<tr id="r_k_sisa_hutang">
		<td class="col-sm-2"><span id="elh_kontrak_k_sisa_hutang"><?php echo $kontrak->k_sisa_hutang->FldCaption() ?></span></td>
		<td data-name="k_sisa_hutang"<?php echo $kontrak->k_sisa_hutang->CellAttributes() ?>>
<span id="el_kontrak_k_sisa_hutang">
<span<?php echo $kontrak->k_sisa_hutang->ViewAttributes() ?>>
<?php echo $kontrak->k_sisa_hutang->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php if ($kontrak->Export == "") { ?>
<script type="text/javascript">
fkontrakview.Init();
</script>
<?php } ?>
<?php
$kontrak_view->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<?php if ($kontrak->Export == "") { ?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$kontrak_view->Page_Terminate();
?>
