<?php
if (session_id() == "") session_start(); // Init session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg14.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql14.php") ?>
<?php include_once "phpfn14.php" ?>
<?php include_once "kontrakinfo.php" ?>
<?php include_once "employeesinfo.php" ?>
<?php include_once "userfn14.php" ?>
<?php

//
// Page class
//

$kontrak_list = NULL; // Initialize page object first

class ckontrak_list extends ckontrak {

	// Page ID
	var $PageID = 'list';

	// Project ID
	var $ProjectID = '{CC60B42B-604B-412A-B014-2315920AF6AA}';

	// Table name
	var $TableName = 'kontrak';

	// Page object name
	var $PageObjName = 'kontrak_list';

	// Grid form hidden field names
	var $FormName = 'fkontraklist';
	var $FormActionName = 'k_action';
	var $FormKeyName = 'k_key';
	var $FormOldKeyName = 'k_oldkey';
	var $FormBlankRowName = 'k_blankrow';
	var $FormKeyCountName = 'key_count';

	// Page headings
	var $Heading = '';
	var $Subheading = '';

	// Page heading
	function PageHeading() {
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->TableCaption();
		return "";
	}

	// Page subheading
	function PageSubheading() {
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->Phrase($this->PageID);
		return "";
	}

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;
	var $ExportPdfUrl;

	// Custom export
	var $ExportExcelCustom = FALSE;
	var $ExportWordCustom = FALSE;
	var $ExportPdfCustom = FALSE;
	var $ExportEmailCustom = FALSE;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (kontrak)
		if (!isset($GLOBALS["kontrak"]) || get_class($GLOBALS["kontrak"]) == "ckontrak") {
			$GLOBALS["kontrak"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["kontrak"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->PageUrl() . "export=print";
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel";
		$this->ExportWordUrl = $this->PageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->PageUrl() . "export=html";
		$this->ExportXmlUrl = $this->PageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->PageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf";
		$this->AddUrl = "kontrakadd.php";
		$this->InlineAddUrl = $this->PageUrl() . "a=add";
		$this->GridAddUrl = $this->PageUrl() . "a=gridadd";
		$this->GridEditUrl = $this->PageUrl() . "a=gridedit";
		$this->MultiDeleteUrl = "kontrakdelete.php";
		$this->MultiUpdateUrl = "kontrakupdate.php";

		// Table object (employees)
		if (!isset($GLOBALS['employees'])) $GLOBALS['employees'] = new cemployees();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'list', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'kontrak', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"]))
			$GLOBALS["gTimer"] = new cTimer();

		// Debug message
		ew_LoadDebugMsg();

		// Open connection
		if (!isset($conn))
			$conn = ew_Connect($this->DBID);

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new cemployees();
			$UserTableConn = Conn($UserTable->DBID);
		}

		// List options
		$this->ListOptions = new cListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new cListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Other options
		$this->OtherOptions['addedit'] = new cListOptions();
		$this->OtherOptions['addedit']->Tag = "div";
		$this->OtherOptions['addedit']->TagClassName = "ewAddEditOption";
		$this->OtherOptions['detail'] = new cListOptions();
		$this->OtherOptions['detail']->Tag = "div";
		$this->OtherOptions['detail']->TagClassName = "ewDetailOption";
		$this->OtherOptions['action'] = new cListOptions();
		$this->OtherOptions['action']->Tag = "div";
		$this->OtherOptions['action']->TagClassName = "ewActionOption";

		// Filter options
		$this->FilterOptions = new cListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ewFilterOption fkontraklistsrch";

		// List actions
		$this->ListActions = new cListActions();
	}

	//
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// User profile
		$UserProfile = new cUserProfile();

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanList()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			$this->Page_Terminate(ew_GetUrl("index.php"));
		}

		// NOTE: Security object may be needed in other part of the script, skip set to Nothing
		// 
		// Security = null;
		// 
		// Get export parameters

		$custom = "";
		if (@$_GET["export"] <> "") {
			$this->Export = $_GET["export"];
			$custom = @$_GET["custom"];
		} elseif (@$_POST["export"] <> "") {
			$this->Export = $_POST["export"];
			$custom = @$_POST["custom"];
		} elseif (ew_IsPost()) {
			if (@$_POST["exporttype"] <> "")
				$this->Export = $_POST["exporttype"];
			$custom = @$_POST["custom"];
		} elseif (@$_GET["cmd"] == "json") {
			$this->Export = $_GET["cmd"];
		} else {
			$this->setExportReturnUrl(ew_CurrentUrl());
		}
		$gsExportFile = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->Export <> "" && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$gsCustomExport = $this->CustomExport;
		$gsExport = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined("EW_USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined("EW_USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action

		// Get grid add count
		$gridaddcnt = @$_GET[EW_TABLE_GRID_ADD_ROW_COUNT];
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->SetupListOptions();

		// Setup export options
		$this->SetupExportOptions();
		$this->k_id_kontrak->SetVisibility();
		$this->k_id_lama->SetVisibility();
		$this->k_no_kontrak->SetVisibility();
		$this->k_luas_lahan->SetVisibility();
		$this->pet_id->SetVisibility();
		$this->koord_id->SetVisibility();
		$this->kk_id->SetVisibility();
		$this->prov_id->SetVisibility();
		$this->kab_id->SetVisibility();
		$this->kec_id->SetVisibility();
		$this->desa_id->SetVisibility();
		$this->blok_id->SetVisibility();
		$this->sos_id->SetVisibility();
		$this->var_id->SetVisibility();
		$this->co_id->SetVisibility();
		$this->k_jumlah_bibit->SetVisibility();
		$this->k_asal_bibit->SetVisibility();
		$this->k_tgl_tanam->SetVisibility();
		$this->k_es_tgl_panen->SetVisibility();
		$this->k_ak_tgl_datang->SetVisibility();
		$this->k_es_qty->SetVisibility();
		$this->k_ak_qty->SetVisibility();
		$this->k_es_perhektar->SetVisibility();
		$this->k_ak_perhektar->SetVisibility();
		$this->k_skor->SetVisibility();
		$this->k_ket->SetVisibility();
		$this->k_cat->SetVisibility();
		$this->k_titik_koordinat->SetVisibility();
		$this->k_foto_lahan->SetVisibility();
		$this->k_dok->SetVisibility();
		$this->k_harga_bibit->SetVisibility();
		$this->k_bayar_bibit->SetVisibility();
		$this->k_pinjaman->SetVisibility();
		$this->k_bayar_pinjaman->SetVisibility();
		$this->k_sisa_hutang->SetVisibility();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();

		// Setup other options
		$this->SetupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->Add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == EW_ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $kontrak;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($kontrak);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		// Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			ew_SaveDebugMsg();
			header("Location: " . $url);
		}
		exit();
	}

	// Class variables
	var $ListOptions; // List options
	var $ExportOptions; // Export options
	var $SearchOptions; // Search options
	var $OtherOptions = array(); // Other options
	var $FilterOptions; // Filter options
	var $ListActions; // List actions
	var $SelectedCount = 0;
	var $SelectedIndex = 0;
	var $DisplayRecs = 100;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $Pager;
	var $AutoHidePager = EW_AUTO_HIDE_PAGER;
	var $AutoHidePageSizeSelector = EW_AUTO_HIDE_PAGE_SIZE_SELECTOR;
	var $DefaultSearchWhere = ""; // Default search WHERE clause
	var $SearchWhere = ""; // Search WHERE clause
	var $RecCnt = 0; // Record count
	var $EditRowCnt;
	var $StartRowCnt = 1;
	var $RowCnt = 0;
	var $Attrs = array(); // Row attributes and cell attributes
	var $RowIndex = 0; // Row index
	var $KeyCount = 0; // Key count
	var $RowAction = ""; // Row action
	var $RowOldKey = ""; // Row old key (for copy)
	var $RecPerRow = 0;
	var $MultiColumnClass;
	var $MultiColumnEditClass = "col-sm-12";
	var $MultiColumnCnt = 12;
	var $MultiColumnEditCnt = 12;
	var $GridCnt = 0;
	var $ColCnt = 0;
	var $DbMasterFilter = ""; // Master filter
	var $DbDetailFilter = ""; // Detail filter
	var $MasterRecordExists;
	var $MultiSelectKey;
	var $Command;
	var $RestoreSearch = FALSE;
	var $DetailPages;
	var $Recordset;
	var $OldRecordset;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError, $gsSearchError, $Security, $EW_EXPORT;

		// Search filters
		$sSrchAdvanced = ""; // Advanced search filter
		$sSrchBasic = ""; // Basic search filter
		$sFilter = "";

		// Get command
		$this->Command = strtolower(@$_GET["cmd"]);
		if ($this->IsPageRequest()) { // Validate request

			// Process list action first
			if ($this->ProcessListAction()) // Ajax request
				$this->Page_Terminate();

			// Handle reset command
			$this->ResetCmd();

			// Set up Breadcrumb
			if ($this->Export == "")
				$this->SetupBreadcrumb();

			// Hide list options
			if ($this->Export <> "") {
				$this->ListOptions->HideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->CurrentAction == "gridadd" || $this->CurrentAction == "gridedit") {
				$this->ListOptions->HideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->Export <> "" || $this->CurrentAction <> "") {
				$this->ExportOptions->HideAllOptions();
				$this->FilterOptions->HideAllOptions();
			}

			// Hide other options
			if ($this->Export <> "") {
				foreach ($this->OtherOptions as &$option)
					$option->HideAllOptions();
			}

			// Get default search criteria
			ew_AddFilter($this->DefaultSearchWhere, $this->BasicSearchWhere(TRUE));
			ew_AddFilter($this->DefaultSearchWhere, $this->AdvancedSearchWhere(TRUE));

			// Get basic search values
			$this->LoadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->LoadSearchValues(); // Get search values

			// Process filter list
			$this->ProcessFilterList();
			if (!$this->ValidateSearch())
				$this->setFailureMessage($gsSearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->Export <> "" || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->CheckSearchParms())
				$this->RestoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->SetupSortOrder();

			// Get basic search criteria
			if ($gsSearchError == "")
				$sSrchBasic = $this->BasicSearchWhere();

			// Get search criteria for advanced search
			if ($gsSearchError == "")
				$sSrchAdvanced = $this->AdvancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 100; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->LoadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->CheckSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->LoadDefault();
			if ($this->BasicSearch->Keyword != "")
				$sSrchBasic = $this->BasicSearchWhere();

			// Load advanced search from default
			if ($this->LoadAdvancedSearchDefault()) {
				$sSrchAdvanced = $this->AdvancedSearchWhere();
			}
		}

		// Build search criteria
		ew_AddFilter($this->SearchWhere, $sSrchAdvanced);
		ew_AddFilter($this->SearchWhere, $sSrchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$sFilter = "";
		if (!$Security->CanList())
			$sFilter = "(0=1)"; // Filter all records
		ew_AddFilter($sFilter, $this->DbDetailFilter);
		ew_AddFilter($sFilter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSQL = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $sFilter;
		} else {
			$this->setSessionWhere($sFilter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if ($this->CustomExport == "" && in_array($this->Export, array_keys($EW_EXPORT))) {
			$this->ExportData();
			$this->Page_Terminate(); // Terminate response
			exit();
		}

		// Load record count first
		if (!$this->IsAddOrEdit()) {
			$bSelectLimit = $this->UseSelectLimit;
			if ($bSelectLimit) {
				$this->TotalRecs = $this->ListRecordCount();
			} else {
				if ($this->Recordset = $this->LoadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
		}

		// Search options
		$this->SetupSearchOptions();
	}

	// Build filter for all keys
	function BuildKeyFilter() {
		global $objForm;
		$sWrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$objForm->Index = $rowindex;
		$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		while ($sThisKey <> "") {
			if ($this->SetupKeyValues($sThisKey)) {
				$sFilter = $this->KeyFilter();
				if ($sWrkFilter <> "") $sWrkFilter .= " OR ";
				$sWrkFilter .= $sFilter;
			} else {
				$sWrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$objForm->Index = $rowindex;
			$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		}
		return $sWrkFilter;
	}

	// Set up key values
	function SetupKeyValues($key) {
		$arrKeyFlds = explode($GLOBALS["EW_COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arrKeyFlds) >= 1) {
			$this->k_id->setFormValue($arrKeyFlds[0]);
			if (!is_numeric($this->k_id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	function GetFilterList() {
		global $UserProfile;

		// Initialize
		$sFilterList = "";
		$sSavedFilterList = "";
		$sFilterList = ew_Concat($sFilterList, $this->k_id->AdvancedSearch->ToJson(), ","); // Field k_id
		$sFilterList = ew_Concat($sFilterList, $this->k_id_kontrak->AdvancedSearch->ToJson(), ","); // Field k_id_kontrak
		$sFilterList = ew_Concat($sFilterList, $this->k_id_lama->AdvancedSearch->ToJson(), ","); // Field k_id_lama
		$sFilterList = ew_Concat($sFilterList, $this->k_no_kontrak->AdvancedSearch->ToJson(), ","); // Field k_no_kontrak
		$sFilterList = ew_Concat($sFilterList, $this->k_luas_lahan->AdvancedSearch->ToJson(), ","); // Field k_luas_lahan
		$sFilterList = ew_Concat($sFilterList, $this->pet_id->AdvancedSearch->ToJson(), ","); // Field pet_id
		$sFilterList = ew_Concat($sFilterList, $this->koord_id->AdvancedSearch->ToJson(), ","); // Field koord_id
		$sFilterList = ew_Concat($sFilterList, $this->kk_id->AdvancedSearch->ToJson(), ","); // Field kk_id
		$sFilterList = ew_Concat($sFilterList, $this->prov_id->AdvancedSearch->ToJson(), ","); // Field prov_id
		$sFilterList = ew_Concat($sFilterList, $this->kab_id->AdvancedSearch->ToJson(), ","); // Field kab_id
		$sFilterList = ew_Concat($sFilterList, $this->kec_id->AdvancedSearch->ToJson(), ","); // Field kec_id
		$sFilterList = ew_Concat($sFilterList, $this->desa_id->AdvancedSearch->ToJson(), ","); // Field desa_id
		$sFilterList = ew_Concat($sFilterList, $this->blok_id->AdvancedSearch->ToJson(), ","); // Field blok_id
		$sFilterList = ew_Concat($sFilterList, $this->sos_id->AdvancedSearch->ToJson(), ","); // Field sos_id
		$sFilterList = ew_Concat($sFilterList, $this->var_id->AdvancedSearch->ToJson(), ","); // Field var_id
		$sFilterList = ew_Concat($sFilterList, $this->co_id->AdvancedSearch->ToJson(), ","); // Field co_id
		$sFilterList = ew_Concat($sFilterList, $this->k_jumlah_bibit->AdvancedSearch->ToJson(), ","); // Field k_jumlah_bibit
		$sFilterList = ew_Concat($sFilterList, $this->k_asal_bibit->AdvancedSearch->ToJson(), ","); // Field k_asal_bibit
		$sFilterList = ew_Concat($sFilterList, $this->k_tgl_tanam->AdvancedSearch->ToJson(), ","); // Field k_tgl_tanam
		$sFilterList = ew_Concat($sFilterList, $this->k_es_tgl_panen->AdvancedSearch->ToJson(), ","); // Field k_es_tgl_panen
		$sFilterList = ew_Concat($sFilterList, $this->k_ak_tgl_datang->AdvancedSearch->ToJson(), ","); // Field k_ak_tgl_datang
		$sFilterList = ew_Concat($sFilterList, $this->k_es_qty->AdvancedSearch->ToJson(), ","); // Field k_es_qty
		$sFilterList = ew_Concat($sFilterList, $this->k_ak_qty->AdvancedSearch->ToJson(), ","); // Field k_ak_qty
		$sFilterList = ew_Concat($sFilterList, $this->k_es_perhektar->AdvancedSearch->ToJson(), ","); // Field k_es_perhektar
		$sFilterList = ew_Concat($sFilterList, $this->k_ak_perhektar->AdvancedSearch->ToJson(), ","); // Field k_ak_perhektar
		$sFilterList = ew_Concat($sFilterList, $this->k_skor->AdvancedSearch->ToJson(), ","); // Field k_skor
		$sFilterList = ew_Concat($sFilterList, $this->k_ket->AdvancedSearch->ToJson(), ","); // Field k_ket
		$sFilterList = ew_Concat($sFilterList, $this->k_cat->AdvancedSearch->ToJson(), ","); // Field k_cat
		$sFilterList = ew_Concat($sFilterList, $this->k_titik_koordinat->AdvancedSearch->ToJson(), ","); // Field k_titik_koordinat
		$sFilterList = ew_Concat($sFilterList, $this->k_foto_lahan->AdvancedSearch->ToJson(), ","); // Field k_foto_lahan
		$sFilterList = ew_Concat($sFilterList, $this->k_dok->AdvancedSearch->ToJson(), ","); // Field k_dok
		$sFilterList = ew_Concat($sFilterList, $this->k_harga_bibit->AdvancedSearch->ToJson(), ","); // Field k_harga_bibit
		$sFilterList = ew_Concat($sFilterList, $this->k_bayar_bibit->AdvancedSearch->ToJson(), ","); // Field k_bayar_bibit
		$sFilterList = ew_Concat($sFilterList, $this->k_pinjaman->AdvancedSearch->ToJson(), ","); // Field k_pinjaman
		$sFilterList = ew_Concat($sFilterList, $this->k_bayar_pinjaman->AdvancedSearch->ToJson(), ","); // Field k_bayar_pinjaman
		$sFilterList = ew_Concat($sFilterList, $this->k_sisa_hutang->AdvancedSearch->ToJson(), ","); // Field k_sisa_hutang
		if ($this->BasicSearch->Keyword <> "") {
			$sWrk = "\"" . EW_TABLE_BASIC_SEARCH . "\":\"" . ew_JsEncode2($this->BasicSearch->Keyword) . "\",\"" . EW_TABLE_BASIC_SEARCH_TYPE . "\":\"" . ew_JsEncode2($this->BasicSearch->Type) . "\"";
			$sFilterList = ew_Concat($sFilterList, $sWrk, ",");
		}
		$sFilterList = preg_replace('/,$/', "", $sFilterList);

		// Return filter list in json
		if ($sFilterList <> "")
			$sFilterList = "\"data\":{" . $sFilterList . "}";
		if ($sSavedFilterList <> "") {
			if ($sFilterList <> "")
				$sFilterList .= ",";
			$sFilterList .= "\"filters\":" . $sSavedFilterList;
		}
		return ($sFilterList <> "") ? "{" . $sFilterList . "}" : "null";
	}

	// Process filter list
	function ProcessFilterList() {
		global $UserProfile;
		if (@$_POST["ajax"] == "savefilters") { // Save filter request (Ajax)
			$filters = @$_POST["filters"];
			$UserProfile->SetSearchFilters(CurrentUserName(), "fkontraklistsrch", $filters);

			// Clean output buffer
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			echo ew_ArrayToJson(array(array("success" => TRUE))); // Success
			$this->Page_Terminate();
			exit();
		} elseif (@$_POST["cmd"] == "resetfilter") {
			$this->RestoreFilterList();
		}
	}

	// Restore list of filters
	function RestoreFilterList() {

		// Return if not reset filter
		if (@$_POST["cmd"] <> "resetfilter")
			return FALSE;
		$filter = json_decode(@$_POST["filter"], TRUE);
		$this->Command = "search";

		// Field k_id
		$this->k_id->AdvancedSearch->SearchValue = @$filter["x_k_id"];
		$this->k_id->AdvancedSearch->SearchOperator = @$filter["z_k_id"];
		$this->k_id->AdvancedSearch->SearchCondition = @$filter["v_k_id"];
		$this->k_id->AdvancedSearch->SearchValue2 = @$filter["y_k_id"];
		$this->k_id->AdvancedSearch->SearchOperator2 = @$filter["w_k_id"];
		$this->k_id->AdvancedSearch->Save();

		// Field k_id_kontrak
		$this->k_id_kontrak->AdvancedSearch->SearchValue = @$filter["x_k_id_kontrak"];
		$this->k_id_kontrak->AdvancedSearch->SearchOperator = @$filter["z_k_id_kontrak"];
		$this->k_id_kontrak->AdvancedSearch->SearchCondition = @$filter["v_k_id_kontrak"];
		$this->k_id_kontrak->AdvancedSearch->SearchValue2 = @$filter["y_k_id_kontrak"];
		$this->k_id_kontrak->AdvancedSearch->SearchOperator2 = @$filter["w_k_id_kontrak"];
		$this->k_id_kontrak->AdvancedSearch->Save();

		// Field k_id_lama
		$this->k_id_lama->AdvancedSearch->SearchValue = @$filter["x_k_id_lama"];
		$this->k_id_lama->AdvancedSearch->SearchOperator = @$filter["z_k_id_lama"];
		$this->k_id_lama->AdvancedSearch->SearchCondition = @$filter["v_k_id_lama"];
		$this->k_id_lama->AdvancedSearch->SearchValue2 = @$filter["y_k_id_lama"];
		$this->k_id_lama->AdvancedSearch->SearchOperator2 = @$filter["w_k_id_lama"];
		$this->k_id_lama->AdvancedSearch->Save();

		// Field k_no_kontrak
		$this->k_no_kontrak->AdvancedSearch->SearchValue = @$filter["x_k_no_kontrak"];
		$this->k_no_kontrak->AdvancedSearch->SearchOperator = @$filter["z_k_no_kontrak"];
		$this->k_no_kontrak->AdvancedSearch->SearchCondition = @$filter["v_k_no_kontrak"];
		$this->k_no_kontrak->AdvancedSearch->SearchValue2 = @$filter["y_k_no_kontrak"];
		$this->k_no_kontrak->AdvancedSearch->SearchOperator2 = @$filter["w_k_no_kontrak"];
		$this->k_no_kontrak->AdvancedSearch->Save();

		// Field k_luas_lahan
		$this->k_luas_lahan->AdvancedSearch->SearchValue = @$filter["x_k_luas_lahan"];
		$this->k_luas_lahan->AdvancedSearch->SearchOperator = @$filter["z_k_luas_lahan"];
		$this->k_luas_lahan->AdvancedSearch->SearchCondition = @$filter["v_k_luas_lahan"];
		$this->k_luas_lahan->AdvancedSearch->SearchValue2 = @$filter["y_k_luas_lahan"];
		$this->k_luas_lahan->AdvancedSearch->SearchOperator2 = @$filter["w_k_luas_lahan"];
		$this->k_luas_lahan->AdvancedSearch->Save();

		// Field pet_id
		$this->pet_id->AdvancedSearch->SearchValue = @$filter["x_pet_id"];
		$this->pet_id->AdvancedSearch->SearchOperator = @$filter["z_pet_id"];
		$this->pet_id->AdvancedSearch->SearchCondition = @$filter["v_pet_id"];
		$this->pet_id->AdvancedSearch->SearchValue2 = @$filter["y_pet_id"];
		$this->pet_id->AdvancedSearch->SearchOperator2 = @$filter["w_pet_id"];
		$this->pet_id->AdvancedSearch->Save();

		// Field koord_id
		$this->koord_id->AdvancedSearch->SearchValue = @$filter["x_koord_id"];
		$this->koord_id->AdvancedSearch->SearchOperator = @$filter["z_koord_id"];
		$this->koord_id->AdvancedSearch->SearchCondition = @$filter["v_koord_id"];
		$this->koord_id->AdvancedSearch->SearchValue2 = @$filter["y_koord_id"];
		$this->koord_id->AdvancedSearch->SearchOperator2 = @$filter["w_koord_id"];
		$this->koord_id->AdvancedSearch->Save();

		// Field kk_id
		$this->kk_id->AdvancedSearch->SearchValue = @$filter["x_kk_id"];
		$this->kk_id->AdvancedSearch->SearchOperator = @$filter["z_kk_id"];
		$this->kk_id->AdvancedSearch->SearchCondition = @$filter["v_kk_id"];
		$this->kk_id->AdvancedSearch->SearchValue2 = @$filter["y_kk_id"];
		$this->kk_id->AdvancedSearch->SearchOperator2 = @$filter["w_kk_id"];
		$this->kk_id->AdvancedSearch->Save();

		// Field prov_id
		$this->prov_id->AdvancedSearch->SearchValue = @$filter["x_prov_id"];
		$this->prov_id->AdvancedSearch->SearchOperator = @$filter["z_prov_id"];
		$this->prov_id->AdvancedSearch->SearchCondition = @$filter["v_prov_id"];
		$this->prov_id->AdvancedSearch->SearchValue2 = @$filter["y_prov_id"];
		$this->prov_id->AdvancedSearch->SearchOperator2 = @$filter["w_prov_id"];
		$this->prov_id->AdvancedSearch->Save();

		// Field kab_id
		$this->kab_id->AdvancedSearch->SearchValue = @$filter["x_kab_id"];
		$this->kab_id->AdvancedSearch->SearchOperator = @$filter["z_kab_id"];
		$this->kab_id->AdvancedSearch->SearchCondition = @$filter["v_kab_id"];
		$this->kab_id->AdvancedSearch->SearchValue2 = @$filter["y_kab_id"];
		$this->kab_id->AdvancedSearch->SearchOperator2 = @$filter["w_kab_id"];
		$this->kab_id->AdvancedSearch->Save();

		// Field kec_id
		$this->kec_id->AdvancedSearch->SearchValue = @$filter["x_kec_id"];
		$this->kec_id->AdvancedSearch->SearchOperator = @$filter["z_kec_id"];
		$this->kec_id->AdvancedSearch->SearchCondition = @$filter["v_kec_id"];
		$this->kec_id->AdvancedSearch->SearchValue2 = @$filter["y_kec_id"];
		$this->kec_id->AdvancedSearch->SearchOperator2 = @$filter["w_kec_id"];
		$this->kec_id->AdvancedSearch->Save();

		// Field desa_id
		$this->desa_id->AdvancedSearch->SearchValue = @$filter["x_desa_id"];
		$this->desa_id->AdvancedSearch->SearchOperator = @$filter["z_desa_id"];
		$this->desa_id->AdvancedSearch->SearchCondition = @$filter["v_desa_id"];
		$this->desa_id->AdvancedSearch->SearchValue2 = @$filter["y_desa_id"];
		$this->desa_id->AdvancedSearch->SearchOperator2 = @$filter["w_desa_id"];
		$this->desa_id->AdvancedSearch->Save();

		// Field blok_id
		$this->blok_id->AdvancedSearch->SearchValue = @$filter["x_blok_id"];
		$this->blok_id->AdvancedSearch->SearchOperator = @$filter["z_blok_id"];
		$this->blok_id->AdvancedSearch->SearchCondition = @$filter["v_blok_id"];
		$this->blok_id->AdvancedSearch->SearchValue2 = @$filter["y_blok_id"];
		$this->blok_id->AdvancedSearch->SearchOperator2 = @$filter["w_blok_id"];
		$this->blok_id->AdvancedSearch->Save();

		// Field sos_id
		$this->sos_id->AdvancedSearch->SearchValue = @$filter["x_sos_id"];
		$this->sos_id->AdvancedSearch->SearchOperator = @$filter["z_sos_id"];
		$this->sos_id->AdvancedSearch->SearchCondition = @$filter["v_sos_id"];
		$this->sos_id->AdvancedSearch->SearchValue2 = @$filter["y_sos_id"];
		$this->sos_id->AdvancedSearch->SearchOperator2 = @$filter["w_sos_id"];
		$this->sos_id->AdvancedSearch->Save();

		// Field var_id
		$this->var_id->AdvancedSearch->SearchValue = @$filter["x_var_id"];
		$this->var_id->AdvancedSearch->SearchOperator = @$filter["z_var_id"];
		$this->var_id->AdvancedSearch->SearchCondition = @$filter["v_var_id"];
		$this->var_id->AdvancedSearch->SearchValue2 = @$filter["y_var_id"];
		$this->var_id->AdvancedSearch->SearchOperator2 = @$filter["w_var_id"];
		$this->var_id->AdvancedSearch->Save();

		// Field co_id
		$this->co_id->AdvancedSearch->SearchValue = @$filter["x_co_id"];
		$this->co_id->AdvancedSearch->SearchOperator = @$filter["z_co_id"];
		$this->co_id->AdvancedSearch->SearchCondition = @$filter["v_co_id"];
		$this->co_id->AdvancedSearch->SearchValue2 = @$filter["y_co_id"];
		$this->co_id->AdvancedSearch->SearchOperator2 = @$filter["w_co_id"];
		$this->co_id->AdvancedSearch->Save();

		// Field k_jumlah_bibit
		$this->k_jumlah_bibit->AdvancedSearch->SearchValue = @$filter["x_k_jumlah_bibit"];
		$this->k_jumlah_bibit->AdvancedSearch->SearchOperator = @$filter["z_k_jumlah_bibit"];
		$this->k_jumlah_bibit->AdvancedSearch->SearchCondition = @$filter["v_k_jumlah_bibit"];
		$this->k_jumlah_bibit->AdvancedSearch->SearchValue2 = @$filter["y_k_jumlah_bibit"];
		$this->k_jumlah_bibit->AdvancedSearch->SearchOperator2 = @$filter["w_k_jumlah_bibit"];
		$this->k_jumlah_bibit->AdvancedSearch->Save();

		// Field k_asal_bibit
		$this->k_asal_bibit->AdvancedSearch->SearchValue = @$filter["x_k_asal_bibit"];
		$this->k_asal_bibit->AdvancedSearch->SearchOperator = @$filter["z_k_asal_bibit"];
		$this->k_asal_bibit->AdvancedSearch->SearchCondition = @$filter["v_k_asal_bibit"];
		$this->k_asal_bibit->AdvancedSearch->SearchValue2 = @$filter["y_k_asal_bibit"];
		$this->k_asal_bibit->AdvancedSearch->SearchOperator2 = @$filter["w_k_asal_bibit"];
		$this->k_asal_bibit->AdvancedSearch->Save();

		// Field k_tgl_tanam
		$this->k_tgl_tanam->AdvancedSearch->SearchValue = @$filter["x_k_tgl_tanam"];
		$this->k_tgl_tanam->AdvancedSearch->SearchOperator = @$filter["z_k_tgl_tanam"];
		$this->k_tgl_tanam->AdvancedSearch->SearchCondition = @$filter["v_k_tgl_tanam"];
		$this->k_tgl_tanam->AdvancedSearch->SearchValue2 = @$filter["y_k_tgl_tanam"];
		$this->k_tgl_tanam->AdvancedSearch->SearchOperator2 = @$filter["w_k_tgl_tanam"];
		$this->k_tgl_tanam->AdvancedSearch->Save();

		// Field k_es_tgl_panen
		$this->k_es_tgl_panen->AdvancedSearch->SearchValue = @$filter["x_k_es_tgl_panen"];
		$this->k_es_tgl_panen->AdvancedSearch->SearchOperator = @$filter["z_k_es_tgl_panen"];
		$this->k_es_tgl_panen->AdvancedSearch->SearchCondition = @$filter["v_k_es_tgl_panen"];
		$this->k_es_tgl_panen->AdvancedSearch->SearchValue2 = @$filter["y_k_es_tgl_panen"];
		$this->k_es_tgl_panen->AdvancedSearch->SearchOperator2 = @$filter["w_k_es_tgl_panen"];
		$this->k_es_tgl_panen->AdvancedSearch->Save();

		// Field k_ak_tgl_datang
		$this->k_ak_tgl_datang->AdvancedSearch->SearchValue = @$filter["x_k_ak_tgl_datang"];
		$this->k_ak_tgl_datang->AdvancedSearch->SearchOperator = @$filter["z_k_ak_tgl_datang"];
		$this->k_ak_tgl_datang->AdvancedSearch->SearchCondition = @$filter["v_k_ak_tgl_datang"];
		$this->k_ak_tgl_datang->AdvancedSearch->SearchValue2 = @$filter["y_k_ak_tgl_datang"];
		$this->k_ak_tgl_datang->AdvancedSearch->SearchOperator2 = @$filter["w_k_ak_tgl_datang"];
		$this->k_ak_tgl_datang->AdvancedSearch->Save();

		// Field k_es_qty
		$this->k_es_qty->AdvancedSearch->SearchValue = @$filter["x_k_es_qty"];
		$this->k_es_qty->AdvancedSearch->SearchOperator = @$filter["z_k_es_qty"];
		$this->k_es_qty->AdvancedSearch->SearchCondition = @$filter["v_k_es_qty"];
		$this->k_es_qty->AdvancedSearch->SearchValue2 = @$filter["y_k_es_qty"];
		$this->k_es_qty->AdvancedSearch->SearchOperator2 = @$filter["w_k_es_qty"];
		$this->k_es_qty->AdvancedSearch->Save();

		// Field k_ak_qty
		$this->k_ak_qty->AdvancedSearch->SearchValue = @$filter["x_k_ak_qty"];
		$this->k_ak_qty->AdvancedSearch->SearchOperator = @$filter["z_k_ak_qty"];
		$this->k_ak_qty->AdvancedSearch->SearchCondition = @$filter["v_k_ak_qty"];
		$this->k_ak_qty->AdvancedSearch->SearchValue2 = @$filter["y_k_ak_qty"];
		$this->k_ak_qty->AdvancedSearch->SearchOperator2 = @$filter["w_k_ak_qty"];
		$this->k_ak_qty->AdvancedSearch->Save();

		// Field k_es_perhektar
		$this->k_es_perhektar->AdvancedSearch->SearchValue = @$filter["x_k_es_perhektar"];
		$this->k_es_perhektar->AdvancedSearch->SearchOperator = @$filter["z_k_es_perhektar"];
		$this->k_es_perhektar->AdvancedSearch->SearchCondition = @$filter["v_k_es_perhektar"];
		$this->k_es_perhektar->AdvancedSearch->SearchValue2 = @$filter["y_k_es_perhektar"];
		$this->k_es_perhektar->AdvancedSearch->SearchOperator2 = @$filter["w_k_es_perhektar"];
		$this->k_es_perhektar->AdvancedSearch->Save();

		// Field k_ak_perhektar
		$this->k_ak_perhektar->AdvancedSearch->SearchValue = @$filter["x_k_ak_perhektar"];
		$this->k_ak_perhektar->AdvancedSearch->SearchOperator = @$filter["z_k_ak_perhektar"];
		$this->k_ak_perhektar->AdvancedSearch->SearchCondition = @$filter["v_k_ak_perhektar"];
		$this->k_ak_perhektar->AdvancedSearch->SearchValue2 = @$filter["y_k_ak_perhektar"];
		$this->k_ak_perhektar->AdvancedSearch->SearchOperator2 = @$filter["w_k_ak_perhektar"];
		$this->k_ak_perhektar->AdvancedSearch->Save();

		// Field k_skor
		$this->k_skor->AdvancedSearch->SearchValue = @$filter["x_k_skor"];
		$this->k_skor->AdvancedSearch->SearchOperator = @$filter["z_k_skor"];
		$this->k_skor->AdvancedSearch->SearchCondition = @$filter["v_k_skor"];
		$this->k_skor->AdvancedSearch->SearchValue2 = @$filter["y_k_skor"];
		$this->k_skor->AdvancedSearch->SearchOperator2 = @$filter["w_k_skor"];
		$this->k_skor->AdvancedSearch->Save();

		// Field k_ket
		$this->k_ket->AdvancedSearch->SearchValue = @$filter["x_k_ket"];
		$this->k_ket->AdvancedSearch->SearchOperator = @$filter["z_k_ket"];
		$this->k_ket->AdvancedSearch->SearchCondition = @$filter["v_k_ket"];
		$this->k_ket->AdvancedSearch->SearchValue2 = @$filter["y_k_ket"];
		$this->k_ket->AdvancedSearch->SearchOperator2 = @$filter["w_k_ket"];
		$this->k_ket->AdvancedSearch->Save();

		// Field k_cat
		$this->k_cat->AdvancedSearch->SearchValue = @$filter["x_k_cat"];
		$this->k_cat->AdvancedSearch->SearchOperator = @$filter["z_k_cat"];
		$this->k_cat->AdvancedSearch->SearchCondition = @$filter["v_k_cat"];
		$this->k_cat->AdvancedSearch->SearchValue2 = @$filter["y_k_cat"];
		$this->k_cat->AdvancedSearch->SearchOperator2 = @$filter["w_k_cat"];
		$this->k_cat->AdvancedSearch->Save();

		// Field k_titik_koordinat
		$this->k_titik_koordinat->AdvancedSearch->SearchValue = @$filter["x_k_titik_koordinat"];
		$this->k_titik_koordinat->AdvancedSearch->SearchOperator = @$filter["z_k_titik_koordinat"];
		$this->k_titik_koordinat->AdvancedSearch->SearchCondition = @$filter["v_k_titik_koordinat"];
		$this->k_titik_koordinat->AdvancedSearch->SearchValue2 = @$filter["y_k_titik_koordinat"];
		$this->k_titik_koordinat->AdvancedSearch->SearchOperator2 = @$filter["w_k_titik_koordinat"];
		$this->k_titik_koordinat->AdvancedSearch->Save();

		// Field k_foto_lahan
		$this->k_foto_lahan->AdvancedSearch->SearchValue = @$filter["x_k_foto_lahan"];
		$this->k_foto_lahan->AdvancedSearch->SearchOperator = @$filter["z_k_foto_lahan"];
		$this->k_foto_lahan->AdvancedSearch->SearchCondition = @$filter["v_k_foto_lahan"];
		$this->k_foto_lahan->AdvancedSearch->SearchValue2 = @$filter["y_k_foto_lahan"];
		$this->k_foto_lahan->AdvancedSearch->SearchOperator2 = @$filter["w_k_foto_lahan"];
		$this->k_foto_lahan->AdvancedSearch->Save();

		// Field k_dok
		$this->k_dok->AdvancedSearch->SearchValue = @$filter["x_k_dok"];
		$this->k_dok->AdvancedSearch->SearchOperator = @$filter["z_k_dok"];
		$this->k_dok->AdvancedSearch->SearchCondition = @$filter["v_k_dok"];
		$this->k_dok->AdvancedSearch->SearchValue2 = @$filter["y_k_dok"];
		$this->k_dok->AdvancedSearch->SearchOperator2 = @$filter["w_k_dok"];
		$this->k_dok->AdvancedSearch->Save();

		// Field k_harga_bibit
		$this->k_harga_bibit->AdvancedSearch->SearchValue = @$filter["x_k_harga_bibit"];
		$this->k_harga_bibit->AdvancedSearch->SearchOperator = @$filter["z_k_harga_bibit"];
		$this->k_harga_bibit->AdvancedSearch->SearchCondition = @$filter["v_k_harga_bibit"];
		$this->k_harga_bibit->AdvancedSearch->SearchValue2 = @$filter["y_k_harga_bibit"];
		$this->k_harga_bibit->AdvancedSearch->SearchOperator2 = @$filter["w_k_harga_bibit"];
		$this->k_harga_bibit->AdvancedSearch->Save();

		// Field k_bayar_bibit
		$this->k_bayar_bibit->AdvancedSearch->SearchValue = @$filter["x_k_bayar_bibit"];
		$this->k_bayar_bibit->AdvancedSearch->SearchOperator = @$filter["z_k_bayar_bibit"];
		$this->k_bayar_bibit->AdvancedSearch->SearchCondition = @$filter["v_k_bayar_bibit"];
		$this->k_bayar_bibit->AdvancedSearch->SearchValue2 = @$filter["y_k_bayar_bibit"];
		$this->k_bayar_bibit->AdvancedSearch->SearchOperator2 = @$filter["w_k_bayar_bibit"];
		$this->k_bayar_bibit->AdvancedSearch->Save();

		// Field k_pinjaman
		$this->k_pinjaman->AdvancedSearch->SearchValue = @$filter["x_k_pinjaman"];
		$this->k_pinjaman->AdvancedSearch->SearchOperator = @$filter["z_k_pinjaman"];
		$this->k_pinjaman->AdvancedSearch->SearchCondition = @$filter["v_k_pinjaman"];
		$this->k_pinjaman->AdvancedSearch->SearchValue2 = @$filter["y_k_pinjaman"];
		$this->k_pinjaman->AdvancedSearch->SearchOperator2 = @$filter["w_k_pinjaman"];
		$this->k_pinjaman->AdvancedSearch->Save();

		// Field k_bayar_pinjaman
		$this->k_bayar_pinjaman->AdvancedSearch->SearchValue = @$filter["x_k_bayar_pinjaman"];
		$this->k_bayar_pinjaman->AdvancedSearch->SearchOperator = @$filter["z_k_bayar_pinjaman"];
		$this->k_bayar_pinjaman->AdvancedSearch->SearchCondition = @$filter["v_k_bayar_pinjaman"];
		$this->k_bayar_pinjaman->AdvancedSearch->SearchValue2 = @$filter["y_k_bayar_pinjaman"];
		$this->k_bayar_pinjaman->AdvancedSearch->SearchOperator2 = @$filter["w_k_bayar_pinjaman"];
		$this->k_bayar_pinjaman->AdvancedSearch->Save();

		// Field k_sisa_hutang
		$this->k_sisa_hutang->AdvancedSearch->SearchValue = @$filter["x_k_sisa_hutang"];
		$this->k_sisa_hutang->AdvancedSearch->SearchOperator = @$filter["z_k_sisa_hutang"];
		$this->k_sisa_hutang->AdvancedSearch->SearchCondition = @$filter["v_k_sisa_hutang"];
		$this->k_sisa_hutang->AdvancedSearch->SearchValue2 = @$filter["y_k_sisa_hutang"];
		$this->k_sisa_hutang->AdvancedSearch->SearchOperator2 = @$filter["w_k_sisa_hutang"];
		$this->k_sisa_hutang->AdvancedSearch->Save();
		$this->BasicSearch->setKeyword(@$filter[EW_TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[EW_TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	function AdvancedSearchWhere($Default = FALSE) {
		global $Security;
		$sWhere = "";
		if (!$Security->CanSearch()) return "";
		$this->BuildSearchSql($sWhere, $this->k_id, $Default, FALSE); // k_id
		$this->BuildSearchSql($sWhere, $this->k_id_kontrak, $Default, FALSE); // k_id_kontrak
		$this->BuildSearchSql($sWhere, $this->k_id_lama, $Default, FALSE); // k_id_lama
		$this->BuildSearchSql($sWhere, $this->k_no_kontrak, $Default, FALSE); // k_no_kontrak
		$this->BuildSearchSql($sWhere, $this->k_luas_lahan, $Default, FALSE); // k_luas_lahan
		$this->BuildSearchSql($sWhere, $this->pet_id, $Default, FALSE); // pet_id
		$this->BuildSearchSql($sWhere, $this->koord_id, $Default, FALSE); // koord_id
		$this->BuildSearchSql($sWhere, $this->kk_id, $Default, FALSE); // kk_id
		$this->BuildSearchSql($sWhere, $this->prov_id, $Default, FALSE); // prov_id
		$this->BuildSearchSql($sWhere, $this->kab_id, $Default, FALSE); // kab_id
		$this->BuildSearchSql($sWhere, $this->kec_id, $Default, FALSE); // kec_id
		$this->BuildSearchSql($sWhere, $this->desa_id, $Default, FALSE); // desa_id
		$this->BuildSearchSql($sWhere, $this->blok_id, $Default, FALSE); // blok_id
		$this->BuildSearchSql($sWhere, $this->sos_id, $Default, FALSE); // sos_id
		$this->BuildSearchSql($sWhere, $this->var_id, $Default, FALSE); // var_id
		$this->BuildSearchSql($sWhere, $this->co_id, $Default, FALSE); // co_id
		$this->BuildSearchSql($sWhere, $this->k_jumlah_bibit, $Default, FALSE); // k_jumlah_bibit
		$this->BuildSearchSql($sWhere, $this->k_asal_bibit, $Default, FALSE); // k_asal_bibit
		$this->BuildSearchSql($sWhere, $this->k_tgl_tanam, $Default, FALSE); // k_tgl_tanam
		$this->BuildSearchSql($sWhere, $this->k_es_tgl_panen, $Default, FALSE); // k_es_tgl_panen
		$this->BuildSearchSql($sWhere, $this->k_ak_tgl_datang, $Default, FALSE); // k_ak_tgl_datang
		$this->BuildSearchSql($sWhere, $this->k_es_qty, $Default, FALSE); // k_es_qty
		$this->BuildSearchSql($sWhere, $this->k_ak_qty, $Default, FALSE); // k_ak_qty
		$this->BuildSearchSql($sWhere, $this->k_es_perhektar, $Default, FALSE); // k_es_perhektar
		$this->BuildSearchSql($sWhere, $this->k_ak_perhektar, $Default, FALSE); // k_ak_perhektar
		$this->BuildSearchSql($sWhere, $this->k_skor, $Default, FALSE); // k_skor
		$this->BuildSearchSql($sWhere, $this->k_ket, $Default, FALSE); // k_ket
		$this->BuildSearchSql($sWhere, $this->k_cat, $Default, FALSE); // k_cat
		$this->BuildSearchSql($sWhere, $this->k_titik_koordinat, $Default, FALSE); // k_titik_koordinat
		$this->BuildSearchSql($sWhere, $this->k_foto_lahan, $Default, FALSE); // k_foto_lahan
		$this->BuildSearchSql($sWhere, $this->k_dok, $Default, FALSE); // k_dok
		$this->BuildSearchSql($sWhere, $this->k_harga_bibit, $Default, FALSE); // k_harga_bibit
		$this->BuildSearchSql($sWhere, $this->k_bayar_bibit, $Default, FALSE); // k_bayar_bibit
		$this->BuildSearchSql($sWhere, $this->k_pinjaman, $Default, FALSE); // k_pinjaman
		$this->BuildSearchSql($sWhere, $this->k_bayar_pinjaman, $Default, FALSE); // k_bayar_pinjaman
		$this->BuildSearchSql($sWhere, $this->k_sisa_hutang, $Default, FALSE); // k_sisa_hutang

		// Set up search parm
		if (!$Default && $sWhere <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$Default && $this->Command == "search") {
			$this->k_id->AdvancedSearch->Save(); // k_id
			$this->k_id_kontrak->AdvancedSearch->Save(); // k_id_kontrak
			$this->k_id_lama->AdvancedSearch->Save(); // k_id_lama
			$this->k_no_kontrak->AdvancedSearch->Save(); // k_no_kontrak
			$this->k_luas_lahan->AdvancedSearch->Save(); // k_luas_lahan
			$this->pet_id->AdvancedSearch->Save(); // pet_id
			$this->koord_id->AdvancedSearch->Save(); // koord_id
			$this->kk_id->AdvancedSearch->Save(); // kk_id
			$this->prov_id->AdvancedSearch->Save(); // prov_id
			$this->kab_id->AdvancedSearch->Save(); // kab_id
			$this->kec_id->AdvancedSearch->Save(); // kec_id
			$this->desa_id->AdvancedSearch->Save(); // desa_id
			$this->blok_id->AdvancedSearch->Save(); // blok_id
			$this->sos_id->AdvancedSearch->Save(); // sos_id
			$this->var_id->AdvancedSearch->Save(); // var_id
			$this->co_id->AdvancedSearch->Save(); // co_id
			$this->k_jumlah_bibit->AdvancedSearch->Save(); // k_jumlah_bibit
			$this->k_asal_bibit->AdvancedSearch->Save(); // k_asal_bibit
			$this->k_tgl_tanam->AdvancedSearch->Save(); // k_tgl_tanam
			$this->k_es_tgl_panen->AdvancedSearch->Save(); // k_es_tgl_panen
			$this->k_ak_tgl_datang->AdvancedSearch->Save(); // k_ak_tgl_datang
			$this->k_es_qty->AdvancedSearch->Save(); // k_es_qty
			$this->k_ak_qty->AdvancedSearch->Save(); // k_ak_qty
			$this->k_es_perhektar->AdvancedSearch->Save(); // k_es_perhektar
			$this->k_ak_perhektar->AdvancedSearch->Save(); // k_ak_perhektar
			$this->k_skor->AdvancedSearch->Save(); // k_skor
			$this->k_ket->AdvancedSearch->Save(); // k_ket
			$this->k_cat->AdvancedSearch->Save(); // k_cat
			$this->k_titik_koordinat->AdvancedSearch->Save(); // k_titik_koordinat
			$this->k_foto_lahan->AdvancedSearch->Save(); // k_foto_lahan
			$this->k_dok->AdvancedSearch->Save(); // k_dok
			$this->k_harga_bibit->AdvancedSearch->Save(); // k_harga_bibit
			$this->k_bayar_bibit->AdvancedSearch->Save(); // k_bayar_bibit
			$this->k_pinjaman->AdvancedSearch->Save(); // k_pinjaman
			$this->k_bayar_pinjaman->AdvancedSearch->Save(); // k_bayar_pinjaman
			$this->k_sisa_hutang->AdvancedSearch->Save(); // k_sisa_hutang
		}
		return $sWhere;
	}

	// Build search SQL
	function BuildSearchSql(&$Where, &$Fld, $Default, $MultiValue) {
		$FldParm = $Fld->FldParm();
		$FldVal = ($Default) ? $Fld->AdvancedSearch->SearchValueDefault : $Fld->AdvancedSearch->SearchValue; // @$_GET["x_$FldParm"]
		$FldOpr = ($Default) ? $Fld->AdvancedSearch->SearchOperatorDefault : $Fld->AdvancedSearch->SearchOperator; // @$_GET["z_$FldParm"]
		$FldCond = ($Default) ? $Fld->AdvancedSearch->SearchConditionDefault : $Fld->AdvancedSearch->SearchCondition; // @$_GET["v_$FldParm"]
		$FldVal2 = ($Default) ? $Fld->AdvancedSearch->SearchValue2Default : $Fld->AdvancedSearch->SearchValue2; // @$_GET["y_$FldParm"]
		$FldOpr2 = ($Default) ? $Fld->AdvancedSearch->SearchOperator2Default : $Fld->AdvancedSearch->SearchOperator2; // @$_GET["w_$FldParm"]
		$sWrk = "";
		if (is_array($FldVal)) $FldVal = implode(",", $FldVal);
		if (is_array($FldVal2)) $FldVal2 = implode(",", $FldVal2);
		$FldOpr = strtoupper(trim($FldOpr));
		if ($FldOpr == "") $FldOpr = "=";
		$FldOpr2 = strtoupper(trim($FldOpr2));
		if ($FldOpr2 == "") $FldOpr2 = "=";
		if (EW_SEARCH_MULTI_VALUE_OPTION == 1)
			$MultiValue = FALSE;
		if ($MultiValue) {
			$sWrk1 = ($FldVal <> "") ? ew_GetMultiSearchSql($Fld, $FldOpr, $FldVal, $this->DBID) : ""; // Field value 1
			$sWrk2 = ($FldVal2 <> "") ? ew_GetMultiSearchSql($Fld, $FldOpr2, $FldVal2, $this->DBID) : ""; // Field value 2
			$sWrk = $sWrk1; // Build final SQL
			if ($sWrk2 <> "")
				$sWrk = ($sWrk <> "") ? "($sWrk) $FldCond ($sWrk2)" : $sWrk2;
		} else {
			$FldVal = $this->ConvertSearchValue($Fld, $FldVal);
			$FldVal2 = $this->ConvertSearchValue($Fld, $FldVal2);
			$sWrk = ew_GetSearchSql($Fld, $FldVal, $FldOpr, $FldCond, $FldVal2, $FldOpr2, $this->DBID);
		}
		ew_AddFilter($Where, $sWrk);
	}

	// Convert search value
	function ConvertSearchValue(&$Fld, $FldVal) {
		if ($FldVal == EW_NULL_VALUE || $FldVal == EW_NOT_NULL_VALUE)
			return $FldVal;
		$Value = $FldVal;
		if ($Fld->FldDataType == EW_DATATYPE_BOOLEAN) {
			if ($FldVal <> "") $Value = ($FldVal == "1" || strtolower(strval($FldVal)) == "y" || strtolower(strval($FldVal)) == "t") ? $Fld->TrueValue : $Fld->FalseValue;
		} elseif ($Fld->FldDataType == EW_DATATYPE_DATE || $Fld->FldDataType == EW_DATATYPE_TIME) {
			if ($FldVal <> "") $Value = ew_UnFormatDateTime($FldVal, $Fld->FldDateTimeFormat);
		}
		return $Value;
	}

	// Return basic search SQL
	function BasicSearchSQL($arKeywords, $type) {
		$sWhere = "";
		$this->BuildBasicSearchSQL($sWhere, $this->k_id_kontrak, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->k_id_lama, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->k_no_kontrak, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->k_luas_lahan, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->pet_id, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->koord_id, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->kk_id, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->prov_id, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->kab_id, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->kec_id, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->desa_id, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->blok_id, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->var_id, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->co_id, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->k_jumlah_bibit, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->k_asal_bibit, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->k_tgl_tanam, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->k_es_tgl_panen, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->k_ak_tgl_datang, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->k_es_qty, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->k_ak_qty, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->k_es_perhektar, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->k_ak_perhektar, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->k_skor, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->k_ket, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->k_cat, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->k_titik_koordinat, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->k_foto_lahan, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->k_dok, $arKeywords, $type);
		return $sWhere;
	}

	// Build basic search SQL
	function BuildBasicSearchSQL(&$Where, &$Fld, $arKeywords, $type) {
		global $EW_BASIC_SEARCH_IGNORE_PATTERN;
		$sDefCond = ($type == "OR") ? "OR" : "AND";
		$arSQL = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$Keyword = $arKeywords[$i];
			$Keyword = trim($Keyword);
			if ($EW_BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$Keyword = preg_replace($EW_BASIC_SEARCH_IGNORE_PATTERN, "\\", $Keyword);
				$ar = explode("\\", $Keyword);
			} else {
				$ar = array($Keyword);
			}
			foreach ($ar as $Keyword) {
				if ($Keyword <> "") {
					$sWrk = "";
					if ($Keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j-1] = "OR";
					} elseif ($Keyword == EW_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NULL";
					} elseif ($Keyword == EW_NOT_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NOT NULL";
					} elseif ($Fld->FldIsVirtual) {
						$sWrk = $Fld->FldVirtualExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					} elseif ($Fld->FldDataType != EW_DATATYPE_NUMBER || is_numeric($Keyword)) {
						$sWrk = $Fld->FldBasicSearchExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					}
					if ($sWrk <> "") {
						$arSQL[$j] = $sWrk;
						$arCond[$j] = $sDefCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSQL);
		$bQuoted = FALSE;
		$sSql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt-1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$bQuoted) $sSql .= "(";
					$bQuoted = TRUE;
				}
				$sSql .= $arSQL[$i];
				if ($bQuoted && $arCond[$i] <> "OR") {
					$sSql .= ")";
					$bQuoted = FALSE;
				}
				$sSql .= " " . $arCond[$i] . " ";
			}
			$sSql .= $arSQL[$cnt-1];
			if ($bQuoted)
				$sSql .= ")";
		}
		if ($sSql <> "") {
			if ($Where <> "") $Where .= " OR ";
			$Where .= "(" . $sSql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	function BasicSearchWhere($Default = FALSE) {
		global $Security;
		$sSearchStr = "";
		if (!$Security->CanSearch()) return "";
		$sSearchKeyword = ($Default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$sSearchType = ($Default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($sSearchKeyword <> "") {
			$ar = $this->BasicSearch->KeywordList($Default);

			// Search keyword in any fields
			if (($sSearchType == "OR" || $sSearchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $sKeyword) {
					if ($sKeyword <> "") {
						if ($sSearchStr <> "") $sSearchStr .= " " . $sSearchType . " ";
						$sSearchStr .= "(" . $this->BasicSearchSQL(array($sKeyword), $sSearchType) . ")";
					}
				}
			} else {
				$sSearchStr = $this->BasicSearchSQL($ar, $sSearchType);
			}
			if (!$Default && in_array($this->Command, array("", "reset", "resetall"))) $this->Command = "search";
		}
		if (!$Default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($sSearchKeyword);
			$this->BasicSearch->setType($sSearchType);
		}
		return $sSearchStr;
	}

	// Check if search parm exists
	function CheckSearchParms() {

		// Check basic search
		if ($this->BasicSearch->IssetSession())
			return TRUE;
		if ($this->k_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->k_id_kontrak->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->k_id_lama->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->k_no_kontrak->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->k_luas_lahan->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->pet_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->koord_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->kk_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->prov_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->kab_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->kec_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->desa_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->blok_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->sos_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->var_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->co_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->k_jumlah_bibit->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->k_asal_bibit->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->k_tgl_tanam->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->k_es_tgl_panen->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->k_ak_tgl_datang->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->k_es_qty->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->k_ak_qty->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->k_es_perhektar->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->k_ak_perhektar->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->k_skor->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->k_ket->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->k_cat->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->k_titik_koordinat->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->k_foto_lahan->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->k_dok->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->k_harga_bibit->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->k_bayar_bibit->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->k_pinjaman->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->k_bayar_pinjaman->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->k_sisa_hutang->AdvancedSearch->IssetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	function ResetSearchParms() {

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->ResetBasicSearchParms();

		// Clear advanced search parameters
		$this->ResetAdvancedSearchParms();
	}

	// Load advanced search default values
	function LoadAdvancedSearchDefault() {
		return FALSE;
	}

	// Clear all basic search parameters
	function ResetBasicSearchParms() {
		$this->BasicSearch->UnsetSession();
	}

	// Clear all advanced search parameters
	function ResetAdvancedSearchParms() {
		$this->k_id->AdvancedSearch->UnsetSession();
		$this->k_id_kontrak->AdvancedSearch->UnsetSession();
		$this->k_id_lama->AdvancedSearch->UnsetSession();
		$this->k_no_kontrak->AdvancedSearch->UnsetSession();
		$this->k_luas_lahan->AdvancedSearch->UnsetSession();
		$this->pet_id->AdvancedSearch->UnsetSession();
		$this->koord_id->AdvancedSearch->UnsetSession();
		$this->kk_id->AdvancedSearch->UnsetSession();
		$this->prov_id->AdvancedSearch->UnsetSession();
		$this->kab_id->AdvancedSearch->UnsetSession();
		$this->kec_id->AdvancedSearch->UnsetSession();
		$this->desa_id->AdvancedSearch->UnsetSession();
		$this->blok_id->AdvancedSearch->UnsetSession();
		$this->sos_id->AdvancedSearch->UnsetSession();
		$this->var_id->AdvancedSearch->UnsetSession();
		$this->co_id->AdvancedSearch->UnsetSession();
		$this->k_jumlah_bibit->AdvancedSearch->UnsetSession();
		$this->k_asal_bibit->AdvancedSearch->UnsetSession();
		$this->k_tgl_tanam->AdvancedSearch->UnsetSession();
		$this->k_es_tgl_panen->AdvancedSearch->UnsetSession();
		$this->k_ak_tgl_datang->AdvancedSearch->UnsetSession();
		$this->k_es_qty->AdvancedSearch->UnsetSession();
		$this->k_ak_qty->AdvancedSearch->UnsetSession();
		$this->k_es_perhektar->AdvancedSearch->UnsetSession();
		$this->k_ak_perhektar->AdvancedSearch->UnsetSession();
		$this->k_skor->AdvancedSearch->UnsetSession();
		$this->k_ket->AdvancedSearch->UnsetSession();
		$this->k_cat->AdvancedSearch->UnsetSession();
		$this->k_titik_koordinat->AdvancedSearch->UnsetSession();
		$this->k_foto_lahan->AdvancedSearch->UnsetSession();
		$this->k_dok->AdvancedSearch->UnsetSession();
		$this->k_harga_bibit->AdvancedSearch->UnsetSession();
		$this->k_bayar_bibit->AdvancedSearch->UnsetSession();
		$this->k_pinjaman->AdvancedSearch->UnsetSession();
		$this->k_bayar_pinjaman->AdvancedSearch->UnsetSession();
		$this->k_sisa_hutang->AdvancedSearch->UnsetSession();
	}

	// Restore all search parameters
	function RestoreSearchParms() {
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->Load();

		// Restore advanced search values
		$this->k_id->AdvancedSearch->Load();
		$this->k_id_kontrak->AdvancedSearch->Load();
		$this->k_id_lama->AdvancedSearch->Load();
		$this->k_no_kontrak->AdvancedSearch->Load();
		$this->k_luas_lahan->AdvancedSearch->Load();
		$this->pet_id->AdvancedSearch->Load();
		$this->koord_id->AdvancedSearch->Load();
		$this->kk_id->AdvancedSearch->Load();
		$this->prov_id->AdvancedSearch->Load();
		$this->kab_id->AdvancedSearch->Load();
		$this->kec_id->AdvancedSearch->Load();
		$this->desa_id->AdvancedSearch->Load();
		$this->blok_id->AdvancedSearch->Load();
		$this->sos_id->AdvancedSearch->Load();
		$this->var_id->AdvancedSearch->Load();
		$this->co_id->AdvancedSearch->Load();
		$this->k_jumlah_bibit->AdvancedSearch->Load();
		$this->k_asal_bibit->AdvancedSearch->Load();
		$this->k_tgl_tanam->AdvancedSearch->Load();
		$this->k_es_tgl_panen->AdvancedSearch->Load();
		$this->k_ak_tgl_datang->AdvancedSearch->Load();
		$this->k_es_qty->AdvancedSearch->Load();
		$this->k_ak_qty->AdvancedSearch->Load();
		$this->k_es_perhektar->AdvancedSearch->Load();
		$this->k_ak_perhektar->AdvancedSearch->Load();
		$this->k_skor->AdvancedSearch->Load();
		$this->k_ket->AdvancedSearch->Load();
		$this->k_cat->AdvancedSearch->Load();
		$this->k_titik_koordinat->AdvancedSearch->Load();
		$this->k_foto_lahan->AdvancedSearch->Load();
		$this->k_dok->AdvancedSearch->Load();
		$this->k_harga_bibit->AdvancedSearch->Load();
		$this->k_bayar_bibit->AdvancedSearch->Load();
		$this->k_pinjaman->AdvancedSearch->Load();
		$this->k_bayar_pinjaman->AdvancedSearch->Load();
		$this->k_sisa_hutang->AdvancedSearch->Load();
	}

	// Set up sort parameters
	function SetupSortOrder() {

		// Check for "order" parameter
		if (@$_GET["order"] <> "") {
			$this->CurrentOrder = @$_GET["order"];
			$this->CurrentOrderType = @$_GET["ordertype"];
			$this->UpdateSort($this->k_id_kontrak); // k_id_kontrak
			$this->UpdateSort($this->k_id_lama); // k_id_lama
			$this->UpdateSort($this->k_no_kontrak); // k_no_kontrak
			$this->UpdateSort($this->k_luas_lahan); // k_luas_lahan
			$this->UpdateSort($this->pet_id); // pet_id
			$this->UpdateSort($this->koord_id); // koord_id
			$this->UpdateSort($this->kk_id); // kk_id
			$this->UpdateSort($this->prov_id); // prov_id
			$this->UpdateSort($this->kab_id); // kab_id
			$this->UpdateSort($this->kec_id); // kec_id
			$this->UpdateSort($this->desa_id); // desa_id
			$this->UpdateSort($this->blok_id); // blok_id
			$this->UpdateSort($this->sos_id); // sos_id
			$this->UpdateSort($this->var_id); // var_id
			$this->UpdateSort($this->co_id); // co_id
			$this->UpdateSort($this->k_jumlah_bibit); // k_jumlah_bibit
			$this->UpdateSort($this->k_asal_bibit); // k_asal_bibit
			$this->UpdateSort($this->k_tgl_tanam); // k_tgl_tanam
			$this->UpdateSort($this->k_es_tgl_panen); // k_es_tgl_panen
			$this->UpdateSort($this->k_ak_tgl_datang); // k_ak_tgl_datang
			$this->UpdateSort($this->k_es_qty); // k_es_qty
			$this->UpdateSort($this->k_ak_qty); // k_ak_qty
			$this->UpdateSort($this->k_es_perhektar); // k_es_perhektar
			$this->UpdateSort($this->k_ak_perhektar); // k_ak_perhektar
			$this->UpdateSort($this->k_skor); // k_skor
			$this->UpdateSort($this->k_ket); // k_ket
			$this->UpdateSort($this->k_cat); // k_cat
			$this->UpdateSort($this->k_titik_koordinat); // k_titik_koordinat
			$this->UpdateSort($this->k_foto_lahan); // k_foto_lahan
			$this->UpdateSort($this->k_dok); // k_dok
			$this->UpdateSort($this->k_harga_bibit); // k_harga_bibit
			$this->UpdateSort($this->k_bayar_bibit); // k_bayar_bibit
			$this->UpdateSort($this->k_pinjaman); // k_pinjaman
			$this->UpdateSort($this->k_bayar_pinjaman); // k_bayar_pinjaman
			$this->UpdateSort($this->k_sisa_hutang); // k_sisa_hutang
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	function LoadSortOrder() {
		$sOrderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($sOrderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$sOrderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($sOrderBy);
				$this->k_id_kontrak->setSort("DESC");
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)
	function ResetCmd() {

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->ResetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$sOrderBy = "";
				$this->setSessionOrderBy($sOrderBy);
				$this->setSessionOrderByList($sOrderBy);
				$this->k_id_kontrak->setSort("");
				$this->k_id_lama->setSort("");
				$this->k_no_kontrak->setSort("");
				$this->k_luas_lahan->setSort("");
				$this->pet_id->setSort("");
				$this->koord_id->setSort("");
				$this->kk_id->setSort("");
				$this->prov_id->setSort("");
				$this->kab_id->setSort("");
				$this->kec_id->setSort("");
				$this->desa_id->setSort("");
				$this->blok_id->setSort("");
				$this->sos_id->setSort("");
				$this->var_id->setSort("");
				$this->co_id->setSort("");
				$this->k_jumlah_bibit->setSort("");
				$this->k_asal_bibit->setSort("");
				$this->k_tgl_tanam->setSort("");
				$this->k_es_tgl_panen->setSort("");
				$this->k_ak_tgl_datang->setSort("");
				$this->k_es_qty->setSort("");
				$this->k_ak_qty->setSort("");
				$this->k_es_perhektar->setSort("");
				$this->k_ak_perhektar->setSort("");
				$this->k_skor->setSort("");
				$this->k_ket->setSort("");
				$this->k_cat->setSort("");
				$this->k_titik_koordinat->setSort("");
				$this->k_foto_lahan->setSort("");
				$this->k_dok->setSort("");
				$this->k_harga_bibit->setSort("");
				$this->k_bayar_bibit->setSort("");
				$this->k_pinjaman->setSort("");
				$this->k_bayar_pinjaman->setSort("");
				$this->k_sisa_hutang->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	function SetupListOptions() {
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->Add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->Add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->CanView();
		$item->OnLeft = TRUE;

		// "edit"
		$item = &$this->ListOptions->Add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->CanEdit();
		$item->OnLeft = TRUE;

		// "copy"
		$item = &$this->ListOptions->Add("copy");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->CanAdd();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->Add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->Add("checkbox");
		$item->Visible = $Security->CanDelete();
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew_SelectAllKey(this);\">";
		$item->MoveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseImageAndText = TRUE;
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->Phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		if ($this->ListOptions->UseButtonGroup && ew_IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;
		$this->ListOptions->ButtonClass = "btn-sm"; // Class for button group

		// Call ListOptions_Load event
		$this->ListOptions_Load();
		$this->SetupListOptionsExt();
		$item = &$this->ListOptions->GetItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->GroupOptionVisible();
	}

	// Render list options
	function RenderListOptions() {
		global $Security, $Language, $objForm;
		$this->ListOptions->LoadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$oListOpt = &$this->ListOptions->Items["view"];
		$viewcaption = ew_HtmlTitle($Language->Phrase("ViewLink"));
		if ($Security->CanView()) {
			$oListOpt->Body = "<a class=\"ewRowLink ewView\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . ew_HtmlEncode($this->ViewUrl) . "\">" . $Language->Phrase("ViewLink") . "</a>";
		} else {
			$oListOpt->Body = "";
		}

		// "edit"
		$oListOpt = &$this->ListOptions->Items["edit"];
		$editcaption = ew_HtmlTitle($Language->Phrase("EditLink"));
		if ($Security->CanEdit()) {
			$oListOpt->Body = "<a class=\"ewRowLink ewEdit\" title=\"" . ew_HtmlTitle($Language->Phrase("EditLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("EditLink")) . "\" href=\"" . ew_HtmlEncode($this->EditUrl) . "\">" . $Language->Phrase("EditLink") . "</a>";
		} else {
			$oListOpt->Body = "";
		}

		// "copy"
		$oListOpt = &$this->ListOptions->Items["copy"];
		$copycaption = ew_HtmlTitle($Language->Phrase("CopyLink"));
		if ($Security->CanAdd()) {
			$oListOpt->Body = "<a class=\"ewRowLink ewCopy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . ew_HtmlEncode($this->CopyUrl) . "\">" . $Language->Phrase("CopyLink") . "</a>";
		} else {
			$oListOpt->Body = "";
		}

		// Set up list action buttons
		$oListOpt = &$this->ListOptions->GetItem("listactions");
		if ($oListOpt && $this->Export == "" && $this->CurrentAction == "") {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode(str_replace(" ewIcon", "", $listaction->Icon)) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\"></span> " : "";
					$links[] = "<li><a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" title=\"" . ew_HtmlTitle($caption) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $Language->Phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default btn-sm ewActions\" title=\"" . ew_HtmlTitle($Language->Phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->Phrase("ListActionButton") . "<b class=\"caret\"></b></button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($oListOpt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$oListOpt->Body = $body;
				$oListOpt->Visible = TRUE;
			}
		}

		// "checkbox"
		$oListOpt = &$this->ListOptions->Items["checkbox"];
		$oListOpt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ewMultiSelect\" value=\"" . ew_HtmlEncode($this->k_id->CurrentValue) . "\" onclick=\"ew_ClickMultiCheckbox(event);\">";
		$this->RenderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	function SetupOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->Add("add");
		$addcaption = ew_HtmlTitle($Language->Phrase("AddLink"));
		$item->Body = "<a class=\"ewAddEdit ewAdd\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . ew_HtmlEncode($this->AddUrl) . "\">" . $Language->Phrase("AddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->CanAdd());
		$option = $options["action"];

		// Add multi delete
		$item = &$option->Add("multidelete");
		$item->Body = "<a class=\"ewAction ewMultiDelete\" title=\"" . ew_HtmlTitle($Language->Phrase("DeleteSelectedLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("DeleteSelectedLink")) . "\" href=\"\" onclick=\"ew_SubmitAction(event,{f:document.fkontraklist,url:'" . $this->MultiDeleteUrl . "'});return false;\">" . $Language->Phrase("DeleteSelectedLink") . "</a>";
		$item->Visible = ($Security->CanDelete());

		// Set up options default
		foreach ($options as &$option) {
			$option->UseImageAndText = TRUE;
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;
			$option->ButtonClass = "btn-sm"; // Class for button group
			$item = &$option->Add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->Phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->Phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->Phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->Add("savecurrentfilter");
		$item->Body = "<a class=\"ewSaveFilter\" data-form=\"fkontraklistsrch\" href=\"#\">" . $Language->Phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->Add("deletefilter");
		$item->Body = "<a class=\"ewDeleteFilter\" data-form=\"fkontraklistsrch\" href=\"#\">" . $Language->Phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->Phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->Add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	function RenderOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_MULTIPLE) {
					$item = &$option->Add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode($listaction->Icon) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\"></span> " : $caption;
					$item->Body = "<a class=\"ewAction ewListAction\" title=\"" . ew_HtmlEncode($caption) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({f:document.fkontraklist}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->GetItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->HideAllOptions();
			}
	}

	// Process list action
	function ProcessListAction() {
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$sFilter = $this->GetKeyFilter();
		$UserAction = @$_POST["useraction"];
		if ($sFilter <> "" && $UserAction <> "") {

			// Check permission first
			$ActionCaption = $UserAction;
			if (array_key_exists($UserAction, $this->ListActions->Items)) {
				$ActionCaption = $this->ListActions->Items[$UserAction]->Caption;
				if (!$this->ListActions->Items[$UserAction]->Allow) {
					$errmsg = str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionNotAllowed"));
					if (@$_POST["ajax"] == $UserAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $sFilter;
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			$rs = $conn->Execute($sSql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $UserAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->BeginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$Processed = $this->Row_CustomAction($UserAction, $row);
					if (!$Processed) break;
					$rs->MoveNext();
				}
				if ($Processed) {
					$conn->CommitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->RollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->Close();
			$this->CurrentAction = ""; // Clear action
			if (@$_POST["ajax"] == $UserAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->ClearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->ClearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	function SetupSearchOptions() {
		global $Language;
		$this->SearchOptions = new cListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ewSearchOption";

		// Search button
		$item = &$this->SearchOptions->Add("searchtoggle");
		$SearchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ewSearchToggle" . $SearchToggleClass . "\" title=\"" . $Language->Phrase("SearchPanel") . "\" data-caption=\"" . $Language->Phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fkontraklistsrch\">" . $Language->Phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->Add("showall");
		$item->Body = "<a class=\"btn btn-default ewShowAll\" title=\"" . $Language->Phrase("ShowAll") . "\" data-caption=\"" . $Language->Phrase("ShowAll") . "\" href=\"" . $this->PageUrl() . "cmd=reset\">" . $Language->Phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseImageAndText = TRUE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->Phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->Add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->Export <> "" || $this->CurrentAction <> "")
			$this->SearchOptions->HideAllOptions();
		global $Security;
		if (!$Security->CanSearch()) {
			$this->SearchOptions->HideAllOptions();
			$this->FilterOptions->HideAllOptions();
		}
	}

	function SetupListOptionsExt() {
		global $Security, $Language;
	}

	function RenderListOptionsExt() {
		global $Security, $Language;
	}

	// Set up starting record parameters
	function SetupStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	function LoadBasicSearchValues() {
		$this->BasicSearch->Keyword = @$_GET[EW_TABLE_BASIC_SEARCH];
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "") $this->Command = "search";
		$this->BasicSearch->Type = @$_GET[EW_TABLE_BASIC_SEARCH_TYPE];
	}

	// Load search values for validation
	function LoadSearchValues() {
		global $objForm;

		// Load search values
		// k_id

		$this->k_id->AdvancedSearch->SearchValue = @$_GET["x_k_id"];
		if ($this->k_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->k_id->AdvancedSearch->SearchOperator = @$_GET["z_k_id"];

		// k_id_kontrak
		$this->k_id_kontrak->AdvancedSearch->SearchValue = @$_GET["x_k_id_kontrak"];
		if ($this->k_id_kontrak->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->k_id_kontrak->AdvancedSearch->SearchOperator = @$_GET["z_k_id_kontrak"];

		// k_id_lama
		$this->k_id_lama->AdvancedSearch->SearchValue = @$_GET["x_k_id_lama"];
		if ($this->k_id_lama->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->k_id_lama->AdvancedSearch->SearchOperator = @$_GET["z_k_id_lama"];

		// k_no_kontrak
		$this->k_no_kontrak->AdvancedSearch->SearchValue = @$_GET["x_k_no_kontrak"];
		if ($this->k_no_kontrak->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->k_no_kontrak->AdvancedSearch->SearchOperator = @$_GET["z_k_no_kontrak"];

		// k_luas_lahan
		$this->k_luas_lahan->AdvancedSearch->SearchValue = @$_GET["x_k_luas_lahan"];
		if ($this->k_luas_lahan->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->k_luas_lahan->AdvancedSearch->SearchOperator = @$_GET["z_k_luas_lahan"];

		// pet_id
		$this->pet_id->AdvancedSearch->SearchValue = @$_GET["x_pet_id"];
		if ($this->pet_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->pet_id->AdvancedSearch->SearchOperator = @$_GET["z_pet_id"];

		// koord_id
		$this->koord_id->AdvancedSearch->SearchValue = @$_GET["x_koord_id"];
		if ($this->koord_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->koord_id->AdvancedSearch->SearchOperator = @$_GET["z_koord_id"];

		// kk_id
		$this->kk_id->AdvancedSearch->SearchValue = @$_GET["x_kk_id"];
		if ($this->kk_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->kk_id->AdvancedSearch->SearchOperator = @$_GET["z_kk_id"];

		// prov_id
		$this->prov_id->AdvancedSearch->SearchValue = @$_GET["x_prov_id"];
		if ($this->prov_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->prov_id->AdvancedSearch->SearchOperator = @$_GET["z_prov_id"];

		// kab_id
		$this->kab_id->AdvancedSearch->SearchValue = @$_GET["x_kab_id"];
		if ($this->kab_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->kab_id->AdvancedSearch->SearchOperator = @$_GET["z_kab_id"];

		// kec_id
		$this->kec_id->AdvancedSearch->SearchValue = @$_GET["x_kec_id"];
		if ($this->kec_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->kec_id->AdvancedSearch->SearchOperator = @$_GET["z_kec_id"];

		// desa_id
		$this->desa_id->AdvancedSearch->SearchValue = @$_GET["x_desa_id"];
		if ($this->desa_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->desa_id->AdvancedSearch->SearchOperator = @$_GET["z_desa_id"];

		// blok_id
		$this->blok_id->AdvancedSearch->SearchValue = @$_GET["x_blok_id"];
		if ($this->blok_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->blok_id->AdvancedSearch->SearchOperator = @$_GET["z_blok_id"];

		// sos_id
		$this->sos_id->AdvancedSearch->SearchValue = @$_GET["x_sos_id"];
		if ($this->sos_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->sos_id->AdvancedSearch->SearchOperator = @$_GET["z_sos_id"];

		// var_id
		$this->var_id->AdvancedSearch->SearchValue = @$_GET["x_var_id"];
		if ($this->var_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->var_id->AdvancedSearch->SearchOperator = @$_GET["z_var_id"];

		// co_id
		$this->co_id->AdvancedSearch->SearchValue = @$_GET["x_co_id"];
		if ($this->co_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->co_id->AdvancedSearch->SearchOperator = @$_GET["z_co_id"];

		// k_jumlah_bibit
		$this->k_jumlah_bibit->AdvancedSearch->SearchValue = @$_GET["x_k_jumlah_bibit"];
		if ($this->k_jumlah_bibit->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->k_jumlah_bibit->AdvancedSearch->SearchOperator = @$_GET["z_k_jumlah_bibit"];

		// k_asal_bibit
		$this->k_asal_bibit->AdvancedSearch->SearchValue = @$_GET["x_k_asal_bibit"];
		if ($this->k_asal_bibit->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->k_asal_bibit->AdvancedSearch->SearchOperator = @$_GET["z_k_asal_bibit"];

		// k_tgl_tanam
		$this->k_tgl_tanam->AdvancedSearch->SearchValue = @$_GET["x_k_tgl_tanam"];
		if ($this->k_tgl_tanam->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->k_tgl_tanam->AdvancedSearch->SearchOperator = @$_GET["z_k_tgl_tanam"];
		$this->k_tgl_tanam->AdvancedSearch->SearchCondition = @$_GET["v_k_tgl_tanam"];
		$this->k_tgl_tanam->AdvancedSearch->SearchValue2 = @$_GET["y_k_tgl_tanam"];
		if ($this->k_tgl_tanam->AdvancedSearch->SearchValue2 <> "" && $this->Command == "") $this->Command = "search";
		$this->k_tgl_tanam->AdvancedSearch->SearchOperator2 = @$_GET["w_k_tgl_tanam"];

		// k_es_tgl_panen
		$this->k_es_tgl_panen->AdvancedSearch->SearchValue = @$_GET["x_k_es_tgl_panen"];
		if ($this->k_es_tgl_panen->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->k_es_tgl_panen->AdvancedSearch->SearchOperator = @$_GET["z_k_es_tgl_panen"];
		$this->k_es_tgl_panen->AdvancedSearch->SearchCondition = @$_GET["v_k_es_tgl_panen"];
		$this->k_es_tgl_panen->AdvancedSearch->SearchValue2 = @$_GET["y_k_es_tgl_panen"];
		if ($this->k_es_tgl_panen->AdvancedSearch->SearchValue2 <> "" && $this->Command == "") $this->Command = "search";
		$this->k_es_tgl_panen->AdvancedSearch->SearchOperator2 = @$_GET["w_k_es_tgl_panen"];

		// k_ak_tgl_datang
		$this->k_ak_tgl_datang->AdvancedSearch->SearchValue = @$_GET["x_k_ak_tgl_datang"];
		if ($this->k_ak_tgl_datang->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->k_ak_tgl_datang->AdvancedSearch->SearchOperator = @$_GET["z_k_ak_tgl_datang"];
		$this->k_ak_tgl_datang->AdvancedSearch->SearchCondition = @$_GET["v_k_ak_tgl_datang"];
		$this->k_ak_tgl_datang->AdvancedSearch->SearchValue2 = @$_GET["y_k_ak_tgl_datang"];
		if ($this->k_ak_tgl_datang->AdvancedSearch->SearchValue2 <> "" && $this->Command == "") $this->Command = "search";
		$this->k_ak_tgl_datang->AdvancedSearch->SearchOperator2 = @$_GET["w_k_ak_tgl_datang"];

		// k_es_qty
		$this->k_es_qty->AdvancedSearch->SearchValue = @$_GET["x_k_es_qty"];
		if ($this->k_es_qty->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->k_es_qty->AdvancedSearch->SearchOperator = @$_GET["z_k_es_qty"];

		// k_ak_qty
		$this->k_ak_qty->AdvancedSearch->SearchValue = @$_GET["x_k_ak_qty"];
		if ($this->k_ak_qty->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->k_ak_qty->AdvancedSearch->SearchOperator = @$_GET["z_k_ak_qty"];

		// k_es_perhektar
		$this->k_es_perhektar->AdvancedSearch->SearchValue = @$_GET["x_k_es_perhektar"];
		if ($this->k_es_perhektar->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->k_es_perhektar->AdvancedSearch->SearchOperator = @$_GET["z_k_es_perhektar"];

		// k_ak_perhektar
		$this->k_ak_perhektar->AdvancedSearch->SearchValue = @$_GET["x_k_ak_perhektar"];
		if ($this->k_ak_perhektar->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->k_ak_perhektar->AdvancedSearch->SearchOperator = @$_GET["z_k_ak_perhektar"];

		// k_skor
		$this->k_skor->AdvancedSearch->SearchValue = @$_GET["x_k_skor"];
		if ($this->k_skor->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->k_skor->AdvancedSearch->SearchOperator = @$_GET["z_k_skor"];

		// k_ket
		$this->k_ket->AdvancedSearch->SearchValue = @$_GET["x_k_ket"];
		if ($this->k_ket->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->k_ket->AdvancedSearch->SearchOperator = @$_GET["z_k_ket"];

		// k_cat
		$this->k_cat->AdvancedSearch->SearchValue = @$_GET["x_k_cat"];
		if ($this->k_cat->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->k_cat->AdvancedSearch->SearchOperator = @$_GET["z_k_cat"];

		// k_titik_koordinat
		$this->k_titik_koordinat->AdvancedSearch->SearchValue = @$_GET["x_k_titik_koordinat"];
		if ($this->k_titik_koordinat->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->k_titik_koordinat->AdvancedSearch->SearchOperator = @$_GET["z_k_titik_koordinat"];

		// k_foto_lahan
		$this->k_foto_lahan->AdvancedSearch->SearchValue = @$_GET["x_k_foto_lahan"];
		if ($this->k_foto_lahan->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->k_foto_lahan->AdvancedSearch->SearchOperator = @$_GET["z_k_foto_lahan"];

		// k_dok
		$this->k_dok->AdvancedSearch->SearchValue = @$_GET["x_k_dok"];
		if ($this->k_dok->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->k_dok->AdvancedSearch->SearchOperator = @$_GET["z_k_dok"];

		// k_harga_bibit
		$this->k_harga_bibit->AdvancedSearch->SearchValue = @$_GET["x_k_harga_bibit"];
		if ($this->k_harga_bibit->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->k_harga_bibit->AdvancedSearch->SearchOperator = @$_GET["z_k_harga_bibit"];

		// k_bayar_bibit
		$this->k_bayar_bibit->AdvancedSearch->SearchValue = @$_GET["x_k_bayar_bibit"];
		if ($this->k_bayar_bibit->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->k_bayar_bibit->AdvancedSearch->SearchOperator = @$_GET["z_k_bayar_bibit"];

		// k_pinjaman
		$this->k_pinjaman->AdvancedSearch->SearchValue = @$_GET["x_k_pinjaman"];
		if ($this->k_pinjaman->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->k_pinjaman->AdvancedSearch->SearchOperator = @$_GET["z_k_pinjaman"];

		// k_bayar_pinjaman
		$this->k_bayar_pinjaman->AdvancedSearch->SearchValue = @$_GET["x_k_bayar_pinjaman"];
		if ($this->k_bayar_pinjaman->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->k_bayar_pinjaman->AdvancedSearch->SearchOperator = @$_GET["z_k_bayar_pinjaman"];

		// k_sisa_hutang
		$this->k_sisa_hutang->AdvancedSearch->SearchValue = @$_GET["x_k_sisa_hutang"];
		if ($this->k_sisa_hutang->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->k_sisa_hutang->AdvancedSearch->SearchOperator = @$_GET["z_k_sisa_hutang"];
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {

		// Load List page SQL
		$sSql = $this->ListSQL();
		$conn = &$this->Connection();

		// Load recordset
		$dbtype = ew_GetConnectionType($this->DBID);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset, array("_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderByList())));
			} else {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = ew_LoadRecordset($sSql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues($rs = NULL) {
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->NewRow(); 

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->k_id->setDbValue($row['k_id']);
		$this->k_id_kontrak->setDbValue($row['k_id_kontrak']);
		$this->k_id_lama->setDbValue($row['k_id_lama']);
		$this->k_no_kontrak->setDbValue($row['k_no_kontrak']);
		$this->k_luas_lahan->setDbValue($row['k_luas_lahan']);
		$this->pet_id->setDbValue($row['pet_id']);
		if (array_key_exists('EV__pet_id', $rs->fields)) {
			$this->pet_id->VirtualValue = $rs->fields('EV__pet_id'); // Set up virtual field value
		} else {
			$this->pet_id->VirtualValue = ""; // Clear value
		}
		$this->koord_id->setDbValue($row['koord_id']);
		if (array_key_exists('EV__koord_id', $rs->fields)) {
			$this->koord_id->VirtualValue = $rs->fields('EV__koord_id'); // Set up virtual field value
		} else {
			$this->koord_id->VirtualValue = ""; // Clear value
		}
		$this->kk_id->setDbValue($row['kk_id']);
		$this->prov_id->setDbValue($row['prov_id']);
		$this->kab_id->setDbValue($row['kab_id']);
		$this->kec_id->setDbValue($row['kec_id']);
		if (array_key_exists('EV__kec_id', $rs->fields)) {
			$this->kec_id->VirtualValue = $rs->fields('EV__kec_id'); // Set up virtual field value
		} else {
			$this->kec_id->VirtualValue = ""; // Clear value
		}
		$this->desa_id->setDbValue($row['desa_id']);
		if (array_key_exists('EV__desa_id', $rs->fields)) {
			$this->desa_id->VirtualValue = $rs->fields('EV__desa_id'); // Set up virtual field value
		} else {
			$this->desa_id->VirtualValue = ""; // Clear value
		}
		$this->blok_id->setDbValue($row['blok_id']);
		if (array_key_exists('EV__blok_id', $rs->fields)) {
			$this->blok_id->VirtualValue = $rs->fields('EV__blok_id'); // Set up virtual field value
		} else {
			$this->blok_id->VirtualValue = ""; // Clear value
		}
		$this->sos_id->setDbValue($row['sos_id']);
		if (array_key_exists('EV__sos_id', $rs->fields)) {
			$this->sos_id->VirtualValue = $rs->fields('EV__sos_id'); // Set up virtual field value
		} else {
			$this->sos_id->VirtualValue = ""; // Clear value
		}
		$this->var_id->setDbValue($row['var_id']);
		$this->co_id->setDbValue($row['co_id']);
		$this->k_jumlah_bibit->setDbValue($row['k_jumlah_bibit']);
		$this->k_asal_bibit->setDbValue($row['k_asal_bibit']);
		$this->k_tgl_tanam->setDbValue($row['k_tgl_tanam']);
		$this->k_es_tgl_panen->setDbValue($row['k_es_tgl_panen']);
		$this->k_ak_tgl_datang->setDbValue($row['k_ak_tgl_datang']);
		$this->k_es_qty->setDbValue($row['k_es_qty']);
		$this->k_ak_qty->setDbValue($row['k_ak_qty']);
		$this->k_es_perhektar->setDbValue($row['k_es_perhektar']);
		$this->k_ak_perhektar->setDbValue($row['k_ak_perhektar']);
		$this->k_skor->setDbValue($row['k_skor']);
		$this->k_ket->setDbValue($row['k_ket']);
		$this->k_cat->setDbValue($row['k_cat']);
		$this->k_titik_koordinat->setDbValue($row['k_titik_koordinat']);
		$this->k_foto_lahan->Upload->DbValue = $row['k_foto_lahan'];
		$this->k_foto_lahan->setDbValue($this->k_foto_lahan->Upload->DbValue);
		$this->k_dok->Upload->DbValue = $row['k_dok'];
		$this->k_dok->setDbValue($this->k_dok->Upload->DbValue);
		$this->k_harga_bibit->setDbValue($row['k_harga_bibit']);
		$this->k_bayar_bibit->setDbValue($row['k_bayar_bibit']);
		$this->k_pinjaman->setDbValue($row['k_pinjaman']);
		$this->k_bayar_pinjaman->setDbValue($row['k_bayar_pinjaman']);
		$this->k_sisa_hutang->setDbValue($row['k_sisa_hutang']);
	}

	// Return a row with default values
	function NewRow() {
		$row = array();
		$row['k_id'] = NULL;
		$row['k_id_kontrak'] = NULL;
		$row['k_id_lama'] = NULL;
		$row['k_no_kontrak'] = NULL;
		$row['k_luas_lahan'] = NULL;
		$row['pet_id'] = NULL;
		$row['koord_id'] = NULL;
		$row['kk_id'] = NULL;
		$row['prov_id'] = NULL;
		$row['kab_id'] = NULL;
		$row['kec_id'] = NULL;
		$row['desa_id'] = NULL;
		$row['blok_id'] = NULL;
		$row['sos_id'] = NULL;
		$row['var_id'] = NULL;
		$row['co_id'] = NULL;
		$row['k_jumlah_bibit'] = NULL;
		$row['k_asal_bibit'] = NULL;
		$row['k_tgl_tanam'] = NULL;
		$row['k_es_tgl_panen'] = NULL;
		$row['k_ak_tgl_datang'] = NULL;
		$row['k_es_qty'] = NULL;
		$row['k_ak_qty'] = NULL;
		$row['k_es_perhektar'] = NULL;
		$row['k_ak_perhektar'] = NULL;
		$row['k_skor'] = NULL;
		$row['k_ket'] = NULL;
		$row['k_cat'] = NULL;
		$row['k_titik_koordinat'] = NULL;
		$row['k_foto_lahan'] = NULL;
		$row['k_dok'] = NULL;
		$row['k_harga_bibit'] = NULL;
		$row['k_bayar_bibit'] = NULL;
		$row['k_pinjaman'] = NULL;
		$row['k_bayar_pinjaman'] = NULL;
		$row['k_sisa_hutang'] = NULL;
		return $row;
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->k_id->DbValue = $row['k_id'];
		$this->k_id_kontrak->DbValue = $row['k_id_kontrak'];
		$this->k_id_lama->DbValue = $row['k_id_lama'];
		$this->k_no_kontrak->DbValue = $row['k_no_kontrak'];
		$this->k_luas_lahan->DbValue = $row['k_luas_lahan'];
		$this->pet_id->DbValue = $row['pet_id'];
		$this->koord_id->DbValue = $row['koord_id'];
		$this->kk_id->DbValue = $row['kk_id'];
		$this->prov_id->DbValue = $row['prov_id'];
		$this->kab_id->DbValue = $row['kab_id'];
		$this->kec_id->DbValue = $row['kec_id'];
		$this->desa_id->DbValue = $row['desa_id'];
		$this->blok_id->DbValue = $row['blok_id'];
		$this->sos_id->DbValue = $row['sos_id'];
		$this->var_id->DbValue = $row['var_id'];
		$this->co_id->DbValue = $row['co_id'];
		$this->k_jumlah_bibit->DbValue = $row['k_jumlah_bibit'];
		$this->k_asal_bibit->DbValue = $row['k_asal_bibit'];
		$this->k_tgl_tanam->DbValue = $row['k_tgl_tanam'];
		$this->k_es_tgl_panen->DbValue = $row['k_es_tgl_panen'];
		$this->k_ak_tgl_datang->DbValue = $row['k_ak_tgl_datang'];
		$this->k_es_qty->DbValue = $row['k_es_qty'];
		$this->k_ak_qty->DbValue = $row['k_ak_qty'];
		$this->k_es_perhektar->DbValue = $row['k_es_perhektar'];
		$this->k_ak_perhektar->DbValue = $row['k_ak_perhektar'];
		$this->k_skor->DbValue = $row['k_skor'];
		$this->k_ket->DbValue = $row['k_ket'];
		$this->k_cat->DbValue = $row['k_cat'];
		$this->k_titik_koordinat->DbValue = $row['k_titik_koordinat'];
		$this->k_foto_lahan->Upload->DbValue = $row['k_foto_lahan'];
		$this->k_dok->Upload->DbValue = $row['k_dok'];
		$this->k_harga_bibit->DbValue = $row['k_harga_bibit'];
		$this->k_bayar_bibit->DbValue = $row['k_bayar_bibit'];
		$this->k_pinjaman->DbValue = $row['k_pinjaman'];
		$this->k_bayar_pinjaman->DbValue = $row['k_bayar_pinjaman'];
		$this->k_sisa_hutang->DbValue = $row['k_sisa_hutang'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("k_id")) <> "")
			$this->k_id->CurrentValue = $this->getKey("k_id"); // k_id
		else
			$bValidKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
		}
		$this->LoadRowValues($this->OldRecordset); // Load row values
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->GetViewUrl();
		$this->EditUrl = $this->GetEditUrl();
		$this->InlineEditUrl = $this->GetInlineEditUrl();
		$this->CopyUrl = $this->GetCopyUrl();
		$this->InlineCopyUrl = $this->GetInlineCopyUrl();
		$this->DeleteUrl = $this->GetDeleteUrl();

		// Convert decimal values if posted back
		if ($this->k_ak_perhektar->FormValue == $this->k_ak_perhektar->CurrentValue && is_numeric(ew_StrToFloat($this->k_ak_perhektar->CurrentValue)))
			$this->k_ak_perhektar->CurrentValue = ew_StrToFloat($this->k_ak_perhektar->CurrentValue);

		// Convert decimal values if posted back
		if ($this->k_skor->FormValue == $this->k_skor->CurrentValue && is_numeric(ew_StrToFloat($this->k_skor->CurrentValue)))
			$this->k_skor->CurrentValue = ew_StrToFloat($this->k_skor->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// k_id

		$this->k_id->CellCssStyle = "white-space: nowrap;";

		// k_id_kontrak
		// k_id_lama
		// k_no_kontrak
		// k_luas_lahan
		// pet_id
		// koord_id
		// kk_id
		// prov_id
		// kab_id
		// kec_id
		// desa_id
		// blok_id
		// sos_id
		// var_id
		// co_id
		// k_jumlah_bibit
		// k_asal_bibit
		// k_tgl_tanam
		// k_es_tgl_panen
		// k_ak_tgl_datang
		// k_es_qty
		// k_ak_qty
		// k_es_perhektar
		// k_ak_perhektar
		// k_skor
		// k_ket
		// k_cat
		// k_titik_koordinat
		// k_foto_lahan
		// k_dok
		// k_harga_bibit
		// k_bayar_bibit
		// k_pinjaman
		// k_bayar_pinjaman
		// k_sisa_hutang
		// Accumulate aggregate value

		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT && $this->RowType <> EW_ROWTYPE_AGGREGATE) {
			if (is_numeric($this->k_luas_lahan->CurrentValue))
				$this->k_luas_lahan->Total += $this->k_luas_lahan->CurrentValue; // Accumulate total
		}
		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// k_id
		$this->k_id->ViewValue = $this->k_id->CurrentValue;
		$this->k_id->ViewCustomAttributes = "";

		// k_id_kontrak
		$this->k_id_kontrak->ViewValue = $this->k_id_kontrak->CurrentValue;
		$this->k_id_kontrak->ViewCustomAttributes = "";

		// k_id_lama
		$this->k_id_lama->ViewValue = $this->k_id_lama->CurrentValue;
		$this->k_id_lama->ViewCustomAttributes = "";

		// k_no_kontrak
		$this->k_no_kontrak->ViewValue = $this->k_no_kontrak->CurrentValue;
		$this->k_no_kontrak->ViewCustomAttributes = "";

		// k_luas_lahan
		$this->k_luas_lahan->ViewValue = $this->k_luas_lahan->CurrentValue;
		$this->k_luas_lahan->ViewCustomAttributes = "";

		// pet_id
		if ($this->pet_id->VirtualValue <> "") {
			$this->pet_id->ViewValue = $this->pet_id->VirtualValue;
		} else {
		if (strval($this->pet_id->CurrentValue) <> "") {
			$sFilterWrk = "`pet_id`" . ew_SearchString("=", $this->pet_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `pet_id`, `pet_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `petani`";
		$sWhereWrk = "";
		$this->pet_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->pet_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `pet_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->pet_id->ViewValue = $this->pet_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->pet_id->ViewValue = $this->pet_id->CurrentValue;
			}
		} else {
			$this->pet_id->ViewValue = NULL;
		}
		}
		$this->pet_id->ViewCustomAttributes = "";

		// koord_id
		if ($this->koord_id->VirtualValue <> "") {
			$this->koord_id->ViewValue = $this->koord_id->VirtualValue;
		} else {
		if (strval($this->koord_id->CurrentValue) <> "") {
			$sFilterWrk = "`koord_id`" . ew_SearchString("=", $this->koord_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `koord_id`, `koord_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `koord`";
		$sWhereWrk = "";
		$this->koord_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->koord_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `koord_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->koord_id->ViewValue = $this->koord_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->koord_id->ViewValue = $this->koord_id->CurrentValue;
			}
		} else {
			$this->koord_id->ViewValue = NULL;
		}
		}
		$this->koord_id->ViewCustomAttributes = "";

		// kk_id
		if (strval($this->kk_id->CurrentValue) <> "") {
			$sFilterWrk = "`kk_id`" . ew_SearchString("=", $this->kk_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `kk_id`, `kk_periode` AS `DispFld`, `kk_tgl_mulai` AS `Disp2Fld`, `kk_tgl_akhir` AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kontrak_koord`";
		$sWhereWrk = "";
		$this->kk_id->LookupFilters = array("df2" => "5", "df3" => "5");
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->kk_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = ew_FormatDateTime($rswrk->fields('Disp2Fld'), 5);
				$arwrk[3] = ew_FormatDateTime($rswrk->fields('Disp3Fld'), 5);
				$this->kk_id->ViewValue = $this->kk_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->kk_id->ViewValue = $this->kk_id->CurrentValue;
			}
		} else {
			$this->kk_id->ViewValue = NULL;
		}
		$this->kk_id->ViewCustomAttributes = "";

		// prov_id
		if (strval($this->prov_id->CurrentValue) <> "") {
			$sFilterWrk = "`prov_id`" . ew_SearchString("=", $this->prov_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `prov_id`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `prov`";
		$sWhereWrk = "";
		$this->prov_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->prov_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `prov_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->prov_id->ViewValue = $this->prov_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->prov_id->ViewValue = $this->prov_id->CurrentValue;
			}
		} else {
			$this->prov_id->ViewValue = NULL;
		}
		$this->prov_id->ViewCustomAttributes = "";

		// kab_id
		if (strval($this->kab_id->CurrentValue) <> "") {
			$sFilterWrk = "`kab_id`" . ew_SearchString("=", $this->kab_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `kab_id`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kab`";
		$sWhereWrk = "";
		$this->kab_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->kab_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `kab_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->kab_id->ViewValue = $this->kab_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->kab_id->ViewValue = $this->kab_id->CurrentValue;
			}
		} else {
			$this->kab_id->ViewValue = NULL;
		}
		$this->kab_id->ViewCustomAttributes = "";

		// kec_id
		if ($this->kec_id->VirtualValue <> "") {
			$this->kec_id->ViewValue = $this->kec_id->VirtualValue;
		} else {
		if (strval($this->kec_id->CurrentValue) <> "") {
			$sFilterWrk = "`kec_id`" . ew_SearchString("=", $this->kec_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `kec_id`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kec`";
		$sWhereWrk = "";
		$this->kec_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->kec_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `kec_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->kec_id->ViewValue = $this->kec_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->kec_id->ViewValue = $this->kec_id->CurrentValue;
			}
		} else {
			$this->kec_id->ViewValue = NULL;
		}
		}
		$this->kec_id->ViewCustomAttributes = "";

		// desa_id
		if ($this->desa_id->VirtualValue <> "") {
			$this->desa_id->ViewValue = $this->desa_id->VirtualValue;
		} else {
		if (strval($this->desa_id->CurrentValue) <> "") {
			$sFilterWrk = "`desa_id`" . ew_SearchString("=", $this->desa_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `desa_id`, `desa_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `desa`";
		$sWhereWrk = "";
		$this->desa_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->desa_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `desa_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->desa_id->ViewValue = $this->desa_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->desa_id->ViewValue = $this->desa_id->CurrentValue;
			}
		} else {
			$this->desa_id->ViewValue = NULL;
		}
		}
		$this->desa_id->ViewCustomAttributes = "";

		// blok_id
		if ($this->blok_id->VirtualValue <> "") {
			$this->blok_id->ViewValue = $this->blok_id->VirtualValue;
		} else {
		if (strval($this->blok_id->CurrentValue) <> "") {
			$sFilterWrk = "`blok_id`" . ew_SearchString("=", $this->blok_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `blok_id`, `blok_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `blok`";
		$sWhereWrk = "";
		$this->blok_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->blok_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `blok_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->blok_id->ViewValue = $this->blok_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->blok_id->ViewValue = $this->blok_id->CurrentValue;
			}
		} else {
			$this->blok_id->ViewValue = NULL;
		}
		}
		$this->blok_id->ViewCustomAttributes = "";

		// sos_id
		if ($this->sos_id->VirtualValue <> "") {
			$this->sos_id->ViewValue = $this->sos_id->VirtualValue;
		} else {
		if (strval($this->sos_id->CurrentValue) <> "") {
			$sFilterWrk = "`sos_id`" . ew_SearchString("=", $this->sos_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `sos_id`, `sos_id` AS `DispFld`, `sos_tgl` AS `Disp2Fld`, `sos_alamat` AS `Disp3Fld`, '' AS `Disp4Fld` FROM `sosialisasi`";
		$sWhereWrk = "";
		$this->sos_id->LookupFilters = array("df2" => "0");
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->sos_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `sos_tgl` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = ew_FormatDateTime($rswrk->fields('Disp2Fld'), 0);
				$arwrk[3] = $rswrk->fields('Disp3Fld');
				$this->sos_id->ViewValue = $this->sos_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->sos_id->ViewValue = $this->sos_id->CurrentValue;
			}
		} else {
			$this->sos_id->ViewValue = NULL;
		}
		}
		$this->sos_id->ViewCustomAttributes = "";

		// var_id
		if (strval($this->var_id->CurrentValue) <> "") {
			$sFilterWrk = "`var_id`" . ew_SearchString("=", $this->var_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `var_id`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `varietas`";
		$sWhereWrk = "";
		$this->var_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->var_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `var_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->var_id->ViewValue = $this->var_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->var_id->ViewValue = $this->var_id->CurrentValue;
			}
		} else {
			$this->var_id->ViewValue = NULL;
		}
		$this->var_id->ViewCustomAttributes = "";

		// co_id
		if (strval($this->co_id->CurrentValue) <> "") {
			$sFilterWrk = "`co_id`" . ew_SearchString("=", $this->co_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `co_id`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `co`";
		$sWhereWrk = "";
		$this->co_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->co_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `co_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->co_id->ViewValue = $this->co_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->co_id->ViewValue = $this->co_id->CurrentValue;
			}
		} else {
			$this->co_id->ViewValue = NULL;
		}
		$this->co_id->ViewCustomAttributes = "";

		// k_jumlah_bibit
		$this->k_jumlah_bibit->ViewValue = $this->k_jumlah_bibit->CurrentValue;
		$this->k_jumlah_bibit->ViewCustomAttributes = "";

		// k_asal_bibit
		$this->k_asal_bibit->ViewValue = $this->k_asal_bibit->CurrentValue;
		$this->k_asal_bibit->ViewCustomAttributes = "";

		// k_tgl_tanam
		$this->k_tgl_tanam->ViewValue = $this->k_tgl_tanam->CurrentValue;
		$this->k_tgl_tanam->ViewValue = ew_FormatDateTime($this->k_tgl_tanam->ViewValue, 5);
		$this->k_tgl_tanam->ViewCustomAttributes = "";

		// k_es_tgl_panen
		$this->k_es_tgl_panen->ViewValue = $this->k_es_tgl_panen->CurrentValue;
		$this->k_es_tgl_panen->ViewValue = ew_FormatDateTime($this->k_es_tgl_panen->ViewValue, 5);
		$this->k_es_tgl_panen->ViewCustomAttributes = "";

		// k_ak_tgl_datang
		$this->k_ak_tgl_datang->ViewValue = $this->k_ak_tgl_datang->CurrentValue;
		$this->k_ak_tgl_datang->ViewValue = ew_FormatDateTime($this->k_ak_tgl_datang->ViewValue, 5);
		$this->k_ak_tgl_datang->ViewCustomAttributes = "";

		// k_es_qty
		$this->k_es_qty->ViewValue = $this->k_es_qty->CurrentValue;
		$this->k_es_qty->ViewCustomAttributes = "";

		// k_ak_qty
		$this->k_ak_qty->ViewValue = $this->k_ak_qty->CurrentValue;
		$this->k_ak_qty->ViewCustomAttributes = "";

		// k_es_perhektar
		$this->k_es_perhektar->ViewValue = $this->k_es_perhektar->CurrentValue;
		$this->k_es_perhektar->ViewCustomAttributes = "";

		// k_ak_perhektar
		$this->k_ak_perhektar->ViewValue = $this->k_ak_perhektar->CurrentValue;
		$this->k_ak_perhektar->ViewCustomAttributes = "";

		// k_skor
		$this->k_skor->ViewValue = $this->k_skor->CurrentValue;
		$this->k_skor->ViewCustomAttributes = "";

		// k_ket
		$this->k_ket->ViewValue = $this->k_ket->CurrentValue;
		$this->k_ket->ViewCustomAttributes = "";

		// k_cat
		$this->k_cat->ViewValue = $this->k_cat->CurrentValue;
		$this->k_cat->ViewCustomAttributes = "";

		// k_titik_koordinat
		$this->k_titik_koordinat->ViewValue = $this->k_titik_koordinat->CurrentValue;
		$this->k_titik_koordinat->CellCssStyle .= "text-align: left;";
		$this->k_titik_koordinat->ViewCustomAttributes = "";

		// k_foto_lahan
		$this->k_foto_lahan->UploadPath = "foto_lahan";
		if (!ew_Empty($this->k_foto_lahan->Upload->DbValue)) {
			$this->k_foto_lahan->ImageWidth = 40;
			$this->k_foto_lahan->ImageHeight = 30;
			$this->k_foto_lahan->ImageAlt = $this->k_foto_lahan->FldAlt();
			$this->k_foto_lahan->ViewValue = $this->k_foto_lahan->Upload->DbValue;
		} else {
			$this->k_foto_lahan->ViewValue = "";
		}
		$this->k_foto_lahan->CellCssStyle .= "text-align: left;";
		$this->k_foto_lahan->ViewCustomAttributes = "";

		// k_dok
		$this->k_dok->UploadPath = "dokumen_kontrak_lahan";
		if (!ew_Empty($this->k_dok->Upload->DbValue)) {
			$this->k_dok->ImageWidth = 42;
			$this->k_dok->ImageHeight = 70;
			$this->k_dok->ImageAlt = $this->k_dok->FldAlt();
			$this->k_dok->ViewValue = $this->k_dok->Upload->DbValue;
		} else {
			$this->k_dok->ViewValue = "";
		}
		$this->k_dok->ViewCustomAttributes = "";

		// k_harga_bibit
		$this->k_harga_bibit->ViewValue = $this->k_harga_bibit->CurrentValue;
		$this->k_harga_bibit->ViewCustomAttributes = "";

		// k_bayar_bibit
		$this->k_bayar_bibit->ViewValue = $this->k_bayar_bibit->CurrentValue;
		$this->k_bayar_bibit->ViewCustomAttributes = "";

		// k_pinjaman
		$this->k_pinjaman->ViewValue = $this->k_pinjaman->CurrentValue;
		$this->k_pinjaman->ViewCustomAttributes = "";

		// k_bayar_pinjaman
		$this->k_bayar_pinjaman->ViewValue = $this->k_bayar_pinjaman->CurrentValue;
		$this->k_bayar_pinjaman->ViewCustomAttributes = "";

		// k_sisa_hutang
		$this->k_sisa_hutang->ViewValue = $this->k_sisa_hutang->CurrentValue;
		$this->k_sisa_hutang->ViewCustomAttributes = "";

			// k_id_kontrak
			$this->k_id_kontrak->LinkCustomAttributes = "";
			$this->k_id_kontrak->HrefValue = "";
			$this->k_id_kontrak->TooltipValue = "";

			// k_id_lama
			$this->k_id_lama->LinkCustomAttributes = "";
			$this->k_id_lama->HrefValue = "";
			$this->k_id_lama->TooltipValue = "";

			// k_no_kontrak
			$this->k_no_kontrak->LinkCustomAttributes = "";
			$this->k_no_kontrak->HrefValue = "";
			$this->k_no_kontrak->TooltipValue = "";

			// k_luas_lahan
			$this->k_luas_lahan->LinkCustomAttributes = "";
			$this->k_luas_lahan->HrefValue = "";
			$this->k_luas_lahan->TooltipValue = "";

			// pet_id
			$this->pet_id->LinkCustomAttributes = "";
			if (!ew_Empty($this->pet_id->CurrentValue)) {
				$this->pet_id->HrefValue = "petaniview.php?showdetail=&pet_id=" . $this->pet_id->CurrentValue; // Add prefix/suffix
				$this->pet_id->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->pet_id->HrefValue = ew_FullUrl($this->pet_id->HrefValue, "href");
			} else {
				$this->pet_id->HrefValue = "";
			}
			$this->pet_id->TooltipValue = "";

			// koord_id
			$this->koord_id->LinkCustomAttributes = "";
			if (!ew_Empty($this->koord_id->CurrentValue)) {
				$this->koord_id->HrefValue = "koordview.php?showdetail=&koord_id=" . $this->koord_id->CurrentValue; // Add prefix/suffix
				$this->koord_id->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->koord_id->HrefValue = ew_FullUrl($this->koord_id->HrefValue, "href");
			} else {
				$this->koord_id->HrefValue = "";
			}
			$this->koord_id->TooltipValue = "";

			// kk_id
			$this->kk_id->LinkCustomAttributes = "";
			if (!ew_Empty($this->kk_id->CurrentValue)) {
				$this->kk_id->HrefValue = "kontrak_koordview.php?showdetail=&kk_id=" . $this->kk_id->CurrentValue; // Add prefix/suffix
				$this->kk_id->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->kk_id->HrefValue = ew_FullUrl($this->kk_id->HrefValue, "href");
			} else {
				$this->kk_id->HrefValue = "";
			}
			$this->kk_id->TooltipValue = "";

			// prov_id
			$this->prov_id->LinkCustomAttributes = "";
			$this->prov_id->HrefValue = "";
			$this->prov_id->TooltipValue = "";

			// kab_id
			$this->kab_id->LinkCustomAttributes = "";
			$this->kab_id->HrefValue = "";
			$this->kab_id->TooltipValue = "";

			// kec_id
			$this->kec_id->LinkCustomAttributes = "";
			$this->kec_id->HrefValue = "";
			$this->kec_id->TooltipValue = "";

			// desa_id
			$this->desa_id->LinkCustomAttributes = "";
			$this->desa_id->HrefValue = "";
			$this->desa_id->TooltipValue = "";

			// blok_id
			$this->blok_id->LinkCustomAttributes = "";
			$this->blok_id->HrefValue = "";
			$this->blok_id->TooltipValue = "";

			// sos_id
			$this->sos_id->LinkCustomAttributes = "";
			$this->sos_id->HrefValue = "";
			$this->sos_id->TooltipValue = "";

			// var_id
			$this->var_id->LinkCustomAttributes = "";
			if (!ew_Empty($this->var_id->CurrentValue)) {
				$this->var_id->HrefValue = "varietasview.php?showdetail=&var_id=" . $this->var_id->CurrentValue; // Add prefix/suffix
				$this->var_id->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->var_id->HrefValue = ew_FullUrl($this->var_id->HrefValue, "href");
			} else {
				$this->var_id->HrefValue = "";
			}
			$this->var_id->TooltipValue = "";

			// co_id
			$this->co_id->LinkCustomAttributes = "";
			if (!ew_Empty($this->co_id->CurrentValue)) {
				$this->co_id->HrefValue = "coview.php?showdetail=&co_id=" . $this->co_id->CurrentValue; // Add prefix/suffix
				$this->co_id->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->co_id->HrefValue = ew_FullUrl($this->co_id->HrefValue, "href");
			} else {
				$this->co_id->HrefValue = "";
			}
			$this->co_id->TooltipValue = "";

			// k_jumlah_bibit
			$this->k_jumlah_bibit->LinkCustomAttributes = "";
			$this->k_jumlah_bibit->HrefValue = "";
			$this->k_jumlah_bibit->TooltipValue = "";

			// k_asal_bibit
			$this->k_asal_bibit->LinkCustomAttributes = "";
			$this->k_asal_bibit->HrefValue = "";
			$this->k_asal_bibit->TooltipValue = "";

			// k_tgl_tanam
			$this->k_tgl_tanam->LinkCustomAttributes = "";
			$this->k_tgl_tanam->HrefValue = "";
			$this->k_tgl_tanam->TooltipValue = "";

			// k_es_tgl_panen
			$this->k_es_tgl_panen->LinkCustomAttributes = "";
			$this->k_es_tgl_panen->HrefValue = "";
			$this->k_es_tgl_panen->TooltipValue = "";

			// k_ak_tgl_datang
			$this->k_ak_tgl_datang->LinkCustomAttributes = "";
			$this->k_ak_tgl_datang->HrefValue = "";
			$this->k_ak_tgl_datang->TooltipValue = "";

			// k_es_qty
			$this->k_es_qty->LinkCustomAttributes = "";
			$this->k_es_qty->HrefValue = "";
			$this->k_es_qty->TooltipValue = "";

			// k_ak_qty
			$this->k_ak_qty->LinkCustomAttributes = "";
			$this->k_ak_qty->HrefValue = "";
			$this->k_ak_qty->TooltipValue = "";

			// k_es_perhektar
			$this->k_es_perhektar->LinkCustomAttributes = "";
			$this->k_es_perhektar->HrefValue = "";
			$this->k_es_perhektar->TooltipValue = "";

			// k_ak_perhektar
			$this->k_ak_perhektar->LinkCustomAttributes = "";
			$this->k_ak_perhektar->HrefValue = "";
			$this->k_ak_perhektar->TooltipValue = "";

			// k_skor
			$this->k_skor->LinkCustomAttributes = "";
			$this->k_skor->HrefValue = "";
			$this->k_skor->TooltipValue = "";

			// k_ket
			$this->k_ket->LinkCustomAttributes = "";
			$this->k_ket->HrefValue = "";
			$this->k_ket->TooltipValue = "";

			// k_cat
			$this->k_cat->LinkCustomAttributes = "";
			$this->k_cat->HrefValue = "";
			$this->k_cat->TooltipValue = "";

			// k_titik_koordinat
			$this->k_titik_koordinat->LinkCustomAttributes = "";
			if (!ew_Empty($this->k_titik_koordinat->CurrentValue)) {
				$this->k_titik_koordinat->HrefValue = ((!empty($this->k_titik_koordinat->ViewValue) && !is_array($this->k_titik_koordinat->ViewValue)) ? ew_RemoveHtml($this->k_titik_koordinat->ViewValue) : $this->k_titik_koordinat->CurrentValue); // Add prefix/suffix
				$this->k_titik_koordinat->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->k_titik_koordinat->HrefValue = ew_FullUrl($this->k_titik_koordinat->HrefValue, "href");
			} else {
				$this->k_titik_koordinat->HrefValue = "";
			}
			$this->k_titik_koordinat->TooltipValue = "";

			// k_foto_lahan
			$this->k_foto_lahan->LinkCustomAttributes = "";
			$this->k_foto_lahan->UploadPath = "foto_lahan";
			if (!ew_Empty($this->k_foto_lahan->Upload->DbValue)) {
				$this->k_foto_lahan->HrefValue = "%u"; // Add prefix/suffix
				$this->k_foto_lahan->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->k_foto_lahan->HrefValue = ew_FullUrl($this->k_foto_lahan->HrefValue, "href");
			} else {
				$this->k_foto_lahan->HrefValue = "";
			}
			$this->k_foto_lahan->HrefValue2 = $this->k_foto_lahan->UploadPath . $this->k_foto_lahan->Upload->DbValue;
			$this->k_foto_lahan->TooltipValue = "";
			if ($this->k_foto_lahan->UseColorbox) {
				if (ew_Empty($this->k_foto_lahan->TooltipValue))
					$this->k_foto_lahan->LinkAttrs["title"] = $Language->Phrase("ViewImageGallery");
				$this->k_foto_lahan->LinkAttrs["data-rel"] = "kontrak_x" . $this->RowCnt . "_k_foto_lahan";
				ew_AppendClass($this->k_foto_lahan->LinkAttrs["class"], "ewLightbox");
			}

			// k_dok
			$this->k_dok->LinkCustomAttributes = "";
			$this->k_dok->UploadPath = "dokumen_kontrak_lahan";
			if (!ew_Empty($this->k_dok->Upload->DbValue)) {
				$this->k_dok->HrefValue = "%u"; // Add prefix/suffix
				$this->k_dok->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->k_dok->HrefValue = ew_FullUrl($this->k_dok->HrefValue, "href");
			} else {
				$this->k_dok->HrefValue = "";
			}
			$this->k_dok->HrefValue2 = $this->k_dok->UploadPath . $this->k_dok->Upload->DbValue;
			$this->k_dok->TooltipValue = "";
			if ($this->k_dok->UseColorbox) {
				if (ew_Empty($this->k_dok->TooltipValue))
					$this->k_dok->LinkAttrs["title"] = $Language->Phrase("ViewImageGallery");
				$this->k_dok->LinkAttrs["data-rel"] = "kontrak_x" . $this->RowCnt . "_k_dok";
				ew_AppendClass($this->k_dok->LinkAttrs["class"], "ewLightbox");
			}

			// k_harga_bibit
			$this->k_harga_bibit->LinkCustomAttributes = "";
			$this->k_harga_bibit->HrefValue = "";
			$this->k_harga_bibit->TooltipValue = "";

			// k_bayar_bibit
			$this->k_bayar_bibit->LinkCustomAttributes = "";
			$this->k_bayar_bibit->HrefValue = "";
			$this->k_bayar_bibit->TooltipValue = "";

			// k_pinjaman
			$this->k_pinjaman->LinkCustomAttributes = "";
			$this->k_pinjaman->HrefValue = "";
			$this->k_pinjaman->TooltipValue = "";

			// k_bayar_pinjaman
			$this->k_bayar_pinjaman->LinkCustomAttributes = "";
			$this->k_bayar_pinjaman->HrefValue = "";
			$this->k_bayar_pinjaman->TooltipValue = "";

			// k_sisa_hutang
			$this->k_sisa_hutang->LinkCustomAttributes = "";
			$this->k_sisa_hutang->HrefValue = "";
			$this->k_sisa_hutang->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_SEARCH) { // Search row

			// k_id_kontrak
			$this->k_id_kontrak->EditAttrs["class"] = "form-control";
			$this->k_id_kontrak->EditCustomAttributes = "";
			$this->k_id_kontrak->EditValue = ew_HtmlEncode($this->k_id_kontrak->AdvancedSearch->SearchValue);
			$this->k_id_kontrak->PlaceHolder = ew_RemoveHtml($this->k_id_kontrak->FldCaption());

			// k_id_lama
			$this->k_id_lama->EditAttrs["class"] = "form-control";
			$this->k_id_lama->EditCustomAttributes = "";
			$this->k_id_lama->EditValue = ew_HtmlEncode($this->k_id_lama->AdvancedSearch->SearchValue);
			$this->k_id_lama->PlaceHolder = ew_RemoveHtml($this->k_id_lama->FldCaption());

			// k_no_kontrak
			$this->k_no_kontrak->EditAttrs["class"] = "form-control";
			$this->k_no_kontrak->EditCustomAttributes = "";
			$this->k_no_kontrak->EditValue = ew_HtmlEncode($this->k_no_kontrak->AdvancedSearch->SearchValue);
			$this->k_no_kontrak->PlaceHolder = ew_RemoveHtml($this->k_no_kontrak->FldCaption());

			// k_luas_lahan
			$this->k_luas_lahan->EditAttrs["class"] = "form-control";
			$this->k_luas_lahan->EditCustomAttributes = "";
			$this->k_luas_lahan->EditValue = ew_HtmlEncode($this->k_luas_lahan->AdvancedSearch->SearchValue);
			$this->k_luas_lahan->PlaceHolder = ew_RemoveHtml($this->k_luas_lahan->FldCaption());

			// pet_id
			$this->pet_id->EditAttrs["class"] = "form-control";
			$this->pet_id->EditCustomAttributes = "";

			// koord_id
			$this->koord_id->EditAttrs["class"] = "form-control";
			$this->koord_id->EditCustomAttributes = "";
			if (trim(strval($this->koord_id->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`koord_id`" . ew_SearchString("=", $this->koord_id->AdvancedSearch->SearchValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `koord_id`, `koord_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `koord`";
			$sWhereWrk = "";
			$this->koord_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->koord_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `koord_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->koord_id->EditValue = $arwrk;

			// kk_id
			$this->kk_id->EditAttrs["class"] = "form-control";
			$this->kk_id->EditCustomAttributes = "";

			// prov_id
			$this->prov_id->EditAttrs["class"] = "form-control";
			$this->prov_id->EditCustomAttributes = "";
			if (trim(strval($this->prov_id->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`prov_id`" . ew_SearchString("=", $this->prov_id->AdvancedSearch->SearchValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `prov_id`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `prov`";
			$sWhereWrk = "";
			$this->prov_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->prov_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `prov_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->prov_id->EditValue = $arwrk;

			// kab_id
			$this->kab_id->EditAttrs["class"] = "form-control";
			$this->kab_id->EditCustomAttributes = "";
			if (trim(strval($this->kab_id->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`kab_id`" . ew_SearchString("=", $this->kab_id->AdvancedSearch->SearchValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `kab_id`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, `kab_prov_id` AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `kab`";
			$sWhereWrk = "";
			$this->kab_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->kab_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `kab_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->kab_id->EditValue = $arwrk;

			// kec_id
			$this->kec_id->EditAttrs["class"] = "form-control";
			$this->kec_id->EditCustomAttributes = "";
			if (trim(strval($this->kec_id->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`kec_id`" . ew_SearchString("=", $this->kec_id->AdvancedSearch->SearchValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `kec_id`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, `kec_prov_id` AS `SelectFilterFld`, `kec_kab_id` AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `kec`";
			$sWhereWrk = "";
			$this->kec_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->kec_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `kec_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->kec_id->EditValue = $arwrk;

			// desa_id
			$this->desa_id->EditAttrs["class"] = "form-control";
			$this->desa_id->EditCustomAttributes = "";
			if (trim(strval($this->desa_id->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`desa_id`" . ew_SearchString("=", $this->desa_id->AdvancedSearch->SearchValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `desa_id`, `desa_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `desa`";
			$sWhereWrk = "";
			$this->desa_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->desa_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `desa_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->desa_id->EditValue = $arwrk;

			// blok_id
			$this->blok_id->EditAttrs["class"] = "form-control";
			$this->blok_id->EditCustomAttributes = "";
			$this->blok_id->EditValue = ew_HtmlEncode($this->blok_id->AdvancedSearch->SearchValue);
			$this->blok_id->PlaceHolder = ew_RemoveHtml($this->blok_id->FldCaption());

			// sos_id
			$this->sos_id->EditAttrs["class"] = "form-control";
			$this->sos_id->EditCustomAttributes = "";
			$this->sos_id->EditValue = ew_HtmlEncode($this->sos_id->AdvancedSearch->SearchValue);
			$this->sos_id->PlaceHolder = ew_RemoveHtml($this->sos_id->FldCaption());

			// var_id
			$this->var_id->EditAttrs["class"] = "form-control";
			$this->var_id->EditCustomAttributes = "";
			if (trim(strval($this->var_id->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`var_id`" . ew_SearchString("=", $this->var_id->AdvancedSearch->SearchValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `var_id`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `varietas`";
			$sWhereWrk = "";
			$this->var_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->var_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `var_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->var_id->EditValue = $arwrk;

			// co_id
			$this->co_id->EditAttrs["class"] = "form-control";
			$this->co_id->EditCustomAttributes = "";
			if (trim(strval($this->co_id->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`co_id`" . ew_SearchString("=", $this->co_id->AdvancedSearch->SearchValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `co_id`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `co`";
			$sWhereWrk = "";
			$this->co_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->co_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `co_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->co_id->EditValue = $arwrk;

			// k_jumlah_bibit
			$this->k_jumlah_bibit->EditAttrs["class"] = "form-control";
			$this->k_jumlah_bibit->EditCustomAttributes = "";
			$this->k_jumlah_bibit->EditValue = ew_HtmlEncode($this->k_jumlah_bibit->AdvancedSearch->SearchValue);
			$this->k_jumlah_bibit->PlaceHolder = ew_RemoveHtml($this->k_jumlah_bibit->FldCaption());

			// k_asal_bibit
			$this->k_asal_bibit->EditAttrs["class"] = "form-control";
			$this->k_asal_bibit->EditCustomAttributes = "";
			$this->k_asal_bibit->EditValue = ew_HtmlEncode($this->k_asal_bibit->AdvancedSearch->SearchValue);
			$this->k_asal_bibit->PlaceHolder = ew_RemoveHtml($this->k_asal_bibit->FldCaption());

			// k_tgl_tanam
			$this->k_tgl_tanam->EditAttrs["class"] = "form-control";
			$this->k_tgl_tanam->EditCustomAttributes = "";
			$this->k_tgl_tanam->EditValue = ew_HtmlEncode(ew_FormatDateTime(ew_UnFormatDateTime($this->k_tgl_tanam->AdvancedSearch->SearchValue, 5), 5));
			$this->k_tgl_tanam->PlaceHolder = ew_RemoveHtml($this->k_tgl_tanam->FldCaption());
			$this->k_tgl_tanam->EditAttrs["class"] = "form-control";
			$this->k_tgl_tanam->EditCustomAttributes = "";
			$this->k_tgl_tanam->EditValue2 = ew_HtmlEncode(ew_FormatDateTime(ew_UnFormatDateTime($this->k_tgl_tanam->AdvancedSearch->SearchValue2, 5), 5));
			$this->k_tgl_tanam->PlaceHolder = ew_RemoveHtml($this->k_tgl_tanam->FldCaption());

			// k_es_tgl_panen
			$this->k_es_tgl_panen->EditAttrs["class"] = "form-control";
			$this->k_es_tgl_panen->EditCustomAttributes = "";
			$this->k_es_tgl_panen->EditValue = ew_HtmlEncode(ew_FormatDateTime(ew_UnFormatDateTime($this->k_es_tgl_panen->AdvancedSearch->SearchValue, 5), 5));
			$this->k_es_tgl_panen->PlaceHolder = ew_RemoveHtml($this->k_es_tgl_panen->FldCaption());
			$this->k_es_tgl_panen->EditAttrs["class"] = "form-control";
			$this->k_es_tgl_panen->EditCustomAttributes = "";
			$this->k_es_tgl_panen->EditValue2 = ew_HtmlEncode(ew_FormatDateTime(ew_UnFormatDateTime($this->k_es_tgl_panen->AdvancedSearch->SearchValue2, 5), 5));
			$this->k_es_tgl_panen->PlaceHolder = ew_RemoveHtml($this->k_es_tgl_panen->FldCaption());

			// k_ak_tgl_datang
			$this->k_ak_tgl_datang->EditAttrs["class"] = "form-control";
			$this->k_ak_tgl_datang->EditCustomAttributes = "";
			$this->k_ak_tgl_datang->EditValue = ew_HtmlEncode(ew_FormatDateTime(ew_UnFormatDateTime($this->k_ak_tgl_datang->AdvancedSearch->SearchValue, 5), 5));
			$this->k_ak_tgl_datang->PlaceHolder = ew_RemoveHtml($this->k_ak_tgl_datang->FldCaption());
			$this->k_ak_tgl_datang->EditAttrs["class"] = "form-control";
			$this->k_ak_tgl_datang->EditCustomAttributes = "";
			$this->k_ak_tgl_datang->EditValue2 = ew_HtmlEncode(ew_FormatDateTime(ew_UnFormatDateTime($this->k_ak_tgl_datang->AdvancedSearch->SearchValue2, 5), 5));
			$this->k_ak_tgl_datang->PlaceHolder = ew_RemoveHtml($this->k_ak_tgl_datang->FldCaption());

			// k_es_qty
			$this->k_es_qty->EditAttrs["class"] = "form-control";
			$this->k_es_qty->EditCustomAttributes = "";
			$this->k_es_qty->EditValue = ew_HtmlEncode($this->k_es_qty->AdvancedSearch->SearchValue);
			$this->k_es_qty->PlaceHolder = ew_RemoveHtml($this->k_es_qty->FldCaption());

			// k_ak_qty
			$this->k_ak_qty->EditAttrs["class"] = "form-control";
			$this->k_ak_qty->EditCustomAttributes = "";
			$this->k_ak_qty->EditValue = ew_HtmlEncode($this->k_ak_qty->AdvancedSearch->SearchValue);
			$this->k_ak_qty->PlaceHolder = ew_RemoveHtml($this->k_ak_qty->FldCaption());

			// k_es_perhektar
			$this->k_es_perhektar->EditAttrs["class"] = "form-control";
			$this->k_es_perhektar->EditCustomAttributes = "";
			$this->k_es_perhektar->EditValue = ew_HtmlEncode($this->k_es_perhektar->AdvancedSearch->SearchValue);
			$this->k_es_perhektar->PlaceHolder = ew_RemoveHtml($this->k_es_perhektar->FldCaption());

			// k_ak_perhektar
			$this->k_ak_perhektar->EditAttrs["class"] = "form-control";
			$this->k_ak_perhektar->EditCustomAttributes = "";
			$this->k_ak_perhektar->EditValue = ew_HtmlEncode($this->k_ak_perhektar->AdvancedSearch->SearchValue);
			$this->k_ak_perhektar->PlaceHolder = ew_RemoveHtml($this->k_ak_perhektar->FldCaption());

			// k_skor
			$this->k_skor->EditAttrs["class"] = "form-control";
			$this->k_skor->EditCustomAttributes = "";
			$this->k_skor->EditValue = ew_HtmlEncode($this->k_skor->AdvancedSearch->SearchValue);
			$this->k_skor->PlaceHolder = ew_RemoveHtml($this->k_skor->FldCaption());

			// k_ket
			$this->k_ket->EditAttrs["class"] = "form-control";
			$this->k_ket->EditCustomAttributes = "";
			$this->k_ket->EditValue = ew_HtmlEncode($this->k_ket->AdvancedSearch->SearchValue);
			$this->k_ket->PlaceHolder = ew_RemoveHtml($this->k_ket->FldCaption());

			// k_cat
			$this->k_cat->EditAttrs["class"] = "form-control";
			$this->k_cat->EditCustomAttributes = "";
			$this->k_cat->EditValue = ew_HtmlEncode($this->k_cat->AdvancedSearch->SearchValue);
			$this->k_cat->PlaceHolder = ew_RemoveHtml($this->k_cat->FldCaption());

			// k_titik_koordinat
			$this->k_titik_koordinat->EditAttrs["class"] = "form-control";
			$this->k_titik_koordinat->EditCustomAttributes = "";
			$this->k_titik_koordinat->EditValue = ew_HtmlEncode($this->k_titik_koordinat->AdvancedSearch->SearchValue);
			$this->k_titik_koordinat->PlaceHolder = ew_RemoveHtml($this->k_titik_koordinat->FldCaption());

			// k_foto_lahan
			$this->k_foto_lahan->EditAttrs["class"] = "form-control";
			$this->k_foto_lahan->EditCustomAttributes = "";
			$this->k_foto_lahan->EditValue = ew_HtmlEncode($this->k_foto_lahan->AdvancedSearch->SearchValue);
			$this->k_foto_lahan->PlaceHolder = ew_RemoveHtml($this->k_foto_lahan->FldCaption());

			// k_dok
			$this->k_dok->EditAttrs["class"] = "form-control";
			$this->k_dok->EditCustomAttributes = "";
			$this->k_dok->EditValue = ew_HtmlEncode($this->k_dok->AdvancedSearch->SearchValue);
			$this->k_dok->PlaceHolder = ew_RemoveHtml($this->k_dok->FldCaption());

			// k_harga_bibit
			$this->k_harga_bibit->EditAttrs["class"] = "form-control";
			$this->k_harga_bibit->EditCustomAttributes = "";
			$this->k_harga_bibit->EditValue = ew_HtmlEncode($this->k_harga_bibit->AdvancedSearch->SearchValue);
			$this->k_harga_bibit->PlaceHolder = ew_RemoveHtml($this->k_harga_bibit->FldCaption());

			// k_bayar_bibit
			$this->k_bayar_bibit->EditAttrs["class"] = "form-control";
			$this->k_bayar_bibit->EditCustomAttributes = "";
			$this->k_bayar_bibit->EditValue = ew_HtmlEncode($this->k_bayar_bibit->AdvancedSearch->SearchValue);
			$this->k_bayar_bibit->PlaceHolder = ew_RemoveHtml($this->k_bayar_bibit->FldCaption());

			// k_pinjaman
			$this->k_pinjaman->EditAttrs["class"] = "form-control";
			$this->k_pinjaman->EditCustomAttributes = "";
			$this->k_pinjaman->EditValue = ew_HtmlEncode($this->k_pinjaman->AdvancedSearch->SearchValue);
			$this->k_pinjaman->PlaceHolder = ew_RemoveHtml($this->k_pinjaman->FldCaption());

			// k_bayar_pinjaman
			$this->k_bayar_pinjaman->EditAttrs["class"] = "form-control";
			$this->k_bayar_pinjaman->EditCustomAttributes = "";
			$this->k_bayar_pinjaman->EditValue = ew_HtmlEncode($this->k_bayar_pinjaman->AdvancedSearch->SearchValue);
			$this->k_bayar_pinjaman->PlaceHolder = ew_RemoveHtml($this->k_bayar_pinjaman->FldCaption());

			// k_sisa_hutang
			$this->k_sisa_hutang->EditAttrs["class"] = "form-control";
			$this->k_sisa_hutang->EditCustomAttributes = "";
			$this->k_sisa_hutang->EditValue = ew_HtmlEncode($this->k_sisa_hutang->AdvancedSearch->SearchValue);
			$this->k_sisa_hutang->PlaceHolder = ew_RemoveHtml($this->k_sisa_hutang->FldCaption());
		} elseif ($this->RowType == EW_ROWTYPE_AGGREGATEINIT) { // Initialize aggregate row
			$this->k_luas_lahan->Total = 0; // Initialize total
		} elseif ($this->RowType == EW_ROWTYPE_AGGREGATE) { // Aggregate row
			$this->k_luas_lahan->CurrentValue = $this->k_luas_lahan->Total;
			$this->k_luas_lahan->ViewValue = $this->k_luas_lahan->CurrentValue;
			$this->k_luas_lahan->ViewCustomAttributes = "";
			$this->k_luas_lahan->HrefValue = ""; // Clear href value
		}
		if ($this->RowType == EW_ROWTYPE_ADD || $this->RowType == EW_ROWTYPE_EDIT || $this->RowType == EW_ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->SetupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	function ValidateSearch() {
		global $gsSearchError;

		// Initialize
		$gsSearchError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return TRUE;
		if (!ew_CheckDate($this->k_tgl_tanam->AdvancedSearch->SearchValue)) {
			ew_AddMessage($gsSearchError, $this->k_tgl_tanam->FldErrMsg());
		}
		if (!ew_CheckDate($this->k_tgl_tanam->AdvancedSearch->SearchValue2)) {
			ew_AddMessage($gsSearchError, $this->k_tgl_tanam->FldErrMsg());
		}
		if (!ew_CheckDate($this->k_es_tgl_panen->AdvancedSearch->SearchValue)) {
			ew_AddMessage($gsSearchError, $this->k_es_tgl_panen->FldErrMsg());
		}
		if (!ew_CheckDate($this->k_es_tgl_panen->AdvancedSearch->SearchValue2)) {
			ew_AddMessage($gsSearchError, $this->k_es_tgl_panen->FldErrMsg());
		}
		if (!ew_CheckDate($this->k_ak_tgl_datang->AdvancedSearch->SearchValue)) {
			ew_AddMessage($gsSearchError, $this->k_ak_tgl_datang->FldErrMsg());
		}
		if (!ew_CheckDate($this->k_ak_tgl_datang->AdvancedSearch->SearchValue2)) {
			ew_AddMessage($gsSearchError, $this->k_ak_tgl_datang->FldErrMsg());
		}

		// Return validate result
		$ValidateSearch = ($gsSearchError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateSearch = $ValidateSearch && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsSearchError, $sFormCustomError);
		}
		return $ValidateSearch;
	}

	// Load advanced search
	function LoadAdvancedSearch() {
		$this->k_id->AdvancedSearch->Load();
		$this->k_id_kontrak->AdvancedSearch->Load();
		$this->k_id_lama->AdvancedSearch->Load();
		$this->k_no_kontrak->AdvancedSearch->Load();
		$this->k_luas_lahan->AdvancedSearch->Load();
		$this->pet_id->AdvancedSearch->Load();
		$this->koord_id->AdvancedSearch->Load();
		$this->kk_id->AdvancedSearch->Load();
		$this->prov_id->AdvancedSearch->Load();
		$this->kab_id->AdvancedSearch->Load();
		$this->kec_id->AdvancedSearch->Load();
		$this->desa_id->AdvancedSearch->Load();
		$this->blok_id->AdvancedSearch->Load();
		$this->sos_id->AdvancedSearch->Load();
		$this->var_id->AdvancedSearch->Load();
		$this->co_id->AdvancedSearch->Load();
		$this->k_jumlah_bibit->AdvancedSearch->Load();
		$this->k_asal_bibit->AdvancedSearch->Load();
		$this->k_tgl_tanam->AdvancedSearch->Load();
		$this->k_es_tgl_panen->AdvancedSearch->Load();
		$this->k_ak_tgl_datang->AdvancedSearch->Load();
		$this->k_es_qty->AdvancedSearch->Load();
		$this->k_ak_qty->AdvancedSearch->Load();
		$this->k_es_perhektar->AdvancedSearch->Load();
		$this->k_ak_perhektar->AdvancedSearch->Load();
		$this->k_skor->AdvancedSearch->Load();
		$this->k_ket->AdvancedSearch->Load();
		$this->k_cat->AdvancedSearch->Load();
		$this->k_titik_koordinat->AdvancedSearch->Load();
		$this->k_foto_lahan->AdvancedSearch->Load();
		$this->k_dok->AdvancedSearch->Load();
		$this->k_harga_bibit->AdvancedSearch->Load();
		$this->k_bayar_bibit->AdvancedSearch->Load();
		$this->k_pinjaman->AdvancedSearch->Load();
		$this->k_bayar_pinjaman->AdvancedSearch->Load();
		$this->k_sisa_hutang->AdvancedSearch->Load();
	}

	// Set up export options
	function SetupExportOptions() {
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->Add("print");
		$item->Body = "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ewExportLink ewPrint\" title=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\">" . $Language->Phrase("PrinterFriendly") . "</a>";
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->Add("excel");
		$item->Body = "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ewExportLink ewExcel\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\">" . $Language->Phrase("ExportToExcel") . "</a>";
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->Add("word");
		$item->Body = "<a href=\"" . $this->ExportWordUrl . "\" class=\"ewExportLink ewWord\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\">" . $Language->Phrase("ExportToWord") . "</a>";
		$item->Visible = TRUE;

		// Export to Html
		$item = &$this->ExportOptions->Add("html");
		$item->Body = "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ewExportLink ewHtml\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\">" . $Language->Phrase("ExportToHtml") . "</a>";
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->Add("xml");
		$item->Body = "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ewExportLink ewXml\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\">" . $Language->Phrase("ExportToXml") . "</a>";
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->Add("csv");
		$item->Body = "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ewExportLink ewCsv\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\">" . $Language->Phrase("ExportToCsv") . "</a>";
		$item->Visible = FALSE;

		// Export to Pdf
		$item = &$this->ExportOptions->Add("pdf");
		$item->Body = "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ewExportLink ewPdf\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\">" . $Language->Phrase("ExportToPDF") . "</a>";
		$item->Visible = FALSE;

		// Export to Email
		$item = &$this->ExportOptions->Add("email");
		$url = "";
		$item->Body = "<button id=\"emf_kontrak\" class=\"ewExportLink ewEmail\" title=\"" . $Language->Phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->Phrase("ExportToEmailText") . "\" onclick=\"ew_EmailDialogShow({lnk:'emf_kontrak',hdr:ewLanguage.Phrase('ExportToEmailText'),f:document.fkontraklist,sel:false" . $url . "});\">" . $Language->Phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseImageAndText = TRUE;
		$this->ExportOptions->UseDropDownButton = FALSE;
		if ($this->ExportOptions->UseButtonGroup && ew_IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->Phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->Add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	function ExportData() {
		$utf8 = (strtolower(EW_CHARSET) == "utf-8");
		$bSelectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($bSelectLimit) {
			$this->TotalRecs = $this->ListRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->LoadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EW_EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->SetupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($bSelectLimit)
			$rs = $this->LoadRecordset($this->StartRec-1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		if (!$rs) {
			header("Content-Type:"); // Remove header
			header("Content-Disposition:");
			$this->ShowMessage();
			return;
		}
		$this->ExportDoc = ew_ExportDocument($this, "h");
		$Doc = &$this->ExportDoc;
		if ($bSelectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		} else {

			//$this->StartRec = $this->StartRec;
			//$this->StopRec = $this->StopRec;

		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$ParentTable = "";
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		$Doc->Text .= $sHeader;
		$this->ExportDocument($Doc, $rs, $this->StartRec, $this->StopRec, "");
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		$Doc->Text .= $sFooter;

		// Close recordset
		$rs->Close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$Doc->ExportHeaderAndFooter();

		// Clean output buffer
		if (!EW_DEBUG_ENABLED && ob_get_length())
			ob_end_clean();

		// Write debug message if enabled
		if (EW_DEBUG_ENABLED && $this->Export <> "pdf")
			echo ew_DebugMsg();

		// Output data
		$Doc->Export();
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->Add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup filters of a field
	function SetupLookupFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		if ($pageId == "list") {
			switch ($fld->FldVar) {
			}
		} elseif ($pageId == "extbs") {
			switch ($fld->FldVar) {
		case "x_koord_id":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `koord_id` AS `LinkFld`, `koord_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `koord`";
				$sWhereWrk = "";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`koord_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->koord_id, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$sSqlWrk .= " ORDER BY `koord_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_prov_id":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `prov_id` AS `LinkFld`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `prov`";
				$sWhereWrk = "";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`prov_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->prov_id, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$sSqlWrk .= " ORDER BY `prov_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_kab_id":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `kab_id` AS `LinkFld`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kab`";
				$sWhereWrk = "{filter}";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`kab_id` IN ({filter_value})', "t0" => "3", "fn0" => "", "f1" => '`kab_prov_id` IN ({filter_value})', "t1" => "3", "fn1" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->kab_id, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$sSqlWrk .= " ORDER BY `kab_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_kec_id":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `kec_id` AS `LinkFld`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kec`";
				$sWhereWrk = "{filter}";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`kec_id` IN ({filter_value})', "t0" => "3", "fn0" => "", "f1" => '`kec_prov_id` IN ({filter_value})', "t1" => "3", "fn1" => "", "f2" => '`kec_kab_id` IN ({filter_value})', "t2" => "3", "fn2" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->kec_id, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$sSqlWrk .= " ORDER BY `kec_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_desa_id":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `desa_id` AS `LinkFld`, `desa_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `desa`";
				$sWhereWrk = "";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`desa_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->desa_id, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$sSqlWrk .= " ORDER BY `desa_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_var_id":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `var_id` AS `LinkFld`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `varietas`";
				$sWhereWrk = "";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`var_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->var_id, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$sSqlWrk .= " ORDER BY `var_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_co_id":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `co_id` AS `LinkFld`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `co`";
				$sWhereWrk = "";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`co_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->co_id, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$sSqlWrk .= " ORDER BY `co_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
			}
		}
	}

	// Setup AutoSuggest filters of a field
	function SetupAutoSuggestFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		if ($pageId == "list") {
			switch ($fld->FldVar) {
			}
		} elseif ($pageId == "extbs") {
			switch ($fld->FldVar) {
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($kontrak_list)) $kontrak_list = new ckontrak_list();

// Page init
$kontrak_list->Page_Init();

// Page main
$kontrak_list->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$kontrak_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if ($kontrak->Export == "") { ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "list";
var CurrentForm = fkontraklist = new ew_Form("fkontraklist", "list");
fkontraklist.FormKeyCountName = '<?php echo $kontrak_list->FormKeyCountName ?>';

// Form_CustomValidate event
fkontraklist.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fkontraklist.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fkontraklist.Lists["x_pet_id"] = {"LinkField":"x_pet_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_pet_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"petani"};
fkontraklist.Lists["x_pet_id"].Data = "<?php echo $kontrak_list->pet_id->LookupFilterQuery(FALSE, "list") ?>";
fkontraklist.Lists["x_koord_id"] = {"LinkField":"x_koord_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_koord_nama","","",""],"ParentFields":[],"ChildFields":["x_kk_id"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"koord"};
fkontraklist.Lists["x_koord_id"].Data = "<?php echo $kontrak_list->koord_id->LookupFilterQuery(FALSE, "list") ?>";
fkontraklist.Lists["x_kk_id"] = {"LinkField":"x_kk_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kk_periode","x_kk_tgl_mulai","x_kk_tgl_akhir",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kontrak_koord"};
fkontraklist.Lists["x_kk_id"].Data = "<?php echo $kontrak_list->kk_id->LookupFilterQuery(FALSE, "list") ?>";
fkontraklist.Lists["x_prov_id"] = {"LinkField":"x_prov_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_prov_nama","","",""],"ParentFields":[],"ChildFields":["x_kab_id","x_kec_id"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"prov"};
fkontraklist.Lists["x_prov_id"].Data = "<?php echo $kontrak_list->prov_id->LookupFilterQuery(FALSE, "list") ?>";
fkontraklist.Lists["x_kab_id"] = {"LinkField":"x_kab_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kab_nama","","",""],"ParentFields":[],"ChildFields":["x_kec_id"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kab"};
fkontraklist.Lists["x_kab_id"].Data = "<?php echo $kontrak_list->kab_id->LookupFilterQuery(FALSE, "list") ?>";
fkontraklist.Lists["x_kec_id"] = {"LinkField":"x_kec_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kec_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kec"};
fkontraklist.Lists["x_kec_id"].Data = "<?php echo $kontrak_list->kec_id->LookupFilterQuery(FALSE, "list") ?>";
fkontraklist.Lists["x_desa_id"] = {"LinkField":"x_desa_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_desa_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"desa"};
fkontraklist.Lists["x_desa_id"].Data = "<?php echo $kontrak_list->desa_id->LookupFilterQuery(FALSE, "list") ?>";
fkontraklist.Lists["x_blok_id"] = {"LinkField":"x_blok_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_blok_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"blok"};
fkontraklist.Lists["x_blok_id"].Data = "<?php echo $kontrak_list->blok_id->LookupFilterQuery(FALSE, "list") ?>";
fkontraklist.Lists["x_sos_id"] = {"LinkField":"x_sos_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_sos_id","x_sos_tgl","x_sos_alamat",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"sosialisasi"};
fkontraklist.Lists["x_sos_id"].Data = "<?php echo $kontrak_list->sos_id->LookupFilterQuery(FALSE, "list") ?>";
fkontraklist.Lists["x_var_id"] = {"LinkField":"x_var_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_var_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"varietas"};
fkontraklist.Lists["x_var_id"].Data = "<?php echo $kontrak_list->var_id->LookupFilterQuery(FALSE, "list") ?>";
fkontraklist.Lists["x_co_id"] = {"LinkField":"x_co_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_co_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"co"};
fkontraklist.Lists["x_co_id"].Data = "<?php echo $kontrak_list->co_id->LookupFilterQuery(FALSE, "list") ?>";

// Form object for search
var CurrentSearchForm = fkontraklistsrch = new ew_Form("fkontraklistsrch");

// Validate function for search
fkontraklistsrch.Validate = function(fobj) {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	fobj = fobj || this.Form;
	var infix = "";
	elm = this.GetElements("x" + infix + "_k_tgl_tanam");
	if (elm && !ew_CheckDate(elm.value))
		return this.OnError(elm, "<?php echo ew_JsEncode2($kontrak->k_tgl_tanam->FldErrMsg()) ?>");
	elm = this.GetElements("x" + infix + "_k_es_tgl_panen");
	if (elm && !ew_CheckDate(elm.value))
		return this.OnError(elm, "<?php echo ew_JsEncode2($kontrak->k_es_tgl_panen->FldErrMsg()) ?>");
	elm = this.GetElements("x" + infix + "_k_ak_tgl_datang");
	if (elm && !ew_CheckDate(elm.value))
		return this.OnError(elm, "<?php echo ew_JsEncode2($kontrak->k_ak_tgl_datang->FldErrMsg()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fkontraklistsrch.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fkontraklistsrch.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fkontraklistsrch.Lists["x_koord_id"] = {"LinkField":"x_koord_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_koord_nama","","",""],"ParentFields":[],"ChildFields":["x_kk_id"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"koord"};
fkontraklistsrch.Lists["x_koord_id"].Data = "<?php echo $kontrak_list->koord_id->LookupFilterQuery(FALSE, "extbs") ?>";
fkontraklistsrch.Lists["x_prov_id"] = {"LinkField":"x_prov_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_prov_nama","","",""],"ParentFields":[],"ChildFields":["x_kab_id","x_kec_id"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"prov"};
fkontraklistsrch.Lists["x_prov_id"].Data = "<?php echo $kontrak_list->prov_id->LookupFilterQuery(FALSE, "extbs") ?>";
fkontraklistsrch.Lists["x_kab_id"] = {"LinkField":"x_kab_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kab_nama","","",""],"ParentFields":["x_prov_id"],"ChildFields":["x_kec_id"],"FilterFields":["x_kab_prov_id"],"Options":[],"Template":"","LinkTable":"kab"};
fkontraklistsrch.Lists["x_kab_id"].Data = "<?php echo $kontrak_list->kab_id->LookupFilterQuery(FALSE, "extbs") ?>";
fkontraklistsrch.Lists["x_kec_id"] = {"LinkField":"x_kec_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kec_nama","","",""],"ParentFields":["x_prov_id","x_kab_id"],"ChildFields":[],"FilterFields":["x_kec_prov_id","x_kec_kab_id"],"Options":[],"Template":"","LinkTable":"kec"};
fkontraklistsrch.Lists["x_kec_id"].Data = "<?php echo $kontrak_list->kec_id->LookupFilterQuery(FALSE, "extbs") ?>";
fkontraklistsrch.Lists["x_desa_id"] = {"LinkField":"x_desa_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_desa_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"desa"};
fkontraklistsrch.Lists["x_desa_id"].Data = "<?php echo $kontrak_list->desa_id->LookupFilterQuery(FALSE, "extbs") ?>";
fkontraklistsrch.Lists["x_var_id"] = {"LinkField":"x_var_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_var_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"varietas"};
fkontraklistsrch.Lists["x_var_id"].Data = "<?php echo $kontrak_list->var_id->LookupFilterQuery(FALSE, "extbs") ?>";
fkontraklistsrch.Lists["x_co_id"] = {"LinkField":"x_co_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_co_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"co"};
fkontraklistsrch.Lists["x_co_id"].Data = "<?php echo $kontrak_list->co_id->LookupFilterQuery(FALSE, "extbs") ?>";

// Init search panel as collapsed
if (fkontraklistsrch) fkontraklistsrch.InitSearchPanel = true;
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if ($kontrak->Export == "") { ?>
<div class="ewToolbar">
<?php if ($kontrak_list->TotalRecs > 0 && $kontrak_list->ExportOptions->Visible()) { ?>
<?php $kontrak_list->ExportOptions->Render("body") ?>
<?php } ?>
<?php if ($kontrak_list->SearchOptions->Visible()) { ?>
<?php $kontrak_list->SearchOptions->Render("body") ?>
<?php } ?>
<?php if ($kontrak_list->FilterOptions->Visible()) { ?>
<?php $kontrak_list->FilterOptions->Render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
	$bSelectLimit = $kontrak_list->UseSelectLimit;
	if ($bSelectLimit) {
		if ($kontrak_list->TotalRecs <= 0)
			$kontrak_list->TotalRecs = $kontrak->ListRecordCount();
	} else {
		if (!$kontrak_list->Recordset && ($kontrak_list->Recordset = $kontrak_list->LoadRecordset()))
			$kontrak_list->TotalRecs = $kontrak_list->Recordset->RecordCount();
	}
	$kontrak_list->StartRec = 1;
	if ($kontrak_list->DisplayRecs <= 0 || ($kontrak->Export <> "" && $kontrak->ExportAll)) // Display all records
		$kontrak_list->DisplayRecs = $kontrak_list->TotalRecs;
	if (!($kontrak->Export <> "" && $kontrak->ExportAll))
		$kontrak_list->SetupStartRec(); // Set up start record position
	if ($bSelectLimit)
		$kontrak_list->Recordset = $kontrak_list->LoadRecordset($kontrak_list->StartRec-1, $kontrak_list->DisplayRecs);

	// Set no record found message
	if ($kontrak->CurrentAction == "" && $kontrak_list->TotalRecs == 0) {
		if (!$Security->CanList())
			$kontrak_list->setWarningMessage(ew_DeniedMsg());
		if ($kontrak_list->SearchWhere == "0=101")
			$kontrak_list->setWarningMessage($Language->Phrase("EnterSearchCriteria"));
		else
			$kontrak_list->setWarningMessage($Language->Phrase("NoRecord"));
	}
$kontrak_list->RenderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if ($kontrak->Export == "" && $kontrak->CurrentAction == "") { ?>
<form name="fkontraklistsrch" id="fkontraklistsrch" class="form-inline ewForm ewExtSearchForm" action="<?php echo ew_CurrentPage() ?>">
<?php $SearchPanelClass = ($kontrak_list->SearchWhere <> "") ? " in" : ""; ?>
<div id="fkontraklistsrch_SearchPanel" class="ewSearchPanel collapse<?php echo $SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="kontrak">
	<div class="ewBasicSearch">
<?php
if ($gsSearchError == "")
	$kontrak_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$kontrak->RowType = EW_ROWTYPE_SEARCH;

// Render row
$kontrak->ResetAttrs();
$kontrak_list->RenderRow();
?>
<div id="xsr_1" class="ewRow">
<?php if ($kontrak->koord_id->Visible) { // koord_id ?>
	<div id="xsc_koord_id" class="ewCell form-group">
		<label for="x_koord_id" class="ewSearchCaption ewLabel"><?php echo $kontrak->koord_id->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_koord_id" id="z_koord_id" value="="></span>
		<span class="ewSearchField">
<select data-table="kontrak" data-field="x_koord_id" data-value-separator="<?php echo $kontrak->koord_id->DisplayValueSeparatorAttribute() ?>" id="x_koord_id" name="x_koord_id"<?php echo $kontrak->koord_id->EditAttributes() ?>>
<?php echo $kontrak->koord_id->SelectOptionListHtml("x_koord_id") ?>
</select>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ewRow">
<?php if ($kontrak->prov_id->Visible) { // prov_id ?>
	<div id="xsc_prov_id" class="ewCell form-group">
		<label for="x_prov_id" class="ewSearchCaption ewLabel"><?php echo $kontrak->prov_id->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_prov_id" id="z_prov_id" value="="></span>
		<span class="ewSearchField">
<?php $kontrak->prov_id->EditAttrs["onchange"] = "ew_UpdateOpt.call(this); " . @$kontrak->prov_id->EditAttrs["onchange"]; ?>
<select data-table="kontrak" data-field="x_prov_id" data-value-separator="<?php echo $kontrak->prov_id->DisplayValueSeparatorAttribute() ?>" id="x_prov_id" name="x_prov_id"<?php echo $kontrak->prov_id->EditAttributes() ?>>
<?php echo $kontrak->prov_id->SelectOptionListHtml("x_prov_id") ?>
</select>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ewRow">
<?php if ($kontrak->kab_id->Visible) { // kab_id ?>
	<div id="xsc_kab_id" class="ewCell form-group">
		<label for="x_kab_id" class="ewSearchCaption ewLabel"><?php echo $kontrak->kab_id->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_kab_id" id="z_kab_id" value="="></span>
		<span class="ewSearchField">
<?php $kontrak->kab_id->EditAttrs["onchange"] = "ew_UpdateOpt.call(this); " . @$kontrak->kab_id->EditAttrs["onchange"]; ?>
<select data-table="kontrak" data-field="x_kab_id" data-value-separator="<?php echo $kontrak->kab_id->DisplayValueSeparatorAttribute() ?>" id="x_kab_id" name="x_kab_id"<?php echo $kontrak->kab_id->EditAttributes() ?>>
<?php echo $kontrak->kab_id->SelectOptionListHtml("x_kab_id") ?>
</select>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ewRow">
<?php if ($kontrak->kec_id->Visible) { // kec_id ?>
	<div id="xsc_kec_id" class="ewCell form-group">
		<label for="x_kec_id" class="ewSearchCaption ewLabel"><?php echo $kontrak->kec_id->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_kec_id" id="z_kec_id" value="="></span>
		<span class="ewSearchField">
<select data-table="kontrak" data-field="x_kec_id" data-value-separator="<?php echo $kontrak->kec_id->DisplayValueSeparatorAttribute() ?>" id="x_kec_id" name="x_kec_id"<?php echo $kontrak->kec_id->EditAttributes() ?>>
<?php echo $kontrak->kec_id->SelectOptionListHtml("x_kec_id") ?>
</select>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_5" class="ewRow">
<?php if ($kontrak->desa_id->Visible) { // desa_id ?>
	<div id="xsc_desa_id" class="ewCell form-group">
		<label for="x_desa_id" class="ewSearchCaption ewLabel"><?php echo $kontrak->desa_id->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_desa_id" id="z_desa_id" value="="></span>
		<span class="ewSearchField">
<select data-table="kontrak" data-field="x_desa_id" data-value-separator="<?php echo $kontrak->desa_id->DisplayValueSeparatorAttribute() ?>" id="x_desa_id" name="x_desa_id"<?php echo $kontrak->desa_id->EditAttributes() ?>>
<?php echo $kontrak->desa_id->SelectOptionListHtml("x_desa_id") ?>
</select>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_6" class="ewRow">
<?php if ($kontrak->var_id->Visible) { // var_id ?>
	<div id="xsc_var_id" class="ewCell form-group">
		<label for="x_var_id" class="ewSearchCaption ewLabel"><?php echo $kontrak->var_id->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_var_id" id="z_var_id" value="="></span>
		<span class="ewSearchField">
<select data-table="kontrak" data-field="x_var_id" data-value-separator="<?php echo $kontrak->var_id->DisplayValueSeparatorAttribute() ?>" id="x_var_id" name="x_var_id"<?php echo $kontrak->var_id->EditAttributes() ?>>
<?php echo $kontrak->var_id->SelectOptionListHtml("x_var_id") ?>
</select>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_7" class="ewRow">
<?php if ($kontrak->co_id->Visible) { // co_id ?>
	<div id="xsc_co_id" class="ewCell form-group">
		<label for="x_co_id" class="ewSearchCaption ewLabel"><?php echo $kontrak->co_id->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_co_id" id="z_co_id" value="="></span>
		<span class="ewSearchField">
<select data-table="kontrak" data-field="x_co_id" data-value-separator="<?php echo $kontrak->co_id->DisplayValueSeparatorAttribute() ?>" id="x_co_id" name="x_co_id"<?php echo $kontrak->co_id->EditAttributes() ?>>
<?php echo $kontrak->co_id->SelectOptionListHtml("x_co_id") ?>
</select>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_8" class="ewRow">
<?php if ($kontrak->k_tgl_tanam->Visible) { // k_tgl_tanam ?>
	<div id="xsc_k_tgl_tanam" class="ewCell form-group">
		<label for="x_k_tgl_tanam" class="ewSearchCaption ewLabel"><?php echo $kontrak->k_tgl_tanam->FldCaption() ?></label>
		<span class="ewSearchOperator"><select name="z_k_tgl_tanam" id="z_k_tgl_tanam" class="form-control" onchange="ewForms(this).SrchOprChanged(this);"><option value="="<?php echo ($kontrak->k_tgl_tanam->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->Phrase("EQUAL") ?></option><option value="<>"<?php echo ($kontrak->k_tgl_tanam->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->Phrase("<>") ?></option><option value="<"<?php echo ($kontrak->k_tgl_tanam->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->Phrase("<") ?></option><option value="<="<?php echo ($kontrak->k_tgl_tanam->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->Phrase("<=") ?></option><option value=">"<?php echo ($kontrak->k_tgl_tanam->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->Phrase(">") ?></option><option value=">="<?php echo ($kontrak->k_tgl_tanam->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->Phrase(">=") ?></option><option value="IS NULL"<?php echo ($kontrak->k_tgl_tanam->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->Phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($kontrak->k_tgl_tanam->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->Phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($kontrak->k_tgl_tanam->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->Phrase("BETWEEN") ?></option></select></span>
		<span class="ewSearchField">
<input type="text" data-table="kontrak" data-field="x_k_tgl_tanam" data-format="5" name="x_k_tgl_tanam" id="x_k_tgl_tanam" placeholder="<?php echo ew_HtmlEncode($kontrak->k_tgl_tanam->getPlaceHolder()) ?>" value="<?php echo $kontrak->k_tgl_tanam->EditValue ?>"<?php echo $kontrak->k_tgl_tanam->EditAttributes() ?>>
<?php if (!$kontrak->k_tgl_tanam->ReadOnly && !$kontrak->k_tgl_tanam->Disabled && !isset($kontrak->k_tgl_tanam->EditAttrs["readonly"]) && !isset($kontrak->k_tgl_tanam->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("fkontraklistsrch", "x_k_tgl_tanam", {"ignoreReadonly":true,"useCurrent":false,"format":5});
</script>
<?php } ?>
</span>
		<span class="ewSearchCond btw1_k_tgl_tanam" style="display: none">&nbsp;<?php echo $Language->Phrase("AND") ?>&nbsp;</span>
		<span class="ewSearchField btw1_k_tgl_tanam" style="display: none">
<input type="text" data-table="kontrak" data-field="x_k_tgl_tanam" data-format="5" name="y_k_tgl_tanam" id="y_k_tgl_tanam" placeholder="<?php echo ew_HtmlEncode($kontrak->k_tgl_tanam->getPlaceHolder()) ?>" value="<?php echo $kontrak->k_tgl_tanam->EditValue2 ?>"<?php echo $kontrak->k_tgl_tanam->EditAttributes() ?>>
<?php if (!$kontrak->k_tgl_tanam->ReadOnly && !$kontrak->k_tgl_tanam->Disabled && !isset($kontrak->k_tgl_tanam->EditAttrs["readonly"]) && !isset($kontrak->k_tgl_tanam->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("fkontraklistsrch", "y_k_tgl_tanam", {"ignoreReadonly":true,"useCurrent":false,"format":5});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_9" class="ewRow">
<?php if ($kontrak->k_es_tgl_panen->Visible) { // k_es_tgl_panen ?>
	<div id="xsc_k_es_tgl_panen" class="ewCell form-group">
		<label for="x_k_es_tgl_panen" class="ewSearchCaption ewLabel"><?php echo $kontrak->k_es_tgl_panen->FldCaption() ?></label>
		<span class="ewSearchOperator"><select name="z_k_es_tgl_panen" id="z_k_es_tgl_panen" class="form-control" onchange="ewForms(this).SrchOprChanged(this);"><option value="="<?php echo ($kontrak->k_es_tgl_panen->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->Phrase("EQUAL") ?></option><option value="<>"<?php echo ($kontrak->k_es_tgl_panen->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->Phrase("<>") ?></option><option value="<"<?php echo ($kontrak->k_es_tgl_panen->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->Phrase("<") ?></option><option value="<="<?php echo ($kontrak->k_es_tgl_panen->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->Phrase("<=") ?></option><option value=">"<?php echo ($kontrak->k_es_tgl_panen->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->Phrase(">") ?></option><option value=">="<?php echo ($kontrak->k_es_tgl_panen->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->Phrase(">=") ?></option><option value="IS NULL"<?php echo ($kontrak->k_es_tgl_panen->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->Phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($kontrak->k_es_tgl_panen->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->Phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($kontrak->k_es_tgl_panen->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->Phrase("BETWEEN") ?></option></select></span>
		<span class="ewSearchField">
<input type="text" data-table="kontrak" data-field="x_k_es_tgl_panen" data-format="5" name="x_k_es_tgl_panen" id="x_k_es_tgl_panen" placeholder="<?php echo ew_HtmlEncode($kontrak->k_es_tgl_panen->getPlaceHolder()) ?>" value="<?php echo $kontrak->k_es_tgl_panen->EditValue ?>"<?php echo $kontrak->k_es_tgl_panen->EditAttributes() ?>>
<?php if (!$kontrak->k_es_tgl_panen->ReadOnly && !$kontrak->k_es_tgl_panen->Disabled && !isset($kontrak->k_es_tgl_panen->EditAttrs["readonly"]) && !isset($kontrak->k_es_tgl_panen->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("fkontraklistsrch", "x_k_es_tgl_panen", {"ignoreReadonly":true,"useCurrent":false,"format":5});
</script>
<?php } ?>
</span>
		<span class="ewSearchCond btw1_k_es_tgl_panen" style="display: none">&nbsp;<?php echo $Language->Phrase("AND") ?>&nbsp;</span>
		<span class="ewSearchField btw1_k_es_tgl_panen" style="display: none">
<input type="text" data-table="kontrak" data-field="x_k_es_tgl_panen" data-format="5" name="y_k_es_tgl_panen" id="y_k_es_tgl_panen" placeholder="<?php echo ew_HtmlEncode($kontrak->k_es_tgl_panen->getPlaceHolder()) ?>" value="<?php echo $kontrak->k_es_tgl_panen->EditValue2 ?>"<?php echo $kontrak->k_es_tgl_panen->EditAttributes() ?>>
<?php if (!$kontrak->k_es_tgl_panen->ReadOnly && !$kontrak->k_es_tgl_panen->Disabled && !isset($kontrak->k_es_tgl_panen->EditAttrs["readonly"]) && !isset($kontrak->k_es_tgl_panen->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("fkontraklistsrch", "y_k_es_tgl_panen", {"ignoreReadonly":true,"useCurrent":false,"format":5});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_10" class="ewRow">
<?php if ($kontrak->k_ak_tgl_datang->Visible) { // k_ak_tgl_datang ?>
	<div id="xsc_k_ak_tgl_datang" class="ewCell form-group">
		<label for="x_k_ak_tgl_datang" class="ewSearchCaption ewLabel"><?php echo $kontrak->k_ak_tgl_datang->FldCaption() ?></label>
		<span class="ewSearchOperator"><select name="z_k_ak_tgl_datang" id="z_k_ak_tgl_datang" class="form-control" onchange="ewForms(this).SrchOprChanged(this);"><option value="="<?php echo ($kontrak->k_ak_tgl_datang->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->Phrase("EQUAL") ?></option><option value="<>"<?php echo ($kontrak->k_ak_tgl_datang->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->Phrase("<>") ?></option><option value="<"<?php echo ($kontrak->k_ak_tgl_datang->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->Phrase("<") ?></option><option value="<="<?php echo ($kontrak->k_ak_tgl_datang->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->Phrase("<=") ?></option><option value=">"<?php echo ($kontrak->k_ak_tgl_datang->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->Phrase(">") ?></option><option value=">="<?php echo ($kontrak->k_ak_tgl_datang->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->Phrase(">=") ?></option><option value="IS NULL"<?php echo ($kontrak->k_ak_tgl_datang->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->Phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($kontrak->k_ak_tgl_datang->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->Phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($kontrak->k_ak_tgl_datang->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->Phrase("BETWEEN") ?></option></select></span>
		<span class="ewSearchField">
<input type="text" data-table="kontrak" data-field="x_k_ak_tgl_datang" data-format="5" name="x_k_ak_tgl_datang" id="x_k_ak_tgl_datang" placeholder="<?php echo ew_HtmlEncode($kontrak->k_ak_tgl_datang->getPlaceHolder()) ?>" value="<?php echo $kontrak->k_ak_tgl_datang->EditValue ?>"<?php echo $kontrak->k_ak_tgl_datang->EditAttributes() ?>>
<?php if (!$kontrak->k_ak_tgl_datang->ReadOnly && !$kontrak->k_ak_tgl_datang->Disabled && !isset($kontrak->k_ak_tgl_datang->EditAttrs["readonly"]) && !isset($kontrak->k_ak_tgl_datang->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("fkontraklistsrch", "x_k_ak_tgl_datang", {"ignoreReadonly":true,"useCurrent":false,"format":5});
</script>
<?php } ?>
</span>
		<span class="ewSearchCond btw1_k_ak_tgl_datang" style="display: none">&nbsp;<?php echo $Language->Phrase("AND") ?>&nbsp;</span>
		<span class="ewSearchField btw1_k_ak_tgl_datang" style="display: none">
<input type="text" data-table="kontrak" data-field="x_k_ak_tgl_datang" data-format="5" name="y_k_ak_tgl_datang" id="y_k_ak_tgl_datang" placeholder="<?php echo ew_HtmlEncode($kontrak->k_ak_tgl_datang->getPlaceHolder()) ?>" value="<?php echo $kontrak->k_ak_tgl_datang->EditValue2 ?>"<?php echo $kontrak->k_ak_tgl_datang->EditAttributes() ?>>
<?php if (!$kontrak->k_ak_tgl_datang->ReadOnly && !$kontrak->k_ak_tgl_datang->Disabled && !isset($kontrak->k_ak_tgl_datang->EditAttrs["readonly"]) && !isset($kontrak->k_ak_tgl_datang->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("fkontraklistsrch", "y_k_ak_tgl_datang", {"ignoreReadonly":true,"useCurrent":false,"format":5});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_11" class="ewRow">
	<div class="ewQuickSearch input-group">
	<input type="text" name="<?php echo EW_TABLE_BASIC_SEARCH ?>" id="<?php echo EW_TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo ew_HtmlEncode($kontrak_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo ew_HtmlEncode($Language->Phrase("Search")) ?>">
	<input type="hidden" name="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo ew_HtmlEncode($kontrak_list->BasicSearch->getType()) ?>">
	<div class="input-group-btn">
		<button type="button" data-toggle="dropdown" class="btn btn-default"><span id="searchtype"><?php echo $kontrak_list->BasicSearch->getTypeNameShort() ?></span><span class="caret"></span></button>
		<ul class="dropdown-menu pull-right" role="menu">
			<li<?php if ($kontrak_list->BasicSearch->getType() == "") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this)"><?php echo $Language->Phrase("QuickSearchAuto") ?></a></li>
			<li<?php if ($kontrak_list->BasicSearch->getType() == "=") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'=')"><?php echo $Language->Phrase("QuickSearchExact") ?></a></li>
			<li<?php if ($kontrak_list->BasicSearch->getType() == "AND") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'AND')"><?php echo $Language->Phrase("QuickSearchAll") ?></a></li>
			<li<?php if ($kontrak_list->BasicSearch->getType() == "OR") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'OR')"><?php echo $Language->Phrase("QuickSearchAny") ?></a></li>
		</ul>
	<button class="btn btn-primary ewButton" name="btnsubmit" id="btnsubmit" type="submit"><?php echo $Language->Phrase("SearchBtn") ?></button>
	</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $kontrak_list->ShowPageHeader(); ?>
<?php
$kontrak_list->ShowMessage();
?>
<?php if ($kontrak_list->TotalRecs > 0 || $kontrak->CurrentAction <> "") { ?>
<div class="box ewBox ewGrid<?php if ($kontrak_list->IsAddOrEdit()) { ?> ewGridAddEdit<?php } ?> kontrak">
<?php if ($kontrak->Export == "") { ?>
<div class="box-header ewGridUpperPanel">
<?php if ($kontrak->CurrentAction <> "gridadd" && $kontrak->CurrentAction <> "gridedit") { ?>
<form name="ewPagerForm" class="form-inline ewForm ewPagerForm" action="<?php echo ew_CurrentPage() ?>">
<?php if (!isset($kontrak_list->Pager)) $kontrak_list->Pager = new cNumericPager($kontrak_list->StartRec, $kontrak_list->DisplayRecs, $kontrak_list->TotalRecs, $kontrak_list->RecRange, $kontrak_list->AutoHidePager) ?>
<?php if ($kontrak_list->Pager->RecordCount > 0 && $kontrak_list->Pager->Visible) { ?>
<div class="ewPager">
<div class="ewNumericPage"><ul class="pagination">
	<?php if ($kontrak_list->Pager->FirstButton->Enabled) { ?>
	<li><a href="<?php echo $kontrak_list->PageUrl() ?>start=<?php echo $kontrak_list->Pager->FirstButton->Start ?>"><?php echo $Language->Phrase("PagerFirst") ?></a></li>
	<?php } ?>
	<?php if ($kontrak_list->Pager->PrevButton->Enabled) { ?>
	<li><a href="<?php echo $kontrak_list->PageUrl() ?>start=<?php echo $kontrak_list->Pager->PrevButton->Start ?>"><?php echo $Language->Phrase("PagerPrevious") ?></a></li>
	<?php } ?>
	<?php foreach ($kontrak_list->Pager->Items as $PagerItem) { ?>
		<li<?php if (!$PagerItem->Enabled) { echo " class=\" active\""; } ?>><a href="<?php if ($PagerItem->Enabled) { echo $kontrak_list->PageUrl() . "start=" . $PagerItem->Start; } else { echo "#"; } ?>"><?php echo $PagerItem->Text ?></a></li>
	<?php } ?>
	<?php if ($kontrak_list->Pager->NextButton->Enabled) { ?>
	<li><a href="<?php echo $kontrak_list->PageUrl() ?>start=<?php echo $kontrak_list->Pager->NextButton->Start ?>"><?php echo $Language->Phrase("PagerNext") ?></a></li>
	<?php } ?>
	<?php if ($kontrak_list->Pager->LastButton->Enabled) { ?>
	<li><a href="<?php echo $kontrak_list->PageUrl() ?>start=<?php echo $kontrak_list->Pager->LastButton->Start ?>"><?php echo $Language->Phrase("PagerLast") ?></a></li>
	<?php } ?>
</ul></div>
</div>
<?php } ?>
<?php if ($kontrak_list->Pager->RecordCount > 0) { ?>
<div class="ewPager ewRec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $kontrak_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $kontrak_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $kontrak_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ewListOtherOptions">
<?php
	foreach ($kontrak_list->OtherOptions as &$option)
		$option->Render("body");
?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fkontraklist" id="fkontraklist" class="form-inline ewForm ewListForm" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($kontrak_list->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $kontrak_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="kontrak">
<div id="gmp_kontrak" class="<?php if (ew_IsResponsiveLayout()) { ?>table-responsive <?php } ?>ewGridMiddlePanel">
<?php if ($kontrak_list->TotalRecs > 0 || $kontrak->CurrentAction == "gridedit") { ?>
<table id="tbl_kontraklist" class="table ewTable">
<thead>
	<tr class="ewTableHeader">
<?php

// Header row
$kontrak_list->RowType = EW_ROWTYPE_HEADER;

// Render list options
$kontrak_list->RenderListOptions();

// Render list options (header, left)
$kontrak_list->ListOptions->Render("header", "left");
?>
<?php if ($kontrak->k_id_kontrak->Visible) { // k_id_kontrak ?>
	<?php if ($kontrak->SortUrl($kontrak->k_id_kontrak) == "") { ?>
		<th data-name="k_id_kontrak" class="<?php echo $kontrak->k_id_kontrak->HeaderCellClass() ?>"><div id="elh_kontrak_k_id_kontrak" class="kontrak_k_id_kontrak"><div class="ewTableHeaderCaption"><?php echo $kontrak->k_id_kontrak->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="k_id_kontrak" class="<?php echo $kontrak->k_id_kontrak->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->k_id_kontrak) ?>',1);"><div id="elh_kontrak_k_id_kontrak" class="kontrak_k_id_kontrak">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->k_id_kontrak->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->k_id_kontrak->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->k_id_kontrak->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->k_id_lama->Visible) { // k_id_lama ?>
	<?php if ($kontrak->SortUrl($kontrak->k_id_lama) == "") { ?>
		<th data-name="k_id_lama" class="<?php echo $kontrak->k_id_lama->HeaderCellClass() ?>"><div id="elh_kontrak_k_id_lama" class="kontrak_k_id_lama"><div class="ewTableHeaderCaption"><?php echo $kontrak->k_id_lama->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="k_id_lama" class="<?php echo $kontrak->k_id_lama->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->k_id_lama) ?>',1);"><div id="elh_kontrak_k_id_lama" class="kontrak_k_id_lama">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->k_id_lama->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->k_id_lama->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->k_id_lama->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->k_no_kontrak->Visible) { // k_no_kontrak ?>
	<?php if ($kontrak->SortUrl($kontrak->k_no_kontrak) == "") { ?>
		<th data-name="k_no_kontrak" class="<?php echo $kontrak->k_no_kontrak->HeaderCellClass() ?>"><div id="elh_kontrak_k_no_kontrak" class="kontrak_k_no_kontrak"><div class="ewTableHeaderCaption"><?php echo $kontrak->k_no_kontrak->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="k_no_kontrak" class="<?php echo $kontrak->k_no_kontrak->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->k_no_kontrak) ?>',1);"><div id="elh_kontrak_k_no_kontrak" class="kontrak_k_no_kontrak">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->k_no_kontrak->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->k_no_kontrak->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->k_no_kontrak->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->k_luas_lahan->Visible) { // k_luas_lahan ?>
	<?php if ($kontrak->SortUrl($kontrak->k_luas_lahan) == "") { ?>
		<th data-name="k_luas_lahan" class="<?php echo $kontrak->k_luas_lahan->HeaderCellClass() ?>"><div id="elh_kontrak_k_luas_lahan" class="kontrak_k_luas_lahan"><div class="ewTableHeaderCaption"><?php echo $kontrak->k_luas_lahan->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="k_luas_lahan" class="<?php echo $kontrak->k_luas_lahan->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->k_luas_lahan) ?>',1);"><div id="elh_kontrak_k_luas_lahan" class="kontrak_k_luas_lahan">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->k_luas_lahan->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->k_luas_lahan->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->k_luas_lahan->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->pet_id->Visible) { // pet_id ?>
	<?php if ($kontrak->SortUrl($kontrak->pet_id) == "") { ?>
		<th data-name="pet_id" class="<?php echo $kontrak->pet_id->HeaderCellClass() ?>"><div id="elh_kontrak_pet_id" class="kontrak_pet_id"><div class="ewTableHeaderCaption"><?php echo $kontrak->pet_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pet_id" class="<?php echo $kontrak->pet_id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->pet_id) ?>',1);"><div id="elh_kontrak_pet_id" class="kontrak_pet_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->pet_id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->pet_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->pet_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->koord_id->Visible) { // koord_id ?>
	<?php if ($kontrak->SortUrl($kontrak->koord_id) == "") { ?>
		<th data-name="koord_id" class="<?php echo $kontrak->koord_id->HeaderCellClass() ?>"><div id="elh_kontrak_koord_id" class="kontrak_koord_id"><div class="ewTableHeaderCaption"><?php echo $kontrak->koord_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="koord_id" class="<?php echo $kontrak->koord_id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->koord_id) ?>',1);"><div id="elh_kontrak_koord_id" class="kontrak_koord_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->koord_id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->koord_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->koord_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->kk_id->Visible) { // kk_id ?>
	<?php if ($kontrak->SortUrl($kontrak->kk_id) == "") { ?>
		<th data-name="kk_id" class="<?php echo $kontrak->kk_id->HeaderCellClass() ?>"><div id="elh_kontrak_kk_id" class="kontrak_kk_id"><div class="ewTableHeaderCaption"><?php echo $kontrak->kk_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="kk_id" class="<?php echo $kontrak->kk_id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->kk_id) ?>',1);"><div id="elh_kontrak_kk_id" class="kontrak_kk_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->kk_id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->kk_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->kk_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->prov_id->Visible) { // prov_id ?>
	<?php if ($kontrak->SortUrl($kontrak->prov_id) == "") { ?>
		<th data-name="prov_id" class="<?php echo $kontrak->prov_id->HeaderCellClass() ?>"><div id="elh_kontrak_prov_id" class="kontrak_prov_id"><div class="ewTableHeaderCaption"><?php echo $kontrak->prov_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="prov_id" class="<?php echo $kontrak->prov_id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->prov_id) ?>',1);"><div id="elh_kontrak_prov_id" class="kontrak_prov_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->prov_id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->prov_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->prov_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->kab_id->Visible) { // kab_id ?>
	<?php if ($kontrak->SortUrl($kontrak->kab_id) == "") { ?>
		<th data-name="kab_id" class="<?php echo $kontrak->kab_id->HeaderCellClass() ?>"><div id="elh_kontrak_kab_id" class="kontrak_kab_id"><div class="ewTableHeaderCaption"><?php echo $kontrak->kab_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="kab_id" class="<?php echo $kontrak->kab_id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->kab_id) ?>',1);"><div id="elh_kontrak_kab_id" class="kontrak_kab_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->kab_id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->kab_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->kab_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->kec_id->Visible) { // kec_id ?>
	<?php if ($kontrak->SortUrl($kontrak->kec_id) == "") { ?>
		<th data-name="kec_id" class="<?php echo $kontrak->kec_id->HeaderCellClass() ?>"><div id="elh_kontrak_kec_id" class="kontrak_kec_id"><div class="ewTableHeaderCaption"><?php echo $kontrak->kec_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="kec_id" class="<?php echo $kontrak->kec_id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->kec_id) ?>',1);"><div id="elh_kontrak_kec_id" class="kontrak_kec_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->kec_id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->kec_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->kec_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->desa_id->Visible) { // desa_id ?>
	<?php if ($kontrak->SortUrl($kontrak->desa_id) == "") { ?>
		<th data-name="desa_id" class="<?php echo $kontrak->desa_id->HeaderCellClass() ?>"><div id="elh_kontrak_desa_id" class="kontrak_desa_id"><div class="ewTableHeaderCaption"><?php echo $kontrak->desa_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="desa_id" class="<?php echo $kontrak->desa_id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->desa_id) ?>',1);"><div id="elh_kontrak_desa_id" class="kontrak_desa_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->desa_id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->desa_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->desa_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->blok_id->Visible) { // blok_id ?>
	<?php if ($kontrak->SortUrl($kontrak->blok_id) == "") { ?>
		<th data-name="blok_id" class="<?php echo $kontrak->blok_id->HeaderCellClass() ?>"><div id="elh_kontrak_blok_id" class="kontrak_blok_id"><div class="ewTableHeaderCaption"><?php echo $kontrak->blok_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="blok_id" class="<?php echo $kontrak->blok_id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->blok_id) ?>',1);"><div id="elh_kontrak_blok_id" class="kontrak_blok_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->blok_id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->blok_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->blok_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->sos_id->Visible) { // sos_id ?>
	<?php if ($kontrak->SortUrl($kontrak->sos_id) == "") { ?>
		<th data-name="sos_id" class="<?php echo $kontrak->sos_id->HeaderCellClass() ?>"><div id="elh_kontrak_sos_id" class="kontrak_sos_id"><div class="ewTableHeaderCaption"><?php echo $kontrak->sos_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sos_id" class="<?php echo $kontrak->sos_id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->sos_id) ?>',1);"><div id="elh_kontrak_sos_id" class="kontrak_sos_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->sos_id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->sos_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->sos_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->var_id->Visible) { // var_id ?>
	<?php if ($kontrak->SortUrl($kontrak->var_id) == "") { ?>
		<th data-name="var_id" class="<?php echo $kontrak->var_id->HeaderCellClass() ?>"><div id="elh_kontrak_var_id" class="kontrak_var_id"><div class="ewTableHeaderCaption"><?php echo $kontrak->var_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="var_id" class="<?php echo $kontrak->var_id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->var_id) ?>',1);"><div id="elh_kontrak_var_id" class="kontrak_var_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->var_id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->var_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->var_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->co_id->Visible) { // co_id ?>
	<?php if ($kontrak->SortUrl($kontrak->co_id) == "") { ?>
		<th data-name="co_id" class="<?php echo $kontrak->co_id->HeaderCellClass() ?>"><div id="elh_kontrak_co_id" class="kontrak_co_id"><div class="ewTableHeaderCaption"><?php echo $kontrak->co_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="co_id" class="<?php echo $kontrak->co_id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->co_id) ?>',1);"><div id="elh_kontrak_co_id" class="kontrak_co_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->co_id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->co_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->co_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->k_jumlah_bibit->Visible) { // k_jumlah_bibit ?>
	<?php if ($kontrak->SortUrl($kontrak->k_jumlah_bibit) == "") { ?>
		<th data-name="k_jumlah_bibit" class="<?php echo $kontrak->k_jumlah_bibit->HeaderCellClass() ?>"><div id="elh_kontrak_k_jumlah_bibit" class="kontrak_k_jumlah_bibit"><div class="ewTableHeaderCaption"><?php echo $kontrak->k_jumlah_bibit->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="k_jumlah_bibit" class="<?php echo $kontrak->k_jumlah_bibit->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->k_jumlah_bibit) ?>',1);"><div id="elh_kontrak_k_jumlah_bibit" class="kontrak_k_jumlah_bibit">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->k_jumlah_bibit->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->k_jumlah_bibit->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->k_jumlah_bibit->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->k_asal_bibit->Visible) { // k_asal_bibit ?>
	<?php if ($kontrak->SortUrl($kontrak->k_asal_bibit) == "") { ?>
		<th data-name="k_asal_bibit" class="<?php echo $kontrak->k_asal_bibit->HeaderCellClass() ?>"><div id="elh_kontrak_k_asal_bibit" class="kontrak_k_asal_bibit"><div class="ewTableHeaderCaption"><?php echo $kontrak->k_asal_bibit->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="k_asal_bibit" class="<?php echo $kontrak->k_asal_bibit->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->k_asal_bibit) ?>',1);"><div id="elh_kontrak_k_asal_bibit" class="kontrak_k_asal_bibit">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->k_asal_bibit->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->k_asal_bibit->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->k_asal_bibit->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->k_tgl_tanam->Visible) { // k_tgl_tanam ?>
	<?php if ($kontrak->SortUrl($kontrak->k_tgl_tanam) == "") { ?>
		<th data-name="k_tgl_tanam" class="<?php echo $kontrak->k_tgl_tanam->HeaderCellClass() ?>"><div id="elh_kontrak_k_tgl_tanam" class="kontrak_k_tgl_tanam"><div class="ewTableHeaderCaption"><?php echo $kontrak->k_tgl_tanam->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="k_tgl_tanam" class="<?php echo $kontrak->k_tgl_tanam->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->k_tgl_tanam) ?>',1);"><div id="elh_kontrak_k_tgl_tanam" class="kontrak_k_tgl_tanam">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->k_tgl_tanam->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->k_tgl_tanam->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->k_tgl_tanam->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->k_es_tgl_panen->Visible) { // k_es_tgl_panen ?>
	<?php if ($kontrak->SortUrl($kontrak->k_es_tgl_panen) == "") { ?>
		<th data-name="k_es_tgl_panen" class="<?php echo $kontrak->k_es_tgl_panen->HeaderCellClass() ?>"><div id="elh_kontrak_k_es_tgl_panen" class="kontrak_k_es_tgl_panen"><div class="ewTableHeaderCaption"><?php echo $kontrak->k_es_tgl_panen->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="k_es_tgl_panen" class="<?php echo $kontrak->k_es_tgl_panen->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->k_es_tgl_panen) ?>',1);"><div id="elh_kontrak_k_es_tgl_panen" class="kontrak_k_es_tgl_panen">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->k_es_tgl_panen->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->k_es_tgl_panen->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->k_es_tgl_panen->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->k_ak_tgl_datang->Visible) { // k_ak_tgl_datang ?>
	<?php if ($kontrak->SortUrl($kontrak->k_ak_tgl_datang) == "") { ?>
		<th data-name="k_ak_tgl_datang" class="<?php echo $kontrak->k_ak_tgl_datang->HeaderCellClass() ?>"><div id="elh_kontrak_k_ak_tgl_datang" class="kontrak_k_ak_tgl_datang"><div class="ewTableHeaderCaption"><?php echo $kontrak->k_ak_tgl_datang->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="k_ak_tgl_datang" class="<?php echo $kontrak->k_ak_tgl_datang->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->k_ak_tgl_datang) ?>',1);"><div id="elh_kontrak_k_ak_tgl_datang" class="kontrak_k_ak_tgl_datang">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->k_ak_tgl_datang->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->k_ak_tgl_datang->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->k_ak_tgl_datang->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->k_es_qty->Visible) { // k_es_qty ?>
	<?php if ($kontrak->SortUrl($kontrak->k_es_qty) == "") { ?>
		<th data-name="k_es_qty" class="<?php echo $kontrak->k_es_qty->HeaderCellClass() ?>"><div id="elh_kontrak_k_es_qty" class="kontrak_k_es_qty"><div class="ewTableHeaderCaption"><?php echo $kontrak->k_es_qty->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="k_es_qty" class="<?php echo $kontrak->k_es_qty->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->k_es_qty) ?>',1);"><div id="elh_kontrak_k_es_qty" class="kontrak_k_es_qty">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->k_es_qty->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->k_es_qty->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->k_es_qty->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->k_ak_qty->Visible) { // k_ak_qty ?>
	<?php if ($kontrak->SortUrl($kontrak->k_ak_qty) == "") { ?>
		<th data-name="k_ak_qty" class="<?php echo $kontrak->k_ak_qty->HeaderCellClass() ?>"><div id="elh_kontrak_k_ak_qty" class="kontrak_k_ak_qty"><div class="ewTableHeaderCaption"><?php echo $kontrak->k_ak_qty->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="k_ak_qty" class="<?php echo $kontrak->k_ak_qty->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->k_ak_qty) ?>',1);"><div id="elh_kontrak_k_ak_qty" class="kontrak_k_ak_qty">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->k_ak_qty->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->k_ak_qty->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->k_ak_qty->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->k_es_perhektar->Visible) { // k_es_perhektar ?>
	<?php if ($kontrak->SortUrl($kontrak->k_es_perhektar) == "") { ?>
		<th data-name="k_es_perhektar" class="<?php echo $kontrak->k_es_perhektar->HeaderCellClass() ?>"><div id="elh_kontrak_k_es_perhektar" class="kontrak_k_es_perhektar"><div class="ewTableHeaderCaption"><?php echo $kontrak->k_es_perhektar->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="k_es_perhektar" class="<?php echo $kontrak->k_es_perhektar->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->k_es_perhektar) ?>',1);"><div id="elh_kontrak_k_es_perhektar" class="kontrak_k_es_perhektar">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->k_es_perhektar->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->k_es_perhektar->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->k_es_perhektar->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->k_ak_perhektar->Visible) { // k_ak_perhektar ?>
	<?php if ($kontrak->SortUrl($kontrak->k_ak_perhektar) == "") { ?>
		<th data-name="k_ak_perhektar" class="<?php echo $kontrak->k_ak_perhektar->HeaderCellClass() ?>"><div id="elh_kontrak_k_ak_perhektar" class="kontrak_k_ak_perhektar"><div class="ewTableHeaderCaption"><?php echo $kontrak->k_ak_perhektar->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="k_ak_perhektar" class="<?php echo $kontrak->k_ak_perhektar->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->k_ak_perhektar) ?>',1);"><div id="elh_kontrak_k_ak_perhektar" class="kontrak_k_ak_perhektar">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->k_ak_perhektar->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->k_ak_perhektar->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->k_ak_perhektar->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->k_skor->Visible) { // k_skor ?>
	<?php if ($kontrak->SortUrl($kontrak->k_skor) == "") { ?>
		<th data-name="k_skor" class="<?php echo $kontrak->k_skor->HeaderCellClass() ?>"><div id="elh_kontrak_k_skor" class="kontrak_k_skor"><div class="ewTableHeaderCaption"><?php echo $kontrak->k_skor->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="k_skor" class="<?php echo $kontrak->k_skor->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->k_skor) ?>',1);"><div id="elh_kontrak_k_skor" class="kontrak_k_skor">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->k_skor->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->k_skor->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->k_skor->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->k_ket->Visible) { // k_ket ?>
	<?php if ($kontrak->SortUrl($kontrak->k_ket) == "") { ?>
		<th data-name="k_ket" class="<?php echo $kontrak->k_ket->HeaderCellClass() ?>"><div id="elh_kontrak_k_ket" class="kontrak_k_ket"><div class="ewTableHeaderCaption"><?php echo $kontrak->k_ket->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="k_ket" class="<?php echo $kontrak->k_ket->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->k_ket) ?>',1);"><div id="elh_kontrak_k_ket" class="kontrak_k_ket">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->k_ket->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->k_ket->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->k_ket->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->k_cat->Visible) { // k_cat ?>
	<?php if ($kontrak->SortUrl($kontrak->k_cat) == "") { ?>
		<th data-name="k_cat" class="<?php echo $kontrak->k_cat->HeaderCellClass() ?>"><div id="elh_kontrak_k_cat" class="kontrak_k_cat"><div class="ewTableHeaderCaption"><?php echo $kontrak->k_cat->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="k_cat" class="<?php echo $kontrak->k_cat->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->k_cat) ?>',1);"><div id="elh_kontrak_k_cat" class="kontrak_k_cat">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->k_cat->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->k_cat->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->k_cat->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->k_titik_koordinat->Visible) { // k_titik_koordinat ?>
	<?php if ($kontrak->SortUrl($kontrak->k_titik_koordinat) == "") { ?>
		<th data-name="k_titik_koordinat" class="<?php echo $kontrak->k_titik_koordinat->HeaderCellClass() ?>"><div id="elh_kontrak_k_titik_koordinat" class="kontrak_k_titik_koordinat"><div class="ewTableHeaderCaption"><?php echo $kontrak->k_titik_koordinat->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="k_titik_koordinat" class="<?php echo $kontrak->k_titik_koordinat->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->k_titik_koordinat) ?>',1);"><div id="elh_kontrak_k_titik_koordinat" class="kontrak_k_titik_koordinat">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->k_titik_koordinat->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->k_titik_koordinat->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->k_titik_koordinat->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->k_foto_lahan->Visible) { // k_foto_lahan ?>
	<?php if ($kontrak->SortUrl($kontrak->k_foto_lahan) == "") { ?>
		<th data-name="k_foto_lahan" class="<?php echo $kontrak->k_foto_lahan->HeaderCellClass() ?>"><div id="elh_kontrak_k_foto_lahan" class="kontrak_k_foto_lahan"><div class="ewTableHeaderCaption"><?php echo $kontrak->k_foto_lahan->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="k_foto_lahan" class="<?php echo $kontrak->k_foto_lahan->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->k_foto_lahan) ?>',1);"><div id="elh_kontrak_k_foto_lahan" class="kontrak_k_foto_lahan">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->k_foto_lahan->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->k_foto_lahan->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->k_foto_lahan->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->k_dok->Visible) { // k_dok ?>
	<?php if ($kontrak->SortUrl($kontrak->k_dok) == "") { ?>
		<th data-name="k_dok" class="<?php echo $kontrak->k_dok->HeaderCellClass() ?>"><div id="elh_kontrak_k_dok" class="kontrak_k_dok"><div class="ewTableHeaderCaption"><?php echo $kontrak->k_dok->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="k_dok" class="<?php echo $kontrak->k_dok->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->k_dok) ?>',1);"><div id="elh_kontrak_k_dok" class="kontrak_k_dok">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->k_dok->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->k_dok->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->k_dok->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->k_harga_bibit->Visible) { // k_harga_bibit ?>
	<?php if ($kontrak->SortUrl($kontrak->k_harga_bibit) == "") { ?>
		<th data-name="k_harga_bibit" class="<?php echo $kontrak->k_harga_bibit->HeaderCellClass() ?>"><div id="elh_kontrak_k_harga_bibit" class="kontrak_k_harga_bibit"><div class="ewTableHeaderCaption"><?php echo $kontrak->k_harga_bibit->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="k_harga_bibit" class="<?php echo $kontrak->k_harga_bibit->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->k_harga_bibit) ?>',1);"><div id="elh_kontrak_k_harga_bibit" class="kontrak_k_harga_bibit">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->k_harga_bibit->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->k_harga_bibit->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->k_harga_bibit->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->k_bayar_bibit->Visible) { // k_bayar_bibit ?>
	<?php if ($kontrak->SortUrl($kontrak->k_bayar_bibit) == "") { ?>
		<th data-name="k_bayar_bibit" class="<?php echo $kontrak->k_bayar_bibit->HeaderCellClass() ?>"><div id="elh_kontrak_k_bayar_bibit" class="kontrak_k_bayar_bibit"><div class="ewTableHeaderCaption"><?php echo $kontrak->k_bayar_bibit->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="k_bayar_bibit" class="<?php echo $kontrak->k_bayar_bibit->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->k_bayar_bibit) ?>',1);"><div id="elh_kontrak_k_bayar_bibit" class="kontrak_k_bayar_bibit">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->k_bayar_bibit->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->k_bayar_bibit->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->k_bayar_bibit->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->k_pinjaman->Visible) { // k_pinjaman ?>
	<?php if ($kontrak->SortUrl($kontrak->k_pinjaman) == "") { ?>
		<th data-name="k_pinjaman" class="<?php echo $kontrak->k_pinjaman->HeaderCellClass() ?>"><div id="elh_kontrak_k_pinjaman" class="kontrak_k_pinjaman"><div class="ewTableHeaderCaption"><?php echo $kontrak->k_pinjaman->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="k_pinjaman" class="<?php echo $kontrak->k_pinjaman->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->k_pinjaman) ?>',1);"><div id="elh_kontrak_k_pinjaman" class="kontrak_k_pinjaman">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->k_pinjaman->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->k_pinjaman->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->k_pinjaman->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->k_bayar_pinjaman->Visible) { // k_bayar_pinjaman ?>
	<?php if ($kontrak->SortUrl($kontrak->k_bayar_pinjaman) == "") { ?>
		<th data-name="k_bayar_pinjaman" class="<?php echo $kontrak->k_bayar_pinjaman->HeaderCellClass() ?>"><div id="elh_kontrak_k_bayar_pinjaman" class="kontrak_k_bayar_pinjaman"><div class="ewTableHeaderCaption"><?php echo $kontrak->k_bayar_pinjaman->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="k_bayar_pinjaman" class="<?php echo $kontrak->k_bayar_pinjaman->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->k_bayar_pinjaman) ?>',1);"><div id="elh_kontrak_k_bayar_pinjaman" class="kontrak_k_bayar_pinjaman">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->k_bayar_pinjaman->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->k_bayar_pinjaman->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->k_bayar_pinjaman->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kontrak->k_sisa_hutang->Visible) { // k_sisa_hutang ?>
	<?php if ($kontrak->SortUrl($kontrak->k_sisa_hutang) == "") { ?>
		<th data-name="k_sisa_hutang" class="<?php echo $kontrak->k_sisa_hutang->HeaderCellClass() ?>"><div id="elh_kontrak_k_sisa_hutang" class="kontrak_k_sisa_hutang"><div class="ewTableHeaderCaption"><?php echo $kontrak->k_sisa_hutang->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="k_sisa_hutang" class="<?php echo $kontrak->k_sisa_hutang->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kontrak->SortUrl($kontrak->k_sisa_hutang) ?>',1);"><div id="elh_kontrak_k_sisa_hutang" class="kontrak_k_sisa_hutang">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kontrak->k_sisa_hutang->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($kontrak->k_sisa_hutang->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kontrak->k_sisa_hutang->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$kontrak_list->ListOptions->Render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($kontrak->ExportAll && $kontrak->Export <> "") {
	$kontrak_list->StopRec = $kontrak_list->TotalRecs;
} else {

	// Set the last record to display
	if ($kontrak_list->TotalRecs > $kontrak_list->StartRec + $kontrak_list->DisplayRecs - 1)
		$kontrak_list->StopRec = $kontrak_list->StartRec + $kontrak_list->DisplayRecs - 1;
	else
		$kontrak_list->StopRec = $kontrak_list->TotalRecs;
}
$kontrak_list->RecCnt = $kontrak_list->StartRec - 1;
if ($kontrak_list->Recordset && !$kontrak_list->Recordset->EOF) {
	$kontrak_list->Recordset->MoveFirst();
	$bSelectLimit = $kontrak_list->UseSelectLimit;
	if (!$bSelectLimit && $kontrak_list->StartRec > 1)
		$kontrak_list->Recordset->Move($kontrak_list->StartRec - 1);
} elseif (!$kontrak->AllowAddDeleteRow && $kontrak_list->StopRec == 0) {
	$kontrak_list->StopRec = $kontrak->GridAddRowCount;
}

// Initialize aggregate
$kontrak->RowType = EW_ROWTYPE_AGGREGATEINIT;
$kontrak->ResetAttrs();
$kontrak_list->RenderRow();
while ($kontrak_list->RecCnt < $kontrak_list->StopRec) {
	$kontrak_list->RecCnt++;
	if (intval($kontrak_list->RecCnt) >= intval($kontrak_list->StartRec)) {
		$kontrak_list->RowCnt++;

		// Set up key count
		$kontrak_list->KeyCount = $kontrak_list->RowIndex;

		// Init row class and style
		$kontrak->ResetAttrs();
		$kontrak->CssClass = "";
		if ($kontrak->CurrentAction == "gridadd") {
		} else {
			$kontrak_list->LoadRowValues($kontrak_list->Recordset); // Load row values
		}
		$kontrak->RowType = EW_ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$kontrak->RowAttrs = array_merge($kontrak->RowAttrs, array('data-rowindex'=>$kontrak_list->RowCnt, 'id'=>'r' . $kontrak_list->RowCnt . '_kontrak', 'data-rowtype'=>$kontrak->RowType));

		// Render row
		$kontrak_list->RenderRow();

		// Render list options
		$kontrak_list->RenderListOptions();
?>
	<tr<?php echo $kontrak->RowAttributes() ?>>
<?php

// Render list options (body, left)
$kontrak_list->ListOptions->Render("body", "left", $kontrak_list->RowCnt);
?>
	<?php if ($kontrak->k_id_kontrak->Visible) { // k_id_kontrak ?>
		<td data-name="k_id_kontrak"<?php echo $kontrak->k_id_kontrak->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_k_id_kontrak" class="kontrak_k_id_kontrak">
<span<?php echo $kontrak->k_id_kontrak->ViewAttributes() ?>>
<?php echo $kontrak->k_id_kontrak->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->k_id_lama->Visible) { // k_id_lama ?>
		<td data-name="k_id_lama"<?php echo $kontrak->k_id_lama->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_k_id_lama" class="kontrak_k_id_lama">
<span<?php echo $kontrak->k_id_lama->ViewAttributes() ?>>
<?php echo $kontrak->k_id_lama->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->k_no_kontrak->Visible) { // k_no_kontrak ?>
		<td data-name="k_no_kontrak"<?php echo $kontrak->k_no_kontrak->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_k_no_kontrak" class="kontrak_k_no_kontrak">
<span<?php echo $kontrak->k_no_kontrak->ViewAttributes() ?>>
<?php echo $kontrak->k_no_kontrak->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->k_luas_lahan->Visible) { // k_luas_lahan ?>
		<td data-name="k_luas_lahan"<?php echo $kontrak->k_luas_lahan->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_k_luas_lahan" class="kontrak_k_luas_lahan">
<span<?php echo $kontrak->k_luas_lahan->ViewAttributes() ?>>
<?php echo $kontrak->k_luas_lahan->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->pet_id->Visible) { // pet_id ?>
		<td data-name="pet_id"<?php echo $kontrak->pet_id->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_pet_id" class="kontrak_pet_id">
<span<?php echo $kontrak->pet_id->ViewAttributes() ?>>
<?php if ((!ew_EmptyStr($kontrak->pet_id->ListViewValue())) && $kontrak->pet_id->LinkAttributes() <> "") { ?>
<a<?php echo $kontrak->pet_id->LinkAttributes() ?>><?php echo $kontrak->pet_id->ListViewValue() ?></a>
<?php } else { ?>
<?php echo $kontrak->pet_id->ListViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->koord_id->Visible) { // koord_id ?>
		<td data-name="koord_id"<?php echo $kontrak->koord_id->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_koord_id" class="kontrak_koord_id">
<span<?php echo $kontrak->koord_id->ViewAttributes() ?>>
<?php if ((!ew_EmptyStr($kontrak->koord_id->ListViewValue())) && $kontrak->koord_id->LinkAttributes() <> "") { ?>
<a<?php echo $kontrak->koord_id->LinkAttributes() ?>><?php echo $kontrak->koord_id->ListViewValue() ?></a>
<?php } else { ?>
<?php echo $kontrak->koord_id->ListViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->kk_id->Visible) { // kk_id ?>
		<td data-name="kk_id"<?php echo $kontrak->kk_id->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_kk_id" class="kontrak_kk_id">
<span<?php echo $kontrak->kk_id->ViewAttributes() ?>>
<?php if ((!ew_EmptyStr($kontrak->kk_id->ListViewValue())) && $kontrak->kk_id->LinkAttributes() <> "") { ?>
<a<?php echo $kontrak->kk_id->LinkAttributes() ?>><?php echo $kontrak->kk_id->ListViewValue() ?></a>
<?php } else { ?>
<?php echo $kontrak->kk_id->ListViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->prov_id->Visible) { // prov_id ?>
		<td data-name="prov_id"<?php echo $kontrak->prov_id->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_prov_id" class="kontrak_prov_id">
<span<?php echo $kontrak->prov_id->ViewAttributes() ?>>
<?php echo $kontrak->prov_id->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->kab_id->Visible) { // kab_id ?>
		<td data-name="kab_id"<?php echo $kontrak->kab_id->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_kab_id" class="kontrak_kab_id">
<span<?php echo $kontrak->kab_id->ViewAttributes() ?>>
<?php echo $kontrak->kab_id->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->kec_id->Visible) { // kec_id ?>
		<td data-name="kec_id"<?php echo $kontrak->kec_id->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_kec_id" class="kontrak_kec_id">
<span<?php echo $kontrak->kec_id->ViewAttributes() ?>>
<?php echo $kontrak->kec_id->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->desa_id->Visible) { // desa_id ?>
		<td data-name="desa_id"<?php echo $kontrak->desa_id->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_desa_id" class="kontrak_desa_id">
<span<?php echo $kontrak->desa_id->ViewAttributes() ?>>
<?php echo $kontrak->desa_id->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->blok_id->Visible) { // blok_id ?>
		<td data-name="blok_id"<?php echo $kontrak->blok_id->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_blok_id" class="kontrak_blok_id">
<span<?php echo $kontrak->blok_id->ViewAttributes() ?>>
<?php echo $kontrak->blok_id->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->sos_id->Visible) { // sos_id ?>
		<td data-name="sos_id"<?php echo $kontrak->sos_id->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_sos_id" class="kontrak_sos_id">
<span<?php echo $kontrak->sos_id->ViewAttributes() ?>>
<?php echo $kontrak->sos_id->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->var_id->Visible) { // var_id ?>
		<td data-name="var_id"<?php echo $kontrak->var_id->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_var_id" class="kontrak_var_id">
<span<?php echo $kontrak->var_id->ViewAttributes() ?>>
<?php if ((!ew_EmptyStr($kontrak->var_id->ListViewValue())) && $kontrak->var_id->LinkAttributes() <> "") { ?>
<a<?php echo $kontrak->var_id->LinkAttributes() ?>><?php echo $kontrak->var_id->ListViewValue() ?></a>
<?php } else { ?>
<?php echo $kontrak->var_id->ListViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->co_id->Visible) { // co_id ?>
		<td data-name="co_id"<?php echo $kontrak->co_id->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_co_id" class="kontrak_co_id">
<span<?php echo $kontrak->co_id->ViewAttributes() ?>>
<?php if ((!ew_EmptyStr($kontrak->co_id->ListViewValue())) && $kontrak->co_id->LinkAttributes() <> "") { ?>
<a<?php echo $kontrak->co_id->LinkAttributes() ?>><?php echo $kontrak->co_id->ListViewValue() ?></a>
<?php } else { ?>
<?php echo $kontrak->co_id->ListViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->k_jumlah_bibit->Visible) { // k_jumlah_bibit ?>
		<td data-name="k_jumlah_bibit"<?php echo $kontrak->k_jumlah_bibit->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_k_jumlah_bibit" class="kontrak_k_jumlah_bibit">
<span<?php echo $kontrak->k_jumlah_bibit->ViewAttributes() ?>>
<?php echo $kontrak->k_jumlah_bibit->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->k_asal_bibit->Visible) { // k_asal_bibit ?>
		<td data-name="k_asal_bibit"<?php echo $kontrak->k_asal_bibit->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_k_asal_bibit" class="kontrak_k_asal_bibit">
<span<?php echo $kontrak->k_asal_bibit->ViewAttributes() ?>>
<?php echo $kontrak->k_asal_bibit->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->k_tgl_tanam->Visible) { // k_tgl_tanam ?>
		<td data-name="k_tgl_tanam"<?php echo $kontrak->k_tgl_tanam->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_k_tgl_tanam" class="kontrak_k_tgl_tanam">
<span<?php echo $kontrak->k_tgl_tanam->ViewAttributes() ?>>
<?php echo $kontrak->k_tgl_tanam->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->k_es_tgl_panen->Visible) { // k_es_tgl_panen ?>
		<td data-name="k_es_tgl_panen"<?php echo $kontrak->k_es_tgl_panen->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_k_es_tgl_panen" class="kontrak_k_es_tgl_panen">
<span<?php echo $kontrak->k_es_tgl_panen->ViewAttributes() ?>>
<?php echo $kontrak->k_es_tgl_panen->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->k_ak_tgl_datang->Visible) { // k_ak_tgl_datang ?>
		<td data-name="k_ak_tgl_datang"<?php echo $kontrak->k_ak_tgl_datang->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_k_ak_tgl_datang" class="kontrak_k_ak_tgl_datang">
<span<?php echo $kontrak->k_ak_tgl_datang->ViewAttributes() ?>>
<?php echo $kontrak->k_ak_tgl_datang->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->k_es_qty->Visible) { // k_es_qty ?>
		<td data-name="k_es_qty"<?php echo $kontrak->k_es_qty->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_k_es_qty" class="kontrak_k_es_qty">
<span<?php echo $kontrak->k_es_qty->ViewAttributes() ?>>
<?php echo $kontrak->k_es_qty->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->k_ak_qty->Visible) { // k_ak_qty ?>
		<td data-name="k_ak_qty"<?php echo $kontrak->k_ak_qty->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_k_ak_qty" class="kontrak_k_ak_qty">
<span<?php echo $kontrak->k_ak_qty->ViewAttributes() ?>>
<?php echo $kontrak->k_ak_qty->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->k_es_perhektar->Visible) { // k_es_perhektar ?>
		<td data-name="k_es_perhektar"<?php echo $kontrak->k_es_perhektar->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_k_es_perhektar" class="kontrak_k_es_perhektar">
<span<?php echo $kontrak->k_es_perhektar->ViewAttributes() ?>>
<?php echo $kontrak->k_es_perhektar->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->k_ak_perhektar->Visible) { // k_ak_perhektar ?>
		<td data-name="k_ak_perhektar"<?php echo $kontrak->k_ak_perhektar->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_k_ak_perhektar" class="kontrak_k_ak_perhektar">
<span<?php echo $kontrak->k_ak_perhektar->ViewAttributes() ?>>
<?php echo $kontrak->k_ak_perhektar->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->k_skor->Visible) { // k_skor ?>
		<td data-name="k_skor"<?php echo $kontrak->k_skor->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_k_skor" class="kontrak_k_skor">
<span<?php echo $kontrak->k_skor->ViewAttributes() ?>>
<?php echo $kontrak->k_skor->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->k_ket->Visible) { // k_ket ?>
		<td data-name="k_ket"<?php echo $kontrak->k_ket->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_k_ket" class="kontrak_k_ket">
<span<?php echo $kontrak->k_ket->ViewAttributes() ?>>
<?php echo $kontrak->k_ket->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->k_cat->Visible) { // k_cat ?>
		<td data-name="k_cat"<?php echo $kontrak->k_cat->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_k_cat" class="kontrak_k_cat">
<span<?php echo $kontrak->k_cat->ViewAttributes() ?>>
<?php echo $kontrak->k_cat->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->k_titik_koordinat->Visible) { // k_titik_koordinat ?>
		<td data-name="k_titik_koordinat"<?php echo $kontrak->k_titik_koordinat->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_k_titik_koordinat" class="kontrak_k_titik_koordinat">
<span<?php echo $kontrak->k_titik_koordinat->ViewAttributes() ?>>
<?php if ((!ew_EmptyStr($kontrak->k_titik_koordinat->ListViewValue())) && $kontrak->k_titik_koordinat->LinkAttributes() <> "") { ?>
<a<?php echo $kontrak->k_titik_koordinat->LinkAttributes() ?>><?php echo $kontrak->k_titik_koordinat->ListViewValue() ?></a>
<?php } else { ?>
<?php echo $kontrak->k_titik_koordinat->ListViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->k_foto_lahan->Visible) { // k_foto_lahan ?>
		<td data-name="k_foto_lahan"<?php echo $kontrak->k_foto_lahan->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_k_foto_lahan" class="kontrak_k_foto_lahan">
<span>
<?php echo ew_GetFileViewTag($kontrak->k_foto_lahan, $kontrak->k_foto_lahan->ListViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->k_dok->Visible) { // k_dok ?>
		<td data-name="k_dok"<?php echo $kontrak->k_dok->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_k_dok" class="kontrak_k_dok">
<span>
<?php echo ew_GetFileViewTag($kontrak->k_dok, $kontrak->k_dok->ListViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->k_harga_bibit->Visible) { // k_harga_bibit ?>
		<td data-name="k_harga_bibit"<?php echo $kontrak->k_harga_bibit->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_k_harga_bibit" class="kontrak_k_harga_bibit">
<span<?php echo $kontrak->k_harga_bibit->ViewAttributes() ?>>
<?php echo $kontrak->k_harga_bibit->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->k_bayar_bibit->Visible) { // k_bayar_bibit ?>
		<td data-name="k_bayar_bibit"<?php echo $kontrak->k_bayar_bibit->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_k_bayar_bibit" class="kontrak_k_bayar_bibit">
<span<?php echo $kontrak->k_bayar_bibit->ViewAttributes() ?>>
<?php echo $kontrak->k_bayar_bibit->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->k_pinjaman->Visible) { // k_pinjaman ?>
		<td data-name="k_pinjaman"<?php echo $kontrak->k_pinjaman->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_k_pinjaman" class="kontrak_k_pinjaman">
<span<?php echo $kontrak->k_pinjaman->ViewAttributes() ?>>
<?php echo $kontrak->k_pinjaman->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->k_bayar_pinjaman->Visible) { // k_bayar_pinjaman ?>
		<td data-name="k_bayar_pinjaman"<?php echo $kontrak->k_bayar_pinjaman->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_k_bayar_pinjaman" class="kontrak_k_bayar_pinjaman">
<span<?php echo $kontrak->k_bayar_pinjaman->ViewAttributes() ?>>
<?php echo $kontrak->k_bayar_pinjaman->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kontrak->k_sisa_hutang->Visible) { // k_sisa_hutang ?>
		<td data-name="k_sisa_hutang"<?php echo $kontrak->k_sisa_hutang->CellAttributes() ?>>
<span id="el<?php echo $kontrak_list->RowCnt ?>_kontrak_k_sisa_hutang" class="kontrak_k_sisa_hutang">
<span<?php echo $kontrak->k_sisa_hutang->ViewAttributes() ?>>
<?php echo $kontrak->k_sisa_hutang->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$kontrak_list->ListOptions->Render("body", "right", $kontrak_list->RowCnt);
?>
	</tr>
<?php
	}
	if ($kontrak->CurrentAction <> "gridadd")
		$kontrak_list->Recordset->MoveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$kontrak->RowType = EW_ROWTYPE_AGGREGATE;
$kontrak->ResetAttrs();
$kontrak_list->RenderRow();
?>
<?php if ($kontrak_list->TotalRecs > 0 && ($kontrak->CurrentAction <> "gridadd" && $kontrak->CurrentAction <> "gridedit")) { ?>
<tfoot><!-- Table footer -->
	<tr class="ewTableFooter">
<?php

// Render list options
$kontrak_list->RenderListOptions();

// Render list options (footer, left)
$kontrak_list->ListOptions->Render("footer", "left");
?>
	<?php if ($kontrak->k_id_kontrak->Visible) { // k_id_kontrak ?>
		<td data-name="k_id_kontrak" class="<?php echo $kontrak->k_id_kontrak->FooterCellClass() ?>"><span id="elf_kontrak_k_id_kontrak" class="kontrak_k_id_kontrak">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->k_id_lama->Visible) { // k_id_lama ?>
		<td data-name="k_id_lama" class="<?php echo $kontrak->k_id_lama->FooterCellClass() ?>"><span id="elf_kontrak_k_id_lama" class="kontrak_k_id_lama">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->k_no_kontrak->Visible) { // k_no_kontrak ?>
		<td data-name="k_no_kontrak" class="<?php echo $kontrak->k_no_kontrak->FooterCellClass() ?>"><span id="elf_kontrak_k_no_kontrak" class="kontrak_k_no_kontrak">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->k_luas_lahan->Visible) { // k_luas_lahan ?>
		<td data-name="k_luas_lahan" class="<?php echo $kontrak->k_luas_lahan->FooterCellClass() ?>"><span id="elf_kontrak_k_luas_lahan" class="kontrak_k_luas_lahan">
<span class="ewAggregate"><?php echo $Language->Phrase("TOTAL") ?></span><span class="ewAggregateValue">
<?php echo $kontrak->k_luas_lahan->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($kontrak->pet_id->Visible) { // pet_id ?>
		<td data-name="pet_id" class="<?php echo $kontrak->pet_id->FooterCellClass() ?>"><span id="elf_kontrak_pet_id" class="kontrak_pet_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->koord_id->Visible) { // koord_id ?>
		<td data-name="koord_id" class="<?php echo $kontrak->koord_id->FooterCellClass() ?>"><span id="elf_kontrak_koord_id" class="kontrak_koord_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->kk_id->Visible) { // kk_id ?>
		<td data-name="kk_id" class="<?php echo $kontrak->kk_id->FooterCellClass() ?>"><span id="elf_kontrak_kk_id" class="kontrak_kk_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->prov_id->Visible) { // prov_id ?>
		<td data-name="prov_id" class="<?php echo $kontrak->prov_id->FooterCellClass() ?>"><span id="elf_kontrak_prov_id" class="kontrak_prov_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->kab_id->Visible) { // kab_id ?>
		<td data-name="kab_id" class="<?php echo $kontrak->kab_id->FooterCellClass() ?>"><span id="elf_kontrak_kab_id" class="kontrak_kab_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->kec_id->Visible) { // kec_id ?>
		<td data-name="kec_id" class="<?php echo $kontrak->kec_id->FooterCellClass() ?>"><span id="elf_kontrak_kec_id" class="kontrak_kec_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->desa_id->Visible) { // desa_id ?>
		<td data-name="desa_id" class="<?php echo $kontrak->desa_id->FooterCellClass() ?>"><span id="elf_kontrak_desa_id" class="kontrak_desa_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->blok_id->Visible) { // blok_id ?>
		<td data-name="blok_id" class="<?php echo $kontrak->blok_id->FooterCellClass() ?>"><span id="elf_kontrak_blok_id" class="kontrak_blok_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->sos_id->Visible) { // sos_id ?>
		<td data-name="sos_id" class="<?php echo $kontrak->sos_id->FooterCellClass() ?>"><span id="elf_kontrak_sos_id" class="kontrak_sos_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->var_id->Visible) { // var_id ?>
		<td data-name="var_id" class="<?php echo $kontrak->var_id->FooterCellClass() ?>"><span id="elf_kontrak_var_id" class="kontrak_var_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->co_id->Visible) { // co_id ?>
		<td data-name="co_id" class="<?php echo $kontrak->co_id->FooterCellClass() ?>"><span id="elf_kontrak_co_id" class="kontrak_co_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->k_jumlah_bibit->Visible) { // k_jumlah_bibit ?>
		<td data-name="k_jumlah_bibit" class="<?php echo $kontrak->k_jumlah_bibit->FooterCellClass() ?>"><span id="elf_kontrak_k_jumlah_bibit" class="kontrak_k_jumlah_bibit">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->k_asal_bibit->Visible) { // k_asal_bibit ?>
		<td data-name="k_asal_bibit" class="<?php echo $kontrak->k_asal_bibit->FooterCellClass() ?>"><span id="elf_kontrak_k_asal_bibit" class="kontrak_k_asal_bibit">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->k_tgl_tanam->Visible) { // k_tgl_tanam ?>
		<td data-name="k_tgl_tanam" class="<?php echo $kontrak->k_tgl_tanam->FooterCellClass() ?>"><span id="elf_kontrak_k_tgl_tanam" class="kontrak_k_tgl_tanam">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->k_es_tgl_panen->Visible) { // k_es_tgl_panen ?>
		<td data-name="k_es_tgl_panen" class="<?php echo $kontrak->k_es_tgl_panen->FooterCellClass() ?>"><span id="elf_kontrak_k_es_tgl_panen" class="kontrak_k_es_tgl_panen">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->k_ak_tgl_datang->Visible) { // k_ak_tgl_datang ?>
		<td data-name="k_ak_tgl_datang" class="<?php echo $kontrak->k_ak_tgl_datang->FooterCellClass() ?>"><span id="elf_kontrak_k_ak_tgl_datang" class="kontrak_k_ak_tgl_datang">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->k_es_qty->Visible) { // k_es_qty ?>
		<td data-name="k_es_qty" class="<?php echo $kontrak->k_es_qty->FooterCellClass() ?>"><span id="elf_kontrak_k_es_qty" class="kontrak_k_es_qty">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->k_ak_qty->Visible) { // k_ak_qty ?>
		<td data-name="k_ak_qty" class="<?php echo $kontrak->k_ak_qty->FooterCellClass() ?>"><span id="elf_kontrak_k_ak_qty" class="kontrak_k_ak_qty">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->k_es_perhektar->Visible) { // k_es_perhektar ?>
		<td data-name="k_es_perhektar" class="<?php echo $kontrak->k_es_perhektar->FooterCellClass() ?>"><span id="elf_kontrak_k_es_perhektar" class="kontrak_k_es_perhektar">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->k_ak_perhektar->Visible) { // k_ak_perhektar ?>
		<td data-name="k_ak_perhektar" class="<?php echo $kontrak->k_ak_perhektar->FooterCellClass() ?>"><span id="elf_kontrak_k_ak_perhektar" class="kontrak_k_ak_perhektar">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->k_skor->Visible) { // k_skor ?>
		<td data-name="k_skor" class="<?php echo $kontrak->k_skor->FooterCellClass() ?>"><span id="elf_kontrak_k_skor" class="kontrak_k_skor">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->k_ket->Visible) { // k_ket ?>
		<td data-name="k_ket" class="<?php echo $kontrak->k_ket->FooterCellClass() ?>"><span id="elf_kontrak_k_ket" class="kontrak_k_ket">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->k_cat->Visible) { // k_cat ?>
		<td data-name="k_cat" class="<?php echo $kontrak->k_cat->FooterCellClass() ?>"><span id="elf_kontrak_k_cat" class="kontrak_k_cat">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->k_titik_koordinat->Visible) { // k_titik_koordinat ?>
		<td data-name="k_titik_koordinat" class="<?php echo $kontrak->k_titik_koordinat->FooterCellClass() ?>"><span id="elf_kontrak_k_titik_koordinat" class="kontrak_k_titik_koordinat">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->k_foto_lahan->Visible) { // k_foto_lahan ?>
		<td data-name="k_foto_lahan" class="<?php echo $kontrak->k_foto_lahan->FooterCellClass() ?>"><span id="elf_kontrak_k_foto_lahan" class="kontrak_k_foto_lahan">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->k_dok->Visible) { // k_dok ?>
		<td data-name="k_dok" class="<?php echo $kontrak->k_dok->FooterCellClass() ?>"><span id="elf_kontrak_k_dok" class="kontrak_k_dok">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->k_harga_bibit->Visible) { // k_harga_bibit ?>
		<td data-name="k_harga_bibit" class="<?php echo $kontrak->k_harga_bibit->FooterCellClass() ?>"><span id="elf_kontrak_k_harga_bibit" class="kontrak_k_harga_bibit">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->k_bayar_bibit->Visible) { // k_bayar_bibit ?>
		<td data-name="k_bayar_bibit" class="<?php echo $kontrak->k_bayar_bibit->FooterCellClass() ?>"><span id="elf_kontrak_k_bayar_bibit" class="kontrak_k_bayar_bibit">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->k_pinjaman->Visible) { // k_pinjaman ?>
		<td data-name="k_pinjaman" class="<?php echo $kontrak->k_pinjaman->FooterCellClass() ?>"><span id="elf_kontrak_k_pinjaman" class="kontrak_k_pinjaman">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->k_bayar_pinjaman->Visible) { // k_bayar_pinjaman ?>
		<td data-name="k_bayar_pinjaman" class="<?php echo $kontrak->k_bayar_pinjaman->FooterCellClass() ?>"><span id="elf_kontrak_k_bayar_pinjaman" class="kontrak_k_bayar_pinjaman">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($kontrak->k_sisa_hutang->Visible) { // k_sisa_hutang ?>
		<td data-name="k_sisa_hutang" class="<?php echo $kontrak->k_sisa_hutang->FooterCellClass() ?>"><span id="elf_kontrak_k_sisa_hutang" class="kontrak_k_sisa_hutang">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$kontrak_list->ListOptions->Render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table>
<?php } ?>
<?php if ($kontrak->CurrentAction == "") { ?>
<input type="hidden" name="a_list" id="a_list" value="">
<?php } ?>
</div>
</form>
<?php

// Close recordset
if ($kontrak_list->Recordset)
	$kontrak_list->Recordset->Close();
?>
<?php if ($kontrak->Export == "") { ?>
<div class="box-footer ewGridLowerPanel">
<?php if ($kontrak->CurrentAction <> "gridadd" && $kontrak->CurrentAction <> "gridedit") { ?>
<form name="ewPagerForm" class="ewForm form-inline ewPagerForm" action="<?php echo ew_CurrentPage() ?>">
<?php if (!isset($kontrak_list->Pager)) $kontrak_list->Pager = new cNumericPager($kontrak_list->StartRec, $kontrak_list->DisplayRecs, $kontrak_list->TotalRecs, $kontrak_list->RecRange, $kontrak_list->AutoHidePager) ?>
<?php if ($kontrak_list->Pager->RecordCount > 0 && $kontrak_list->Pager->Visible) { ?>
<div class="ewPager">
<div class="ewNumericPage"><ul class="pagination">
	<?php if ($kontrak_list->Pager->FirstButton->Enabled) { ?>
	<li><a href="<?php echo $kontrak_list->PageUrl() ?>start=<?php echo $kontrak_list->Pager->FirstButton->Start ?>"><?php echo $Language->Phrase("PagerFirst") ?></a></li>
	<?php } ?>
	<?php if ($kontrak_list->Pager->PrevButton->Enabled) { ?>
	<li><a href="<?php echo $kontrak_list->PageUrl() ?>start=<?php echo $kontrak_list->Pager->PrevButton->Start ?>"><?php echo $Language->Phrase("PagerPrevious") ?></a></li>
	<?php } ?>
	<?php foreach ($kontrak_list->Pager->Items as $PagerItem) { ?>
		<li<?php if (!$PagerItem->Enabled) { echo " class=\" active\""; } ?>><a href="<?php if ($PagerItem->Enabled) { echo $kontrak_list->PageUrl() . "start=" . $PagerItem->Start; } else { echo "#"; } ?>"><?php echo $PagerItem->Text ?></a></li>
	<?php } ?>
	<?php if ($kontrak_list->Pager->NextButton->Enabled) { ?>
	<li><a href="<?php echo $kontrak_list->PageUrl() ?>start=<?php echo $kontrak_list->Pager->NextButton->Start ?>"><?php echo $Language->Phrase("PagerNext") ?></a></li>
	<?php } ?>
	<?php if ($kontrak_list->Pager->LastButton->Enabled) { ?>
	<li><a href="<?php echo $kontrak_list->PageUrl() ?>start=<?php echo $kontrak_list->Pager->LastButton->Start ?>"><?php echo $Language->Phrase("PagerLast") ?></a></li>
	<?php } ?>
</ul></div>
</div>
<?php } ?>
<?php if ($kontrak_list->Pager->RecordCount > 0) { ?>
<div class="ewPager ewRec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $kontrak_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $kontrak_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $kontrak_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ewListOtherOptions">
<?php
	foreach ($kontrak_list->OtherOptions as &$option)
		$option->Render("body", "bottom");
?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div>
<?php } ?>
<?php if ($kontrak_list->TotalRecs == 0 && $kontrak->CurrentAction == "") { // Show other options ?>
<div class="ewListOtherOptions">
<?php
	foreach ($kontrak_list->OtherOptions as &$option) {
		$option->ButtonClass = "";
		$option->Render("body", "");
	}
?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php if ($kontrak->Export == "") { ?>
<script type="text/javascript">
fkontraklistsrch.FilterList = <?php echo $kontrak_list->GetFilterList() ?>;
fkontraklistsrch.Init();
fkontraklist.Init();
</script>
<?php } ?>
<?php
$kontrak_list->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<?php if ($kontrak->Export == "") { ?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$kontrak_list->Page_Terminate();
?>
