<?php
if (session_id() == "") session_start(); // Init session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg14.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql14.php") ?>
<?php include_once "phpfn14.php" ?>
<?php include_once "kontrakinfo.php" ?>
<?php include_once "employeesinfo.php" ?>
<?php include_once "userfn14.php" ?>
<?php

//
// Page class
//

$kontrak_edit = NULL; // Initialize page object first

class ckontrak_edit extends ckontrak {

	// Page ID
	var $PageID = 'edit';

	// Project ID
	var $ProjectID = '{CC60B42B-604B-412A-B014-2315920AF6AA}';

	// Table name
	var $TableName = 'kontrak';

	// Page object name
	var $PageObjName = 'kontrak_edit';

	// Page headings
	var $Heading = '';
	var $Subheading = '';

	// Page heading
	function PageHeading() {
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->TableCaption();
		return "";
	}

	// Page subheading
	function PageSubheading() {
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->Phrase($this->PageID);
		return "";
	}

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (kontrak)
		if (!isset($GLOBALS["kontrak"]) || get_class($GLOBALS["kontrak"]) == "ckontrak") {
			$GLOBALS["kontrak"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["kontrak"];
		}

		// Table object (employees)
		if (!isset($GLOBALS['employees'])) $GLOBALS['employees'] = new cemployees();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'edit', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'kontrak', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"]))
			$GLOBALS["gTimer"] = new cTimer();

		// Debug message
		ew_LoadDebugMsg();

		// Open connection
		if (!isset($conn))
			$conn = ew_Connect($this->DBID);

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new cemployees();
			$UserTableConn = Conn($UserTable->DBID);
		}
	}

	//
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Is modal
		$this->IsModal = (@$_GET["modal"] == "1" || @$_POST["modal"] == "1");

		// User profile
		$UserProfile = new cUserProfile();

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanEdit()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			if ($Security->CanList())
				$this->Page_Terminate(ew_GetUrl("kontraklist.php"));
			else
				$this->Page_Terminate(ew_GetUrl("login.php"));
		}

		// NOTE: Security object may be needed in other part of the script, skip set to Nothing
		// 
		// Security = null;
		// 
		// Create form object

		$objForm = new cFormObj();
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action
		$this->k_id_lama->SetVisibility();
		$this->k_no_kontrak->SetVisibility();
		$this->k_luas_lahan->SetVisibility();
		$this->pet_id->SetVisibility();
		$this->koord_id->SetVisibility();
		$this->kk_id->SetVisibility();
		$this->prov_id->SetVisibility();
		$this->kab_id->SetVisibility();
		$this->kec_id->SetVisibility();
		$this->desa_id->SetVisibility();
		$this->blok_id->SetVisibility();
		$this->sos_id->SetVisibility();
		$this->var_id->SetVisibility();
		$this->co_id->SetVisibility();
		$this->k_jumlah_bibit->SetVisibility();
		$this->k_asal_bibit->SetVisibility();
		$this->k_tgl_tanam->SetVisibility();
		$this->k_es_tgl_panen->SetVisibility();
		$this->k_ak_tgl_datang->SetVisibility();
		$this->k_ak_qty->SetVisibility();
		$this->k_es_perhektar->SetVisibility();
		$this->k_ket->SetVisibility();
		$this->k_cat->SetVisibility();
		$this->k_titik_koordinat->SetVisibility();
		$this->k_foto_lahan->SetVisibility();
		$this->k_dok->SetVisibility();
		$this->k_harga_bibit->SetVisibility();
		$this->k_bayar_bibit->SetVisibility();
		$this->k_pinjaman->SetVisibility();
		$this->k_bayar_pinjaman->SetVisibility();
		$this->k_sisa_hutang->SetVisibility();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $kontrak;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($kontrak);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		// Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = ew_GetPageName($url);
				if ($pageName != $this->GetListUrl()) { // Not List page
					$row["caption"] = $this->GetModalCaption($pageName);
					if ($pageName == "kontrakview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				header("Content-Type: application/json; charset=utf-8");
				echo ew_ConvertToUtf8(ew_ArrayToJson(array($row)));
			} else {
				ew_SaveDebugMsg();
				header("Location: " . $url);
			}
		}
		exit();
	}
	var $FormClassName = "form-horizontal ewForm ewEditForm";
	var $IsModal = FALSE;
	var $IsMobileOrModal = FALSE;
	var $DbMasterFilter;
	var $DbDetailFilter;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError, $gbSkipHeaderFooter;

		// Check modal
		if ($this->IsModal)
			$gbSkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = ew_IsMobile() || $this->IsModal;
		$this->FormClassName = "ewForm ewEditForm form-horizontal";
		$sReturnUrl = "";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (@$_POST["a_edit"] <> "") {
			$this->CurrentAction = $_POST["a_edit"]; // Get action code
			if ($this->CurrentAction <> "I") // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($objForm->HasValue("x_k_id")) {
				$this->k_id->setFormValue($objForm->GetValue("x_k_id"));
			}
		} else {
			$this->CurrentAction = "I"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (isset($_GET["k_id"])) {
				$this->k_id->setQueryStringValue($_GET["k_id"]);
				$loadByQuery = TRUE;
			} else {
				$this->k_id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->LoadRow();

		// Process form if post back
		if ($postBack) {
			$this->LoadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->ValidateForm()) {
				$this->CurrentAction = ""; // Form error, reset action
				$this->setFailureMessage($gsFormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->RestoreFormValues();
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "I": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "") $this->setFailureMessage($Language->Phrase("NoRecord")); // No record found
					$this->Page_Terminate("kontraklist.php"); // No matching record, return to list
				}
				break;
			Case "U": // Update
				$sReturnUrl = $this->getReturnUrl();
				if (ew_GetPageName($sReturnUrl) == "kontraklist.php")
					$sReturnUrl = $this->AddMasterUrl($sReturnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->EditRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->Phrase("UpdateSuccess")); // Update success
					$this->Page_Terminate($sReturnUrl); // Return to caller
				} elseif ($this->getFailureMessage() == $Language->Phrase("NoRecord")) {
					$this->Page_Terminate($sReturnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->RestoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->SetupBreadcrumb();

		// Render the record
		$this->RowType = EW_ROWTYPE_EDIT; // Render as Edit
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Set up starting record parameters
	function SetupStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	function GetUploadFiles() {
		global $objForm, $Language;

		// Get upload data
		$this->k_foto_lahan->Upload->Index = $objForm->Index;
		$this->k_foto_lahan->Upload->UploadFile();
		$this->k_foto_lahan->CurrentValue = $this->k_foto_lahan->Upload->FileName;
		$this->k_dok->Upload->Index = $objForm->Index;
		$this->k_dok->Upload->UploadFile();
		$this->k_dok->CurrentValue = $this->k_dok->Upload->FileName;
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm;
		$this->GetUploadFiles(); // Get upload files
		if (!$this->k_id_lama->FldIsDetailKey) {
			$this->k_id_lama->setFormValue($objForm->GetValue("x_k_id_lama"));
		}
		if (!$this->k_no_kontrak->FldIsDetailKey) {
			$this->k_no_kontrak->setFormValue($objForm->GetValue("x_k_no_kontrak"));
		}
		if (!$this->k_luas_lahan->FldIsDetailKey) {
			$this->k_luas_lahan->setFormValue($objForm->GetValue("x_k_luas_lahan"));
		}
		if (!$this->pet_id->FldIsDetailKey) {
			$this->pet_id->setFormValue($objForm->GetValue("x_pet_id"));
		}
		if (!$this->koord_id->FldIsDetailKey) {
			$this->koord_id->setFormValue($objForm->GetValue("x_koord_id"));
		}
		if (!$this->kk_id->FldIsDetailKey) {
			$this->kk_id->setFormValue($objForm->GetValue("x_kk_id"));
		}
		if (!$this->prov_id->FldIsDetailKey) {
			$this->prov_id->setFormValue($objForm->GetValue("x_prov_id"));
		}
		if (!$this->kab_id->FldIsDetailKey) {
			$this->kab_id->setFormValue($objForm->GetValue("x_kab_id"));
		}
		if (!$this->kec_id->FldIsDetailKey) {
			$this->kec_id->setFormValue($objForm->GetValue("x_kec_id"));
		}
		if (!$this->desa_id->FldIsDetailKey) {
			$this->desa_id->setFormValue($objForm->GetValue("x_desa_id"));
		}
		if (!$this->blok_id->FldIsDetailKey) {
			$this->blok_id->setFormValue($objForm->GetValue("x_blok_id"));
		}
		if (!$this->sos_id->FldIsDetailKey) {
			$this->sos_id->setFormValue($objForm->GetValue("x_sos_id"));
		}
		if (!$this->var_id->FldIsDetailKey) {
			$this->var_id->setFormValue($objForm->GetValue("x_var_id"));
		}
		if (!$this->co_id->FldIsDetailKey) {
			$this->co_id->setFormValue($objForm->GetValue("x_co_id"));
		}
		if (!$this->k_jumlah_bibit->FldIsDetailKey) {
			$this->k_jumlah_bibit->setFormValue($objForm->GetValue("x_k_jumlah_bibit"));
		}
		if (!$this->k_asal_bibit->FldIsDetailKey) {
			$this->k_asal_bibit->setFormValue($objForm->GetValue("x_k_asal_bibit"));
		}
		if (!$this->k_tgl_tanam->FldIsDetailKey) {
			$this->k_tgl_tanam->setFormValue($objForm->GetValue("x_k_tgl_tanam"));
			$this->k_tgl_tanam->CurrentValue = ew_UnFormatDateTime($this->k_tgl_tanam->CurrentValue, 5);
		}
		if (!$this->k_es_tgl_panen->FldIsDetailKey) {
			$this->k_es_tgl_panen->setFormValue($objForm->GetValue("x_k_es_tgl_panen"));
			$this->k_es_tgl_panen->CurrentValue = ew_UnFormatDateTime($this->k_es_tgl_panen->CurrentValue, 5);
		}
		if (!$this->k_ak_tgl_datang->FldIsDetailKey) {
			$this->k_ak_tgl_datang->setFormValue($objForm->GetValue("x_k_ak_tgl_datang"));
			$this->k_ak_tgl_datang->CurrentValue = ew_UnFormatDateTime($this->k_ak_tgl_datang->CurrentValue, 5);
		}
		if (!$this->k_ak_qty->FldIsDetailKey) {
			$this->k_ak_qty->setFormValue($objForm->GetValue("x_k_ak_qty"));
		}
		if (!$this->k_es_perhektar->FldIsDetailKey) {
			$this->k_es_perhektar->setFormValue($objForm->GetValue("x_k_es_perhektar"));
		}
		if (!$this->k_ket->FldIsDetailKey) {
			$this->k_ket->setFormValue($objForm->GetValue("x_k_ket"));
		}
		if (!$this->k_cat->FldIsDetailKey) {
			$this->k_cat->setFormValue($objForm->GetValue("x_k_cat"));
		}
		if (!$this->k_titik_koordinat->FldIsDetailKey) {
			$this->k_titik_koordinat->setFormValue($objForm->GetValue("x_k_titik_koordinat"));
		}
		if (!$this->k_harga_bibit->FldIsDetailKey) {
			$this->k_harga_bibit->setFormValue($objForm->GetValue("x_k_harga_bibit"));
		}
		if (!$this->k_bayar_bibit->FldIsDetailKey) {
			$this->k_bayar_bibit->setFormValue($objForm->GetValue("x_k_bayar_bibit"));
		}
		if (!$this->k_pinjaman->FldIsDetailKey) {
			$this->k_pinjaman->setFormValue($objForm->GetValue("x_k_pinjaman"));
		}
		if (!$this->k_bayar_pinjaman->FldIsDetailKey) {
			$this->k_bayar_pinjaman->setFormValue($objForm->GetValue("x_k_bayar_pinjaman"));
		}
		if (!$this->k_sisa_hutang->FldIsDetailKey) {
			$this->k_sisa_hutang->setFormValue($objForm->GetValue("x_k_sisa_hutang"));
		}
		if (!$this->k_id->FldIsDetailKey)
			$this->k_id->setFormValue($objForm->GetValue("x_k_id"));
	}

	// Restore form values
	function RestoreFormValues() {
		global $objForm;
		$this->k_id->CurrentValue = $this->k_id->FormValue;
		$this->k_id_lama->CurrentValue = $this->k_id_lama->FormValue;
		$this->k_no_kontrak->CurrentValue = $this->k_no_kontrak->FormValue;
		$this->k_luas_lahan->CurrentValue = $this->k_luas_lahan->FormValue;
		$this->pet_id->CurrentValue = $this->pet_id->FormValue;
		$this->koord_id->CurrentValue = $this->koord_id->FormValue;
		$this->kk_id->CurrentValue = $this->kk_id->FormValue;
		$this->prov_id->CurrentValue = $this->prov_id->FormValue;
		$this->kab_id->CurrentValue = $this->kab_id->FormValue;
		$this->kec_id->CurrentValue = $this->kec_id->FormValue;
		$this->desa_id->CurrentValue = $this->desa_id->FormValue;
		$this->blok_id->CurrentValue = $this->blok_id->FormValue;
		$this->sos_id->CurrentValue = $this->sos_id->FormValue;
		$this->var_id->CurrentValue = $this->var_id->FormValue;
		$this->co_id->CurrentValue = $this->co_id->FormValue;
		$this->k_jumlah_bibit->CurrentValue = $this->k_jumlah_bibit->FormValue;
		$this->k_asal_bibit->CurrentValue = $this->k_asal_bibit->FormValue;
		$this->k_tgl_tanam->CurrentValue = $this->k_tgl_tanam->FormValue;
		$this->k_tgl_tanam->CurrentValue = ew_UnFormatDateTime($this->k_tgl_tanam->CurrentValue, 5);
		$this->k_es_tgl_panen->CurrentValue = $this->k_es_tgl_panen->FormValue;
		$this->k_es_tgl_panen->CurrentValue = ew_UnFormatDateTime($this->k_es_tgl_panen->CurrentValue, 5);
		$this->k_ak_tgl_datang->CurrentValue = $this->k_ak_tgl_datang->FormValue;
		$this->k_ak_tgl_datang->CurrentValue = ew_UnFormatDateTime($this->k_ak_tgl_datang->CurrentValue, 5);
		$this->k_ak_qty->CurrentValue = $this->k_ak_qty->FormValue;
		$this->k_es_perhektar->CurrentValue = $this->k_es_perhektar->FormValue;
		$this->k_ket->CurrentValue = $this->k_ket->FormValue;
		$this->k_cat->CurrentValue = $this->k_cat->FormValue;
		$this->k_titik_koordinat->CurrentValue = $this->k_titik_koordinat->FormValue;
		$this->k_harga_bibit->CurrentValue = $this->k_harga_bibit->FormValue;
		$this->k_bayar_bibit->CurrentValue = $this->k_bayar_bibit->FormValue;
		$this->k_pinjaman->CurrentValue = $this->k_pinjaman->FormValue;
		$this->k_bayar_pinjaman->CurrentValue = $this->k_bayar_pinjaman->FormValue;
		$this->k_sisa_hutang->CurrentValue = $this->k_sisa_hutang->FormValue;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues($rs = NULL) {
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->NewRow(); 

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->k_id->setDbValue($row['k_id']);
		$this->k_id_kontrak->setDbValue($row['k_id_kontrak']);
		$this->k_id_lama->setDbValue($row['k_id_lama']);
		$this->k_no_kontrak->setDbValue($row['k_no_kontrak']);
		$this->k_luas_lahan->setDbValue($row['k_luas_lahan']);
		$this->pet_id->setDbValue($row['pet_id']);
		if (array_key_exists('EV__pet_id', $rs->fields)) {
			$this->pet_id->VirtualValue = $rs->fields('EV__pet_id'); // Set up virtual field value
		} else {
			$this->pet_id->VirtualValue = ""; // Clear value
		}
		$this->koord_id->setDbValue($row['koord_id']);
		if (array_key_exists('EV__koord_id', $rs->fields)) {
			$this->koord_id->VirtualValue = $rs->fields('EV__koord_id'); // Set up virtual field value
		} else {
			$this->koord_id->VirtualValue = ""; // Clear value
		}
		$this->kk_id->setDbValue($row['kk_id']);
		$this->prov_id->setDbValue($row['prov_id']);
		$this->kab_id->setDbValue($row['kab_id']);
		$this->kec_id->setDbValue($row['kec_id']);
		if (array_key_exists('EV__kec_id', $rs->fields)) {
			$this->kec_id->VirtualValue = $rs->fields('EV__kec_id'); // Set up virtual field value
		} else {
			$this->kec_id->VirtualValue = ""; // Clear value
		}
		$this->desa_id->setDbValue($row['desa_id']);
		if (array_key_exists('EV__desa_id', $rs->fields)) {
			$this->desa_id->VirtualValue = $rs->fields('EV__desa_id'); // Set up virtual field value
		} else {
			$this->desa_id->VirtualValue = ""; // Clear value
		}
		$this->blok_id->setDbValue($row['blok_id']);
		if (array_key_exists('EV__blok_id', $rs->fields)) {
			$this->blok_id->VirtualValue = $rs->fields('EV__blok_id'); // Set up virtual field value
		} else {
			$this->blok_id->VirtualValue = ""; // Clear value
		}
		$this->sos_id->setDbValue($row['sos_id']);
		if (array_key_exists('EV__sos_id', $rs->fields)) {
			$this->sos_id->VirtualValue = $rs->fields('EV__sos_id'); // Set up virtual field value
		} else {
			$this->sos_id->VirtualValue = ""; // Clear value
		}
		$this->var_id->setDbValue($row['var_id']);
		$this->co_id->setDbValue($row['co_id']);
		$this->k_jumlah_bibit->setDbValue($row['k_jumlah_bibit']);
		$this->k_asal_bibit->setDbValue($row['k_asal_bibit']);
		$this->k_tgl_tanam->setDbValue($row['k_tgl_tanam']);
		$this->k_es_tgl_panen->setDbValue($row['k_es_tgl_panen']);
		$this->k_ak_tgl_datang->setDbValue($row['k_ak_tgl_datang']);
		$this->k_es_qty->setDbValue($row['k_es_qty']);
		$this->k_ak_qty->setDbValue($row['k_ak_qty']);
		$this->k_es_perhektar->setDbValue($row['k_es_perhektar']);
		$this->k_ak_perhektar->setDbValue($row['k_ak_perhektar']);
		$this->k_skor->setDbValue($row['k_skor']);
		$this->k_ket->setDbValue($row['k_ket']);
		$this->k_cat->setDbValue($row['k_cat']);
		$this->k_titik_koordinat->setDbValue($row['k_titik_koordinat']);
		$this->k_foto_lahan->Upload->DbValue = $row['k_foto_lahan'];
		$this->k_foto_lahan->setDbValue($this->k_foto_lahan->Upload->DbValue);
		$this->k_dok->Upload->DbValue = $row['k_dok'];
		$this->k_dok->setDbValue($this->k_dok->Upload->DbValue);
		$this->k_harga_bibit->setDbValue($row['k_harga_bibit']);
		$this->k_bayar_bibit->setDbValue($row['k_bayar_bibit']);
		$this->k_pinjaman->setDbValue($row['k_pinjaman']);
		$this->k_bayar_pinjaman->setDbValue($row['k_bayar_pinjaman']);
		$this->k_sisa_hutang->setDbValue($row['k_sisa_hutang']);
	}

	// Return a row with default values
	function NewRow() {
		$row = array();
		$row['k_id'] = NULL;
		$row['k_id_kontrak'] = NULL;
		$row['k_id_lama'] = NULL;
		$row['k_no_kontrak'] = NULL;
		$row['k_luas_lahan'] = NULL;
		$row['pet_id'] = NULL;
		$row['koord_id'] = NULL;
		$row['kk_id'] = NULL;
		$row['prov_id'] = NULL;
		$row['kab_id'] = NULL;
		$row['kec_id'] = NULL;
		$row['desa_id'] = NULL;
		$row['blok_id'] = NULL;
		$row['sos_id'] = NULL;
		$row['var_id'] = NULL;
		$row['co_id'] = NULL;
		$row['k_jumlah_bibit'] = NULL;
		$row['k_asal_bibit'] = NULL;
		$row['k_tgl_tanam'] = NULL;
		$row['k_es_tgl_panen'] = NULL;
		$row['k_ak_tgl_datang'] = NULL;
		$row['k_es_qty'] = NULL;
		$row['k_ak_qty'] = NULL;
		$row['k_es_perhektar'] = NULL;
		$row['k_ak_perhektar'] = NULL;
		$row['k_skor'] = NULL;
		$row['k_ket'] = NULL;
		$row['k_cat'] = NULL;
		$row['k_titik_koordinat'] = NULL;
		$row['k_foto_lahan'] = NULL;
		$row['k_dok'] = NULL;
		$row['k_harga_bibit'] = NULL;
		$row['k_bayar_bibit'] = NULL;
		$row['k_pinjaman'] = NULL;
		$row['k_bayar_pinjaman'] = NULL;
		$row['k_sisa_hutang'] = NULL;
		return $row;
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->k_id->DbValue = $row['k_id'];
		$this->k_id_kontrak->DbValue = $row['k_id_kontrak'];
		$this->k_id_lama->DbValue = $row['k_id_lama'];
		$this->k_no_kontrak->DbValue = $row['k_no_kontrak'];
		$this->k_luas_lahan->DbValue = $row['k_luas_lahan'];
		$this->pet_id->DbValue = $row['pet_id'];
		$this->koord_id->DbValue = $row['koord_id'];
		$this->kk_id->DbValue = $row['kk_id'];
		$this->prov_id->DbValue = $row['prov_id'];
		$this->kab_id->DbValue = $row['kab_id'];
		$this->kec_id->DbValue = $row['kec_id'];
		$this->desa_id->DbValue = $row['desa_id'];
		$this->blok_id->DbValue = $row['blok_id'];
		$this->sos_id->DbValue = $row['sos_id'];
		$this->var_id->DbValue = $row['var_id'];
		$this->co_id->DbValue = $row['co_id'];
		$this->k_jumlah_bibit->DbValue = $row['k_jumlah_bibit'];
		$this->k_asal_bibit->DbValue = $row['k_asal_bibit'];
		$this->k_tgl_tanam->DbValue = $row['k_tgl_tanam'];
		$this->k_es_tgl_panen->DbValue = $row['k_es_tgl_panen'];
		$this->k_ak_tgl_datang->DbValue = $row['k_ak_tgl_datang'];
		$this->k_es_qty->DbValue = $row['k_es_qty'];
		$this->k_ak_qty->DbValue = $row['k_ak_qty'];
		$this->k_es_perhektar->DbValue = $row['k_es_perhektar'];
		$this->k_ak_perhektar->DbValue = $row['k_ak_perhektar'];
		$this->k_skor->DbValue = $row['k_skor'];
		$this->k_ket->DbValue = $row['k_ket'];
		$this->k_cat->DbValue = $row['k_cat'];
		$this->k_titik_koordinat->DbValue = $row['k_titik_koordinat'];
		$this->k_foto_lahan->Upload->DbValue = $row['k_foto_lahan'];
		$this->k_dok->Upload->DbValue = $row['k_dok'];
		$this->k_harga_bibit->DbValue = $row['k_harga_bibit'];
		$this->k_bayar_bibit->DbValue = $row['k_bayar_bibit'];
		$this->k_pinjaman->DbValue = $row['k_pinjaman'];
		$this->k_bayar_pinjaman->DbValue = $row['k_bayar_pinjaman'];
		$this->k_sisa_hutang->DbValue = $row['k_sisa_hutang'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("k_id")) <> "")
			$this->k_id->CurrentValue = $this->getKey("k_id"); // k_id
		else
			$bValidKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
		}
		$this->LoadRowValues($this->OldRecordset); // Load row values
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// k_id
		// k_id_kontrak
		// k_id_lama
		// k_no_kontrak
		// k_luas_lahan
		// pet_id
		// koord_id
		// kk_id
		// prov_id
		// kab_id
		// kec_id
		// desa_id
		// blok_id
		// sos_id
		// var_id
		// co_id
		// k_jumlah_bibit
		// k_asal_bibit
		// k_tgl_tanam
		// k_es_tgl_panen
		// k_ak_tgl_datang
		// k_es_qty
		// k_ak_qty
		// k_es_perhektar
		// k_ak_perhektar
		// k_skor
		// k_ket
		// k_cat
		// k_titik_koordinat
		// k_foto_lahan
		// k_dok
		// k_harga_bibit
		// k_bayar_bibit
		// k_pinjaman
		// k_bayar_pinjaman
		// k_sisa_hutang

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// k_id
		$this->k_id->ViewValue = $this->k_id->CurrentValue;
		$this->k_id->ViewCustomAttributes = "";

		// k_id_kontrak
		$this->k_id_kontrak->ViewValue = $this->k_id_kontrak->CurrentValue;
		$this->k_id_kontrak->ViewCustomAttributes = "";

		// k_id_lama
		$this->k_id_lama->ViewValue = $this->k_id_lama->CurrentValue;
		$this->k_id_lama->ViewCustomAttributes = "";

		// k_no_kontrak
		$this->k_no_kontrak->ViewValue = $this->k_no_kontrak->CurrentValue;
		$this->k_no_kontrak->ViewCustomAttributes = "";

		// k_luas_lahan
		$this->k_luas_lahan->ViewValue = $this->k_luas_lahan->CurrentValue;
		$this->k_luas_lahan->ViewCustomAttributes = "";

		// pet_id
		if ($this->pet_id->VirtualValue <> "") {
			$this->pet_id->ViewValue = $this->pet_id->VirtualValue;
		} else {
		if (strval($this->pet_id->CurrentValue) <> "") {
			$sFilterWrk = "`pet_id`" . ew_SearchString("=", $this->pet_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `pet_id`, `pet_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `petani`";
		$sWhereWrk = "";
		$this->pet_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->pet_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `pet_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->pet_id->ViewValue = $this->pet_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->pet_id->ViewValue = $this->pet_id->CurrentValue;
			}
		} else {
			$this->pet_id->ViewValue = NULL;
		}
		}
		$this->pet_id->ViewCustomAttributes = "";

		// koord_id
		if ($this->koord_id->VirtualValue <> "") {
			$this->koord_id->ViewValue = $this->koord_id->VirtualValue;
		} else {
		if (strval($this->koord_id->CurrentValue) <> "") {
			$sFilterWrk = "`koord_id`" . ew_SearchString("=", $this->koord_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `koord_id`, `koord_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `koord`";
		$sWhereWrk = "";
		$this->koord_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->koord_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `koord_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->koord_id->ViewValue = $this->koord_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->koord_id->ViewValue = $this->koord_id->CurrentValue;
			}
		} else {
			$this->koord_id->ViewValue = NULL;
		}
		}
		$this->koord_id->ViewCustomAttributes = "";

		// kk_id
		if (strval($this->kk_id->CurrentValue) <> "") {
			$sFilterWrk = "`kk_id`" . ew_SearchString("=", $this->kk_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `kk_id`, `kk_periode` AS `DispFld`, `kk_tgl_mulai` AS `Disp2Fld`, `kk_tgl_akhir` AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kontrak_koord`";
		$sWhereWrk = "";
		$this->kk_id->LookupFilters = array("df2" => "5", "df3" => "5");
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->kk_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = ew_FormatDateTime($rswrk->fields('Disp2Fld'), 5);
				$arwrk[3] = ew_FormatDateTime($rswrk->fields('Disp3Fld'), 5);
				$this->kk_id->ViewValue = $this->kk_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->kk_id->ViewValue = $this->kk_id->CurrentValue;
			}
		} else {
			$this->kk_id->ViewValue = NULL;
		}
		$this->kk_id->ViewCustomAttributes = "";

		// prov_id
		if (strval($this->prov_id->CurrentValue) <> "") {
			$sFilterWrk = "`prov_id`" . ew_SearchString("=", $this->prov_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `prov_id`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `prov`";
		$sWhereWrk = "";
		$this->prov_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->prov_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `prov_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->prov_id->ViewValue = $this->prov_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->prov_id->ViewValue = $this->prov_id->CurrentValue;
			}
		} else {
			$this->prov_id->ViewValue = NULL;
		}
		$this->prov_id->ViewCustomAttributes = "";

		// kab_id
		if (strval($this->kab_id->CurrentValue) <> "") {
			$sFilterWrk = "`kab_id`" . ew_SearchString("=", $this->kab_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `kab_id`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kab`";
		$sWhereWrk = "";
		$this->kab_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->kab_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `kab_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->kab_id->ViewValue = $this->kab_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->kab_id->ViewValue = $this->kab_id->CurrentValue;
			}
		} else {
			$this->kab_id->ViewValue = NULL;
		}
		$this->kab_id->ViewCustomAttributes = "";

		// kec_id
		if ($this->kec_id->VirtualValue <> "") {
			$this->kec_id->ViewValue = $this->kec_id->VirtualValue;
		} else {
		if (strval($this->kec_id->CurrentValue) <> "") {
			$sFilterWrk = "`kec_id`" . ew_SearchString("=", $this->kec_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `kec_id`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kec`";
		$sWhereWrk = "";
		$this->kec_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->kec_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `kec_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->kec_id->ViewValue = $this->kec_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->kec_id->ViewValue = $this->kec_id->CurrentValue;
			}
		} else {
			$this->kec_id->ViewValue = NULL;
		}
		}
		$this->kec_id->ViewCustomAttributes = "";

		// desa_id
		if ($this->desa_id->VirtualValue <> "") {
			$this->desa_id->ViewValue = $this->desa_id->VirtualValue;
		} else {
		if (strval($this->desa_id->CurrentValue) <> "") {
			$sFilterWrk = "`desa_id`" . ew_SearchString("=", $this->desa_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `desa_id`, `desa_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `desa`";
		$sWhereWrk = "";
		$this->desa_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->desa_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `desa_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->desa_id->ViewValue = $this->desa_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->desa_id->ViewValue = $this->desa_id->CurrentValue;
			}
		} else {
			$this->desa_id->ViewValue = NULL;
		}
		}
		$this->desa_id->ViewCustomAttributes = "";

		// blok_id
		if ($this->blok_id->VirtualValue <> "") {
			$this->blok_id->ViewValue = $this->blok_id->VirtualValue;
		} else {
		if (strval($this->blok_id->CurrentValue) <> "") {
			$sFilterWrk = "`blok_id`" . ew_SearchString("=", $this->blok_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `blok_id`, `blok_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `blok`";
		$sWhereWrk = "";
		$this->blok_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->blok_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `blok_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->blok_id->ViewValue = $this->blok_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->blok_id->ViewValue = $this->blok_id->CurrentValue;
			}
		} else {
			$this->blok_id->ViewValue = NULL;
		}
		}
		$this->blok_id->ViewCustomAttributes = "";

		// sos_id
		if ($this->sos_id->VirtualValue <> "") {
			$this->sos_id->ViewValue = $this->sos_id->VirtualValue;
		} else {
		if (strval($this->sos_id->CurrentValue) <> "") {
			$sFilterWrk = "`sos_id`" . ew_SearchString("=", $this->sos_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `sos_id`, `sos_id` AS `DispFld`, `sos_tgl` AS `Disp2Fld`, `sos_alamat` AS `Disp3Fld`, '' AS `Disp4Fld` FROM `sosialisasi`";
		$sWhereWrk = "";
		$this->sos_id->LookupFilters = array("df2" => "0");
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->sos_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `sos_tgl` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = ew_FormatDateTime($rswrk->fields('Disp2Fld'), 0);
				$arwrk[3] = $rswrk->fields('Disp3Fld');
				$this->sos_id->ViewValue = $this->sos_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->sos_id->ViewValue = $this->sos_id->CurrentValue;
			}
		} else {
			$this->sos_id->ViewValue = NULL;
		}
		}
		$this->sos_id->ViewCustomAttributes = "";

		// var_id
		if (strval($this->var_id->CurrentValue) <> "") {
			$sFilterWrk = "`var_id`" . ew_SearchString("=", $this->var_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `var_id`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `varietas`";
		$sWhereWrk = "";
		$this->var_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->var_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `var_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->var_id->ViewValue = $this->var_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->var_id->ViewValue = $this->var_id->CurrentValue;
			}
		} else {
			$this->var_id->ViewValue = NULL;
		}
		$this->var_id->ViewCustomAttributes = "";

		// co_id
		if (strval($this->co_id->CurrentValue) <> "") {
			$sFilterWrk = "`co_id`" . ew_SearchString("=", $this->co_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `co_id`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `co`";
		$sWhereWrk = "";
		$this->co_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->co_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `co_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->co_id->ViewValue = $this->co_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->co_id->ViewValue = $this->co_id->CurrentValue;
			}
		} else {
			$this->co_id->ViewValue = NULL;
		}
		$this->co_id->ViewCustomAttributes = "";

		// k_jumlah_bibit
		$this->k_jumlah_bibit->ViewValue = $this->k_jumlah_bibit->CurrentValue;
		$this->k_jumlah_bibit->ViewCustomAttributes = "";

		// k_asal_bibit
		$this->k_asal_bibit->ViewValue = $this->k_asal_bibit->CurrentValue;
		$this->k_asal_bibit->ViewCustomAttributes = "";

		// k_tgl_tanam
		$this->k_tgl_tanam->ViewValue = $this->k_tgl_tanam->CurrentValue;
		$this->k_tgl_tanam->ViewValue = ew_FormatDateTime($this->k_tgl_tanam->ViewValue, 5);
		$this->k_tgl_tanam->ViewCustomAttributes = "";

		// k_es_tgl_panen
		$this->k_es_tgl_panen->ViewValue = $this->k_es_tgl_panen->CurrentValue;
		$this->k_es_tgl_panen->ViewValue = ew_FormatDateTime($this->k_es_tgl_panen->ViewValue, 5);
		$this->k_es_tgl_panen->ViewCustomAttributes = "";

		// k_ak_tgl_datang
		$this->k_ak_tgl_datang->ViewValue = $this->k_ak_tgl_datang->CurrentValue;
		$this->k_ak_tgl_datang->ViewValue = ew_FormatDateTime($this->k_ak_tgl_datang->ViewValue, 5);
		$this->k_ak_tgl_datang->ViewCustomAttributes = "";

		// k_es_qty
		$this->k_es_qty->ViewValue = $this->k_es_qty->CurrentValue;
		$this->k_es_qty->ViewCustomAttributes = "";

		// k_ak_qty
		$this->k_ak_qty->ViewValue = $this->k_ak_qty->CurrentValue;
		$this->k_ak_qty->ViewCustomAttributes = "";

		// k_es_perhektar
		$this->k_es_perhektar->ViewValue = $this->k_es_perhektar->CurrentValue;
		$this->k_es_perhektar->ViewCustomAttributes = "";

		// k_ak_perhektar
		$this->k_ak_perhektar->ViewValue = $this->k_ak_perhektar->CurrentValue;
		$this->k_ak_perhektar->ViewCustomAttributes = "";

		// k_skor
		$this->k_skor->ViewValue = $this->k_skor->CurrentValue;
		$this->k_skor->ViewCustomAttributes = "";

		// k_ket
		$this->k_ket->ViewValue = $this->k_ket->CurrentValue;
		$this->k_ket->ViewCustomAttributes = "";

		// k_cat
		$this->k_cat->ViewValue = $this->k_cat->CurrentValue;
		$this->k_cat->ViewCustomAttributes = "";

		// k_titik_koordinat
		$this->k_titik_koordinat->ViewValue = $this->k_titik_koordinat->CurrentValue;
		$this->k_titik_koordinat->CellCssStyle .= "text-align: left;";
		$this->k_titik_koordinat->ViewCustomAttributes = "";

		// k_foto_lahan
		$this->k_foto_lahan->UploadPath = "foto_lahan";
		if (!ew_Empty($this->k_foto_lahan->Upload->DbValue)) {
			$this->k_foto_lahan->ImageWidth = 40;
			$this->k_foto_lahan->ImageHeight = 30;
			$this->k_foto_lahan->ImageAlt = $this->k_foto_lahan->FldAlt();
			$this->k_foto_lahan->ViewValue = $this->k_foto_lahan->Upload->DbValue;
		} else {
			$this->k_foto_lahan->ViewValue = "";
		}
		$this->k_foto_lahan->CellCssStyle .= "text-align: left;";
		$this->k_foto_lahan->ViewCustomAttributes = "";

		// k_dok
		$this->k_dok->UploadPath = "dokumen_kontrak_lahan";
		if (!ew_Empty($this->k_dok->Upload->DbValue)) {
			$this->k_dok->ImageWidth = 42;
			$this->k_dok->ImageHeight = 70;
			$this->k_dok->ImageAlt = $this->k_dok->FldAlt();
			$this->k_dok->ViewValue = $this->k_dok->Upload->DbValue;
		} else {
			$this->k_dok->ViewValue = "";
		}
		$this->k_dok->ViewCustomAttributes = "";

		// k_harga_bibit
		$this->k_harga_bibit->ViewValue = $this->k_harga_bibit->CurrentValue;
		$this->k_harga_bibit->ViewCustomAttributes = "";

		// k_bayar_bibit
		$this->k_bayar_bibit->ViewValue = $this->k_bayar_bibit->CurrentValue;
		$this->k_bayar_bibit->ViewCustomAttributes = "";

		// k_pinjaman
		$this->k_pinjaman->ViewValue = $this->k_pinjaman->CurrentValue;
		$this->k_pinjaman->ViewCustomAttributes = "";

		// k_bayar_pinjaman
		$this->k_bayar_pinjaman->ViewValue = $this->k_bayar_pinjaman->CurrentValue;
		$this->k_bayar_pinjaman->ViewCustomAttributes = "";

		// k_sisa_hutang
		$this->k_sisa_hutang->ViewValue = $this->k_sisa_hutang->CurrentValue;
		$this->k_sisa_hutang->ViewCustomAttributes = "";

			// k_id_lama
			$this->k_id_lama->LinkCustomAttributes = "";
			$this->k_id_lama->HrefValue = "";
			$this->k_id_lama->TooltipValue = "";

			// k_no_kontrak
			$this->k_no_kontrak->LinkCustomAttributes = "";
			$this->k_no_kontrak->HrefValue = "";
			$this->k_no_kontrak->TooltipValue = "";

			// k_luas_lahan
			$this->k_luas_lahan->LinkCustomAttributes = "";
			$this->k_luas_lahan->HrefValue = "";
			$this->k_luas_lahan->TooltipValue = "";

			// pet_id
			$this->pet_id->LinkCustomAttributes = "";
			if (!ew_Empty($this->pet_id->CurrentValue)) {
				$this->pet_id->HrefValue = "petaniview.php?showdetail=&pet_id=" . $this->pet_id->CurrentValue; // Add prefix/suffix
				$this->pet_id->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->pet_id->HrefValue = ew_FullUrl($this->pet_id->HrefValue, "href");
			} else {
				$this->pet_id->HrefValue = "";
			}
			$this->pet_id->TooltipValue = "";

			// koord_id
			$this->koord_id->LinkCustomAttributes = "";
			if (!ew_Empty($this->koord_id->CurrentValue)) {
				$this->koord_id->HrefValue = "koordview.php?showdetail=&koord_id=" . $this->koord_id->CurrentValue; // Add prefix/suffix
				$this->koord_id->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->koord_id->HrefValue = ew_FullUrl($this->koord_id->HrefValue, "href");
			} else {
				$this->koord_id->HrefValue = "";
			}
			$this->koord_id->TooltipValue = "";

			// kk_id
			$this->kk_id->LinkCustomAttributes = "";
			if (!ew_Empty($this->kk_id->CurrentValue)) {
				$this->kk_id->HrefValue = "kontrak_koordview.php?showdetail=&kk_id=" . $this->kk_id->CurrentValue; // Add prefix/suffix
				$this->kk_id->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->kk_id->HrefValue = ew_FullUrl($this->kk_id->HrefValue, "href");
			} else {
				$this->kk_id->HrefValue = "";
			}
			$this->kk_id->TooltipValue = "";

			// prov_id
			$this->prov_id->LinkCustomAttributes = "";
			$this->prov_id->HrefValue = "";
			$this->prov_id->TooltipValue = "";

			// kab_id
			$this->kab_id->LinkCustomAttributes = "";
			$this->kab_id->HrefValue = "";
			$this->kab_id->TooltipValue = "";

			// kec_id
			$this->kec_id->LinkCustomAttributes = "";
			$this->kec_id->HrefValue = "";
			$this->kec_id->TooltipValue = "";

			// desa_id
			$this->desa_id->LinkCustomAttributes = "";
			$this->desa_id->HrefValue = "";
			$this->desa_id->TooltipValue = "";

			// blok_id
			$this->blok_id->LinkCustomAttributes = "";
			$this->blok_id->HrefValue = "";
			$this->blok_id->TooltipValue = "";

			// sos_id
			$this->sos_id->LinkCustomAttributes = "";
			$this->sos_id->HrefValue = "";
			$this->sos_id->TooltipValue = "";

			// var_id
			$this->var_id->LinkCustomAttributes = "";
			if (!ew_Empty($this->var_id->CurrentValue)) {
				$this->var_id->HrefValue = "varietasview.php?showdetail=&var_id=" . $this->var_id->CurrentValue; // Add prefix/suffix
				$this->var_id->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->var_id->HrefValue = ew_FullUrl($this->var_id->HrefValue, "href");
			} else {
				$this->var_id->HrefValue = "";
			}
			$this->var_id->TooltipValue = "";

			// co_id
			$this->co_id->LinkCustomAttributes = "";
			if (!ew_Empty($this->co_id->CurrentValue)) {
				$this->co_id->HrefValue = "coview.php?showdetail=&co_id=" . $this->co_id->CurrentValue; // Add prefix/suffix
				$this->co_id->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->co_id->HrefValue = ew_FullUrl($this->co_id->HrefValue, "href");
			} else {
				$this->co_id->HrefValue = "";
			}
			$this->co_id->TooltipValue = "";

			// k_jumlah_bibit
			$this->k_jumlah_bibit->LinkCustomAttributes = "";
			$this->k_jumlah_bibit->HrefValue = "";
			$this->k_jumlah_bibit->TooltipValue = "";

			// k_asal_bibit
			$this->k_asal_bibit->LinkCustomAttributes = "";
			$this->k_asal_bibit->HrefValue = "";
			$this->k_asal_bibit->TooltipValue = "";

			// k_tgl_tanam
			$this->k_tgl_tanam->LinkCustomAttributes = "";
			$this->k_tgl_tanam->HrefValue = "";
			$this->k_tgl_tanam->TooltipValue = "";

			// k_es_tgl_panen
			$this->k_es_tgl_panen->LinkCustomAttributes = "";
			$this->k_es_tgl_panen->HrefValue = "";
			$this->k_es_tgl_panen->TooltipValue = "";

			// k_ak_tgl_datang
			$this->k_ak_tgl_datang->LinkCustomAttributes = "";
			$this->k_ak_tgl_datang->HrefValue = "";
			$this->k_ak_tgl_datang->TooltipValue = "";

			// k_ak_qty
			$this->k_ak_qty->LinkCustomAttributes = "";
			$this->k_ak_qty->HrefValue = "";
			$this->k_ak_qty->TooltipValue = "";

			// k_es_perhektar
			$this->k_es_perhektar->LinkCustomAttributes = "";
			$this->k_es_perhektar->HrefValue = "";
			$this->k_es_perhektar->TooltipValue = "";

			// k_ket
			$this->k_ket->LinkCustomAttributes = "";
			$this->k_ket->HrefValue = "";
			$this->k_ket->TooltipValue = "";

			// k_cat
			$this->k_cat->LinkCustomAttributes = "";
			$this->k_cat->HrefValue = "";
			$this->k_cat->TooltipValue = "";

			// k_titik_koordinat
			$this->k_titik_koordinat->LinkCustomAttributes = "";
			if (!ew_Empty($this->k_titik_koordinat->CurrentValue)) {
				$this->k_titik_koordinat->HrefValue = ((!empty($this->k_titik_koordinat->ViewValue) && !is_array($this->k_titik_koordinat->ViewValue)) ? ew_RemoveHtml($this->k_titik_koordinat->ViewValue) : $this->k_titik_koordinat->CurrentValue); // Add prefix/suffix
				$this->k_titik_koordinat->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->k_titik_koordinat->HrefValue = ew_FullUrl($this->k_titik_koordinat->HrefValue, "href");
			} else {
				$this->k_titik_koordinat->HrefValue = "";
			}
			$this->k_titik_koordinat->TooltipValue = "";

			// k_foto_lahan
			$this->k_foto_lahan->LinkCustomAttributes = "";
			$this->k_foto_lahan->UploadPath = "foto_lahan";
			if (!ew_Empty($this->k_foto_lahan->Upload->DbValue)) {
				$this->k_foto_lahan->HrefValue = "%u"; // Add prefix/suffix
				$this->k_foto_lahan->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->k_foto_lahan->HrefValue = ew_FullUrl($this->k_foto_lahan->HrefValue, "href");
			} else {
				$this->k_foto_lahan->HrefValue = "";
			}
			$this->k_foto_lahan->HrefValue2 = $this->k_foto_lahan->UploadPath . $this->k_foto_lahan->Upload->DbValue;
			$this->k_foto_lahan->TooltipValue = "";
			if ($this->k_foto_lahan->UseColorbox) {
				if (ew_Empty($this->k_foto_lahan->TooltipValue))
					$this->k_foto_lahan->LinkAttrs["title"] = $Language->Phrase("ViewImageGallery");
				$this->k_foto_lahan->LinkAttrs["data-rel"] = "kontrak_x_k_foto_lahan";
				ew_AppendClass($this->k_foto_lahan->LinkAttrs["class"], "ewLightbox");
			}

			// k_dok
			$this->k_dok->LinkCustomAttributes = "";
			$this->k_dok->UploadPath = "dokumen_kontrak_lahan";
			if (!ew_Empty($this->k_dok->Upload->DbValue)) {
				$this->k_dok->HrefValue = "%u"; // Add prefix/suffix
				$this->k_dok->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->k_dok->HrefValue = ew_FullUrl($this->k_dok->HrefValue, "href");
			} else {
				$this->k_dok->HrefValue = "";
			}
			$this->k_dok->HrefValue2 = $this->k_dok->UploadPath . $this->k_dok->Upload->DbValue;
			$this->k_dok->TooltipValue = "";
			if ($this->k_dok->UseColorbox) {
				if (ew_Empty($this->k_dok->TooltipValue))
					$this->k_dok->LinkAttrs["title"] = $Language->Phrase("ViewImageGallery");
				$this->k_dok->LinkAttrs["data-rel"] = "kontrak_x_k_dok";
				ew_AppendClass($this->k_dok->LinkAttrs["class"], "ewLightbox");
			}

			// k_harga_bibit
			$this->k_harga_bibit->LinkCustomAttributes = "";
			$this->k_harga_bibit->HrefValue = "";
			$this->k_harga_bibit->TooltipValue = "";

			// k_bayar_bibit
			$this->k_bayar_bibit->LinkCustomAttributes = "";
			$this->k_bayar_bibit->HrefValue = "";
			$this->k_bayar_bibit->TooltipValue = "";

			// k_pinjaman
			$this->k_pinjaman->LinkCustomAttributes = "";
			$this->k_pinjaman->HrefValue = "";
			$this->k_pinjaman->TooltipValue = "";

			// k_bayar_pinjaman
			$this->k_bayar_pinjaman->LinkCustomAttributes = "";
			$this->k_bayar_pinjaman->HrefValue = "";
			$this->k_bayar_pinjaman->TooltipValue = "";

			// k_sisa_hutang
			$this->k_sisa_hutang->LinkCustomAttributes = "";
			$this->k_sisa_hutang->HrefValue = "";
			$this->k_sisa_hutang->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_EDIT) { // Edit row

			// k_id_lama
			$this->k_id_lama->EditAttrs["class"] = "form-control";
			$this->k_id_lama->EditCustomAttributes = "";
			$this->k_id_lama->EditValue = ew_HtmlEncode($this->k_id_lama->CurrentValue);
			$this->k_id_lama->PlaceHolder = ew_RemoveHtml($this->k_id_lama->FldCaption());

			// k_no_kontrak
			$this->k_no_kontrak->EditAttrs["class"] = "form-control";
			$this->k_no_kontrak->EditCustomAttributes = "";
			$this->k_no_kontrak->EditValue = ew_HtmlEncode($this->k_no_kontrak->CurrentValue);
			$this->k_no_kontrak->PlaceHolder = ew_RemoveHtml($this->k_no_kontrak->FldCaption());

			// k_luas_lahan
			$this->k_luas_lahan->EditAttrs["class"] = "form-control";
			$this->k_luas_lahan->EditCustomAttributes = "";
			$this->k_luas_lahan->EditValue = ew_HtmlEncode($this->k_luas_lahan->CurrentValue);
			$this->k_luas_lahan->PlaceHolder = ew_RemoveHtml($this->k_luas_lahan->FldCaption());

			// pet_id
			$this->pet_id->EditAttrs["class"] = "form-control";
			$this->pet_id->EditCustomAttributes = "";
			if (trim(strval($this->pet_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`pet_id`" . ew_SearchString("=", $this->pet_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `pet_id`, `pet_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `petani`";
			$sWhereWrk = "";
			$this->pet_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->pet_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `pet_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->pet_id->EditValue = $arwrk;

			// koord_id
			$this->koord_id->EditAttrs["class"] = "form-control";
			$this->koord_id->EditCustomAttributes = "";
			if (trim(strval($this->koord_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`koord_id`" . ew_SearchString("=", $this->koord_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `koord_id`, `koord_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `koord`";
			$sWhereWrk = "";
			$this->koord_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->koord_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `koord_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->koord_id->EditValue = $arwrk;

			// kk_id
			$this->kk_id->EditAttrs["class"] = "form-control";
			$this->kk_id->EditCustomAttributes = "";
			if (trim(strval($this->kk_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`kk_id`" . ew_SearchString("=", $this->kk_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `kk_id`, `kk_periode` AS `DispFld`, `kk_tgl_mulai` AS `Disp2Fld`, `kk_tgl_akhir` AS `Disp3Fld`, '' AS `Disp4Fld`, `koord_id` AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `kontrak_koord`";
			$sWhereWrk = "";
			$this->kk_id->LookupFilters = array("df2" => "5", "df3" => "5");
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->kk_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$rowswrk = count($arwrk);
			for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
				$arwrk[$rowcntwrk][2] = ew_FormatDateTime($arwrk[$rowcntwrk][2], 5);
				$arwrk[$rowcntwrk][3] = ew_FormatDateTime($arwrk[$rowcntwrk][3], 5);
			}
			$this->kk_id->EditValue = $arwrk;

			// prov_id
			$this->prov_id->EditAttrs["class"] = "form-control";
			$this->prov_id->EditCustomAttributes = "";
			if (trim(strval($this->prov_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`prov_id`" . ew_SearchString("=", $this->prov_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `prov_id`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `prov`";
			$sWhereWrk = "";
			$this->prov_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->prov_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `prov_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->prov_id->EditValue = $arwrk;

			// kab_id
			$this->kab_id->EditAttrs["class"] = "form-control";
			$this->kab_id->EditCustomAttributes = "";
			if (trim(strval($this->kab_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`kab_id`" . ew_SearchString("=", $this->kab_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `kab_id`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, `kab_prov_id` AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `kab`";
			$sWhereWrk = "";
			$this->kab_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->kab_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `kab_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->kab_id->EditValue = $arwrk;

			// kec_id
			$this->kec_id->EditAttrs["class"] = "form-control";
			$this->kec_id->EditCustomAttributes = "";
			if (trim(strval($this->kec_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`kec_id`" . ew_SearchString("=", $this->kec_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `kec_id`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, `kec_prov_id` AS `SelectFilterFld`, `kec_kab_id` AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `kec`";
			$sWhereWrk = "";
			$this->kec_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->kec_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `kec_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->kec_id->EditValue = $arwrk;

			// desa_id
			$this->desa_id->EditAttrs["class"] = "form-control";
			$this->desa_id->EditCustomAttributes = "";
			if (trim(strval($this->desa_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`desa_id`" . ew_SearchString("=", $this->desa_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `desa_id`, `desa_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `desa`";
			$sWhereWrk = "";
			$this->desa_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->desa_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `desa_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->desa_id->EditValue = $arwrk;

			// blok_id
			$this->blok_id->EditAttrs["class"] = "form-control";
			$this->blok_id->EditCustomAttributes = "";
			if (trim(strval($this->blok_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`blok_id`" . ew_SearchString("=", $this->blok_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `blok_id`, `blok_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `blok`";
			$sWhereWrk = "";
			$this->blok_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->blok_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `blok_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->blok_id->EditValue = $arwrk;

			// sos_id
			$this->sos_id->EditAttrs["class"] = "form-control";
			$this->sos_id->EditCustomAttributes = "";
			if (trim(strval($this->sos_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`sos_id`" . ew_SearchString("=", $this->sos_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `sos_id`, `sos_id` AS `DispFld`, `sos_tgl` AS `Disp2Fld`, `sos_alamat` AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `sosialisasi`";
			$sWhereWrk = "";
			$this->sos_id->LookupFilters = array("df2" => "0");
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->sos_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `sos_tgl` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$rowswrk = count($arwrk);
			for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
				$arwrk[$rowcntwrk][2] = ew_FormatDateTime($arwrk[$rowcntwrk][2], 0);
			}
			$this->sos_id->EditValue = $arwrk;

			// var_id
			$this->var_id->EditAttrs["class"] = "form-control";
			$this->var_id->EditCustomAttributes = "";
			if (trim(strval($this->var_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`var_id`" . ew_SearchString("=", $this->var_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `var_id`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `varietas`";
			$sWhereWrk = "";
			$this->var_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->var_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `var_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->var_id->EditValue = $arwrk;

			// co_id
			$this->co_id->EditAttrs["class"] = "form-control";
			$this->co_id->EditCustomAttributes = "";
			if (trim(strval($this->co_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`co_id`" . ew_SearchString("=", $this->co_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `co_id`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `co`";
			$sWhereWrk = "";
			$this->co_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->co_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `co_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->co_id->EditValue = $arwrk;

			// k_jumlah_bibit
			$this->k_jumlah_bibit->EditAttrs["class"] = "form-control";
			$this->k_jumlah_bibit->EditCustomAttributes = "";
			$this->k_jumlah_bibit->EditValue = ew_HtmlEncode($this->k_jumlah_bibit->CurrentValue);
			$this->k_jumlah_bibit->PlaceHolder = ew_RemoveHtml($this->k_jumlah_bibit->FldCaption());

			// k_asal_bibit
			$this->k_asal_bibit->EditAttrs["class"] = "form-control";
			$this->k_asal_bibit->EditCustomAttributes = "";
			$this->k_asal_bibit->EditValue = ew_HtmlEncode($this->k_asal_bibit->CurrentValue);
			$this->k_asal_bibit->PlaceHolder = ew_RemoveHtml($this->k_asal_bibit->FldCaption());

			// k_tgl_tanam
			$this->k_tgl_tanam->EditAttrs["class"] = "form-control";
			$this->k_tgl_tanam->EditCustomAttributes = "";
			$this->k_tgl_tanam->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->k_tgl_tanam->CurrentValue, 5));
			$this->k_tgl_tanam->PlaceHolder = ew_RemoveHtml($this->k_tgl_tanam->FldCaption());

			// k_es_tgl_panen
			$this->k_es_tgl_panen->EditAttrs["class"] = "form-control";
			$this->k_es_tgl_panen->EditCustomAttributes = "";
			$this->k_es_tgl_panen->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->k_es_tgl_panen->CurrentValue, 5));
			$this->k_es_tgl_panen->PlaceHolder = ew_RemoveHtml($this->k_es_tgl_panen->FldCaption());

			// k_ak_tgl_datang
			$this->k_ak_tgl_datang->EditAttrs["class"] = "form-control";
			$this->k_ak_tgl_datang->EditCustomAttributes = "";
			$this->k_ak_tgl_datang->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->k_ak_tgl_datang->CurrentValue, 5));
			$this->k_ak_tgl_datang->PlaceHolder = ew_RemoveHtml($this->k_ak_tgl_datang->FldCaption());

			// k_ak_qty
			$this->k_ak_qty->EditAttrs["class"] = "form-control";
			$this->k_ak_qty->EditCustomAttributes = "";
			$this->k_ak_qty->EditValue = ew_HtmlEncode($this->k_ak_qty->CurrentValue);
			$this->k_ak_qty->PlaceHolder = ew_RemoveHtml($this->k_ak_qty->FldCaption());

			// k_es_perhektar
			$this->k_es_perhektar->EditAttrs["class"] = "form-control";
			$this->k_es_perhektar->EditCustomAttributes = "";
			$this->k_es_perhektar->EditValue = ew_HtmlEncode($this->k_es_perhektar->CurrentValue);
			$this->k_es_perhektar->PlaceHolder = ew_RemoveHtml($this->k_es_perhektar->FldCaption());

			// k_ket
			$this->k_ket->EditAttrs["class"] = "form-control";
			$this->k_ket->EditCustomAttributes = "";
			$this->k_ket->EditValue = ew_HtmlEncode($this->k_ket->CurrentValue);
			$this->k_ket->PlaceHolder = ew_RemoveHtml($this->k_ket->FldCaption());

			// k_cat
			$this->k_cat->EditAttrs["class"] = "form-control";
			$this->k_cat->EditCustomAttributes = "";
			$this->k_cat->EditValue = ew_HtmlEncode($this->k_cat->CurrentValue);
			$this->k_cat->PlaceHolder = ew_RemoveHtml($this->k_cat->FldCaption());

			// k_titik_koordinat
			$this->k_titik_koordinat->EditAttrs["class"] = "form-control";
			$this->k_titik_koordinat->EditCustomAttributes = "";
			$this->k_titik_koordinat->EditValue = ew_HtmlEncode($this->k_titik_koordinat->CurrentValue);
			$this->k_titik_koordinat->PlaceHolder = ew_RemoveHtml($this->k_titik_koordinat->FldCaption());

			// k_foto_lahan
			$this->k_foto_lahan->EditAttrs["class"] = "form-control";
			$this->k_foto_lahan->EditCustomAttributes = "";
			$this->k_foto_lahan->UploadPath = "foto_lahan";
			if (!ew_Empty($this->k_foto_lahan->Upload->DbValue)) {
				$this->k_foto_lahan->ImageWidth = 40;
				$this->k_foto_lahan->ImageHeight = 30;
				$this->k_foto_lahan->ImageAlt = $this->k_foto_lahan->FldAlt();
				$this->k_foto_lahan->EditValue = $this->k_foto_lahan->Upload->DbValue;
			} else {
				$this->k_foto_lahan->EditValue = "";
			}
			if (!ew_Empty($this->k_foto_lahan->CurrentValue))
					$this->k_foto_lahan->Upload->FileName = $this->k_foto_lahan->CurrentValue;
			if ($this->CurrentAction == "I" && !$this->EventCancelled) ew_RenderUploadField($this->k_foto_lahan);

			// k_dok
			$this->k_dok->EditAttrs["class"] = "form-control";
			$this->k_dok->EditCustomAttributes = "";
			$this->k_dok->UploadPath = "dokumen_kontrak_lahan";
			if (!ew_Empty($this->k_dok->Upload->DbValue)) {
				$this->k_dok->ImageWidth = 42;
				$this->k_dok->ImageHeight = 70;
				$this->k_dok->ImageAlt = $this->k_dok->FldAlt();
				$this->k_dok->EditValue = $this->k_dok->Upload->DbValue;
			} else {
				$this->k_dok->EditValue = "";
			}
			if (!ew_Empty($this->k_dok->CurrentValue))
					$this->k_dok->Upload->FileName = $this->k_dok->CurrentValue;
			if ($this->CurrentAction == "I" && !$this->EventCancelled) ew_RenderUploadField($this->k_dok);

			// k_harga_bibit
			$this->k_harga_bibit->EditAttrs["class"] = "form-control";
			$this->k_harga_bibit->EditCustomAttributes = "";
			$this->k_harga_bibit->EditValue = ew_HtmlEncode($this->k_harga_bibit->CurrentValue);
			$this->k_harga_bibit->PlaceHolder = ew_RemoveHtml($this->k_harga_bibit->FldCaption());

			// k_bayar_bibit
			$this->k_bayar_bibit->EditAttrs["class"] = "form-control";
			$this->k_bayar_bibit->EditCustomAttributes = "";
			$this->k_bayar_bibit->EditValue = ew_HtmlEncode($this->k_bayar_bibit->CurrentValue);
			$this->k_bayar_bibit->PlaceHolder = ew_RemoveHtml($this->k_bayar_bibit->FldCaption());

			// k_pinjaman
			$this->k_pinjaman->EditAttrs["class"] = "form-control";
			$this->k_pinjaman->EditCustomAttributes = "";
			$this->k_pinjaman->EditValue = ew_HtmlEncode($this->k_pinjaman->CurrentValue);
			$this->k_pinjaman->PlaceHolder = ew_RemoveHtml($this->k_pinjaman->FldCaption());

			// k_bayar_pinjaman
			$this->k_bayar_pinjaman->EditAttrs["class"] = "form-control";
			$this->k_bayar_pinjaman->EditCustomAttributes = "";
			$this->k_bayar_pinjaman->EditValue = ew_HtmlEncode($this->k_bayar_pinjaman->CurrentValue);
			$this->k_bayar_pinjaman->PlaceHolder = ew_RemoveHtml($this->k_bayar_pinjaman->FldCaption());

			// k_sisa_hutang
			$this->k_sisa_hutang->EditAttrs["class"] = "form-control";
			$this->k_sisa_hutang->EditCustomAttributes = "";
			$this->k_sisa_hutang->EditValue = ew_HtmlEncode($this->k_sisa_hutang->CurrentValue);
			$this->k_sisa_hutang->PlaceHolder = ew_RemoveHtml($this->k_sisa_hutang->FldCaption());

			// Edit refer script
			// k_id_lama

			$this->k_id_lama->LinkCustomAttributes = "";
			$this->k_id_lama->HrefValue = "";

			// k_no_kontrak
			$this->k_no_kontrak->LinkCustomAttributes = "";
			$this->k_no_kontrak->HrefValue = "";

			// k_luas_lahan
			$this->k_luas_lahan->LinkCustomAttributes = "";
			$this->k_luas_lahan->HrefValue = "";

			// pet_id
			$this->pet_id->LinkCustomAttributes = "";
			if (!ew_Empty($this->pet_id->CurrentValue)) {
				$this->pet_id->HrefValue = "petaniview.php?showdetail=&pet_id=" . $this->pet_id->CurrentValue; // Add prefix/suffix
				$this->pet_id->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->pet_id->HrefValue = ew_FullUrl($this->pet_id->HrefValue, "href");
			} else {
				$this->pet_id->HrefValue = "";
			}

			// koord_id
			$this->koord_id->LinkCustomAttributes = "";
			if (!ew_Empty($this->koord_id->CurrentValue)) {
				$this->koord_id->HrefValue = "koordview.php?showdetail=&koord_id=" . $this->koord_id->CurrentValue; // Add prefix/suffix
				$this->koord_id->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->koord_id->HrefValue = ew_FullUrl($this->koord_id->HrefValue, "href");
			} else {
				$this->koord_id->HrefValue = "";
			}

			// kk_id
			$this->kk_id->LinkCustomAttributes = "";
			if (!ew_Empty($this->kk_id->CurrentValue)) {
				$this->kk_id->HrefValue = "kontrak_koordview.php?showdetail=&kk_id=" . $this->kk_id->CurrentValue; // Add prefix/suffix
				$this->kk_id->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->kk_id->HrefValue = ew_FullUrl($this->kk_id->HrefValue, "href");
			} else {
				$this->kk_id->HrefValue = "";
			}

			// prov_id
			$this->prov_id->LinkCustomAttributes = "";
			$this->prov_id->HrefValue = "";

			// kab_id
			$this->kab_id->LinkCustomAttributes = "";
			$this->kab_id->HrefValue = "";

			// kec_id
			$this->kec_id->LinkCustomAttributes = "";
			$this->kec_id->HrefValue = "";

			// desa_id
			$this->desa_id->LinkCustomAttributes = "";
			$this->desa_id->HrefValue = "";

			// blok_id
			$this->blok_id->LinkCustomAttributes = "";
			$this->blok_id->HrefValue = "";

			// sos_id
			$this->sos_id->LinkCustomAttributes = "";
			$this->sos_id->HrefValue = "";

			// var_id
			$this->var_id->LinkCustomAttributes = "";
			if (!ew_Empty($this->var_id->CurrentValue)) {
				$this->var_id->HrefValue = "varietasview.php?showdetail=&var_id=" . $this->var_id->CurrentValue; // Add prefix/suffix
				$this->var_id->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->var_id->HrefValue = ew_FullUrl($this->var_id->HrefValue, "href");
			} else {
				$this->var_id->HrefValue = "";
			}

			// co_id
			$this->co_id->LinkCustomAttributes = "";
			if (!ew_Empty($this->co_id->CurrentValue)) {
				$this->co_id->HrefValue = "coview.php?showdetail=&co_id=" . $this->co_id->CurrentValue; // Add prefix/suffix
				$this->co_id->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->co_id->HrefValue = ew_FullUrl($this->co_id->HrefValue, "href");
			} else {
				$this->co_id->HrefValue = "";
			}

			// k_jumlah_bibit
			$this->k_jumlah_bibit->LinkCustomAttributes = "";
			$this->k_jumlah_bibit->HrefValue = "";

			// k_asal_bibit
			$this->k_asal_bibit->LinkCustomAttributes = "";
			$this->k_asal_bibit->HrefValue = "";

			// k_tgl_tanam
			$this->k_tgl_tanam->LinkCustomAttributes = "";
			$this->k_tgl_tanam->HrefValue = "";

			// k_es_tgl_panen
			$this->k_es_tgl_panen->LinkCustomAttributes = "";
			$this->k_es_tgl_panen->HrefValue = "";

			// k_ak_tgl_datang
			$this->k_ak_tgl_datang->LinkCustomAttributes = "";
			$this->k_ak_tgl_datang->HrefValue = "";

			// k_ak_qty
			$this->k_ak_qty->LinkCustomAttributes = "";
			$this->k_ak_qty->HrefValue = "";

			// k_es_perhektar
			$this->k_es_perhektar->LinkCustomAttributes = "";
			$this->k_es_perhektar->HrefValue = "";

			// k_ket
			$this->k_ket->LinkCustomAttributes = "";
			$this->k_ket->HrefValue = "";

			// k_cat
			$this->k_cat->LinkCustomAttributes = "";
			$this->k_cat->HrefValue = "";

			// k_titik_koordinat
			$this->k_titik_koordinat->LinkCustomAttributes = "";
			if (!ew_Empty($this->k_titik_koordinat->CurrentValue)) {
				$this->k_titik_koordinat->HrefValue = ((!empty($this->k_titik_koordinat->EditValue) && !is_array($this->k_titik_koordinat->EditValue)) ? ew_RemoveHtml($this->k_titik_koordinat->EditValue) : $this->k_titik_koordinat->CurrentValue); // Add prefix/suffix
				$this->k_titik_koordinat->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->k_titik_koordinat->HrefValue = ew_FullUrl($this->k_titik_koordinat->HrefValue, "href");
			} else {
				$this->k_titik_koordinat->HrefValue = "";
			}

			// k_foto_lahan
			$this->k_foto_lahan->LinkCustomAttributes = "";
			$this->k_foto_lahan->UploadPath = "foto_lahan";
			if (!ew_Empty($this->k_foto_lahan->Upload->DbValue)) {
				$this->k_foto_lahan->HrefValue = "%u"; // Add prefix/suffix
				$this->k_foto_lahan->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->k_foto_lahan->HrefValue = ew_FullUrl($this->k_foto_lahan->HrefValue, "href");
			} else {
				$this->k_foto_lahan->HrefValue = "";
			}
			$this->k_foto_lahan->HrefValue2 = $this->k_foto_lahan->UploadPath . $this->k_foto_lahan->Upload->DbValue;

			// k_dok
			$this->k_dok->LinkCustomAttributes = "";
			$this->k_dok->UploadPath = "dokumen_kontrak_lahan";
			if (!ew_Empty($this->k_dok->Upload->DbValue)) {
				$this->k_dok->HrefValue = "%u"; // Add prefix/suffix
				$this->k_dok->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->k_dok->HrefValue = ew_FullUrl($this->k_dok->HrefValue, "href");
			} else {
				$this->k_dok->HrefValue = "";
			}
			$this->k_dok->HrefValue2 = $this->k_dok->UploadPath . $this->k_dok->Upload->DbValue;

			// k_harga_bibit
			$this->k_harga_bibit->LinkCustomAttributes = "";
			$this->k_harga_bibit->HrefValue = "";

			// k_bayar_bibit
			$this->k_bayar_bibit->LinkCustomAttributes = "";
			$this->k_bayar_bibit->HrefValue = "";

			// k_pinjaman
			$this->k_pinjaman->LinkCustomAttributes = "";
			$this->k_pinjaman->HrefValue = "";

			// k_bayar_pinjaman
			$this->k_bayar_pinjaman->LinkCustomAttributes = "";
			$this->k_bayar_pinjaman->HrefValue = "";

			// k_sisa_hutang
			$this->k_sisa_hutang->LinkCustomAttributes = "";
			$this->k_sisa_hutang->HrefValue = "";
		}
		if ($this->RowType == EW_ROWTYPE_ADD || $this->RowType == EW_ROWTYPE_EDIT || $this->RowType == EW_ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->SetupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $Language, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return ($gsFormError == "");
		if (!$this->k_luas_lahan->FldIsDetailKey && !is_null($this->k_luas_lahan->FormValue) && $this->k_luas_lahan->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->k_luas_lahan->FldCaption(), $this->k_luas_lahan->ReqErrMsg));
		}
		if (!ew_CheckInteger($this->k_luas_lahan->FormValue)) {
			ew_AddMessage($gsFormError, $this->k_luas_lahan->FldErrMsg());
		}
		if (!ew_CheckInteger($this->k_jumlah_bibit->FormValue)) {
			ew_AddMessage($gsFormError, $this->k_jumlah_bibit->FldErrMsg());
		}
		if (!ew_CheckDate($this->k_tgl_tanam->FormValue)) {
			ew_AddMessage($gsFormError, $this->k_tgl_tanam->FldErrMsg());
		}
		if (!ew_CheckDate($this->k_es_tgl_panen->FormValue)) {
			ew_AddMessage($gsFormError, $this->k_es_tgl_panen->FldErrMsg());
		}
		if (!ew_CheckDate($this->k_ak_tgl_datang->FormValue)) {
			ew_AddMessage($gsFormError, $this->k_ak_tgl_datang->FldErrMsg());
		}
		if (!ew_CheckInteger($this->k_ak_qty->FormValue)) {
			ew_AddMessage($gsFormError, $this->k_ak_qty->FldErrMsg());
		}
		if (!ew_CheckInteger($this->k_es_perhektar->FormValue)) {
			ew_AddMessage($gsFormError, $this->k_es_perhektar->FldErrMsg());
		}
		if (!$this->k_harga_bibit->FldIsDetailKey && !is_null($this->k_harga_bibit->FormValue) && $this->k_harga_bibit->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->k_harga_bibit->FldCaption(), $this->k_harga_bibit->ReqErrMsg));
		}
		if (!ew_CheckInteger($this->k_harga_bibit->FormValue)) {
			ew_AddMessage($gsFormError, $this->k_harga_bibit->FldErrMsg());
		}
		if (!$this->k_bayar_bibit->FldIsDetailKey && !is_null($this->k_bayar_bibit->FormValue) && $this->k_bayar_bibit->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->k_bayar_bibit->FldCaption(), $this->k_bayar_bibit->ReqErrMsg));
		}
		if (!ew_CheckInteger($this->k_bayar_bibit->FormValue)) {
			ew_AddMessage($gsFormError, $this->k_bayar_bibit->FldErrMsg());
		}
		if (!$this->k_pinjaman->FldIsDetailKey && !is_null($this->k_pinjaman->FormValue) && $this->k_pinjaman->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->k_pinjaman->FldCaption(), $this->k_pinjaman->ReqErrMsg));
		}
		if (!ew_CheckInteger($this->k_pinjaman->FormValue)) {
			ew_AddMessage($gsFormError, $this->k_pinjaman->FldErrMsg());
		}
		if (!$this->k_bayar_pinjaman->FldIsDetailKey && !is_null($this->k_bayar_pinjaman->FormValue) && $this->k_bayar_pinjaman->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->k_bayar_pinjaman->FldCaption(), $this->k_bayar_pinjaman->ReqErrMsg));
		}
		if (!ew_CheckInteger($this->k_bayar_pinjaman->FormValue)) {
			ew_AddMessage($gsFormError, $this->k_bayar_pinjaman->FldErrMsg());
		}
		if (!$this->k_sisa_hutang->FldIsDetailKey && !is_null($this->k_sisa_hutang->FormValue) && $this->k_sisa_hutang->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->k_sisa_hutang->FldCaption(), $this->k_sisa_hutang->ReqErrMsg));
		}
		if (!ew_CheckInteger($this->k_sisa_hutang->FormValue)) {
			ew_AddMessage($gsFormError, $this->k_sisa_hutang->FldErrMsg());
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsFormError, $sFormCustomError);
		}
		return $ValidateForm;
	}

	// Update record based on key values
	function EditRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();
		$sFilter = $this->ApplyUserIDFilters($sFilter);
		$conn = &$this->Connection();
		if ($this->k_no_kontrak->CurrentValue <> "") { // Check field with unique index
			$sFilterChk = "(`k_no_kontrak` = '" . ew_AdjustSql($this->k_no_kontrak->CurrentValue, $this->DBID) . "')";
			$sFilterChk .= " AND NOT (" . $sFilter . ")";
			$this->CurrentFilter = $sFilterChk;
			$sSqlChk = $this->SQL();
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			$rsChk = $conn->Execute($sSqlChk);
			$conn->raiseErrorFn = '';
			if ($rsChk === FALSE) {
				return FALSE;
			} elseif (!$rsChk->EOF) {
				$sIdxErrMsg = str_replace("%f", $this->k_no_kontrak->FldCaption(), $Language->Phrase("DupIndex"));
				$sIdxErrMsg = str_replace("%v", $this->k_no_kontrak->CurrentValue, $sIdxErrMsg);
				$this->setFailureMessage($sIdxErrMsg);
				$rsChk->Close();
				return FALSE;
			}
			$rsChk->Close();
		}
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
		$rs = $conn->Execute($sSql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->Phrase("NoRecord")); // Set no record message
			$EditRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->LoadDbValues($rsold);
			$this->k_foto_lahan->OldUploadPath = "foto_lahan";
			$this->k_foto_lahan->UploadPath = $this->k_foto_lahan->OldUploadPath;
			$this->k_dok->OldUploadPath = "dokumen_kontrak_lahan";
			$this->k_dok->UploadPath = $this->k_dok->OldUploadPath;
			$rsnew = array();

			// k_id_lama
			$this->k_id_lama->SetDbValueDef($rsnew, $this->k_id_lama->CurrentValue, NULL, $this->k_id_lama->ReadOnly);

			// k_no_kontrak
			$this->k_no_kontrak->SetDbValueDef($rsnew, $this->k_no_kontrak->CurrentValue, NULL, $this->k_no_kontrak->ReadOnly);

			// k_luas_lahan
			$this->k_luas_lahan->SetDbValueDef($rsnew, $this->k_luas_lahan->CurrentValue, 0, $this->k_luas_lahan->ReadOnly);

			// pet_id
			$this->pet_id->SetDbValueDef($rsnew, $this->pet_id->CurrentValue, NULL, $this->pet_id->ReadOnly);

			// koord_id
			$this->koord_id->SetDbValueDef($rsnew, $this->koord_id->CurrentValue, NULL, $this->koord_id->ReadOnly);

			// kk_id
			$this->kk_id->SetDbValueDef($rsnew, $this->kk_id->CurrentValue, NULL, $this->kk_id->ReadOnly);

			// prov_id
			$this->prov_id->SetDbValueDef($rsnew, $this->prov_id->CurrentValue, NULL, $this->prov_id->ReadOnly);

			// kab_id
			$this->kab_id->SetDbValueDef($rsnew, $this->kab_id->CurrentValue, NULL, $this->kab_id->ReadOnly);

			// kec_id
			$this->kec_id->SetDbValueDef($rsnew, $this->kec_id->CurrentValue, NULL, $this->kec_id->ReadOnly);

			// desa_id
			$this->desa_id->SetDbValueDef($rsnew, $this->desa_id->CurrentValue, NULL, $this->desa_id->ReadOnly);

			// blok_id
			$this->blok_id->SetDbValueDef($rsnew, $this->blok_id->CurrentValue, NULL, $this->blok_id->ReadOnly);

			// sos_id
			$this->sos_id->SetDbValueDef($rsnew, $this->sos_id->CurrentValue, NULL, $this->sos_id->ReadOnly);

			// var_id
			$this->var_id->SetDbValueDef($rsnew, $this->var_id->CurrentValue, NULL, $this->var_id->ReadOnly);

			// co_id
			$this->co_id->SetDbValueDef($rsnew, $this->co_id->CurrentValue, NULL, $this->co_id->ReadOnly);

			// k_jumlah_bibit
			$this->k_jumlah_bibit->SetDbValueDef($rsnew, $this->k_jumlah_bibit->CurrentValue, NULL, $this->k_jumlah_bibit->ReadOnly);

			// k_asal_bibit
			$this->k_asal_bibit->SetDbValueDef($rsnew, $this->k_asal_bibit->CurrentValue, NULL, $this->k_asal_bibit->ReadOnly);

			// k_tgl_tanam
			$this->k_tgl_tanam->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->k_tgl_tanam->CurrentValue, 5), NULL, $this->k_tgl_tanam->ReadOnly);

			// k_es_tgl_panen
			$this->k_es_tgl_panen->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->k_es_tgl_panen->CurrentValue, 5), NULL, $this->k_es_tgl_panen->ReadOnly);

			// k_ak_tgl_datang
			$this->k_ak_tgl_datang->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->k_ak_tgl_datang->CurrentValue, 5), NULL, $this->k_ak_tgl_datang->ReadOnly);

			// k_ak_qty
			$this->k_ak_qty->SetDbValueDef($rsnew, $this->k_ak_qty->CurrentValue, NULL, $this->k_ak_qty->ReadOnly);

			// k_es_perhektar
			$this->k_es_perhektar->SetDbValueDef($rsnew, $this->k_es_perhektar->CurrentValue, NULL, $this->k_es_perhektar->ReadOnly);

			// k_ket
			$this->k_ket->SetDbValueDef($rsnew, $this->k_ket->CurrentValue, NULL, $this->k_ket->ReadOnly);

			// k_cat
			$this->k_cat->SetDbValueDef($rsnew, $this->k_cat->CurrentValue, NULL, $this->k_cat->ReadOnly);

			// k_titik_koordinat
			$this->k_titik_koordinat->SetDbValueDef($rsnew, $this->k_titik_koordinat->CurrentValue, NULL, $this->k_titik_koordinat->ReadOnly);

			// k_foto_lahan
			if ($this->k_foto_lahan->Visible && !$this->k_foto_lahan->ReadOnly && !$this->k_foto_lahan->Upload->KeepFile) {
				$this->k_foto_lahan->Upload->DbValue = $rsold['k_foto_lahan']; // Get original value
				if ($this->k_foto_lahan->Upload->FileName == "") {
					$rsnew['k_foto_lahan'] = NULL;
				} else {
					$rsnew['k_foto_lahan'] = $this->k_foto_lahan->Upload->FileName;
				}
				$this->k_foto_lahan->ImageWidth = 400; // Resize width
				$this->k_foto_lahan->ImageHeight = 300; // Resize height
			}

			// k_dok
			if ($this->k_dok->Visible && !$this->k_dok->ReadOnly && !$this->k_dok->Upload->KeepFile) {
				$this->k_dok->Upload->DbValue = $rsold['k_dok']; // Get original value
				if ($this->k_dok->Upload->FileName == "") {
					$rsnew['k_dok'] = NULL;
				} else {
					$rsnew['k_dok'] = $this->k_dok->Upload->FileName;
				}
				$this->k_dok->ImageWidth = 420; // Resize width
				$this->k_dok->ImageHeight = 700; // Resize height
			}

			// k_harga_bibit
			$this->k_harga_bibit->SetDbValueDef($rsnew, $this->k_harga_bibit->CurrentValue, 0, $this->k_harga_bibit->ReadOnly);

			// k_bayar_bibit
			$this->k_bayar_bibit->SetDbValueDef($rsnew, $this->k_bayar_bibit->CurrentValue, 0, $this->k_bayar_bibit->ReadOnly);

			// k_pinjaman
			$this->k_pinjaman->SetDbValueDef($rsnew, $this->k_pinjaman->CurrentValue, 0, $this->k_pinjaman->ReadOnly);

			// k_bayar_pinjaman
			$this->k_bayar_pinjaman->SetDbValueDef($rsnew, $this->k_bayar_pinjaman->CurrentValue, 0, $this->k_bayar_pinjaman->ReadOnly);

			// k_sisa_hutang
			$this->k_sisa_hutang->SetDbValueDef($rsnew, $this->k_sisa_hutang->CurrentValue, 0, $this->k_sisa_hutang->ReadOnly);
			if ($this->k_foto_lahan->Visible && !$this->k_foto_lahan->Upload->KeepFile) {
				$this->k_foto_lahan->UploadPath = "foto_lahan";
				$OldFiles = ew_Empty($this->k_foto_lahan->Upload->DbValue) ? array() : explode(EW_MULTIPLE_UPLOAD_SEPARATOR, strval($this->k_foto_lahan->Upload->DbValue));
				if (!ew_Empty($this->k_foto_lahan->Upload->FileName)) {
					$NewFiles = explode(EW_MULTIPLE_UPLOAD_SEPARATOR, strval($this->k_foto_lahan->Upload->FileName));
					$NewFileCount = count($NewFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						$fldvar = ($this->k_foto_lahan->Upload->Index < 0) ? $this->k_foto_lahan->FldVar : substr($this->k_foto_lahan->FldVar, 0, 1) . $this->k_foto_lahan->Upload->Index . substr($this->k_foto_lahan->FldVar, 1);
						if ($NewFiles[$i] <> "") {
							$file = $NewFiles[$i];
							if (file_exists(ew_UploadTempPath($fldvar, $this->k_foto_lahan->TblVar) . $file)) {
								$OldFileFound = FALSE;
								$OldFileCount = count($OldFiles);
								for ($j = 0; $j < $OldFileCount; $j++) {
									$file1 = $OldFiles[$j];
									if ($file1 == $file) { // Old file found, no need to delete anymore
										unset($OldFiles[$j]);
										$OldFileFound = TRUE;
										break;
									}
								}
								if ($OldFileFound) // No need to check if file exists further
									continue;
								$file1 = ew_UploadFileNameEx($this->k_foto_lahan->PhysicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(ew_UploadTempPath($fldvar, $this->k_foto_lahan->TblVar) . $file1) || file_exists($this->k_foto_lahan->PhysicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = ew_UniqueFilename($this->k_foto_lahan->PhysicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(ew_UploadTempPath($fldvar, $this->k_foto_lahan->TblVar) . $file, ew_UploadTempPath($fldvar, $this->k_foto_lahan->TblVar) . $file1);
									$NewFiles[$i] = $file1;
								}
							}
						}
					}
					$this->k_foto_lahan->Upload->DbValue = empty($OldFiles) ? "" : implode(EW_MULTIPLE_UPLOAD_SEPARATOR, $OldFiles);
					$this->k_foto_lahan->Upload->FileName = implode(EW_MULTIPLE_UPLOAD_SEPARATOR, $NewFiles);
					$this->k_foto_lahan->SetDbValueDef($rsnew, $this->k_foto_lahan->Upload->FileName, NULL, $this->k_foto_lahan->ReadOnly);
				}
			}
			if ($this->k_dok->Visible && !$this->k_dok->Upload->KeepFile) {
				$this->k_dok->UploadPath = "dokumen_kontrak_lahan";
				$OldFiles = ew_Empty($this->k_dok->Upload->DbValue) ? array() : explode(EW_MULTIPLE_UPLOAD_SEPARATOR, strval($this->k_dok->Upload->DbValue));
				if (!ew_Empty($this->k_dok->Upload->FileName)) {
					$NewFiles = explode(EW_MULTIPLE_UPLOAD_SEPARATOR, strval($this->k_dok->Upload->FileName));
					$NewFileCount = count($NewFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						$fldvar = ($this->k_dok->Upload->Index < 0) ? $this->k_dok->FldVar : substr($this->k_dok->FldVar, 0, 1) . $this->k_dok->Upload->Index . substr($this->k_dok->FldVar, 1);
						if ($NewFiles[$i] <> "") {
							$file = $NewFiles[$i];
							if (file_exists(ew_UploadTempPath($fldvar, $this->k_dok->TblVar) . $file)) {
								$OldFileFound = FALSE;
								$OldFileCount = count($OldFiles);
								for ($j = 0; $j < $OldFileCount; $j++) {
									$file1 = $OldFiles[$j];
									if ($file1 == $file) { // Old file found, no need to delete anymore
										unset($OldFiles[$j]);
										$OldFileFound = TRUE;
										break;
									}
								}
								if ($OldFileFound) // No need to check if file exists further
									continue;
								$file1 = ew_UploadFileNameEx($this->k_dok->PhysicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(ew_UploadTempPath($fldvar, $this->k_dok->TblVar) . $file1) || file_exists($this->k_dok->PhysicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = ew_UniqueFilename($this->k_dok->PhysicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(ew_UploadTempPath($fldvar, $this->k_dok->TblVar) . $file, ew_UploadTempPath($fldvar, $this->k_dok->TblVar) . $file1);
									$NewFiles[$i] = $file1;
								}
							}
						}
					}
					$this->k_dok->Upload->DbValue = empty($OldFiles) ? "" : implode(EW_MULTIPLE_UPLOAD_SEPARATOR, $OldFiles);
					$this->k_dok->Upload->FileName = implode(EW_MULTIPLE_UPLOAD_SEPARATOR, $NewFiles);
					$this->k_dok->SetDbValueDef($rsnew, $this->k_dok->Upload->FileName, NULL, $this->k_dok->ReadOnly);
				}
			}

			// Call Row Updating event
			$bUpdateRow = $this->Row_Updating($rsold, $rsnew);
			if ($bUpdateRow) {
				$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
				if (count($rsnew) > 0)
					$EditRow = $this->Update($rsnew, "", $rsold);
				else
					$EditRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($EditRow) {
					if ($this->k_foto_lahan->Visible && !$this->k_foto_lahan->Upload->KeepFile) {
						$OldFiles = ew_Empty($this->k_foto_lahan->Upload->DbValue) ? array() : explode(EW_MULTIPLE_UPLOAD_SEPARATOR, strval($this->k_foto_lahan->Upload->DbValue));
						if (!ew_Empty($this->k_foto_lahan->Upload->FileName)) {
							$NewFiles = explode(EW_MULTIPLE_UPLOAD_SEPARATOR, $this->k_foto_lahan->Upload->FileName);
							$NewFiles2 = explode(EW_MULTIPLE_UPLOAD_SEPARATOR, $rsnew['k_foto_lahan']);
							$NewFileCount = count($NewFiles);
							for ($i = 0; $i < $NewFileCount; $i++) {
								$fldvar = ($this->k_foto_lahan->Upload->Index < 0) ? $this->k_foto_lahan->FldVar : substr($this->k_foto_lahan->FldVar, 0, 1) . $this->k_foto_lahan->Upload->Index . substr($this->k_foto_lahan->FldVar, 1);
								if ($NewFiles[$i] <> "") {
									$file = ew_UploadTempPath($fldvar, $this->k_foto_lahan->TblVar) . $NewFiles[$i];
									if (file_exists($file)) {
										if (@$NewFiles2[$i] <> "") // Use correct file name
											$NewFiles[$i] = $NewFiles2[$i];
										if (!$this->k_foto_lahan->Upload->ResizeAndSaveToFile($this->k_foto_lahan->ImageWidth, $this->k_foto_lahan->ImageHeight, EW_THUMBNAIL_DEFAULT_QUALITY, $NewFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->Phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$NewFiles = array();
						}
						$OldFileCount = count($OldFiles);
						for ($i = 0; $i < $OldFileCount; $i++) {
							if ($OldFiles[$i] <> "" && !in_array($OldFiles[$i], $NewFiles))
								@unlink($this->k_foto_lahan->OldPhysicalUploadPath() . $OldFiles[$i]);
						}
					}
					if ($this->k_dok->Visible && !$this->k_dok->Upload->KeepFile) {
						$OldFiles = ew_Empty($this->k_dok->Upload->DbValue) ? array() : explode(EW_MULTIPLE_UPLOAD_SEPARATOR, strval($this->k_dok->Upload->DbValue));
						if (!ew_Empty($this->k_dok->Upload->FileName)) {
							$NewFiles = explode(EW_MULTIPLE_UPLOAD_SEPARATOR, $this->k_dok->Upload->FileName);
							$NewFiles2 = explode(EW_MULTIPLE_UPLOAD_SEPARATOR, $rsnew['k_dok']);
							$NewFileCount = count($NewFiles);
							for ($i = 0; $i < $NewFileCount; $i++) {
								$fldvar = ($this->k_dok->Upload->Index < 0) ? $this->k_dok->FldVar : substr($this->k_dok->FldVar, 0, 1) . $this->k_dok->Upload->Index . substr($this->k_dok->FldVar, 1);
								if ($NewFiles[$i] <> "") {
									$file = ew_UploadTempPath($fldvar, $this->k_dok->TblVar) . $NewFiles[$i];
									if (file_exists($file)) {
										if (@$NewFiles2[$i] <> "") // Use correct file name
											$NewFiles[$i] = $NewFiles2[$i];
										if (!$this->k_dok->Upload->ResizeAndSaveToFile($this->k_dok->ImageWidth, $this->k_dok->ImageHeight, EW_THUMBNAIL_DEFAULT_QUALITY, $NewFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->Phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$NewFiles = array();
						}
						$OldFileCount = count($OldFiles);
						for ($i = 0; $i < $OldFileCount; $i++) {
							if ($OldFiles[$i] <> "" && !in_array($OldFiles[$i], $NewFiles))
								@unlink($this->k_dok->OldPhysicalUploadPath() . $OldFiles[$i]);
						}
					}
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->Phrase("UpdateCancelled"));
				}
				$EditRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($EditRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->Close();

		// k_foto_lahan
		ew_CleanUploadTempPath($this->k_foto_lahan, $this->k_foto_lahan->Upload->Index);

		// k_dok
		ew_CleanUploadTempPath($this->k_dok, $this->k_dok->Upload->Index);
		return $EditRow;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$Breadcrumb->Add("list", $this->TableVar, $this->AddMasterUrl("kontraklist.php"), "", $this->TableVar, TRUE);
		$PageId = "edit";
		$Breadcrumb->Add("edit", $PageId, $url);
	}

	// Setup lookup filters of a field
	function SetupLookupFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		case "x_pet_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `pet_id` AS `LinkFld`, `pet_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `petani`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`pet_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->pet_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `pet_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_koord_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `koord_id` AS `LinkFld`, `koord_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `koord`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`koord_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->koord_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `koord_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_kk_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `kk_id` AS `LinkFld`, `kk_periode` AS `DispFld`, `kk_tgl_mulai` AS `Disp2Fld`, `kk_tgl_akhir` AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kontrak_koord`";
			$sWhereWrk = "{filter}";
			$fld->LookupFilters = array("df2" => "5", "df3" => "5");
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`kk_id` IN ({filter_value})', "t0" => "3", "fn0" => "", "f1" => '`koord_id` IN ({filter_value})', "t1" => "3", "fn1" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->kk_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_prov_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `prov_id` AS `LinkFld`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `prov`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`prov_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->prov_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `prov_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_kab_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `kab_id` AS `LinkFld`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kab`";
			$sWhereWrk = "{filter}";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`kab_id` IN ({filter_value})', "t0" => "3", "fn0" => "", "f1" => '`kab_prov_id` IN ({filter_value})', "t1" => "3", "fn1" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->kab_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `kab_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_kec_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `kec_id` AS `LinkFld`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kec`";
			$sWhereWrk = "{filter}";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`kec_id` IN ({filter_value})', "t0" => "3", "fn0" => "", "f1" => '`kec_prov_id` IN ({filter_value})', "t1" => "3", "fn1" => "", "f2" => '`kec_kab_id` IN ({filter_value})', "t2" => "3", "fn2" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->kec_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `kec_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_desa_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `desa_id` AS `LinkFld`, `desa_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `desa`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`desa_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->desa_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `desa_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_blok_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `blok_id` AS `LinkFld`, `blok_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `blok`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`blok_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->blok_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `blok_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_sos_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `sos_id` AS `LinkFld`, `sos_id` AS `DispFld`, `sos_tgl` AS `Disp2Fld`, `sos_alamat` AS `Disp3Fld`, '' AS `Disp4Fld` FROM `sosialisasi`";
			$sWhereWrk = "";
			$fld->LookupFilters = array("df2" => "0");
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`sos_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->sos_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `sos_tgl` DESC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_var_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `var_id` AS `LinkFld`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `varietas`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`var_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->var_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `var_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_co_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `co_id` AS `LinkFld`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `co`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`co_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->co_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `co_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		}
	}

	// Setup AutoSuggest filters of a field
	function SetupAutoSuggestFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($kontrak_edit)) $kontrak_edit = new ckontrak_edit();

// Page init
$kontrak_edit->Page_Init();

// Page main
$kontrak_edit->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$kontrak_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "edit";
var CurrentForm = fkontrakedit = new ew_Form("fkontrakedit", "edit");

// Validate form
fkontrakedit.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);
	if ($fobj.find("#a_confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.FormKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = $fobj.find("#a_list").val() == "gridinsert";
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
			elm = this.GetElements("x" + infix + "_k_luas_lahan");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $kontrak->k_luas_lahan->FldCaption(), $kontrak->k_luas_lahan->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_k_luas_lahan");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($kontrak->k_luas_lahan->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_k_jumlah_bibit");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($kontrak->k_jumlah_bibit->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_k_tgl_tanam");
			if (elm && !ew_CheckDate(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($kontrak->k_tgl_tanam->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_k_es_tgl_panen");
			if (elm && !ew_CheckDate(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($kontrak->k_es_tgl_panen->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_k_ak_tgl_datang");
			if (elm && !ew_CheckDate(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($kontrak->k_ak_tgl_datang->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_k_ak_qty");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($kontrak->k_ak_qty->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_k_es_perhektar");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($kontrak->k_es_perhektar->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_k_harga_bibit");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $kontrak->k_harga_bibit->FldCaption(), $kontrak->k_harga_bibit->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_k_harga_bibit");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($kontrak->k_harga_bibit->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_k_bayar_bibit");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $kontrak->k_bayar_bibit->FldCaption(), $kontrak->k_bayar_bibit->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_k_bayar_bibit");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($kontrak->k_bayar_bibit->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_k_pinjaman");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $kontrak->k_pinjaman->FldCaption(), $kontrak->k_pinjaman->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_k_pinjaman");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($kontrak->k_pinjaman->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_k_bayar_pinjaman");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $kontrak->k_bayar_pinjaman->FldCaption(), $kontrak->k_bayar_pinjaman->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_k_bayar_pinjaman");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($kontrak->k_bayar_pinjaman->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_k_sisa_hutang");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $kontrak->k_sisa_hutang->FldCaption(), $kontrak->k_sisa_hutang->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_k_sisa_hutang");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($kontrak->k_sisa_hutang->FldErrMsg()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ewForms[val])
			if (!ewForms[val].Validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fkontrakedit.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fkontrakedit.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fkontrakedit.Lists["x_pet_id"] = {"LinkField":"x_pet_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_pet_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"petani"};
fkontrakedit.Lists["x_pet_id"].Data = "<?php echo $kontrak_edit->pet_id->LookupFilterQuery(FALSE, "edit") ?>";
fkontrakedit.Lists["x_koord_id"] = {"LinkField":"x_koord_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_koord_nama","","",""],"ParentFields":[],"ChildFields":["x_kk_id"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"koord"};
fkontrakedit.Lists["x_koord_id"].Data = "<?php echo $kontrak_edit->koord_id->LookupFilterQuery(FALSE, "edit") ?>";
fkontrakedit.Lists["x_kk_id"] = {"LinkField":"x_kk_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kk_periode","x_kk_tgl_mulai","x_kk_tgl_akhir",""],"ParentFields":["x_koord_id"],"ChildFields":[],"FilterFields":["x_koord_id"],"Options":[],"Template":"","LinkTable":"kontrak_koord"};
fkontrakedit.Lists["x_kk_id"].Data = "<?php echo $kontrak_edit->kk_id->LookupFilterQuery(FALSE, "edit") ?>";
fkontrakedit.Lists["x_prov_id"] = {"LinkField":"x_prov_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_prov_nama","","",""],"ParentFields":[],"ChildFields":["x_kab_id","x_kec_id"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"prov"};
fkontrakedit.Lists["x_prov_id"].Data = "<?php echo $kontrak_edit->prov_id->LookupFilterQuery(FALSE, "edit") ?>";
fkontrakedit.Lists["x_kab_id"] = {"LinkField":"x_kab_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kab_nama","","",""],"ParentFields":["x_prov_id"],"ChildFields":["x_kec_id"],"FilterFields":["x_kab_prov_id"],"Options":[],"Template":"","LinkTable":"kab"};
fkontrakedit.Lists["x_kab_id"].Data = "<?php echo $kontrak_edit->kab_id->LookupFilterQuery(FALSE, "edit") ?>";
fkontrakedit.Lists["x_kec_id"] = {"LinkField":"x_kec_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kec_nama","","",""],"ParentFields":["x_prov_id","x_kab_id"],"ChildFields":[],"FilterFields":["x_kec_prov_id","x_kec_kab_id"],"Options":[],"Template":"","LinkTable":"kec"};
fkontrakedit.Lists["x_kec_id"].Data = "<?php echo $kontrak_edit->kec_id->LookupFilterQuery(FALSE, "edit") ?>";
fkontrakedit.Lists["x_desa_id"] = {"LinkField":"x_desa_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_desa_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"desa"};
fkontrakedit.Lists["x_desa_id"].Data = "<?php echo $kontrak_edit->desa_id->LookupFilterQuery(FALSE, "edit") ?>";
fkontrakedit.Lists["x_blok_id"] = {"LinkField":"x_blok_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_blok_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"blok"};
fkontrakedit.Lists["x_blok_id"].Data = "<?php echo $kontrak_edit->blok_id->LookupFilterQuery(FALSE, "edit") ?>";
fkontrakedit.Lists["x_sos_id"] = {"LinkField":"x_sos_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_sos_id","x_sos_tgl","x_sos_alamat",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"sosialisasi"};
fkontrakedit.Lists["x_sos_id"].Data = "<?php echo $kontrak_edit->sos_id->LookupFilterQuery(FALSE, "edit") ?>";
fkontrakedit.Lists["x_var_id"] = {"LinkField":"x_var_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_var_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"varietas"};
fkontrakedit.Lists["x_var_id"].Data = "<?php echo $kontrak_edit->var_id->LookupFilterQuery(FALSE, "edit") ?>";
fkontrakedit.Lists["x_co_id"] = {"LinkField":"x_co_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_co_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"co"};
fkontrakedit.Lists["x_co_id"].Data = "<?php echo $kontrak_edit->co_id->LookupFilterQuery(FALSE, "edit") ?>";

// Form object for search
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php $kontrak_edit->ShowPageHeader(); ?>
<?php
$kontrak_edit->ShowMessage();
?>
<form name="fkontrakedit" id="fkontrakedit" class="<?php echo $kontrak_edit->FormClassName ?>" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($kontrak_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $kontrak_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="kontrak">
<input type="hidden" name="a_edit" id="a_edit" value="U">
<input type="hidden" name="modal" value="<?php echo intval($kontrak_edit->IsModal) ?>">
<div class="ewEditDiv"><!-- page* -->
<?php if ($kontrak->k_id_lama->Visible) { // k_id_lama ?>
	<div id="r_k_id_lama" class="form-group">
		<label id="elh_kontrak_k_id_lama" for="x_k_id_lama" class="<?php echo $kontrak_edit->LeftColumnClass ?>"><?php echo $kontrak->k_id_lama->FldCaption() ?></label>
		<div class="<?php echo $kontrak_edit->RightColumnClass ?>"><div<?php echo $kontrak->k_id_lama->CellAttributes() ?>>
<span id="el_kontrak_k_id_lama">
<input type="text" data-table="kontrak" data-field="x_k_id_lama" name="x_k_id_lama" id="x_k_id_lama" size="30" maxlength="50" placeholder="<?php echo ew_HtmlEncode($kontrak->k_id_lama->getPlaceHolder()) ?>" value="<?php echo $kontrak->k_id_lama->EditValue ?>"<?php echo $kontrak->k_id_lama->EditAttributes() ?>>
</span>
<?php echo $kontrak->k_id_lama->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak->k_no_kontrak->Visible) { // k_no_kontrak ?>
	<div id="r_k_no_kontrak" class="form-group">
		<label id="elh_kontrak_k_no_kontrak" for="x_k_no_kontrak" class="<?php echo $kontrak_edit->LeftColumnClass ?>"><?php echo $kontrak->k_no_kontrak->FldCaption() ?></label>
		<div class="<?php echo $kontrak_edit->RightColumnClass ?>"><div<?php echo $kontrak->k_no_kontrak->CellAttributes() ?>>
<span id="el_kontrak_k_no_kontrak">
<input type="text" data-table="kontrak" data-field="x_k_no_kontrak" name="x_k_no_kontrak" id="x_k_no_kontrak" size="30" maxlength="50" placeholder="<?php echo ew_HtmlEncode($kontrak->k_no_kontrak->getPlaceHolder()) ?>" value="<?php echo $kontrak->k_no_kontrak->EditValue ?>"<?php echo $kontrak->k_no_kontrak->EditAttributes() ?>>
</span>
<?php echo $kontrak->k_no_kontrak->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak->k_luas_lahan->Visible) { // k_luas_lahan ?>
	<div id="r_k_luas_lahan" class="form-group">
		<label id="elh_kontrak_k_luas_lahan" for="x_k_luas_lahan" class="<?php echo $kontrak_edit->LeftColumnClass ?>"><?php echo $kontrak->k_luas_lahan->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $kontrak_edit->RightColumnClass ?>"><div<?php echo $kontrak->k_luas_lahan->CellAttributes() ?>>
<span id="el_kontrak_k_luas_lahan">
<input type="text" data-table="kontrak" data-field="x_k_luas_lahan" name="x_k_luas_lahan" id="x_k_luas_lahan" size="30" placeholder="<?php echo ew_HtmlEncode($kontrak->k_luas_lahan->getPlaceHolder()) ?>" value="<?php echo $kontrak->k_luas_lahan->EditValue ?>"<?php echo $kontrak->k_luas_lahan->EditAttributes() ?>>
</span>
<?php echo $kontrak->k_luas_lahan->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak->pet_id->Visible) { // pet_id ?>
	<div id="r_pet_id" class="form-group">
		<label id="elh_kontrak_pet_id" for="x_pet_id" class="<?php echo $kontrak_edit->LeftColumnClass ?>"><?php echo $kontrak->pet_id->FldCaption() ?></label>
		<div class="<?php echo $kontrak_edit->RightColumnClass ?>"><div<?php echo $kontrak->pet_id->CellAttributes() ?>>
<span id="el_kontrak_pet_id">
<select data-table="kontrak" data-field="x_pet_id" data-value-separator="<?php echo $kontrak->pet_id->DisplayValueSeparatorAttribute() ?>" id="x_pet_id" name="x_pet_id"<?php echo $kontrak->pet_id->EditAttributes() ?>>
<?php echo $kontrak->pet_id->SelectOptionListHtml("x_pet_id") ?>
</select>
<?php if (AllowAdd(CurrentProjectID() . "petani") && !$kontrak->pet_id->ReadOnly) { ?>
<button type="button" title="<?php echo ew_HtmlTitle($Language->Phrase("AddLink")) . "&nbsp;" . $kontrak->pet_id->FldCaption() ?>" onclick="ew_AddOptDialogShow({lnk:this,el:'x_pet_id',url:'petaniaddopt.php'});" class="ewAddOptBtn btn btn-default btn-sm" id="aol_x_pet_id"><span class="glyphicon glyphicon-plus ewIcon"></span><span class="hide"><?php echo $Language->Phrase("AddLink") ?>&nbsp;<?php echo $kontrak->pet_id->FldCaption() ?></span></button>
<?php } ?>
</span>
<?php echo $kontrak->pet_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak->koord_id->Visible) { // koord_id ?>
	<div id="r_koord_id" class="form-group">
		<label id="elh_kontrak_koord_id" for="x_koord_id" class="<?php echo $kontrak_edit->LeftColumnClass ?>"><?php echo $kontrak->koord_id->FldCaption() ?></label>
		<div class="<?php echo $kontrak_edit->RightColumnClass ?>"><div<?php echo $kontrak->koord_id->CellAttributes() ?>>
<span id="el_kontrak_koord_id">
<?php $kontrak->koord_id->EditAttrs["onchange"] = "ew_UpdateOpt.call(this); " . @$kontrak->koord_id->EditAttrs["onchange"]; ?>
<select data-table="kontrak" data-field="x_koord_id" data-value-separator="<?php echo $kontrak->koord_id->DisplayValueSeparatorAttribute() ?>" id="x_koord_id" name="x_koord_id"<?php echo $kontrak->koord_id->EditAttributes() ?>>
<?php echo $kontrak->koord_id->SelectOptionListHtml("x_koord_id") ?>
</select>
<?php if (AllowAdd(CurrentProjectID() . "koord") && !$kontrak->koord_id->ReadOnly) { ?>
<button type="button" title="<?php echo ew_HtmlTitle($Language->Phrase("AddLink")) . "&nbsp;" . $kontrak->koord_id->FldCaption() ?>" onclick="ew_AddOptDialogShow({lnk:this,el:'x_koord_id',url:'koordaddopt.php'});" class="ewAddOptBtn btn btn-default btn-sm" id="aol_x_koord_id"><span class="glyphicon glyphicon-plus ewIcon"></span><span class="hide"><?php echo $Language->Phrase("AddLink") ?>&nbsp;<?php echo $kontrak->koord_id->FldCaption() ?></span></button>
<?php } ?>
</span>
<?php echo $kontrak->koord_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak->kk_id->Visible) { // kk_id ?>
	<div id="r_kk_id" class="form-group">
		<label id="elh_kontrak_kk_id" for="x_kk_id" class="<?php echo $kontrak_edit->LeftColumnClass ?>"><?php echo $kontrak->kk_id->FldCaption() ?></label>
		<div class="<?php echo $kontrak_edit->RightColumnClass ?>"><div<?php echo $kontrak->kk_id->CellAttributes() ?>>
<span id="el_kontrak_kk_id">
<select data-table="kontrak" data-field="x_kk_id" data-value-separator="<?php echo $kontrak->kk_id->DisplayValueSeparatorAttribute() ?>" id="x_kk_id" name="x_kk_id"<?php echo $kontrak->kk_id->EditAttributes() ?>>
<?php echo $kontrak->kk_id->SelectOptionListHtml("x_kk_id") ?>
</select>
</span>
<?php echo $kontrak->kk_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak->prov_id->Visible) { // prov_id ?>
	<div id="r_prov_id" class="form-group">
		<label id="elh_kontrak_prov_id" for="x_prov_id" class="<?php echo $kontrak_edit->LeftColumnClass ?>"><?php echo $kontrak->prov_id->FldCaption() ?></label>
		<div class="<?php echo $kontrak_edit->RightColumnClass ?>"><div<?php echo $kontrak->prov_id->CellAttributes() ?>>
<span id="el_kontrak_prov_id">
<?php $kontrak->prov_id->EditAttrs["onchange"] = "ew_UpdateOpt.call(this); " . @$kontrak->prov_id->EditAttrs["onchange"]; ?>
<select data-table="kontrak" data-field="x_prov_id" data-value-separator="<?php echo $kontrak->prov_id->DisplayValueSeparatorAttribute() ?>" id="x_prov_id" name="x_prov_id"<?php echo $kontrak->prov_id->EditAttributes() ?>>
<?php echo $kontrak->prov_id->SelectOptionListHtml("x_prov_id") ?>
</select>
<?php if (AllowAdd(CurrentProjectID() . "prov") && !$kontrak->prov_id->ReadOnly) { ?>
<button type="button" title="<?php echo ew_HtmlTitle($Language->Phrase("AddLink")) . "&nbsp;" . $kontrak->prov_id->FldCaption() ?>" onclick="ew_AddOptDialogShow({lnk:this,el:'x_prov_id',url:'provaddopt.php'});" class="ewAddOptBtn btn btn-default btn-sm" id="aol_x_prov_id"><span class="glyphicon glyphicon-plus ewIcon"></span><span class="hide"><?php echo $Language->Phrase("AddLink") ?>&nbsp;<?php echo $kontrak->prov_id->FldCaption() ?></span></button>
<?php } ?>
</span>
<?php echo $kontrak->prov_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak->kab_id->Visible) { // kab_id ?>
	<div id="r_kab_id" class="form-group">
		<label id="elh_kontrak_kab_id" for="x_kab_id" class="<?php echo $kontrak_edit->LeftColumnClass ?>"><?php echo $kontrak->kab_id->FldCaption() ?></label>
		<div class="<?php echo $kontrak_edit->RightColumnClass ?>"><div<?php echo $kontrak->kab_id->CellAttributes() ?>>
<span id="el_kontrak_kab_id">
<?php $kontrak->kab_id->EditAttrs["onchange"] = "ew_UpdateOpt.call(this); " . @$kontrak->kab_id->EditAttrs["onchange"]; ?>
<select data-table="kontrak" data-field="x_kab_id" data-value-separator="<?php echo $kontrak->kab_id->DisplayValueSeparatorAttribute() ?>" id="x_kab_id" name="x_kab_id"<?php echo $kontrak->kab_id->EditAttributes() ?>>
<?php echo $kontrak->kab_id->SelectOptionListHtml("x_kab_id") ?>
</select>
<?php if (AllowAdd(CurrentProjectID() . "kab") && !$kontrak->kab_id->ReadOnly) { ?>
<button type="button" title="<?php echo ew_HtmlTitle($Language->Phrase("AddLink")) . "&nbsp;" . $kontrak->kab_id->FldCaption() ?>" onclick="ew_AddOptDialogShow({lnk:this,el:'x_kab_id',url:'kabaddopt.php'});" class="ewAddOptBtn btn btn-default btn-sm" id="aol_x_kab_id"><span class="glyphicon glyphicon-plus ewIcon"></span><span class="hide"><?php echo $Language->Phrase("AddLink") ?>&nbsp;<?php echo $kontrak->kab_id->FldCaption() ?></span></button>
<?php } ?>
</span>
<?php echo $kontrak->kab_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak->kec_id->Visible) { // kec_id ?>
	<div id="r_kec_id" class="form-group">
		<label id="elh_kontrak_kec_id" for="x_kec_id" class="<?php echo $kontrak_edit->LeftColumnClass ?>"><?php echo $kontrak->kec_id->FldCaption() ?></label>
		<div class="<?php echo $kontrak_edit->RightColumnClass ?>"><div<?php echo $kontrak->kec_id->CellAttributes() ?>>
<span id="el_kontrak_kec_id">
<select data-table="kontrak" data-field="x_kec_id" data-value-separator="<?php echo $kontrak->kec_id->DisplayValueSeparatorAttribute() ?>" id="x_kec_id" name="x_kec_id"<?php echo $kontrak->kec_id->EditAttributes() ?>>
<?php echo $kontrak->kec_id->SelectOptionListHtml("x_kec_id") ?>
</select>
<?php if (AllowAdd(CurrentProjectID() . "kec") && !$kontrak->kec_id->ReadOnly) { ?>
<button type="button" title="<?php echo ew_HtmlTitle($Language->Phrase("AddLink")) . "&nbsp;" . $kontrak->kec_id->FldCaption() ?>" onclick="ew_AddOptDialogShow({lnk:this,el:'x_kec_id',url:'kecaddopt.php'});" class="ewAddOptBtn btn btn-default btn-sm" id="aol_x_kec_id"><span class="glyphicon glyphicon-plus ewIcon"></span><span class="hide"><?php echo $Language->Phrase("AddLink") ?>&nbsp;<?php echo $kontrak->kec_id->FldCaption() ?></span></button>
<?php } ?>
</span>
<?php echo $kontrak->kec_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak->desa_id->Visible) { // desa_id ?>
	<div id="r_desa_id" class="form-group">
		<label id="elh_kontrak_desa_id" for="x_desa_id" class="<?php echo $kontrak_edit->LeftColumnClass ?>"><?php echo $kontrak->desa_id->FldCaption() ?></label>
		<div class="<?php echo $kontrak_edit->RightColumnClass ?>"><div<?php echo $kontrak->desa_id->CellAttributes() ?>>
<span id="el_kontrak_desa_id">
<select data-table="kontrak" data-field="x_desa_id" data-value-separator="<?php echo $kontrak->desa_id->DisplayValueSeparatorAttribute() ?>" id="x_desa_id" name="x_desa_id"<?php echo $kontrak->desa_id->EditAttributes() ?>>
<?php echo $kontrak->desa_id->SelectOptionListHtml("x_desa_id") ?>
</select>
<?php if (AllowAdd(CurrentProjectID() . "desa") && !$kontrak->desa_id->ReadOnly) { ?>
<button type="button" title="<?php echo ew_HtmlTitle($Language->Phrase("AddLink")) . "&nbsp;" . $kontrak->desa_id->FldCaption() ?>" onclick="ew_AddOptDialogShow({lnk:this,el:'x_desa_id',url:'desaaddopt.php'});" class="ewAddOptBtn btn btn-default btn-sm" id="aol_x_desa_id"><span class="glyphicon glyphicon-plus ewIcon"></span><span class="hide"><?php echo $Language->Phrase("AddLink") ?>&nbsp;<?php echo $kontrak->desa_id->FldCaption() ?></span></button>
<?php } ?>
</span>
<?php echo $kontrak->desa_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak->blok_id->Visible) { // blok_id ?>
	<div id="r_blok_id" class="form-group">
		<label id="elh_kontrak_blok_id" for="x_blok_id" class="<?php echo $kontrak_edit->LeftColumnClass ?>"><?php echo $kontrak->blok_id->FldCaption() ?></label>
		<div class="<?php echo $kontrak_edit->RightColumnClass ?>"><div<?php echo $kontrak->blok_id->CellAttributes() ?>>
<span id="el_kontrak_blok_id">
<select data-table="kontrak" data-field="x_blok_id" data-value-separator="<?php echo $kontrak->blok_id->DisplayValueSeparatorAttribute() ?>" id="x_blok_id" name="x_blok_id"<?php echo $kontrak->blok_id->EditAttributes() ?>>
<?php echo $kontrak->blok_id->SelectOptionListHtml("x_blok_id") ?>
</select>
<?php if (AllowAdd(CurrentProjectID() . "blok") && !$kontrak->blok_id->ReadOnly) { ?>
<button type="button" title="<?php echo ew_HtmlTitle($Language->Phrase("AddLink")) . "&nbsp;" . $kontrak->blok_id->FldCaption() ?>" onclick="ew_AddOptDialogShow({lnk:this,el:'x_blok_id',url:'blokaddopt.php'});" class="ewAddOptBtn btn btn-default btn-sm" id="aol_x_blok_id"><span class="glyphicon glyphicon-plus ewIcon"></span><span class="hide"><?php echo $Language->Phrase("AddLink") ?>&nbsp;<?php echo $kontrak->blok_id->FldCaption() ?></span></button>
<?php } ?>
</span>
<?php echo $kontrak->blok_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak->sos_id->Visible) { // sos_id ?>
	<div id="r_sos_id" class="form-group">
		<label id="elh_kontrak_sos_id" for="x_sos_id" class="<?php echo $kontrak_edit->LeftColumnClass ?>"><?php echo $kontrak->sos_id->FldCaption() ?></label>
		<div class="<?php echo $kontrak_edit->RightColumnClass ?>"><div<?php echo $kontrak->sos_id->CellAttributes() ?>>
<span id="el_kontrak_sos_id">
<select data-table="kontrak" data-field="x_sos_id" data-value-separator="<?php echo $kontrak->sos_id->DisplayValueSeparatorAttribute() ?>" id="x_sos_id" name="x_sos_id"<?php echo $kontrak->sos_id->EditAttributes() ?>>
<?php echo $kontrak->sos_id->SelectOptionListHtml("x_sos_id") ?>
</select>
<?php if (AllowAdd(CurrentProjectID() . "sosialisasi") && !$kontrak->sos_id->ReadOnly) { ?>
<button type="button" title="<?php echo ew_HtmlTitle($Language->Phrase("AddLink")) . "&nbsp;" . $kontrak->sos_id->FldCaption() ?>" onclick="ew_AddOptDialogShow({lnk:this,el:'x_sos_id',url:'sosialisasiaddopt.php'});" class="ewAddOptBtn btn btn-default btn-sm" id="aol_x_sos_id"><span class="glyphicon glyphicon-plus ewIcon"></span><span class="hide"><?php echo $Language->Phrase("AddLink") ?>&nbsp;<?php echo $kontrak->sos_id->FldCaption() ?></span></button>
<?php } ?>
</span>
<?php echo $kontrak->sos_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak->var_id->Visible) { // var_id ?>
	<div id="r_var_id" class="form-group">
		<label id="elh_kontrak_var_id" for="x_var_id" class="<?php echo $kontrak_edit->LeftColumnClass ?>"><?php echo $kontrak->var_id->FldCaption() ?></label>
		<div class="<?php echo $kontrak_edit->RightColumnClass ?>"><div<?php echo $kontrak->var_id->CellAttributes() ?>>
<span id="el_kontrak_var_id">
<select data-table="kontrak" data-field="x_var_id" data-value-separator="<?php echo $kontrak->var_id->DisplayValueSeparatorAttribute() ?>" id="x_var_id" name="x_var_id"<?php echo $kontrak->var_id->EditAttributes() ?>>
<?php echo $kontrak->var_id->SelectOptionListHtml("x_var_id") ?>
</select>
<?php if (AllowAdd(CurrentProjectID() . "varietas") && !$kontrak->var_id->ReadOnly) { ?>
<button type="button" title="<?php echo ew_HtmlTitle($Language->Phrase("AddLink")) . "&nbsp;" . $kontrak->var_id->FldCaption() ?>" onclick="ew_AddOptDialogShow({lnk:this,el:'x_var_id',url:'varietasaddopt.php'});" class="ewAddOptBtn btn btn-default btn-sm" id="aol_x_var_id"><span class="glyphicon glyphicon-plus ewIcon"></span><span class="hide"><?php echo $Language->Phrase("AddLink") ?>&nbsp;<?php echo $kontrak->var_id->FldCaption() ?></span></button>
<?php } ?>
</span>
<?php echo $kontrak->var_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak->co_id->Visible) { // co_id ?>
	<div id="r_co_id" class="form-group">
		<label id="elh_kontrak_co_id" for="x_co_id" class="<?php echo $kontrak_edit->LeftColumnClass ?>"><?php echo $kontrak->co_id->FldCaption() ?></label>
		<div class="<?php echo $kontrak_edit->RightColumnClass ?>"><div<?php echo $kontrak->co_id->CellAttributes() ?>>
<span id="el_kontrak_co_id">
<select data-table="kontrak" data-field="x_co_id" data-value-separator="<?php echo $kontrak->co_id->DisplayValueSeparatorAttribute() ?>" id="x_co_id" name="x_co_id"<?php echo $kontrak->co_id->EditAttributes() ?>>
<?php echo $kontrak->co_id->SelectOptionListHtml("x_co_id") ?>
</select>
<?php if (AllowAdd(CurrentProjectID() . "co") && !$kontrak->co_id->ReadOnly) { ?>
<button type="button" title="<?php echo ew_HtmlTitle($Language->Phrase("AddLink")) . "&nbsp;" . $kontrak->co_id->FldCaption() ?>" onclick="ew_AddOptDialogShow({lnk:this,el:'x_co_id',url:'coaddopt.php'});" class="ewAddOptBtn btn btn-default btn-sm" id="aol_x_co_id"><span class="glyphicon glyphicon-plus ewIcon"></span><span class="hide"><?php echo $Language->Phrase("AddLink") ?>&nbsp;<?php echo $kontrak->co_id->FldCaption() ?></span></button>
<?php } ?>
</span>
<?php echo $kontrak->co_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak->k_jumlah_bibit->Visible) { // k_jumlah_bibit ?>
	<div id="r_k_jumlah_bibit" class="form-group">
		<label id="elh_kontrak_k_jumlah_bibit" for="x_k_jumlah_bibit" class="<?php echo $kontrak_edit->LeftColumnClass ?>"><?php echo $kontrak->k_jumlah_bibit->FldCaption() ?></label>
		<div class="<?php echo $kontrak_edit->RightColumnClass ?>"><div<?php echo $kontrak->k_jumlah_bibit->CellAttributes() ?>>
<span id="el_kontrak_k_jumlah_bibit">
<input type="text" data-table="kontrak" data-field="x_k_jumlah_bibit" name="x_k_jumlah_bibit" id="x_k_jumlah_bibit" size="30" placeholder="<?php echo ew_HtmlEncode($kontrak->k_jumlah_bibit->getPlaceHolder()) ?>" value="<?php echo $kontrak->k_jumlah_bibit->EditValue ?>"<?php echo $kontrak->k_jumlah_bibit->EditAttributes() ?>>
</span>
<?php echo $kontrak->k_jumlah_bibit->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak->k_asal_bibit->Visible) { // k_asal_bibit ?>
	<div id="r_k_asal_bibit" class="form-group">
		<label id="elh_kontrak_k_asal_bibit" for="x_k_asal_bibit" class="<?php echo $kontrak_edit->LeftColumnClass ?>"><?php echo $kontrak->k_asal_bibit->FldCaption() ?></label>
		<div class="<?php echo $kontrak_edit->RightColumnClass ?>"><div<?php echo $kontrak->k_asal_bibit->CellAttributes() ?>>
<span id="el_kontrak_k_asal_bibit">
<input type="text" data-table="kontrak" data-field="x_k_asal_bibit" name="x_k_asal_bibit" id="x_k_asal_bibit" size="30" maxlength="50" placeholder="<?php echo ew_HtmlEncode($kontrak->k_asal_bibit->getPlaceHolder()) ?>" value="<?php echo $kontrak->k_asal_bibit->EditValue ?>"<?php echo $kontrak->k_asal_bibit->EditAttributes() ?>>
</span>
<?php echo $kontrak->k_asal_bibit->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak->k_tgl_tanam->Visible) { // k_tgl_tanam ?>
	<div id="r_k_tgl_tanam" class="form-group">
		<label id="elh_kontrak_k_tgl_tanam" for="x_k_tgl_tanam" class="<?php echo $kontrak_edit->LeftColumnClass ?>"><?php echo $kontrak->k_tgl_tanam->FldCaption() ?></label>
		<div class="<?php echo $kontrak_edit->RightColumnClass ?>"><div<?php echo $kontrak->k_tgl_tanam->CellAttributes() ?>>
<span id="el_kontrak_k_tgl_tanam">
<input type="text" data-table="kontrak" data-field="x_k_tgl_tanam" data-format="5" name="x_k_tgl_tanam" id="x_k_tgl_tanam" placeholder="<?php echo ew_HtmlEncode($kontrak->k_tgl_tanam->getPlaceHolder()) ?>" value="<?php echo $kontrak->k_tgl_tanam->EditValue ?>"<?php echo $kontrak->k_tgl_tanam->EditAttributes() ?>>
<?php if (!$kontrak->k_tgl_tanam->ReadOnly && !$kontrak->k_tgl_tanam->Disabled && !isset($kontrak->k_tgl_tanam->EditAttrs["readonly"]) && !isset($kontrak->k_tgl_tanam->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("fkontrakedit", "x_k_tgl_tanam", {"ignoreReadonly":true,"useCurrent":false,"format":5});
</script>
<?php } ?>
</span>
<?php echo $kontrak->k_tgl_tanam->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak->k_es_tgl_panen->Visible) { // k_es_tgl_panen ?>
	<div id="r_k_es_tgl_panen" class="form-group">
		<label id="elh_kontrak_k_es_tgl_panen" for="x_k_es_tgl_panen" class="<?php echo $kontrak_edit->LeftColumnClass ?>"><?php echo $kontrak->k_es_tgl_panen->FldCaption() ?></label>
		<div class="<?php echo $kontrak_edit->RightColumnClass ?>"><div<?php echo $kontrak->k_es_tgl_panen->CellAttributes() ?>>
<span id="el_kontrak_k_es_tgl_panen">
<input type="text" data-table="kontrak" data-field="x_k_es_tgl_panen" data-format="5" name="x_k_es_tgl_panen" id="x_k_es_tgl_panen" placeholder="<?php echo ew_HtmlEncode($kontrak->k_es_tgl_panen->getPlaceHolder()) ?>" value="<?php echo $kontrak->k_es_tgl_panen->EditValue ?>"<?php echo $kontrak->k_es_tgl_panen->EditAttributes() ?>>
<?php if (!$kontrak->k_es_tgl_panen->ReadOnly && !$kontrak->k_es_tgl_panen->Disabled && !isset($kontrak->k_es_tgl_panen->EditAttrs["readonly"]) && !isset($kontrak->k_es_tgl_panen->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("fkontrakedit", "x_k_es_tgl_panen", {"ignoreReadonly":true,"useCurrent":false,"format":5});
</script>
<?php } ?>
</span>
<?php echo $kontrak->k_es_tgl_panen->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak->k_ak_tgl_datang->Visible) { // k_ak_tgl_datang ?>
	<div id="r_k_ak_tgl_datang" class="form-group">
		<label id="elh_kontrak_k_ak_tgl_datang" for="x_k_ak_tgl_datang" class="<?php echo $kontrak_edit->LeftColumnClass ?>"><?php echo $kontrak->k_ak_tgl_datang->FldCaption() ?></label>
		<div class="<?php echo $kontrak_edit->RightColumnClass ?>"><div<?php echo $kontrak->k_ak_tgl_datang->CellAttributes() ?>>
<span id="el_kontrak_k_ak_tgl_datang">
<input type="text" data-table="kontrak" data-field="x_k_ak_tgl_datang" data-format="5" name="x_k_ak_tgl_datang" id="x_k_ak_tgl_datang" placeholder="<?php echo ew_HtmlEncode($kontrak->k_ak_tgl_datang->getPlaceHolder()) ?>" value="<?php echo $kontrak->k_ak_tgl_datang->EditValue ?>"<?php echo $kontrak->k_ak_tgl_datang->EditAttributes() ?>>
<?php if (!$kontrak->k_ak_tgl_datang->ReadOnly && !$kontrak->k_ak_tgl_datang->Disabled && !isset($kontrak->k_ak_tgl_datang->EditAttrs["readonly"]) && !isset($kontrak->k_ak_tgl_datang->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("fkontrakedit", "x_k_ak_tgl_datang", {"ignoreReadonly":true,"useCurrent":false,"format":5});
</script>
<?php } ?>
</span>
<?php echo $kontrak->k_ak_tgl_datang->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak->k_ak_qty->Visible) { // k_ak_qty ?>
	<div id="r_k_ak_qty" class="form-group">
		<label id="elh_kontrak_k_ak_qty" for="x_k_ak_qty" class="<?php echo $kontrak_edit->LeftColumnClass ?>"><?php echo $kontrak->k_ak_qty->FldCaption() ?></label>
		<div class="<?php echo $kontrak_edit->RightColumnClass ?>"><div<?php echo $kontrak->k_ak_qty->CellAttributes() ?>>
<span id="el_kontrak_k_ak_qty">
<input type="text" data-table="kontrak" data-field="x_k_ak_qty" name="x_k_ak_qty" id="x_k_ak_qty" size="30" placeholder="<?php echo ew_HtmlEncode($kontrak->k_ak_qty->getPlaceHolder()) ?>" value="<?php echo $kontrak->k_ak_qty->EditValue ?>"<?php echo $kontrak->k_ak_qty->EditAttributes() ?>>
</span>
<?php echo $kontrak->k_ak_qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak->k_es_perhektar->Visible) { // k_es_perhektar ?>
	<div id="r_k_es_perhektar" class="form-group">
		<label id="elh_kontrak_k_es_perhektar" for="x_k_es_perhektar" class="<?php echo $kontrak_edit->LeftColumnClass ?>"><?php echo $kontrak->k_es_perhektar->FldCaption() ?></label>
		<div class="<?php echo $kontrak_edit->RightColumnClass ?>"><div<?php echo $kontrak->k_es_perhektar->CellAttributes() ?>>
<span id="el_kontrak_k_es_perhektar">
<input type="text" data-table="kontrak" data-field="x_k_es_perhektar" name="x_k_es_perhektar" id="x_k_es_perhektar" size="30" placeholder="<?php echo ew_HtmlEncode($kontrak->k_es_perhektar->getPlaceHolder()) ?>" value="<?php echo $kontrak->k_es_perhektar->EditValue ?>"<?php echo $kontrak->k_es_perhektar->EditAttributes() ?>>
</span>
<?php echo $kontrak->k_es_perhektar->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak->k_ket->Visible) { // k_ket ?>
	<div id="r_k_ket" class="form-group">
		<label id="elh_kontrak_k_ket" for="x_k_ket" class="<?php echo $kontrak_edit->LeftColumnClass ?>"><?php echo $kontrak->k_ket->FldCaption() ?></label>
		<div class="<?php echo $kontrak_edit->RightColumnClass ?>"><div<?php echo $kontrak->k_ket->CellAttributes() ?>>
<span id="el_kontrak_k_ket">
<textarea data-table="kontrak" data-field="x_k_ket" name="x_k_ket" id="x_k_ket" cols="35" rows="4" placeholder="<?php echo ew_HtmlEncode($kontrak->k_ket->getPlaceHolder()) ?>"<?php echo $kontrak->k_ket->EditAttributes() ?>><?php echo $kontrak->k_ket->EditValue ?></textarea>
</span>
<?php echo $kontrak->k_ket->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak->k_cat->Visible) { // k_cat ?>
	<div id="r_k_cat" class="form-group">
		<label id="elh_kontrak_k_cat" for="x_k_cat" class="<?php echo $kontrak_edit->LeftColumnClass ?>"><?php echo $kontrak->k_cat->FldCaption() ?></label>
		<div class="<?php echo $kontrak_edit->RightColumnClass ?>"><div<?php echo $kontrak->k_cat->CellAttributes() ?>>
<span id="el_kontrak_k_cat">
<textarea data-table="kontrak" data-field="x_k_cat" name="x_k_cat" id="x_k_cat" cols="35" rows="4" placeholder="<?php echo ew_HtmlEncode($kontrak->k_cat->getPlaceHolder()) ?>"<?php echo $kontrak->k_cat->EditAttributes() ?>><?php echo $kontrak->k_cat->EditValue ?></textarea>
</span>
<?php echo $kontrak->k_cat->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak->k_titik_koordinat->Visible) { // k_titik_koordinat ?>
	<div id="r_k_titik_koordinat" class="form-group">
		<label id="elh_kontrak_k_titik_koordinat" for="x_k_titik_koordinat" class="<?php echo $kontrak_edit->LeftColumnClass ?>"><?php echo $kontrak->k_titik_koordinat->FldCaption() ?></label>
		<div class="<?php echo $kontrak_edit->RightColumnClass ?>"><div<?php echo $kontrak->k_titik_koordinat->CellAttributes() ?>>
<span id="el_kontrak_k_titik_koordinat">
<input type="text" data-table="kontrak" data-field="x_k_titik_koordinat" name="x_k_titik_koordinat" id="x_k_titik_koordinat" size="60" maxlength="200" placeholder="<?php echo ew_HtmlEncode($kontrak->k_titik_koordinat->getPlaceHolder()) ?>" value="<?php echo $kontrak->k_titik_koordinat->EditValue ?>"<?php echo $kontrak->k_titik_koordinat->EditAttributes() ?>>
</span>
<?php echo $kontrak->k_titik_koordinat->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak->k_foto_lahan->Visible) { // k_foto_lahan ?>
	<div id="r_k_foto_lahan" class="form-group">
		<label id="elh_kontrak_k_foto_lahan" class="<?php echo $kontrak_edit->LeftColumnClass ?>"><?php echo $kontrak->k_foto_lahan->FldCaption() ?></label>
		<div class="<?php echo $kontrak_edit->RightColumnClass ?>"><div<?php echo $kontrak->k_foto_lahan->CellAttributes() ?>>
<span id="el_kontrak_k_foto_lahan">
<div id="fd_x_k_foto_lahan">
<span title="<?php echo $kontrak->k_foto_lahan->FldTitle() ? $kontrak->k_foto_lahan->FldTitle() : $Language->Phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ewTooltip<?php if ($kontrak->k_foto_lahan->ReadOnly || $kontrak->k_foto_lahan->Disabled) echo " hide"; ?>" data-trigger="hover">
	<span><?php echo $Language->Phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="kontrak" data-field="x_k_foto_lahan" name="x_k_foto_lahan" id="x_k_foto_lahan" multiple="multiple"<?php echo $kontrak->k_foto_lahan->EditAttributes() ?>>
</span>
<input type="hidden" name="fn_x_k_foto_lahan" id= "fn_x_k_foto_lahan" value="<?php echo $kontrak->k_foto_lahan->Upload->FileName ?>">
<?php if (@$_POST["fa_x_k_foto_lahan"] == "0") { ?>
<input type="hidden" name="fa_x_k_foto_lahan" id= "fa_x_k_foto_lahan" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_k_foto_lahan" id= "fa_x_k_foto_lahan" value="1">
<?php } ?>
<input type="hidden" name="fs_x_k_foto_lahan" id= "fs_x_k_foto_lahan" value="100">
<input type="hidden" name="fx_x_k_foto_lahan" id= "fx_x_k_foto_lahan" value="<?php echo $kontrak->k_foto_lahan->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_k_foto_lahan" id= "fm_x_k_foto_lahan" value="<?php echo $kontrak->k_foto_lahan->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_k_foto_lahan" id= "fc_x_k_foto_lahan" value="<?php echo $kontrak->k_foto_lahan->UploadMaxFileCount ?>">
</div>
<table id="ft_x_k_foto_lahan" class="table table-condensed pull-left ewUploadTable"><tbody class="files"></tbody></table>
</span>
<?php echo $kontrak->k_foto_lahan->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak->k_dok->Visible) { // k_dok ?>
	<div id="r_k_dok" class="form-group">
		<label id="elh_kontrak_k_dok" class="<?php echo $kontrak_edit->LeftColumnClass ?>"><?php echo $kontrak->k_dok->FldCaption() ?></label>
		<div class="<?php echo $kontrak_edit->RightColumnClass ?>"><div<?php echo $kontrak->k_dok->CellAttributes() ?>>
<span id="el_kontrak_k_dok">
<div id="fd_x_k_dok">
<span title="<?php echo $kontrak->k_dok->FldTitle() ? $kontrak->k_dok->FldTitle() : $Language->Phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ewTooltip<?php if ($kontrak->k_dok->ReadOnly || $kontrak->k_dok->Disabled) echo " hide"; ?>" data-trigger="hover">
	<span><?php echo $Language->Phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="kontrak" data-field="x_k_dok" name="x_k_dok" id="x_k_dok" multiple="multiple"<?php echo $kontrak->k_dok->EditAttributes() ?>>
</span>
<input type="hidden" name="fn_x_k_dok" id= "fn_x_k_dok" value="<?php echo $kontrak->k_dok->Upload->FileName ?>">
<?php if (@$_POST["fa_x_k_dok"] == "0") { ?>
<input type="hidden" name="fa_x_k_dok" id= "fa_x_k_dok" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_k_dok" id= "fa_x_k_dok" value="1">
<?php } ?>
<input type="hidden" name="fs_x_k_dok" id= "fs_x_k_dok" value="50">
<input type="hidden" name="fx_x_k_dok" id= "fx_x_k_dok" value="<?php echo $kontrak->k_dok->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_k_dok" id= "fm_x_k_dok" value="<?php echo $kontrak->k_dok->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_k_dok" id= "fc_x_k_dok" value="<?php echo $kontrak->k_dok->UploadMaxFileCount ?>">
</div>
<table id="ft_x_k_dok" class="table table-condensed pull-left ewUploadTable"><tbody class="files"></tbody></table>
</span>
<?php echo $kontrak->k_dok->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak->k_harga_bibit->Visible) { // k_harga_bibit ?>
	<div id="r_k_harga_bibit" class="form-group">
		<label id="elh_kontrak_k_harga_bibit" for="x_k_harga_bibit" class="<?php echo $kontrak_edit->LeftColumnClass ?>"><?php echo $kontrak->k_harga_bibit->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $kontrak_edit->RightColumnClass ?>"><div<?php echo $kontrak->k_harga_bibit->CellAttributes() ?>>
<span id="el_kontrak_k_harga_bibit">
<input type="text" data-table="kontrak" data-field="x_k_harga_bibit" name="x_k_harga_bibit" id="x_k_harga_bibit" size="30" placeholder="<?php echo ew_HtmlEncode($kontrak->k_harga_bibit->getPlaceHolder()) ?>" value="<?php echo $kontrak->k_harga_bibit->EditValue ?>"<?php echo $kontrak->k_harga_bibit->EditAttributes() ?>>
</span>
<?php echo $kontrak->k_harga_bibit->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak->k_bayar_bibit->Visible) { // k_bayar_bibit ?>
	<div id="r_k_bayar_bibit" class="form-group">
		<label id="elh_kontrak_k_bayar_bibit" for="x_k_bayar_bibit" class="<?php echo $kontrak_edit->LeftColumnClass ?>"><?php echo $kontrak->k_bayar_bibit->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $kontrak_edit->RightColumnClass ?>"><div<?php echo $kontrak->k_bayar_bibit->CellAttributes() ?>>
<span id="el_kontrak_k_bayar_bibit">
<input type="text" data-table="kontrak" data-field="x_k_bayar_bibit" name="x_k_bayar_bibit" id="x_k_bayar_bibit" size="30" placeholder="<?php echo ew_HtmlEncode($kontrak->k_bayar_bibit->getPlaceHolder()) ?>" value="<?php echo $kontrak->k_bayar_bibit->EditValue ?>"<?php echo $kontrak->k_bayar_bibit->EditAttributes() ?>>
</span>
<?php echo $kontrak->k_bayar_bibit->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak->k_pinjaman->Visible) { // k_pinjaman ?>
	<div id="r_k_pinjaman" class="form-group">
		<label id="elh_kontrak_k_pinjaman" for="x_k_pinjaman" class="<?php echo $kontrak_edit->LeftColumnClass ?>"><?php echo $kontrak->k_pinjaman->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $kontrak_edit->RightColumnClass ?>"><div<?php echo $kontrak->k_pinjaman->CellAttributes() ?>>
<span id="el_kontrak_k_pinjaman">
<input type="text" data-table="kontrak" data-field="x_k_pinjaman" name="x_k_pinjaman" id="x_k_pinjaman" size="30" placeholder="<?php echo ew_HtmlEncode($kontrak->k_pinjaman->getPlaceHolder()) ?>" value="<?php echo $kontrak->k_pinjaman->EditValue ?>"<?php echo $kontrak->k_pinjaman->EditAttributes() ?>>
</span>
<?php echo $kontrak->k_pinjaman->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak->k_bayar_pinjaman->Visible) { // k_bayar_pinjaman ?>
	<div id="r_k_bayar_pinjaman" class="form-group">
		<label id="elh_kontrak_k_bayar_pinjaman" for="x_k_bayar_pinjaman" class="<?php echo $kontrak_edit->LeftColumnClass ?>"><?php echo $kontrak->k_bayar_pinjaman->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $kontrak_edit->RightColumnClass ?>"><div<?php echo $kontrak->k_bayar_pinjaman->CellAttributes() ?>>
<span id="el_kontrak_k_bayar_pinjaman">
<input type="text" data-table="kontrak" data-field="x_k_bayar_pinjaman" name="x_k_bayar_pinjaman" id="x_k_bayar_pinjaman" size="30" placeholder="<?php echo ew_HtmlEncode($kontrak->k_bayar_pinjaman->getPlaceHolder()) ?>" value="<?php echo $kontrak->k_bayar_pinjaman->EditValue ?>"<?php echo $kontrak->k_bayar_pinjaman->EditAttributes() ?>>
</span>
<?php echo $kontrak->k_bayar_pinjaman->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kontrak->k_sisa_hutang->Visible) { // k_sisa_hutang ?>
	<div id="r_k_sisa_hutang" class="form-group">
		<label id="elh_kontrak_k_sisa_hutang" for="x_k_sisa_hutang" class="<?php echo $kontrak_edit->LeftColumnClass ?>"><?php echo $kontrak->k_sisa_hutang->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $kontrak_edit->RightColumnClass ?>"><div<?php echo $kontrak->k_sisa_hutang->CellAttributes() ?>>
<span id="el_kontrak_k_sisa_hutang">
<input type="text" data-table="kontrak" data-field="x_k_sisa_hutang" name="x_k_sisa_hutang" id="x_k_sisa_hutang" size="30" placeholder="<?php echo ew_HtmlEncode($kontrak->k_sisa_hutang->getPlaceHolder()) ?>" value="<?php echo $kontrak->k_sisa_hutang->EditValue ?>"<?php echo $kontrak->k_sisa_hutang->EditAttributes() ?>>
</span>
<?php echo $kontrak->k_sisa_hutang->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<input type="hidden" data-table="kontrak" data-field="x_k_id" name="x_k_id" id="x_k_id" value="<?php echo ew_HtmlEncode($kontrak->k_id->CurrentValue) ?>">
<?php if (!$kontrak_edit->IsModal) { ?>
<div class="form-group"><!-- buttons .form-group -->
	<div class="<?php echo $kontrak_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ewButton" name="btnAction" id="btnAction" type="submit"><?php echo $Language->Phrase("SaveBtn") ?></button>
<button class="btn btn-default ewButton" name="btnCancel" id="btnCancel" type="button" data-href="<?php echo $kontrak_edit->getReturnUrl() ?>"><?php echo $Language->Phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<script type="text/javascript">
fkontrakedit.Init();
</script>
<?php
$kontrak_edit->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$kontrak_edit->Page_Terminate();
?>
