<?php

// Global variable for table object
$kontrak_koord = NULL;

//
// Table class for kontrak_koord
//
class ckontrak_koord extends cTable {
	var $kk_id;
	var $kk_no_kontrak;
	var $koord_id;
	var $kk_tgl_mulai;
	var $kk_tgl_akhir;
	var $kk_periode;
	var $var_id;
	var $kk_harga;
	var $kk_luas;
	var $kk_dok;

	//
	// Table class constructor
	//
	function __construct() {
		global $Language;

		// Language object
		if (!isset($Language)) $Language = new cLanguage();
		$this->TableVar = 'kontrak_koord';
		$this->TableName = 'kontrak_koord';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`kontrak_koord`";
		$this->DBID = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = ""; // Page orientation (PHPExcel only)
		$this->ExportExcelPageSize = ""; // Page size (PHPExcel only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new cBasicSearch($this->TableVar);

		// kk_id
		$this->kk_id = new cField('kontrak_koord', 'kontrak_koord', 'x_kk_id', 'kk_id', '`kk_id`', '`kk_id`', 3, -1, FALSE, '`kk_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->kk_id->Sortable = TRUE; // Allow sort
		$this->kk_id->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['kk_id'] = &$this->kk_id;

		// kk_no_kontrak
		$this->kk_no_kontrak = new cField('kontrak_koord', 'kontrak_koord', 'x_kk_no_kontrak', 'kk_no_kontrak', '`kk_no_kontrak`', '`kk_no_kontrak`', 200, -1, FALSE, '`kk_no_kontrak`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->kk_no_kontrak->Sortable = TRUE; // Allow sort
		$this->fields['kk_no_kontrak'] = &$this->kk_no_kontrak;

		// koord_id
		$this->koord_id = new cField('kontrak_koord', 'kontrak_koord', 'x_koord_id', 'koord_id', '`koord_id`', '`koord_id`', 3, -1, FALSE, '`koord_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->koord_id->Sortable = TRUE; // Allow sort
		$this->koord_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->koord_id->PleaseSelectText = $Language->Phrase("PleaseSelect"); // PleaseSelect text
		$this->koord_id->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['koord_id'] = &$this->koord_id;

		// kk_tgl_mulai
		$this->kk_tgl_mulai = new cField('kontrak_koord', 'kontrak_koord', 'x_kk_tgl_mulai', 'kk_tgl_mulai', '`kk_tgl_mulai`', ew_CastDateFieldForLike('`kk_tgl_mulai`', 5, "DB"), 133, 5, FALSE, '`kk_tgl_mulai`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->kk_tgl_mulai->Sortable = TRUE; // Allow sort
		$this->kk_tgl_mulai->FldDefaultErrMsg = str_replace("%s", $GLOBALS["EW_DATE_SEPARATOR"], $Language->Phrase("IncorrectDateYMD"));
		$this->fields['kk_tgl_mulai'] = &$this->kk_tgl_mulai;

		// kk_tgl_akhir
		$this->kk_tgl_akhir = new cField('kontrak_koord', 'kontrak_koord', 'x_kk_tgl_akhir', 'kk_tgl_akhir', '`kk_tgl_akhir`', ew_CastDateFieldForLike('`kk_tgl_akhir`', 5, "DB"), 133, 5, FALSE, '`kk_tgl_akhir`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->kk_tgl_akhir->Sortable = TRUE; // Allow sort
		$this->kk_tgl_akhir->FldDefaultErrMsg = str_replace("%s", $GLOBALS["EW_DATE_SEPARATOR"], $Language->Phrase("IncorrectDateYMD"));
		$this->fields['kk_tgl_akhir'] = &$this->kk_tgl_akhir;

		// kk_periode
		$this->kk_periode = new cField('kontrak_koord', 'kontrak_koord', 'x_kk_periode', 'kk_periode', '`kk_periode`', '`kk_periode`', 3, -1, FALSE, '`kk_periode`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->kk_periode->Sortable = TRUE; // Allow sort
		$this->kk_periode->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['kk_periode'] = &$this->kk_periode;

		// var_id
		$this->var_id = new cField('kontrak_koord', 'kontrak_koord', 'x_var_id', 'var_id', '`var_id`', '`var_id`', 3, -1, FALSE, '`var_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->var_id->Sortable = TRUE; // Allow sort
		$this->var_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->var_id->PleaseSelectText = $Language->Phrase("PleaseSelect"); // PleaseSelect text
		$this->var_id->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['var_id'] = &$this->var_id;

		// kk_harga
		$this->kk_harga = new cField('kontrak_koord', 'kontrak_koord', 'x_kk_harga', 'kk_harga', '`kk_harga`', '`kk_harga`', 3, -1, FALSE, '`kk_harga`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->kk_harga->Sortable = TRUE; // Allow sort
		$this->kk_harga->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['kk_harga'] = &$this->kk_harga;

		// kk_luas
		$this->kk_luas = new cField('kontrak_koord', 'kontrak_koord', 'x_kk_luas', 'kk_luas', '`kk_luas`', '`kk_luas`', 3, -1, FALSE, '`kk_luas`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->kk_luas->Sortable = TRUE; // Allow sort
		$this->kk_luas->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['kk_luas'] = &$this->kk_luas;

		// kk_dok
		$this->kk_dok = new cField('kontrak_koord', 'kontrak_koord', 'x_kk_dok', 'kk_dok', '`kk_dok`', '`kk_dok`', 200, -1, TRUE, '`kk_dok`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->kk_dok->Sortable = TRUE; // Allow sort
		$this->kk_dok->ImageResize = TRUE;
		$this->fields['kk_dok'] = &$this->kk_dok;
	}

	// Field Visibility
	function GetFieldVisibility($fldparm) {
		global $Security;
		return $this->$fldparm->Visible; // Returns original value
	}

	// Column CSS classes
	var $LeftColumnClass = "col-sm-2 control-label ewLabel";
	var $RightColumnClass = "col-sm-10";
	var $OffsetColumnClass = "col-sm-10 col-sm-offset-2";

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function SetLeftColumnClass($class) {
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " control-label ewLabel";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - intval($match[2]));
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace($match[1], $match[1] + "-offset", $class);
		}
	}

	// Single column sort
	function UpdateSort(&$ofld) {
		if ($this->CurrentOrder == $ofld->FldName) {
			$sSortField = $ofld->FldExpression;
			$sLastSort = $ofld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$sThisSort = $this->CurrentOrderType;
			} else {
				$sThisSort = ($sLastSort == "ASC") ? "DESC" : "ASC";
			}
			$ofld->setSort($sThisSort);
			$this->setSessionOrderBy($sSortField . " " . $sThisSort); // Save to Session
		} else {
			$ofld->setSort("");
		}
	}

	// Table level SQL
	var $_SqlFrom = "";

	function getSqlFrom() { // From
		return ($this->_SqlFrom <> "") ? $this->_SqlFrom : "`kontrak_koord`";
	}

	function SqlFrom() { // For backward compatibility
		return $this->getSqlFrom();
	}

	function setSqlFrom($v) {
		$this->_SqlFrom = $v;
	}
	var $_SqlSelect = "";

	function getSqlSelect() { // Select
		return ($this->_SqlSelect <> "") ? $this->_SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}

	function SqlSelect() { // For backward compatibility
		return $this->getSqlSelect();
	}

	function setSqlSelect($v) {
		$this->_SqlSelect = $v;
	}
	var $_SqlWhere = "";

	function getSqlWhere() { // Where
		$sWhere = ($this->_SqlWhere <> "") ? $this->_SqlWhere : "";
		$this->TableFilter = "";
		ew_AddFilter($sWhere, $this->TableFilter);
		return $sWhere;
	}

	function SqlWhere() { // For backward compatibility
		return $this->getSqlWhere();
	}

	function setSqlWhere($v) {
		$this->_SqlWhere = $v;
	}
	var $_SqlGroupBy = "";

	function getSqlGroupBy() { // Group By
		return ($this->_SqlGroupBy <> "") ? $this->_SqlGroupBy : "";
	}

	function SqlGroupBy() { // For backward compatibility
		return $this->getSqlGroupBy();
	}

	function setSqlGroupBy($v) {
		$this->_SqlGroupBy = $v;
	}
	var $_SqlHaving = "";

	function getSqlHaving() { // Having
		return ($this->_SqlHaving <> "") ? $this->_SqlHaving : "";
	}

	function SqlHaving() { // For backward compatibility
		return $this->getSqlHaving();
	}

	function setSqlHaving($v) {
		$this->_SqlHaving = $v;
	}
	var $_SqlOrderBy = "";

	function getSqlOrderBy() { // Order By
		return ($this->_SqlOrderBy <> "") ? $this->_SqlOrderBy : "`kk_id` DESC";
	}

	function SqlOrderBy() { // For backward compatibility
		return $this->getSqlOrderBy();
	}

	function setSqlOrderBy($v) {
		$this->_SqlOrderBy = $v;
	}

	// Apply User ID filters
	function ApplyUserIDFilters($sFilter) {
		return $sFilter;
	}

	// Check if User ID security allows view all
	function UserIDAllow($id = "") {
		$allow = EW_USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	function GetSQL($where, $orderby) {
		return ew_BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderby);
	}

	// Table SQL
	function SQL() {
		$filter = $this->CurrentFilter;
		$filter = $this->ApplyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->GetSQL($filter, $sort);
	}

	// Table SQL with List page filter
	var $UseSessionForListSQL = TRUE;

	function ListSQL() {
		$sFilter = $this->UseSessionForListSQL ? $this->getSessionWhere() : "";
		ew_AddFilter($sFilter, $this->CurrentFilter);
		$sFilter = $this->ApplyUserIDFilters($sFilter);
		$this->Recordset_Selecting($sFilter);
		$sSelect = $this->getSqlSelect();
		$sSort = $this->UseSessionForListSQL ? $this->getSessionOrderBy() : "";
		return ew_BuildSelectSql($sSelect, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $sFilter, $sSort);
	}

	// Get ORDER BY clause
	function GetOrderBy() {
		$sSort = $this->getSessionOrderBy();
		return ew_BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sSort);
	}

	// Try to get record count
	function TryGetRecordCount($sql) {
		$cnt = -1;
		$pattern = "/^SELECT \* FROM/i";
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') && preg_match($pattern, $sql)) {
			$sql = "SELECT COUNT(*) FROM" . preg_replace($pattern, "", $sql);
		} else {
			$sql = "SELECT COUNT(*) FROM (" . $sql . ") EW_COUNT_TABLE";
		}
		$conn = &$this->Connection();
		if ($rs = $conn->Execute($sql)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->Close();
			}
		}
		return intval($cnt);
	}

	// Get record count based on filter (for detail record count in master table pages)
	function LoadRecordCount($filter) {
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = ew_BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->TryGetRecordCount($sql);
		if ($cnt == -1) {
			if ($rs = $this->LoadRs($this->CurrentFilter)) {
				$cnt = $rs->RecordCount();
				$rs->Close();
			}
		}
		$this->CurrentFilter = $origFilter;
		return intval($cnt);
	}

	// Get record count (for current List page)
	function ListRecordCount() {
		$filter = $this->getSessionWhere();
		ew_AddFilter($filter, $this->CurrentFilter);
		$filter = $this->ApplyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = ew_BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->TryGetRecordCount($sql);
		if ($cnt == -1) {
			$conn = &$this->Connection();
			if ($rs = $conn->Execute($sql)) {
				$cnt = $rs->RecordCount();
				$rs->Close();
			}
		}
		return intval($cnt);
	}

	// INSERT statement
	function InsertSQL(&$rs) {
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->FldIsCustom)
				continue;
			$names .= $this->fields[$name]->FldExpression . ",";
			$values .= ew_QuotedValue($value, $this->fields[$name]->FldDataType, $this->DBID) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	function Insert(&$rs) {
		$conn = &$this->Connection();
		$bInsert = $conn->Execute($this->InsertSQL($rs));
		if ($bInsert) {

			// Get insert id if necessary
			$this->kk_id->setDbValue($conn->Insert_ID());
			$rs['kk_id'] = $this->kk_id->DbValue;
		}
		return $bInsert;
	}

	// UPDATE statement
	function UpdateSQL(&$rs, $where = "", $curfilter = TRUE) {
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->FldIsCustom)
				continue;
			$sql .= $this->fields[$name]->FldExpression . "=";
			$sql .= ew_QuotedValue($value, $this->fields[$name]->FldDataType, $this->DBID) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->ArrayToFilter($where);
		ew_AddFilter($filter, $where);
		if ($filter <> "")	$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	function Update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE) {
		$conn = &$this->Connection();
		$bUpdate = $conn->Execute($this->UpdateSQL($rs, $where, $curfilter));
		return $bUpdate;
	}

	// DELETE statement
	function DeleteSQL(&$rs, $where = "", $curfilter = TRUE) {
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->ArrayToFilter($where);
		if ($rs) {
			if (array_key_exists('kk_id', $rs))
				ew_AddFilter($where, ew_QuotedName('kk_id', $this->DBID) . '=' . ew_QuotedValue($rs['kk_id'], $this->kk_id->FldDataType, $this->DBID));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		ew_AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	function Delete(&$rs, $where = "", $curfilter = TRUE) {
		$bDelete = TRUE;
		$conn = &$this->Connection();
		if ($bDelete)
			$bDelete = $conn->Execute($this->DeleteSQL($rs, $where, $curfilter));
		return $bDelete;
	}

	// Key filter WHERE clause
	function SqlKeyFilter() {
		return "`kk_id` = @kk_id@";
	}

	// Key filter
	function KeyFilter() {
		$sKeyFilter = $this->SqlKeyFilter();
		if (!is_numeric($this->kk_id->CurrentValue))
			return "0=1"; // Invalid key
		if (is_null($this->kk_id->CurrentValue))
			return "0=1"; // Invalid key
		else
			$sKeyFilter = str_replace("@kk_id@", ew_AdjustSql($this->kk_id->CurrentValue, $this->DBID), $sKeyFilter); // Replace key value
		return $sKeyFilter;
	}

	// Return page URL
	function getReturnUrl() {
		$name = EW_PROJECT_NAME . "_" . $this->TableVar . "_" . EW_TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ew_ServerVar("HTTP_REFERER") <> "" && ew_ReferPage() <> ew_CurrentPage() && ew_ReferPage() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ew_ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "kontrak_koordlist.php";
		}
	}

	function setReturnUrl($v) {
		$_SESSION[EW_PROJECT_NAME . "_" . $this->TableVar . "_" . EW_TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	function GetModalCaption($pageName) {
		global $Language;
		if ($pageName == "kontrak_koordview.php")
			return $Language->Phrase("View");
		elseif ($pageName == "kontrak_koordedit.php")
			return $Language->Phrase("Edit");
		elseif ($pageName == "kontrak_koordadd.php")
			return $Language->Phrase("Add");
		else
			return "";
	}

	// List URL
	function GetListUrl() {
		return "kontrak_koordlist.php";
	}

	// View URL
	function GetViewUrl($parm = "") {
		if ($parm <> "")
			$url = $this->KeyUrl("kontrak_koordview.php", $this->UrlParm($parm));
		else
			$url = $this->KeyUrl("kontrak_koordview.php", $this->UrlParm(EW_TABLE_SHOW_DETAIL . "="));
		return $this->AddMasterUrl($url);
	}

	// Add URL
	function GetAddUrl($parm = "") {
		if ($parm <> "")
			$url = "kontrak_koordadd.php?" . $this->UrlParm($parm);
		else
			$url = "kontrak_koordadd.php";
		return $this->AddMasterUrl($url);
	}

	// Edit URL
	function GetEditUrl($parm = "") {
		$url = $this->KeyUrl("kontrak_koordedit.php", $this->UrlParm($parm));
		return $this->AddMasterUrl($url);
	}

	// Inline edit URL
	function GetInlineEditUrl() {
		$url = $this->KeyUrl(ew_CurrentPage(), $this->UrlParm("a=edit"));
		return $this->AddMasterUrl($url);
	}

	// Copy URL
	function GetCopyUrl($parm = "") {
		$url = $this->KeyUrl("kontrak_koordadd.php", $this->UrlParm($parm));
		return $this->AddMasterUrl($url);
	}

	// Inline copy URL
	function GetInlineCopyUrl() {
		$url = $this->KeyUrl(ew_CurrentPage(), $this->UrlParm("a=copy"));
		return $this->AddMasterUrl($url);
	}

	// Delete URL
	function GetDeleteUrl() {
		return $this->KeyUrl("kontrak_koorddelete.php", $this->UrlParm());
	}

	// Add master url
	function AddMasterUrl($url) {
		return $url;
	}

	function KeyToJson() {
		$json = "";
		$json .= "kk_id:" . ew_VarToJson($this->kk_id->CurrentValue, "number", "'");
		return "{" . $json . "}";
	}

	// Add key value to URL
	function KeyUrl($url, $parm = "") {
		$sUrl = $url . "?";
		if ($parm <> "") $sUrl .= $parm . "&";
		if (!is_null($this->kk_id->CurrentValue)) {
			$sUrl .= "kk_id=" . urlencode($this->kk_id->CurrentValue);
		} else {
			return "javascript:ew_Alert(ewLanguage.Phrase('InvalidRecord'));";
		}
		return $sUrl;
	}

	// Sort URL
	function SortUrl(&$fld) {
		if ($this->CurrentAction <> "" || $this->Export <> "" ||
			in_array($fld->FldType, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$sUrlParm = $this->UrlParm("order=" . urlencode($fld->FldName) . "&amp;ordertype=" . $fld->ReverseSort());
			return $this->AddMasterUrl(ew_CurrentPage() . "?" . $sUrlParm);
		} else {
			return "";
		}
	}

	// Get record keys from $_POST/$_GET/$_SESSION
	function GetRecordKeys() {
		global $EW_COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (isset($_POST["key_m"])) {
			$arKeys = $_POST["key_m"];
			$cnt = count($arKeys);
		} elseif (isset($_GET["key_m"])) {
			$arKeys = $_GET["key_m"];
			$cnt = count($arKeys);
		} elseif (!empty($_GET) || !empty($_POST)) {
			$isPost = ew_IsPost();
			if ($isPost && isset($_POST["kk_id"]))
				$arKeys[] = $_POST["kk_id"];
			elseif (isset($_GET["kk_id"]))
				$arKeys[] = $_GET["kk_id"];
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get key filter
	function GetKeyFilter() {
		$arKeys = $this->GetRecordKeys();
		$sKeyFilter = "";
		foreach ($arKeys as $key) {
			if ($sKeyFilter <> "") $sKeyFilter .= " OR ";
			$this->kk_id->CurrentValue = $key;
			$sKeyFilter .= "(" . $this->KeyFilter() . ")";
		}
		return $sKeyFilter;
	}

	// Load rows based on filter
	function &LoadRs($filter) {

		// Set up filter (SQL WHERE clause) and get return SQL
		//$this->CurrentFilter = $filter;
		//$sql = $this->SQL();

		$sql = $this->GetSQL($filter, "");
		$conn = &$this->Connection();
		$rs = $conn->Execute($sql);
		return $rs;
	}

	// Load row values from recordset
	function LoadListRowValues(&$rs) {
		$this->kk_id->setDbValue($rs->fields('kk_id'));
		$this->kk_no_kontrak->setDbValue($rs->fields('kk_no_kontrak'));
		$this->koord_id->setDbValue($rs->fields('koord_id'));
		$this->kk_tgl_mulai->setDbValue($rs->fields('kk_tgl_mulai'));
		$this->kk_tgl_akhir->setDbValue($rs->fields('kk_tgl_akhir'));
		$this->kk_periode->setDbValue($rs->fields('kk_periode'));
		$this->var_id->setDbValue($rs->fields('var_id'));
		$this->kk_harga->setDbValue($rs->fields('kk_harga'));
		$this->kk_luas->setDbValue($rs->fields('kk_luas'));
		$this->kk_dok->Upload->DbValue = $rs->fields('kk_dok');
	}

	// Render list row values
	function RenderListRow() {
		global $Security, $gsLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

	// Common render codes
		// kk_id
		// kk_no_kontrak
		// koord_id
		// kk_tgl_mulai
		// kk_tgl_akhir
		// kk_periode
		// var_id
		// kk_harga
		// kk_luas
		// kk_dok
		// kk_id

		$this->kk_id->ViewValue = $this->kk_id->CurrentValue;
		$this->kk_id->ViewCustomAttributes = "";

		// kk_no_kontrak
		$this->kk_no_kontrak->ViewValue = $this->kk_no_kontrak->CurrentValue;
		$this->kk_no_kontrak->ViewCustomAttributes = "";

		// koord_id
		if (strval($this->koord_id->CurrentValue) <> "") {
			$sFilterWrk = "`koord_id`" . ew_SearchString("=", $this->koord_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `koord_id`, `koord_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `koord`";
		$sWhereWrk = "";
		$this->koord_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->koord_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `koord_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->koord_id->ViewValue = $this->koord_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->koord_id->ViewValue = $this->koord_id->CurrentValue;
			}
		} else {
			$this->koord_id->ViewValue = NULL;
		}
		$this->koord_id->ViewCustomAttributes = "";

		// kk_tgl_mulai
		$this->kk_tgl_mulai->ViewValue = $this->kk_tgl_mulai->CurrentValue;
		$this->kk_tgl_mulai->ViewValue = ew_FormatDateTime($this->kk_tgl_mulai->ViewValue, 5);
		$this->kk_tgl_mulai->ViewCustomAttributes = "";

		// kk_tgl_akhir
		$this->kk_tgl_akhir->ViewValue = $this->kk_tgl_akhir->CurrentValue;
		$this->kk_tgl_akhir->ViewValue = ew_FormatDateTime($this->kk_tgl_akhir->ViewValue, 5);
		$this->kk_tgl_akhir->ViewCustomAttributes = "";

		// kk_periode
		$this->kk_periode->ViewValue = $this->kk_periode->CurrentValue;
		$this->kk_periode->ViewCustomAttributes = "";

		// var_id
		if (strval($this->var_id->CurrentValue) <> "") {
			$sFilterWrk = "`var_id`" . ew_SearchString("=", $this->var_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `var_id`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `varietas`";
		$sWhereWrk = "";
		$this->var_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->var_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->var_id->ViewValue = $this->var_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->var_id->ViewValue = $this->var_id->CurrentValue;
			}
		} else {
			$this->var_id->ViewValue = NULL;
		}
		$this->var_id->ViewCustomAttributes = "";

		// kk_harga
		$this->kk_harga->ViewValue = $this->kk_harga->CurrentValue;
		$this->kk_harga->ViewCustomAttributes = "";

		// kk_luas
		$this->kk_luas->ViewValue = $this->kk_luas->CurrentValue;
		$this->kk_luas->ViewCustomAttributes = "";

		// kk_dok
		$this->kk_dok->UploadPath = "dokumen_kontrak_koordinator";
		if (!ew_Empty($this->kk_dok->Upload->DbValue)) {
			$this->kk_dok->ImageWidth = 42;
			$this->kk_dok->ImageHeight = 70;
			$this->kk_dok->ImageAlt = $this->kk_dok->FldAlt();
			$this->kk_dok->ViewValue = $this->kk_dok->Upload->DbValue;
		} else {
			$this->kk_dok->ViewValue = "";
		}
		$this->kk_dok->ViewCustomAttributes = "";

		// kk_id
		$this->kk_id->LinkCustomAttributes = "";
		$this->kk_id->HrefValue = "";
		$this->kk_id->TooltipValue = "";

		// kk_no_kontrak
		$this->kk_no_kontrak->LinkCustomAttributes = "";
		$this->kk_no_kontrak->HrefValue = "";
		$this->kk_no_kontrak->TooltipValue = "";

		// koord_id
		$this->koord_id->LinkCustomAttributes = "";
		if (!ew_Empty($this->koord_id->CurrentValue)) {
			$this->koord_id->HrefValue = "koordview.php?showdetail=&koord_id=" . $this->koord_id->CurrentValue; // Add prefix/suffix
			$this->koord_id->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->Export <> "") $this->koord_id->HrefValue = ew_FullUrl($this->koord_id->HrefValue, "href");
		} else {
			$this->koord_id->HrefValue = "";
		}
		$this->koord_id->TooltipValue = "";

		// kk_tgl_mulai
		$this->kk_tgl_mulai->LinkCustomAttributes = "";
		$this->kk_tgl_mulai->HrefValue = "";
		$this->kk_tgl_mulai->TooltipValue = "";

		// kk_tgl_akhir
		$this->kk_tgl_akhir->LinkCustomAttributes = "";
		$this->kk_tgl_akhir->HrefValue = "";
		$this->kk_tgl_akhir->TooltipValue = "";

		// kk_periode
		$this->kk_periode->LinkCustomAttributes = "";
		$this->kk_periode->HrefValue = "";
		$this->kk_periode->TooltipValue = "";

		// var_id
		$this->var_id->LinkCustomAttributes = "";
		$this->var_id->HrefValue = "";
		$this->var_id->TooltipValue = "";

		// kk_harga
		$this->kk_harga->LinkCustomAttributes = "";
		$this->kk_harga->HrefValue = "";
		$this->kk_harga->TooltipValue = "";

		// kk_luas
		$this->kk_luas->LinkCustomAttributes = "";
		$this->kk_luas->HrefValue = "";
		$this->kk_luas->TooltipValue = "";

		// kk_dok
		$this->kk_dok->LinkCustomAttributes = "";
		$this->kk_dok->UploadPath = "dokumen_kontrak_koordinator";
		if (!ew_Empty($this->kk_dok->Upload->DbValue)) {
			$this->kk_dok->HrefValue = ew_GetFileUploadUrl($this->kk_dok, $this->kk_dok->Upload->DbValue); // Add prefix/suffix
			$this->kk_dok->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->Export <> "") $this->kk_dok->HrefValue = ew_FullUrl($this->kk_dok->HrefValue, "href");
		} else {
			$this->kk_dok->HrefValue = "";
		}
		$this->kk_dok->HrefValue2 = $this->kk_dok->UploadPath . $this->kk_dok->Upload->DbValue;
		$this->kk_dok->TooltipValue = "";
		if ($this->kk_dok->UseColorbox) {
			if (ew_Empty($this->kk_dok->TooltipValue))
				$this->kk_dok->LinkAttrs["title"] = $Language->Phrase("ViewImageGallery");
			$this->kk_dok->LinkAttrs["data-rel"] = "kontrak_koord_x_kk_dok";
			ew_AppendClass($this->kk_dok->LinkAttrs["class"], "ewLightbox");
		}

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->CustomTemplateFieldValues();
	}

	// Render edit row values
	function RenderEditRow() {
		global $Security, $gsLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// kk_id
		$this->kk_id->EditAttrs["class"] = "form-control";
		$this->kk_id->EditCustomAttributes = "";
		$this->kk_id->EditValue = $this->kk_id->CurrentValue;
		$this->kk_id->ViewCustomAttributes = "";

		// kk_no_kontrak
		$this->kk_no_kontrak->EditAttrs["class"] = "form-control";
		$this->kk_no_kontrak->EditCustomAttributes = "";
		$this->kk_no_kontrak->EditValue = $this->kk_no_kontrak->CurrentValue;
		$this->kk_no_kontrak->PlaceHolder = ew_RemoveHtml($this->kk_no_kontrak->FldCaption());

		// koord_id
		$this->koord_id->EditAttrs["class"] = "form-control";
		$this->koord_id->EditCustomAttributes = "";

		// kk_tgl_mulai
		$this->kk_tgl_mulai->EditAttrs["class"] = "form-control";
		$this->kk_tgl_mulai->EditCustomAttributes = "";
		$this->kk_tgl_mulai->EditValue = ew_FormatDateTime($this->kk_tgl_mulai->CurrentValue, 5);
		$this->kk_tgl_mulai->PlaceHolder = ew_RemoveHtml($this->kk_tgl_mulai->FldCaption());

		// kk_tgl_akhir
		$this->kk_tgl_akhir->EditAttrs["class"] = "form-control";
		$this->kk_tgl_akhir->EditCustomAttributes = "";
		$this->kk_tgl_akhir->EditValue = ew_FormatDateTime($this->kk_tgl_akhir->CurrentValue, 5);
		$this->kk_tgl_akhir->PlaceHolder = ew_RemoveHtml($this->kk_tgl_akhir->FldCaption());

		// kk_periode
		$this->kk_periode->EditAttrs["class"] = "form-control";
		$this->kk_periode->EditCustomAttributes = "";
		$this->kk_periode->EditValue = $this->kk_periode->CurrentValue;
		$this->kk_periode->PlaceHolder = ew_RemoveHtml($this->kk_periode->FldCaption());

		// var_id
		$this->var_id->EditAttrs["class"] = "form-control";
		$this->var_id->EditCustomAttributes = "";

		// kk_harga
		$this->kk_harga->EditAttrs["class"] = "form-control";
		$this->kk_harga->EditCustomAttributes = "";
		$this->kk_harga->EditValue = $this->kk_harga->CurrentValue;
		$this->kk_harga->PlaceHolder = ew_RemoveHtml($this->kk_harga->FldCaption());

		// kk_luas
		$this->kk_luas->EditAttrs["class"] = "form-control";
		$this->kk_luas->EditCustomAttributes = "";
		$this->kk_luas->EditValue = $this->kk_luas->CurrentValue;
		$this->kk_luas->PlaceHolder = ew_RemoveHtml($this->kk_luas->FldCaption());

		// kk_dok
		$this->kk_dok->EditAttrs["class"] = "form-control";
		$this->kk_dok->EditCustomAttributes = "";
		$this->kk_dok->UploadPath = "dokumen_kontrak_koordinator";
		if (!ew_Empty($this->kk_dok->Upload->DbValue)) {
			$this->kk_dok->ImageWidth = 42;
			$this->kk_dok->ImageHeight = 70;
			$this->kk_dok->ImageAlt = $this->kk_dok->FldAlt();
			$this->kk_dok->EditValue = $this->kk_dok->Upload->DbValue;
		} else {
			$this->kk_dok->EditValue = "";
		}
		if (!ew_Empty($this->kk_dok->CurrentValue))
				$this->kk_dok->Upload->FileName = $this->kk_dok->CurrentValue;

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	function AggregateListRowValues() {
	}

	// Aggregate list row (for rendering)
	function AggregateListRow() {

		// Call Row Rendered event
		$this->Row_Rendered();
	}
	var $ExportDoc;

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	function ExportDocument(&$Doc, &$Recordset, $StartRec, $StopRec, $ExportPageType = "") {
		if (!$Recordset || !$Doc)
			return;
		if (!$Doc->ExportCustom) {

			// Write header
			$Doc->ExportTableHeader();
			if ($Doc->Horizontal) { // Horizontal format, write header
				$Doc->BeginExportRow();
				if ($ExportPageType == "view") {
					if ($this->kk_id->Exportable) $Doc->ExportCaption($this->kk_id);
					if ($this->kk_no_kontrak->Exportable) $Doc->ExportCaption($this->kk_no_kontrak);
					if ($this->koord_id->Exportable) $Doc->ExportCaption($this->koord_id);
					if ($this->kk_tgl_mulai->Exportable) $Doc->ExportCaption($this->kk_tgl_mulai);
					if ($this->kk_tgl_akhir->Exportable) $Doc->ExportCaption($this->kk_tgl_akhir);
					if ($this->kk_periode->Exportable) $Doc->ExportCaption($this->kk_periode);
					if ($this->var_id->Exportable) $Doc->ExportCaption($this->var_id);
					if ($this->kk_harga->Exportable) $Doc->ExportCaption($this->kk_harga);
					if ($this->kk_luas->Exportable) $Doc->ExportCaption($this->kk_luas);
					if ($this->kk_dok->Exportable) $Doc->ExportCaption($this->kk_dok);
				} else {
					if ($this->kk_id->Exportable) $Doc->ExportCaption($this->kk_id);
					if ($this->kk_no_kontrak->Exportable) $Doc->ExportCaption($this->kk_no_kontrak);
					if ($this->koord_id->Exportable) $Doc->ExportCaption($this->koord_id);
					if ($this->kk_tgl_mulai->Exportable) $Doc->ExportCaption($this->kk_tgl_mulai);
					if ($this->kk_tgl_akhir->Exportable) $Doc->ExportCaption($this->kk_tgl_akhir);
					if ($this->kk_periode->Exportable) $Doc->ExportCaption($this->kk_periode);
					if ($this->var_id->Exportable) $Doc->ExportCaption($this->var_id);
					if ($this->kk_harga->Exportable) $Doc->ExportCaption($this->kk_harga);
					if ($this->kk_luas->Exportable) $Doc->ExportCaption($this->kk_luas);
					if ($this->kk_dok->Exportable) $Doc->ExportCaption($this->kk_dok);
				}
				$Doc->EndExportRow();
			}
		}

		// Move to first record
		$RecCnt = $StartRec - 1;
		if (!$Recordset->EOF) {
			$Recordset->MoveFirst();
			if ($StartRec > 1)
				$Recordset->Move($StartRec - 1);
		}
		while (!$Recordset->EOF && $RecCnt < $StopRec) {
			$RecCnt++;
			if (intval($RecCnt) >= intval($StartRec)) {
				$RowCnt = intval($RecCnt) - intval($StartRec) + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($RowCnt > 1 && ($RowCnt - 1) % $this->ExportPageBreakCount == 0)
						$Doc->ExportPageBreak();
				}
				$this->LoadListRowValues($Recordset);

				// Render row
				$this->RowType = EW_ROWTYPE_VIEW; // Render view
				$this->ResetAttrs();
				$this->RenderListRow();
				if (!$Doc->ExportCustom) {
					$Doc->BeginExportRow($RowCnt); // Allow CSS styles if enabled
					if ($ExportPageType == "view") {
						if ($this->kk_id->Exportable) $Doc->ExportField($this->kk_id);
						if ($this->kk_no_kontrak->Exportable) $Doc->ExportField($this->kk_no_kontrak);
						if ($this->koord_id->Exportable) $Doc->ExportField($this->koord_id);
						if ($this->kk_tgl_mulai->Exportable) $Doc->ExportField($this->kk_tgl_mulai);
						if ($this->kk_tgl_akhir->Exportable) $Doc->ExportField($this->kk_tgl_akhir);
						if ($this->kk_periode->Exportable) $Doc->ExportField($this->kk_periode);
						if ($this->var_id->Exportable) $Doc->ExportField($this->var_id);
						if ($this->kk_harga->Exportable) $Doc->ExportField($this->kk_harga);
						if ($this->kk_luas->Exportable) $Doc->ExportField($this->kk_luas);
						if ($this->kk_dok->Exportable) $Doc->ExportField($this->kk_dok);
					} else {
						if ($this->kk_id->Exportable) $Doc->ExportField($this->kk_id);
						if ($this->kk_no_kontrak->Exportable) $Doc->ExportField($this->kk_no_kontrak);
						if ($this->koord_id->Exportable) $Doc->ExportField($this->koord_id);
						if ($this->kk_tgl_mulai->Exportable) $Doc->ExportField($this->kk_tgl_mulai);
						if ($this->kk_tgl_akhir->Exportable) $Doc->ExportField($this->kk_tgl_akhir);
						if ($this->kk_periode->Exportable) $Doc->ExportField($this->kk_periode);
						if ($this->var_id->Exportable) $Doc->ExportField($this->var_id);
						if ($this->kk_harga->Exportable) $Doc->ExportField($this->kk_harga);
						if ($this->kk_luas->Exportable) $Doc->ExportField($this->kk_luas);
						if ($this->kk_dok->Exportable) $Doc->ExportField($this->kk_dok);
					}
					$Doc->EndExportRow($RowCnt);
				}
			}

			// Call Row Export server event
			if ($Doc->ExportCustom)
				$this->Row_Export($Recordset->fields);
			$Recordset->MoveNext();
		}
		if (!$Doc->ExportCustom) {
			$Doc->ExportTableFooter();
		}
	}

	// Get auto fill value
	function GetAutoFill($id, $val) {
		$rsarr = array();
		$rowcnt = 0;

		// Output
		if (is_array($rsarr) && $rowcnt > 0) {
			$fldcnt = count($rsarr[0]);
			for ($i = 0; $i < $rowcnt; $i++) {
				for ($j = 0; $j < $fldcnt; $j++) {
					$str = strval($rsarr[$i][$j]);
					$str = ew_ConvertToUtf8($str);
					if (isset($post["keepCRLF"])) {
						$str = str_replace(array("\r", "\n"), array("\\r", "\\n"), $str);
					} else {
						$str = str_replace(array("\r", "\n"), array(" ", " "), $str);
					}
					$rsarr[$i][$j] = $str;
				}
			}
			return ew_ArrayToJson($rsarr);
		} else {
			return FALSE;
		}
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending(&$Email, &$Args) {

		//var_dump($Email); var_dump($Args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->FldName, $fld->LookupFilters, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>
