<?php
if (session_id() == "") session_start(); // Init session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg14.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql14.php") ?>
<?php include_once "phpfn14.php" ?>
<?php include_once "kegiatan_harianinfo.php" ?>
<?php include_once "employeesinfo.php" ?>
<?php include_once "userfn14.php" ?>
<?php

//
// Page class
//

$kegiatan_harian_list = NULL; // Initialize page object first

class ckegiatan_harian_list extends ckegiatan_harian {

	// Page ID
	var $PageID = 'list';

	// Project ID
	var $ProjectID = '{CC60B42B-604B-412A-B014-2315920AF6AA}';

	// Table name
	var $TableName = 'kegiatan_harian';

	// Page object name
	var $PageObjName = 'kegiatan_harian_list';

	// Grid form hidden field names
	var $FormName = 'fkegiatan_harianlist';
	var $FormActionName = 'k_action';
	var $FormKeyName = 'k_key';
	var $FormOldKeyName = 'k_oldkey';
	var $FormBlankRowName = 'k_blankrow';
	var $FormKeyCountName = 'key_count';

	// Page headings
	var $Heading = '';
	var $Subheading = '';

	// Page heading
	function PageHeading() {
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->TableCaption();
		return "";
	}

	// Page subheading
	function PageSubheading() {
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->Phrase($this->PageID);
		return "";
	}

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;
	var $ExportPdfUrl;

	// Custom export
	var $ExportExcelCustom = FALSE;
	var $ExportWordCustom = FALSE;
	var $ExportPdfCustom = FALSE;
	var $ExportEmailCustom = FALSE;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (kegiatan_harian)
		if (!isset($GLOBALS["kegiatan_harian"]) || get_class($GLOBALS["kegiatan_harian"]) == "ckegiatan_harian") {
			$GLOBALS["kegiatan_harian"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["kegiatan_harian"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->PageUrl() . "export=print";
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel";
		$this->ExportWordUrl = $this->PageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->PageUrl() . "export=html";
		$this->ExportXmlUrl = $this->PageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->PageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf";
		$this->AddUrl = "kegiatan_harianadd.php";
		$this->InlineAddUrl = $this->PageUrl() . "a=add";
		$this->GridAddUrl = $this->PageUrl() . "a=gridadd";
		$this->GridEditUrl = $this->PageUrl() . "a=gridedit";
		$this->MultiDeleteUrl = "kegiatan_hariandelete.php";
		$this->MultiUpdateUrl = "kegiatan_harianupdate.php";

		// Table object (employees)
		if (!isset($GLOBALS['employees'])) $GLOBALS['employees'] = new cemployees();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'list', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'kegiatan_harian', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"]))
			$GLOBALS["gTimer"] = new cTimer();

		// Debug message
		ew_LoadDebugMsg();

		// Open connection
		if (!isset($conn))
			$conn = ew_Connect($this->DBID);

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new cemployees();
			$UserTableConn = Conn($UserTable->DBID);
		}

		// List options
		$this->ListOptions = new cListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new cListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Other options
		$this->OtherOptions['addedit'] = new cListOptions();
		$this->OtherOptions['addedit']->Tag = "div";
		$this->OtherOptions['addedit']->TagClassName = "ewAddEditOption";
		$this->OtherOptions['detail'] = new cListOptions();
		$this->OtherOptions['detail']->Tag = "div";
		$this->OtherOptions['detail']->TagClassName = "ewDetailOption";
		$this->OtherOptions['action'] = new cListOptions();
		$this->OtherOptions['action']->Tag = "div";
		$this->OtherOptions['action']->TagClassName = "ewActionOption";

		// Filter options
		$this->FilterOptions = new cListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ewFilterOption fkegiatan_harianlistsrch";

		// List actions
		$this->ListActions = new cListActions();
	}

	//
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// User profile
		$UserProfile = new cUserProfile();

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanList()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			$this->Page_Terminate(ew_GetUrl("index.php"));
		}

		// NOTE: Security object may be needed in other part of the script, skip set to Nothing
		// 
		// Security = null;
		// 
		// Get export parameters

		$custom = "";
		if (@$_GET["export"] <> "") {
			$this->Export = $_GET["export"];
			$custom = @$_GET["custom"];
		} elseif (@$_POST["export"] <> "") {
			$this->Export = $_POST["export"];
			$custom = @$_POST["custom"];
		} elseif (ew_IsPost()) {
			if (@$_POST["exporttype"] <> "")
				$this->Export = $_POST["exporttype"];
			$custom = @$_POST["custom"];
		} elseif (@$_GET["cmd"] == "json") {
			$this->Export = $_GET["cmd"];
		} else {
			$this->setExportReturnUrl(ew_CurrentUrl());
		}
		$gsExportFile = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->Export <> "" && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$gsCustomExport = $this->CustomExport;
		$gsExport = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined("EW_USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined("EW_USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action

		// Get grid add count
		$gridaddcnt = @$_GET[EW_TABLE_GRID_ADD_ROW_COUNT];
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->SetupListOptions();

		// Setup export options
		$this->SetupExportOptions();
		$this->kh_id->SetVisibility();
		if ($this->IsAdd() || $this->IsCopy() || $this->IsGridAdd())
			$this->kh_id->Visible = FALSE;
		$this->kh_tgl->SetVisibility();
		$this->kh_co_id->SetVisibility();
		$this->kh_rencana->SetVisibility();
		$this->kh_realisasi->SetVisibility();
		$this->kh_hasil->SetVisibility();
		$this->kh_foto->SetVisibility();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();

		// Setup other options
		$this->SetupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->Add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == EW_ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $kegiatan_harian;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($kegiatan_harian);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		// Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			ew_SaveDebugMsg();
			header("Location: " . $url);
		}
		exit();
	}

	// Class variables
	var $ListOptions; // List options
	var $ExportOptions; // Export options
	var $SearchOptions; // Search options
	var $OtherOptions = array(); // Other options
	var $FilterOptions; // Filter options
	var $ListActions; // List actions
	var $SelectedCount = 0;
	var $SelectedIndex = 0;
	var $DisplayRecs = 100;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $Pager;
	var $AutoHidePager = EW_AUTO_HIDE_PAGER;
	var $AutoHidePageSizeSelector = EW_AUTO_HIDE_PAGE_SIZE_SELECTOR;
	var $DefaultSearchWhere = ""; // Default search WHERE clause
	var $SearchWhere = ""; // Search WHERE clause
	var $RecCnt = 0; // Record count
	var $EditRowCnt;
	var $StartRowCnt = 1;
	var $RowCnt = 0;
	var $Attrs = array(); // Row attributes and cell attributes
	var $RowIndex = 0; // Row index
	var $KeyCount = 0; // Key count
	var $RowAction = ""; // Row action
	var $RowOldKey = ""; // Row old key (for copy)
	var $RecPerRow = 0;
	var $MultiColumnClass;
	var $MultiColumnEditClass = "col-sm-12";
	var $MultiColumnCnt = 12;
	var $MultiColumnEditCnt = 12;
	var $GridCnt = 0;
	var $ColCnt = 0;
	var $DbMasterFilter = ""; // Master filter
	var $DbDetailFilter = ""; // Detail filter
	var $MasterRecordExists;
	var $MultiSelectKey;
	var $Command;
	var $RestoreSearch = FALSE;
	var $DetailPages;
	var $Recordset;
	var $OldRecordset;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError, $gsSearchError, $Security, $EW_EXPORT;

		// Search filters
		$sSrchAdvanced = ""; // Advanced search filter
		$sSrchBasic = ""; // Basic search filter
		$sFilter = "";

		// Get command
		$this->Command = strtolower(@$_GET["cmd"]);
		if ($this->IsPageRequest()) { // Validate request

			// Process list action first
			if ($this->ProcessListAction()) // Ajax request
				$this->Page_Terminate();

			// Handle reset command
			$this->ResetCmd();

			// Set up Breadcrumb
			if ($this->Export == "")
				$this->SetupBreadcrumb();

			// Hide list options
			if ($this->Export <> "") {
				$this->ListOptions->HideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->CurrentAction == "gridadd" || $this->CurrentAction == "gridedit") {
				$this->ListOptions->HideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->Export <> "" || $this->CurrentAction <> "") {
				$this->ExportOptions->HideAllOptions();
				$this->FilterOptions->HideAllOptions();
			}

			// Hide other options
			if ($this->Export <> "") {
				foreach ($this->OtherOptions as &$option)
					$option->HideAllOptions();
			}

			// Get default search criteria
			ew_AddFilter($this->DefaultSearchWhere, $this->BasicSearchWhere(TRUE));
			ew_AddFilter($this->DefaultSearchWhere, $this->AdvancedSearchWhere(TRUE));

			// Get basic search values
			$this->LoadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->LoadSearchValues(); // Get search values

			// Process filter list
			$this->ProcessFilterList();
			if (!$this->ValidateSearch())
				$this->setFailureMessage($gsSearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->Export <> "" || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->CheckSearchParms())
				$this->RestoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->SetupSortOrder();

			// Get basic search criteria
			if ($gsSearchError == "")
				$sSrchBasic = $this->BasicSearchWhere();

			// Get search criteria for advanced search
			if ($gsSearchError == "")
				$sSrchAdvanced = $this->AdvancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 100; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->LoadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->CheckSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->LoadDefault();
			if ($this->BasicSearch->Keyword != "")
				$sSrchBasic = $this->BasicSearchWhere();

			// Load advanced search from default
			if ($this->LoadAdvancedSearchDefault()) {
				$sSrchAdvanced = $this->AdvancedSearchWhere();
			}
		}

		// Build search criteria
		ew_AddFilter($this->SearchWhere, $sSrchAdvanced);
		ew_AddFilter($this->SearchWhere, $sSrchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$sFilter = "";
		if (!$Security->CanList())
			$sFilter = "(0=1)"; // Filter all records
		ew_AddFilter($sFilter, $this->DbDetailFilter);
		ew_AddFilter($sFilter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSQL = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $sFilter;
		} else {
			$this->setSessionWhere($sFilter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if ($this->CustomExport == "" && in_array($this->Export, array_keys($EW_EXPORT))) {
			$this->ExportData();
			$this->Page_Terminate(); // Terminate response
			exit();
		}

		// Load record count first
		if (!$this->IsAddOrEdit()) {
			$bSelectLimit = $this->UseSelectLimit;
			if ($bSelectLimit) {
				$this->TotalRecs = $this->ListRecordCount();
			} else {
				if ($this->Recordset = $this->LoadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
		}

		// Search options
		$this->SetupSearchOptions();
	}

	// Build filter for all keys
	function BuildKeyFilter() {
		global $objForm;
		$sWrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$objForm->Index = $rowindex;
		$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		while ($sThisKey <> "") {
			if ($this->SetupKeyValues($sThisKey)) {
				$sFilter = $this->KeyFilter();
				if ($sWrkFilter <> "") $sWrkFilter .= " OR ";
				$sWrkFilter .= $sFilter;
			} else {
				$sWrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$objForm->Index = $rowindex;
			$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		}
		return $sWrkFilter;
	}

	// Set up key values
	function SetupKeyValues($key) {
		$arrKeyFlds = explode($GLOBALS["EW_COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arrKeyFlds) >= 1) {
			$this->kh_id->setFormValue($arrKeyFlds[0]);
			if (!is_numeric($this->kh_id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	function GetFilterList() {
		global $UserProfile;

		// Initialize
		$sFilterList = "";
		$sSavedFilterList = "";
		$sFilterList = ew_Concat($sFilterList, $this->kh_id->AdvancedSearch->ToJson(), ","); // Field kh_id
		$sFilterList = ew_Concat($sFilterList, $this->kh_tgl->AdvancedSearch->ToJson(), ","); // Field kh_tgl
		$sFilterList = ew_Concat($sFilterList, $this->kh_co_id->AdvancedSearch->ToJson(), ","); // Field kh_co_id
		$sFilterList = ew_Concat($sFilterList, $this->kh_rencana->AdvancedSearch->ToJson(), ","); // Field kh_rencana
		$sFilterList = ew_Concat($sFilterList, $this->kh_realisasi->AdvancedSearch->ToJson(), ","); // Field kh_realisasi
		$sFilterList = ew_Concat($sFilterList, $this->kh_hasil->AdvancedSearch->ToJson(), ","); // Field kh_hasil
		$sFilterList = ew_Concat($sFilterList, $this->kh_foto->AdvancedSearch->ToJson(), ","); // Field kh_foto
		if ($this->BasicSearch->Keyword <> "") {
			$sWrk = "\"" . EW_TABLE_BASIC_SEARCH . "\":\"" . ew_JsEncode2($this->BasicSearch->Keyword) . "\",\"" . EW_TABLE_BASIC_SEARCH_TYPE . "\":\"" . ew_JsEncode2($this->BasicSearch->Type) . "\"";
			$sFilterList = ew_Concat($sFilterList, $sWrk, ",");
		}
		$sFilterList = preg_replace('/,$/', "", $sFilterList);

		// Return filter list in json
		if ($sFilterList <> "")
			$sFilterList = "\"data\":{" . $sFilterList . "}";
		if ($sSavedFilterList <> "") {
			if ($sFilterList <> "")
				$sFilterList .= ",";
			$sFilterList .= "\"filters\":" . $sSavedFilterList;
		}
		return ($sFilterList <> "") ? "{" . $sFilterList . "}" : "null";
	}

	// Process filter list
	function ProcessFilterList() {
		global $UserProfile;
		if (@$_POST["ajax"] == "savefilters") { // Save filter request (Ajax)
			$filters = @$_POST["filters"];
			$UserProfile->SetSearchFilters(CurrentUserName(), "fkegiatan_harianlistsrch", $filters);

			// Clean output buffer
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			echo ew_ArrayToJson(array(array("success" => TRUE))); // Success
			$this->Page_Terminate();
			exit();
		} elseif (@$_POST["cmd"] == "resetfilter") {
			$this->RestoreFilterList();
		}
	}

	// Restore list of filters
	function RestoreFilterList() {

		// Return if not reset filter
		if (@$_POST["cmd"] <> "resetfilter")
			return FALSE;
		$filter = json_decode(@$_POST["filter"], TRUE);
		$this->Command = "search";

		// Field kh_id
		$this->kh_id->AdvancedSearch->SearchValue = @$filter["x_kh_id"];
		$this->kh_id->AdvancedSearch->SearchOperator = @$filter["z_kh_id"];
		$this->kh_id->AdvancedSearch->SearchCondition = @$filter["v_kh_id"];
		$this->kh_id->AdvancedSearch->SearchValue2 = @$filter["y_kh_id"];
		$this->kh_id->AdvancedSearch->SearchOperator2 = @$filter["w_kh_id"];
		$this->kh_id->AdvancedSearch->Save();

		// Field kh_tgl
		$this->kh_tgl->AdvancedSearch->SearchValue = @$filter["x_kh_tgl"];
		$this->kh_tgl->AdvancedSearch->SearchOperator = @$filter["z_kh_tgl"];
		$this->kh_tgl->AdvancedSearch->SearchCondition = @$filter["v_kh_tgl"];
		$this->kh_tgl->AdvancedSearch->SearchValue2 = @$filter["y_kh_tgl"];
		$this->kh_tgl->AdvancedSearch->SearchOperator2 = @$filter["w_kh_tgl"];
		$this->kh_tgl->AdvancedSearch->Save();

		// Field kh_co_id
		$this->kh_co_id->AdvancedSearch->SearchValue = @$filter["x_kh_co_id"];
		$this->kh_co_id->AdvancedSearch->SearchOperator = @$filter["z_kh_co_id"];
		$this->kh_co_id->AdvancedSearch->SearchCondition = @$filter["v_kh_co_id"];
		$this->kh_co_id->AdvancedSearch->SearchValue2 = @$filter["y_kh_co_id"];
		$this->kh_co_id->AdvancedSearch->SearchOperator2 = @$filter["w_kh_co_id"];
		$this->kh_co_id->AdvancedSearch->Save();

		// Field kh_rencana
		$this->kh_rencana->AdvancedSearch->SearchValue = @$filter["x_kh_rencana"];
		$this->kh_rencana->AdvancedSearch->SearchOperator = @$filter["z_kh_rencana"];
		$this->kh_rencana->AdvancedSearch->SearchCondition = @$filter["v_kh_rencana"];
		$this->kh_rencana->AdvancedSearch->SearchValue2 = @$filter["y_kh_rencana"];
		$this->kh_rencana->AdvancedSearch->SearchOperator2 = @$filter["w_kh_rencana"];
		$this->kh_rencana->AdvancedSearch->Save();

		// Field kh_realisasi
		$this->kh_realisasi->AdvancedSearch->SearchValue = @$filter["x_kh_realisasi"];
		$this->kh_realisasi->AdvancedSearch->SearchOperator = @$filter["z_kh_realisasi"];
		$this->kh_realisasi->AdvancedSearch->SearchCondition = @$filter["v_kh_realisasi"];
		$this->kh_realisasi->AdvancedSearch->SearchValue2 = @$filter["y_kh_realisasi"];
		$this->kh_realisasi->AdvancedSearch->SearchOperator2 = @$filter["w_kh_realisasi"];
		$this->kh_realisasi->AdvancedSearch->Save();

		// Field kh_hasil
		$this->kh_hasil->AdvancedSearch->SearchValue = @$filter["x_kh_hasil"];
		$this->kh_hasil->AdvancedSearch->SearchOperator = @$filter["z_kh_hasil"];
		$this->kh_hasil->AdvancedSearch->SearchCondition = @$filter["v_kh_hasil"];
		$this->kh_hasil->AdvancedSearch->SearchValue2 = @$filter["y_kh_hasil"];
		$this->kh_hasil->AdvancedSearch->SearchOperator2 = @$filter["w_kh_hasil"];
		$this->kh_hasil->AdvancedSearch->Save();

		// Field kh_foto
		$this->kh_foto->AdvancedSearch->SearchValue = @$filter["x_kh_foto"];
		$this->kh_foto->AdvancedSearch->SearchOperator = @$filter["z_kh_foto"];
		$this->kh_foto->AdvancedSearch->SearchCondition = @$filter["v_kh_foto"];
		$this->kh_foto->AdvancedSearch->SearchValue2 = @$filter["y_kh_foto"];
		$this->kh_foto->AdvancedSearch->SearchOperator2 = @$filter["w_kh_foto"];
		$this->kh_foto->AdvancedSearch->Save();
		$this->BasicSearch->setKeyword(@$filter[EW_TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[EW_TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	function AdvancedSearchWhere($Default = FALSE) {
		global $Security;
		$sWhere = "";
		if (!$Security->CanSearch()) return "";
		$this->BuildSearchSql($sWhere, $this->kh_id, $Default, FALSE); // kh_id
		$this->BuildSearchSql($sWhere, $this->kh_tgl, $Default, FALSE); // kh_tgl
		$this->BuildSearchSql($sWhere, $this->kh_co_id, $Default, FALSE); // kh_co_id
		$this->BuildSearchSql($sWhere, $this->kh_rencana, $Default, FALSE); // kh_rencana
		$this->BuildSearchSql($sWhere, $this->kh_realisasi, $Default, FALSE); // kh_realisasi
		$this->BuildSearchSql($sWhere, $this->kh_hasil, $Default, FALSE); // kh_hasil
		$this->BuildSearchSql($sWhere, $this->kh_foto, $Default, FALSE); // kh_foto

		// Set up search parm
		if (!$Default && $sWhere <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$Default && $this->Command == "search") {
			$this->kh_id->AdvancedSearch->Save(); // kh_id
			$this->kh_tgl->AdvancedSearch->Save(); // kh_tgl
			$this->kh_co_id->AdvancedSearch->Save(); // kh_co_id
			$this->kh_rencana->AdvancedSearch->Save(); // kh_rencana
			$this->kh_realisasi->AdvancedSearch->Save(); // kh_realisasi
			$this->kh_hasil->AdvancedSearch->Save(); // kh_hasil
			$this->kh_foto->AdvancedSearch->Save(); // kh_foto
		}
		return $sWhere;
	}

	// Build search SQL
	function BuildSearchSql(&$Where, &$Fld, $Default, $MultiValue) {
		$FldParm = $Fld->FldParm();
		$FldVal = ($Default) ? $Fld->AdvancedSearch->SearchValueDefault : $Fld->AdvancedSearch->SearchValue; // @$_GET["x_$FldParm"]
		$FldOpr = ($Default) ? $Fld->AdvancedSearch->SearchOperatorDefault : $Fld->AdvancedSearch->SearchOperator; // @$_GET["z_$FldParm"]
		$FldCond = ($Default) ? $Fld->AdvancedSearch->SearchConditionDefault : $Fld->AdvancedSearch->SearchCondition; // @$_GET["v_$FldParm"]
		$FldVal2 = ($Default) ? $Fld->AdvancedSearch->SearchValue2Default : $Fld->AdvancedSearch->SearchValue2; // @$_GET["y_$FldParm"]
		$FldOpr2 = ($Default) ? $Fld->AdvancedSearch->SearchOperator2Default : $Fld->AdvancedSearch->SearchOperator2; // @$_GET["w_$FldParm"]
		$sWrk = "";
		if (is_array($FldVal)) $FldVal = implode(",", $FldVal);
		if (is_array($FldVal2)) $FldVal2 = implode(",", $FldVal2);
		$FldOpr = strtoupper(trim($FldOpr));
		if ($FldOpr == "") $FldOpr = "=";
		$FldOpr2 = strtoupper(trim($FldOpr2));
		if ($FldOpr2 == "") $FldOpr2 = "=";
		if (EW_SEARCH_MULTI_VALUE_OPTION == 1)
			$MultiValue = FALSE;
		if ($MultiValue) {
			$sWrk1 = ($FldVal <> "") ? ew_GetMultiSearchSql($Fld, $FldOpr, $FldVal, $this->DBID) : ""; // Field value 1
			$sWrk2 = ($FldVal2 <> "") ? ew_GetMultiSearchSql($Fld, $FldOpr2, $FldVal2, $this->DBID) : ""; // Field value 2
			$sWrk = $sWrk1; // Build final SQL
			if ($sWrk2 <> "")
				$sWrk = ($sWrk <> "") ? "($sWrk) $FldCond ($sWrk2)" : $sWrk2;
		} else {
			$FldVal = $this->ConvertSearchValue($Fld, $FldVal);
			$FldVal2 = $this->ConvertSearchValue($Fld, $FldVal2);
			$sWrk = ew_GetSearchSql($Fld, $FldVal, $FldOpr, $FldCond, $FldVal2, $FldOpr2, $this->DBID);
		}
		ew_AddFilter($Where, $sWrk);
	}

	// Convert search value
	function ConvertSearchValue(&$Fld, $FldVal) {
		if ($FldVal == EW_NULL_VALUE || $FldVal == EW_NOT_NULL_VALUE)
			return $FldVal;
		$Value = $FldVal;
		if ($Fld->FldDataType == EW_DATATYPE_BOOLEAN) {
			if ($FldVal <> "") $Value = ($FldVal == "1" || strtolower(strval($FldVal)) == "y" || strtolower(strval($FldVal)) == "t") ? $Fld->TrueValue : $Fld->FalseValue;
		} elseif ($Fld->FldDataType == EW_DATATYPE_DATE || $Fld->FldDataType == EW_DATATYPE_TIME) {
			if ($FldVal <> "") $Value = ew_UnFormatDateTime($FldVal, $Fld->FldDateTimeFormat);
		}
		return $Value;
	}

	// Return basic search SQL
	function BasicSearchSQL($arKeywords, $type) {
		$sWhere = "";
		$this->BuildBasicSearchSQL($sWhere, $this->kh_rencana, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->kh_realisasi, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->kh_hasil, $arKeywords, $type);
		return $sWhere;
	}

	// Build basic search SQL
	function BuildBasicSearchSQL(&$Where, &$Fld, $arKeywords, $type) {
		global $EW_BASIC_SEARCH_IGNORE_PATTERN;
		$sDefCond = ($type == "OR") ? "OR" : "AND";
		$arSQL = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$Keyword = $arKeywords[$i];
			$Keyword = trim($Keyword);
			if ($EW_BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$Keyword = preg_replace($EW_BASIC_SEARCH_IGNORE_PATTERN, "\\", $Keyword);
				$ar = explode("\\", $Keyword);
			} else {
				$ar = array($Keyword);
			}
			foreach ($ar as $Keyword) {
				if ($Keyword <> "") {
					$sWrk = "";
					if ($Keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j-1] = "OR";
					} elseif ($Keyword == EW_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NULL";
					} elseif ($Keyword == EW_NOT_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NOT NULL";
					} elseif ($Fld->FldIsVirtual) {
						$sWrk = $Fld->FldVirtualExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					} elseif ($Fld->FldDataType != EW_DATATYPE_NUMBER || is_numeric($Keyword)) {
						$sWrk = $Fld->FldBasicSearchExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					}
					if ($sWrk <> "") {
						$arSQL[$j] = $sWrk;
						$arCond[$j] = $sDefCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSQL);
		$bQuoted = FALSE;
		$sSql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt-1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$bQuoted) $sSql .= "(";
					$bQuoted = TRUE;
				}
				$sSql .= $arSQL[$i];
				if ($bQuoted && $arCond[$i] <> "OR") {
					$sSql .= ")";
					$bQuoted = FALSE;
				}
				$sSql .= " " . $arCond[$i] . " ";
			}
			$sSql .= $arSQL[$cnt-1];
			if ($bQuoted)
				$sSql .= ")";
		}
		if ($sSql <> "") {
			if ($Where <> "") $Where .= " OR ";
			$Where .= "(" . $sSql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	function BasicSearchWhere($Default = FALSE) {
		global $Security;
		$sSearchStr = "";
		if (!$Security->CanSearch()) return "";
		$sSearchKeyword = ($Default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$sSearchType = ($Default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($sSearchKeyword <> "") {
			$ar = $this->BasicSearch->KeywordList($Default);

			// Search keyword in any fields
			if (($sSearchType == "OR" || $sSearchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $sKeyword) {
					if ($sKeyword <> "") {
						if ($sSearchStr <> "") $sSearchStr .= " " . $sSearchType . " ";
						$sSearchStr .= "(" . $this->BasicSearchSQL(array($sKeyword), $sSearchType) . ")";
					}
				}
			} else {
				$sSearchStr = $this->BasicSearchSQL($ar, $sSearchType);
			}
			if (!$Default && in_array($this->Command, array("", "reset", "resetall"))) $this->Command = "search";
		}
		if (!$Default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($sSearchKeyword);
			$this->BasicSearch->setType($sSearchType);
		}
		return $sSearchStr;
	}

	// Check if search parm exists
	function CheckSearchParms() {

		// Check basic search
		if ($this->BasicSearch->IssetSession())
			return TRUE;
		if ($this->kh_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->kh_tgl->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->kh_co_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->kh_rencana->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->kh_realisasi->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->kh_hasil->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->kh_foto->AdvancedSearch->IssetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	function ResetSearchParms() {

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->ResetBasicSearchParms();

		// Clear advanced search parameters
		$this->ResetAdvancedSearchParms();
	}

	// Load advanced search default values
	function LoadAdvancedSearchDefault() {
		return FALSE;
	}

	// Clear all basic search parameters
	function ResetBasicSearchParms() {
		$this->BasicSearch->UnsetSession();
	}

	// Clear all advanced search parameters
	function ResetAdvancedSearchParms() {
		$this->kh_id->AdvancedSearch->UnsetSession();
		$this->kh_tgl->AdvancedSearch->UnsetSession();
		$this->kh_co_id->AdvancedSearch->UnsetSession();
		$this->kh_rencana->AdvancedSearch->UnsetSession();
		$this->kh_realisasi->AdvancedSearch->UnsetSession();
		$this->kh_hasil->AdvancedSearch->UnsetSession();
		$this->kh_foto->AdvancedSearch->UnsetSession();
	}

	// Restore all search parameters
	function RestoreSearchParms() {
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->Load();

		// Restore advanced search values
		$this->kh_id->AdvancedSearch->Load();
		$this->kh_tgl->AdvancedSearch->Load();
		$this->kh_co_id->AdvancedSearch->Load();
		$this->kh_rencana->AdvancedSearch->Load();
		$this->kh_realisasi->AdvancedSearch->Load();
		$this->kh_hasil->AdvancedSearch->Load();
		$this->kh_foto->AdvancedSearch->Load();
	}

	// Set up sort parameters
	function SetupSortOrder() {

		// Check for "order" parameter
		if (@$_GET["order"] <> "") {
			$this->CurrentOrder = @$_GET["order"];
			$this->CurrentOrderType = @$_GET["ordertype"];
			$this->UpdateSort($this->kh_id); // kh_id
			$this->UpdateSort($this->kh_tgl); // kh_tgl
			$this->UpdateSort($this->kh_co_id); // kh_co_id
			$this->UpdateSort($this->kh_rencana); // kh_rencana
			$this->UpdateSort($this->kh_realisasi); // kh_realisasi
			$this->UpdateSort($this->kh_hasil); // kh_hasil
			$this->UpdateSort($this->kh_foto); // kh_foto
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	function LoadSortOrder() {
		$sOrderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($sOrderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$sOrderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($sOrderBy);
				$this->kh_id->setSort("DESC");
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)
	function ResetCmd() {

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->ResetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$sOrderBy = "";
				$this->setSessionOrderBy($sOrderBy);
				$this->kh_id->setSort("");
				$this->kh_tgl->setSort("");
				$this->kh_co_id->setSort("");
				$this->kh_rencana->setSort("");
				$this->kh_realisasi->setSort("");
				$this->kh_hasil->setSort("");
				$this->kh_foto->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	function SetupListOptions() {
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->Add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->Add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->CanView();
		$item->OnLeft = TRUE;

		// "edit"
		$item = &$this->ListOptions->Add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->CanEdit();
		$item->OnLeft = TRUE;

		// "copy"
		$item = &$this->ListOptions->Add("copy");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->CanAdd();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->Add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->Add("checkbox");
		$item->Visible = $Security->CanDelete();
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew_SelectAllKey(this);\">";
		$item->MoveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseImageAndText = TRUE;
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->Phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		if ($this->ListOptions->UseButtonGroup && ew_IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;
		$this->ListOptions->ButtonClass = "btn-sm"; // Class for button group

		// Call ListOptions_Load event
		$this->ListOptions_Load();
		$this->SetupListOptionsExt();
		$item = &$this->ListOptions->GetItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->GroupOptionVisible();
	}

	// Render list options
	function RenderListOptions() {
		global $Security, $Language, $objForm;
		$this->ListOptions->LoadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$oListOpt = &$this->ListOptions->Items["view"];
		$viewcaption = ew_HtmlTitle($Language->Phrase("ViewLink"));
		if ($Security->CanView()) {
			$oListOpt->Body = "<a class=\"ewRowLink ewView\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . ew_HtmlEncode($this->ViewUrl) . "\">" . $Language->Phrase("ViewLink") . "</a>";
		} else {
			$oListOpt->Body = "";
		}

		// "edit"
		$oListOpt = &$this->ListOptions->Items["edit"];
		$editcaption = ew_HtmlTitle($Language->Phrase("EditLink"));
		if ($Security->CanEdit()) {
			$oListOpt->Body = "<a class=\"ewRowLink ewEdit\" title=\"" . ew_HtmlTitle($Language->Phrase("EditLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("EditLink")) . "\" href=\"" . ew_HtmlEncode($this->EditUrl) . "\">" . $Language->Phrase("EditLink") . "</a>";
		} else {
			$oListOpt->Body = "";
		}

		// "copy"
		$oListOpt = &$this->ListOptions->Items["copy"];
		$copycaption = ew_HtmlTitle($Language->Phrase("CopyLink"));
		if ($Security->CanAdd()) {
			$oListOpt->Body = "<a class=\"ewRowLink ewCopy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . ew_HtmlEncode($this->CopyUrl) . "\">" . $Language->Phrase("CopyLink") . "</a>";
		} else {
			$oListOpt->Body = "";
		}

		// Set up list action buttons
		$oListOpt = &$this->ListOptions->GetItem("listactions");
		if ($oListOpt && $this->Export == "" && $this->CurrentAction == "") {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode(str_replace(" ewIcon", "", $listaction->Icon)) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\"></span> " : "";
					$links[] = "<li><a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" title=\"" . ew_HtmlTitle($caption) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $Language->Phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default btn-sm ewActions\" title=\"" . ew_HtmlTitle($Language->Phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->Phrase("ListActionButton") . "<b class=\"caret\"></b></button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($oListOpt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$oListOpt->Body = $body;
				$oListOpt->Visible = TRUE;
			}
		}

		// "checkbox"
		$oListOpt = &$this->ListOptions->Items["checkbox"];
		$oListOpt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ewMultiSelect\" value=\"" . ew_HtmlEncode($this->kh_id->CurrentValue) . "\" onclick=\"ew_ClickMultiCheckbox(event);\">";
		$this->RenderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	function SetupOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->Add("add");
		$addcaption = ew_HtmlTitle($Language->Phrase("AddLink"));
		$item->Body = "<a class=\"ewAddEdit ewAdd\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . ew_HtmlEncode($this->AddUrl) . "\">" . $Language->Phrase("AddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->CanAdd());
		$option = $options["action"];

		// Add multi delete
		$item = &$option->Add("multidelete");
		$item->Body = "<a class=\"ewAction ewMultiDelete\" title=\"" . ew_HtmlTitle($Language->Phrase("DeleteSelectedLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("DeleteSelectedLink")) . "\" href=\"\" onclick=\"ew_SubmitAction(event,{f:document.fkegiatan_harianlist,url:'" . $this->MultiDeleteUrl . "'});return false;\">" . $Language->Phrase("DeleteSelectedLink") . "</a>";
		$item->Visible = ($Security->CanDelete());

		// Set up options default
		foreach ($options as &$option) {
			$option->UseImageAndText = TRUE;
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;
			$option->ButtonClass = "btn-sm"; // Class for button group
			$item = &$option->Add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->Phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->Phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->Phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->Add("savecurrentfilter");
		$item->Body = "<a class=\"ewSaveFilter\" data-form=\"fkegiatan_harianlistsrch\" href=\"#\">" . $Language->Phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->Add("deletefilter");
		$item->Body = "<a class=\"ewDeleteFilter\" data-form=\"fkegiatan_harianlistsrch\" href=\"#\">" . $Language->Phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->Phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->Add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	function RenderOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_MULTIPLE) {
					$item = &$option->Add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode($listaction->Icon) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\"></span> " : $caption;
					$item->Body = "<a class=\"ewAction ewListAction\" title=\"" . ew_HtmlEncode($caption) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({f:document.fkegiatan_harianlist}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->GetItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->HideAllOptions();
			}
	}

	// Process list action
	function ProcessListAction() {
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$sFilter = $this->GetKeyFilter();
		$UserAction = @$_POST["useraction"];
		if ($sFilter <> "" && $UserAction <> "") {

			// Check permission first
			$ActionCaption = $UserAction;
			if (array_key_exists($UserAction, $this->ListActions->Items)) {
				$ActionCaption = $this->ListActions->Items[$UserAction]->Caption;
				if (!$this->ListActions->Items[$UserAction]->Allow) {
					$errmsg = str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionNotAllowed"));
					if (@$_POST["ajax"] == $UserAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $sFilter;
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			$rs = $conn->Execute($sSql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $UserAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->BeginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$Processed = $this->Row_CustomAction($UserAction, $row);
					if (!$Processed) break;
					$rs->MoveNext();
				}
				if ($Processed) {
					$conn->CommitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->RollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->Close();
			$this->CurrentAction = ""; // Clear action
			if (@$_POST["ajax"] == $UserAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->ClearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->ClearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	function SetupSearchOptions() {
		global $Language;
		$this->SearchOptions = new cListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ewSearchOption";

		// Search button
		$item = &$this->SearchOptions->Add("searchtoggle");
		$SearchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ewSearchToggle" . $SearchToggleClass . "\" title=\"" . $Language->Phrase("SearchPanel") . "\" data-caption=\"" . $Language->Phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fkegiatan_harianlistsrch\">" . $Language->Phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->Add("showall");
		$item->Body = "<a class=\"btn btn-default ewShowAll\" title=\"" . $Language->Phrase("ShowAll") . "\" data-caption=\"" . $Language->Phrase("ShowAll") . "\" href=\"" . $this->PageUrl() . "cmd=reset\">" . $Language->Phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseImageAndText = TRUE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->Phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->Add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->Export <> "" || $this->CurrentAction <> "")
			$this->SearchOptions->HideAllOptions();
		global $Security;
		if (!$Security->CanSearch()) {
			$this->SearchOptions->HideAllOptions();
			$this->FilterOptions->HideAllOptions();
		}
	}

	function SetupListOptionsExt() {
		global $Security, $Language;
	}

	function RenderListOptionsExt() {
		global $Security, $Language;
	}

	// Set up starting record parameters
	function SetupStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	function LoadBasicSearchValues() {
		$this->BasicSearch->Keyword = @$_GET[EW_TABLE_BASIC_SEARCH];
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "") $this->Command = "search";
		$this->BasicSearch->Type = @$_GET[EW_TABLE_BASIC_SEARCH_TYPE];
	}

	// Load search values for validation
	function LoadSearchValues() {
		global $objForm;

		// Load search values
		// kh_id

		$this->kh_id->AdvancedSearch->SearchValue = @$_GET["x_kh_id"];
		if ($this->kh_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->kh_id->AdvancedSearch->SearchOperator = @$_GET["z_kh_id"];

		// kh_tgl
		$this->kh_tgl->AdvancedSearch->SearchValue = @$_GET["x_kh_tgl"];
		if ($this->kh_tgl->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->kh_tgl->AdvancedSearch->SearchOperator = @$_GET["z_kh_tgl"];
		$this->kh_tgl->AdvancedSearch->SearchCondition = @$_GET["v_kh_tgl"];
		$this->kh_tgl->AdvancedSearch->SearchValue2 = @$_GET["y_kh_tgl"];
		if ($this->kh_tgl->AdvancedSearch->SearchValue2 <> "" && $this->Command == "") $this->Command = "search";
		$this->kh_tgl->AdvancedSearch->SearchOperator2 = @$_GET["w_kh_tgl"];

		// kh_co_id
		$this->kh_co_id->AdvancedSearch->SearchValue = @$_GET["x_kh_co_id"];
		if ($this->kh_co_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->kh_co_id->AdvancedSearch->SearchOperator = @$_GET["z_kh_co_id"];

		// kh_rencana
		$this->kh_rencana->AdvancedSearch->SearchValue = @$_GET["x_kh_rencana"];
		if ($this->kh_rencana->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->kh_rencana->AdvancedSearch->SearchOperator = @$_GET["z_kh_rencana"];

		// kh_realisasi
		$this->kh_realisasi->AdvancedSearch->SearchValue = @$_GET["x_kh_realisasi"];
		if ($this->kh_realisasi->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->kh_realisasi->AdvancedSearch->SearchOperator = @$_GET["z_kh_realisasi"];

		// kh_hasil
		$this->kh_hasil->AdvancedSearch->SearchValue = @$_GET["x_kh_hasil"];
		if ($this->kh_hasil->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->kh_hasil->AdvancedSearch->SearchOperator = @$_GET["z_kh_hasil"];

		// kh_foto
		$this->kh_foto->AdvancedSearch->SearchValue = @$_GET["x_kh_foto"];
		if ($this->kh_foto->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->kh_foto->AdvancedSearch->SearchOperator = @$_GET["z_kh_foto"];
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {

		// Load List page SQL
		$sSql = $this->ListSQL();
		$conn = &$this->Connection();

		// Load recordset
		$dbtype = ew_GetConnectionType($this->DBID);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset, array("_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())));
			} else {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = ew_LoadRecordset($sSql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues($rs = NULL) {
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->NewRow(); 

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->kh_id->setDbValue($row['kh_id']);
		$this->kh_tgl->setDbValue($row['kh_tgl']);
		$this->kh_co_id->setDbValue($row['kh_co_id']);
		$this->kh_rencana->setDbValue($row['kh_rencana']);
		$this->kh_realisasi->setDbValue($row['kh_realisasi']);
		$this->kh_hasil->setDbValue($row['kh_hasil']);
		$this->kh_foto->Upload->DbValue = $row['kh_foto'];
		$this->kh_foto->setDbValue($this->kh_foto->Upload->DbValue);
	}

	// Return a row with default values
	function NewRow() {
		$row = array();
		$row['kh_id'] = NULL;
		$row['kh_tgl'] = NULL;
		$row['kh_co_id'] = NULL;
		$row['kh_rencana'] = NULL;
		$row['kh_realisasi'] = NULL;
		$row['kh_hasil'] = NULL;
		$row['kh_foto'] = NULL;
		return $row;
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->kh_id->DbValue = $row['kh_id'];
		$this->kh_tgl->DbValue = $row['kh_tgl'];
		$this->kh_co_id->DbValue = $row['kh_co_id'];
		$this->kh_rencana->DbValue = $row['kh_rencana'];
		$this->kh_realisasi->DbValue = $row['kh_realisasi'];
		$this->kh_hasil->DbValue = $row['kh_hasil'];
		$this->kh_foto->Upload->DbValue = $row['kh_foto'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("kh_id")) <> "")
			$this->kh_id->CurrentValue = $this->getKey("kh_id"); // kh_id
		else
			$bValidKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
		}
		$this->LoadRowValues($this->OldRecordset); // Load row values
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->GetViewUrl();
		$this->EditUrl = $this->GetEditUrl();
		$this->InlineEditUrl = $this->GetInlineEditUrl();
		$this->CopyUrl = $this->GetCopyUrl();
		$this->InlineCopyUrl = $this->GetInlineCopyUrl();
		$this->DeleteUrl = $this->GetDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// kh_id
		// kh_tgl
		// kh_co_id
		// kh_rencana
		// kh_realisasi
		// kh_hasil
		// kh_foto

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// kh_id
		$this->kh_id->ViewValue = $this->kh_id->CurrentValue;
		$this->kh_id->ViewCustomAttributes = "";

		// kh_tgl
		$this->kh_tgl->ViewValue = $this->kh_tgl->CurrentValue;
		$this->kh_tgl->ViewValue = ew_FormatDateTime($this->kh_tgl->ViewValue, 0);
		$this->kh_tgl->ViewCustomAttributes = "";

		// kh_co_id
		if (strval($this->kh_co_id->CurrentValue) <> "") {
			$sFilterWrk = "`co_id`" . ew_SearchString("=", $this->kh_co_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `co_id`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `co`";
		$sWhereWrk = "";
		$this->kh_co_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->kh_co_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->kh_co_id->ViewValue = $this->kh_co_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->kh_co_id->ViewValue = $this->kh_co_id->CurrentValue;
			}
		} else {
			$this->kh_co_id->ViewValue = NULL;
		}
		$this->kh_co_id->ViewCustomAttributes = "";

		// kh_rencana
		$this->kh_rencana->ViewValue = $this->kh_rencana->CurrentValue;
		$this->kh_rencana->ViewCustomAttributes = "";

		// kh_realisasi
		$this->kh_realisasi->ViewValue = $this->kh_realisasi->CurrentValue;
		$this->kh_realisasi->ViewCustomAttributes = "";

		// kh_hasil
		$this->kh_hasil->ViewValue = $this->kh_hasil->CurrentValue;
		$this->kh_hasil->ViewCustomAttributes = "";

		// kh_foto
		$this->kh_foto->UploadPath = "kegiatan_foto";
		if (!ew_Empty($this->kh_foto->Upload->DbValue)) {
			$this->kh_foto->ImageWidth = 80;
			$this->kh_foto->ImageHeight = 60;
			$this->kh_foto->ImageAlt = $this->kh_foto->FldAlt();
			$this->kh_foto->ViewValue = $this->kh_foto->Upload->DbValue;
		} else {
			$this->kh_foto->ViewValue = "";
		}
		$this->kh_foto->CellCssStyle .= "text-align: center;";
		$this->kh_foto->ViewCustomAttributes = "";

			// kh_id
			$this->kh_id->LinkCustomAttributes = "";
			$this->kh_id->HrefValue = "";
			$this->kh_id->TooltipValue = "";

			// kh_tgl
			$this->kh_tgl->LinkCustomAttributes = "";
			$this->kh_tgl->HrefValue = "";
			$this->kh_tgl->TooltipValue = "";

			// kh_co_id
			$this->kh_co_id->LinkCustomAttributes = "";
			$this->kh_co_id->HrefValue = "";
			$this->kh_co_id->TooltipValue = "";

			// kh_rencana
			$this->kh_rencana->LinkCustomAttributes = "";
			$this->kh_rencana->HrefValue = "";
			$this->kh_rencana->TooltipValue = "";

			// kh_realisasi
			$this->kh_realisasi->LinkCustomAttributes = "";
			$this->kh_realisasi->HrefValue = "";
			$this->kh_realisasi->TooltipValue = "";

			// kh_hasil
			$this->kh_hasil->LinkCustomAttributes = "";
			$this->kh_hasil->HrefValue = "";
			$this->kh_hasil->TooltipValue = "";

			// kh_foto
			$this->kh_foto->LinkCustomAttributes = "";
			$this->kh_foto->UploadPath = "kegiatan_foto";
			if (!ew_Empty($this->kh_foto->Upload->DbValue)) {
				$this->kh_foto->HrefValue = "%u"; // Add prefix/suffix
				$this->kh_foto->LinkAttrs["target"] = ""; // Add target
				if ($this->Export <> "") $this->kh_foto->HrefValue = ew_FullUrl($this->kh_foto->HrefValue, "href");
			} else {
				$this->kh_foto->HrefValue = "";
			}
			$this->kh_foto->HrefValue2 = $this->kh_foto->UploadPath . $this->kh_foto->Upload->DbValue;
			$this->kh_foto->TooltipValue = "";
			if ($this->kh_foto->UseColorbox) {
				if (ew_Empty($this->kh_foto->TooltipValue))
					$this->kh_foto->LinkAttrs["title"] = $Language->Phrase("ViewImageGallery");
				$this->kh_foto->LinkAttrs["data-rel"] = "kegiatan_harian_x" . $this->RowCnt . "_kh_foto";
				ew_AppendClass($this->kh_foto->LinkAttrs["class"], "ewLightbox");
			}
		} elseif ($this->RowType == EW_ROWTYPE_SEARCH) { // Search row

			// kh_id
			$this->kh_id->EditAttrs["class"] = "form-control";
			$this->kh_id->EditCustomAttributes = "";
			$this->kh_id->EditValue = ew_HtmlEncode($this->kh_id->AdvancedSearch->SearchValue);
			$this->kh_id->PlaceHolder = ew_RemoveHtml($this->kh_id->FldCaption());

			// kh_tgl
			$this->kh_tgl->EditAttrs["class"] = "form-control";
			$this->kh_tgl->EditCustomAttributes = "";
			$this->kh_tgl->EditValue = ew_HtmlEncode(ew_FormatDateTime(ew_UnFormatDateTime($this->kh_tgl->AdvancedSearch->SearchValue, 0), 8));
			$this->kh_tgl->PlaceHolder = ew_RemoveHtml($this->kh_tgl->FldCaption());
			$this->kh_tgl->EditAttrs["class"] = "form-control";
			$this->kh_tgl->EditCustomAttributes = "";
			$this->kh_tgl->EditValue2 = ew_HtmlEncode(ew_FormatDateTime(ew_UnFormatDateTime($this->kh_tgl->AdvancedSearch->SearchValue2, 0), 8));
			$this->kh_tgl->PlaceHolder = ew_RemoveHtml($this->kh_tgl->FldCaption());

			// kh_co_id
			$this->kh_co_id->EditAttrs["class"] = "form-control";
			$this->kh_co_id->EditCustomAttributes = "";
			if (trim(strval($this->kh_co_id->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`co_id`" . ew_SearchString("=", $this->kh_co_id->AdvancedSearch->SearchValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `co_id`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `co`";
			$sWhereWrk = "";
			$this->kh_co_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->kh_co_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->kh_co_id->EditValue = $arwrk;

			// kh_rencana
			$this->kh_rencana->EditAttrs["class"] = "form-control";
			$this->kh_rencana->EditCustomAttributes = "";
			$this->kh_rencana->EditValue = ew_HtmlEncode($this->kh_rencana->AdvancedSearch->SearchValue);
			$this->kh_rencana->PlaceHolder = ew_RemoveHtml($this->kh_rencana->FldCaption());

			// kh_realisasi
			$this->kh_realisasi->EditAttrs["class"] = "form-control";
			$this->kh_realisasi->EditCustomAttributes = "";
			$this->kh_realisasi->EditValue = ew_HtmlEncode($this->kh_realisasi->AdvancedSearch->SearchValue);
			$this->kh_realisasi->PlaceHolder = ew_RemoveHtml($this->kh_realisasi->FldCaption());

			// kh_hasil
			$this->kh_hasil->EditAttrs["class"] = "form-control";
			$this->kh_hasil->EditCustomAttributes = "";
			$this->kh_hasil->EditValue = ew_HtmlEncode($this->kh_hasil->AdvancedSearch->SearchValue);
			$this->kh_hasil->PlaceHolder = ew_RemoveHtml($this->kh_hasil->FldCaption());

			// kh_foto
			$this->kh_foto->EditAttrs["class"] = "form-control";
			$this->kh_foto->EditCustomAttributes = "";
			$this->kh_foto->EditValue = ew_HtmlEncode($this->kh_foto->AdvancedSearch->SearchValue);
			$this->kh_foto->PlaceHolder = ew_RemoveHtml($this->kh_foto->FldCaption());
		}
		if ($this->RowType == EW_ROWTYPE_ADD || $this->RowType == EW_ROWTYPE_EDIT || $this->RowType == EW_ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->SetupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	function ValidateSearch() {
		global $gsSearchError;

		// Initialize
		$gsSearchError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return TRUE;
		if (!ew_CheckDateDef($this->kh_tgl->AdvancedSearch->SearchValue)) {
			ew_AddMessage($gsSearchError, $this->kh_tgl->FldErrMsg());
		}
		if (!ew_CheckDateDef($this->kh_tgl->AdvancedSearch->SearchValue2)) {
			ew_AddMessage($gsSearchError, $this->kh_tgl->FldErrMsg());
		}

		// Return validate result
		$ValidateSearch = ($gsSearchError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateSearch = $ValidateSearch && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsSearchError, $sFormCustomError);
		}
		return $ValidateSearch;
	}

	// Load advanced search
	function LoadAdvancedSearch() {
		$this->kh_id->AdvancedSearch->Load();
		$this->kh_tgl->AdvancedSearch->Load();
		$this->kh_co_id->AdvancedSearch->Load();
		$this->kh_rencana->AdvancedSearch->Load();
		$this->kh_realisasi->AdvancedSearch->Load();
		$this->kh_hasil->AdvancedSearch->Load();
		$this->kh_foto->AdvancedSearch->Load();
	}

	// Set up export options
	function SetupExportOptions() {
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->Add("print");
		$item->Body = "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ewExportLink ewPrint\" title=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\">" . $Language->Phrase("PrinterFriendly") . "</a>";
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->Add("excel");
		$item->Body = "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ewExportLink ewExcel\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\">" . $Language->Phrase("ExportToExcel") . "</a>";
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->Add("word");
		$item->Body = "<a href=\"" . $this->ExportWordUrl . "\" class=\"ewExportLink ewWord\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\">" . $Language->Phrase("ExportToWord") . "</a>";
		$item->Visible = TRUE;

		// Export to Html
		$item = &$this->ExportOptions->Add("html");
		$item->Body = "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ewExportLink ewHtml\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\">" . $Language->Phrase("ExportToHtml") . "</a>";
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->Add("xml");
		$item->Body = "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ewExportLink ewXml\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\">" . $Language->Phrase("ExportToXml") . "</a>";
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->Add("csv");
		$item->Body = "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ewExportLink ewCsv\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\">" . $Language->Phrase("ExportToCsv") . "</a>";
		$item->Visible = FALSE;

		// Export to Pdf
		$item = &$this->ExportOptions->Add("pdf");
		$item->Body = "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ewExportLink ewPdf\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\">" . $Language->Phrase("ExportToPDF") . "</a>";
		$item->Visible = FALSE;

		// Export to Email
		$item = &$this->ExportOptions->Add("email");
		$url = "";
		$item->Body = "<button id=\"emf_kegiatan_harian\" class=\"ewExportLink ewEmail\" title=\"" . $Language->Phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->Phrase("ExportToEmailText") . "\" onclick=\"ew_EmailDialogShow({lnk:'emf_kegiatan_harian',hdr:ewLanguage.Phrase('ExportToEmailText'),f:document.fkegiatan_harianlist,sel:false" . $url . "});\">" . $Language->Phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseImageAndText = TRUE;
		$this->ExportOptions->UseDropDownButton = FALSE;
		if ($this->ExportOptions->UseButtonGroup && ew_IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->Phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->Add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	function ExportData() {
		$utf8 = (strtolower(EW_CHARSET) == "utf-8");
		$bSelectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($bSelectLimit) {
			$this->TotalRecs = $this->ListRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->LoadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EW_EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->SetupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($bSelectLimit)
			$rs = $this->LoadRecordset($this->StartRec-1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		if (!$rs) {
			header("Content-Type:"); // Remove header
			header("Content-Disposition:");
			$this->ShowMessage();
			return;
		}
		$this->ExportDoc = ew_ExportDocument($this, "h");
		$Doc = &$this->ExportDoc;
		if ($bSelectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		} else {

			//$this->StartRec = $this->StartRec;
			//$this->StopRec = $this->StopRec;

		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$ParentTable = "";
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		$Doc->Text .= $sHeader;
		$this->ExportDocument($Doc, $rs, $this->StartRec, $this->StopRec, "");
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		$Doc->Text .= $sFooter;

		// Close recordset
		$rs->Close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$Doc->ExportHeaderAndFooter();

		// Clean output buffer
		if (!EW_DEBUG_ENABLED && ob_get_length())
			ob_end_clean();

		// Write debug message if enabled
		if (EW_DEBUG_ENABLED && $this->Export <> "pdf")
			echo ew_DebugMsg();

		// Output data
		$Doc->Export();
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->Add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup filters of a field
	function SetupLookupFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		if ($pageId == "list") {
			switch ($fld->FldVar) {
			}
		} elseif ($pageId == "extbs") {
			switch ($fld->FldVar) {
		case "x_kh_co_id":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `co_id` AS `LinkFld`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `co`";
				$sWhereWrk = "";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`co_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->kh_co_id, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
			}
		}
	}

	// Setup AutoSuggest filters of a field
	function SetupAutoSuggestFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		if ($pageId == "list") {
			switch ($fld->FldVar) {
			}
		} elseif ($pageId == "extbs") {
			switch ($fld->FldVar) {
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($kegiatan_harian_list)) $kegiatan_harian_list = new ckegiatan_harian_list();

// Page init
$kegiatan_harian_list->Page_Init();

// Page main
$kegiatan_harian_list->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$kegiatan_harian_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if ($kegiatan_harian->Export == "") { ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "list";
var CurrentForm = fkegiatan_harianlist = new ew_Form("fkegiatan_harianlist", "list");
fkegiatan_harianlist.FormKeyCountName = '<?php echo $kegiatan_harian_list->FormKeyCountName ?>';

// Form_CustomValidate event
fkegiatan_harianlist.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fkegiatan_harianlist.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fkegiatan_harianlist.Lists["x_kh_co_id"] = {"LinkField":"x_co_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_co_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"co"};
fkegiatan_harianlist.Lists["x_kh_co_id"].Data = "<?php echo $kegiatan_harian_list->kh_co_id->LookupFilterQuery(FALSE, "list") ?>";

// Form object for search
var CurrentSearchForm = fkegiatan_harianlistsrch = new ew_Form("fkegiatan_harianlistsrch");

// Validate function for search
fkegiatan_harianlistsrch.Validate = function(fobj) {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	fobj = fobj || this.Form;
	var infix = "";
	elm = this.GetElements("x" + infix + "_kh_tgl");
	if (elm && !ew_CheckDateDef(elm.value))
		return this.OnError(elm, "<?php echo ew_JsEncode2($kegiatan_harian->kh_tgl->FldErrMsg()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fkegiatan_harianlistsrch.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fkegiatan_harianlistsrch.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fkegiatan_harianlistsrch.Lists["x_kh_co_id"] = {"LinkField":"x_co_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_co_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"co"};
fkegiatan_harianlistsrch.Lists["x_kh_co_id"].Data = "<?php echo $kegiatan_harian_list->kh_co_id->LookupFilterQuery(FALSE, "extbs") ?>";

// Init search panel as collapsed
if (fkegiatan_harianlistsrch) fkegiatan_harianlistsrch.InitSearchPanel = true;
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if ($kegiatan_harian->Export == "") { ?>
<div class="ewToolbar">
<?php if ($kegiatan_harian_list->TotalRecs > 0 && $kegiatan_harian_list->ExportOptions->Visible()) { ?>
<?php $kegiatan_harian_list->ExportOptions->Render("body") ?>
<?php } ?>
<?php if ($kegiatan_harian_list->SearchOptions->Visible()) { ?>
<?php $kegiatan_harian_list->SearchOptions->Render("body") ?>
<?php } ?>
<?php if ($kegiatan_harian_list->FilterOptions->Visible()) { ?>
<?php $kegiatan_harian_list->FilterOptions->Render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
	$bSelectLimit = $kegiatan_harian_list->UseSelectLimit;
	if ($bSelectLimit) {
		if ($kegiatan_harian_list->TotalRecs <= 0)
			$kegiatan_harian_list->TotalRecs = $kegiatan_harian->ListRecordCount();
	} else {
		if (!$kegiatan_harian_list->Recordset && ($kegiatan_harian_list->Recordset = $kegiatan_harian_list->LoadRecordset()))
			$kegiatan_harian_list->TotalRecs = $kegiatan_harian_list->Recordset->RecordCount();
	}
	$kegiatan_harian_list->StartRec = 1;
	if ($kegiatan_harian_list->DisplayRecs <= 0 || ($kegiatan_harian->Export <> "" && $kegiatan_harian->ExportAll)) // Display all records
		$kegiatan_harian_list->DisplayRecs = $kegiatan_harian_list->TotalRecs;
	if (!($kegiatan_harian->Export <> "" && $kegiatan_harian->ExportAll))
		$kegiatan_harian_list->SetupStartRec(); // Set up start record position
	if ($bSelectLimit)
		$kegiatan_harian_list->Recordset = $kegiatan_harian_list->LoadRecordset($kegiatan_harian_list->StartRec-1, $kegiatan_harian_list->DisplayRecs);

	// Set no record found message
	if ($kegiatan_harian->CurrentAction == "" && $kegiatan_harian_list->TotalRecs == 0) {
		if (!$Security->CanList())
			$kegiatan_harian_list->setWarningMessage(ew_DeniedMsg());
		if ($kegiatan_harian_list->SearchWhere == "0=101")
			$kegiatan_harian_list->setWarningMessage($Language->Phrase("EnterSearchCriteria"));
		else
			$kegiatan_harian_list->setWarningMessage($Language->Phrase("NoRecord"));
	}
$kegiatan_harian_list->RenderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if ($kegiatan_harian->Export == "" && $kegiatan_harian->CurrentAction == "") { ?>
<form name="fkegiatan_harianlistsrch" id="fkegiatan_harianlistsrch" class="form-inline ewForm ewExtSearchForm" action="<?php echo ew_CurrentPage() ?>">
<?php $SearchPanelClass = ($kegiatan_harian_list->SearchWhere <> "") ? " in" : ""; ?>
<div id="fkegiatan_harianlistsrch_SearchPanel" class="ewSearchPanel collapse<?php echo $SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="kegiatan_harian">
	<div class="ewBasicSearch">
<?php
if ($gsSearchError == "")
	$kegiatan_harian_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$kegiatan_harian->RowType = EW_ROWTYPE_SEARCH;

// Render row
$kegiatan_harian->ResetAttrs();
$kegiatan_harian_list->RenderRow();
?>
<div id="xsr_1" class="ewRow">
<?php if ($kegiatan_harian->kh_tgl->Visible) { // kh_tgl ?>
	<div id="xsc_kh_tgl" class="ewCell form-group">
		<label for="x_kh_tgl" class="ewSearchCaption ewLabel"><?php echo $kegiatan_harian->kh_tgl->FldCaption() ?></label>
		<span class="ewSearchOperator"><select name="z_kh_tgl" id="z_kh_tgl" class="form-control" onchange="ewForms(this).SrchOprChanged(this);"><option value="="<?php echo ($kegiatan_harian->kh_tgl->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->Phrase("EQUAL") ?></option><option value="<>"<?php echo ($kegiatan_harian->kh_tgl->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->Phrase("<>") ?></option><option value="<"<?php echo ($kegiatan_harian->kh_tgl->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->Phrase("<") ?></option><option value="<="<?php echo ($kegiatan_harian->kh_tgl->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->Phrase("<=") ?></option><option value=">"<?php echo ($kegiatan_harian->kh_tgl->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->Phrase(">") ?></option><option value=">="<?php echo ($kegiatan_harian->kh_tgl->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->Phrase(">=") ?></option><option value="IS NULL"<?php echo ($kegiatan_harian->kh_tgl->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->Phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($kegiatan_harian->kh_tgl->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->Phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($kegiatan_harian->kh_tgl->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->Phrase("BETWEEN") ?></option></select></span>
		<span class="ewSearchField">
<input type="text" data-table="kegiatan_harian" data-field="x_kh_tgl" name="x_kh_tgl" id="x_kh_tgl" placeholder="<?php echo ew_HtmlEncode($kegiatan_harian->kh_tgl->getPlaceHolder()) ?>" value="<?php echo $kegiatan_harian->kh_tgl->EditValue ?>"<?php echo $kegiatan_harian->kh_tgl->EditAttributes() ?>>
<?php if (!$kegiatan_harian->kh_tgl->ReadOnly && !$kegiatan_harian->kh_tgl->Disabled && !isset($kegiatan_harian->kh_tgl->EditAttrs["readonly"]) && !isset($kegiatan_harian->kh_tgl->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("fkegiatan_harianlistsrch", "x_kh_tgl", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		<span class="ewSearchCond btw1_kh_tgl" style="display: none">&nbsp;<?php echo $Language->Phrase("AND") ?>&nbsp;</span>
		<span class="ewSearchField btw1_kh_tgl" style="display: none">
<input type="text" data-table="kegiatan_harian" data-field="x_kh_tgl" name="y_kh_tgl" id="y_kh_tgl" placeholder="<?php echo ew_HtmlEncode($kegiatan_harian->kh_tgl->getPlaceHolder()) ?>" value="<?php echo $kegiatan_harian->kh_tgl->EditValue2 ?>"<?php echo $kegiatan_harian->kh_tgl->EditAttributes() ?>>
<?php if (!$kegiatan_harian->kh_tgl->ReadOnly && !$kegiatan_harian->kh_tgl->Disabled && !isset($kegiatan_harian->kh_tgl->EditAttrs["readonly"]) && !isset($kegiatan_harian->kh_tgl->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("fkegiatan_harianlistsrch", "y_kh_tgl", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ewRow">
<?php if ($kegiatan_harian->kh_co_id->Visible) { // kh_co_id ?>
	<div id="xsc_kh_co_id" class="ewCell form-group">
		<label for="x_kh_co_id" class="ewSearchCaption ewLabel"><?php echo $kegiatan_harian->kh_co_id->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_kh_co_id" id="z_kh_co_id" value="="></span>
		<span class="ewSearchField">
<select data-table="kegiatan_harian" data-field="x_kh_co_id" data-value-separator="<?php echo $kegiatan_harian->kh_co_id->DisplayValueSeparatorAttribute() ?>" id="x_kh_co_id" name="x_kh_co_id"<?php echo $kegiatan_harian->kh_co_id->EditAttributes() ?>>
<?php echo $kegiatan_harian->kh_co_id->SelectOptionListHtml("x_kh_co_id") ?>
</select>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ewRow">
	<div class="ewQuickSearch input-group">
	<input type="text" name="<?php echo EW_TABLE_BASIC_SEARCH ?>" id="<?php echo EW_TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo ew_HtmlEncode($kegiatan_harian_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo ew_HtmlEncode($Language->Phrase("Search")) ?>">
	<input type="hidden" name="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo ew_HtmlEncode($kegiatan_harian_list->BasicSearch->getType()) ?>">
	<div class="input-group-btn">
		<button type="button" data-toggle="dropdown" class="btn btn-default"><span id="searchtype"><?php echo $kegiatan_harian_list->BasicSearch->getTypeNameShort() ?></span><span class="caret"></span></button>
		<ul class="dropdown-menu pull-right" role="menu">
			<li<?php if ($kegiatan_harian_list->BasicSearch->getType() == "") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this)"><?php echo $Language->Phrase("QuickSearchAuto") ?></a></li>
			<li<?php if ($kegiatan_harian_list->BasicSearch->getType() == "=") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'=')"><?php echo $Language->Phrase("QuickSearchExact") ?></a></li>
			<li<?php if ($kegiatan_harian_list->BasicSearch->getType() == "AND") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'AND')"><?php echo $Language->Phrase("QuickSearchAll") ?></a></li>
			<li<?php if ($kegiatan_harian_list->BasicSearch->getType() == "OR") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'OR')"><?php echo $Language->Phrase("QuickSearchAny") ?></a></li>
		</ul>
	<button class="btn btn-primary ewButton" name="btnsubmit" id="btnsubmit" type="submit"><?php echo $Language->Phrase("SearchBtn") ?></button>
	</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $kegiatan_harian_list->ShowPageHeader(); ?>
<?php
$kegiatan_harian_list->ShowMessage();
?>
<?php if ($kegiatan_harian_list->TotalRecs > 0 || $kegiatan_harian->CurrentAction <> "") { ?>
<div class="box ewBox ewGrid<?php if ($kegiatan_harian_list->IsAddOrEdit()) { ?> ewGridAddEdit<?php } ?> kegiatan_harian">
<?php if ($kegiatan_harian->Export == "") { ?>
<div class="box-header ewGridUpperPanel">
<?php if ($kegiatan_harian->CurrentAction <> "gridadd" && $kegiatan_harian->CurrentAction <> "gridedit") { ?>
<form name="ewPagerForm" class="form-inline ewForm ewPagerForm" action="<?php echo ew_CurrentPage() ?>">
<?php if (!isset($kegiatan_harian_list->Pager)) $kegiatan_harian_list->Pager = new cNumericPager($kegiatan_harian_list->StartRec, $kegiatan_harian_list->DisplayRecs, $kegiatan_harian_list->TotalRecs, $kegiatan_harian_list->RecRange, $kegiatan_harian_list->AutoHidePager) ?>
<?php if ($kegiatan_harian_list->Pager->RecordCount > 0 && $kegiatan_harian_list->Pager->Visible) { ?>
<div class="ewPager">
<div class="ewNumericPage"><ul class="pagination">
	<?php if ($kegiatan_harian_list->Pager->FirstButton->Enabled) { ?>
	<li><a href="<?php echo $kegiatan_harian_list->PageUrl() ?>start=<?php echo $kegiatan_harian_list->Pager->FirstButton->Start ?>"><?php echo $Language->Phrase("PagerFirst") ?></a></li>
	<?php } ?>
	<?php if ($kegiatan_harian_list->Pager->PrevButton->Enabled) { ?>
	<li><a href="<?php echo $kegiatan_harian_list->PageUrl() ?>start=<?php echo $kegiatan_harian_list->Pager->PrevButton->Start ?>"><?php echo $Language->Phrase("PagerPrevious") ?></a></li>
	<?php } ?>
	<?php foreach ($kegiatan_harian_list->Pager->Items as $PagerItem) { ?>
		<li<?php if (!$PagerItem->Enabled) { echo " class=\" active\""; } ?>><a href="<?php if ($PagerItem->Enabled) { echo $kegiatan_harian_list->PageUrl() . "start=" . $PagerItem->Start; } else { echo "#"; } ?>"><?php echo $PagerItem->Text ?></a></li>
	<?php } ?>
	<?php if ($kegiatan_harian_list->Pager->NextButton->Enabled) { ?>
	<li><a href="<?php echo $kegiatan_harian_list->PageUrl() ?>start=<?php echo $kegiatan_harian_list->Pager->NextButton->Start ?>"><?php echo $Language->Phrase("PagerNext") ?></a></li>
	<?php } ?>
	<?php if ($kegiatan_harian_list->Pager->LastButton->Enabled) { ?>
	<li><a href="<?php echo $kegiatan_harian_list->PageUrl() ?>start=<?php echo $kegiatan_harian_list->Pager->LastButton->Start ?>"><?php echo $Language->Phrase("PagerLast") ?></a></li>
	<?php } ?>
</ul></div>
</div>
<?php } ?>
<?php if ($kegiatan_harian_list->Pager->RecordCount > 0) { ?>
<div class="ewPager ewRec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $kegiatan_harian_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $kegiatan_harian_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $kegiatan_harian_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ewListOtherOptions">
<?php
	foreach ($kegiatan_harian_list->OtherOptions as &$option)
		$option->Render("body");
?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fkegiatan_harianlist" id="fkegiatan_harianlist" class="form-inline ewForm ewListForm" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($kegiatan_harian_list->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $kegiatan_harian_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="kegiatan_harian">
<div id="gmp_kegiatan_harian" class="<?php if (ew_IsResponsiveLayout()) { ?>table-responsive <?php } ?>ewGridMiddlePanel">
<?php if ($kegiatan_harian_list->TotalRecs > 0 || $kegiatan_harian->CurrentAction == "gridedit") { ?>
<table id="tbl_kegiatan_harianlist" class="table ewTable">
<thead>
	<tr class="ewTableHeader">
<?php

// Header row
$kegiatan_harian_list->RowType = EW_ROWTYPE_HEADER;

// Render list options
$kegiatan_harian_list->RenderListOptions();

// Render list options (header, left)
$kegiatan_harian_list->ListOptions->Render("header", "left");
?>
<?php if ($kegiatan_harian->kh_id->Visible) { // kh_id ?>
	<?php if ($kegiatan_harian->SortUrl($kegiatan_harian->kh_id) == "") { ?>
		<th data-name="kh_id" class="<?php echo $kegiatan_harian->kh_id->HeaderCellClass() ?>"><div id="elh_kegiatan_harian_kh_id" class="kegiatan_harian_kh_id"><div class="ewTableHeaderCaption"><?php echo $kegiatan_harian->kh_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="kh_id" class="<?php echo $kegiatan_harian->kh_id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kegiatan_harian->SortUrl($kegiatan_harian->kh_id) ?>',1);"><div id="elh_kegiatan_harian_kh_id" class="kegiatan_harian_kh_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kegiatan_harian->kh_id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($kegiatan_harian->kh_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kegiatan_harian->kh_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kegiatan_harian->kh_tgl->Visible) { // kh_tgl ?>
	<?php if ($kegiatan_harian->SortUrl($kegiatan_harian->kh_tgl) == "") { ?>
		<th data-name="kh_tgl" class="<?php echo $kegiatan_harian->kh_tgl->HeaderCellClass() ?>"><div id="elh_kegiatan_harian_kh_tgl" class="kegiatan_harian_kh_tgl"><div class="ewTableHeaderCaption"><?php echo $kegiatan_harian->kh_tgl->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="kh_tgl" class="<?php echo $kegiatan_harian->kh_tgl->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kegiatan_harian->SortUrl($kegiatan_harian->kh_tgl) ?>',1);"><div id="elh_kegiatan_harian_kh_tgl" class="kegiatan_harian_kh_tgl">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kegiatan_harian->kh_tgl->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($kegiatan_harian->kh_tgl->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kegiatan_harian->kh_tgl->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kegiatan_harian->kh_co_id->Visible) { // kh_co_id ?>
	<?php if ($kegiatan_harian->SortUrl($kegiatan_harian->kh_co_id) == "") { ?>
		<th data-name="kh_co_id" class="<?php echo $kegiatan_harian->kh_co_id->HeaderCellClass() ?>"><div id="elh_kegiatan_harian_kh_co_id" class="kegiatan_harian_kh_co_id"><div class="ewTableHeaderCaption"><?php echo $kegiatan_harian->kh_co_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="kh_co_id" class="<?php echo $kegiatan_harian->kh_co_id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kegiatan_harian->SortUrl($kegiatan_harian->kh_co_id) ?>',1);"><div id="elh_kegiatan_harian_kh_co_id" class="kegiatan_harian_kh_co_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kegiatan_harian->kh_co_id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($kegiatan_harian->kh_co_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kegiatan_harian->kh_co_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kegiatan_harian->kh_rencana->Visible) { // kh_rencana ?>
	<?php if ($kegiatan_harian->SortUrl($kegiatan_harian->kh_rencana) == "") { ?>
		<th data-name="kh_rencana" class="<?php echo $kegiatan_harian->kh_rencana->HeaderCellClass() ?>"><div id="elh_kegiatan_harian_kh_rencana" class="kegiatan_harian_kh_rencana"><div class="ewTableHeaderCaption"><?php echo $kegiatan_harian->kh_rencana->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="kh_rencana" class="<?php echo $kegiatan_harian->kh_rencana->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kegiatan_harian->SortUrl($kegiatan_harian->kh_rencana) ?>',1);"><div id="elh_kegiatan_harian_kh_rencana" class="kegiatan_harian_kh_rencana">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kegiatan_harian->kh_rencana->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($kegiatan_harian->kh_rencana->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kegiatan_harian->kh_rencana->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kegiatan_harian->kh_realisasi->Visible) { // kh_realisasi ?>
	<?php if ($kegiatan_harian->SortUrl($kegiatan_harian->kh_realisasi) == "") { ?>
		<th data-name="kh_realisasi" class="<?php echo $kegiatan_harian->kh_realisasi->HeaderCellClass() ?>"><div id="elh_kegiatan_harian_kh_realisasi" class="kegiatan_harian_kh_realisasi"><div class="ewTableHeaderCaption"><?php echo $kegiatan_harian->kh_realisasi->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="kh_realisasi" class="<?php echo $kegiatan_harian->kh_realisasi->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kegiatan_harian->SortUrl($kegiatan_harian->kh_realisasi) ?>',1);"><div id="elh_kegiatan_harian_kh_realisasi" class="kegiatan_harian_kh_realisasi">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kegiatan_harian->kh_realisasi->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($kegiatan_harian->kh_realisasi->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kegiatan_harian->kh_realisasi->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kegiatan_harian->kh_hasil->Visible) { // kh_hasil ?>
	<?php if ($kegiatan_harian->SortUrl($kegiatan_harian->kh_hasil) == "") { ?>
		<th data-name="kh_hasil" class="<?php echo $kegiatan_harian->kh_hasil->HeaderCellClass() ?>"><div id="elh_kegiatan_harian_kh_hasil" class="kegiatan_harian_kh_hasil"><div class="ewTableHeaderCaption"><?php echo $kegiatan_harian->kh_hasil->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="kh_hasil" class="<?php echo $kegiatan_harian->kh_hasil->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kegiatan_harian->SortUrl($kegiatan_harian->kh_hasil) ?>',1);"><div id="elh_kegiatan_harian_kh_hasil" class="kegiatan_harian_kh_hasil">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kegiatan_harian->kh_hasil->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($kegiatan_harian->kh_hasil->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kegiatan_harian->kh_hasil->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kegiatan_harian->kh_foto->Visible) { // kh_foto ?>
	<?php if ($kegiatan_harian->SortUrl($kegiatan_harian->kh_foto) == "") { ?>
		<th data-name="kh_foto" class="<?php echo $kegiatan_harian->kh_foto->HeaderCellClass() ?>"><div id="elh_kegiatan_harian_kh_foto" class="kegiatan_harian_kh_foto"><div class="ewTableHeaderCaption"><?php echo $kegiatan_harian->kh_foto->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="kh_foto" class="<?php echo $kegiatan_harian->kh_foto->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $kegiatan_harian->SortUrl($kegiatan_harian->kh_foto) ?>',1);"><div id="elh_kegiatan_harian_kh_foto" class="kegiatan_harian_kh_foto">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $kegiatan_harian->kh_foto->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($kegiatan_harian->kh_foto->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($kegiatan_harian->kh_foto->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$kegiatan_harian_list->ListOptions->Render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($kegiatan_harian->ExportAll && $kegiatan_harian->Export <> "") {
	$kegiatan_harian_list->StopRec = $kegiatan_harian_list->TotalRecs;
} else {

	// Set the last record to display
	if ($kegiatan_harian_list->TotalRecs > $kegiatan_harian_list->StartRec + $kegiatan_harian_list->DisplayRecs - 1)
		$kegiatan_harian_list->StopRec = $kegiatan_harian_list->StartRec + $kegiatan_harian_list->DisplayRecs - 1;
	else
		$kegiatan_harian_list->StopRec = $kegiatan_harian_list->TotalRecs;
}
$kegiatan_harian_list->RecCnt = $kegiatan_harian_list->StartRec - 1;
if ($kegiatan_harian_list->Recordset && !$kegiatan_harian_list->Recordset->EOF) {
	$kegiatan_harian_list->Recordset->MoveFirst();
	$bSelectLimit = $kegiatan_harian_list->UseSelectLimit;
	if (!$bSelectLimit && $kegiatan_harian_list->StartRec > 1)
		$kegiatan_harian_list->Recordset->Move($kegiatan_harian_list->StartRec - 1);
} elseif (!$kegiatan_harian->AllowAddDeleteRow && $kegiatan_harian_list->StopRec == 0) {
	$kegiatan_harian_list->StopRec = $kegiatan_harian->GridAddRowCount;
}

// Initialize aggregate
$kegiatan_harian->RowType = EW_ROWTYPE_AGGREGATEINIT;
$kegiatan_harian->ResetAttrs();
$kegiatan_harian_list->RenderRow();
while ($kegiatan_harian_list->RecCnt < $kegiatan_harian_list->StopRec) {
	$kegiatan_harian_list->RecCnt++;
	if (intval($kegiatan_harian_list->RecCnt) >= intval($kegiatan_harian_list->StartRec)) {
		$kegiatan_harian_list->RowCnt++;

		// Set up key count
		$kegiatan_harian_list->KeyCount = $kegiatan_harian_list->RowIndex;

		// Init row class and style
		$kegiatan_harian->ResetAttrs();
		$kegiatan_harian->CssClass = "";
		if ($kegiatan_harian->CurrentAction == "gridadd") {
		} else {
			$kegiatan_harian_list->LoadRowValues($kegiatan_harian_list->Recordset); // Load row values
		}
		$kegiatan_harian->RowType = EW_ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$kegiatan_harian->RowAttrs = array_merge($kegiatan_harian->RowAttrs, array('data-rowindex'=>$kegiatan_harian_list->RowCnt, 'id'=>'r' . $kegiatan_harian_list->RowCnt . '_kegiatan_harian', 'data-rowtype'=>$kegiatan_harian->RowType));

		// Render row
		$kegiatan_harian_list->RenderRow();

		// Render list options
		$kegiatan_harian_list->RenderListOptions();
?>
	<tr<?php echo $kegiatan_harian->RowAttributes() ?>>
<?php

// Render list options (body, left)
$kegiatan_harian_list->ListOptions->Render("body", "left", $kegiatan_harian_list->RowCnt);
?>
	<?php if ($kegiatan_harian->kh_id->Visible) { // kh_id ?>
		<td data-name="kh_id"<?php echo $kegiatan_harian->kh_id->CellAttributes() ?>>
<span id="el<?php echo $kegiatan_harian_list->RowCnt ?>_kegiatan_harian_kh_id" class="kegiatan_harian_kh_id">
<span<?php echo $kegiatan_harian->kh_id->ViewAttributes() ?>>
<?php echo $kegiatan_harian->kh_id->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kegiatan_harian->kh_tgl->Visible) { // kh_tgl ?>
		<td data-name="kh_tgl"<?php echo $kegiatan_harian->kh_tgl->CellAttributes() ?>>
<span id="el<?php echo $kegiatan_harian_list->RowCnt ?>_kegiatan_harian_kh_tgl" class="kegiatan_harian_kh_tgl">
<span<?php echo $kegiatan_harian->kh_tgl->ViewAttributes() ?>>
<?php echo $kegiatan_harian->kh_tgl->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kegiatan_harian->kh_co_id->Visible) { // kh_co_id ?>
		<td data-name="kh_co_id"<?php echo $kegiatan_harian->kh_co_id->CellAttributes() ?>>
<span id="el<?php echo $kegiatan_harian_list->RowCnt ?>_kegiatan_harian_kh_co_id" class="kegiatan_harian_kh_co_id">
<span<?php echo $kegiatan_harian->kh_co_id->ViewAttributes() ?>>
<?php echo $kegiatan_harian->kh_co_id->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kegiatan_harian->kh_rencana->Visible) { // kh_rencana ?>
		<td data-name="kh_rencana"<?php echo $kegiatan_harian->kh_rencana->CellAttributes() ?>>
<span id="el<?php echo $kegiatan_harian_list->RowCnt ?>_kegiatan_harian_kh_rencana" class="kegiatan_harian_kh_rencana">
<span<?php echo $kegiatan_harian->kh_rencana->ViewAttributes() ?>>
<?php echo $kegiatan_harian->kh_rencana->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kegiatan_harian->kh_realisasi->Visible) { // kh_realisasi ?>
		<td data-name="kh_realisasi"<?php echo $kegiatan_harian->kh_realisasi->CellAttributes() ?>>
<span id="el<?php echo $kegiatan_harian_list->RowCnt ?>_kegiatan_harian_kh_realisasi" class="kegiatan_harian_kh_realisasi">
<span<?php echo $kegiatan_harian->kh_realisasi->ViewAttributes() ?>>
<?php echo $kegiatan_harian->kh_realisasi->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kegiatan_harian->kh_hasil->Visible) { // kh_hasil ?>
		<td data-name="kh_hasil"<?php echo $kegiatan_harian->kh_hasil->CellAttributes() ?>>
<span id="el<?php echo $kegiatan_harian_list->RowCnt ?>_kegiatan_harian_kh_hasil" class="kegiatan_harian_kh_hasil">
<span<?php echo $kegiatan_harian->kh_hasil->ViewAttributes() ?>>
<?php echo $kegiatan_harian->kh_hasil->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kegiatan_harian->kh_foto->Visible) { // kh_foto ?>
		<td data-name="kh_foto"<?php echo $kegiatan_harian->kh_foto->CellAttributes() ?>>
<span id="el<?php echo $kegiatan_harian_list->RowCnt ?>_kegiatan_harian_kh_foto" class="kegiatan_harian_kh_foto">
<span>
<?php echo ew_GetFileViewTag($kegiatan_harian->kh_foto, $kegiatan_harian->kh_foto->ListViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$kegiatan_harian_list->ListOptions->Render("body", "right", $kegiatan_harian_list->RowCnt);
?>
	</tr>
<?php
	}
	if ($kegiatan_harian->CurrentAction <> "gridadd")
		$kegiatan_harian_list->Recordset->MoveNext();
}
?>
</tbody>
</table>
<?php } ?>
<?php if ($kegiatan_harian->CurrentAction == "") { ?>
<input type="hidden" name="a_list" id="a_list" value="">
<?php } ?>
</div>
</form>
<?php

// Close recordset
if ($kegiatan_harian_list->Recordset)
	$kegiatan_harian_list->Recordset->Close();
?>
<?php if ($kegiatan_harian->Export == "") { ?>
<div class="box-footer ewGridLowerPanel">
<?php if ($kegiatan_harian->CurrentAction <> "gridadd" && $kegiatan_harian->CurrentAction <> "gridedit") { ?>
<form name="ewPagerForm" class="ewForm form-inline ewPagerForm" action="<?php echo ew_CurrentPage() ?>">
<?php if (!isset($kegiatan_harian_list->Pager)) $kegiatan_harian_list->Pager = new cNumericPager($kegiatan_harian_list->StartRec, $kegiatan_harian_list->DisplayRecs, $kegiatan_harian_list->TotalRecs, $kegiatan_harian_list->RecRange, $kegiatan_harian_list->AutoHidePager) ?>
<?php if ($kegiatan_harian_list->Pager->RecordCount > 0 && $kegiatan_harian_list->Pager->Visible) { ?>
<div class="ewPager">
<div class="ewNumericPage"><ul class="pagination">
	<?php if ($kegiatan_harian_list->Pager->FirstButton->Enabled) { ?>
	<li><a href="<?php echo $kegiatan_harian_list->PageUrl() ?>start=<?php echo $kegiatan_harian_list->Pager->FirstButton->Start ?>"><?php echo $Language->Phrase("PagerFirst") ?></a></li>
	<?php } ?>
	<?php if ($kegiatan_harian_list->Pager->PrevButton->Enabled) { ?>
	<li><a href="<?php echo $kegiatan_harian_list->PageUrl() ?>start=<?php echo $kegiatan_harian_list->Pager->PrevButton->Start ?>"><?php echo $Language->Phrase("PagerPrevious") ?></a></li>
	<?php } ?>
	<?php foreach ($kegiatan_harian_list->Pager->Items as $PagerItem) { ?>
		<li<?php if (!$PagerItem->Enabled) { echo " class=\" active\""; } ?>><a href="<?php if ($PagerItem->Enabled) { echo $kegiatan_harian_list->PageUrl() . "start=" . $PagerItem->Start; } else { echo "#"; } ?>"><?php echo $PagerItem->Text ?></a></li>
	<?php } ?>
	<?php if ($kegiatan_harian_list->Pager->NextButton->Enabled) { ?>
	<li><a href="<?php echo $kegiatan_harian_list->PageUrl() ?>start=<?php echo $kegiatan_harian_list->Pager->NextButton->Start ?>"><?php echo $Language->Phrase("PagerNext") ?></a></li>
	<?php } ?>
	<?php if ($kegiatan_harian_list->Pager->LastButton->Enabled) { ?>
	<li><a href="<?php echo $kegiatan_harian_list->PageUrl() ?>start=<?php echo $kegiatan_harian_list->Pager->LastButton->Start ?>"><?php echo $Language->Phrase("PagerLast") ?></a></li>
	<?php } ?>
</ul></div>
</div>
<?php } ?>
<?php if ($kegiatan_harian_list->Pager->RecordCount > 0) { ?>
<div class="ewPager ewRec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $kegiatan_harian_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $kegiatan_harian_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $kegiatan_harian_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ewListOtherOptions">
<?php
	foreach ($kegiatan_harian_list->OtherOptions as &$option)
		$option->Render("body", "bottom");
?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div>
<?php } ?>
<?php if ($kegiatan_harian_list->TotalRecs == 0 && $kegiatan_harian->CurrentAction == "") { // Show other options ?>
<div class="ewListOtherOptions">
<?php
	foreach ($kegiatan_harian_list->OtherOptions as &$option) {
		$option->ButtonClass = "";
		$option->Render("body", "");
	}
?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php if ($kegiatan_harian->Export == "") { ?>
<script type="text/javascript">
fkegiatan_harianlistsrch.FilterList = <?php echo $kegiatan_harian_list->GetFilterList() ?>;
fkegiatan_harianlistsrch.Init();
fkegiatan_harianlist.Init();
</script>
<?php } ?>
<?php
$kegiatan_harian_list->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<?php if ($kegiatan_harian->Export == "") { ?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$kegiatan_harian_list->Page_Terminate();
?>
