<?php
if (session_id() == "") session_start(); // Init session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg14.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql14.php") ?>
<?php include_once "phpfn14.php" ?>
<?php include_once "kedatanganinfo.php" ?>
<?php include_once "employeesinfo.php" ?>
<?php include_once "userfn14.php" ?>
<?php

//
// Page class
//

$kedatangan_edit = NULL; // Initialize page object first

class ckedatangan_edit extends ckedatangan {

	// Page ID
	var $PageID = 'edit';

	// Project ID
	var $ProjectID = '{CC60B42B-604B-412A-B014-2315920AF6AA}';

	// Table name
	var $TableName = 'kedatangan';

	// Page object name
	var $PageObjName = 'kedatangan_edit';

	// Page headings
	var $Heading = '';
	var $Subheading = '';

	// Page heading
	function PageHeading() {
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->TableCaption();
		return "";
	}

	// Page subheading
	function PageSubheading() {
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->Phrase($this->PageID);
		return "";
	}

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (kedatangan)
		if (!isset($GLOBALS["kedatangan"]) || get_class($GLOBALS["kedatangan"]) == "ckedatangan") {
			$GLOBALS["kedatangan"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["kedatangan"];
		}

		// Table object (employees)
		if (!isset($GLOBALS['employees'])) $GLOBALS['employees'] = new cemployees();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'edit', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'kedatangan', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"]))
			$GLOBALS["gTimer"] = new cTimer();

		// Debug message
		ew_LoadDebugMsg();

		// Open connection
		if (!isset($conn))
			$conn = ew_Connect($this->DBID);

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new cemployees();
			$UserTableConn = Conn($UserTable->DBID);
		}
	}

	//
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Is modal
		$this->IsModal = (@$_GET["modal"] == "1" || @$_POST["modal"] == "1");

		// User profile
		$UserProfile = new cUserProfile();

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanEdit()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			if ($Security->CanList())
				$this->Page_Terminate(ew_GetUrl("kedatanganlist.php"));
			else
				$this->Page_Terminate(ew_GetUrl("login.php"));
		}

		// NOTE: Security object may be needed in other part of the script, skip set to Nothing
		// 
		// Security = null;
		// 
		// Create form object

		$objForm = new cFormObj();
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action
		$this->datang_id->SetVisibility();
		$this->datang_tgl->SetVisibility();
		$this->datang_sumber->SetVisibility();
		$this->k_id->SetVisibility();
		$this->sup_id->SetVisibility();
		$this->var_id->SetVisibility();
		$this->datang_jumlah->SetVisibility();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $kedatangan;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($kedatangan);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		// Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = ew_GetPageName($url);
				if ($pageName != $this->GetListUrl()) { // Not List page
					$row["caption"] = $this->GetModalCaption($pageName);
					if ($pageName == "kedatanganview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				header("Content-Type: application/json; charset=utf-8");
				echo ew_ConvertToUtf8(ew_ArrayToJson(array($row)));
			} else {
				ew_SaveDebugMsg();
				header("Location: " . $url);
			}
		}
		exit();
	}
	var $FormClassName = "form-horizontal ewForm ewEditForm";
	var $IsModal = FALSE;
	var $IsMobileOrModal = FALSE;
	var $DbMasterFilter;
	var $DbDetailFilter;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError, $gbSkipHeaderFooter;

		// Check modal
		if ($this->IsModal)
			$gbSkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = ew_IsMobile() || $this->IsModal;
		$this->FormClassName = "ewForm ewEditForm form-horizontal";
		$sReturnUrl = "";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (@$_POST["a_edit"] <> "") {
			$this->CurrentAction = $_POST["a_edit"]; // Get action code
			if ($this->CurrentAction <> "I") // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($objForm->HasValue("x_datang_id")) {
				$this->datang_id->setFormValue($objForm->GetValue("x_datang_id"));
			}
		} else {
			$this->CurrentAction = "I"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (isset($_GET["datang_id"])) {
				$this->datang_id->setQueryStringValue($_GET["datang_id"]);
				$loadByQuery = TRUE;
			} else {
				$this->datang_id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->LoadRow();

		// Process form if post back
		if ($postBack) {
			$this->LoadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->ValidateForm()) {
				$this->CurrentAction = ""; // Form error, reset action
				$this->setFailureMessage($gsFormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->RestoreFormValues();
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "I": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "") $this->setFailureMessage($Language->Phrase("NoRecord")); // No record found
					$this->Page_Terminate("kedatanganlist.php"); // No matching record, return to list
				}
				break;
			Case "U": // Update
				$sReturnUrl = $this->getReturnUrl();
				if (ew_GetPageName($sReturnUrl) == "kedatanganlist.php")
					$sReturnUrl = $this->AddMasterUrl($sReturnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->EditRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->Phrase("UpdateSuccess")); // Update success
					$this->Page_Terminate($sReturnUrl); // Return to caller
				} elseif ($this->getFailureMessage() == $Language->Phrase("NoRecord")) {
					$this->Page_Terminate($sReturnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->RestoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->SetupBreadcrumb();

		// Render the record
		$this->RowType = EW_ROWTYPE_EDIT; // Render as Edit
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Set up starting record parameters
	function SetupStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	function GetUploadFiles() {
		global $objForm, $Language;

		// Get upload data
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm;
		if (!$this->datang_id->FldIsDetailKey) {
			$this->datang_id->setFormValue($objForm->GetValue("x_datang_id"));
		}
		if (!$this->datang_tgl->FldIsDetailKey) {
			$this->datang_tgl->setFormValue($objForm->GetValue("x_datang_tgl"));
			$this->datang_tgl->CurrentValue = ew_UnFormatDateTime($this->datang_tgl->CurrentValue, 0);
		}
		if (!$this->datang_sumber->FldIsDetailKey) {
			$this->datang_sumber->setFormValue($objForm->GetValue("x_datang_sumber"));
		}
		if (!$this->k_id->FldIsDetailKey) {
			$this->k_id->setFormValue($objForm->GetValue("x_k_id"));
		}
		if (!$this->sup_id->FldIsDetailKey) {
			$this->sup_id->setFormValue($objForm->GetValue("x_sup_id"));
		}
		if (!$this->var_id->FldIsDetailKey) {
			$this->var_id->setFormValue($objForm->GetValue("x_var_id"));
		}
		if (!$this->datang_jumlah->FldIsDetailKey) {
			$this->datang_jumlah->setFormValue($objForm->GetValue("x_datang_jumlah"));
		}
	}

	// Restore form values
	function RestoreFormValues() {
		global $objForm;
		$this->datang_id->CurrentValue = $this->datang_id->FormValue;
		$this->datang_tgl->CurrentValue = $this->datang_tgl->FormValue;
		$this->datang_tgl->CurrentValue = ew_UnFormatDateTime($this->datang_tgl->CurrentValue, 0);
		$this->datang_sumber->CurrentValue = $this->datang_sumber->FormValue;
		$this->k_id->CurrentValue = $this->k_id->FormValue;
		$this->sup_id->CurrentValue = $this->sup_id->FormValue;
		$this->var_id->CurrentValue = $this->var_id->FormValue;
		$this->datang_jumlah->CurrentValue = $this->datang_jumlah->FormValue;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues($rs = NULL) {
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->NewRow(); 

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->datang_id->setDbValue($row['datang_id']);
		$this->datang_tgl->setDbValue($row['datang_tgl']);
		$this->datang_sumber->setDbValue($row['datang_sumber']);
		$this->k_id->setDbValue($row['k_id']);
		if (array_key_exists('EV__k_id', $rs->fields)) {
			$this->k_id->VirtualValue = $rs->fields('EV__k_id'); // Set up virtual field value
		} else {
			$this->k_id->VirtualValue = ""; // Clear value
		}
		$this->sup_id->setDbValue($row['sup_id']);
		$this->var_id->setDbValue($row['var_id']);
		$this->datang_jumlah->setDbValue($row['datang_jumlah']);
	}

	// Return a row with default values
	function NewRow() {
		$row = array();
		$row['datang_id'] = NULL;
		$row['datang_tgl'] = NULL;
		$row['datang_sumber'] = NULL;
		$row['k_id'] = NULL;
		$row['sup_id'] = NULL;
		$row['var_id'] = NULL;
		$row['datang_jumlah'] = NULL;
		return $row;
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->datang_id->DbValue = $row['datang_id'];
		$this->datang_tgl->DbValue = $row['datang_tgl'];
		$this->datang_sumber->DbValue = $row['datang_sumber'];
		$this->k_id->DbValue = $row['k_id'];
		$this->sup_id->DbValue = $row['sup_id'];
		$this->var_id->DbValue = $row['var_id'];
		$this->datang_jumlah->DbValue = $row['datang_jumlah'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("datang_id")) <> "")
			$this->datang_id->CurrentValue = $this->getKey("datang_id"); // datang_id
		else
			$bValidKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
		}
		$this->LoadRowValues($this->OldRecordset); // Load row values
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// datang_id
		// datang_tgl
		// datang_sumber
		// k_id
		// sup_id
		// var_id
		// datang_jumlah

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// datang_id
		$this->datang_id->ViewValue = $this->datang_id->CurrentValue;
		$this->datang_id->ViewCustomAttributes = "";

		// datang_tgl
		$this->datang_tgl->ViewValue = $this->datang_tgl->CurrentValue;
		$this->datang_tgl->ViewValue = ew_FormatDateTime($this->datang_tgl->ViewValue, 0);
		$this->datang_tgl->ViewCustomAttributes = "";

		// datang_sumber
		if (strval($this->datang_sumber->CurrentValue) <> "") {
			$sFilterWrk = "`ds_id`" . ew_SearchString("=", $this->datang_sumber->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `ds_id`, `ds_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `datang_sumber`";
		$sWhereWrk = "";
		$this->datang_sumber->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->datang_sumber, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `ds_id` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->datang_sumber->ViewValue = $this->datang_sumber->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->datang_sumber->ViewValue = $this->datang_sumber->CurrentValue;
			}
		} else {
			$this->datang_sumber->ViewValue = NULL;
		}
		$this->datang_sumber->ViewCustomAttributes = "";

		// k_id
		if ($this->k_id->VirtualValue <> "") {
			$this->k_id->ViewValue = $this->k_id->VirtualValue;
		} else {
			$this->k_id->ViewValue = $this->k_id->CurrentValue;
		if (strval($this->k_id->CurrentValue) <> "") {
			$sFilterWrk = "`k_id`" . ew_SearchString("=", $this->k_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `k_id`, `k_id_kontrak` AS `DispFld`, `k_tgl_tanam` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kontrak`";
		$sWhereWrk = "";
		$this->k_id->LookupFilters = array("df2" => "5");
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->k_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `k_id` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = ew_FormatDateTime($rswrk->fields('Disp2Fld'), 5);
				$this->k_id->ViewValue = $this->k_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->k_id->ViewValue = $this->k_id->CurrentValue;
			}
		} else {
			$this->k_id->ViewValue = NULL;
		}
		}
		$this->k_id->ViewCustomAttributes = "";

		// sup_id
		$this->sup_id->ViewValue = $this->sup_id->CurrentValue;
		if (strval($this->sup_id->CurrentValue) <> "") {
			$sFilterWrk = "`sup_id`" . ew_SearchString("=", $this->sup_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `sup_id`, `sup_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `suplaiyer_ubi`";
		$sWhereWrk = "";
		$this->sup_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->sup_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `sup_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->sup_id->ViewValue = $this->sup_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->sup_id->ViewValue = $this->sup_id->CurrentValue;
			}
		} else {
			$this->sup_id->ViewValue = NULL;
		}
		$this->sup_id->ViewCustomAttributes = "";

		// var_id
		if (strval($this->var_id->CurrentValue) <> "") {
			$sFilterWrk = "`var_id`" . ew_SearchString("=", $this->var_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `var_id`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `varietas`";
		$sWhereWrk = "";
		$this->var_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->var_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `var_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->var_id->ViewValue = $this->var_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->var_id->ViewValue = $this->var_id->CurrentValue;
			}
		} else {
			$this->var_id->ViewValue = NULL;
		}
		$this->var_id->ViewCustomAttributes = "";

		// datang_jumlah
		$this->datang_jumlah->ViewValue = $this->datang_jumlah->CurrentValue;
		$this->datang_jumlah->ViewCustomAttributes = "";

			// datang_id
			$this->datang_id->LinkCustomAttributes = "";
			$this->datang_id->HrefValue = "";
			$this->datang_id->TooltipValue = "";

			// datang_tgl
			$this->datang_tgl->LinkCustomAttributes = "";
			$this->datang_tgl->HrefValue = "";
			$this->datang_tgl->TooltipValue = "";

			// datang_sumber
			$this->datang_sumber->LinkCustomAttributes = "";
			$this->datang_sumber->HrefValue = "";
			$this->datang_sumber->TooltipValue = "";

			// k_id
			$this->k_id->LinkCustomAttributes = "";
			$this->k_id->HrefValue = "";
			$this->k_id->TooltipValue = "";

			// sup_id
			$this->sup_id->LinkCustomAttributes = "";
			$this->sup_id->HrefValue = "";
			$this->sup_id->TooltipValue = "";

			// var_id
			$this->var_id->LinkCustomAttributes = "";
			$this->var_id->HrefValue = "";
			$this->var_id->TooltipValue = "";

			// datang_jumlah
			$this->datang_jumlah->LinkCustomAttributes = "";
			$this->datang_jumlah->HrefValue = "";
			$this->datang_jumlah->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_EDIT) { // Edit row

			// datang_id
			$this->datang_id->EditAttrs["class"] = "form-control";
			$this->datang_id->EditCustomAttributes = "";
			$this->datang_id->EditValue = $this->datang_id->CurrentValue;
			$this->datang_id->ViewCustomAttributes = "";

			// datang_tgl
			$this->datang_tgl->EditAttrs["class"] = "form-control";
			$this->datang_tgl->EditCustomAttributes = "";
			$this->datang_tgl->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->datang_tgl->CurrentValue, 8));
			$this->datang_tgl->PlaceHolder = ew_RemoveHtml($this->datang_tgl->FldCaption());

			// datang_sumber
			$this->datang_sumber->EditCustomAttributes = "";
			if (trim(strval($this->datang_sumber->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`ds_id`" . ew_SearchString("=", $this->datang_sumber->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `ds_id`, `ds_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `datang_sumber`";
			$sWhereWrk = "";
			$this->datang_sumber->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->datang_sumber, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `ds_id` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->datang_sumber->EditValue = $arwrk;

			// k_id
			$this->k_id->EditAttrs["class"] = "form-control";
			$this->k_id->EditCustomAttributes = "";
			$this->k_id->EditValue = ew_HtmlEncode($this->k_id->CurrentValue);
			$this->k_id->PlaceHolder = ew_RemoveHtml($this->k_id->FldCaption());

			// sup_id
			$this->sup_id->EditAttrs["class"] = "form-control";
			$this->sup_id->EditCustomAttributes = "";
			$this->sup_id->EditValue = ew_HtmlEncode($this->sup_id->CurrentValue);
			if (strval($this->sup_id->CurrentValue) <> "") {
				$sFilterWrk = "`sup_id`" . ew_SearchString("=", $this->sup_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			$sSqlWrk = "SELECT `sup_id`, `sup_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `suplaiyer_ubi`";
			$sWhereWrk = "";
			$this->sup_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->sup_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `sup_nama` ASC";
				$rswrk = Conn()->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = ew_HtmlEncode($rswrk->fields('DispFld'));
					$this->sup_id->EditValue = $this->sup_id->DisplayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->sup_id->EditValue = ew_HtmlEncode($this->sup_id->CurrentValue);
				}
			} else {
				$this->sup_id->EditValue = NULL;
			}
			$this->sup_id->PlaceHolder = ew_RemoveHtml($this->sup_id->FldCaption());

			// var_id
			$this->var_id->EditAttrs["class"] = "form-control";
			$this->var_id->EditCustomAttributes = "";
			if (trim(strval($this->var_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`var_id`" . ew_SearchString("=", $this->var_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `var_id`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `varietas`";
			$sWhereWrk = "";
			$this->var_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->var_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `var_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->var_id->EditValue = $arwrk;

			// datang_jumlah
			$this->datang_jumlah->EditAttrs["class"] = "form-control";
			$this->datang_jumlah->EditCustomAttributes = "";
			$this->datang_jumlah->EditValue = ew_HtmlEncode($this->datang_jumlah->CurrentValue);
			$this->datang_jumlah->PlaceHolder = ew_RemoveHtml($this->datang_jumlah->FldCaption());

			// Edit refer script
			// datang_id

			$this->datang_id->LinkCustomAttributes = "";
			$this->datang_id->HrefValue = "";

			// datang_tgl
			$this->datang_tgl->LinkCustomAttributes = "";
			$this->datang_tgl->HrefValue = "";

			// datang_sumber
			$this->datang_sumber->LinkCustomAttributes = "";
			$this->datang_sumber->HrefValue = "";

			// k_id
			$this->k_id->LinkCustomAttributes = "";
			$this->k_id->HrefValue = "";

			// sup_id
			$this->sup_id->LinkCustomAttributes = "";
			$this->sup_id->HrefValue = "";

			// var_id
			$this->var_id->LinkCustomAttributes = "";
			$this->var_id->HrefValue = "";

			// datang_jumlah
			$this->datang_jumlah->LinkCustomAttributes = "";
			$this->datang_jumlah->HrefValue = "";
		}
		if ($this->RowType == EW_ROWTYPE_ADD || $this->RowType == EW_ROWTYPE_EDIT || $this->RowType == EW_ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->SetupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $Language, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return ($gsFormError == "");
		if (!$this->datang_id->FldIsDetailKey && !is_null($this->datang_id->FormValue) && $this->datang_id->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->datang_id->FldCaption(), $this->datang_id->ReqErrMsg));
		}
		if (!ew_CheckInteger($this->datang_id->FormValue)) {
			ew_AddMessage($gsFormError, $this->datang_id->FldErrMsg());
		}
		if (!ew_CheckDateDef($this->datang_tgl->FormValue)) {
			ew_AddMessage($gsFormError, $this->datang_tgl->FldErrMsg());
		}
		if (!ew_CheckInteger($this->sup_id->FormValue)) {
			ew_AddMessage($gsFormError, $this->sup_id->FldErrMsg());
		}
		if (!ew_CheckInteger($this->datang_jumlah->FormValue)) {
			ew_AddMessage($gsFormError, $this->datang_jumlah->FldErrMsg());
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsFormError, $sFormCustomError);
		}
		return $ValidateForm;
	}

	// Update record based on key values
	function EditRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();
		$sFilter = $this->ApplyUserIDFilters($sFilter);
		$conn = &$this->Connection();
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
		$rs = $conn->Execute($sSql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->Phrase("NoRecord")); // Set no record message
			$EditRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->LoadDbValues($rsold);
			$rsnew = array();

			// datang_id
			// datang_tgl

			$this->datang_tgl->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->datang_tgl->CurrentValue, 0), NULL, $this->datang_tgl->ReadOnly);

			// datang_sumber
			$this->datang_sumber->SetDbValueDef($rsnew, $this->datang_sumber->CurrentValue, NULL, $this->datang_sumber->ReadOnly);

			// k_id
			$this->k_id->SetDbValueDef($rsnew, $this->k_id->CurrentValue, NULL, $this->k_id->ReadOnly);

			// sup_id
			$this->sup_id->SetDbValueDef($rsnew, $this->sup_id->CurrentValue, NULL, $this->sup_id->ReadOnly);

			// var_id
			$this->var_id->SetDbValueDef($rsnew, $this->var_id->CurrentValue, NULL, $this->var_id->ReadOnly);

			// datang_jumlah
			$this->datang_jumlah->SetDbValueDef($rsnew, $this->datang_jumlah->CurrentValue, NULL, $this->datang_jumlah->ReadOnly);

			// Call Row Updating event
			$bUpdateRow = $this->Row_Updating($rsold, $rsnew);
			if ($bUpdateRow) {
				$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
				if (count($rsnew) > 0)
					$EditRow = $this->Update($rsnew, "", $rsold);
				else
					$EditRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($EditRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->Phrase("UpdateCancelled"));
				}
				$EditRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($EditRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->Close();
		return $EditRow;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$Breadcrumb->Add("list", $this->TableVar, $this->AddMasterUrl("kedatanganlist.php"), "", $this->TableVar, TRUE);
		$PageId = "edit";
		$Breadcrumb->Add("edit", $PageId, $url);
	}

	// Setup lookup filters of a field
	function SetupLookupFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		case "x_datang_sumber":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `ds_id` AS `LinkFld`, `ds_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `datang_sumber`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`ds_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->datang_sumber, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `ds_id` DESC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_k_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `k_id` AS `LinkFld`, `k_id_kontrak` AS `DispFld`, `k_tgl_tanam` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kontrak`";
			$sWhereWrk = "{filter}";
			$fld->LookupFilters = array("df2" => "5");
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`k_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->k_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `k_id` DESC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_sup_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `sup_id` AS `LinkFld`, `sup_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `suplaiyer_ubi`";
			$sWhereWrk = "{filter}";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`sup_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->sup_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `sup_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_var_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `var_id` AS `LinkFld`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `varietas`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`var_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->var_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `var_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		}
	}

	// Setup AutoSuggest filters of a field
	function SetupAutoSuggestFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		case "x_k_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `k_id`, `k_id_kontrak` AS `DispFld`, `k_tgl_tanam` AS `Disp2Fld` FROM `kontrak`";
			$sWhereWrk = "`k_id_kontrak` LIKE '{query_value}%' OR CONCAT(COALESCE(`k_id_kontrak`, ''),'" . ew_ValueSeparator(1, $this->k_id) . "',COALESCE(" . ew_CastDateFieldForLike('`k_tgl_tanam`', 5, "DB") . ",'')) LIKE '{query_value}%'";
			$fld->LookupFilters = array("df2" => "5");
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->k_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `k_id` DESC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_sup_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `sup_id`, `sup_nama` AS `DispFld` FROM `suplaiyer_ubi`";
			$sWhereWrk = "`sup_nama` LIKE '{query_value}%'";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->sup_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `sup_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($kedatangan_edit)) $kedatangan_edit = new ckedatangan_edit();

// Page init
$kedatangan_edit->Page_Init();

// Page main
$kedatangan_edit->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$kedatangan_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "edit";
var CurrentForm = fkedatanganedit = new ew_Form("fkedatanganedit", "edit");

// Validate form
fkedatanganedit.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);
	if ($fobj.find("#a_confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.FormKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = $fobj.find("#a_list").val() == "gridinsert";
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
			elm = this.GetElements("x" + infix + "_datang_id");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $kedatangan->datang_id->FldCaption(), $kedatangan->datang_id->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_datang_id");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($kedatangan->datang_id->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_datang_tgl");
			if (elm && !ew_CheckDateDef(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($kedatangan->datang_tgl->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_sup_id");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($kedatangan->sup_id->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_datang_jumlah");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($kedatangan->datang_jumlah->FldErrMsg()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ewForms[val])
			if (!ewForms[val].Validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fkedatanganedit.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fkedatanganedit.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fkedatanganedit.Lists["x_datang_sumber"] = {"LinkField":"x_ds_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_ds_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"datang_sumber"};
fkedatanganedit.Lists["x_datang_sumber"].Data = "<?php echo $kedatangan_edit->datang_sumber->LookupFilterQuery(FALSE, "edit") ?>";
fkedatanganedit.Lists["x_k_id"] = {"LinkField":"x_k_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_k_id_kontrak","x_k_tgl_tanam","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kontrak"};
fkedatanganedit.Lists["x_k_id"].Data = "<?php echo $kedatangan_edit->k_id->LookupFilterQuery(FALSE, "edit") ?>";
fkedatanganedit.AutoSuggests["x_k_id"] = <?php echo json_encode(array("data" => "ajax=autosuggest&" . $kedatangan_edit->k_id->LookupFilterQuery(TRUE, "edit"))) ?>;
fkedatanganedit.Lists["x_sup_id"] = {"LinkField":"x_sup_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_sup_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"suplaiyer_ubi"};
fkedatanganedit.Lists["x_sup_id"].Data = "<?php echo $kedatangan_edit->sup_id->LookupFilterQuery(FALSE, "edit") ?>";
fkedatanganedit.AutoSuggests["x_sup_id"] = <?php echo json_encode(array("data" => "ajax=autosuggest&" . $kedatangan_edit->sup_id->LookupFilterQuery(TRUE, "edit"))) ?>;
fkedatanganedit.Lists["x_var_id"] = {"LinkField":"x_var_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_var_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"varietas"};
fkedatanganedit.Lists["x_var_id"].Data = "<?php echo $kedatangan_edit->var_id->LookupFilterQuery(FALSE, "edit") ?>";

// Form object for search
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php $kedatangan_edit->ShowPageHeader(); ?>
<?php
$kedatangan_edit->ShowMessage();
?>
<form name="fkedatanganedit" id="fkedatanganedit" class="<?php echo $kedatangan_edit->FormClassName ?>" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($kedatangan_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $kedatangan_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="kedatangan">
<input type="hidden" name="a_edit" id="a_edit" value="U">
<input type="hidden" name="modal" value="<?php echo intval($kedatangan_edit->IsModal) ?>">
<div class="ewEditDiv"><!-- page* -->
<?php if ($kedatangan->datang_id->Visible) { // datang_id ?>
	<div id="r_datang_id" class="form-group">
		<label id="elh_kedatangan_datang_id" for="x_datang_id" class="<?php echo $kedatangan_edit->LeftColumnClass ?>"><?php echo $kedatangan->datang_id->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $kedatangan_edit->RightColumnClass ?>"><div<?php echo $kedatangan->datang_id->CellAttributes() ?>>
<span id="el_kedatangan_datang_id">
<span<?php echo $kedatangan->datang_id->ViewAttributes() ?>>
<p class="form-control-static"><?php echo $kedatangan->datang_id->EditValue ?></p></span>
</span>
<input type="hidden" data-table="kedatangan" data-field="x_datang_id" name="x_datang_id" id="x_datang_id" value="<?php echo ew_HtmlEncode($kedatangan->datang_id->CurrentValue) ?>">
<?php echo $kedatangan->datang_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kedatangan->datang_tgl->Visible) { // datang_tgl ?>
	<div id="r_datang_tgl" class="form-group">
		<label id="elh_kedatangan_datang_tgl" for="x_datang_tgl" class="<?php echo $kedatangan_edit->LeftColumnClass ?>"><?php echo $kedatangan->datang_tgl->FldCaption() ?></label>
		<div class="<?php echo $kedatangan_edit->RightColumnClass ?>"><div<?php echo $kedatangan->datang_tgl->CellAttributes() ?>>
<span id="el_kedatangan_datang_tgl">
<input type="text" data-table="kedatangan" data-field="x_datang_tgl" name="x_datang_tgl" id="x_datang_tgl" placeholder="<?php echo ew_HtmlEncode($kedatangan->datang_tgl->getPlaceHolder()) ?>" value="<?php echo $kedatangan->datang_tgl->EditValue ?>"<?php echo $kedatangan->datang_tgl->EditAttributes() ?>>
<?php if (!$kedatangan->datang_tgl->ReadOnly && !$kedatangan->datang_tgl->Disabled && !isset($kedatangan->datang_tgl->EditAttrs["readonly"]) && !isset($kedatangan->datang_tgl->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("fkedatanganedit", "x_datang_tgl", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $kedatangan->datang_tgl->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kedatangan->datang_sumber->Visible) { // datang_sumber ?>
	<div id="r_datang_sumber" class="form-group">
		<label id="elh_kedatangan_datang_sumber" class="<?php echo $kedatangan_edit->LeftColumnClass ?>"><?php echo $kedatangan->datang_sumber->FldCaption() ?></label>
		<div class="<?php echo $kedatangan_edit->RightColumnClass ?>"><div<?php echo $kedatangan->datang_sumber->CellAttributes() ?>>
<span id="el_kedatangan_datang_sumber">
<div id="tp_x_datang_sumber" class="ewTemplate"><input type="radio" data-table="kedatangan" data-field="x_datang_sumber" data-value-separator="<?php echo $kedatangan->datang_sumber->DisplayValueSeparatorAttribute() ?>" name="x_datang_sumber" id="x_datang_sumber" value="{value}"<?php echo $kedatangan->datang_sumber->EditAttributes() ?>></div>
<div id="dsl_x_datang_sumber" data-repeatcolumn="5" class="ewItemList" style="display: none;"><div>
<?php echo $kedatangan->datang_sumber->RadioButtonListHtml(FALSE, "x_datang_sumber") ?>
</div></div>
</span>
<?php echo $kedatangan->datang_sumber->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kedatangan->k_id->Visible) { // k_id ?>
	<div id="r_k_id" class="form-group">
		<label id="elh_kedatangan_k_id" class="<?php echo $kedatangan_edit->LeftColumnClass ?>"><?php echo $kedatangan->k_id->FldCaption() ?></label>
		<div class="<?php echo $kedatangan_edit->RightColumnClass ?>"><div<?php echo $kedatangan->k_id->CellAttributes() ?>>
<span id="el_kedatangan_k_id">
<?php
$wrkonchange = trim(" " . @$kedatangan->k_id->EditAttrs["onchange"]);
if ($wrkonchange <> "") $wrkonchange = " onchange=\"" . ew_JsEncode2($wrkonchange) . "\"";
$kedatangan->k_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_k_id" style="white-space: nowrap; z-index: 8960">
	<input type="text" name="sv_x_k_id" id="sv_x_k_id" value="<?php echo $kedatangan->k_id->EditValue ?>" size="30" placeholder="<?php echo ew_HtmlEncode($kedatangan->k_id->getPlaceHolder()) ?>" data-placeholder="<?php echo ew_HtmlEncode($kedatangan->k_id->getPlaceHolder()) ?>"<?php echo $kedatangan->k_id->EditAttributes() ?>>
</span>
<input type="hidden" data-table="kedatangan" data-field="x_k_id" data-value-separator="<?php echo $kedatangan->k_id->DisplayValueSeparatorAttribute() ?>" name="x_k_id" id="x_k_id" value="<?php echo ew_HtmlEncode($kedatangan->k_id->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script type="text/javascript">
fkedatanganedit.CreateAutoSuggest({"id":"x_k_id","forceSelect":false});
</script>
</span>
<?php echo $kedatangan->k_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kedatangan->sup_id->Visible) { // sup_id ?>
	<div id="r_sup_id" class="form-group">
		<label id="elh_kedatangan_sup_id" class="<?php echo $kedatangan_edit->LeftColumnClass ?>"><?php echo $kedatangan->sup_id->FldCaption() ?></label>
		<div class="<?php echo $kedatangan_edit->RightColumnClass ?>"><div<?php echo $kedatangan->sup_id->CellAttributes() ?>>
<span id="el_kedatangan_sup_id">
<?php
$wrkonchange = trim(" " . @$kedatangan->sup_id->EditAttrs["onchange"]);
if ($wrkonchange <> "") $wrkonchange = " onchange=\"" . ew_JsEncode2($wrkonchange) . "\"";
$kedatangan->sup_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_sup_id" style="white-space: nowrap; z-index: 8950">
	<input type="text" name="sv_x_sup_id" id="sv_x_sup_id" value="<?php echo $kedatangan->sup_id->EditValue ?>" size="30" placeholder="<?php echo ew_HtmlEncode($kedatangan->sup_id->getPlaceHolder()) ?>" data-placeholder="<?php echo ew_HtmlEncode($kedatangan->sup_id->getPlaceHolder()) ?>"<?php echo $kedatangan->sup_id->EditAttributes() ?>>
</span>
<input type="hidden" data-table="kedatangan" data-field="x_sup_id" data-value-separator="<?php echo $kedatangan->sup_id->DisplayValueSeparatorAttribute() ?>" name="x_sup_id" id="x_sup_id" value="<?php echo ew_HtmlEncode($kedatangan->sup_id->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script type="text/javascript">
fkedatanganedit.CreateAutoSuggest({"id":"x_sup_id","forceSelect":false});
</script>
</span>
<?php echo $kedatangan->sup_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kedatangan->var_id->Visible) { // var_id ?>
	<div id="r_var_id" class="form-group">
		<label id="elh_kedatangan_var_id" for="x_var_id" class="<?php echo $kedatangan_edit->LeftColumnClass ?>"><?php echo $kedatangan->var_id->FldCaption() ?></label>
		<div class="<?php echo $kedatangan_edit->RightColumnClass ?>"><div<?php echo $kedatangan->var_id->CellAttributes() ?>>
<span id="el_kedatangan_var_id">
<select data-table="kedatangan" data-field="x_var_id" data-value-separator="<?php echo $kedatangan->var_id->DisplayValueSeparatorAttribute() ?>" id="x_var_id" name="x_var_id"<?php echo $kedatangan->var_id->EditAttributes() ?>>
<?php echo $kedatangan->var_id->SelectOptionListHtml("x_var_id") ?>
</select>
</span>
<?php echo $kedatangan->var_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kedatangan->datang_jumlah->Visible) { // datang_jumlah ?>
	<div id="r_datang_jumlah" class="form-group">
		<label id="elh_kedatangan_datang_jumlah" for="x_datang_jumlah" class="<?php echo $kedatangan_edit->LeftColumnClass ?>"><?php echo $kedatangan->datang_jumlah->FldCaption() ?></label>
		<div class="<?php echo $kedatangan_edit->RightColumnClass ?>"><div<?php echo $kedatangan->datang_jumlah->CellAttributes() ?>>
<span id="el_kedatangan_datang_jumlah">
<input type="text" data-table="kedatangan" data-field="x_datang_jumlah" name="x_datang_jumlah" id="x_datang_jumlah" size="30" placeholder="<?php echo ew_HtmlEncode($kedatangan->datang_jumlah->getPlaceHolder()) ?>" value="<?php echo $kedatangan->datang_jumlah->EditValue ?>"<?php echo $kedatangan->datang_jumlah->EditAttributes() ?>>
</span>
<?php echo $kedatangan->datang_jumlah->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$kedatangan_edit->IsModal) { ?>
<div class="form-group"><!-- buttons .form-group -->
	<div class="<?php echo $kedatangan_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ewButton" name="btnAction" id="btnAction" type="submit"><?php echo $Language->Phrase("SaveBtn") ?></button>
<button class="btn btn-default ewButton" name="btnCancel" id="btnCancel" type="button" data-href="<?php echo $kedatangan_edit->getReturnUrl() ?>"><?php echo $Language->Phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<script type="text/javascript">
fkedatanganedit.Init();
</script>
<?php
$kedatangan_edit->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$kedatangan_edit->Page_Terminate();
?>
