<?php
if (session_id() == "") session_start(); // Init session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg14.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql14.php") ?>
<?php include_once "phpfn14.php" ?>
<?php include_once "hirarki_bibitinfo.php" ?>
<?php include_once "employeesinfo.php" ?>
<?php include_once "userfn14.php" ?>
<?php

//
// Page class
//

$hirarki_bibit_list = NULL; // Initialize page object first

class chirarki_bibit_list extends chirarki_bibit {

	// Page ID
	var $PageID = 'list';

	// Project ID
	var $ProjectID = '{CC60B42B-604B-412A-B014-2315920AF6AA}';

	// Table name
	var $TableName = 'hirarki_bibit';

	// Page object name
	var $PageObjName = 'hirarki_bibit_list';

	// Grid form hidden field names
	var $FormName = 'fhirarki_bibitlist';
	var $FormActionName = 'k_action';
	var $FormKeyName = 'k_key';
	var $FormOldKeyName = 'k_oldkey';
	var $FormBlankRowName = 'k_blankrow';
	var $FormKeyCountName = 'key_count';

	// Page headings
	var $Heading = '';
	var $Subheading = '';

	// Page heading
	function PageHeading() {
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->TableCaption();
		return "";
	}

	// Page subheading
	function PageSubheading() {
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->Phrase($this->PageID);
		return "";
	}

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;
	var $ExportPdfUrl;

	// Custom export
	var $ExportExcelCustom = FALSE;
	var $ExportWordCustom = FALSE;
	var $ExportPdfCustom = FALSE;
	var $ExportEmailCustom = FALSE;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (hirarki_bibit)
		if (!isset($GLOBALS["hirarki_bibit"]) || get_class($GLOBALS["hirarki_bibit"]) == "chirarki_bibit") {
			$GLOBALS["hirarki_bibit"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["hirarki_bibit"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->PageUrl() . "export=print";
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel";
		$this->ExportWordUrl = $this->PageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->PageUrl() . "export=html";
		$this->ExportXmlUrl = $this->PageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->PageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf";
		$this->AddUrl = "hirarki_bibitadd.php";
		$this->InlineAddUrl = $this->PageUrl() . "a=add";
		$this->GridAddUrl = $this->PageUrl() . "a=gridadd";
		$this->GridEditUrl = $this->PageUrl() . "a=gridedit";
		$this->MultiDeleteUrl = "hirarki_bibitdelete.php";
		$this->MultiUpdateUrl = "hirarki_bibitupdate.php";

		// Table object (employees)
		if (!isset($GLOBALS['employees'])) $GLOBALS['employees'] = new cemployees();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'list', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'hirarki_bibit', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"]))
			$GLOBALS["gTimer"] = new cTimer();

		// Debug message
		ew_LoadDebugMsg();

		// Open connection
		if (!isset($conn))
			$conn = ew_Connect($this->DBID);

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new cemployees();
			$UserTableConn = Conn($UserTable->DBID);
		}

		// List options
		$this->ListOptions = new cListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new cListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Other options
		$this->OtherOptions['addedit'] = new cListOptions();
		$this->OtherOptions['addedit']->Tag = "div";
		$this->OtherOptions['addedit']->TagClassName = "ewAddEditOption";
		$this->OtherOptions['detail'] = new cListOptions();
		$this->OtherOptions['detail']->Tag = "div";
		$this->OtherOptions['detail']->TagClassName = "ewDetailOption";
		$this->OtherOptions['action'] = new cListOptions();
		$this->OtherOptions['action']->Tag = "div";
		$this->OtherOptions['action']->TagClassName = "ewActionOption";

		// Filter options
		$this->FilterOptions = new cListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ewFilterOption fhirarki_bibitlistsrch";

		// List actions
		$this->ListActions = new cListActions();
	}

	//
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// User profile
		$UserProfile = new cUserProfile();

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanList()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			$this->Page_Terminate(ew_GetUrl("index.php"));
		}

		// NOTE: Security object may be needed in other part of the script, skip set to Nothing
		// 
		// Security = null;
		// 
		// Get export parameters

		$custom = "";
		if (@$_GET["export"] <> "") {
			$this->Export = $_GET["export"];
			$custom = @$_GET["custom"];
		} elseif (@$_POST["export"] <> "") {
			$this->Export = $_POST["export"];
			$custom = @$_POST["custom"];
		} elseif (ew_IsPost()) {
			if (@$_POST["exporttype"] <> "")
				$this->Export = $_POST["exporttype"];
			$custom = @$_POST["custom"];
		} elseif (@$_GET["cmd"] == "json") {
			$this->Export = $_GET["cmd"];
		} else {
			$this->setExportReturnUrl(ew_CurrentUrl());
		}
		$gsExportFile = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->Export <> "" && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$gsCustomExport = $this->CustomExport;
		$gsExport = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined("EW_USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined("EW_USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action

		// Get grid add count
		$gridaddcnt = @$_GET[EW_TABLE_GRID_ADD_ROW_COUNT];
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->SetupListOptions();

		// Setup export options
		$this->SetupExportOptions();
		$this->K0->SetVisibility();
		$this->K1->SetVisibility();
		$this->K2->SetVisibility();
		$this->K3->SetVisibility();
		$this->K4->SetVisibility();
		$this->K5->SetVisibility();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();

		// Setup other options
		$this->SetupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->Add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == EW_ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $hirarki_bibit;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($hirarki_bibit);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		// Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			ew_SaveDebugMsg();
			header("Location: " . $url);
		}
		exit();
	}

	// Class variables
	var $ListOptions; // List options
	var $ExportOptions; // Export options
	var $SearchOptions; // Search options
	var $OtherOptions = array(); // Other options
	var $FilterOptions; // Filter options
	var $ListActions; // List actions
	var $SelectedCount = 0;
	var $SelectedIndex = 0;
	var $DisplayRecs = 100;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $Pager;
	var $AutoHidePager = EW_AUTO_HIDE_PAGER;
	var $AutoHidePageSizeSelector = EW_AUTO_HIDE_PAGE_SIZE_SELECTOR;
	var $DefaultSearchWhere = ""; // Default search WHERE clause
	var $SearchWhere = ""; // Search WHERE clause
	var $RecCnt = 0; // Record count
	var $EditRowCnt;
	var $StartRowCnt = 1;
	var $RowCnt = 0;
	var $Attrs = array(); // Row attributes and cell attributes
	var $RowIndex = 0; // Row index
	var $KeyCount = 0; // Key count
	var $RowAction = ""; // Row action
	var $RowOldKey = ""; // Row old key (for copy)
	var $RecPerRow = 0;
	var $MultiColumnClass;
	var $MultiColumnEditClass = "col-sm-12";
	var $MultiColumnCnt = 12;
	var $MultiColumnEditCnt = 12;
	var $GridCnt = 0;
	var $ColCnt = 0;
	var $DbMasterFilter = ""; // Master filter
	var $DbDetailFilter = ""; // Detail filter
	var $MasterRecordExists;
	var $MultiSelectKey;
	var $Command;
	var $RestoreSearch = FALSE;
	var $DetailPages;
	var $Recordset;
	var $OldRecordset;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError, $gsSearchError, $Security, $EW_EXPORT;

		// Search filters
		$sSrchAdvanced = ""; // Advanced search filter
		$sSrchBasic = ""; // Basic search filter
		$sFilter = "";

		// Get command
		$this->Command = strtolower(@$_GET["cmd"]);
		if ($this->IsPageRequest()) { // Validate request

			// Process list action first
			if ($this->ProcessListAction()) // Ajax request
				$this->Page_Terminate();

			// Handle reset command
			$this->ResetCmd();

			// Set up Breadcrumb
			if ($this->Export == "")
				$this->SetupBreadcrumb();

			// Hide list options
			if ($this->Export <> "") {
				$this->ListOptions->HideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->CurrentAction == "gridadd" || $this->CurrentAction == "gridedit") {
				$this->ListOptions->HideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->Export <> "" || $this->CurrentAction <> "") {
				$this->ExportOptions->HideAllOptions();
				$this->FilterOptions->HideAllOptions();
			}

			// Hide other options
			if ($this->Export <> "") {
				foreach ($this->OtherOptions as &$option)
					$option->HideAllOptions();
			}

			// Get default search criteria
			ew_AddFilter($this->DefaultSearchWhere, $this->BasicSearchWhere(TRUE));
			ew_AddFilter($this->DefaultSearchWhere, $this->AdvancedSearchWhere(TRUE));

			// Get basic search values
			$this->LoadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->LoadSearchValues(); // Get search values

			// Process filter list
			$this->ProcessFilterList();
			if (!$this->ValidateSearch())
				$this->setFailureMessage($gsSearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->Export <> "" || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->CheckSearchParms())
				$this->RestoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->SetupSortOrder();

			// Get basic search criteria
			if ($gsSearchError == "")
				$sSrchBasic = $this->BasicSearchWhere();

			// Get search criteria for advanced search
			if ($gsSearchError == "")
				$sSrchAdvanced = $this->AdvancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 100; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->LoadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->CheckSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->LoadDefault();
			if ($this->BasicSearch->Keyword != "")
				$sSrchBasic = $this->BasicSearchWhere();

			// Load advanced search from default
			if ($this->LoadAdvancedSearchDefault()) {
				$sSrchAdvanced = $this->AdvancedSearchWhere();
			}
		}

		// Build search criteria
		ew_AddFilter($this->SearchWhere, $sSrchAdvanced);
		ew_AddFilter($this->SearchWhere, $sSrchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$sFilter = "";
		if (!$Security->CanList())
			$sFilter = "(0=1)"; // Filter all records
		ew_AddFilter($sFilter, $this->DbDetailFilter);
		ew_AddFilter($sFilter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSQL = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $sFilter;
		} else {
			$this->setSessionWhere($sFilter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if ($this->CustomExport == "" && in_array($this->Export, array_keys($EW_EXPORT))) {
			$this->ExportData();
			$this->Page_Terminate(); // Terminate response
			exit();
		}

		// Load record count first
		if (!$this->IsAddOrEdit()) {
			$bSelectLimit = $this->UseSelectLimit;
			if ($bSelectLimit) {
				$this->TotalRecs = $this->ListRecordCount();
			} else {
				if ($this->Recordset = $this->LoadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
		}

		// Search options
		$this->SetupSearchOptions();
	}

	// Build filter for all keys
	function BuildKeyFilter() {
		global $objForm;
		$sWrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$objForm->Index = $rowindex;
		$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		while ($sThisKey <> "") {
			if ($this->SetupKeyValues($sThisKey)) {
				$sFilter = $this->KeyFilter();
				if ($sWrkFilter <> "") $sWrkFilter .= " OR ";
				$sWrkFilter .= $sFilter;
			} else {
				$sWrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$objForm->Index = $rowindex;
			$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		}
		return $sWrkFilter;
	}

	// Set up key values
	function SetupKeyValues($key) {
		$arrKeyFlds = explode($GLOBALS["EW_COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arrKeyFlds) >= 0) {
		}
		return TRUE;
	}

	// Get list of filters
	function GetFilterList() {
		global $UserProfile;

		// Initialize
		$sFilterList = "";
		$sSavedFilterList = "";
		$sFilterList = ew_Concat($sFilterList, $this->K0->AdvancedSearch->ToJson(), ","); // Field K0
		$sFilterList = ew_Concat($sFilterList, $this->K1->AdvancedSearch->ToJson(), ","); // Field K1
		$sFilterList = ew_Concat($sFilterList, $this->K2->AdvancedSearch->ToJson(), ","); // Field K2
		$sFilterList = ew_Concat($sFilterList, $this->K3->AdvancedSearch->ToJson(), ","); // Field K3
		$sFilterList = ew_Concat($sFilterList, $this->K4->AdvancedSearch->ToJson(), ","); // Field K4
		$sFilterList = ew_Concat($sFilterList, $this->K5->AdvancedSearch->ToJson(), ","); // Field K5
		if ($this->BasicSearch->Keyword <> "") {
			$sWrk = "\"" . EW_TABLE_BASIC_SEARCH . "\":\"" . ew_JsEncode2($this->BasicSearch->Keyword) . "\",\"" . EW_TABLE_BASIC_SEARCH_TYPE . "\":\"" . ew_JsEncode2($this->BasicSearch->Type) . "\"";
			$sFilterList = ew_Concat($sFilterList, $sWrk, ",");
		}
		$sFilterList = preg_replace('/,$/', "", $sFilterList);

		// Return filter list in json
		if ($sFilterList <> "")
			$sFilterList = "\"data\":{" . $sFilterList . "}";
		if ($sSavedFilterList <> "") {
			if ($sFilterList <> "")
				$sFilterList .= ",";
			$sFilterList .= "\"filters\":" . $sSavedFilterList;
		}
		return ($sFilterList <> "") ? "{" . $sFilterList . "}" : "null";
	}

	// Process filter list
	function ProcessFilterList() {
		global $UserProfile;
		if (@$_POST["ajax"] == "savefilters") { // Save filter request (Ajax)
			$filters = @$_POST["filters"];
			$UserProfile->SetSearchFilters(CurrentUserName(), "fhirarki_bibitlistsrch", $filters);

			// Clean output buffer
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			echo ew_ArrayToJson(array(array("success" => TRUE))); // Success
			$this->Page_Terminate();
			exit();
		} elseif (@$_POST["cmd"] == "resetfilter") {
			$this->RestoreFilterList();
		}
	}

	// Restore list of filters
	function RestoreFilterList() {

		// Return if not reset filter
		if (@$_POST["cmd"] <> "resetfilter")
			return FALSE;
		$filter = json_decode(@$_POST["filter"], TRUE);
		$this->Command = "search";

		// Field K0
		$this->K0->AdvancedSearch->SearchValue = @$filter["x_K0"];
		$this->K0->AdvancedSearch->SearchOperator = @$filter["z_K0"];
		$this->K0->AdvancedSearch->SearchCondition = @$filter["v_K0"];
		$this->K0->AdvancedSearch->SearchValue2 = @$filter["y_K0"];
		$this->K0->AdvancedSearch->SearchOperator2 = @$filter["w_K0"];
		$this->K0->AdvancedSearch->Save();

		// Field K1
		$this->K1->AdvancedSearch->SearchValue = @$filter["x_K1"];
		$this->K1->AdvancedSearch->SearchOperator = @$filter["z_K1"];
		$this->K1->AdvancedSearch->SearchCondition = @$filter["v_K1"];
		$this->K1->AdvancedSearch->SearchValue2 = @$filter["y_K1"];
		$this->K1->AdvancedSearch->SearchOperator2 = @$filter["w_K1"];
		$this->K1->AdvancedSearch->Save();

		// Field K2
		$this->K2->AdvancedSearch->SearchValue = @$filter["x_K2"];
		$this->K2->AdvancedSearch->SearchOperator = @$filter["z_K2"];
		$this->K2->AdvancedSearch->SearchCondition = @$filter["v_K2"];
		$this->K2->AdvancedSearch->SearchValue2 = @$filter["y_K2"];
		$this->K2->AdvancedSearch->SearchOperator2 = @$filter["w_K2"];
		$this->K2->AdvancedSearch->Save();

		// Field K3
		$this->K3->AdvancedSearch->SearchValue = @$filter["x_K3"];
		$this->K3->AdvancedSearch->SearchOperator = @$filter["z_K3"];
		$this->K3->AdvancedSearch->SearchCondition = @$filter["v_K3"];
		$this->K3->AdvancedSearch->SearchValue2 = @$filter["y_K3"];
		$this->K3->AdvancedSearch->SearchOperator2 = @$filter["w_K3"];
		$this->K3->AdvancedSearch->Save();

		// Field K4
		$this->K4->AdvancedSearch->SearchValue = @$filter["x_K4"];
		$this->K4->AdvancedSearch->SearchOperator = @$filter["z_K4"];
		$this->K4->AdvancedSearch->SearchCondition = @$filter["v_K4"];
		$this->K4->AdvancedSearch->SearchValue2 = @$filter["y_K4"];
		$this->K4->AdvancedSearch->SearchOperator2 = @$filter["w_K4"];
		$this->K4->AdvancedSearch->Save();

		// Field K5
		$this->K5->AdvancedSearch->SearchValue = @$filter["x_K5"];
		$this->K5->AdvancedSearch->SearchOperator = @$filter["z_K5"];
		$this->K5->AdvancedSearch->SearchCondition = @$filter["v_K5"];
		$this->K5->AdvancedSearch->SearchValue2 = @$filter["y_K5"];
		$this->K5->AdvancedSearch->SearchOperator2 = @$filter["w_K5"];
		$this->K5->AdvancedSearch->Save();
		$this->BasicSearch->setKeyword(@$filter[EW_TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[EW_TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	function AdvancedSearchWhere($Default = FALSE) {
		global $Security;
		$sWhere = "";
		if (!$Security->CanSearch()) return "";
		$this->BuildSearchSql($sWhere, $this->K0, $Default, FALSE); // K0
		$this->BuildSearchSql($sWhere, $this->K1, $Default, FALSE); // K1
		$this->BuildSearchSql($sWhere, $this->K2, $Default, FALSE); // K2
		$this->BuildSearchSql($sWhere, $this->K3, $Default, FALSE); // K3
		$this->BuildSearchSql($sWhere, $this->K4, $Default, FALSE); // K4
		$this->BuildSearchSql($sWhere, $this->K5, $Default, FALSE); // K5

		// Set up search parm
		if (!$Default && $sWhere <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$Default && $this->Command == "search") {
			$this->K0->AdvancedSearch->Save(); // K0
			$this->K1->AdvancedSearch->Save(); // K1
			$this->K2->AdvancedSearch->Save(); // K2
			$this->K3->AdvancedSearch->Save(); // K3
			$this->K4->AdvancedSearch->Save(); // K4
			$this->K5->AdvancedSearch->Save(); // K5
		}
		return $sWhere;
	}

	// Build search SQL
	function BuildSearchSql(&$Where, &$Fld, $Default, $MultiValue) {
		$FldParm = $Fld->FldParm();
		$FldVal = ($Default) ? $Fld->AdvancedSearch->SearchValueDefault : $Fld->AdvancedSearch->SearchValue; // @$_GET["x_$FldParm"]
		$FldOpr = ($Default) ? $Fld->AdvancedSearch->SearchOperatorDefault : $Fld->AdvancedSearch->SearchOperator; // @$_GET["z_$FldParm"]
		$FldCond = ($Default) ? $Fld->AdvancedSearch->SearchConditionDefault : $Fld->AdvancedSearch->SearchCondition; // @$_GET["v_$FldParm"]
		$FldVal2 = ($Default) ? $Fld->AdvancedSearch->SearchValue2Default : $Fld->AdvancedSearch->SearchValue2; // @$_GET["y_$FldParm"]
		$FldOpr2 = ($Default) ? $Fld->AdvancedSearch->SearchOperator2Default : $Fld->AdvancedSearch->SearchOperator2; // @$_GET["w_$FldParm"]
		$sWrk = "";
		if (is_array($FldVal)) $FldVal = implode(",", $FldVal);
		if (is_array($FldVal2)) $FldVal2 = implode(",", $FldVal2);
		$FldOpr = strtoupper(trim($FldOpr));
		if ($FldOpr == "") $FldOpr = "=";
		$FldOpr2 = strtoupper(trim($FldOpr2));
		if ($FldOpr2 == "") $FldOpr2 = "=";
		if (EW_SEARCH_MULTI_VALUE_OPTION == 1)
			$MultiValue = FALSE;
		if ($MultiValue) {
			$sWrk1 = ($FldVal <> "") ? ew_GetMultiSearchSql($Fld, $FldOpr, $FldVal, $this->DBID) : ""; // Field value 1
			$sWrk2 = ($FldVal2 <> "") ? ew_GetMultiSearchSql($Fld, $FldOpr2, $FldVal2, $this->DBID) : ""; // Field value 2
			$sWrk = $sWrk1; // Build final SQL
			if ($sWrk2 <> "")
				$sWrk = ($sWrk <> "") ? "($sWrk) $FldCond ($sWrk2)" : $sWrk2;
		} else {
			$FldVal = $this->ConvertSearchValue($Fld, $FldVal);
			$FldVal2 = $this->ConvertSearchValue($Fld, $FldVal2);
			$sWrk = ew_GetSearchSql($Fld, $FldVal, $FldOpr, $FldCond, $FldVal2, $FldOpr2, $this->DBID);
		}
		ew_AddFilter($Where, $sWrk);
	}

	// Convert search value
	function ConvertSearchValue(&$Fld, $FldVal) {
		if ($FldVal == EW_NULL_VALUE || $FldVal == EW_NOT_NULL_VALUE)
			return $FldVal;
		$Value = $FldVal;
		if ($Fld->FldDataType == EW_DATATYPE_BOOLEAN) {
			if ($FldVal <> "") $Value = ($FldVal == "1" || strtolower(strval($FldVal)) == "y" || strtolower(strval($FldVal)) == "t") ? $Fld->TrueValue : $Fld->FalseValue;
		} elseif ($Fld->FldDataType == EW_DATATYPE_DATE || $Fld->FldDataType == EW_DATATYPE_TIME) {
			if ($FldVal <> "") $Value = ew_UnFormatDateTime($FldVal, $Fld->FldDateTimeFormat);
		}
		return $Value;
	}

	// Return basic search SQL
	function BasicSearchSQL($arKeywords, $type) {
		$sWhere = "";
		$this->BuildBasicSearchSQL($sWhere, $this->K0, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->K1, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->K2, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->K3, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->K4, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->K5, $arKeywords, $type);
		return $sWhere;
	}

	// Build basic search SQL
	function BuildBasicSearchSQL(&$Where, &$Fld, $arKeywords, $type) {
		global $EW_BASIC_SEARCH_IGNORE_PATTERN;
		$sDefCond = ($type == "OR") ? "OR" : "AND";
		$arSQL = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$Keyword = $arKeywords[$i];
			$Keyword = trim($Keyword);
			if ($EW_BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$Keyword = preg_replace($EW_BASIC_SEARCH_IGNORE_PATTERN, "\\", $Keyword);
				$ar = explode("\\", $Keyword);
			} else {
				$ar = array($Keyword);
			}
			foreach ($ar as $Keyword) {
				if ($Keyword <> "") {
					$sWrk = "";
					if ($Keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j-1] = "OR";
					} elseif ($Keyword == EW_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NULL";
					} elseif ($Keyword == EW_NOT_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NOT NULL";
					} elseif ($Fld->FldIsVirtual) {
						$sWrk = $Fld->FldVirtualExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					} elseif ($Fld->FldDataType != EW_DATATYPE_NUMBER || is_numeric($Keyword)) {
						$sWrk = $Fld->FldBasicSearchExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					}
					if ($sWrk <> "") {
						$arSQL[$j] = $sWrk;
						$arCond[$j] = $sDefCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSQL);
		$bQuoted = FALSE;
		$sSql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt-1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$bQuoted) $sSql .= "(";
					$bQuoted = TRUE;
				}
				$sSql .= $arSQL[$i];
				if ($bQuoted && $arCond[$i] <> "OR") {
					$sSql .= ")";
					$bQuoted = FALSE;
				}
				$sSql .= " " . $arCond[$i] . " ";
			}
			$sSql .= $arSQL[$cnt-1];
			if ($bQuoted)
				$sSql .= ")";
		}
		if ($sSql <> "") {
			if ($Where <> "") $Where .= " OR ";
			$Where .= "(" . $sSql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	function BasicSearchWhere($Default = FALSE) {
		global $Security;
		$sSearchStr = "";
		if (!$Security->CanSearch()) return "";
		$sSearchKeyword = ($Default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$sSearchType = ($Default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($sSearchKeyword <> "") {
			$ar = $this->BasicSearch->KeywordList($Default);

			// Search keyword in any fields
			if (($sSearchType == "OR" || $sSearchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $sKeyword) {
					if ($sKeyword <> "") {
						if ($sSearchStr <> "") $sSearchStr .= " " . $sSearchType . " ";
						$sSearchStr .= "(" . $this->BasicSearchSQL(array($sKeyword), $sSearchType) . ")";
					}
				}
			} else {
				$sSearchStr = $this->BasicSearchSQL($ar, $sSearchType);
			}
			if (!$Default && in_array($this->Command, array("", "reset", "resetall"))) $this->Command = "search";
		}
		if (!$Default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($sSearchKeyword);
			$this->BasicSearch->setType($sSearchType);
		}
		return $sSearchStr;
	}

	// Check if search parm exists
	function CheckSearchParms() {

		// Check basic search
		if ($this->BasicSearch->IssetSession())
			return TRUE;
		if ($this->K0->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->K1->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->K2->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->K3->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->K4->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->K5->AdvancedSearch->IssetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	function ResetSearchParms() {

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->ResetBasicSearchParms();

		// Clear advanced search parameters
		$this->ResetAdvancedSearchParms();
	}

	// Load advanced search default values
	function LoadAdvancedSearchDefault() {
		return FALSE;
	}

	// Clear all basic search parameters
	function ResetBasicSearchParms() {
		$this->BasicSearch->UnsetSession();
	}

	// Clear all advanced search parameters
	function ResetAdvancedSearchParms() {
		$this->K0->AdvancedSearch->UnsetSession();
		$this->K1->AdvancedSearch->UnsetSession();
		$this->K2->AdvancedSearch->UnsetSession();
		$this->K3->AdvancedSearch->UnsetSession();
		$this->K4->AdvancedSearch->UnsetSession();
		$this->K5->AdvancedSearch->UnsetSession();
	}

	// Restore all search parameters
	function RestoreSearchParms() {
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->Load();

		// Restore advanced search values
		$this->K0->AdvancedSearch->Load();
		$this->K1->AdvancedSearch->Load();
		$this->K2->AdvancedSearch->Load();
		$this->K3->AdvancedSearch->Load();
		$this->K4->AdvancedSearch->Load();
		$this->K5->AdvancedSearch->Load();
	}

	// Set up sort parameters
	function SetupSortOrder() {

		// Check for "order" parameter
		if (@$_GET["order"] <> "") {
			$this->CurrentOrder = @$_GET["order"];
			$this->CurrentOrderType = @$_GET["ordertype"];
			$this->UpdateSort($this->K0); // K0
			$this->UpdateSort($this->K1); // K1
			$this->UpdateSort($this->K2); // K2
			$this->UpdateSort($this->K3); // K3
			$this->UpdateSort($this->K4); // K4
			$this->UpdateSort($this->K5); // K5
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	function LoadSortOrder() {
		$sOrderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($sOrderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$sOrderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($sOrderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)
	function ResetCmd() {

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->ResetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$sOrderBy = "";
				$this->setSessionOrderBy($sOrderBy);
				$this->K0->setSort("");
				$this->K1->setSort("");
				$this->K2->setSort("");
				$this->K3->setSort("");
				$this->K4->setSort("");
				$this->K5->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	function SetupListOptions() {
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->Add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// List actions
		$item = &$this->ListOptions->Add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->Add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew_SelectAllKey(this);\">";
		$item->MoveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseImageAndText = TRUE;
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->Phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		if ($this->ListOptions->UseButtonGroup && ew_IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;
		$this->ListOptions->ButtonClass = "btn-sm"; // Class for button group

		// Call ListOptions_Load event
		$this->ListOptions_Load();
		$this->SetupListOptionsExt();
		$item = &$this->ListOptions->GetItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->GroupOptionVisible();
	}

	// Render list options
	function RenderListOptions() {
		global $Security, $Language, $objForm;
		$this->ListOptions->LoadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// Set up list action buttons
		$oListOpt = &$this->ListOptions->GetItem("listactions");
		if ($oListOpt && $this->Export == "" && $this->CurrentAction == "") {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode(str_replace(" ewIcon", "", $listaction->Icon)) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\"></span> " : "";
					$links[] = "<li><a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" title=\"" . ew_HtmlTitle($caption) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $Language->Phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default btn-sm ewActions\" title=\"" . ew_HtmlTitle($Language->Phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->Phrase("ListActionButton") . "<b class=\"caret\"></b></button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($oListOpt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$oListOpt->Body = $body;
				$oListOpt->Visible = TRUE;
			}
		}

		// "checkbox"
		$oListOpt = &$this->ListOptions->Items["checkbox"];
		$this->RenderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	function SetupOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseImageAndText = TRUE;
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;
			$option->ButtonClass = "btn-sm"; // Class for button group
			$item = &$option->Add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->Phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->Phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->Phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->Add("savecurrentfilter");
		$item->Body = "<a class=\"ewSaveFilter\" data-form=\"fhirarki_bibitlistsrch\" href=\"#\">" . $Language->Phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->Add("deletefilter");
		$item->Body = "<a class=\"ewDeleteFilter\" data-form=\"fhirarki_bibitlistsrch\" href=\"#\">" . $Language->Phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->Phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->Add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	function RenderOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_MULTIPLE) {
					$item = &$option->Add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode($listaction->Icon) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\"></span> " : $caption;
					$item->Body = "<a class=\"ewAction ewListAction\" title=\"" . ew_HtmlEncode($caption) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({f:document.fhirarki_bibitlist}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->GetItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->HideAllOptions();
			}
	}

	// Process list action
	function ProcessListAction() {
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$sFilter = $this->GetKeyFilter();
		$UserAction = @$_POST["useraction"];
		if ($sFilter <> "" && $UserAction <> "") {

			// Check permission first
			$ActionCaption = $UserAction;
			if (array_key_exists($UserAction, $this->ListActions->Items)) {
				$ActionCaption = $this->ListActions->Items[$UserAction]->Caption;
				if (!$this->ListActions->Items[$UserAction]->Allow) {
					$errmsg = str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionNotAllowed"));
					if (@$_POST["ajax"] == $UserAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $sFilter;
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			$rs = $conn->Execute($sSql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $UserAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->BeginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$Processed = $this->Row_CustomAction($UserAction, $row);
					if (!$Processed) break;
					$rs->MoveNext();
				}
				if ($Processed) {
					$conn->CommitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->RollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->Close();
			$this->CurrentAction = ""; // Clear action
			if (@$_POST["ajax"] == $UserAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->ClearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->ClearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	function SetupSearchOptions() {
		global $Language;
		$this->SearchOptions = new cListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ewSearchOption";

		// Search button
		$item = &$this->SearchOptions->Add("searchtoggle");
		$SearchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ewSearchToggle" . $SearchToggleClass . "\" title=\"" . $Language->Phrase("SearchPanel") . "\" data-caption=\"" . $Language->Phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fhirarki_bibitlistsrch\">" . $Language->Phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->Add("showall");
		$item->Body = "<a class=\"btn btn-default ewShowAll\" title=\"" . $Language->Phrase("ShowAll") . "\" data-caption=\"" . $Language->Phrase("ShowAll") . "\" href=\"" . $this->PageUrl() . "cmd=reset\">" . $Language->Phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseImageAndText = TRUE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->Phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->Add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->Export <> "" || $this->CurrentAction <> "")
			$this->SearchOptions->HideAllOptions();
		global $Security;
		if (!$Security->CanSearch()) {
			$this->SearchOptions->HideAllOptions();
			$this->FilterOptions->HideAllOptions();
		}
	}

	function SetupListOptionsExt() {
		global $Security, $Language;
	}

	function RenderListOptionsExt() {
		global $Security, $Language;
	}

	// Set up starting record parameters
	function SetupStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	function LoadBasicSearchValues() {
		$this->BasicSearch->Keyword = @$_GET[EW_TABLE_BASIC_SEARCH];
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "") $this->Command = "search";
		$this->BasicSearch->Type = @$_GET[EW_TABLE_BASIC_SEARCH_TYPE];
	}

	// Load search values for validation
	function LoadSearchValues() {
		global $objForm;

		// Load search values
		// K0

		$this->K0->AdvancedSearch->SearchValue = @$_GET["x_K0"];
		if ($this->K0->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->K0->AdvancedSearch->SearchOperator = @$_GET["z_K0"];

		// K1
		$this->K1->AdvancedSearch->SearchValue = @$_GET["x_K1"];
		if ($this->K1->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->K1->AdvancedSearch->SearchOperator = @$_GET["z_K1"];

		// K2
		$this->K2->AdvancedSearch->SearchValue = @$_GET["x_K2"];
		if ($this->K2->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->K2->AdvancedSearch->SearchOperator = @$_GET["z_K2"];

		// K3
		$this->K3->AdvancedSearch->SearchValue = @$_GET["x_K3"];
		if ($this->K3->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->K3->AdvancedSearch->SearchOperator = @$_GET["z_K3"];

		// K4
		$this->K4->AdvancedSearch->SearchValue = @$_GET["x_K4"];
		if ($this->K4->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->K4->AdvancedSearch->SearchOperator = @$_GET["z_K4"];

		// K5
		$this->K5->AdvancedSearch->SearchValue = @$_GET["x_K5"];
		if ($this->K5->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->K5->AdvancedSearch->SearchOperator = @$_GET["z_K5"];
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {

		// Load List page SQL
		$sSql = $this->ListSQL();
		$conn = &$this->Connection();

		// Load recordset
		$dbtype = ew_GetConnectionType($this->DBID);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset, array("_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())));
			} else {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = ew_LoadRecordset($sSql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues($rs = NULL) {
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->NewRow(); 

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->K0->setDbValue($row['K0']);
		$this->K1->setDbValue($row['K1']);
		$this->K2->setDbValue($row['K2']);
		$this->K3->setDbValue($row['K3']);
		$this->K4->setDbValue($row['K4']);
		$this->K5->setDbValue($row['K5']);
	}

	// Return a row with default values
	function NewRow() {
		$row = array();
		$row['K0'] = NULL;
		$row['K1'] = NULL;
		$row['K2'] = NULL;
		$row['K3'] = NULL;
		$row['K4'] = NULL;
		$row['K5'] = NULL;
		return $row;
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->K0->DbValue = $row['K0'];
		$this->K1->DbValue = $row['K1'];
		$this->K2->DbValue = $row['K2'];
		$this->K3->DbValue = $row['K3'];
		$this->K4->DbValue = $row['K4'];
		$this->K5->DbValue = $row['K5'];
	}

	// Load old record
	function LoadOldRecord() {
		return FALSE;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->GetViewUrl();
		$this->EditUrl = $this->GetEditUrl();
		$this->InlineEditUrl = $this->GetInlineEditUrl();
		$this->CopyUrl = $this->GetCopyUrl();
		$this->InlineCopyUrl = $this->GetInlineCopyUrl();
		$this->DeleteUrl = $this->GetDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// K0
		// K1
		// K2
		// K3
		// K4
		// K5

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// K0
		$this->K0->ViewValue = $this->K0->CurrentValue;
		$this->K0->ViewCustomAttributes = "";

		// K1
		$this->K1->ViewValue = $this->K1->CurrentValue;
		$this->K1->ViewCustomAttributes = "";

		// K2
		$this->K2->ViewValue = $this->K2->CurrentValue;
		$this->K2->ViewCustomAttributes = "";

		// K3
		$this->K3->ViewValue = $this->K3->CurrentValue;
		$this->K3->ViewCustomAttributes = "";

		// K4
		$this->K4->ViewValue = $this->K4->CurrentValue;
		$this->K4->ViewCustomAttributes = "";

		// K5
		$this->K5->ViewValue = $this->K5->CurrentValue;
		$this->K5->ViewCustomAttributes = "";

			// K0
			$this->K0->LinkCustomAttributes = "";
			$this->K0->HrefValue = "";
			$this->K0->TooltipValue = "";

			// K1
			$this->K1->LinkCustomAttributes = "";
			$this->K1->HrefValue = "";
			$this->K1->TooltipValue = "";

			// K2
			$this->K2->LinkCustomAttributes = "";
			$this->K2->HrefValue = "";
			$this->K2->TooltipValue = "";

			// K3
			$this->K3->LinkCustomAttributes = "";
			$this->K3->HrefValue = "";
			$this->K3->TooltipValue = "";

			// K4
			$this->K4->LinkCustomAttributes = "";
			$this->K4->HrefValue = "";
			$this->K4->TooltipValue = "";

			// K5
			$this->K5->LinkCustomAttributes = "";
			$this->K5->HrefValue = "";
			$this->K5->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_SEARCH) { // Search row

			// K0
			$this->K0->EditAttrs["class"] = "form-control";
			$this->K0->EditCustomAttributes = "";
			$this->K0->EditValue = ew_HtmlEncode($this->K0->AdvancedSearch->SearchValue);
			$this->K0->PlaceHolder = ew_RemoveHtml($this->K0->FldCaption());

			// K1
			$this->K1->EditAttrs["class"] = "form-control";
			$this->K1->EditCustomAttributes = "";
			$this->K1->EditValue = ew_HtmlEncode($this->K1->AdvancedSearch->SearchValue);
			$this->K1->PlaceHolder = ew_RemoveHtml($this->K1->FldCaption());

			// K2
			$this->K2->EditAttrs["class"] = "form-control";
			$this->K2->EditCustomAttributes = "";
			$this->K2->EditValue = ew_HtmlEncode($this->K2->AdvancedSearch->SearchValue);
			$this->K2->PlaceHolder = ew_RemoveHtml($this->K2->FldCaption());

			// K3
			$this->K3->EditAttrs["class"] = "form-control";
			$this->K3->EditCustomAttributes = "";
			$this->K3->EditValue = ew_HtmlEncode($this->K3->AdvancedSearch->SearchValue);
			$this->K3->PlaceHolder = ew_RemoveHtml($this->K3->FldCaption());

			// K4
			$this->K4->EditAttrs["class"] = "form-control";
			$this->K4->EditCustomAttributes = "";
			$this->K4->EditValue = ew_HtmlEncode($this->K4->AdvancedSearch->SearchValue);
			$this->K4->PlaceHolder = ew_RemoveHtml($this->K4->FldCaption());

			// K5
			$this->K5->EditAttrs["class"] = "form-control";
			$this->K5->EditCustomAttributes = "";
			$this->K5->EditValue = ew_HtmlEncode($this->K5->AdvancedSearch->SearchValue);
			$this->K5->PlaceHolder = ew_RemoveHtml($this->K5->FldCaption());
		}
		if ($this->RowType == EW_ROWTYPE_ADD || $this->RowType == EW_ROWTYPE_EDIT || $this->RowType == EW_ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->SetupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	function ValidateSearch() {
		global $gsSearchError;

		// Initialize
		$gsSearchError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return TRUE;

		// Return validate result
		$ValidateSearch = ($gsSearchError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateSearch = $ValidateSearch && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsSearchError, $sFormCustomError);
		}
		return $ValidateSearch;
	}

	// Load advanced search
	function LoadAdvancedSearch() {
		$this->K0->AdvancedSearch->Load();
		$this->K1->AdvancedSearch->Load();
		$this->K2->AdvancedSearch->Load();
		$this->K3->AdvancedSearch->Load();
		$this->K4->AdvancedSearch->Load();
		$this->K5->AdvancedSearch->Load();
	}

	// Set up export options
	function SetupExportOptions() {
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->Add("print");
		$item->Body = "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ewExportLink ewPrint\" title=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\">" . $Language->Phrase("PrinterFriendly") . "</a>";
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->Add("excel");
		$item->Body = "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ewExportLink ewExcel\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\">" . $Language->Phrase("ExportToExcel") . "</a>";
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->Add("word");
		$item->Body = "<a href=\"" . $this->ExportWordUrl . "\" class=\"ewExportLink ewWord\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\">" . $Language->Phrase("ExportToWord") . "</a>";
		$item->Visible = TRUE;

		// Export to Html
		$item = &$this->ExportOptions->Add("html");
		$item->Body = "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ewExportLink ewHtml\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\">" . $Language->Phrase("ExportToHtml") . "</a>";
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->Add("xml");
		$item->Body = "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ewExportLink ewXml\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\">" . $Language->Phrase("ExportToXml") . "</a>";
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->Add("csv");
		$item->Body = "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ewExportLink ewCsv\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\">" . $Language->Phrase("ExportToCsv") . "</a>";
		$item->Visible = FALSE;

		// Export to Pdf
		$item = &$this->ExportOptions->Add("pdf");
		$item->Body = "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ewExportLink ewPdf\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\">" . $Language->Phrase("ExportToPDF") . "</a>";
		$item->Visible = FALSE;

		// Export to Email
		$item = &$this->ExportOptions->Add("email");
		$url = "";
		$item->Body = "<button id=\"emf_hirarki_bibit\" class=\"ewExportLink ewEmail\" title=\"" . $Language->Phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->Phrase("ExportToEmailText") . "\" onclick=\"ew_EmailDialogShow({lnk:'emf_hirarki_bibit',hdr:ewLanguage.Phrase('ExportToEmailText'),f:document.fhirarki_bibitlist,sel:false" . $url . "});\">" . $Language->Phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseImageAndText = TRUE;
		$this->ExportOptions->UseDropDownButton = FALSE;
		if ($this->ExportOptions->UseButtonGroup && ew_IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->Phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->Add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	function ExportData() {
		$utf8 = (strtolower(EW_CHARSET) == "utf-8");
		$bSelectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($bSelectLimit) {
			$this->TotalRecs = $this->ListRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->LoadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EW_EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->SetupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($bSelectLimit)
			$rs = $this->LoadRecordset($this->StartRec-1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		if (!$rs) {
			header("Content-Type:"); // Remove header
			header("Content-Disposition:");
			$this->ShowMessage();
			return;
		}
		$this->ExportDoc = ew_ExportDocument($this, "h");
		$Doc = &$this->ExportDoc;
		if ($bSelectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		} else {

			//$this->StartRec = $this->StartRec;
			//$this->StopRec = $this->StopRec;

		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$ParentTable = "";
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		$Doc->Text .= $sHeader;
		$this->ExportDocument($Doc, $rs, $this->StartRec, $this->StopRec, "");
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		$Doc->Text .= $sFooter;

		// Close recordset
		$rs->Close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$Doc->ExportHeaderAndFooter();

		// Clean output buffer
		if (!EW_DEBUG_ENABLED && ob_get_length())
			ob_end_clean();

		// Write debug message if enabled
		if (EW_DEBUG_ENABLED && $this->Export <> "pdf")
			echo ew_DebugMsg();

		// Output data
		$Doc->Export();
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->Add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup filters of a field
	function SetupLookupFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		if ($pageId == "list") {
			switch ($fld->FldVar) {
			}
		} elseif ($pageId == "extbs") {
			switch ($fld->FldVar) {
			}
		}
	}

	// Setup AutoSuggest filters of a field
	function SetupAutoSuggestFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		if ($pageId == "list") {
			switch ($fld->FldVar) {
			}
		} elseif ($pageId == "extbs") {
			switch ($fld->FldVar) {
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($hirarki_bibit_list)) $hirarki_bibit_list = new chirarki_bibit_list();

// Page init
$hirarki_bibit_list->Page_Init();

// Page main
$hirarki_bibit_list->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$hirarki_bibit_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if ($hirarki_bibit->Export == "") { ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "list";
var CurrentForm = fhirarki_bibitlist = new ew_Form("fhirarki_bibitlist", "list");
fhirarki_bibitlist.FormKeyCountName = '<?php echo $hirarki_bibit_list->FormKeyCountName ?>';

// Form_CustomValidate event
fhirarki_bibitlist.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fhirarki_bibitlist.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var CurrentSearchForm = fhirarki_bibitlistsrch = new ew_Form("fhirarki_bibitlistsrch");

// Validate function for search
fhirarki_bibitlistsrch.Validate = function(fobj) {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	fobj = fobj || this.Form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fhirarki_bibitlistsrch.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fhirarki_bibitlistsrch.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Init search panel as collapsed

if (fhirarki_bibitlistsrch) fhirarki_bibitlistsrch.InitSearchPanel = true;
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if ($hirarki_bibit->Export == "") { ?>
<div class="ewToolbar">
<?php if ($hirarki_bibit_list->TotalRecs > 0 && $hirarki_bibit_list->ExportOptions->Visible()) { ?>
<?php $hirarki_bibit_list->ExportOptions->Render("body") ?>
<?php } ?>
<?php if ($hirarki_bibit_list->SearchOptions->Visible()) { ?>
<?php $hirarki_bibit_list->SearchOptions->Render("body") ?>
<?php } ?>
<?php if ($hirarki_bibit_list->FilterOptions->Visible()) { ?>
<?php $hirarki_bibit_list->FilterOptions->Render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
	$bSelectLimit = $hirarki_bibit_list->UseSelectLimit;
	if ($bSelectLimit) {
		if ($hirarki_bibit_list->TotalRecs <= 0)
			$hirarki_bibit_list->TotalRecs = $hirarki_bibit->ListRecordCount();
	} else {
		if (!$hirarki_bibit_list->Recordset && ($hirarki_bibit_list->Recordset = $hirarki_bibit_list->LoadRecordset()))
			$hirarki_bibit_list->TotalRecs = $hirarki_bibit_list->Recordset->RecordCount();
	}
	$hirarki_bibit_list->StartRec = 1;
	if ($hirarki_bibit_list->DisplayRecs <= 0 || ($hirarki_bibit->Export <> "" && $hirarki_bibit->ExportAll)) // Display all records
		$hirarki_bibit_list->DisplayRecs = $hirarki_bibit_list->TotalRecs;
	if (!($hirarki_bibit->Export <> "" && $hirarki_bibit->ExportAll))
		$hirarki_bibit_list->SetupStartRec(); // Set up start record position
	if ($bSelectLimit)
		$hirarki_bibit_list->Recordset = $hirarki_bibit_list->LoadRecordset($hirarki_bibit_list->StartRec-1, $hirarki_bibit_list->DisplayRecs);

	// Set no record found message
	if ($hirarki_bibit->CurrentAction == "" && $hirarki_bibit_list->TotalRecs == 0) {
		if (!$Security->CanList())
			$hirarki_bibit_list->setWarningMessage(ew_DeniedMsg());
		if ($hirarki_bibit_list->SearchWhere == "0=101")
			$hirarki_bibit_list->setWarningMessage($Language->Phrase("EnterSearchCriteria"));
		else
			$hirarki_bibit_list->setWarningMessage($Language->Phrase("NoRecord"));
	}
$hirarki_bibit_list->RenderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if ($hirarki_bibit->Export == "" && $hirarki_bibit->CurrentAction == "") { ?>
<form name="fhirarki_bibitlistsrch" id="fhirarki_bibitlistsrch" class="form-inline ewForm ewExtSearchForm" action="<?php echo ew_CurrentPage() ?>">
<?php $SearchPanelClass = ($hirarki_bibit_list->SearchWhere <> "") ? " in" : ""; ?>
<div id="fhirarki_bibitlistsrch_SearchPanel" class="ewSearchPanel collapse<?php echo $SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="hirarki_bibit">
	<div class="ewBasicSearch">
<?php
if ($gsSearchError == "")
	$hirarki_bibit_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$hirarki_bibit->RowType = EW_ROWTYPE_SEARCH;

// Render row
$hirarki_bibit->ResetAttrs();
$hirarki_bibit_list->RenderRow();
?>
<div id="xsr_1" class="ewRow">
<?php if ($hirarki_bibit->K0->Visible) { // K0 ?>
	<div id="xsc_K0" class="ewCell form-group">
		<label for="x_K0" class="ewSearchCaption ewLabel"><?php echo $hirarki_bibit->K0->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_K0" id="z_K0" value="LIKE"></span>
		<span class="ewSearchField">
<input type="text" data-table="hirarki_bibit" data-field="x_K0" name="x_K0" id="x_K0" size="30" maxlength="100" placeholder="<?php echo ew_HtmlEncode($hirarki_bibit->K0->getPlaceHolder()) ?>" value="<?php echo $hirarki_bibit->K0->EditValue ?>"<?php echo $hirarki_bibit->K0->EditAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ewRow">
<?php if ($hirarki_bibit->K1->Visible) { // K1 ?>
	<div id="xsc_K1" class="ewCell form-group">
		<label for="x_K1" class="ewSearchCaption ewLabel"><?php echo $hirarki_bibit->K1->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_K1" id="z_K1" value="LIKE"></span>
		<span class="ewSearchField">
<input type="text" data-table="hirarki_bibit" data-field="x_K1" name="x_K1" id="x_K1" size="30" maxlength="100" placeholder="<?php echo ew_HtmlEncode($hirarki_bibit->K1->getPlaceHolder()) ?>" value="<?php echo $hirarki_bibit->K1->EditValue ?>"<?php echo $hirarki_bibit->K1->EditAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ewRow">
<?php if ($hirarki_bibit->K2->Visible) { // K2 ?>
	<div id="xsc_K2" class="ewCell form-group">
		<label for="x_K2" class="ewSearchCaption ewLabel"><?php echo $hirarki_bibit->K2->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_K2" id="z_K2" value="LIKE"></span>
		<span class="ewSearchField">
<input type="text" data-table="hirarki_bibit" data-field="x_K2" name="x_K2" id="x_K2" size="30" maxlength="100" placeholder="<?php echo ew_HtmlEncode($hirarki_bibit->K2->getPlaceHolder()) ?>" value="<?php echo $hirarki_bibit->K2->EditValue ?>"<?php echo $hirarki_bibit->K2->EditAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ewRow">
<?php if ($hirarki_bibit->K3->Visible) { // K3 ?>
	<div id="xsc_K3" class="ewCell form-group">
		<label for="x_K3" class="ewSearchCaption ewLabel"><?php echo $hirarki_bibit->K3->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_K3" id="z_K3" value="LIKE"></span>
		<span class="ewSearchField">
<input type="text" data-table="hirarki_bibit" data-field="x_K3" name="x_K3" id="x_K3" size="30" maxlength="100" placeholder="<?php echo ew_HtmlEncode($hirarki_bibit->K3->getPlaceHolder()) ?>" value="<?php echo $hirarki_bibit->K3->EditValue ?>"<?php echo $hirarki_bibit->K3->EditAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_5" class="ewRow">
<?php if ($hirarki_bibit->K4->Visible) { // K4 ?>
	<div id="xsc_K4" class="ewCell form-group">
		<label for="x_K4" class="ewSearchCaption ewLabel"><?php echo $hirarki_bibit->K4->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_K4" id="z_K4" value="LIKE"></span>
		<span class="ewSearchField">
<input type="text" data-table="hirarki_bibit" data-field="x_K4" name="x_K4" id="x_K4" size="30" maxlength="100" placeholder="<?php echo ew_HtmlEncode($hirarki_bibit->K4->getPlaceHolder()) ?>" value="<?php echo $hirarki_bibit->K4->EditValue ?>"<?php echo $hirarki_bibit->K4->EditAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_6" class="ewRow">
<?php if ($hirarki_bibit->K5->Visible) { // K5 ?>
	<div id="xsc_K5" class="ewCell form-group">
		<label for="x_K5" class="ewSearchCaption ewLabel"><?php echo $hirarki_bibit->K5->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_K5" id="z_K5" value="LIKE"></span>
		<span class="ewSearchField">
<input type="text" data-table="hirarki_bibit" data-field="x_K5" name="x_K5" id="x_K5" size="30" maxlength="100" placeholder="<?php echo ew_HtmlEncode($hirarki_bibit->K5->getPlaceHolder()) ?>" value="<?php echo $hirarki_bibit->K5->EditValue ?>"<?php echo $hirarki_bibit->K5->EditAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_7" class="ewRow">
	<div class="ewQuickSearch input-group">
	<input type="text" name="<?php echo EW_TABLE_BASIC_SEARCH ?>" id="<?php echo EW_TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo ew_HtmlEncode($hirarki_bibit_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo ew_HtmlEncode($Language->Phrase("Search")) ?>">
	<input type="hidden" name="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo ew_HtmlEncode($hirarki_bibit_list->BasicSearch->getType()) ?>">
	<div class="input-group-btn">
		<button type="button" data-toggle="dropdown" class="btn btn-default"><span id="searchtype"><?php echo $hirarki_bibit_list->BasicSearch->getTypeNameShort() ?></span><span class="caret"></span></button>
		<ul class="dropdown-menu pull-right" role="menu">
			<li<?php if ($hirarki_bibit_list->BasicSearch->getType() == "") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this)"><?php echo $Language->Phrase("QuickSearchAuto") ?></a></li>
			<li<?php if ($hirarki_bibit_list->BasicSearch->getType() == "=") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'=')"><?php echo $Language->Phrase("QuickSearchExact") ?></a></li>
			<li<?php if ($hirarki_bibit_list->BasicSearch->getType() == "AND") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'AND')"><?php echo $Language->Phrase("QuickSearchAll") ?></a></li>
			<li<?php if ($hirarki_bibit_list->BasicSearch->getType() == "OR") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'OR')"><?php echo $Language->Phrase("QuickSearchAny") ?></a></li>
		</ul>
	<button class="btn btn-primary ewButton" name="btnsubmit" id="btnsubmit" type="submit"><?php echo $Language->Phrase("SearchBtn") ?></button>
	</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $hirarki_bibit_list->ShowPageHeader(); ?>
<?php
$hirarki_bibit_list->ShowMessage();
?>
<?php if ($hirarki_bibit_list->TotalRecs > 0 || $hirarki_bibit->CurrentAction <> "") { ?>
<div class="box ewBox ewGrid<?php if ($hirarki_bibit_list->IsAddOrEdit()) { ?> ewGridAddEdit<?php } ?> hirarki_bibit">
<?php if ($hirarki_bibit->Export == "") { ?>
<div class="box-header ewGridUpperPanel">
<?php if ($hirarki_bibit->CurrentAction <> "gridadd" && $hirarki_bibit->CurrentAction <> "gridedit") { ?>
<form name="ewPagerForm" class="form-inline ewForm ewPagerForm" action="<?php echo ew_CurrentPage() ?>">
<?php if (!isset($hirarki_bibit_list->Pager)) $hirarki_bibit_list->Pager = new cNumericPager($hirarki_bibit_list->StartRec, $hirarki_bibit_list->DisplayRecs, $hirarki_bibit_list->TotalRecs, $hirarki_bibit_list->RecRange, $hirarki_bibit_list->AutoHidePager) ?>
<?php if ($hirarki_bibit_list->Pager->RecordCount > 0 && $hirarki_bibit_list->Pager->Visible) { ?>
<div class="ewPager">
<div class="ewNumericPage"><ul class="pagination">
	<?php if ($hirarki_bibit_list->Pager->FirstButton->Enabled) { ?>
	<li><a href="<?php echo $hirarki_bibit_list->PageUrl() ?>start=<?php echo $hirarki_bibit_list->Pager->FirstButton->Start ?>"><?php echo $Language->Phrase("PagerFirst") ?></a></li>
	<?php } ?>
	<?php if ($hirarki_bibit_list->Pager->PrevButton->Enabled) { ?>
	<li><a href="<?php echo $hirarki_bibit_list->PageUrl() ?>start=<?php echo $hirarki_bibit_list->Pager->PrevButton->Start ?>"><?php echo $Language->Phrase("PagerPrevious") ?></a></li>
	<?php } ?>
	<?php foreach ($hirarki_bibit_list->Pager->Items as $PagerItem) { ?>
		<li<?php if (!$PagerItem->Enabled) { echo " class=\" active\""; } ?>><a href="<?php if ($PagerItem->Enabled) { echo $hirarki_bibit_list->PageUrl() . "start=" . $PagerItem->Start; } else { echo "#"; } ?>"><?php echo $PagerItem->Text ?></a></li>
	<?php } ?>
	<?php if ($hirarki_bibit_list->Pager->NextButton->Enabled) { ?>
	<li><a href="<?php echo $hirarki_bibit_list->PageUrl() ?>start=<?php echo $hirarki_bibit_list->Pager->NextButton->Start ?>"><?php echo $Language->Phrase("PagerNext") ?></a></li>
	<?php } ?>
	<?php if ($hirarki_bibit_list->Pager->LastButton->Enabled) { ?>
	<li><a href="<?php echo $hirarki_bibit_list->PageUrl() ?>start=<?php echo $hirarki_bibit_list->Pager->LastButton->Start ?>"><?php echo $Language->Phrase("PagerLast") ?></a></li>
	<?php } ?>
</ul></div>
</div>
<?php } ?>
<?php if ($hirarki_bibit_list->Pager->RecordCount > 0) { ?>
<div class="ewPager ewRec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $hirarki_bibit_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $hirarki_bibit_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $hirarki_bibit_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ewListOtherOptions">
<?php
	foreach ($hirarki_bibit_list->OtherOptions as &$option)
		$option->Render("body");
?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fhirarki_bibitlist" id="fhirarki_bibitlist" class="form-inline ewForm ewListForm" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($hirarki_bibit_list->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $hirarki_bibit_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="hirarki_bibit">
<div id="gmp_hirarki_bibit" class="<?php if (ew_IsResponsiveLayout()) { ?>table-responsive <?php } ?>ewGridMiddlePanel">
<?php if ($hirarki_bibit_list->TotalRecs > 0 || $hirarki_bibit->CurrentAction == "gridedit") { ?>
<table id="tbl_hirarki_bibitlist" class="table ewTable">
<thead>
	<tr class="ewTableHeader">
<?php

// Header row
$hirarki_bibit_list->RowType = EW_ROWTYPE_HEADER;

// Render list options
$hirarki_bibit_list->RenderListOptions();

// Render list options (header, left)
$hirarki_bibit_list->ListOptions->Render("header", "left");
?>
<?php if ($hirarki_bibit->K0->Visible) { // K0 ?>
	<?php if ($hirarki_bibit->SortUrl($hirarki_bibit->K0) == "") { ?>
		<th data-name="K0" class="<?php echo $hirarki_bibit->K0->HeaderCellClass() ?>"><div id="elh_hirarki_bibit_K0" class="hirarki_bibit_K0"><div class="ewTableHeaderCaption"><?php echo $hirarki_bibit->K0->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="K0" class="<?php echo $hirarki_bibit->K0->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $hirarki_bibit->SortUrl($hirarki_bibit->K0) ?>',1);"><div id="elh_hirarki_bibit_K0" class="hirarki_bibit_K0">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $hirarki_bibit->K0->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($hirarki_bibit->K0->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($hirarki_bibit->K0->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hirarki_bibit->K1->Visible) { // K1 ?>
	<?php if ($hirarki_bibit->SortUrl($hirarki_bibit->K1) == "") { ?>
		<th data-name="K1" class="<?php echo $hirarki_bibit->K1->HeaderCellClass() ?>"><div id="elh_hirarki_bibit_K1" class="hirarki_bibit_K1"><div class="ewTableHeaderCaption"><?php echo $hirarki_bibit->K1->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="K1" class="<?php echo $hirarki_bibit->K1->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $hirarki_bibit->SortUrl($hirarki_bibit->K1) ?>',1);"><div id="elh_hirarki_bibit_K1" class="hirarki_bibit_K1">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $hirarki_bibit->K1->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($hirarki_bibit->K1->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($hirarki_bibit->K1->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hirarki_bibit->K2->Visible) { // K2 ?>
	<?php if ($hirarki_bibit->SortUrl($hirarki_bibit->K2) == "") { ?>
		<th data-name="K2" class="<?php echo $hirarki_bibit->K2->HeaderCellClass() ?>"><div id="elh_hirarki_bibit_K2" class="hirarki_bibit_K2"><div class="ewTableHeaderCaption"><?php echo $hirarki_bibit->K2->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="K2" class="<?php echo $hirarki_bibit->K2->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $hirarki_bibit->SortUrl($hirarki_bibit->K2) ?>',1);"><div id="elh_hirarki_bibit_K2" class="hirarki_bibit_K2">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $hirarki_bibit->K2->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($hirarki_bibit->K2->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($hirarki_bibit->K2->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hirarki_bibit->K3->Visible) { // K3 ?>
	<?php if ($hirarki_bibit->SortUrl($hirarki_bibit->K3) == "") { ?>
		<th data-name="K3" class="<?php echo $hirarki_bibit->K3->HeaderCellClass() ?>"><div id="elh_hirarki_bibit_K3" class="hirarki_bibit_K3"><div class="ewTableHeaderCaption"><?php echo $hirarki_bibit->K3->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="K3" class="<?php echo $hirarki_bibit->K3->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $hirarki_bibit->SortUrl($hirarki_bibit->K3) ?>',1);"><div id="elh_hirarki_bibit_K3" class="hirarki_bibit_K3">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $hirarki_bibit->K3->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($hirarki_bibit->K3->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($hirarki_bibit->K3->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hirarki_bibit->K4->Visible) { // K4 ?>
	<?php if ($hirarki_bibit->SortUrl($hirarki_bibit->K4) == "") { ?>
		<th data-name="K4" class="<?php echo $hirarki_bibit->K4->HeaderCellClass() ?>"><div id="elh_hirarki_bibit_K4" class="hirarki_bibit_K4"><div class="ewTableHeaderCaption"><?php echo $hirarki_bibit->K4->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="K4" class="<?php echo $hirarki_bibit->K4->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $hirarki_bibit->SortUrl($hirarki_bibit->K4) ?>',1);"><div id="elh_hirarki_bibit_K4" class="hirarki_bibit_K4">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $hirarki_bibit->K4->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($hirarki_bibit->K4->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($hirarki_bibit->K4->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hirarki_bibit->K5->Visible) { // K5 ?>
	<?php if ($hirarki_bibit->SortUrl($hirarki_bibit->K5) == "") { ?>
		<th data-name="K5" class="<?php echo $hirarki_bibit->K5->HeaderCellClass() ?>"><div id="elh_hirarki_bibit_K5" class="hirarki_bibit_K5"><div class="ewTableHeaderCaption"><?php echo $hirarki_bibit->K5->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="K5" class="<?php echo $hirarki_bibit->K5->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $hirarki_bibit->SortUrl($hirarki_bibit->K5) ?>',1);"><div id="elh_hirarki_bibit_K5" class="hirarki_bibit_K5">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $hirarki_bibit->K5->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($hirarki_bibit->K5->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($hirarki_bibit->K5->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$hirarki_bibit_list->ListOptions->Render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($hirarki_bibit->ExportAll && $hirarki_bibit->Export <> "") {
	$hirarki_bibit_list->StopRec = $hirarki_bibit_list->TotalRecs;
} else {

	// Set the last record to display
	if ($hirarki_bibit_list->TotalRecs > $hirarki_bibit_list->StartRec + $hirarki_bibit_list->DisplayRecs - 1)
		$hirarki_bibit_list->StopRec = $hirarki_bibit_list->StartRec + $hirarki_bibit_list->DisplayRecs - 1;
	else
		$hirarki_bibit_list->StopRec = $hirarki_bibit_list->TotalRecs;
}
$hirarki_bibit_list->RecCnt = $hirarki_bibit_list->StartRec - 1;
if ($hirarki_bibit_list->Recordset && !$hirarki_bibit_list->Recordset->EOF) {
	$hirarki_bibit_list->Recordset->MoveFirst();
	$bSelectLimit = $hirarki_bibit_list->UseSelectLimit;
	if (!$bSelectLimit && $hirarki_bibit_list->StartRec > 1)
		$hirarki_bibit_list->Recordset->Move($hirarki_bibit_list->StartRec - 1);
} elseif (!$hirarki_bibit->AllowAddDeleteRow && $hirarki_bibit_list->StopRec == 0) {
	$hirarki_bibit_list->StopRec = $hirarki_bibit->GridAddRowCount;
}

// Initialize aggregate
$hirarki_bibit->RowType = EW_ROWTYPE_AGGREGATEINIT;
$hirarki_bibit->ResetAttrs();
$hirarki_bibit_list->RenderRow();
while ($hirarki_bibit_list->RecCnt < $hirarki_bibit_list->StopRec) {
	$hirarki_bibit_list->RecCnt++;
	if (intval($hirarki_bibit_list->RecCnt) >= intval($hirarki_bibit_list->StartRec)) {
		$hirarki_bibit_list->RowCnt++;

		// Set up key count
		$hirarki_bibit_list->KeyCount = $hirarki_bibit_list->RowIndex;

		// Init row class and style
		$hirarki_bibit->ResetAttrs();
		$hirarki_bibit->CssClass = "";
		if ($hirarki_bibit->CurrentAction == "gridadd") {
		} else {
			$hirarki_bibit_list->LoadRowValues($hirarki_bibit_list->Recordset); // Load row values
		}
		$hirarki_bibit->RowType = EW_ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$hirarki_bibit->RowAttrs = array_merge($hirarki_bibit->RowAttrs, array('data-rowindex'=>$hirarki_bibit_list->RowCnt, 'id'=>'r' . $hirarki_bibit_list->RowCnt . '_hirarki_bibit', 'data-rowtype'=>$hirarki_bibit->RowType));

		// Render row
		$hirarki_bibit_list->RenderRow();

		// Render list options
		$hirarki_bibit_list->RenderListOptions();
?>
	<tr<?php echo $hirarki_bibit->RowAttributes() ?>>
<?php

// Render list options (body, left)
$hirarki_bibit_list->ListOptions->Render("body", "left", $hirarki_bibit_list->RowCnt);
?>
	<?php if ($hirarki_bibit->K0->Visible) { // K0 ?>
		<td data-name="K0"<?php echo $hirarki_bibit->K0->CellAttributes() ?>>
<span id="el<?php echo $hirarki_bibit_list->RowCnt ?>_hirarki_bibit_K0" class="hirarki_bibit_K0">
<span<?php echo $hirarki_bibit->K0->ViewAttributes() ?>>
<?php echo $hirarki_bibit->K0->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hirarki_bibit->K1->Visible) { // K1 ?>
		<td data-name="K1"<?php echo $hirarki_bibit->K1->CellAttributes() ?>>
<span id="el<?php echo $hirarki_bibit_list->RowCnt ?>_hirarki_bibit_K1" class="hirarki_bibit_K1">
<span<?php echo $hirarki_bibit->K1->ViewAttributes() ?>>
<?php echo $hirarki_bibit->K1->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hirarki_bibit->K2->Visible) { // K2 ?>
		<td data-name="K2"<?php echo $hirarki_bibit->K2->CellAttributes() ?>>
<span id="el<?php echo $hirarki_bibit_list->RowCnt ?>_hirarki_bibit_K2" class="hirarki_bibit_K2">
<span<?php echo $hirarki_bibit->K2->ViewAttributes() ?>>
<?php echo $hirarki_bibit->K2->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hirarki_bibit->K3->Visible) { // K3 ?>
		<td data-name="K3"<?php echo $hirarki_bibit->K3->CellAttributes() ?>>
<span id="el<?php echo $hirarki_bibit_list->RowCnt ?>_hirarki_bibit_K3" class="hirarki_bibit_K3">
<span<?php echo $hirarki_bibit->K3->ViewAttributes() ?>>
<?php echo $hirarki_bibit->K3->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hirarki_bibit->K4->Visible) { // K4 ?>
		<td data-name="K4"<?php echo $hirarki_bibit->K4->CellAttributes() ?>>
<span id="el<?php echo $hirarki_bibit_list->RowCnt ?>_hirarki_bibit_K4" class="hirarki_bibit_K4">
<span<?php echo $hirarki_bibit->K4->ViewAttributes() ?>>
<?php echo $hirarki_bibit->K4->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hirarki_bibit->K5->Visible) { // K5 ?>
		<td data-name="K5"<?php echo $hirarki_bibit->K5->CellAttributes() ?>>
<span id="el<?php echo $hirarki_bibit_list->RowCnt ?>_hirarki_bibit_K5" class="hirarki_bibit_K5">
<span<?php echo $hirarki_bibit->K5->ViewAttributes() ?>>
<?php echo $hirarki_bibit->K5->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$hirarki_bibit_list->ListOptions->Render("body", "right", $hirarki_bibit_list->RowCnt);
?>
	</tr>
<?php
	}
	if ($hirarki_bibit->CurrentAction <> "gridadd")
		$hirarki_bibit_list->Recordset->MoveNext();
}
?>
</tbody>
</table>
<?php } ?>
<?php if ($hirarki_bibit->CurrentAction == "") { ?>
<input type="hidden" name="a_list" id="a_list" value="">
<?php } ?>
</div>
</form>
<?php

// Close recordset
if ($hirarki_bibit_list->Recordset)
	$hirarki_bibit_list->Recordset->Close();
?>
<?php if ($hirarki_bibit->Export == "") { ?>
<div class="box-footer ewGridLowerPanel">
<?php if ($hirarki_bibit->CurrentAction <> "gridadd" && $hirarki_bibit->CurrentAction <> "gridedit") { ?>
<form name="ewPagerForm" class="ewForm form-inline ewPagerForm" action="<?php echo ew_CurrentPage() ?>">
<?php if (!isset($hirarki_bibit_list->Pager)) $hirarki_bibit_list->Pager = new cNumericPager($hirarki_bibit_list->StartRec, $hirarki_bibit_list->DisplayRecs, $hirarki_bibit_list->TotalRecs, $hirarki_bibit_list->RecRange, $hirarki_bibit_list->AutoHidePager) ?>
<?php if ($hirarki_bibit_list->Pager->RecordCount > 0 && $hirarki_bibit_list->Pager->Visible) { ?>
<div class="ewPager">
<div class="ewNumericPage"><ul class="pagination">
	<?php if ($hirarki_bibit_list->Pager->FirstButton->Enabled) { ?>
	<li><a href="<?php echo $hirarki_bibit_list->PageUrl() ?>start=<?php echo $hirarki_bibit_list->Pager->FirstButton->Start ?>"><?php echo $Language->Phrase("PagerFirst") ?></a></li>
	<?php } ?>
	<?php if ($hirarki_bibit_list->Pager->PrevButton->Enabled) { ?>
	<li><a href="<?php echo $hirarki_bibit_list->PageUrl() ?>start=<?php echo $hirarki_bibit_list->Pager->PrevButton->Start ?>"><?php echo $Language->Phrase("PagerPrevious") ?></a></li>
	<?php } ?>
	<?php foreach ($hirarki_bibit_list->Pager->Items as $PagerItem) { ?>
		<li<?php if (!$PagerItem->Enabled) { echo " class=\" active\""; } ?>><a href="<?php if ($PagerItem->Enabled) { echo $hirarki_bibit_list->PageUrl() . "start=" . $PagerItem->Start; } else { echo "#"; } ?>"><?php echo $PagerItem->Text ?></a></li>
	<?php } ?>
	<?php if ($hirarki_bibit_list->Pager->NextButton->Enabled) { ?>
	<li><a href="<?php echo $hirarki_bibit_list->PageUrl() ?>start=<?php echo $hirarki_bibit_list->Pager->NextButton->Start ?>"><?php echo $Language->Phrase("PagerNext") ?></a></li>
	<?php } ?>
	<?php if ($hirarki_bibit_list->Pager->LastButton->Enabled) { ?>
	<li><a href="<?php echo $hirarki_bibit_list->PageUrl() ?>start=<?php echo $hirarki_bibit_list->Pager->LastButton->Start ?>"><?php echo $Language->Phrase("PagerLast") ?></a></li>
	<?php } ?>
</ul></div>
</div>
<?php } ?>
<?php if ($hirarki_bibit_list->Pager->RecordCount > 0) { ?>
<div class="ewPager ewRec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $hirarki_bibit_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $hirarki_bibit_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $hirarki_bibit_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ewListOtherOptions">
<?php
	foreach ($hirarki_bibit_list->OtherOptions as &$option)
		$option->Render("body", "bottom");
?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div>
<?php } ?>
<?php if ($hirarki_bibit_list->TotalRecs == 0 && $hirarki_bibit->CurrentAction == "") { // Show other options ?>
<div class="ewListOtherOptions">
<?php
	foreach ($hirarki_bibit_list->OtherOptions as &$option) {
		$option->ButtonClass = "";
		$option->Render("body", "");
	}
?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php if ($hirarki_bibit->Export == "") { ?>
<script type="text/javascript">
fhirarki_bibitlistsrch.FilterList = <?php echo $hirarki_bibit_list->GetFilterList() ?>;
fhirarki_bibitlistsrch.Init();
fhirarki_bibitlist.Init();
</script>
<?php } ?>
<?php
$hirarki_bibit_list->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<?php if ($hirarki_bibit->Export == "") { ?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$hirarki_bibit_list->Page_Terminate();
?>
