<?php

namespace PHPMaker2023\co;

// Page object
$LuasviewList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { luasview: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fluasviewsrch" id="fluasviewsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="on">
<div id="fluasviewsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { luasview: currentTable } });
var currentForm;
var fluasviewsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fluasviewsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["Pic", [], fields.Pic.isInvalid],
            ["varietas", [], fields.varietas.isInvalid],
            ["Provinsi", [], fields.Provinsi.isInvalid],
            ["Kabupaten", [], fields.Kabupaten.isInvalid],
            ["Koordinator", [], fields.Koordinator.isInvalid],
            ["Tahun", [ew.Validators.integer], fields.Tahun.isInvalid],
            ["y_Tahun", [ew.Validators.between], false],
            ["Bulan", [ew.Validators.integer], fields.Bulan.isInvalid],
            ["y_Bulan", [ew.Validators.between], false],
            ["Luas", [], fields.Luas.isInvalid],
            ["Estimasi_Panen", [], fields.Estimasi_Panen.isInvalid],
            ["Aktual_Panen", [], fields.Aktual_Panen.isInvalid],
            ["Rata_rata_Skor", [], fields.Rata_rata_Skor.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = ROWTYPE_SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->Pic->Visible) { // Pic ?>
<?php
if (!$Page->Pic->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Pic" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Pic->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_Pic" class="ew-search-caption ew-label"><?= $Page->Pic->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Pic" id="z_Pic" value="LIKE">
</div>
        </div>
        <div id="el_luasview_Pic" class="ew-search-field">
<input type="<?= $Page->Pic->getInputTextType() ?>" name="x_Pic" id="x_Pic" data-table="luasview" data-field="x_Pic" value="<?= $Page->Pic->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->Pic->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Pic->formatPattern()) ?>"<?= $Page->Pic->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Pic->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->varietas->Visible) { // varietas ?>
<?php
if (!$Page->varietas->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_varietas" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->varietas->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_varietas" class="ew-search-caption ew-label"><?= $Page->varietas->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_varietas" id="z_varietas" value="LIKE">
</div>
        </div>
        <div id="el_luasview_varietas" class="ew-search-field">
<input type="<?= $Page->varietas->getInputTextType() ?>" name="x_varietas" id="x_varietas" data-table="luasview" data-field="x_varietas" value="<?= $Page->varietas->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->varietas->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->varietas->formatPattern()) ?>"<?= $Page->varietas->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->varietas->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Provinsi->Visible) { // Provinsi ?>
<?php
if (!$Page->Provinsi->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Provinsi" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Provinsi->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_Provinsi" class="ew-search-caption ew-label"><?= $Page->Provinsi->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Provinsi" id="z_Provinsi" value="LIKE">
</div>
        </div>
        <div id="el_luasview_Provinsi" class="ew-search-field">
<input type="<?= $Page->Provinsi->getInputTextType() ?>" name="x_Provinsi" id="x_Provinsi" data-table="luasview" data-field="x_Provinsi" value="<?= $Page->Provinsi->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->Provinsi->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Provinsi->formatPattern()) ?>"<?= $Page->Provinsi->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Provinsi->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Kabupaten->Visible) { // Kabupaten ?>
<?php
if (!$Page->Kabupaten->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Kabupaten" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Kabupaten->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_Kabupaten" class="ew-search-caption ew-label"><?= $Page->Kabupaten->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kabupaten" id="z_Kabupaten" value="LIKE">
</div>
        </div>
        <div id="el_luasview_Kabupaten" class="ew-search-field">
<input type="<?= $Page->Kabupaten->getInputTextType() ?>" name="x_Kabupaten" id="x_Kabupaten" data-table="luasview" data-field="x_Kabupaten" value="<?= $Page->Kabupaten->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->Kabupaten->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Kabupaten->formatPattern()) ?>"<?= $Page->Kabupaten->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Kabupaten->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Koordinator->Visible) { // Koordinator ?>
<?php
if (!$Page->Koordinator->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Koordinator" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Koordinator->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_Koordinator" class="ew-search-caption ew-label"><?= $Page->Koordinator->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Koordinator" id="z_Koordinator" value="LIKE">
</div>
        </div>
        <div id="el_luasview_Koordinator" class="ew-search-field">
<input type="<?= $Page->Koordinator->getInputTextType() ?>" name="x_Koordinator" id="x_Koordinator" data-table="luasview" data-field="x_Koordinator" value="<?= $Page->Koordinator->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->Koordinator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Koordinator->formatPattern()) ?>"<?= $Page->Koordinator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Koordinator->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Tahun->Visible) { // Tahun ?>
<?php
if (!$Page->Tahun->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Tahun" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Tahun->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_Tahun" class="ew-search-caption ew-label"><?= $Page->Tahun->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_Tahun" id="z_Tahun" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->Tahun->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->Tahun->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_luasview_Tahun" class="ew-search-field">
<input type="<?= $Page->Tahun->getInputTextType() ?>" name="x_Tahun" id="x_Tahun" data-table="luasview" data-field="x_Tahun" value="<?= $Page->Tahun->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Tahun->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Tahun->formatPattern()) ?>"<?= $Page->Tahun->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Tahun->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_luasview_Tahun" class="ew-search-field2 d-none">
<input type="<?= $Page->Tahun->getInputTextType() ?>" name="y_Tahun" id="y_Tahun" data-table="luasview" data-field="x_Tahun" value="<?= $Page->Tahun->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->Tahun->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Tahun->formatPattern()) ?>"<?= $Page->Tahun->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Tahun->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Bulan->Visible) { // Bulan ?>
<?php
if (!$Page->Bulan->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Bulan" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Bulan->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_Bulan" class="ew-search-caption ew-label"><?= $Page->Bulan->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_Bulan" id="z_Bulan" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->Bulan->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->Bulan->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_luasview_Bulan" class="ew-search-field">
<input type="<?= $Page->Bulan->getInputTextType() ?>" name="x_Bulan" id="x_Bulan" data-table="luasview" data-field="x_Bulan" value="<?= $Page->Bulan->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Bulan->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Bulan->formatPattern()) ?>"<?= $Page->Bulan->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Bulan->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_luasview_Bulan" class="ew-search-field2 d-none">
<input type="<?= $Page->Bulan->getInputTextType() ?>" name="y_Bulan" id="y_Bulan" data-table="luasview" data-field="x_Bulan" value="<?= $Page->Bulan->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->Bulan->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Bulan->formatPattern()) ?>"<?= $Page->Bulan->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Bulan->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
</div><!-- /.row -->
<div class="row mb-0">
    <div class="col-sm-auto px-0 pe-sm-2">
        <div class="ew-basic-search input-group">
            <input type="search" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control ew-basic-search-keyword" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
            <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="ew-basic-search-type" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
            <button type="button" data-bs-toggle="dropdown" class="btn btn-outline-secondary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false">
                <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
            </button>
            <div class="dropdown-menu dropdown-menu-end">
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fluasviewsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fluasviewsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fluasviewsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fluasviewsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
            </div>
        </div>
    </div>
    <div class="col-sm-auto mb-3">
        <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
    </div>
</div>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-list">
<?php if (!$Page->isExport() || $Page->isExport("print")) { ?>
<!-- Middle Container -->
<div id="ew-middle" class="<?= $Page->MiddleContentClass ?>">
<?php } ?>
<?php if (!$Page->isExport() || $Page->isExport("print")) { ?>
<!-- Content Container -->
<div id="ew-content" class="<?= $Page->ContainerClass ?>">
<?php } ?>
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="on">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="luasview">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_luasview" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_luasviewlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = ROWTYPE_HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->Pic->Visible) { // Pic ?>
        <th data-name="Pic" class="<?= $Page->Pic->headerCellClass() ?>"><div id="elh_luasview_Pic" class="luasview_Pic"><?= $Page->renderFieldHeader($Page->Pic) ?></div></th>
<?php } ?>
<?php if ($Page->varietas->Visible) { // varietas ?>
        <th data-name="varietas" class="<?= $Page->varietas->headerCellClass() ?>"><div id="elh_luasview_varietas" class="luasview_varietas"><?= $Page->renderFieldHeader($Page->varietas) ?></div></th>
<?php } ?>
<?php if ($Page->Provinsi->Visible) { // Provinsi ?>
        <th data-name="Provinsi" class="<?= $Page->Provinsi->headerCellClass() ?>"><div id="elh_luasview_Provinsi" class="luasview_Provinsi"><?= $Page->renderFieldHeader($Page->Provinsi) ?></div></th>
<?php } ?>
<?php if ($Page->Kabupaten->Visible) { // Kabupaten ?>
        <th data-name="Kabupaten" class="<?= $Page->Kabupaten->headerCellClass() ?>"><div id="elh_luasview_Kabupaten" class="luasview_Kabupaten"><?= $Page->renderFieldHeader($Page->Kabupaten) ?></div></th>
<?php } ?>
<?php if ($Page->Koordinator->Visible) { // Koordinator ?>
        <th data-name="Koordinator" class="<?= $Page->Koordinator->headerCellClass() ?>"><div id="elh_luasview_Koordinator" class="luasview_Koordinator"><?= $Page->renderFieldHeader($Page->Koordinator) ?></div></th>
<?php } ?>
<?php if ($Page->Tahun->Visible) { // Tahun ?>
        <th data-name="Tahun" class="<?= $Page->Tahun->headerCellClass() ?>"><div id="elh_luasview_Tahun" class="luasview_Tahun"><?= $Page->renderFieldHeader($Page->Tahun) ?></div></th>
<?php } ?>
<?php if ($Page->Bulan->Visible) { // Bulan ?>
        <th data-name="Bulan" class="<?= $Page->Bulan->headerCellClass() ?>"><div id="elh_luasview_Bulan" class="luasview_Bulan"><?= $Page->renderFieldHeader($Page->Bulan) ?></div></th>
<?php } ?>
<?php if ($Page->Luas->Visible) { // Luas ?>
        <th data-name="Luas" class="<?= $Page->Luas->headerCellClass() ?>"><div id="elh_luasview_Luas" class="luasview_Luas"><?= $Page->renderFieldHeader($Page->Luas) ?></div></th>
<?php } ?>
<?php if ($Page->Estimasi_Panen->Visible) { // Estimasi_Panen ?>
        <th data-name="Estimasi_Panen" class="<?= $Page->Estimasi_Panen->headerCellClass() ?>"><div id="elh_luasview_Estimasi_Panen" class="luasview_Estimasi_Panen"><?= $Page->renderFieldHeader($Page->Estimasi_Panen) ?></div></th>
<?php } ?>
<?php if ($Page->Aktual_Panen->Visible) { // Aktual_Panen ?>
        <th data-name="Aktual_Panen" class="<?= $Page->Aktual_Panen->headerCellClass() ?>"><div id="elh_luasview_Aktual_Panen" class="luasview_Aktual_Panen"><?= $Page->renderFieldHeader($Page->Aktual_Panen) ?></div></th>
<?php } ?>
<?php if ($Page->Rata_rata_Skor->Visible) { // Rata_rata_Skor ?>
        <th data-name="Rata_rata_Skor" class="<?= $Page->Rata_rata_Skor->headerCellClass() ?>"><div id="elh_luasview_Rata_rata_Skor" class="luasview_Rata_rata_Skor"><?= $Page->renderFieldHeader($Page->Rata_rata_Skor) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->Pic->Visible) { // Pic ?>
        <td data-name="Pic"<?= $Page->Pic->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_luasview_Pic" class="el_luasview_Pic">
<span<?= $Page->Pic->viewAttributes() ?>>
<?= $Page->Pic->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->varietas->Visible) { // varietas ?>
        <td data-name="varietas"<?= $Page->varietas->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_luasview_varietas" class="el_luasview_varietas">
<span<?= $Page->varietas->viewAttributes() ?>>
<?= $Page->varietas->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Provinsi->Visible) { // Provinsi ?>
        <td data-name="Provinsi"<?= $Page->Provinsi->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_luasview_Provinsi" class="el_luasview_Provinsi">
<span<?= $Page->Provinsi->viewAttributes() ?>>
<?= $Page->Provinsi->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Kabupaten->Visible) { // Kabupaten ?>
        <td data-name="Kabupaten"<?= $Page->Kabupaten->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_luasview_Kabupaten" class="el_luasview_Kabupaten">
<span<?= $Page->Kabupaten->viewAttributes() ?>>
<?= $Page->Kabupaten->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Koordinator->Visible) { // Koordinator ?>
        <td data-name="Koordinator"<?= $Page->Koordinator->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_luasview_Koordinator" class="el_luasview_Koordinator">
<span<?= $Page->Koordinator->viewAttributes() ?>>
<?= $Page->Koordinator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Tahun->Visible) { // Tahun ?>
        <td data-name="Tahun"<?= $Page->Tahun->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_luasview_Tahun" class="el_luasview_Tahun">
<span<?= $Page->Tahun->viewAttributes() ?>>
<?= $Page->Tahun->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Bulan->Visible) { // Bulan ?>
        <td data-name="Bulan"<?= $Page->Bulan->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_luasview_Bulan" class="el_luasview_Bulan">
<span<?= $Page->Bulan->viewAttributes() ?>>
<?= $Page->Bulan->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Luas->Visible) { // Luas ?>
        <td data-name="Luas"<?= $Page->Luas->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_luasview_Luas" class="el_luasview_Luas">
<span<?= $Page->Luas->viewAttributes() ?>>
<?= $Page->Luas->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Estimasi_Panen->Visible) { // Estimasi_Panen ?>
        <td data-name="Estimasi_Panen"<?= $Page->Estimasi_Panen->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_luasview_Estimasi_Panen" class="el_luasview_Estimasi_Panen">
<span<?= $Page->Estimasi_Panen->viewAttributes() ?>>
<?= $Page->Estimasi_Panen->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Aktual_Panen->Visible) { // Aktual_Panen ?>
        <td data-name="Aktual_Panen"<?= $Page->Aktual_Panen->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_luasview_Aktual_Panen" class="el_luasview_Aktual_Panen">
<span<?= $Page->Aktual_Panen->viewAttributes() ?>>
<?= $Page->Aktual_Panen->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Rata_rata_Skor->Visible) { // Rata_rata_Skor ?>
        <td data-name="Rata_rata_Skor"<?= $Page->Rata_rata_Skor->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_luasview_Rata_rata_Skor" class="el_luasview_Rata_rata_Skor">
<span<?= $Page->Rata_rata_Skor->viewAttributes() ?>>
<?= $Page->Rata_rata_Skor->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }
    if (
        $Page->Recordset &&
        !$Page->Recordset->EOF &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->Recordset->moveNext();
    }
    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close recordset
if ($Page->Recordset) {
    $Page->Recordset->close();
}
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
<?php if (!$Page->isExport() || $Page->isExport("print")) { ?>
</div>
<!-- /#ew-content -->
<?php } ?>
<?php if (!$Page->isExport() || $Page->isExport("print")) { ?>
</div>
<!-- /#ew-middle -->
<?php } ?>
<?php if (!$Page->isExport() || $Page->isExport("print")) { ?>
<!-- Bottom Container -->
<div id="ew-bottom" class="<?= $Page->BottomContentClass ?>">
<?php } ?>
<?php
if (!$DashboardReport) {
    // Set up chart drilldown
    $Page->Chart1->DrillDownInPanel = $Page->DrillDownInPanel;
    echo $Page->Chart1->render("ew-chart-bottom");
}
?>
<?php
if (!$DashboardReport) {
    // Set up chart drilldown
    $Page->Chart2->DrillDownInPanel = $Page->DrillDownInPanel;
    echo $Page->Chart2->render("ew-chart-bottom");
}
?>
<?php if (!$Page->isExport() || $Page->isExport("print")) { ?>
</div>
<!-- /#ew-bottom -->
<?php } ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("luasview");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
