<?php

namespace PHPMaker2023\co;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Page class
 */
class OrderBibitAdd extends OrderBibit
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "OrderBibitAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "OrderBibitAdd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->ob_id->Visible = false;
        $this->ob_co->setVisibility();
        $this->ob_k_tanam->setVisibility();
        $this->ob_pembeli->setVisibility();
        $this->ob_tgl_kirim->setVisibility();
        $this->ob_var->setVisibility();
        $this->ob_jumlah->setVisibility();
        $this->status->setVisibility();
        $this->ob_tgl_real_kirim->setVisibility();
        $this->ob_jumlah_real_kirim->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'order_bibit';
        $this->TableName = 'order_bibit';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Table object (order_bibit)
        if (!isset($GLOBALS["order_bibit"]) || get_class($GLOBALS["order_bibit"]) == PROJECT_NAMESPACE . "order_bibit") {
            $GLOBALS["order_bibit"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'order_bibit');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response (Assume return to modal for simplicity)
            if ($this->IsModal) { // Show as modal
                $result = ["url" => GetUrl($url), "modal" => "1"];
                $pageName = GetPageName($url);
                if ($pageName != $this->getListUrl()) { // Not List page => View page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = $pageName == "OrderBibitView"; // If View page, no primary button
                } else { // List page
                    // $result["list"] = $this->PageID == "search"; // Refresh List page if current page is Search page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['ob_id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->ob_id->Visible = false;
        }
    }

    // Lookup data
    public function lookup($ar = null)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $ar["field"] ?? Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;
        $name = $ar["name"] ?? Post("name");
        $isQuery = ContainsString($name, "query_builder_rule");
        if ($isQuery) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $ar["ajax"] ?? Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $ar["q"] ?? Param("q") ?? $ar["sv"] ?? Post("sv", "");
            $pageSize = $ar["n"] ?? Param("n") ?? $ar["recperpage"] ?? Post("recperpage", 10);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $ar["q"] ?? Param("q", "");
            $pageSize = $ar["n"] ?? Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $ar["start"] ?? Param("start", -1);
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $ar["page"] ?? Param("page", -1);
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($ar["s"] ?? Post("s", ""));
        $userFilter = Decrypt($ar["f"] ?? Post("f", ""));
        $userOrderBy = Decrypt($ar["o"] ?? Post("o", ""));
        $keys = $ar["keys"] ?? Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $ar["v0"] ?? $ar["lookupValue"] ?? Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $ar["v" . $i] ?? Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, !is_array($ar)); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $UserProfile, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->ob_co);
        $this->setupLookupOptions($this->ob_k_tanam);
        $this->setupLookupOptions($this->ob_var);
        $this->setupLookupOptions($this->status);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("ob_id") ?? Route("ob_id")) !== null) {
                $this->ob_id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("OrderBibitList"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "OrderBibitList") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "OrderBibitView") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "OrderBibitList") {
                            Container("flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "OrderBibitList"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson([ "success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage() ]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = ROWTYPE_ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'ob_co' first before field var 'x_ob_co'
        $val = $CurrentForm->hasValue("ob_co") ? $CurrentForm->getValue("ob_co") : $CurrentForm->getValue("x_ob_co");
        if (!$this->ob_co->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ob_co->Visible = false; // Disable update for API request
            } else {
                $this->ob_co->setFormValue($val);
            }
        }

        // Check field name 'ob_k_tanam' first before field var 'x_ob_k_tanam'
        $val = $CurrentForm->hasValue("ob_k_tanam") ? $CurrentForm->getValue("ob_k_tanam") : $CurrentForm->getValue("x_ob_k_tanam");
        if (!$this->ob_k_tanam->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ob_k_tanam->Visible = false; // Disable update for API request
            } else {
                $this->ob_k_tanam->setFormValue($val);
            }
        }

        // Check field name 'ob_pembeli' first before field var 'x_ob_pembeli'
        $val = $CurrentForm->hasValue("ob_pembeli") ? $CurrentForm->getValue("ob_pembeli") : $CurrentForm->getValue("x_ob_pembeli");
        if (!$this->ob_pembeli->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ob_pembeli->Visible = false; // Disable update for API request
            } else {
                $this->ob_pembeli->setFormValue($val);
            }
        }

        // Check field name 'ob_tgl_kirim' first before field var 'x_ob_tgl_kirim'
        $val = $CurrentForm->hasValue("ob_tgl_kirim") ? $CurrentForm->getValue("ob_tgl_kirim") : $CurrentForm->getValue("x_ob_tgl_kirim");
        if (!$this->ob_tgl_kirim->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ob_tgl_kirim->Visible = false; // Disable update for API request
            } else {
                $this->ob_tgl_kirim->setFormValue($val, true, $validate);
            }
            $this->ob_tgl_kirim->CurrentValue = UnFormatDateTime($this->ob_tgl_kirim->CurrentValue, $this->ob_tgl_kirim->formatPattern());
        }

        // Check field name 'ob_var' first before field var 'x_ob_var'
        $val = $CurrentForm->hasValue("ob_var") ? $CurrentForm->getValue("ob_var") : $CurrentForm->getValue("x_ob_var");
        if (!$this->ob_var->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ob_var->Visible = false; // Disable update for API request
            } else {
                $this->ob_var->setFormValue($val);
            }
        }

        // Check field name 'ob_jumlah' first before field var 'x_ob_jumlah'
        $val = $CurrentForm->hasValue("ob_jumlah") ? $CurrentForm->getValue("ob_jumlah") : $CurrentForm->getValue("x_ob_jumlah");
        if (!$this->ob_jumlah->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ob_jumlah->Visible = false; // Disable update for API request
            } else {
                $this->ob_jumlah->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val);
            }
        }

        // Check field name 'ob_tgl_real_kirim' first before field var 'x_ob_tgl_real_kirim'
        $val = $CurrentForm->hasValue("ob_tgl_real_kirim") ? $CurrentForm->getValue("ob_tgl_real_kirim") : $CurrentForm->getValue("x_ob_tgl_real_kirim");
        if (!$this->ob_tgl_real_kirim->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ob_tgl_real_kirim->Visible = false; // Disable update for API request
            } else {
                $this->ob_tgl_real_kirim->setFormValue($val, true, $validate);
            }
            $this->ob_tgl_real_kirim->CurrentValue = UnFormatDateTime($this->ob_tgl_real_kirim->CurrentValue, $this->ob_tgl_real_kirim->formatPattern());
        }

        // Check field name 'ob_jumlah_real_kirim' first before field var 'x_ob_jumlah_real_kirim'
        $val = $CurrentForm->hasValue("ob_jumlah_real_kirim") ? $CurrentForm->getValue("ob_jumlah_real_kirim") : $CurrentForm->getValue("x_ob_jumlah_real_kirim");
        if (!$this->ob_jumlah_real_kirim->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ob_jumlah_real_kirim->Visible = false; // Disable update for API request
            } else {
                $this->ob_jumlah_real_kirim->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'ob_id' first before field var 'x_ob_id'
        $val = $CurrentForm->hasValue("ob_id") ? $CurrentForm->getValue("ob_id") : $CurrentForm->getValue("x_ob_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->ob_co->CurrentValue = $this->ob_co->FormValue;
        $this->ob_k_tanam->CurrentValue = $this->ob_k_tanam->FormValue;
        $this->ob_pembeli->CurrentValue = $this->ob_pembeli->FormValue;
        $this->ob_tgl_kirim->CurrentValue = $this->ob_tgl_kirim->FormValue;
        $this->ob_tgl_kirim->CurrentValue = UnFormatDateTime($this->ob_tgl_kirim->CurrentValue, $this->ob_tgl_kirim->formatPattern());
        $this->ob_var->CurrentValue = $this->ob_var->FormValue;
        $this->ob_jumlah->CurrentValue = $this->ob_jumlah->FormValue;
        $this->status->CurrentValue = $this->status->FormValue;
        $this->ob_tgl_real_kirim->CurrentValue = $this->ob_tgl_real_kirim->FormValue;
        $this->ob_tgl_real_kirim->CurrentValue = UnFormatDateTime($this->ob_tgl_real_kirim->CurrentValue, $this->ob_tgl_real_kirim->formatPattern());
        $this->ob_jumlah_real_kirim->CurrentValue = $this->ob_jumlah_real_kirim->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }
        if (!$row) {
            return;
        }

        // Call Row Selected event
        $this->rowSelected($row);
        $this->ob_id->setDbValue($row['ob_id']);
        $this->ob_co->setDbValue($row['ob_co']);
        $this->ob_k_tanam->setDbValue($row['ob_k_tanam']);
        $this->ob_pembeli->setDbValue($row['ob_pembeli']);
        $this->ob_tgl_kirim->setDbValue($row['ob_tgl_kirim']);
        $this->ob_var->setDbValue($row['ob_var']);
        $this->ob_jumlah->setDbValue($row['ob_jumlah']);
        $this->status->setDbValue($row['status']);
        $this->ob_tgl_real_kirim->setDbValue($row['ob_tgl_real_kirim']);
        $this->ob_jumlah_real_kirim->setDbValue($row['ob_jumlah_real_kirim']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['ob_id'] = $this->ob_id->DefaultValue;
        $row['ob_co'] = $this->ob_co->DefaultValue;
        $row['ob_k_tanam'] = $this->ob_k_tanam->DefaultValue;
        $row['ob_pembeli'] = $this->ob_pembeli->DefaultValue;
        $row['ob_tgl_kirim'] = $this->ob_tgl_kirim->DefaultValue;
        $row['ob_var'] = $this->ob_var->DefaultValue;
        $row['ob_jumlah'] = $this->ob_jumlah->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['ob_tgl_real_kirim'] = $this->ob_tgl_real_kirim->DefaultValue;
        $row['ob_jumlah_real_kirim'] = $this->ob_jumlah_real_kirim->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = LoadRecordset($sql, $conn);
            if ($rs && ($row = $rs->fields)) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // ob_id
        $this->ob_id->RowCssClass = "row";

        // ob_co
        $this->ob_co->RowCssClass = "row";

        // ob_k_tanam
        $this->ob_k_tanam->RowCssClass = "row";

        // ob_pembeli
        $this->ob_pembeli->RowCssClass = "row";

        // ob_tgl_kirim
        $this->ob_tgl_kirim->RowCssClass = "row";

        // ob_var
        $this->ob_var->RowCssClass = "row";

        // ob_jumlah
        $this->ob_jumlah->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // ob_tgl_real_kirim
        $this->ob_tgl_real_kirim->RowCssClass = "row";

        // ob_jumlah_real_kirim
        $this->ob_jumlah_real_kirim->RowCssClass = "row";

        // View row
        if ($this->RowType == ROWTYPE_VIEW) {
            // ob_id
            $this->ob_id->ViewValue = $this->ob_id->CurrentValue;

            // ob_co
            $curVal = strval($this->ob_co->CurrentValue);
            if ($curVal != "") {
                $this->ob_co->ViewValue = $this->ob_co->lookupCacheOption($curVal);
                if ($this->ob_co->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`co_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->ob_co->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ob_co->Lookup->renderViewRow($rswrk[0]);
                        $this->ob_co->ViewValue = $this->ob_co->displayValue($arwrk);
                    } else {
                        $this->ob_co->ViewValue = $this->ob_co->CurrentValue;
                    }
                }
            } else {
                $this->ob_co->ViewValue = null;
            }

            // ob_k_tanam
            $curVal = strval($this->ob_k_tanam->CurrentValue);
            if ($curVal != "") {
                $this->ob_k_tanam->ViewValue = $this->ob_k_tanam->lookupCacheOption($curVal);
                if ($this->ob_k_tanam->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`k_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->ob_k_tanam->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ob_k_tanam->Lookup->renderViewRow($rswrk[0]);
                        $this->ob_k_tanam->ViewValue = $this->ob_k_tanam->displayValue($arwrk);
                    } else {
                        $this->ob_k_tanam->ViewValue = $this->ob_k_tanam->CurrentValue;
                    }
                }
            } else {
                $this->ob_k_tanam->ViewValue = null;
            }

            // ob_pembeli
            $this->ob_pembeli->ViewValue = $this->ob_pembeli->CurrentValue;

            // ob_tgl_kirim
            $this->ob_tgl_kirim->ViewValue = $this->ob_tgl_kirim->CurrentValue;
            $this->ob_tgl_kirim->ViewValue = FormatDateTime($this->ob_tgl_kirim->ViewValue, $this->ob_tgl_kirim->formatPattern());

            // ob_var
            $curVal = strval($this->ob_var->CurrentValue);
            if ($curVal != "") {
                $this->ob_var->ViewValue = $this->ob_var->lookupCacheOption($curVal);
                if ($this->ob_var->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`var_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->ob_var->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ob_var->Lookup->renderViewRow($rswrk[0]);
                        $this->ob_var->ViewValue = $this->ob_var->displayValue($arwrk);
                    } else {
                        $this->ob_var->ViewValue = $this->ob_var->CurrentValue;
                    }
                }
            } else {
                $this->ob_var->ViewValue = null;
            }

            // ob_jumlah
            $this->ob_jumlah->ViewValue = $this->ob_jumlah->CurrentValue;

            // status
            $curVal = strval($this->status->CurrentValue);
            if ($curVal != "") {
                $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
                if ($this->status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`status_order_bibit`", "=", $curVal, DATATYPE_STRING, "");
                    $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                        $this->status->ViewValue = $this->status->displayValue($arwrk);
                    } else {
                        $this->status->ViewValue = $this->status->CurrentValue;
                    }
                }
            } else {
                $this->status->ViewValue = null;
            }

            // ob_tgl_real_kirim
            $this->ob_tgl_real_kirim->ViewValue = $this->ob_tgl_real_kirim->CurrentValue;
            $this->ob_tgl_real_kirim->ViewValue = FormatDateTime($this->ob_tgl_real_kirim->ViewValue, $this->ob_tgl_real_kirim->formatPattern());

            // ob_jumlah_real_kirim
            $this->ob_jumlah_real_kirim->ViewValue = $this->ob_jumlah_real_kirim->CurrentValue;

            // ob_co
            $this->ob_co->HrefValue = "";
            $this->ob_co->TooltipValue = "";

            // ob_k_tanam
            $this->ob_k_tanam->HrefValue = "";

            // ob_pembeli
            $this->ob_pembeli->HrefValue = "";

            // ob_tgl_kirim
            $this->ob_tgl_kirim->HrefValue = "";
            $this->ob_tgl_kirim->TooltipValue = "";

            // ob_var
            $this->ob_var->HrefValue = "";
            $this->ob_var->TooltipValue = "";

            // ob_jumlah
            $this->ob_jumlah->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // ob_tgl_real_kirim
            $this->ob_tgl_real_kirim->HrefValue = "";

            // ob_jumlah_real_kirim
            $this->ob_jumlah_real_kirim->HrefValue = "";
        } elseif ($this->RowType == ROWTYPE_ADD) {
            // ob_co
            $this->ob_co->setupEditAttributes();
            $curVal = trim(strval($this->ob_co->CurrentValue));
            if ($curVal != "") {
                $this->ob_co->ViewValue = $this->ob_co->lookupCacheOption($curVal);
            } else {
                $this->ob_co->ViewValue = $this->ob_co->Lookup !== null && is_array($this->ob_co->lookupOptions()) && count($this->ob_co->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->ob_co->ViewValue !== null) { // Load from cache
                $this->ob_co->EditValue = array_values($this->ob_co->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`co_id`", "=", $this->ob_co->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->ob_co->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->ob_co->EditValue = $arwrk;
            }
            $this->ob_co->PlaceHolder = RemoveHtml($this->ob_co->caption());

            // ob_k_tanam
            $this->ob_k_tanam->setupEditAttributes();
            $curVal = trim(strval($this->ob_k_tanam->CurrentValue));
            if ($curVal != "") {
                $this->ob_k_tanam->ViewValue = $this->ob_k_tanam->lookupCacheOption($curVal);
            } else {
                $this->ob_k_tanam->ViewValue = $this->ob_k_tanam->Lookup !== null && is_array($this->ob_k_tanam->lookupOptions()) && count($this->ob_k_tanam->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->ob_k_tanam->ViewValue !== null) { // Load from cache
                $this->ob_k_tanam->EditValue = array_values($this->ob_k_tanam->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`k_id`", "=", $this->ob_k_tanam->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->ob_k_tanam->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->ob_k_tanam->EditValue = $arwrk;
            }
            $this->ob_k_tanam->PlaceHolder = RemoveHtml($this->ob_k_tanam->caption());

            // ob_pembeli
            $this->ob_pembeli->setupEditAttributes();
            if (!$this->ob_pembeli->Raw) {
                $this->ob_pembeli->CurrentValue = HtmlDecode($this->ob_pembeli->CurrentValue);
            }
            $this->ob_pembeli->EditValue = HtmlEncode($this->ob_pembeli->CurrentValue);
            $this->ob_pembeli->PlaceHolder = RemoveHtml($this->ob_pembeli->caption());

            // ob_tgl_kirim
            $this->ob_tgl_kirim->setupEditAttributes();
            $this->ob_tgl_kirim->EditValue = HtmlEncode(FormatDateTime($this->ob_tgl_kirim->CurrentValue, $this->ob_tgl_kirim->formatPattern()));
            $this->ob_tgl_kirim->PlaceHolder = RemoveHtml($this->ob_tgl_kirim->caption());

            // ob_var
            $this->ob_var->setupEditAttributes();
            $curVal = trim(strval($this->ob_var->CurrentValue));
            if ($curVal != "") {
                $this->ob_var->ViewValue = $this->ob_var->lookupCacheOption($curVal);
            } else {
                $this->ob_var->ViewValue = $this->ob_var->Lookup !== null && is_array($this->ob_var->lookupOptions()) && count($this->ob_var->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->ob_var->ViewValue !== null) { // Load from cache
                $this->ob_var->EditValue = array_values($this->ob_var->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`var_id`", "=", $this->ob_var->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->ob_var->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->ob_var->EditValue = $arwrk;
            }
            $this->ob_var->PlaceHolder = RemoveHtml($this->ob_var->caption());

            // ob_jumlah
            $this->ob_jumlah->setupEditAttributes();
            $this->ob_jumlah->EditValue = HtmlEncode($this->ob_jumlah->CurrentValue);
            $this->ob_jumlah->PlaceHolder = RemoveHtml($this->ob_jumlah->caption());
            if (strval($this->ob_jumlah->EditValue) != "" && is_numeric($this->ob_jumlah->EditValue)) {
                $this->ob_jumlah->EditValue = $this->ob_jumlah->EditValue;
            }

            // status
            $curVal = trim(strval($this->status->CurrentValue));
            if ($curVal != "") {
                $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
            } else {
                $this->status->ViewValue = $this->status->Lookup !== null && is_array($this->status->lookupOptions()) && count($this->status->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->status->ViewValue !== null) { // Load from cache
                $this->status->EditValue = array_values($this->status->lookupOptions());
                if ($this->status->ViewValue == "") {
                    $this->status->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`status_order_bibit`", "=", $this->status->CurrentValue, DATATYPE_STRING, "");
                }
                $sqlWrk = $this->status->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                    $this->status->ViewValue = $this->status->displayValue($arwrk);
                } else {
                    $this->status->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->status->EditValue = $arwrk;
            }
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // ob_tgl_real_kirim
            $this->ob_tgl_real_kirim->setupEditAttributes();
            $this->ob_tgl_real_kirim->EditValue = HtmlEncode(FormatDateTime($this->ob_tgl_real_kirim->CurrentValue, $this->ob_tgl_real_kirim->formatPattern()));
            $this->ob_tgl_real_kirim->PlaceHolder = RemoveHtml($this->ob_tgl_real_kirim->caption());

            // ob_jumlah_real_kirim
            $this->ob_jumlah_real_kirim->setupEditAttributes();
            $this->ob_jumlah_real_kirim->EditValue = HtmlEncode($this->ob_jumlah_real_kirim->CurrentValue);
            $this->ob_jumlah_real_kirim->PlaceHolder = RemoveHtml($this->ob_jumlah_real_kirim->caption());
            if (strval($this->ob_jumlah_real_kirim->EditValue) != "" && is_numeric($this->ob_jumlah_real_kirim->EditValue)) {
                $this->ob_jumlah_real_kirim->EditValue = $this->ob_jumlah_real_kirim->EditValue;
            }

            // Add refer script

            // ob_co
            $this->ob_co->HrefValue = "";

            // ob_k_tanam
            $this->ob_k_tanam->HrefValue = "";

            // ob_pembeli
            $this->ob_pembeli->HrefValue = "";

            // ob_tgl_kirim
            $this->ob_tgl_kirim->HrefValue = "";

            // ob_var
            $this->ob_var->HrefValue = "";

            // ob_jumlah
            $this->ob_jumlah->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // ob_tgl_real_kirim
            $this->ob_tgl_real_kirim->HrefValue = "";

            // ob_jumlah_real_kirim
            $this->ob_jumlah_real_kirim->HrefValue = "";
        }
        if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
        if ($this->ob_co->Visible && $this->ob_co->Required) {
            if (!$this->ob_co->IsDetailKey && EmptyValue($this->ob_co->FormValue)) {
                $this->ob_co->addErrorMessage(str_replace("%s", $this->ob_co->caption(), $this->ob_co->RequiredErrorMessage));
            }
        }
        if ($this->ob_k_tanam->Visible && $this->ob_k_tanam->Required) {
            if (!$this->ob_k_tanam->IsDetailKey && EmptyValue($this->ob_k_tanam->FormValue)) {
                $this->ob_k_tanam->addErrorMessage(str_replace("%s", $this->ob_k_tanam->caption(), $this->ob_k_tanam->RequiredErrorMessage));
            }
        }
        if ($this->ob_pembeli->Visible && $this->ob_pembeli->Required) {
            if (!$this->ob_pembeli->IsDetailKey && EmptyValue($this->ob_pembeli->FormValue)) {
                $this->ob_pembeli->addErrorMessage(str_replace("%s", $this->ob_pembeli->caption(), $this->ob_pembeli->RequiredErrorMessage));
            }
        }
        if ($this->ob_tgl_kirim->Visible && $this->ob_tgl_kirim->Required) {
            if (!$this->ob_tgl_kirim->IsDetailKey && EmptyValue($this->ob_tgl_kirim->FormValue)) {
                $this->ob_tgl_kirim->addErrorMessage(str_replace("%s", $this->ob_tgl_kirim->caption(), $this->ob_tgl_kirim->RequiredErrorMessage));
            }
        }
        if (!CheckDate($this->ob_tgl_kirim->FormValue, $this->ob_tgl_kirim->formatPattern())) {
            $this->ob_tgl_kirim->addErrorMessage($this->ob_tgl_kirim->getErrorMessage(false));
        }
        if ($this->ob_var->Visible && $this->ob_var->Required) {
            if (!$this->ob_var->IsDetailKey && EmptyValue($this->ob_var->FormValue)) {
                $this->ob_var->addErrorMessage(str_replace("%s", $this->ob_var->caption(), $this->ob_var->RequiredErrorMessage));
            }
        }
        if ($this->ob_jumlah->Visible && $this->ob_jumlah->Required) {
            if (!$this->ob_jumlah->IsDetailKey && EmptyValue($this->ob_jumlah->FormValue)) {
                $this->ob_jumlah->addErrorMessage(str_replace("%s", $this->ob_jumlah->caption(), $this->ob_jumlah->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->ob_jumlah->FormValue)) {
            $this->ob_jumlah->addErrorMessage($this->ob_jumlah->getErrorMessage(false));
        }
        if ($this->status->Visible && $this->status->Required) {
            if ($this->status->FormValue == "") {
                $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
            }
        }
        if ($this->ob_tgl_real_kirim->Visible && $this->ob_tgl_real_kirim->Required) {
            if (!$this->ob_tgl_real_kirim->IsDetailKey && EmptyValue($this->ob_tgl_real_kirim->FormValue)) {
                $this->ob_tgl_real_kirim->addErrorMessage(str_replace("%s", $this->ob_tgl_real_kirim->caption(), $this->ob_tgl_real_kirim->RequiredErrorMessage));
            }
        }
        if (!CheckDate($this->ob_tgl_real_kirim->FormValue, $this->ob_tgl_real_kirim->formatPattern())) {
            $this->ob_tgl_real_kirim->addErrorMessage($this->ob_tgl_real_kirim->getErrorMessage(false));
        }
        if ($this->ob_jumlah_real_kirim->Visible && $this->ob_jumlah_real_kirim->Required) {
            if (!$this->ob_jumlah_real_kirim->IsDetailKey && EmptyValue($this->ob_jumlah_real_kirim->FormValue)) {
                $this->ob_jumlah_real_kirim->addErrorMessage(str_replace("%s", $this->ob_jumlah_real_kirim->caption(), $this->ob_jumlah_real_kirim->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->ob_jumlah_real_kirim->FormValue)) {
            $this->ob_jumlah_real_kirim->addErrorMessage($this->ob_jumlah_real_kirim->getErrorMessage(false));
        }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Set new row
        $rsnew = [];

        // ob_co
        $this->ob_co->setDbValueDef($rsnew, $this->ob_co->CurrentValue, false);

        // ob_k_tanam
        $this->ob_k_tanam->setDbValueDef($rsnew, $this->ob_k_tanam->CurrentValue, false);

        // ob_pembeli
        $this->ob_pembeli->setDbValueDef($rsnew, $this->ob_pembeli->CurrentValue, false);

        // ob_tgl_kirim
        $this->ob_tgl_kirim->setDbValueDef($rsnew, UnFormatDateTime($this->ob_tgl_kirim->CurrentValue, $this->ob_tgl_kirim->formatPattern()), false);

        // ob_var
        $this->ob_var->setDbValueDef($rsnew, $this->ob_var->CurrentValue, false);

        // ob_jumlah
        $this->ob_jumlah->setDbValueDef($rsnew, $this->ob_jumlah->CurrentValue, false);

        // status
        $this->status->setDbValueDef($rsnew, $this->status->CurrentValue, false);

        // ob_tgl_real_kirim
        $this->ob_tgl_real_kirim->setDbValueDef($rsnew, UnFormatDateTime($this->ob_tgl_real_kirim->CurrentValue, $this->ob_tgl_real_kirim->formatPattern()), false);

        // ob_jumlah_real_kirim
        $this->ob_jumlah_real_kirim->setDbValueDef($rsnew, $this->ob_jumlah_real_kirim->CurrentValue, false);

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("KontrakList");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("OrderBibitList"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_ob_co":
                    break;
                case "x_ob_k_tanam":
                    break;
                case "x_ob_var":
                    break;
                case "x_status":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
