<?php

namespace PHPMaker2021\gudang_ubi;

use Doctrine\DBAL\ParameterType;

/**
 * Page class
 */
class SortirAdd extends Sortir
{
    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Table name
    public $TableName = 'sortir';

    // Page object name
    public $PageObjName = "SortirAdd";

    // Rendering View
    public $RenderingView = false;

    // Custom template
    public $UseCustomTemplate = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl()
    {
        $url = ScriptName() . "?";
        if ($this->UseTokenInUrl) {
            $url .= "t=" . $this->TableVar . "&"; // Add page token
        }
        return $url;
    }

    // Messages
    private $message = "";
    private $failureMessage = "";
    private $successMessage = "";
    private $warningMessage = "";

    // Get message
    public function getMessage()
    {
        return $_SESSION[SESSION_MESSAGE] ?? $this->message;
    }

    // Set message
    public function setMessage($v)
    {
        AddMessage($this->message, $v);
        $_SESSION[SESSION_MESSAGE] = $this->message;
    }

    // Get failure message
    public function getFailureMessage()
    {
        return $_SESSION[SESSION_FAILURE_MESSAGE] ?? $this->failureMessage;
    }

    // Set failure message
    public function setFailureMessage($v)
    {
        AddMessage($this->failureMessage, $v);
        $_SESSION[SESSION_FAILURE_MESSAGE] = $this->failureMessage;
    }

    // Get success message
    public function getSuccessMessage()
    {
        return $_SESSION[SESSION_SUCCESS_MESSAGE] ?? $this->successMessage;
    }

    // Set success message
    public function setSuccessMessage($v)
    {
        AddMessage($this->successMessage, $v);
        $_SESSION[SESSION_SUCCESS_MESSAGE] = $this->successMessage;
    }

    // Get warning message
    public function getWarningMessage()
    {
        return $_SESSION[SESSION_WARNING_MESSAGE] ?? $this->warningMessage;
    }

    // Set warning message
    public function setWarningMessage($v)
    {
        AddMessage($this->warningMessage, $v);
        $_SESSION[SESSION_WARNING_MESSAGE] = $this->warningMessage;
    }

    // Clear message
    public function clearMessage()
    {
        $this->message = "";
        $_SESSION[SESSION_MESSAGE] = "";
    }

    // Clear failure message
    public function clearFailureMessage()
    {
        $this->failureMessage = "";
        $_SESSION[SESSION_FAILURE_MESSAGE] = "";
    }

    // Clear success message
    public function clearSuccessMessage()
    {
        $this->successMessage = "";
        $_SESSION[SESSION_SUCCESS_MESSAGE] = "";
    }

    // Clear warning message
    public function clearWarningMessage()
    {
        $this->warningMessage = "";
        $_SESSION[SESSION_WARNING_MESSAGE] = "";
    }

    // Clear messages
    public function clearMessages()
    {
        $this->clearMessage();
        $this->clearFailureMessage();
        $this->clearSuccessMessage();
        $this->clearWarningMessage();
    }

    // Show message
    public function showMessage()
    {
        $hidden = true;
        $html = "";
        // Message
        $message = $this->getMessage();
        if (method_exists($this, "messageShowing")) {
            $this->messageShowing($message, "");
        }
        if ($message != "") { // Message in Session, display
            if (!$hidden) {
                $message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
            }
            $html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
            $_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
        }
        // Warning message
        $warningMessage = $this->getWarningMessage();
        if (method_exists($this, "messageShowing")) {
            $this->messageShowing($warningMessage, "warning");
        }
        if ($warningMessage != "") { // Message in Session, display
            if (!$hidden) {
                $warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
            }
            $html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
            $_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
        }
        // Success message
        $successMessage = $this->getSuccessMessage();
        if (method_exists($this, "messageShowing")) {
            $this->messageShowing($successMessage, "success");
        }
        if ($successMessage != "") { // Message in Session, display
            if (!$hidden) {
                $successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
            }
            $html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
            $_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
        }
        // Failure message
        $errorMessage = $this->getFailureMessage();
        if (method_exists($this, "messageShowing")) {
            $this->messageShowing($errorMessage, "failure");
        }
        if ($errorMessage != "") { // Message in Session, display
            if (!$hidden) {
                $errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
            }
            $html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
            $_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
        }
        echo '<div class="ew-message-dialog' . ($hidden ? ' d-none' : '') . '">' . $html . '</div>';
    }

    // Get message as array
    public function getMessages()
    {
        $ar = [];
        // Message
        $message = $this->getMessage();
        if ($message != "") { // Message in Session, display
            $ar["message"] = $message;
            $_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
        }
        // Warning message
        $warningMessage = $this->getWarningMessage();
        if ($warningMessage != "") { // Message in Session, display
            $ar["warningMessage"] = $warningMessage;
            $_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
        }
        // Success message
        $successMessage = $this->getSuccessMessage();
        if ($successMessage != "") { // Message in Session, display
            $ar["successMessage"] = $successMessage;
            $_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
        }
        // Failure message
        $failureMessage = $this->getFailureMessage();
        if ($failureMessage != "") { // Message in Session, display
            $ar["failureMessage"] = $failureMessage;
            $_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
        }
        return $ar;
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Validate page request
    protected function isPageRequest()
    {
        global $CurrentForm;
        if ($this->UseTokenInUrl) {
            if ($CurrentForm) {
                return ($this->TableVar == $CurrentForm->getValue("t"));
            }
            if (Get("t") !== null) {
                return ($this->TableVar == Get("t"));
            }
        }
        return true;
    }

    // Constructor
    public function __construct()
    {
        global $Language, $DashboardReport, $DebugTimer;
        global $UserTable;

        // Initialize
        $GLOBALS["Page"] = &$this;
        $this->TokenTimeout = SessionTimeoutTime();

        // Language object
        $Language = Container("language");

        // Parent constuctor
        parent::__construct();

        // Table object (sortir)
        if (!isset($GLOBALS["sortir"]) || get_class($GLOBALS["sortir"]) == PROJECT_NAMESPACE . "sortir") {
            $GLOBALS["sortir"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl();

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'sortir');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] = $GLOBALS["Conn"] ?? $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents($stream = null): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $ExportFileName, $TempImages, $DashboardReport;

        // Page is terminated
        $this->terminated = true;

         // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();

        // Export
        if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
            $content = $this->getContents();
            if ($ExportFileName == "") {
                $ExportFileName = $this->TableVar;
            }
            $class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
            if (class_exists($class)) {
                $doc = new $class(Container("sortir"));
                $doc->Text = @$content;
                if ($this->isExport("email")) {
                    echo $this->exportEmail($doc->Text);
                } else {
                    $doc->export();
                }
                DeleteTempImages(); // Delete temp images
                return;
            }
        }
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show error
                WriteJson(array_merge(["success" => false], $this->getMessages()));
            }
            return;
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $row = ["url" => GetUrl($url), "modal" => "1"];
                $pageName = GetPageName($url);
                if ($pageName != $this->getListUrl()) { // Not List page
                    $row["caption"] = $this->getModalCaption($pageName);
                    if ($pageName == "SortirView") {
                        $row["view"] = "1";
                    }
                } else { // List page should not be shown as modal => error
                    $row["error"] = $this->getFailureMessage();
                    $this->clearFailureMessage();
                }
                WriteJson($row);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['sortir_id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->sortir_id->Visible = false;
        }
    }

    // Lookup data
    public function lookup()
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = Post("field");
        if (!array_key_exists($fieldName, $this->Fields)) {
            return false;
        }
        $lookupField = $this->Fields[$fieldName];
        $lookup = $lookupField->Lookup;
        if ($lookup === null) {
            return false;
        }
        $tbl = $lookup->getTable();
        if (!$Security->allowLookup(PROJECT_ID . $tbl->TableName)) { // Lookup permission
            return false;
        }

        // Get lookup parameters
        $lookupType = Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal")) {
            $searchValue = Post("sv", "");
            $pageSize = Post("recperpage", 10);
            $offset = Post("start", 0);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = Param("q", "");
            $pageSize = Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
            $start = Param("start", -1);
            $start = is_numeric($start) ? (int)$start : -1;
            $page = Param("page", -1);
            $page = is_numeric($page) ? (int)$page : -1;
            $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        }
        $userSelect = Decrypt(Post("s", ""));
        $userFilter = Decrypt(Post("f", ""));
        $userOrderBy = Decrypt(Post("o", ""));
        $keys = Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        $lookup->toJson($this); // Use settings from current page
    }
    public $FormClassName = "ew-horizontal ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $OldRecordset;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
            $SkipHeaderFooter;

        // Is modal
        $this->IsModal = Param("modal") == "1";

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->sortir_id->Visible = false;
        $this->sortir_kedatangan->setVisibility();
        $this->sortir_petugas->setVisibility();
        $this->sortir_tanggal->setVisibility();
        $this->sortir_okking->setVisibility();
        $this->sortir_okl->setVisibility();
        $this->sortir_okm->setVisibility();
        $this->sortir_oks->setVisibility();
        $this->sortir_okss->setVisibility();
        $this->sortir_oktotal->setVisibility();
        $this->sortir_rijek_busuk->setVisibility();
        $this->sortir_rijek_kecil->setVisibility();
        $this->sortir_rijek_sampah->setVisibility();
        $this->sortir_catatan->setVisibility();
        $this->hideFieldsForAddEdit();

        // Do not use lookup cache
        $this->setUseLookupCache(false);

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->sortir_kedatangan);
        $this->setupLookupOptions($this->sortir_petugas);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $this->FormClassName = "ew-form ew-add-form ew-horizontal";
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action") !== null) {
            $this->CurrentAction = Post("action"); // Get form action
            $postBack = true;
        } else {
            // Load key values from QueryString
            $this->CopyRecord = true;
            if (($keyValue = Get("sortir_id") ?? Route("sortir_id")) !== null) {
                $this->sortir_id->setQueryStringValue($keyValue);
                $this->setKey("sortir_id", $this->sortir_id->CurrentValue); // Set up key
            } else {
                $this->setKey("sortir_id", ""); // Clear key
                $this->CopyRecord = false;
            }
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record / default values
        $loaded = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$loaded) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("SortirList"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($this->OldRecordset)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "SortirList") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "SortirView") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }
                    if (IsApi()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = ROWTYPE_ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Pass table and field properties to client side
            $this->toClientVar(["tableCaption"], ["caption", "Required", "IsInvalid", "Raw"]);

            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Rendering event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->sortir_id->CurrentValue = null;
        $this->sortir_id->OldValue = $this->sortir_id->CurrentValue;
        $this->sortir_kedatangan->CurrentValue = null;
        $this->sortir_kedatangan->OldValue = $this->sortir_kedatangan->CurrentValue;
        $this->sortir_petugas->CurrentValue = null;
        $this->sortir_petugas->OldValue = $this->sortir_petugas->CurrentValue;
        $this->sortir_tanggal->CurrentValue = null;
        $this->sortir_tanggal->OldValue = $this->sortir_tanggal->CurrentValue;
        $this->sortir_okking->CurrentValue = 0;
        $this->sortir_okl->CurrentValue = 0;
        $this->sortir_okm->CurrentValue = 0;
        $this->sortir_oks->CurrentValue = 0;
        $this->sortir_okss->CurrentValue = 0;
        $this->sortir_oktotal->CurrentValue = 0;
        $this->sortir_rijek_busuk->CurrentValue = 0;
        $this->sortir_rijek_kecil->CurrentValue = 0;
        $this->sortir_rijek_sampah->CurrentValue = 0;
        $this->sortir_catatan->CurrentValue = null;
        $this->sortir_catatan->OldValue = $this->sortir_catatan->CurrentValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;

        // Check field name 'sortir_kedatangan' first before field var 'x_sortir_kedatangan'
        $val = $CurrentForm->hasValue("sortir_kedatangan") ? $CurrentForm->getValue("sortir_kedatangan") : $CurrentForm->getValue("x_sortir_kedatangan");
        if (!$this->sortir_kedatangan->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sortir_kedatangan->Visible = false; // Disable update for API request
            } else {
                $this->sortir_kedatangan->setFormValue($val);
            }
        }

        // Check field name 'sortir_petugas' first before field var 'x_sortir_petugas'
        $val = $CurrentForm->hasValue("sortir_petugas") ? $CurrentForm->getValue("sortir_petugas") : $CurrentForm->getValue("x_sortir_petugas");
        if (!$this->sortir_petugas->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sortir_petugas->Visible = false; // Disable update for API request
            } else {
                $this->sortir_petugas->setFormValue($val);
            }
        }

        // Check field name 'sortir_tanggal' first before field var 'x_sortir_tanggal'
        $val = $CurrentForm->hasValue("sortir_tanggal") ? $CurrentForm->getValue("sortir_tanggal") : $CurrentForm->getValue("x_sortir_tanggal");
        if (!$this->sortir_tanggal->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sortir_tanggal->Visible = false; // Disable update for API request
            } else {
                $this->sortir_tanggal->setFormValue($val);
            }
            $this->sortir_tanggal->CurrentValue = UnFormatDateTime($this->sortir_tanggal->CurrentValue, 0);
        }

        // Check field name 'sortir_okking' first before field var 'x_sortir_okking'
        $val = $CurrentForm->hasValue("sortir_okking") ? $CurrentForm->getValue("sortir_okking") : $CurrentForm->getValue("x_sortir_okking");
        if (!$this->sortir_okking->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sortir_okking->Visible = false; // Disable update for API request
            } else {
                $this->sortir_okking->setFormValue($val);
            }
        }

        // Check field name 'sortir_okl' first before field var 'x_sortir_okl'
        $val = $CurrentForm->hasValue("sortir_okl") ? $CurrentForm->getValue("sortir_okl") : $CurrentForm->getValue("x_sortir_okl");
        if (!$this->sortir_okl->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sortir_okl->Visible = false; // Disable update for API request
            } else {
                $this->sortir_okl->setFormValue($val);
            }
        }

        // Check field name 'sortir_okm' first before field var 'x_sortir_okm'
        $val = $CurrentForm->hasValue("sortir_okm") ? $CurrentForm->getValue("sortir_okm") : $CurrentForm->getValue("x_sortir_okm");
        if (!$this->sortir_okm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sortir_okm->Visible = false; // Disable update for API request
            } else {
                $this->sortir_okm->setFormValue($val);
            }
        }

        // Check field name 'sortir_oks' first before field var 'x_sortir_oks'
        $val = $CurrentForm->hasValue("sortir_oks") ? $CurrentForm->getValue("sortir_oks") : $CurrentForm->getValue("x_sortir_oks");
        if (!$this->sortir_oks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sortir_oks->Visible = false; // Disable update for API request
            } else {
                $this->sortir_oks->setFormValue($val);
            }
        }

        // Check field name 'sortir_okss' first before field var 'x_sortir_okss'
        $val = $CurrentForm->hasValue("sortir_okss") ? $CurrentForm->getValue("sortir_okss") : $CurrentForm->getValue("x_sortir_okss");
        if (!$this->sortir_okss->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sortir_okss->Visible = false; // Disable update for API request
            } else {
                $this->sortir_okss->setFormValue($val);
            }
        }

        // Check field name 'sortir_oktotal' first before field var 'x_sortir_oktotal'
        $val = $CurrentForm->hasValue("sortir_oktotal") ? $CurrentForm->getValue("sortir_oktotal") : $CurrentForm->getValue("x_sortir_oktotal");
        if (!$this->sortir_oktotal->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sortir_oktotal->Visible = false; // Disable update for API request
            } else {
                $this->sortir_oktotal->setFormValue($val);
            }
        }

        // Check field name 'sortir_rijek_busuk' first before field var 'x_sortir_rijek_busuk'
        $val = $CurrentForm->hasValue("sortir_rijek_busuk") ? $CurrentForm->getValue("sortir_rijek_busuk") : $CurrentForm->getValue("x_sortir_rijek_busuk");
        if (!$this->sortir_rijek_busuk->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sortir_rijek_busuk->Visible = false; // Disable update for API request
            } else {
                $this->sortir_rijek_busuk->setFormValue($val);
            }
        }

        // Check field name 'sortir_rijek_kecil' first before field var 'x_sortir_rijek_kecil'
        $val = $CurrentForm->hasValue("sortir_rijek_kecil") ? $CurrentForm->getValue("sortir_rijek_kecil") : $CurrentForm->getValue("x_sortir_rijek_kecil");
        if (!$this->sortir_rijek_kecil->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sortir_rijek_kecil->Visible = false; // Disable update for API request
            } else {
                $this->sortir_rijek_kecil->setFormValue($val);
            }
        }

        // Check field name 'sortir_rijek_sampah' first before field var 'x_sortir_rijek_sampah'
        $val = $CurrentForm->hasValue("sortir_rijek_sampah") ? $CurrentForm->getValue("sortir_rijek_sampah") : $CurrentForm->getValue("x_sortir_rijek_sampah");
        if (!$this->sortir_rijek_sampah->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sortir_rijek_sampah->Visible = false; // Disable update for API request
            } else {
                $this->sortir_rijek_sampah->setFormValue($val);
            }
        }

        // Check field name 'sortir_catatan' first before field var 'x_sortir_catatan'
        $val = $CurrentForm->hasValue("sortir_catatan") ? $CurrentForm->getValue("sortir_catatan") : $CurrentForm->getValue("x_sortir_catatan");
        if (!$this->sortir_catatan->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sortir_catatan->Visible = false; // Disable update for API request
            } else {
                $this->sortir_catatan->setFormValue($val);
            }
        }

        // Check field name 'sortir_id' first before field var 'x_sortir_id'
        $val = $CurrentForm->hasValue("sortir_id") ? $CurrentForm->getValue("sortir_id") : $CurrentForm->getValue("x_sortir_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->sortir_kedatangan->CurrentValue = $this->sortir_kedatangan->FormValue;
        $this->sortir_petugas->CurrentValue = $this->sortir_petugas->FormValue;
        $this->sortir_tanggal->CurrentValue = $this->sortir_tanggal->FormValue;
        $this->sortir_tanggal->CurrentValue = UnFormatDateTime($this->sortir_tanggal->CurrentValue, 0);
        $this->sortir_okking->CurrentValue = $this->sortir_okking->FormValue;
        $this->sortir_okl->CurrentValue = $this->sortir_okl->FormValue;
        $this->sortir_okm->CurrentValue = $this->sortir_okm->FormValue;
        $this->sortir_oks->CurrentValue = $this->sortir_oks->FormValue;
        $this->sortir_okss->CurrentValue = $this->sortir_okss->FormValue;
        $this->sortir_oktotal->CurrentValue = $this->sortir_oktotal->FormValue;
        $this->sortir_rijek_busuk->CurrentValue = $this->sortir_rijek_busuk->FormValue;
        $this->sortir_rijek_kecil->CurrentValue = $this->sortir_rijek_kecil->FormValue;
        $this->sortir_rijek_sampah->CurrentValue = $this->sortir_rijek_sampah->FormValue;
        $this->sortir_catatan->CurrentValue = $this->sortir_catatan->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssoc($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }

        // Call Row Selected event
        $this->rowSelected($row);
        if (!$rs) {
            return;
        }
        $this->sortir_id->setDbValue($row['sortir_id']);
        $this->sortir_kedatangan->setDbValue($row['sortir_kedatangan']);
        $this->sortir_petugas->setDbValue($row['sortir_petugas']);
        $this->sortir_tanggal->setDbValue($row['sortir_tanggal']);
        $this->sortir_okking->setDbValue($row['sortir_okking']);
        $this->sortir_okl->setDbValue($row['sortir_okl']);
        $this->sortir_okm->setDbValue($row['sortir_okm']);
        $this->sortir_oks->setDbValue($row['sortir_oks']);
        $this->sortir_okss->setDbValue($row['sortir_okss']);
        $this->sortir_oktotal->setDbValue($row['sortir_oktotal']);
        $this->sortir_rijek_busuk->setDbValue($row['sortir_rijek_busuk']);
        $this->sortir_rijek_kecil->setDbValue($row['sortir_rijek_kecil']);
        $this->sortir_rijek_sampah->setDbValue($row['sortir_rijek_sampah']);
        $this->sortir_catatan->setDbValue($row['sortir_catatan']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $this->loadDefaultValues();
        $row = [];
        $row['sortir_id'] = $this->sortir_id->CurrentValue;
        $row['sortir_kedatangan'] = $this->sortir_kedatangan->CurrentValue;
        $row['sortir_petugas'] = $this->sortir_petugas->CurrentValue;
        $row['sortir_tanggal'] = $this->sortir_tanggal->CurrentValue;
        $row['sortir_okking'] = $this->sortir_okking->CurrentValue;
        $row['sortir_okl'] = $this->sortir_okl->CurrentValue;
        $row['sortir_okm'] = $this->sortir_okm->CurrentValue;
        $row['sortir_oks'] = $this->sortir_oks->CurrentValue;
        $row['sortir_okss'] = $this->sortir_okss->CurrentValue;
        $row['sortir_oktotal'] = $this->sortir_oktotal->CurrentValue;
        $row['sortir_rijek_busuk'] = $this->sortir_rijek_busuk->CurrentValue;
        $row['sortir_rijek_kecil'] = $this->sortir_rijek_kecil->CurrentValue;
        $row['sortir_rijek_sampah'] = $this->sortir_rijek_sampah->CurrentValue;
        $row['sortir_catatan'] = $this->sortir_catatan->CurrentValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load key values from Session
        $validKey = true;
        if (strval($this->getKey("sortir_id")) != "") {
            $this->sortir_id->OldValue = $this->getKey("sortir_id"); // sortir_id
        } else {
            $validKey = false;
        }

        // Load old record
        $this->OldRecordset = null;
        if ($validKey) {
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $this->OldRecordset = LoadRecordset($sql, $conn);
        }
        $this->loadRowValues($this->OldRecordset); // Load row values
        return $validKey;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Convert decimal values if posted back
        if ($this->sortir_okking->FormValue == $this->sortir_okking->CurrentValue && is_numeric(ConvertToFloatString($this->sortir_okking->CurrentValue))) {
            $this->sortir_okking->CurrentValue = ConvertToFloatString($this->sortir_okking->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->sortir_okl->FormValue == $this->sortir_okl->CurrentValue && is_numeric(ConvertToFloatString($this->sortir_okl->CurrentValue))) {
            $this->sortir_okl->CurrentValue = ConvertToFloatString($this->sortir_okl->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->sortir_okm->FormValue == $this->sortir_okm->CurrentValue && is_numeric(ConvertToFloatString($this->sortir_okm->CurrentValue))) {
            $this->sortir_okm->CurrentValue = ConvertToFloatString($this->sortir_okm->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->sortir_oks->FormValue == $this->sortir_oks->CurrentValue && is_numeric(ConvertToFloatString($this->sortir_oks->CurrentValue))) {
            $this->sortir_oks->CurrentValue = ConvertToFloatString($this->sortir_oks->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->sortir_okss->FormValue == $this->sortir_okss->CurrentValue && is_numeric(ConvertToFloatString($this->sortir_okss->CurrentValue))) {
            $this->sortir_okss->CurrentValue = ConvertToFloatString($this->sortir_okss->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->sortir_oktotal->FormValue == $this->sortir_oktotal->CurrentValue && is_numeric(ConvertToFloatString($this->sortir_oktotal->CurrentValue))) {
            $this->sortir_oktotal->CurrentValue = ConvertToFloatString($this->sortir_oktotal->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->sortir_rijek_busuk->FormValue == $this->sortir_rijek_busuk->CurrentValue && is_numeric(ConvertToFloatString($this->sortir_rijek_busuk->CurrentValue))) {
            $this->sortir_rijek_busuk->CurrentValue = ConvertToFloatString($this->sortir_rijek_busuk->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->sortir_rijek_kecil->FormValue == $this->sortir_rijek_kecil->CurrentValue && is_numeric(ConvertToFloatString($this->sortir_rijek_kecil->CurrentValue))) {
            $this->sortir_rijek_kecil->CurrentValue = ConvertToFloatString($this->sortir_rijek_kecil->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->sortir_rijek_sampah->FormValue == $this->sortir_rijek_sampah->CurrentValue && is_numeric(ConvertToFloatString($this->sortir_rijek_sampah->CurrentValue))) {
            $this->sortir_rijek_sampah->CurrentValue = ConvertToFloatString($this->sortir_rijek_sampah->CurrentValue);
        }

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // sortir_id

        // sortir_kedatangan

        // sortir_petugas

        // sortir_tanggal

        // sortir_okking

        // sortir_okl

        // sortir_okm

        // sortir_oks

        // sortir_okss

        // sortir_oktotal

        // sortir_rijek_busuk

        // sortir_rijek_kecil

        // sortir_rijek_sampah

        // sortir_catatan
        if ($this->RowType == ROWTYPE_VIEW) {
            // sortir_id
            $this->sortir_id->ViewValue = $this->sortir_id->CurrentValue;
            $this->sortir_id->ViewValue = FormatNumber($this->sortir_id->ViewValue, 0, -2, -2, -2);
            $this->sortir_id->ViewCustomAttributes = "";

            // sortir_kedatangan
            $curVal = strval($this->sortir_kedatangan->CurrentValue);
            if ($curVal != "") {
                $this->sortir_kedatangan->ViewValue = $this->sortir_kedatangan->lookupCacheOption($curVal);
                if ($this->sortir_kedatangan->ViewValue === null) { // Lookup from database
                    $filterWrk = "`datang_id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->sortir_kedatangan->Lookup->getSql(false, $filterWrk, '', $this, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->sortir_kedatangan->Lookup->renderViewRow($rswrk[0]);
                        $this->sortir_kedatangan->ViewValue = $this->sortir_kedatangan->displayValue($arwrk);
                    } else {
                        $this->sortir_kedatangan->ViewValue = $this->sortir_kedatangan->CurrentValue;
                    }
                }
            } else {
                $this->sortir_kedatangan->ViewValue = null;
            }
            $this->sortir_kedatangan->ViewCustomAttributes = "";

            // sortir_petugas
            $curVal = strval($this->sortir_petugas->CurrentValue);
            if ($curVal != "") {
                $this->sortir_petugas->ViewValue = $this->sortir_petugas->lookupCacheOption($curVal);
                if ($this->sortir_petugas->ViewValue === null) { // Lookup from database
                    $filterWrk = "`EmployeeID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->sortir_petugas->Lookup->getSql(false, $filterWrk, '', $this, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->sortir_petugas->Lookup->renderViewRow($rswrk[0]);
                        $this->sortir_petugas->ViewValue = $this->sortir_petugas->displayValue($arwrk);
                    } else {
                        $this->sortir_petugas->ViewValue = $this->sortir_petugas->CurrentValue;
                    }
                }
            } else {
                $this->sortir_petugas->ViewValue = null;
            }
            $this->sortir_petugas->ViewCustomAttributes = "";

            // sortir_tanggal
            $this->sortir_tanggal->ViewValue = $this->sortir_tanggal->CurrentValue;
            $this->sortir_tanggal->ViewValue = FormatDateTime($this->sortir_tanggal->ViewValue, 0);
            $this->sortir_tanggal->ViewCustomAttributes = "";

            // sortir_okking
            $this->sortir_okking->ViewValue = $this->sortir_okking->CurrentValue;
            $this->sortir_okking->ViewValue = FormatNumber($this->sortir_okking->ViewValue, 2, -2, -2, -2);
            $this->sortir_okking->ViewCustomAttributes = "";

            // sortir_okl
            $this->sortir_okl->ViewValue = $this->sortir_okl->CurrentValue;
            $this->sortir_okl->ViewValue = FormatNumber($this->sortir_okl->ViewValue, 2, -2, -2, -2);
            $this->sortir_okl->ViewCustomAttributes = "";

            // sortir_okm
            $this->sortir_okm->ViewValue = $this->sortir_okm->CurrentValue;
            $this->sortir_okm->ViewValue = FormatNumber($this->sortir_okm->ViewValue, 2, -2, -2, -2);
            $this->sortir_okm->ViewCustomAttributes = "";

            // sortir_oks
            $this->sortir_oks->ViewValue = $this->sortir_oks->CurrentValue;
            $this->sortir_oks->ViewValue = FormatNumber($this->sortir_oks->ViewValue, 2, -2, -2, -2);
            $this->sortir_oks->ViewCustomAttributes = "";

            // sortir_okss
            $this->sortir_okss->ViewValue = $this->sortir_okss->CurrentValue;
            $this->sortir_okss->ViewValue = FormatNumber($this->sortir_okss->ViewValue, 2, -2, -2, -2);
            $this->sortir_okss->ViewCustomAttributes = "";

            // sortir_oktotal
            $this->sortir_oktotal->ViewValue = $this->sortir_oktotal->CurrentValue;
            $this->sortir_oktotal->ViewValue = FormatNumber($this->sortir_oktotal->ViewValue, 2, -2, -2, -2);
            $this->sortir_oktotal->ViewCustomAttributes = "";

            // sortir_rijek_busuk
            $this->sortir_rijek_busuk->ViewValue = $this->sortir_rijek_busuk->CurrentValue;
            $this->sortir_rijek_busuk->ViewValue = FormatNumber($this->sortir_rijek_busuk->ViewValue, 2, -2, -2, -2);
            $this->sortir_rijek_busuk->ViewCustomAttributes = "";

            // sortir_rijek_kecil
            $this->sortir_rijek_kecil->ViewValue = $this->sortir_rijek_kecil->CurrentValue;
            $this->sortir_rijek_kecil->ViewValue = FormatNumber($this->sortir_rijek_kecil->ViewValue, 2, -2, -2, -2);
            $this->sortir_rijek_kecil->ViewCustomAttributes = "";

            // sortir_rijek_sampah
            $this->sortir_rijek_sampah->ViewValue = $this->sortir_rijek_sampah->CurrentValue;
            $this->sortir_rijek_sampah->ViewValue = FormatNumber($this->sortir_rijek_sampah->ViewValue, 2, -2, -2, -2);
            $this->sortir_rijek_sampah->ViewCustomAttributes = "";

            // sortir_catatan
            $this->sortir_catatan->ViewValue = $this->sortir_catatan->CurrentValue;
            $this->sortir_catatan->ViewCustomAttributes = "";

            // sortir_kedatangan
            $this->sortir_kedatangan->LinkCustomAttributes = "";
            $this->sortir_kedatangan->HrefValue = "";
            $this->sortir_kedatangan->TooltipValue = "";

            // sortir_petugas
            $this->sortir_petugas->LinkCustomAttributes = "";
            $this->sortir_petugas->HrefValue = "";
            $this->sortir_petugas->TooltipValue = "";

            // sortir_tanggal
            $this->sortir_tanggal->LinkCustomAttributes = "";
            $this->sortir_tanggal->HrefValue = "";
            $this->sortir_tanggal->TooltipValue = "";

            // sortir_okking
            $this->sortir_okking->LinkCustomAttributes = "";
            $this->sortir_okking->HrefValue = "";
            $this->sortir_okking->TooltipValue = "";

            // sortir_okl
            $this->sortir_okl->LinkCustomAttributes = "";
            $this->sortir_okl->HrefValue = "";
            $this->sortir_okl->TooltipValue = "";

            // sortir_okm
            $this->sortir_okm->LinkCustomAttributes = "";
            $this->sortir_okm->HrefValue = "";
            $this->sortir_okm->TooltipValue = "";

            // sortir_oks
            $this->sortir_oks->LinkCustomAttributes = "";
            $this->sortir_oks->HrefValue = "";
            $this->sortir_oks->TooltipValue = "";

            // sortir_okss
            $this->sortir_okss->LinkCustomAttributes = "";
            $this->sortir_okss->HrefValue = "";
            $this->sortir_okss->TooltipValue = "";

            // sortir_oktotal
            $this->sortir_oktotal->LinkCustomAttributes = "";
            $this->sortir_oktotal->HrefValue = "";
            $this->sortir_oktotal->TooltipValue = "";

            // sortir_rijek_busuk
            $this->sortir_rijek_busuk->LinkCustomAttributes = "";
            $this->sortir_rijek_busuk->HrefValue = "";
            $this->sortir_rijek_busuk->TooltipValue = "";

            // sortir_rijek_kecil
            $this->sortir_rijek_kecil->LinkCustomAttributes = "";
            $this->sortir_rijek_kecil->HrefValue = "";
            $this->sortir_rijek_kecil->TooltipValue = "";

            // sortir_rijek_sampah
            $this->sortir_rijek_sampah->LinkCustomAttributes = "";
            $this->sortir_rijek_sampah->HrefValue = "";
            $this->sortir_rijek_sampah->TooltipValue = "";

            // sortir_catatan
            $this->sortir_catatan->LinkCustomAttributes = "";
            $this->sortir_catatan->HrefValue = "";
            $this->sortir_catatan->TooltipValue = "";
        } elseif ($this->RowType == ROWTYPE_ADD) {
            // sortir_kedatangan
            $this->sortir_kedatangan->EditAttrs["class"] = "form-control";
            $this->sortir_kedatangan->EditCustomAttributes = "";
            $curVal = trim(strval($this->sortir_kedatangan->CurrentValue));
            if ($curVal != "") {
                $this->sortir_kedatangan->ViewValue = $this->sortir_kedatangan->lookupCacheOption($curVal);
            } else {
                $this->sortir_kedatangan->ViewValue = $this->sortir_kedatangan->Lookup !== null && is_array($this->sortir_kedatangan->Lookup->Options) ? $curVal : null;
            }
            if ($this->sortir_kedatangan->ViewValue !== null) { // Load from cache
                $this->sortir_kedatangan->EditValue = array_values($this->sortir_kedatangan->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`datang_id`" . SearchString("=", $this->sortir_kedatangan->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->sortir_kedatangan->Lookup->getSql(true, $filterWrk, '', $this);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row)
                    $row = $this->sortir_kedatangan->Lookup->renderViewRow($row);
                $this->sortir_kedatangan->EditValue = $arwrk;
            }
            $this->sortir_kedatangan->PlaceHolder = RemoveHtml($this->sortir_kedatangan->caption());

            // sortir_petugas

            // sortir_tanggal
            $this->sortir_tanggal->EditAttrs["class"] = "form-control";
            $this->sortir_tanggal->EditCustomAttributes = "";
            $this->sortir_tanggal->EditValue = HtmlEncode(FormatDateTime($this->sortir_tanggal->CurrentValue, 8));
            $this->sortir_tanggal->PlaceHolder = RemoveHtml($this->sortir_tanggal->caption());

            // sortir_okking
            $this->sortir_okking->EditAttrs["class"] = "form-control";
            $this->sortir_okking->EditCustomAttributes = "";
            $this->sortir_okking->EditValue = HtmlEncode($this->sortir_okking->CurrentValue);
            $this->sortir_okking->PlaceHolder = RemoveHtml($this->sortir_okking->caption());
            if (strval($this->sortir_okking->EditValue) != "" && is_numeric($this->sortir_okking->EditValue)) {
                $this->sortir_okking->EditValue = FormatNumber($this->sortir_okking->EditValue, -2, -2, -2, -2);
            }

            // sortir_okl
            $this->sortir_okl->EditAttrs["class"] = "form-control";
            $this->sortir_okl->EditCustomAttributes = "";
            $this->sortir_okl->EditValue = HtmlEncode($this->sortir_okl->CurrentValue);
            $this->sortir_okl->PlaceHolder = RemoveHtml($this->sortir_okl->caption());
            if (strval($this->sortir_okl->EditValue) != "" && is_numeric($this->sortir_okl->EditValue)) {
                $this->sortir_okl->EditValue = FormatNumber($this->sortir_okl->EditValue, -2, -2, -2, -2);
            }

            // sortir_okm
            $this->sortir_okm->EditAttrs["class"] = "form-control";
            $this->sortir_okm->EditCustomAttributes = "";
            $this->sortir_okm->EditValue = HtmlEncode($this->sortir_okm->CurrentValue);
            $this->sortir_okm->PlaceHolder = RemoveHtml($this->sortir_okm->caption());
            if (strval($this->sortir_okm->EditValue) != "" && is_numeric($this->sortir_okm->EditValue)) {
                $this->sortir_okm->EditValue = FormatNumber($this->sortir_okm->EditValue, -2, -2, -2, -2);
            }

            // sortir_oks
            $this->sortir_oks->EditAttrs["class"] = "form-control";
            $this->sortir_oks->EditCustomAttributes = "";
            $this->sortir_oks->EditValue = HtmlEncode($this->sortir_oks->CurrentValue);
            $this->sortir_oks->PlaceHolder = RemoveHtml($this->sortir_oks->caption());
            if (strval($this->sortir_oks->EditValue) != "" && is_numeric($this->sortir_oks->EditValue)) {
                $this->sortir_oks->EditValue = FormatNumber($this->sortir_oks->EditValue, -2, -2, -2, -2);
            }

            // sortir_okss
            $this->sortir_okss->EditAttrs["class"] = "form-control";
            $this->sortir_okss->EditCustomAttributes = "";
            $this->sortir_okss->EditValue = HtmlEncode($this->sortir_okss->CurrentValue);
            $this->sortir_okss->PlaceHolder = RemoveHtml($this->sortir_okss->caption());
            if (strval($this->sortir_okss->EditValue) != "" && is_numeric($this->sortir_okss->EditValue)) {
                $this->sortir_okss->EditValue = FormatNumber($this->sortir_okss->EditValue, -2, -2, -2, -2);
            }

            // sortir_oktotal
            $this->sortir_oktotal->EditAttrs["class"] = "form-control";
            $this->sortir_oktotal->EditCustomAttributes = "";
            $this->sortir_oktotal->EditValue = HtmlEncode($this->sortir_oktotal->CurrentValue);
            $this->sortir_oktotal->PlaceHolder = RemoveHtml($this->sortir_oktotal->caption());
            if (strval($this->sortir_oktotal->EditValue) != "" && is_numeric($this->sortir_oktotal->EditValue)) {
                $this->sortir_oktotal->EditValue = FormatNumber($this->sortir_oktotal->EditValue, -2, -2, -2, -2);
            }

            // sortir_rijek_busuk
            $this->sortir_rijek_busuk->EditAttrs["class"] = "form-control";
            $this->sortir_rijek_busuk->EditCustomAttributes = "";
            $this->sortir_rijek_busuk->EditValue = HtmlEncode($this->sortir_rijek_busuk->CurrentValue);
            $this->sortir_rijek_busuk->PlaceHolder = RemoveHtml($this->sortir_rijek_busuk->caption());
            if (strval($this->sortir_rijek_busuk->EditValue) != "" && is_numeric($this->sortir_rijek_busuk->EditValue)) {
                $this->sortir_rijek_busuk->EditValue = FormatNumber($this->sortir_rijek_busuk->EditValue, -2, -2, -2, -2);
            }

            // sortir_rijek_kecil
            $this->sortir_rijek_kecil->EditAttrs["class"] = "form-control";
            $this->sortir_rijek_kecil->EditCustomAttributes = "";
            $this->sortir_rijek_kecil->EditValue = HtmlEncode($this->sortir_rijek_kecil->CurrentValue);
            $this->sortir_rijek_kecil->PlaceHolder = RemoveHtml($this->sortir_rijek_kecil->caption());
            if (strval($this->sortir_rijek_kecil->EditValue) != "" && is_numeric($this->sortir_rijek_kecil->EditValue)) {
                $this->sortir_rijek_kecil->EditValue = FormatNumber($this->sortir_rijek_kecil->EditValue, -2, -2, -2, -2);
            }

            // sortir_rijek_sampah
            $this->sortir_rijek_sampah->EditAttrs["class"] = "form-control";
            $this->sortir_rijek_sampah->EditCustomAttributes = "";
            $this->sortir_rijek_sampah->EditValue = HtmlEncode($this->sortir_rijek_sampah->CurrentValue);
            $this->sortir_rijek_sampah->PlaceHolder = RemoveHtml($this->sortir_rijek_sampah->caption());
            if (strval($this->sortir_rijek_sampah->EditValue) != "" && is_numeric($this->sortir_rijek_sampah->EditValue)) {
                $this->sortir_rijek_sampah->EditValue = FormatNumber($this->sortir_rijek_sampah->EditValue, -2, -2, -2, -2);
            }

            // sortir_catatan
            $this->sortir_catatan->EditAttrs["class"] = "form-control";
            $this->sortir_catatan->EditCustomAttributes = "";
            $this->sortir_catatan->EditValue = HtmlEncode($this->sortir_catatan->CurrentValue);
            $this->sortir_catatan->PlaceHolder = RemoveHtml($this->sortir_catatan->caption());

            // Add refer script

            // sortir_kedatangan
            $this->sortir_kedatangan->LinkCustomAttributes = "";
            $this->sortir_kedatangan->HrefValue = "";

            // sortir_petugas
            $this->sortir_petugas->LinkCustomAttributes = "";
            $this->sortir_petugas->HrefValue = "";

            // sortir_tanggal
            $this->sortir_tanggal->LinkCustomAttributes = "";
            $this->sortir_tanggal->HrefValue = "";

            // sortir_okking
            $this->sortir_okking->LinkCustomAttributes = "";
            $this->sortir_okking->HrefValue = "";

            // sortir_okl
            $this->sortir_okl->LinkCustomAttributes = "";
            $this->sortir_okl->HrefValue = "";

            // sortir_okm
            $this->sortir_okm->LinkCustomAttributes = "";
            $this->sortir_okm->HrefValue = "";

            // sortir_oks
            $this->sortir_oks->LinkCustomAttributes = "";
            $this->sortir_oks->HrefValue = "";

            // sortir_okss
            $this->sortir_okss->LinkCustomAttributes = "";
            $this->sortir_okss->HrefValue = "";

            // sortir_oktotal
            $this->sortir_oktotal->LinkCustomAttributes = "";
            $this->sortir_oktotal->HrefValue = "";

            // sortir_rijek_busuk
            $this->sortir_rijek_busuk->LinkCustomAttributes = "";
            $this->sortir_rijek_busuk->HrefValue = "";

            // sortir_rijek_kecil
            $this->sortir_rijek_kecil->LinkCustomAttributes = "";
            $this->sortir_rijek_kecil->HrefValue = "";

            // sortir_rijek_sampah
            $this->sortir_rijek_sampah->LinkCustomAttributes = "";
            $this->sortir_rijek_sampah->HrefValue = "";

            // sortir_catatan
            $this->sortir_catatan->LinkCustomAttributes = "";
            $this->sortir_catatan->HrefValue = "";
        }
        if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if ($this->sortir_kedatangan->Required) {
            if (!$this->sortir_kedatangan->IsDetailKey && EmptyValue($this->sortir_kedatangan->FormValue)) {
                $this->sortir_kedatangan->addErrorMessage(str_replace("%s", $this->sortir_kedatangan->caption(), $this->sortir_kedatangan->RequiredErrorMessage));
            }
        }
        if ($this->sortir_petugas->Required) {
            if (!$this->sortir_petugas->IsDetailKey && EmptyValue($this->sortir_petugas->FormValue)) {
                $this->sortir_petugas->addErrorMessage(str_replace("%s", $this->sortir_petugas->caption(), $this->sortir_petugas->RequiredErrorMessage));
            }
        }
        if ($this->sortir_tanggal->Required) {
            if (!$this->sortir_tanggal->IsDetailKey && EmptyValue($this->sortir_tanggal->FormValue)) {
                $this->sortir_tanggal->addErrorMessage(str_replace("%s", $this->sortir_tanggal->caption(), $this->sortir_tanggal->RequiredErrorMessage));
            }
        }
        if (!CheckDate($this->sortir_tanggal->FormValue)) {
            $this->sortir_tanggal->addErrorMessage($this->sortir_tanggal->getErrorMessage(false));
        }
        if ($this->sortir_okking->Required) {
            if (!$this->sortir_okking->IsDetailKey && EmptyValue($this->sortir_okking->FormValue)) {
                $this->sortir_okking->addErrorMessage(str_replace("%s", $this->sortir_okking->caption(), $this->sortir_okking->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->sortir_okking->FormValue)) {
            $this->sortir_okking->addErrorMessage($this->sortir_okking->getErrorMessage(false));
        }
        if ($this->sortir_okl->Required) {
            if (!$this->sortir_okl->IsDetailKey && EmptyValue($this->sortir_okl->FormValue)) {
                $this->sortir_okl->addErrorMessage(str_replace("%s", $this->sortir_okl->caption(), $this->sortir_okl->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->sortir_okl->FormValue)) {
            $this->sortir_okl->addErrorMessage($this->sortir_okl->getErrorMessage(false));
        }
        if ($this->sortir_okm->Required) {
            if (!$this->sortir_okm->IsDetailKey && EmptyValue($this->sortir_okm->FormValue)) {
                $this->sortir_okm->addErrorMessage(str_replace("%s", $this->sortir_okm->caption(), $this->sortir_okm->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->sortir_okm->FormValue)) {
            $this->sortir_okm->addErrorMessage($this->sortir_okm->getErrorMessage(false));
        }
        if ($this->sortir_oks->Required) {
            if (!$this->sortir_oks->IsDetailKey && EmptyValue($this->sortir_oks->FormValue)) {
                $this->sortir_oks->addErrorMessage(str_replace("%s", $this->sortir_oks->caption(), $this->sortir_oks->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->sortir_oks->FormValue)) {
            $this->sortir_oks->addErrorMessage($this->sortir_oks->getErrorMessage(false));
        }
        if ($this->sortir_okss->Required) {
            if (!$this->sortir_okss->IsDetailKey && EmptyValue($this->sortir_okss->FormValue)) {
                $this->sortir_okss->addErrorMessage(str_replace("%s", $this->sortir_okss->caption(), $this->sortir_okss->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->sortir_okss->FormValue)) {
            $this->sortir_okss->addErrorMessage($this->sortir_okss->getErrorMessage(false));
        }
        if ($this->sortir_oktotal->Required) {
            if (!$this->sortir_oktotal->IsDetailKey && EmptyValue($this->sortir_oktotal->FormValue)) {
                $this->sortir_oktotal->addErrorMessage(str_replace("%s", $this->sortir_oktotal->caption(), $this->sortir_oktotal->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->sortir_oktotal->FormValue)) {
            $this->sortir_oktotal->addErrorMessage($this->sortir_oktotal->getErrorMessage(false));
        }
        if ($this->sortir_rijek_busuk->Required) {
            if (!$this->sortir_rijek_busuk->IsDetailKey && EmptyValue($this->sortir_rijek_busuk->FormValue)) {
                $this->sortir_rijek_busuk->addErrorMessage(str_replace("%s", $this->sortir_rijek_busuk->caption(), $this->sortir_rijek_busuk->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->sortir_rijek_busuk->FormValue)) {
            $this->sortir_rijek_busuk->addErrorMessage($this->sortir_rijek_busuk->getErrorMessage(false));
        }
        if ($this->sortir_rijek_kecil->Required) {
            if (!$this->sortir_rijek_kecil->IsDetailKey && EmptyValue($this->sortir_rijek_kecil->FormValue)) {
                $this->sortir_rijek_kecil->addErrorMessage(str_replace("%s", $this->sortir_rijek_kecil->caption(), $this->sortir_rijek_kecil->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->sortir_rijek_kecil->FormValue)) {
            $this->sortir_rijek_kecil->addErrorMessage($this->sortir_rijek_kecil->getErrorMessage(false));
        }
        if ($this->sortir_rijek_sampah->Required) {
            if (!$this->sortir_rijek_sampah->IsDetailKey && EmptyValue($this->sortir_rijek_sampah->FormValue)) {
                $this->sortir_rijek_sampah->addErrorMessage(str_replace("%s", $this->sortir_rijek_sampah->caption(), $this->sortir_rijek_sampah->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->sortir_rijek_sampah->FormValue)) {
            $this->sortir_rijek_sampah->addErrorMessage($this->sortir_rijek_sampah->getErrorMessage(false));
        }
        if ($this->sortir_catatan->Required) {
            if (!$this->sortir_catatan->IsDetailKey && EmptyValue($this->sortir_catatan->FormValue)) {
                $this->sortir_catatan->addErrorMessage(str_replace("%s", $this->sortir_catatan->caption(), $this->sortir_catatan->RequiredErrorMessage));
            }
        }

        // Return validate result
        $validateForm = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;
        $conn = $this->getConnection();

        // Load db values from rsold
        $this->loadDbValues($rsold);
        if ($rsold) {
        }
        $rsnew = [];

        // sortir_kedatangan
        $this->sortir_kedatangan->setDbValueDef($rsnew, $this->sortir_kedatangan->CurrentValue, 0, false);

        // sortir_petugas
        $this->sortir_petugas->CurrentValue = CurrentUserName();
        $this->sortir_petugas->setDbValueDef($rsnew, $this->sortir_petugas->CurrentValue, 0);

        // sortir_tanggal
        $this->sortir_tanggal->setDbValueDef($rsnew, UnFormatDateTime($this->sortir_tanggal->CurrentValue, 0), CurrentDate(), false);

        // sortir_okking
        $this->sortir_okking->setDbValueDef($rsnew, $this->sortir_okking->CurrentValue, 0, false);

        // sortir_okl
        $this->sortir_okl->setDbValueDef($rsnew, $this->sortir_okl->CurrentValue, 0, false);

        // sortir_okm
        $this->sortir_okm->setDbValueDef($rsnew, $this->sortir_okm->CurrentValue, 0, false);

        // sortir_oks
        $this->sortir_oks->setDbValueDef($rsnew, $this->sortir_oks->CurrentValue, 0, false);

        // sortir_okss
        $this->sortir_okss->setDbValueDef($rsnew, $this->sortir_okss->CurrentValue, 0, false);

        // sortir_oktotal
        $this->sortir_oktotal->setDbValueDef($rsnew, $this->sortir_oktotal->CurrentValue, 0, false);

        // sortir_rijek_busuk
        $this->sortir_rijek_busuk->setDbValueDef($rsnew, $this->sortir_rijek_busuk->CurrentValue, 0, false);

        // sortir_rijek_kecil
        $this->sortir_rijek_kecil->setDbValueDef($rsnew, $this->sortir_rijek_kecil->CurrentValue, 0, false);

        // sortir_rijek_sampah
        $this->sortir_rijek_sampah->setDbValueDef($rsnew, $this->sortir_rijek_sampah->CurrentValue, 0, false);

        // sortir_catatan
        $this->sortir_catatan->setDbValueDef($rsnew, $this->sortir_catatan->CurrentValue, "", false);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Clean upload path if any
        if ($addRow) {
        }

        // Write JSON for API request
        if (IsApi() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            WriteJson(["success" => true, $this->TableVar => $row]);
        }
        return $addRow;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("KedatanganList");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("SortirList"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_sortir_kedatangan":
                    break;
                case "x_sortir_petugas":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll(\PDO::FETCH_BOTH);
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row);
                    $ar[strval($row[0])] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in CustomError
        return true;
    }
}
