<?php

namespace PHPMaker2021\gudang_ubi;

use Slim\App;
use Slim\Routing\RouteCollectorProxy;

// Handle Routes
return function (App $app) {
    // employees
    $app->any('/EmployeesList[/{EmployeeID}]', EmployeesController::class . ':list')->add(PermissionMiddleware::class)->setName('EmployeesList-employees-list'); // list
    $app->any('/EmployeesAdd[/{EmployeeID}]', EmployeesController::class . ':add')->add(PermissionMiddleware::class)->setName('EmployeesAdd-employees-add'); // add
    $app->any('/EmployeesView[/{EmployeeID}]', EmployeesController::class . ':view')->add(PermissionMiddleware::class)->setName('EmployeesView-employees-view'); // view
    $app->any('/EmployeesEdit[/{EmployeeID}]', EmployeesController::class . ':edit')->add(PermissionMiddleware::class)->setName('EmployeesEdit-employees-edit'); // edit
    $app->any('/EmployeesDelete[/{EmployeeID}]', EmployeesController::class . ':delete')->add(PermissionMiddleware::class)->setName('EmployeesDelete-employees-delete'); // delete
    $app->group(
        '/employees',
        function (RouteCollectorProxy $group) {
            $group->any('/list[/{EmployeeID}]', EmployeesController::class . ':list')->add(PermissionMiddleware::class)->setName('employees/list-employees-list-2'); // list
            $group->any('/add[/{EmployeeID}]', EmployeesController::class . ':add')->add(PermissionMiddleware::class)->setName('employees/add-employees-add-2'); // add
            $group->any('/view[/{EmployeeID}]', EmployeesController::class . ':view')->add(PermissionMiddleware::class)->setName('employees/view-employees-view-2'); // view
            $group->any('/edit[/{EmployeeID}]', EmployeesController::class . ':edit')->add(PermissionMiddleware::class)->setName('employees/edit-employees-edit-2'); // edit
            $group->any('/delete[/{EmployeeID}]', EmployeesController::class . ':delete')->add(PermissionMiddleware::class)->setName('employees/delete-employees-delete-2'); // delete
        }
    );

    // kedatangan
    $app->any('/KedatanganList[/{datang_id}]', KedatanganController::class . ':list')->add(PermissionMiddleware::class)->setName('KedatanganList-kedatangan-list'); // list
    $app->any('/KedatanganAdd[/{datang_id}]', KedatanganController::class . ':add')->add(PermissionMiddleware::class)->setName('KedatanganAdd-kedatangan-add'); // add
    $app->group(
        '/kedatangan',
        function (RouteCollectorProxy $group) {
            $group->any('/list[/{datang_id}]', KedatanganController::class . ':list')->add(PermissionMiddleware::class)->setName('kedatangan/list-kedatangan-list-2'); // list
            $group->any('/add[/{datang_id}]', KedatanganController::class . ':add')->add(PermissionMiddleware::class)->setName('kedatangan/add-kedatangan-add-2'); // add
        }
    );

    // sortir
    $app->any('/SortirList[/{sortir_id}]', SortirController::class . ':list')->add(PermissionMiddleware::class)->setName('SortirList-sortir-list'); // list
    $app->any('/SortirAdd[/{sortir_id}]', SortirController::class . ':add')->add(PermissionMiddleware::class)->setName('SortirAdd-sortir-add'); // add
    $app->group(
        '/sortir',
        function (RouteCollectorProxy $group) {
            $group->any('/list[/{sortir_id}]', SortirController::class . ':list')->add(PermissionMiddleware::class)->setName('sortir/list-sortir-list-2'); // list
            $group->any('/add[/{sortir_id}]', SortirController::class . ':add')->add(PermissionMiddleware::class)->setName('sortir/add-sortir-add-2'); // add
        }
    );

    // sup
    $app->any('/SupList[/{sup_id}]', SupController::class . ':list')->add(PermissionMiddleware::class)->setName('SupList-sup-list'); // list
    $app->any('/SupAdd[/{sup_id}]', SupController::class . ':add')->add(PermissionMiddleware::class)->setName('SupAdd-sup-add'); // add
    $app->any('/SupView[/{sup_id}]', SupController::class . ':view')->add(PermissionMiddleware::class)->setName('SupView-sup-view'); // view
    $app->any('/SupEdit[/{sup_id}]', SupController::class . ':edit')->add(PermissionMiddleware::class)->setName('SupEdit-sup-edit'); // edit
    $app->any('/SupDelete[/{sup_id}]', SupController::class . ':delete')->add(PermissionMiddleware::class)->setName('SupDelete-sup-delete'); // delete
    $app->group(
        '/sup',
        function (RouteCollectorProxy $group) {
            $group->any('/list[/{sup_id}]', SupController::class . ':list')->add(PermissionMiddleware::class)->setName('sup/list-sup-list-2'); // list
            $group->any('/add[/{sup_id}]', SupController::class . ':add')->add(PermissionMiddleware::class)->setName('sup/add-sup-add-2'); // add
            $group->any('/view[/{sup_id}]', SupController::class . ':view')->add(PermissionMiddleware::class)->setName('sup/view-sup-view-2'); // view
            $group->any('/edit[/{sup_id}]', SupController::class . ':edit')->add(PermissionMiddleware::class)->setName('sup/edit-sup-edit-2'); // edit
            $group->any('/delete[/{sup_id}]', SupController::class . ':delete')->add(PermissionMiddleware::class)->setName('sup/delete-sup-delete-2'); // delete
        }
    );

    // userlevelpermissions
    $app->any('/UserlevelpermissionsList[/{userlevelid}/{_tablename}]', UserlevelpermissionsController::class . ':list')->add(PermissionMiddleware::class)->setName('UserlevelpermissionsList-userlevelpermissions-list'); // list
    $app->any('/UserlevelpermissionsAdd[/{userlevelid}/{_tablename}]', UserlevelpermissionsController::class . ':add')->add(PermissionMiddleware::class)->setName('UserlevelpermissionsAdd-userlevelpermissions-add'); // add
    $app->any('/UserlevelpermissionsView[/{userlevelid}/{_tablename}]', UserlevelpermissionsController::class . ':view')->add(PermissionMiddleware::class)->setName('UserlevelpermissionsView-userlevelpermissions-view'); // view
    $app->any('/UserlevelpermissionsEdit[/{userlevelid}/{_tablename}]', UserlevelpermissionsController::class . ':edit')->add(PermissionMiddleware::class)->setName('UserlevelpermissionsEdit-userlevelpermissions-edit'); // edit
    $app->any('/UserlevelpermissionsDelete[/{userlevelid}/{_tablename}]', UserlevelpermissionsController::class . ':delete')->add(PermissionMiddleware::class)->setName('UserlevelpermissionsDelete-userlevelpermissions-delete'); // delete
    $app->group(
        '/userlevelpermissions',
        function (RouteCollectorProxy $group) {
            $group->any('/list[/{userlevelid}/{_tablename}]', UserlevelpermissionsController::class . ':list')->add(PermissionMiddleware::class)->setName('userlevelpermissions/list-userlevelpermissions-list-2'); // list
            $group->any('/add[/{userlevelid}/{_tablename}]', UserlevelpermissionsController::class . ':add')->add(PermissionMiddleware::class)->setName('userlevelpermissions/add-userlevelpermissions-add-2'); // add
            $group->any('/view[/{userlevelid}/{_tablename}]', UserlevelpermissionsController::class . ':view')->add(PermissionMiddleware::class)->setName('userlevelpermissions/view-userlevelpermissions-view-2'); // view
            $group->any('/edit[/{userlevelid}/{_tablename}]', UserlevelpermissionsController::class . ':edit')->add(PermissionMiddleware::class)->setName('userlevelpermissions/edit-userlevelpermissions-edit-2'); // edit
            $group->any('/delete[/{userlevelid}/{_tablename}]', UserlevelpermissionsController::class . ':delete')->add(PermissionMiddleware::class)->setName('userlevelpermissions/delete-userlevelpermissions-delete-2'); // delete
        }
    );

    // userlevels
    $app->any('/UserlevelsList[/{userlevelid}]', UserlevelsController::class . ':list')->add(PermissionMiddleware::class)->setName('UserlevelsList-userlevels-list'); // list
    $app->any('/UserlevelsAdd[/{userlevelid}]', UserlevelsController::class . ':add')->add(PermissionMiddleware::class)->setName('UserlevelsAdd-userlevels-add'); // add
    $app->any('/UserlevelsView[/{userlevelid}]', UserlevelsController::class . ':view')->add(PermissionMiddleware::class)->setName('UserlevelsView-userlevels-view'); // view
    $app->any('/UserlevelsEdit[/{userlevelid}]', UserlevelsController::class . ':edit')->add(PermissionMiddleware::class)->setName('UserlevelsEdit-userlevels-edit'); // edit
    $app->any('/UserlevelsDelete[/{userlevelid}]', UserlevelsController::class . ':delete')->add(PermissionMiddleware::class)->setName('UserlevelsDelete-userlevels-delete'); // delete
    $app->group(
        '/userlevels',
        function (RouteCollectorProxy $group) {
            $group->any('/list[/{userlevelid}]', UserlevelsController::class . ':list')->add(PermissionMiddleware::class)->setName('userlevels/list-userlevels-list-2'); // list
            $group->any('/add[/{userlevelid}]', UserlevelsController::class . ':add')->add(PermissionMiddleware::class)->setName('userlevels/add-userlevels-add-2'); // add
            $group->any('/view[/{userlevelid}]', UserlevelsController::class . ':view')->add(PermissionMiddleware::class)->setName('userlevels/view-userlevels-view-2'); // view
            $group->any('/edit[/{userlevelid}]', UserlevelsController::class . ':edit')->add(PermissionMiddleware::class)->setName('userlevels/edit-userlevels-edit-2'); // edit
            $group->any('/delete[/{userlevelid}]', UserlevelsController::class . ':delete')->add(PermissionMiddleware::class)->setName('userlevels/delete-userlevels-delete-2'); // delete
        }
    );

    // varietas
    $app->any('/VarietasList[/{var_id}]', VarietasController::class . ':list')->add(PermissionMiddleware::class)->setName('VarietasList-varietas-list'); // list
    $app->any('/VarietasAdd[/{var_id}]', VarietasController::class . ':add')->add(PermissionMiddleware::class)->setName('VarietasAdd-varietas-add'); // add
    $app->any('/VarietasView[/{var_id}]', VarietasController::class . ':view')->add(PermissionMiddleware::class)->setName('VarietasView-varietas-view'); // view
    $app->any('/VarietasEdit[/{var_id}]', VarietasController::class . ':edit')->add(PermissionMiddleware::class)->setName('VarietasEdit-varietas-edit'); // edit
    $app->any('/VarietasDelete[/{var_id}]', VarietasController::class . ':delete')->add(PermissionMiddleware::class)->setName('VarietasDelete-varietas-delete'); // delete
    $app->group(
        '/varietas',
        function (RouteCollectorProxy $group) {
            $group->any('/list[/{var_id}]', VarietasController::class . ':list')->add(PermissionMiddleware::class)->setName('varietas/list-varietas-list-2'); // list
            $group->any('/add[/{var_id}]', VarietasController::class . ':add')->add(PermissionMiddleware::class)->setName('varietas/add-varietas-add-2'); // add
            $group->any('/view[/{var_id}]', VarietasController::class . ':view')->add(PermissionMiddleware::class)->setName('varietas/view-varietas-view-2'); // view
            $group->any('/edit[/{var_id}]', VarietasController::class . ':edit')->add(PermissionMiddleware::class)->setName('varietas/edit-varietas-edit-2'); // edit
            $group->any('/delete[/{var_id}]', VarietasController::class . ':delete')->add(PermissionMiddleware::class)->setName('varietas/delete-varietas-delete-2'); // delete
        }
    );

    // error
    $app->any('/error', OthersController::class . ':error')->add(PermissionMiddleware::class)->setName('error');

    // personal_data
    $app->any('/personaldata', OthersController::class . ':personaldata')->add(PermissionMiddleware::class)->setName('personaldata');

    // login
    $app->any('/login', OthersController::class . ':login')->add(PermissionMiddleware::class)->setName('login');

    // userpriv
    $app->any('/userpriv', OthersController::class . ':userpriv')->add(PermissionMiddleware::class)->setName('userpriv');

    // logout
    $app->any('/logout', OthersController::class . ':logout')->add(PermissionMiddleware::class)->setName('logout');

    // Index
    $app->any('/[index]', OthersController::class . ':index')->setName('index');
    if (function_exists(PROJECT_NAMESPACE . "Route_Action")) {
        Route_Action($app);
    }

    /**
     * Catch-all route to serve a 404 Not Found page if none of the routes match
     * NOTE: Make sure this route is defined last.
     */
    $app->map(
        ['GET', 'POST', 'PUT', 'DELETE', 'PATCH'],
        '/{routes:.+}',
        function ($request, $response, $params) {
            $error = [
                "statusCode" => "404",
                "error" => [
                    "class" => "text-warning",
                    "type" => Container("language")->phrase("Error"),
                    "description" => str_replace("%p", $params["routes"], Container("language")->phrase("PageNotFound")),
                ],
            ];
            Container("flash")->addMessage("error", $error);
            return $response->withStatus(302)->withHeader("Location", GetUrl("error")); // Redirect to error page
        }
    );
};
