<?php

namespace PHPMaker2021\gudang_ubi;

use Doctrine\DBAL\ParameterType;

/**
 * Page class
 */
class SortirList extends Sortir
{
    // Page ID
    public $PageID = "list";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Table name
    public $TableName = 'sortir';

    // Page object name
    public $PageObjName = "SortirList";

    // Rendering View
    public $RenderingView = false;

    // Custom template
    public $UseCustomTemplate = false;

    // Grid form hidden field names
    public $FormName = "fsortirlist";
    public $FormActionName = "k_action";
    public $FormKeyName = "k_key";
    public $FormOldKeyName = "k_oldkey";
    public $FormBlankRowName = "k_blankrow";
    public $FormKeyCountName = "key_count";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $CopyUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $ListUrl;

    // Export URLs
    public $ExportPrintUrl;
    public $ExportHtmlUrl;
    public $ExportExcelUrl;
    public $ExportWordUrl;
    public $ExportXmlUrl;
    public $ExportCsvUrl;
    public $ExportPdfUrl;

    // Custom export
    public $ExportExcelCustom = false;
    public $ExportWordCustom = false;
    public $ExportPdfCustom = false;
    public $ExportEmailCustom = false;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl()
    {
        $url = ScriptName() . "?";
        if ($this->UseTokenInUrl) {
            $url .= "t=" . $this->TableVar . "&"; // Add page token
        }
        return $url;
    }

    // Messages
    private $message = "";
    private $failureMessage = "";
    private $successMessage = "";
    private $warningMessage = "";

    // Get message
    public function getMessage()
    {
        return $_SESSION[SESSION_MESSAGE] ?? $this->message;
    }

    // Set message
    public function setMessage($v)
    {
        AddMessage($this->message, $v);
        $_SESSION[SESSION_MESSAGE] = $this->message;
    }

    // Get failure message
    public function getFailureMessage()
    {
        return $_SESSION[SESSION_FAILURE_MESSAGE] ?? $this->failureMessage;
    }

    // Set failure message
    public function setFailureMessage($v)
    {
        AddMessage($this->failureMessage, $v);
        $_SESSION[SESSION_FAILURE_MESSAGE] = $this->failureMessage;
    }

    // Get success message
    public function getSuccessMessage()
    {
        return $_SESSION[SESSION_SUCCESS_MESSAGE] ?? $this->successMessage;
    }

    // Set success message
    public function setSuccessMessage($v)
    {
        AddMessage($this->successMessage, $v);
        $_SESSION[SESSION_SUCCESS_MESSAGE] = $this->successMessage;
    }

    // Get warning message
    public function getWarningMessage()
    {
        return $_SESSION[SESSION_WARNING_MESSAGE] ?? $this->warningMessage;
    }

    // Set warning message
    public function setWarningMessage($v)
    {
        AddMessage($this->warningMessage, $v);
        $_SESSION[SESSION_WARNING_MESSAGE] = $this->warningMessage;
    }

    // Clear message
    public function clearMessage()
    {
        $this->message = "";
        $_SESSION[SESSION_MESSAGE] = "";
    }

    // Clear failure message
    public function clearFailureMessage()
    {
        $this->failureMessage = "";
        $_SESSION[SESSION_FAILURE_MESSAGE] = "";
    }

    // Clear success message
    public function clearSuccessMessage()
    {
        $this->successMessage = "";
        $_SESSION[SESSION_SUCCESS_MESSAGE] = "";
    }

    // Clear warning message
    public function clearWarningMessage()
    {
        $this->warningMessage = "";
        $_SESSION[SESSION_WARNING_MESSAGE] = "";
    }

    // Clear messages
    public function clearMessages()
    {
        $this->clearMessage();
        $this->clearFailureMessage();
        $this->clearSuccessMessage();
        $this->clearWarningMessage();
    }

    // Show message
    public function showMessage()
    {
        $hidden = true;
        $html = "";
        // Message
        $message = $this->getMessage();
        if (method_exists($this, "messageShowing")) {
            $this->messageShowing($message, "");
        }
        if ($message != "") { // Message in Session, display
            if (!$hidden) {
                $message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
            }
            $html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
            $_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
        }
        // Warning message
        $warningMessage = $this->getWarningMessage();
        if (method_exists($this, "messageShowing")) {
            $this->messageShowing($warningMessage, "warning");
        }
        if ($warningMessage != "") { // Message in Session, display
            if (!$hidden) {
                $warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
            }
            $html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
            $_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
        }
        // Success message
        $successMessage = $this->getSuccessMessage();
        if (method_exists($this, "messageShowing")) {
            $this->messageShowing($successMessage, "success");
        }
        if ($successMessage != "") { // Message in Session, display
            if (!$hidden) {
                $successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
            }
            $html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
            $_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
        }
        // Failure message
        $errorMessage = $this->getFailureMessage();
        if (method_exists($this, "messageShowing")) {
            $this->messageShowing($errorMessage, "failure");
        }
        if ($errorMessage != "") { // Message in Session, display
            if (!$hidden) {
                $errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
            }
            $html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
            $_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
        }
        echo '<div class="ew-message-dialog' . ($hidden ? ' d-none' : '') . '">' . $html . '</div>';
    }

    // Get message as array
    public function getMessages()
    {
        $ar = [];
        // Message
        $message = $this->getMessage();
        if ($message != "") { // Message in Session, display
            $ar["message"] = $message;
            $_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
        }
        // Warning message
        $warningMessage = $this->getWarningMessage();
        if ($warningMessage != "") { // Message in Session, display
            $ar["warningMessage"] = $warningMessage;
            $_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
        }
        // Success message
        $successMessage = $this->getSuccessMessage();
        if ($successMessage != "") { // Message in Session, display
            $ar["successMessage"] = $successMessage;
            $_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
        }
        // Failure message
        $failureMessage = $this->getFailureMessage();
        if ($failureMessage != "") { // Message in Session, display
            $ar["failureMessage"] = $failureMessage;
            $_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
        }
        return $ar;
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Validate page request
    protected function isPageRequest()
    {
        global $CurrentForm;
        if ($this->UseTokenInUrl) {
            if ($CurrentForm) {
                return ($this->TableVar == $CurrentForm->getValue("t"));
            }
            if (Get("t") !== null) {
                return ($this->TableVar == Get("t"));
            }
        }
        return true;
    }

    // Constructor
    public function __construct()
    {
        global $Language, $DashboardReport, $DebugTimer;
        global $UserTable;

        // Initialize
        $GLOBALS["Page"] = &$this;
        $this->TokenTimeout = SessionTimeoutTime();

        // Language object
        $Language = Container("language");

        // Parent constuctor
        parent::__construct();

        // Table object (sortir)
        if (!isset($GLOBALS["sortir"]) || get_class($GLOBALS["sortir"]) == PROJECT_NAMESPACE . "sortir") {
            $GLOBALS["sortir"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl();

        // Initialize URLs
        $this->ExportPrintUrl = $pageUrl . "export=print";
        $this->ExportExcelUrl = $pageUrl . "export=excel";
        $this->ExportWordUrl = $pageUrl . "export=word";
        $this->ExportPdfUrl = $pageUrl . "export=pdf";
        $this->ExportHtmlUrl = $pageUrl . "export=html";
        $this->ExportXmlUrl = $pageUrl . "export=xml";
        $this->ExportCsvUrl = $pageUrl . "export=csv";
        $this->AddUrl = "SortirAdd";
        $this->InlineAddUrl = $pageUrl . "action=add";
        $this->GridAddUrl = $pageUrl . "action=gridadd";
        $this->GridEditUrl = $pageUrl . "action=gridedit";
        $this->MultiDeleteUrl = "SortirDelete";
        $this->MultiUpdateUrl = "SortirUpdate";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'sortir');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] = $GLOBALS["Conn"] ?? $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions();
        $this->ListOptions->TableVar = $this->TableVar;

        // Export options
        $this->ExportOptions = new ListOptions("div");
        $this->ExportOptions->TagClassName = "ew-export-option";

        // Import options
        $this->ImportOptions = new ListOptions("div");
        $this->ImportOptions->TagClassName = "ew-import-option";

        // Other options
        if (!$this->OtherOptions) {
            $this->OtherOptions = new ListOptionsArray();
        }
        $this->OtherOptions["addedit"] = new ListOptions("div");
        $this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
        $this->OtherOptions["detail"] = new ListOptions("div");
        $this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
        $this->OtherOptions["action"] = new ListOptions("div");
        $this->OtherOptions["action"]->TagClassName = "ew-action-option";

        // Filter options
        $this->FilterOptions = new ListOptions("div");
        $this->FilterOptions->TagClassName = "ew-filter-option fsortirlistsrch";

        // List actions
        $this->ListActions = new ListActions();
    }

    // Get content from stream
    public function getContents($stream = null): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $ExportFileName, $TempImages, $DashboardReport;

        // Page is terminated
        $this->terminated = true;

         // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();

        // Export
        if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
            $content = $this->getContents();
            if ($ExportFileName == "") {
                $ExportFileName = $this->TableVar;
            }
            $class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
            if (class_exists($class)) {
                $doc = new $class(Container("sortir"));
                $doc->Text = @$content;
                if ($this->isExport("email")) {
                    echo $this->exportEmail($doc->Text);
                } else {
                    $doc->export();
                }
                DeleteTempImages(); // Delete temp images
                return;
            }
        }
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show error
                WriteJson(array_merge(["success" => false], $this->getMessages()));
            }
            return;
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        if ($fld->DataType == DATATYPE_MEMO && $fld->MemoMaxLength > 0) {
                            $val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
                        }
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['sortir_id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->sortir_id->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->sortir_petugas->Visible = false;
        }
    }

    // Lookup data
    public function lookup()
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = Post("field");
        if (!array_key_exists($fieldName, $this->Fields)) {
            return false;
        }
        $lookupField = $this->Fields[$fieldName];
        $lookup = $lookupField->Lookup;
        if ($lookup === null) {
            return false;
        }
        $tbl = $lookup->getTable();
        if (!$Security->allowLookup(PROJECT_ID . $tbl->TableName)) { // Lookup permission
            return false;
        }

        // Get lookup parameters
        $lookupType = Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal")) {
            $searchValue = Post("sv", "");
            $pageSize = Post("recperpage", 10);
            $offset = Post("start", 0);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = Param("q", "");
            $pageSize = Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
            $start = Param("start", -1);
            $start = is_numeric($start) ? (int)$start : -1;
            $page = Param("page", -1);
            $page = is_numeric($page) ? (int)$page : -1;
            $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        }
        $userSelect = Decrypt(Post("s", ""));
        $userFilter = Decrypt(Post("f", ""));
        $userOrderBy = Decrypt(Post("o", ""));
        $keys = Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        $lookup->toJson($this); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $DisplayRecords = 50;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = "10,20,50,-1"; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse show"; // Search Panel class
    public $SearchRowCount = 0; // For extended search
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 1; // For extended search
    public $RecordCount = 0; // Record count
    public $EditRowCount;
    public $StartRowCount = 1;
    public $RowCount = 0;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $RowAction = ""; // Row action
    public $RowOldKey = ""; // Row old key (for copy)
    public $MultiColumnClass = "col-sm";
    public $MultiColumnEditClass = "w-100";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $RestoreSearch = false;
    public $DetailPages;
    public $OldRecordset;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm;

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();
        $this->sortir_id->setVisibility();
        $this->sortir_kedatangan->setVisibility();
        $this->sortir_petugas->setVisibility();
        $this->sortir_tanggal->setVisibility();
        $this->sortir_okking->setVisibility();
        $this->sortir_okl->setVisibility();
        $this->sortir_okm->setVisibility();
        $this->sortir_oks->setVisibility();
        $this->sortir_okss->setVisibility();
        $this->sortir_oktotal->setVisibility();
        $this->sortir_rijek_busuk->setVisibility();
        $this->sortir_rijek_kecil->setVisibility();
        $this->sortir_rijek_sampah->setVisibility();
        $this->sortir_catatan->setVisibility();
        $this->hideFieldsForAddEdit();

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up custom action (compatible with old version)
        foreach ($this->CustomActions as $name => $action) {
            $this->ListActions->add($name, $action);
        }

        // Show checkbox column if multiple action
        foreach ($this->ListActions->Items as $listaction) {
            if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
                $this->ListOptions["checkbox"]->Visible = true;
                break;
            }
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->sortir_kedatangan);

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $filter = "";

        // Get command
        $this->Command = strtolower(Get("cmd"));
        if ($this->isPageRequest()) {
            // Process list action first
            if ($this->processListAction()) { // Ajax request
                $this->terminate();
                return;
            }

            // Set up records per page
            $this->setupDisplayRecords();

            // Handle reset command
            $this->resetCmd();

            // Set up Breadcrumb
            if (!$this->isExport()) {
                $this->setupBreadcrumb();
            }

            // Check QueryString parameters
            if (Get("action") !== null) {
                $this->CurrentAction = Get("action");

                // Clear inline mode
                if ($this->isCancel()) {
                    $this->clearInlineMode();
                }

                // Switch to grid edit mode
                if ($this->isGridEdit()) {
                    $this->gridEditMode();
                }

                // Switch to inline edit mode
                if ($this->isEdit()) {
                    $this->inlineEditMode();
                }

                // Switch to inline add mode
                if ($this->isAdd() || $this->isCopy()) {
                    $this->inlineAddMode();
                }

                // Switch to grid add mode
                if ($this->isGridAdd()) {
                    $this->gridAddMode();
                }
            } else {
                if (Post("action") !== null) {
                    $this->CurrentAction = Post("action"); // Get action

                    // Grid Update
                    if (($this->isGridUpdate() || $this->isGridOverwrite()) && @$_SESSION[SESSION_INLINE_MODE] == "gridedit") {
                        if ($this->validateGridForm()) {
                            $gridUpdate = $this->gridUpdate();
                        } else {
                            $gridUpdate = false;
                        }
                        if ($gridUpdate) {
                        } else {
                            $this->EventCancelled = true;
                            $this->gridEditMode(); // Stay in Grid edit mode
                        }
                    }

                    // Inline Update
                    if (($this->isUpdate() || $this->isOverwrite()) && @$_SESSION[SESSION_INLINE_MODE] == "edit") {
                        $this->inlineUpdate();
                    }

                    // Insert Inline
                    if ($this->isInsert() && @$_SESSION[SESSION_INLINE_MODE] == "add") {
                        $this->inlineInsert();
                    }

                    // Grid Insert
                    if ($this->isGridInsert() && @$_SESSION[SESSION_INLINE_MODE] == "gridadd") {
                        if ($this->validateGridForm()) {
                            $gridInsert = $this->gridInsert();
                        } else {
                            $gridInsert = false;
                        }
                        if ($gridInsert) {
                        } else {
                            $this->EventCancelled = true;
                            $this->gridAddMode(); // Stay in Grid add mode
                        }
                    }
                } elseif (@$_SESSION[SESSION_INLINE_MODE] == "gridedit") { // Previously in grid edit mode
                    if (Get(Config("TABLE_START_REC")) !== null || Get(Config("TABLE_PAGE_NO")) !== null) { // Stay in grid edit mode if paging
                        $this->gridEditMode();
                    } else { // Reset grid edit
                        $this->clearInlineMode();
                    }
                }
            }

            // Hide list options
            if ($this->isExport()) {
                $this->ListOptions->hideAllOptions(["sequence"]);
                $this->ListOptions->UseDropDownButton = false; // Disable drop down button
                $this->ListOptions->UseButtonGroup = false; // Disable button group
            } elseif ($this->isGridAdd() || $this->isGridEdit()) {
                $this->ListOptions->hideAllOptions();
                $this->ListOptions->UseDropDownButton = false; // Disable drop down button
                $this->ListOptions->UseButtonGroup = false; // Disable button group
            }

            // Hide options
            if ($this->isExport() || $this->CurrentAction) {
                $this->ExportOptions->hideAllOptions();
                $this->FilterOptions->hideAllOptions();
                $this->ImportOptions->hideAllOptions();
            }

            // Hide other options
            if ($this->isExport()) {
                $this->OtherOptions->hideAllOptions();
            }

            // Show grid delete link for grid add / grid edit
            if ($this->AllowAddDeleteRow) {
                if ($this->isGridAdd() || $this->isGridEdit()) {
                    $item = $this->ListOptions["griddelete"];
                    if ($item) {
                        $item->Visible = true;
                    }
                }
            }

            // Get default search criteria
            AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(true));
            AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(true));

            // Get basic search values
            $this->loadBasicSearchValues();

            // Get and validate search values for advanced search
            $this->loadSearchValues(); // Get search values

            // Process filter list
            if ($this->processFilterList()) {
                $this->terminate();
                return;
            }
            if (!$this->validateSearch()) {
                // Nothing to do
            }

            // Restore search parms from Session if not searching / reset / export
            if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms()) {
                $this->restoreSearchParms();
            }

            // Call Recordset SearchValidated event
            $this->recordsetSearchValidated();

            // Set up sorting order
            $this->setupSortOrder();

            // Get basic search criteria
            if (!$this->hasInvalidFields()) {
                $srchBasic = $this->basicSearchWhere();
            }

            // Get search criteria for advanced search
            if (!$this->hasInvalidFields()) {
                $srchAdvanced = $this->advancedSearchWhere();
            }
        }

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 50; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Load Sorting Order
        if ($this->Command != "json") {
            $this->loadSortOrder();
        }

        // Load search default if no existing search criteria
        if (!$this->checkSearchParms()) {
            // Load basic search from default
            $this->BasicSearch->loadDefault();
            if ($this->BasicSearch->Keyword != "") {
                $srchBasic = $this->basicSearchWhere();
            }

            // Load advanced search from default
            if ($this->loadAdvancedSearchDefault()) {
                $srchAdvanced = $this->advancedSearchWhere();
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Build search criteria
        AddFilter($this->SearchWhere, $srchAdvanced);
        AddFilter($this->SearchWhere, $srchBasic);

        // Call Recordset_Searching event
        $this->recordsetSearching($this->SearchWhere);

        // Save search criteria
        if ($this->Command == "search" && !$this->RestoreSearch) {
            $this->setSearchWhere($this->SearchWhere); // Save to Session
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->Command != "json") {
            $this->SearchWhere = $this->getSearchWhere();
        }

        // Build filter
        $filter = "";
        if (!$Security->canList()) {
            $filter = "(0=1)"; // Filter all records
        }
        AddFilter($filter, $this->DbDetailFilter);
        AddFilter($filter, $this->SearchWhere);

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $filter;
        } else {
            $this->setSessionWhere($filter);
            $this->CurrentFilter = "";
        }
        if ($this->isGridAdd()) {
            $this->CurrentFilter = "0=1";
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->GridAddRowCount;
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) { // Display all records
                $this->DisplayRecords = $this->TotalRecords;
            }
            if (!($this->isExport() && $this->ExportAll)) { // Set up start record position
                $this->setupStartRecord();
            }
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

            // Set no record found message
            if (!$this->CurrentAction && $this->TotalRecords == 0) {
                if (!$Security->canList()) {
                    $this->setWarningMessage(DeniedMessage());
                }
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            }
        }

        // Search/sort options
        $this->setupSearchSortOptions();

        // Set up search panel class
        if ($this->SearchWhere != "") {
            AppendClass($this->SearchPanelClass, "show");
        }

        // Normal return
        if (IsApi()) {
            $rows = $this->getRecordsFromRecordset($this->Recordset);
            $this->Recordset->close();
            WriteJson(["success" => true, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecords]);
            $this->terminate(true);
            return;
        }

        // Set up pager
        $this->Pager = new PrevNextPager($this->StartRecord, $this->getRecordsPerPage(), $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Pass table and field properties to client side
            $this->toClientVar(["tableCaption"], ["caption", "Required", "IsInvalid", "Raw"]);

            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Rendering event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }
        }
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 50; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Exit inline mode
    protected function clearInlineMode()
    {
        $this->setKey("sortir_id", ""); // Clear inline edit key
        $this->sortir_okking->FormValue = ""; // Clear form value
        $this->sortir_okl->FormValue = ""; // Clear form value
        $this->sortir_okm->FormValue = ""; // Clear form value
        $this->sortir_oks->FormValue = ""; // Clear form value
        $this->sortir_okss->FormValue = ""; // Clear form value
        $this->sortir_oktotal->FormValue = ""; // Clear form value
        $this->sortir_rijek_busuk->FormValue = ""; // Clear form value
        $this->sortir_rijek_kecil->FormValue = ""; // Clear form value
        $this->sortir_rijek_sampah->FormValue = ""; // Clear form value
        $this->LastAction = $this->CurrentAction; // Save last action
        $this->CurrentAction = ""; // Clear action
        $_SESSION[SESSION_INLINE_MODE] = ""; // Clear inline mode
    }

    // Switch to Grid Add mode
    protected function gridAddMode()
    {
        $this->CurrentAction = "gridadd";
        $_SESSION[SESSION_INLINE_MODE] = "gridadd";
        $this->hideFieldsForAddEdit();
    }

    // Switch to Grid Edit mode
    protected function gridEditMode()
    {
        $this->CurrentAction = "gridedit";
        $_SESSION[SESSION_INLINE_MODE] = "gridedit";
        $this->hideFieldsForAddEdit();
    }

    // Switch to Inline Edit mode
    protected function inlineEditMode()
    {
        global $Security, $Language;
        if (!$Security->canEdit()) {
            return false; // Edit not allowed
        }
        $inlineEdit = true;
        if (($keyValue = Get("sortir_id") ?? Route("sortir_id")) !== null) {
            $this->sortir_id->setQueryStringValue($keyValue);
        } else {
            $inlineEdit = false;
        }
        if ($inlineEdit) {
            if ($this->loadRow()) {
                    $this->setKey("sortir_id", $this->sortir_id->CurrentValue); // Set up inline edit key
                $_SESSION[SESSION_INLINE_MODE] = "edit"; // Enable inline edit
            }
        }
        return true;
    }

    // Perform update to Inline Edit record
    protected function inlineUpdate()
    {
        global $Language, $CurrentForm;
        $CurrentForm->Index = 1;
        $this->loadFormValues(); // Get form values

        // Validate form
        $inlineUpdate = true;
        if (!$this->validateForm()) {
            $inlineUpdate = false; // Form error, reset action
        } else {
            $inlineUpdate = false;
            $rowkey = strval($CurrentForm->getValue($this->FormKeyName));
            if ($this->setupKeyValues($rowkey)) { // Set up key values
                if ($this->checkInlineEditKey()) { // Check key
                    $this->SendEmail = true; // Send email on update success
                    $inlineUpdate = $this->editRow(); // Update record
                } else {
                    $inlineUpdate = false;
                }
            }
        }
        if ($inlineUpdate) { // Update success
            if ($this->getSuccessMessage() == "") {
                $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Set up success message
            }
            $this->clearInlineMode(); // Clear inline edit mode
        } else {
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("UpdateFailed")); // Set update failed message
            }
            $this->EventCancelled = true; // Cancel event
            $this->CurrentAction = "edit"; // Stay in edit mode
        }
    }

    // Check Inline Edit key
    public function checkInlineEditKey()
    {
        if ($this->EventCancelled) {
            $this->sortir_id->OldValue = $this->sortir_id->DbValue;
        }
        $val = $this->sortir_id->OldValue !== null ? $this->sortir_id->OldValue : $this->sortir_id->CurrentValue;
        if (strval($this->getKey("sortir_id")) != strval($val)) {
            return false;
        }
        return true;
    }

    // Switch to Inline Add mode
    protected function inlineAddMode()
    {
        global $Security, $Language;
        if (!$Security->canAdd()) {
            return false; // Add not allowed
        }
        $this->CurrentAction = "add";
        $_SESSION[SESSION_INLINE_MODE] = "add"; // Enable inline add
        return true;
    }

    // Perform update to Inline Add/Copy record
    protected function inlineInsert()
    {
        global $Language, $CurrentForm;
        $this->loadOldRecord(); // Load old record
        $CurrentForm->Index = 0;
        $this->loadFormValues(); // Get form values

        // Validate form
        if (!$this->validateForm()) {
            $this->EventCancelled = true; // Set event cancelled
            $this->CurrentAction = "add"; // Stay in add mode
            return;
        }
        $this->SendEmail = true; // Send email on add success
        if ($this->addRow($this->OldRecordset)) { // Add record
            if ($this->getSuccessMessage() == "") {
                $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up add success message
            }
            $this->clearInlineMode(); // Clear inline add mode
        } else { // Add failed
            $this->EventCancelled = true; // Set event cancelled
            $this->CurrentAction = "add"; // Stay in add mode
        }
    }

    // Perform update to grid
    public function gridUpdate()
    {
        global $Language, $CurrentForm;
        $gridUpdate = true;

        // Get old recordset
        $this->CurrentFilter = $this->buildKeyFilter();
        if ($this->CurrentFilter == "") {
            $this->CurrentFilter = "0=1";
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        if ($rs = $conn->executeQuery($sql)) {
            $rsold = $rs->fetchAll();
            $rs->closeCursor();
        }

        // Call Grid Updating event
        if (!$this->gridUpdating($rsold)) {
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("GridEditCancelled")); // Set grid edit cancelled message
            }
            return false;
        }

        // Begin transaction
        $conn->beginTransaction();
        $key = "";

        // Update row index and get row key
        $CurrentForm->Index = -1;
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Update all rows based on key
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            $CurrentForm->Index = $rowindex;
            $rowkey = strval($CurrentForm->getValue($this->FormKeyName));
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));

            // Load all values and keys
            if ($rowaction != "insertdelete") { // Skip insert then deleted rows
                $this->loadFormValues(); // Get form values
                if ($rowaction == "" || $rowaction == "edit" || $rowaction == "delete") {
                    $gridUpdate = $this->setupKeyValues($rowkey); // Set up key values
                } else {
                    $gridUpdate = true;
                }

                // Skip empty row
                if ($rowaction == "insert" && $this->emptyRow()) {
                    // Validate form and insert/update/delete record
                } elseif ($gridUpdate) {
                    if ($rowaction == "delete") {
                        $this->CurrentFilter = $this->getRecordFilter();
                        $gridUpdate = $this->deleteRows(); // Delete this row
                    //} elseif (!$this->validateForm()) { // Already done in validateGridForm
                    //    $gridUpdate = false; // Form error, reset action
                    } else {
                        if ($rowaction == "insert") {
                            $gridUpdate = $this->addRow(); // Insert this row
                        } else {
                            if ($rowkey != "") {
                                $this->SendEmail = false; // Do not send email on update success
                                $gridUpdate = $this->editRow(); // Update this row
                            }
                        } // End update
                    }
                }
                if ($gridUpdate) {
                    if ($key != "") {
                        $key .= ", ";
                    }
                    $key .= $rowkey;
                } else {
                    break;
                }
            }
        }
        if ($gridUpdate) {
            $conn->commit(); // Commit transaction

            // Get new records
            $rsnew = $conn->fetchAll($sql);

            // Call Grid_Updated event
            $this->gridUpdated($rsold, $rsnew);
            if ($this->getSuccessMessage() == "") {
                $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Set up update success message
            }
            $this->clearInlineMode(); // Clear inline edit mode
        } else {
            $conn->rollback(); // Rollback transaction
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("UpdateFailed")); // Set update failed message
            }
        }
        return $gridUpdate;
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->FormKeyName));
        while ($thisKey != "") {
            if ($this->setupKeyValues($thisKey)) {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->FormKeyName));
        }
        return $wrkFilter;
    }

    // Set up key values
    protected function setupKeyValues($key)
    {
        $arKeyFlds = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
        if (count($arKeyFlds) >= 1) {
            $this->sortir_id->setOldValue($arKeyFlds[0]);
            if (!is_numeric($this->sortir_id->OldValue)) {
                return false;
            }
        }
        return true;
    }

    // Perform Grid Add
    public function gridInsert()
    {
        global $Language, $CurrentForm;
        $rowindex = 1;
        $gridInsert = false;
        $conn = $this->getConnection();

        // Call Grid Inserting event
        if (!$this->gridInserting()) {
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("GridAddCancelled")); // Set grid add cancelled message
            }
            return false;
        }

        // Begin transaction
        $conn->beginTransaction();

        // Init key filter
        $wrkfilter = "";
        $addcnt = 0;
        $key = "";

        // Get row count
        $CurrentForm->Index = -1;
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Insert all rows
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "" && $rowaction != "insert") {
                continue; // Skip
            }
            $this->loadFormValues(); // Get form values
            if (!$this->emptyRow()) {
                $addcnt++;
                $this->SendEmail = false; // Do not send email on insert success

                // Validate form // Already done in validateGridForm
                //if (!$this->validateForm()) {
                //    $gridInsert = false; // Form error, reset action
                //} else {
                    $gridInsert = $this->addRow($this->OldRecordset); // Insert this row
                //}
                if ($gridInsert) {
                    if ($key != "") {
                        $key .= Config("COMPOSITE_KEY_SEPARATOR");
                    }
                    $key .= $this->sortir_id->CurrentValue;

                    // Add filter for this record
                    $filter = $this->getRecordFilter();
                    if ($wrkfilter != "") {
                        $wrkfilter .= " OR ";
                    }
                    $wrkfilter .= $filter;
                } else {
                    break;
                }
            }
        }
        if ($addcnt == 0) { // No record inserted
            $this->setFailureMessage($Language->phrase("NoAddRecord"));
            $gridInsert = false;
        }
        if ($gridInsert) {
            $conn->commit(); // Commit transaction

            // Get new records
            $this->CurrentFilter = $wrkfilter;
            $sql = $this->getCurrentSql();
            $rsnew = $conn->fetchAll($sql);

            // Call Grid_Inserted event
            $this->gridInserted($rsnew);
            if ($this->getSuccessMessage() == "") {
                $this->setSuccessMessage($Language->phrase("InsertSuccess")); // Set up insert success message
            }
            $this->clearInlineMode(); // Clear grid add mode
        } else {
            $conn->rollback(); // Rollback transaction
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("InsertFailed")); // Set insert failed message
            }
        }
        return $gridInsert;
    }

    // Check if empty row
    public function emptyRow()
    {
        global $CurrentForm;
        if ($CurrentForm->hasValue("x_sortir_kedatangan") && $CurrentForm->hasValue("o_sortir_kedatangan") && $this->sortir_kedatangan->CurrentValue != $this->sortir_kedatangan->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_sortir_tanggal") && $CurrentForm->hasValue("o_sortir_tanggal") && $this->sortir_tanggal->CurrentValue != $this->sortir_tanggal->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_sortir_okking") && $CurrentForm->hasValue("o_sortir_okking") && $this->sortir_okking->CurrentValue != $this->sortir_okking->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_sortir_okl") && $CurrentForm->hasValue("o_sortir_okl") && $this->sortir_okl->CurrentValue != $this->sortir_okl->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_sortir_okm") && $CurrentForm->hasValue("o_sortir_okm") && $this->sortir_okm->CurrentValue != $this->sortir_okm->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_sortir_oks") && $CurrentForm->hasValue("o_sortir_oks") && $this->sortir_oks->CurrentValue != $this->sortir_oks->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_sortir_okss") && $CurrentForm->hasValue("o_sortir_okss") && $this->sortir_okss->CurrentValue != $this->sortir_okss->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_sortir_oktotal") && $CurrentForm->hasValue("o_sortir_oktotal") && $this->sortir_oktotal->CurrentValue != $this->sortir_oktotal->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_sortir_rijek_busuk") && $CurrentForm->hasValue("o_sortir_rijek_busuk") && $this->sortir_rijek_busuk->CurrentValue != $this->sortir_rijek_busuk->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_sortir_rijek_kecil") && $CurrentForm->hasValue("o_sortir_rijek_kecil") && $this->sortir_rijek_kecil->CurrentValue != $this->sortir_rijek_kecil->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_sortir_rijek_sampah") && $CurrentForm->hasValue("o_sortir_rijek_sampah") && $this->sortir_rijek_sampah->CurrentValue != $this->sortir_rijek_sampah->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_sortir_catatan") && $CurrentForm->hasValue("o_sortir_catatan") && $this->sortir_catatan->CurrentValue != $this->sortir_catatan->OldValue) {
            return false;
        }
        return true;
    }

    // Validate grid form
    public function validateGridForm()
    {
        global $CurrentForm;
        // Get row count
        $CurrentForm->Index = -1;
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Validate all records
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "delete" && $rowaction != "insertdelete") {
                $this->loadFormValues(); // Get form values
                if ($rowaction == "insert" && $this->emptyRow()) {
                    // Ignore
                } elseif (!$this->validateForm()) {
                    return false;
                }
            }
        }
        return true;
    }

    // Get all form values of the grid
    public function getGridFormValues()
    {
        global $CurrentForm;
        // Get row count
        $CurrentForm->Index = -1;
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }
        $rows = [];

        // Loop through all records
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "delete" && $rowaction != "insertdelete") {
                $this->loadFormValues(); // Get form values
                if ($rowaction == "insert" && $this->emptyRow()) {
                    // Ignore
                } else {
                    $rows[] = $this->getFieldValues("FormValue"); // Return row as array
                }
            }
        }
        return $rows; // Return as array of array
    }

    // Restore form values for current row
    public function restoreCurrentRowFormValues($idx)
    {
        global $CurrentForm;

        // Get row based on current index
        $CurrentForm->Index = $idx;
        $rowaction = strval($CurrentForm->getValue($this->FormActionName));
        $this->loadFormValues(); // Load form values
        // Set up invalid status correctly
        $this->resetFormError();
        if ($rowaction == "insert" && $this->emptyRow()) {
            // Ignore
        } else {
            $this->validateForm();
        }
    }

    // Reset form status
    public function resetFormError()
    {
        $this->sortir_id->clearErrorMessage();
        $this->sortir_kedatangan->clearErrorMessage();
        $this->sortir_petugas->clearErrorMessage();
        $this->sortir_tanggal->clearErrorMessage();
        $this->sortir_okking->clearErrorMessage();
        $this->sortir_okl->clearErrorMessage();
        $this->sortir_okm->clearErrorMessage();
        $this->sortir_oks->clearErrorMessage();
        $this->sortir_okss->clearErrorMessage();
        $this->sortir_oktotal->clearErrorMessage();
        $this->sortir_rijek_busuk->clearErrorMessage();
        $this->sortir_rijek_kecil->clearErrorMessage();
        $this->sortir_rijek_sampah->clearErrorMessage();
        $this->sortir_catatan->clearErrorMessage();
    }

    // Get list of filters
    public function getFilterList()
    {
        global $UserProfile;

        // Initialize
        $filterList = "";
        $savedFilterList = "";
        $filterList = Concat($filterList, $this->sortir_id->AdvancedSearch->toJson(), ","); // Field sortir_id
        $filterList = Concat($filterList, $this->sortir_kedatangan->AdvancedSearch->toJson(), ","); // Field sortir_kedatangan
        $filterList = Concat($filterList, $this->sortir_petugas->AdvancedSearch->toJson(), ","); // Field sortir_petugas
        $filterList = Concat($filterList, $this->sortir_tanggal->AdvancedSearch->toJson(), ","); // Field sortir_tanggal
        $filterList = Concat($filterList, $this->sortir_okking->AdvancedSearch->toJson(), ","); // Field sortir_okking
        $filterList = Concat($filterList, $this->sortir_okl->AdvancedSearch->toJson(), ","); // Field sortir_okl
        $filterList = Concat($filterList, $this->sortir_okm->AdvancedSearch->toJson(), ","); // Field sortir_okm
        $filterList = Concat($filterList, $this->sortir_oks->AdvancedSearch->toJson(), ","); // Field sortir_oks
        $filterList = Concat($filterList, $this->sortir_okss->AdvancedSearch->toJson(), ","); // Field sortir_okss
        $filterList = Concat($filterList, $this->sortir_oktotal->AdvancedSearch->toJson(), ","); // Field sortir_oktotal
        $filterList = Concat($filterList, $this->sortir_rijek_busuk->AdvancedSearch->toJson(), ","); // Field sortir_rijek_busuk
        $filterList = Concat($filterList, $this->sortir_rijek_kecil->AdvancedSearch->toJson(), ","); // Field sortir_rijek_kecil
        $filterList = Concat($filterList, $this->sortir_rijek_sampah->AdvancedSearch->toJson(), ","); // Field sortir_rijek_sampah
        $filterList = Concat($filterList, $this->sortir_catatan->AdvancedSearch->toJson(), ","); // Field sortir_catatan
        if ($this->BasicSearch->Keyword != "") {
            $wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
            $filterList = Concat($filterList, $wrk, ",");
        }

        // Return filter list in JSON
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        global $UserProfile;
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            $UserProfile->setSearchFilters(CurrentUserName(), "fsortirlistsrch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd") !== "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter"), true);
        $this->Command = "search";

        // Field sortir_id
        $this->sortir_id->AdvancedSearch->SearchValue = @$filter["x_sortir_id"];
        $this->sortir_id->AdvancedSearch->SearchOperator = @$filter["z_sortir_id"];
        $this->sortir_id->AdvancedSearch->SearchCondition = @$filter["v_sortir_id"];
        $this->sortir_id->AdvancedSearch->SearchValue2 = @$filter["y_sortir_id"];
        $this->sortir_id->AdvancedSearch->SearchOperator2 = @$filter["w_sortir_id"];
        $this->sortir_id->AdvancedSearch->save();

        // Field sortir_kedatangan
        $this->sortir_kedatangan->AdvancedSearch->SearchValue = @$filter["x_sortir_kedatangan"];
        $this->sortir_kedatangan->AdvancedSearch->SearchOperator = @$filter["z_sortir_kedatangan"];
        $this->sortir_kedatangan->AdvancedSearch->SearchCondition = @$filter["v_sortir_kedatangan"];
        $this->sortir_kedatangan->AdvancedSearch->SearchValue2 = @$filter["y_sortir_kedatangan"];
        $this->sortir_kedatangan->AdvancedSearch->SearchOperator2 = @$filter["w_sortir_kedatangan"];
        $this->sortir_kedatangan->AdvancedSearch->save();

        // Field sortir_petugas
        $this->sortir_petugas->AdvancedSearch->SearchValue = @$filter["x_sortir_petugas"];
        $this->sortir_petugas->AdvancedSearch->SearchOperator = @$filter["z_sortir_petugas"];
        $this->sortir_petugas->AdvancedSearch->SearchCondition = @$filter["v_sortir_petugas"];
        $this->sortir_petugas->AdvancedSearch->SearchValue2 = @$filter["y_sortir_petugas"];
        $this->sortir_petugas->AdvancedSearch->SearchOperator2 = @$filter["w_sortir_petugas"];
        $this->sortir_petugas->AdvancedSearch->save();

        // Field sortir_tanggal
        $this->sortir_tanggal->AdvancedSearch->SearchValue = @$filter["x_sortir_tanggal"];
        $this->sortir_tanggal->AdvancedSearch->SearchOperator = @$filter["z_sortir_tanggal"];
        $this->sortir_tanggal->AdvancedSearch->SearchCondition = @$filter["v_sortir_tanggal"];
        $this->sortir_tanggal->AdvancedSearch->SearchValue2 = @$filter["y_sortir_tanggal"];
        $this->sortir_tanggal->AdvancedSearch->SearchOperator2 = @$filter["w_sortir_tanggal"];
        $this->sortir_tanggal->AdvancedSearch->save();

        // Field sortir_okking
        $this->sortir_okking->AdvancedSearch->SearchValue = @$filter["x_sortir_okking"];
        $this->sortir_okking->AdvancedSearch->SearchOperator = @$filter["z_sortir_okking"];
        $this->sortir_okking->AdvancedSearch->SearchCondition = @$filter["v_sortir_okking"];
        $this->sortir_okking->AdvancedSearch->SearchValue2 = @$filter["y_sortir_okking"];
        $this->sortir_okking->AdvancedSearch->SearchOperator2 = @$filter["w_sortir_okking"];
        $this->sortir_okking->AdvancedSearch->save();

        // Field sortir_okl
        $this->sortir_okl->AdvancedSearch->SearchValue = @$filter["x_sortir_okl"];
        $this->sortir_okl->AdvancedSearch->SearchOperator = @$filter["z_sortir_okl"];
        $this->sortir_okl->AdvancedSearch->SearchCondition = @$filter["v_sortir_okl"];
        $this->sortir_okl->AdvancedSearch->SearchValue2 = @$filter["y_sortir_okl"];
        $this->sortir_okl->AdvancedSearch->SearchOperator2 = @$filter["w_sortir_okl"];
        $this->sortir_okl->AdvancedSearch->save();

        // Field sortir_okm
        $this->sortir_okm->AdvancedSearch->SearchValue = @$filter["x_sortir_okm"];
        $this->sortir_okm->AdvancedSearch->SearchOperator = @$filter["z_sortir_okm"];
        $this->sortir_okm->AdvancedSearch->SearchCondition = @$filter["v_sortir_okm"];
        $this->sortir_okm->AdvancedSearch->SearchValue2 = @$filter["y_sortir_okm"];
        $this->sortir_okm->AdvancedSearch->SearchOperator2 = @$filter["w_sortir_okm"];
        $this->sortir_okm->AdvancedSearch->save();

        // Field sortir_oks
        $this->sortir_oks->AdvancedSearch->SearchValue = @$filter["x_sortir_oks"];
        $this->sortir_oks->AdvancedSearch->SearchOperator = @$filter["z_sortir_oks"];
        $this->sortir_oks->AdvancedSearch->SearchCondition = @$filter["v_sortir_oks"];
        $this->sortir_oks->AdvancedSearch->SearchValue2 = @$filter["y_sortir_oks"];
        $this->sortir_oks->AdvancedSearch->SearchOperator2 = @$filter["w_sortir_oks"];
        $this->sortir_oks->AdvancedSearch->save();

        // Field sortir_okss
        $this->sortir_okss->AdvancedSearch->SearchValue = @$filter["x_sortir_okss"];
        $this->sortir_okss->AdvancedSearch->SearchOperator = @$filter["z_sortir_okss"];
        $this->sortir_okss->AdvancedSearch->SearchCondition = @$filter["v_sortir_okss"];
        $this->sortir_okss->AdvancedSearch->SearchValue2 = @$filter["y_sortir_okss"];
        $this->sortir_okss->AdvancedSearch->SearchOperator2 = @$filter["w_sortir_okss"];
        $this->sortir_okss->AdvancedSearch->save();

        // Field sortir_oktotal
        $this->sortir_oktotal->AdvancedSearch->SearchValue = @$filter["x_sortir_oktotal"];
        $this->sortir_oktotal->AdvancedSearch->SearchOperator = @$filter["z_sortir_oktotal"];
        $this->sortir_oktotal->AdvancedSearch->SearchCondition = @$filter["v_sortir_oktotal"];
        $this->sortir_oktotal->AdvancedSearch->SearchValue2 = @$filter["y_sortir_oktotal"];
        $this->sortir_oktotal->AdvancedSearch->SearchOperator2 = @$filter["w_sortir_oktotal"];
        $this->sortir_oktotal->AdvancedSearch->save();

        // Field sortir_rijek_busuk
        $this->sortir_rijek_busuk->AdvancedSearch->SearchValue = @$filter["x_sortir_rijek_busuk"];
        $this->sortir_rijek_busuk->AdvancedSearch->SearchOperator = @$filter["z_sortir_rijek_busuk"];
        $this->sortir_rijek_busuk->AdvancedSearch->SearchCondition = @$filter["v_sortir_rijek_busuk"];
        $this->sortir_rijek_busuk->AdvancedSearch->SearchValue2 = @$filter["y_sortir_rijek_busuk"];
        $this->sortir_rijek_busuk->AdvancedSearch->SearchOperator2 = @$filter["w_sortir_rijek_busuk"];
        $this->sortir_rijek_busuk->AdvancedSearch->save();

        // Field sortir_rijek_kecil
        $this->sortir_rijek_kecil->AdvancedSearch->SearchValue = @$filter["x_sortir_rijek_kecil"];
        $this->sortir_rijek_kecil->AdvancedSearch->SearchOperator = @$filter["z_sortir_rijek_kecil"];
        $this->sortir_rijek_kecil->AdvancedSearch->SearchCondition = @$filter["v_sortir_rijek_kecil"];
        $this->sortir_rijek_kecil->AdvancedSearch->SearchValue2 = @$filter["y_sortir_rijek_kecil"];
        $this->sortir_rijek_kecil->AdvancedSearch->SearchOperator2 = @$filter["w_sortir_rijek_kecil"];
        $this->sortir_rijek_kecil->AdvancedSearch->save();

        // Field sortir_rijek_sampah
        $this->sortir_rijek_sampah->AdvancedSearch->SearchValue = @$filter["x_sortir_rijek_sampah"];
        $this->sortir_rijek_sampah->AdvancedSearch->SearchOperator = @$filter["z_sortir_rijek_sampah"];
        $this->sortir_rijek_sampah->AdvancedSearch->SearchCondition = @$filter["v_sortir_rijek_sampah"];
        $this->sortir_rijek_sampah->AdvancedSearch->SearchValue2 = @$filter["y_sortir_rijek_sampah"];
        $this->sortir_rijek_sampah->AdvancedSearch->SearchOperator2 = @$filter["w_sortir_rijek_sampah"];
        $this->sortir_rijek_sampah->AdvancedSearch->save();

        // Field sortir_catatan
        $this->sortir_catatan->AdvancedSearch->SearchValue = @$filter["x_sortir_catatan"];
        $this->sortir_catatan->AdvancedSearch->SearchOperator = @$filter["z_sortir_catatan"];
        $this->sortir_catatan->AdvancedSearch->SearchCondition = @$filter["v_sortir_catatan"];
        $this->sortir_catatan->AdvancedSearch->SearchValue2 = @$filter["y_sortir_catatan"];
        $this->sortir_catatan->AdvancedSearch->SearchOperator2 = @$filter["w_sortir_catatan"];
        $this->sortir_catatan->AdvancedSearch->save();
        $this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
        $this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
    }

    // Advanced search WHERE clause based on QueryString
    protected function advancedSearchWhere($default = false)
    {
        global $Security;
        $where = "";
        if (!$Security->canSearch()) {
            return "";
        }
        $this->buildSearchSql($where, $this->sortir_id, $default, false); // sortir_id
        $this->buildSearchSql($where, $this->sortir_kedatangan, $default, false); // sortir_kedatangan
        $this->buildSearchSql($where, $this->sortir_petugas, $default, false); // sortir_petugas
        $this->buildSearchSql($where, $this->sortir_tanggal, $default, false); // sortir_tanggal
        $this->buildSearchSql($where, $this->sortir_okking, $default, false); // sortir_okking
        $this->buildSearchSql($where, $this->sortir_okl, $default, false); // sortir_okl
        $this->buildSearchSql($where, $this->sortir_okm, $default, false); // sortir_okm
        $this->buildSearchSql($where, $this->sortir_oks, $default, false); // sortir_oks
        $this->buildSearchSql($where, $this->sortir_okss, $default, false); // sortir_okss
        $this->buildSearchSql($where, $this->sortir_oktotal, $default, false); // sortir_oktotal
        $this->buildSearchSql($where, $this->sortir_rijek_busuk, $default, false); // sortir_rijek_busuk
        $this->buildSearchSql($where, $this->sortir_rijek_kecil, $default, false); // sortir_rijek_kecil
        $this->buildSearchSql($where, $this->sortir_rijek_sampah, $default, false); // sortir_rijek_sampah
        $this->buildSearchSql($where, $this->sortir_catatan, $default, false); // sortir_catatan

        // Set up search parm
        if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
            $this->Command = "search";
        }
        if (!$default && $this->Command == "search") {
            $this->sortir_id->AdvancedSearch->save(); // sortir_id
            $this->sortir_kedatangan->AdvancedSearch->save(); // sortir_kedatangan
            $this->sortir_petugas->AdvancedSearch->save(); // sortir_petugas
            $this->sortir_tanggal->AdvancedSearch->save(); // sortir_tanggal
            $this->sortir_okking->AdvancedSearch->save(); // sortir_okking
            $this->sortir_okl->AdvancedSearch->save(); // sortir_okl
            $this->sortir_okm->AdvancedSearch->save(); // sortir_okm
            $this->sortir_oks->AdvancedSearch->save(); // sortir_oks
            $this->sortir_okss->AdvancedSearch->save(); // sortir_okss
            $this->sortir_oktotal->AdvancedSearch->save(); // sortir_oktotal
            $this->sortir_rijek_busuk->AdvancedSearch->save(); // sortir_rijek_busuk
            $this->sortir_rijek_kecil->AdvancedSearch->save(); // sortir_rijek_kecil
            $this->sortir_rijek_sampah->AdvancedSearch->save(); // sortir_rijek_sampah
            $this->sortir_catatan->AdvancedSearch->save(); // sortir_catatan
        }
        return $where;
    }

    // Build search SQL
    protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
    {
        $fldParm = $fld->Param;
        $fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
        $fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        $fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
        $wrk = "";
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldOpr = strtoupper(trim($fldOpr));
        if ($fldOpr == "") {
            $fldOpr = "=";
        }
        $fldOpr2 = strtoupper(trim($fldOpr2));
        if ($fldOpr2 == "") {
            $fldOpr2 = "=";
        }
        if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 || !IsMultiSearchOperator($fldOpr)) {
            $multiValue = false;
        }
        if ($multiValue) {
            $wrk1 = ($fldVal != "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
            $wrk2 = ($fldVal2 != "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
            $wrk = $wrk1; // Build final SQL
            if ($wrk2 != "") {
                $wrk = ($wrk != "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
            }
        } else {
            $fldVal = $this->convertSearchValue($fld, $fldVal);
            $fldVal2 = $this->convertSearchValue($fld, $fldVal2);
            $wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
        }
        AddFilter($where, $wrk);
    }

    // Convert search value
    protected function convertSearchValue(&$fld, $fldVal)
    {
        if ($fldVal == Config("NULL_VALUE") || $fldVal == Config("NOT_NULL_VALUE")) {
            return $fldVal;
        }
        $value = $fldVal;
        if ($fld->isBoolean()) {
            if ($fldVal != "") {
                $value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
            }
        } elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
            if ($fldVal != "") {
                $value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
            }
        }
        return $value;
    }

    // Return basic search SQL
    protected function basicSearchSql($arKeywords, $type)
    {
        $where = "";
        $this->buildBasicSearchSql($where, $this->sortir_catatan, $arKeywords, $type);
        return $where;
    }

    // Build basic search SQL
    protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
    {
        $defCond = ($type == "OR") ? "OR" : "AND";
        $arSql = []; // Array for SQL parts
        $arCond = []; // Array for search conditions
        $cnt = count($arKeywords);
        $j = 0; // Number of SQL parts
        for ($i = 0; $i < $cnt; $i++) {
            $keyword = $arKeywords[$i];
            $keyword = trim($keyword);
            if (Config("BASIC_SEARCH_IGNORE_PATTERN") != "") {
                $keyword = preg_replace(Config("BASIC_SEARCH_IGNORE_PATTERN"), "\\", $keyword);
                $ar = explode("\\", $keyword);
            } else {
                $ar = [$keyword];
            }
            foreach ($ar as $keyword) {
                if ($keyword != "") {
                    $wrk = "";
                    if ($keyword == "OR" && $type == "") {
                        if ($j > 0) {
                            $arCond[$j - 1] = "OR";
                        }
                    } elseif ($keyword == Config("NULL_VALUE")) {
                        $wrk = $fld->Expression . " IS NULL";
                    } elseif ($keyword == Config("NOT_NULL_VALUE")) {
                        $wrk = $fld->Expression . " IS NOT NULL";
                    } elseif ($fld->IsVirtual) {
                        $wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
                    } elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
                        $wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
                    }
                    if ($wrk != "") {
                        $arSql[$j] = $wrk;
                        $arCond[$j] = $defCond;
                        $j += 1;
                    }
                }
            }
        }
        $cnt = count($arSql);
        $quoted = false;
        $sql = "";
        if ($cnt > 0) {
            for ($i = 0; $i < $cnt - 1; $i++) {
                if ($arCond[$i] == "OR") {
                    if (!$quoted) {
                        $sql .= "(";
                    }
                    $quoted = true;
                }
                $sql .= $arSql[$i];
                if ($quoted && $arCond[$i] != "OR") {
                    $sql .= ")";
                    $quoted = false;
                }
                $sql .= " " . $arCond[$i] . " ";
            }
            $sql .= $arSql[$cnt - 1];
            if ($quoted) {
                $sql .= ")";
            }
        }
        if ($sql != "") {
            if ($where != "") {
                $where .= " OR ";
            }
            $where .= "(" . $sql . ")";
        }
    }

    // Return basic search WHERE clause based on search keyword and type
    protected function basicSearchWhere($default = false)
    {
        global $Security;
        $searchStr = "";
        if (!$Security->canSearch()) {
            return "";
        }
        $searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
        $searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

        // Get search SQL
        if ($searchKeyword != "") {
            $ar = $this->BasicSearch->keywordList($default);
            // Search keyword in any fields
            if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
                foreach ($ar as $keyword) {
                    if ($keyword != "") {
                        if ($searchStr != "") {
                            $searchStr .= " " . $searchType . " ";
                        }
                        $searchStr .= "(" . $this->basicSearchSql([$keyword], $searchType) . ")";
                    }
                }
            } else {
                $searchStr = $this->basicSearchSql($ar, $searchType);
            }
            if (!$default && in_array($this->Command, ["", "reset", "resetall"])) {
                $this->Command = "search";
            }
        }
        if (!$default && $this->Command == "search") {
            $this->BasicSearch->setKeyword($searchKeyword);
            $this->BasicSearch->setType($searchType);
        }
        return $searchStr;
    }

    // Check if search parm exists
    protected function checkSearchParms()
    {
        // Check basic search
        if ($this->BasicSearch->issetSession()) {
            return true;
        }
        if ($this->sortir_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->sortir_kedatangan->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->sortir_petugas->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->sortir_tanggal->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->sortir_okking->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->sortir_okl->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->sortir_okm->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->sortir_oks->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->sortir_okss->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->sortir_oktotal->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->sortir_rijek_busuk->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->sortir_rijek_kecil->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->sortir_rijek_sampah->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->sortir_catatan->AdvancedSearch->issetSession()) {
            return true;
        }
        return false;
    }

    // Clear all search parameters
    protected function resetSearchParms()
    {
        // Clear search WHERE clause
        $this->SearchWhere = "";
        $this->setSearchWhere($this->SearchWhere);

        // Clear basic search parameters
        $this->resetBasicSearchParms();

        // Clear advanced search parameters
        $this->resetAdvancedSearchParms();
    }

    // Load advanced search default values
    protected function loadAdvancedSearchDefault()
    {
        return false;
    }

    // Clear all basic search parameters
    protected function resetBasicSearchParms()
    {
        $this->BasicSearch->unsetSession();
    }

    // Clear all advanced search parameters
    protected function resetAdvancedSearchParms()
    {
                $this->sortir_id->AdvancedSearch->unsetSession();
                $this->sortir_kedatangan->AdvancedSearch->unsetSession();
                $this->sortir_petugas->AdvancedSearch->unsetSession();
                $this->sortir_tanggal->AdvancedSearch->unsetSession();
                $this->sortir_okking->AdvancedSearch->unsetSession();
                $this->sortir_okl->AdvancedSearch->unsetSession();
                $this->sortir_okm->AdvancedSearch->unsetSession();
                $this->sortir_oks->AdvancedSearch->unsetSession();
                $this->sortir_okss->AdvancedSearch->unsetSession();
                $this->sortir_oktotal->AdvancedSearch->unsetSession();
                $this->sortir_rijek_busuk->AdvancedSearch->unsetSession();
                $this->sortir_rijek_kecil->AdvancedSearch->unsetSession();
                $this->sortir_rijek_sampah->AdvancedSearch->unsetSession();
                $this->sortir_catatan->AdvancedSearch->unsetSession();
    }

    // Restore all search parameters
    protected function restoreSearchParms()
    {
        $this->RestoreSearch = true;

        // Restore basic search values
        $this->BasicSearch->load();

        // Restore advanced search values
                $this->sortir_id->AdvancedSearch->load();
                $this->sortir_kedatangan->AdvancedSearch->load();
                $this->sortir_petugas->AdvancedSearch->load();
                $this->sortir_tanggal->AdvancedSearch->load();
                $this->sortir_okking->AdvancedSearch->load();
                $this->sortir_okl->AdvancedSearch->load();
                $this->sortir_okm->AdvancedSearch->load();
                $this->sortir_oks->AdvancedSearch->load();
                $this->sortir_okss->AdvancedSearch->load();
                $this->sortir_oktotal->AdvancedSearch->load();
                $this->sortir_rijek_busuk->AdvancedSearch->load();
                $this->sortir_rijek_kecil->AdvancedSearch->load();
                $this->sortir_rijek_sampah->AdvancedSearch->load();
                $this->sortir_catatan->AdvancedSearch->load();
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->updateSort($this->sortir_id); // sortir_id
            $this->updateSort($this->sortir_kedatangan); // sortir_kedatangan
            $this->updateSort($this->sortir_petugas); // sortir_petugas
            $this->updateSort($this->sortir_tanggal); // sortir_tanggal
            $this->updateSort($this->sortir_okking); // sortir_okking
            $this->updateSort($this->sortir_okl); // sortir_okl
            $this->updateSort($this->sortir_okm); // sortir_okm
            $this->updateSort($this->sortir_oks); // sortir_oks
            $this->updateSort($this->sortir_okss); // sortir_okss
            $this->updateSort($this->sortir_oktotal); // sortir_oktotal
            $this->updateSort($this->sortir_rijek_busuk); // sortir_rijek_busuk
            $this->updateSort($this->sortir_rijek_kecil); // sortir_rijek_kecil
            $this->updateSort($this->sortir_rijek_sampah); // sortir_rijek_sampah
            $this->updateSort($this->sortir_catatan); // sortir_catatan
            $this->setStartRecordNumber(1); // Reset start position
        }
    }

    // Load sort order parameters
    protected function loadSortOrder()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        if ($orderBy == "") {
            $this->DefaultSort = "";
            if ($this->getSqlOrderBy() != "") {
                $useDefaultSort = true;
                if ($useDefaultSort) {
                    $orderBy = $this->getSqlOrderBy();
                    $this->setSessionOrderBy($orderBy);
                } else {
                    $this->setSessionOrderBy("");
                }
            }
        }
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset search criteria
            if ($this->Command == "reset" || $this->Command == "resetall") {
                $this->resetSearchParms();
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->sortir_id->setSort("");
                $this->sortir_kedatangan->setSort("");
                $this->sortir_petugas->setSort("");
                $this->sortir_tanggal->setSort("");
                $this->sortir_okking->setSort("");
                $this->sortir_okl->setSort("");
                $this->sortir_okm->setSort("");
                $this->sortir_oks->setSort("");
                $this->sortir_okss->setSort("");
                $this->sortir_oktotal->setSort("");
                $this->sortir_rijek_busuk->setSort("");
                $this->sortir_rijek_kecil->setSort("");
                $this->sortir_rijek_sampah->setSort("");
                $this->sortir_catatan->setSort("");
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // "griddelete"
        if ($this->AllowAddDeleteRow) {
            $item = &$this->ListOptions->add("griddelete");
            $item->CssClass = "text-nowrap";
            $item->OnLeft = false;
            $item->Visible = false; // Default hidden
        }

        // Add group option item
        $item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
        $item->Body = "";
        $item->OnLeft = false;
        $item->Visible = false;

        // "edit"
        $item = &$this->ListOptions->add("edit");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canEdit();
        $item->OnLeft = false;

        // "copy"
        $item = &$this->ListOptions->add("copy");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canAdd() && $this->isAdd();
        $item->OnLeft = false;

        // List actions
        $item = &$this->ListOptions->add("listactions");
        $item->CssClass = "text-nowrap";
        $item->OnLeft = false;
        $item->Visible = false;
        $item->ShowInButtonGroup = false;
        $item->ShowInDropDown = false;

        // "checkbox"
        $item = &$this->ListOptions->add("checkbox");
        $item->Visible = false;
        $item->OnLeft = false;
        $item->Header = "<div class=\"custom-control custom-checkbox d-inline-block\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"custom-control-input\" onclick=\"ew.selectAllKey(this);\"><label class=\"custom-control-label\" for=\"key\"></label></div>";
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = false;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = false;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $this->setupListOptionsExt();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();

        // Set up row action and key
        $keyName = "";
        if ($CurrentForm && is_numeric($this->RowIndex) && $this->RowType != "view") {
            $CurrentForm->Index = $this->RowIndex;
            $actionName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormActionName);
            $oldKeyName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormOldKeyName);
            $keyName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormKeyName);
            $blankRowName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormBlankRowName);
            if ($this->RowAction != "") {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $actionName . "\" id=\"" . $actionName . "\" value=\"" . $this->RowAction . "\">";
            }
            if ($this->RowAction == "delete") {
                $rowkey = $CurrentForm->getValue($this->FormKeyName);
                $this->setupKeyValues($rowkey);
                // Reload hidden key for delete
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $keyName . "\" id=\"" . $keyName . "\" value=\"" . HtmlEncode($rowkey) . "\">";
            }
            if ($this->RowAction == "insert" && $this->isConfirm() && $this->emptyRow()) {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $blankRowName . "\" id=\"" . $blankRowName . "\" value=\"1\">";
            }
        }

        // "delete"
        if ($this->AllowAddDeleteRow) {
            if ($this->isGridAdd() || $this->isGridEdit()) {
                $options = &$this->ListOptions;
                $options->UseButtonGroup = true; // Use button group for grid delete button
                $opt = $options["griddelete"];
                if (is_numeric($this->RowIndex) && ($this->RowAction == "" || $this->RowAction == "edit")) { // Do not allow delete existing record
                    $opt->Body = "&nbsp;";
                } else {
                    $opt->Body = "<a class=\"ew-grid-link ew-grid-delete\" title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" onclick=\"return ew.deleteGridRow(this, " . $this->RowIndex . ");\">" . $Language->phrase("DeleteLink") . "</a>";
                }
            }
        }
        $pageUrl = $this->pageUrl();

        // "copy"
        $opt = $this->ListOptions["copy"];
        if ($this->isInlineAddRow() || $this->isInlineCopyRow()) { // Inline Add/Copy
            $this->ListOptions->CustomItem = "copy"; // Show copy column only
            $cancelurl = $this->addMasterUrl($pageUrl . "action=cancel");
            $opt->Body = "<div" . (($opt->OnLeft) ? " class=\"text-right\"" : "") . ">" .
            "<a class=\"ew-grid-link ew-inline-insert\" title=\"" . HtmlTitle($Language->phrase("InsertLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("InsertLink")) . "\" href=\"#\" onclick=\"return ew.forms.get(this).submit('" . $this->pageName() . "');\">" . $Language->phrase("InsertLink") . "</a>&nbsp;" .
            "<a class=\"ew-grid-link ew-inline-cancel\" title=\"" . HtmlTitle($Language->phrase("CancelLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("CancelLink")) . "\" href=\"" . $cancelurl . "\">" . $Language->phrase("CancelLink") . "</a>" .
            "<input type=\"hidden\" name=\"action\" id=\"action\" value=\"insert\"></div>";
            return;
        }

        // "edit"
        $opt = $this->ListOptions["edit"];
        if ($this->isInlineEditRow()) { // Inline-Edit
            $this->ListOptions->CustomItem = "edit"; // Show edit column only
            $cancelurl = $this->addMasterUrl($pageUrl . "action=cancel");
                $opt->Body = "<div" . (($opt->OnLeft) ? " class=\"text-right\"" : "") . ">" .
                "<a class=\"ew-grid-link ew-inline-update\" title=\"" . HtmlTitle($Language->phrase("UpdateLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("UpdateLink")) . "\" href=\"#\" onclick=\"return ew.forms.get(this).submit('" . UrlAddHash($this->pageName(), "r" . $this->RowCount . "_" . $this->TableVar) . "');\">" . $Language->phrase("UpdateLink") . "</a>&nbsp;" .
                "<a class=\"ew-grid-link ew-inline-cancel\" title=\"" . HtmlTitle($Language->phrase("CancelLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("CancelLink")) . "\" href=\"" . $cancelurl . "\">" . $Language->phrase("CancelLink") . "</a>" .
                "<input type=\"hidden\" name=\"action\" id=\"action\" value=\"update\"></div>";
            $opt->Body .= "<input type=\"hidden\" name=\"k" . $this->RowIndex . "_key\" id=\"k" . $this->RowIndex . "_key\" value=\"" . HtmlEncode($this->sortir_id->CurrentValue) . "\">";
            return;
        }
        if ($this->CurrentMode == "view") {
            // "edit"
            $opt = $this->ListOptions["edit"];
            $editcaption = HtmlTitle($Language->phrase("EditLink"));
            if ($Security->canEdit()) {
                $opt->Body .= "<a class=\"ew-row-link ew-inline-edit\" title=\"" . HtmlTitle($Language->phrase("InlineEditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("InlineEditLink")) . "\" href=\"" . HtmlEncode(UrlAddHash(GetUrl($this->InlineEditUrl), "r" . $this->RowCount . "_" . $this->TableVar)) . "\">" . $Language->phrase("InlineEditLink") . "</a>";
            } else {
                $opt->Body = "";
            }
        } // End View mode

        // Set up list action buttons
        $opt = $this->ListOptions["listactions"];
        if ($opt && !$this->isExport() && !$this->CurrentAction) {
            $body = "";
            $links = [];
            foreach ($this->ListActions->Items as $listaction) {
                if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
                    $action = $listaction->Action;
                    $caption = $listaction->Caption;
                    $icon = ($listaction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
                    $links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(true) . "}," . $listaction->toJson(true) . "));\">" . $icon . $listaction->Caption . "</a></li>";
                    if (count($links) == 1) { // Single button
                        $body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(true) . "}," . $listaction->toJson(true) . "));\">" . $icon . $listaction->Caption . "</a>";
                    }
                }
            }
            if (count($links) > 1) { // More than one buttons, use dropdown
                $body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
                $content = "";
                foreach ($links as $link) {
                    $content .= "<li>" . $link . "</li>";
                }
                $body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">" . $content . "</ul>";
                $body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
            }
            if (count($links) > 0) {
                $opt->Body = $body;
                $opt->Visible = true;
            }
        }

        // "checkbox"
        $opt = $this->ListOptions["checkbox"];
        $opt->Body = "<div class=\"custom-control custom-checkbox d-inline-block\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"custom-control-input ew-multi-select\" value=\"" . HtmlEncode($this->sortir_id->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\"><label class=\"custom-control-label\" for=\"key_m_" . $this->RowCount . "\"></label></div>";
        if ($this->isGridEdit() && is_numeric($this->RowIndex)) {
            $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $keyName . "\" id=\"" . $keyName . "\" value=\"" . $this->sortir_id->CurrentValue . "\">";
        }
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["addedit"];

        // Add
        $item = &$option->add("add");
        $addcaption = HtmlTitle($Language->phrase("AddLink"));
        $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("AddLink") . "</a>";
        $item->Visible = $this->AddUrl != "" && $Security->canAdd();

        // Inline Add
        $item = &$option->add("inlineadd");
        $item->Body = "<a class=\"ew-add-edit ew-inline-add\" title=\"" . HtmlTitle($Language->phrase("InlineAddLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("InlineAddLink")) . "\" href=\"" . HtmlEncode(GetUrl($this->InlineAddUrl)) . "\">" . $Language->phrase("InlineAddLink") . "</a>";
        $item->Visible = $this->InlineAddUrl != "" && $Security->canAdd();
        $item = &$option->add("gridadd");
        $item->Body = "<a class=\"ew-add-edit ew-grid-add\" title=\"" . HtmlTitle($Language->phrase("GridAddLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("GridAddLink")) . "\" href=\"" . HtmlEncode(GetUrl($this->GridAddUrl)) . "\">" . $Language->phrase("GridAddLink") . "</a>";
        $item->Visible = $this->GridAddUrl != "" && $Security->canAdd();

        // Add grid edit
        $option = $options["addedit"];
        $item = &$option->add("gridedit");
        $item->Body = "<a class=\"ew-add-edit ew-grid-edit\" title=\"" . HtmlTitle($Language->phrase("GridEditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("GridEditLink")) . "\" href=\"" . HtmlEncode(GetUrl($this->GridEditUrl)) . "\">" . $Language->phrase("GridEditLink") . "</a>";
        $item->Visible = $this->GridEditUrl != "" && $Security->canEdit();
        $option = $options["action"];

        // Set up options default
        foreach ($options as $option) {
            $option->UseDropDownButton = false;
            $option->UseButtonGroup = true;
            //$option->ButtonClass = ""; // Class for button group
            $item = &$option->add($option->GroupOptionName);
            $item->Body = "";
            $item->Visible = false;
        }
        $options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fsortirlistsrch\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fsortirlistsrch\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
        $item->Body = "";
        $item->Visible = false;
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        if (!$this->isGridAdd() && !$this->isGridEdit()) { // Not grid add/edit mode
            $option = $options["action"];
            // Set up list action buttons
            foreach ($this->ListActions->Items as $listaction) {
                if ($listaction->Select == ACTION_MULTIPLE) {
                    $item = &$option->add("custom_" . $listaction->Action);
                    $caption = $listaction->Caption;
                    $icon = ($listaction->Icon != "") ? '<i class="' . HtmlEncode($listaction->Icon) . '" data-caption="' . HtmlEncode($caption) . '"></i>' . $caption : $caption;
                    $item->Body = '<a class="ew-action ew-list-action" title="' . HtmlEncode($caption) . '" data-caption="' . HtmlEncode($caption) . '" href="#" onclick="return ew.submitAction(event,jQuery.extend({f:document.fsortirlist},' . $listaction->toJson(true) . '));">' . $icon . '</a>';
                    $item->Visible = $listaction->Allow;
                }
            }

            // Hide grid edit and other options
            if ($this->TotalRecords <= 0) {
                $option = $options["addedit"];
                $item = $option["gridedit"];
                if ($item) {
                    $item->Visible = false;
                }
                $option = $options["action"];
                $option->hideAllOptions();
            }
        } else { // Grid add/edit mode
            // Hide all options first
            foreach ($options as $option) {
                $option->hideAllOptions();
            }
            $pageUrl = $this->pageUrl();

            // Grid-Add
            if ($this->isGridAdd()) {
                if ($this->AllowAddDeleteRow) {
                    // Add add blank row
                    $option = $options["addedit"];
                    $option->UseDropDownButton = false;
                    $item = &$option->add("addblankrow");
                    $item->Body = "<a class=\"ew-add-edit ew-add-blank-row\" title=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" href=\"#\" onclick=\"return ew.addGridRow(this);\">" . $Language->phrase("AddBlankRow") . "</a>";
                    $item->Visible = $Security->canAdd();
                }
                $option = $options["action"];
                $option->UseDropDownButton = false;
                // Add grid insert
                $item = &$option->add("gridinsert");
                $item->Body = "<a class=\"ew-action ew-grid-insert\" title=\"" . HtmlTitle($Language->phrase("GridInsertLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("GridInsertLink")) . "\" href=\"#\" onclick=\"return ew.forms.get(this).submit('" . $this->pageName() . "');\">" . $Language->phrase("GridInsertLink") . "</a>";
                // Add grid cancel
                $item = &$option->add("gridcancel");
                $cancelurl = $this->addMasterUrl($pageUrl . "action=cancel");
                $item->Body = "<a class=\"ew-action ew-grid-cancel\" title=\"" . HtmlTitle($Language->phrase("GridCancelLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("GridCancelLink")) . "\" href=\"" . $cancelurl . "\">" . $Language->phrase("GridCancelLink") . "</a>";
            }

            // Grid-Edit
            if ($this->isGridEdit()) {
                if ($this->AllowAddDeleteRow) {
                    // Add add blank row
                    $option = $options["addedit"];
                    $option->UseDropDownButton = false;
                    $item = &$option->add("addblankrow");
                    $item->Body = "<a class=\"ew-add-edit ew-add-blank-row\" title=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" href=\"#\" onclick=\"return ew.addGridRow(this);\">" . $Language->phrase("AddBlankRow") . "</a>";
                    $item->Visible = $Security->canAdd();
                }
                $option = $options["action"];
                $option->UseDropDownButton = false;
                    $item = &$option->add("gridsave");
                    $item->Body = "<a class=\"ew-action ew-grid-save\" title=\"" . HtmlTitle($Language->phrase("GridSaveLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("GridSaveLink")) . "\" href=\"#\" onclick=\"return ew.forms.get(this).submit('" . $this->pageName() . "');\">" . $Language->phrase("GridSaveLink") . "</a>";
                    $item = &$option->add("gridcancel");
                    $cancelurl = $this->addMasterUrl($pageUrl . "action=cancel");
                    $item->Body = "<a class=\"ew-action ew-grid-cancel\" title=\"" . HtmlTitle($Language->phrase("GridCancelLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("GridCancelLink")) . "\" href=\"" . $cancelurl . "\">" . $Language->phrase("GridCancelLink") . "</a>";
            }
        }
    }

    // Process list action
    protected function processListAction()
    {
        global $Language, $Security;
        $userlist = "";
        $user = "";
        $filter = $this->getFilterFromRecordKeys();
        $userAction = Post("useraction", "");
        if ($filter != "" && $userAction != "") {
            // Check permission first
            $actionCaption = $userAction;
            if (array_key_exists($userAction, $this->ListActions->Items)) {
                $actionCaption = $this->ListActions[$userAction]->Caption;
                if (!$this->ListActions[$userAction]->Allow) {
                    $errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
                    if (Post("ajax") == $userAction) { // Ajax
                        echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                        return true;
                    } else {
                        $this->setFailureMessage($errmsg);
                        return false;
                    }
                }
            }
            $this->CurrentFilter = $filter;
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = LoadRecordset($sql, $conn, \PDO::FETCH_ASSOC);
            $this->CurrentAction = $userAction;

            // Call row action event
            if ($rs) {
                $conn->beginTransaction();
                $this->SelectedCount = $rs->recordCount();
                $this->SelectedIndex = 0;
                while (!$rs->EOF) {
                    $this->SelectedIndex++;
                    $row = $rs->fields;
                    $processed = $this->rowCustomAction($userAction, $row);
                    if (!$processed) {
                        break;
                    }
                    $rs->moveNext();
                }
                if ($processed) {
                    $conn->commit(); // Commit the changes
                    if ($this->getSuccessMessage() == "" && !ob_get_length()) { // No output
                        $this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
                    }
                } else {
                    $conn->rollback(); // Rollback changes

                    // Set up error message
                    if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                        // Use the message, do nothing
                    } elseif ($this->CancelMessage != "") {
                        $this->setFailureMessage($this->CancelMessage);
                        $this->CancelMessage = "";
                    } else {
                        $this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
                    }
                }
            }
            if ($rs) {
                $rs->close();
            }
            $this->CurrentAction = ""; // Clear action
            if (Post("ajax") == $userAction) { // Ajax
                if ($this->getSuccessMessage() != "") {
                    echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
                    $this->clearSuccessMessage(); // Clear message
                }
                if ($this->getFailureMessage() != "") {
                    echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
                    $this->clearFailureMessage(); // Clear message
                }
                return true;
            }
        }
        return false; // Not ajax request
    }

    // Set up list options (extended codes)
    protected function setupListOptionsExt()
    {
    }

    // Render list options (extended codes)
    protected function renderListOptionsExt()
    {
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->sortir_id->CurrentValue = null;
        $this->sortir_id->OldValue = $this->sortir_id->CurrentValue;
        $this->sortir_kedatangan->CurrentValue = null;
        $this->sortir_kedatangan->OldValue = $this->sortir_kedatangan->CurrentValue;
        $this->sortir_petugas->CurrentValue = null;
        $this->sortir_petugas->OldValue = $this->sortir_petugas->CurrentValue;
        $this->sortir_tanggal->CurrentValue = null;
        $this->sortir_tanggal->OldValue = $this->sortir_tanggal->CurrentValue;
        $this->sortir_okking->CurrentValue = 0;
        $this->sortir_okking->OldValue = $this->sortir_okking->CurrentValue;
        $this->sortir_okl->CurrentValue = 0;
        $this->sortir_okl->OldValue = $this->sortir_okl->CurrentValue;
        $this->sortir_okm->CurrentValue = 0;
        $this->sortir_okm->OldValue = $this->sortir_okm->CurrentValue;
        $this->sortir_oks->CurrentValue = 0;
        $this->sortir_oks->OldValue = $this->sortir_oks->CurrentValue;
        $this->sortir_okss->CurrentValue = 0;
        $this->sortir_okss->OldValue = $this->sortir_okss->CurrentValue;
        $this->sortir_oktotal->CurrentValue = 0;
        $this->sortir_oktotal->OldValue = $this->sortir_oktotal->CurrentValue;
        $this->sortir_rijek_busuk->CurrentValue = 0;
        $this->sortir_rijek_busuk->OldValue = $this->sortir_rijek_busuk->CurrentValue;
        $this->sortir_rijek_kecil->CurrentValue = 0;
        $this->sortir_rijek_kecil->OldValue = $this->sortir_rijek_kecil->CurrentValue;
        $this->sortir_rijek_sampah->CurrentValue = 0;
        $this->sortir_rijek_sampah->OldValue = $this->sortir_rijek_sampah->CurrentValue;
        $this->sortir_catatan->CurrentValue = null;
        $this->sortir_catatan->OldValue = $this->sortir_catatan->CurrentValue;
    }

    // Load basic search values
    protected function loadBasicSearchValues()
    {
        $this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), false);
        if ($this->BasicSearch->Keyword != "" && $this->Command == "") {
            $this->Command = "search";
        }
        $this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), false);
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // sortir_id
        if (!$this->isAddOrEdit() && $this->sortir_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->sortir_id->AdvancedSearch->SearchValue != "" || $this->sortir_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // sortir_kedatangan
        if (!$this->isAddOrEdit() && $this->sortir_kedatangan->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->sortir_kedatangan->AdvancedSearch->SearchValue != "" || $this->sortir_kedatangan->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // sortir_petugas
        if (!$this->isAddOrEdit() && $this->sortir_petugas->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->sortir_petugas->AdvancedSearch->SearchValue != "" || $this->sortir_petugas->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // sortir_tanggal
        if (!$this->isAddOrEdit() && $this->sortir_tanggal->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->sortir_tanggal->AdvancedSearch->SearchValue != "" || $this->sortir_tanggal->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // sortir_okking
        if (!$this->isAddOrEdit() && $this->sortir_okking->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->sortir_okking->AdvancedSearch->SearchValue != "" || $this->sortir_okking->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // sortir_okl
        if (!$this->isAddOrEdit() && $this->sortir_okl->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->sortir_okl->AdvancedSearch->SearchValue != "" || $this->sortir_okl->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // sortir_okm
        if (!$this->isAddOrEdit() && $this->sortir_okm->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->sortir_okm->AdvancedSearch->SearchValue != "" || $this->sortir_okm->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // sortir_oks
        if (!$this->isAddOrEdit() && $this->sortir_oks->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->sortir_oks->AdvancedSearch->SearchValue != "" || $this->sortir_oks->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // sortir_okss
        if (!$this->isAddOrEdit() && $this->sortir_okss->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->sortir_okss->AdvancedSearch->SearchValue != "" || $this->sortir_okss->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // sortir_oktotal
        if (!$this->isAddOrEdit() && $this->sortir_oktotal->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->sortir_oktotal->AdvancedSearch->SearchValue != "" || $this->sortir_oktotal->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // sortir_rijek_busuk
        if (!$this->isAddOrEdit() && $this->sortir_rijek_busuk->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->sortir_rijek_busuk->AdvancedSearch->SearchValue != "" || $this->sortir_rijek_busuk->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // sortir_rijek_kecil
        if (!$this->isAddOrEdit() && $this->sortir_rijek_kecil->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->sortir_rijek_kecil->AdvancedSearch->SearchValue != "" || $this->sortir_rijek_kecil->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // sortir_rijek_sampah
        if (!$this->isAddOrEdit() && $this->sortir_rijek_sampah->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->sortir_rijek_sampah->AdvancedSearch->SearchValue != "" || $this->sortir_rijek_sampah->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // sortir_catatan
        if (!$this->isAddOrEdit() && $this->sortir_catatan->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->sortir_catatan->AdvancedSearch->SearchValue != "" || $this->sortir_catatan->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        return $hasValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;

        // Check field name 'sortir_id' first before field var 'x_sortir_id'
        $val = $CurrentForm->hasValue("sortir_id") ? $CurrentForm->getValue("sortir_id") : $CurrentForm->getValue("x_sortir_id");
        if (!$this->sortir_id->IsDetailKey && !$this->isGridAdd() && !$this->isAdd()) {
            $this->sortir_id->setFormValue($val);
        }

        // Check field name 'sortir_kedatangan' first before field var 'x_sortir_kedatangan'
        $val = $CurrentForm->hasValue("sortir_kedatangan") ? $CurrentForm->getValue("sortir_kedatangan") : $CurrentForm->getValue("x_sortir_kedatangan");
        if (!$this->sortir_kedatangan->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sortir_kedatangan->Visible = false; // Disable update for API request
            } else {
                $this->sortir_kedatangan->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_sortir_kedatangan")) {
            $this->sortir_kedatangan->setOldValue($CurrentForm->getValue("o_sortir_kedatangan"));
        }

        // Check field name 'sortir_petugas' first before field var 'x_sortir_petugas'
        $val = $CurrentForm->hasValue("sortir_petugas") ? $CurrentForm->getValue("sortir_petugas") : $CurrentForm->getValue("x_sortir_petugas");
        if (!$this->sortir_petugas->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sortir_petugas->Visible = false; // Disable update for API request
            } else {
                $this->sortir_petugas->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_sortir_petugas")) {
            $this->sortir_petugas->setOldValue($CurrentForm->getValue("o_sortir_petugas"));
        }

        // Check field name 'sortir_tanggal' first before field var 'x_sortir_tanggal'
        $val = $CurrentForm->hasValue("sortir_tanggal") ? $CurrentForm->getValue("sortir_tanggal") : $CurrentForm->getValue("x_sortir_tanggal");
        if (!$this->sortir_tanggal->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sortir_tanggal->Visible = false; // Disable update for API request
            } else {
                $this->sortir_tanggal->setFormValue($val);
            }
            $this->sortir_tanggal->CurrentValue = UnFormatDateTime($this->sortir_tanggal->CurrentValue, 0);
        }
        if ($CurrentForm->hasValue("o_sortir_tanggal")) {
            $this->sortir_tanggal->setOldValue($CurrentForm->getValue("o_sortir_tanggal"));
        }

        // Check field name 'sortir_okking' first before field var 'x_sortir_okking'
        $val = $CurrentForm->hasValue("sortir_okking") ? $CurrentForm->getValue("sortir_okking") : $CurrentForm->getValue("x_sortir_okking");
        if (!$this->sortir_okking->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sortir_okking->Visible = false; // Disable update for API request
            } else {
                $this->sortir_okking->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_sortir_okking")) {
            $this->sortir_okking->setOldValue($CurrentForm->getValue("o_sortir_okking"));
        }

        // Check field name 'sortir_okl' first before field var 'x_sortir_okl'
        $val = $CurrentForm->hasValue("sortir_okl") ? $CurrentForm->getValue("sortir_okl") : $CurrentForm->getValue("x_sortir_okl");
        if (!$this->sortir_okl->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sortir_okl->Visible = false; // Disable update for API request
            } else {
                $this->sortir_okl->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_sortir_okl")) {
            $this->sortir_okl->setOldValue($CurrentForm->getValue("o_sortir_okl"));
        }

        // Check field name 'sortir_okm' first before field var 'x_sortir_okm'
        $val = $CurrentForm->hasValue("sortir_okm") ? $CurrentForm->getValue("sortir_okm") : $CurrentForm->getValue("x_sortir_okm");
        if (!$this->sortir_okm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sortir_okm->Visible = false; // Disable update for API request
            } else {
                $this->sortir_okm->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_sortir_okm")) {
            $this->sortir_okm->setOldValue($CurrentForm->getValue("o_sortir_okm"));
        }

        // Check field name 'sortir_oks' first before field var 'x_sortir_oks'
        $val = $CurrentForm->hasValue("sortir_oks") ? $CurrentForm->getValue("sortir_oks") : $CurrentForm->getValue("x_sortir_oks");
        if (!$this->sortir_oks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sortir_oks->Visible = false; // Disable update for API request
            } else {
                $this->sortir_oks->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_sortir_oks")) {
            $this->sortir_oks->setOldValue($CurrentForm->getValue("o_sortir_oks"));
        }

        // Check field name 'sortir_okss' first before field var 'x_sortir_okss'
        $val = $CurrentForm->hasValue("sortir_okss") ? $CurrentForm->getValue("sortir_okss") : $CurrentForm->getValue("x_sortir_okss");
        if (!$this->sortir_okss->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sortir_okss->Visible = false; // Disable update for API request
            } else {
                $this->sortir_okss->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_sortir_okss")) {
            $this->sortir_okss->setOldValue($CurrentForm->getValue("o_sortir_okss"));
        }

        // Check field name 'sortir_oktotal' first before field var 'x_sortir_oktotal'
        $val = $CurrentForm->hasValue("sortir_oktotal") ? $CurrentForm->getValue("sortir_oktotal") : $CurrentForm->getValue("x_sortir_oktotal");
        if (!$this->sortir_oktotal->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sortir_oktotal->Visible = false; // Disable update for API request
            } else {
                $this->sortir_oktotal->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_sortir_oktotal")) {
            $this->sortir_oktotal->setOldValue($CurrentForm->getValue("o_sortir_oktotal"));
        }

        // Check field name 'sortir_rijek_busuk' first before field var 'x_sortir_rijek_busuk'
        $val = $CurrentForm->hasValue("sortir_rijek_busuk") ? $CurrentForm->getValue("sortir_rijek_busuk") : $CurrentForm->getValue("x_sortir_rijek_busuk");
        if (!$this->sortir_rijek_busuk->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sortir_rijek_busuk->Visible = false; // Disable update for API request
            } else {
                $this->sortir_rijek_busuk->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_sortir_rijek_busuk")) {
            $this->sortir_rijek_busuk->setOldValue($CurrentForm->getValue("o_sortir_rijek_busuk"));
        }

        // Check field name 'sortir_rijek_kecil' first before field var 'x_sortir_rijek_kecil'
        $val = $CurrentForm->hasValue("sortir_rijek_kecil") ? $CurrentForm->getValue("sortir_rijek_kecil") : $CurrentForm->getValue("x_sortir_rijek_kecil");
        if (!$this->sortir_rijek_kecil->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sortir_rijek_kecil->Visible = false; // Disable update for API request
            } else {
                $this->sortir_rijek_kecil->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_sortir_rijek_kecil")) {
            $this->sortir_rijek_kecil->setOldValue($CurrentForm->getValue("o_sortir_rijek_kecil"));
        }

        // Check field name 'sortir_rijek_sampah' first before field var 'x_sortir_rijek_sampah'
        $val = $CurrentForm->hasValue("sortir_rijek_sampah") ? $CurrentForm->getValue("sortir_rijek_sampah") : $CurrentForm->getValue("x_sortir_rijek_sampah");
        if (!$this->sortir_rijek_sampah->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sortir_rijek_sampah->Visible = false; // Disable update for API request
            } else {
                $this->sortir_rijek_sampah->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_sortir_rijek_sampah")) {
            $this->sortir_rijek_sampah->setOldValue($CurrentForm->getValue("o_sortir_rijek_sampah"));
        }

        // Check field name 'sortir_catatan' first before field var 'x_sortir_catatan'
        $val = $CurrentForm->hasValue("sortir_catatan") ? $CurrentForm->getValue("sortir_catatan") : $CurrentForm->getValue("x_sortir_catatan");
        if (!$this->sortir_catatan->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sortir_catatan->Visible = false; // Disable update for API request
            } else {
                $this->sortir_catatan->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_sortir_catatan")) {
            $this->sortir_catatan->setOldValue($CurrentForm->getValue("o_sortir_catatan"));
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        if (!$this->isGridAdd() && !$this->isAdd()) {
            $this->sortir_id->CurrentValue = $this->sortir_id->FormValue;
        }
        $this->sortir_kedatangan->CurrentValue = $this->sortir_kedatangan->FormValue;
        $this->sortir_petugas->CurrentValue = $this->sortir_petugas->FormValue;
        $this->sortir_tanggal->CurrentValue = $this->sortir_tanggal->FormValue;
        $this->sortir_tanggal->CurrentValue = UnFormatDateTime($this->sortir_tanggal->CurrentValue, 0);
        $this->sortir_okking->CurrentValue = $this->sortir_okking->FormValue;
        $this->sortir_okl->CurrentValue = $this->sortir_okl->FormValue;
        $this->sortir_okm->CurrentValue = $this->sortir_okm->FormValue;
        $this->sortir_oks->CurrentValue = $this->sortir_oks->FormValue;
        $this->sortir_okss->CurrentValue = $this->sortir_okss->FormValue;
        $this->sortir_oktotal->CurrentValue = $this->sortir_oktotal->FormValue;
        $this->sortir_rijek_busuk->CurrentValue = $this->sortir_rijek_busuk->FormValue;
        $this->sortir_rijek_kecil->CurrentValue = $this->sortir_rijek_kecil->FormValue;
        $this->sortir_rijek_sampah->CurrentValue = $this->sortir_rijek_sampah->FormValue;
        $this->sortir_catatan->CurrentValue = $this->sortir_catatan->FormValue;
    }

    // Load recordset
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load recordset
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > -1) {
            $sql->setMaxResults($rowcnt);
        }
        $stmt = $sql->execute();
        $rs = new Recordset($stmt, $sql);

        // Call Recordset Selected event
        $this->recordsetSelected($rs);
        return $rs;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssoc($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
            if (!$this->EventCancelled) {
                $this->HashValue = $this->getRowHash($row); // Get hash value for record
            }
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }

        // Call Row Selected event
        $this->rowSelected($row);
        if (!$rs) {
            return;
        }
        $this->sortir_id->setDbValue($row['sortir_id']);
        $this->sortir_kedatangan->setDbValue($row['sortir_kedatangan']);
        $this->sortir_petugas->setDbValue($row['sortir_petugas']);
        $this->sortir_tanggal->setDbValue($row['sortir_tanggal']);
        $this->sortir_okking->setDbValue($row['sortir_okking']);
        $this->sortir_okl->setDbValue($row['sortir_okl']);
        $this->sortir_okm->setDbValue($row['sortir_okm']);
        $this->sortir_oks->setDbValue($row['sortir_oks']);
        $this->sortir_okss->setDbValue($row['sortir_okss']);
        $this->sortir_oktotal->setDbValue($row['sortir_oktotal']);
        $this->sortir_rijek_busuk->setDbValue($row['sortir_rijek_busuk']);
        $this->sortir_rijek_kecil->setDbValue($row['sortir_rijek_kecil']);
        $this->sortir_rijek_sampah->setDbValue($row['sortir_rijek_sampah']);
        $this->sortir_catatan->setDbValue($row['sortir_catatan']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $this->loadDefaultValues();
        $row = [];
        $row['sortir_id'] = $this->sortir_id->CurrentValue;
        $row['sortir_kedatangan'] = $this->sortir_kedatangan->CurrentValue;
        $row['sortir_petugas'] = $this->sortir_petugas->CurrentValue;
        $row['sortir_tanggal'] = $this->sortir_tanggal->CurrentValue;
        $row['sortir_okking'] = $this->sortir_okking->CurrentValue;
        $row['sortir_okl'] = $this->sortir_okl->CurrentValue;
        $row['sortir_okm'] = $this->sortir_okm->CurrentValue;
        $row['sortir_oks'] = $this->sortir_oks->CurrentValue;
        $row['sortir_okss'] = $this->sortir_okss->CurrentValue;
        $row['sortir_oktotal'] = $this->sortir_oktotal->CurrentValue;
        $row['sortir_rijek_busuk'] = $this->sortir_rijek_busuk->CurrentValue;
        $row['sortir_rijek_kecil'] = $this->sortir_rijek_kecil->CurrentValue;
        $row['sortir_rijek_sampah'] = $this->sortir_rijek_sampah->CurrentValue;
        $row['sortir_catatan'] = $this->sortir_catatan->CurrentValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load key values from Session
        $validKey = true;
        if (strval($this->getKey("sortir_id")) != "") {
            $this->sortir_id->OldValue = $this->getKey("sortir_id"); // sortir_id
        } else {
            $validKey = false;
        }

        // Load old record
        $this->OldRecordset = null;
        if ($validKey) {
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $this->OldRecordset = LoadRecordset($sql, $conn);
        }
        $this->loadRowValues($this->OldRecordset); // Load row values
        return $validKey;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->InlineEditUrl = $this->getInlineEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->InlineCopyUrl = $this->getInlineCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Convert decimal values if posted back
        if ($this->sortir_okking->FormValue == $this->sortir_okking->CurrentValue && is_numeric(ConvertToFloatString($this->sortir_okking->CurrentValue))) {
            $this->sortir_okking->CurrentValue = ConvertToFloatString($this->sortir_okking->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->sortir_okl->FormValue == $this->sortir_okl->CurrentValue && is_numeric(ConvertToFloatString($this->sortir_okl->CurrentValue))) {
            $this->sortir_okl->CurrentValue = ConvertToFloatString($this->sortir_okl->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->sortir_okm->FormValue == $this->sortir_okm->CurrentValue && is_numeric(ConvertToFloatString($this->sortir_okm->CurrentValue))) {
            $this->sortir_okm->CurrentValue = ConvertToFloatString($this->sortir_okm->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->sortir_oks->FormValue == $this->sortir_oks->CurrentValue && is_numeric(ConvertToFloatString($this->sortir_oks->CurrentValue))) {
            $this->sortir_oks->CurrentValue = ConvertToFloatString($this->sortir_oks->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->sortir_okss->FormValue == $this->sortir_okss->CurrentValue && is_numeric(ConvertToFloatString($this->sortir_okss->CurrentValue))) {
            $this->sortir_okss->CurrentValue = ConvertToFloatString($this->sortir_okss->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->sortir_oktotal->FormValue == $this->sortir_oktotal->CurrentValue && is_numeric(ConvertToFloatString($this->sortir_oktotal->CurrentValue))) {
            $this->sortir_oktotal->CurrentValue = ConvertToFloatString($this->sortir_oktotal->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->sortir_rijek_busuk->FormValue == $this->sortir_rijek_busuk->CurrentValue && is_numeric(ConvertToFloatString($this->sortir_rijek_busuk->CurrentValue))) {
            $this->sortir_rijek_busuk->CurrentValue = ConvertToFloatString($this->sortir_rijek_busuk->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->sortir_rijek_kecil->FormValue == $this->sortir_rijek_kecil->CurrentValue && is_numeric(ConvertToFloatString($this->sortir_rijek_kecil->CurrentValue))) {
            $this->sortir_rijek_kecil->CurrentValue = ConvertToFloatString($this->sortir_rijek_kecil->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->sortir_rijek_sampah->FormValue == $this->sortir_rijek_sampah->CurrentValue && is_numeric(ConvertToFloatString($this->sortir_rijek_sampah->CurrentValue))) {
            $this->sortir_rijek_sampah->CurrentValue = ConvertToFloatString($this->sortir_rijek_sampah->CurrentValue);
        }

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // sortir_id

        // sortir_kedatangan

        // sortir_petugas

        // sortir_tanggal

        // sortir_okking

        // sortir_okl

        // sortir_okm

        // sortir_oks

        // sortir_okss

        // sortir_oktotal

        // sortir_rijek_busuk

        // sortir_rijek_kecil

        // sortir_rijek_sampah

        // sortir_catatan
        if ($this->RowType == ROWTYPE_VIEW) {
            // sortir_id
            $this->sortir_id->ViewValue = $this->sortir_id->CurrentValue;
            $this->sortir_id->ViewValue = FormatNumber($this->sortir_id->ViewValue, 0, -2, -2, -2);
            $this->sortir_id->ViewCustomAttributes = "";

            // sortir_kedatangan
            $curVal = strval($this->sortir_kedatangan->CurrentValue);
            if ($curVal != "") {
                $this->sortir_kedatangan->ViewValue = $this->sortir_kedatangan->lookupCacheOption($curVal);
                if ($this->sortir_kedatangan->ViewValue === null) { // Lookup from database
                    $filterWrk = "`datang_id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->sortir_kedatangan->Lookup->getSql(false, $filterWrk, '', $this, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->sortir_kedatangan->Lookup->renderViewRow($rswrk[0]);
                        $this->sortir_kedatangan->ViewValue = $this->sortir_kedatangan->displayValue($arwrk);
                    } else {
                        $this->sortir_kedatangan->ViewValue = $this->sortir_kedatangan->CurrentValue;
                    }
                }
            } else {
                $this->sortir_kedatangan->ViewValue = null;
            }
            $this->sortir_kedatangan->ViewCustomAttributes = "";

            // sortir_petugas
            $this->sortir_petugas->ViewValue = $this->sortir_petugas->CurrentValue;
            $this->sortir_petugas->ViewCustomAttributes = "";

            // sortir_tanggal
            $this->sortir_tanggal->ViewValue = $this->sortir_tanggal->CurrentValue;
            $this->sortir_tanggal->ViewValue = FormatDateTime($this->sortir_tanggal->ViewValue, 0);
            $this->sortir_tanggal->ViewCustomAttributes = "";

            // sortir_okking
            $this->sortir_okking->ViewValue = $this->sortir_okking->CurrentValue;
            $this->sortir_okking->ViewValue = FormatNumber($this->sortir_okking->ViewValue, 2, -2, -2, -2);
            $this->sortir_okking->ViewCustomAttributes = "";

            // sortir_okl
            $this->sortir_okl->ViewValue = $this->sortir_okl->CurrentValue;
            $this->sortir_okl->ViewValue = FormatNumber($this->sortir_okl->ViewValue, 2, -2, -2, -2);
            $this->sortir_okl->ViewCustomAttributes = "";

            // sortir_okm
            $this->sortir_okm->ViewValue = $this->sortir_okm->CurrentValue;
            $this->sortir_okm->ViewValue = FormatNumber($this->sortir_okm->ViewValue, 2, -2, -2, -2);
            $this->sortir_okm->ViewCustomAttributes = "";

            // sortir_oks
            $this->sortir_oks->ViewValue = $this->sortir_oks->CurrentValue;
            $this->sortir_oks->ViewValue = FormatNumber($this->sortir_oks->ViewValue, 2, -2, -2, -2);
            $this->sortir_oks->ViewCustomAttributes = "";

            // sortir_okss
            $this->sortir_okss->ViewValue = $this->sortir_okss->CurrentValue;
            $this->sortir_okss->ViewValue = FormatNumber($this->sortir_okss->ViewValue, 2, -2, -2, -2);
            $this->sortir_okss->ViewCustomAttributes = "";

            // sortir_oktotal
            $this->sortir_oktotal->ViewValue = $this->sortir_oktotal->CurrentValue;
            $this->sortir_oktotal->ViewValue = FormatNumber($this->sortir_oktotal->ViewValue, 2, -2, -2, -2);
            $this->sortir_oktotal->ViewCustomAttributes = "";

            // sortir_rijek_busuk
            $this->sortir_rijek_busuk->ViewValue = $this->sortir_rijek_busuk->CurrentValue;
            $this->sortir_rijek_busuk->ViewValue = FormatNumber($this->sortir_rijek_busuk->ViewValue, 2, -2, -2, -2);
            $this->sortir_rijek_busuk->ViewCustomAttributes = "";

            // sortir_rijek_kecil
            $this->sortir_rijek_kecil->ViewValue = $this->sortir_rijek_kecil->CurrentValue;
            $this->sortir_rijek_kecil->ViewValue = FormatNumber($this->sortir_rijek_kecil->ViewValue, 2, -2, -2, -2);
            $this->sortir_rijek_kecil->ViewCustomAttributes = "";

            // sortir_rijek_sampah
            $this->sortir_rijek_sampah->ViewValue = $this->sortir_rijek_sampah->CurrentValue;
            $this->sortir_rijek_sampah->ViewValue = FormatNumber($this->sortir_rijek_sampah->ViewValue, 2, -2, -2, -2);
            $this->sortir_rijek_sampah->ViewCustomAttributes = "";

            // sortir_catatan
            $this->sortir_catatan->ViewValue = $this->sortir_catatan->CurrentValue;
            $this->sortir_catatan->ViewCustomAttributes = "";

            // sortir_id
            $this->sortir_id->LinkCustomAttributes = "";
            $this->sortir_id->HrefValue = "";
            $this->sortir_id->TooltipValue = "";

            // sortir_kedatangan
            $this->sortir_kedatangan->LinkCustomAttributes = "";
            $this->sortir_kedatangan->HrefValue = "";
            $this->sortir_kedatangan->TooltipValue = "";

            // sortir_petugas
            $this->sortir_petugas->LinkCustomAttributes = "";
            $this->sortir_petugas->HrefValue = "";
            $this->sortir_petugas->TooltipValue = "";

            // sortir_tanggal
            $this->sortir_tanggal->LinkCustomAttributes = "";
            $this->sortir_tanggal->HrefValue = "";
            $this->sortir_tanggal->TooltipValue = "";

            // sortir_okking
            $this->sortir_okking->LinkCustomAttributes = "";
            $this->sortir_okking->HrefValue = "";
            $this->sortir_okking->TooltipValue = "";

            // sortir_okl
            $this->sortir_okl->LinkCustomAttributes = "";
            $this->sortir_okl->HrefValue = "";
            $this->sortir_okl->TooltipValue = "";

            // sortir_okm
            $this->sortir_okm->LinkCustomAttributes = "";
            $this->sortir_okm->HrefValue = "";
            $this->sortir_okm->TooltipValue = "";

            // sortir_oks
            $this->sortir_oks->LinkCustomAttributes = "";
            $this->sortir_oks->HrefValue = "";
            $this->sortir_oks->TooltipValue = "";

            // sortir_okss
            $this->sortir_okss->LinkCustomAttributes = "";
            $this->sortir_okss->HrefValue = "";
            $this->sortir_okss->TooltipValue = "";

            // sortir_oktotal
            $this->sortir_oktotal->LinkCustomAttributes = "";
            $this->sortir_oktotal->HrefValue = "";
            $this->sortir_oktotal->TooltipValue = "";

            // sortir_rijek_busuk
            $this->sortir_rijek_busuk->LinkCustomAttributes = "";
            $this->sortir_rijek_busuk->HrefValue = "";
            $this->sortir_rijek_busuk->TooltipValue = "";

            // sortir_rijek_kecil
            $this->sortir_rijek_kecil->LinkCustomAttributes = "";
            $this->sortir_rijek_kecil->HrefValue = "";
            $this->sortir_rijek_kecil->TooltipValue = "";

            // sortir_rijek_sampah
            $this->sortir_rijek_sampah->LinkCustomAttributes = "";
            $this->sortir_rijek_sampah->HrefValue = "";
            $this->sortir_rijek_sampah->TooltipValue = "";

            // sortir_catatan
            $this->sortir_catatan->LinkCustomAttributes = "";
            $this->sortir_catatan->HrefValue = "";
            $this->sortir_catatan->TooltipValue = "";
        } elseif ($this->RowType == ROWTYPE_ADD) {
            // sortir_id

            // sortir_kedatangan
            $this->sortir_kedatangan->EditAttrs["class"] = "form-control";
            $this->sortir_kedatangan->EditCustomAttributes = "";
            $curVal = trim(strval($this->sortir_kedatangan->CurrentValue));
            if ($curVal != "") {
                $this->sortir_kedatangan->ViewValue = $this->sortir_kedatangan->lookupCacheOption($curVal);
            } else {
                $this->sortir_kedatangan->ViewValue = $this->sortir_kedatangan->Lookup !== null && is_array($this->sortir_kedatangan->Lookup->Options) ? $curVal : null;
            }
            if ($this->sortir_kedatangan->ViewValue !== null) { // Load from cache
                $this->sortir_kedatangan->EditValue = array_values($this->sortir_kedatangan->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`datang_id`" . SearchString("=", $this->sortir_kedatangan->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->sortir_kedatangan->Lookup->getSql(true, $filterWrk, '', $this);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row)
                    $row = $this->sortir_kedatangan->Lookup->renderViewRow($row);
                $this->sortir_kedatangan->EditValue = $arwrk;
            }
            $this->sortir_kedatangan->PlaceHolder = RemoveHtml($this->sortir_kedatangan->caption());

            // sortir_petugas

            // sortir_tanggal
            $this->sortir_tanggal->EditAttrs["class"] = "form-control";
            $this->sortir_tanggal->EditCustomAttributes = "";
            $this->sortir_tanggal->EditValue = HtmlEncode(FormatDateTime($this->sortir_tanggal->CurrentValue, 8));
            $this->sortir_tanggal->PlaceHolder = RemoveHtml($this->sortir_tanggal->caption());

            // sortir_okking
            $this->sortir_okking->EditAttrs["class"] = "form-control";
            $this->sortir_okking->EditCustomAttributes = "";
            $this->sortir_okking->EditValue = HtmlEncode($this->sortir_okking->CurrentValue);
            $this->sortir_okking->PlaceHolder = RemoveHtml($this->sortir_okking->caption());
            if (strval($this->sortir_okking->EditValue) != "" && is_numeric($this->sortir_okking->EditValue)) {
                $this->sortir_okking->EditValue = FormatNumber($this->sortir_okking->EditValue, -2, -2, -2, -2);
                $this->sortir_okking->OldValue = $this->sortir_okking->EditValue;
            }

            // sortir_okl
            $this->sortir_okl->EditAttrs["class"] = "form-control";
            $this->sortir_okl->EditCustomAttributes = "";
            $this->sortir_okl->EditValue = HtmlEncode($this->sortir_okl->CurrentValue);
            $this->sortir_okl->PlaceHolder = RemoveHtml($this->sortir_okl->caption());
            if (strval($this->sortir_okl->EditValue) != "" && is_numeric($this->sortir_okl->EditValue)) {
                $this->sortir_okl->EditValue = FormatNumber($this->sortir_okl->EditValue, -2, -2, -2, -2);
                $this->sortir_okl->OldValue = $this->sortir_okl->EditValue;
            }

            // sortir_okm
            $this->sortir_okm->EditAttrs["class"] = "form-control";
            $this->sortir_okm->EditCustomAttributes = "";
            $this->sortir_okm->EditValue = HtmlEncode($this->sortir_okm->CurrentValue);
            $this->sortir_okm->PlaceHolder = RemoveHtml($this->sortir_okm->caption());
            if (strval($this->sortir_okm->EditValue) != "" && is_numeric($this->sortir_okm->EditValue)) {
                $this->sortir_okm->EditValue = FormatNumber($this->sortir_okm->EditValue, -2, -2, -2, -2);
                $this->sortir_okm->OldValue = $this->sortir_okm->EditValue;
            }

            // sortir_oks
            $this->sortir_oks->EditAttrs["class"] = "form-control";
            $this->sortir_oks->EditCustomAttributes = "";
            $this->sortir_oks->EditValue = HtmlEncode($this->sortir_oks->CurrentValue);
            $this->sortir_oks->PlaceHolder = RemoveHtml($this->sortir_oks->caption());
            if (strval($this->sortir_oks->EditValue) != "" && is_numeric($this->sortir_oks->EditValue)) {
                $this->sortir_oks->EditValue = FormatNumber($this->sortir_oks->EditValue, -2, -2, -2, -2);
                $this->sortir_oks->OldValue = $this->sortir_oks->EditValue;
            }

            // sortir_okss
            $this->sortir_okss->EditAttrs["class"] = "form-control";
            $this->sortir_okss->EditCustomAttributes = "";
            $this->sortir_okss->EditValue = HtmlEncode($this->sortir_okss->CurrentValue);
            $this->sortir_okss->PlaceHolder = RemoveHtml($this->sortir_okss->caption());
            if (strval($this->sortir_okss->EditValue) != "" && is_numeric($this->sortir_okss->EditValue)) {
                $this->sortir_okss->EditValue = FormatNumber($this->sortir_okss->EditValue, -2, -2, -2, -2);
                $this->sortir_okss->OldValue = $this->sortir_okss->EditValue;
            }

            // sortir_oktotal
            $this->sortir_oktotal->EditAttrs["class"] = "form-control";
            $this->sortir_oktotal->EditCustomAttributes = "";
            $this->sortir_oktotal->EditValue = HtmlEncode($this->sortir_oktotal->CurrentValue);
            $this->sortir_oktotal->PlaceHolder = RemoveHtml($this->sortir_oktotal->caption());
            if (strval($this->sortir_oktotal->EditValue) != "" && is_numeric($this->sortir_oktotal->EditValue)) {
                $this->sortir_oktotal->EditValue = FormatNumber($this->sortir_oktotal->EditValue, -2, -2, -2, -2);
                $this->sortir_oktotal->OldValue = $this->sortir_oktotal->EditValue;
            }

            // sortir_rijek_busuk
            $this->sortir_rijek_busuk->EditAttrs["class"] = "form-control";
            $this->sortir_rijek_busuk->EditCustomAttributes = "";
            $this->sortir_rijek_busuk->EditValue = HtmlEncode($this->sortir_rijek_busuk->CurrentValue);
            $this->sortir_rijek_busuk->PlaceHolder = RemoveHtml($this->sortir_rijek_busuk->caption());
            if (strval($this->sortir_rijek_busuk->EditValue) != "" && is_numeric($this->sortir_rijek_busuk->EditValue)) {
                $this->sortir_rijek_busuk->EditValue = FormatNumber($this->sortir_rijek_busuk->EditValue, -2, -2, -2, -2);
                $this->sortir_rijek_busuk->OldValue = $this->sortir_rijek_busuk->EditValue;
            }

            // sortir_rijek_kecil
            $this->sortir_rijek_kecil->EditAttrs["class"] = "form-control";
            $this->sortir_rijek_kecil->EditCustomAttributes = "";
            $this->sortir_rijek_kecil->EditValue = HtmlEncode($this->sortir_rijek_kecil->CurrentValue);
            $this->sortir_rijek_kecil->PlaceHolder = RemoveHtml($this->sortir_rijek_kecil->caption());
            if (strval($this->sortir_rijek_kecil->EditValue) != "" && is_numeric($this->sortir_rijek_kecil->EditValue)) {
                $this->sortir_rijek_kecil->EditValue = FormatNumber($this->sortir_rijek_kecil->EditValue, -2, -2, -2, -2);
                $this->sortir_rijek_kecil->OldValue = $this->sortir_rijek_kecil->EditValue;
            }

            // sortir_rijek_sampah
            $this->sortir_rijek_sampah->EditAttrs["class"] = "form-control";
            $this->sortir_rijek_sampah->EditCustomAttributes = "";
            $this->sortir_rijek_sampah->EditValue = HtmlEncode($this->sortir_rijek_sampah->CurrentValue);
            $this->sortir_rijek_sampah->PlaceHolder = RemoveHtml($this->sortir_rijek_sampah->caption());
            if (strval($this->sortir_rijek_sampah->EditValue) != "" && is_numeric($this->sortir_rijek_sampah->EditValue)) {
                $this->sortir_rijek_sampah->EditValue = FormatNumber($this->sortir_rijek_sampah->EditValue, -2, -2, -2, -2);
                $this->sortir_rijek_sampah->OldValue = $this->sortir_rijek_sampah->EditValue;
            }

            // sortir_catatan
            $this->sortir_catatan->EditAttrs["class"] = "form-control";
            $this->sortir_catatan->EditCustomAttributes = "";
            $this->sortir_catatan->EditValue = HtmlEncode($this->sortir_catatan->CurrentValue);
            $this->sortir_catatan->PlaceHolder = RemoveHtml($this->sortir_catatan->caption());

            // Add refer script

            // sortir_id
            $this->sortir_id->LinkCustomAttributes = "";
            $this->sortir_id->HrefValue = "";

            // sortir_kedatangan
            $this->sortir_kedatangan->LinkCustomAttributes = "";
            $this->sortir_kedatangan->HrefValue = "";

            // sortir_petugas
            $this->sortir_petugas->LinkCustomAttributes = "";
            $this->sortir_petugas->HrefValue = "";

            // sortir_tanggal
            $this->sortir_tanggal->LinkCustomAttributes = "";
            $this->sortir_tanggal->HrefValue = "";

            // sortir_okking
            $this->sortir_okking->LinkCustomAttributes = "";
            $this->sortir_okking->HrefValue = "";

            // sortir_okl
            $this->sortir_okl->LinkCustomAttributes = "";
            $this->sortir_okl->HrefValue = "";

            // sortir_okm
            $this->sortir_okm->LinkCustomAttributes = "";
            $this->sortir_okm->HrefValue = "";

            // sortir_oks
            $this->sortir_oks->LinkCustomAttributes = "";
            $this->sortir_oks->HrefValue = "";

            // sortir_okss
            $this->sortir_okss->LinkCustomAttributes = "";
            $this->sortir_okss->HrefValue = "";

            // sortir_oktotal
            $this->sortir_oktotal->LinkCustomAttributes = "";
            $this->sortir_oktotal->HrefValue = "";

            // sortir_rijek_busuk
            $this->sortir_rijek_busuk->LinkCustomAttributes = "";
            $this->sortir_rijek_busuk->HrefValue = "";

            // sortir_rijek_kecil
            $this->sortir_rijek_kecil->LinkCustomAttributes = "";
            $this->sortir_rijek_kecil->HrefValue = "";

            // sortir_rijek_sampah
            $this->sortir_rijek_sampah->LinkCustomAttributes = "";
            $this->sortir_rijek_sampah->HrefValue = "";

            // sortir_catatan
            $this->sortir_catatan->LinkCustomAttributes = "";
            $this->sortir_catatan->HrefValue = "";
        } elseif ($this->RowType == ROWTYPE_EDIT) {
            // sortir_id
            $this->sortir_id->EditAttrs["class"] = "form-control";
            $this->sortir_id->EditCustomAttributes = "";
            $this->sortir_id->EditValue = $this->sortir_id->CurrentValue;
            $this->sortir_id->EditValue = FormatNumber($this->sortir_id->EditValue, 0, -2, -2, -2);
            $this->sortir_id->ViewCustomAttributes = "";

            // sortir_kedatangan
            $this->sortir_kedatangan->EditAttrs["class"] = "form-control";
            $this->sortir_kedatangan->EditCustomAttributes = "";
            $curVal = trim(strval($this->sortir_kedatangan->CurrentValue));
            if ($curVal != "") {
                $this->sortir_kedatangan->ViewValue = $this->sortir_kedatangan->lookupCacheOption($curVal);
            } else {
                $this->sortir_kedatangan->ViewValue = $this->sortir_kedatangan->Lookup !== null && is_array($this->sortir_kedatangan->Lookup->Options) ? $curVal : null;
            }
            if ($this->sortir_kedatangan->ViewValue !== null) { // Load from cache
                $this->sortir_kedatangan->EditValue = array_values($this->sortir_kedatangan->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`datang_id`" . SearchString("=", $this->sortir_kedatangan->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->sortir_kedatangan->Lookup->getSql(true, $filterWrk, '', $this);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row)
                    $row = $this->sortir_kedatangan->Lookup->renderViewRow($row);
                $this->sortir_kedatangan->EditValue = $arwrk;
            }
            $this->sortir_kedatangan->PlaceHolder = RemoveHtml($this->sortir_kedatangan->caption());

            // sortir_petugas

            // sortir_tanggal
            $this->sortir_tanggal->EditAttrs["class"] = "form-control";
            $this->sortir_tanggal->EditCustomAttributes = "";
            $this->sortir_tanggal->EditValue = HtmlEncode(FormatDateTime($this->sortir_tanggal->CurrentValue, 8));
            $this->sortir_tanggal->PlaceHolder = RemoveHtml($this->sortir_tanggal->caption());

            // sortir_okking
            $this->sortir_okking->EditAttrs["class"] = "form-control";
            $this->sortir_okking->EditCustomAttributes = "";
            $this->sortir_okking->EditValue = HtmlEncode($this->sortir_okking->CurrentValue);
            $this->sortir_okking->PlaceHolder = RemoveHtml($this->sortir_okking->caption());
            if (strval($this->sortir_okking->EditValue) != "" && is_numeric($this->sortir_okking->EditValue)) {
                $this->sortir_okking->EditValue = FormatNumber($this->sortir_okking->EditValue, -2, -2, -2, -2);
                $this->sortir_okking->OldValue = $this->sortir_okking->EditValue;
            }

            // sortir_okl
            $this->sortir_okl->EditAttrs["class"] = "form-control";
            $this->sortir_okl->EditCustomAttributes = "";
            $this->sortir_okl->EditValue = HtmlEncode($this->sortir_okl->CurrentValue);
            $this->sortir_okl->PlaceHolder = RemoveHtml($this->sortir_okl->caption());
            if (strval($this->sortir_okl->EditValue) != "" && is_numeric($this->sortir_okl->EditValue)) {
                $this->sortir_okl->EditValue = FormatNumber($this->sortir_okl->EditValue, -2, -2, -2, -2);
                $this->sortir_okl->OldValue = $this->sortir_okl->EditValue;
            }

            // sortir_okm
            $this->sortir_okm->EditAttrs["class"] = "form-control";
            $this->sortir_okm->EditCustomAttributes = "";
            $this->sortir_okm->EditValue = HtmlEncode($this->sortir_okm->CurrentValue);
            $this->sortir_okm->PlaceHolder = RemoveHtml($this->sortir_okm->caption());
            if (strval($this->sortir_okm->EditValue) != "" && is_numeric($this->sortir_okm->EditValue)) {
                $this->sortir_okm->EditValue = FormatNumber($this->sortir_okm->EditValue, -2, -2, -2, -2);
                $this->sortir_okm->OldValue = $this->sortir_okm->EditValue;
            }

            // sortir_oks
            $this->sortir_oks->EditAttrs["class"] = "form-control";
            $this->sortir_oks->EditCustomAttributes = "";
            $this->sortir_oks->EditValue = HtmlEncode($this->sortir_oks->CurrentValue);
            $this->sortir_oks->PlaceHolder = RemoveHtml($this->sortir_oks->caption());
            if (strval($this->sortir_oks->EditValue) != "" && is_numeric($this->sortir_oks->EditValue)) {
                $this->sortir_oks->EditValue = FormatNumber($this->sortir_oks->EditValue, -2, -2, -2, -2);
                $this->sortir_oks->OldValue = $this->sortir_oks->EditValue;
            }

            // sortir_okss
            $this->sortir_okss->EditAttrs["class"] = "form-control";
            $this->sortir_okss->EditCustomAttributes = "";
            $this->sortir_okss->EditValue = HtmlEncode($this->sortir_okss->CurrentValue);
            $this->sortir_okss->PlaceHolder = RemoveHtml($this->sortir_okss->caption());
            if (strval($this->sortir_okss->EditValue) != "" && is_numeric($this->sortir_okss->EditValue)) {
                $this->sortir_okss->EditValue = FormatNumber($this->sortir_okss->EditValue, -2, -2, -2, -2);
                $this->sortir_okss->OldValue = $this->sortir_okss->EditValue;
            }

            // sortir_oktotal
            $this->sortir_oktotal->EditAttrs["class"] = "form-control";
            $this->sortir_oktotal->EditCustomAttributes = "";
            $this->sortir_oktotal->EditValue = $this->sortir_oktotal->CurrentValue;
            $this->sortir_oktotal->EditValue = FormatNumber($this->sortir_oktotal->EditValue, 2, -2, -2, -2);
            $this->sortir_oktotal->ViewCustomAttributes = "";

            // sortir_rijek_busuk
            $this->sortir_rijek_busuk->EditAttrs["class"] = "form-control";
            $this->sortir_rijek_busuk->EditCustomAttributes = "";
            $this->sortir_rijek_busuk->EditValue = HtmlEncode($this->sortir_rijek_busuk->CurrentValue);
            $this->sortir_rijek_busuk->PlaceHolder = RemoveHtml($this->sortir_rijek_busuk->caption());
            if (strval($this->sortir_rijek_busuk->EditValue) != "" && is_numeric($this->sortir_rijek_busuk->EditValue)) {
                $this->sortir_rijek_busuk->EditValue = FormatNumber($this->sortir_rijek_busuk->EditValue, -2, -2, -2, -2);
                $this->sortir_rijek_busuk->OldValue = $this->sortir_rijek_busuk->EditValue;
            }

            // sortir_rijek_kecil
            $this->sortir_rijek_kecil->EditAttrs["class"] = "form-control";
            $this->sortir_rijek_kecil->EditCustomAttributes = "";
            $this->sortir_rijek_kecil->EditValue = HtmlEncode($this->sortir_rijek_kecil->CurrentValue);
            $this->sortir_rijek_kecil->PlaceHolder = RemoveHtml($this->sortir_rijek_kecil->caption());
            if (strval($this->sortir_rijek_kecil->EditValue) != "" && is_numeric($this->sortir_rijek_kecil->EditValue)) {
                $this->sortir_rijek_kecil->EditValue = FormatNumber($this->sortir_rijek_kecil->EditValue, -2, -2, -2, -2);
                $this->sortir_rijek_kecil->OldValue = $this->sortir_rijek_kecil->EditValue;
            }

            // sortir_rijek_sampah
            $this->sortir_rijek_sampah->EditAttrs["class"] = "form-control";
            $this->sortir_rijek_sampah->EditCustomAttributes = "";
            $this->sortir_rijek_sampah->EditValue = HtmlEncode($this->sortir_rijek_sampah->CurrentValue);
            $this->sortir_rijek_sampah->PlaceHolder = RemoveHtml($this->sortir_rijek_sampah->caption());
            if (strval($this->sortir_rijek_sampah->EditValue) != "" && is_numeric($this->sortir_rijek_sampah->EditValue)) {
                $this->sortir_rijek_sampah->EditValue = FormatNumber($this->sortir_rijek_sampah->EditValue, -2, -2, -2, -2);
                $this->sortir_rijek_sampah->OldValue = $this->sortir_rijek_sampah->EditValue;
            }

            // sortir_catatan
            $this->sortir_catatan->EditAttrs["class"] = "form-control";
            $this->sortir_catatan->EditCustomAttributes = "";
            $this->sortir_catatan->EditValue = HtmlEncode($this->sortir_catatan->CurrentValue);
            $this->sortir_catatan->PlaceHolder = RemoveHtml($this->sortir_catatan->caption());

            // Edit refer script

            // sortir_id
            $this->sortir_id->LinkCustomAttributes = "";
            $this->sortir_id->HrefValue = "";
            $this->sortir_id->TooltipValue = "";

            // sortir_kedatangan
            $this->sortir_kedatangan->LinkCustomAttributes = "";
            $this->sortir_kedatangan->HrefValue = "";

            // sortir_petugas
            $this->sortir_petugas->LinkCustomAttributes = "";
            $this->sortir_petugas->HrefValue = "";

            // sortir_tanggal
            $this->sortir_tanggal->LinkCustomAttributes = "";
            $this->sortir_tanggal->HrefValue = "";

            // sortir_okking
            $this->sortir_okking->LinkCustomAttributes = "";
            $this->sortir_okking->HrefValue = "";

            // sortir_okl
            $this->sortir_okl->LinkCustomAttributes = "";
            $this->sortir_okl->HrefValue = "";

            // sortir_okm
            $this->sortir_okm->LinkCustomAttributes = "";
            $this->sortir_okm->HrefValue = "";

            // sortir_oks
            $this->sortir_oks->LinkCustomAttributes = "";
            $this->sortir_oks->HrefValue = "";

            // sortir_okss
            $this->sortir_okss->LinkCustomAttributes = "";
            $this->sortir_okss->HrefValue = "";

            // sortir_oktotal
            $this->sortir_oktotal->LinkCustomAttributes = "";
            $this->sortir_oktotal->HrefValue = "";
            $this->sortir_oktotal->TooltipValue = "";

            // sortir_rijek_busuk
            $this->sortir_rijek_busuk->LinkCustomAttributes = "";
            $this->sortir_rijek_busuk->HrefValue = "";

            // sortir_rijek_kecil
            $this->sortir_rijek_kecil->LinkCustomAttributes = "";
            $this->sortir_rijek_kecil->HrefValue = "";

            // sortir_rijek_sampah
            $this->sortir_rijek_sampah->LinkCustomAttributes = "";
            $this->sortir_rijek_sampah->HrefValue = "";

            // sortir_catatan
            $this->sortir_catatan->LinkCustomAttributes = "";
            $this->sortir_catatan->HrefValue = "";
        } elseif ($this->RowType == ROWTYPE_SEARCH) {
            // sortir_id
            $this->sortir_id->EditAttrs["class"] = "form-control";
            $this->sortir_id->EditCustomAttributes = "";
            $this->sortir_id->EditValue = HtmlEncode($this->sortir_id->AdvancedSearch->SearchValue);
            $this->sortir_id->PlaceHolder = RemoveHtml($this->sortir_id->caption());

            // sortir_kedatangan
            $this->sortir_kedatangan->EditAttrs["class"] = "form-control";
            $this->sortir_kedatangan->EditCustomAttributes = "";
            $curVal = trim(strval($this->sortir_kedatangan->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->sortir_kedatangan->AdvancedSearch->ViewValue = $this->sortir_kedatangan->lookupCacheOption($curVal);
            } else {
                $this->sortir_kedatangan->AdvancedSearch->ViewValue = $this->sortir_kedatangan->Lookup !== null && is_array($this->sortir_kedatangan->Lookup->Options) ? $curVal : null;
            }
            if ($this->sortir_kedatangan->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->sortir_kedatangan->EditValue = array_values($this->sortir_kedatangan->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`datang_id`" . SearchString("=", $this->sortir_kedatangan->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->sortir_kedatangan->Lookup->getSql(true, $filterWrk, '', $this);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row)
                    $row = $this->sortir_kedatangan->Lookup->renderViewRow($row);
                $this->sortir_kedatangan->EditValue = $arwrk;
            }
            $this->sortir_kedatangan->PlaceHolder = RemoveHtml($this->sortir_kedatangan->caption());

            // sortir_petugas
            $this->sortir_petugas->EditAttrs["class"] = "form-control";
            $this->sortir_petugas->EditCustomAttributes = "";
            if (!$this->sortir_petugas->Raw) {
                $this->sortir_petugas->AdvancedSearch->SearchValue = HtmlDecode($this->sortir_petugas->AdvancedSearch->SearchValue);
            }
            $this->sortir_petugas->EditValue = HtmlEncode($this->sortir_petugas->AdvancedSearch->SearchValue);
            $this->sortir_petugas->PlaceHolder = RemoveHtml($this->sortir_petugas->caption());

            // sortir_tanggal
            $this->sortir_tanggal->EditAttrs["class"] = "form-control";
            $this->sortir_tanggal->EditCustomAttributes = "";
            $this->sortir_tanggal->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->sortir_tanggal->AdvancedSearch->SearchValue, 0), 8));
            $this->sortir_tanggal->PlaceHolder = RemoveHtml($this->sortir_tanggal->caption());
            $this->sortir_tanggal->EditAttrs["class"] = "form-control";
            $this->sortir_tanggal->EditCustomAttributes = "";
            $this->sortir_tanggal->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->sortir_tanggal->AdvancedSearch->SearchValue2, 0), 8));
            $this->sortir_tanggal->PlaceHolder = RemoveHtml($this->sortir_tanggal->caption());

            // sortir_okking
            $this->sortir_okking->EditAttrs["class"] = "form-control";
            $this->sortir_okking->EditCustomAttributes = "";
            $this->sortir_okking->EditValue = HtmlEncode($this->sortir_okking->AdvancedSearch->SearchValue);
            $this->sortir_okking->PlaceHolder = RemoveHtml($this->sortir_okking->caption());

            // sortir_okl
            $this->sortir_okl->EditAttrs["class"] = "form-control";
            $this->sortir_okl->EditCustomAttributes = "";
            $this->sortir_okl->EditValue = HtmlEncode($this->sortir_okl->AdvancedSearch->SearchValue);
            $this->sortir_okl->PlaceHolder = RemoveHtml($this->sortir_okl->caption());

            // sortir_okm
            $this->sortir_okm->EditAttrs["class"] = "form-control";
            $this->sortir_okm->EditCustomAttributes = "";
            $this->sortir_okm->EditValue = HtmlEncode($this->sortir_okm->AdvancedSearch->SearchValue);
            $this->sortir_okm->PlaceHolder = RemoveHtml($this->sortir_okm->caption());

            // sortir_oks
            $this->sortir_oks->EditAttrs["class"] = "form-control";
            $this->sortir_oks->EditCustomAttributes = "";
            $this->sortir_oks->EditValue = HtmlEncode($this->sortir_oks->AdvancedSearch->SearchValue);
            $this->sortir_oks->PlaceHolder = RemoveHtml($this->sortir_oks->caption());

            // sortir_okss
            $this->sortir_okss->EditAttrs["class"] = "form-control";
            $this->sortir_okss->EditCustomAttributes = "";
            $this->sortir_okss->EditValue = HtmlEncode($this->sortir_okss->AdvancedSearch->SearchValue);
            $this->sortir_okss->PlaceHolder = RemoveHtml($this->sortir_okss->caption());

            // sortir_oktotal
            $this->sortir_oktotal->EditAttrs["class"] = "form-control";
            $this->sortir_oktotal->EditCustomAttributes = "";
            $this->sortir_oktotal->EditValue = HtmlEncode($this->sortir_oktotal->AdvancedSearch->SearchValue);
            $this->sortir_oktotal->PlaceHolder = RemoveHtml($this->sortir_oktotal->caption());

            // sortir_rijek_busuk
            $this->sortir_rijek_busuk->EditAttrs["class"] = "form-control";
            $this->sortir_rijek_busuk->EditCustomAttributes = "";
            $this->sortir_rijek_busuk->EditValue = HtmlEncode($this->sortir_rijek_busuk->AdvancedSearch->SearchValue);
            $this->sortir_rijek_busuk->PlaceHolder = RemoveHtml($this->sortir_rijek_busuk->caption());

            // sortir_rijek_kecil
            $this->sortir_rijek_kecil->EditAttrs["class"] = "form-control";
            $this->sortir_rijek_kecil->EditCustomAttributes = "";
            $this->sortir_rijek_kecil->EditValue = HtmlEncode($this->sortir_rijek_kecil->AdvancedSearch->SearchValue);
            $this->sortir_rijek_kecil->PlaceHolder = RemoveHtml($this->sortir_rijek_kecil->caption());

            // sortir_rijek_sampah
            $this->sortir_rijek_sampah->EditAttrs["class"] = "form-control";
            $this->sortir_rijek_sampah->EditCustomAttributes = "";
            $this->sortir_rijek_sampah->EditValue = HtmlEncode($this->sortir_rijek_sampah->AdvancedSearch->SearchValue);
            $this->sortir_rijek_sampah->PlaceHolder = RemoveHtml($this->sortir_rijek_sampah->caption());

            // sortir_catatan
            $this->sortir_catatan->EditAttrs["class"] = "form-control";
            $this->sortir_catatan->EditCustomAttributes = "";
            $this->sortir_catatan->EditValue = HtmlEncode($this->sortir_catatan->AdvancedSearch->SearchValue);
            $this->sortir_catatan->PlaceHolder = RemoveHtml($this->sortir_catatan->caption());
        }
        if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckDate($this->sortir_tanggal->AdvancedSearch->SearchValue)) {
            $this->sortir_tanggal->addErrorMessage($this->sortir_tanggal->getErrorMessage(false));
        }
        if (!CheckDate($this->sortir_tanggal->AdvancedSearch->SearchValue2)) {
            $this->sortir_tanggal->addErrorMessage($this->sortir_tanggal->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Validate form
    protected function validateForm()
    {
        global $Language;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if ($this->sortir_id->Required) {
            if (!$this->sortir_id->IsDetailKey && EmptyValue($this->sortir_id->FormValue)) {
                $this->sortir_id->addErrorMessage(str_replace("%s", $this->sortir_id->caption(), $this->sortir_id->RequiredErrorMessage));
            }
        }
        if ($this->sortir_kedatangan->Required) {
            if (!$this->sortir_kedatangan->IsDetailKey && EmptyValue($this->sortir_kedatangan->FormValue)) {
                $this->sortir_kedatangan->addErrorMessage(str_replace("%s", $this->sortir_kedatangan->caption(), $this->sortir_kedatangan->RequiredErrorMessage));
            }
        }
        if ($this->sortir_petugas->Required) {
            if (!$this->sortir_petugas->IsDetailKey && EmptyValue($this->sortir_petugas->FormValue)) {
                $this->sortir_petugas->addErrorMessage(str_replace("%s", $this->sortir_petugas->caption(), $this->sortir_petugas->RequiredErrorMessage));
            }
        }
        if ($this->sortir_tanggal->Required) {
            if (!$this->sortir_tanggal->IsDetailKey && EmptyValue($this->sortir_tanggal->FormValue)) {
                $this->sortir_tanggal->addErrorMessage(str_replace("%s", $this->sortir_tanggal->caption(), $this->sortir_tanggal->RequiredErrorMessage));
            }
        }
        if (!CheckDate($this->sortir_tanggal->FormValue)) {
            $this->sortir_tanggal->addErrorMessage($this->sortir_tanggal->getErrorMessage(false));
        }
        if ($this->sortir_okking->Required) {
            if (!$this->sortir_okking->IsDetailKey && EmptyValue($this->sortir_okking->FormValue)) {
                $this->sortir_okking->addErrorMessage(str_replace("%s", $this->sortir_okking->caption(), $this->sortir_okking->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->sortir_okking->FormValue)) {
            $this->sortir_okking->addErrorMessage($this->sortir_okking->getErrorMessage(false));
        }
        if ($this->sortir_okl->Required) {
            if (!$this->sortir_okl->IsDetailKey && EmptyValue($this->sortir_okl->FormValue)) {
                $this->sortir_okl->addErrorMessage(str_replace("%s", $this->sortir_okl->caption(), $this->sortir_okl->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->sortir_okl->FormValue)) {
            $this->sortir_okl->addErrorMessage($this->sortir_okl->getErrorMessage(false));
        }
        if ($this->sortir_okm->Required) {
            if (!$this->sortir_okm->IsDetailKey && EmptyValue($this->sortir_okm->FormValue)) {
                $this->sortir_okm->addErrorMessage(str_replace("%s", $this->sortir_okm->caption(), $this->sortir_okm->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->sortir_okm->FormValue)) {
            $this->sortir_okm->addErrorMessage($this->sortir_okm->getErrorMessage(false));
        }
        if ($this->sortir_oks->Required) {
            if (!$this->sortir_oks->IsDetailKey && EmptyValue($this->sortir_oks->FormValue)) {
                $this->sortir_oks->addErrorMessage(str_replace("%s", $this->sortir_oks->caption(), $this->sortir_oks->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->sortir_oks->FormValue)) {
            $this->sortir_oks->addErrorMessage($this->sortir_oks->getErrorMessage(false));
        }
        if ($this->sortir_okss->Required) {
            if (!$this->sortir_okss->IsDetailKey && EmptyValue($this->sortir_okss->FormValue)) {
                $this->sortir_okss->addErrorMessage(str_replace("%s", $this->sortir_okss->caption(), $this->sortir_okss->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->sortir_okss->FormValue)) {
            $this->sortir_okss->addErrorMessage($this->sortir_okss->getErrorMessage(false));
        }
        if ($this->sortir_oktotal->Required) {
            if (!$this->sortir_oktotal->IsDetailKey && EmptyValue($this->sortir_oktotal->FormValue)) {
                $this->sortir_oktotal->addErrorMessage(str_replace("%s", $this->sortir_oktotal->caption(), $this->sortir_oktotal->RequiredErrorMessage));
            }
        }
        if ($this->sortir_rijek_busuk->Required) {
            if (!$this->sortir_rijek_busuk->IsDetailKey && EmptyValue($this->sortir_rijek_busuk->FormValue)) {
                $this->sortir_rijek_busuk->addErrorMessage(str_replace("%s", $this->sortir_rijek_busuk->caption(), $this->sortir_rijek_busuk->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->sortir_rijek_busuk->FormValue)) {
            $this->sortir_rijek_busuk->addErrorMessage($this->sortir_rijek_busuk->getErrorMessage(false));
        }
        if ($this->sortir_rijek_kecil->Required) {
            if (!$this->sortir_rijek_kecil->IsDetailKey && EmptyValue($this->sortir_rijek_kecil->FormValue)) {
                $this->sortir_rijek_kecil->addErrorMessage(str_replace("%s", $this->sortir_rijek_kecil->caption(), $this->sortir_rijek_kecil->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->sortir_rijek_kecil->FormValue)) {
            $this->sortir_rijek_kecil->addErrorMessage($this->sortir_rijek_kecil->getErrorMessage(false));
        }
        if ($this->sortir_rijek_sampah->Required) {
            if (!$this->sortir_rijek_sampah->IsDetailKey && EmptyValue($this->sortir_rijek_sampah->FormValue)) {
                $this->sortir_rijek_sampah->addErrorMessage(str_replace("%s", $this->sortir_rijek_sampah->caption(), $this->sortir_rijek_sampah->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->sortir_rijek_sampah->FormValue)) {
            $this->sortir_rijek_sampah->addErrorMessage($this->sortir_rijek_sampah->getErrorMessage(false));
        }
        if ($this->sortir_catatan->Required) {
            if (!$this->sortir_catatan->IsDetailKey && EmptyValue($this->sortir_catatan->FormValue)) {
                $this->sortir_catatan->addErrorMessage(str_replace("%s", $this->sortir_catatan->caption(), $this->sortir_catatan->RequiredErrorMessage));
            }
        }

        // Return validate result
        $validateForm = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Delete records based on current filter
    protected function deleteRows()
    {
        global $Language, $Security;
        if (!$Security->canDelete()) {
            $this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
            return false;
        }
        $deleteRows = true;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $rows = $conn->fetchAll($sql);
        if (count($rows) == 0) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
            return false;
        }

        // Clone old rows
        $rsold = $rows;

        // Call row deleting event
        if ($deleteRows) {
            foreach ($rsold as $row) {
                $deleteRows = $this->rowDeleting($row);
                if (!$deleteRows) {
                    break;
                }
            }
        }
        if ($deleteRows) {
            $key = "";
            foreach ($rsold as $row) {
                $thisKey = "";
                if ($thisKey != "") {
                    $thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
                }
                $thisKey .= $row['sortir_id'];
                if (Config("DELETE_UPLOADED_FILES")) { // Delete old files
                    $this->deleteUploadedFiles($row);
                }
                $deleteRows = $this->delete($row); // Delete
                if ($deleteRows === false) {
                    break;
                }
                if ($key != "") {
                    $key .= ", ";
                }
                $key .= $thisKey;
            }
        }
        if (!$deleteRows) {
            // Set up error message
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("DeleteCancelled"));
            }
        }

        // Call Row Deleted event
        if ($deleteRows) {
            foreach ($rsold as $row) {
                $this->rowDeleted($row);
            }
        }

        // Write JSON for API request (Support single row only)
        if (IsApi() && $deleteRows) {
            $row = $this->getRecordsFromRecordset($rsold, true);
            WriteJson(["success" => true, $this->TableVar => $row]);
        }
        return $deleteRows;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssoc($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            $editRow = false; // Update Failed
        } else {
            // Save old values
            $this->loadDbValues($rsold);
            $rsnew = [];

            // sortir_kedatangan
            $this->sortir_kedatangan->setDbValueDef($rsnew, $this->sortir_kedatangan->CurrentValue, 0, $this->sortir_kedatangan->ReadOnly);

            // sortir_petugas
            $this->sortir_petugas->CurrentValue = CurrentUserName();
            $this->sortir_petugas->setDbValueDef($rsnew, $this->sortir_petugas->CurrentValue, "");

            // sortir_tanggal
            $this->sortir_tanggal->setDbValueDef($rsnew, UnFormatDateTime($this->sortir_tanggal->CurrentValue, 0), CurrentDate(), $this->sortir_tanggal->ReadOnly);

            // sortir_okking
            $this->sortir_okking->setDbValueDef($rsnew, $this->sortir_okking->CurrentValue, 0, $this->sortir_okking->ReadOnly);

            // sortir_okl
            $this->sortir_okl->setDbValueDef($rsnew, $this->sortir_okl->CurrentValue, 0, $this->sortir_okl->ReadOnly);

            // sortir_okm
            $this->sortir_okm->setDbValueDef($rsnew, $this->sortir_okm->CurrentValue, 0, $this->sortir_okm->ReadOnly);

            // sortir_oks
            $this->sortir_oks->setDbValueDef($rsnew, $this->sortir_oks->CurrentValue, 0, $this->sortir_oks->ReadOnly);

            // sortir_okss
            $this->sortir_okss->setDbValueDef($rsnew, $this->sortir_okss->CurrentValue, 0, $this->sortir_okss->ReadOnly);

            // sortir_rijek_busuk
            $this->sortir_rijek_busuk->setDbValueDef($rsnew, $this->sortir_rijek_busuk->CurrentValue, 0, $this->sortir_rijek_busuk->ReadOnly);

            // sortir_rijek_kecil
            $this->sortir_rijek_kecil->setDbValueDef($rsnew, $this->sortir_rijek_kecil->CurrentValue, 0, $this->sortir_rijek_kecil->ReadOnly);

            // sortir_rijek_sampah
            $this->sortir_rijek_sampah->setDbValueDef($rsnew, $this->sortir_rijek_sampah->CurrentValue, 0, $this->sortir_rijek_sampah->ReadOnly);

            // sortir_catatan
            $this->sortir_catatan->setDbValueDef($rsnew, $this->sortir_catatan->CurrentValue, "", $this->sortir_catatan->ReadOnly);

            // Call Row Updating event
            $updateRow = $this->rowUpdating($rsold, $rsnew);

            // Check for duplicate key when key changed
            if ($updateRow) {
                $newKeyFilter = $this->getRecordFilter($rsnew);
                if ($newKeyFilter != $oldKeyFilter) {
                    $rsChk = $this->loadRs($newKeyFilter)->fetch();
                    if ($rsChk !== false) {
                        $keyErrMsg = str_replace("%f", $newKeyFilter, $Language->phrase("DupKey"));
                        $this->setFailureMessage($keyErrMsg);
                        $updateRow = false;
                    }
                }
            }
            if ($updateRow) {
                if (count($rsnew) > 0) {
                    $editRow = $this->update($rsnew, "", $rsold);
                } else {
                    $editRow = true; // No field to update
                }
                if ($editRow) {
                }
            } else {
                if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                    // Use the message, do nothing
                } elseif ($this->CancelMessage != "") {
                    $this->setFailureMessage($this->CancelMessage);
                    $this->CancelMessage = "";
                } else {
                    $this->setFailureMessage($Language->phrase("UpdateCancelled"));
                }
                $editRow = false;
            }
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Clean upload path if any
        if ($editRow) {
        }

        // Write JSON for API request
        if (IsApi() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            WriteJson(["success" => true, $this->TableVar => $row]);
        }
        return $editRow;
    }

    // Load row hash
    protected function loadRowHash()
    {
        $filter = $this->getRecordFilter();

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $row = $conn->fetchAssoc($sql);
        $this->HashValue = $row ? $this->getRowHash($row) : ""; // Get hash value for record
    }

    // Get Row Hash
    public function getRowHash(&$rs)
    {
        if (!$rs) {
            return "";
        }
        $row = ($rs instanceof Recordset) ? $rs->fields : $rs;
        $hash = "";
        $hash .= GetFieldHash($row['sortir_kedatangan']); // sortir_kedatangan
        $hash .= GetFieldHash($row['sortir_petugas']); // sortir_petugas
        $hash .= GetFieldHash($row['sortir_tanggal']); // sortir_tanggal
        $hash .= GetFieldHash($row['sortir_okking']); // sortir_okking
        $hash .= GetFieldHash($row['sortir_okl']); // sortir_okl
        $hash .= GetFieldHash($row['sortir_okm']); // sortir_okm
        $hash .= GetFieldHash($row['sortir_oks']); // sortir_oks
        $hash .= GetFieldHash($row['sortir_okss']); // sortir_okss
        $hash .= GetFieldHash($row['sortir_rijek_busuk']); // sortir_rijek_busuk
        $hash .= GetFieldHash($row['sortir_rijek_kecil']); // sortir_rijek_kecil
        $hash .= GetFieldHash($row['sortir_rijek_sampah']); // sortir_rijek_sampah
        $hash .= GetFieldHash($row['sortir_catatan']); // sortir_catatan
        return md5($hash);
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;
        $conn = $this->getConnection();

        // Load db values from rsold
        $this->loadDbValues($rsold);
        if ($rsold) {
        }
        $rsnew = [];

        // sortir_kedatangan
        $this->sortir_kedatangan->setDbValueDef($rsnew, $this->sortir_kedatangan->CurrentValue, 0, false);

        // sortir_petugas
        $this->sortir_petugas->CurrentValue = CurrentUserName();
        $this->sortir_petugas->setDbValueDef($rsnew, $this->sortir_petugas->CurrentValue, "");

        // sortir_tanggal
        $this->sortir_tanggal->setDbValueDef($rsnew, UnFormatDateTime($this->sortir_tanggal->CurrentValue, 0), CurrentDate(), false);

        // sortir_okking
        $this->sortir_okking->setDbValueDef($rsnew, $this->sortir_okking->CurrentValue, 0, false);

        // sortir_okl
        $this->sortir_okl->setDbValueDef($rsnew, $this->sortir_okl->CurrentValue, 0, false);

        // sortir_okm
        $this->sortir_okm->setDbValueDef($rsnew, $this->sortir_okm->CurrentValue, 0, false);

        // sortir_oks
        $this->sortir_oks->setDbValueDef($rsnew, $this->sortir_oks->CurrentValue, 0, false);

        // sortir_okss
        $this->sortir_okss->setDbValueDef($rsnew, $this->sortir_okss->CurrentValue, 0, false);

        // sortir_oktotal
        $this->sortir_oktotal->setDbValueDef($rsnew, $this->sortir_oktotal->CurrentValue, 0, false);

        // sortir_rijek_busuk
        $this->sortir_rijek_busuk->setDbValueDef($rsnew, $this->sortir_rijek_busuk->CurrentValue, 0, false);

        // sortir_rijek_kecil
        $this->sortir_rijek_kecil->setDbValueDef($rsnew, $this->sortir_rijek_kecil->CurrentValue, 0, false);

        // sortir_rijek_sampah
        $this->sortir_rijek_sampah->setDbValueDef($rsnew, $this->sortir_rijek_sampah->CurrentValue, 0, false);

        // sortir_catatan
        $this->sortir_catatan->setDbValueDef($rsnew, $this->sortir_catatan->CurrentValue, "", false);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Clean upload path if any
        if ($addRow) {
        }

        // Write JSON for API request
        if (IsApi() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            WriteJson(["success" => true, $this->TableVar => $row]);
        }
        return $addRow;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->sortir_id->AdvancedSearch->load();
        $this->sortir_kedatangan->AdvancedSearch->load();
        $this->sortir_petugas->AdvancedSearch->load();
        $this->sortir_tanggal->AdvancedSearch->load();
        $this->sortir_okking->AdvancedSearch->load();
        $this->sortir_okl->AdvancedSearch->load();
        $this->sortir_okm->AdvancedSearch->load();
        $this->sortir_oks->AdvancedSearch->load();
        $this->sortir_okss->AdvancedSearch->load();
        $this->sortir_oktotal->AdvancedSearch->load();
        $this->sortir_rijek_busuk->AdvancedSearch->load();
        $this->sortir_rijek_kecil->AdvancedSearch->load();
        $this->sortir_rijek_sampah->AdvancedSearch->load();
        $this->sortir_catatan->AdvancedSearch->load();
    }

    // Set up search/sort options
    protected function setupSearchSortOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl();
        $this->SearchOptions = new ListOptions("div");
        $this->SearchOptions->TagClassName = "ew-search-option";

        // Search button
        $item = &$this->SearchOptions->add("searchtoggle");
        $searchToggleClass = ($this->SearchWhere != "") ? " active" : " active";
        $item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" href=\"#\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fsortirlistsrch\" aria-pressed=\"" . ($searchToggleClass == " active" ? "true" : "false") . "\">" . $Language->phrase("SearchLink") . "</a>";
        $item->Visible = true;

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        $item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction) {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("KedatanganList");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
        $Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_sortir_kedatangan":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll(\PDO::FETCH_BOTH);
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row);
                    $ar[strval($row[0])] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        if ($this->isPageRequest()) { // Validate request
            $startRec = Get(Config("TABLE_START_REC"));
            $pageNo = Get(Config("TABLE_PAGE_NO"));
            if ($pageNo !== null) { // Check for "pageno" parameter first
                if (is_numeric($pageNo)) {
                    $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                    if ($this->StartRecord <= 0) {
                        $this->StartRecord = 1;
                    } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                        $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                    }
                    $this->setStartRecordNumber($this->StartRecord);
                }
            } elseif ($startRec !== null) { // Check for "start" parameter
                $this->StartRecord = $startRec;
                $this->setStartRecordNumber($this->StartRecord);
            }
        }
        $this->StartRecord = $this->getStartRecordNumber();

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
            $this->setStartRecordNumber($this->StartRecord);
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in CustomError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->Add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->MoveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered()
    {
        // Example:
        //$this->ListOptions["new"]->Body = "xxx";
    }

    // Row Custom Action event
    public function rowCustomAction($action, $row)
    {
        // Return false to abort
        return true;
    }

    // Page Exporting event
    // $this->ExportDoc = export document object
    public function pageExporting()
    {
        //$this->ExportDoc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $this->ExportDoc = export document object
    public function rowExport($rs)
    {
        //$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $this->ExportDoc = export document object
    public function pageExported()
    {
        //$this->ExportDoc->Text .= "my footer"; // Export footer
        //Log($this->ExportDoc->Text);
    }

    // Page Importing event
    public function pageImporting($reader, &$options)
    {
        //var_dump($reader); // Import data reader
        //var_dump($options); // Show all options for importing
        //return false; // Return false to skip import
        return true;
    }

    // Row Import event
    public function rowImport(&$row, $cnt)
    {
        //Log($cnt); // Import record count
        //var_dump($row); // Import row
        //return false; // Return false to skip import
        return true;
    }

    // Page Imported event
    public function pageImported($reader, $results)
    {
        //var_dump($reader); // Import data reader
        //var_dump($results); // Import results
    }
}
