<?php

namespace PHPMaker2021\gudang_ubi;

use Doctrine\DBAL\ParameterType;

/**
 * Table class for sortir
 */
class Sortir extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $UseSessionForListSql = true;
    public $UseCustomTemplate = false; // Use custom template

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Export
    public $ExportDoc;

    // Fields
    public $sortir_id;
    public $sortir_kedatangan;
    public $sortir_petugas;
    public $sortir_tanggal;
    public $sortir_okking;
    public $sortir_okl;
    public $sortir_okm;
    public $sortir_oks;
    public $sortir_okss;
    public $sortir_oktotal;
    public $sortir_rijek_busuk;
    public $sortir_rijek_kecil;
    public $sortir_rijek_sampah;
    public $sortir_catatan;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        global $Language, $CurrentLanguage;
        parent::__construct();

        // Language object
        $Language = Container("language");
        $this->TableVar = 'sortir';
        $this->TableName = 'sortir';
        $this->TableType = 'TABLE';

        // Update Table
        $this->UpdateTable = "`sortir`";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)
        $this->ExportExcelPageOrientation = ""; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = ""; // Page size (PhpSpreadsheet only)
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this->TableVar);

        // sortir_id
        $this->sortir_id = new DbField('sortir', 'sortir', 'x_sortir_id', 'sortir_id', '`sortir_id`', '`sortir_id`', 3, 11, -1, false, '`sortir_id`', false, false, false, 'FORMATTED TEXT', 'NO');
        $this->sortir_id->IsAutoIncrement = true; // Autoincrement field
        $this->sortir_id->IsPrimaryKey = true; // Primary key field
        $this->sortir_id->Sortable = true; // Allow sort
        $this->sortir_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Fields['sortir_id'] = &$this->sortir_id;

        // sortir_kedatangan
        $this->sortir_kedatangan = new DbField('sortir', 'sortir', 'x_sortir_kedatangan', 'sortir_kedatangan', '`sortir_kedatangan`', '`sortir_kedatangan`', 3, 11, -1, false, '`sortir_kedatangan`', false, false, false, 'FORMATTED TEXT', 'SELECT');
        $this->sortir_kedatangan->Nullable = false; // NOT NULL field
        $this->sortir_kedatangan->Required = true; // Required field
        $this->sortir_kedatangan->Sortable = true; // Allow sort
        $this->sortir_kedatangan->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->sortir_kedatangan->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->sortir_kedatangan->Lookup = new Lookup('sortir_kedatangan', 'kedatangan', false, 'datang_id', ["datang_id","datang_tanggal","datang_jumlah",""], [], [], [], [], [], [], '', '');
        $this->sortir_kedatangan->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Fields['sortir_kedatangan'] = &$this->sortir_kedatangan;

        // sortir_petugas
        $this->sortir_petugas = new DbField('sortir', 'sortir', 'x_sortir_petugas', 'sortir_petugas', '`sortir_petugas`', '`sortir_petugas`', 200, 20, -1, false, '`sortir_petugas`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->sortir_petugas->Nullable = false; // NOT NULL field
        $this->sortir_petugas->Sortable = true; // Allow sort
        $this->Fields['sortir_petugas'] = &$this->sortir_petugas;

        // sortir_tanggal
        $this->sortir_tanggal = new DbField('sortir', 'sortir', 'x_sortir_tanggal', 'sortir_tanggal', '`sortir_tanggal`', CastDateFieldForLike("`sortir_tanggal`", 0, "DB"), 133, 10, 0, false, '`sortir_tanggal`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->sortir_tanggal->Nullable = false; // NOT NULL field
        $this->sortir_tanggal->Required = true; // Required field
        $this->sortir_tanggal->Sortable = true; // Allow sort
        $this->sortir_tanggal->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->Fields['sortir_tanggal'] = &$this->sortir_tanggal;

        // sortir_okking
        $this->sortir_okking = new DbField('sortir', 'sortir', 'x_sortir_okking', 'sortir_okking', '`sortir_okking`', '`sortir_okking`', 131, 10, -1, false, '`sortir_okking`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->sortir_okking->Nullable = false; // NOT NULL field
        $this->sortir_okking->Required = true; // Required field
        $this->sortir_okking->Sortable = true; // Allow sort
        $this->sortir_okking->DefaultDecimalPrecision = 2; // Default decimal precision
        $this->sortir_okking->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Fields['sortir_okking'] = &$this->sortir_okking;

        // sortir_okl
        $this->sortir_okl = new DbField('sortir', 'sortir', 'x_sortir_okl', 'sortir_okl', '`sortir_okl`', '`sortir_okl`', 131, 10, -1, false, '`sortir_okl`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->sortir_okl->Nullable = false; // NOT NULL field
        $this->sortir_okl->Required = true; // Required field
        $this->sortir_okl->Sortable = true; // Allow sort
        $this->sortir_okl->DefaultDecimalPrecision = 2; // Default decimal precision
        $this->sortir_okl->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Fields['sortir_okl'] = &$this->sortir_okl;

        // sortir_okm
        $this->sortir_okm = new DbField('sortir', 'sortir', 'x_sortir_okm', 'sortir_okm', '`sortir_okm`', '`sortir_okm`', 131, 10, -1, false, '`sortir_okm`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->sortir_okm->Nullable = false; // NOT NULL field
        $this->sortir_okm->Required = true; // Required field
        $this->sortir_okm->Sortable = true; // Allow sort
        $this->sortir_okm->DefaultDecimalPrecision = 2; // Default decimal precision
        $this->sortir_okm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Fields['sortir_okm'] = &$this->sortir_okm;

        // sortir_oks
        $this->sortir_oks = new DbField('sortir', 'sortir', 'x_sortir_oks', 'sortir_oks', '`sortir_oks`', '`sortir_oks`', 131, 10, -1, false, '`sortir_oks`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->sortir_oks->Nullable = false; // NOT NULL field
        $this->sortir_oks->Required = true; // Required field
        $this->sortir_oks->Sortable = true; // Allow sort
        $this->sortir_oks->DefaultDecimalPrecision = 2; // Default decimal precision
        $this->sortir_oks->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Fields['sortir_oks'] = &$this->sortir_oks;

        // sortir_okss
        $this->sortir_okss = new DbField('sortir', 'sortir', 'x_sortir_okss', 'sortir_okss', '`sortir_okss`', '`sortir_okss`', 131, 10, -1, false, '`sortir_okss`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->sortir_okss->Nullable = false; // NOT NULL field
        $this->sortir_okss->Required = true; // Required field
        $this->sortir_okss->Sortable = true; // Allow sort
        $this->sortir_okss->DefaultDecimalPrecision = 2; // Default decimal precision
        $this->sortir_okss->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Fields['sortir_okss'] = &$this->sortir_okss;

        // sortir_oktotal
        $this->sortir_oktotal = new DbField('sortir', 'sortir', 'x_sortir_oktotal', 'sortir_oktotal', '`sortir_oktotal`', '`sortir_oktotal`', 131, 10, -1, false, '`sortir_oktotal`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->sortir_oktotal->Nullable = false; // NOT NULL field
        $this->sortir_oktotal->Required = true; // Required field
        $this->sortir_oktotal->Sortable = true; // Allow sort
        $this->sortir_oktotal->DefaultDecimalPrecision = 2; // Default decimal precision
        $this->sortir_oktotal->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Fields['sortir_oktotal'] = &$this->sortir_oktotal;

        // sortir_rijek_busuk
        $this->sortir_rijek_busuk = new DbField('sortir', 'sortir', 'x_sortir_rijek_busuk', 'sortir_rijek_busuk', '`sortir_rijek_busuk`', '`sortir_rijek_busuk`', 131, 10, -1, false, '`sortir_rijek_busuk`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->sortir_rijek_busuk->Nullable = false; // NOT NULL field
        $this->sortir_rijek_busuk->Required = true; // Required field
        $this->sortir_rijek_busuk->Sortable = true; // Allow sort
        $this->sortir_rijek_busuk->DefaultDecimalPrecision = 2; // Default decimal precision
        $this->sortir_rijek_busuk->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Fields['sortir_rijek_busuk'] = &$this->sortir_rijek_busuk;

        // sortir_rijek_kecil
        $this->sortir_rijek_kecil = new DbField('sortir', 'sortir', 'x_sortir_rijek_kecil', 'sortir_rijek_kecil', '`sortir_rijek_kecil`', '`sortir_rijek_kecil`', 131, 10, -1, false, '`sortir_rijek_kecil`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->sortir_rijek_kecil->Nullable = false; // NOT NULL field
        $this->sortir_rijek_kecil->Required = true; // Required field
        $this->sortir_rijek_kecil->Sortable = true; // Allow sort
        $this->sortir_rijek_kecil->DefaultDecimalPrecision = 2; // Default decimal precision
        $this->sortir_rijek_kecil->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Fields['sortir_rijek_kecil'] = &$this->sortir_rijek_kecil;

        // sortir_rijek_sampah
        $this->sortir_rijek_sampah = new DbField('sortir', 'sortir', 'x_sortir_rijek_sampah', 'sortir_rijek_sampah', '`sortir_rijek_sampah`', '`sortir_rijek_sampah`', 131, 10, -1, false, '`sortir_rijek_sampah`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->sortir_rijek_sampah->Nullable = false; // NOT NULL field
        $this->sortir_rijek_sampah->Required = true; // Required field
        $this->sortir_rijek_sampah->Sortable = true; // Allow sort
        $this->sortir_rijek_sampah->DefaultDecimalPrecision = 2; // Default decimal precision
        $this->sortir_rijek_sampah->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Fields['sortir_rijek_sampah'] = &$this->sortir_rijek_sampah;

        // sortir_catatan
        $this->sortir_catatan = new DbField('sortir', 'sortir', 'x_sortir_catatan', 'sortir_catatan', '`sortir_catatan`', '`sortir_catatan`', 201, 65535, -1, false, '`sortir_catatan`', false, false, false, 'FORMATTED TEXT', 'TEXTAREA');
        $this->sortir_catatan->Nullable = false; // NOT NULL field
        $this->sortir_catatan->Required = true; // Required field
        $this->sortir_catatan->Sortable = true; // Allow sort
        $this->Fields['sortir_catatan'] = &$this->sortir_catatan;
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $fld->setSort($curSort);
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        } else {
            $fld->setSort("");
        }
    }

    // Table level SQL
    public function getSqlFrom() // From
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "`sortir`";
    }

    public function sqlFrom() // For backward compatibility
    {
        return $this->getSqlFrom();
    }

    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select("*");
    }

    public function sqlSelect() // For backward compatibility
    {
        return $this->getSqlSelect();
    }

    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    public function getSqlWhere() // Where
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    public function sqlWhere() // For backward compatibility
    {
        return $this->getSqlWhere();
    }

    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    public function getSqlGroupBy() // Group By
    {
        return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
    }

    public function sqlGroupBy() // For backward compatibility
    {
        return $this->getSqlGroupBy();
    }

    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    public function sqlHaving() // For backward compatibility
    {
        return $this->getSqlHaving();
    }

    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    public function getSqlOrderBy() // Order By
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : $this->DefaultSort;
    }

    public function sqlOrderBy() // For backward compatibility
    {
        return $this->getSqlOrderBy();
    }

    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter)
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return (($allow & 1) == 1);
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return (($allow & 4) == 4);
            case "delete":
                return (($allow & 2) == 2);
            case "view":
                return (($allow & 32) == 32);
            case "search":
                return (($allow & 64) == 64);
            default:
                return (($allow & 8) == 8);
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $rs = null;
        if ($sql instanceof \Doctrine\DBAL\Query\QueryBuilder) { // Query builder
            $sql = $sql->resetQueryPart("orderBy")->getSQL();
        }
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            ($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
            preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) &&
            !preg_match('/^\s*select\s+distinct\s+/i', $sql) && !preg_match('/\s+order\s+by\s+/i', $sql)
        ) {
            $sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
        } else {
            $sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $rs = $conn->executeQuery($sqlwrk);
        $cnt = $rs->fetchColumn();
        if ($cnt !== false) {
            return (int)$cnt;
        }

        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        return ExecuteRecordCount($sql, $conn);
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        )->getSQL();
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    protected function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->setValue($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        $success = $this->insertSql($rs)->execute();
        if ($success) {
            // Get insert id if necessary
            $this->sortir_id->setDbValue($conn->lastInsertId());
            $rs['sortir_id'] = $this->sortir_id->DbValue;
        }
        return $success;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    protected function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->set($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        $success = $this->updateSql($rs, $where, $curfilter)->execute();
        $success = ($success > 0) ? $success : true;
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    protected function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('sortir_id', $rs)) {
                AddFilter($where, QuotedName('sortir_id', $this->Dbid) . '=' . QuotedValue($rs['sortir_id'], $this->sortir_id->DataType, $this->Dbid));
            }
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            $success = $this->deleteSql($rs, $where, $curfilter)->execute();
        }
        return $success;
    }

    // Load DbValue from recordset or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->sortir_id->DbValue = $row['sortir_id'];
        $this->sortir_kedatangan->DbValue = $row['sortir_kedatangan'];
        $this->sortir_petugas->DbValue = $row['sortir_petugas'];
        $this->sortir_tanggal->DbValue = $row['sortir_tanggal'];
        $this->sortir_okking->DbValue = $row['sortir_okking'];
        $this->sortir_okl->DbValue = $row['sortir_okl'];
        $this->sortir_okm->DbValue = $row['sortir_okm'];
        $this->sortir_oks->DbValue = $row['sortir_oks'];
        $this->sortir_okss->DbValue = $row['sortir_okss'];
        $this->sortir_oktotal->DbValue = $row['sortir_oktotal'];
        $this->sortir_rijek_busuk->DbValue = $row['sortir_rijek_busuk'];
        $this->sortir_rijek_kecil->DbValue = $row['sortir_rijek_kecil'];
        $this->sortir_rijek_sampah->DbValue = $row['sortir_rijek_sampah'];
        $this->sortir_catatan->DbValue = $row['sortir_catatan'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`sortir_id` = @sortir_id@";
    }

    // Get record filter
    public function getRecordFilter($row = null)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('sortir_id', $row) ? $row['sortir_id'] : null;
        } else {
            $val = $this->sortir_id->OldValue !== null ? $this->sortir_id->OldValue : $this->sortir_id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@sortir_id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if (ReferUrl() != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login") { // Referer not same page or login page
            $_SESSION[$name] = ReferUrl(); // Save to Session
        }
        if (@$_SESSION[$name] != "") {
            return $_SESSION[$name];
        } else {
            return GetUrl("SortirList");
        }
    }

    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        if ($pageName == "SortirView") {
            return $Language->phrase("View");
        } elseif ($pageName == "SortirEdit") {
            return $Language->phrase("Edit");
        } elseif ($pageName == "SortirAdd") {
            return $Language->phrase("Add");
        } else {
            return "";
        }
    }

    // List URL
    public function getListUrl()
    {
        return "SortirList";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("SortirView", $this->getUrlParm($parm));
        } else {
            $url = $this->keyUrl("SortirView", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "SortirAdd?" . $this->getUrlParm($parm);
        } else {
            $url = "SortirAdd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("SortirEdit", $this->getUrlParm($parm));
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("SortirAdd", $this->getUrlParm($parm));
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl()
    {
        return $this->keyUrl("SortirDelete", $this->getUrlParm());
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "sortir_id:" . JsonEncode($this->sortir_id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->sortir_id->CurrentValue !== null) {
            $url .= "/" . rawurlencode($this->sortir_id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderSort($fld)
    {
        $classId = $fld->TableVar . "_" . $fld->Param;
        $scriptId = str_replace("%id%", $classId, "tpc_%id%");
        $scriptStart = $this->UseCustomTemplate ? "<template id=\"" . $scriptId . "\">" : "";
        $scriptEnd = $this->UseCustomTemplate ? "</template>" : "";
        $jsSort = " class=\"ew-pointer\" onclick=\"ew.sort(event, '" . $this->sortUrl($fld) . "', 1);\"";
        if ($this->sortUrl($fld) == "") {
            $html = <<<NOSORTHTML
{$scriptStart}<div class="ew-table-header-caption">{$fld->caption()}</div>{$scriptEnd}
NOSORTHTML;
        } else {
            if ($fld->getSort() == "ASC") {
                $sortIcon = '<i class="fas fa-sort-up"></i>';
            } elseif ($fld->getSort() == "DESC") {
                $sortIcon = '<i class="fas fa-sort-down"></i>';
            } else {
                $sortIcon = '';
            }
            $html = <<<SORTHTML
{$scriptStart}<div{$jsSort}><div class="ew-table-header-btn"><span class="ew-table-header-caption">{$fld->caption()}</span><span class="ew-table-header-sort">{$sortIcon}</span></div></div>{$scriptEnd}
SORTHTML;
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort());
            return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            if (($keyValue = Param("sortir_id") ?? Route("sortir_id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif (IsApi() && (($keyValue = Key(0) ?? Route(2)) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }

            //return $arKeys; // Do not return yet, so the values will also be checked by the following code
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->sortir_id->CurrentValue = $key;
            } else {
                $this->sortir_id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load recordset based on filter
    public function &loadRs($filter)
    {
        $sql = $this->getSql($filter); // Set up filter (WHERE Clause)
        $conn = $this->getConnection();
        $stmt = $conn->executeQuery($sql);
        return $stmt;
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->sortir_id->setDbValue($row['sortir_id']);
        $this->sortir_kedatangan->setDbValue($row['sortir_kedatangan']);
        $this->sortir_petugas->setDbValue($row['sortir_petugas']);
        $this->sortir_tanggal->setDbValue($row['sortir_tanggal']);
        $this->sortir_okking->setDbValue($row['sortir_okking']);
        $this->sortir_okl->setDbValue($row['sortir_okl']);
        $this->sortir_okm->setDbValue($row['sortir_okm']);
        $this->sortir_oks->setDbValue($row['sortir_oks']);
        $this->sortir_okss->setDbValue($row['sortir_okss']);
        $this->sortir_oktotal->setDbValue($row['sortir_oktotal']);
        $this->sortir_rijek_busuk->setDbValue($row['sortir_rijek_busuk']);
        $this->sortir_rijek_kecil->setDbValue($row['sortir_rijek_kecil']);
        $this->sortir_rijek_sampah->setDbValue($row['sortir_rijek_sampah']);
        $this->sortir_catatan->setDbValue($row['sortir_catatan']);
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // sortir_id

        // sortir_kedatangan

        // sortir_petugas

        // sortir_tanggal

        // sortir_okking

        // sortir_okl

        // sortir_okm

        // sortir_oks

        // sortir_okss

        // sortir_oktotal

        // sortir_rijek_busuk

        // sortir_rijek_kecil

        // sortir_rijek_sampah

        // sortir_catatan

        // sortir_id
        $this->sortir_id->ViewValue = $this->sortir_id->CurrentValue;
        $this->sortir_id->ViewValue = FormatNumber($this->sortir_id->ViewValue, 0, -2, -2, -2);
        $this->sortir_id->ViewCustomAttributes = "";

        // sortir_kedatangan
        $curVal = strval($this->sortir_kedatangan->CurrentValue);
        if ($curVal != "") {
            $this->sortir_kedatangan->ViewValue = $this->sortir_kedatangan->lookupCacheOption($curVal);
            if ($this->sortir_kedatangan->ViewValue === null) { // Lookup from database
                $filterWrk = "`datang_id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->sortir_kedatangan->Lookup->getSql(false, $filterWrk, '', $this, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->sortir_kedatangan->Lookup->renderViewRow($rswrk[0]);
                    $this->sortir_kedatangan->ViewValue = $this->sortir_kedatangan->displayValue($arwrk);
                } else {
                    $this->sortir_kedatangan->ViewValue = $this->sortir_kedatangan->CurrentValue;
                }
            }
        } else {
            $this->sortir_kedatangan->ViewValue = null;
        }
        $this->sortir_kedatangan->ViewCustomAttributes = "";

        // sortir_petugas
        $this->sortir_petugas->ViewValue = $this->sortir_petugas->CurrentValue;
        $this->sortir_petugas->ViewCustomAttributes = "";

        // sortir_tanggal
        $this->sortir_tanggal->ViewValue = $this->sortir_tanggal->CurrentValue;
        $this->sortir_tanggal->ViewValue = FormatDateTime($this->sortir_tanggal->ViewValue, 0);
        $this->sortir_tanggal->ViewCustomAttributes = "";

        // sortir_okking
        $this->sortir_okking->ViewValue = $this->sortir_okking->CurrentValue;
        $this->sortir_okking->ViewValue = FormatNumber($this->sortir_okking->ViewValue, 2, -2, -2, -2);
        $this->sortir_okking->ViewCustomAttributes = "";

        // sortir_okl
        $this->sortir_okl->ViewValue = $this->sortir_okl->CurrentValue;
        $this->sortir_okl->ViewValue = FormatNumber($this->sortir_okl->ViewValue, 2, -2, -2, -2);
        $this->sortir_okl->ViewCustomAttributes = "";

        // sortir_okm
        $this->sortir_okm->ViewValue = $this->sortir_okm->CurrentValue;
        $this->sortir_okm->ViewValue = FormatNumber($this->sortir_okm->ViewValue, 2, -2, -2, -2);
        $this->sortir_okm->ViewCustomAttributes = "";

        // sortir_oks
        $this->sortir_oks->ViewValue = $this->sortir_oks->CurrentValue;
        $this->sortir_oks->ViewValue = FormatNumber($this->sortir_oks->ViewValue, 2, -2, -2, -2);
        $this->sortir_oks->ViewCustomAttributes = "";

        // sortir_okss
        $this->sortir_okss->ViewValue = $this->sortir_okss->CurrentValue;
        $this->sortir_okss->ViewValue = FormatNumber($this->sortir_okss->ViewValue, 2, -2, -2, -2);
        $this->sortir_okss->ViewCustomAttributes = "";

        // sortir_oktotal
        $this->sortir_oktotal->ViewValue = $this->sortir_oktotal->CurrentValue;
        $this->sortir_oktotal->ViewValue = FormatNumber($this->sortir_oktotal->ViewValue, 2, -2, -2, -2);
        $this->sortir_oktotal->ViewCustomAttributes = "";

        // sortir_rijek_busuk
        $this->sortir_rijek_busuk->ViewValue = $this->sortir_rijek_busuk->CurrentValue;
        $this->sortir_rijek_busuk->ViewValue = FormatNumber($this->sortir_rijek_busuk->ViewValue, 2, -2, -2, -2);
        $this->sortir_rijek_busuk->ViewCustomAttributes = "";

        // sortir_rijek_kecil
        $this->sortir_rijek_kecil->ViewValue = $this->sortir_rijek_kecil->CurrentValue;
        $this->sortir_rijek_kecil->ViewValue = FormatNumber($this->sortir_rijek_kecil->ViewValue, 2, -2, -2, -2);
        $this->sortir_rijek_kecil->ViewCustomAttributes = "";

        // sortir_rijek_sampah
        $this->sortir_rijek_sampah->ViewValue = $this->sortir_rijek_sampah->CurrentValue;
        $this->sortir_rijek_sampah->ViewValue = FormatNumber($this->sortir_rijek_sampah->ViewValue, 2, -2, -2, -2);
        $this->sortir_rijek_sampah->ViewCustomAttributes = "";

        // sortir_catatan
        $this->sortir_catatan->ViewValue = $this->sortir_catatan->CurrentValue;
        $this->sortir_catatan->ViewCustomAttributes = "";

        // sortir_id
        $this->sortir_id->LinkCustomAttributes = "";
        $this->sortir_id->HrefValue = "";
        $this->sortir_id->TooltipValue = "";

        // sortir_kedatangan
        $this->sortir_kedatangan->LinkCustomAttributes = "";
        $this->sortir_kedatangan->HrefValue = "";
        $this->sortir_kedatangan->TooltipValue = "";

        // sortir_petugas
        $this->sortir_petugas->LinkCustomAttributes = "";
        $this->sortir_petugas->HrefValue = "";
        $this->sortir_petugas->TooltipValue = "";

        // sortir_tanggal
        $this->sortir_tanggal->LinkCustomAttributes = "";
        $this->sortir_tanggal->HrefValue = "";
        $this->sortir_tanggal->TooltipValue = "";

        // sortir_okking
        $this->sortir_okking->LinkCustomAttributes = "";
        $this->sortir_okking->HrefValue = "";
        $this->sortir_okking->TooltipValue = "";

        // sortir_okl
        $this->sortir_okl->LinkCustomAttributes = "";
        $this->sortir_okl->HrefValue = "";
        $this->sortir_okl->TooltipValue = "";

        // sortir_okm
        $this->sortir_okm->LinkCustomAttributes = "";
        $this->sortir_okm->HrefValue = "";
        $this->sortir_okm->TooltipValue = "";

        // sortir_oks
        $this->sortir_oks->LinkCustomAttributes = "";
        $this->sortir_oks->HrefValue = "";
        $this->sortir_oks->TooltipValue = "";

        // sortir_okss
        $this->sortir_okss->LinkCustomAttributes = "";
        $this->sortir_okss->HrefValue = "";
        $this->sortir_okss->TooltipValue = "";

        // sortir_oktotal
        $this->sortir_oktotal->LinkCustomAttributes = "";
        $this->sortir_oktotal->HrefValue = "";
        $this->sortir_oktotal->TooltipValue = "";

        // sortir_rijek_busuk
        $this->sortir_rijek_busuk->LinkCustomAttributes = "";
        $this->sortir_rijek_busuk->HrefValue = "";
        $this->sortir_rijek_busuk->TooltipValue = "";

        // sortir_rijek_kecil
        $this->sortir_rijek_kecil->LinkCustomAttributes = "";
        $this->sortir_rijek_kecil->HrefValue = "";
        $this->sortir_rijek_kecil->TooltipValue = "";

        // sortir_rijek_sampah
        $this->sortir_rijek_sampah->LinkCustomAttributes = "";
        $this->sortir_rijek_sampah->HrefValue = "";
        $this->sortir_rijek_sampah->TooltipValue = "";

        // sortir_catatan
        $this->sortir_catatan->LinkCustomAttributes = "";
        $this->sortir_catatan->HrefValue = "";
        $this->sortir_catatan->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // sortir_id
        $this->sortir_id->EditAttrs["class"] = "form-control";
        $this->sortir_id->EditCustomAttributes = "";
        $this->sortir_id->EditValue = $this->sortir_id->CurrentValue;
        $this->sortir_id->EditValue = FormatNumber($this->sortir_id->EditValue, 0, -2, -2, -2);
        $this->sortir_id->ViewCustomAttributes = "";

        // sortir_kedatangan
        $this->sortir_kedatangan->EditAttrs["class"] = "form-control";
        $this->sortir_kedatangan->EditCustomAttributes = "";
        $this->sortir_kedatangan->PlaceHolder = RemoveHtml($this->sortir_kedatangan->caption());

        // sortir_petugas

        // sortir_tanggal
        $this->sortir_tanggal->EditAttrs["class"] = "form-control";
        $this->sortir_tanggal->EditCustomAttributes = "";
        $this->sortir_tanggal->EditValue = FormatDateTime($this->sortir_tanggal->CurrentValue, 8);
        $this->sortir_tanggal->PlaceHolder = RemoveHtml($this->sortir_tanggal->caption());

        // sortir_okking
        $this->sortir_okking->EditAttrs["class"] = "form-control";
        $this->sortir_okking->EditCustomAttributes = "";
        $this->sortir_okking->EditValue = $this->sortir_okking->CurrentValue;
        $this->sortir_okking->PlaceHolder = RemoveHtml($this->sortir_okking->caption());
        if (strval($this->sortir_okking->EditValue) != "" && is_numeric($this->sortir_okking->EditValue)) {
            $this->sortir_okking->EditValue = FormatNumber($this->sortir_okking->EditValue, -2, -2, -2, -2);
        }

        // sortir_okl
        $this->sortir_okl->EditAttrs["class"] = "form-control";
        $this->sortir_okl->EditCustomAttributes = "";
        $this->sortir_okl->EditValue = $this->sortir_okl->CurrentValue;
        $this->sortir_okl->PlaceHolder = RemoveHtml($this->sortir_okl->caption());
        if (strval($this->sortir_okl->EditValue) != "" && is_numeric($this->sortir_okl->EditValue)) {
            $this->sortir_okl->EditValue = FormatNumber($this->sortir_okl->EditValue, -2, -2, -2, -2);
        }

        // sortir_okm
        $this->sortir_okm->EditAttrs["class"] = "form-control";
        $this->sortir_okm->EditCustomAttributes = "";
        $this->sortir_okm->EditValue = $this->sortir_okm->CurrentValue;
        $this->sortir_okm->PlaceHolder = RemoveHtml($this->sortir_okm->caption());
        if (strval($this->sortir_okm->EditValue) != "" && is_numeric($this->sortir_okm->EditValue)) {
            $this->sortir_okm->EditValue = FormatNumber($this->sortir_okm->EditValue, -2, -2, -2, -2);
        }

        // sortir_oks
        $this->sortir_oks->EditAttrs["class"] = "form-control";
        $this->sortir_oks->EditCustomAttributes = "";
        $this->sortir_oks->EditValue = $this->sortir_oks->CurrentValue;
        $this->sortir_oks->PlaceHolder = RemoveHtml($this->sortir_oks->caption());
        if (strval($this->sortir_oks->EditValue) != "" && is_numeric($this->sortir_oks->EditValue)) {
            $this->sortir_oks->EditValue = FormatNumber($this->sortir_oks->EditValue, -2, -2, -2, -2);
        }

        // sortir_okss
        $this->sortir_okss->EditAttrs["class"] = "form-control";
        $this->sortir_okss->EditCustomAttributes = "";
        $this->sortir_okss->EditValue = $this->sortir_okss->CurrentValue;
        $this->sortir_okss->PlaceHolder = RemoveHtml($this->sortir_okss->caption());
        if (strval($this->sortir_okss->EditValue) != "" && is_numeric($this->sortir_okss->EditValue)) {
            $this->sortir_okss->EditValue = FormatNumber($this->sortir_okss->EditValue, -2, -2, -2, -2);
        }

        // sortir_oktotal
        $this->sortir_oktotal->EditAttrs["class"] = "form-control";
        $this->sortir_oktotal->EditCustomAttributes = "";
        $this->sortir_oktotal->EditValue = $this->sortir_oktotal->CurrentValue;
        $this->sortir_oktotal->EditValue = FormatNumber($this->sortir_oktotal->EditValue, 2, -2, -2, -2);
        $this->sortir_oktotal->ViewCustomAttributes = "";

        // sortir_rijek_busuk
        $this->sortir_rijek_busuk->EditAttrs["class"] = "form-control";
        $this->sortir_rijek_busuk->EditCustomAttributes = "";
        $this->sortir_rijek_busuk->EditValue = $this->sortir_rijek_busuk->CurrentValue;
        $this->sortir_rijek_busuk->PlaceHolder = RemoveHtml($this->sortir_rijek_busuk->caption());
        if (strval($this->sortir_rijek_busuk->EditValue) != "" && is_numeric($this->sortir_rijek_busuk->EditValue)) {
            $this->sortir_rijek_busuk->EditValue = FormatNumber($this->sortir_rijek_busuk->EditValue, -2, -2, -2, -2);
        }

        // sortir_rijek_kecil
        $this->sortir_rijek_kecil->EditAttrs["class"] = "form-control";
        $this->sortir_rijek_kecil->EditCustomAttributes = "";
        $this->sortir_rijek_kecil->EditValue = $this->sortir_rijek_kecil->CurrentValue;
        $this->sortir_rijek_kecil->PlaceHolder = RemoveHtml($this->sortir_rijek_kecil->caption());
        if (strval($this->sortir_rijek_kecil->EditValue) != "" && is_numeric($this->sortir_rijek_kecil->EditValue)) {
            $this->sortir_rijek_kecil->EditValue = FormatNumber($this->sortir_rijek_kecil->EditValue, -2, -2, -2, -2);
        }

        // sortir_rijek_sampah
        $this->sortir_rijek_sampah->EditAttrs["class"] = "form-control";
        $this->sortir_rijek_sampah->EditCustomAttributes = "";
        $this->sortir_rijek_sampah->EditValue = $this->sortir_rijek_sampah->CurrentValue;
        $this->sortir_rijek_sampah->PlaceHolder = RemoveHtml($this->sortir_rijek_sampah->caption());
        if (strval($this->sortir_rijek_sampah->EditValue) != "" && is_numeric($this->sortir_rijek_sampah->EditValue)) {
            $this->sortir_rijek_sampah->EditValue = FormatNumber($this->sortir_rijek_sampah->EditValue, -2, -2, -2, -2);
        }

        // sortir_catatan
        $this->sortir_catatan->EditAttrs["class"] = "form-control";
        $this->sortir_catatan->EditCustomAttributes = "";
        $this->sortir_catatan->EditValue = $this->sortir_catatan->CurrentValue;
        $this->sortir_catatan->PlaceHolder = RemoveHtml($this->sortir_catatan->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$recordset || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->sortir_id);
                    $doc->exportCaption($this->sortir_kedatangan);
                    $doc->exportCaption($this->sortir_petugas);
                    $doc->exportCaption($this->sortir_tanggal);
                    $doc->exportCaption($this->sortir_okking);
                    $doc->exportCaption($this->sortir_okl);
                    $doc->exportCaption($this->sortir_okm);
                    $doc->exportCaption($this->sortir_oks);
                    $doc->exportCaption($this->sortir_okss);
                    $doc->exportCaption($this->sortir_oktotal);
                    $doc->exportCaption($this->sortir_rijek_busuk);
                    $doc->exportCaption($this->sortir_rijek_kecil);
                    $doc->exportCaption($this->sortir_rijek_sampah);
                    $doc->exportCaption($this->sortir_catatan);
                } else {
                    $doc->exportCaption($this->sortir_id);
                    $doc->exportCaption($this->sortir_kedatangan);
                    $doc->exportCaption($this->sortir_petugas);
                    $doc->exportCaption($this->sortir_tanggal);
                    $doc->exportCaption($this->sortir_okking);
                    $doc->exportCaption($this->sortir_okl);
                    $doc->exportCaption($this->sortir_okm);
                    $doc->exportCaption($this->sortir_oks);
                    $doc->exportCaption($this->sortir_okss);
                    $doc->exportCaption($this->sortir_oktotal);
                    $doc->exportCaption($this->sortir_rijek_busuk);
                    $doc->exportCaption($this->sortir_rijek_kecil);
                    $doc->exportCaption($this->sortir_rijek_sampah);
                    $doc->exportCaption($this->sortir_catatan);
                }
                $doc->endExportRow();
            }
        }

        // Move to first record
        $recCnt = $startRec - 1;
        $stopRec = ($stopRec > 0) ? $stopRec : PHP_INT_MAX;
        while (!$recordset->EOF && $recCnt < $stopRec) {
            $row = $recordset->fields;
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = ROWTYPE_VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->sortir_id);
                        $doc->exportField($this->sortir_kedatangan);
                        $doc->exportField($this->sortir_petugas);
                        $doc->exportField($this->sortir_tanggal);
                        $doc->exportField($this->sortir_okking);
                        $doc->exportField($this->sortir_okl);
                        $doc->exportField($this->sortir_okm);
                        $doc->exportField($this->sortir_oks);
                        $doc->exportField($this->sortir_okss);
                        $doc->exportField($this->sortir_oktotal);
                        $doc->exportField($this->sortir_rijek_busuk);
                        $doc->exportField($this->sortir_rijek_kecil);
                        $doc->exportField($this->sortir_rijek_sampah);
                        $doc->exportField($this->sortir_catatan);
                    } else {
                        $doc->exportField($this->sortir_id);
                        $doc->exportField($this->sortir_kedatangan);
                        $doc->exportField($this->sortir_petugas);
                        $doc->exportField($this->sortir_tanggal);
                        $doc->exportField($this->sortir_okking);
                        $doc->exportField($this->sortir_okl);
                        $doc->exportField($this->sortir_okm);
                        $doc->exportField($this->sortir_oks);
                        $doc->exportField($this->sortir_okss);
                        $doc->exportField($this->sortir_oktotal);
                        $doc->exportField($this->sortir_rijek_busuk);
                        $doc->exportField($this->sortir_rijek_kecil);
                        $doc->exportField($this->sortir_rijek_sampah);
                        $doc->exportField($this->sortir_catatan);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($row);
            }
            $recordset->moveNext();
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        // No binary fields
        return false;
    }

    // Table level events

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected(&$rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, &$rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, &$rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted(&$rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, &$args)
    {
        //var_dump($email); var_dump($args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
