<?php

namespace PHPMaker2021\gudang_ubi;

use Doctrine\DBAL\ParameterType;

/**
 * Page class
 */
class KedatanganList extends Kedatangan
{
    // Page ID
    public $PageID = "list";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Table name
    public $TableName = 'kedatangan';

    // Page object name
    public $PageObjName = "KedatanganList";

    // Rendering View
    public $RenderingView = false;

    // Custom template
    public $UseCustomTemplate = false;

    // Grid form hidden field names
    public $FormName = "fkedatanganlist";
    public $FormActionName = "k_action";
    public $FormKeyName = "k_key";
    public $FormOldKeyName = "k_oldkey";
    public $FormBlankRowName = "k_blankrow";
    public $FormKeyCountName = "key_count";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $CopyUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $ListUrl;

    // Export URLs
    public $ExportPrintUrl;
    public $ExportHtmlUrl;
    public $ExportExcelUrl;
    public $ExportWordUrl;
    public $ExportXmlUrl;
    public $ExportCsvUrl;
    public $ExportPdfUrl;

    // Custom export
    public $ExportExcelCustom = false;
    public $ExportWordCustom = false;
    public $ExportPdfCustom = false;
    public $ExportEmailCustom = false;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl()
    {
        $url = ScriptName() . "?";
        if ($this->UseTokenInUrl) {
            $url .= "t=" . $this->TableVar . "&"; // Add page token
        }
        return $url;
    }

    // Messages
    private $message = "";
    private $failureMessage = "";
    private $successMessage = "";
    private $warningMessage = "";

    // Get message
    public function getMessage()
    {
        return $_SESSION[SESSION_MESSAGE] ?? $this->message;
    }

    // Set message
    public function setMessage($v)
    {
        AddMessage($this->message, $v);
        $_SESSION[SESSION_MESSAGE] = $this->message;
    }

    // Get failure message
    public function getFailureMessage()
    {
        return $_SESSION[SESSION_FAILURE_MESSAGE] ?? $this->failureMessage;
    }

    // Set failure message
    public function setFailureMessage($v)
    {
        AddMessage($this->failureMessage, $v);
        $_SESSION[SESSION_FAILURE_MESSAGE] = $this->failureMessage;
    }

    // Get success message
    public function getSuccessMessage()
    {
        return $_SESSION[SESSION_SUCCESS_MESSAGE] ?? $this->successMessage;
    }

    // Set success message
    public function setSuccessMessage($v)
    {
        AddMessage($this->successMessage, $v);
        $_SESSION[SESSION_SUCCESS_MESSAGE] = $this->successMessage;
    }

    // Get warning message
    public function getWarningMessage()
    {
        return $_SESSION[SESSION_WARNING_MESSAGE] ?? $this->warningMessage;
    }

    // Set warning message
    public function setWarningMessage($v)
    {
        AddMessage($this->warningMessage, $v);
        $_SESSION[SESSION_WARNING_MESSAGE] = $this->warningMessage;
    }

    // Clear message
    public function clearMessage()
    {
        $this->message = "";
        $_SESSION[SESSION_MESSAGE] = "";
    }

    // Clear failure message
    public function clearFailureMessage()
    {
        $this->failureMessage = "";
        $_SESSION[SESSION_FAILURE_MESSAGE] = "";
    }

    // Clear success message
    public function clearSuccessMessage()
    {
        $this->successMessage = "";
        $_SESSION[SESSION_SUCCESS_MESSAGE] = "";
    }

    // Clear warning message
    public function clearWarningMessage()
    {
        $this->warningMessage = "";
        $_SESSION[SESSION_WARNING_MESSAGE] = "";
    }

    // Clear messages
    public function clearMessages()
    {
        $this->clearMessage();
        $this->clearFailureMessage();
        $this->clearSuccessMessage();
        $this->clearWarningMessage();
    }

    // Show message
    public function showMessage()
    {
        $hidden = true;
        $html = "";
        // Message
        $message = $this->getMessage();
        if (method_exists($this, "messageShowing")) {
            $this->messageShowing($message, "");
        }
        if ($message != "") { // Message in Session, display
            if (!$hidden) {
                $message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
            }
            $html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
            $_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
        }
        // Warning message
        $warningMessage = $this->getWarningMessage();
        if (method_exists($this, "messageShowing")) {
            $this->messageShowing($warningMessage, "warning");
        }
        if ($warningMessage != "") { // Message in Session, display
            if (!$hidden) {
                $warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
            }
            $html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
            $_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
        }
        // Success message
        $successMessage = $this->getSuccessMessage();
        if (method_exists($this, "messageShowing")) {
            $this->messageShowing($successMessage, "success");
        }
        if ($successMessage != "") { // Message in Session, display
            if (!$hidden) {
                $successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
            }
            $html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
            $_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
        }
        // Failure message
        $errorMessage = $this->getFailureMessage();
        if (method_exists($this, "messageShowing")) {
            $this->messageShowing($errorMessage, "failure");
        }
        if ($errorMessage != "") { // Message in Session, display
            if (!$hidden) {
                $errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
            }
            $html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
            $_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
        }
        echo '<div class="ew-message-dialog' . ($hidden ? ' d-none' : '') . '">' . $html . '</div>';
    }

    // Get message as array
    public function getMessages()
    {
        $ar = [];
        // Message
        $message = $this->getMessage();
        if ($message != "") { // Message in Session, display
            $ar["message"] = $message;
            $_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
        }
        // Warning message
        $warningMessage = $this->getWarningMessage();
        if ($warningMessage != "") { // Message in Session, display
            $ar["warningMessage"] = $warningMessage;
            $_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
        }
        // Success message
        $successMessage = $this->getSuccessMessage();
        if ($successMessage != "") { // Message in Session, display
            $ar["successMessage"] = $successMessage;
            $_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
        }
        // Failure message
        $failureMessage = $this->getFailureMessage();
        if ($failureMessage != "") { // Message in Session, display
            $ar["failureMessage"] = $failureMessage;
            $_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
        }
        return $ar;
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Validate page request
    protected function isPageRequest()
    {
        global $CurrentForm;
        if ($this->UseTokenInUrl) {
            if ($CurrentForm) {
                return ($this->TableVar == $CurrentForm->getValue("t"));
            }
            if (Get("t") !== null) {
                return ($this->TableVar == Get("t"));
            }
        }
        return true;
    }

    // Constructor
    public function __construct()
    {
        global $Language, $DashboardReport, $DebugTimer;
        global $UserTable;

        // Initialize
        $GLOBALS["Page"] = &$this;
        $this->TokenTimeout = SessionTimeoutTime();

        // Language object
        $Language = Container("language");

        // Parent constuctor
        parent::__construct();

        // Table object (kedatangan)
        if (!isset($GLOBALS["kedatangan"]) || get_class($GLOBALS["kedatangan"]) == PROJECT_NAMESPACE . "kedatangan") {
            $GLOBALS["kedatangan"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl();

        // Initialize URLs
        $this->ExportPrintUrl = $pageUrl . "export=print";
        $this->ExportExcelUrl = $pageUrl . "export=excel";
        $this->ExportWordUrl = $pageUrl . "export=word";
        $this->ExportPdfUrl = $pageUrl . "export=pdf";
        $this->ExportHtmlUrl = $pageUrl . "export=html";
        $this->ExportXmlUrl = $pageUrl . "export=xml";
        $this->ExportCsvUrl = $pageUrl . "export=csv";
        $this->AddUrl = "KedatanganAdd";
        $this->InlineAddUrl = $pageUrl . "action=add";
        $this->GridAddUrl = $pageUrl . "action=gridadd";
        $this->GridEditUrl = $pageUrl . "action=gridedit";
        $this->MultiDeleteUrl = "KedatanganDelete";
        $this->MultiUpdateUrl = "KedatanganUpdate";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'kedatangan');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] = $GLOBALS["Conn"] ?? $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions();
        $this->ListOptions->TableVar = $this->TableVar;

        // Export options
        $this->ExportOptions = new ListOptions("div");
        $this->ExportOptions->TagClassName = "ew-export-option";

        // Import options
        $this->ImportOptions = new ListOptions("div");
        $this->ImportOptions->TagClassName = "ew-import-option";

        // Other options
        if (!$this->OtherOptions) {
            $this->OtherOptions = new ListOptionsArray();
        }
        $this->OtherOptions["addedit"] = new ListOptions("div");
        $this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
        $this->OtherOptions["detail"] = new ListOptions("div");
        $this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
        $this->OtherOptions["action"] = new ListOptions("div");
        $this->OtherOptions["action"]->TagClassName = "ew-action-option";

        // Filter options
        $this->FilterOptions = new ListOptions("div");
        $this->FilterOptions->TagClassName = "ew-filter-option fkedatanganlistsrch";

        // List actions
        $this->ListActions = new ListActions();
    }

    // Get content from stream
    public function getContents($stream = null): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $ExportFileName, $TempImages, $DashboardReport;

        // Page is terminated
        $this->terminated = true;

         // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();

        // Export
        if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
            $content = $this->getContents();
            if ($ExportFileName == "") {
                $ExportFileName = $this->TableVar;
            }
            $class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
            if (class_exists($class)) {
                $doc = new $class(Container("kedatangan"));
                $doc->Text = @$content;
                if ($this->isExport("email")) {
                    echo $this->exportEmail($doc->Text);
                } else {
                    $doc->export();
                }
                DeleteTempImages(); // Delete temp images
                return;
            }
        }
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show error
                WriteJson(array_merge(["success" => false], $this->getMessages()));
            }
            return;
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        if ($fld->DataType == DATATYPE_MEMO && $fld->MemoMaxLength > 0) {
                            $val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
                        }
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['datang_id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->datang_id->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->datang_petugas->Visible = false;
        }
    }

    // Lookup data
    public function lookup()
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = Post("field");
        if (!array_key_exists($fieldName, $this->Fields)) {
            return false;
        }
        $lookupField = $this->Fields[$fieldName];
        $lookup = $lookupField->Lookup;
        if ($lookup === null) {
            return false;
        }
        $tbl = $lookup->getTable();
        if (!$Security->allowLookup(PROJECT_ID . $tbl->TableName)) { // Lookup permission
            return false;
        }

        // Get lookup parameters
        $lookupType = Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal")) {
            $searchValue = Post("sv", "");
            $pageSize = Post("recperpage", 10);
            $offset = Post("start", 0);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = Param("q", "");
            $pageSize = Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
            $start = Param("start", -1);
            $start = is_numeric($start) ? (int)$start : -1;
            $page = Param("page", -1);
            $page = is_numeric($page) ? (int)$page : -1;
            $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        }
        $userSelect = Decrypt(Post("s", ""));
        $userFilter = Decrypt(Post("f", ""));
        $userOrderBy = Decrypt(Post("o", ""));
        $keys = Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        $lookup->toJson($this); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $DisplayRecords = 50;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = "10,20,50,-1"; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse show"; // Search Panel class
    public $SearchRowCount = 0; // For extended search
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 1; // For extended search
    public $RecordCount = 0; // Record count
    public $EditRowCount;
    public $StartRowCount = 1;
    public $RowCount = 0;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $RowAction = ""; // Row action
    public $RowOldKey = ""; // Row old key (for copy)
    public $MultiColumnClass = "col-sm";
    public $MultiColumnEditClass = "w-100";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $RestoreSearch = false;
    public $DetailPages;
    public $OldRecordset;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm;

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();
        $this->datang_id->setVisibility();
        $this->datang_petugas->setVisibility();
        $this->datang_tanggal->setVisibility();
        $this->datang_varietas->setVisibility();
        $this->datang_sup->setVisibility();
        $this->datang_timbang1->setVisibility();
        $this->datang_timbang2->setVisibility();
        $this->datang_timbang3->setVisibility();
        $this->datang_timbang4->setVisibility();
        $this->datang_timbang5->setVisibility();
        $this->datang_timbang6->setVisibility();
        $this->datang_timbang7->setVisibility();
        $this->datang_timbang8->setVisibility();
        $this->datang_timbang9->setVisibility();
        $this->datang_timbang10->setVisibility();
        $this->datang_timbang11->setVisibility();
        $this->datang_timbang12->setVisibility();
        $this->datang_timbang13->setVisibility();
        $this->datang_timbang14->setVisibility();
        $this->datang_timbang15->setVisibility();
        $this->datang_timbang16->setVisibility();
        $this->datang_timbang17->setVisibility();
        $this->datang_timbang18->setVisibility();
        $this->datang_timbang19->setVisibility();
        $this->datang_timbang20->setVisibility();
        $this->datang_timbang21->setVisibility();
        $this->datang_timbang22->setVisibility();
        $this->datang_timbang23->setVisibility();
        $this->datang_timbang24->setVisibility();
        $this->datang_timbang25->setVisibility();
        $this->datang_jumlah->setVisibility();
        $this->datang_jumlah_karung->setVisibility();
        $this->datang_berat_bersih->setVisibility();
        $this->datang_catatan->setVisibility();
        $this->hideFieldsForAddEdit();

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up custom action (compatible with old version)
        foreach ($this->CustomActions as $name => $action) {
            $this->ListActions->add($name, $action);
        }

        // Show checkbox column if multiple action
        foreach ($this->ListActions->Items as $listaction) {
            if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
                $this->ListOptions["checkbox"]->Visible = true;
                break;
            }
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->datang_varietas);
        $this->setupLookupOptions($this->datang_sup);

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $filter = "";

        // Get command
        $this->Command = strtolower(Get("cmd"));
        if ($this->isPageRequest()) {
            // Process list action first
            if ($this->processListAction()) { // Ajax request
                $this->terminate();
                return;
            }

            // Set up records per page
            $this->setupDisplayRecords();

            // Handle reset command
            $this->resetCmd();

            // Set up Breadcrumb
            if (!$this->isExport()) {
                $this->setupBreadcrumb();
            }

            // Check QueryString parameters
            if (Get("action") !== null) {
                $this->CurrentAction = Get("action");

                // Clear inline mode
                if ($this->isCancel()) {
                    $this->clearInlineMode();
                }

                // Switch to grid add mode
                if ($this->isGridAdd()) {
                    $this->gridAddMode();
                }
            } else {
                if (Post("action") !== null) {
                    $this->CurrentAction = Post("action"); // Get action

                    // Grid Insert
                    if ($this->isGridInsert() && @$_SESSION[SESSION_INLINE_MODE] == "gridadd") {
                        if ($this->validateGridForm()) {
                            $gridInsert = $this->gridInsert();
                        } else {
                            $gridInsert = false;
                        }
                        if ($gridInsert) {
                        } else {
                            $this->EventCancelled = true;
                            $this->gridAddMode(); // Stay in Grid add mode
                        }
                    }
                }
            }

            // Hide list options
            if ($this->isExport()) {
                $this->ListOptions->hideAllOptions(["sequence"]);
                $this->ListOptions->UseDropDownButton = false; // Disable drop down button
                $this->ListOptions->UseButtonGroup = false; // Disable button group
            } elseif ($this->isGridAdd() || $this->isGridEdit()) {
                $this->ListOptions->hideAllOptions();
                $this->ListOptions->UseDropDownButton = false; // Disable drop down button
                $this->ListOptions->UseButtonGroup = false; // Disable button group
            }

            // Hide options
            if ($this->isExport() || $this->CurrentAction) {
                $this->ExportOptions->hideAllOptions();
                $this->FilterOptions->hideAllOptions();
                $this->ImportOptions->hideAllOptions();
            }

            // Hide other options
            if ($this->isExport()) {
                $this->OtherOptions->hideAllOptions();
            }

            // Show grid delete link for grid add / grid edit
            if ($this->AllowAddDeleteRow) {
                if ($this->isGridAdd() || $this->isGridEdit()) {
                    $item = $this->ListOptions["griddelete"];
                    if ($item) {
                        $item->Visible = true;
                    }
                }
            }

            // Get default search criteria
            AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(true));
            AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(true));

            // Get basic search values
            $this->loadBasicSearchValues();

            // Get and validate search values for advanced search
            $this->loadSearchValues(); // Get search values

            // Process filter list
            if ($this->processFilterList()) {
                $this->terminate();
                return;
            }
            if (!$this->validateSearch()) {
                // Nothing to do
            }

            // Restore search parms from Session if not searching / reset / export
            if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms()) {
                $this->restoreSearchParms();
            }

            // Call Recordset SearchValidated event
            $this->recordsetSearchValidated();

            // Set up sorting order
            $this->setupSortOrder();

            // Get basic search criteria
            if (!$this->hasInvalidFields()) {
                $srchBasic = $this->basicSearchWhere();
            }

            // Get search criteria for advanced search
            if (!$this->hasInvalidFields()) {
                $srchAdvanced = $this->advancedSearchWhere();
            }
        }

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 50; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Load Sorting Order
        if ($this->Command != "json") {
            $this->loadSortOrder();
        }

        // Load search default if no existing search criteria
        if (!$this->checkSearchParms()) {
            // Load basic search from default
            $this->BasicSearch->loadDefault();
            if ($this->BasicSearch->Keyword != "") {
                $srchBasic = $this->basicSearchWhere();
            }

            // Load advanced search from default
            if ($this->loadAdvancedSearchDefault()) {
                $srchAdvanced = $this->advancedSearchWhere();
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Build search criteria
        AddFilter($this->SearchWhere, $srchAdvanced);
        AddFilter($this->SearchWhere, $srchBasic);

        // Call Recordset_Searching event
        $this->recordsetSearching($this->SearchWhere);

        // Save search criteria
        if ($this->Command == "search" && !$this->RestoreSearch) {
            $this->setSearchWhere($this->SearchWhere); // Save to Session
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->Command != "json") {
            $this->SearchWhere = $this->getSearchWhere();
        }

        // Build filter
        $filter = "";
        if (!$Security->canList()) {
            $filter = "(0=1)"; // Filter all records
        }
        AddFilter($filter, $this->DbDetailFilter);
        AddFilter($filter, $this->SearchWhere);

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $filter;
        } else {
            $this->setSessionWhere($filter);
            $this->CurrentFilter = "";
        }
        if ($this->isGridAdd()) {
            $this->CurrentFilter = "0=1";
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->GridAddRowCount;
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) { // Display all records
                $this->DisplayRecords = $this->TotalRecords;
            }
            if (!($this->isExport() && $this->ExportAll)) { // Set up start record position
                $this->setupStartRecord();
            }
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

            // Set no record found message
            if (!$this->CurrentAction && $this->TotalRecords == 0) {
                if (!$Security->canList()) {
                    $this->setWarningMessage(DeniedMessage());
                }
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            }
        }

        // Search/sort options
        $this->setupSearchSortOptions();

        // Set up search panel class
        if ($this->SearchWhere != "") {
            AppendClass($this->SearchPanelClass, "show");
        }

        // Normal return
        if (IsApi()) {
            $rows = $this->getRecordsFromRecordset($this->Recordset);
            $this->Recordset->close();
            WriteJson(["success" => true, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecords]);
            $this->terminate(true);
            return;
        }

        // Set up pager
        $this->Pager = new PrevNextPager($this->StartRecord, $this->getRecordsPerPage(), $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Pass table and field properties to client side
            $this->toClientVar(["tableCaption"], ["caption", "Required", "IsInvalid", "Raw"]);

            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Rendering event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }
        }
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 50; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Exit inline mode
    protected function clearInlineMode()
    {
        $this->datang_timbang1->FormValue = ""; // Clear form value
        $this->datang_timbang2->FormValue = ""; // Clear form value
        $this->datang_timbang3->FormValue = ""; // Clear form value
        $this->datang_timbang4->FormValue = ""; // Clear form value
        $this->datang_timbang5->FormValue = ""; // Clear form value
        $this->datang_timbang6->FormValue = ""; // Clear form value
        $this->datang_timbang7->FormValue = ""; // Clear form value
        $this->datang_timbang8->FormValue = ""; // Clear form value
        $this->datang_timbang9->FormValue = ""; // Clear form value
        $this->datang_timbang10->FormValue = ""; // Clear form value
        $this->datang_timbang11->FormValue = ""; // Clear form value
        $this->datang_timbang12->FormValue = ""; // Clear form value
        $this->datang_timbang13->FormValue = ""; // Clear form value
        $this->datang_timbang14->FormValue = ""; // Clear form value
        $this->datang_timbang15->FormValue = ""; // Clear form value
        $this->datang_timbang16->FormValue = ""; // Clear form value
        $this->datang_timbang17->FormValue = ""; // Clear form value
        $this->datang_timbang18->FormValue = ""; // Clear form value
        $this->datang_timbang19->FormValue = ""; // Clear form value
        $this->datang_timbang20->FormValue = ""; // Clear form value
        $this->datang_timbang21->FormValue = ""; // Clear form value
        $this->datang_timbang22->FormValue = ""; // Clear form value
        $this->datang_timbang23->FormValue = ""; // Clear form value
        $this->datang_timbang24->FormValue = ""; // Clear form value
        $this->datang_timbang25->FormValue = ""; // Clear form value
        $this->datang_jumlah->FormValue = ""; // Clear form value
        $this->datang_jumlah_karung->FormValue = ""; // Clear form value
        $this->datang_berat_bersih->FormValue = ""; // Clear form value
        $this->LastAction = $this->CurrentAction; // Save last action
        $this->CurrentAction = ""; // Clear action
        $_SESSION[SESSION_INLINE_MODE] = ""; // Clear inline mode
    }

    // Switch to Grid Add mode
    protected function gridAddMode()
    {
        $this->CurrentAction = "gridadd";
        $_SESSION[SESSION_INLINE_MODE] = "gridadd";
        $this->hideFieldsForAddEdit();
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->FormKeyName));
        while ($thisKey != "") {
            if ($this->setupKeyValues($thisKey)) {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->FormKeyName));
        }
        return $wrkFilter;
    }

    // Set up key values
    protected function setupKeyValues($key)
    {
        $arKeyFlds = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
        if (count($arKeyFlds) >= 1) {
            $this->datang_id->setOldValue($arKeyFlds[0]);
            if (!is_numeric($this->datang_id->OldValue)) {
                return false;
            }
        }
        return true;
    }

    // Perform Grid Add
    public function gridInsert()
    {
        global $Language, $CurrentForm;
        $rowindex = 1;
        $gridInsert = false;
        $conn = $this->getConnection();

        // Call Grid Inserting event
        if (!$this->gridInserting()) {
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("GridAddCancelled")); // Set grid add cancelled message
            }
            return false;
        }

        // Begin transaction
        $conn->beginTransaction();

        // Init key filter
        $wrkfilter = "";
        $addcnt = 0;
        $key = "";

        // Get row count
        $CurrentForm->Index = -1;
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Insert all rows
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "" && $rowaction != "insert") {
                continue; // Skip
            }
            $this->loadFormValues(); // Get form values
            if (!$this->emptyRow()) {
                $addcnt++;
                $this->SendEmail = false; // Do not send email on insert success

                // Validate form // Already done in validateGridForm
                //if (!$this->validateForm()) {
                //    $gridInsert = false; // Form error, reset action
                //} else {
                    $gridInsert = $this->addRow($this->OldRecordset); // Insert this row
                //}
                if ($gridInsert) {
                    if ($key != "") {
                        $key .= Config("COMPOSITE_KEY_SEPARATOR");
                    }
                    $key .= $this->datang_id->CurrentValue;

                    // Add filter for this record
                    $filter = $this->getRecordFilter();
                    if ($wrkfilter != "") {
                        $wrkfilter .= " OR ";
                    }
                    $wrkfilter .= $filter;
                } else {
                    break;
                }
            }
        }
        if ($addcnt == 0) { // No record inserted
            $this->setFailureMessage($Language->phrase("NoAddRecord"));
            $gridInsert = false;
        }
        if ($gridInsert) {
            $conn->commit(); // Commit transaction

            // Get new records
            $this->CurrentFilter = $wrkfilter;
            $sql = $this->getCurrentSql();
            $rsnew = $conn->fetchAll($sql);

            // Call Grid_Inserted event
            $this->gridInserted($rsnew);
            if ($this->getSuccessMessage() == "") {
                $this->setSuccessMessage($Language->phrase("InsertSuccess")); // Set up insert success message
            }
            $this->clearInlineMode(); // Clear grid add mode
        } else {
            $conn->rollback(); // Rollback transaction
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("InsertFailed")); // Set insert failed message
            }
        }
        return $gridInsert;
    }

    // Check if empty row
    public function emptyRow()
    {
        global $CurrentForm;
        if ($CurrentForm->hasValue("x_datang_tanggal") && $CurrentForm->hasValue("o_datang_tanggal") && $this->datang_tanggal->CurrentValue != $this->datang_tanggal->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_datang_varietas") && $CurrentForm->hasValue("o_datang_varietas") && $this->datang_varietas->CurrentValue != $this->datang_varietas->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_datang_sup") && $CurrentForm->hasValue("o_datang_sup") && $this->datang_sup->CurrentValue != $this->datang_sup->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_datang_timbang1") && $CurrentForm->hasValue("o_datang_timbang1") && $this->datang_timbang1->CurrentValue != $this->datang_timbang1->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_datang_timbang2") && $CurrentForm->hasValue("o_datang_timbang2") && $this->datang_timbang2->CurrentValue != $this->datang_timbang2->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_datang_timbang3") && $CurrentForm->hasValue("o_datang_timbang3") && $this->datang_timbang3->CurrentValue != $this->datang_timbang3->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_datang_timbang4") && $CurrentForm->hasValue("o_datang_timbang4") && $this->datang_timbang4->CurrentValue != $this->datang_timbang4->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_datang_timbang5") && $CurrentForm->hasValue("o_datang_timbang5") && $this->datang_timbang5->CurrentValue != $this->datang_timbang5->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_datang_timbang6") && $CurrentForm->hasValue("o_datang_timbang6") && $this->datang_timbang6->CurrentValue != $this->datang_timbang6->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_datang_timbang7") && $CurrentForm->hasValue("o_datang_timbang7") && $this->datang_timbang7->CurrentValue != $this->datang_timbang7->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_datang_timbang8") && $CurrentForm->hasValue("o_datang_timbang8") && $this->datang_timbang8->CurrentValue != $this->datang_timbang8->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_datang_timbang9") && $CurrentForm->hasValue("o_datang_timbang9") && $this->datang_timbang9->CurrentValue != $this->datang_timbang9->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_datang_timbang10") && $CurrentForm->hasValue("o_datang_timbang10") && $this->datang_timbang10->CurrentValue != $this->datang_timbang10->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_datang_timbang11") && $CurrentForm->hasValue("o_datang_timbang11") && $this->datang_timbang11->CurrentValue != $this->datang_timbang11->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_datang_timbang12") && $CurrentForm->hasValue("o_datang_timbang12") && $this->datang_timbang12->CurrentValue != $this->datang_timbang12->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_datang_timbang13") && $CurrentForm->hasValue("o_datang_timbang13") && $this->datang_timbang13->CurrentValue != $this->datang_timbang13->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_datang_timbang14") && $CurrentForm->hasValue("o_datang_timbang14") && $this->datang_timbang14->CurrentValue != $this->datang_timbang14->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_datang_timbang15") && $CurrentForm->hasValue("o_datang_timbang15") && $this->datang_timbang15->CurrentValue != $this->datang_timbang15->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_datang_timbang16") && $CurrentForm->hasValue("o_datang_timbang16") && $this->datang_timbang16->CurrentValue != $this->datang_timbang16->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_datang_timbang17") && $CurrentForm->hasValue("o_datang_timbang17") && $this->datang_timbang17->CurrentValue != $this->datang_timbang17->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_datang_timbang18") && $CurrentForm->hasValue("o_datang_timbang18") && $this->datang_timbang18->CurrentValue != $this->datang_timbang18->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_datang_timbang19") && $CurrentForm->hasValue("o_datang_timbang19") && $this->datang_timbang19->CurrentValue != $this->datang_timbang19->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_datang_timbang20") && $CurrentForm->hasValue("o_datang_timbang20") && $this->datang_timbang20->CurrentValue != $this->datang_timbang20->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_datang_timbang21") && $CurrentForm->hasValue("o_datang_timbang21") && $this->datang_timbang21->CurrentValue != $this->datang_timbang21->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_datang_timbang22") && $CurrentForm->hasValue("o_datang_timbang22") && $this->datang_timbang22->CurrentValue != $this->datang_timbang22->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_datang_timbang23") && $CurrentForm->hasValue("o_datang_timbang23") && $this->datang_timbang23->CurrentValue != $this->datang_timbang23->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_datang_timbang24") && $CurrentForm->hasValue("o_datang_timbang24") && $this->datang_timbang24->CurrentValue != $this->datang_timbang24->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_datang_timbang25") && $CurrentForm->hasValue("o_datang_timbang25") && $this->datang_timbang25->CurrentValue != $this->datang_timbang25->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_datang_jumlah") && $CurrentForm->hasValue("o_datang_jumlah") && $this->datang_jumlah->CurrentValue != $this->datang_jumlah->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_datang_jumlah_karung") && $CurrentForm->hasValue("o_datang_jumlah_karung") && $this->datang_jumlah_karung->CurrentValue != $this->datang_jumlah_karung->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_datang_berat_bersih") && $CurrentForm->hasValue("o_datang_berat_bersih") && $this->datang_berat_bersih->CurrentValue != $this->datang_berat_bersih->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_datang_catatan") && $CurrentForm->hasValue("o_datang_catatan") && $this->datang_catatan->CurrentValue != $this->datang_catatan->OldValue) {
            return false;
        }
        return true;
    }

    // Validate grid form
    public function validateGridForm()
    {
        global $CurrentForm;
        // Get row count
        $CurrentForm->Index = -1;
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Validate all records
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "delete" && $rowaction != "insertdelete") {
                $this->loadFormValues(); // Get form values
                if ($rowaction == "insert" && $this->emptyRow()) {
                    // Ignore
                } elseif (!$this->validateForm()) {
                    return false;
                }
            }
        }
        return true;
    }

    // Get all form values of the grid
    public function getGridFormValues()
    {
        global $CurrentForm;
        // Get row count
        $CurrentForm->Index = -1;
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }
        $rows = [];

        // Loop through all records
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "delete" && $rowaction != "insertdelete") {
                $this->loadFormValues(); // Get form values
                if ($rowaction == "insert" && $this->emptyRow()) {
                    // Ignore
                } else {
                    $rows[] = $this->getFieldValues("FormValue"); // Return row as array
                }
            }
        }
        return $rows; // Return as array of array
    }

    // Restore form values for current row
    public function restoreCurrentRowFormValues($idx)
    {
        global $CurrentForm;

        // Get row based on current index
        $CurrentForm->Index = $idx;
        $rowaction = strval($CurrentForm->getValue($this->FormActionName));
        $this->loadFormValues(); // Load form values
        // Set up invalid status correctly
        $this->resetFormError();
        if ($rowaction == "insert" && $this->emptyRow()) {
            // Ignore
        } else {
            $this->validateForm();
        }
    }

    // Reset form status
    public function resetFormError()
    {
        $this->datang_id->clearErrorMessage();
        $this->datang_petugas->clearErrorMessage();
        $this->datang_tanggal->clearErrorMessage();
        $this->datang_varietas->clearErrorMessage();
        $this->datang_sup->clearErrorMessage();
        $this->datang_timbang1->clearErrorMessage();
        $this->datang_timbang2->clearErrorMessage();
        $this->datang_timbang3->clearErrorMessage();
        $this->datang_timbang4->clearErrorMessage();
        $this->datang_timbang5->clearErrorMessage();
        $this->datang_timbang6->clearErrorMessage();
        $this->datang_timbang7->clearErrorMessage();
        $this->datang_timbang8->clearErrorMessage();
        $this->datang_timbang9->clearErrorMessage();
        $this->datang_timbang10->clearErrorMessage();
        $this->datang_timbang11->clearErrorMessage();
        $this->datang_timbang12->clearErrorMessage();
        $this->datang_timbang13->clearErrorMessage();
        $this->datang_timbang14->clearErrorMessage();
        $this->datang_timbang15->clearErrorMessage();
        $this->datang_timbang16->clearErrorMessage();
        $this->datang_timbang17->clearErrorMessage();
        $this->datang_timbang18->clearErrorMessage();
        $this->datang_timbang19->clearErrorMessage();
        $this->datang_timbang20->clearErrorMessage();
        $this->datang_timbang21->clearErrorMessage();
        $this->datang_timbang22->clearErrorMessage();
        $this->datang_timbang23->clearErrorMessage();
        $this->datang_timbang24->clearErrorMessage();
        $this->datang_timbang25->clearErrorMessage();
        $this->datang_jumlah->clearErrorMessage();
        $this->datang_jumlah_karung->clearErrorMessage();
        $this->datang_berat_bersih->clearErrorMessage();
        $this->datang_catatan->clearErrorMessage();
    }

    // Get list of filters
    public function getFilterList()
    {
        global $UserProfile;

        // Initialize
        $filterList = "";
        $savedFilterList = "";
        $filterList = Concat($filterList, $this->datang_id->AdvancedSearch->toJson(), ","); // Field datang_id
        $filterList = Concat($filterList, $this->datang_petugas->AdvancedSearch->toJson(), ","); // Field datang_petugas
        $filterList = Concat($filterList, $this->datang_tanggal->AdvancedSearch->toJson(), ","); // Field datang_tanggal
        $filterList = Concat($filterList, $this->datang_varietas->AdvancedSearch->toJson(), ","); // Field datang_varietas
        $filterList = Concat($filterList, $this->datang_sup->AdvancedSearch->toJson(), ","); // Field datang_sup
        $filterList = Concat($filterList, $this->datang_timbang1->AdvancedSearch->toJson(), ","); // Field datang_timbang1
        $filterList = Concat($filterList, $this->datang_timbang2->AdvancedSearch->toJson(), ","); // Field datang_timbang2
        $filterList = Concat($filterList, $this->datang_timbang3->AdvancedSearch->toJson(), ","); // Field datang_timbang3
        $filterList = Concat($filterList, $this->datang_timbang4->AdvancedSearch->toJson(), ","); // Field datang_timbang4
        $filterList = Concat($filterList, $this->datang_timbang5->AdvancedSearch->toJson(), ","); // Field datang_timbang5
        $filterList = Concat($filterList, $this->datang_timbang6->AdvancedSearch->toJson(), ","); // Field datang_timbang6
        $filterList = Concat($filterList, $this->datang_timbang7->AdvancedSearch->toJson(), ","); // Field datang_timbang7
        $filterList = Concat($filterList, $this->datang_timbang8->AdvancedSearch->toJson(), ","); // Field datang_timbang8
        $filterList = Concat($filterList, $this->datang_timbang9->AdvancedSearch->toJson(), ","); // Field datang_timbang9
        $filterList = Concat($filterList, $this->datang_timbang10->AdvancedSearch->toJson(), ","); // Field datang_timbang10
        $filterList = Concat($filterList, $this->datang_timbang11->AdvancedSearch->toJson(), ","); // Field datang_timbang11
        $filterList = Concat($filterList, $this->datang_timbang12->AdvancedSearch->toJson(), ","); // Field datang_timbang12
        $filterList = Concat($filterList, $this->datang_timbang13->AdvancedSearch->toJson(), ","); // Field datang_timbang13
        $filterList = Concat($filterList, $this->datang_timbang14->AdvancedSearch->toJson(), ","); // Field datang_timbang14
        $filterList = Concat($filterList, $this->datang_timbang15->AdvancedSearch->toJson(), ","); // Field datang_timbang15
        $filterList = Concat($filterList, $this->datang_timbang16->AdvancedSearch->toJson(), ","); // Field datang_timbang16
        $filterList = Concat($filterList, $this->datang_timbang17->AdvancedSearch->toJson(), ","); // Field datang_timbang17
        $filterList = Concat($filterList, $this->datang_timbang18->AdvancedSearch->toJson(), ","); // Field datang_timbang18
        $filterList = Concat($filterList, $this->datang_timbang19->AdvancedSearch->toJson(), ","); // Field datang_timbang19
        $filterList = Concat($filterList, $this->datang_timbang20->AdvancedSearch->toJson(), ","); // Field datang_timbang20
        $filterList = Concat($filterList, $this->datang_timbang21->AdvancedSearch->toJson(), ","); // Field datang_timbang21
        $filterList = Concat($filterList, $this->datang_timbang22->AdvancedSearch->toJson(), ","); // Field datang_timbang22
        $filterList = Concat($filterList, $this->datang_timbang23->AdvancedSearch->toJson(), ","); // Field datang_timbang23
        $filterList = Concat($filterList, $this->datang_timbang24->AdvancedSearch->toJson(), ","); // Field datang_timbang24
        $filterList = Concat($filterList, $this->datang_timbang25->AdvancedSearch->toJson(), ","); // Field datang_timbang25
        $filterList = Concat($filterList, $this->datang_jumlah->AdvancedSearch->toJson(), ","); // Field datang_jumlah
        $filterList = Concat($filterList, $this->datang_jumlah_karung->AdvancedSearch->toJson(), ","); // Field datang_jumlah_karung
        $filterList = Concat($filterList, $this->datang_berat_bersih->AdvancedSearch->toJson(), ","); // Field datang_berat_bersih
        $filterList = Concat($filterList, $this->datang_catatan->AdvancedSearch->toJson(), ","); // Field datang_catatan
        if ($this->BasicSearch->Keyword != "") {
            $wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
            $filterList = Concat($filterList, $wrk, ",");
        }

        // Return filter list in JSON
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        global $UserProfile;
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            $UserProfile->setSearchFilters(CurrentUserName(), "fkedatanganlistsrch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd") !== "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter"), true);
        $this->Command = "search";

        // Field datang_id
        $this->datang_id->AdvancedSearch->SearchValue = @$filter["x_datang_id"];
        $this->datang_id->AdvancedSearch->SearchOperator = @$filter["z_datang_id"];
        $this->datang_id->AdvancedSearch->SearchCondition = @$filter["v_datang_id"];
        $this->datang_id->AdvancedSearch->SearchValue2 = @$filter["y_datang_id"];
        $this->datang_id->AdvancedSearch->SearchOperator2 = @$filter["w_datang_id"];
        $this->datang_id->AdvancedSearch->save();

        // Field datang_petugas
        $this->datang_petugas->AdvancedSearch->SearchValue = @$filter["x_datang_petugas"];
        $this->datang_petugas->AdvancedSearch->SearchOperator = @$filter["z_datang_petugas"];
        $this->datang_petugas->AdvancedSearch->SearchCondition = @$filter["v_datang_petugas"];
        $this->datang_petugas->AdvancedSearch->SearchValue2 = @$filter["y_datang_petugas"];
        $this->datang_petugas->AdvancedSearch->SearchOperator2 = @$filter["w_datang_petugas"];
        $this->datang_petugas->AdvancedSearch->save();

        // Field datang_tanggal
        $this->datang_tanggal->AdvancedSearch->SearchValue = @$filter["x_datang_tanggal"];
        $this->datang_tanggal->AdvancedSearch->SearchOperator = @$filter["z_datang_tanggal"];
        $this->datang_tanggal->AdvancedSearch->SearchCondition = @$filter["v_datang_tanggal"];
        $this->datang_tanggal->AdvancedSearch->SearchValue2 = @$filter["y_datang_tanggal"];
        $this->datang_tanggal->AdvancedSearch->SearchOperator2 = @$filter["w_datang_tanggal"];
        $this->datang_tanggal->AdvancedSearch->save();

        // Field datang_varietas
        $this->datang_varietas->AdvancedSearch->SearchValue = @$filter["x_datang_varietas"];
        $this->datang_varietas->AdvancedSearch->SearchOperator = @$filter["z_datang_varietas"];
        $this->datang_varietas->AdvancedSearch->SearchCondition = @$filter["v_datang_varietas"];
        $this->datang_varietas->AdvancedSearch->SearchValue2 = @$filter["y_datang_varietas"];
        $this->datang_varietas->AdvancedSearch->SearchOperator2 = @$filter["w_datang_varietas"];
        $this->datang_varietas->AdvancedSearch->save();

        // Field datang_sup
        $this->datang_sup->AdvancedSearch->SearchValue = @$filter["x_datang_sup"];
        $this->datang_sup->AdvancedSearch->SearchOperator = @$filter["z_datang_sup"];
        $this->datang_sup->AdvancedSearch->SearchCondition = @$filter["v_datang_sup"];
        $this->datang_sup->AdvancedSearch->SearchValue2 = @$filter["y_datang_sup"];
        $this->datang_sup->AdvancedSearch->SearchOperator2 = @$filter["w_datang_sup"];
        $this->datang_sup->AdvancedSearch->save();

        // Field datang_timbang1
        $this->datang_timbang1->AdvancedSearch->SearchValue = @$filter["x_datang_timbang1"];
        $this->datang_timbang1->AdvancedSearch->SearchOperator = @$filter["z_datang_timbang1"];
        $this->datang_timbang1->AdvancedSearch->SearchCondition = @$filter["v_datang_timbang1"];
        $this->datang_timbang1->AdvancedSearch->SearchValue2 = @$filter["y_datang_timbang1"];
        $this->datang_timbang1->AdvancedSearch->SearchOperator2 = @$filter["w_datang_timbang1"];
        $this->datang_timbang1->AdvancedSearch->save();

        // Field datang_timbang2
        $this->datang_timbang2->AdvancedSearch->SearchValue = @$filter["x_datang_timbang2"];
        $this->datang_timbang2->AdvancedSearch->SearchOperator = @$filter["z_datang_timbang2"];
        $this->datang_timbang2->AdvancedSearch->SearchCondition = @$filter["v_datang_timbang2"];
        $this->datang_timbang2->AdvancedSearch->SearchValue2 = @$filter["y_datang_timbang2"];
        $this->datang_timbang2->AdvancedSearch->SearchOperator2 = @$filter["w_datang_timbang2"];
        $this->datang_timbang2->AdvancedSearch->save();

        // Field datang_timbang3
        $this->datang_timbang3->AdvancedSearch->SearchValue = @$filter["x_datang_timbang3"];
        $this->datang_timbang3->AdvancedSearch->SearchOperator = @$filter["z_datang_timbang3"];
        $this->datang_timbang3->AdvancedSearch->SearchCondition = @$filter["v_datang_timbang3"];
        $this->datang_timbang3->AdvancedSearch->SearchValue2 = @$filter["y_datang_timbang3"];
        $this->datang_timbang3->AdvancedSearch->SearchOperator2 = @$filter["w_datang_timbang3"];
        $this->datang_timbang3->AdvancedSearch->save();

        // Field datang_timbang4
        $this->datang_timbang4->AdvancedSearch->SearchValue = @$filter["x_datang_timbang4"];
        $this->datang_timbang4->AdvancedSearch->SearchOperator = @$filter["z_datang_timbang4"];
        $this->datang_timbang4->AdvancedSearch->SearchCondition = @$filter["v_datang_timbang4"];
        $this->datang_timbang4->AdvancedSearch->SearchValue2 = @$filter["y_datang_timbang4"];
        $this->datang_timbang4->AdvancedSearch->SearchOperator2 = @$filter["w_datang_timbang4"];
        $this->datang_timbang4->AdvancedSearch->save();

        // Field datang_timbang5
        $this->datang_timbang5->AdvancedSearch->SearchValue = @$filter["x_datang_timbang5"];
        $this->datang_timbang5->AdvancedSearch->SearchOperator = @$filter["z_datang_timbang5"];
        $this->datang_timbang5->AdvancedSearch->SearchCondition = @$filter["v_datang_timbang5"];
        $this->datang_timbang5->AdvancedSearch->SearchValue2 = @$filter["y_datang_timbang5"];
        $this->datang_timbang5->AdvancedSearch->SearchOperator2 = @$filter["w_datang_timbang5"];
        $this->datang_timbang5->AdvancedSearch->save();

        // Field datang_timbang6
        $this->datang_timbang6->AdvancedSearch->SearchValue = @$filter["x_datang_timbang6"];
        $this->datang_timbang6->AdvancedSearch->SearchOperator = @$filter["z_datang_timbang6"];
        $this->datang_timbang6->AdvancedSearch->SearchCondition = @$filter["v_datang_timbang6"];
        $this->datang_timbang6->AdvancedSearch->SearchValue2 = @$filter["y_datang_timbang6"];
        $this->datang_timbang6->AdvancedSearch->SearchOperator2 = @$filter["w_datang_timbang6"];
        $this->datang_timbang6->AdvancedSearch->save();

        // Field datang_timbang7
        $this->datang_timbang7->AdvancedSearch->SearchValue = @$filter["x_datang_timbang7"];
        $this->datang_timbang7->AdvancedSearch->SearchOperator = @$filter["z_datang_timbang7"];
        $this->datang_timbang7->AdvancedSearch->SearchCondition = @$filter["v_datang_timbang7"];
        $this->datang_timbang7->AdvancedSearch->SearchValue2 = @$filter["y_datang_timbang7"];
        $this->datang_timbang7->AdvancedSearch->SearchOperator2 = @$filter["w_datang_timbang7"];
        $this->datang_timbang7->AdvancedSearch->save();

        // Field datang_timbang8
        $this->datang_timbang8->AdvancedSearch->SearchValue = @$filter["x_datang_timbang8"];
        $this->datang_timbang8->AdvancedSearch->SearchOperator = @$filter["z_datang_timbang8"];
        $this->datang_timbang8->AdvancedSearch->SearchCondition = @$filter["v_datang_timbang8"];
        $this->datang_timbang8->AdvancedSearch->SearchValue2 = @$filter["y_datang_timbang8"];
        $this->datang_timbang8->AdvancedSearch->SearchOperator2 = @$filter["w_datang_timbang8"];
        $this->datang_timbang8->AdvancedSearch->save();

        // Field datang_timbang9
        $this->datang_timbang9->AdvancedSearch->SearchValue = @$filter["x_datang_timbang9"];
        $this->datang_timbang9->AdvancedSearch->SearchOperator = @$filter["z_datang_timbang9"];
        $this->datang_timbang9->AdvancedSearch->SearchCondition = @$filter["v_datang_timbang9"];
        $this->datang_timbang9->AdvancedSearch->SearchValue2 = @$filter["y_datang_timbang9"];
        $this->datang_timbang9->AdvancedSearch->SearchOperator2 = @$filter["w_datang_timbang9"];
        $this->datang_timbang9->AdvancedSearch->save();

        // Field datang_timbang10
        $this->datang_timbang10->AdvancedSearch->SearchValue = @$filter["x_datang_timbang10"];
        $this->datang_timbang10->AdvancedSearch->SearchOperator = @$filter["z_datang_timbang10"];
        $this->datang_timbang10->AdvancedSearch->SearchCondition = @$filter["v_datang_timbang10"];
        $this->datang_timbang10->AdvancedSearch->SearchValue2 = @$filter["y_datang_timbang10"];
        $this->datang_timbang10->AdvancedSearch->SearchOperator2 = @$filter["w_datang_timbang10"];
        $this->datang_timbang10->AdvancedSearch->save();

        // Field datang_timbang11
        $this->datang_timbang11->AdvancedSearch->SearchValue = @$filter["x_datang_timbang11"];
        $this->datang_timbang11->AdvancedSearch->SearchOperator = @$filter["z_datang_timbang11"];
        $this->datang_timbang11->AdvancedSearch->SearchCondition = @$filter["v_datang_timbang11"];
        $this->datang_timbang11->AdvancedSearch->SearchValue2 = @$filter["y_datang_timbang11"];
        $this->datang_timbang11->AdvancedSearch->SearchOperator2 = @$filter["w_datang_timbang11"];
        $this->datang_timbang11->AdvancedSearch->save();

        // Field datang_timbang12
        $this->datang_timbang12->AdvancedSearch->SearchValue = @$filter["x_datang_timbang12"];
        $this->datang_timbang12->AdvancedSearch->SearchOperator = @$filter["z_datang_timbang12"];
        $this->datang_timbang12->AdvancedSearch->SearchCondition = @$filter["v_datang_timbang12"];
        $this->datang_timbang12->AdvancedSearch->SearchValue2 = @$filter["y_datang_timbang12"];
        $this->datang_timbang12->AdvancedSearch->SearchOperator2 = @$filter["w_datang_timbang12"];
        $this->datang_timbang12->AdvancedSearch->save();

        // Field datang_timbang13
        $this->datang_timbang13->AdvancedSearch->SearchValue = @$filter["x_datang_timbang13"];
        $this->datang_timbang13->AdvancedSearch->SearchOperator = @$filter["z_datang_timbang13"];
        $this->datang_timbang13->AdvancedSearch->SearchCondition = @$filter["v_datang_timbang13"];
        $this->datang_timbang13->AdvancedSearch->SearchValue2 = @$filter["y_datang_timbang13"];
        $this->datang_timbang13->AdvancedSearch->SearchOperator2 = @$filter["w_datang_timbang13"];
        $this->datang_timbang13->AdvancedSearch->save();

        // Field datang_timbang14
        $this->datang_timbang14->AdvancedSearch->SearchValue = @$filter["x_datang_timbang14"];
        $this->datang_timbang14->AdvancedSearch->SearchOperator = @$filter["z_datang_timbang14"];
        $this->datang_timbang14->AdvancedSearch->SearchCondition = @$filter["v_datang_timbang14"];
        $this->datang_timbang14->AdvancedSearch->SearchValue2 = @$filter["y_datang_timbang14"];
        $this->datang_timbang14->AdvancedSearch->SearchOperator2 = @$filter["w_datang_timbang14"];
        $this->datang_timbang14->AdvancedSearch->save();

        // Field datang_timbang15
        $this->datang_timbang15->AdvancedSearch->SearchValue = @$filter["x_datang_timbang15"];
        $this->datang_timbang15->AdvancedSearch->SearchOperator = @$filter["z_datang_timbang15"];
        $this->datang_timbang15->AdvancedSearch->SearchCondition = @$filter["v_datang_timbang15"];
        $this->datang_timbang15->AdvancedSearch->SearchValue2 = @$filter["y_datang_timbang15"];
        $this->datang_timbang15->AdvancedSearch->SearchOperator2 = @$filter["w_datang_timbang15"];
        $this->datang_timbang15->AdvancedSearch->save();

        // Field datang_timbang16
        $this->datang_timbang16->AdvancedSearch->SearchValue = @$filter["x_datang_timbang16"];
        $this->datang_timbang16->AdvancedSearch->SearchOperator = @$filter["z_datang_timbang16"];
        $this->datang_timbang16->AdvancedSearch->SearchCondition = @$filter["v_datang_timbang16"];
        $this->datang_timbang16->AdvancedSearch->SearchValue2 = @$filter["y_datang_timbang16"];
        $this->datang_timbang16->AdvancedSearch->SearchOperator2 = @$filter["w_datang_timbang16"];
        $this->datang_timbang16->AdvancedSearch->save();

        // Field datang_timbang17
        $this->datang_timbang17->AdvancedSearch->SearchValue = @$filter["x_datang_timbang17"];
        $this->datang_timbang17->AdvancedSearch->SearchOperator = @$filter["z_datang_timbang17"];
        $this->datang_timbang17->AdvancedSearch->SearchCondition = @$filter["v_datang_timbang17"];
        $this->datang_timbang17->AdvancedSearch->SearchValue2 = @$filter["y_datang_timbang17"];
        $this->datang_timbang17->AdvancedSearch->SearchOperator2 = @$filter["w_datang_timbang17"];
        $this->datang_timbang17->AdvancedSearch->save();

        // Field datang_timbang18
        $this->datang_timbang18->AdvancedSearch->SearchValue = @$filter["x_datang_timbang18"];
        $this->datang_timbang18->AdvancedSearch->SearchOperator = @$filter["z_datang_timbang18"];
        $this->datang_timbang18->AdvancedSearch->SearchCondition = @$filter["v_datang_timbang18"];
        $this->datang_timbang18->AdvancedSearch->SearchValue2 = @$filter["y_datang_timbang18"];
        $this->datang_timbang18->AdvancedSearch->SearchOperator2 = @$filter["w_datang_timbang18"];
        $this->datang_timbang18->AdvancedSearch->save();

        // Field datang_timbang19
        $this->datang_timbang19->AdvancedSearch->SearchValue = @$filter["x_datang_timbang19"];
        $this->datang_timbang19->AdvancedSearch->SearchOperator = @$filter["z_datang_timbang19"];
        $this->datang_timbang19->AdvancedSearch->SearchCondition = @$filter["v_datang_timbang19"];
        $this->datang_timbang19->AdvancedSearch->SearchValue2 = @$filter["y_datang_timbang19"];
        $this->datang_timbang19->AdvancedSearch->SearchOperator2 = @$filter["w_datang_timbang19"];
        $this->datang_timbang19->AdvancedSearch->save();

        // Field datang_timbang20
        $this->datang_timbang20->AdvancedSearch->SearchValue = @$filter["x_datang_timbang20"];
        $this->datang_timbang20->AdvancedSearch->SearchOperator = @$filter["z_datang_timbang20"];
        $this->datang_timbang20->AdvancedSearch->SearchCondition = @$filter["v_datang_timbang20"];
        $this->datang_timbang20->AdvancedSearch->SearchValue2 = @$filter["y_datang_timbang20"];
        $this->datang_timbang20->AdvancedSearch->SearchOperator2 = @$filter["w_datang_timbang20"];
        $this->datang_timbang20->AdvancedSearch->save();

        // Field datang_timbang21
        $this->datang_timbang21->AdvancedSearch->SearchValue = @$filter["x_datang_timbang21"];
        $this->datang_timbang21->AdvancedSearch->SearchOperator = @$filter["z_datang_timbang21"];
        $this->datang_timbang21->AdvancedSearch->SearchCondition = @$filter["v_datang_timbang21"];
        $this->datang_timbang21->AdvancedSearch->SearchValue2 = @$filter["y_datang_timbang21"];
        $this->datang_timbang21->AdvancedSearch->SearchOperator2 = @$filter["w_datang_timbang21"];
        $this->datang_timbang21->AdvancedSearch->save();

        // Field datang_timbang22
        $this->datang_timbang22->AdvancedSearch->SearchValue = @$filter["x_datang_timbang22"];
        $this->datang_timbang22->AdvancedSearch->SearchOperator = @$filter["z_datang_timbang22"];
        $this->datang_timbang22->AdvancedSearch->SearchCondition = @$filter["v_datang_timbang22"];
        $this->datang_timbang22->AdvancedSearch->SearchValue2 = @$filter["y_datang_timbang22"];
        $this->datang_timbang22->AdvancedSearch->SearchOperator2 = @$filter["w_datang_timbang22"];
        $this->datang_timbang22->AdvancedSearch->save();

        // Field datang_timbang23
        $this->datang_timbang23->AdvancedSearch->SearchValue = @$filter["x_datang_timbang23"];
        $this->datang_timbang23->AdvancedSearch->SearchOperator = @$filter["z_datang_timbang23"];
        $this->datang_timbang23->AdvancedSearch->SearchCondition = @$filter["v_datang_timbang23"];
        $this->datang_timbang23->AdvancedSearch->SearchValue2 = @$filter["y_datang_timbang23"];
        $this->datang_timbang23->AdvancedSearch->SearchOperator2 = @$filter["w_datang_timbang23"];
        $this->datang_timbang23->AdvancedSearch->save();

        // Field datang_timbang24
        $this->datang_timbang24->AdvancedSearch->SearchValue = @$filter["x_datang_timbang24"];
        $this->datang_timbang24->AdvancedSearch->SearchOperator = @$filter["z_datang_timbang24"];
        $this->datang_timbang24->AdvancedSearch->SearchCondition = @$filter["v_datang_timbang24"];
        $this->datang_timbang24->AdvancedSearch->SearchValue2 = @$filter["y_datang_timbang24"];
        $this->datang_timbang24->AdvancedSearch->SearchOperator2 = @$filter["w_datang_timbang24"];
        $this->datang_timbang24->AdvancedSearch->save();

        // Field datang_timbang25
        $this->datang_timbang25->AdvancedSearch->SearchValue = @$filter["x_datang_timbang25"];
        $this->datang_timbang25->AdvancedSearch->SearchOperator = @$filter["z_datang_timbang25"];
        $this->datang_timbang25->AdvancedSearch->SearchCondition = @$filter["v_datang_timbang25"];
        $this->datang_timbang25->AdvancedSearch->SearchValue2 = @$filter["y_datang_timbang25"];
        $this->datang_timbang25->AdvancedSearch->SearchOperator2 = @$filter["w_datang_timbang25"];
        $this->datang_timbang25->AdvancedSearch->save();

        // Field datang_jumlah
        $this->datang_jumlah->AdvancedSearch->SearchValue = @$filter["x_datang_jumlah"];
        $this->datang_jumlah->AdvancedSearch->SearchOperator = @$filter["z_datang_jumlah"];
        $this->datang_jumlah->AdvancedSearch->SearchCondition = @$filter["v_datang_jumlah"];
        $this->datang_jumlah->AdvancedSearch->SearchValue2 = @$filter["y_datang_jumlah"];
        $this->datang_jumlah->AdvancedSearch->SearchOperator2 = @$filter["w_datang_jumlah"];
        $this->datang_jumlah->AdvancedSearch->save();

        // Field datang_jumlah_karung
        $this->datang_jumlah_karung->AdvancedSearch->SearchValue = @$filter["x_datang_jumlah_karung"];
        $this->datang_jumlah_karung->AdvancedSearch->SearchOperator = @$filter["z_datang_jumlah_karung"];
        $this->datang_jumlah_karung->AdvancedSearch->SearchCondition = @$filter["v_datang_jumlah_karung"];
        $this->datang_jumlah_karung->AdvancedSearch->SearchValue2 = @$filter["y_datang_jumlah_karung"];
        $this->datang_jumlah_karung->AdvancedSearch->SearchOperator2 = @$filter["w_datang_jumlah_karung"];
        $this->datang_jumlah_karung->AdvancedSearch->save();

        // Field datang_berat_bersih
        $this->datang_berat_bersih->AdvancedSearch->SearchValue = @$filter["x_datang_berat_bersih"];
        $this->datang_berat_bersih->AdvancedSearch->SearchOperator = @$filter["z_datang_berat_bersih"];
        $this->datang_berat_bersih->AdvancedSearch->SearchCondition = @$filter["v_datang_berat_bersih"];
        $this->datang_berat_bersih->AdvancedSearch->SearchValue2 = @$filter["y_datang_berat_bersih"];
        $this->datang_berat_bersih->AdvancedSearch->SearchOperator2 = @$filter["w_datang_berat_bersih"];
        $this->datang_berat_bersih->AdvancedSearch->save();

        // Field datang_catatan
        $this->datang_catatan->AdvancedSearch->SearchValue = @$filter["x_datang_catatan"];
        $this->datang_catatan->AdvancedSearch->SearchOperator = @$filter["z_datang_catatan"];
        $this->datang_catatan->AdvancedSearch->SearchCondition = @$filter["v_datang_catatan"];
        $this->datang_catatan->AdvancedSearch->SearchValue2 = @$filter["y_datang_catatan"];
        $this->datang_catatan->AdvancedSearch->SearchOperator2 = @$filter["w_datang_catatan"];
        $this->datang_catatan->AdvancedSearch->save();
        $this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
        $this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
    }

    // Advanced search WHERE clause based on QueryString
    protected function advancedSearchWhere($default = false)
    {
        global $Security;
        $where = "";
        if (!$Security->canSearch()) {
            return "";
        }
        $this->buildSearchSql($where, $this->datang_id, $default, false); // datang_id
        $this->buildSearchSql($where, $this->datang_petugas, $default, false); // datang_petugas
        $this->buildSearchSql($where, $this->datang_tanggal, $default, false); // datang_tanggal
        $this->buildSearchSql($where, $this->datang_varietas, $default, false); // datang_varietas
        $this->buildSearchSql($where, $this->datang_sup, $default, false); // datang_sup
        $this->buildSearchSql($where, $this->datang_timbang1, $default, false); // datang_timbang1
        $this->buildSearchSql($where, $this->datang_timbang2, $default, false); // datang_timbang2
        $this->buildSearchSql($where, $this->datang_timbang3, $default, false); // datang_timbang3
        $this->buildSearchSql($where, $this->datang_timbang4, $default, false); // datang_timbang4
        $this->buildSearchSql($where, $this->datang_timbang5, $default, false); // datang_timbang5
        $this->buildSearchSql($where, $this->datang_timbang6, $default, false); // datang_timbang6
        $this->buildSearchSql($where, $this->datang_timbang7, $default, false); // datang_timbang7
        $this->buildSearchSql($where, $this->datang_timbang8, $default, false); // datang_timbang8
        $this->buildSearchSql($where, $this->datang_timbang9, $default, false); // datang_timbang9
        $this->buildSearchSql($where, $this->datang_timbang10, $default, false); // datang_timbang10
        $this->buildSearchSql($where, $this->datang_timbang11, $default, false); // datang_timbang11
        $this->buildSearchSql($where, $this->datang_timbang12, $default, false); // datang_timbang12
        $this->buildSearchSql($where, $this->datang_timbang13, $default, false); // datang_timbang13
        $this->buildSearchSql($where, $this->datang_timbang14, $default, false); // datang_timbang14
        $this->buildSearchSql($where, $this->datang_timbang15, $default, false); // datang_timbang15
        $this->buildSearchSql($where, $this->datang_timbang16, $default, false); // datang_timbang16
        $this->buildSearchSql($where, $this->datang_timbang17, $default, false); // datang_timbang17
        $this->buildSearchSql($where, $this->datang_timbang18, $default, false); // datang_timbang18
        $this->buildSearchSql($where, $this->datang_timbang19, $default, false); // datang_timbang19
        $this->buildSearchSql($where, $this->datang_timbang20, $default, false); // datang_timbang20
        $this->buildSearchSql($where, $this->datang_timbang21, $default, false); // datang_timbang21
        $this->buildSearchSql($where, $this->datang_timbang22, $default, false); // datang_timbang22
        $this->buildSearchSql($where, $this->datang_timbang23, $default, false); // datang_timbang23
        $this->buildSearchSql($where, $this->datang_timbang24, $default, false); // datang_timbang24
        $this->buildSearchSql($where, $this->datang_timbang25, $default, false); // datang_timbang25
        $this->buildSearchSql($where, $this->datang_jumlah, $default, false); // datang_jumlah
        $this->buildSearchSql($where, $this->datang_jumlah_karung, $default, false); // datang_jumlah_karung
        $this->buildSearchSql($where, $this->datang_berat_bersih, $default, false); // datang_berat_bersih
        $this->buildSearchSql($where, $this->datang_catatan, $default, false); // datang_catatan

        // Set up search parm
        if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
            $this->Command = "search";
        }
        if (!$default && $this->Command == "search") {
            $this->datang_id->AdvancedSearch->save(); // datang_id
            $this->datang_petugas->AdvancedSearch->save(); // datang_petugas
            $this->datang_tanggal->AdvancedSearch->save(); // datang_tanggal
            $this->datang_varietas->AdvancedSearch->save(); // datang_varietas
            $this->datang_sup->AdvancedSearch->save(); // datang_sup
            $this->datang_timbang1->AdvancedSearch->save(); // datang_timbang1
            $this->datang_timbang2->AdvancedSearch->save(); // datang_timbang2
            $this->datang_timbang3->AdvancedSearch->save(); // datang_timbang3
            $this->datang_timbang4->AdvancedSearch->save(); // datang_timbang4
            $this->datang_timbang5->AdvancedSearch->save(); // datang_timbang5
            $this->datang_timbang6->AdvancedSearch->save(); // datang_timbang6
            $this->datang_timbang7->AdvancedSearch->save(); // datang_timbang7
            $this->datang_timbang8->AdvancedSearch->save(); // datang_timbang8
            $this->datang_timbang9->AdvancedSearch->save(); // datang_timbang9
            $this->datang_timbang10->AdvancedSearch->save(); // datang_timbang10
            $this->datang_timbang11->AdvancedSearch->save(); // datang_timbang11
            $this->datang_timbang12->AdvancedSearch->save(); // datang_timbang12
            $this->datang_timbang13->AdvancedSearch->save(); // datang_timbang13
            $this->datang_timbang14->AdvancedSearch->save(); // datang_timbang14
            $this->datang_timbang15->AdvancedSearch->save(); // datang_timbang15
            $this->datang_timbang16->AdvancedSearch->save(); // datang_timbang16
            $this->datang_timbang17->AdvancedSearch->save(); // datang_timbang17
            $this->datang_timbang18->AdvancedSearch->save(); // datang_timbang18
            $this->datang_timbang19->AdvancedSearch->save(); // datang_timbang19
            $this->datang_timbang20->AdvancedSearch->save(); // datang_timbang20
            $this->datang_timbang21->AdvancedSearch->save(); // datang_timbang21
            $this->datang_timbang22->AdvancedSearch->save(); // datang_timbang22
            $this->datang_timbang23->AdvancedSearch->save(); // datang_timbang23
            $this->datang_timbang24->AdvancedSearch->save(); // datang_timbang24
            $this->datang_timbang25->AdvancedSearch->save(); // datang_timbang25
            $this->datang_jumlah->AdvancedSearch->save(); // datang_jumlah
            $this->datang_jumlah_karung->AdvancedSearch->save(); // datang_jumlah_karung
            $this->datang_berat_bersih->AdvancedSearch->save(); // datang_berat_bersih
            $this->datang_catatan->AdvancedSearch->save(); // datang_catatan
        }
        return $where;
    }

    // Build search SQL
    protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
    {
        $fldParm = $fld->Param;
        $fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
        $fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        $fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
        $wrk = "";
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldOpr = strtoupper(trim($fldOpr));
        if ($fldOpr == "") {
            $fldOpr = "=";
        }
        $fldOpr2 = strtoupper(trim($fldOpr2));
        if ($fldOpr2 == "") {
            $fldOpr2 = "=";
        }
        if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 || !IsMultiSearchOperator($fldOpr)) {
            $multiValue = false;
        }
        if ($multiValue) {
            $wrk1 = ($fldVal != "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
            $wrk2 = ($fldVal2 != "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
            $wrk = $wrk1; // Build final SQL
            if ($wrk2 != "") {
                $wrk = ($wrk != "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
            }
        } else {
            $fldVal = $this->convertSearchValue($fld, $fldVal);
            $fldVal2 = $this->convertSearchValue($fld, $fldVal2);
            $wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
        }
        AddFilter($where, $wrk);
    }

    // Convert search value
    protected function convertSearchValue(&$fld, $fldVal)
    {
        if ($fldVal == Config("NULL_VALUE") || $fldVal == Config("NOT_NULL_VALUE")) {
            return $fldVal;
        }
        $value = $fldVal;
        if ($fld->isBoolean()) {
            if ($fldVal != "") {
                $value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
            }
        } elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
            if ($fldVal != "") {
                $value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
            }
        }
        return $value;
    }

    // Return basic search SQL
    protected function basicSearchSql($arKeywords, $type)
    {
        $where = "";
        $this->buildBasicSearchSql($where, $this->datang_catatan, $arKeywords, $type);
        return $where;
    }

    // Build basic search SQL
    protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
    {
        $defCond = ($type == "OR") ? "OR" : "AND";
        $arSql = []; // Array for SQL parts
        $arCond = []; // Array for search conditions
        $cnt = count($arKeywords);
        $j = 0; // Number of SQL parts
        for ($i = 0; $i < $cnt; $i++) {
            $keyword = $arKeywords[$i];
            $keyword = trim($keyword);
            if (Config("BASIC_SEARCH_IGNORE_PATTERN") != "") {
                $keyword = preg_replace(Config("BASIC_SEARCH_IGNORE_PATTERN"), "\\", $keyword);
                $ar = explode("\\", $keyword);
            } else {
                $ar = [$keyword];
            }
            foreach ($ar as $keyword) {
                if ($keyword != "") {
                    $wrk = "";
                    if ($keyword == "OR" && $type == "") {
                        if ($j > 0) {
                            $arCond[$j - 1] = "OR";
                        }
                    } elseif ($keyword == Config("NULL_VALUE")) {
                        $wrk = $fld->Expression . " IS NULL";
                    } elseif ($keyword == Config("NOT_NULL_VALUE")) {
                        $wrk = $fld->Expression . " IS NOT NULL";
                    } elseif ($fld->IsVirtual) {
                        $wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
                    } elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
                        $wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
                    }
                    if ($wrk != "") {
                        $arSql[$j] = $wrk;
                        $arCond[$j] = $defCond;
                        $j += 1;
                    }
                }
            }
        }
        $cnt = count($arSql);
        $quoted = false;
        $sql = "";
        if ($cnt > 0) {
            for ($i = 0; $i < $cnt - 1; $i++) {
                if ($arCond[$i] == "OR") {
                    if (!$quoted) {
                        $sql .= "(";
                    }
                    $quoted = true;
                }
                $sql .= $arSql[$i];
                if ($quoted && $arCond[$i] != "OR") {
                    $sql .= ")";
                    $quoted = false;
                }
                $sql .= " " . $arCond[$i] . " ";
            }
            $sql .= $arSql[$cnt - 1];
            if ($quoted) {
                $sql .= ")";
            }
        }
        if ($sql != "") {
            if ($where != "") {
                $where .= " OR ";
            }
            $where .= "(" . $sql . ")";
        }
    }

    // Return basic search WHERE clause based on search keyword and type
    protected function basicSearchWhere($default = false)
    {
        global $Security;
        $searchStr = "";
        if (!$Security->canSearch()) {
            return "";
        }
        $searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
        $searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

        // Get search SQL
        if ($searchKeyword != "") {
            $ar = $this->BasicSearch->keywordList($default);
            // Search keyword in any fields
            if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
                foreach ($ar as $keyword) {
                    if ($keyword != "") {
                        if ($searchStr != "") {
                            $searchStr .= " " . $searchType . " ";
                        }
                        $searchStr .= "(" . $this->basicSearchSql([$keyword], $searchType) . ")";
                    }
                }
            } else {
                $searchStr = $this->basicSearchSql($ar, $searchType);
            }
            if (!$default && in_array($this->Command, ["", "reset", "resetall"])) {
                $this->Command = "search";
            }
        }
        if (!$default && $this->Command == "search") {
            $this->BasicSearch->setKeyword($searchKeyword);
            $this->BasicSearch->setType($searchType);
        }
        return $searchStr;
    }

    // Check if search parm exists
    protected function checkSearchParms()
    {
        // Check basic search
        if ($this->BasicSearch->issetSession()) {
            return true;
        }
        if ($this->datang_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_petugas->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_tanggal->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_varietas->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_sup->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_timbang1->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_timbang2->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_timbang3->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_timbang4->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_timbang5->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_timbang6->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_timbang7->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_timbang8->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_timbang9->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_timbang10->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_timbang11->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_timbang12->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_timbang13->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_timbang14->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_timbang15->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_timbang16->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_timbang17->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_timbang18->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_timbang19->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_timbang20->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_timbang21->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_timbang22->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_timbang23->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_timbang24->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_timbang25->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_jumlah->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_jumlah_karung->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_berat_bersih->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datang_catatan->AdvancedSearch->issetSession()) {
            return true;
        }
        return false;
    }

    // Clear all search parameters
    protected function resetSearchParms()
    {
        // Clear search WHERE clause
        $this->SearchWhere = "";
        $this->setSearchWhere($this->SearchWhere);

        // Clear basic search parameters
        $this->resetBasicSearchParms();

        // Clear advanced search parameters
        $this->resetAdvancedSearchParms();
    }

    // Load advanced search default values
    protected function loadAdvancedSearchDefault()
    {
        return false;
    }

    // Clear all basic search parameters
    protected function resetBasicSearchParms()
    {
        $this->BasicSearch->unsetSession();
    }

    // Clear all advanced search parameters
    protected function resetAdvancedSearchParms()
    {
                $this->datang_id->AdvancedSearch->unsetSession();
                $this->datang_petugas->AdvancedSearch->unsetSession();
                $this->datang_tanggal->AdvancedSearch->unsetSession();
                $this->datang_varietas->AdvancedSearch->unsetSession();
                $this->datang_sup->AdvancedSearch->unsetSession();
                $this->datang_timbang1->AdvancedSearch->unsetSession();
                $this->datang_timbang2->AdvancedSearch->unsetSession();
                $this->datang_timbang3->AdvancedSearch->unsetSession();
                $this->datang_timbang4->AdvancedSearch->unsetSession();
                $this->datang_timbang5->AdvancedSearch->unsetSession();
                $this->datang_timbang6->AdvancedSearch->unsetSession();
                $this->datang_timbang7->AdvancedSearch->unsetSession();
                $this->datang_timbang8->AdvancedSearch->unsetSession();
                $this->datang_timbang9->AdvancedSearch->unsetSession();
                $this->datang_timbang10->AdvancedSearch->unsetSession();
                $this->datang_timbang11->AdvancedSearch->unsetSession();
                $this->datang_timbang12->AdvancedSearch->unsetSession();
                $this->datang_timbang13->AdvancedSearch->unsetSession();
                $this->datang_timbang14->AdvancedSearch->unsetSession();
                $this->datang_timbang15->AdvancedSearch->unsetSession();
                $this->datang_timbang16->AdvancedSearch->unsetSession();
                $this->datang_timbang17->AdvancedSearch->unsetSession();
                $this->datang_timbang18->AdvancedSearch->unsetSession();
                $this->datang_timbang19->AdvancedSearch->unsetSession();
                $this->datang_timbang20->AdvancedSearch->unsetSession();
                $this->datang_timbang21->AdvancedSearch->unsetSession();
                $this->datang_timbang22->AdvancedSearch->unsetSession();
                $this->datang_timbang23->AdvancedSearch->unsetSession();
                $this->datang_timbang24->AdvancedSearch->unsetSession();
                $this->datang_timbang25->AdvancedSearch->unsetSession();
                $this->datang_jumlah->AdvancedSearch->unsetSession();
                $this->datang_jumlah_karung->AdvancedSearch->unsetSession();
                $this->datang_berat_bersih->AdvancedSearch->unsetSession();
                $this->datang_catatan->AdvancedSearch->unsetSession();
    }

    // Restore all search parameters
    protected function restoreSearchParms()
    {
        $this->RestoreSearch = true;

        // Restore basic search values
        $this->BasicSearch->load();

        // Restore advanced search values
                $this->datang_id->AdvancedSearch->load();
                $this->datang_petugas->AdvancedSearch->load();
                $this->datang_tanggal->AdvancedSearch->load();
                $this->datang_varietas->AdvancedSearch->load();
                $this->datang_sup->AdvancedSearch->load();
                $this->datang_timbang1->AdvancedSearch->load();
                $this->datang_timbang2->AdvancedSearch->load();
                $this->datang_timbang3->AdvancedSearch->load();
                $this->datang_timbang4->AdvancedSearch->load();
                $this->datang_timbang5->AdvancedSearch->load();
                $this->datang_timbang6->AdvancedSearch->load();
                $this->datang_timbang7->AdvancedSearch->load();
                $this->datang_timbang8->AdvancedSearch->load();
                $this->datang_timbang9->AdvancedSearch->load();
                $this->datang_timbang10->AdvancedSearch->load();
                $this->datang_timbang11->AdvancedSearch->load();
                $this->datang_timbang12->AdvancedSearch->load();
                $this->datang_timbang13->AdvancedSearch->load();
                $this->datang_timbang14->AdvancedSearch->load();
                $this->datang_timbang15->AdvancedSearch->load();
                $this->datang_timbang16->AdvancedSearch->load();
                $this->datang_timbang17->AdvancedSearch->load();
                $this->datang_timbang18->AdvancedSearch->load();
                $this->datang_timbang19->AdvancedSearch->load();
                $this->datang_timbang20->AdvancedSearch->load();
                $this->datang_timbang21->AdvancedSearch->load();
                $this->datang_timbang22->AdvancedSearch->load();
                $this->datang_timbang23->AdvancedSearch->load();
                $this->datang_timbang24->AdvancedSearch->load();
                $this->datang_timbang25->AdvancedSearch->load();
                $this->datang_jumlah->AdvancedSearch->load();
                $this->datang_jumlah_karung->AdvancedSearch->load();
                $this->datang_berat_bersih->AdvancedSearch->load();
                $this->datang_catatan->AdvancedSearch->load();
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->updateSort($this->datang_id); // datang_id
            $this->updateSort($this->datang_petugas); // datang_petugas
            $this->updateSort($this->datang_tanggal); // datang_tanggal
            $this->updateSort($this->datang_varietas); // datang_varietas
            $this->updateSort($this->datang_sup); // datang_sup
            $this->updateSort($this->datang_timbang1); // datang_timbang1
            $this->updateSort($this->datang_timbang2); // datang_timbang2
            $this->updateSort($this->datang_timbang3); // datang_timbang3
            $this->updateSort($this->datang_timbang4); // datang_timbang4
            $this->updateSort($this->datang_timbang5); // datang_timbang5
            $this->updateSort($this->datang_timbang6); // datang_timbang6
            $this->updateSort($this->datang_timbang7); // datang_timbang7
            $this->updateSort($this->datang_timbang8); // datang_timbang8
            $this->updateSort($this->datang_timbang9); // datang_timbang9
            $this->updateSort($this->datang_timbang10); // datang_timbang10
            $this->updateSort($this->datang_timbang11); // datang_timbang11
            $this->updateSort($this->datang_timbang12); // datang_timbang12
            $this->updateSort($this->datang_timbang13); // datang_timbang13
            $this->updateSort($this->datang_timbang14); // datang_timbang14
            $this->updateSort($this->datang_timbang15); // datang_timbang15
            $this->updateSort($this->datang_timbang16); // datang_timbang16
            $this->updateSort($this->datang_timbang17); // datang_timbang17
            $this->updateSort($this->datang_timbang18); // datang_timbang18
            $this->updateSort($this->datang_timbang19); // datang_timbang19
            $this->updateSort($this->datang_timbang20); // datang_timbang20
            $this->updateSort($this->datang_timbang21); // datang_timbang21
            $this->updateSort($this->datang_timbang22); // datang_timbang22
            $this->updateSort($this->datang_timbang23); // datang_timbang23
            $this->updateSort($this->datang_timbang24); // datang_timbang24
            $this->updateSort($this->datang_timbang25); // datang_timbang25
            $this->updateSort($this->datang_jumlah); // datang_jumlah
            $this->updateSort($this->datang_jumlah_karung); // datang_jumlah_karung
            $this->updateSort($this->datang_berat_bersih); // datang_berat_bersih
            $this->updateSort($this->datang_catatan); // datang_catatan
            $this->setStartRecordNumber(1); // Reset start position
        }
    }

    // Load sort order parameters
    protected function loadSortOrder()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        if ($orderBy == "") {
            $this->DefaultSort = "";
            if ($this->getSqlOrderBy() != "") {
                $useDefaultSort = true;
                if ($useDefaultSort) {
                    $orderBy = $this->getSqlOrderBy();
                    $this->setSessionOrderBy($orderBy);
                } else {
                    $this->setSessionOrderBy("");
                }
            }
        }
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset search criteria
            if ($this->Command == "reset" || $this->Command == "resetall") {
                $this->resetSearchParms();
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->datang_id->setSort("");
                $this->datang_petugas->setSort("");
                $this->datang_tanggal->setSort("");
                $this->datang_varietas->setSort("");
                $this->datang_sup->setSort("");
                $this->datang_timbang1->setSort("");
                $this->datang_timbang2->setSort("");
                $this->datang_timbang3->setSort("");
                $this->datang_timbang4->setSort("");
                $this->datang_timbang5->setSort("");
                $this->datang_timbang6->setSort("");
                $this->datang_timbang7->setSort("");
                $this->datang_timbang8->setSort("");
                $this->datang_timbang9->setSort("");
                $this->datang_timbang10->setSort("");
                $this->datang_timbang11->setSort("");
                $this->datang_timbang12->setSort("");
                $this->datang_timbang13->setSort("");
                $this->datang_timbang14->setSort("");
                $this->datang_timbang15->setSort("");
                $this->datang_timbang16->setSort("");
                $this->datang_timbang17->setSort("");
                $this->datang_timbang18->setSort("");
                $this->datang_timbang19->setSort("");
                $this->datang_timbang20->setSort("");
                $this->datang_timbang21->setSort("");
                $this->datang_timbang22->setSort("");
                $this->datang_timbang23->setSort("");
                $this->datang_timbang24->setSort("");
                $this->datang_timbang25->setSort("");
                $this->datang_jumlah->setSort("");
                $this->datang_jumlah_karung->setSort("");
                $this->datang_berat_bersih->setSort("");
                $this->datang_catatan->setSort("");
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // "griddelete"
        if ($this->AllowAddDeleteRow) {
            $item = &$this->ListOptions->add("griddelete");
            $item->CssClass = "text-nowrap";
            $item->OnLeft = false;
            $item->Visible = false; // Default hidden
        }

        // Add group option item
        $item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
        $item->Body = "";
        $item->OnLeft = false;
        $item->Visible = false;

        // List actions
        $item = &$this->ListOptions->add("listactions");
        $item->CssClass = "text-nowrap";
        $item->OnLeft = false;
        $item->Visible = false;
        $item->ShowInButtonGroup = false;
        $item->ShowInDropDown = false;

        // "checkbox"
        $item = &$this->ListOptions->add("checkbox");
        $item->Visible = false;
        $item->OnLeft = false;
        $item->Header = "<div class=\"custom-control custom-checkbox d-inline-block\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"custom-control-input\" onclick=\"ew.selectAllKey(this);\"><label class=\"custom-control-label\" for=\"key\"></label></div>";
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = false;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = false;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $this->setupListOptionsExt();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();

        // Set up row action and key
        $keyName = "";
        if ($CurrentForm && is_numeric($this->RowIndex) && $this->RowType != "view") {
            $CurrentForm->Index = $this->RowIndex;
            $actionName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormActionName);
            $oldKeyName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormOldKeyName);
            $keyName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormKeyName);
            $blankRowName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormBlankRowName);
            if ($this->RowAction != "") {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $actionName . "\" id=\"" . $actionName . "\" value=\"" . $this->RowAction . "\">";
            }
            if ($this->RowAction == "delete") {
                $rowkey = $CurrentForm->getValue($this->FormKeyName);
                $this->setupKeyValues($rowkey);
                // Reload hidden key for delete
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $keyName . "\" id=\"" . $keyName . "\" value=\"" . HtmlEncode($rowkey) . "\">";
            }
            if ($this->RowAction == "insert" && $this->isConfirm() && $this->emptyRow()) {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $blankRowName . "\" id=\"" . $blankRowName . "\" value=\"1\">";
            }
        }

        // "delete"
        if ($this->AllowAddDeleteRow) {
            if ($this->isGridAdd() || $this->isGridEdit()) {
                $options = &$this->ListOptions;
                $options->UseButtonGroup = true; // Use button group for grid delete button
                $opt = $options["griddelete"];
                if (is_numeric($this->RowIndex) && ($this->RowAction == "" || $this->RowAction == "edit")) { // Do not allow delete existing record
                    $opt->Body = "&nbsp;";
                } else {
                    $opt->Body = "<a class=\"ew-grid-link ew-grid-delete\" title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" onclick=\"return ew.deleteGridRow(this, " . $this->RowIndex . ");\">" . $Language->phrase("DeleteLink") . "</a>";
                }
            }
        }
        $pageUrl = $this->pageUrl();
        if ($this->CurrentMode == "view") { // View mode
        } // End View mode

        // Set up list action buttons
        $opt = $this->ListOptions["listactions"];
        if ($opt && !$this->isExport() && !$this->CurrentAction) {
            $body = "";
            $links = [];
            foreach ($this->ListActions->Items as $listaction) {
                if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
                    $action = $listaction->Action;
                    $caption = $listaction->Caption;
                    $icon = ($listaction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
                    $links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(true) . "}," . $listaction->toJson(true) . "));\">" . $icon . $listaction->Caption . "</a></li>";
                    if (count($links) == 1) { // Single button
                        $body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(true) . "}," . $listaction->toJson(true) . "));\">" . $icon . $listaction->Caption . "</a>";
                    }
                }
            }
            if (count($links) > 1) { // More than one buttons, use dropdown
                $body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
                $content = "";
                foreach ($links as $link) {
                    $content .= "<li>" . $link . "</li>";
                }
                $body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">" . $content . "</ul>";
                $body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
            }
            if (count($links) > 0) {
                $opt->Body = $body;
                $opt->Visible = true;
            }
        }

        // "checkbox"
        $opt = $this->ListOptions["checkbox"];
        $opt->Body = "<div class=\"custom-control custom-checkbox d-inline-block\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"custom-control-input ew-multi-select\" value=\"" . HtmlEncode($this->datang_id->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\"><label class=\"custom-control-label\" for=\"key_m_" . $this->RowCount . "\"></label></div>";
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["addedit"];

        // Add
        $item = &$option->add("add");
        $addcaption = HtmlTitle($Language->phrase("AddLink"));
        $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("AddLink") . "</a>";
        $item->Visible = $this->AddUrl != "" && $Security->canAdd();
        $item = &$option->add("gridadd");
        $item->Body = "<a class=\"ew-add-edit ew-grid-add\" title=\"" . HtmlTitle($Language->phrase("GridAddLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("GridAddLink")) . "\" href=\"" . HtmlEncode(GetUrl($this->GridAddUrl)) . "\">" . $Language->phrase("GridAddLink") . "</a>";
        $item->Visible = $this->GridAddUrl != "" && $Security->canAdd();
        $option = $options["action"];

        // Set up options default
        foreach ($options as $option) {
            $option->UseDropDownButton = false;
            $option->UseButtonGroup = true;
            //$option->ButtonClass = ""; // Class for button group
            $item = &$option->add($option->GroupOptionName);
            $item->Body = "";
            $item->Visible = false;
        }
        $options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fkedatanganlistsrch\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fkedatanganlistsrch\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
        $item->Body = "";
        $item->Visible = false;
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        if (!$this->isGridAdd() && !$this->isGridEdit()) { // Not grid add/edit mode
            $option = $options["action"];
            // Set up list action buttons
            foreach ($this->ListActions->Items as $listaction) {
                if ($listaction->Select == ACTION_MULTIPLE) {
                    $item = &$option->add("custom_" . $listaction->Action);
                    $caption = $listaction->Caption;
                    $icon = ($listaction->Icon != "") ? '<i class="' . HtmlEncode($listaction->Icon) . '" data-caption="' . HtmlEncode($caption) . '"></i>' . $caption : $caption;
                    $item->Body = '<a class="ew-action ew-list-action" title="' . HtmlEncode($caption) . '" data-caption="' . HtmlEncode($caption) . '" href="#" onclick="return ew.submitAction(event,jQuery.extend({f:document.fkedatanganlist},' . $listaction->toJson(true) . '));">' . $icon . '</a>';
                    $item->Visible = $listaction->Allow;
                }
            }

            // Hide grid edit and other options
            if ($this->TotalRecords <= 0) {
                $option = $options["addedit"];
                $item = $option["gridedit"];
                if ($item) {
                    $item->Visible = false;
                }
                $option = $options["action"];
                $option->hideAllOptions();
            }
        } else { // Grid add/edit mode
            // Hide all options first
            foreach ($options as $option) {
                $option->hideAllOptions();
            }
            $pageUrl = $this->pageUrl();

            // Grid-Add
            if ($this->isGridAdd()) {
                if ($this->AllowAddDeleteRow) {
                    // Add add blank row
                    $option = $options["addedit"];
                    $option->UseDropDownButton = false;
                    $item = &$option->add("addblankrow");
                    $item->Body = "<a class=\"ew-add-edit ew-add-blank-row\" title=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" href=\"#\" onclick=\"return ew.addGridRow(this);\">" . $Language->phrase("AddBlankRow") . "</a>";
                    $item->Visible = $Security->canAdd();
                }
                $option = $options["action"];
                $option->UseDropDownButton = false;
                // Add grid insert
                $item = &$option->add("gridinsert");
                $item->Body = "<a class=\"ew-action ew-grid-insert\" title=\"" . HtmlTitle($Language->phrase("GridInsertLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("GridInsertLink")) . "\" href=\"#\" onclick=\"return ew.forms.get(this).submit('" . $this->pageName() . "');\">" . $Language->phrase("GridInsertLink") . "</a>";
                // Add grid cancel
                $item = &$option->add("gridcancel");
                $cancelurl = $this->addMasterUrl($pageUrl . "action=cancel");
                $item->Body = "<a class=\"ew-action ew-grid-cancel\" title=\"" . HtmlTitle($Language->phrase("GridCancelLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("GridCancelLink")) . "\" href=\"" . $cancelurl . "\">" . $Language->phrase("GridCancelLink") . "</a>";
            }
        }
    }

    // Process list action
    protected function processListAction()
    {
        global $Language, $Security;
        $userlist = "";
        $user = "";
        $filter = $this->getFilterFromRecordKeys();
        $userAction = Post("useraction", "");
        if ($filter != "" && $userAction != "") {
            // Check permission first
            $actionCaption = $userAction;
            if (array_key_exists($userAction, $this->ListActions->Items)) {
                $actionCaption = $this->ListActions[$userAction]->Caption;
                if (!$this->ListActions[$userAction]->Allow) {
                    $errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
                    if (Post("ajax") == $userAction) { // Ajax
                        echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                        return true;
                    } else {
                        $this->setFailureMessage($errmsg);
                        return false;
                    }
                }
            }
            $this->CurrentFilter = $filter;
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = LoadRecordset($sql, $conn, \PDO::FETCH_ASSOC);
            $this->CurrentAction = $userAction;

            // Call row action event
            if ($rs) {
                $conn->beginTransaction();
                $this->SelectedCount = $rs->recordCount();
                $this->SelectedIndex = 0;
                while (!$rs->EOF) {
                    $this->SelectedIndex++;
                    $row = $rs->fields;
                    $processed = $this->rowCustomAction($userAction, $row);
                    if (!$processed) {
                        break;
                    }
                    $rs->moveNext();
                }
                if ($processed) {
                    $conn->commit(); // Commit the changes
                    if ($this->getSuccessMessage() == "" && !ob_get_length()) { // No output
                        $this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
                    }
                } else {
                    $conn->rollback(); // Rollback changes

                    // Set up error message
                    if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                        // Use the message, do nothing
                    } elseif ($this->CancelMessage != "") {
                        $this->setFailureMessage($this->CancelMessage);
                        $this->CancelMessage = "";
                    } else {
                        $this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
                    }
                }
            }
            if ($rs) {
                $rs->close();
            }
            $this->CurrentAction = ""; // Clear action
            if (Post("ajax") == $userAction) { // Ajax
                if ($this->getSuccessMessage() != "") {
                    echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
                    $this->clearSuccessMessage(); // Clear message
                }
                if ($this->getFailureMessage() != "") {
                    echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
                    $this->clearFailureMessage(); // Clear message
                }
                return true;
            }
        }
        return false; // Not ajax request
    }

    // Set up list options (extended codes)
    protected function setupListOptionsExt()
    {
    }

    // Render list options (extended codes)
    protected function renderListOptionsExt()
    {
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->datang_id->CurrentValue = null;
        $this->datang_id->OldValue = $this->datang_id->CurrentValue;
        $this->datang_petugas->CurrentValue = null;
        $this->datang_petugas->OldValue = $this->datang_petugas->CurrentValue;
        $this->datang_tanggal->CurrentValue = null;
        $this->datang_tanggal->OldValue = $this->datang_tanggal->CurrentValue;
        $this->datang_varietas->CurrentValue = null;
        $this->datang_varietas->OldValue = $this->datang_varietas->CurrentValue;
        $this->datang_sup->CurrentValue = null;
        $this->datang_sup->OldValue = $this->datang_sup->CurrentValue;
        $this->datang_timbang1->CurrentValue = 0;
        $this->datang_timbang1->OldValue = $this->datang_timbang1->CurrentValue;
        $this->datang_timbang2->CurrentValue = 0;
        $this->datang_timbang2->OldValue = $this->datang_timbang2->CurrentValue;
        $this->datang_timbang3->CurrentValue = 0;
        $this->datang_timbang3->OldValue = $this->datang_timbang3->CurrentValue;
        $this->datang_timbang4->CurrentValue = 0;
        $this->datang_timbang4->OldValue = $this->datang_timbang4->CurrentValue;
        $this->datang_timbang5->CurrentValue = 0;
        $this->datang_timbang5->OldValue = $this->datang_timbang5->CurrentValue;
        $this->datang_timbang6->CurrentValue = 0;
        $this->datang_timbang6->OldValue = $this->datang_timbang6->CurrentValue;
        $this->datang_timbang7->CurrentValue = 0;
        $this->datang_timbang7->OldValue = $this->datang_timbang7->CurrentValue;
        $this->datang_timbang8->CurrentValue = 0;
        $this->datang_timbang8->OldValue = $this->datang_timbang8->CurrentValue;
        $this->datang_timbang9->CurrentValue = 0;
        $this->datang_timbang9->OldValue = $this->datang_timbang9->CurrentValue;
        $this->datang_timbang10->CurrentValue = 0;
        $this->datang_timbang10->OldValue = $this->datang_timbang10->CurrentValue;
        $this->datang_timbang11->CurrentValue = 0;
        $this->datang_timbang11->OldValue = $this->datang_timbang11->CurrentValue;
        $this->datang_timbang12->CurrentValue = 0;
        $this->datang_timbang12->OldValue = $this->datang_timbang12->CurrentValue;
        $this->datang_timbang13->CurrentValue = 0;
        $this->datang_timbang13->OldValue = $this->datang_timbang13->CurrentValue;
        $this->datang_timbang14->CurrentValue = 0;
        $this->datang_timbang14->OldValue = $this->datang_timbang14->CurrentValue;
        $this->datang_timbang15->CurrentValue = 0;
        $this->datang_timbang15->OldValue = $this->datang_timbang15->CurrentValue;
        $this->datang_timbang16->CurrentValue = 0;
        $this->datang_timbang16->OldValue = $this->datang_timbang16->CurrentValue;
        $this->datang_timbang17->CurrentValue = 0;
        $this->datang_timbang17->OldValue = $this->datang_timbang17->CurrentValue;
        $this->datang_timbang18->CurrentValue = 0;
        $this->datang_timbang18->OldValue = $this->datang_timbang18->CurrentValue;
        $this->datang_timbang19->CurrentValue = 0;
        $this->datang_timbang19->OldValue = $this->datang_timbang19->CurrentValue;
        $this->datang_timbang20->CurrentValue = 0;
        $this->datang_timbang20->OldValue = $this->datang_timbang20->CurrentValue;
        $this->datang_timbang21->CurrentValue = 0;
        $this->datang_timbang21->OldValue = $this->datang_timbang21->CurrentValue;
        $this->datang_timbang22->CurrentValue = 0;
        $this->datang_timbang22->OldValue = $this->datang_timbang22->CurrentValue;
        $this->datang_timbang23->CurrentValue = 0;
        $this->datang_timbang23->OldValue = $this->datang_timbang23->CurrentValue;
        $this->datang_timbang24->CurrentValue = 0;
        $this->datang_timbang24->OldValue = $this->datang_timbang24->CurrentValue;
        $this->datang_timbang25->CurrentValue = 0;
        $this->datang_timbang25->OldValue = $this->datang_timbang25->CurrentValue;
        $this->datang_jumlah->CurrentValue = null;
        $this->datang_jumlah->OldValue = $this->datang_jumlah->CurrentValue;
        $this->datang_jumlah_karung->CurrentValue = 0;
        $this->datang_jumlah_karung->OldValue = $this->datang_jumlah_karung->CurrentValue;
        $this->datang_berat_bersih->CurrentValue = null;
        $this->datang_berat_bersih->OldValue = $this->datang_berat_bersih->CurrentValue;
        $this->datang_catatan->CurrentValue = null;
        $this->datang_catatan->OldValue = $this->datang_catatan->CurrentValue;
    }

    // Load basic search values
    protected function loadBasicSearchValues()
    {
        $this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), false);
        if ($this->BasicSearch->Keyword != "" && $this->Command == "") {
            $this->Command = "search";
        }
        $this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), false);
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // datang_id
        if (!$this->isAddOrEdit() && $this->datang_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_id->AdvancedSearch->SearchValue != "" || $this->datang_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_petugas
        if (!$this->isAddOrEdit() && $this->datang_petugas->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_petugas->AdvancedSearch->SearchValue != "" || $this->datang_petugas->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_tanggal
        if (!$this->isAddOrEdit() && $this->datang_tanggal->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_tanggal->AdvancedSearch->SearchValue != "" || $this->datang_tanggal->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_varietas
        if (!$this->isAddOrEdit() && $this->datang_varietas->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_varietas->AdvancedSearch->SearchValue != "" || $this->datang_varietas->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_sup
        if (!$this->isAddOrEdit() && $this->datang_sup->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_sup->AdvancedSearch->SearchValue != "" || $this->datang_sup->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_timbang1
        if (!$this->isAddOrEdit() && $this->datang_timbang1->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_timbang1->AdvancedSearch->SearchValue != "" || $this->datang_timbang1->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_timbang2
        if (!$this->isAddOrEdit() && $this->datang_timbang2->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_timbang2->AdvancedSearch->SearchValue != "" || $this->datang_timbang2->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_timbang3
        if (!$this->isAddOrEdit() && $this->datang_timbang3->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_timbang3->AdvancedSearch->SearchValue != "" || $this->datang_timbang3->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_timbang4
        if (!$this->isAddOrEdit() && $this->datang_timbang4->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_timbang4->AdvancedSearch->SearchValue != "" || $this->datang_timbang4->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_timbang5
        if (!$this->isAddOrEdit() && $this->datang_timbang5->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_timbang5->AdvancedSearch->SearchValue != "" || $this->datang_timbang5->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_timbang6
        if (!$this->isAddOrEdit() && $this->datang_timbang6->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_timbang6->AdvancedSearch->SearchValue != "" || $this->datang_timbang6->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_timbang7
        if (!$this->isAddOrEdit() && $this->datang_timbang7->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_timbang7->AdvancedSearch->SearchValue != "" || $this->datang_timbang7->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_timbang8
        if (!$this->isAddOrEdit() && $this->datang_timbang8->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_timbang8->AdvancedSearch->SearchValue != "" || $this->datang_timbang8->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_timbang9
        if (!$this->isAddOrEdit() && $this->datang_timbang9->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_timbang9->AdvancedSearch->SearchValue != "" || $this->datang_timbang9->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_timbang10
        if (!$this->isAddOrEdit() && $this->datang_timbang10->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_timbang10->AdvancedSearch->SearchValue != "" || $this->datang_timbang10->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_timbang11
        if (!$this->isAddOrEdit() && $this->datang_timbang11->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_timbang11->AdvancedSearch->SearchValue != "" || $this->datang_timbang11->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_timbang12
        if (!$this->isAddOrEdit() && $this->datang_timbang12->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_timbang12->AdvancedSearch->SearchValue != "" || $this->datang_timbang12->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_timbang13
        if (!$this->isAddOrEdit() && $this->datang_timbang13->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_timbang13->AdvancedSearch->SearchValue != "" || $this->datang_timbang13->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_timbang14
        if (!$this->isAddOrEdit() && $this->datang_timbang14->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_timbang14->AdvancedSearch->SearchValue != "" || $this->datang_timbang14->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_timbang15
        if (!$this->isAddOrEdit() && $this->datang_timbang15->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_timbang15->AdvancedSearch->SearchValue != "" || $this->datang_timbang15->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_timbang16
        if (!$this->isAddOrEdit() && $this->datang_timbang16->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_timbang16->AdvancedSearch->SearchValue != "" || $this->datang_timbang16->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_timbang17
        if (!$this->isAddOrEdit() && $this->datang_timbang17->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_timbang17->AdvancedSearch->SearchValue != "" || $this->datang_timbang17->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_timbang18
        if (!$this->isAddOrEdit() && $this->datang_timbang18->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_timbang18->AdvancedSearch->SearchValue != "" || $this->datang_timbang18->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_timbang19
        if (!$this->isAddOrEdit() && $this->datang_timbang19->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_timbang19->AdvancedSearch->SearchValue != "" || $this->datang_timbang19->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_timbang20
        if (!$this->isAddOrEdit() && $this->datang_timbang20->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_timbang20->AdvancedSearch->SearchValue != "" || $this->datang_timbang20->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_timbang21
        if (!$this->isAddOrEdit() && $this->datang_timbang21->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_timbang21->AdvancedSearch->SearchValue != "" || $this->datang_timbang21->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_timbang22
        if (!$this->isAddOrEdit() && $this->datang_timbang22->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_timbang22->AdvancedSearch->SearchValue != "" || $this->datang_timbang22->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_timbang23
        if (!$this->isAddOrEdit() && $this->datang_timbang23->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_timbang23->AdvancedSearch->SearchValue != "" || $this->datang_timbang23->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_timbang24
        if (!$this->isAddOrEdit() && $this->datang_timbang24->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_timbang24->AdvancedSearch->SearchValue != "" || $this->datang_timbang24->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_timbang25
        if (!$this->isAddOrEdit() && $this->datang_timbang25->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_timbang25->AdvancedSearch->SearchValue != "" || $this->datang_timbang25->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_jumlah
        if (!$this->isAddOrEdit() && $this->datang_jumlah->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_jumlah->AdvancedSearch->SearchValue != "" || $this->datang_jumlah->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_jumlah_karung
        if (!$this->isAddOrEdit() && $this->datang_jumlah_karung->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_jumlah_karung->AdvancedSearch->SearchValue != "" || $this->datang_jumlah_karung->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_berat_bersih
        if (!$this->isAddOrEdit() && $this->datang_berat_bersih->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_berat_bersih->AdvancedSearch->SearchValue != "" || $this->datang_berat_bersih->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datang_catatan
        if (!$this->isAddOrEdit() && $this->datang_catatan->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datang_catatan->AdvancedSearch->SearchValue != "" || $this->datang_catatan->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        return $hasValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;

        // Check field name 'datang_id' first before field var 'x_datang_id'
        $val = $CurrentForm->hasValue("datang_id") ? $CurrentForm->getValue("datang_id") : $CurrentForm->getValue("x_datang_id");
        if (!$this->datang_id->IsDetailKey && !$this->isGridAdd() && !$this->isAdd()) {
            $this->datang_id->setFormValue($val);
        }

        // Check field name 'datang_petugas' first before field var 'x_datang_petugas'
        $val = $CurrentForm->hasValue("datang_petugas") ? $CurrentForm->getValue("datang_petugas") : $CurrentForm->getValue("x_datang_petugas");
        if (!$this->datang_petugas->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_petugas->Visible = false; // Disable update for API request
            } else {
                $this->datang_petugas->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_datang_petugas")) {
            $this->datang_petugas->setOldValue($CurrentForm->getValue("o_datang_petugas"));
        }

        // Check field name 'datang_tanggal' first before field var 'x_datang_tanggal'
        $val = $CurrentForm->hasValue("datang_tanggal") ? $CurrentForm->getValue("datang_tanggal") : $CurrentForm->getValue("x_datang_tanggal");
        if (!$this->datang_tanggal->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_tanggal->Visible = false; // Disable update for API request
            } else {
                $this->datang_tanggal->setFormValue($val);
            }
            $this->datang_tanggal->CurrentValue = UnFormatDateTime($this->datang_tanggal->CurrentValue, 0);
        }
        if ($CurrentForm->hasValue("o_datang_tanggal")) {
            $this->datang_tanggal->setOldValue($CurrentForm->getValue("o_datang_tanggal"));
        }

        // Check field name 'datang_varietas' first before field var 'x_datang_varietas'
        $val = $CurrentForm->hasValue("datang_varietas") ? $CurrentForm->getValue("datang_varietas") : $CurrentForm->getValue("x_datang_varietas");
        if (!$this->datang_varietas->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_varietas->Visible = false; // Disable update for API request
            } else {
                $this->datang_varietas->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_datang_varietas")) {
            $this->datang_varietas->setOldValue($CurrentForm->getValue("o_datang_varietas"));
        }

        // Check field name 'datang_sup' first before field var 'x_datang_sup'
        $val = $CurrentForm->hasValue("datang_sup") ? $CurrentForm->getValue("datang_sup") : $CurrentForm->getValue("x_datang_sup");
        if (!$this->datang_sup->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_sup->Visible = false; // Disable update for API request
            } else {
                $this->datang_sup->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_datang_sup")) {
            $this->datang_sup->setOldValue($CurrentForm->getValue("o_datang_sup"));
        }

        // Check field name 'datang_timbang1' first before field var 'x_datang_timbang1'
        $val = $CurrentForm->hasValue("datang_timbang1") ? $CurrentForm->getValue("datang_timbang1") : $CurrentForm->getValue("x_datang_timbang1");
        if (!$this->datang_timbang1->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_timbang1->Visible = false; // Disable update for API request
            } else {
                $this->datang_timbang1->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_datang_timbang1")) {
            $this->datang_timbang1->setOldValue($CurrentForm->getValue("o_datang_timbang1"));
        }

        // Check field name 'datang_timbang2' first before field var 'x_datang_timbang2'
        $val = $CurrentForm->hasValue("datang_timbang2") ? $CurrentForm->getValue("datang_timbang2") : $CurrentForm->getValue("x_datang_timbang2");
        if (!$this->datang_timbang2->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_timbang2->Visible = false; // Disable update for API request
            } else {
                $this->datang_timbang2->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_datang_timbang2")) {
            $this->datang_timbang2->setOldValue($CurrentForm->getValue("o_datang_timbang2"));
        }

        // Check field name 'datang_timbang3' first before field var 'x_datang_timbang3'
        $val = $CurrentForm->hasValue("datang_timbang3") ? $CurrentForm->getValue("datang_timbang3") : $CurrentForm->getValue("x_datang_timbang3");
        if (!$this->datang_timbang3->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_timbang3->Visible = false; // Disable update for API request
            } else {
                $this->datang_timbang3->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_datang_timbang3")) {
            $this->datang_timbang3->setOldValue($CurrentForm->getValue("o_datang_timbang3"));
        }

        // Check field name 'datang_timbang4' first before field var 'x_datang_timbang4'
        $val = $CurrentForm->hasValue("datang_timbang4") ? $CurrentForm->getValue("datang_timbang4") : $CurrentForm->getValue("x_datang_timbang4");
        if (!$this->datang_timbang4->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_timbang4->Visible = false; // Disable update for API request
            } else {
                $this->datang_timbang4->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_datang_timbang4")) {
            $this->datang_timbang4->setOldValue($CurrentForm->getValue("o_datang_timbang4"));
        }

        // Check field name 'datang_timbang5' first before field var 'x_datang_timbang5'
        $val = $CurrentForm->hasValue("datang_timbang5") ? $CurrentForm->getValue("datang_timbang5") : $CurrentForm->getValue("x_datang_timbang5");
        if (!$this->datang_timbang5->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_timbang5->Visible = false; // Disable update for API request
            } else {
                $this->datang_timbang5->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_datang_timbang5")) {
            $this->datang_timbang5->setOldValue($CurrentForm->getValue("o_datang_timbang5"));
        }

        // Check field name 'datang_timbang6' first before field var 'x_datang_timbang6'
        $val = $CurrentForm->hasValue("datang_timbang6") ? $CurrentForm->getValue("datang_timbang6") : $CurrentForm->getValue("x_datang_timbang6");
        if (!$this->datang_timbang6->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_timbang6->Visible = false; // Disable update for API request
            } else {
                $this->datang_timbang6->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_datang_timbang6")) {
            $this->datang_timbang6->setOldValue($CurrentForm->getValue("o_datang_timbang6"));
        }

        // Check field name 'datang_timbang7' first before field var 'x_datang_timbang7'
        $val = $CurrentForm->hasValue("datang_timbang7") ? $CurrentForm->getValue("datang_timbang7") : $CurrentForm->getValue("x_datang_timbang7");
        if (!$this->datang_timbang7->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_timbang7->Visible = false; // Disable update for API request
            } else {
                $this->datang_timbang7->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_datang_timbang7")) {
            $this->datang_timbang7->setOldValue($CurrentForm->getValue("o_datang_timbang7"));
        }

        // Check field name 'datang_timbang8' first before field var 'x_datang_timbang8'
        $val = $CurrentForm->hasValue("datang_timbang8") ? $CurrentForm->getValue("datang_timbang8") : $CurrentForm->getValue("x_datang_timbang8");
        if (!$this->datang_timbang8->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_timbang8->Visible = false; // Disable update for API request
            } else {
                $this->datang_timbang8->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_datang_timbang8")) {
            $this->datang_timbang8->setOldValue($CurrentForm->getValue("o_datang_timbang8"));
        }

        // Check field name 'datang_timbang9' first before field var 'x_datang_timbang9'
        $val = $CurrentForm->hasValue("datang_timbang9") ? $CurrentForm->getValue("datang_timbang9") : $CurrentForm->getValue("x_datang_timbang9");
        if (!$this->datang_timbang9->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_timbang9->Visible = false; // Disable update for API request
            } else {
                $this->datang_timbang9->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_datang_timbang9")) {
            $this->datang_timbang9->setOldValue($CurrentForm->getValue("o_datang_timbang9"));
        }

        // Check field name 'datang_timbang10' first before field var 'x_datang_timbang10'
        $val = $CurrentForm->hasValue("datang_timbang10") ? $CurrentForm->getValue("datang_timbang10") : $CurrentForm->getValue("x_datang_timbang10");
        if (!$this->datang_timbang10->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_timbang10->Visible = false; // Disable update for API request
            } else {
                $this->datang_timbang10->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_datang_timbang10")) {
            $this->datang_timbang10->setOldValue($CurrentForm->getValue("o_datang_timbang10"));
        }

        // Check field name 'datang_timbang11' first before field var 'x_datang_timbang11'
        $val = $CurrentForm->hasValue("datang_timbang11") ? $CurrentForm->getValue("datang_timbang11") : $CurrentForm->getValue("x_datang_timbang11");
        if (!$this->datang_timbang11->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_timbang11->Visible = false; // Disable update for API request
            } else {
                $this->datang_timbang11->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_datang_timbang11")) {
            $this->datang_timbang11->setOldValue($CurrentForm->getValue("o_datang_timbang11"));
        }

        // Check field name 'datang_timbang12' first before field var 'x_datang_timbang12'
        $val = $CurrentForm->hasValue("datang_timbang12") ? $CurrentForm->getValue("datang_timbang12") : $CurrentForm->getValue("x_datang_timbang12");
        if (!$this->datang_timbang12->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_timbang12->Visible = false; // Disable update for API request
            } else {
                $this->datang_timbang12->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_datang_timbang12")) {
            $this->datang_timbang12->setOldValue($CurrentForm->getValue("o_datang_timbang12"));
        }

        // Check field name 'datang_timbang13' first before field var 'x_datang_timbang13'
        $val = $CurrentForm->hasValue("datang_timbang13") ? $CurrentForm->getValue("datang_timbang13") : $CurrentForm->getValue("x_datang_timbang13");
        if (!$this->datang_timbang13->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_timbang13->Visible = false; // Disable update for API request
            } else {
                $this->datang_timbang13->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_datang_timbang13")) {
            $this->datang_timbang13->setOldValue($CurrentForm->getValue("o_datang_timbang13"));
        }

        // Check field name 'datang_timbang14' first before field var 'x_datang_timbang14'
        $val = $CurrentForm->hasValue("datang_timbang14") ? $CurrentForm->getValue("datang_timbang14") : $CurrentForm->getValue("x_datang_timbang14");
        if (!$this->datang_timbang14->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_timbang14->Visible = false; // Disable update for API request
            } else {
                $this->datang_timbang14->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_datang_timbang14")) {
            $this->datang_timbang14->setOldValue($CurrentForm->getValue("o_datang_timbang14"));
        }

        // Check field name 'datang_timbang15' first before field var 'x_datang_timbang15'
        $val = $CurrentForm->hasValue("datang_timbang15") ? $CurrentForm->getValue("datang_timbang15") : $CurrentForm->getValue("x_datang_timbang15");
        if (!$this->datang_timbang15->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_timbang15->Visible = false; // Disable update for API request
            } else {
                $this->datang_timbang15->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_datang_timbang15")) {
            $this->datang_timbang15->setOldValue($CurrentForm->getValue("o_datang_timbang15"));
        }

        // Check field name 'datang_timbang16' first before field var 'x_datang_timbang16'
        $val = $CurrentForm->hasValue("datang_timbang16") ? $CurrentForm->getValue("datang_timbang16") : $CurrentForm->getValue("x_datang_timbang16");
        if (!$this->datang_timbang16->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_timbang16->Visible = false; // Disable update for API request
            } else {
                $this->datang_timbang16->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_datang_timbang16")) {
            $this->datang_timbang16->setOldValue($CurrentForm->getValue("o_datang_timbang16"));
        }

        // Check field name 'datang_timbang17' first before field var 'x_datang_timbang17'
        $val = $CurrentForm->hasValue("datang_timbang17") ? $CurrentForm->getValue("datang_timbang17") : $CurrentForm->getValue("x_datang_timbang17");
        if (!$this->datang_timbang17->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_timbang17->Visible = false; // Disable update for API request
            } else {
                $this->datang_timbang17->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_datang_timbang17")) {
            $this->datang_timbang17->setOldValue($CurrentForm->getValue("o_datang_timbang17"));
        }

        // Check field name 'datang_timbang18' first before field var 'x_datang_timbang18'
        $val = $CurrentForm->hasValue("datang_timbang18") ? $CurrentForm->getValue("datang_timbang18") : $CurrentForm->getValue("x_datang_timbang18");
        if (!$this->datang_timbang18->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_timbang18->Visible = false; // Disable update for API request
            } else {
                $this->datang_timbang18->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_datang_timbang18")) {
            $this->datang_timbang18->setOldValue($CurrentForm->getValue("o_datang_timbang18"));
        }

        // Check field name 'datang_timbang19' first before field var 'x_datang_timbang19'
        $val = $CurrentForm->hasValue("datang_timbang19") ? $CurrentForm->getValue("datang_timbang19") : $CurrentForm->getValue("x_datang_timbang19");
        if (!$this->datang_timbang19->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_timbang19->Visible = false; // Disable update for API request
            } else {
                $this->datang_timbang19->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_datang_timbang19")) {
            $this->datang_timbang19->setOldValue($CurrentForm->getValue("o_datang_timbang19"));
        }

        // Check field name 'datang_timbang20' first before field var 'x_datang_timbang20'
        $val = $CurrentForm->hasValue("datang_timbang20") ? $CurrentForm->getValue("datang_timbang20") : $CurrentForm->getValue("x_datang_timbang20");
        if (!$this->datang_timbang20->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_timbang20->Visible = false; // Disable update for API request
            } else {
                $this->datang_timbang20->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_datang_timbang20")) {
            $this->datang_timbang20->setOldValue($CurrentForm->getValue("o_datang_timbang20"));
        }

        // Check field name 'datang_timbang21' first before field var 'x_datang_timbang21'
        $val = $CurrentForm->hasValue("datang_timbang21") ? $CurrentForm->getValue("datang_timbang21") : $CurrentForm->getValue("x_datang_timbang21");
        if (!$this->datang_timbang21->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_timbang21->Visible = false; // Disable update for API request
            } else {
                $this->datang_timbang21->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_datang_timbang21")) {
            $this->datang_timbang21->setOldValue($CurrentForm->getValue("o_datang_timbang21"));
        }

        // Check field name 'datang_timbang22' first before field var 'x_datang_timbang22'
        $val = $CurrentForm->hasValue("datang_timbang22") ? $CurrentForm->getValue("datang_timbang22") : $CurrentForm->getValue("x_datang_timbang22");
        if (!$this->datang_timbang22->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_timbang22->Visible = false; // Disable update for API request
            } else {
                $this->datang_timbang22->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_datang_timbang22")) {
            $this->datang_timbang22->setOldValue($CurrentForm->getValue("o_datang_timbang22"));
        }

        // Check field name 'datang_timbang23' first before field var 'x_datang_timbang23'
        $val = $CurrentForm->hasValue("datang_timbang23") ? $CurrentForm->getValue("datang_timbang23") : $CurrentForm->getValue("x_datang_timbang23");
        if (!$this->datang_timbang23->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_timbang23->Visible = false; // Disable update for API request
            } else {
                $this->datang_timbang23->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_datang_timbang23")) {
            $this->datang_timbang23->setOldValue($CurrentForm->getValue("o_datang_timbang23"));
        }

        // Check field name 'datang_timbang24' first before field var 'x_datang_timbang24'
        $val = $CurrentForm->hasValue("datang_timbang24") ? $CurrentForm->getValue("datang_timbang24") : $CurrentForm->getValue("x_datang_timbang24");
        if (!$this->datang_timbang24->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_timbang24->Visible = false; // Disable update for API request
            } else {
                $this->datang_timbang24->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_datang_timbang24")) {
            $this->datang_timbang24->setOldValue($CurrentForm->getValue("o_datang_timbang24"));
        }

        // Check field name 'datang_timbang25' first before field var 'x_datang_timbang25'
        $val = $CurrentForm->hasValue("datang_timbang25") ? $CurrentForm->getValue("datang_timbang25") : $CurrentForm->getValue("x_datang_timbang25");
        if (!$this->datang_timbang25->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_timbang25->Visible = false; // Disable update for API request
            } else {
                $this->datang_timbang25->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_datang_timbang25")) {
            $this->datang_timbang25->setOldValue($CurrentForm->getValue("o_datang_timbang25"));
        }

        // Check field name 'datang_jumlah' first before field var 'x_datang_jumlah'
        $val = $CurrentForm->hasValue("datang_jumlah") ? $CurrentForm->getValue("datang_jumlah") : $CurrentForm->getValue("x_datang_jumlah");
        if (!$this->datang_jumlah->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_jumlah->Visible = false; // Disable update for API request
            } else {
                $this->datang_jumlah->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_datang_jumlah")) {
            $this->datang_jumlah->setOldValue($CurrentForm->getValue("o_datang_jumlah"));
        }

        // Check field name 'datang_jumlah_karung' first before field var 'x_datang_jumlah_karung'
        $val = $CurrentForm->hasValue("datang_jumlah_karung") ? $CurrentForm->getValue("datang_jumlah_karung") : $CurrentForm->getValue("x_datang_jumlah_karung");
        if (!$this->datang_jumlah_karung->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_jumlah_karung->Visible = false; // Disable update for API request
            } else {
                $this->datang_jumlah_karung->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_datang_jumlah_karung")) {
            $this->datang_jumlah_karung->setOldValue($CurrentForm->getValue("o_datang_jumlah_karung"));
        }

        // Check field name 'datang_berat_bersih' first before field var 'x_datang_berat_bersih'
        $val = $CurrentForm->hasValue("datang_berat_bersih") ? $CurrentForm->getValue("datang_berat_bersih") : $CurrentForm->getValue("x_datang_berat_bersih");
        if (!$this->datang_berat_bersih->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_berat_bersih->Visible = false; // Disable update for API request
            } else {
                $this->datang_berat_bersih->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_datang_berat_bersih")) {
            $this->datang_berat_bersih->setOldValue($CurrentForm->getValue("o_datang_berat_bersih"));
        }

        // Check field name 'datang_catatan' first before field var 'x_datang_catatan'
        $val = $CurrentForm->hasValue("datang_catatan") ? $CurrentForm->getValue("datang_catatan") : $CurrentForm->getValue("x_datang_catatan");
        if (!$this->datang_catatan->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_catatan->Visible = false; // Disable update for API request
            } else {
                $this->datang_catatan->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_datang_catatan")) {
            $this->datang_catatan->setOldValue($CurrentForm->getValue("o_datang_catatan"));
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        if (!$this->isGridAdd() && !$this->isAdd()) {
            $this->datang_id->CurrentValue = $this->datang_id->FormValue;
        }
        $this->datang_petugas->CurrentValue = $this->datang_petugas->FormValue;
        $this->datang_tanggal->CurrentValue = $this->datang_tanggal->FormValue;
        $this->datang_tanggal->CurrentValue = UnFormatDateTime($this->datang_tanggal->CurrentValue, 0);
        $this->datang_varietas->CurrentValue = $this->datang_varietas->FormValue;
        $this->datang_sup->CurrentValue = $this->datang_sup->FormValue;
        $this->datang_timbang1->CurrentValue = $this->datang_timbang1->FormValue;
        $this->datang_timbang2->CurrentValue = $this->datang_timbang2->FormValue;
        $this->datang_timbang3->CurrentValue = $this->datang_timbang3->FormValue;
        $this->datang_timbang4->CurrentValue = $this->datang_timbang4->FormValue;
        $this->datang_timbang5->CurrentValue = $this->datang_timbang5->FormValue;
        $this->datang_timbang6->CurrentValue = $this->datang_timbang6->FormValue;
        $this->datang_timbang7->CurrentValue = $this->datang_timbang7->FormValue;
        $this->datang_timbang8->CurrentValue = $this->datang_timbang8->FormValue;
        $this->datang_timbang9->CurrentValue = $this->datang_timbang9->FormValue;
        $this->datang_timbang10->CurrentValue = $this->datang_timbang10->FormValue;
        $this->datang_timbang11->CurrentValue = $this->datang_timbang11->FormValue;
        $this->datang_timbang12->CurrentValue = $this->datang_timbang12->FormValue;
        $this->datang_timbang13->CurrentValue = $this->datang_timbang13->FormValue;
        $this->datang_timbang14->CurrentValue = $this->datang_timbang14->FormValue;
        $this->datang_timbang15->CurrentValue = $this->datang_timbang15->FormValue;
        $this->datang_timbang16->CurrentValue = $this->datang_timbang16->FormValue;
        $this->datang_timbang17->CurrentValue = $this->datang_timbang17->FormValue;
        $this->datang_timbang18->CurrentValue = $this->datang_timbang18->FormValue;
        $this->datang_timbang19->CurrentValue = $this->datang_timbang19->FormValue;
        $this->datang_timbang20->CurrentValue = $this->datang_timbang20->FormValue;
        $this->datang_timbang21->CurrentValue = $this->datang_timbang21->FormValue;
        $this->datang_timbang22->CurrentValue = $this->datang_timbang22->FormValue;
        $this->datang_timbang23->CurrentValue = $this->datang_timbang23->FormValue;
        $this->datang_timbang24->CurrentValue = $this->datang_timbang24->FormValue;
        $this->datang_timbang25->CurrentValue = $this->datang_timbang25->FormValue;
        $this->datang_jumlah->CurrentValue = $this->datang_jumlah->FormValue;
        $this->datang_jumlah_karung->CurrentValue = $this->datang_jumlah_karung->FormValue;
        $this->datang_berat_bersih->CurrentValue = $this->datang_berat_bersih->FormValue;
        $this->datang_catatan->CurrentValue = $this->datang_catatan->FormValue;
    }

    // Load recordset
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load recordset
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > -1) {
            $sql->setMaxResults($rowcnt);
        }
        $stmt = $sql->execute();
        $rs = new Recordset($stmt, $sql);

        // Call Recordset Selected event
        $this->recordsetSelected($rs);
        return $rs;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssoc($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }

        // Call Row Selected event
        $this->rowSelected($row);
        if (!$rs) {
            return;
        }
        $this->datang_id->setDbValue($row['datang_id']);
        $this->datang_petugas->setDbValue($row['datang_petugas']);
        $this->datang_tanggal->setDbValue($row['datang_tanggal']);
        $this->datang_varietas->setDbValue($row['datang_varietas']);
        $this->datang_sup->setDbValue($row['datang_sup']);
        $this->datang_timbang1->setDbValue($row['datang_timbang1']);
        $this->datang_timbang2->setDbValue($row['datang_timbang2']);
        $this->datang_timbang3->setDbValue($row['datang_timbang3']);
        $this->datang_timbang4->setDbValue($row['datang_timbang4']);
        $this->datang_timbang5->setDbValue($row['datang_timbang5']);
        $this->datang_timbang6->setDbValue($row['datang_timbang6']);
        $this->datang_timbang7->setDbValue($row['datang_timbang7']);
        $this->datang_timbang8->setDbValue($row['datang_timbang8']);
        $this->datang_timbang9->setDbValue($row['datang_timbang9']);
        $this->datang_timbang10->setDbValue($row['datang_timbang10']);
        $this->datang_timbang11->setDbValue($row['datang_timbang11']);
        $this->datang_timbang12->setDbValue($row['datang_timbang12']);
        $this->datang_timbang13->setDbValue($row['datang_timbang13']);
        $this->datang_timbang14->setDbValue($row['datang_timbang14']);
        $this->datang_timbang15->setDbValue($row['datang_timbang15']);
        $this->datang_timbang16->setDbValue($row['datang_timbang16']);
        $this->datang_timbang17->setDbValue($row['datang_timbang17']);
        $this->datang_timbang18->setDbValue($row['datang_timbang18']);
        $this->datang_timbang19->setDbValue($row['datang_timbang19']);
        $this->datang_timbang20->setDbValue($row['datang_timbang20']);
        $this->datang_timbang21->setDbValue($row['datang_timbang21']);
        $this->datang_timbang22->setDbValue($row['datang_timbang22']);
        $this->datang_timbang23->setDbValue($row['datang_timbang23']);
        $this->datang_timbang24->setDbValue($row['datang_timbang24']);
        $this->datang_timbang25->setDbValue($row['datang_timbang25']);
        $this->datang_jumlah->setDbValue($row['datang_jumlah']);
        $this->datang_jumlah_karung->setDbValue($row['datang_jumlah_karung']);
        $this->datang_berat_bersih->setDbValue($row['datang_berat_bersih']);
        $this->datang_catatan->setDbValue($row['datang_catatan']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $this->loadDefaultValues();
        $row = [];
        $row['datang_id'] = $this->datang_id->CurrentValue;
        $row['datang_petugas'] = $this->datang_petugas->CurrentValue;
        $row['datang_tanggal'] = $this->datang_tanggal->CurrentValue;
        $row['datang_varietas'] = $this->datang_varietas->CurrentValue;
        $row['datang_sup'] = $this->datang_sup->CurrentValue;
        $row['datang_timbang1'] = $this->datang_timbang1->CurrentValue;
        $row['datang_timbang2'] = $this->datang_timbang2->CurrentValue;
        $row['datang_timbang3'] = $this->datang_timbang3->CurrentValue;
        $row['datang_timbang4'] = $this->datang_timbang4->CurrentValue;
        $row['datang_timbang5'] = $this->datang_timbang5->CurrentValue;
        $row['datang_timbang6'] = $this->datang_timbang6->CurrentValue;
        $row['datang_timbang7'] = $this->datang_timbang7->CurrentValue;
        $row['datang_timbang8'] = $this->datang_timbang8->CurrentValue;
        $row['datang_timbang9'] = $this->datang_timbang9->CurrentValue;
        $row['datang_timbang10'] = $this->datang_timbang10->CurrentValue;
        $row['datang_timbang11'] = $this->datang_timbang11->CurrentValue;
        $row['datang_timbang12'] = $this->datang_timbang12->CurrentValue;
        $row['datang_timbang13'] = $this->datang_timbang13->CurrentValue;
        $row['datang_timbang14'] = $this->datang_timbang14->CurrentValue;
        $row['datang_timbang15'] = $this->datang_timbang15->CurrentValue;
        $row['datang_timbang16'] = $this->datang_timbang16->CurrentValue;
        $row['datang_timbang17'] = $this->datang_timbang17->CurrentValue;
        $row['datang_timbang18'] = $this->datang_timbang18->CurrentValue;
        $row['datang_timbang19'] = $this->datang_timbang19->CurrentValue;
        $row['datang_timbang20'] = $this->datang_timbang20->CurrentValue;
        $row['datang_timbang21'] = $this->datang_timbang21->CurrentValue;
        $row['datang_timbang22'] = $this->datang_timbang22->CurrentValue;
        $row['datang_timbang23'] = $this->datang_timbang23->CurrentValue;
        $row['datang_timbang24'] = $this->datang_timbang24->CurrentValue;
        $row['datang_timbang25'] = $this->datang_timbang25->CurrentValue;
        $row['datang_jumlah'] = $this->datang_jumlah->CurrentValue;
        $row['datang_jumlah_karung'] = $this->datang_jumlah_karung->CurrentValue;
        $row['datang_berat_bersih'] = $this->datang_berat_bersih->CurrentValue;
        $row['datang_catatan'] = $this->datang_catatan->CurrentValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load key values from Session
        $validKey = true;
        if (strval($this->getKey("datang_id")) != "") {
            $this->datang_id->OldValue = $this->getKey("datang_id"); // datang_id
        } else {
            $validKey = false;
        }

        // Load old record
        $this->OldRecordset = null;
        if ($validKey) {
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $this->OldRecordset = LoadRecordset($sql, $conn);
        }
        $this->loadRowValues($this->OldRecordset); // Load row values
        return $validKey;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->InlineEditUrl = $this->getInlineEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->InlineCopyUrl = $this->getInlineCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Convert decimal values if posted back
        if ($this->datang_timbang1->FormValue == $this->datang_timbang1->CurrentValue && is_numeric(ConvertToFloatString($this->datang_timbang1->CurrentValue))) {
            $this->datang_timbang1->CurrentValue = ConvertToFloatString($this->datang_timbang1->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->datang_timbang2->FormValue == $this->datang_timbang2->CurrentValue && is_numeric(ConvertToFloatString($this->datang_timbang2->CurrentValue))) {
            $this->datang_timbang2->CurrentValue = ConvertToFloatString($this->datang_timbang2->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->datang_timbang3->FormValue == $this->datang_timbang3->CurrentValue && is_numeric(ConvertToFloatString($this->datang_timbang3->CurrentValue))) {
            $this->datang_timbang3->CurrentValue = ConvertToFloatString($this->datang_timbang3->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->datang_timbang4->FormValue == $this->datang_timbang4->CurrentValue && is_numeric(ConvertToFloatString($this->datang_timbang4->CurrentValue))) {
            $this->datang_timbang4->CurrentValue = ConvertToFloatString($this->datang_timbang4->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->datang_timbang5->FormValue == $this->datang_timbang5->CurrentValue && is_numeric(ConvertToFloatString($this->datang_timbang5->CurrentValue))) {
            $this->datang_timbang5->CurrentValue = ConvertToFloatString($this->datang_timbang5->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->datang_timbang6->FormValue == $this->datang_timbang6->CurrentValue && is_numeric(ConvertToFloatString($this->datang_timbang6->CurrentValue))) {
            $this->datang_timbang6->CurrentValue = ConvertToFloatString($this->datang_timbang6->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->datang_timbang7->FormValue == $this->datang_timbang7->CurrentValue && is_numeric(ConvertToFloatString($this->datang_timbang7->CurrentValue))) {
            $this->datang_timbang7->CurrentValue = ConvertToFloatString($this->datang_timbang7->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->datang_timbang8->FormValue == $this->datang_timbang8->CurrentValue && is_numeric(ConvertToFloatString($this->datang_timbang8->CurrentValue))) {
            $this->datang_timbang8->CurrentValue = ConvertToFloatString($this->datang_timbang8->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->datang_timbang9->FormValue == $this->datang_timbang9->CurrentValue && is_numeric(ConvertToFloatString($this->datang_timbang9->CurrentValue))) {
            $this->datang_timbang9->CurrentValue = ConvertToFloatString($this->datang_timbang9->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->datang_timbang10->FormValue == $this->datang_timbang10->CurrentValue && is_numeric(ConvertToFloatString($this->datang_timbang10->CurrentValue))) {
            $this->datang_timbang10->CurrentValue = ConvertToFloatString($this->datang_timbang10->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->datang_timbang11->FormValue == $this->datang_timbang11->CurrentValue && is_numeric(ConvertToFloatString($this->datang_timbang11->CurrentValue))) {
            $this->datang_timbang11->CurrentValue = ConvertToFloatString($this->datang_timbang11->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->datang_timbang12->FormValue == $this->datang_timbang12->CurrentValue && is_numeric(ConvertToFloatString($this->datang_timbang12->CurrentValue))) {
            $this->datang_timbang12->CurrentValue = ConvertToFloatString($this->datang_timbang12->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->datang_timbang13->FormValue == $this->datang_timbang13->CurrentValue && is_numeric(ConvertToFloatString($this->datang_timbang13->CurrentValue))) {
            $this->datang_timbang13->CurrentValue = ConvertToFloatString($this->datang_timbang13->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->datang_timbang14->FormValue == $this->datang_timbang14->CurrentValue && is_numeric(ConvertToFloatString($this->datang_timbang14->CurrentValue))) {
            $this->datang_timbang14->CurrentValue = ConvertToFloatString($this->datang_timbang14->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->datang_timbang15->FormValue == $this->datang_timbang15->CurrentValue && is_numeric(ConvertToFloatString($this->datang_timbang15->CurrentValue))) {
            $this->datang_timbang15->CurrentValue = ConvertToFloatString($this->datang_timbang15->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->datang_timbang16->FormValue == $this->datang_timbang16->CurrentValue && is_numeric(ConvertToFloatString($this->datang_timbang16->CurrentValue))) {
            $this->datang_timbang16->CurrentValue = ConvertToFloatString($this->datang_timbang16->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->datang_timbang17->FormValue == $this->datang_timbang17->CurrentValue && is_numeric(ConvertToFloatString($this->datang_timbang17->CurrentValue))) {
            $this->datang_timbang17->CurrentValue = ConvertToFloatString($this->datang_timbang17->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->datang_timbang18->FormValue == $this->datang_timbang18->CurrentValue && is_numeric(ConvertToFloatString($this->datang_timbang18->CurrentValue))) {
            $this->datang_timbang18->CurrentValue = ConvertToFloatString($this->datang_timbang18->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->datang_timbang19->FormValue == $this->datang_timbang19->CurrentValue && is_numeric(ConvertToFloatString($this->datang_timbang19->CurrentValue))) {
            $this->datang_timbang19->CurrentValue = ConvertToFloatString($this->datang_timbang19->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->datang_timbang20->FormValue == $this->datang_timbang20->CurrentValue && is_numeric(ConvertToFloatString($this->datang_timbang20->CurrentValue))) {
            $this->datang_timbang20->CurrentValue = ConvertToFloatString($this->datang_timbang20->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->datang_timbang21->FormValue == $this->datang_timbang21->CurrentValue && is_numeric(ConvertToFloatString($this->datang_timbang21->CurrentValue))) {
            $this->datang_timbang21->CurrentValue = ConvertToFloatString($this->datang_timbang21->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->datang_timbang22->FormValue == $this->datang_timbang22->CurrentValue && is_numeric(ConvertToFloatString($this->datang_timbang22->CurrentValue))) {
            $this->datang_timbang22->CurrentValue = ConvertToFloatString($this->datang_timbang22->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->datang_timbang23->FormValue == $this->datang_timbang23->CurrentValue && is_numeric(ConvertToFloatString($this->datang_timbang23->CurrentValue))) {
            $this->datang_timbang23->CurrentValue = ConvertToFloatString($this->datang_timbang23->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->datang_timbang24->FormValue == $this->datang_timbang24->CurrentValue && is_numeric(ConvertToFloatString($this->datang_timbang24->CurrentValue))) {
            $this->datang_timbang24->CurrentValue = ConvertToFloatString($this->datang_timbang24->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->datang_timbang25->FormValue == $this->datang_timbang25->CurrentValue && is_numeric(ConvertToFloatString($this->datang_timbang25->CurrentValue))) {
            $this->datang_timbang25->CurrentValue = ConvertToFloatString($this->datang_timbang25->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->datang_jumlah->FormValue == $this->datang_jumlah->CurrentValue && is_numeric(ConvertToFloatString($this->datang_jumlah->CurrentValue))) {
            $this->datang_jumlah->CurrentValue = ConvertToFloatString($this->datang_jumlah->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->datang_jumlah_karung->FormValue == $this->datang_jumlah_karung->CurrentValue && is_numeric(ConvertToFloatString($this->datang_jumlah_karung->CurrentValue))) {
            $this->datang_jumlah_karung->CurrentValue = ConvertToFloatString($this->datang_jumlah_karung->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->datang_berat_bersih->FormValue == $this->datang_berat_bersih->CurrentValue && is_numeric(ConvertToFloatString($this->datang_berat_bersih->CurrentValue))) {
            $this->datang_berat_bersih->CurrentValue = ConvertToFloatString($this->datang_berat_bersih->CurrentValue);
        }

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // datang_id

        // datang_petugas

        // datang_tanggal

        // datang_varietas

        // datang_sup

        // datang_timbang1

        // datang_timbang2

        // datang_timbang3

        // datang_timbang4

        // datang_timbang5

        // datang_timbang6

        // datang_timbang7

        // datang_timbang8

        // datang_timbang9

        // datang_timbang10

        // datang_timbang11

        // datang_timbang12

        // datang_timbang13

        // datang_timbang14

        // datang_timbang15

        // datang_timbang16

        // datang_timbang17

        // datang_timbang18

        // datang_timbang19

        // datang_timbang20

        // datang_timbang21

        // datang_timbang22

        // datang_timbang23

        // datang_timbang24

        // datang_timbang25

        // datang_jumlah

        // datang_jumlah_karung

        // datang_berat_bersih

        // datang_catatan
        if ($this->RowType == ROWTYPE_VIEW) {
            // datang_id
            $this->datang_id->ViewValue = $this->datang_id->CurrentValue;
            $this->datang_id->ViewValue = FormatNumber($this->datang_id->ViewValue, 0, -2, -2, -2);
            $this->datang_id->ViewCustomAttributes = "";

            // datang_petugas
            $this->datang_petugas->ViewValue = $this->datang_petugas->CurrentValue;
            $this->datang_petugas->ViewCustomAttributes = "";

            // datang_tanggal
            $this->datang_tanggal->ViewValue = $this->datang_tanggal->CurrentValue;
            $this->datang_tanggal->ViewValue = FormatDateTime($this->datang_tanggal->ViewValue, 0);
            $this->datang_tanggal->ViewCustomAttributes = "";

            // datang_varietas
            $curVal = strval($this->datang_varietas->CurrentValue);
            if ($curVal != "") {
                $this->datang_varietas->ViewValue = $this->datang_varietas->lookupCacheOption($curVal);
                if ($this->datang_varietas->ViewValue === null) { // Lookup from database
                    $filterWrk = "`var_id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->datang_varietas->Lookup->getSql(false, $filterWrk, '', $this, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->datang_varietas->Lookup->renderViewRow($rswrk[0]);
                        $this->datang_varietas->ViewValue = $this->datang_varietas->displayValue($arwrk);
                    } else {
                        $this->datang_varietas->ViewValue = $this->datang_varietas->CurrentValue;
                    }
                }
            } else {
                $this->datang_varietas->ViewValue = null;
            }
            $this->datang_varietas->ViewCustomAttributes = "";

            // datang_sup
            $curVal = strval($this->datang_sup->CurrentValue);
            if ($curVal != "") {
                $this->datang_sup->ViewValue = $this->datang_sup->lookupCacheOption($curVal);
                if ($this->datang_sup->ViewValue === null) { // Lookup from database
                    $filterWrk = "`sup_id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->datang_sup->Lookup->getSql(false, $filterWrk, '', $this, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->datang_sup->Lookup->renderViewRow($rswrk[0]);
                        $this->datang_sup->ViewValue = $this->datang_sup->displayValue($arwrk);
                    } else {
                        $this->datang_sup->ViewValue = $this->datang_sup->CurrentValue;
                    }
                }
            } else {
                $this->datang_sup->ViewValue = null;
            }
            $this->datang_sup->ViewCustomAttributes = "";

            // datang_timbang1
            $this->datang_timbang1->ViewValue = $this->datang_timbang1->CurrentValue;
            $this->datang_timbang1->ViewValue = FormatNumber($this->datang_timbang1->ViewValue, 2, -2, -2, -2);
            $this->datang_timbang1->ViewCustomAttributes = "";

            // datang_timbang2
            $this->datang_timbang2->ViewValue = $this->datang_timbang2->CurrentValue;
            $this->datang_timbang2->ViewValue = FormatNumber($this->datang_timbang2->ViewValue, 2, -2, -2, -2);
            $this->datang_timbang2->ViewCustomAttributes = "";

            // datang_timbang3
            $this->datang_timbang3->ViewValue = $this->datang_timbang3->CurrentValue;
            $this->datang_timbang3->ViewValue = FormatNumber($this->datang_timbang3->ViewValue, 2, -2, -2, -2);
            $this->datang_timbang3->ViewCustomAttributes = "";

            // datang_timbang4
            $this->datang_timbang4->ViewValue = $this->datang_timbang4->CurrentValue;
            $this->datang_timbang4->ViewValue = FormatNumber($this->datang_timbang4->ViewValue, 2, -2, -2, -2);
            $this->datang_timbang4->ViewCustomAttributes = "";

            // datang_timbang5
            $this->datang_timbang5->ViewValue = $this->datang_timbang5->CurrentValue;
            $this->datang_timbang5->ViewValue = FormatNumber($this->datang_timbang5->ViewValue, 2, -2, -2, -2);
            $this->datang_timbang5->ViewCustomAttributes = "";

            // datang_timbang6
            $this->datang_timbang6->ViewValue = $this->datang_timbang6->CurrentValue;
            $this->datang_timbang6->ViewValue = FormatNumber($this->datang_timbang6->ViewValue, 2, -2, -2, -2);
            $this->datang_timbang6->ViewCustomAttributes = "";

            // datang_timbang7
            $this->datang_timbang7->ViewValue = $this->datang_timbang7->CurrentValue;
            $this->datang_timbang7->ViewValue = FormatNumber($this->datang_timbang7->ViewValue, 2, -2, -2, -2);
            $this->datang_timbang7->ViewCustomAttributes = "";

            // datang_timbang8
            $this->datang_timbang8->ViewValue = $this->datang_timbang8->CurrentValue;
            $this->datang_timbang8->ViewValue = FormatNumber($this->datang_timbang8->ViewValue, 2, -2, -2, -2);
            $this->datang_timbang8->ViewCustomAttributes = "";

            // datang_timbang9
            $this->datang_timbang9->ViewValue = $this->datang_timbang9->CurrentValue;
            $this->datang_timbang9->ViewValue = FormatNumber($this->datang_timbang9->ViewValue, 2, -2, -2, -2);
            $this->datang_timbang9->ViewCustomAttributes = "";

            // datang_timbang10
            $this->datang_timbang10->ViewValue = $this->datang_timbang10->CurrentValue;
            $this->datang_timbang10->ViewValue = FormatNumber($this->datang_timbang10->ViewValue, 2, -2, -2, -2);
            $this->datang_timbang10->ViewCustomAttributes = "";

            // datang_timbang11
            $this->datang_timbang11->ViewValue = $this->datang_timbang11->CurrentValue;
            $this->datang_timbang11->ViewValue = FormatNumber($this->datang_timbang11->ViewValue, 2, -2, -2, -2);
            $this->datang_timbang11->ViewCustomAttributes = "";

            // datang_timbang12
            $this->datang_timbang12->ViewValue = $this->datang_timbang12->CurrentValue;
            $this->datang_timbang12->ViewValue = FormatNumber($this->datang_timbang12->ViewValue, 2, -2, -2, -2);
            $this->datang_timbang12->ViewCustomAttributes = "";

            // datang_timbang13
            $this->datang_timbang13->ViewValue = $this->datang_timbang13->CurrentValue;
            $this->datang_timbang13->ViewValue = FormatNumber($this->datang_timbang13->ViewValue, 2, -2, -2, -2);
            $this->datang_timbang13->ViewCustomAttributes = "";

            // datang_timbang14
            $this->datang_timbang14->ViewValue = $this->datang_timbang14->CurrentValue;
            $this->datang_timbang14->ViewValue = FormatNumber($this->datang_timbang14->ViewValue, 2, -2, -2, -2);
            $this->datang_timbang14->ViewCustomAttributes = "";

            // datang_timbang15
            $this->datang_timbang15->ViewValue = $this->datang_timbang15->CurrentValue;
            $this->datang_timbang15->ViewValue = FormatNumber($this->datang_timbang15->ViewValue, 2, -2, -2, -2);
            $this->datang_timbang15->ViewCustomAttributes = "";

            // datang_timbang16
            $this->datang_timbang16->ViewValue = $this->datang_timbang16->CurrentValue;
            $this->datang_timbang16->ViewValue = FormatNumber($this->datang_timbang16->ViewValue, 2, -2, -2, -2);
            $this->datang_timbang16->ViewCustomAttributes = "";

            // datang_timbang17
            $this->datang_timbang17->ViewValue = $this->datang_timbang17->CurrentValue;
            $this->datang_timbang17->ViewValue = FormatNumber($this->datang_timbang17->ViewValue, 2, -2, -2, -2);
            $this->datang_timbang17->ViewCustomAttributes = "";

            // datang_timbang18
            $this->datang_timbang18->ViewValue = $this->datang_timbang18->CurrentValue;
            $this->datang_timbang18->ViewValue = FormatNumber($this->datang_timbang18->ViewValue, 2, -2, -2, -2);
            $this->datang_timbang18->ViewCustomAttributes = "";

            // datang_timbang19
            $this->datang_timbang19->ViewValue = $this->datang_timbang19->CurrentValue;
            $this->datang_timbang19->ViewValue = FormatNumber($this->datang_timbang19->ViewValue, 2, -2, -2, -2);
            $this->datang_timbang19->ViewCustomAttributes = "";

            // datang_timbang20
            $this->datang_timbang20->ViewValue = $this->datang_timbang20->CurrentValue;
            $this->datang_timbang20->ViewValue = FormatNumber($this->datang_timbang20->ViewValue, 2, -2, -2, -2);
            $this->datang_timbang20->ViewCustomAttributes = "";

            // datang_timbang21
            $this->datang_timbang21->ViewValue = $this->datang_timbang21->CurrentValue;
            $this->datang_timbang21->ViewValue = FormatNumber($this->datang_timbang21->ViewValue, 2, -2, -2, -2);
            $this->datang_timbang21->ViewCustomAttributes = "";

            // datang_timbang22
            $this->datang_timbang22->ViewValue = $this->datang_timbang22->CurrentValue;
            $this->datang_timbang22->ViewValue = FormatNumber($this->datang_timbang22->ViewValue, 2, -2, -2, -2);
            $this->datang_timbang22->ViewCustomAttributes = "";

            // datang_timbang23
            $this->datang_timbang23->ViewValue = $this->datang_timbang23->CurrentValue;
            $this->datang_timbang23->ViewValue = FormatNumber($this->datang_timbang23->ViewValue, 2, -2, -2, -2);
            $this->datang_timbang23->ViewCustomAttributes = "";

            // datang_timbang24
            $this->datang_timbang24->ViewValue = $this->datang_timbang24->CurrentValue;
            $this->datang_timbang24->ViewValue = FormatNumber($this->datang_timbang24->ViewValue, 2, -2, -2, -2);
            $this->datang_timbang24->ViewCustomAttributes = "";

            // datang_timbang25
            $this->datang_timbang25->ViewValue = $this->datang_timbang25->CurrentValue;
            $this->datang_timbang25->ViewValue = FormatNumber($this->datang_timbang25->ViewValue, 2, -2, -2, -2);
            $this->datang_timbang25->ViewCustomAttributes = "";

            // datang_jumlah
            $this->datang_jumlah->ViewValue = $this->datang_jumlah->CurrentValue;
            $this->datang_jumlah->ViewValue = FormatNumber($this->datang_jumlah->ViewValue, 2, -2, -2, -2);
            $this->datang_jumlah->ViewCustomAttributes = "";

            // datang_jumlah_karung
            $this->datang_jumlah_karung->ViewValue = $this->datang_jumlah_karung->CurrentValue;
            $this->datang_jumlah_karung->ViewValue = FormatNumber($this->datang_jumlah_karung->ViewValue, 2, -2, -2, -2);
            $this->datang_jumlah_karung->ViewCustomAttributes = "";

            // datang_berat_bersih
            $this->datang_berat_bersih->ViewValue = $this->datang_berat_bersih->CurrentValue;
            $this->datang_berat_bersih->ViewValue = FormatNumber($this->datang_berat_bersih->ViewValue, 2, -2, -2, -2);
            $this->datang_berat_bersih->ViewCustomAttributes = "";

            // datang_catatan
            $this->datang_catatan->ViewValue = $this->datang_catatan->CurrentValue;
            $this->datang_catatan->ViewCustomAttributes = "";

            // datang_id
            $this->datang_id->LinkCustomAttributes = "";
            $this->datang_id->HrefValue = "";
            $this->datang_id->TooltipValue = "";

            // datang_petugas
            $this->datang_petugas->LinkCustomAttributes = "";
            $this->datang_petugas->HrefValue = "";
            $this->datang_petugas->TooltipValue = "";

            // datang_tanggal
            $this->datang_tanggal->LinkCustomAttributes = "";
            $this->datang_tanggal->HrefValue = "";
            $this->datang_tanggal->TooltipValue = "";

            // datang_varietas
            $this->datang_varietas->LinkCustomAttributes = "";
            $this->datang_varietas->HrefValue = "";
            $this->datang_varietas->TooltipValue = "";

            // datang_sup
            $this->datang_sup->LinkCustomAttributes = "";
            $this->datang_sup->HrefValue = "";
            $this->datang_sup->TooltipValue = "";

            // datang_timbang1
            $this->datang_timbang1->LinkCustomAttributes = "";
            $this->datang_timbang1->HrefValue = "";
            $this->datang_timbang1->TooltipValue = "";

            // datang_timbang2
            $this->datang_timbang2->LinkCustomAttributes = "";
            $this->datang_timbang2->HrefValue = "";
            $this->datang_timbang2->TooltipValue = "";

            // datang_timbang3
            $this->datang_timbang3->LinkCustomAttributes = "";
            $this->datang_timbang3->HrefValue = "";
            $this->datang_timbang3->TooltipValue = "";

            // datang_timbang4
            $this->datang_timbang4->LinkCustomAttributes = "";
            $this->datang_timbang4->HrefValue = "";
            $this->datang_timbang4->TooltipValue = "";

            // datang_timbang5
            $this->datang_timbang5->LinkCustomAttributes = "";
            $this->datang_timbang5->HrefValue = "";
            $this->datang_timbang5->TooltipValue = "";

            // datang_timbang6
            $this->datang_timbang6->LinkCustomAttributes = "";
            $this->datang_timbang6->HrefValue = "";
            $this->datang_timbang6->TooltipValue = "";

            // datang_timbang7
            $this->datang_timbang7->LinkCustomAttributes = "";
            $this->datang_timbang7->HrefValue = "";
            $this->datang_timbang7->TooltipValue = "";

            // datang_timbang8
            $this->datang_timbang8->LinkCustomAttributes = "";
            $this->datang_timbang8->HrefValue = "";
            $this->datang_timbang8->TooltipValue = "";

            // datang_timbang9
            $this->datang_timbang9->LinkCustomAttributes = "";
            $this->datang_timbang9->HrefValue = "";
            $this->datang_timbang9->TooltipValue = "";

            // datang_timbang10
            $this->datang_timbang10->LinkCustomAttributes = "";
            $this->datang_timbang10->HrefValue = "";
            $this->datang_timbang10->TooltipValue = "";

            // datang_timbang11
            $this->datang_timbang11->LinkCustomAttributes = "";
            $this->datang_timbang11->HrefValue = "";
            $this->datang_timbang11->TooltipValue = "";

            // datang_timbang12
            $this->datang_timbang12->LinkCustomAttributes = "";
            $this->datang_timbang12->HrefValue = "";
            $this->datang_timbang12->TooltipValue = "";

            // datang_timbang13
            $this->datang_timbang13->LinkCustomAttributes = "";
            $this->datang_timbang13->HrefValue = "";
            $this->datang_timbang13->TooltipValue = "";

            // datang_timbang14
            $this->datang_timbang14->LinkCustomAttributes = "";
            $this->datang_timbang14->HrefValue = "";
            $this->datang_timbang14->TooltipValue = "";

            // datang_timbang15
            $this->datang_timbang15->LinkCustomAttributes = "";
            $this->datang_timbang15->HrefValue = "";
            $this->datang_timbang15->TooltipValue = "";

            // datang_timbang16
            $this->datang_timbang16->LinkCustomAttributes = "";
            $this->datang_timbang16->HrefValue = "";
            $this->datang_timbang16->TooltipValue = "";

            // datang_timbang17
            $this->datang_timbang17->LinkCustomAttributes = "";
            $this->datang_timbang17->HrefValue = "";
            $this->datang_timbang17->TooltipValue = "";

            // datang_timbang18
            $this->datang_timbang18->LinkCustomAttributes = "";
            $this->datang_timbang18->HrefValue = "";
            $this->datang_timbang18->TooltipValue = "";

            // datang_timbang19
            $this->datang_timbang19->LinkCustomAttributes = "";
            $this->datang_timbang19->HrefValue = "";
            $this->datang_timbang19->TooltipValue = "";

            // datang_timbang20
            $this->datang_timbang20->LinkCustomAttributes = "";
            $this->datang_timbang20->HrefValue = "";
            $this->datang_timbang20->TooltipValue = "";

            // datang_timbang21
            $this->datang_timbang21->LinkCustomAttributes = "";
            $this->datang_timbang21->HrefValue = "";
            $this->datang_timbang21->TooltipValue = "";

            // datang_timbang22
            $this->datang_timbang22->LinkCustomAttributes = "";
            $this->datang_timbang22->HrefValue = "";
            $this->datang_timbang22->TooltipValue = "";

            // datang_timbang23
            $this->datang_timbang23->LinkCustomAttributes = "";
            $this->datang_timbang23->HrefValue = "";
            $this->datang_timbang23->TooltipValue = "";

            // datang_timbang24
            $this->datang_timbang24->LinkCustomAttributes = "";
            $this->datang_timbang24->HrefValue = "";
            $this->datang_timbang24->TooltipValue = "";

            // datang_timbang25
            $this->datang_timbang25->LinkCustomAttributes = "";
            $this->datang_timbang25->HrefValue = "";
            $this->datang_timbang25->TooltipValue = "";

            // datang_jumlah
            $this->datang_jumlah->LinkCustomAttributes = "";
            $this->datang_jumlah->HrefValue = "";
            $this->datang_jumlah->TooltipValue = "";

            // datang_jumlah_karung
            $this->datang_jumlah_karung->LinkCustomAttributes = "";
            $this->datang_jumlah_karung->HrefValue = "";
            $this->datang_jumlah_karung->TooltipValue = "";

            // datang_berat_bersih
            $this->datang_berat_bersih->LinkCustomAttributes = "";
            $this->datang_berat_bersih->HrefValue = "";
            $this->datang_berat_bersih->TooltipValue = "";

            // datang_catatan
            $this->datang_catatan->LinkCustomAttributes = "";
            $this->datang_catatan->HrefValue = "";
            $this->datang_catatan->TooltipValue = "";
        } elseif ($this->RowType == ROWTYPE_ADD) {
            // datang_id

            // datang_petugas

            // datang_tanggal
            $this->datang_tanggal->EditAttrs["class"] = "form-control";
            $this->datang_tanggal->EditCustomAttributes = "";
            $this->datang_tanggal->EditValue = HtmlEncode(FormatDateTime($this->datang_tanggal->CurrentValue, 8));
            $this->datang_tanggal->PlaceHolder = RemoveHtml($this->datang_tanggal->caption());

            // datang_varietas
            $this->datang_varietas->EditAttrs["class"] = "form-control";
            $this->datang_varietas->EditCustomAttributes = "";
            $curVal = trim(strval($this->datang_varietas->CurrentValue));
            if ($curVal != "") {
                $this->datang_varietas->ViewValue = $this->datang_varietas->lookupCacheOption($curVal);
            } else {
                $this->datang_varietas->ViewValue = $this->datang_varietas->Lookup !== null && is_array($this->datang_varietas->Lookup->Options) ? $curVal : null;
            }
            if ($this->datang_varietas->ViewValue !== null) { // Load from cache
                $this->datang_varietas->EditValue = array_values($this->datang_varietas->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`var_id`" . SearchString("=", $this->datang_varietas->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->datang_varietas->Lookup->getSql(true, $filterWrk, '', $this);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->datang_varietas->EditValue = $arwrk;
            }
            $this->datang_varietas->PlaceHolder = RemoveHtml($this->datang_varietas->caption());

            // datang_sup
            $this->datang_sup->EditAttrs["class"] = "form-control";
            $this->datang_sup->EditCustomAttributes = "";
            $curVal = trim(strval($this->datang_sup->CurrentValue));
            if ($curVal != "") {
                $this->datang_sup->ViewValue = $this->datang_sup->lookupCacheOption($curVal);
            } else {
                $this->datang_sup->ViewValue = $this->datang_sup->Lookup !== null && is_array($this->datang_sup->Lookup->Options) ? $curVal : null;
            }
            if ($this->datang_sup->ViewValue !== null) { // Load from cache
                $this->datang_sup->EditValue = array_values($this->datang_sup->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`sup_id`" . SearchString("=", $this->datang_sup->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->datang_sup->Lookup->getSql(true, $filterWrk, '', $this);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->datang_sup->EditValue = $arwrk;
            }
            $this->datang_sup->PlaceHolder = RemoveHtml($this->datang_sup->caption());

            // datang_timbang1
            $this->datang_timbang1->EditAttrs["class"] = "form-control";
            $this->datang_timbang1->EditCustomAttributes = "";
            $this->datang_timbang1->EditValue = HtmlEncode($this->datang_timbang1->CurrentValue);
            $this->datang_timbang1->PlaceHolder = RemoveHtml($this->datang_timbang1->caption());
            if (strval($this->datang_timbang1->EditValue) != "" && is_numeric($this->datang_timbang1->EditValue)) {
                $this->datang_timbang1->EditValue = FormatNumber($this->datang_timbang1->EditValue, -2, -2, -2, -2);
                $this->datang_timbang1->OldValue = $this->datang_timbang1->EditValue;
            }

            // datang_timbang2
            $this->datang_timbang2->EditAttrs["class"] = "form-control";
            $this->datang_timbang2->EditCustomAttributes = "";
            $this->datang_timbang2->EditValue = HtmlEncode($this->datang_timbang2->CurrentValue);
            $this->datang_timbang2->PlaceHolder = RemoveHtml($this->datang_timbang2->caption());
            if (strval($this->datang_timbang2->EditValue) != "" && is_numeric($this->datang_timbang2->EditValue)) {
                $this->datang_timbang2->EditValue = FormatNumber($this->datang_timbang2->EditValue, -2, -2, -2, -2);
                $this->datang_timbang2->OldValue = $this->datang_timbang2->EditValue;
            }

            // datang_timbang3
            $this->datang_timbang3->EditAttrs["class"] = "form-control";
            $this->datang_timbang3->EditCustomAttributes = "";
            $this->datang_timbang3->EditValue = HtmlEncode($this->datang_timbang3->CurrentValue);
            $this->datang_timbang3->PlaceHolder = RemoveHtml($this->datang_timbang3->caption());
            if (strval($this->datang_timbang3->EditValue) != "" && is_numeric($this->datang_timbang3->EditValue)) {
                $this->datang_timbang3->EditValue = FormatNumber($this->datang_timbang3->EditValue, -2, -2, -2, -2);
                $this->datang_timbang3->OldValue = $this->datang_timbang3->EditValue;
            }

            // datang_timbang4
            $this->datang_timbang4->EditAttrs["class"] = "form-control";
            $this->datang_timbang4->EditCustomAttributes = "";
            $this->datang_timbang4->EditValue = HtmlEncode($this->datang_timbang4->CurrentValue);
            $this->datang_timbang4->PlaceHolder = RemoveHtml($this->datang_timbang4->caption());
            if (strval($this->datang_timbang4->EditValue) != "" && is_numeric($this->datang_timbang4->EditValue)) {
                $this->datang_timbang4->EditValue = FormatNumber($this->datang_timbang4->EditValue, -2, -2, -2, -2);
                $this->datang_timbang4->OldValue = $this->datang_timbang4->EditValue;
            }

            // datang_timbang5
            $this->datang_timbang5->EditAttrs["class"] = "form-control";
            $this->datang_timbang5->EditCustomAttributes = "";
            $this->datang_timbang5->EditValue = HtmlEncode($this->datang_timbang5->CurrentValue);
            $this->datang_timbang5->PlaceHolder = RemoveHtml($this->datang_timbang5->caption());
            if (strval($this->datang_timbang5->EditValue) != "" && is_numeric($this->datang_timbang5->EditValue)) {
                $this->datang_timbang5->EditValue = FormatNumber($this->datang_timbang5->EditValue, -2, -2, -2, -2);
                $this->datang_timbang5->OldValue = $this->datang_timbang5->EditValue;
            }

            // datang_timbang6
            $this->datang_timbang6->EditAttrs["class"] = "form-control";
            $this->datang_timbang6->EditCustomAttributes = "";
            $this->datang_timbang6->EditValue = HtmlEncode($this->datang_timbang6->CurrentValue);
            $this->datang_timbang6->PlaceHolder = RemoveHtml($this->datang_timbang6->caption());
            if (strval($this->datang_timbang6->EditValue) != "" && is_numeric($this->datang_timbang6->EditValue)) {
                $this->datang_timbang6->EditValue = FormatNumber($this->datang_timbang6->EditValue, -2, -2, -2, -2);
                $this->datang_timbang6->OldValue = $this->datang_timbang6->EditValue;
            }

            // datang_timbang7
            $this->datang_timbang7->EditAttrs["class"] = "form-control";
            $this->datang_timbang7->EditCustomAttributes = "";
            $this->datang_timbang7->EditValue = HtmlEncode($this->datang_timbang7->CurrentValue);
            $this->datang_timbang7->PlaceHolder = RemoveHtml($this->datang_timbang7->caption());
            if (strval($this->datang_timbang7->EditValue) != "" && is_numeric($this->datang_timbang7->EditValue)) {
                $this->datang_timbang7->EditValue = FormatNumber($this->datang_timbang7->EditValue, -2, -2, -2, -2);
                $this->datang_timbang7->OldValue = $this->datang_timbang7->EditValue;
            }

            // datang_timbang8
            $this->datang_timbang8->EditAttrs["class"] = "form-control";
            $this->datang_timbang8->EditCustomAttributes = "";
            $this->datang_timbang8->EditValue = HtmlEncode($this->datang_timbang8->CurrentValue);
            $this->datang_timbang8->PlaceHolder = RemoveHtml($this->datang_timbang8->caption());
            if (strval($this->datang_timbang8->EditValue) != "" && is_numeric($this->datang_timbang8->EditValue)) {
                $this->datang_timbang8->EditValue = FormatNumber($this->datang_timbang8->EditValue, -2, -2, -2, -2);
                $this->datang_timbang8->OldValue = $this->datang_timbang8->EditValue;
            }

            // datang_timbang9
            $this->datang_timbang9->EditAttrs["class"] = "form-control";
            $this->datang_timbang9->EditCustomAttributes = "";
            $this->datang_timbang9->EditValue = HtmlEncode($this->datang_timbang9->CurrentValue);
            $this->datang_timbang9->PlaceHolder = RemoveHtml($this->datang_timbang9->caption());
            if (strval($this->datang_timbang9->EditValue) != "" && is_numeric($this->datang_timbang9->EditValue)) {
                $this->datang_timbang9->EditValue = FormatNumber($this->datang_timbang9->EditValue, -2, -2, -2, -2);
                $this->datang_timbang9->OldValue = $this->datang_timbang9->EditValue;
            }

            // datang_timbang10
            $this->datang_timbang10->EditAttrs["class"] = "form-control";
            $this->datang_timbang10->EditCustomAttributes = "";
            $this->datang_timbang10->EditValue = HtmlEncode($this->datang_timbang10->CurrentValue);
            $this->datang_timbang10->PlaceHolder = RemoveHtml($this->datang_timbang10->caption());
            if (strval($this->datang_timbang10->EditValue) != "" && is_numeric($this->datang_timbang10->EditValue)) {
                $this->datang_timbang10->EditValue = FormatNumber($this->datang_timbang10->EditValue, -2, -2, -2, -2);
                $this->datang_timbang10->OldValue = $this->datang_timbang10->EditValue;
            }

            // datang_timbang11
            $this->datang_timbang11->EditAttrs["class"] = "form-control";
            $this->datang_timbang11->EditCustomAttributes = "";
            $this->datang_timbang11->EditValue = HtmlEncode($this->datang_timbang11->CurrentValue);
            $this->datang_timbang11->PlaceHolder = RemoveHtml($this->datang_timbang11->caption());
            if (strval($this->datang_timbang11->EditValue) != "" && is_numeric($this->datang_timbang11->EditValue)) {
                $this->datang_timbang11->EditValue = FormatNumber($this->datang_timbang11->EditValue, -2, -2, -2, -2);
                $this->datang_timbang11->OldValue = $this->datang_timbang11->EditValue;
            }

            // datang_timbang12
            $this->datang_timbang12->EditAttrs["class"] = "form-control";
            $this->datang_timbang12->EditCustomAttributes = "";
            $this->datang_timbang12->EditValue = HtmlEncode($this->datang_timbang12->CurrentValue);
            $this->datang_timbang12->PlaceHolder = RemoveHtml($this->datang_timbang12->caption());
            if (strval($this->datang_timbang12->EditValue) != "" && is_numeric($this->datang_timbang12->EditValue)) {
                $this->datang_timbang12->EditValue = FormatNumber($this->datang_timbang12->EditValue, -2, -2, -2, -2);
                $this->datang_timbang12->OldValue = $this->datang_timbang12->EditValue;
            }

            // datang_timbang13
            $this->datang_timbang13->EditAttrs["class"] = "form-control";
            $this->datang_timbang13->EditCustomAttributes = "";
            $this->datang_timbang13->EditValue = HtmlEncode($this->datang_timbang13->CurrentValue);
            $this->datang_timbang13->PlaceHolder = RemoveHtml($this->datang_timbang13->caption());
            if (strval($this->datang_timbang13->EditValue) != "" && is_numeric($this->datang_timbang13->EditValue)) {
                $this->datang_timbang13->EditValue = FormatNumber($this->datang_timbang13->EditValue, -2, -2, -2, -2);
                $this->datang_timbang13->OldValue = $this->datang_timbang13->EditValue;
            }

            // datang_timbang14
            $this->datang_timbang14->EditAttrs["class"] = "form-control";
            $this->datang_timbang14->EditCustomAttributes = "";
            $this->datang_timbang14->EditValue = HtmlEncode($this->datang_timbang14->CurrentValue);
            $this->datang_timbang14->PlaceHolder = RemoveHtml($this->datang_timbang14->caption());
            if (strval($this->datang_timbang14->EditValue) != "" && is_numeric($this->datang_timbang14->EditValue)) {
                $this->datang_timbang14->EditValue = FormatNumber($this->datang_timbang14->EditValue, -2, -2, -2, -2);
                $this->datang_timbang14->OldValue = $this->datang_timbang14->EditValue;
            }

            // datang_timbang15
            $this->datang_timbang15->EditAttrs["class"] = "form-control";
            $this->datang_timbang15->EditCustomAttributes = "";
            $this->datang_timbang15->EditValue = HtmlEncode($this->datang_timbang15->CurrentValue);
            $this->datang_timbang15->PlaceHolder = RemoveHtml($this->datang_timbang15->caption());
            if (strval($this->datang_timbang15->EditValue) != "" && is_numeric($this->datang_timbang15->EditValue)) {
                $this->datang_timbang15->EditValue = FormatNumber($this->datang_timbang15->EditValue, -2, -2, -2, -2);
                $this->datang_timbang15->OldValue = $this->datang_timbang15->EditValue;
            }

            // datang_timbang16
            $this->datang_timbang16->EditAttrs["class"] = "form-control";
            $this->datang_timbang16->EditCustomAttributes = "";
            $this->datang_timbang16->EditValue = HtmlEncode($this->datang_timbang16->CurrentValue);
            $this->datang_timbang16->PlaceHolder = RemoveHtml($this->datang_timbang16->caption());
            if (strval($this->datang_timbang16->EditValue) != "" && is_numeric($this->datang_timbang16->EditValue)) {
                $this->datang_timbang16->EditValue = FormatNumber($this->datang_timbang16->EditValue, -2, -2, -2, -2);
                $this->datang_timbang16->OldValue = $this->datang_timbang16->EditValue;
            }

            // datang_timbang17
            $this->datang_timbang17->EditAttrs["class"] = "form-control";
            $this->datang_timbang17->EditCustomAttributes = "";
            $this->datang_timbang17->EditValue = HtmlEncode($this->datang_timbang17->CurrentValue);
            $this->datang_timbang17->PlaceHolder = RemoveHtml($this->datang_timbang17->caption());
            if (strval($this->datang_timbang17->EditValue) != "" && is_numeric($this->datang_timbang17->EditValue)) {
                $this->datang_timbang17->EditValue = FormatNumber($this->datang_timbang17->EditValue, -2, -2, -2, -2);
                $this->datang_timbang17->OldValue = $this->datang_timbang17->EditValue;
            }

            // datang_timbang18
            $this->datang_timbang18->EditAttrs["class"] = "form-control";
            $this->datang_timbang18->EditCustomAttributes = "";
            $this->datang_timbang18->EditValue = HtmlEncode($this->datang_timbang18->CurrentValue);
            $this->datang_timbang18->PlaceHolder = RemoveHtml($this->datang_timbang18->caption());
            if (strval($this->datang_timbang18->EditValue) != "" && is_numeric($this->datang_timbang18->EditValue)) {
                $this->datang_timbang18->EditValue = FormatNumber($this->datang_timbang18->EditValue, -2, -2, -2, -2);
                $this->datang_timbang18->OldValue = $this->datang_timbang18->EditValue;
            }

            // datang_timbang19
            $this->datang_timbang19->EditAttrs["class"] = "form-control";
            $this->datang_timbang19->EditCustomAttributes = "";
            $this->datang_timbang19->EditValue = HtmlEncode($this->datang_timbang19->CurrentValue);
            $this->datang_timbang19->PlaceHolder = RemoveHtml($this->datang_timbang19->caption());
            if (strval($this->datang_timbang19->EditValue) != "" && is_numeric($this->datang_timbang19->EditValue)) {
                $this->datang_timbang19->EditValue = FormatNumber($this->datang_timbang19->EditValue, -2, -2, -2, -2);
                $this->datang_timbang19->OldValue = $this->datang_timbang19->EditValue;
            }

            // datang_timbang20
            $this->datang_timbang20->EditAttrs["class"] = "form-control";
            $this->datang_timbang20->EditCustomAttributes = "";
            $this->datang_timbang20->EditValue = HtmlEncode($this->datang_timbang20->CurrentValue);
            $this->datang_timbang20->PlaceHolder = RemoveHtml($this->datang_timbang20->caption());
            if (strval($this->datang_timbang20->EditValue) != "" && is_numeric($this->datang_timbang20->EditValue)) {
                $this->datang_timbang20->EditValue = FormatNumber($this->datang_timbang20->EditValue, -2, -2, -2, -2);
                $this->datang_timbang20->OldValue = $this->datang_timbang20->EditValue;
            }

            // datang_timbang21
            $this->datang_timbang21->EditAttrs["class"] = "form-control";
            $this->datang_timbang21->EditCustomAttributes = "";
            $this->datang_timbang21->EditValue = HtmlEncode($this->datang_timbang21->CurrentValue);
            $this->datang_timbang21->PlaceHolder = RemoveHtml($this->datang_timbang21->caption());
            if (strval($this->datang_timbang21->EditValue) != "" && is_numeric($this->datang_timbang21->EditValue)) {
                $this->datang_timbang21->EditValue = FormatNumber($this->datang_timbang21->EditValue, -2, -2, -2, -2);
                $this->datang_timbang21->OldValue = $this->datang_timbang21->EditValue;
            }

            // datang_timbang22
            $this->datang_timbang22->EditAttrs["class"] = "form-control";
            $this->datang_timbang22->EditCustomAttributes = "";
            $this->datang_timbang22->EditValue = HtmlEncode($this->datang_timbang22->CurrentValue);
            $this->datang_timbang22->PlaceHolder = RemoveHtml($this->datang_timbang22->caption());
            if (strval($this->datang_timbang22->EditValue) != "" && is_numeric($this->datang_timbang22->EditValue)) {
                $this->datang_timbang22->EditValue = FormatNumber($this->datang_timbang22->EditValue, -2, -2, -2, -2);
                $this->datang_timbang22->OldValue = $this->datang_timbang22->EditValue;
            }

            // datang_timbang23
            $this->datang_timbang23->EditAttrs["class"] = "form-control";
            $this->datang_timbang23->EditCustomAttributes = "";
            $this->datang_timbang23->EditValue = HtmlEncode($this->datang_timbang23->CurrentValue);
            $this->datang_timbang23->PlaceHolder = RemoveHtml($this->datang_timbang23->caption());
            if (strval($this->datang_timbang23->EditValue) != "" && is_numeric($this->datang_timbang23->EditValue)) {
                $this->datang_timbang23->EditValue = FormatNumber($this->datang_timbang23->EditValue, -2, -2, -2, -2);
                $this->datang_timbang23->OldValue = $this->datang_timbang23->EditValue;
            }

            // datang_timbang24
            $this->datang_timbang24->EditAttrs["class"] = "form-control";
            $this->datang_timbang24->EditCustomAttributes = "";
            $this->datang_timbang24->EditValue = HtmlEncode($this->datang_timbang24->CurrentValue);
            $this->datang_timbang24->PlaceHolder = RemoveHtml($this->datang_timbang24->caption());
            if (strval($this->datang_timbang24->EditValue) != "" && is_numeric($this->datang_timbang24->EditValue)) {
                $this->datang_timbang24->EditValue = FormatNumber($this->datang_timbang24->EditValue, -2, -2, -2, -2);
                $this->datang_timbang24->OldValue = $this->datang_timbang24->EditValue;
            }

            // datang_timbang25
            $this->datang_timbang25->EditAttrs["class"] = "form-control";
            $this->datang_timbang25->EditCustomAttributes = "";
            $this->datang_timbang25->EditValue = HtmlEncode($this->datang_timbang25->CurrentValue);
            $this->datang_timbang25->PlaceHolder = RemoveHtml($this->datang_timbang25->caption());
            if (strval($this->datang_timbang25->EditValue) != "" && is_numeric($this->datang_timbang25->EditValue)) {
                $this->datang_timbang25->EditValue = FormatNumber($this->datang_timbang25->EditValue, -2, -2, -2, -2);
                $this->datang_timbang25->OldValue = $this->datang_timbang25->EditValue;
            }

            // datang_jumlah
            $this->datang_jumlah->EditAttrs["class"] = "form-control";
            $this->datang_jumlah->EditCustomAttributes = "";
            $this->datang_jumlah->EditValue = HtmlEncode($this->datang_jumlah->CurrentValue);
            $this->datang_jumlah->PlaceHolder = RemoveHtml($this->datang_jumlah->caption());
            if (strval($this->datang_jumlah->EditValue) != "" && is_numeric($this->datang_jumlah->EditValue)) {
                $this->datang_jumlah->EditValue = FormatNumber($this->datang_jumlah->EditValue, -2, -2, -2, -2);
                $this->datang_jumlah->OldValue = $this->datang_jumlah->EditValue;
            }

            // datang_jumlah_karung
            $this->datang_jumlah_karung->EditAttrs["class"] = "form-control";
            $this->datang_jumlah_karung->EditCustomAttributes = "";
            $this->datang_jumlah_karung->EditValue = HtmlEncode($this->datang_jumlah_karung->CurrentValue);
            $this->datang_jumlah_karung->PlaceHolder = RemoveHtml($this->datang_jumlah_karung->caption());
            if (strval($this->datang_jumlah_karung->EditValue) != "" && is_numeric($this->datang_jumlah_karung->EditValue)) {
                $this->datang_jumlah_karung->EditValue = FormatNumber($this->datang_jumlah_karung->EditValue, -2, -2, -2, -2);
                $this->datang_jumlah_karung->OldValue = $this->datang_jumlah_karung->EditValue;
            }

            // datang_berat_bersih
            $this->datang_berat_bersih->EditAttrs["class"] = "form-control";
            $this->datang_berat_bersih->EditCustomAttributes = "";
            $this->datang_berat_bersih->EditValue = HtmlEncode($this->datang_berat_bersih->CurrentValue);
            $this->datang_berat_bersih->PlaceHolder = RemoveHtml($this->datang_berat_bersih->caption());
            if (strval($this->datang_berat_bersih->EditValue) != "" && is_numeric($this->datang_berat_bersih->EditValue)) {
                $this->datang_berat_bersih->EditValue = FormatNumber($this->datang_berat_bersih->EditValue, -2, -2, -2, -2);
                $this->datang_berat_bersih->OldValue = $this->datang_berat_bersih->EditValue;
            }

            // datang_catatan
            $this->datang_catatan->EditAttrs["class"] = "form-control";
            $this->datang_catatan->EditCustomAttributes = "";
            $this->datang_catatan->EditValue = HtmlEncode($this->datang_catatan->CurrentValue);
            $this->datang_catatan->PlaceHolder = RemoveHtml($this->datang_catatan->caption());

            // Add refer script

            // datang_id
            $this->datang_id->LinkCustomAttributes = "";
            $this->datang_id->HrefValue = "";

            // datang_petugas
            $this->datang_petugas->LinkCustomAttributes = "";
            $this->datang_petugas->HrefValue = "";

            // datang_tanggal
            $this->datang_tanggal->LinkCustomAttributes = "";
            $this->datang_tanggal->HrefValue = "";

            // datang_varietas
            $this->datang_varietas->LinkCustomAttributes = "";
            $this->datang_varietas->HrefValue = "";

            // datang_sup
            $this->datang_sup->LinkCustomAttributes = "";
            $this->datang_sup->HrefValue = "";

            // datang_timbang1
            $this->datang_timbang1->LinkCustomAttributes = "";
            $this->datang_timbang1->HrefValue = "";

            // datang_timbang2
            $this->datang_timbang2->LinkCustomAttributes = "";
            $this->datang_timbang2->HrefValue = "";

            // datang_timbang3
            $this->datang_timbang3->LinkCustomAttributes = "";
            $this->datang_timbang3->HrefValue = "";

            // datang_timbang4
            $this->datang_timbang4->LinkCustomAttributes = "";
            $this->datang_timbang4->HrefValue = "";

            // datang_timbang5
            $this->datang_timbang5->LinkCustomAttributes = "";
            $this->datang_timbang5->HrefValue = "";

            // datang_timbang6
            $this->datang_timbang6->LinkCustomAttributes = "";
            $this->datang_timbang6->HrefValue = "";

            // datang_timbang7
            $this->datang_timbang7->LinkCustomAttributes = "";
            $this->datang_timbang7->HrefValue = "";

            // datang_timbang8
            $this->datang_timbang8->LinkCustomAttributes = "";
            $this->datang_timbang8->HrefValue = "";

            // datang_timbang9
            $this->datang_timbang9->LinkCustomAttributes = "";
            $this->datang_timbang9->HrefValue = "";

            // datang_timbang10
            $this->datang_timbang10->LinkCustomAttributes = "";
            $this->datang_timbang10->HrefValue = "";

            // datang_timbang11
            $this->datang_timbang11->LinkCustomAttributes = "";
            $this->datang_timbang11->HrefValue = "";

            // datang_timbang12
            $this->datang_timbang12->LinkCustomAttributes = "";
            $this->datang_timbang12->HrefValue = "";

            // datang_timbang13
            $this->datang_timbang13->LinkCustomAttributes = "";
            $this->datang_timbang13->HrefValue = "";

            // datang_timbang14
            $this->datang_timbang14->LinkCustomAttributes = "";
            $this->datang_timbang14->HrefValue = "";

            // datang_timbang15
            $this->datang_timbang15->LinkCustomAttributes = "";
            $this->datang_timbang15->HrefValue = "";

            // datang_timbang16
            $this->datang_timbang16->LinkCustomAttributes = "";
            $this->datang_timbang16->HrefValue = "";

            // datang_timbang17
            $this->datang_timbang17->LinkCustomAttributes = "";
            $this->datang_timbang17->HrefValue = "";

            // datang_timbang18
            $this->datang_timbang18->LinkCustomAttributes = "";
            $this->datang_timbang18->HrefValue = "";

            // datang_timbang19
            $this->datang_timbang19->LinkCustomAttributes = "";
            $this->datang_timbang19->HrefValue = "";

            // datang_timbang20
            $this->datang_timbang20->LinkCustomAttributes = "";
            $this->datang_timbang20->HrefValue = "";

            // datang_timbang21
            $this->datang_timbang21->LinkCustomAttributes = "";
            $this->datang_timbang21->HrefValue = "";

            // datang_timbang22
            $this->datang_timbang22->LinkCustomAttributes = "";
            $this->datang_timbang22->HrefValue = "";

            // datang_timbang23
            $this->datang_timbang23->LinkCustomAttributes = "";
            $this->datang_timbang23->HrefValue = "";

            // datang_timbang24
            $this->datang_timbang24->LinkCustomAttributes = "";
            $this->datang_timbang24->HrefValue = "";

            // datang_timbang25
            $this->datang_timbang25->LinkCustomAttributes = "";
            $this->datang_timbang25->HrefValue = "";

            // datang_jumlah
            $this->datang_jumlah->LinkCustomAttributes = "";
            $this->datang_jumlah->HrefValue = "";

            // datang_jumlah_karung
            $this->datang_jumlah_karung->LinkCustomAttributes = "";
            $this->datang_jumlah_karung->HrefValue = "";

            // datang_berat_bersih
            $this->datang_berat_bersih->LinkCustomAttributes = "";
            $this->datang_berat_bersih->HrefValue = "";

            // datang_catatan
            $this->datang_catatan->LinkCustomAttributes = "";
            $this->datang_catatan->HrefValue = "";
        } elseif ($this->RowType == ROWTYPE_SEARCH) {
            // datang_id
            $this->datang_id->EditAttrs["class"] = "form-control";
            $this->datang_id->EditCustomAttributes = "";
            $this->datang_id->EditValue = HtmlEncode($this->datang_id->AdvancedSearch->SearchValue);
            $this->datang_id->PlaceHolder = RemoveHtml($this->datang_id->caption());

            // datang_petugas
            $this->datang_petugas->EditAttrs["class"] = "form-control";
            $this->datang_petugas->EditCustomAttributes = "";
            if (!$this->datang_petugas->Raw) {
                $this->datang_petugas->AdvancedSearch->SearchValue = HtmlDecode($this->datang_petugas->AdvancedSearch->SearchValue);
            }
            $this->datang_petugas->EditValue = HtmlEncode($this->datang_petugas->AdvancedSearch->SearchValue);
            $this->datang_petugas->PlaceHolder = RemoveHtml($this->datang_petugas->caption());

            // datang_tanggal
            $this->datang_tanggal->EditAttrs["class"] = "form-control";
            $this->datang_tanggal->EditCustomAttributes = "";
            $this->datang_tanggal->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datang_tanggal->AdvancedSearch->SearchValue, 0), 8));
            $this->datang_tanggal->PlaceHolder = RemoveHtml($this->datang_tanggal->caption());
            $this->datang_tanggal->EditAttrs["class"] = "form-control";
            $this->datang_tanggal->EditCustomAttributes = "";
            $this->datang_tanggal->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datang_tanggal->AdvancedSearch->SearchValue2, 0), 8));
            $this->datang_tanggal->PlaceHolder = RemoveHtml($this->datang_tanggal->caption());

            // datang_varietas
            $this->datang_varietas->EditAttrs["class"] = "form-control";
            $this->datang_varietas->EditCustomAttributes = "";
            $curVal = trim(strval($this->datang_varietas->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->datang_varietas->AdvancedSearch->ViewValue = $this->datang_varietas->lookupCacheOption($curVal);
            } else {
                $this->datang_varietas->AdvancedSearch->ViewValue = $this->datang_varietas->Lookup !== null && is_array($this->datang_varietas->Lookup->Options) ? $curVal : null;
            }
            if ($this->datang_varietas->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->datang_varietas->EditValue = array_values($this->datang_varietas->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`var_id`" . SearchString("=", $this->datang_varietas->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->datang_varietas->Lookup->getSql(true, $filterWrk, '', $this);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->datang_varietas->EditValue = $arwrk;
            }
            $this->datang_varietas->PlaceHolder = RemoveHtml($this->datang_varietas->caption());

            // datang_sup
            $this->datang_sup->EditAttrs["class"] = "form-control";
            $this->datang_sup->EditCustomAttributes = "";
            $curVal = trim(strval($this->datang_sup->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->datang_sup->AdvancedSearch->ViewValue = $this->datang_sup->lookupCacheOption($curVal);
            } else {
                $this->datang_sup->AdvancedSearch->ViewValue = $this->datang_sup->Lookup !== null && is_array($this->datang_sup->Lookup->Options) ? $curVal : null;
            }
            if ($this->datang_sup->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->datang_sup->EditValue = array_values($this->datang_sup->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`sup_id`" . SearchString("=", $this->datang_sup->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->datang_sup->Lookup->getSql(true, $filterWrk, '', $this);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->datang_sup->EditValue = $arwrk;
            }
            $this->datang_sup->PlaceHolder = RemoveHtml($this->datang_sup->caption());

            // datang_timbang1
            $this->datang_timbang1->EditAttrs["class"] = "form-control";
            $this->datang_timbang1->EditCustomAttributes = "";
            $this->datang_timbang1->EditValue = HtmlEncode($this->datang_timbang1->AdvancedSearch->SearchValue);
            $this->datang_timbang1->PlaceHolder = RemoveHtml($this->datang_timbang1->caption());

            // datang_timbang2
            $this->datang_timbang2->EditAttrs["class"] = "form-control";
            $this->datang_timbang2->EditCustomAttributes = "";
            $this->datang_timbang2->EditValue = HtmlEncode($this->datang_timbang2->AdvancedSearch->SearchValue);
            $this->datang_timbang2->PlaceHolder = RemoveHtml($this->datang_timbang2->caption());

            // datang_timbang3
            $this->datang_timbang3->EditAttrs["class"] = "form-control";
            $this->datang_timbang3->EditCustomAttributes = "";
            $this->datang_timbang3->EditValue = HtmlEncode($this->datang_timbang3->AdvancedSearch->SearchValue);
            $this->datang_timbang3->PlaceHolder = RemoveHtml($this->datang_timbang3->caption());

            // datang_timbang4
            $this->datang_timbang4->EditAttrs["class"] = "form-control";
            $this->datang_timbang4->EditCustomAttributes = "";
            $this->datang_timbang4->EditValue = HtmlEncode($this->datang_timbang4->AdvancedSearch->SearchValue);
            $this->datang_timbang4->PlaceHolder = RemoveHtml($this->datang_timbang4->caption());

            // datang_timbang5
            $this->datang_timbang5->EditAttrs["class"] = "form-control";
            $this->datang_timbang5->EditCustomAttributes = "";
            $this->datang_timbang5->EditValue = HtmlEncode($this->datang_timbang5->AdvancedSearch->SearchValue);
            $this->datang_timbang5->PlaceHolder = RemoveHtml($this->datang_timbang5->caption());

            // datang_timbang6
            $this->datang_timbang6->EditAttrs["class"] = "form-control";
            $this->datang_timbang6->EditCustomAttributes = "";
            $this->datang_timbang6->EditValue = HtmlEncode($this->datang_timbang6->AdvancedSearch->SearchValue);
            $this->datang_timbang6->PlaceHolder = RemoveHtml($this->datang_timbang6->caption());

            // datang_timbang7
            $this->datang_timbang7->EditAttrs["class"] = "form-control";
            $this->datang_timbang7->EditCustomAttributes = "";
            $this->datang_timbang7->EditValue = HtmlEncode($this->datang_timbang7->AdvancedSearch->SearchValue);
            $this->datang_timbang7->PlaceHolder = RemoveHtml($this->datang_timbang7->caption());

            // datang_timbang8
            $this->datang_timbang8->EditAttrs["class"] = "form-control";
            $this->datang_timbang8->EditCustomAttributes = "";
            $this->datang_timbang8->EditValue = HtmlEncode($this->datang_timbang8->AdvancedSearch->SearchValue);
            $this->datang_timbang8->PlaceHolder = RemoveHtml($this->datang_timbang8->caption());

            // datang_timbang9
            $this->datang_timbang9->EditAttrs["class"] = "form-control";
            $this->datang_timbang9->EditCustomAttributes = "";
            $this->datang_timbang9->EditValue = HtmlEncode($this->datang_timbang9->AdvancedSearch->SearchValue);
            $this->datang_timbang9->PlaceHolder = RemoveHtml($this->datang_timbang9->caption());

            // datang_timbang10
            $this->datang_timbang10->EditAttrs["class"] = "form-control";
            $this->datang_timbang10->EditCustomAttributes = "";
            $this->datang_timbang10->EditValue = HtmlEncode($this->datang_timbang10->AdvancedSearch->SearchValue);
            $this->datang_timbang10->PlaceHolder = RemoveHtml($this->datang_timbang10->caption());

            // datang_timbang11
            $this->datang_timbang11->EditAttrs["class"] = "form-control";
            $this->datang_timbang11->EditCustomAttributes = "";
            $this->datang_timbang11->EditValue = HtmlEncode($this->datang_timbang11->AdvancedSearch->SearchValue);
            $this->datang_timbang11->PlaceHolder = RemoveHtml($this->datang_timbang11->caption());

            // datang_timbang12
            $this->datang_timbang12->EditAttrs["class"] = "form-control";
            $this->datang_timbang12->EditCustomAttributes = "";
            $this->datang_timbang12->EditValue = HtmlEncode($this->datang_timbang12->AdvancedSearch->SearchValue);
            $this->datang_timbang12->PlaceHolder = RemoveHtml($this->datang_timbang12->caption());

            // datang_timbang13
            $this->datang_timbang13->EditAttrs["class"] = "form-control";
            $this->datang_timbang13->EditCustomAttributes = "";
            $this->datang_timbang13->EditValue = HtmlEncode($this->datang_timbang13->AdvancedSearch->SearchValue);
            $this->datang_timbang13->PlaceHolder = RemoveHtml($this->datang_timbang13->caption());

            // datang_timbang14
            $this->datang_timbang14->EditAttrs["class"] = "form-control";
            $this->datang_timbang14->EditCustomAttributes = "";
            $this->datang_timbang14->EditValue = HtmlEncode($this->datang_timbang14->AdvancedSearch->SearchValue);
            $this->datang_timbang14->PlaceHolder = RemoveHtml($this->datang_timbang14->caption());

            // datang_timbang15
            $this->datang_timbang15->EditAttrs["class"] = "form-control";
            $this->datang_timbang15->EditCustomAttributes = "";
            $this->datang_timbang15->EditValue = HtmlEncode($this->datang_timbang15->AdvancedSearch->SearchValue);
            $this->datang_timbang15->PlaceHolder = RemoveHtml($this->datang_timbang15->caption());

            // datang_timbang16
            $this->datang_timbang16->EditAttrs["class"] = "form-control";
            $this->datang_timbang16->EditCustomAttributes = "";
            $this->datang_timbang16->EditValue = HtmlEncode($this->datang_timbang16->AdvancedSearch->SearchValue);
            $this->datang_timbang16->PlaceHolder = RemoveHtml($this->datang_timbang16->caption());

            // datang_timbang17
            $this->datang_timbang17->EditAttrs["class"] = "form-control";
            $this->datang_timbang17->EditCustomAttributes = "";
            $this->datang_timbang17->EditValue = HtmlEncode($this->datang_timbang17->AdvancedSearch->SearchValue);
            $this->datang_timbang17->PlaceHolder = RemoveHtml($this->datang_timbang17->caption());

            // datang_timbang18
            $this->datang_timbang18->EditAttrs["class"] = "form-control";
            $this->datang_timbang18->EditCustomAttributes = "";
            $this->datang_timbang18->EditValue = HtmlEncode($this->datang_timbang18->AdvancedSearch->SearchValue);
            $this->datang_timbang18->PlaceHolder = RemoveHtml($this->datang_timbang18->caption());

            // datang_timbang19
            $this->datang_timbang19->EditAttrs["class"] = "form-control";
            $this->datang_timbang19->EditCustomAttributes = "";
            $this->datang_timbang19->EditValue = HtmlEncode($this->datang_timbang19->AdvancedSearch->SearchValue);
            $this->datang_timbang19->PlaceHolder = RemoveHtml($this->datang_timbang19->caption());

            // datang_timbang20
            $this->datang_timbang20->EditAttrs["class"] = "form-control";
            $this->datang_timbang20->EditCustomAttributes = "";
            $this->datang_timbang20->EditValue = HtmlEncode($this->datang_timbang20->AdvancedSearch->SearchValue);
            $this->datang_timbang20->PlaceHolder = RemoveHtml($this->datang_timbang20->caption());

            // datang_timbang21
            $this->datang_timbang21->EditAttrs["class"] = "form-control";
            $this->datang_timbang21->EditCustomAttributes = "";
            $this->datang_timbang21->EditValue = HtmlEncode($this->datang_timbang21->AdvancedSearch->SearchValue);
            $this->datang_timbang21->PlaceHolder = RemoveHtml($this->datang_timbang21->caption());

            // datang_timbang22
            $this->datang_timbang22->EditAttrs["class"] = "form-control";
            $this->datang_timbang22->EditCustomAttributes = "";
            $this->datang_timbang22->EditValue = HtmlEncode($this->datang_timbang22->AdvancedSearch->SearchValue);
            $this->datang_timbang22->PlaceHolder = RemoveHtml($this->datang_timbang22->caption());

            // datang_timbang23
            $this->datang_timbang23->EditAttrs["class"] = "form-control";
            $this->datang_timbang23->EditCustomAttributes = "";
            $this->datang_timbang23->EditValue = HtmlEncode($this->datang_timbang23->AdvancedSearch->SearchValue);
            $this->datang_timbang23->PlaceHolder = RemoveHtml($this->datang_timbang23->caption());

            // datang_timbang24
            $this->datang_timbang24->EditAttrs["class"] = "form-control";
            $this->datang_timbang24->EditCustomAttributes = "";
            $this->datang_timbang24->EditValue = HtmlEncode($this->datang_timbang24->AdvancedSearch->SearchValue);
            $this->datang_timbang24->PlaceHolder = RemoveHtml($this->datang_timbang24->caption());

            // datang_timbang25
            $this->datang_timbang25->EditAttrs["class"] = "form-control";
            $this->datang_timbang25->EditCustomAttributes = "";
            $this->datang_timbang25->EditValue = HtmlEncode($this->datang_timbang25->AdvancedSearch->SearchValue);
            $this->datang_timbang25->PlaceHolder = RemoveHtml($this->datang_timbang25->caption());

            // datang_jumlah
            $this->datang_jumlah->EditAttrs["class"] = "form-control";
            $this->datang_jumlah->EditCustomAttributes = "";
            $this->datang_jumlah->EditValue = HtmlEncode($this->datang_jumlah->AdvancedSearch->SearchValue);
            $this->datang_jumlah->PlaceHolder = RemoveHtml($this->datang_jumlah->caption());

            // datang_jumlah_karung
            $this->datang_jumlah_karung->EditAttrs["class"] = "form-control";
            $this->datang_jumlah_karung->EditCustomAttributes = "";
            $this->datang_jumlah_karung->EditValue = HtmlEncode($this->datang_jumlah_karung->AdvancedSearch->SearchValue);
            $this->datang_jumlah_karung->PlaceHolder = RemoveHtml($this->datang_jumlah_karung->caption());

            // datang_berat_bersih
            $this->datang_berat_bersih->EditAttrs["class"] = "form-control";
            $this->datang_berat_bersih->EditCustomAttributes = "";
            $this->datang_berat_bersih->EditValue = HtmlEncode($this->datang_berat_bersih->AdvancedSearch->SearchValue);
            $this->datang_berat_bersih->PlaceHolder = RemoveHtml($this->datang_berat_bersih->caption());

            // datang_catatan
            $this->datang_catatan->EditAttrs["class"] = "form-control";
            $this->datang_catatan->EditCustomAttributes = "";
            $this->datang_catatan->EditValue = HtmlEncode($this->datang_catatan->AdvancedSearch->SearchValue);
            $this->datang_catatan->PlaceHolder = RemoveHtml($this->datang_catatan->caption());
        }
        if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckDate($this->datang_tanggal->AdvancedSearch->SearchValue)) {
            $this->datang_tanggal->addErrorMessage($this->datang_tanggal->getErrorMessage(false));
        }
        if (!CheckDate($this->datang_tanggal->AdvancedSearch->SearchValue2)) {
            $this->datang_tanggal->addErrorMessage($this->datang_tanggal->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Validate form
    protected function validateForm()
    {
        global $Language;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if ($this->datang_id->Required) {
            if (!$this->datang_id->IsDetailKey && EmptyValue($this->datang_id->FormValue)) {
                $this->datang_id->addErrorMessage(str_replace("%s", $this->datang_id->caption(), $this->datang_id->RequiredErrorMessage));
            }
        }
        if ($this->datang_petugas->Required) {
            if (!$this->datang_petugas->IsDetailKey && EmptyValue($this->datang_petugas->FormValue)) {
                $this->datang_petugas->addErrorMessage(str_replace("%s", $this->datang_petugas->caption(), $this->datang_petugas->RequiredErrorMessage));
            }
        }
        if ($this->datang_tanggal->Required) {
            if (!$this->datang_tanggal->IsDetailKey && EmptyValue($this->datang_tanggal->FormValue)) {
                $this->datang_tanggal->addErrorMessage(str_replace("%s", $this->datang_tanggal->caption(), $this->datang_tanggal->RequiredErrorMessage));
            }
        }
        if (!CheckDate($this->datang_tanggal->FormValue)) {
            $this->datang_tanggal->addErrorMessage($this->datang_tanggal->getErrorMessage(false));
        }
        if ($this->datang_varietas->Required) {
            if (!$this->datang_varietas->IsDetailKey && EmptyValue($this->datang_varietas->FormValue)) {
                $this->datang_varietas->addErrorMessage(str_replace("%s", $this->datang_varietas->caption(), $this->datang_varietas->RequiredErrorMessage));
            }
        }
        if ($this->datang_sup->Required) {
            if (!$this->datang_sup->IsDetailKey && EmptyValue($this->datang_sup->FormValue)) {
                $this->datang_sup->addErrorMessage(str_replace("%s", $this->datang_sup->caption(), $this->datang_sup->RequiredErrorMessage));
            }
        }
        if ($this->datang_timbang1->Required) {
            if (!$this->datang_timbang1->IsDetailKey && EmptyValue($this->datang_timbang1->FormValue)) {
                $this->datang_timbang1->addErrorMessage(str_replace("%s", $this->datang_timbang1->caption(), $this->datang_timbang1->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->datang_timbang1->FormValue)) {
            $this->datang_timbang1->addErrorMessage($this->datang_timbang1->getErrorMessage(false));
        }
        if ($this->datang_timbang2->Required) {
            if (!$this->datang_timbang2->IsDetailKey && EmptyValue($this->datang_timbang2->FormValue)) {
                $this->datang_timbang2->addErrorMessage(str_replace("%s", $this->datang_timbang2->caption(), $this->datang_timbang2->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->datang_timbang2->FormValue)) {
            $this->datang_timbang2->addErrorMessage($this->datang_timbang2->getErrorMessage(false));
        }
        if ($this->datang_timbang3->Required) {
            if (!$this->datang_timbang3->IsDetailKey && EmptyValue($this->datang_timbang3->FormValue)) {
                $this->datang_timbang3->addErrorMessage(str_replace("%s", $this->datang_timbang3->caption(), $this->datang_timbang3->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->datang_timbang3->FormValue)) {
            $this->datang_timbang3->addErrorMessage($this->datang_timbang3->getErrorMessage(false));
        }
        if ($this->datang_timbang4->Required) {
            if (!$this->datang_timbang4->IsDetailKey && EmptyValue($this->datang_timbang4->FormValue)) {
                $this->datang_timbang4->addErrorMessage(str_replace("%s", $this->datang_timbang4->caption(), $this->datang_timbang4->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->datang_timbang4->FormValue)) {
            $this->datang_timbang4->addErrorMessage($this->datang_timbang4->getErrorMessage(false));
        }
        if ($this->datang_timbang5->Required) {
            if (!$this->datang_timbang5->IsDetailKey && EmptyValue($this->datang_timbang5->FormValue)) {
                $this->datang_timbang5->addErrorMessage(str_replace("%s", $this->datang_timbang5->caption(), $this->datang_timbang5->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->datang_timbang5->FormValue)) {
            $this->datang_timbang5->addErrorMessage($this->datang_timbang5->getErrorMessage(false));
        }
        if ($this->datang_timbang6->Required) {
            if (!$this->datang_timbang6->IsDetailKey && EmptyValue($this->datang_timbang6->FormValue)) {
                $this->datang_timbang6->addErrorMessage(str_replace("%s", $this->datang_timbang6->caption(), $this->datang_timbang6->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->datang_timbang6->FormValue)) {
            $this->datang_timbang6->addErrorMessage($this->datang_timbang6->getErrorMessage(false));
        }
        if ($this->datang_timbang7->Required) {
            if (!$this->datang_timbang7->IsDetailKey && EmptyValue($this->datang_timbang7->FormValue)) {
                $this->datang_timbang7->addErrorMessage(str_replace("%s", $this->datang_timbang7->caption(), $this->datang_timbang7->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->datang_timbang7->FormValue)) {
            $this->datang_timbang7->addErrorMessage($this->datang_timbang7->getErrorMessage(false));
        }
        if ($this->datang_timbang8->Required) {
            if (!$this->datang_timbang8->IsDetailKey && EmptyValue($this->datang_timbang8->FormValue)) {
                $this->datang_timbang8->addErrorMessage(str_replace("%s", $this->datang_timbang8->caption(), $this->datang_timbang8->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->datang_timbang8->FormValue)) {
            $this->datang_timbang8->addErrorMessage($this->datang_timbang8->getErrorMessage(false));
        }
        if ($this->datang_timbang9->Required) {
            if (!$this->datang_timbang9->IsDetailKey && EmptyValue($this->datang_timbang9->FormValue)) {
                $this->datang_timbang9->addErrorMessage(str_replace("%s", $this->datang_timbang9->caption(), $this->datang_timbang9->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->datang_timbang9->FormValue)) {
            $this->datang_timbang9->addErrorMessage($this->datang_timbang9->getErrorMessage(false));
        }
        if ($this->datang_timbang10->Required) {
            if (!$this->datang_timbang10->IsDetailKey && EmptyValue($this->datang_timbang10->FormValue)) {
                $this->datang_timbang10->addErrorMessage(str_replace("%s", $this->datang_timbang10->caption(), $this->datang_timbang10->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->datang_timbang10->FormValue)) {
            $this->datang_timbang10->addErrorMessage($this->datang_timbang10->getErrorMessage(false));
        }
        if ($this->datang_timbang11->Required) {
            if (!$this->datang_timbang11->IsDetailKey && EmptyValue($this->datang_timbang11->FormValue)) {
                $this->datang_timbang11->addErrorMessage(str_replace("%s", $this->datang_timbang11->caption(), $this->datang_timbang11->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->datang_timbang11->FormValue)) {
            $this->datang_timbang11->addErrorMessage($this->datang_timbang11->getErrorMessage(false));
        }
        if ($this->datang_timbang12->Required) {
            if (!$this->datang_timbang12->IsDetailKey && EmptyValue($this->datang_timbang12->FormValue)) {
                $this->datang_timbang12->addErrorMessage(str_replace("%s", $this->datang_timbang12->caption(), $this->datang_timbang12->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->datang_timbang12->FormValue)) {
            $this->datang_timbang12->addErrorMessage($this->datang_timbang12->getErrorMessage(false));
        }
        if ($this->datang_timbang13->Required) {
            if (!$this->datang_timbang13->IsDetailKey && EmptyValue($this->datang_timbang13->FormValue)) {
                $this->datang_timbang13->addErrorMessage(str_replace("%s", $this->datang_timbang13->caption(), $this->datang_timbang13->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->datang_timbang13->FormValue)) {
            $this->datang_timbang13->addErrorMessage($this->datang_timbang13->getErrorMessage(false));
        }
        if ($this->datang_timbang14->Required) {
            if (!$this->datang_timbang14->IsDetailKey && EmptyValue($this->datang_timbang14->FormValue)) {
                $this->datang_timbang14->addErrorMessage(str_replace("%s", $this->datang_timbang14->caption(), $this->datang_timbang14->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->datang_timbang14->FormValue)) {
            $this->datang_timbang14->addErrorMessage($this->datang_timbang14->getErrorMessage(false));
        }
        if ($this->datang_timbang15->Required) {
            if (!$this->datang_timbang15->IsDetailKey && EmptyValue($this->datang_timbang15->FormValue)) {
                $this->datang_timbang15->addErrorMessage(str_replace("%s", $this->datang_timbang15->caption(), $this->datang_timbang15->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->datang_timbang15->FormValue)) {
            $this->datang_timbang15->addErrorMessage($this->datang_timbang15->getErrorMessage(false));
        }
        if ($this->datang_timbang16->Required) {
            if (!$this->datang_timbang16->IsDetailKey && EmptyValue($this->datang_timbang16->FormValue)) {
                $this->datang_timbang16->addErrorMessage(str_replace("%s", $this->datang_timbang16->caption(), $this->datang_timbang16->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->datang_timbang16->FormValue)) {
            $this->datang_timbang16->addErrorMessage($this->datang_timbang16->getErrorMessage(false));
        }
        if ($this->datang_timbang17->Required) {
            if (!$this->datang_timbang17->IsDetailKey && EmptyValue($this->datang_timbang17->FormValue)) {
                $this->datang_timbang17->addErrorMessage(str_replace("%s", $this->datang_timbang17->caption(), $this->datang_timbang17->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->datang_timbang17->FormValue)) {
            $this->datang_timbang17->addErrorMessage($this->datang_timbang17->getErrorMessage(false));
        }
        if ($this->datang_timbang18->Required) {
            if (!$this->datang_timbang18->IsDetailKey && EmptyValue($this->datang_timbang18->FormValue)) {
                $this->datang_timbang18->addErrorMessage(str_replace("%s", $this->datang_timbang18->caption(), $this->datang_timbang18->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->datang_timbang18->FormValue)) {
            $this->datang_timbang18->addErrorMessage($this->datang_timbang18->getErrorMessage(false));
        }
        if ($this->datang_timbang19->Required) {
            if (!$this->datang_timbang19->IsDetailKey && EmptyValue($this->datang_timbang19->FormValue)) {
                $this->datang_timbang19->addErrorMessage(str_replace("%s", $this->datang_timbang19->caption(), $this->datang_timbang19->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->datang_timbang19->FormValue)) {
            $this->datang_timbang19->addErrorMessage($this->datang_timbang19->getErrorMessage(false));
        }
        if ($this->datang_timbang20->Required) {
            if (!$this->datang_timbang20->IsDetailKey && EmptyValue($this->datang_timbang20->FormValue)) {
                $this->datang_timbang20->addErrorMessage(str_replace("%s", $this->datang_timbang20->caption(), $this->datang_timbang20->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->datang_timbang20->FormValue)) {
            $this->datang_timbang20->addErrorMessage($this->datang_timbang20->getErrorMessage(false));
        }
        if ($this->datang_timbang21->Required) {
            if (!$this->datang_timbang21->IsDetailKey && EmptyValue($this->datang_timbang21->FormValue)) {
                $this->datang_timbang21->addErrorMessage(str_replace("%s", $this->datang_timbang21->caption(), $this->datang_timbang21->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->datang_timbang21->FormValue)) {
            $this->datang_timbang21->addErrorMessage($this->datang_timbang21->getErrorMessage(false));
        }
        if ($this->datang_timbang22->Required) {
            if (!$this->datang_timbang22->IsDetailKey && EmptyValue($this->datang_timbang22->FormValue)) {
                $this->datang_timbang22->addErrorMessage(str_replace("%s", $this->datang_timbang22->caption(), $this->datang_timbang22->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->datang_timbang22->FormValue)) {
            $this->datang_timbang22->addErrorMessage($this->datang_timbang22->getErrorMessage(false));
        }
        if ($this->datang_timbang23->Required) {
            if (!$this->datang_timbang23->IsDetailKey && EmptyValue($this->datang_timbang23->FormValue)) {
                $this->datang_timbang23->addErrorMessage(str_replace("%s", $this->datang_timbang23->caption(), $this->datang_timbang23->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->datang_timbang23->FormValue)) {
            $this->datang_timbang23->addErrorMessage($this->datang_timbang23->getErrorMessage(false));
        }
        if ($this->datang_timbang24->Required) {
            if (!$this->datang_timbang24->IsDetailKey && EmptyValue($this->datang_timbang24->FormValue)) {
                $this->datang_timbang24->addErrorMessage(str_replace("%s", $this->datang_timbang24->caption(), $this->datang_timbang24->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->datang_timbang24->FormValue)) {
            $this->datang_timbang24->addErrorMessage($this->datang_timbang24->getErrorMessage(false));
        }
        if ($this->datang_timbang25->Required) {
            if (!$this->datang_timbang25->IsDetailKey && EmptyValue($this->datang_timbang25->FormValue)) {
                $this->datang_timbang25->addErrorMessage(str_replace("%s", $this->datang_timbang25->caption(), $this->datang_timbang25->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->datang_timbang25->FormValue)) {
            $this->datang_timbang25->addErrorMessage($this->datang_timbang25->getErrorMessage(false));
        }
        if ($this->datang_jumlah->Required) {
            if (!$this->datang_jumlah->IsDetailKey && EmptyValue($this->datang_jumlah->FormValue)) {
                $this->datang_jumlah->addErrorMessage(str_replace("%s", $this->datang_jumlah->caption(), $this->datang_jumlah->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->datang_jumlah->FormValue)) {
            $this->datang_jumlah->addErrorMessage($this->datang_jumlah->getErrorMessage(false));
        }
        if ($this->datang_jumlah_karung->Required) {
            if (!$this->datang_jumlah_karung->IsDetailKey && EmptyValue($this->datang_jumlah_karung->FormValue)) {
                $this->datang_jumlah_karung->addErrorMessage(str_replace("%s", $this->datang_jumlah_karung->caption(), $this->datang_jumlah_karung->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->datang_jumlah_karung->FormValue)) {
            $this->datang_jumlah_karung->addErrorMessage($this->datang_jumlah_karung->getErrorMessage(false));
        }
        if ($this->datang_berat_bersih->Required) {
            if (!$this->datang_berat_bersih->IsDetailKey && EmptyValue($this->datang_berat_bersih->FormValue)) {
                $this->datang_berat_bersih->addErrorMessage(str_replace("%s", $this->datang_berat_bersih->caption(), $this->datang_berat_bersih->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->datang_berat_bersih->FormValue)) {
            $this->datang_berat_bersih->addErrorMessage($this->datang_berat_bersih->getErrorMessage(false));
        }
        if ($this->datang_catatan->Required) {
            if (!$this->datang_catatan->IsDetailKey && EmptyValue($this->datang_catatan->FormValue)) {
                $this->datang_catatan->addErrorMessage(str_replace("%s", $this->datang_catatan->caption(), $this->datang_catatan->RequiredErrorMessage));
            }
        }

        // Return validate result
        $validateForm = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Delete records based on current filter
    protected function deleteRows()
    {
        global $Language, $Security;
        if (!$Security->canDelete()) {
            $this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
            return false;
        }
        $deleteRows = true;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $rows = $conn->fetchAll($sql);
        if (count($rows) == 0) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
            return false;
        }

        // Clone old rows
        $rsold = $rows;

        // Call row deleting event
        if ($deleteRows) {
            foreach ($rsold as $row) {
                $deleteRows = $this->rowDeleting($row);
                if (!$deleteRows) {
                    break;
                }
            }
        }
        if ($deleteRows) {
            $key = "";
            foreach ($rsold as $row) {
                $thisKey = "";
                if ($thisKey != "") {
                    $thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
                }
                $thisKey .= $row['datang_id'];
                if (Config("DELETE_UPLOADED_FILES")) { // Delete old files
                    $this->deleteUploadedFiles($row);
                }
                $deleteRows = $this->delete($row); // Delete
                if ($deleteRows === false) {
                    break;
                }
                if ($key != "") {
                    $key .= ", ";
                }
                $key .= $thisKey;
            }
        }
        if (!$deleteRows) {
            // Set up error message
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("DeleteCancelled"));
            }
        }

        // Call Row Deleted event
        if ($deleteRows) {
            foreach ($rsold as $row) {
                $this->rowDeleted($row);
            }
        }

        // Write JSON for API request (Support single row only)
        if (IsApi() && $deleteRows) {
            $row = $this->getRecordsFromRecordset($rsold, true);
            WriteJson(["success" => true, $this->TableVar => $row]);
        }
        return $deleteRows;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;
        $conn = $this->getConnection();

        // Load db values from rsold
        $this->loadDbValues($rsold);
        if ($rsold) {
        }
        $rsnew = [];

        // datang_petugas
        $this->datang_petugas->CurrentValue = CurrentUserName();
        $this->datang_petugas->setDbValueDef($rsnew, $this->datang_petugas->CurrentValue, "");

        // datang_tanggal
        $this->datang_tanggal->setDbValueDef($rsnew, UnFormatDateTime($this->datang_tanggal->CurrentValue, 0), CurrentDate(), false);

        // datang_varietas
        $this->datang_varietas->setDbValueDef($rsnew, $this->datang_varietas->CurrentValue, 0, false);

        // datang_sup
        $this->datang_sup->setDbValueDef($rsnew, $this->datang_sup->CurrentValue, 0, false);

        // datang_timbang1
        $this->datang_timbang1->setDbValueDef($rsnew, $this->datang_timbang1->CurrentValue, 0, false);

        // datang_timbang2
        $this->datang_timbang2->setDbValueDef($rsnew, $this->datang_timbang2->CurrentValue, 0, false);

        // datang_timbang3
        $this->datang_timbang3->setDbValueDef($rsnew, $this->datang_timbang3->CurrentValue, 0, false);

        // datang_timbang4
        $this->datang_timbang4->setDbValueDef($rsnew, $this->datang_timbang4->CurrentValue, 0, false);

        // datang_timbang5
        $this->datang_timbang5->setDbValueDef($rsnew, $this->datang_timbang5->CurrentValue, 0, false);

        // datang_timbang6
        $this->datang_timbang6->setDbValueDef($rsnew, $this->datang_timbang6->CurrentValue, 0, false);

        // datang_timbang7
        $this->datang_timbang7->setDbValueDef($rsnew, $this->datang_timbang7->CurrentValue, 0, false);

        // datang_timbang8
        $this->datang_timbang8->setDbValueDef($rsnew, $this->datang_timbang8->CurrentValue, 0, false);

        // datang_timbang9
        $this->datang_timbang9->setDbValueDef($rsnew, $this->datang_timbang9->CurrentValue, 0, false);

        // datang_timbang10
        $this->datang_timbang10->setDbValueDef($rsnew, $this->datang_timbang10->CurrentValue, 0, false);

        // datang_timbang11
        $this->datang_timbang11->setDbValueDef($rsnew, $this->datang_timbang11->CurrentValue, 0, false);

        // datang_timbang12
        $this->datang_timbang12->setDbValueDef($rsnew, $this->datang_timbang12->CurrentValue, 0, false);

        // datang_timbang13
        $this->datang_timbang13->setDbValueDef($rsnew, $this->datang_timbang13->CurrentValue, 0, false);

        // datang_timbang14
        $this->datang_timbang14->setDbValueDef($rsnew, $this->datang_timbang14->CurrentValue, 0, false);

        // datang_timbang15
        $this->datang_timbang15->setDbValueDef($rsnew, $this->datang_timbang15->CurrentValue, 0, false);

        // datang_timbang16
        $this->datang_timbang16->setDbValueDef($rsnew, $this->datang_timbang16->CurrentValue, 0, false);

        // datang_timbang17
        $this->datang_timbang17->setDbValueDef($rsnew, $this->datang_timbang17->CurrentValue, 0, false);

        // datang_timbang18
        $this->datang_timbang18->setDbValueDef($rsnew, $this->datang_timbang18->CurrentValue, 0, false);

        // datang_timbang19
        $this->datang_timbang19->setDbValueDef($rsnew, $this->datang_timbang19->CurrentValue, 0, false);

        // datang_timbang20
        $this->datang_timbang20->setDbValueDef($rsnew, $this->datang_timbang20->CurrentValue, 0, false);

        // datang_timbang21
        $this->datang_timbang21->setDbValueDef($rsnew, $this->datang_timbang21->CurrentValue, 0, false);

        // datang_timbang22
        $this->datang_timbang22->setDbValueDef($rsnew, $this->datang_timbang22->CurrentValue, 0, false);

        // datang_timbang23
        $this->datang_timbang23->setDbValueDef($rsnew, $this->datang_timbang23->CurrentValue, 0, false);

        // datang_timbang24
        $this->datang_timbang24->setDbValueDef($rsnew, $this->datang_timbang24->CurrentValue, 0, false);

        // datang_timbang25
        $this->datang_timbang25->setDbValueDef($rsnew, $this->datang_timbang25->CurrentValue, 0, false);

        // datang_jumlah
        $this->datang_jumlah->setDbValueDef($rsnew, $this->datang_jumlah->CurrentValue, 0, false);

        // datang_jumlah_karung
        $this->datang_jumlah_karung->setDbValueDef($rsnew, $this->datang_jumlah_karung->CurrentValue, 0, false);

        // datang_berat_bersih
        $this->datang_berat_bersih->setDbValueDef($rsnew, $this->datang_berat_bersih->CurrentValue, 0, false);

        // datang_catatan
        $this->datang_catatan->setDbValueDef($rsnew, $this->datang_catatan->CurrentValue, "", false);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Clean upload path if any
        if ($addRow) {
        }

        // Write JSON for API request
        if (IsApi() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            WriteJson(["success" => true, $this->TableVar => $row]);
        }
        return $addRow;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->datang_id->AdvancedSearch->load();
        $this->datang_petugas->AdvancedSearch->load();
        $this->datang_tanggal->AdvancedSearch->load();
        $this->datang_varietas->AdvancedSearch->load();
        $this->datang_sup->AdvancedSearch->load();
        $this->datang_timbang1->AdvancedSearch->load();
        $this->datang_timbang2->AdvancedSearch->load();
        $this->datang_timbang3->AdvancedSearch->load();
        $this->datang_timbang4->AdvancedSearch->load();
        $this->datang_timbang5->AdvancedSearch->load();
        $this->datang_timbang6->AdvancedSearch->load();
        $this->datang_timbang7->AdvancedSearch->load();
        $this->datang_timbang8->AdvancedSearch->load();
        $this->datang_timbang9->AdvancedSearch->load();
        $this->datang_timbang10->AdvancedSearch->load();
        $this->datang_timbang11->AdvancedSearch->load();
        $this->datang_timbang12->AdvancedSearch->load();
        $this->datang_timbang13->AdvancedSearch->load();
        $this->datang_timbang14->AdvancedSearch->load();
        $this->datang_timbang15->AdvancedSearch->load();
        $this->datang_timbang16->AdvancedSearch->load();
        $this->datang_timbang17->AdvancedSearch->load();
        $this->datang_timbang18->AdvancedSearch->load();
        $this->datang_timbang19->AdvancedSearch->load();
        $this->datang_timbang20->AdvancedSearch->load();
        $this->datang_timbang21->AdvancedSearch->load();
        $this->datang_timbang22->AdvancedSearch->load();
        $this->datang_timbang23->AdvancedSearch->load();
        $this->datang_timbang24->AdvancedSearch->load();
        $this->datang_timbang25->AdvancedSearch->load();
        $this->datang_jumlah->AdvancedSearch->load();
        $this->datang_jumlah_karung->AdvancedSearch->load();
        $this->datang_berat_bersih->AdvancedSearch->load();
        $this->datang_catatan->AdvancedSearch->load();
    }

    // Set up search/sort options
    protected function setupSearchSortOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl();
        $this->SearchOptions = new ListOptions("div");
        $this->SearchOptions->TagClassName = "ew-search-option";

        // Search button
        $item = &$this->SearchOptions->add("searchtoggle");
        $searchToggleClass = ($this->SearchWhere != "") ? " active" : " active";
        $item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" href=\"#\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fkedatanganlistsrch\" aria-pressed=\"" . ($searchToggleClass == " active" ? "true" : "false") . "\">" . $Language->phrase("SearchLink") . "</a>";
        $item->Visible = true;

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        $item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction) {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("KedatanganList");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
        $Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_datang_varietas":
                    break;
                case "x_datang_sup":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll(\PDO::FETCH_BOTH);
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row);
                    $ar[strval($row[0])] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        if ($this->isPageRequest()) { // Validate request
            $startRec = Get(Config("TABLE_START_REC"));
            $pageNo = Get(Config("TABLE_PAGE_NO"));
            if ($pageNo !== null) { // Check for "pageno" parameter first
                if (is_numeric($pageNo)) {
                    $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                    if ($this->StartRecord <= 0) {
                        $this->StartRecord = 1;
                    } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                        $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                    }
                    $this->setStartRecordNumber($this->StartRecord);
                }
            } elseif ($startRec !== null) { // Check for "start" parameter
                $this->StartRecord = $startRec;
                $this->setStartRecordNumber($this->StartRecord);
            }
        }
        $this->StartRecord = $this->getStartRecordNumber();

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
            $this->setStartRecordNumber($this->StartRecord);
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in CustomError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->Add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->MoveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered()
    {
        // Example:
        //$this->ListOptions["new"]->Body = "xxx";
    }

    // Row Custom Action event
    public function rowCustomAction($action, $row)
    {
        // Return false to abort
        return true;
    }

    // Page Exporting event
    // $this->ExportDoc = export document object
    public function pageExporting()
    {
        //$this->ExportDoc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $this->ExportDoc = export document object
    public function rowExport($rs)
    {
        //$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $this->ExportDoc = export document object
    public function pageExported()
    {
        //$this->ExportDoc->Text .= "my footer"; // Export footer
        //Log($this->ExportDoc->Text);
    }

    // Page Importing event
    public function pageImporting($reader, &$options)
    {
        //var_dump($reader); // Import data reader
        //var_dump($options); // Show all options for importing
        //return false; // Return false to skip import
        return true;
    }

    // Row Import event
    public function rowImport(&$row, $cnt)
    {
        //Log($cnt); // Import record count
        //var_dump($row); // Import row
        //return false; // Return false to skip import
        return true;
    }

    // Page Imported event
    public function pageImported($reader, $results)
    {
        //var_dump($reader); // Import data reader
        //var_dump($results); // Import results
    }
}
